package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteClusterTemplate invokes the emr.DeleteClusterTemplate API synchronously
// api document: https://help.aliyun.com/api/emr/deleteclustertemplate.html
func (client *Client) DeleteClusterTemplate(request *DeleteClusterTemplateRequest) (response *DeleteClusterTemplateResponse, err error) {
	response = CreateDeleteClusterTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteClusterTemplateWithChan invokes the emr.DeleteClusterTemplate API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteclustertemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteClusterTemplateWithChan(request *DeleteClusterTemplateRequest) (<-chan *DeleteClusterTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteClusterTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteClusterTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteClusterTemplateWithCallback invokes the emr.DeleteClusterTemplate API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteclustertemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteClusterTemplateWithCallback(request *DeleteClusterTemplateRequest, callback func(response *DeleteClusterTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteClusterTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteClusterTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteClusterTemplateRequest is the request struct for api DeleteClusterTemplate
type DeleteClusterTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BizId           string           `position:"Query" name:"BizId"`
}

// DeleteClusterTemplateResponse is the response struct for api DeleteClusterTemplate
type DeleteClusterTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteClusterTemplateRequest creates a request to invoke DeleteClusterTemplate API
func CreateDeleteClusterTemplateRequest() (request *DeleteClusterTemplateRequest) {
	request = &DeleteClusterTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteClusterTemplate", "emr", "openAPI")
	return
}

// CreateDeleteClusterTemplateResponse creates a response to parse from DeleteClusterTemplate response
func CreateDeleteClusterTemplateResponse() (response *DeleteClusterTemplateResponse) {
	response = &DeleteClusterTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
