package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterService invokes the emr.DescribeClusterService API synchronously
// api document: https://help.aliyun.com/api/emr/describeclusterservice.html
func (client *Client) DescribeClusterService(request *DescribeClusterServiceRequest) (response *DescribeClusterServiceResponse, err error) {
	response = CreateDescribeClusterServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterServiceWithChan invokes the emr.DescribeClusterService API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceWithChan(request *DescribeClusterServiceRequest) (<-chan *DescribeClusterServiceResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterServiceWithCallback invokes the emr.DescribeClusterService API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceWithCallback(request *DescribeClusterServiceRequest, callback func(response *DescribeClusterServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterServiceResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterServiceRequest is the request struct for api DescribeClusterService
type DescribeClusterServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DescribeClusterServiceResponse is the response struct for api DescribeClusterService
type DescribeClusterServiceResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	ServiceInfo ServiceInfo `json:"ServiceInfo" xml:"ServiceInfo"`
}

// CreateDescribeClusterServiceRequest creates a request to invoke DescribeClusterService API
func CreateDescribeClusterServiceRequest() (request *DescribeClusterServiceRequest) {
	request = &DescribeClusterServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterService", "emr", "openAPI")
	return
}

// CreateDescribeClusterServiceResponse creates a response to parse from DescribeClusterService response
func CreateDescribeClusterServiceResponse() (response *DescribeClusterServiceResponse) {
	response = &DescribeClusterServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
