package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreListTables invokes the emr.MetastoreListTables API synchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttables.html
func (client *Client) MetastoreListTables(request *MetastoreListTablesRequest) (response *MetastoreListTablesResponse, err error) {
	response = CreateMetastoreListTablesResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreListTablesWithChan invokes the emr.MetastoreListTables API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttables.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListTablesWithChan(request *MetastoreListTablesRequest) (<-chan *MetastoreListTablesResponse, <-chan error) {
	responseChan := make(chan *MetastoreListTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreListTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreListTablesWithCallback invokes the emr.MetastoreListTables API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttables.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListTablesWithCallback(request *MetastoreListTablesRequest, callback func(response *MetastoreListTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreListTablesResponse
		var err error
		defer close(result)
		response, err = client.MetastoreListTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreListTablesRequest is the request struct for api MetastoreListTables
type MetastoreListTablesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	TableId         string           `position:"Query" name:"TableId"`
	DatabaseId      string           `position:"Query" name:"DatabaseId"`
	TableName       string           `position:"Query" name:"TableName"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	FuzzyTableName  string           `position:"Query" name:"FuzzyTableName"`
}

// MetastoreListTablesResponse is the response struct for api MetastoreListTables
type MetastoreListTablesResponse struct {
	*responses.BaseResponse
	RequestId  string                          `json:"RequestId" xml:"RequestId"`
	TotalCount int                             `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                             `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                             `json:"PageSize" xml:"PageSize"`
	TableNames TableNamesInMetastoreListTables `json:"TableNames" xml:"TableNames"`
	TableList  TableList                       `json:"TableList" xml:"TableList"`
}

// CreateMetastoreListTablesRequest creates a request to invoke MetastoreListTables API
func CreateMetastoreListTablesRequest() (request *MetastoreListTablesRequest) {
	request = &MetastoreListTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreListTables", "emr", "openAPI")
	return
}

// CreateMetastoreListTablesResponse creates a response to parse from MetastoreListTables response
func CreateMetastoreListTablesResponse() (response *MetastoreListTablesResponse) {
	response = &MetastoreListTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
