package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishPredictiveJobGroup invokes the ccc.PublishPredictiveJobGroup API synchronously
// api document: https://help.aliyun.com/api/ccc/publishpredictivejobgroup.html
func (client *Client) PublishPredictiveJobGroup(request *PublishPredictiveJobGroupRequest) (response *PublishPredictiveJobGroupResponse, err error) {
	response = CreatePublishPredictiveJobGroupResponse()
	err = client.DoAction(request, response)
	return
}

// PublishPredictiveJobGroupWithChan invokes the ccc.PublishPredictiveJobGroup API asynchronously
// api document: https://help.aliyun.com/api/ccc/publishpredictivejobgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishPredictiveJobGroupWithChan(request *PublishPredictiveJobGroupRequest) (<-chan *PublishPredictiveJobGroupResponse, <-chan error) {
	responseChan := make(chan *PublishPredictiveJobGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishPredictiveJobGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishPredictiveJobGroupWithCallback invokes the ccc.PublishPredictiveJobGroup API asynchronously
// api document: https://help.aliyun.com/api/ccc/publishpredictivejobgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishPredictiveJobGroupWithCallback(request *PublishPredictiveJobGroupRequest, callback func(response *PublishPredictiveJobGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishPredictiveJobGroupResponse
		var err error
		defer close(result)
		response, err = client.PublishPredictiveJobGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishPredictiveJobGroupRequest is the request struct for api PublishPredictiveJobGroup
type PublishPredictiveJobGroupRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
	JobGroupId   string `position:"Query" name:"JobGroupId"`
}

// PublishPredictiveJobGroupResponse is the response struct for api PublishPredictiveJobGroup
type PublishPredictiveJobGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePublishPredictiveJobGroupRequest creates a request to invoke PublishPredictiveJobGroup API
func CreatePublishPredictiveJobGroupRequest() (request *PublishPredictiveJobGroupRequest) {
	request = &PublishPredictiveJobGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "PublishPredictiveJobGroup", "", "")
	return
}

// CreatePublishPredictiveJobGroupResponse creates a response to parse from PublishPredictiveJobGroup response
func CreatePublishPredictiveJobGroupResponse() (response *PublishPredictiveJobGroupResponse) {
	response = &PublishPredictiveJobGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
