package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEcosphereSpecs invokes the baas.DescribeEcosphereSpecs API synchronously
// api document: https://help.aliyun.com/api/baas/describeecospherespecs.html
func (client *Client) DescribeEcosphereSpecs(request *DescribeEcosphereSpecsRequest) (response *DescribeEcosphereSpecsResponse, err error) {
	response = CreateDescribeEcosphereSpecsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEcosphereSpecsWithChan invokes the baas.DescribeEcosphereSpecs API asynchronously
// api document: https://help.aliyun.com/api/baas/describeecospherespecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEcosphereSpecsWithChan(request *DescribeEcosphereSpecsRequest) (<-chan *DescribeEcosphereSpecsResponse, <-chan error) {
	responseChan := make(chan *DescribeEcosphereSpecsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEcosphereSpecs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEcosphereSpecsWithCallback invokes the baas.DescribeEcosphereSpecs API asynchronously
// api document: https://help.aliyun.com/api/baas/describeecospherespecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEcosphereSpecsWithCallback(request *DescribeEcosphereSpecsRequest, callback func(response *DescribeEcosphereSpecsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEcosphereSpecsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEcosphereSpecs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEcosphereSpecsRequest is the request struct for api DescribeEcosphereSpecs
type DescribeEcosphereSpecsRequest struct {
	*requests.RpcRequest
}

// DescribeEcosphereSpecsResponse is the response struct for api DescribeEcosphereSpecs
type DescribeEcosphereSpecsResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Success   bool          `json:"Success" xml:"Success"`
	ErrorCode int           `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ClusterSpec `json:"Result" xml:"Result"`
}

// CreateDescribeEcosphereSpecsRequest creates a request to invoke DescribeEcosphereSpecs API
func CreateDescribeEcosphereSpecsRequest() (request *DescribeEcosphereSpecsRequest) {
	request = &DescribeEcosphereSpecsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeEcosphereSpecs", "", "")
	return
}

// CreateDescribeEcosphereSpecsResponse creates a response to parse from DescribeEcosphereSpecs response
func CreateDescribeEcosphereSpecsResponse() (response *DescribeEcosphereSpecsResponse) {
	response = &DescribeEcosphereSpecsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
