package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNavNode invokes the emr.UpdateNavNode API synchronously
// api document: https://help.aliyun.com/api/emr/updatenavnode.html
func (client *Client) UpdateNavNode(request *UpdateNavNodeRequest) (response *UpdateNavNodeResponse, err error) {
	response = CreateUpdateNavNodeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNavNodeWithChan invokes the emr.UpdateNavNode API asynchronously
// api document: https://help.aliyun.com/api/emr/updatenavnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateNavNodeWithChan(request *UpdateNavNodeRequest) (<-chan *UpdateNavNodeResponse, <-chan error) {
	responseChan := make(chan *UpdateNavNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNavNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNavNodeWithCallback invokes the emr.UpdateNavNode API asynchronously
// api document: https://help.aliyun.com/api/emr/updatenavnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateNavNodeWithCallback(request *UpdateNavNodeRequest, callback func(response *UpdateNavNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNavNodeResponse
		var err error
		defer close(result)
		response, err = client.UpdateNavNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNavNodeRequest is the request struct for api UpdateNavNode
type UpdateNavNodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Id              string           `position:"Query" name:"Id"`
	ProjectId       string           `position:"Query" name:"ProjectId"`
	ParentId        string           `position:"Query" name:"ParentId"`
}

// UpdateNavNodeResponse is the response struct for api UpdateNavNode
type UpdateNavNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateNavNodeRequest creates a request to invoke UpdateNavNode API
func CreateUpdateNavNodeRequest() (request *UpdateNavNodeRequest) {
	request = &UpdateNavNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateNavNode", "emr", "openAPI")
	return
}

// CreateUpdateNavNodeResponse creates a response to parse from UpdateNavNode response
func CreateUpdateNavNodeResponse() (response *UpdateNavNodeResponse) {
	response = &UpdateNavNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
