package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDashboardUid invokes the airec.ListDashboardUid API synchronously
// api document: https://help.aliyun.com/api/airec/listdashboarduid.html
func (client *Client) ListDashboardUid(request *ListDashboardUidRequest) (response *ListDashboardUidResponse, err error) {
	response = CreateListDashboardUidResponse()
	err = client.DoAction(request, response)
	return
}

// ListDashboardUidWithChan invokes the airec.ListDashboardUid API asynchronously
// api document: https://help.aliyun.com/api/airec/listdashboarduid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDashboardUidWithChan(request *ListDashboardUidRequest) (<-chan *ListDashboardUidResponse, <-chan error) {
	responseChan := make(chan *ListDashboardUidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDashboardUid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDashboardUidWithCallback invokes the airec.ListDashboardUid API asynchronously
// api document: https://help.aliyun.com/api/airec/listdashboarduid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDashboardUidWithCallback(request *ListDashboardUidRequest, callback func(response *ListDashboardUidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDashboardUidResponse
		var err error
		defer close(result)
		response, err = client.ListDashboardUid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDashboardUidRequest is the request struct for api ListDashboardUid
type ListDashboardUidRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListDashboardUidResponse is the response struct for api ListDashboardUid
type ListDashboardUidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListDashboardUidRequest creates a request to invoke ListDashboardUid API
func CreateListDashboardUidRequest() (request *ListDashboardUidRequest) {
	request = &ListDashboardUidRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "ListDashboardUid", "/openapi/instances/[InstanceId]/dashboard/uid", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDashboardUidResponse creates a response to parse from ListDashboardUid response
func CreateListDashboardUidResponse() (response *ListDashboardUidResponse) {
	response = &ListDashboardUidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
