package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTranscodeTemplateGroup invokes the vod.ListTranscodeTemplateGroup API synchronously
// api document: https://help.aliyun.com/api/vod/listtranscodetemplategroup.html
func (client *Client) ListTranscodeTemplateGroup(request *ListTranscodeTemplateGroupRequest) (response *ListTranscodeTemplateGroupResponse, err error) {
	response = CreateListTranscodeTemplateGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListTranscodeTemplateGroupWithChan invokes the vod.ListTranscodeTemplateGroup API asynchronously
// api document: https://help.aliyun.com/api/vod/listtranscodetemplategroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTranscodeTemplateGroupWithChan(request *ListTranscodeTemplateGroupRequest) (<-chan *ListTranscodeTemplateGroupResponse, <-chan error) {
	responseChan := make(chan *ListTranscodeTemplateGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTranscodeTemplateGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTranscodeTemplateGroupWithCallback invokes the vod.ListTranscodeTemplateGroup API asynchronously
// api document: https://help.aliyun.com/api/vod/listtranscodetemplategroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTranscodeTemplateGroupWithCallback(request *ListTranscodeTemplateGroupRequest, callback func(response *ListTranscodeTemplateGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTranscodeTemplateGroupResponse
		var err error
		defer close(result)
		response, err = client.ListTranscodeTemplateGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTranscodeTemplateGroupRequest is the request struct for api ListTranscodeTemplateGroup
type ListTranscodeTemplateGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	AppId                string           `position:"Query" name:"AppId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListTranscodeTemplateGroupResponse is the response struct for api ListTranscodeTemplateGroup
type ListTranscodeTemplateGroupResponse struct {
	*responses.BaseResponse
	RequestId                  string                   `json:"RequestId" xml:"RequestId"`
	TranscodeTemplateGroupList []TranscodeTemplateGroup `json:"TranscodeTemplateGroupList" xml:"TranscodeTemplateGroupList"`
}

// CreateListTranscodeTemplateGroupRequest creates a request to invoke ListTranscodeTemplateGroup API
func CreateListTranscodeTemplateGroupRequest() (request *ListTranscodeTemplateGroupRequest) {
	request = &ListTranscodeTemplateGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListTranscodeTemplateGroup", "vod", "openAPI")
	return
}

// CreateListTranscodeTemplateGroupResponse creates a response to parse from ListTranscodeTemplateGroup response
func CreateListTranscodeTemplateGroupResponse() (response *ListTranscodeTemplateGroupResponse) {
	response = &ListTranscodeTemplateGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
