package api

/************************************************
  generated by IDE. for [ServerAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *ServerAPI) Reset() *ServerAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *ServerAPI) Offset(offset int) *ServerAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *ServerAPI) Limit(limit int) *ServerAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *ServerAPI) Include(key string) *ServerAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *ServerAPI) Exclude(key string) *ServerAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *ServerAPI) FilterBy(key string, value interface{}) *ServerAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ServerAPI) FilterMultiBy(key string, value interface{}) *ServerAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *ServerAPI) WithNameLike(name string) *ServerAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *ServerAPI) WithTag(tag string) *ServerAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *ServerAPI) WithTags(tags []string) *ServerAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ServerAPI) WithSizeGib(size int) *ServerAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *ServerAPI) WithSharedScope() *ServerAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *ServerAPI) WithUserScope() *ServerAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *ServerAPI) SortBy(key string, reverse bool) *ServerAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *ServerAPI) SortByName(reverse bool) *ServerAPI {
	api.sortByName(reverse)
	return api
}

// func (api *ServerAPI) SortBySize(reverse bool) *ServerAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *ServerAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *ServerAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *ServerAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *ServerAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *ServerAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *ServerAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ServerAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *ServerAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *ServerAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *ServerAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ServerAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *ServerAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *ServerAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *ServerAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *ServerAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *ServerAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *ServerAPI) New() *sacloud.Server {
	return &sacloud.Server{}
}

// Create 新規作成
func (api *ServerAPI) Create(value *sacloud.Server) (*sacloud.Server, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *ServerAPI) Read(id int64) (*sacloud.Server, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *ServerAPI) Update(id int64, value *sacloud.Server) (*sacloud.Server, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *ServerAPI) Delete(id int64) (*sacloud.Server, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *ServerAPI) setStateValue(setFunc func(*sacloud.Request)) *ServerAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *ServerAPI) request(f func(*sacloud.Response) error) (*sacloud.Server, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Server, nil
}

func (api *ServerAPI) createRequest(value *sacloud.Server) *sacloud.Request {
	req := &sacloud.Request{}
	req.Server = value
	return req
}
