// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListInputSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputSecurityGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInputSecurityGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInputSecurityGroupsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListInputSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	InputSecurityGroups []InputSecurityGroup `locationName:"inputSecurityGroups" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInputSecurityGroupsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputSecurityGroups != nil {
		v := s.InputSecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputSecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListInputSecurityGroups = "ListInputSecurityGroups"

// ListInputSecurityGroupsRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Produces a list of Input Security Groups for an account
//
//    // Example sending a request using ListInputSecurityGroupsRequest.
//    req := client.ListInputSecurityGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *Client) ListInputSecurityGroupsRequest(input *ListInputSecurityGroupsInput) ListInputSecurityGroupsRequest {
	op := &aws.Operation{
		Name:       opListInputSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputSecurityGroupsInput{}
	}

	req := c.newRequest(op, input, &ListInputSecurityGroupsOutput{})
	return ListInputSecurityGroupsRequest{Request: req, Input: input, Copy: c.ListInputSecurityGroupsRequest}
}

// ListInputSecurityGroupsRequest is the request type for the
// ListInputSecurityGroups API operation.
type ListInputSecurityGroupsRequest struct {
	*aws.Request
	Input *ListInputSecurityGroupsInput
	Copy  func(*ListInputSecurityGroupsInput) ListInputSecurityGroupsRequest
}

// Send marshals and sends the ListInputSecurityGroups API request.
func (r ListInputSecurityGroupsRequest) Send(ctx context.Context) (*ListInputSecurityGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInputSecurityGroupsResponse{
		ListInputSecurityGroupsOutput: r.Request.Data.(*ListInputSecurityGroupsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInputSecurityGroupsRequestPaginator returns a paginator for ListInputSecurityGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInputSecurityGroupsRequest(input)
//   p := medialive.NewListInputSecurityGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInputSecurityGroupsPaginator(req ListInputSecurityGroupsRequest) ListInputSecurityGroupsPaginator {
	return ListInputSecurityGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInputSecurityGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInputSecurityGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInputSecurityGroupsPaginator struct {
	aws.Pager
}

func (p *ListInputSecurityGroupsPaginator) CurrentPage() *ListInputSecurityGroupsOutput {
	return p.Pager.CurrentPage().(*ListInputSecurityGroupsOutput)
}

// ListInputSecurityGroupsResponse is the response type for the
// ListInputSecurityGroups API operation.
type ListInputSecurityGroupsResponse struct {
	*ListInputSecurityGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInputSecurityGroups request.
func (r *ListInputSecurityGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
