package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelPredictiveJobs invokes the ccc.CancelPredictiveJobs API synchronously
// api document: https://help.aliyun.com/api/ccc/cancelpredictivejobs.html
func (client *Client) CancelPredictiveJobs(request *CancelPredictiveJobsRequest) (response *CancelPredictiveJobsResponse, err error) {
	response = CreateCancelPredictiveJobsResponse()
	err = client.DoAction(request, response)
	return
}

// CancelPredictiveJobsWithChan invokes the ccc.CancelPredictiveJobs API asynchronously
// api document: https://help.aliyun.com/api/ccc/cancelpredictivejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelPredictiveJobsWithChan(request *CancelPredictiveJobsRequest) (<-chan *CancelPredictiveJobsResponse, <-chan error) {
	responseChan := make(chan *CancelPredictiveJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelPredictiveJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelPredictiveJobsWithCallback invokes the ccc.CancelPredictiveJobs API asynchronously
// api document: https://help.aliyun.com/api/ccc/cancelpredictivejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelPredictiveJobsWithCallback(request *CancelPredictiveJobsRequest, callback func(response *CancelPredictiveJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelPredictiveJobsResponse
		var err error
		defer close(result)
		response, err = client.CancelPredictiveJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelPredictiveJobsRequest is the request struct for api CancelPredictiveJobs
type CancelPredictiveJobsRequest struct {
	*requests.RpcRequest
	All        requests.Boolean `position:"Query" name:"All"`
	JobId      *[]string        `position:"Query" name:"JobId"  type:"Repeated"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	JobGroupId string           `position:"Query" name:"JobGroupId"`
}

// CancelPredictiveJobsResponse is the response struct for api CancelPredictiveJobs
type CancelPredictiveJobsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCancelPredictiveJobsRequest creates a request to invoke CancelPredictiveJobs API
func CreateCancelPredictiveJobsRequest() (request *CancelPredictiveJobsRequest) {
	request = &CancelPredictiveJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "CancelPredictiveJobs", "", "")
	return
}

// CreateCancelPredictiveJobsResponse creates a response to parse from CancelPredictiveJobs response
func CreateCancelPredictiveJobsResponse() (response *CancelPredictiveJobsResponse) {
	response = &CancelPredictiveJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
