package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CommonApiWhiteList invokes the emr.CommonApiWhiteList API synchronously
// api document: https://help.aliyun.com/api/emr/commonapiwhitelist.html
func (client *Client) CommonApiWhiteList(request *CommonApiWhiteListRequest) (response *CommonApiWhiteListResponse, err error) {
	response = CreateCommonApiWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// CommonApiWhiteListWithChan invokes the emr.CommonApiWhiteList API asynchronously
// api document: https://help.aliyun.com/api/emr/commonapiwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CommonApiWhiteListWithChan(request *CommonApiWhiteListRequest) (<-chan *CommonApiWhiteListResponse, <-chan error) {
	responseChan := make(chan *CommonApiWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CommonApiWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CommonApiWhiteListWithCallback invokes the emr.CommonApiWhiteList API asynchronously
// api document: https://help.aliyun.com/api/emr/commonapiwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CommonApiWhiteListWithCallback(request *CommonApiWhiteListRequest, callback func(response *CommonApiWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CommonApiWhiteListResponse
		var err error
		defer close(result)
		response, err = client.CommonApiWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CommonApiWhiteListRequest is the request struct for api CommonApiWhiteList
type CommonApiWhiteListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// CommonApiWhiteListResponse is the response struct for api CommonApiWhiteList
type CommonApiWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	WhiteList string `json:"WhiteList" xml:"WhiteList"`
}

// CreateCommonApiWhiteListRequest creates a request to invoke CommonApiWhiteList API
func CreateCommonApiWhiteListRequest() (request *CommonApiWhiteListRequest) {
	request = &CommonApiWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CommonApiWhiteList", "emr", "openAPI")
	return
}

// CreateCommonApiWhiteListResponse creates a response to parse from CommonApiWhiteList response
func CreateCommonApiWhiteListResponse() (response *CommonApiWhiteListResponse) {
	response = &CommonApiWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
