package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitFpCompareJob invokes the mts.SubmitFpCompareJob API synchronously
// api document: https://help.aliyun.com/api/mts/submitfpcomparejob.html
func (client *Client) SubmitFpCompareJob(request *SubmitFpCompareJobRequest) (response *SubmitFpCompareJobResponse, err error) {
	response = CreateSubmitFpCompareJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitFpCompareJobWithChan invokes the mts.SubmitFpCompareJob API asynchronously
// api document: https://help.aliyun.com/api/mts/submitfpcomparejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitFpCompareJobWithChan(request *SubmitFpCompareJobRequest) (<-chan *SubmitFpCompareJobResponse, <-chan error) {
	responseChan := make(chan *SubmitFpCompareJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitFpCompareJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitFpCompareJobWithCallback invokes the mts.SubmitFpCompareJob API asynchronously
// api document: https://help.aliyun.com/api/mts/submitfpcomparejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitFpCompareJobWithCallback(request *SubmitFpCompareJobRequest, callback func(response *SubmitFpCompareJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitFpCompareJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitFpCompareJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitFpCompareJobRequest is the request struct for api SubmitFpCompareJob
type SubmitFpCompareJobRequest struct {
	*requests.RpcRequest
	MatchedFrameStorage  string           `position:"Query" name:"MatchedFrameStorage"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	QueryMedia           string           `position:"Query" name:"QueryMedia"`
	FpDBId               string           `position:"Query" name:"FpDBId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	MasterMedia          string           `position:"Query" name:"MasterMedia"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
}

// SubmitFpCompareJobResponse is the response struct for api SubmitFpCompareJob
type SubmitFpCompareJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitFpCompareJobRequest creates a request to invoke SubmitFpCompareJob API
func CreateSubmitFpCompareJobRequest() (request *SubmitFpCompareJobRequest) {
	request = &SubmitFpCompareJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitFpCompareJob", "mts", "openAPI")
	return
}

// CreateSubmitFpCompareJobResponse creates a response to parse from SubmitFpCompareJob response
func CreateSubmitFpCompareJobResponse() (response *SubmitFpCompareJobResponse) {
	response = &SubmitFpCompareJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
