package hdinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/hdinsight/mgmt/2018-06-01/hdinsight"

// Application the HDInsight cluster application
type Application struct {
	autorest.Response `json:"-"`
	// Etag - The ETag for the application
	Etag *string `json:"etag,omitempty"`
	// Tags - The tags for the application.
	Tags map[string]*string `json:"tags"`
	// Properties - The properties of the application.
	Properties *ApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	return json.Marshal(objectMap)
}

// ApplicationGetEndpoint gets the application SSH endpoint
type ApplicationGetEndpoint struct {
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// DestinationPort - The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// PublicPort - The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// PrivateIPAddress - The private ip address of the endpoint.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
}

// ApplicationGetHTTPSEndpoint gets the application HTTP endpoints.
type ApplicationGetHTTPSEndpoint struct {
	// AccessModes - The list of access modes for the application.
	AccessModes *[]string `json:"accessModes,omitempty"`
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// DestinationPort - The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// PublicPort - The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// SubDomainSuffix - The subdomain suffix of the application.
	SubDomainSuffix *string `json:"subDomainSuffix,omitempty"`
	// DisableGatewayAuth - The value indicates whether to disable GatewayAuth.
	DisableGatewayAuth *bool `json:"disableGatewayAuth,omitempty"`
}

// ApplicationListResult result of the request to list cluster Applications. It contains a list of
// operations and a URL link to get the next set of results.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of HDInsight applications installed on HDInsight cluster.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationListResult.
func (alr ApplicationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alr.Value != nil {
		objectMap["value"] = alr.Value
	}
	return json.Marshal(objectMap)
}

// ApplicationListResultIterator provides access to a complete listing of Application values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListResultIterator type.
func NewApplicationListResultIterator(page ApplicationListResultPage) ApplicationListResultIterator {
	return ApplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ApplicationListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ApplicationListResultPage contains a page of Application values.
type ApplicationListResultPage struct {
	fn  func(context.Context, ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []Application {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplicationListResultPage type.
func NewApplicationListResultPage(cur ApplicationListResult, getNextPage func(context.Context, ApplicationListResult) (ApplicationListResult, error)) ApplicationListResultPage {
	return ApplicationListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// ApplicationProperties the HDInsight cluster application GET response.
type ApplicationProperties struct {
	// ComputeProfile - The list of roles in the cluster.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// InstallScriptActions - The list of install script actions.
	InstallScriptActions *[]RuntimeScriptAction `json:"installScriptActions,omitempty"`
	// UninstallScriptActions - The list of uninstall script actions.
	UninstallScriptActions *[]RuntimeScriptAction `json:"uninstallScriptActions,omitempty"`
	// HTTPSEndpoints - The list of application HTTPS endpoints.
	HTTPSEndpoints *[]ApplicationGetHTTPSEndpoint `json:"httpsEndpoints,omitempty"`
	// SSHEndpoints - The list of application SSH endpoints.
	SSHEndpoints *[]ApplicationGetEndpoint `json:"sshEndpoints,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ApplicationType - The application type.
	ApplicationType *string `json:"applicationType,omitempty"`
	// ApplicationState - READ-ONLY; The application state.
	ApplicationState *string `json:"applicationState,omitempty"`
	// Errors - The list of errors.
	Errors *[]Errors `json:"errors,omitempty"`
	// CreatedDate - READ-ONLY; The application create date time.
	CreatedDate *string `json:"createdDate,omitempty"`
	// MarketplaceIdentifier - READ-ONLY; The marketplace identifier.
	MarketplaceIdentifier *string `json:"marketplaceIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationProperties.
func (ap ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ComputeProfile != nil {
		objectMap["computeProfile"] = ap.ComputeProfile
	}
	if ap.InstallScriptActions != nil {
		objectMap["installScriptActions"] = ap.InstallScriptActions
	}
	if ap.UninstallScriptActions != nil {
		objectMap["uninstallScriptActions"] = ap.UninstallScriptActions
	}
	if ap.HTTPSEndpoints != nil {
		objectMap["httpsEndpoints"] = ap.HTTPSEndpoints
	}
	if ap.SSHEndpoints != nil {
		objectMap["sshEndpoints"] = ap.SSHEndpoints
	}
	if ap.ApplicationType != nil {
		objectMap["applicationType"] = ap.ApplicationType
	}
	if ap.Errors != nil {
		objectMap["errors"] = ap.Errors
	}
	return json.Marshal(objectMap)
}

// ApplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (Application, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsCreateFuture.Result.
func (future *ApplicationsCreateFuture) result(client ApplicationsClient) (a Application, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ApplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsCreateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsDeleteFuture.Result.
func (future *ApplicationsDeleteFuture) result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ApplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Autoscale the autoscale request parameters
type Autoscale struct {
	// Capacity - Parameters for load-based autoscale
	Capacity *AutoscaleCapacity `json:"capacity,omitempty"`
	// Recurrence - Parameters for schedule-based autoscale
	Recurrence *AutoscaleRecurrence `json:"recurrence,omitempty"`
}

// AutoscaleCapacity the load-based autoscale request parameters
type AutoscaleCapacity struct {
	// MinInstanceCount - The minimum instance count of the cluster
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`
	// MaxInstanceCount - The maximum instance count of the cluster
	MaxInstanceCount *int32 `json:"maxInstanceCount,omitempty"`
}

// AutoscaleConfigurationUpdateParameter the autoscale configuration update parameter.
type AutoscaleConfigurationUpdateParameter struct {
	// Autoscale - The autoscale configuration.
	Autoscale *Autoscale `json:"autoscale,omitempty"`
}

// AutoscaleRecurrence schedule-based autoscale request parameters
type AutoscaleRecurrence struct {
	// TimeZone - The time zone for the autoscale schedule times
	TimeZone *string `json:"timeZone,omitempty"`
	// Schedule - Array of schedule-based autoscale rules
	Schedule *[]AutoscaleSchedule `json:"schedule,omitempty"`
}

// AutoscaleSchedule parameters for a schedule-based autoscale rule, consisting of an array of days + a
// time and capacity
type AutoscaleSchedule struct {
	// Days - Days of the week for a schedule-based autoscale rule
	Days *[]DaysOfWeek `json:"days,omitempty"`
	// TimeAndCapacity - Time and capacity for a schedule-based autoscale rule
	TimeAndCapacity *AutoscaleTimeAndCapacity `json:"timeAndCapacity,omitempty"`
}

// AutoscaleTimeAndCapacity time and capacity request parameters
type AutoscaleTimeAndCapacity struct {
	// Time - 24-hour time in the form xx:xx
	Time *string `json:"time,omitempty"`
	// MinInstanceCount - The minimum instance count of the cluster
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`
	// MaxInstanceCount - The maximum instance count of the cluster
	MaxInstanceCount *int32 `json:"maxInstanceCount,omitempty"`
}

// BillingMeters the billing meters.
type BillingMeters struct {
	// MeterParameter - The virtual machine sizes.
	MeterParameter *string `json:"meterParameter,omitempty"`
	// Meter - The HDInsight meter guid.
	Meter *string `json:"meter,omitempty"`
	// Unit - The unit of meter, VMHours or CoreHours.
	Unit *string `json:"unit,omitempty"`
}

// BillingResources the billing resources.
type BillingResources struct {
	// Region - The region or location.
	Region *string `json:"region,omitempty"`
	// BillingMeters - The billing meter information.
	BillingMeters *[]BillingMeters `json:"billingMeters,omitempty"`
	// DiskBillingMeters - The managed disk billing information.
	DiskBillingMeters *[]DiskBillingMeters `json:"diskBillingMeters,omitempty"`
}

// BillingResponseListResult the response for the operation to get regional billingSpecs for a
// subscription.
type BillingResponseListResult struct {
	autorest.Response `json:"-"`
	// VMSizes - The virtual machine sizes to include or exclude.
	VMSizes *[]string `json:"vmSizes,omitempty"`
	// VMSizesWithEncryptionAtHost - The vm sizes which enable encryption at host.
	VMSizesWithEncryptionAtHost *[]string `json:"vmSizesWithEncryptionAtHost,omitempty"`
	// VMSizeFilters - The virtual machine filtering mode. Effectively this can enabling or disabling the virtual machine sizes in a particular set.
	VMSizeFilters *[]VMSizeCompatibilityFilterV2 `json:"vmSizeFilters,omitempty"`
	// VMSizeProperties - READ-ONLY; The vm size properties.
	VMSizeProperties *[]VMSizeProperty `json:"vmSizeProperties,omitempty"`
	// BillingResources - The billing and managed disk billing resources for a region.
	BillingResources *[]BillingResources `json:"billingResources,omitempty"`
}

// MarshalJSON is the custom marshaler for BillingResponseListResult.
func (brlr BillingResponseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brlr.VMSizes != nil {
		objectMap["vmSizes"] = brlr.VMSizes
	}
	if brlr.VMSizesWithEncryptionAtHost != nil {
		objectMap["vmSizesWithEncryptionAtHost"] = brlr.VMSizesWithEncryptionAtHost
	}
	if brlr.VMSizeFilters != nil {
		objectMap["vmSizeFilters"] = brlr.VMSizeFilters
	}
	if brlr.BillingResources != nil {
		objectMap["billingResources"] = brlr.BillingResources
	}
	return json.Marshal(objectMap)
}

// CapabilitiesResult the Get Capabilities operation response.
type CapabilitiesResult struct {
	autorest.Response `json:"-"`
	// Versions - The version capability.
	Versions map[string]*VersionsCapability `json:"versions"`
	// Regions - The virtual machine size compatibility features.
	Regions map[string]*RegionsCapability `json:"regions"`
	// VMSizes - The virtual machine sizes.
	VMSizes map[string]*VMSizesCapability `json:"vmSizes"`
	// VMSizeFilters - The virtual machine size compatibility filters.
	VMSizeFilters *[]VMSizeCompatibilityFilter `json:"vmSize_filters,omitempty"`
	// Features - The capability features.
	Features *[]string `json:"features,omitempty"`
	// Quota - The quota capability.
	Quota *QuotaCapability `json:"quota,omitempty"`
}

// MarshalJSON is the custom marshaler for CapabilitiesResult.
func (cr CapabilitiesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Versions != nil {
		objectMap["versions"] = cr.Versions
	}
	if cr.Regions != nil {
		objectMap["regions"] = cr.Regions
	}
	if cr.VMSizes != nil {
		objectMap["vmSizes"] = cr.VMSizes
	}
	if cr.VMSizeFilters != nil {
		objectMap["vmSize_filters"] = cr.VMSizeFilters
	}
	if cr.Features != nil {
		objectMap["features"] = cr.Features
	}
	if cr.Quota != nil {
		objectMap["quota"] = cr.Quota
	}
	return json.Marshal(objectMap)
}

// ClientGroupInfo the information of AAD security group.
type ClientGroupInfo struct {
	// GroupName - The AAD security group name.
	GroupName *string `json:"groupName,omitempty"`
	// GroupID - The AAD security group id.
	GroupID *string `json:"groupId,omitempty"`
}

// Cluster the HDInsight cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// Etag - The ETag for the resource
	Etag *string `json:"etag,omitempty"`
	// Properties - The properties of the cluster.
	Properties *ClusterGetProperties `json:"properties,omitempty"`
	// Identity - The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	if c.Properties != nil {
		objectMap["properties"] = c.Properties
	}
	if c.Identity != nil {
		objectMap["identity"] = c.Identity
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// ClusterConfigurations the configuration object for the specified cluster.
type ClusterConfigurations struct {
	autorest.Response `json:"-"`
	// Configurations - The configuration object for the specified configuration for the specified cluster.
	Configurations map[string]map[string]*string `json:"configurations"`
}

// MarshalJSON is the custom marshaler for ClusterConfigurations.
func (cc ClusterConfigurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.Configurations != nil {
		objectMap["configurations"] = cc.Configurations
	}
	return json.Marshal(objectMap)
}

// ClusterCreateParametersExtended the CreateCluster request parameters.
type ClusterCreateParametersExtended struct {
	// Location - The location of the cluster.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Properties - The cluster create parameters.
	Properties *ClusterCreateProperties `json:"properties,omitempty"`
	// Identity - The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCreateParametersExtended.
func (ccpe ClusterCreateParametersExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccpe.Location != nil {
		objectMap["location"] = ccpe.Location
	}
	if ccpe.Tags != nil {
		objectMap["tags"] = ccpe.Tags
	}
	if ccpe.Properties != nil {
		objectMap["properties"] = ccpe.Properties
	}
	if ccpe.Identity != nil {
		objectMap["identity"] = ccpe.Identity
	}
	return json.Marshal(objectMap)
}

// ClusterCreateProperties the cluster create parameters.
type ClusterCreateProperties struct {
	// ClusterVersion - The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// OsType - The type of operating system. Possible values include: 'Windows', 'Linux'
	OsType OSType `json:"osType,omitempty"`
	// Tier - The cluster tier. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// ClusterDefinition - The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`
	// KafkaRestProperties - The cluster kafka rest proxy configuration.
	KafkaRestProperties *KafkaRestProperties `json:"kafkaRestProperties,omitempty"`
	// SecurityProfile - The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// ComputeProfile - The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// StorageProfile - The storage profile.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// DiskEncryptionProperties - The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties `json:"diskEncryptionProperties,omitempty"`
	// EncryptionInTransitProperties - The encryption-in-transit properties.
	EncryptionInTransitProperties *EncryptionInTransitProperties `json:"encryptionInTransitProperties,omitempty"`
	// MinSupportedTLSVersion - The minimal supported tls version.
	MinSupportedTLSVersion *string `json:"minSupportedTlsVersion,omitempty"`
	// NetworkProperties - The network properties.
	NetworkProperties *NetworkProperties `json:"networkProperties,omitempty"`
	// ComputeIsolationProperties - The compute isolation properties.
	ComputeIsolationProperties *ComputeIsolationProperties `json:"computeIsolationProperties,omitempty"`
}

// ClusterDefinition the cluster definition.
type ClusterDefinition struct {
	// Blueprint - The link to the blueprint.
	Blueprint *string `json:"blueprint,omitempty"`
	// Kind - The type of cluster.
	Kind *string `json:"kind,omitempty"`
	// ComponentVersion - The versions of different services in the cluster.
	ComponentVersion map[string]*string `json:"componentVersion"`
	// Configurations - The cluster configurations.
	Configurations interface{} `json:"configurations,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterDefinition.
func (cd ClusterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.Blueprint != nil {
		objectMap["blueprint"] = cd.Blueprint
	}
	if cd.Kind != nil {
		objectMap["kind"] = cd.Kind
	}
	if cd.ComponentVersion != nil {
		objectMap["componentVersion"] = cd.ComponentVersion
	}
	if cd.Configurations != nil {
		objectMap["configurations"] = cd.Configurations
	}
	return json.Marshal(objectMap)
}

// ClusterDiskEncryptionParameters the Disk Encryption Cluster request parameters.
type ClusterDiskEncryptionParameters struct {
	// VaultURI - Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string `json:"vaultUri,omitempty"`
	// KeyName - Key name that is used for enabling disk encryption.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Specific key version that is used for enabling disk encryption.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ClusterGetProperties the properties of cluster.
type ClusterGetProperties struct {
	// ClusterVersion - The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// ClusterHdpVersion - The hdp version of the cluster.
	ClusterHdpVersion *string `json:"clusterHdpVersion,omitempty"`
	// OsType - The type of operating system. Possible values include: 'Windows', 'Linux'
	OsType OSType `json:"osType,omitempty"`
	// Tier - The cluster tier. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// ClusterID - The cluster id.
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterDefinition - The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`
	// KafkaRestProperties - The cluster kafka rest proxy configuration.
	KafkaRestProperties *KafkaRestProperties `json:"kafkaRestProperties,omitempty"`
	// SecurityProfile - The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// ComputeProfile - The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// ProvisioningState - The provisioning state, which only appears in the response. Possible values include: 'ClusterProvisioningStateInProgress', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateCanceled', 'ClusterProvisioningStateDeleting'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// CreatedDate - The date on which the cluster was created.
	CreatedDate *string `json:"createdDate,omitempty"`
	// ClusterState - The state of the cluster.
	ClusterState *string `json:"clusterState,omitempty"`
	// QuotaInfo - The quota information.
	QuotaInfo *QuotaInfo `json:"quotaInfo,omitempty"`
	// Errors - The list of errors.
	Errors *[]Errors `json:"errors,omitempty"`
	// ConnectivityEndpoints - The list of connectivity endpoints.
	ConnectivityEndpoints *[]ConnectivityEndpoint `json:"connectivityEndpoints,omitempty"`
	// DiskEncryptionProperties - The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties `json:"diskEncryptionProperties,omitempty"`
	// EncryptionInTransitProperties - The encryption-in-transit properties.
	EncryptionInTransitProperties *EncryptionInTransitProperties `json:"encryptionInTransitProperties,omitempty"`
	// StorageProfile - The storage profile.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// MinSupportedTLSVersion - The minimal supported tls version.
	MinSupportedTLSVersion *string `json:"minSupportedTlsVersion,omitempty"`
	// ExcludedServicesConfig - The excluded services config.
	ExcludedServicesConfig *ExcludedServicesConfig `json:"excludedServicesConfig,omitempty"`
	// NetworkProperties - The network properties.
	NetworkProperties *NetworkProperties `json:"networkProperties,omitempty"`
	// ComputeIsolationProperties - The compute isolation properties.
	ComputeIsolationProperties *ComputeIsolationProperties `json:"computeIsolationProperties,omitempty"`
}

// ClusterIdentity identity for the cluster.
type ClusterIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of cluster identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. Possible values include: 'SystemAssigned', 'UserAssigned', 'SystemAssignedUserAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ClusterIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ClusterIdentity.
func (ci ClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	if ci.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = ci.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ClusterIdentityUserAssignedIdentitiesValue ...
type ClusterIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
	// TenantID - The tenant id of user assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterIdentityUserAssignedIdentitiesValue.
func (ciAiv ClusterIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ciAiv.TenantID != nil {
		objectMap["tenantId"] = ciAiv.TenantID
	}
	return json.Marshal(objectMap)
}

// ClusterListPersistedScriptActionsResult the ListPersistedScriptActions operation response.
type ClusterListPersistedScriptActionsResult struct {
	// Value - The list of Persisted Script Actions.
	Value *[]RuntimeScriptAction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterListPersistedScriptActionsResult.
func (clpsar ClusterListPersistedScriptActionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clpsar.Value != nil {
		objectMap["value"] = clpsar.Value
	}
	return json.Marshal(objectMap)
}

// ClusterListResult the List Cluster operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterListResult.
func (clr ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clr.Value != nil {
		objectMap["value"] = clr.Value
	}
	return json.Marshal(objectMap)
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ClusterListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(cur ClusterListResult, getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ClusterListRuntimeScriptActionDetailResult the list runtime script action detail response.
type ClusterListRuntimeScriptActionDetailResult struct {
	// Value - READ-ONLY; The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterMonitoringRequest the Operations Management Suite (OMS) parameters.
type ClusterMonitoringRequest struct {
	// WorkspaceID - The Operations Management Suite (OMS) workspace ID.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// PrimaryKey - The Operations Management Suite (OMS) workspace key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
}

// ClusterMonitoringResponse the Operations Management Suite (OMS) status response
type ClusterMonitoringResponse struct {
	autorest.Response `json:"-"`
	// ClusterMonitoringEnabled - The status of the Operations Management Suite (OMS) on the HDInsight cluster.
	ClusterMonitoringEnabled *bool `json:"clusterMonitoringEnabled,omitempty"`
	// WorkspaceID - The workspace ID of the Operations Management Suite (OMS) on the HDInsight cluster.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// ClusterPatchParameters the PatchCluster request parameters
type ClusterPatchParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterPatchParameters.
func (cpp ClusterPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	return json.Marshal(objectMap)
}

// ClusterResizeParameters the Resize Cluster request parameters.
type ClusterResizeParameters struct {
	// TargetInstanceCount - The target instance count for the operation.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateFuture.Result.
func (future *ClustersCreateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersExecuteScriptActionsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersExecuteScriptActionsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersExecuteScriptActionsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersExecuteScriptActionsFuture.Result.
func (future *ClustersExecuteScriptActionsFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersExecuteScriptActionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersExecuteScriptActionsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersResizeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersResizeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersResizeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersResizeFuture.Result.
func (future *ClustersResizeFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersResizeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersResizeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersRotateDiskEncryptionKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersRotateDiskEncryptionKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersRotateDiskEncryptionKeyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersRotateDiskEncryptionKeyFuture.Result.
func (future *ClustersRotateDiskEncryptionKeyFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersRotateDiskEncryptionKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersRotateDiskEncryptionKeyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateAutoScaleConfigurationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersUpdateAutoScaleConfigurationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateAutoScaleConfigurationFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateAutoScaleConfigurationFuture.Result.
func (future *ClustersUpdateAutoScaleConfigurationFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersUpdateAutoScaleConfigurationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersUpdateAutoScaleConfigurationFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateGatewaySettingsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersUpdateGatewaySettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateGatewaySettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateGatewaySettingsFuture.Result.
func (future *ClustersUpdateGatewaySettingsFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersUpdateGatewaySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersUpdateGatewaySettingsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ComputeIsolationProperties the compute isolation properties.
type ComputeIsolationProperties struct {
	// EnableComputeIsolation - The flag indicates whether enable compute isolation or not.
	EnableComputeIsolation *bool `json:"enableComputeIsolation,omitempty"`
	// HostSku - The host sku.
	HostSku *string `json:"hostSku,omitempty"`
}

// ComputeProfile describes the compute profile.
type ComputeProfile struct {
	// Roles - The list of roles in the cluster.
	Roles *[]Role `json:"roles,omitempty"`
}

// ConfigurationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigurationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationsUpdateFuture.Result.
func (future *ConfigurationsUpdateFuture) result(client ConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ConfigurationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ConfigurationsUpdateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectivityEndpoint the connectivity properties
type ConnectivityEndpoint struct {
	// Name - The name of the endpoint.
	Name *string `json:"name,omitempty"`
	// Protocol - The protocol of the endpoint.
	Protocol *string `json:"protocol,omitempty"`
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// Port - The port to connect to.
	Port *int32 `json:"port,omitempty"`
	// PrivateIPAddress - The private ip address of the endpoint.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
}

// DataDisksGroups the data disks groups for the role.
type DataDisksGroups struct {
	// DisksPerNode - The number of disks per node.
	DisksPerNode *int32 `json:"disksPerNode,omitempty"`
	// StorageAccountType - READ-ONLY; ReadOnly. The storage account type. Do not set this value.
	StorageAccountType *string `json:"storageAccountType,omitempty"`
	// DiskSizeGB - READ-ONLY; ReadOnly. The DiskSize in GB. Do not set this value.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
}

// MarshalJSON is the custom marshaler for DataDisksGroups.
func (ddg DataDisksGroups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ddg.DisksPerNode != nil {
		objectMap["disksPerNode"] = ddg.DisksPerNode
	}
	return json.Marshal(objectMap)
}

// Dimension the definition of Dimension.
type Dimension struct {
	// Name - The name of the dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - The display name of the dimension.
	InternalName *string `json:"internalName,omitempty"`
	// ToBeExportedForShoebox - The flag indicates whether the metric will be exported for shoebox or not.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// DiskBillingMeters the disk billing meters.
type DiskBillingMeters struct {
	// DiskRpMeter - The managed disk meter guid.
	DiskRpMeter *string `json:"diskRpMeter,omitempty"`
	// Sku - The managed disk billing sku, P30 or S30.
	Sku *string `json:"sku,omitempty"`
	// Tier - The managed disk billing tier, Standard or Premium. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
}

// DiskEncryptionProperties the disk encryption properties
type DiskEncryptionProperties struct {
	// VaultURI - Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string `json:"vaultUri,omitempty"`
	// KeyName - Key name that is used for enabling disk encryption.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Specific key version that is used for enabling disk encryption.
	KeyVersion *string `json:"keyVersion,omitempty"`
	// EncryptionAlgorithm - Algorithm identifier for encryption, default RSA-OAEP. Possible values include: 'RSAOAEP', 'RSAOAEP256', 'RSA15'
	EncryptionAlgorithm JSONWebKeyEncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
	// MsiResourceID - Resource ID of Managed Identity that is used to access the key vault.
	MsiResourceID *string `json:"msiResourceId,omitempty"`
	// EncryptionAtHost - Indicates whether or not resource disk encryption is enabled.
	EncryptionAtHost *bool `json:"encryptionAtHost,omitempty"`
}

// EncryptionInTransitProperties the encryption-in-transit properties.
type EncryptionInTransitProperties struct {
	// IsEncryptionInTransitEnabled - Indicates whether or not inter cluster node communication is encrypted in transit.
	IsEncryptionInTransitEnabled *bool `json:"isEncryptionInTransitEnabled,omitempty"`
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Errors the error message associated with the cluster creation.
type Errors struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ExcludedServicesConfig the configuration that services will be excluded when creating cluster.
type ExcludedServicesConfig struct {
	// ExcludedServicesConfigID - The config id of excluded services.
	ExcludedServicesConfigID *string `json:"excludedServicesConfigId,omitempty"`
	// ExcludedServicesList - The list of excluded services.
	ExcludedServicesList *string `json:"excludedServicesList,omitempty"`
}

// ExecuteScriptActionParameters the parameters for the script actions to execute on a running cluster.
type ExecuteScriptActionParameters struct {
	// ScriptActions - The list of run time script actions.
	ScriptActions *[]RuntimeScriptAction `json:"scriptActions,omitempty"`
	// PersistOnSuccess - Gets or sets if the scripts needs to be persisted.
	PersistOnSuccess *bool `json:"persistOnSuccess,omitempty"`
}

// Extension cluster monitoring extensions
type Extension struct {
	autorest.Response `json:"-"`
	// WorkspaceID - The workspace ID for the cluster monitoring extension.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// PrimaryKey - The certificate for the cluster monitoring extensions.
	PrimaryKey *string `json:"primaryKey,omitempty"`
}

// ExtensionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsCreateFuture.Result.
func (future *ExtensionsCreateFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsDeleteFuture.Result.
func (future *ExtensionsDeleteFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsDisableMonitoringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExtensionsDisableMonitoringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsDisableMonitoringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsDisableMonitoringFuture.Result.
func (future *ExtensionsDisableMonitoringFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsDisableMonitoringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsDisableMonitoringFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsEnableMonitoringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExtensionsEnableMonitoringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsEnableMonitoringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsEnableMonitoringFuture.Result.
func (future *ExtensionsEnableMonitoringFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsEnableMonitoringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsEnableMonitoringFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GatewaySettings gateway settings.
type GatewaySettings struct {
	autorest.Response `json:"-"`
	// IsCredentialEnabled - READ-ONLY; Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *string `json:"restAuthCredential.isEnabled,omitempty"`
	// UserName - READ-ONLY; The gateway settings user name.
	UserName *string `json:"restAuthCredential.username,omitempty"`
	// Password - READ-ONLY; The gateway settings user password.
	Password *string `json:"restAuthCredential.password,omitempty"`
}

// HardwareProfile the hardware profile.
type HardwareProfile struct {
	// VMSize - The size of the VM
	VMSize *string `json:"vmSize,omitempty"`
}

// HostInfo the cluster host information.
type HostInfo struct {
	// Name - The host name
	Name *string `json:"name,omitempty"`
	// Fqdn - The Fully Qualified Domain Name of host
	Fqdn *string `json:"fqdn,omitempty"`
	// EffectiveDiskEncryptionKeyURL - The effective disk encryption key URL used by the host
	EffectiveDiskEncryptionKeyURL *string `json:"effectiveDiskEncryptionKeyUrl,omitempty"`
}

// KafkaRestProperties the kafka rest proxy configuration which contains AAD security group information.
type KafkaRestProperties struct {
	// ClientGroupInfo - The information of AAD security group.
	ClientGroupInfo *ClientGroupInfo `json:"clientGroupInfo,omitempty"`
}

// LinuxOperatingSystemProfile the ssh username, password, and ssh public key.
type LinuxOperatingSystemProfile struct {
	// Username - The username.
	Username *string `json:"username,omitempty"`
	// Password - The password.
	Password *string `json:"password,omitempty"`
	// SSHProfile - The SSH profile.
	SSHProfile *SSHProfile `json:"sshProfile,omitempty"`
}

// ListHostInfo ...
type ListHostInfo struct {
	autorest.Response `json:"-"`
	Value             *[]HostInfo `json:"value,omitempty"`
}

// LocalizedName the details about the localizable name of a type of usage.
type LocalizedName struct {
	// Value - The name of the used resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the used resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricSpecifications the details of metric specifications.
type MetricSpecifications struct {
	// Name - The name of the metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - The display description of the metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - The unit of the metric specification.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - The aggregation type of the metric specification.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - The supported aggregation types of the metric specification.
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - The supported time grain types of the metric specification.
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// EnableRegionalMdmAccount - The flag indicates whether enable regional mdm account or not.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`
	// SourceMdmAccount - The source mdm account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - The source mdm namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// MetricFilterPattern - The metric filter pattern.
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`
	// FillGapWithZero - The flag indicates whether filling gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category of the metric.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - The override name of resource id dimension name.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
	// IsInternal - The flag indicates whether the metric is internal or not.
	IsInternal *bool `json:"isInternal,omitempty"`
	// DelegateMetricNameOverride - The override name of delegate metric.
	DelegateMetricNameOverride *string `json:"delegateMetricNameOverride,omitempty"`
	// Dimensions - The dimensions of the metric specification.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
}

// NetworkProperties the network properties.
type NetworkProperties struct {
	// ResourceProviderConnection - The direction for the resource provider connection. Possible values include: 'Inbound', 'Outbound'
	ResourceProviderConnection ResourceProviderConnection `json:"resourceProviderConnection,omitempty"`
	// PrivateLink - Indicates whether or not private link is enabled. Possible values include: 'Disabled', 'Enabled'
	PrivateLink PrivateLink `json:"privateLink,omitempty"`
}

// Operation the HDInsight REST API operation.
type Operation struct {
	// Name - The operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Properties - The operation properties.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - The service provider: Microsoft.HDInsight
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed: Cluster, Applications, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation type: read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list HDInsight operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of HDInsight operations supported by the HDInsight resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationProperties the details of operation.
type OperationProperties struct {
	// ServiceSpecification - The specification of the service.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationResource the azure async operation response.
type OperationResource struct {
	// Status - The async operation state. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationState `json:"status,omitempty"`
	// Error - The operation error information.
	Error *Errors `json:"error,omitempty"`
}

// OsProfile the Linux operation systems profile.
type OsProfile struct {
	// LinuxOperatingSystemProfile - The Linux OS profile.
	LinuxOperatingSystemProfile *LinuxOperatingSystemProfile `json:"linuxOperatingSystemProfile,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// QuotaCapability the regional quota capability.
type QuotaCapability struct {
	// CoresUsed - The number of cores used in the subscription.
	CoresUsed *int64 `json:"cores_used,omitempty"`
	// MaxCoresAllowed - The number of cores that the subscription allowed.
	MaxCoresAllowed *int64 `json:"max_cores_allowed,omitempty"`
	// RegionalQuotas - The list of region quota capabilities.
	RegionalQuotas *[]RegionalQuotaCapability `json:"regionalQuotas,omitempty"`
}

// QuotaInfo the quota properties for the cluster.
type QuotaInfo struct {
	// CoresUsed - The cores used by the cluster.
	CoresUsed *int32 `json:"coresUsed,omitempty"`
}

// RegionalQuotaCapability the regional quota capacity.
type RegionalQuotaCapability struct {
	// RegionName - The region name.
	RegionName *string `json:"region_name,omitempty"`
	// CoresUsed - The number of cores used in the region.
	CoresUsed *int64 `json:"cores_used,omitempty"`
	// CoresAvailable - The number of cores available in the region.
	CoresAvailable *int64 `json:"cores_available,omitempty"`
}

// RegionsCapability the regions capability.
type RegionsCapability struct {
	// Available - The list of region capabilities.
	Available *[]string `json:"available,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// Role describes a role on the cluster.
type Role struct {
	// Name - The name of the role.
	Name *string `json:"name,omitempty"`
	// MinInstanceCount - The minimum instance count of the cluster.
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`
	// TargetInstanceCount - The instance count of the cluster.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
	// AutoscaleConfiguration - The autoscale configurations.
	AutoscaleConfiguration *Autoscale `json:"autoscale,omitempty"`
	// HardwareProfile - The hardware profile.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// OsProfile - The operating system profile.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// VirtualNetworkProfile - The virtual network profile.
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`
	// DataDisksGroups - The data disks groups for the role.
	DataDisksGroups *[]DataDisksGroups `json:"dataDisksGroups,omitempty"`
	// ScriptActions - The list of script actions on the role.
	ScriptActions *[]ScriptAction `json:"scriptActions,omitempty"`
	// EncryptDataDisks - Indicates whether encrypt the data disks.
	EncryptDataDisks *bool `json:"encryptDataDisks,omitempty"`
}

// RuntimeScriptAction describes a script action on a running cluster.
type RuntimeScriptAction struct {
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - READ-ONLY; The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// MarshalJSON is the custom marshaler for RuntimeScriptAction.
func (rsaVar RuntimeScriptAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsaVar.Name != nil {
		objectMap["name"] = rsaVar.Name
	}
	if rsaVar.URI != nil {
		objectMap["uri"] = rsaVar.URI
	}
	if rsaVar.Parameters != nil {
		objectMap["parameters"] = rsaVar.Parameters
	}
	if rsaVar.Roles != nil {
		objectMap["roles"] = rsaVar.Roles
	}
	return json.Marshal(objectMap)
}

// RuntimeScriptActionDetail the execution details of a script action.
type RuntimeScriptActionDetail struct {
	autorest.Response `json:"-"`
	// ScriptExecutionID - READ-ONLY; The execution id of the script action.
	ScriptExecutionID *int64 `json:"scriptExecutionId,omitempty"`
	// StartTime - READ-ONLY; The start time of script action execution.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of script action execution.
	EndTime *string `json:"endTime,omitempty"`
	// Status - READ-ONLY; The current execution status of the script action.
	Status *string `json:"status,omitempty"`
	// Operation - READ-ONLY; The reason why the script action was executed.
	Operation *string `json:"operation,omitempty"`
	// ExecutionSummary - READ-ONLY; The summary of script action execution result.
	ExecutionSummary *[]ScriptActionExecutionSummary `json:"executionSummary,omitempty"`
	// DebugInformation - READ-ONLY; The script action execution debug information.
	DebugInformation *string `json:"debugInformation,omitempty"`
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - READ-ONLY; The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// MarshalJSON is the custom marshaler for RuntimeScriptActionDetail.
func (rsad RuntimeScriptActionDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsad.Name != nil {
		objectMap["name"] = rsad.Name
	}
	if rsad.URI != nil {
		objectMap["uri"] = rsad.URI
	}
	if rsad.Parameters != nil {
		objectMap["parameters"] = rsad.Parameters
	}
	if rsad.Roles != nil {
		objectMap["roles"] = rsad.Roles
	}
	return json.Marshal(objectMap)
}

// ScriptAction describes a script action on role on the cluster.
type ScriptAction struct {
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`
}

// ScriptActionExecutionHistoryList the list script execution history response.
type ScriptActionExecutionHistoryList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScriptActionExecutionHistoryListIterator provides access to a complete listing of
// RuntimeScriptActionDetail values.
type ScriptActionExecutionHistoryListIterator struct {
	i    int
	page ScriptActionExecutionHistoryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptActionExecutionHistoryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionExecutionHistoryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptActionExecutionHistoryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptActionExecutionHistoryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptActionExecutionHistoryListIterator) Response() ScriptActionExecutionHistoryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptActionExecutionHistoryListIterator) Value() RuntimeScriptActionDetail {
	if !iter.page.NotDone() {
		return RuntimeScriptActionDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptActionExecutionHistoryListIterator type.
func NewScriptActionExecutionHistoryListIterator(page ScriptActionExecutionHistoryListPage) ScriptActionExecutionHistoryListIterator {
	return ScriptActionExecutionHistoryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saehl ScriptActionExecutionHistoryList) IsEmpty() bool {
	return saehl.Value == nil || len(*saehl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (saehl ScriptActionExecutionHistoryList) hasNextLink() bool {
	return saehl.NextLink != nil && len(*saehl.NextLink) != 0
}

// scriptActionExecutionHistoryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saehl ScriptActionExecutionHistoryList) scriptActionExecutionHistoryListPreparer(ctx context.Context) (*http.Request, error) {
	if !saehl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saehl.NextLink)))
}

// ScriptActionExecutionHistoryListPage contains a page of RuntimeScriptActionDetail values.
type ScriptActionExecutionHistoryListPage struct {
	fn    func(context.Context, ScriptActionExecutionHistoryList) (ScriptActionExecutionHistoryList, error)
	saehl ScriptActionExecutionHistoryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptActionExecutionHistoryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionExecutionHistoryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.saehl)
		if err != nil {
			return err
		}
		page.saehl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptActionExecutionHistoryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptActionExecutionHistoryListPage) NotDone() bool {
	return !page.saehl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptActionExecutionHistoryListPage) Response() ScriptActionExecutionHistoryList {
	return page.saehl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptActionExecutionHistoryListPage) Values() []RuntimeScriptActionDetail {
	if page.saehl.IsEmpty() {
		return nil
	}
	return *page.saehl.Value
}

// Creates a new instance of the ScriptActionExecutionHistoryListPage type.
func NewScriptActionExecutionHistoryListPage(cur ScriptActionExecutionHistoryList, getNextPage func(context.Context, ScriptActionExecutionHistoryList) (ScriptActionExecutionHistoryList, error)) ScriptActionExecutionHistoryListPage {
	return ScriptActionExecutionHistoryListPage{
		fn:    getNextPage,
		saehl: cur,
	}
}

// ScriptActionExecutionSummary the execution summary of a script action.
type ScriptActionExecutionSummary struct {
	// Status - READ-ONLY; The status of script action execution.
	Status *string `json:"status,omitempty"`
	// InstanceCount - READ-ONLY; The instance count for a given script action execution status.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// ScriptActionPersistedGetResponseSpec the persisted script action for cluster.
type ScriptActionPersistedGetResponseSpec struct {
	// Name - The name of script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - The application name for the script action.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// ScriptActionsList the persisted script action for the cluster.
type ScriptActionsList struct {
	autorest.Response `json:"-"`
	// Value - The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptActionsList.
func (sal ScriptActionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sal.Value != nil {
		objectMap["value"] = sal.Value
	}
	return json.Marshal(objectMap)
}

// ScriptActionsListIterator provides access to a complete listing of RuntimeScriptActionDetail values.
type ScriptActionsListIterator struct {
	i    int
	page ScriptActionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptActionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptActionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptActionsListIterator) Response() ScriptActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptActionsListIterator) Value() RuntimeScriptActionDetail {
	if !iter.page.NotDone() {
		return RuntimeScriptActionDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptActionsListIterator type.
func NewScriptActionsListIterator(page ScriptActionsListPage) ScriptActionsListIterator {
	return ScriptActionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sal ScriptActionsList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sal ScriptActionsList) hasNextLink() bool {
	return sal.NextLink != nil && len(*sal.NextLink) != 0
}

// scriptActionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal ScriptActionsList) scriptActionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !sal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// ScriptActionsListPage contains a page of RuntimeScriptActionDetail values.
type ScriptActionsListPage struct {
	fn  func(context.Context, ScriptActionsList) (ScriptActionsList, error)
	sal ScriptActionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptActionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sal)
		if err != nil {
			return err
		}
		page.sal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptActionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptActionsListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptActionsListPage) Response() ScriptActionsList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptActionsListPage) Values() []RuntimeScriptActionDetail {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// Creates a new instance of the ScriptActionsListPage type.
func NewScriptActionsListPage(cur ScriptActionsList, getNextPage func(context.Context, ScriptActionsList) (ScriptActionsList, error)) ScriptActionsListPage {
	return ScriptActionsListPage{
		fn:  getNextPage,
		sal: cur,
	}
}

// SecurityProfile the security profile which contains Ssh public key for the HDInsight cluster.
type SecurityProfile struct {
	// DirectoryType - The directory type. Possible values include: 'ActiveDirectory'
	DirectoryType DirectoryType `json:"directoryType,omitempty"`
	// Domain - The organization's active directory domain.
	Domain *string `json:"domain,omitempty"`
	// OrganizationalUnitDN - The organizational unit within the Active Directory to place the cluster and service accounts.
	OrganizationalUnitDN *string `json:"organizationalUnitDN,omitempty"`
	// LdapsUrls - The LDAPS protocol URLs to communicate with the Active Directory.
	LdapsUrls *[]string `json:"ldapsUrls,omitempty"`
	// DomainUsername - The domain user account that will have admin privileges on the cluster.
	DomainUsername *string `json:"domainUsername,omitempty"`
	// DomainUserPassword - The domain admin password.
	DomainUserPassword *string `json:"domainUserPassword,omitempty"`
	// ClusterUsersGroupDNS - Optional. The Distinguished Names for cluster user groups
	ClusterUsersGroupDNS *[]string `json:"clusterUsersGroupDNs,omitempty"`
	// AaddsResourceID - The resource ID of the user's Azure Active Directory Domain Service.
	AaddsResourceID *string `json:"aaddsResourceId,omitempty"`
	// MsiResourceID - User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
	MsiResourceID *string `json:"msiResourceId,omitempty"`
}

// ServiceSpecification the specification of the service.
type ServiceSpecification struct {
	// MetricSpecifications - The metric specifications.
	MetricSpecifications *[]MetricSpecifications `json:"metricSpecifications,omitempty"`
}

// SetString ...
type SetString struct {
	autorest.Response `json:"-"`
	Value             map[string]*string `json:"value"`
}

// MarshalJSON is the custom marshaler for SetString.
func (ss SetString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.Value != nil {
		objectMap["value"] = ss.Value
	}
	return json.Marshal(objectMap)
}

// SSHProfile the list of SSH public keys.
type SSHProfile struct {
	// PublicKeys - The list of SSH public keys.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey the SSH public key for the cluster nodes.
type SSHPublicKey struct {
	// CertificateData - The certificate for SSH.
	CertificateData *string `json:"certificateData,omitempty"`
}

// StorageAccount the storage Account.
type StorageAccount struct {
	// Name - The name of the storage account.
	Name *string `json:"name,omitempty"`
	// IsDefault - Whether or not the storage account is the default storage account.
	IsDefault *bool `json:"isDefault,omitempty"`
	// Container - The container in the storage account, only to be specified for WASB storage accounts.
	Container *string `json:"container,omitempty"`
	// FileSystem - The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
	FileSystem *string `json:"fileSystem,omitempty"`
	// Key - The storage account access key.
	Key *string `json:"key,omitempty"`
	// ResourceID - The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
	ResourceID *string `json:"resourceId,omitempty"`
	// MsiResourceID - The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
	MsiResourceID *string `json:"msiResourceId,omitempty"`
}

// StorageProfile the storage profile.
type StorageProfile struct {
	// Storageaccounts - The list of storage accounts in the cluster.
	Storageaccounts *[]StorageAccount `json:"storageaccounts,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateGatewaySettingsParameters the update gateway settings request parameters.
type UpdateGatewaySettingsParameters struct {
	// IsCredentialEnabled - Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *bool `json:"restAuthCredential.isEnabled,omitempty"`
	// UserName - The gateway settings user name.
	UserName *string `json:"restAuthCredential.username,omitempty"`
	// Password - The gateway settings user password.
	Password *string `json:"restAuthCredential.password,omitempty"`
}

// Usage the details about the usage of a particular limited resource.
type Usage struct {
	// Unit - The type of measurement for usage.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current usage.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - The maximum allowed usage.
	Limit *int32 `json:"limit,omitempty"`
	// Name - The details about the localizable name of the used resource.
	Name *LocalizedName `json:"name,omitempty"`
}

// UsagesListResult the response for the operation to get regional usages for a subscription.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usages.
	Value *[]Usage `json:"value,omitempty"`
}

// VersionsCapability the version capability.
type VersionsCapability struct {
	// Available - The list of version capabilities.
	Available *[]VersionSpec `json:"available,omitempty"`
}

// VersionSpec the version properties.
type VersionSpec struct {
	// FriendlyName - The friendly name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// DisplayName - The display name
	DisplayName *string `json:"displayName,omitempty"`
	// IsDefault - Whether or not the version is the default version.
	IsDefault *string `json:"isDefault,omitempty"`
	// ComponentVersions - The component version property.
	ComponentVersions map[string]*string `json:"componentVersions"`
}

// MarshalJSON is the custom marshaler for VersionSpec.
func (vs VersionSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vs.FriendlyName != nil {
		objectMap["friendlyName"] = vs.FriendlyName
	}
	if vs.DisplayName != nil {
		objectMap["displayName"] = vs.DisplayName
	}
	if vs.IsDefault != nil {
		objectMap["isDefault"] = vs.IsDefault
	}
	if vs.ComponentVersions != nil {
		objectMap["componentVersions"] = vs.ComponentVersions
	}
	return json.Marshal(objectMap)
}

// VirtualMachinesRestartHostsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesRestartHostsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesRestartHostsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesRestartHostsFuture.Result.
func (future *VirtualMachinesRestartHostsFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.VirtualMachinesRestartHostsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hdinsight.VirtualMachinesRestartHostsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkProfile the virtual network properties.
type VirtualNetworkProfile struct {
	// ID - The ID of the virtual network.
	ID *string `json:"id,omitempty"`
	// Subnet - The name of the subnet.
	Subnet *string `json:"subnet,omitempty"`
}

// VMSizeCompatibilityFilter the virtual machine type compatibility filter.
type VMSizeCompatibilityFilter struct {
	// FilterMode - The mode for the filter.
	FilterMode *string `json:"FilterMode,omitempty"`
	// Regions - The list of regions.
	Regions *[]string `json:"Regions,omitempty"`
	// ClusterFlavors - The list of cluster types available.
	ClusterFlavors *[]string `json:"ClusterFlavors,omitempty"`
	// NodeTypes - The list of node types.
	NodeTypes *[]string `json:"NodeTypes,omitempty"`
	// ClusterVersions - The list of cluster versions.
	ClusterVersions *[]string `json:"ClusterVersions,omitempty"`
	// Vmsizes - The list of virtual machine sizes.
	Vmsizes *[]string `json:"vmsizes,omitempty"`
}

// VMSizeCompatibilityFilterV2 this class represent a single filter object that defines a multidimensional
// set. The dimensions of this set are Regions, ClusterFlavors, NodeTypes and ClusterVersions. The
// constraint should be defined based on the following: FilterMode (Exclude vs Include), VMSizes (the vm
// sizes in affect of exclusion/inclusion) and the ordering of the Filters. Later filters override previous
// settings if conflicted.
type VMSizeCompatibilityFilterV2 struct {
	// FilterMode - The filtering mode. Effectively this can enabling or disabling the VM sizes in a particular set. Possible values include: 'Exclude', 'Include', 'Recommend', 'Default'
	FilterMode FilterMode `json:"filterMode,omitempty"`
	// Regions - The list of regions under the effect of the filter.
	Regions *[]string `json:"regions,omitempty"`
	// ClusterFlavors - The list of cluster flavors under the effect of the filter.
	ClusterFlavors *[]string `json:"clusterFlavors,omitempty"`
	// NodeTypes - The list of node types affected by the filter.
	NodeTypes *[]string `json:"nodeTypes,omitempty"`
	// ClusterVersions - The list of cluster versions affected in Major.Minor format.
	ClusterVersions *[]string `json:"clusterVersions,omitempty"`
	// OsType - The OSType affected, Windows or Linux.
	OsType *[]OSType `json:"osType,omitempty"`
	// VMSizes - The list of virtual machine sizes to include or exclude.
	VMSizes *[]string `json:"vmSizes,omitempty"`
}

// VMSizeProperty the vm size property
type VMSizeProperty struct {
	// Name - The vm size name.
	Name *string `json:"name,omitempty"`
	// Cores - The number of cores that the vm size has.
	Cores *int32 `json:"cores,omitempty"`
	// DataDiskStorageTier - The data disk storage tier of the vm size.
	DataDiskStorageTier *string `json:"dataDiskStorageTier,omitempty"`
	// Label - The label of the vm size.
	Label *string `json:"label,omitempty"`
	// MaxDataDiskCount - The max data disk count of the vm size.
	MaxDataDiskCount *int64 `json:"maxDataDiskCount,omitempty"`
	// MemoryInMb - The memory whose unit is MB of the vm size.
	MemoryInMb *int64 `json:"memoryInMb,omitempty"`
	// SupportedByVirtualMachines - This indicates this vm size is supported by virtual machines or not
	SupportedByVirtualMachines *bool `json:"supportedByVirtualMachines,omitempty"`
	// SupportedByWebWorkerRoles - The indicates this vm size is supported by web worker roles or not
	SupportedByWebWorkerRoles *bool `json:"supportedByWebWorkerRoles,omitempty"`
	// VirtualMachineResourceDiskSizeInMb - The virtual machine resource disk size whose unit is MB of the vm size.
	VirtualMachineResourceDiskSizeInMb *int64 `json:"virtualMachineResourceDiskSizeInMb,omitempty"`
	// WebWorkerResourceDiskSizeInMb - The web worker resource disk size whose unit is MB of the vm size.
	WebWorkerResourceDiskSizeInMb *int64 `json:"webWorkerResourceDiskSizeInMb,omitempty"`
}

// VMSizesCapability the virtual machine sizes capability.
type VMSizesCapability struct {
	// Available - The list of virtual machine size capabilities.
	Available *[]string `json:"available,omitempty"`
}
