// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to get information about the current ApiKeys resource.
type GetApiKeysInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a customer in AWS Marketplace or an external system, such
	// as a developer portal.
	CustomerId *string `location:"querystring" locationName:"customerId" type:"string"`

	// A boolean flag to specify whether (true) or not (false) the result contains
	// key values.
	IncludeValues *bool `location:"querystring" locationName:"includeValues" type:"boolean"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The name of queried API keys.
	NameQuery *string `location:"querystring" locationName:"name" type:"string"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetApiKeysInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApiKeysInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CustomerId != nil {
		v := *s.CustomerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "customerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IncludeValues != nil {
		v := *s.IncludeValues

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "includeValues", protocol.BoolValue(v), metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.NameQuery != nil {
		v := *s.NameQuery

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a collection of API keys as represented by an ApiKeys resource.
//
// Use API Keys (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html)
type GetApiKeysOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []ApiKey `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`

	// A list of warning messages logged during the import of API keys when the
	// failOnWarnings option is set to true.
	Warnings []string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s GetApiKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApiKeysOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Warnings != nil {
		v := s.Warnings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "warnings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opGetApiKeys = "GetApiKeys"

// GetApiKeysRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Gets information about the current ApiKeys resource.
//
//    // Example sending a request using GetApiKeysRequest.
//    req := client.GetApiKeysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetApiKeysRequest(input *GetApiKeysInput) GetApiKeysRequest {
	op := &aws.Operation{
		Name:       opGetApiKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/apikeys",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetApiKeysInput{}
	}

	req := c.newRequest(op, input, &GetApiKeysOutput{})
	return GetApiKeysRequest{Request: req, Input: input, Copy: c.GetApiKeysRequest}
}

// GetApiKeysRequest is the request type for the
// GetApiKeys API operation.
type GetApiKeysRequest struct {
	*aws.Request
	Input *GetApiKeysInput
	Copy  func(*GetApiKeysInput) GetApiKeysRequest
}

// Send marshals and sends the GetApiKeys API request.
func (r GetApiKeysRequest) Send(ctx context.Context) (*GetApiKeysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApiKeysResponse{
		GetApiKeysOutput: r.Request.Data.(*GetApiKeysOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetApiKeysRequestPaginator returns a paginator for GetApiKeys.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetApiKeysRequest(input)
//   p := apigateway.NewGetApiKeysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetApiKeysPaginator(req GetApiKeysRequest) GetApiKeysPaginator {
	return GetApiKeysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetApiKeysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetApiKeysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetApiKeysPaginator struct {
	aws.Pager
}

func (p *GetApiKeysPaginator) CurrentPage() *GetApiKeysOutput {
	return p.Pager.CurrentPage().(*GetApiKeysOutput)
}

// GetApiKeysResponse is the response type for the
// GetApiKeys API operation.
type GetApiKeysResponse struct {
	*GetApiKeysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApiKeys request.
func (r *GetApiKeysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
