// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of jobs to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListTranscriptionJobs was truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only transcription jobs with the specified status.
	// Jobs are ordered by creation date, with the newest jobs returned first. If
	// you don’t specify a status, Amazon Transcribe returns all transcription
	// jobs ordered by creation date.
	Status TranscriptionJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTranscriptionJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// The ListTranscriptionJobs operation returns a page of jobs at a time. The
	// maximum size of the page is set by the MaxResults parameter. If there are
	// more jobs in the list than the page size, Amazon Transcribe returns the NextPage
	// token. Include the token in the next request to the ListTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the jobs returned.
	Status TranscriptionJobStatus `type:"string" enum:"true"`

	// A list of objects containing summary information for a transcription job.
	TranscriptionJobSummaries []TranscriptionJobSummary `type:"list"`
}

// String returns the string representation
func (s ListTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTranscriptionJobs = "ListTranscriptionJobs"

// ListTranscriptionJobsRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Lists transcription jobs with the specified status.
//
//    // Example sending a request using ListTranscriptionJobsRequest.
//    req := client.ListTranscriptionJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *Client) ListTranscriptionJobsRequest(input *ListTranscriptionJobsInput) ListTranscriptionJobsRequest {
	op := &aws.Operation{
		Name:       opListTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTranscriptionJobsInput{}
	}

	req := c.newRequest(op, input, &ListTranscriptionJobsOutput{})
	return ListTranscriptionJobsRequest{Request: req, Input: input, Copy: c.ListTranscriptionJobsRequest}
}

// ListTranscriptionJobsRequest is the request type for the
// ListTranscriptionJobs API operation.
type ListTranscriptionJobsRequest struct {
	*aws.Request
	Input *ListTranscriptionJobsInput
	Copy  func(*ListTranscriptionJobsInput) ListTranscriptionJobsRequest
}

// Send marshals and sends the ListTranscriptionJobs API request.
func (r ListTranscriptionJobsRequest) Send(ctx context.Context) (*ListTranscriptionJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTranscriptionJobsResponse{
		ListTranscriptionJobsOutput: r.Request.Data.(*ListTranscriptionJobsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTranscriptionJobsRequestPaginator returns a paginator for ListTranscriptionJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTranscriptionJobsRequest(input)
//   p := transcribe.NewListTranscriptionJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTranscriptionJobsPaginator(req ListTranscriptionJobsRequest) ListTranscriptionJobsPaginator {
	return ListTranscriptionJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTranscriptionJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTranscriptionJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTranscriptionJobsPaginator struct {
	aws.Pager
}

func (p *ListTranscriptionJobsPaginator) CurrentPage() *ListTranscriptionJobsOutput {
	return p.Pager.CurrentPage().(*ListTranscriptionJobsOutput)
}

// ListTranscriptionJobsResponse is the response type for the
// ListTranscriptionJobs API operation.
type ListTranscriptionJobsResponse struct {
	*ListTranscriptionJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTranscriptionJobs request.
func (r *ListTranscriptionJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
