// Code generated by protoc-gen-validate
// source: envoy/data/cluster/v2alpha/outlier_detection_event.proto
// DO NOT EDIT!!!

package envoy_data_cluster_v2alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on OutlierDetectionEvent with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *OutlierDetectionEvent) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := OutlierEjectionType_name[int32(m.GetType())]; !ok {
		return OutlierDetectionEventValidationError{
			Field:  "Type",
			Reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetTimestamp()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionEventValidationError{
				Field:  "Timestamp",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetSecsSinceLastAction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionEventValidationError{
				Field:  "SecsSinceLastAction",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if len(m.GetClusterName()) < 1 {
		return OutlierDetectionEventValidationError{
			Field:  "ClusterName",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetUpstreamUrl()) < 1 {
		return OutlierDetectionEventValidationError{
			Field:  "UpstreamUrl",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if _, ok := Action_name[int32(m.GetAction())]; !ok {
		return OutlierDetectionEventValidationError{
			Field:  "Action",
			Reason: "value must be one of the defined enum values",
		}
	}

	// no validation rules for NumEjections

	// no validation rules for Enforced

	switch m.Event.(type) {

	case *OutlierDetectionEvent_EjectSuccessRateEvent:

		if v, ok := interface{}(m.GetEjectSuccessRateEvent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OutlierDetectionEventValidationError{
					Field:  "EjectSuccessRateEvent",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *OutlierDetectionEvent_EjectConsecutiveEvent:

		if v, ok := interface{}(m.GetEjectConsecutiveEvent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OutlierDetectionEventValidationError{
					Field:  "EjectConsecutiveEvent",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return OutlierDetectionEventValidationError{
			Field:  "Event",
			Reason: "value is required",
		}

	}

	return nil
}

// OutlierDetectionEventValidationError is the validation error returned by
// OutlierDetectionEvent.Validate if the designated constraints aren't met.
type OutlierDetectionEventValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e OutlierDetectionEventValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierDetectionEvent.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = OutlierDetectionEventValidationError{}

// Validate checks the field values on OutlierEjectSuccessRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *OutlierEjectSuccessRate) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetHostSuccessRate() > 100 {
		return OutlierEjectSuccessRateValidationError{
			Field:  "HostSuccessRate",
			Reason: "value must be less than or equal to 100",
		}
	}

	if m.GetClusterAverageSuccessRate() > 100 {
		return OutlierEjectSuccessRateValidationError{
			Field:  "ClusterAverageSuccessRate",
			Reason: "value must be less than or equal to 100",
		}
	}

	if m.GetClusterSuccessRateEjectionThreshold() > 100 {
		return OutlierEjectSuccessRateValidationError{
			Field:  "ClusterSuccessRateEjectionThreshold",
			Reason: "value must be less than or equal to 100",
		}
	}

	return nil
}

// OutlierEjectSuccessRateValidationError is the validation error returned by
// OutlierEjectSuccessRate.Validate if the designated constraints aren't met.
type OutlierEjectSuccessRateValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e OutlierEjectSuccessRateValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierEjectSuccessRate.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = OutlierEjectSuccessRateValidationError{}

// Validate checks the field values on OutlierEjectConsecutive with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *OutlierEjectConsecutive) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// OutlierEjectConsecutiveValidationError is the validation error returned by
// OutlierEjectConsecutive.Validate if the designated constraints aren't met.
type OutlierEjectConsecutiveValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e OutlierEjectConsecutiveValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierEjectConsecutive.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = OutlierEjectConsecutiveValidationError{}
