// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/data/cluster/v2alpha/outlier_detection_event.proto

package envoy_data_cluster_v2alpha

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	_ "github.com/lyft/protoc-gen-validate/validate"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Type of ejection that took place
type OutlierEjectionType int32

const (
	// In case upstream host returns certain number of consecutive 5xx
	OutlierEjectionType_CONSECUTIVE_5XX OutlierEjectionType = 0
	// In case upstream host returns certain number of consecutive gateway errors
	OutlierEjectionType_CONSECUTIVE_GATEWAY_FAILURE OutlierEjectionType = 1
	// Runs over aggregated success rate statistics from every host in cluster
	OutlierEjectionType_SUCCESS_RATE OutlierEjectionType = 2
)

var OutlierEjectionType_name = map[int32]string{
	0: "CONSECUTIVE_5XX",
	1: "CONSECUTIVE_GATEWAY_FAILURE",
	2: "SUCCESS_RATE",
}

var OutlierEjectionType_value = map[string]int32{
	"CONSECUTIVE_5XX":             0,
	"CONSECUTIVE_GATEWAY_FAILURE": 1,
	"SUCCESS_RATE":                2,
}

func (x OutlierEjectionType) String() string {
	return proto.EnumName(OutlierEjectionType_name, int32(x))
}

func (OutlierEjectionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5e03c92c55863094, []int{0}
}

// Represents possible action applied to upstream host
type Action int32

const (
	// In case host was excluded from service
	Action_EJECT Action = 0
	// In case host was brought back into service
	Action_UNEJECT Action = 1
)

var Action_name = map[int32]string{
	0: "EJECT",
	1: "UNEJECT",
}

var Action_value = map[string]int32{
	"EJECT":   0,
	"UNEJECT": 1,
}

func (x Action) String() string {
	return proto.EnumName(Action_name, int32(x))
}

func (Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5e03c92c55863094, []int{1}
}

type OutlierDetectionEvent struct {
	// In case of eject represents type of ejection that took place.
	Type OutlierEjectionType `protobuf:"varint,1,opt,name=type,proto3,enum=envoy.data.cluster.v2alpha.OutlierEjectionType" json:"type,omitempty"`
	// Timestamp for event.
	Timestamp *time.Time `protobuf:"bytes,2,opt,name=timestamp,proto3,stdtime" json:"timestamp,omitempty"`
	// The time in seconds since the last action (either an ejection or unejection) took place.
	SecsSinceLastAction *types.UInt64Value `protobuf:"bytes,3,opt,name=secs_since_last_action,json=secsSinceLastAction,proto3" json:"secs_since_last_action,omitempty"`
	// The :ref:`cluster <envoy_api_msg_Cluster>` that owns the ejected host.
	ClusterName string `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// The URL of the ejected host. E.g., ``tcp://1.2.3.4:80``.
	UpstreamUrl string `protobuf:"bytes,5,opt,name=upstream_url,json=upstreamUrl,proto3" json:"upstream_url,omitempty"`
	// The action that took place.
	Action Action `protobuf:"varint,6,opt,name=action,proto3,enum=envoy.data.cluster.v2alpha.Action" json:"action,omitempty"`
	// If ``action`` is ``eject``, specifies the number of times the host has been ejected (local to
	// that Envoy and gets reset if the host gets removed from the upstream cluster for any reason and
	// then re-added).
	NumEjections uint32 `protobuf:"varint,7,opt,name=num_ejections,json=numEjections,proto3" json:"num_ejections,omitempty"`
	// If ``action`` is ``eject``, specifies if the ejection was enforced. ``true`` means the host was
	// ejected. ``false`` means the event was logged but the host was not actually ejected.
	Enforced bool `protobuf:"varint,8,opt,name=enforced,proto3" json:"enforced,omitempty"`
	// Types that are valid to be assigned to Event:
	//	*OutlierDetectionEvent_EjectSuccessRateEvent
	//	*OutlierDetectionEvent_EjectConsecutiveEvent
	Event                isOutlierDetectionEvent_Event `protobuf_oneof:"event"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *OutlierDetectionEvent) Reset()         { *m = OutlierDetectionEvent{} }
func (m *OutlierDetectionEvent) String() string { return proto.CompactTextString(m) }
func (*OutlierDetectionEvent) ProtoMessage()    {}
func (*OutlierDetectionEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e03c92c55863094, []int{0}
}
func (m *OutlierDetectionEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutlierDetectionEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutlierDetectionEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutlierDetectionEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutlierDetectionEvent.Merge(m, src)
}
func (m *OutlierDetectionEvent) XXX_Size() int {
	return m.Size()
}
func (m *OutlierDetectionEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_OutlierDetectionEvent.DiscardUnknown(m)
}

var xxx_messageInfo_OutlierDetectionEvent proto.InternalMessageInfo

type isOutlierDetectionEvent_Event interface {
	isOutlierDetectionEvent_Event()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type OutlierDetectionEvent_EjectSuccessRateEvent struct {
	EjectSuccessRateEvent *OutlierEjectSuccessRate `protobuf:"bytes,9,opt,name=eject_success_rate_event,json=ejectSuccessRateEvent,proto3,oneof"`
}
type OutlierDetectionEvent_EjectConsecutiveEvent struct {
	EjectConsecutiveEvent *OutlierEjectConsecutive `protobuf:"bytes,10,opt,name=eject_consecutive_event,json=ejectConsecutiveEvent,proto3,oneof"`
}

func (*OutlierDetectionEvent_EjectSuccessRateEvent) isOutlierDetectionEvent_Event() {}
func (*OutlierDetectionEvent_EjectConsecutiveEvent) isOutlierDetectionEvent_Event() {}

func (m *OutlierDetectionEvent) GetEvent() isOutlierDetectionEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *OutlierDetectionEvent) GetType() OutlierEjectionType {
	if m != nil {
		return m.Type
	}
	return OutlierEjectionType_CONSECUTIVE_5XX
}

func (m *OutlierDetectionEvent) GetTimestamp() *time.Time {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *OutlierDetectionEvent) GetSecsSinceLastAction() *types.UInt64Value {
	if m != nil {
		return m.SecsSinceLastAction
	}
	return nil
}

func (m *OutlierDetectionEvent) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *OutlierDetectionEvent) GetUpstreamUrl() string {
	if m != nil {
		return m.UpstreamUrl
	}
	return ""
}

func (m *OutlierDetectionEvent) GetAction() Action {
	if m != nil {
		return m.Action
	}
	return Action_EJECT
}

func (m *OutlierDetectionEvent) GetNumEjections() uint32 {
	if m != nil {
		return m.NumEjections
	}
	return 0
}

func (m *OutlierDetectionEvent) GetEnforced() bool {
	if m != nil {
		return m.Enforced
	}
	return false
}

func (m *OutlierDetectionEvent) GetEjectSuccessRateEvent() *OutlierEjectSuccessRate {
	if x, ok := m.GetEvent().(*OutlierDetectionEvent_EjectSuccessRateEvent); ok {
		return x.EjectSuccessRateEvent
	}
	return nil
}

func (m *OutlierDetectionEvent) GetEjectConsecutiveEvent() *OutlierEjectConsecutive {
	if x, ok := m.GetEvent().(*OutlierDetectionEvent_EjectConsecutiveEvent); ok {
		return x.EjectConsecutiveEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OutlierDetectionEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OutlierDetectionEvent_OneofMarshaler, _OutlierDetectionEvent_OneofUnmarshaler, _OutlierDetectionEvent_OneofSizer, []interface{}{
		(*OutlierDetectionEvent_EjectSuccessRateEvent)(nil),
		(*OutlierDetectionEvent_EjectConsecutiveEvent)(nil),
	}
}

func _OutlierDetectionEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OutlierDetectionEvent)
	// event
	switch x := m.Event.(type) {
	case *OutlierDetectionEvent_EjectSuccessRateEvent:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EjectSuccessRateEvent); err != nil {
			return err
		}
	case *OutlierDetectionEvent_EjectConsecutiveEvent:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EjectConsecutiveEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OutlierDetectionEvent.Event has unexpected type %T", x)
	}
	return nil
}

func _OutlierDetectionEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OutlierDetectionEvent)
	switch tag {
	case 9: // event.eject_success_rate_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OutlierEjectSuccessRate)
		err := b.DecodeMessage(msg)
		m.Event = &OutlierDetectionEvent_EjectSuccessRateEvent{msg}
		return true, err
	case 10: // event.eject_consecutive_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OutlierEjectConsecutive)
		err := b.DecodeMessage(msg)
		m.Event = &OutlierDetectionEvent_EjectConsecutiveEvent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OutlierDetectionEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OutlierDetectionEvent)
	// event
	switch x := m.Event.(type) {
	case *OutlierDetectionEvent_EjectSuccessRateEvent:
		s := proto.Size(x.EjectSuccessRateEvent)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OutlierDetectionEvent_EjectConsecutiveEvent:
		s := proto.Size(x.EjectConsecutiveEvent)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type OutlierEjectSuccessRate struct {
	// Host’s success rate at the time of the ejection event on a 0-100 range.
	HostSuccessRate uint32 `protobuf:"varint,1,opt,name=host_success_rate,json=hostSuccessRate,proto3" json:"host_success_rate,omitempty"`
	// Average success rate of the hosts in the cluster at the time of the ejection event on a 0-100
	// range.
	ClusterAverageSuccessRate uint32 `protobuf:"varint,2,opt,name=cluster_average_success_rate,json=clusterAverageSuccessRate,proto3" json:"cluster_average_success_rate,omitempty"`
	// Success rate ejection threshold at the time of the ejection event.
	ClusterSuccessRateEjectionThreshold uint32   `protobuf:"varint,3,opt,name=cluster_success_rate_ejection_threshold,json=clusterSuccessRateEjectionThreshold,proto3" json:"cluster_success_rate_ejection_threshold,omitempty"`
	XXX_NoUnkeyedLiteral                struct{} `json:"-"`
	XXX_unrecognized                    []byte   `json:"-"`
	XXX_sizecache                       int32    `json:"-"`
}

func (m *OutlierEjectSuccessRate) Reset()         { *m = OutlierEjectSuccessRate{} }
func (m *OutlierEjectSuccessRate) String() string { return proto.CompactTextString(m) }
func (*OutlierEjectSuccessRate) ProtoMessage()    {}
func (*OutlierEjectSuccessRate) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e03c92c55863094, []int{1}
}
func (m *OutlierEjectSuccessRate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutlierEjectSuccessRate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutlierEjectSuccessRate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutlierEjectSuccessRate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutlierEjectSuccessRate.Merge(m, src)
}
func (m *OutlierEjectSuccessRate) XXX_Size() int {
	return m.Size()
}
func (m *OutlierEjectSuccessRate) XXX_DiscardUnknown() {
	xxx_messageInfo_OutlierEjectSuccessRate.DiscardUnknown(m)
}

var xxx_messageInfo_OutlierEjectSuccessRate proto.InternalMessageInfo

func (m *OutlierEjectSuccessRate) GetHostSuccessRate() uint32 {
	if m != nil {
		return m.HostSuccessRate
	}
	return 0
}

func (m *OutlierEjectSuccessRate) GetClusterAverageSuccessRate() uint32 {
	if m != nil {
		return m.ClusterAverageSuccessRate
	}
	return 0
}

func (m *OutlierEjectSuccessRate) GetClusterSuccessRateEjectionThreshold() uint32 {
	if m != nil {
		return m.ClusterSuccessRateEjectionThreshold
	}
	return 0
}

type OutlierEjectConsecutive struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutlierEjectConsecutive) Reset()         { *m = OutlierEjectConsecutive{} }
func (m *OutlierEjectConsecutive) String() string { return proto.CompactTextString(m) }
func (*OutlierEjectConsecutive) ProtoMessage()    {}
func (*OutlierEjectConsecutive) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e03c92c55863094, []int{2}
}
func (m *OutlierEjectConsecutive) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutlierEjectConsecutive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutlierEjectConsecutive.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutlierEjectConsecutive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutlierEjectConsecutive.Merge(m, src)
}
func (m *OutlierEjectConsecutive) XXX_Size() int {
	return m.Size()
}
func (m *OutlierEjectConsecutive) XXX_DiscardUnknown() {
	xxx_messageInfo_OutlierEjectConsecutive.DiscardUnknown(m)
}

var xxx_messageInfo_OutlierEjectConsecutive proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("envoy.data.cluster.v2alpha.OutlierEjectionType", OutlierEjectionType_name, OutlierEjectionType_value)
	proto.RegisterEnum("envoy.data.cluster.v2alpha.Action", Action_name, Action_value)
	proto.RegisterType((*OutlierDetectionEvent)(nil), "envoy.data.cluster.v2alpha.OutlierDetectionEvent")
	proto.RegisterType((*OutlierEjectSuccessRate)(nil), "envoy.data.cluster.v2alpha.OutlierEjectSuccessRate")
	proto.RegisterType((*OutlierEjectConsecutive)(nil), "envoy.data.cluster.v2alpha.OutlierEjectConsecutive")
}

func init() {
	proto.RegisterFile("envoy/data/cluster/v2alpha/outlier_detection_event.proto", fileDescriptor_5e03c92c55863094)
}

var fileDescriptor_5e03c92c55863094 = []byte{
	// 720 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x4e, 0xdb, 0x4a,
	0x14, 0x66, 0x42, 0x12, 0xc8, 0xf0, 0x97, 0x6b, 0x2e, 0x17, 0x93, 0x8b, 0x42, 0x14, 0x16, 0x8d,
	0x50, 0x65, 0x4b, 0x50, 0xaa, 0xae, 0x2a, 0x25, 0xa9, 0x69, 0x41, 0x08, 0xa8, 0x93, 0x50, 0xba,
	0xa8, 0xac, 0xc1, 0x39, 0x24, 0xa9, 0x6c, 0x8f, 0xe5, 0x19, 0xa7, 0xcd, 0xb6, 0x4f, 0xd0, 0xc7,
	0xe8, 0x23, 0x54, 0x5d, 0xb1, 0xec, 0xae, 0x7d, 0x83, 0x56, 0xd9, 0xf1, 0x10, 0x95, 0x2a, 0x8f,
	0xc7, 0x90, 0xf0, 0xa7, 0x76, 0x37, 0x9e, 0x39, 0xdf, 0x77, 0xbe, 0xf3, 0x9d, 0x73, 0x8c, 0x9f,
	0x80, 0xd7, 0xa7, 0x03, 0xbd, 0x4d, 0x38, 0xd1, 0x6d, 0x27, 0x64, 0x1c, 0x02, 0xbd, 0xbf, 0x49,
	0x1c, 0xbf, 0x4b, 0x74, 0x1a, 0x72, 0xa7, 0x07, 0x81, 0xd5, 0x06, 0x0e, 0x36, 0xef, 0x51, 0xcf,
	0x82, 0x3e, 0x78, 0x5c, 0xf3, 0x03, 0xca, 0xa9, 0x52, 0x10, 0x48, 0x2d, 0x42, 0x6a, 0x12, 0xa9,
	0x49, 0x64, 0x61, 0xad, 0x43, 0x69, 0xc7, 0x01, 0x5d, 0x44, 0x9e, 0x86, 0x67, 0x3a, 0xef, 0xb9,
	0xc0, 0x38, 0x71, 0xfd, 0x18, 0x5c, 0x28, 0x5e, 0x0f, 0x78, 0x17, 0x10, 0xdf, 0x87, 0x80, 0xc9,
	0xf7, 0xe5, 0x3e, 0x71, 0x7a, 0x6d, 0xc2, 0x41, 0x4f, 0x0e, 0xf2, 0xe1, 0xdf, 0x0e, 0xed, 0x50,
	0x71, 0xd4, 0xa3, 0x53, 0x7c, 0x5b, 0xfe, 0x96, 0xc1, 0x4b, 0x87, 0xb1, 0xda, 0x67, 0x89, 0x58,
	0x23, 0xd2, 0xaa, 0x1c, 0xe2, 0x34, 0x1f, 0xf8, 0xa0, 0xa2, 0x12, 0xaa, 0xcc, 0x6f, 0xea, 0xda,
	0xdd, 0xa2, 0x35, 0x49, 0x60, 0xbc, 0x8d, 0xf1, 0xcd, 0x81, 0x0f, 0x35, 0xfc, 0xe5, 0xe2, 0x7c,
	0x32, 0xf3, 0x01, 0xa5, 0xf2, 0xc8, 0x14, 0x44, 0xca, 0x53, 0x9c, 0xbb, 0x2c, 0x46, 0x4d, 0x95,
	0x50, 0x65, 0x66, 0xb3, 0xa0, 0xc5, 0xd5, 0x68, 0x49, 0x35, 0x5a, 0x33, 0x89, 0xa8, 0xa5, 0x3f,
	0xfe, 0x58, 0x43, 0xe6, 0x15, 0x44, 0x79, 0x89, 0xff, 0x63, 0x60, 0x33, 0x8b, 0xf5, 0x3c, 0x1b,
	0x2c, 0x87, 0x30, 0x6e, 0x11, 0x91, 0x4f, 0x9d, 0x14, 0x64, 0xab, 0x37, 0xc8, 0x5a, 0xbb, 0x1e,
	0x7f, 0xfc, 0xe8, 0x98, 0x38, 0x21, 0x98, 0x8b, 0x11, 0xb6, 0x11, 0x41, 0xf7, 0x09, 0xe3, 0x55,
	0x01, 0x54, 0x1e, 0xe2, 0x59, 0x59, 0x8b, 0xe5, 0x11, 0x17, 0xd4, 0x74, 0x09, 0x55, 0x72, 0xb5,
	0x5c, 0x24, 0x3d, 0x1d, 0xa4, 0x4a, 0xc8, 0x9c, 0x91, 0xcf, 0x07, 0xc4, 0x85, 0x28, 0x3a, 0xf4,
	0x19, 0x0f, 0x80, 0xb8, 0x56, 0x18, 0x38, 0x6a, 0xe6, 0x46, 0x74, 0xf2, 0xdc, 0x0a, 0x1c, 0x65,
	0x07, 0x67, 0xa5, 0xbc, 0xac, 0x70, 0xb0, 0x7c, 0x9f, 0x83, 0xb1, 0x9e, 0x31, 0xd3, 0x24, 0x5a,
	0x59, 0xc7, 0x73, 0x5e, 0xe8, 0x5a, 0x20, 0xcd, 0x65, 0xea, 0x54, 0x09, 0x55, 0xe6, 0xcc, 0x59,
	0x2f, 0x74, 0x13, 0xc3, 0x99, 0x52, 0xc0, 0xd3, 0xe0, 0x9d, 0xd1, 0xc0, 0x86, 0xb6, 0x3a, 0x5d,
	0x42, 0x95, 0x69, 0xf3, 0xf2, 0x5b, 0xf1, 0xb0, 0x2a, 0xc0, 0x16, 0x0b, 0x6d, 0x1b, 0x18, 0xb3,
	0x02, 0xc2, 0x21, 0x1e, 0x48, 0x35, 0x27, 0x9c, 0xdb, 0xfa, 0xd3, 0xe6, 0x36, 0x62, 0x06, 0x93,
	0x70, 0x78, 0x31, 0x61, 0x2e, 0xc1, 0xb5, 0xbb, 0x78, 0x70, 0x5c, 0xbc, 0x1c, 0xe7, 0xb3, 0xa9,
	0xc7, 0xc0, 0x0e, 0x79, 0xaf, 0x9f, 0xa4, 0xc3, 0x7f, 0x97, 0xae, 0x7e, 0x45, 0x70, 0x99, 0x6e,
	0xe4, 0x4e, 0xa4, 0xab, 0xcd, 0xe3, 0x8c, 0x20, 0x57, 0x32, 0x9f, 0x2f, 0xce, 0x27, 0x51, 0xf9,
	0x17, 0xc2, 0xcb, 0x77, 0x68, 0x56, 0xb6, 0xf1, 0x3f, 0x5d, 0xca, 0xc6, 0x9d, 0x10, 0x03, 0x3e,
	0x27, 0xdb, 0xb8, 0x91, 0x52, 0xdb, 0xe6, 0x42, 0x14, 0x33, 0x0a, 0xdb, 0xc3, 0xab, 0xc9, 0x98,
	0x90, 0x3e, 0x04, 0xa4, 0x03, 0xe3, 0x0c, 0xa9, 0xeb, 0x0c, 0x2b, 0x32, 0xbc, 0x1a, 0x47, 0x8f,
	0x72, 0x59, 0xf8, 0x41, 0xc2, 0x35, 0xde, 0x0f, 0xd9, 0x4b, 0x8b, 0x77, 0x03, 0x60, 0x5d, 0xea,
	0xb4, 0xc5, 0x58, 0x8f, 0xd1, 0xae, 0x4b, 0xe4, 0xa8, 0xe5, 0xc9, 0xce, 0x25, 0xa8, 0xf2, 0xca,
	0x78, 0xf9, 0x23, 0x7e, 0x6d, 0xbc, 0xc1, 0x8b, 0xb7, 0xac, 0xaa, 0xb2, 0x88, 0x17, 0xea, 0x87,
	0x07, 0x0d, 0xa3, 0xde, 0x6a, 0xee, 0x1e, 0x1b, 0xd6, 0xf6, 0xc9, 0x49, 0x7e, 0x42, 0x59, 0xc3,
	0xff, 0x8f, 0x5e, 0x3e, 0xaf, 0x36, 0x8d, 0x57, 0xd5, 0xd7, 0xd6, 0x4e, 0x75, 0x77, 0xbf, 0x65,
	0x1a, 0x79, 0xa4, 0xe4, 0xf1, 0x6c, 0xa3, 0x55, 0xaf, 0x1b, 0x8d, 0x86, 0x65, 0x56, 0x9b, 0x46,
	0x3e, 0xb5, 0x51, 0xc2, 0x59, 0xb9, 0x57, 0x39, 0x9c, 0x31, 0xf6, 0x8c, 0x7a, 0x33, 0x3f, 0xa1,
	0xcc, 0xe0, 0xa9, 0xd6, 0x41, 0xfc, 0x81, 0x6a, 0x27, 0x9f, 0x86, 0x45, 0xf4, 0x75, 0x58, 0x44,
	0xdf, 0x87, 0x45, 0xf4, 0x73, 0x58, 0x44, 0xb8, 0xd2, 0xa3, 0xf1, 0x34, 0xf8, 0x01, 0x7d, 0x3f,
	0xb8, 0x67, 0x30, 0x6a, 0x85, 0x5b, 0x7f, 0x53, 0x47, 0xd1, 0xae, 0x1f, 0xa1, 0xd3, 0xac, 0x58,
	0xfa, 0xad, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x1f, 0x09, 0x67, 0xf2, 0x96, 0x05, 0x00, 0x00,
}

func (this *OutlierDetectionEvent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutlierDetectionEvent)
	if !ok {
		that2, ok := that.(OutlierDetectionEvent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if that1.Timestamp == nil {
		if this.Timestamp != nil {
			return false
		}
	} else if !this.Timestamp.Equal(*that1.Timestamp) {
		return false
	}
	if !this.SecsSinceLastAction.Equal(that1.SecsSinceLastAction) {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.UpstreamUrl != that1.UpstreamUrl {
		return false
	}
	if this.Action != that1.Action {
		return false
	}
	if this.NumEjections != that1.NumEjections {
		return false
	}
	if this.Enforced != that1.Enforced {
		return false
	}
	if that1.Event == nil {
		if this.Event != nil {
			return false
		}
	} else if this.Event == nil {
		return false
	} else if !this.Event.Equal(that1.Event) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *OutlierDetectionEvent_EjectSuccessRateEvent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutlierDetectionEvent_EjectSuccessRateEvent)
	if !ok {
		that2, ok := that.(OutlierDetectionEvent_EjectSuccessRateEvent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EjectSuccessRateEvent.Equal(that1.EjectSuccessRateEvent) {
		return false
	}
	return true
}
func (this *OutlierDetectionEvent_EjectConsecutiveEvent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutlierDetectionEvent_EjectConsecutiveEvent)
	if !ok {
		that2, ok := that.(OutlierDetectionEvent_EjectConsecutiveEvent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EjectConsecutiveEvent.Equal(that1.EjectConsecutiveEvent) {
		return false
	}
	return true
}
func (this *OutlierEjectSuccessRate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutlierEjectSuccessRate)
	if !ok {
		that2, ok := that.(OutlierEjectSuccessRate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostSuccessRate != that1.HostSuccessRate {
		return false
	}
	if this.ClusterAverageSuccessRate != that1.ClusterAverageSuccessRate {
		return false
	}
	if this.ClusterSuccessRateEjectionThreshold != that1.ClusterSuccessRateEjectionThreshold {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *OutlierEjectConsecutive) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutlierEjectConsecutive)
	if !ok {
		that2, ok := that.(OutlierEjectConsecutive)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *OutlierDetectionEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierDetectionEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.Type))
	}
	if m.Timestamp != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(*m.Timestamp)))
		n1, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.Timestamp, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.SecsSinceLastAction != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.SecsSinceLastAction.Size()))
		n2, err := m.SecsSinceLastAction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.UpstreamUrl) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(len(m.UpstreamUrl)))
		i += copy(dAtA[i:], m.UpstreamUrl)
	}
	if m.Action != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.Action))
	}
	if m.NumEjections != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.NumEjections))
	}
	if m.Enforced {
		dAtA[i] = 0x40
		i++
		if m.Enforced {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Event != nil {
		nn3, err := m.Event.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OutlierDetectionEvent_EjectSuccessRateEvent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EjectSuccessRateEvent != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.EjectSuccessRateEvent.Size()))
		n4, err := m.EjectSuccessRateEvent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *OutlierDetectionEvent_EjectConsecutiveEvent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EjectConsecutiveEvent != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.EjectConsecutiveEvent.Size()))
		n5, err := m.EjectConsecutiveEvent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *OutlierEjectSuccessRate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierEjectSuccessRate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HostSuccessRate != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.HostSuccessRate))
	}
	if m.ClusterAverageSuccessRate != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.ClusterAverageSuccessRate))
	}
	if m.ClusterSuccessRateEjectionThreshold != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintOutlierDetectionEvent(dAtA, i, uint64(m.ClusterSuccessRateEjectionThreshold))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OutlierEjectConsecutive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierEjectConsecutive) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintOutlierDetectionEvent(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *OutlierDetectionEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovOutlierDetectionEvent(uint64(m.Type))
	}
	if m.Timestamp != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.Timestamp)
		n += 1 + l + sovOutlierDetectionEvent(uint64(l))
	}
	if m.SecsSinceLastAction != nil {
		l = m.SecsSinceLastAction.Size()
		n += 1 + l + sovOutlierDetectionEvent(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovOutlierDetectionEvent(uint64(l))
	}
	l = len(m.UpstreamUrl)
	if l > 0 {
		n += 1 + l + sovOutlierDetectionEvent(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovOutlierDetectionEvent(uint64(m.Action))
	}
	if m.NumEjections != 0 {
		n += 1 + sovOutlierDetectionEvent(uint64(m.NumEjections))
	}
	if m.Enforced {
		n += 2
	}
	if m.Event != nil {
		n += m.Event.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutlierDetectionEvent_EjectSuccessRateEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EjectSuccessRateEvent != nil {
		l = m.EjectSuccessRateEvent.Size()
		n += 1 + l + sovOutlierDetectionEvent(uint64(l))
	}
	return n
}
func (m *OutlierDetectionEvent_EjectConsecutiveEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EjectConsecutiveEvent != nil {
		l = m.EjectConsecutiveEvent.Size()
		n += 1 + l + sovOutlierDetectionEvent(uint64(l))
	}
	return n
}
func (m *OutlierEjectSuccessRate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HostSuccessRate != 0 {
		n += 1 + sovOutlierDetectionEvent(uint64(m.HostSuccessRate))
	}
	if m.ClusterAverageSuccessRate != 0 {
		n += 1 + sovOutlierDetectionEvent(uint64(m.ClusterAverageSuccessRate))
	}
	if m.ClusterSuccessRateEjectionThreshold != 0 {
		n += 1 + sovOutlierDetectionEvent(uint64(m.ClusterSuccessRateEjectionThreshold))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutlierEjectConsecutive) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovOutlierDetectionEvent(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozOutlierDetectionEvent(x uint64) (n int) {
	return sovOutlierDetectionEvent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *OutlierDetectionEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOutlierDetectionEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierDetectionEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierDetectionEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= OutlierEjectionType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecsSinceLastAction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecsSinceLastAction == nil {
				m.SecsSinceLastAction = &types.UInt64Value{}
			}
			if err := m.SecsSinceLastAction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpstreamUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= Action(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumEjections", wireType)
			}
			m.NumEjections = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumEjections |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enforced", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enforced = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EjectSuccessRateEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OutlierEjectSuccessRate{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Event = &OutlierDetectionEvent_EjectSuccessRateEvent{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EjectConsecutiveEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OutlierEjectConsecutive{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Event = &OutlierDetectionEvent_EjectConsecutiveEvent{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOutlierDetectionEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutlierEjectSuccessRate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOutlierDetectionEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierEjectSuccessRate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierEjectSuccessRate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostSuccessRate", wireType)
			}
			m.HostSuccessRate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HostSuccessRate |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterAverageSuccessRate", wireType)
			}
			m.ClusterAverageSuccessRate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterAverageSuccessRate |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterSuccessRateEjectionThreshold", wireType)
			}
			m.ClusterSuccessRateEjectionThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterSuccessRateEjectionThreshold |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOutlierDetectionEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutlierEjectConsecutive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOutlierDetectionEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierEjectConsecutive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierEjectConsecutive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOutlierDetectionEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthOutlierDetectionEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipOutlierDetectionEvent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowOutlierDetectionEvent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOutlierDetectionEvent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthOutlierDetectionEvent
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthOutlierDetectionEvent
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowOutlierDetectionEvent
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipOutlierDetectionEvent(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthOutlierDetectionEvent
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthOutlierDetectionEvent = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowOutlierDetectionEvent   = fmt.Errorf("proto: integer overflow")
)
