// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

package admin // import "google.golang.org/genproto/googleapis/bigtable/admin/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CreateTable][google.bigtable.admin.v2.BigtableTableAdmin.CreateTable]
type CreateTableRequest struct {
	// The unique name of the instance in which to create the table.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The name by which the new table should be referred to within the parent
	// instance, e.g., `foobar` rather than `<parent>/tables/foobar`.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// The Table to create.
	Table *Table `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// The optional list of row keys that will be used to initially split the
	// table into several tablets (tablets are similar to HBase regions).
	// Given two split keys, `s1` and `s2`, three tablets will be created,
	// spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
	//
	// Example:
	//
	// * Row keys := `["a", "apple", "custom", "customer_1", "customer_2",`
	//                `"other", "zz"]`
	// * initial_split_keys := `["apple", "customer_1", "customer_2", "other"]`
	// * Key assignment:
	//     - Tablet 1 `[, apple)                => {"a"}.`
	//     - Tablet 2 `[apple, customer_1)      => {"apple", "custom"}.`
	//     - Tablet 3 `[customer_1, customer_2) => {"customer_1"}.`
	//     - Tablet 4 `[customer_2, other)      => {"customer_2"}.`
	//     - Tablet 5 `[other, )                => {"other", "zz"}.`
	InitialSplits        []*CreateTableRequest_Split `protobuf:"bytes,4,rep,name=initial_splits,json=initialSplits,proto3" json:"initial_splits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *CreateTableRequest) Reset()         { *m = CreateTableRequest{} }
func (m *CreateTableRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTableRequest) ProtoMessage()    {}
func (*CreateTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{0}
}
func (m *CreateTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableRequest.Unmarshal(m, b)
}
func (m *CreateTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableRequest.Marshal(b, m, deterministic)
}
func (dst *CreateTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableRequest.Merge(dst, src)
}
func (m *CreateTableRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTableRequest.Size(m)
}
func (m *CreateTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableRequest proto.InternalMessageInfo

func (m *CreateTableRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTableRequest) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

func (m *CreateTableRequest) GetTable() *Table {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *CreateTableRequest) GetInitialSplits() []*CreateTableRequest_Split {
	if m != nil {
		return m.InitialSplits
	}
	return nil
}

// An initial split point for a newly created table.
type CreateTableRequest_Split struct {
	// Row key to use as an initial tablet boundary.
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTableRequest_Split) Reset()         { *m = CreateTableRequest_Split{} }
func (m *CreateTableRequest_Split) String() string { return proto.CompactTextString(m) }
func (*CreateTableRequest_Split) ProtoMessage()    {}
func (*CreateTableRequest_Split) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{0, 0}
}
func (m *CreateTableRequest_Split) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableRequest_Split.Unmarshal(m, b)
}
func (m *CreateTableRequest_Split) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableRequest_Split.Marshal(b, m, deterministic)
}
func (dst *CreateTableRequest_Split) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableRequest_Split.Merge(dst, src)
}
func (m *CreateTableRequest_Split) XXX_Size() int {
	return xxx_messageInfo_CreateTableRequest_Split.Size(m)
}
func (m *CreateTableRequest_Split) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableRequest_Split.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableRequest_Split proto.InternalMessageInfo

func (m *CreateTableRequest_Split) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type CreateTableFromSnapshotRequest struct {
	// The unique name of the instance in which to create the table.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The name by which the new table should be referred to within the parent
	// instance, e.g., `foobar` rather than `<parent>/tables/foobar`.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// The unique name of the snapshot from which to restore the table. The
	// snapshot and the table must be in the same instance.
	// Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>/snapshots/<snapshot>`.
	SourceSnapshot       string   `protobuf:"bytes,3,opt,name=source_snapshot,json=sourceSnapshot,proto3" json:"source_snapshot,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTableFromSnapshotRequest) Reset()         { *m = CreateTableFromSnapshotRequest{} }
func (m *CreateTableFromSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTableFromSnapshotRequest) ProtoMessage()    {}
func (*CreateTableFromSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{1}
}
func (m *CreateTableFromSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableFromSnapshotRequest.Unmarshal(m, b)
}
func (m *CreateTableFromSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableFromSnapshotRequest.Marshal(b, m, deterministic)
}
func (dst *CreateTableFromSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableFromSnapshotRequest.Merge(dst, src)
}
func (m *CreateTableFromSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTableFromSnapshotRequest.Size(m)
}
func (m *CreateTableFromSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableFromSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableFromSnapshotRequest proto.InternalMessageInfo

func (m *CreateTableFromSnapshotRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTableFromSnapshotRequest) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

func (m *CreateTableFromSnapshotRequest) GetSourceSnapshot() string {
	if m != nil {
		return m.SourceSnapshot
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange][google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange]
type DropRowRangeRequest struct {
	// The unique name of the table on which to drop a range of rows.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Delete all rows or by prefix.
	//
	// Types that are valid to be assigned to Target:
	//	*DropRowRangeRequest_RowKeyPrefix
	//	*DropRowRangeRequest_DeleteAllDataFromTable
	Target               isDropRowRangeRequest_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *DropRowRangeRequest) Reset()         { *m = DropRowRangeRequest{} }
func (m *DropRowRangeRequest) String() string { return proto.CompactTextString(m) }
func (*DropRowRangeRequest) ProtoMessage()    {}
func (*DropRowRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{2}
}
func (m *DropRowRangeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DropRowRangeRequest.Unmarshal(m, b)
}
func (m *DropRowRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DropRowRangeRequest.Marshal(b, m, deterministic)
}
func (dst *DropRowRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DropRowRangeRequest.Merge(dst, src)
}
func (m *DropRowRangeRequest) XXX_Size() int {
	return xxx_messageInfo_DropRowRangeRequest.Size(m)
}
func (m *DropRowRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DropRowRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DropRowRangeRequest proto.InternalMessageInfo

func (m *DropRowRangeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isDropRowRangeRequest_Target interface {
	isDropRowRangeRequest_Target()
}

type DropRowRangeRequest_RowKeyPrefix struct {
	RowKeyPrefix []byte `protobuf:"bytes,2,opt,name=row_key_prefix,json=rowKeyPrefix,proto3,oneof"`
}

type DropRowRangeRequest_DeleteAllDataFromTable struct {
	DeleteAllDataFromTable bool `protobuf:"varint,3,opt,name=delete_all_data_from_table,json=deleteAllDataFromTable,proto3,oneof"`
}

func (*DropRowRangeRequest_RowKeyPrefix) isDropRowRangeRequest_Target() {}

func (*DropRowRangeRequest_DeleteAllDataFromTable) isDropRowRangeRequest_Target() {}

func (m *DropRowRangeRequest) GetTarget() isDropRowRangeRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *DropRowRangeRequest) GetRowKeyPrefix() []byte {
	if x, ok := m.GetTarget().(*DropRowRangeRequest_RowKeyPrefix); ok {
		return x.RowKeyPrefix
	}
	return nil
}

func (m *DropRowRangeRequest) GetDeleteAllDataFromTable() bool {
	if x, ok := m.GetTarget().(*DropRowRangeRequest_DeleteAllDataFromTable); ok {
		return x.DeleteAllDataFromTable
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DropRowRangeRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DropRowRangeRequest_OneofMarshaler, _DropRowRangeRequest_OneofUnmarshaler, _DropRowRangeRequest_OneofSizer, []interface{}{
		(*DropRowRangeRequest_RowKeyPrefix)(nil),
		(*DropRowRangeRequest_DeleteAllDataFromTable)(nil),
	}
}

func _DropRowRangeRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DropRowRangeRequest)
	// target
	switch x := m.Target.(type) {
	case *DropRowRangeRequest_RowKeyPrefix:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKeyPrefix)
	case *DropRowRangeRequest_DeleteAllDataFromTable:
		t := uint64(0)
		if x.DeleteAllDataFromTable {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("DropRowRangeRequest.Target has unexpected type %T", x)
	}
	return nil
}

func _DropRowRangeRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DropRowRangeRequest)
	switch tag {
	case 2: // target.row_key_prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Target = &DropRowRangeRequest_RowKeyPrefix{x}
		return true, err
	case 3: // target.delete_all_data_from_table
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Target = &DropRowRangeRequest_DeleteAllDataFromTable{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _DropRowRangeRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DropRowRangeRequest)
	// target
	switch x := m.Target.(type) {
	case *DropRowRangeRequest_RowKeyPrefix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.RowKeyPrefix)))
		n += len(x.RowKeyPrefix)
	case *DropRowRangeRequest_DeleteAllDataFromTable:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListTables][google.bigtable.admin.v2.BigtableTableAdmin.ListTables]
type ListTablesRequest struct {
	// The unique name of the instance for which tables should be listed.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The view to be applied to the returned tables' fields.
	// Defaults to `NAME_ONLY` if unspecified; no others are currently supported.
	View Table_View `protobuf:"varint,2,opt,name=view,proto3,enum=google.bigtable.admin.v2.Table_View" json:"view,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTablesRequest) Reset()         { *m = ListTablesRequest{} }
func (m *ListTablesRequest) String() string { return proto.CompactTextString(m) }
func (*ListTablesRequest) ProtoMessage()    {}
func (*ListTablesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{3}
}
func (m *ListTablesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTablesRequest.Unmarshal(m, b)
}
func (m *ListTablesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTablesRequest.Marshal(b, m, deterministic)
}
func (dst *ListTablesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTablesRequest.Merge(dst, src)
}
func (m *ListTablesRequest) XXX_Size() int {
	return xxx_messageInfo_ListTablesRequest.Size(m)
}
func (m *ListTablesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTablesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTablesRequest proto.InternalMessageInfo

func (m *ListTablesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTablesRequest) GetView() Table_View {
	if m != nil {
		return m.View
	}
	return Table_VIEW_UNSPECIFIED
}

func (m *ListTablesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListTables][google.bigtable.admin.v2.BigtableTableAdmin.ListTables]
type ListTablesResponse struct {
	// The tables present in the requested instance.
	Tables []*Table `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty"`
	// Set if not all tables could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTablesResponse) Reset()         { *m = ListTablesResponse{} }
func (m *ListTablesResponse) String() string { return proto.CompactTextString(m) }
func (*ListTablesResponse) ProtoMessage()    {}
func (*ListTablesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{4}
}
func (m *ListTablesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTablesResponse.Unmarshal(m, b)
}
func (m *ListTablesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTablesResponse.Marshal(b, m, deterministic)
}
func (dst *ListTablesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTablesResponse.Merge(dst, src)
}
func (m *ListTablesResponse) XXX_Size() int {
	return xxx_messageInfo_ListTablesResponse.Size(m)
}
func (m *ListTablesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTablesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTablesResponse proto.InternalMessageInfo

func (m *ListTablesResponse) GetTables() []*Table {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *ListTablesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetTable][google.bigtable.admin.v2.BigtableTableAdmin.GetTable]
type GetTableRequest struct {
	// The unique name of the requested table.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The view to be applied to the returned table's fields.
	// Defaults to `SCHEMA_VIEW` if unspecified.
	View                 Table_View `protobuf:"varint,2,opt,name=view,proto3,enum=google.bigtable.admin.v2.Table_View" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetTableRequest) Reset()         { *m = GetTableRequest{} }
func (m *GetTableRequest) String() string { return proto.CompactTextString(m) }
func (*GetTableRequest) ProtoMessage()    {}
func (*GetTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{5}
}
func (m *GetTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTableRequest.Unmarshal(m, b)
}
func (m *GetTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTableRequest.Marshal(b, m, deterministic)
}
func (dst *GetTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTableRequest.Merge(dst, src)
}
func (m *GetTableRequest) XXX_Size() int {
	return xxx_messageInfo_GetTableRequest.Size(m)
}
func (m *GetTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTableRequest proto.InternalMessageInfo

func (m *GetTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetTableRequest) GetView() Table_View {
	if m != nil {
		return m.View
	}
	return Table_VIEW_UNSPECIFIED
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable][google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable]
type DeleteTableRequest struct {
	// The unique name of the table to be deleted.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTableRequest) Reset()         { *m = DeleteTableRequest{} }
func (m *DeleteTableRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTableRequest) ProtoMessage()    {}
func (*DeleteTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{6}
}
func (m *DeleteTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTableRequest.Unmarshal(m, b)
}
func (m *DeleteTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTableRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTableRequest.Merge(dst, src)
}
func (m *DeleteTableRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTableRequest.Size(m)
}
func (m *DeleteTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTableRequest proto.InternalMessageInfo

func (m *DeleteTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies][google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies]
type ModifyColumnFamiliesRequest struct {
	// The unique name of the table whose families should be modified.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Modifications to be atomically applied to the specified table's families.
	// Entries are applied in order, meaning that earlier modifications can be
	// masked by later ones (in the case of repeated updates to the same family,
	// for example).
	Modifications        []*ModifyColumnFamiliesRequest_Modification `protobuf:"bytes,2,rep,name=modifications,proto3" json:"modifications,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ModifyColumnFamiliesRequest) Reset()         { *m = ModifyColumnFamiliesRequest{} }
func (m *ModifyColumnFamiliesRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyColumnFamiliesRequest) ProtoMessage()    {}
func (*ModifyColumnFamiliesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{7}
}
func (m *ModifyColumnFamiliesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyColumnFamiliesRequest.Unmarshal(m, b)
}
func (m *ModifyColumnFamiliesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyColumnFamiliesRequest.Marshal(b, m, deterministic)
}
func (dst *ModifyColumnFamiliesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyColumnFamiliesRequest.Merge(dst, src)
}
func (m *ModifyColumnFamiliesRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyColumnFamiliesRequest.Size(m)
}
func (m *ModifyColumnFamiliesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyColumnFamiliesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyColumnFamiliesRequest proto.InternalMessageInfo

func (m *ModifyColumnFamiliesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifyColumnFamiliesRequest) GetModifications() []*ModifyColumnFamiliesRequest_Modification {
	if m != nil {
		return m.Modifications
	}
	return nil
}

// A create, update, or delete of a particular column family.
type ModifyColumnFamiliesRequest_Modification struct {
	// The ID of the column family to be modified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Column familiy modifications.
	//
	// Types that are valid to be assigned to Mod:
	//	*ModifyColumnFamiliesRequest_Modification_Create
	//	*ModifyColumnFamiliesRequest_Modification_Update
	//	*ModifyColumnFamiliesRequest_Modification_Drop
	Mod                  isModifyColumnFamiliesRequest_Modification_Mod `protobuf_oneof:"mod"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *ModifyColumnFamiliesRequest_Modification) Reset() {
	*m = ModifyColumnFamiliesRequest_Modification{}
}
func (m *ModifyColumnFamiliesRequest_Modification) String() string { return proto.CompactTextString(m) }
func (*ModifyColumnFamiliesRequest_Modification) ProtoMessage()    {}
func (*ModifyColumnFamiliesRequest_Modification) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{7, 0}
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Unmarshal(m, b)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Marshal(b, m, deterministic)
}
func (dst *ModifyColumnFamiliesRequest_Modification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Merge(dst, src)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_Size() int {
	return xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Size(m)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyColumnFamiliesRequest_Modification proto.InternalMessageInfo

func (m *ModifyColumnFamiliesRequest_Modification) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isModifyColumnFamiliesRequest_Modification_Mod interface {
	isModifyColumnFamiliesRequest_Modification_Mod()
}

type ModifyColumnFamiliesRequest_Modification_Create struct {
	Create *ColumnFamily `protobuf:"bytes,2,opt,name=create,proto3,oneof"`
}

type ModifyColumnFamiliesRequest_Modification_Update struct {
	Update *ColumnFamily `protobuf:"bytes,3,opt,name=update,proto3,oneof"`
}

type ModifyColumnFamiliesRequest_Modification_Drop struct {
	Drop bool `protobuf:"varint,4,opt,name=drop,proto3,oneof"`
}

func (*ModifyColumnFamiliesRequest_Modification_Create) isModifyColumnFamiliesRequest_Modification_Mod() {
}

func (*ModifyColumnFamiliesRequest_Modification_Update) isModifyColumnFamiliesRequest_Modification_Mod() {
}

func (*ModifyColumnFamiliesRequest_Modification_Drop) isModifyColumnFamiliesRequest_Modification_Mod() {
}

func (m *ModifyColumnFamiliesRequest_Modification) GetMod() isModifyColumnFamiliesRequest_Modification_Mod {
	if m != nil {
		return m.Mod
	}
	return nil
}

func (m *ModifyColumnFamiliesRequest_Modification) GetCreate() *ColumnFamily {
	if x, ok := m.GetMod().(*ModifyColumnFamiliesRequest_Modification_Create); ok {
		return x.Create
	}
	return nil
}

func (m *ModifyColumnFamiliesRequest_Modification) GetUpdate() *ColumnFamily {
	if x, ok := m.GetMod().(*ModifyColumnFamiliesRequest_Modification_Update); ok {
		return x.Update
	}
	return nil
}

func (m *ModifyColumnFamiliesRequest_Modification) GetDrop() bool {
	if x, ok := m.GetMod().(*ModifyColumnFamiliesRequest_Modification_Drop); ok {
		return x.Drop
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ModifyColumnFamiliesRequest_Modification) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ModifyColumnFamiliesRequest_Modification_OneofMarshaler, _ModifyColumnFamiliesRequest_Modification_OneofUnmarshaler, _ModifyColumnFamiliesRequest_Modification_OneofSizer, []interface{}{
		(*ModifyColumnFamiliesRequest_Modification_Create)(nil),
		(*ModifyColumnFamiliesRequest_Modification_Update)(nil),
		(*ModifyColumnFamiliesRequest_Modification_Drop)(nil),
	}
}

func _ModifyColumnFamiliesRequest_Modification_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ModifyColumnFamiliesRequest_Modification)
	// mod
	switch x := m.Mod.(type) {
	case *ModifyColumnFamiliesRequest_Modification_Create:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *ModifyColumnFamiliesRequest_Modification_Update:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *ModifyColumnFamiliesRequest_Modification_Drop:
		t := uint64(0)
		if x.Drop {
			t = 1
		}
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("ModifyColumnFamiliesRequest_Modification.Mod has unexpected type %T", x)
	}
	return nil
}

func _ModifyColumnFamiliesRequest_Modification_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ModifyColumnFamiliesRequest_Modification)
	switch tag {
	case 2: // mod.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnFamily)
		err := b.DecodeMessage(msg)
		m.Mod = &ModifyColumnFamiliesRequest_Modification_Create{msg}
		return true, err
	case 3: // mod.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnFamily)
		err := b.DecodeMessage(msg)
		m.Mod = &ModifyColumnFamiliesRequest_Modification_Update{msg}
		return true, err
	case 4: // mod.drop
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Mod = &ModifyColumnFamiliesRequest_Modification_Drop{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _ModifyColumnFamiliesRequest_Modification_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ModifyColumnFamiliesRequest_Modification)
	// mod
	switch x := m.Mod.(type) {
	case *ModifyColumnFamiliesRequest_Modification_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ModifyColumnFamiliesRequest_Modification_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ModifyColumnFamiliesRequest_Modification_Drop:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken][google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken]
type GenerateConsistencyTokenRequest struct {
	// The unique name of the Table for which to create a consistency token.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateConsistencyTokenRequest) Reset()         { *m = GenerateConsistencyTokenRequest{} }
func (m *GenerateConsistencyTokenRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateConsistencyTokenRequest) ProtoMessage()    {}
func (*GenerateConsistencyTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{8}
}
func (m *GenerateConsistencyTokenRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateConsistencyTokenRequest.Unmarshal(m, b)
}
func (m *GenerateConsistencyTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateConsistencyTokenRequest.Marshal(b, m, deterministic)
}
func (dst *GenerateConsistencyTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateConsistencyTokenRequest.Merge(dst, src)
}
func (m *GenerateConsistencyTokenRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateConsistencyTokenRequest.Size(m)
}
func (m *GenerateConsistencyTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateConsistencyTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateConsistencyTokenRequest proto.InternalMessageInfo

func (m *GenerateConsistencyTokenRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken][google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken]
type GenerateConsistencyTokenResponse struct {
	// The generated consistency token.
	ConsistencyToken     string   `protobuf:"bytes,1,opt,name=consistency_token,json=consistencyToken,proto3" json:"consistency_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateConsistencyTokenResponse) Reset()         { *m = GenerateConsistencyTokenResponse{} }
func (m *GenerateConsistencyTokenResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateConsistencyTokenResponse) ProtoMessage()    {}
func (*GenerateConsistencyTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{9}
}
func (m *GenerateConsistencyTokenResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateConsistencyTokenResponse.Unmarshal(m, b)
}
func (m *GenerateConsistencyTokenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateConsistencyTokenResponse.Marshal(b, m, deterministic)
}
func (dst *GenerateConsistencyTokenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateConsistencyTokenResponse.Merge(dst, src)
}
func (m *GenerateConsistencyTokenResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateConsistencyTokenResponse.Size(m)
}
func (m *GenerateConsistencyTokenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateConsistencyTokenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateConsistencyTokenResponse proto.InternalMessageInfo

func (m *GenerateConsistencyTokenResponse) GetConsistencyToken() string {
	if m != nil {
		return m.ConsistencyToken
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
type CheckConsistencyRequest struct {
	// The unique name of the Table for which to check replication consistency.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The token created using GenerateConsistencyToken for the Table.
	ConsistencyToken     string   `protobuf:"bytes,2,opt,name=consistency_token,json=consistencyToken,proto3" json:"consistency_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConsistencyRequest) Reset()         { *m = CheckConsistencyRequest{} }
func (m *CheckConsistencyRequest) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyRequest) ProtoMessage()    {}
func (*CheckConsistencyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{10}
}
func (m *CheckConsistencyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckConsistencyRequest.Unmarshal(m, b)
}
func (m *CheckConsistencyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckConsistencyRequest.Marshal(b, m, deterministic)
}
func (dst *CheckConsistencyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyRequest.Merge(dst, src)
}
func (m *CheckConsistencyRequest) XXX_Size() int {
	return xxx_messageInfo_CheckConsistencyRequest.Size(m)
}
func (m *CheckConsistencyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyRequest proto.InternalMessageInfo

func (m *CheckConsistencyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CheckConsistencyRequest) GetConsistencyToken() string {
	if m != nil {
		return m.ConsistencyToken
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
type CheckConsistencyResponse struct {
	// True only if the token is consistent. A token is consistent if replication
	// has caught up with the restrictions specified in the request.
	Consistent           bool     `protobuf:"varint,1,opt,name=consistent,proto3" json:"consistent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConsistencyResponse) Reset()         { *m = CheckConsistencyResponse{} }
func (m *CheckConsistencyResponse) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyResponse) ProtoMessage()    {}
func (*CheckConsistencyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{11}
}
func (m *CheckConsistencyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckConsistencyResponse.Unmarshal(m, b)
}
func (m *CheckConsistencyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckConsistencyResponse.Marshal(b, m, deterministic)
}
func (dst *CheckConsistencyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyResponse.Merge(dst, src)
}
func (m *CheckConsistencyResponse) XXX_Size() int {
	return xxx_messageInfo_CheckConsistencyResponse.Size(m)
}
func (m *CheckConsistencyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyResponse proto.InternalMessageInfo

func (m *CheckConsistencyResponse) GetConsistent() bool {
	if m != nil {
		return m.Consistent
	}
	return false
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable][google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type SnapshotTableRequest struct {
	// The unique name of the table to have the snapshot taken.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the cluster where the snapshot will be created in.
	// Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>`.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The ID by which the new snapshot should be referred to within the parent
	// cluster, e.g., `mysnapshot` of the form: `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
	// rather than
	// `projects/<project>/instances/<instance>/clusters/<cluster>/snapshots/mysnapshot`.
	SnapshotId string `protobuf:"bytes,3,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// The amount of time that the new snapshot can stay active after it is
	// created. Once 'ttl' expires, the snapshot will get deleted. The maximum
	// amount of time a snapshot can stay active is 7 days. If 'ttl' is not
	// specified, the default value of 24 hours will be used.
	Ttl *duration.Duration `protobuf:"bytes,4,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Description of the snapshot.
	Description          string   `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapshotTableRequest) Reset()         { *m = SnapshotTableRequest{} }
func (m *SnapshotTableRequest) String() string { return proto.CompactTextString(m) }
func (*SnapshotTableRequest) ProtoMessage()    {}
func (*SnapshotTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{12}
}
func (m *SnapshotTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapshotTableRequest.Unmarshal(m, b)
}
func (m *SnapshotTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapshotTableRequest.Marshal(b, m, deterministic)
}
func (dst *SnapshotTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotTableRequest.Merge(dst, src)
}
func (m *SnapshotTableRequest) XXX_Size() int {
	return xxx_messageInfo_SnapshotTableRequest.Size(m)
}
func (m *SnapshotTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotTableRequest proto.InternalMessageInfo

func (m *SnapshotTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SnapshotTableRequest) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *SnapshotTableRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *SnapshotTableRequest) GetTtl() *duration.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func (m *SnapshotTableRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type GetSnapshotRequest struct {
	// The unique name of the requested snapshot.
	// Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>/snapshots/<snapshot>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSnapshotRequest) Reset()         { *m = GetSnapshotRequest{} }
func (m *GetSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*GetSnapshotRequest) ProtoMessage()    {}
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{13}
}
func (m *GetSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSnapshotRequest.Unmarshal(m, b)
}
func (m *GetSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSnapshotRequest.Marshal(b, m, deterministic)
}
func (dst *GetSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSnapshotRequest.Merge(dst, src)
}
func (m *GetSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_GetSnapshotRequest.Size(m)
}
func (m *GetSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSnapshotRequest proto.InternalMessageInfo

func (m *GetSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots][google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type ListSnapshotsRequest struct {
	// The unique name of the cluster for which snapshots should be listed.
	// Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>`.
	// Use `<cluster> = '-'` to list snapshots for all clusters in an instance,
	// e.g., `projects/<project>/instances/<instance>/clusters/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of snapshots to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsRequest) Reset()         { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()    {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{14}
}
func (m *ListSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsRequest.Unmarshal(m, b)
}
func (m *ListSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsRequest.Marshal(b, m, deterministic)
}
func (dst *ListSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsRequest.Merge(dst, src)
}
func (m *ListSnapshotsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsRequest.Size(m)
}
func (m *ListSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsRequest proto.InternalMessageInfo

func (m *ListSnapshotsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSnapshotsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSnapshotsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots][google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type ListSnapshotsResponse struct {
	// The snapshots present in the requested cluster.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// Set if not all snapshots could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsResponse) Reset()         { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()    {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{15}
}
func (m *ListSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsResponse.Unmarshal(m, b)
}
func (m *ListSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsResponse.Marshal(b, m, deterministic)
}
func (dst *ListSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse.Merge(dst, src)
}
func (m *ListSnapshotsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsResponse.Size(m)
}
func (m *ListSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse proto.InternalMessageInfo

func (m *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListSnapshotsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type DeleteSnapshotRequest struct {
	// The unique name of the snapshot to be deleted.
	// Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>/snapshots/<snapshot>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSnapshotRequest) Reset()         { *m = DeleteSnapshotRequest{} }
func (m *DeleteSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotRequest) ProtoMessage()    {}
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{16}
}
func (m *DeleteSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotRequest.Unmarshal(m, b)
}
func (m *DeleteSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotRequest.Merge(dst, src)
}
func (m *DeleteSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotRequest.Size(m)
}
func (m *DeleteSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotRequest proto.InternalMessageInfo

func (m *DeleteSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The metadata for the Operation returned by SnapshotTable.
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type SnapshotTableMetadata struct {
	// The request that prompted the initiation of this SnapshotTable operation.
	OriginalRequest *SnapshotTableRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SnapshotTableMetadata) Reset()         { *m = SnapshotTableMetadata{} }
func (m *SnapshotTableMetadata) String() string { return proto.CompactTextString(m) }
func (*SnapshotTableMetadata) ProtoMessage()    {}
func (*SnapshotTableMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{17}
}
func (m *SnapshotTableMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapshotTableMetadata.Unmarshal(m, b)
}
func (m *SnapshotTableMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapshotTableMetadata.Marshal(b, m, deterministic)
}
func (dst *SnapshotTableMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotTableMetadata.Merge(dst, src)
}
func (m *SnapshotTableMetadata) XXX_Size() int {
	return xxx_messageInfo_SnapshotTableMetadata.Size(m)
}
func (m *SnapshotTableMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotTableMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotTableMetadata proto.InternalMessageInfo

func (m *SnapshotTableMetadata) GetOriginalRequest() *SnapshotTableRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *SnapshotTableMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *SnapshotTableMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by CreateTableFromSnapshot.
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type CreateTableFromSnapshotMetadata struct {
	// The request that prompted the initiation of this CreateTableFromSnapshot
	// operation.
	OriginalRequest *CreateTableFromSnapshotRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateTableFromSnapshotMetadata) Reset()         { *m = CreateTableFromSnapshotMetadata{} }
func (m *CreateTableFromSnapshotMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateTableFromSnapshotMetadata) ProtoMessage()    {}
func (*CreateTableFromSnapshotMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb, []int{18}
}
func (m *CreateTableFromSnapshotMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableFromSnapshotMetadata.Unmarshal(m, b)
}
func (m *CreateTableFromSnapshotMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableFromSnapshotMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateTableFromSnapshotMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableFromSnapshotMetadata.Merge(dst, src)
}
func (m *CreateTableFromSnapshotMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateTableFromSnapshotMetadata.Size(m)
}
func (m *CreateTableFromSnapshotMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableFromSnapshotMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableFromSnapshotMetadata proto.InternalMessageInfo

func (m *CreateTableFromSnapshotMetadata) GetOriginalRequest() *CreateTableFromSnapshotRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateTableFromSnapshotMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateTableFromSnapshotMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateTableRequest)(nil), "google.bigtable.admin.v2.CreateTableRequest")
	proto.RegisterType((*CreateTableRequest_Split)(nil), "google.bigtable.admin.v2.CreateTableRequest.Split")
	proto.RegisterType((*CreateTableFromSnapshotRequest)(nil), "google.bigtable.admin.v2.CreateTableFromSnapshotRequest")
	proto.RegisterType((*DropRowRangeRequest)(nil), "google.bigtable.admin.v2.DropRowRangeRequest")
	proto.RegisterType((*ListTablesRequest)(nil), "google.bigtable.admin.v2.ListTablesRequest")
	proto.RegisterType((*ListTablesResponse)(nil), "google.bigtable.admin.v2.ListTablesResponse")
	proto.RegisterType((*GetTableRequest)(nil), "google.bigtable.admin.v2.GetTableRequest")
	proto.RegisterType((*DeleteTableRequest)(nil), "google.bigtable.admin.v2.DeleteTableRequest")
	proto.RegisterType((*ModifyColumnFamiliesRequest)(nil), "google.bigtable.admin.v2.ModifyColumnFamiliesRequest")
	proto.RegisterType((*ModifyColumnFamiliesRequest_Modification)(nil), "google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification")
	proto.RegisterType((*GenerateConsistencyTokenRequest)(nil), "google.bigtable.admin.v2.GenerateConsistencyTokenRequest")
	proto.RegisterType((*GenerateConsistencyTokenResponse)(nil), "google.bigtable.admin.v2.GenerateConsistencyTokenResponse")
	proto.RegisterType((*CheckConsistencyRequest)(nil), "google.bigtable.admin.v2.CheckConsistencyRequest")
	proto.RegisterType((*CheckConsistencyResponse)(nil), "google.bigtable.admin.v2.CheckConsistencyResponse")
	proto.RegisterType((*SnapshotTableRequest)(nil), "google.bigtable.admin.v2.SnapshotTableRequest")
	proto.RegisterType((*GetSnapshotRequest)(nil), "google.bigtable.admin.v2.GetSnapshotRequest")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "google.bigtable.admin.v2.ListSnapshotsRequest")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "google.bigtable.admin.v2.ListSnapshotsResponse")
	proto.RegisterType((*DeleteSnapshotRequest)(nil), "google.bigtable.admin.v2.DeleteSnapshotRequest")
	proto.RegisterType((*SnapshotTableMetadata)(nil), "google.bigtable.admin.v2.SnapshotTableMetadata")
	proto.RegisterType((*CreateTableFromSnapshotMetadata)(nil), "google.bigtable.admin.v2.CreateTableFromSnapshotMetadata")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BigtableTableAdminClient is the client API for BigtableTableAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigtableTableAdminClient interface {
	// Creates a new table in the specified instance.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Creates a new table from the specified snapshot. The target table must
	// not exist. The snapshot and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	CreateTableFromSnapshot(ctx context.Context, in *CreateTableFromSnapshotRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists all tables served from a specified instance.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Gets metadata information about the specified table.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Performs a series of column family modifications on the specified table.
	// Either all or none of the modifications will occur before this method
	// returns, but data requests received prior to that point may see a table
	// where only some modifications have taken effect.
	ModifyColumnFamilies(ctx context.Context, in *ModifyColumnFamiliesRequest, opts ...grpc.CallOption) (*Table, error)
	// Permanently drop/delete a row range from a specified table. The request can
	// specify whether to delete all rows in a table, or only those that match a
	// particular prefix.
	DropRowRange(ctx context.Context, in *DropRowRangeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Generates a consistency token for a Table, which can be used in
	// CheckConsistency to check whether mutations to the table that finished
	// before this call started have been replicated. The tokens will be available
	// for 90 days.
	GenerateConsistencyToken(ctx context.Context, in *GenerateConsistencyTokenRequest, opts ...grpc.CallOption) (*GenerateConsistencyTokenResponse, error)
	// Checks replication consistency based on a consistency token, that is, if
	// replication has caught up based on the conditions specified in the token
	// and the check request.
	CheckConsistency(ctx context.Context, in *CheckConsistencyRequest, opts ...grpc.CallOption) (*CheckConsistencyResponse, error)
	// Creates a new snapshot in the specified cluster from the specified
	// source table. The cluster and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	SnapshotTable(ctx context.Context, in *SnapshotTableRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets metadata information about the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Lists all snapshots associated with the specified cluster.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Permanently deletes the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type bigtableTableAdminClient struct {
	cc *grpc.ClientConn
}

func NewBigtableTableAdminClient(cc *grpc.ClientConn) BigtableTableAdminClient {
	return &bigtableTableAdminClient{cc}
}

func (c *bigtableTableAdminClient) CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CreateTableFromSnapshot(ctx context.Context, in *CreateTableFromSnapshotRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTableFromSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/ListTables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GetTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ModifyColumnFamilies(ctx context.Context, in *ModifyColumnFamiliesRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/ModifyColumnFamilies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DropRowRange(ctx context.Context, in *DropRowRangeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/DropRowRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GenerateConsistencyToken(ctx context.Context, in *GenerateConsistencyTokenRequest, opts ...grpc.CallOption) (*GenerateConsistencyTokenResponse, error) {
	out := new(GenerateConsistencyTokenResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GenerateConsistencyToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CheckConsistency(ctx context.Context, in *CheckConsistencyRequest, opts ...grpc.CallOption) (*CheckConsistencyResponse, error) {
	out := new(CheckConsistencyResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/CheckConsistency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) SnapshotTable(ctx context.Context, in *SnapshotTableRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/SnapshotTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GetSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/ListSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableTableAdminServer is the server API for BigtableTableAdmin service.
type BigtableTableAdminServer interface {
	// Creates a new table in the specified instance.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(context.Context, *CreateTableRequest) (*Table, error)
	// Creates a new table from the specified snapshot. The target table must
	// not exist. The snapshot and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	CreateTableFromSnapshot(context.Context, *CreateTableFromSnapshotRequest) (*longrunning.Operation, error)
	// Lists all tables served from a specified instance.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Gets metadata information about the specified table.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(context.Context, *DeleteTableRequest) (*empty.Empty, error)
	// Performs a series of column family modifications on the specified table.
	// Either all or none of the modifications will occur before this method
	// returns, but data requests received prior to that point may see a table
	// where only some modifications have taken effect.
	ModifyColumnFamilies(context.Context, *ModifyColumnFamiliesRequest) (*Table, error)
	// Permanently drop/delete a row range from a specified table. The request can
	// specify whether to delete all rows in a table, or only those that match a
	// particular prefix.
	DropRowRange(context.Context, *DropRowRangeRequest) (*empty.Empty, error)
	// Generates a consistency token for a Table, which can be used in
	// CheckConsistency to check whether mutations to the table that finished
	// before this call started have been replicated. The tokens will be available
	// for 90 days.
	GenerateConsistencyToken(context.Context, *GenerateConsistencyTokenRequest) (*GenerateConsistencyTokenResponse, error)
	// Checks replication consistency based on a consistency token, that is, if
	// replication has caught up based on the conditions specified in the token
	// and the check request.
	CheckConsistency(context.Context, *CheckConsistencyRequest) (*CheckConsistencyResponse, error)
	// Creates a new snapshot in the specified cluster from the specified
	// source table. The cluster and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	SnapshotTable(context.Context, *SnapshotTableRequest) (*longrunning.Operation, error)
	// Gets metadata information about the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Lists all snapshots associated with the specified cluster.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Permanently deletes the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*empty.Empty, error)
}

func RegisterBigtableTableAdminServer(s *grpc.Server, srv BigtableTableAdminServer) {
	s.RegisterService(&_BigtableTableAdmin_serviceDesc, srv)
}

func _BigtableTableAdmin_CreateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateTable(ctx, req.(*CreateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CreateTableFromSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableFromSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateTableFromSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTableFromSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateTableFromSnapshot(ctx, req.(*CreateTableFromSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/ListTables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GetTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteTable(ctx, req.(*DeleteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ModifyColumnFamilies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyColumnFamiliesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ModifyColumnFamilies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/ModifyColumnFamilies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ModifyColumnFamilies(ctx, req.(*ModifyColumnFamiliesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DropRowRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropRowRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DropRowRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/DropRowRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DropRowRange(ctx, req.(*DropRowRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GenerateConsistencyToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConsistencyTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GenerateConsistencyToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GenerateConsistencyToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GenerateConsistencyToken(ctx, req.(*GenerateConsistencyTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CheckConsistency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckConsistencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CheckConsistency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/CheckConsistency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CheckConsistency(ctx, req.(*CheckConsistencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_SnapshotTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SnapshotTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).SnapshotTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/SnapshotTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).SnapshotTable(ctx, req.(*SnapshotTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GetSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableTableAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableTableAdmin",
	HandlerType: (*BigtableTableAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTable",
			Handler:    _BigtableTableAdmin_CreateTable_Handler,
		},
		{
			MethodName: "CreateTableFromSnapshot",
			Handler:    _BigtableTableAdmin_CreateTableFromSnapshot_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _BigtableTableAdmin_ListTables_Handler,
		},
		{
			MethodName: "GetTable",
			Handler:    _BigtableTableAdmin_GetTable_Handler,
		},
		{
			MethodName: "DeleteTable",
			Handler:    _BigtableTableAdmin_DeleteTable_Handler,
		},
		{
			MethodName: "ModifyColumnFamilies",
			Handler:    _BigtableTableAdmin_ModifyColumnFamilies_Handler,
		},
		{
			MethodName: "DropRowRange",
			Handler:    _BigtableTableAdmin_DropRowRange_Handler,
		},
		{
			MethodName: "GenerateConsistencyToken",
			Handler:    _BigtableTableAdmin_GenerateConsistencyToken_Handler,
		},
		{
			MethodName: "CheckConsistency",
			Handler:    _BigtableTableAdmin_CheckConsistency_Handler,
		},
		{
			MethodName: "SnapshotTable",
			Handler:    _BigtableTableAdmin_SnapshotTable_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _BigtableTableAdmin_GetSnapshot_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _BigtableTableAdmin_ListSnapshots_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _BigtableTableAdmin_DeleteSnapshot_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_table_admin.proto",
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/bigtable_table_admin.proto", fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb)
}

var fileDescriptor_bigtable_table_admin_ab6bfd213423f2bb = []byte{
	// 1514 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcb, 0x6f, 0xdc, 0x54,
	0x17, 0xaf, 0x27, 0x8f, 0x26, 0x67, 0xf2, 0xea, 0xfd, 0xd2, 0x76, 0x3a, 0x6d, 0x93, 0xc8, 0x5f,
	0x55, 0x42, 0x52, 0xc6, 0x62, 0xaa, 0xa8, 0x21, 0x6d, 0x20, 0x9d, 0x84, 0x26, 0x05, 0x4a, 0x23,
	0xb7, 0xaa, 0xd4, 0x2a, 0x92, 0xe5, 0x8c, 0x6f, 0x9c, 0xdb, 0x78, 0x7c, 0x8d, 0x7d, 0xa7, 0x69,
	0x0a, 0x5d, 0x50, 0x21, 0x21, 0xb1, 0xed, 0xaa, 0x42, 0x42, 0x62, 0xcb, 0x12, 0x21, 0x21, 0x55,
	0x48, 0x88, 0x2d, 0x5b, 0xd6, 0x2c, 0x90, 0x58, 0xb3, 0xe2, 0x0f, 0x40, 0xf7, 0xe1, 0xc4, 0xf3,
	0xf0, 0x78, 0x26, 0x6c, 0xd8, 0x44, 0xbe, 0xe7, 0x9e, 0xc7, 0xef, 0x9c, 0x73, 0xef, 0xb9, 0xbf,
	0x09, 0x5c, 0x75, 0x29, 0x75, 0x3d, 0x6c, 0x6c, 0x13, 0x97, 0xd9, 0xdb, 0x1e, 0x36, 0x6c, 0xa7,
	0x46, 0x7c, 0xe3, 0x49, 0xf9, 0x50, 0x62, 0xc9, 0xbf, 0x42, 0x5e, 0x0a, 0x42, 0xca, 0x28, 0x2a,
	0x48, 0xa3, 0x52, 0xac, 0x52, 0x92, 0x9b, 0x4f, 0xca, 0xc5, 0x0b, 0xca, 0x9d, 0x1d, 0x10, 0xc3,
	0xf6, 0x7d, 0xca, 0x6c, 0x46, 0xa8, 0x1f, 0x49, 0xbb, 0xe2, 0xa5, 0xd4, 0x60, 0xd2, 0x8d, 0xd4,
	0xfa, 0xbf, 0xd2, 0xf2, 0xa8, 0xef, 0x86, 0x75, 0xdf, 0x27, 0xbe, 0x6b, 0xd0, 0x00, 0x87, 0x0d,
	0xae, 0xa6, 0x94, 0x92, 0x58, 0x6d, 0xd7, 0x77, 0x0c, 0xa7, 0x2e, 0x15, 0xd4, 0xfe, 0xf9, 0xe6,
	0x7d, 0x5c, 0x0b, 0xd8, 0x81, 0xda, 0x9c, 0x6e, 0xde, 0x64, 0xa4, 0x86, 0x23, 0x66, 0xd7, 0x02,
	0xa9, 0xa0, 0xff, 0xad, 0x01, 0x5a, 0x0d, 0xb1, 0xcd, 0xf0, 0x7d, 0x0e, 0xcc, 0xc4, 0x9f, 0xd4,
	0x71, 0xc4, 0xd0, 0x19, 0x18, 0x0c, 0xec, 0x10, 0xfb, 0xac, 0xa0, 0xcd, 0x68, 0xb3, 0xc3, 0xa6,
	0x5a, 0xa1, 0x73, 0x30, 0x24, 0x8b, 0x44, 0x9c, 0x42, 0x4e, 0xec, 0x9c, 0x14, 0xeb, 0xdb, 0x0e,
	0x5a, 0x80, 0x01, 0xf1, 0x59, 0xe8, 0x9b, 0xd1, 0x66, 0xf3, 0xe5, 0xe9, 0x52, 0x5a, 0xe9, 0x4a,
	0x32, 0x92, 0xd4, 0x46, 0x0f, 0x61, 0x8c, 0xf8, 0x84, 0x11, 0xdb, 0xb3, 0xa2, 0xc0, 0x23, 0x2c,
	0x2a, 0xf4, 0xcf, 0xf4, 0xcd, 0xe6, 0xcb, 0xe5, 0x74, 0xfb, 0x56, 0xbc, 0xa5, 0x7b, 0xdc, 0xd4,
	0x1c, 0x55, 0x9e, 0xc4, 0x2a, 0x2a, 0x9e, 0x83, 0x01, 0xf1, 0x85, 0x26, 0xa0, 0x6f, 0x0f, 0x1f,
	0x88, 0x54, 0x46, 0x4c, 0xfe, 0xa9, 0x7f, 0x06, 0x53, 0x09, 0x2f, 0xb7, 0x42, 0x5a, 0xbb, 0xe7,
	0xdb, 0x41, 0xb4, 0x4b, 0xd9, 0xbf, 0xa8, 0xc0, 0x1b, 0x30, 0x1e, 0xd1, 0x7a, 0x58, 0xc5, 0x56,
	0xa4, 0x9c, 0x89, 0x5a, 0x0c, 0x9b, 0x63, 0x52, 0x1c, 0x87, 0xd0, 0x5f, 0x69, 0xf0, 0xbf, 0xb5,
	0x90, 0x06, 0x26, 0xdd, 0x37, 0x6d, 0xdf, 0x3d, 0xac, 0x3a, 0x82, 0x7e, 0xdf, 0xae, 0x61, 0x15,
	0x51, 0x7c, 0xa3, 0xcb, 0x30, 0x16, 0xd2, 0x7d, 0x6b, 0x0f, 0x1f, 0x58, 0x41, 0x88, 0x77, 0xc8,
	0x53, 0x11, 0x75, 0x64, 0xe3, 0x84, 0x39, 0x12, 0xd2, 0xfd, 0x0f, 0xf1, 0xc1, 0xa6, 0x90, 0xa2,
	0x1b, 0x50, 0x74, 0xb0, 0x87, 0x19, 0xb6, 0x6c, 0xcf, 0xb3, 0x1c, 0x9b, 0xd9, 0xd6, 0x4e, 0x48,
	0x6b, 0xd6, 0x51, 0x4f, 0x86, 0x36, 0x4e, 0x98, 0x67, 0xa4, 0xce, 0x4d, 0xcf, 0x5b, 0xb3, 0x99,
	0xcd, 0xf3, 0x16, 0x05, 0xa8, 0x0c, 0xc1, 0x20, 0xb3, 0x43, 0x17, 0x33, 0xfd, 0x0b, 0x0d, 0x4e,
	0x7d, 0x44, 0x22, 0x26, 0xe4, 0x51, 0x56, 0x35, 0x16, 0xa1, 0xff, 0x09, 0xc1, 0xfb, 0x02, 0xd3,
	0x58, 0xf9, 0x52, 0x46, 0xcf, 0x4b, 0x0f, 0x08, 0xde, 0x37, 0x85, 0x05, 0xba, 0x08, 0x10, 0xd8,
	0x2e, 0xb6, 0x18, 0xdd, 0xc3, 0xbe, 0xaa, 0xd3, 0x30, 0x97, 0xdc, 0xe7, 0x02, 0xbd, 0x0e, 0x28,
	0x89, 0x22, 0x0a, 0xa8, 0x1f, 0x61, 0x74, 0x8d, 0xc3, 0xe4, 0x92, 0x82, 0x26, 0x0e, 0x49, 0xe6,
	0x21, 0x53, 0xea, 0xe8, 0x32, 0x8c, 0xfb, 0xf8, 0x29, 0xb3, 0x12, 0x21, 0x65, 0xf3, 0x46, 0xb9,
	0x78, 0xf3, 0x30, 0xac, 0x05, 0xe3, 0xeb, 0x98, 0x35, 0x5c, 0x85, 0x76, 0x4d, 0x39, 0x76, 0xda,
	0xfa, 0x2c, 0xa0, 0x35, 0xd1, 0x82, 0xac, 0x18, 0xfa, 0xef, 0x39, 0x38, 0x7f, 0x87, 0x3a, 0x64,
	0xe7, 0x60, 0x95, 0x7a, 0xf5, 0x9a, 0x7f, 0xcb, 0xae, 0x11, 0x8f, 0x1c, 0xb5, 0xa4, 0x1d, 0xae,
	0x5d, 0x18, 0xad, 0x71, 0x13, 0x52, 0x95, 0x23, 0xa4, 0x90, 0x13, 0x65, 0xaa, 0xa4, 0x03, 0xec,
	0x10, 0x41, 0xee, 0x29, 0x57, 0x66, 0xa3, 0xe3, 0xe2, 0xcf, 0x1a, 0x8c, 0x24, 0xf7, 0xd1, 0x18,
	0xe4, 0x88, 0xa3, 0xc0, 0xe4, 0x88, 0x83, 0x56, 0x60, 0xb0, 0x2a, 0x6e, 0x98, 0x28, 0x52, 0xbe,
	0x7c, 0xb9, 0xc3, 0x7d, 0x3e, 0x8a, 0x7e, 0xb0, 0x71, 0xc2, 0x54, 0x76, 0xdc, 0x43, 0x3d, 0x70,
	0xb8, 0x87, 0xbe, 0x5e, 0x3d, 0x48, 0x3b, 0x34, 0x09, 0xfd, 0x4e, 0x48, 0x83, 0x42, 0xbf, 0x3a,
	0xfd, 0x62, 0x55, 0x19, 0x80, 0xbe, 0x1a, 0x75, 0xf4, 0x05, 0x98, 0x5e, 0xc7, 0x3e, 0x1f, 0xb6,
	0x78, 0x95, 0xfa, 0x11, 0x89, 0x18, 0xf6, 0xab, 0x07, 0xe2, 0x18, 0x74, 0x6a, 0xcb, 0x5d, 0x98,
	0x49, 0x37, 0x53, 0xc7, 0x74, 0x1e, 0x4e, 0x55, 0x8f, 0xf6, 0xd4, 0x79, 0x93, 0x4e, 0x26, 0xaa,
	0x4d, 0x46, 0xfa, 0x23, 0x38, 0xbb, 0xba, 0x8b, 0xab, 0x7b, 0x09, 0x6f, 0x9d, 0x5a, 0xdc, 0xd6,
	0x77, 0x2e, 0xc5, 0xf7, 0x12, 0x14, 0x5a, 0x7d, 0x2b, 0x90, 0x53, 0x00, 0x87, 0xfa, 0xf2, 0x5a,
	0x0f, 0x99, 0x09, 0x89, 0xfe, 0x83, 0x06, 0x93, 0xf1, 0xc4, 0xca, 0xbc, 0x10, 0x05, 0x38, 0x59,
	0xf5, 0xea, 0x11, 0xc3, 0x61, 0x3c, 0x14, 0xd5, 0x12, 0x4d, 0x43, 0x3e, 0x9e, 0x86, 0x7c, 0x64,
	0xca, 0x8b, 0x0e, 0xb1, 0xe8, 0xb6, 0x83, 0xe6, 0xa1, 0x8f, 0x31, 0x4f, 0xf4, 0x28, 0x5f, 0x3e,
	0x17, 0xf7, 0x38, 0x7e, 0xb0, 0x4a, 0x6b, 0xea, 0xb5, 0x33, 0xb9, 0x16, 0x9a, 0x81, 0xbc, 0x83,
	0xa3, 0x6a, 0x48, 0x02, 0x2e, 0x2b, 0x0c, 0x08, 0x6f, 0x49, 0x11, 0xbf, 0x60, 0xeb, 0x98, 0x35,
	0x4f, 0xf3, 0x76, 0x9d, 0x7c, 0x0c, 0x93, 0x7c, 0xc4, 0xc4, 0xaa, 0x99, 0xb3, 0xee, 0x3c, 0x88,
	0xf9, 0x64, 0x45, 0xe4, 0x99, 0x3c, 0xd4, 0x03, 0xe6, 0x10, 0x17, 0xdc, 0x23, 0xcf, 0x70, 0xd6,
	0x38, 0xfb, 0x5c, 0x83, 0xd3, 0x4d, 0xc1, 0x54, 0x1b, 0x56, 0x60, 0x38, 0x2e, 0x46, 0x3c, 0xd5,
	0xf4, 0xf4, 0x83, 0x7e, 0x98, 0xd7, 0x91, 0x51, 0xd7, 0xb3, 0x6d, 0x1e, 0x4e, 0xcb, 0xd1, 0xd3,
	0x4d, 0x71, 0xfe, 0xd2, 0xe0, 0x74, 0x43, 0xf7, 0xef, 0x60, 0x66, 0xf3, 0x57, 0x05, 0x3d, 0x84,
	0x09, 0x1a, 0x12, 0x97, 0xf8, 0xb6, 0x67, 0x85, 0xd2, 0x83, 0xb0, 0xcc, 0x97, 0x4b, 0xd9, 0xb8,
	0x93, 0x07, 0xc9, 0x1c, 0x8f, 0xfd, 0xc4, 0x40, 0x96, 0x61, 0x44, 0x79, 0xb4, 0x38, 0x4f, 0x51,
	0x93, 0xa3, 0xd8, 0x72, 0x26, 0xee, 0xc7, 0x24, 0xc6, 0xcc, 0x2b, 0x7d, 0x2e, 0x41, 0xd7, 0x21,
	0xbf, 0x43, 0x7c, 0x12, 0xed, 0x4a, 0xeb, 0xbe, 0x4c, 0x6b, 0x90, 0xea, 0x5c, 0xa0, 0xbf, 0xc8,
	0xc1, 0x74, 0x0a, 0x25, 0x38, 0x4c, 0xbd, 0x9a, 0x9a, 0xfa, 0x62, 0x57, 0x6c, 0xa5, 0x0d, 0xcf,
	0xf8, 0x4f, 0x15, 0xa1, 0xfc, 0xe3, 0x29, 0x40, 0x15, 0x95, 0x81, 0x40, 0x7c, 0x93, 0x67, 0x81,
	0x5e, 0x6a, 0x90, 0x4f, 0xa4, 0x81, 0xae, 0xf4, 0xc2, 0xcd, 0x8a, 0x59, 0x8f, 0xb4, 0xbe, 0xf0,
	0xe2, 0xb7, 0x3f, 0x5f, 0xe6, 0x0c, 0x7d, 0x8e, 0xf3, 0xe3, 0x4f, 0xe5, 0x6d, 0x5b, 0x0e, 0x42,
	0xfa, 0x18, 0x57, 0x59, 0x64, 0xcc, 0x19, 0xc4, 0x8f, 0x98, 0xed, 0x57, 0x71, 0x64, 0xcc, 0x3d,
	0x97, 0xfc, 0x39, 0x5a, 0xd2, 0xe6, 0xd0, 0x4f, 0x1a, 0x9c, 0x4d, 0x29, 0x2e, 0x3a, 0x76, 0x3f,
	0x8a, 0x17, 0x63, 0xcb, 0x04, 0x29, 0x2f, 0xdd, 0x8d, 0x49, 0xb9, 0xbe, 0x21, 0xb0, 0x56, 0xf4,
	0xe5, 0x1e, 0xb0, 0xca, 0xf7, 0x2c, 0x19, 0x8c, 0xc3, 0xff, 0x5a, 0x03, 0x38, 0xa2, 0x38, 0x68,
	0x3e, 0x1d, 0x71, 0x0b, 0x1d, 0x2b, 0x5e, 0xe9, 0x4e, 0x59, 0x8e, 0x18, 0xbd, 0x2c, 0x30, 0x5f,
	0x41, 0x3d, 0xd4, 0x17, 0x7d, 0xa5, 0xc1, 0x50, 0xcc, 0x84, 0xd0, 0x9b, 0xe9, 0xe1, 0x9a, 0xd8,
	0x52, 0x76, 0xb3, 0x1b, 0xc1, 0xf0, 0x59, 0x93, 0x02, 0x45, 0x21, 0x31, 0xe6, 0x9e, 0xa3, 0x2f,
	0x35, 0xc8, 0x27, 0x58, 0x53, 0xa7, 0xf3, 0xd7, 0x4a, 0xae, 0x8a, 0x67, 0x5a, 0x0e, 0xff, 0xfb,
	0xfc, 0x17, 0x52, 0x8c, 0x64, 0xae, 0x17, 0x24, 0xaf, 0x35, 0x98, 0x6c, 0x47, 0x99, 0xd0, 0xc2,
	0xb1, 0x28, 0x56, 0x76, 0xb9, 0x3e, 0x10, 0x20, 0xd7, 0xf4, 0xf7, 0xba, 0x07, 0xb9, 0x54, 0x6b,
	0x13, 0x90, 0x9f, 0xb8, 0x57, 0x1a, 0x8c, 0x24, 0x7f, 0x76, 0xa0, 0xb7, 0x3a, 0xd4, 0xb1, 0xf5,
	0xe7, 0x49, 0x6a, 0x21, 0x2b, 0x02, 0xe3, 0x0d, 0xfd, 0x5a, 0x0f, 0x18, 0x9d, 0x84, 0x7f, 0x8e,
	0xed, 0x0f, 0x0d, 0x0a, 0x69, 0xbc, 0x0a, 0xbd, 0xd3, 0xe9, 0xfc, 0x75, 0xa4, 0x70, 0xc5, 0xa5,
	0xe3, 0x98, 0xaa, 0x7b, 0xf3, 0xb1, 0xc8, 0x6b, 0x43, 0x5f, 0xed, 0x21, 0x2f, 0x37, 0xc5, 0x29,
	0xcf, 0xf1, 0x17, 0x0d, 0x26, 0x9a, 0xe9, 0x18, 0x7a, 0xbb, 0xc3, 0xa4, 0x6a, 0x4f, 0x0b, 0x8b,
	0xe5, 0x5e, 0x4c, 0x54, 0x2e, 0xb7, 0x44, 0x2e, 0x2b, 0xfa, 0xf5, 0x1e, 0x72, 0xa9, 0x36, 0x39,
	0xe3, 0x39, 0x7c, 0xa3, 0xc1, 0x68, 0xc3, 0x63, 0x8e, 0x7a, 0x7c, 0xf5, 0xb3, 0x06, 0xec, 0xbb,
	0x02, 0xe8, 0xa2, 0x7e, 0xb5, 0x07, 0xa0, 0x51, 0x62, 0xac, 0x7e, 0xab, 0x41, 0x3e, 0x41, 0x00,
	0x3b, 0xcd, 0x8a, 0x56, 0x9e, 0x58, 0xec, 0x82, 0x7a, 0xe9, 0x2b, 0x02, 0xe1, 0x12, 0x5a, 0xcc,
	0x44, 0xa8, 0x38, 0x30, 0xff, 0x3c, 0xa4, 0x6b, 0x7c, 0x8a, 0x7c, 0xaf, 0xc1, 0x68, 0x03, 0x1b,
	0xec, 0x54, 0xc4, 0x76, 0x1c, 0xb5, 0x68, 0x74, 0xad, 0xaf, 0xfa, 0xdf, 0x08, 0xba, 0xe3, 0x1b,
	0x90, 0x80, 0xfd, 0xfc, 0x08, 0x37, 0x7f, 0xaf, 0xc6, 0x1a, 0xf9, 0x23, 0x32, 0xb2, 0xe6, 0x70,
	0x73, 0x79, 0xd3, 0x26, 0x88, 0x42, 0x37, 0x77, 0xec, 0x92, 0x56, 0x5e, 0x6b, 0x70, 0xa1, 0x4a,
	0x6b, 0xa9, 0x80, 0x2a, 0x67, 0x5b, 0x79, 0xcd, 0x26, 0x07, 0xb1, 0xa9, 0x3d, 0x5a, 0x56, 0x46,
	0x2e, 0xf5, 0x6c, 0xdf, 0x2d, 0xd1, 0xd0, 0x35, 0x5c, 0xec, 0x0b, 0x88, 0x86, 0xdc, 0xb2, 0x03,
	0x12, 0xb5, 0xfe, 0x2f, 0xef, 0xba, 0xf8, 0xf8, 0x2e, 0x37, 0xb5, 0x2e, 0xed, 0x57, 0x3d, 0x5a,
	0x77, 0x4a, 0x71, 0x9c, 0x92, 0x88, 0x51, 0x7a, 0x50, 0xfe, 0x35, 0x56, 0xd8, 0x12, 0x0a, 0x5b,
	0xb1, 0xc2, 0x96, 0x50, 0xd8, 0x7a, 0x50, 0xde, 0x1e, 0x14, 0xb1, 0xae, 0xfe, 0x13, 0x00, 0x00,
	0xff, 0xff, 0xe3, 0x38, 0xa4, 0xfd, 0xa3, 0x14, 0x00, 0x00,
}
