// Code generated by protoc-gen-validate
// source: envoy/type/matcher/string.proto
// DO NOT EDIT!!!

package matcher

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on StringMatcher with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *StringMatcher) Validate() error {
	if m == nil {
		return nil
	}

	switch m.MatchPattern.(type) {

	case *StringMatcher_Exact:
		// no validation rules for Exact

	case *StringMatcher_Prefix:

		if len(m.GetPrefix()) < 1 {
			return StringMatcherValidationError{
				Field:  "Prefix",
				Reason: "value length must be at least 1 bytes",
			}
		}

	case *StringMatcher_Suffix:

		if len(m.GetSuffix()) < 1 {
			return StringMatcherValidationError{
				Field:  "Suffix",
				Reason: "value length must be at least 1 bytes",
			}
		}

	case *StringMatcher_Regex:

		if len(m.GetRegex()) > 1024 {
			return StringMatcherValidationError{
				Field:  "Regex",
				Reason: "value length must be at most 1024 bytes",
			}
		}

	default:
		return StringMatcherValidationError{
			Field:  "MatchPattern",
			Reason: "value is required",
		}

	}

	return nil
}

// StringMatcherValidationError is the validation error returned by
// StringMatcher.Validate if the designated constraints aren't met.
type StringMatcherValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e StringMatcherValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStringMatcher.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = StringMatcherValidationError{}

// Validate checks the field values on ListStringMatcher with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ListStringMatcher) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetPatterns()) < 1 {
		return ListStringMatcherValidationError{
			Field:  "Patterns",
			Reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetPatterns() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListStringMatcherValidationError{
					Field:  fmt.Sprintf("Patterns[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// ListStringMatcherValidationError is the validation error returned by
// ListStringMatcher.Validate if the designated constraints aren't met.
type ListStringMatcherValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e ListStringMatcherValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListStringMatcher.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = ListStringMatcherValidationError{}
