// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opActivateKeySigningKey = "ActivateKeySigningKey"

// ActivateKeySigningKeyRequest generates a "aws/request.Request" representing the
// client's request for the ActivateKeySigningKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateKeySigningKey for more information on using the ActivateKeySigningKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ActivateKeySigningKeyRequest method.
//    req, resp := client.ActivateKeySigningKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ActivateKeySigningKey
func (c *Route53) ActivateKeySigningKeyRequest(input *ActivateKeySigningKeyInput) (req *request.Request, output *ActivateKeySigningKeyOutput) {
	op := &request.Operation{
		Name:       opActivateKeySigningKey,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/activate",
	}

	if input == nil {
		input = &ActivateKeySigningKeyInput{}
	}

	output = &ActivateKeySigningKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateKeySigningKey API operation for Amazon Route 53.
//
// Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC.
// This operation changes the KSK status to ACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ActivateKeySigningKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeNoSuchKeySigningKey "NoSuchKeySigningKey"
//   The specified key-signing key (KSK) doesn't exist.
//
//   * ErrCodeInvalidKeySigningKeyStatus "InvalidKeySigningKeyStatus"
//   The key-signing key (KSK) status isn't valid or another KSK has the status
//   INTERNAL_FAILURE.
//
//   * ErrCodeInvalidSigningStatus "InvalidSigningStatus"
//   Your hosted zone status isn't valid for this operation. In the hosted zone,
//   change the status to enable DNSSEC or disable DNSSEC.
//
//   * ErrCodeInvalidKMSArn "InvalidKMSArn"
//   The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
//   signing.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ActivateKeySigningKey
func (c *Route53) ActivateKeySigningKey(input *ActivateKeySigningKeyInput) (*ActivateKeySigningKeyOutput, error) {
	req, out := c.ActivateKeySigningKeyRequest(input)
	return out, req.Send()
}

// ActivateKeySigningKeyWithContext is the same as ActivateKeySigningKey with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateKeySigningKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ActivateKeySigningKeyWithContext(ctx aws.Context, input *ActivateKeySigningKeyInput, opts ...request.Option) (*ActivateKeySigningKeyOutput, error) {
	req, out := c.ActivateKeySigningKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateVPCWithHostedZone = "AssociateVPCWithHostedZone"

// AssociateVPCWithHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVPCWithHostedZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateVPCWithHostedZone for more information on using the AssociateVPCWithHostedZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateVPCWithHostedZoneRequest method.
//    req, resp := client.AssociateVPCWithHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone
func (c *Route53) AssociateVPCWithHostedZoneRequest(input *AssociateVPCWithHostedZoneInput) (req *request.Request, output *AssociateVPCWithHostedZoneOutput) {
	op := &request.Operation{
		Name:       opAssociateVPCWithHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/associatevpc",
	}

	if input == nil {
		input = &AssociateVPCWithHostedZoneInput{}
	}

	output = &AssociateVPCWithHostedZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateVPCWithHostedZone API operation for Amazon Route 53.
//
// Associates an Amazon VPC with a private hosted zone.
//
// To perform the association, the VPC and the private hosted zone must already
// exist. You can't convert a public hosted zone into a private hosted zone.
//
// If you want to associate a VPC that was created by using one account with
// a private hosted zone that was created by using a different account, the
// account that created the private hosted zone must first submit a CreateVPCAssociationAuthorization
// request. Then the account that created the VPC must submit an AssociateVPCWithHostedZone
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation AssociateVPCWithHostedZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Associating the specified VPC with the specified hosted zone has not been
//   authorized.
//
//   * ErrCodeInvalidVPCId "InvalidVPCId"
//   The VPC ID that you specified either isn't a valid ID or the current account
//   is not authorized to access this VPC.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodePublicZoneVPCAssociation "PublicZoneVPCAssociation"
//   You're trying to associate a VPC with a public hosted zone. Amazon Route
//   53 doesn't support associating a VPC with a public hosted zone.
//
//   * ErrCodeConflictingDomainExists "ConflictingDomainExists"
//   The cause of this error depends on the operation that you're performing:
//
//      * Create a public hosted zone: Two hosted zones that have the same name
//      or that have a parent/child relationship (example.com and test.example.com)
//      can't have any common name servers. You tried to create a hosted zone
//      that has the same name as an existing hosted zone or that's the parent
//      or child of an existing hosted zone, and you specified a delegation set
//      that shares one or more name servers with the existing hosted zone. For
//      more information, see CreateReusableDelegationSet (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html).
//
//      * Create a private hosted zone: A hosted zone with the specified name
//      already exists and is already associated with the Amazon VPC that you
//      specified.
//
//      * Associate VPCs with a private hosted zone: The VPC that you specified
//      is already associated with another hosted zone that has the same name.
//
//   * ErrCodeLimitsExceeded "LimitsExceeded"
//   This operation can't be completed either because the current account has
//   reached the limit on reusable delegation sets that it can create or because
//   you've reached the limit on the number of Amazon VPCs that you can associate
//   with a private hosted zone. To get the current limit on the number of reusable
//   delegation sets, see GetAccountLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html).
//   To get the current limit on the number of Amazon VPCs that you can associate
//   with a private hosted zone, see GetHostedZoneLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html).
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone
func (c *Route53) AssociateVPCWithHostedZone(input *AssociateVPCWithHostedZoneInput) (*AssociateVPCWithHostedZoneOutput, error) {
	req, out := c.AssociateVPCWithHostedZoneRequest(input)
	return out, req.Send()
}

// AssociateVPCWithHostedZoneWithContext is the same as AssociateVPCWithHostedZone with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateVPCWithHostedZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) AssociateVPCWithHostedZoneWithContext(ctx aws.Context, input *AssociateVPCWithHostedZoneInput, opts ...request.Option) (*AssociateVPCWithHostedZoneOutput, error) {
	req, out := c.AssociateVPCWithHostedZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opChangeResourceRecordSets = "ChangeResourceRecordSets"

// ChangeResourceRecordSetsRequest generates a "aws/request.Request" representing the
// client's request for the ChangeResourceRecordSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChangeResourceRecordSets for more information on using the ChangeResourceRecordSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ChangeResourceRecordSetsRequest method.
//    req, resp := client.ChangeResourceRecordSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets
func (c *Route53) ChangeResourceRecordSetsRequest(input *ChangeResourceRecordSetsInput) (req *request.Request, output *ChangeResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opChangeResourceRecordSets,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset/",
	}

	if input == nil {
		input = &ChangeResourceRecordSetsInput{}
	}

	output = &ChangeResourceRecordSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ChangeResourceRecordSets API operation for Amazon Route 53.
//
// Creates, changes, or deletes a resource record set, which contains authoritative
// DNS information for a specified domain name or subdomain name. For example,
// you can use ChangeResourceRecordSets to create a resource record set that
// routes traffic for test.example.com to a web server that has an IP address
// of 192.0.2.44.
//
// Deleting Resource Record Sets
//
// To delete a resource record set, you must specify all the same values that
// you specified when you created it.
//
// Change Batches and Transactional Changes
//
// The request body must include a document with a ChangeResourceRecordSetsRequest
// element. The request body contains a list of change items, known as a change
// batch. Change batches are considered transactional changes. Route 53 validates
// the changes in the request and then either makes all or none of the changes
// in the change batch request. This ensures that DNS routing isn't adversely
// affected by partial changes to the resource record sets in a hosted zone.
//
// For example, suppose a change batch request contains two changes: it deletes
// the CNAME resource record set for www.example.com and creates an alias resource
// record set for www.example.com. If validation for both records succeeds,
// Route 53 deletes the first resource record set and creates the second resource
// record set in a single operation. If validation for either the DELETE or
// the CREATE action fails, then the request is canceled, and the original CNAME
// record continues to exist.
//
// If you try to delete the same resource record set more than once in a single
// change batch, Route 53 returns an InvalidChangeBatch error.
//
// Traffic Flow
//
// To create resource record sets for complex routing configurations, use either
// the traffic flow visual editor in the Route 53 console or the API actions
// for traffic policies and traffic policy instances. Save the configuration
// as a traffic policy, then associate the traffic policy with one or more domain
// names (such as example.com) or subdomain names (such as www.example.com),
// in the same hosted zone or in multiple hosted zones. You can roll back the
// updates if the new configuration isn't performing as expected. For more information,
// see Using Traffic Flow to Route DNS Traffic (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html)
// in the Amazon Route 53 Developer Guide.
//
// Create, Delete, and Upsert
//
// Use ChangeResourceRecordsSetsRequest to perform the following actions:
//
//    * CREATE: Creates a resource record set that has the specified values.
//
//    * DELETE: Deletes an existing resource record set that has the specified
//    values.
//
//    * UPSERT: If a resource record set does not already exist, Amazon Web
//    Services creates it. If a resource set does exist, Route 53 updates it
//    with the values in the request.
//
// Syntaxes for Creating, Updating, and Deleting Resource Record Sets
//
// The syntax for a request depends on the type of resource record set that
// you want to create, delete, or update, such as weighted, alias, or failover.
// The XML elements in your request must appear in the order listed in the syntax.
//
// For an example for each type of resource record set, see "Examples."
//
// Don't refer to the syntax in the "Parameter Syntax" section, which includes
// all of the elements for every kind of resource record set that you can create,
// delete, or update by using ChangeResourceRecordSets.
//
// Change Propagation to Route 53 DNS Servers
//
// When you submit a ChangeResourceRecordSets request, Route 53 propagates your
// changes to all of the Route 53 authoritative DNS servers. While your changes
// are propagating, GetChange returns a status of PENDING. When propagation
// is complete, GetChange returns a status of INSYNC. Changes generally propagate
// to all Route 53 name servers within 60 seconds. For more information, see
// GetChange (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html).
//
// Limits on ChangeResourceRecordSets Requests
//
// For information about the limits on a ChangeResourceRecordSets request, see
// Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ChangeResourceRecordSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeInvalidChangeBatch "InvalidChangeBatch"
//   This exception contains a list of messages that might contain one or more
//   error messages. Each error message indicates one error in the change batch.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets
func (c *Route53) ChangeResourceRecordSets(input *ChangeResourceRecordSetsInput) (*ChangeResourceRecordSetsOutput, error) {
	req, out := c.ChangeResourceRecordSetsRequest(input)
	return out, req.Send()
}

// ChangeResourceRecordSetsWithContext is the same as ChangeResourceRecordSets with the addition of
// the ability to pass a context and additional request options.
//
// See ChangeResourceRecordSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ChangeResourceRecordSetsWithContext(ctx aws.Context, input *ChangeResourceRecordSetsInput, opts ...request.Option) (*ChangeResourceRecordSetsOutput, error) {
	req, out := c.ChangeResourceRecordSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opChangeTagsForResource = "ChangeTagsForResource"

// ChangeTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ChangeTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChangeTagsForResource for more information on using the ChangeTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ChangeTagsForResourceRequest method.
//    req, resp := client.ChangeTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource
func (c *Route53) ChangeTagsForResourceRequest(input *ChangeTagsForResourceInput) (req *request.Request, output *ChangeTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opChangeTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ChangeTagsForResourceInput{}
	}

	output = &ChangeTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ChangeTagsForResource API operation for Amazon Route 53.
//
// Adds, edits, or deletes tags for a health check or a hosted zone.
//
// For information about using tags for cost allocation, see Using Cost Allocation
// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ChangeTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource
func (c *Route53) ChangeTagsForResource(input *ChangeTagsForResourceInput) (*ChangeTagsForResourceOutput, error) {
	req, out := c.ChangeTagsForResourceRequest(input)
	return out, req.Send()
}

// ChangeTagsForResourceWithContext is the same as ChangeTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ChangeTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ChangeTagsForResourceWithContext(ctx aws.Context, input *ChangeTagsForResourceInput, opts ...request.Option) (*ChangeTagsForResourceOutput, error) {
	req, out := c.ChangeTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHealthCheck = "CreateHealthCheck"

// CreateHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the CreateHealthCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHealthCheck for more information on using the CreateHealthCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHealthCheckRequest method.
//    req, resp := client.CreateHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck
func (c *Route53) CreateHealthCheckRequest(input *CreateHealthCheckInput) (req *request.Request, output *CreateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opCreateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck",
	}

	if input == nil {
		input = &CreateHealthCheckInput{}
	}

	output = &CreateHealthCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHealthCheck API operation for Amazon Route 53.
//
// Creates a new health check.
//
// For information about adding health checks to resource record sets, see HealthCheckId
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId)
// in ChangeResourceRecordSets (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html).
//
// ELB Load Balancers
//
// If you're registering EC2 instances with an Elastic Load Balancing (ELB)
// load balancer, do not create Amazon Route 53 health checks for the EC2 instances.
// When you register an EC2 instance with a load balancer, you configure settings
// for an ELB health check, which performs a similar function to a Route 53
// health check.
//
// Private Hosted Zones
//
// You can associate health checks with failover resource record sets in a private
// hosted zone. Note the following:
//
//    * Route 53 health checkers are outside the VPC. To check the health of
//    an endpoint within a VPC by IP address, you must assign a public IP address
//    to the instance in the VPC.
//
//    * You can configure a health checker to check the health of an external
//    resource that the instance relies on, such as a database server.
//
//    * You can create a CloudWatch metric, associate an alarm with the metric,
//    and then create a health check that is based on the state of the alarm.
//    For example, you might create a CloudWatch metric that checks the status
//    of the Amazon EC2 StatusCheckFailed metric, add an alarm to the metric,
//    and then create a health check that is based on the state of the alarm.
//    For information about creating CloudWatch metrics and alarms by using
//    the CloudWatch console, see the Amazon CloudWatch User Guide (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyHealthChecks "TooManyHealthChecks"
//   This health check can't be created because the current account has reached
//   the limit on the number of active health checks.
//
//   For information about default limits, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
//   in the Amazon Route 53 Developer Guide.
//
//   For information about how to get the current limit for an account, see GetAccountLimit
//   (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html).
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   You have reached the maximum number of active health checks for an account.
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   * ErrCodeHealthCheckAlreadyExists "HealthCheckAlreadyExists"
//   The health check you're attempting to create already exists. Amazon Route
//   53 returns this error when you submit a request that has the following values:
//
//      * The same value for CallerReference as an existing health check, and
//      one or more values that differ from the existing health check that has
//      the same caller reference.
//
//      * The same value for CallerReference as a health check that you created
//      and later deleted, regardless of the other settings in the request.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck
func (c *Route53) CreateHealthCheck(input *CreateHealthCheckInput) (*CreateHealthCheckOutput, error) {
	req, out := c.CreateHealthCheckRequest(input)
	return out, req.Send()
}

// CreateHealthCheckWithContext is the same as CreateHealthCheck with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHealthCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateHealthCheckWithContext(ctx aws.Context, input *CreateHealthCheckInput, opts ...request.Option) (*CreateHealthCheckOutput, error) {
	req, out := c.CreateHealthCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHostedZone = "CreateHostedZone"

// CreateHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the CreateHostedZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHostedZone for more information on using the CreateHostedZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHostedZoneRequest method.
//    req, resp := client.CreateHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone
func (c *Route53) CreateHostedZoneRequest(input *CreateHostedZoneInput) (req *request.Request, output *CreateHostedZoneOutput) {
	op := &request.Operation{
		Name:       opCreateHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone",
	}

	if input == nil {
		input = &CreateHostedZoneInput{}
	}

	output = &CreateHostedZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHostedZone API operation for Amazon Route 53.
//
// Creates a new public or private hosted zone. You create records in a public
// hosted zone to define how you want to route traffic on the internet for a
// domain, such as example.com, and its subdomains (apex.example.com, acme.example.com).
// You create records in a private hosted zone to define how you want to route
// traffic for a domain and its subdomains within one or more Amazon Virtual
// Private Clouds (Amazon VPCs).
//
// You can't convert a public hosted zone to a private hosted zone or vice versa.
// Instead, you must create a new hosted zone with the same name and create
// new resource record sets.
//
// For more information about charges for hosted zones, see Amazon Route 53
// Pricing (http://aws.amazon.com/route53/pricing/).
//
// Note the following:
//
//    * You can't create a hosted zone for a top-level domain (TLD) such as
//    .com.
//
//    * For public hosted zones, Route 53 automatically creates a default SOA
//    record and four NS records for the zone. For more information about SOA
//    and NS records, see NS and SOA Records that Route 53 Creates for a Hosted
//    Zone (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html)
//    in the Amazon Route 53 Developer Guide. If you want to use the same name
//    servers for multiple public hosted zones, you can optionally associate
//    a reusable delegation set with the hosted zone. See the DelegationSetId
//    element.
//
//    * If your domain is registered with a registrar other than Route 53, you
//    must update the name servers with your registrar to make Route 53 the
//    DNS service for the domain. For more information, see Migrating DNS Service
//    for an Existing Domain to Amazon Route 53 (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html)
//    in the Amazon Route 53 Developer Guide.
//
// When you submit a CreateHostedZone request, the initial status of the hosted
// zone is PENDING. For public hosted zones, this means that the NS and SOA
// records are not yet available on all Route 53 DNS servers. When the NS and
// SOA records are available, the status of the zone changes to INSYNC.
//
// The CreateHostedZone request requires the caller to have an ec2:DescribeVpcs
// permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateHostedZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDomainName "InvalidDomainName"
//   The specified domain name is not valid.
//
//   * ErrCodeHostedZoneAlreadyExists "HostedZoneAlreadyExists"
//   The hosted zone you're trying to create already exists. Amazon Route 53 returns
//   this error when a hosted zone has already been created with the specified
//   CallerReference.
//
//   * ErrCodeTooManyHostedZones "TooManyHostedZones"
//   This operation can't be completed either because the current account has
//   reached the limit on the number of hosted zones or because you've reached
//   the limit on the number of hosted zones that can be associated with a reusable
//   delegation set.
//
//   For information about default limits, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
//   in the Amazon Route 53 Developer Guide.
//
//   To get the current limit on hosted zones that can be created by an account,
//   see GetAccountLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html).
//
//   To get the current limit on hosted zones that can be associated with a reusable
//   delegation set, see GetReusableDelegationSetLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html).
//
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   * ErrCodeInvalidVPCId "InvalidVPCId"
//   The VPC ID that you specified either isn't a valid ID or the current account
//   is not authorized to access this VPC.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeDelegationSetNotAvailable "DelegationSetNotAvailable"
//   You can create a hosted zone that has the same name as an existing hosted
//   zone (example.com is common), but there is a limit to the number of hosted
//   zones that have the same name. If you get this error, Amazon Route 53 has
//   reached that limit. If you own the domain name and Route 53 generates this
//   error, contact Customer Support.
//
//   * ErrCodeConflictingDomainExists "ConflictingDomainExists"
//   The cause of this error depends on the operation that you're performing:
//
//      * Create a public hosted zone: Two hosted zones that have the same name
//      or that have a parent/child relationship (example.com and test.example.com)
//      can't have any common name servers. You tried to create a hosted zone
//      that has the same name as an existing hosted zone or that's the parent
//      or child of an existing hosted zone, and you specified a delegation set
//      that shares one or more name servers with the existing hosted zone. For
//      more information, see CreateReusableDelegationSet (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html).
//
//      * Create a private hosted zone: A hosted zone with the specified name
//      already exists and is already associated with the Amazon VPC that you
//      specified.
//
//      * Associate VPCs with a private hosted zone: The VPC that you specified
//      is already associated with another hosted zone that has the same name.
//
//   * ErrCodeNoSuchDelegationSet "NoSuchDelegationSet"
//   A reusable delegation set with the specified ID does not exist.
//
//   * ErrCodeDelegationSetNotReusable "DelegationSetNotReusable"
//   A reusable delegation set with the specified ID does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone
func (c *Route53) CreateHostedZone(input *CreateHostedZoneInput) (*CreateHostedZoneOutput, error) {
	req, out := c.CreateHostedZoneRequest(input)
	return out, req.Send()
}

// CreateHostedZoneWithContext is the same as CreateHostedZone with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHostedZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateHostedZoneWithContext(ctx aws.Context, input *CreateHostedZoneInput, opts ...request.Option) (*CreateHostedZoneOutput, error) {
	req, out := c.CreateHostedZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeySigningKey = "CreateKeySigningKey"

// CreateKeySigningKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeySigningKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeySigningKey for more information on using the CreateKeySigningKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeySigningKeyRequest method.
//    req, resp := client.CreateKeySigningKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateKeySigningKey
func (c *Route53) CreateKeySigningKeyRequest(input *CreateKeySigningKeyInput) (req *request.Request, output *CreateKeySigningKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKeySigningKey,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/keysigningkey",
	}

	if input == nil {
		input = &CreateKeySigningKeyInput{}
	}

	output = &CreateKeySigningKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeySigningKey API operation for Amazon Route 53.
//
// Creates a new key-signing key (KSK) associated with a hosted zone. You can
// only have two KSKs per hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateKeySigningKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   Parameter name is not valid.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeInvalidKMSArn "InvalidKMSArn"
//   The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
//   signing.
//
//   * ErrCodeInvalidKeySigningKeyStatus "InvalidKeySigningKeyStatus"
//   The key-signing key (KSK) status isn't valid or another KSK has the status
//   INTERNAL_FAILURE.
//
//   * ErrCodeInvalidSigningStatus "InvalidSigningStatus"
//   Your hosted zone status isn't valid for this operation. In the hosted zone,
//   change the status to enable DNSSEC or disable DNSSEC.
//
//   * ErrCodeInvalidKeySigningKeyName "InvalidKeySigningKeyName"
//   The key-signing key (KSK) name that you specified isn't a valid name.
//
//   * ErrCodeKeySigningKeyAlreadyExists "KeySigningKeyAlreadyExists"
//   You've already created a key-signing key (KSK) with this name or with the
//   same customer managed customer master key (CMK) ARN.
//
//   * ErrCodeTooManyKeySigningKeys "TooManyKeySigningKeys"
//   You've reached the limit for the number of key-signing keys (KSKs). Remove
//   at least one KSK, and then try again.
//
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateKeySigningKey
func (c *Route53) CreateKeySigningKey(input *CreateKeySigningKeyInput) (*CreateKeySigningKeyOutput, error) {
	req, out := c.CreateKeySigningKeyRequest(input)
	return out, req.Send()
}

// CreateKeySigningKeyWithContext is the same as CreateKeySigningKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeySigningKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateKeySigningKeyWithContext(ctx aws.Context, input *CreateKeySigningKeyInput, opts ...request.Option) (*CreateKeySigningKeyOutput, error) {
	req, out := c.CreateKeySigningKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQueryLoggingConfig = "CreateQueryLoggingConfig"

// CreateQueryLoggingConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateQueryLoggingConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQueryLoggingConfig for more information on using the CreateQueryLoggingConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateQueryLoggingConfigRequest method.
//    req, resp := client.CreateQueryLoggingConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateQueryLoggingConfig
func (c *Route53) CreateQueryLoggingConfigRequest(input *CreateQueryLoggingConfigInput) (req *request.Request, output *CreateQueryLoggingConfigOutput) {
	op := &request.Operation{
		Name:       opCreateQueryLoggingConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/queryloggingconfig",
	}

	if input == nil {
		input = &CreateQueryLoggingConfigInput{}
	}

	output = &CreateQueryLoggingConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQueryLoggingConfig API operation for Amazon Route 53.
//
// Creates a configuration for DNS query logging. After you create a query logging
// configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch
// Logs log group.
//
// DNS query logs contain information about the queries that Route 53 receives
// for a specified public hosted zone, such as the following:
//
//    * Route 53 edge location that responded to the DNS query
//
//    * Domain or subdomain that was requested
//
//    * DNS record type, such as A or AAAA
//
//    * DNS response code, such as NoError or ServFail
//
// Log Group and Resource Policy
//
// Before you create a query logging configuration, perform the following operations.
//
// If you create a query logging configuration using the Route 53 console, Route
// 53 performs these operations automatically.
//
// Create a CloudWatch Logs log group, and make note of the ARN, which you specify
// when you create a query logging configuration. Note the following:
//
//    * You must create the log group in the us-east-1 region.
//
//    * You must use the same account to create the log group and the hosted
//    zone that you want to configure query logging for.
//
//    * When you create log groups for query logging, we recommend that you
//    use a consistent prefix, for example: /aws/route53/hosted zone name In
//    the next step, you'll create a resource policy, which controls access
//    to one or more log groups and the associated Amazon Web Services resources,
//    such as Route 53 hosted zones. There's a limit on the number of resource
//    policies that you can create, so we recommend that you use a consistent
//    prefix so you can use the same resource policy for all the log groups
//    that you create for query logging.
//
// Create a CloudWatch Logs resource policy, and give it the permissions that
// Route 53 needs to create log streams and to send query logs to log streams.
// For the value of Resource, specify the ARN for the log group that you created
// in the previous step. To use the same resource policy for all the CloudWatch
// Logs log groups that you created for query logging configurations, replace
// the hosted zone name with *, for example:
//
// arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*
//
// You can't use the CloudWatch console to create or edit a resource policy.
// You must use the CloudWatch API, one of the Amazon Web Services SDKs, or
// the CLI.
//
// Log Streams and Edge Locations
//
// When Route 53 finishes creating the configuration for DNS query logging,
// it does the following:
//
//    * Creates a log stream for an edge location the first time that the edge
//    location responds to DNS queries for the specified hosted zone. That log
//    stream is used to log all queries that Route 53 responds to for that edge
//    location.
//
//    * Begins to send query logs to the applicable log stream.
//
// The name of each log stream is in the following format:
//
// hosted zone ID/edge location code
//
// The edge location code is a three-letter code and an arbitrarily assigned
// number, for example, DFW3. The three-letter code typically corresponds with
// the International Air Transport Association airport code for an airport near
// the edge location. (These abbreviations might change in the future.) For
// a list of edge locations, see "The Route 53 Global Network" on the Route
// 53 Product Details (http://aws.amazon.com/route53/details/) page.
//
// Queries That Are Logged
//
// Query logs contain only the queries that DNS resolvers forward to Route 53.
// If a DNS resolver has already cached the response to a query (such as the
// IP address for a load balancer for example.com), the resolver will continue
// to return the cached response. It doesn't forward another query to Route
// 53 until the TTL for the corresponding resource record set expires. Depending
// on how many DNS queries are submitted for a resource record set, and depending
// on the TTL for that resource record set, query logs might contain information
// about only one query out of every several thousand queries that are submitted
// to DNS. For more information about how DNS works, see Routing Internet Traffic
// to Your Website or Web Application (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html)
// in the Amazon Route 53 Developer Guide.
//
// Log File Format
//
// For a list of the values in each query log and the format of each value,
// see Logging DNS Queries (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html)
// in the Amazon Route 53 Developer Guide.
//
// Pricing
//
// For information about charges for query logs, see Amazon CloudWatch Pricing
// (http://aws.amazon.com/cloudwatch/pricing/).
//
// How to Stop Logging
//
// If you want Route 53 to stop sending query logs to CloudWatch Logs, delete
// the query logging configuration. For more information, see DeleteQueryLoggingConfig
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateQueryLoggingConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeNoSuchCloudWatchLogsLogGroup "NoSuchCloudWatchLogsLogGroup"
//   There is no CloudWatch Logs log group with the specified ARN.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeQueryLoggingConfigAlreadyExists "QueryLoggingConfigAlreadyExists"
//   You can create only one query logging configuration for a hosted zone, and
//   a query logging configuration already exists for this hosted zone.
//
//   * ErrCodeInsufficientCloudWatchLogsResourcePolicy "InsufficientCloudWatchLogsResourcePolicy"
//   Amazon Route 53 doesn't have the permissions required to create log streams
//   and send query logs to log streams. Possible causes include the following:
//
//      * There is no resource policy that specifies the log group ARN in the
//      value for Resource.
//
//      * The resource policy that includes the log group ARN in the value for
//      Resource doesn't have the necessary permissions.
//
//      * The resource policy hasn't finished propagating yet.
//
//      * The Key management service (KMS) key you specified doesn’t exist or
//      it can’t be used with the log group associated with query log. Update
//      or provide a resource policy to grant permissions for the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateQueryLoggingConfig
func (c *Route53) CreateQueryLoggingConfig(input *CreateQueryLoggingConfigInput) (*CreateQueryLoggingConfigOutput, error) {
	req, out := c.CreateQueryLoggingConfigRequest(input)
	return out, req.Send()
}

// CreateQueryLoggingConfigWithContext is the same as CreateQueryLoggingConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueryLoggingConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateQueryLoggingConfigWithContext(ctx aws.Context, input *CreateQueryLoggingConfigInput, opts ...request.Option) (*CreateQueryLoggingConfigOutput, error) {
	req, out := c.CreateQueryLoggingConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReusableDelegationSet = "CreateReusableDelegationSet"

// CreateReusableDelegationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateReusableDelegationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReusableDelegationSet for more information on using the CreateReusableDelegationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReusableDelegationSetRequest method.
//    req, resp := client.CreateReusableDelegationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet
func (c *Route53) CreateReusableDelegationSetRequest(input *CreateReusableDelegationSetInput) (req *request.Request, output *CreateReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opCreateReusableDelegationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &CreateReusableDelegationSetInput{}
	}

	output = &CreateReusableDelegationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReusableDelegationSet API operation for Amazon Route 53.
//
// Creates a delegation set (a group of four name servers) that can be reused
// by multiple hosted zones that were created by the same account.
//
// You can also create a reusable delegation set that uses the four name servers
// that are associated with an existing hosted zone. Specify the hosted zone
// ID in the CreateReusableDelegationSet request.
//
// You can't associate a reusable delegation set with a private hosted zone.
//
// For information about using a reusable delegation set to configure white
// label name servers, see Configuring White Label Name Servers (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html).
//
// The process for migrating existing hosted zones to use a reusable delegation
// set is comparable to the process for configuring white label name servers.
// You need to perform the following steps:
//
// Create a reusable delegation set.
//
// Recreate hosted zones, and reduce the TTL to 60 seconds or less.
//
// Recreate resource record sets in the new hosted zones.
//
// Change the registrar's name servers to use the name servers for the new hosted
// zones.
//
// Monitor traffic for the website or application.
//
// Change TTLs back to their original values.
//
// If you want to migrate existing hosted zones to use a reusable delegation
// set, the existing hosted zones can't use any of the name servers that are
// assigned to the reusable delegation set. If one or more hosted zones do use
// one or more name servers that are assigned to the reusable delegation set,
// you can do one of the following:
//
//    * For small numbers of hosted zones—up to a few hundred—it's relatively
//    easy to create reusable delegation sets until you get one that has four
//    name servers that don't overlap with any of the name servers in your hosted
//    zones.
//
//    * For larger numbers of hosted zones, the easiest solution is to use more
//    than one reusable delegation set.
//
//    * For larger numbers of hosted zones, you can also migrate hosted zones
//    that have overlapping name servers to hosted zones that don't have overlapping
//    name servers, then migrate the hosted zones again to use the reusable
//    delegation set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateReusableDelegationSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDelegationSetAlreadyCreated "DelegationSetAlreadyCreated"
//   A delegation set with the same owner and caller reference combination has
//   already been created.
//
//   * ErrCodeLimitsExceeded "LimitsExceeded"
//   This operation can't be completed either because the current account has
//   reached the limit on reusable delegation sets that it can create or because
//   you've reached the limit on the number of Amazon VPCs that you can associate
//   with a private hosted zone. To get the current limit on the number of reusable
//   delegation sets, see GetAccountLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html).
//   To get the current limit on the number of Amazon VPCs that you can associate
//   with a private hosted zone, see GetHostedZoneLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html).
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   * ErrCodeHostedZoneNotFound "HostedZoneNotFound"
//   The specified HostedZone can't be found.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   Parameter name is not valid.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeDelegationSetNotAvailable "DelegationSetNotAvailable"
//   You can create a hosted zone that has the same name as an existing hosted
//   zone (example.com is common), but there is a limit to the number of hosted
//   zones that have the same name. If you get this error, Amazon Route 53 has
//   reached that limit. If you own the domain name and Route 53 generates this
//   error, contact Customer Support.
//
//   * ErrCodeDelegationSetAlreadyReusable "DelegationSetAlreadyReusable"
//   The specified delegation set has already been marked as reusable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet
func (c *Route53) CreateReusableDelegationSet(input *CreateReusableDelegationSetInput) (*CreateReusableDelegationSetOutput, error) {
	req, out := c.CreateReusableDelegationSetRequest(input)
	return out, req.Send()
}

// CreateReusableDelegationSetWithContext is the same as CreateReusableDelegationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReusableDelegationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateReusableDelegationSetWithContext(ctx aws.Context, input *CreateReusableDelegationSetInput, opts ...request.Option) (*CreateReusableDelegationSetOutput, error) {
	req, out := c.CreateReusableDelegationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficPolicy = "CreateTrafficPolicy"

// CreateTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficPolicy for more information on using the CreateTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficPolicyRequest method.
//    req, resp := client.CreateTrafficPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy
func (c *Route53) CreateTrafficPolicyRequest(input *CreateTrafficPolicyInput) (req *request.Request, output *CreateTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy",
	}

	if input == nil {
		input = &CreateTrafficPolicyInput{}
	}

	output = &CreateTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficPolicy API operation for Amazon Route 53.
//
// Creates a traffic policy, which you use to create multiple DNS resource record
// sets for one domain name (such as example.com) or one subdomain name (such
// as www.example.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateTrafficPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeTooManyTrafficPolicies "TooManyTrafficPolicies"
//   This traffic policy can't be created because the current account has reached
//   the limit on the number of traffic policies.
//
//   For information about default limits, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
//   in the Amazon Route 53 Developer Guide.
//
//   To get the current limit for an account, see GetAccountLimit (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html).
//
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   * ErrCodeTrafficPolicyAlreadyExists "TrafficPolicyAlreadyExists"
//   A traffic policy that has the same value for Name already exists.
//
//   * ErrCodeInvalidTrafficPolicyDocument "InvalidTrafficPolicyDocument"
//   The format of the traffic policy document that you specified in the Document
//   element is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy
func (c *Route53) CreateTrafficPolicy(input *CreateTrafficPolicyInput) (*CreateTrafficPolicyOutput, error) {
	req, out := c.CreateTrafficPolicyRequest(input)
	return out, req.Send()
}

// CreateTrafficPolicyWithContext is the same as CreateTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateTrafficPolicyWithContext(ctx aws.Context, input *CreateTrafficPolicyInput, opts ...request.Option) (*CreateTrafficPolicyOutput, error) {
	req, out := c.CreateTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficPolicyInstance = "CreateTrafficPolicyInstance"

// CreateTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicyInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficPolicyInstance for more information on using the CreateTrafficPolicyInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficPolicyInstanceRequest method.
//    req, resp := client.CreateTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance
func (c *Route53) CreateTrafficPolicyInstanceRequest(input *CreateTrafficPolicyInstanceInput) (req *request.Request, output *CreateTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicyInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance",
	}

	if input == nil {
		input = &CreateTrafficPolicyInstanceInput{}
	}

	output = &CreateTrafficPolicyInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficPolicyInstance API operation for Amazon Route 53.
//
// Creates resource record sets in a specified hosted zone based on the settings
// in a specified traffic policy version. In addition, CreateTrafficPolicyInstance
// associates the resource record sets with a specified domain name (such as
// example.com) or subdomain name (such as www.example.com). Amazon Route 53
// responds to DNS queries for the domain or subdomain name by using the resource
// record sets that CreateTrafficPolicyInstance created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeTooManyTrafficPolicyInstances "TooManyTrafficPolicyInstances"
//   This traffic policy instance can't be created because the current account
//   has reached the limit on the number of traffic policy instances.
//
//   For information about default limits, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
//   in the Amazon Route 53 Developer Guide.
//
//   For information about how to get the current limit for an account, see GetAccountLimit
//   (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html).
//
//   To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the Amazon Web Services Support Center.
//
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
//   * ErrCodeTrafficPolicyInstanceAlreadyExists "TrafficPolicyInstanceAlreadyExists"
//   There is already a traffic policy instance with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance
func (c *Route53) CreateTrafficPolicyInstance(input *CreateTrafficPolicyInstanceInput) (*CreateTrafficPolicyInstanceOutput, error) {
	req, out := c.CreateTrafficPolicyInstanceRequest(input)
	return out, req.Send()
}

// CreateTrafficPolicyInstanceWithContext is the same as CreateTrafficPolicyInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficPolicyInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateTrafficPolicyInstanceWithContext(ctx aws.Context, input *CreateTrafficPolicyInstanceInput, opts ...request.Option) (*CreateTrafficPolicyInstanceOutput, error) {
	req, out := c.CreateTrafficPolicyInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficPolicyVersion = "CreateTrafficPolicyVersion"

// CreateTrafficPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficPolicyVersion for more information on using the CreateTrafficPolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrafficPolicyVersionRequest method.
//    req, resp := client.CreateTrafficPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion
func (c *Route53) CreateTrafficPolicyVersionRequest(input *CreateTrafficPolicyVersionInput) (req *request.Request, output *CreateTrafficPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}",
	}

	if input == nil {
		input = &CreateTrafficPolicyVersionInput{}
	}

	output = &CreateTrafficPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficPolicyVersion API operation for Amazon Route 53.
//
// Creates a new version of an existing traffic policy. When you create a new
// version of a traffic policy, you specify the ID of the traffic policy that
// you want to update and a JSON-formatted document that describes the new version.
// You use traffic policies to create multiple DNS resource record sets for
// one domain name (such as example.com) or one subdomain name (such as www.example.com).
// You can create a maximum of 1000 versions of a traffic policy. If you reach
// the limit and need to create another version, you'll need to start a new
// traffic policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateTrafficPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeTooManyTrafficPolicyVersionsForCurrentPolicy "TooManyTrafficPolicyVersionsForCurrentPolicy"
//   This traffic policy version can't be created because you've reached the limit
//   of 1000 on the number of versions that you can create for the current traffic
//   policy.
//
//   To create more traffic policy versions, you can use GetTrafficPolicy (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html)
//   to get the traffic policy document for a specified traffic policy version,
//   and then use CreateTrafficPolicy (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html)
//   to create a new traffic policy using the traffic policy document.
//
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeInvalidTrafficPolicyDocument "InvalidTrafficPolicyDocument"
//   The format of the traffic policy document that you specified in the Document
//   element is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion
func (c *Route53) CreateTrafficPolicyVersion(input *CreateTrafficPolicyVersionInput) (*CreateTrafficPolicyVersionOutput, error) {
	req, out := c.CreateTrafficPolicyVersionRequest(input)
	return out, req.Send()
}

// CreateTrafficPolicyVersionWithContext is the same as CreateTrafficPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateTrafficPolicyVersionWithContext(ctx aws.Context, input *CreateTrafficPolicyVersionInput, opts ...request.Option) (*CreateTrafficPolicyVersionOutput, error) {
	req, out := c.CreateTrafficPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVPCAssociationAuthorization = "CreateVPCAssociationAuthorization"

// CreateVPCAssociationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVPCAssociationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVPCAssociationAuthorization for more information on using the CreateVPCAssociationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVPCAssociationAuthorizationRequest method.
//    req, resp := client.CreateVPCAssociationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization
func (c *Route53) CreateVPCAssociationAuthorizationRequest(input *CreateVPCAssociationAuthorizationInput) (req *request.Request, output *CreateVPCAssociationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opCreateVPCAssociationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
	}

	if input == nil {
		input = &CreateVPCAssociationAuthorizationInput{}
	}

	output = &CreateVPCAssociationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVPCAssociationAuthorization API operation for Amazon Route 53.
//
// Authorizes the account that created a specified VPC to submit an AssociateVPCWithHostedZone
// request to associate the VPC with a specified hosted zone that was created
// by a different account. To submit a CreateVPCAssociationAuthorization request,
// you must use the account that created the hosted zone. After you authorize
// the association, use the account that created the VPC to submit an AssociateVPCWithHostedZone
// request.
//
// If you want to associate multiple VPCs that you created by using one account
// with a hosted zone that you created by using a different account, you must
// submit one authorization request for each VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateVPCAssociationAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeTooManyVPCAssociationAuthorizations "TooManyVPCAssociationAuthorizations"
//   You've created the maximum number of authorizations that can be created for
//   the specified hosted zone. To authorize another VPC to be associated with
//   the hosted zone, submit a DeleteVPCAssociationAuthorization request to remove
//   an existing authorization. To get a list of existing authorizations, submit
//   a ListVPCAssociationAuthorizations request.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidVPCId "InvalidVPCId"
//   The VPC ID that you specified either isn't a valid ID or the current account
//   is not authorized to access this VPC.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization
func (c *Route53) CreateVPCAssociationAuthorization(input *CreateVPCAssociationAuthorizationInput) (*CreateVPCAssociationAuthorizationOutput, error) {
	req, out := c.CreateVPCAssociationAuthorizationRequest(input)
	return out, req.Send()
}

// CreateVPCAssociationAuthorizationWithContext is the same as CreateVPCAssociationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVPCAssociationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) CreateVPCAssociationAuthorizationWithContext(ctx aws.Context, input *CreateVPCAssociationAuthorizationInput, opts ...request.Option) (*CreateVPCAssociationAuthorizationOutput, error) {
	req, out := c.CreateVPCAssociationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateKeySigningKey = "DeactivateKeySigningKey"

// DeactivateKeySigningKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateKeySigningKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateKeySigningKey for more information on using the DeactivateKeySigningKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeactivateKeySigningKeyRequest method.
//    req, resp := client.DeactivateKeySigningKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeactivateKeySigningKey
func (c *Route53) DeactivateKeySigningKeyRequest(input *DeactivateKeySigningKeyInput) (req *request.Request, output *DeactivateKeySigningKeyOutput) {
	op := &request.Operation{
		Name:       opDeactivateKeySigningKey,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/deactivate",
	}

	if input == nil {
		input = &DeactivateKeySigningKeyInput{}
	}

	output = &DeactivateKeySigningKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeactivateKeySigningKey API operation for Amazon Route 53.
//
// Deactivates a key-signing key (KSK) so that it will not be used for signing
// by DNSSEC. This operation changes the KSK status to INACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeactivateKeySigningKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeNoSuchKeySigningKey "NoSuchKeySigningKey"
//   The specified key-signing key (KSK) doesn't exist.
//
//   * ErrCodeInvalidKeySigningKeyStatus "InvalidKeySigningKeyStatus"
//   The key-signing key (KSK) status isn't valid or another KSK has the status
//   INTERNAL_FAILURE.
//
//   * ErrCodeInvalidSigningStatus "InvalidSigningStatus"
//   Your hosted zone status isn't valid for this operation. In the hosted zone,
//   change the status to enable DNSSEC or disable DNSSEC.
//
//   * ErrCodeKeySigningKeyInUse "KeySigningKeyInUse"
//   The key-signing key (KSK) that you specified can't be deactivated because
//   it's the only KSK for a currently-enabled DNSSEC. Disable DNSSEC signing,
//   or add or enable another KSK.
//
//   * ErrCodeKeySigningKeyInParentDSRecord "KeySigningKeyInParentDSRecord"
//   The key-signing key (KSK) is specified in a parent DS record.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeactivateKeySigningKey
func (c *Route53) DeactivateKeySigningKey(input *DeactivateKeySigningKeyInput) (*DeactivateKeySigningKeyOutput, error) {
	req, out := c.DeactivateKeySigningKeyRequest(input)
	return out, req.Send()
}

// DeactivateKeySigningKeyWithContext is the same as DeactivateKeySigningKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateKeySigningKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeactivateKeySigningKeyWithContext(ctx aws.Context, input *DeactivateKeySigningKeyInput, opts ...request.Option) (*DeactivateKeySigningKeyOutput, error) {
	req, out := c.DeactivateKeySigningKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHealthCheck = "DeleteHealthCheck"

// DeleteHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHealthCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHealthCheck for more information on using the DeleteHealthCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHealthCheckRequest method.
//    req, resp := client.DeleteHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck
func (c *Route53) DeleteHealthCheckRequest(input *DeleteHealthCheckInput) (req *request.Request, output *DeleteHealthCheckOutput) {
	op := &request.Operation{
		Name:       opDeleteHealthCheck,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &DeleteHealthCheckInput{}
	}

	output = &DeleteHealthCheckOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHealthCheck API operation for Amazon Route 53.
//
// Deletes a health check.
//
// Amazon Route 53 does not prevent you from deleting a health check even if
// the health check is associated with one or more resource record sets. If
// you delete a health check and you don't update the associated resource record
// sets, the future status of the health check can't be predicted and may change.
// This will affect the routing of DNS queries for your DNS failover configuration.
// For more information, see Replacing and Deleting Health Checks (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html)
// in the Amazon Route 53 Developer Guide.
//
// If you're using Cloud Map and you configured Cloud Map to create a Route
// 53 health check when you register an instance, you can't use the Route 53
// DeleteHealthCheck command to delete the health check. The health check is
// deleted automatically when you deregister the instance; there can be a delay
// of several hours before the health check is deleted from Route 53.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeHealthCheckInUse "HealthCheckInUse"
//   This error code is not in use.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck
func (c *Route53) DeleteHealthCheck(input *DeleteHealthCheckInput) (*DeleteHealthCheckOutput, error) {
	req, out := c.DeleteHealthCheckRequest(input)
	return out, req.Send()
}

// DeleteHealthCheckWithContext is the same as DeleteHealthCheck with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHealthCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteHealthCheckWithContext(ctx aws.Context, input *DeleteHealthCheckInput, opts ...request.Option) (*DeleteHealthCheckOutput, error) {
	req, out := c.DeleteHealthCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHostedZone = "DeleteHostedZone"

// DeleteHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHostedZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHostedZone for more information on using the DeleteHostedZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHostedZoneRequest method.
//    req, resp := client.DeleteHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone
func (c *Route53) DeleteHostedZoneRequest(input *DeleteHostedZoneInput) (req *request.Request, output *DeleteHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDeleteHostedZone,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &DeleteHostedZoneInput{}
	}

	output = &DeleteHostedZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteHostedZone API operation for Amazon Route 53.
//
// Deletes a hosted zone.
//
// If the hosted zone was created by another service, such as Cloud Map, see
// Deleting Public Hosted Zones That Were Created by Another Service (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service)
// in the Amazon Route 53 Developer Guide for information about how to delete
// it. (The process is the same for public and private hosted zones that were
// created by another service.)
//
// If you want to keep your domain registration but you want to stop routing
// internet traffic to your website or web application, we recommend that you
// delete resource record sets in the hosted zone instead of deleting the hosted
// zone.
//
// If you delete a hosted zone, you can't undelete it. You must create a new
// hosted zone and update the name servers for your domain registration, which
// can require up to 48 hours to take effect. (If you delegated responsibility
// for a subdomain to a hosted zone and you delete the child hosted zone, you
// must update the name servers in the parent hosted zone.) In addition, if
// you delete a hosted zone, someone could hijack the domain and route traffic
// to their own resources using your domain name.
//
// If you want to avoid the monthly charge for the hosted zone, you can transfer
// DNS service for the domain to a free DNS service. When you transfer DNS service,
// you have to update the name servers for the domain registration. If the domain
// is registered with Route 53, see UpdateDomainNameservers (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html)
// for information about how to replace Route 53 name servers with name servers
// for the new DNS service. If the domain is registered with another registrar,
// use the method provided by the registrar to update name servers for the domain
// registration. For more information, perform an internet search on "free DNS
// service."
//
// You can delete a hosted zone only if it contains only the default SOA record
// and NS resource record sets. If the hosted zone contains other resource record
// sets, you must delete them before you can delete the hosted zone. If you
// try to delete a hosted zone that contains other resource record sets, the
// request fails, and Route 53 returns a HostedZoneNotEmpty error. For information
// about deleting records from your hosted zone, see ChangeResourceRecordSets
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html).
//
// To verify that the hosted zone has been deleted, do one of the following:
//
//    * Use the GetHostedZone action to request information about the hosted
//    zone.
//
//    * Use the ListHostedZones action to get a list of the hosted zones associated
//    with the current account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteHostedZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeHostedZoneNotEmpty "HostedZoneNotEmpty"
//   The hosted zone contains resource records that are not SOA or NS records.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeInvalidDomainName "InvalidDomainName"
//   The specified domain name is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone
func (c *Route53) DeleteHostedZone(input *DeleteHostedZoneInput) (*DeleteHostedZoneOutput, error) {
	req, out := c.DeleteHostedZoneRequest(input)
	return out, req.Send()
}

// DeleteHostedZoneWithContext is the same as DeleteHostedZone with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHostedZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteHostedZoneWithContext(ctx aws.Context, input *DeleteHostedZoneInput, opts ...request.Option) (*DeleteHostedZoneOutput, error) {
	req, out := c.DeleteHostedZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeySigningKey = "DeleteKeySigningKey"

// DeleteKeySigningKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeySigningKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeySigningKey for more information on using the DeleteKeySigningKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeySigningKeyRequest method.
//    req, resp := client.DeleteKeySigningKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteKeySigningKey
func (c *Route53) DeleteKeySigningKeyRequest(input *DeleteKeySigningKeyInput) (req *request.Request, output *DeleteKeySigningKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteKeySigningKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}",
	}

	if input == nil {
		input = &DeleteKeySigningKeyInput{}
	}

	output = &DeleteKeySigningKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKeySigningKey API operation for Amazon Route 53.
//
// Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate
// it. The KSK must be deactivated before you can delete it regardless of whether
// the hosted zone is enabled for DNSSEC signing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteKeySigningKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeNoSuchKeySigningKey "NoSuchKeySigningKey"
//   The specified key-signing key (KSK) doesn't exist.
//
//   * ErrCodeInvalidKeySigningKeyStatus "InvalidKeySigningKeyStatus"
//   The key-signing key (KSK) status isn't valid or another KSK has the status
//   INTERNAL_FAILURE.
//
//   * ErrCodeInvalidSigningStatus "InvalidSigningStatus"
//   Your hosted zone status isn't valid for this operation. In the hosted zone,
//   change the status to enable DNSSEC or disable DNSSEC.
//
//   * ErrCodeInvalidKMSArn "InvalidKMSArn"
//   The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
//   signing.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteKeySigningKey
func (c *Route53) DeleteKeySigningKey(input *DeleteKeySigningKeyInput) (*DeleteKeySigningKeyOutput, error) {
	req, out := c.DeleteKeySigningKeyRequest(input)
	return out, req.Send()
}

// DeleteKeySigningKeyWithContext is the same as DeleteKeySigningKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeySigningKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteKeySigningKeyWithContext(ctx aws.Context, input *DeleteKeySigningKeyInput, opts ...request.Option) (*DeleteKeySigningKeyOutput, error) {
	req, out := c.DeleteKeySigningKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueryLoggingConfig = "DeleteQueryLoggingConfig"

// DeleteQueryLoggingConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueryLoggingConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueryLoggingConfig for more information on using the DeleteQueryLoggingConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteQueryLoggingConfigRequest method.
//    req, resp := client.DeleteQueryLoggingConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig
func (c *Route53) DeleteQueryLoggingConfigRequest(input *DeleteQueryLoggingConfigInput) (req *request.Request, output *DeleteQueryLoggingConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteQueryLoggingConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/queryloggingconfig/{Id}",
	}

	if input == nil {
		input = &DeleteQueryLoggingConfigInput{}
	}

	output = &DeleteQueryLoggingConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteQueryLoggingConfig API operation for Amazon Route 53.
//
// Deletes a configuration for DNS query logging. If you delete a configuration,
// Amazon Route 53 stops sending query logs to CloudWatch Logs. Route 53 doesn't
// delete any logs that are already in CloudWatch Logs.
//
// For more information about DNS query logs, see CreateQueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteQueryLoggingConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeNoSuchQueryLoggingConfig "NoSuchQueryLoggingConfig"
//   There is no DNS query logging configuration with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig
func (c *Route53) DeleteQueryLoggingConfig(input *DeleteQueryLoggingConfigInput) (*DeleteQueryLoggingConfigOutput, error) {
	req, out := c.DeleteQueryLoggingConfigRequest(input)
	return out, req.Send()
}

// DeleteQueryLoggingConfigWithContext is the same as DeleteQueryLoggingConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueryLoggingConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteQueryLoggingConfigWithContext(ctx aws.Context, input *DeleteQueryLoggingConfigInput, opts ...request.Option) (*DeleteQueryLoggingConfigOutput, error) {
	req, out := c.DeleteQueryLoggingConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReusableDelegationSet = "DeleteReusableDelegationSet"

// DeleteReusableDelegationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReusableDelegationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReusableDelegationSet for more information on using the DeleteReusableDelegationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReusableDelegationSetRequest method.
//    req, resp := client.DeleteReusableDelegationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet
func (c *Route53) DeleteReusableDelegationSetRequest(input *DeleteReusableDelegationSetInput) (req *request.Request, output *DeleteReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReusableDelegationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &DeleteReusableDelegationSetInput{}
	}

	output = &DeleteReusableDelegationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReusableDelegationSet API operation for Amazon Route 53.
//
// Deletes a reusable delegation set.
//
// You can delete a reusable delegation set only if it isn't associated with
// any hosted zones.
//
// To verify that the reusable delegation set is not associated with any hosted
// zones, submit a GetReusableDelegationSet (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html)
// request and specify the ID of the reusable delegation set that you want to
// delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteReusableDelegationSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDelegationSet "NoSuchDelegationSet"
//   A reusable delegation set with the specified ID does not exist.
//
//   * ErrCodeDelegationSetInUse "DelegationSetInUse"
//   The specified delegation contains associated hosted zones which must be deleted
//   before the reusable delegation set can be deleted.
//
//   * ErrCodeDelegationSetNotReusable "DelegationSetNotReusable"
//   A reusable delegation set with the specified ID does not exist.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet
func (c *Route53) DeleteReusableDelegationSet(input *DeleteReusableDelegationSetInput) (*DeleteReusableDelegationSetOutput, error) {
	req, out := c.DeleteReusableDelegationSetRequest(input)
	return out, req.Send()
}

// DeleteReusableDelegationSetWithContext is the same as DeleteReusableDelegationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReusableDelegationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteReusableDelegationSetWithContext(ctx aws.Context, input *DeleteReusableDelegationSetInput, opts ...request.Option) (*DeleteReusableDelegationSetOutput, error) {
	req, out := c.DeleteReusableDelegationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficPolicy = "DeleteTrafficPolicy"

// DeleteTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficPolicy for more information on using the DeleteTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrafficPolicyRequest method.
//    req, resp := client.DeleteTrafficPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy
func (c *Route53) DeleteTrafficPolicyRequest(input *DeleteTrafficPolicyInput) (req *request.Request, output *DeleteTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInput{}
	}

	output = &DeleteTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrafficPolicy API operation for Amazon Route 53.
//
// Deletes a traffic policy.
//
// When you delete a traffic policy, Route 53 sets a flag on the policy to indicate
// that it has been deleted. However, Route 53 never fully deletes the traffic
// policy. Note the following:
//
//    * Deleted traffic policies aren't listed if you run ListTrafficPolicies
//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html).
//
//    * There's no way to get a list of deleted policies.
//
//    * If you retain the ID of the policy, you can get information about the
//    policy, including the traffic policy document, by running GetTrafficPolicy
//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteTrafficPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeTrafficPolicyInUse "TrafficPolicyInUse"
//   One or more traffic policy instances were created by using the specified
//   traffic policy.
//
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy
func (c *Route53) DeleteTrafficPolicy(input *DeleteTrafficPolicyInput) (*DeleteTrafficPolicyOutput, error) {
	req, out := c.DeleteTrafficPolicyRequest(input)
	return out, req.Send()
}

// DeleteTrafficPolicyWithContext is the same as DeleteTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteTrafficPolicyWithContext(ctx aws.Context, input *DeleteTrafficPolicyInput, opts ...request.Option) (*DeleteTrafficPolicyOutput, error) {
	req, out := c.DeleteTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficPolicyInstance = "DeleteTrafficPolicyInstance"

// DeleteTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficPolicyInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficPolicyInstance for more information on using the DeleteTrafficPolicyInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrafficPolicyInstanceRequest method.
//    req, resp := client.DeleteTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance
func (c *Route53) DeleteTrafficPolicyInstanceRequest(input *DeleteTrafficPolicyInstanceInput) (req *request.Request, output *DeleteTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicyInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInstanceInput{}
	}

	output = &DeleteTrafficPolicyInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrafficPolicyInstance API operation for Amazon Route 53.
//
// Deletes a traffic policy instance and all of the resource record sets that
// Amazon Route 53 created when you created the instance.
//
// In the Route 53 console, traffic policy instances are known as policy records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchTrafficPolicyInstance "NoSuchTrafficPolicyInstance"
//   No traffic policy instance exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance
func (c *Route53) DeleteTrafficPolicyInstance(input *DeleteTrafficPolicyInstanceInput) (*DeleteTrafficPolicyInstanceOutput, error) {
	req, out := c.DeleteTrafficPolicyInstanceRequest(input)
	return out, req.Send()
}

// DeleteTrafficPolicyInstanceWithContext is the same as DeleteTrafficPolicyInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficPolicyInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteTrafficPolicyInstanceWithContext(ctx aws.Context, input *DeleteTrafficPolicyInstanceInput, opts ...request.Option) (*DeleteTrafficPolicyInstanceOutput, error) {
	req, out := c.DeleteTrafficPolicyInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVPCAssociationAuthorization = "DeleteVPCAssociationAuthorization"

// DeleteVPCAssociationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVPCAssociationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVPCAssociationAuthorization for more information on using the DeleteVPCAssociationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVPCAssociationAuthorizationRequest method.
//    req, resp := client.DeleteVPCAssociationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization
func (c *Route53) DeleteVPCAssociationAuthorizationRequest(input *DeleteVPCAssociationAuthorizationInput) (req *request.Request, output *DeleteVPCAssociationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteVPCAssociationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/deauthorizevpcassociation",
	}

	if input == nil {
		input = &DeleteVPCAssociationAuthorizationInput{}
	}

	output = &DeleteVPCAssociationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVPCAssociationAuthorization API operation for Amazon Route 53.
//
// Removes authorization to submit an AssociateVPCWithHostedZone request to
// associate a specified VPC with a hosted zone that was created by a different
// account. You must use the account that created the hosted zone to submit
// a DeleteVPCAssociationAuthorization request.
//
// Sending this request only prevents the account that created the VPC from
// associating the VPC with the Amazon Route 53 hosted zone in the future. If
// the VPC is already associated with the hosted zone, DeleteVPCAssociationAuthorization
// won't disassociate the VPC from the hosted zone. If you want to delete an
// existing association, use DisassociateVPCFromHostedZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteVPCAssociationAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeVPCAssociationAuthorizationNotFound "VPCAssociationAuthorizationNotFound"
//   The VPC that you specified is not authorized to be associated with the hosted
//   zone.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidVPCId "InvalidVPCId"
//   The VPC ID that you specified either isn't a valid ID or the current account
//   is not authorized to access this VPC.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization
func (c *Route53) DeleteVPCAssociationAuthorization(input *DeleteVPCAssociationAuthorizationInput) (*DeleteVPCAssociationAuthorizationOutput, error) {
	req, out := c.DeleteVPCAssociationAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteVPCAssociationAuthorizationWithContext is the same as DeleteVPCAssociationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVPCAssociationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DeleteVPCAssociationAuthorizationWithContext(ctx aws.Context, input *DeleteVPCAssociationAuthorizationInput, opts ...request.Option) (*DeleteVPCAssociationAuthorizationOutput, error) {
	req, out := c.DeleteVPCAssociationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableHostedZoneDNSSEC = "DisableHostedZoneDNSSEC"

// DisableHostedZoneDNSSECRequest generates a "aws/request.Request" representing the
// client's request for the DisableHostedZoneDNSSEC operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableHostedZoneDNSSEC for more information on using the DisableHostedZoneDNSSEC
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableHostedZoneDNSSECRequest method.
//    req, resp := client.DisableHostedZoneDNSSECRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisableHostedZoneDNSSEC
func (c *Route53) DisableHostedZoneDNSSECRequest(input *DisableHostedZoneDNSSECInput) (req *request.Request, output *DisableHostedZoneDNSSECOutput) {
	op := &request.Operation{
		Name:       opDisableHostedZoneDNSSEC,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/disable-dnssec",
	}

	if input == nil {
		input = &DisableHostedZoneDNSSECInput{}
	}

	output = &DisableHostedZoneDNSSECOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableHostedZoneDNSSEC API operation for Amazon Route 53.
//
// Disables DNSSEC signing in a specific hosted zone. This action does not deactivate
// any key-signing keys (KSKs) that are active in the hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DisableHostedZoneDNSSEC for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   Parameter name is not valid.
//
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeKeySigningKeyInParentDSRecord "KeySigningKeyInParentDSRecord"
//   The key-signing key (KSK) is specified in a parent DS record.
//
//   * ErrCodeDNSSECNotFound "DNSSECNotFound"
//   The hosted zone doesn't have any DNSSEC resources.
//
//   * ErrCodeInvalidKeySigningKeyStatus "InvalidKeySigningKeyStatus"
//   The key-signing key (KSK) status isn't valid or another KSK has the status
//   INTERNAL_FAILURE.
//
//   * ErrCodeInvalidKMSArn "InvalidKMSArn"
//   The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
//   signing.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisableHostedZoneDNSSEC
func (c *Route53) DisableHostedZoneDNSSEC(input *DisableHostedZoneDNSSECInput) (*DisableHostedZoneDNSSECOutput, error) {
	req, out := c.DisableHostedZoneDNSSECRequest(input)
	return out, req.Send()
}

// DisableHostedZoneDNSSECWithContext is the same as DisableHostedZoneDNSSEC with the addition of
// the ability to pass a context and additional request options.
//
// See DisableHostedZoneDNSSEC for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DisableHostedZoneDNSSECWithContext(ctx aws.Context, input *DisableHostedZoneDNSSECInput, opts ...request.Option) (*DisableHostedZoneDNSSECOutput, error) {
	req, out := c.DisableHostedZoneDNSSECRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateVPCFromHostedZone = "DisassociateVPCFromHostedZone"

// DisassociateVPCFromHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateVPCFromHostedZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateVPCFromHostedZone for more information on using the DisassociateVPCFromHostedZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateVPCFromHostedZoneRequest method.
//    req, resp := client.DisassociateVPCFromHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone
func (c *Route53) DisassociateVPCFromHostedZoneRequest(input *DisassociateVPCFromHostedZoneInput) (req *request.Request, output *DisassociateVPCFromHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDisassociateVPCFromHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/disassociatevpc",
	}

	if input == nil {
		input = &DisassociateVPCFromHostedZoneInput{}
	}

	output = &DisassociateVPCFromHostedZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateVPCFromHostedZone API operation for Amazon Route 53.
//
// Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon
// Route 53 private hosted zone. Note the following:
//
//    * You can't disassociate the last Amazon VPC from a private hosted zone.
//
//    * You can't convert a private hosted zone into a public hosted zone.
//
//    * You can submit a DisassociateVPCFromHostedZone request using either
//    the account that created the hosted zone or the account that created the
//    Amazon VPC.
//
//    * Some services, such as Cloud Map and Amazon Elastic File System (Amazon
//    EFS) automatically create hosted zones and associate VPCs with the hosted
//    zones. A service can create a hosted zone using your account or using
//    its own account. You can disassociate a VPC from a hosted zone only if
//    the service created the hosted zone using your account. When you run DisassociateVPCFromHostedZone
//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html),
//    if the hosted zone has a value for OwningAccount, you can use DisassociateVPCFromHostedZone.
//    If the hosted zone has a value for OwningService, you can't use DisassociateVPCFromHostedZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DisassociateVPCFromHostedZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidVPCId "InvalidVPCId"
//   The VPC ID that you specified either isn't a valid ID or the current account
//   is not authorized to access this VPC.
//
//   * ErrCodeVPCAssociationNotFound "VPCAssociationNotFound"
//   The specified VPC and hosted zone are not currently associated.
//
//   * ErrCodeLastVPCAssociation "LastVPCAssociation"
//   The VPC that you're trying to disassociate from the private hosted zone is
//   the last VPC that is associated with the hosted zone. Amazon Route 53 doesn't
//   support disassociating the last VPC from a hosted zone.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone
func (c *Route53) DisassociateVPCFromHostedZone(input *DisassociateVPCFromHostedZoneInput) (*DisassociateVPCFromHostedZoneOutput, error) {
	req, out := c.DisassociateVPCFromHostedZoneRequest(input)
	return out, req.Send()
}

// DisassociateVPCFromHostedZoneWithContext is the same as DisassociateVPCFromHostedZone with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateVPCFromHostedZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) DisassociateVPCFromHostedZoneWithContext(ctx aws.Context, input *DisassociateVPCFromHostedZoneInput, opts ...request.Option) (*DisassociateVPCFromHostedZoneOutput, error) {
	req, out := c.DisassociateVPCFromHostedZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableHostedZoneDNSSEC = "EnableHostedZoneDNSSEC"

// EnableHostedZoneDNSSECRequest generates a "aws/request.Request" representing the
// client's request for the EnableHostedZoneDNSSEC operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableHostedZoneDNSSEC for more information on using the EnableHostedZoneDNSSEC
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableHostedZoneDNSSECRequest method.
//    req, resp := client.EnableHostedZoneDNSSECRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/EnableHostedZoneDNSSEC
func (c *Route53) EnableHostedZoneDNSSECRequest(input *EnableHostedZoneDNSSECInput) (req *request.Request, output *EnableHostedZoneDNSSECOutput) {
	op := &request.Operation{
		Name:       opEnableHostedZoneDNSSEC,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/enable-dnssec",
	}

	if input == nil {
		input = &EnableHostedZoneDNSSECInput{}
	}

	output = &EnableHostedZoneDNSSECOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableHostedZoneDNSSEC API operation for Amazon Route 53.
//
// Enables DNSSEC signing in a specific hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation EnableHostedZoneDNSSEC for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   Parameter name is not valid.
//
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
//   * ErrCodeKeySigningKeyWithActiveStatusNotFound "KeySigningKeyWithActiveStatusNotFound"
//   A key-signing key (KSK) with ACTIVE status wasn't found.
//
//   * ErrCodeInvalidKMSArn "InvalidKMSArn"
//   The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
//   signing.
//
//   * ErrCodeHostedZonePartiallyDelegated "HostedZonePartiallyDelegated"
//   The hosted zone nameservers don't match the parent nameservers. The hosted
//   zone and parent must have the same nameservers.
//
//   * ErrCodeDNSSECNotFound "DNSSECNotFound"
//   The hosted zone doesn't have any DNSSEC resources.
//
//   * ErrCodeInvalidKeySigningKeyStatus "InvalidKeySigningKeyStatus"
//   The key-signing key (KSK) status isn't valid or another KSK has the status
//   INTERNAL_FAILURE.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/EnableHostedZoneDNSSEC
func (c *Route53) EnableHostedZoneDNSSEC(input *EnableHostedZoneDNSSECInput) (*EnableHostedZoneDNSSECOutput, error) {
	req, out := c.EnableHostedZoneDNSSECRequest(input)
	return out, req.Send()
}

// EnableHostedZoneDNSSECWithContext is the same as EnableHostedZoneDNSSEC with the addition of
// the ability to pass a context and additional request options.
//
// See EnableHostedZoneDNSSEC for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) EnableHostedZoneDNSSECWithContext(ctx aws.Context, input *EnableHostedZoneDNSSECInput, opts ...request.Option) (*EnableHostedZoneDNSSECOutput, error) {
	req, out := c.EnableHostedZoneDNSSECRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountLimit = "GetAccountLimit"

// GetAccountLimitRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountLimit for more information on using the GetAccountLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountLimitRequest method.
//    req, resp := client.GetAccountLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetAccountLimit
func (c *Route53) GetAccountLimitRequest(input *GetAccountLimitInput) (req *request.Request, output *GetAccountLimitOutput) {
	op := &request.Operation{
		Name:       opGetAccountLimit,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/accountlimit/{Type}",
	}

	if input == nil {
		input = &GetAccountLimitInput{}
	}

	output = &GetAccountLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountLimit API operation for Amazon Route 53.
//
// Gets the specified limit for the current account, for example, the maximum
// number of health checks that you can create using the account.
//
// For the default limit, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide. To request a higher limit, open a
// case (https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-route53).
//
// You can also view account limits in Amazon Web Services Trusted Advisor.
// Sign in to the Management Console and open the Trusted Advisor console at
// https://console.aws.amazon.com/trustedadvisor/ (https://console.aws.amazon.com/trustedadvisor).
// Then choose Service limits in the navigation pane.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetAccountLimit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetAccountLimit
func (c *Route53) GetAccountLimit(input *GetAccountLimitInput) (*GetAccountLimitOutput, error) {
	req, out := c.GetAccountLimitRequest(input)
	return out, req.Send()
}

// GetAccountLimitWithContext is the same as GetAccountLimit with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetAccountLimitWithContext(ctx aws.Context, input *GetAccountLimitInput, opts ...request.Option) (*GetAccountLimitOutput, error) {
	req, out := c.GetAccountLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChange = "GetChange"

// GetChangeRequest generates a "aws/request.Request" representing the
// client's request for the GetChange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChange for more information on using the GetChange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChangeRequest method.
//    req, resp := client.GetChangeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange
func (c *Route53) GetChangeRequest(input *GetChangeInput) (req *request.Request, output *GetChangeOutput) {
	op := &request.Operation{
		Name:       opGetChange,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/change/{Id}",
	}

	if input == nil {
		input = &GetChangeInput{}
	}

	output = &GetChangeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChange API operation for Amazon Route 53.
//
// Returns the current status of a change batch request. The status is one of
// the following values:
//
//    * PENDING indicates that the changes in this request have not propagated
//    to all Amazon Route 53 DNS servers. This is the initial status of all
//    change batch requests.
//
//    * INSYNC indicates that the changes have propagated to all Route 53 DNS
//    servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetChange for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchChange "NoSuchChange"
//   A change with the specified change ID does not exist.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange
func (c *Route53) GetChange(input *GetChangeInput) (*GetChangeOutput, error) {
	req, out := c.GetChangeRequest(input)
	return out, req.Send()
}

// GetChangeWithContext is the same as GetChange with the addition of
// the ability to pass a context and additional request options.
//
// See GetChange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetChangeWithContext(ctx aws.Context, input *GetChangeInput, opts ...request.Option) (*GetChangeOutput, error) {
	req, out := c.GetChangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCheckerIpRanges = "GetCheckerIpRanges"

// GetCheckerIpRangesRequest generates a "aws/request.Request" representing the
// client's request for the GetCheckerIpRanges operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCheckerIpRanges for more information on using the GetCheckerIpRanges
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCheckerIpRangesRequest method.
//    req, resp := client.GetCheckerIpRangesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges
func (c *Route53) GetCheckerIpRangesRequest(input *GetCheckerIpRangesInput) (req *request.Request, output *GetCheckerIpRangesOutput) {
	op := &request.Operation{
		Name:       opGetCheckerIpRanges,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/checkeripranges",
	}

	if input == nil {
		input = &GetCheckerIpRangesInput{}
	}

	output = &GetCheckerIpRangesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCheckerIpRanges API operation for Amazon Route 53.
//
// Route 53 does not perform authorization for this API because it retrieves
// information that is already available to the public.
//
// GetCheckerIpRanges still works, but we recommend that you download ip-ranges.json,
// which includes IP address ranges for all Amazon Web Services services. For
// more information, see IP Address Ranges of Amazon Route 53 Servers (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetCheckerIpRanges for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges
func (c *Route53) GetCheckerIpRanges(input *GetCheckerIpRangesInput) (*GetCheckerIpRangesOutput, error) {
	req, out := c.GetCheckerIpRangesRequest(input)
	return out, req.Send()
}

// GetCheckerIpRangesWithContext is the same as GetCheckerIpRanges with the addition of
// the ability to pass a context and additional request options.
//
// See GetCheckerIpRanges for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetCheckerIpRangesWithContext(ctx aws.Context, input *GetCheckerIpRangesInput, opts ...request.Option) (*GetCheckerIpRangesOutput, error) {
	req, out := c.GetCheckerIpRangesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDNSSEC = "GetDNSSEC"

// GetDNSSECRequest generates a "aws/request.Request" representing the
// client's request for the GetDNSSEC operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDNSSEC for more information on using the GetDNSSEC
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDNSSECRequest method.
//    req, resp := client.GetDNSSECRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetDNSSEC
func (c *Route53) GetDNSSECRequest(input *GetDNSSECInput) (req *request.Request, output *GetDNSSECOutput) {
	op := &request.Operation{
		Name:       opGetDNSSEC,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/dnssec",
	}

	if input == nil {
		input = &GetDNSSECInput{}
	}

	output = &GetDNSSECOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDNSSEC API operation for Amazon Route 53.
//
// Returns information about DNSSEC for a specific hosted zone, including the
// key-signing keys (KSKs) in the hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetDNSSEC for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   Parameter name is not valid.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetDNSSEC
func (c *Route53) GetDNSSEC(input *GetDNSSECInput) (*GetDNSSECOutput, error) {
	req, out := c.GetDNSSECRequest(input)
	return out, req.Send()
}

// GetDNSSECWithContext is the same as GetDNSSEC with the addition of
// the ability to pass a context and additional request options.
//
// See GetDNSSEC for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetDNSSECWithContext(ctx aws.Context, input *GetDNSSECInput, opts ...request.Option) (*GetDNSSECOutput, error) {
	req, out := c.GetDNSSECRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGeoLocation = "GetGeoLocation"

// GetGeoLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetGeoLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeoLocation for more information on using the GetGeoLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGeoLocationRequest method.
//    req, resp := client.GetGeoLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation
func (c *Route53) GetGeoLocationRequest(input *GetGeoLocationInput) (req *request.Request, output *GetGeoLocationOutput) {
	op := &request.Operation{
		Name:       opGetGeoLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocation",
	}

	if input == nil {
		input = &GetGeoLocationInput{}
	}

	output = &GetGeoLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGeoLocation API operation for Amazon Route 53.
//
// Gets information about whether a specified geographic location is supported
// for Amazon Route 53 geolocation resource record sets.
//
// Route 53 does not perform authorization for this API because it retrieves
// information that is already available to the public.
//
// Use the following syntax to determine whether a continent is supported for
// geolocation:
//
// GET /2013-04-01/geolocation?continentcode=two-letter abbreviation for a continent
//
// Use the following syntax to determine whether a country is supported for
// geolocation:
//
// GET /2013-04-01/geolocation?countrycode=two-character country code
//
// Use the following syntax to determine whether a subdivision of a country
// is supported for geolocation:
//
// GET /2013-04-01/geolocation?countrycode=two-character country code&subdivisioncode=subdivision
// code
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetGeoLocation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchGeoLocation "NoSuchGeoLocation"
//   Amazon Route 53 doesn't support the specified geographic location. For a
//   list of supported geolocation codes, see the GeoLocation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html)
//   data type.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation
func (c *Route53) GetGeoLocation(input *GetGeoLocationInput) (*GetGeoLocationOutput, error) {
	req, out := c.GetGeoLocationRequest(input)
	return out, req.Send()
}

// GetGeoLocationWithContext is the same as GetGeoLocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeoLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetGeoLocationWithContext(ctx aws.Context, input *GetGeoLocationInput, opts ...request.Option) (*GetGeoLocationOutput, error) {
	req, out := c.GetGeoLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHealthCheck = "GetHealthCheck"

// GetHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHealthCheck for more information on using the GetHealthCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHealthCheckRequest method.
//    req, resp := client.GetHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck
func (c *Route53) GetHealthCheckRequest(input *GetHealthCheckInput) (req *request.Request, output *GetHealthCheckOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheck,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &GetHealthCheckInput{}
	}

	output = &GetHealthCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHealthCheck API operation for Amazon Route 53.
//
// Gets information about a specified health check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeIncompatibleVersion "IncompatibleVersion"
//   The resource you're trying to access is unsupported on this Amazon Route
//   53 endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck
func (c *Route53) GetHealthCheck(input *GetHealthCheckInput) (*GetHealthCheckOutput, error) {
	req, out := c.GetHealthCheckRequest(input)
	return out, req.Send()
}

// GetHealthCheckWithContext is the same as GetHealthCheck with the addition of
// the ability to pass a context and additional request options.
//
// See GetHealthCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHealthCheckWithContext(ctx aws.Context, input *GetHealthCheckInput, opts ...request.Option) (*GetHealthCheckOutput, error) {
	req, out := c.GetHealthCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHealthCheckCount = "GetHealthCheckCount"

// GetHealthCheckCountRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheckCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHealthCheckCount for more information on using the GetHealthCheckCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHealthCheckCountRequest method.
//    req, resp := client.GetHealthCheckCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount
func (c *Route53) GetHealthCheckCountRequest(input *GetHealthCheckCountInput) (req *request.Request, output *GetHealthCheckCountOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheckcount",
	}

	if input == nil {
		input = &GetHealthCheckCountInput{}
	}

	output = &GetHealthCheckCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHealthCheckCount API operation for Amazon Route 53.
//
// Retrieves the number of health checks that are associated with the current
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheckCount for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount
func (c *Route53) GetHealthCheckCount(input *GetHealthCheckCountInput) (*GetHealthCheckCountOutput, error) {
	req, out := c.GetHealthCheckCountRequest(input)
	return out, req.Send()
}

// GetHealthCheckCountWithContext is the same as GetHealthCheckCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetHealthCheckCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHealthCheckCountWithContext(ctx aws.Context, input *GetHealthCheckCountInput, opts ...request.Option) (*GetHealthCheckCountOutput, error) {
	req, out := c.GetHealthCheckCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHealthCheckLastFailureReason = "GetHealthCheckLastFailureReason"

// GetHealthCheckLastFailureReasonRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheckLastFailureReason operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHealthCheckLastFailureReason for more information on using the GetHealthCheckLastFailureReason
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHealthCheckLastFailureReasonRequest method.
//    req, resp := client.GetHealthCheckLastFailureReasonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason
func (c *Route53) GetHealthCheckLastFailureReasonRequest(input *GetHealthCheckLastFailureReasonInput) (req *request.Request, output *GetHealthCheckLastFailureReasonOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckLastFailureReason,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
	}

	if input == nil {
		input = &GetHealthCheckLastFailureReasonInput{}
	}

	output = &GetHealthCheckLastFailureReasonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHealthCheckLastFailureReason API operation for Amazon Route 53.
//
// Gets the reason that a specified health check failed most recently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheckLastFailureReason for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason
func (c *Route53) GetHealthCheckLastFailureReason(input *GetHealthCheckLastFailureReasonInput) (*GetHealthCheckLastFailureReasonOutput, error) {
	req, out := c.GetHealthCheckLastFailureReasonRequest(input)
	return out, req.Send()
}

// GetHealthCheckLastFailureReasonWithContext is the same as GetHealthCheckLastFailureReason with the addition of
// the ability to pass a context and additional request options.
//
// See GetHealthCheckLastFailureReason for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHealthCheckLastFailureReasonWithContext(ctx aws.Context, input *GetHealthCheckLastFailureReasonInput, opts ...request.Option) (*GetHealthCheckLastFailureReasonOutput, error) {
	req, out := c.GetHealthCheckLastFailureReasonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHealthCheckStatus = "GetHealthCheckStatus"

// GetHealthCheckStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheckStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHealthCheckStatus for more information on using the GetHealthCheckStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHealthCheckStatusRequest method.
//    req, resp := client.GetHealthCheckStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus
func (c *Route53) GetHealthCheckStatusRequest(input *GetHealthCheckStatusInput) (req *request.Request, output *GetHealthCheckStatusOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/status",
	}

	if input == nil {
		input = &GetHealthCheckStatusInput{}
	}

	output = &GetHealthCheckStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHealthCheckStatus API operation for Amazon Route 53.
//
// Gets status of a specified health check.
//
// This API is intended for use during development to diagnose behavior. It
// doesn’t support production use-cases with high query rates that require
// immediate and actionable responses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheckStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus
func (c *Route53) GetHealthCheckStatus(input *GetHealthCheckStatusInput) (*GetHealthCheckStatusOutput, error) {
	req, out := c.GetHealthCheckStatusRequest(input)
	return out, req.Send()
}

// GetHealthCheckStatusWithContext is the same as GetHealthCheckStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetHealthCheckStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHealthCheckStatusWithContext(ctx aws.Context, input *GetHealthCheckStatusInput, opts ...request.Option) (*GetHealthCheckStatusOutput, error) {
	req, out := c.GetHealthCheckStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHostedZone = "GetHostedZone"

// GetHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the GetHostedZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHostedZone for more information on using the GetHostedZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHostedZoneRequest method.
//    req, resp := client.GetHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone
func (c *Route53) GetHostedZoneRequest(input *GetHostedZoneInput) (req *request.Request, output *GetHostedZoneOutput) {
	op := &request.Operation{
		Name:       opGetHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &GetHostedZoneInput{}
	}

	output = &GetHostedZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHostedZone API operation for Amazon Route 53.
//
// Gets information about a specified hosted zone including the four name servers
// assigned to the hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHostedZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone
func (c *Route53) GetHostedZone(input *GetHostedZoneInput) (*GetHostedZoneOutput, error) {
	req, out := c.GetHostedZoneRequest(input)
	return out, req.Send()
}

// GetHostedZoneWithContext is the same as GetHostedZone with the addition of
// the ability to pass a context and additional request options.
//
// See GetHostedZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHostedZoneWithContext(ctx aws.Context, input *GetHostedZoneInput, opts ...request.Option) (*GetHostedZoneOutput, error) {
	req, out := c.GetHostedZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHostedZoneCount = "GetHostedZoneCount"

// GetHostedZoneCountRequest generates a "aws/request.Request" representing the
// client's request for the GetHostedZoneCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHostedZoneCount for more information on using the GetHostedZoneCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHostedZoneCountRequest method.
//    req, resp := client.GetHostedZoneCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount
func (c *Route53) GetHostedZoneCountRequest(input *GetHostedZoneCountInput) (req *request.Request, output *GetHostedZoneCountOutput) {
	op := &request.Operation{
		Name:       opGetHostedZoneCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonecount",
	}

	if input == nil {
		input = &GetHostedZoneCountInput{}
	}

	output = &GetHostedZoneCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHostedZoneCount API operation for Amazon Route 53.
//
// Retrieves the number of hosted zones that are associated with the current
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHostedZoneCount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount
func (c *Route53) GetHostedZoneCount(input *GetHostedZoneCountInput) (*GetHostedZoneCountOutput, error) {
	req, out := c.GetHostedZoneCountRequest(input)
	return out, req.Send()
}

// GetHostedZoneCountWithContext is the same as GetHostedZoneCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetHostedZoneCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHostedZoneCountWithContext(ctx aws.Context, input *GetHostedZoneCountInput, opts ...request.Option) (*GetHostedZoneCountOutput, error) {
	req, out := c.GetHostedZoneCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHostedZoneLimit = "GetHostedZoneLimit"

// GetHostedZoneLimitRequest generates a "aws/request.Request" representing the
// client's request for the GetHostedZoneLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHostedZoneLimit for more information on using the GetHostedZoneLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHostedZoneLimitRequest method.
//    req, resp := client.GetHostedZoneLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit
func (c *Route53) GetHostedZoneLimitRequest(input *GetHostedZoneLimitInput) (req *request.Request, output *GetHostedZoneLimitOutput) {
	op := &request.Operation{
		Name:       opGetHostedZoneLimit,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonelimit/{Id}/{Type}",
	}

	if input == nil {
		input = &GetHostedZoneLimitInput{}
	}

	output = &GetHostedZoneLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHostedZoneLimit API operation for Amazon Route 53.
//
// Gets the specified limit for a specified hosted zone, for example, the maximum
// number of records that you can create in the hosted zone.
//
// For the default limit, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide. To request a higher limit, open a
// case (https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-route53).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHostedZoneLimit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeHostedZoneNotPrivate "HostedZoneNotPrivate"
//   The specified hosted zone is a public hosted zone, not a private hosted zone.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit
func (c *Route53) GetHostedZoneLimit(input *GetHostedZoneLimitInput) (*GetHostedZoneLimitOutput, error) {
	req, out := c.GetHostedZoneLimitRequest(input)
	return out, req.Send()
}

// GetHostedZoneLimitWithContext is the same as GetHostedZoneLimit with the addition of
// the ability to pass a context and additional request options.
//
// See GetHostedZoneLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetHostedZoneLimitWithContext(ctx aws.Context, input *GetHostedZoneLimitInput, opts ...request.Option) (*GetHostedZoneLimitOutput, error) {
	req, out := c.GetHostedZoneLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryLoggingConfig = "GetQueryLoggingConfig"

// GetQueryLoggingConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryLoggingConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryLoggingConfig for more information on using the GetQueryLoggingConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryLoggingConfigRequest method.
//    req, resp := client.GetQueryLoggingConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetQueryLoggingConfig
func (c *Route53) GetQueryLoggingConfigRequest(input *GetQueryLoggingConfigInput) (req *request.Request, output *GetQueryLoggingConfigOutput) {
	op := &request.Operation{
		Name:       opGetQueryLoggingConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/queryloggingconfig/{Id}",
	}

	if input == nil {
		input = &GetQueryLoggingConfigInput{}
	}

	output = &GetQueryLoggingConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryLoggingConfig API operation for Amazon Route 53.
//
// Gets information about a specified configuration for DNS query logging.
//
// For more information about DNS query logs, see CreateQueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html)
// and Logging DNS Queries (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetQueryLoggingConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchQueryLoggingConfig "NoSuchQueryLoggingConfig"
//   There is no DNS query logging configuration with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetQueryLoggingConfig
func (c *Route53) GetQueryLoggingConfig(input *GetQueryLoggingConfigInput) (*GetQueryLoggingConfigOutput, error) {
	req, out := c.GetQueryLoggingConfigRequest(input)
	return out, req.Send()
}

// GetQueryLoggingConfigWithContext is the same as GetQueryLoggingConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryLoggingConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetQueryLoggingConfigWithContext(ctx aws.Context, input *GetQueryLoggingConfigInput, opts ...request.Option) (*GetQueryLoggingConfigOutput, error) {
	req, out := c.GetQueryLoggingConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReusableDelegationSet = "GetReusableDelegationSet"

// GetReusableDelegationSetRequest generates a "aws/request.Request" representing the
// client's request for the GetReusableDelegationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReusableDelegationSet for more information on using the GetReusableDelegationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReusableDelegationSetRequest method.
//    req, resp := client.GetReusableDelegationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet
func (c *Route53) GetReusableDelegationSetRequest(input *GetReusableDelegationSetInput) (req *request.Request, output *GetReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opGetReusableDelegationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &GetReusableDelegationSetInput{}
	}

	output = &GetReusableDelegationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReusableDelegationSet API operation for Amazon Route 53.
//
// Retrieves information about a specified reusable delegation set, including
// the four name servers that are assigned to the delegation set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetReusableDelegationSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDelegationSet "NoSuchDelegationSet"
//   A reusable delegation set with the specified ID does not exist.
//
//   * ErrCodeDelegationSetNotReusable "DelegationSetNotReusable"
//   A reusable delegation set with the specified ID does not exist.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet
func (c *Route53) GetReusableDelegationSet(input *GetReusableDelegationSetInput) (*GetReusableDelegationSetOutput, error) {
	req, out := c.GetReusableDelegationSetRequest(input)
	return out, req.Send()
}

// GetReusableDelegationSetWithContext is the same as GetReusableDelegationSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetReusableDelegationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetReusableDelegationSetWithContext(ctx aws.Context, input *GetReusableDelegationSetInput, opts ...request.Option) (*GetReusableDelegationSetOutput, error) {
	req, out := c.GetReusableDelegationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReusableDelegationSetLimit = "GetReusableDelegationSetLimit"

// GetReusableDelegationSetLimitRequest generates a "aws/request.Request" representing the
// client's request for the GetReusableDelegationSetLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReusableDelegationSetLimit for more information on using the GetReusableDelegationSetLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReusableDelegationSetLimitRequest method.
//    req, resp := client.GetReusableDelegationSetLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetLimit
func (c *Route53) GetReusableDelegationSetLimitRequest(input *GetReusableDelegationSetLimitInput) (req *request.Request, output *GetReusableDelegationSetLimitOutput) {
	op := &request.Operation{
		Name:       opGetReusableDelegationSetLimit,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/reusabledelegationsetlimit/{Id}/{Type}",
	}

	if input == nil {
		input = &GetReusableDelegationSetLimitInput{}
	}

	output = &GetReusableDelegationSetLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReusableDelegationSetLimit API operation for Amazon Route 53.
//
// Gets the maximum number of hosted zones that you can associate with the specified
// reusable delegation set.
//
// For the default limit, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide. To request a higher limit, open a
// case (https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-route53).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetReusableDelegationSetLimit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchDelegationSet "NoSuchDelegationSet"
//   A reusable delegation set with the specified ID does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetLimit
func (c *Route53) GetReusableDelegationSetLimit(input *GetReusableDelegationSetLimitInput) (*GetReusableDelegationSetLimitOutput, error) {
	req, out := c.GetReusableDelegationSetLimitRequest(input)
	return out, req.Send()
}

// GetReusableDelegationSetLimitWithContext is the same as GetReusableDelegationSetLimit with the addition of
// the ability to pass a context and additional request options.
//
// See GetReusableDelegationSetLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetReusableDelegationSetLimitWithContext(ctx aws.Context, input *GetReusableDelegationSetLimitInput, opts ...request.Option) (*GetReusableDelegationSetLimitOutput, error) {
	req, out := c.GetReusableDelegationSetLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrafficPolicy = "GetTrafficPolicy"

// GetTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrafficPolicy for more information on using the GetTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTrafficPolicyRequest method.
//    req, resp := client.GetTrafficPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy
func (c *Route53) GetTrafficPolicyRequest(input *GetTrafficPolicyInput) (req *request.Request, output *GetTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &GetTrafficPolicyInput{}
	}

	output = &GetTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrafficPolicy API operation for Amazon Route 53.
//
// Gets information about a specific traffic policy version.
//
// For information about how of deleting a traffic policy affects the response
// from GetTrafficPolicy, see DeleteTrafficPolicy (https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetTrafficPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy
func (c *Route53) GetTrafficPolicy(input *GetTrafficPolicyInput) (*GetTrafficPolicyOutput, error) {
	req, out := c.GetTrafficPolicyRequest(input)
	return out, req.Send()
}

// GetTrafficPolicyWithContext is the same as GetTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetTrafficPolicyWithContext(ctx aws.Context, input *GetTrafficPolicyInput, opts ...request.Option) (*GetTrafficPolicyOutput, error) {
	req, out := c.GetTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrafficPolicyInstance = "GetTrafficPolicyInstance"

// GetTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicyInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrafficPolicyInstance for more information on using the GetTrafficPolicyInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTrafficPolicyInstanceRequest method.
//    req, resp := client.GetTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance
func (c *Route53) GetTrafficPolicyInstanceRequest(input *GetTrafficPolicyInstanceInput) (req *request.Request, output *GetTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicyInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &GetTrafficPolicyInstanceInput{}
	}

	output = &GetTrafficPolicyInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrafficPolicyInstance API operation for Amazon Route 53.
//
// Gets information about a specified traffic policy instance.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// In the Route 53 console, traffic policy instances are known as policy records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchTrafficPolicyInstance "NoSuchTrafficPolicyInstance"
//   No traffic policy instance exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance
func (c *Route53) GetTrafficPolicyInstance(input *GetTrafficPolicyInstanceInput) (*GetTrafficPolicyInstanceOutput, error) {
	req, out := c.GetTrafficPolicyInstanceRequest(input)
	return out, req.Send()
}

// GetTrafficPolicyInstanceWithContext is the same as GetTrafficPolicyInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrafficPolicyInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetTrafficPolicyInstanceWithContext(ctx aws.Context, input *GetTrafficPolicyInstanceInput, opts ...request.Option) (*GetTrafficPolicyInstanceOutput, error) {
	req, out := c.GetTrafficPolicyInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrafficPolicyInstanceCount = "GetTrafficPolicyInstanceCount"

// GetTrafficPolicyInstanceCountRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicyInstanceCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrafficPolicyInstanceCount for more information on using the GetTrafficPolicyInstanceCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTrafficPolicyInstanceCountRequest method.
//    req, resp := client.GetTrafficPolicyInstanceCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount
func (c *Route53) GetTrafficPolicyInstanceCountRequest(input *GetTrafficPolicyInstanceCountInput) (req *request.Request, output *GetTrafficPolicyInstanceCountOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicyInstanceCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstancecount",
	}

	if input == nil {
		input = &GetTrafficPolicyInstanceCountInput{}
	}

	output = &GetTrafficPolicyInstanceCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrafficPolicyInstanceCount API operation for Amazon Route 53.
//
// Gets the number of traffic policy instances that are associated with the
// current account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetTrafficPolicyInstanceCount for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount
func (c *Route53) GetTrafficPolicyInstanceCount(input *GetTrafficPolicyInstanceCountInput) (*GetTrafficPolicyInstanceCountOutput, error) {
	req, out := c.GetTrafficPolicyInstanceCountRequest(input)
	return out, req.Send()
}

// GetTrafficPolicyInstanceCountWithContext is the same as GetTrafficPolicyInstanceCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrafficPolicyInstanceCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) GetTrafficPolicyInstanceCountWithContext(ctx aws.Context, input *GetTrafficPolicyInstanceCountInput, opts ...request.Option) (*GetTrafficPolicyInstanceCountOutput, error) {
	req, out := c.GetTrafficPolicyInstanceCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGeoLocations = "ListGeoLocations"

// ListGeoLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeoLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeoLocations for more information on using the ListGeoLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGeoLocationsRequest method.
//    req, resp := client.ListGeoLocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations
func (c *Route53) ListGeoLocationsRequest(input *ListGeoLocationsInput) (req *request.Request, output *ListGeoLocationsOutput) {
	op := &request.Operation{
		Name:       opListGeoLocations,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocations",
	}

	if input == nil {
		input = &ListGeoLocationsInput{}
	}

	output = &ListGeoLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGeoLocations API operation for Amazon Route 53.
//
// Retrieves a list of supported geographic locations.
//
// Countries are listed first, and continents are listed last. If Amazon Route
// 53 supports subdivisions for a country (for example, states or provinces),
// the subdivisions for that country are listed in alphabetical order immediately
// after the corresponding country.
//
// Route 53 does not perform authorization for this API because it retrieves
// information that is already available to the public.
//
// For a list of supported geolocation codes, see the GeoLocation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html)
// data type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListGeoLocations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations
func (c *Route53) ListGeoLocations(input *ListGeoLocationsInput) (*ListGeoLocationsOutput, error) {
	req, out := c.ListGeoLocationsRequest(input)
	return out, req.Send()
}

// ListGeoLocationsWithContext is the same as ListGeoLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeoLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListGeoLocationsWithContext(ctx aws.Context, input *ListGeoLocationsInput, opts ...request.Option) (*ListGeoLocationsOutput, error) {
	req, out := c.ListGeoLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHealthChecks = "ListHealthChecks"

// ListHealthChecksRequest generates a "aws/request.Request" representing the
// client's request for the ListHealthChecks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHealthChecks for more information on using the ListHealthChecks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHealthChecksRequest method.
//    req, resp := client.ListHealthChecksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks
func (c *Route53) ListHealthChecksRequest(input *ListHealthChecksInput) (req *request.Request, output *ListHealthChecksOutput) {
	op := &request.Operation{
		Name:       opListHealthChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHealthChecksInput{}
	}

	output = &ListHealthChecksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHealthChecks API operation for Amazon Route 53.
//
// Retrieve a list of the health checks that are associated with the current
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHealthChecks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeIncompatibleVersion "IncompatibleVersion"
//   The resource you're trying to access is unsupported on this Amazon Route
//   53 endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks
func (c *Route53) ListHealthChecks(input *ListHealthChecksInput) (*ListHealthChecksOutput, error) {
	req, out := c.ListHealthChecksRequest(input)
	return out, req.Send()
}

// ListHealthChecksWithContext is the same as ListHealthChecks with the addition of
// the ability to pass a context and additional request options.
//
// See ListHealthChecks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListHealthChecksWithContext(ctx aws.Context, input *ListHealthChecksInput, opts ...request.Option) (*ListHealthChecksOutput, error) {
	req, out := c.ListHealthChecksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHealthChecksPages iterates over the pages of a ListHealthChecks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHealthChecks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHealthChecks operation.
//    pageNum := 0
//    err := client.ListHealthChecksPages(params,
//        func(page *route53.ListHealthChecksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListHealthChecksPages(input *ListHealthChecksInput, fn func(*ListHealthChecksOutput, bool) bool) error {
	return c.ListHealthChecksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHealthChecksPagesWithContext same as ListHealthChecksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListHealthChecksPagesWithContext(ctx aws.Context, input *ListHealthChecksInput, fn func(*ListHealthChecksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHealthChecksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHealthChecksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHealthChecksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHostedZones = "ListHostedZones"

// ListHostedZonesRequest generates a "aws/request.Request" representing the
// client's request for the ListHostedZones operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHostedZones for more information on using the ListHostedZones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHostedZonesRequest method.
//    req, resp := client.ListHostedZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones
func (c *Route53) ListHostedZonesRequest(input *ListHostedZonesInput) (req *request.Request, output *ListHostedZonesOutput) {
	op := &request.Operation{
		Name:       opListHostedZones,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHostedZonesInput{}
	}

	output = &ListHostedZonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHostedZones API operation for Amazon Route 53.
//
// Retrieves a list of the public and private hosted zones that are associated
// with the current account. The response includes a HostedZones child element
// for each hosted zone.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of hosted zones, you can use the maxitems parameter to list them in
// groups of up to 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHostedZones for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchDelegationSet "NoSuchDelegationSet"
//   A reusable delegation set with the specified ID does not exist.
//
//   * ErrCodeDelegationSetNotReusable "DelegationSetNotReusable"
//   A reusable delegation set with the specified ID does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones
func (c *Route53) ListHostedZones(input *ListHostedZonesInput) (*ListHostedZonesOutput, error) {
	req, out := c.ListHostedZonesRequest(input)
	return out, req.Send()
}

// ListHostedZonesWithContext is the same as ListHostedZones with the addition of
// the ability to pass a context and additional request options.
//
// See ListHostedZones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListHostedZonesWithContext(ctx aws.Context, input *ListHostedZonesInput, opts ...request.Option) (*ListHostedZonesOutput, error) {
	req, out := c.ListHostedZonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHostedZonesPages iterates over the pages of a ListHostedZones operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHostedZones method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHostedZones operation.
//    pageNum := 0
//    err := client.ListHostedZonesPages(params,
//        func(page *route53.ListHostedZonesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListHostedZonesPages(input *ListHostedZonesInput, fn func(*ListHostedZonesOutput, bool) bool) error {
	return c.ListHostedZonesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHostedZonesPagesWithContext same as ListHostedZonesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListHostedZonesPagesWithContext(ctx aws.Context, input *ListHostedZonesInput, fn func(*ListHostedZonesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHostedZonesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHostedZonesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHostedZonesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHostedZonesByName = "ListHostedZonesByName"

// ListHostedZonesByNameRequest generates a "aws/request.Request" representing the
// client's request for the ListHostedZonesByName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHostedZonesByName for more information on using the ListHostedZonesByName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHostedZonesByNameRequest method.
//    req, resp := client.ListHostedZonesByNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName
func (c *Route53) ListHostedZonesByNameRequest(input *ListHostedZonesByNameInput) (req *request.Request, output *ListHostedZonesByNameOutput) {
	op := &request.Operation{
		Name:       opListHostedZonesByName,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonesbyname",
	}

	if input == nil {
		input = &ListHostedZonesByNameInput{}
	}

	output = &ListHostedZonesByNameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHostedZonesByName API operation for Amazon Route 53.
//
// Retrieves a list of your hosted zones in lexicographic order. The response
// includes a HostedZones child element for each hosted zone created by the
// current account.
//
// ListHostedZonesByName sorts hosted zones by name with the labels reversed.
// For example:
//
// com.example.www.
//
// Note the trailing dot, which can change the sort order in some circumstances.
//
// If the domain name includes escape characters or Punycode, ListHostedZonesByName
// alphabetizes the domain name using the escaped or Punycoded value, which
// is the format that Amazon Route 53 saves in its database. For example, to
// create a hosted zone for exämple.com, you specify ex\344mple.com for the
// domain name. ListHostedZonesByName alphabetizes it as:
//
// com.ex\344mple.
//
// The labels are reversed and alphabetized using the escaped value. For more
// information about valid domain name formats, including internationalized
// domain names, see DNS Domain Name Format (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
// in the Amazon Route 53 Developer Guide.
//
// Route 53 returns up to 100 items in each response. If you have a lot of hosted
// zones, use the MaxItems parameter to list them in groups of up to 100. The
// response includes values that help navigate from one group of MaxItems hosted
// zones to the next:
//
//    * The DNSName and HostedZoneId elements in the response contain the values,
//    if any, specified for the dnsname and hostedzoneid parameters in the request
//    that produced the current response.
//
//    * The MaxItems element in the response contains the value, if any, that
//    you specified for the maxitems parameter in the request that produced
//    the current response.
//
//    * If the value of IsTruncated in the response is true, there are more
//    hosted zones associated with the current account. If IsTruncated is false,
//    this response includes the last hosted zone that is associated with the
//    current account. The NextDNSName element and NextHostedZoneId elements
//    are omitted from the response.
//
//    * The NextDNSName and NextHostedZoneId elements in the response contain
//    the domain name and the hosted zone ID of the next hosted zone that is
//    associated with the current account. If you want to list more hosted zones,
//    make another call to ListHostedZonesByName, and specify the value of NextDNSName
//    and NextHostedZoneId in the dnsname and hostedzoneid parameters, respectively.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHostedZonesByName for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeInvalidDomainName "InvalidDomainName"
//   The specified domain name is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName
func (c *Route53) ListHostedZonesByName(input *ListHostedZonesByNameInput) (*ListHostedZonesByNameOutput, error) {
	req, out := c.ListHostedZonesByNameRequest(input)
	return out, req.Send()
}

// ListHostedZonesByNameWithContext is the same as ListHostedZonesByName with the addition of
// the ability to pass a context and additional request options.
//
// See ListHostedZonesByName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListHostedZonesByNameWithContext(ctx aws.Context, input *ListHostedZonesByNameInput, opts ...request.Option) (*ListHostedZonesByNameOutput, error) {
	req, out := c.ListHostedZonesByNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHostedZonesByVPC = "ListHostedZonesByVPC"

// ListHostedZonesByVPCRequest generates a "aws/request.Request" representing the
// client's request for the ListHostedZonesByVPC operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHostedZonesByVPC for more information on using the ListHostedZonesByVPC
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHostedZonesByVPCRequest method.
//    req, resp := client.ListHostedZonesByVPCRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByVPC
func (c *Route53) ListHostedZonesByVPCRequest(input *ListHostedZonesByVPCInput) (req *request.Request, output *ListHostedZonesByVPCOutput) {
	op := &request.Operation{
		Name:       opListHostedZonesByVPC,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonesbyvpc",
	}

	if input == nil {
		input = &ListHostedZonesByVPCInput{}
	}

	output = &ListHostedZonesByVPCOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHostedZonesByVPC API operation for Amazon Route 53.
//
// Lists all the private hosted zones that a specified VPC is associated with,
// regardless of which account or Amazon Web Services service owns the hosted
// zones. The HostedZoneOwner structure in the response contains one of the
// following values:
//
//    * An OwningAccount element, which contains the account number of either
//    the current account or another account. Some services, such as Cloud Map,
//    create hosted zones using the current account.
//
//    * An OwningService element, which identifies the Amazon Web Services service
//    that created and owns the hosted zone. For example, if a hosted zone was
//    created by Amazon Elastic File System (Amazon EFS), the value of Owner
//    is efs.amazonaws.com.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHostedZonesByVPC for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The value that you specified to get the second or subsequent page of results
//   is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByVPC
func (c *Route53) ListHostedZonesByVPC(input *ListHostedZonesByVPCInput) (*ListHostedZonesByVPCOutput, error) {
	req, out := c.ListHostedZonesByVPCRequest(input)
	return out, req.Send()
}

// ListHostedZonesByVPCWithContext is the same as ListHostedZonesByVPC with the addition of
// the ability to pass a context and additional request options.
//
// See ListHostedZonesByVPC for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListHostedZonesByVPCWithContext(ctx aws.Context, input *ListHostedZonesByVPCInput, opts ...request.Option) (*ListHostedZonesByVPCOutput, error) {
	req, out := c.ListHostedZonesByVPCRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListQueryLoggingConfigs = "ListQueryLoggingConfigs"

// ListQueryLoggingConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueryLoggingConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueryLoggingConfigs for more information on using the ListQueryLoggingConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQueryLoggingConfigsRequest method.
//    req, resp := client.ListQueryLoggingConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs
func (c *Route53) ListQueryLoggingConfigsRequest(input *ListQueryLoggingConfigsInput) (req *request.Request, output *ListQueryLoggingConfigsOutput) {
	op := &request.Operation{
		Name:       opListQueryLoggingConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/queryloggingconfig",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueryLoggingConfigsInput{}
	}

	output = &ListQueryLoggingConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueryLoggingConfigs API operation for Amazon Route 53.
//
// Lists the configurations for DNS query logging that are associated with the
// current account or the configuration that is associated with a specified
// hosted zone.
//
// For more information about DNS query logs, see CreateQueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html).
// Additional information, including the format of DNS query logs, appears in
// Logging DNS Queries (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListQueryLoggingConfigs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The value that you specified to get the second or subsequent page of results
//   is invalid.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs
func (c *Route53) ListQueryLoggingConfigs(input *ListQueryLoggingConfigsInput) (*ListQueryLoggingConfigsOutput, error) {
	req, out := c.ListQueryLoggingConfigsRequest(input)
	return out, req.Send()
}

// ListQueryLoggingConfigsWithContext is the same as ListQueryLoggingConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueryLoggingConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListQueryLoggingConfigsWithContext(ctx aws.Context, input *ListQueryLoggingConfigsInput, opts ...request.Option) (*ListQueryLoggingConfigsOutput, error) {
	req, out := c.ListQueryLoggingConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueryLoggingConfigsPages iterates over the pages of a ListQueryLoggingConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueryLoggingConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQueryLoggingConfigs operation.
//    pageNum := 0
//    err := client.ListQueryLoggingConfigsPages(params,
//        func(page *route53.ListQueryLoggingConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListQueryLoggingConfigsPages(input *ListQueryLoggingConfigsInput, fn func(*ListQueryLoggingConfigsOutput, bool) bool) error {
	return c.ListQueryLoggingConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueryLoggingConfigsPagesWithContext same as ListQueryLoggingConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListQueryLoggingConfigsPagesWithContext(ctx aws.Context, input *ListQueryLoggingConfigsInput, fn func(*ListQueryLoggingConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueryLoggingConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueryLoggingConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueryLoggingConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceRecordSets = "ListResourceRecordSets"

// ListResourceRecordSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceRecordSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceRecordSets for more information on using the ListResourceRecordSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceRecordSetsRequest method.
//    req, resp := client.ListResourceRecordSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets
func (c *Route53) ListResourceRecordSetsRequest(input *ListResourceRecordSetsInput) (req *request.Request, output *ListResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opListResourceRecordSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"StartRecordName", "StartRecordType", "StartRecordIdentifier"},
			OutputTokens:    []string{"NextRecordName", "NextRecordType", "NextRecordIdentifier"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListResourceRecordSetsInput{}
	}

	output = &ListResourceRecordSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceRecordSets API operation for Amazon Route 53.
//
// Lists the resource record sets in a specified hosted zone.
//
// ListResourceRecordSets returns up to 300 resource record sets at a time in
// ASCII order, beginning at a position specified by the name and type elements.
//
// Sort order
//
// ListResourceRecordSets sorts results first by DNS name with the labels reversed,
// for example:
//
// com.example.www.
//
// Note the trailing dot, which can change the sort order when the record name
// contains characters that appear before . (decimal 46) in the ASCII table.
// These characters include the following: ! " # $ % & ' ( ) * + , -
//
// When multiple records have the same DNS name, ListResourceRecordSets sorts
// results by the record type.
//
// Specifying where to start listing records
//
// You can use the name and type elements to specify the resource record set
// that the list begins with:
//
// If you do not specify Name or Type
//
// The results begin with the first resource record set that the hosted zone
// contains.
//
// If you specify Name but not Type
//
// The results begin with the first resource record set in the list whose name
// is greater than or equal to Name.
//
// If you specify Type but not Name
//
// Amazon Route 53 returns the InvalidInput error.
//
// If you specify both Name and Type
//
// The results begin with the first resource record set in the list whose name
// is greater than or equal to Name, and whose type is greater than or equal
// to Type.
//
// Resource record sets that are PENDING
//
// This action returns the most current version of the records. This includes
// records that are PENDING, and that are not yet available on all Route 53
// DNS servers.
//
// Changing resource record sets
//
// To ensure that you get an accurate listing of the resource record sets for
// a hosted zone at a point in time, do not submit a ChangeResourceRecordSets
// request while you're paging through the results of a ListResourceRecordSets
// request. If you do, some pages may display results without the latest changes
// while other pages display results with the latest changes.
//
// Displaying the next page of results
//
// If a ListResourceRecordSets command returns more than one page of results,
// the value of IsTruncated is true. To display the next page of results, get
// the values of NextRecordName, NextRecordType, and NextRecordIdentifier (if
// any) from the response. Then submit another ListResourceRecordSets request,
// and specify those values for StartRecordName, StartRecordType, and StartRecordIdentifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListResourceRecordSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets
func (c *Route53) ListResourceRecordSets(input *ListResourceRecordSetsInput) (*ListResourceRecordSetsOutput, error) {
	req, out := c.ListResourceRecordSetsRequest(input)
	return out, req.Send()
}

// ListResourceRecordSetsWithContext is the same as ListResourceRecordSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceRecordSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListResourceRecordSetsWithContext(ctx aws.Context, input *ListResourceRecordSetsInput, opts ...request.Option) (*ListResourceRecordSetsOutput, error) {
	req, out := c.ListResourceRecordSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceRecordSetsPages iterates over the pages of a ListResourceRecordSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceRecordSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResourceRecordSets operation.
//    pageNum := 0
//    err := client.ListResourceRecordSetsPages(params,
//        func(page *route53.ListResourceRecordSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListResourceRecordSetsPages(input *ListResourceRecordSetsInput, fn func(*ListResourceRecordSetsOutput, bool) bool) error {
	return c.ListResourceRecordSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceRecordSetsPagesWithContext same as ListResourceRecordSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListResourceRecordSetsPagesWithContext(ctx aws.Context, input *ListResourceRecordSetsInput, fn func(*ListResourceRecordSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceRecordSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceRecordSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceRecordSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReusableDelegationSets = "ListReusableDelegationSets"

// ListReusableDelegationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListReusableDelegationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReusableDelegationSets for more information on using the ListReusableDelegationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListReusableDelegationSetsRequest method.
//    req, resp := client.ListReusableDelegationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets
func (c *Route53) ListReusableDelegationSetsRequest(input *ListReusableDelegationSetsInput) (req *request.Request, output *ListReusableDelegationSetsOutput) {
	op := &request.Operation{
		Name:       opListReusableDelegationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &ListReusableDelegationSetsInput{}
	}

	output = &ListReusableDelegationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReusableDelegationSets API operation for Amazon Route 53.
//
// Retrieves a list of the reusable delegation sets that are associated with
// the current account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListReusableDelegationSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets
func (c *Route53) ListReusableDelegationSets(input *ListReusableDelegationSetsInput) (*ListReusableDelegationSetsOutput, error) {
	req, out := c.ListReusableDelegationSetsRequest(input)
	return out, req.Send()
}

// ListReusableDelegationSetsWithContext is the same as ListReusableDelegationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListReusableDelegationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListReusableDelegationSetsWithContext(ctx aws.Context, input *ListReusableDelegationSetsInput, opts ...request.Option) (*ListReusableDelegationSetsOutput, error) {
	req, out := c.ListReusableDelegationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource
func (c *Route53) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Route 53.
//
// Lists tags for one health check or hosted zone.
//
// For information about using tags for cost allocation, see Using Cost Allocation
// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource
func (c *Route53) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResources = "ListTagsForResources"

// ListTagsForResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResources for more information on using the ListTagsForResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourcesRequest method.
//    req, resp := client.ListTagsForResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources
func (c *Route53) ListTagsForResourcesRequest(input *ListTagsForResourcesInput) (req *request.Request, output *ListTagsForResourcesOutput) {
	op := &request.Operation{
		Name:       opListTagsForResources,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}",
	}

	if input == nil {
		input = &ListTagsForResourcesInput{}
	}

	output = &ListTagsForResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResources API operation for Amazon Route 53.
//
// Lists tags for up to 10 health checks or hosted zones.
//
// For information about using tags for cost allocation, see Using Cost Allocation
// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTagsForResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The limit on the number of requests per second was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources
func (c *Route53) ListTagsForResources(input *ListTagsForResourcesInput) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	return out, req.Send()
}

// ListTagsForResourcesWithContext is the same as ListTagsForResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTagsForResourcesWithContext(ctx aws.Context, input *ListTagsForResourcesInput, opts ...request.Option) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrafficPolicies = "ListTrafficPolicies"

// ListTrafficPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficPolicies for more information on using the ListTrafficPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrafficPoliciesRequest method.
//    req, resp := client.ListTrafficPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies
func (c *Route53) ListTrafficPoliciesRequest(input *ListTrafficPoliciesInput) (req *request.Request, output *ListTrafficPoliciesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicies",
	}

	if input == nil {
		input = &ListTrafficPoliciesInput{}
	}

	output = &ListTrafficPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficPolicies API operation for Amazon Route 53.
//
// Gets information about the latest version for every traffic policy that is
// associated with the current account. Policies are listed in the order that
// they were created in.
//
// For information about how of deleting a traffic policy affects the response
// from ListTrafficPolicies, see DeleteTrafficPolicy (https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies
func (c *Route53) ListTrafficPolicies(input *ListTrafficPoliciesInput) (*ListTrafficPoliciesOutput, error) {
	req, out := c.ListTrafficPoliciesRequest(input)
	return out, req.Send()
}

// ListTrafficPoliciesWithContext is the same as ListTrafficPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTrafficPoliciesWithContext(ctx aws.Context, input *ListTrafficPoliciesInput, opts ...request.Option) (*ListTrafficPoliciesOutput, error) {
	req, out := c.ListTrafficPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrafficPolicyInstances = "ListTrafficPolicyInstances"

// ListTrafficPolicyInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficPolicyInstances for more information on using the ListTrafficPolicyInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrafficPolicyInstancesRequest method.
//    req, resp := client.ListTrafficPolicyInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances
func (c *Route53) ListTrafficPolicyInstancesRequest(input *ListTrafficPolicyInstancesInput) (req *request.Request, output *ListTrafficPolicyInstancesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesInput{}
	}

	output = &ListTrafficPolicyInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficPolicyInstances API operation for Amazon Route 53.
//
// Gets information about the traffic policy instances that you created by using
// the current account.
//
// After you submit an UpdateTrafficPolicyInstance request, there's a brief
// delay while Amazon Route 53 creates the resource record sets that are specified
// in the traffic policy definition. For more information, see the State response
// element.
//
// Route 53 returns a maximum of 100 items in each response. If you have a lot
// of traffic policy instances, you can use the MaxItems parameter to list them
// in groups of up to 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchTrafficPolicyInstance "NoSuchTrafficPolicyInstance"
//   No traffic policy instance exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances
func (c *Route53) ListTrafficPolicyInstances(input *ListTrafficPolicyInstancesInput) (*ListTrafficPolicyInstancesOutput, error) {
	req, out := c.ListTrafficPolicyInstancesRequest(input)
	return out, req.Send()
}

// ListTrafficPolicyInstancesWithContext is the same as ListTrafficPolicyInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficPolicyInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTrafficPolicyInstancesWithContext(ctx aws.Context, input *ListTrafficPolicyInstancesInput, opts ...request.Option) (*ListTrafficPolicyInstancesOutput, error) {
	req, out := c.ListTrafficPolicyInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrafficPolicyInstancesByHostedZone = "ListTrafficPolicyInstancesByHostedZone"

// ListTrafficPolicyInstancesByHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyInstancesByHostedZone operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficPolicyInstancesByHostedZone for more information on using the ListTrafficPolicyInstancesByHostedZone
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrafficPolicyInstancesByHostedZoneRequest method.
//    req, resp := client.ListTrafficPolicyInstancesByHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone
func (c *Route53) ListTrafficPolicyInstancesByHostedZoneRequest(input *ListTrafficPolicyInstancesByHostedZoneInput) (req *request.Request, output *ListTrafficPolicyInstancesByHostedZoneOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstancesByHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/hostedzone",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByHostedZoneInput{}
	}

	output = &ListTrafficPolicyInstancesByHostedZoneOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficPolicyInstancesByHostedZone API operation for Amazon Route 53.
//
// Gets information about the traffic policy instances that you created in a
// specified hosted zone.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// Route 53 returns a maximum of 100 items in each response. If you have a lot
// of traffic policy instances, you can use the MaxItems parameter to list them
// in groups of up to 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyInstancesByHostedZone for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchTrafficPolicyInstance "NoSuchTrafficPolicyInstance"
//   No traffic policy instance exists with the specified ID.
//
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone
func (c *Route53) ListTrafficPolicyInstancesByHostedZone(input *ListTrafficPolicyInstancesByHostedZoneInput) (*ListTrafficPolicyInstancesByHostedZoneOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByHostedZoneRequest(input)
	return out, req.Send()
}

// ListTrafficPolicyInstancesByHostedZoneWithContext is the same as ListTrafficPolicyInstancesByHostedZone with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficPolicyInstancesByHostedZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTrafficPolicyInstancesByHostedZoneWithContext(ctx aws.Context, input *ListTrafficPolicyInstancesByHostedZoneInput, opts ...request.Option) (*ListTrafficPolicyInstancesByHostedZoneOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByHostedZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrafficPolicyInstancesByPolicy = "ListTrafficPolicyInstancesByPolicy"

// ListTrafficPolicyInstancesByPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyInstancesByPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficPolicyInstancesByPolicy for more information on using the ListTrafficPolicyInstancesByPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrafficPolicyInstancesByPolicyRequest method.
//    req, resp := client.ListTrafficPolicyInstancesByPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy
func (c *Route53) ListTrafficPolicyInstancesByPolicyRequest(input *ListTrafficPolicyInstancesByPolicyInput) (req *request.Request, output *ListTrafficPolicyInstancesByPolicyOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstancesByPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/trafficpolicy",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByPolicyInput{}
	}

	output = &ListTrafficPolicyInstancesByPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficPolicyInstancesByPolicy API operation for Amazon Route 53.
//
// Gets information about the traffic policy instances that you created by using
// a specify traffic policy version.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// Route 53 returns a maximum of 100 items in each response. If you have a lot
// of traffic policy instances, you can use the MaxItems parameter to list them
// in groups of up to 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyInstancesByPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchTrafficPolicyInstance "NoSuchTrafficPolicyInstance"
//   No traffic policy instance exists with the specified ID.
//
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy
func (c *Route53) ListTrafficPolicyInstancesByPolicy(input *ListTrafficPolicyInstancesByPolicyInput) (*ListTrafficPolicyInstancesByPolicyOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByPolicyRequest(input)
	return out, req.Send()
}

// ListTrafficPolicyInstancesByPolicyWithContext is the same as ListTrafficPolicyInstancesByPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficPolicyInstancesByPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTrafficPolicyInstancesByPolicyWithContext(ctx aws.Context, input *ListTrafficPolicyInstancesByPolicyInput, opts ...request.Option) (*ListTrafficPolicyInstancesByPolicyOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrafficPolicyVersions = "ListTrafficPolicyVersions"

// ListTrafficPolicyVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficPolicyVersions for more information on using the ListTrafficPolicyVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrafficPolicyVersionsRequest method.
//    req, resp := client.ListTrafficPolicyVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions
func (c *Route53) ListTrafficPolicyVersionsRequest(input *ListTrafficPolicyVersionsInput) (req *request.Request, output *ListTrafficPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicies/{Id}/versions",
	}

	if input == nil {
		input = &ListTrafficPolicyVersionsInput{}
	}

	output = &ListTrafficPolicyVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficPolicyVersions API operation for Amazon Route 53.
//
// Gets information about all of the versions for a specified traffic policy.
//
// Traffic policy versions are listed in numerical order by VersionNumber.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions
func (c *Route53) ListTrafficPolicyVersions(input *ListTrafficPolicyVersionsInput) (*ListTrafficPolicyVersionsOutput, error) {
	req, out := c.ListTrafficPolicyVersionsRequest(input)
	return out, req.Send()
}

// ListTrafficPolicyVersionsWithContext is the same as ListTrafficPolicyVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficPolicyVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListTrafficPolicyVersionsWithContext(ctx aws.Context, input *ListTrafficPolicyVersionsInput, opts ...request.Option) (*ListTrafficPolicyVersionsOutput, error) {
	req, out := c.ListTrafficPolicyVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVPCAssociationAuthorizations = "ListVPCAssociationAuthorizations"

// ListVPCAssociationAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the ListVPCAssociationAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVPCAssociationAuthorizations for more information on using the ListVPCAssociationAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVPCAssociationAuthorizationsRequest method.
//    req, resp := client.ListVPCAssociationAuthorizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations
func (c *Route53) ListVPCAssociationAuthorizationsRequest(input *ListVPCAssociationAuthorizationsInput) (req *request.Request, output *ListVPCAssociationAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opListVPCAssociationAuthorizations,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
	}

	if input == nil {
		input = &ListVPCAssociationAuthorizationsInput{}
	}

	output = &ListVPCAssociationAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVPCAssociationAuthorizations API operation for Amazon Route 53.
//
// Gets a list of the VPCs that were created by other accounts and that can
// be associated with a specified hosted zone because you've submitted one or
// more CreateVPCAssociationAuthorization requests.
//
// The response includes a VPCs element with a VPC child element for each VPC
// that can be associated with the hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListVPCAssociationAuthorizations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeInvalidPaginationToken "InvalidPaginationToken"
//   The value that you specified to get the second or subsequent page of results
//   is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations
func (c *Route53) ListVPCAssociationAuthorizations(input *ListVPCAssociationAuthorizationsInput) (*ListVPCAssociationAuthorizationsOutput, error) {
	req, out := c.ListVPCAssociationAuthorizationsRequest(input)
	return out, req.Send()
}

// ListVPCAssociationAuthorizationsWithContext is the same as ListVPCAssociationAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See ListVPCAssociationAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) ListVPCAssociationAuthorizationsWithContext(ctx aws.Context, input *ListVPCAssociationAuthorizationsInput, opts ...request.Option) (*ListVPCAssociationAuthorizationsOutput, error) {
	req, out := c.ListVPCAssociationAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestDNSAnswer = "TestDNSAnswer"

// TestDNSAnswerRequest generates a "aws/request.Request" representing the
// client's request for the TestDNSAnswer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestDNSAnswer for more information on using the TestDNSAnswer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestDNSAnswerRequest method.
//    req, resp := client.TestDNSAnswerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer
func (c *Route53) TestDNSAnswerRequest(input *TestDNSAnswerInput) (req *request.Request, output *TestDNSAnswerOutput) {
	op := &request.Operation{
		Name:       opTestDNSAnswer,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/testdnsanswer",
	}

	if input == nil {
		input = &TestDNSAnswerInput{}
	}

	output = &TestDNSAnswerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestDNSAnswer API operation for Amazon Route 53.
//
// Gets the value that Amazon Route 53 returns in response to a DNS request
// for a specified record name and type. You can optionally specify the IP address
// of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
//
// This call only supports querying public hosted zones.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation TestDNSAnswer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer
func (c *Route53) TestDNSAnswer(input *TestDNSAnswerInput) (*TestDNSAnswerOutput, error) {
	req, out := c.TestDNSAnswerRequest(input)
	return out, req.Send()
}

// TestDNSAnswerWithContext is the same as TestDNSAnswer with the addition of
// the ability to pass a context and additional request options.
//
// See TestDNSAnswer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) TestDNSAnswerWithContext(ctx aws.Context, input *TestDNSAnswerInput, opts ...request.Option) (*TestDNSAnswerOutput, error) {
	req, out := c.TestDNSAnswerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateHealthCheck = "UpdateHealthCheck"

// UpdateHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHealthCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateHealthCheck for more information on using the UpdateHealthCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateHealthCheckRequest method.
//    req, resp := client.UpdateHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck
func (c *Route53) UpdateHealthCheckRequest(input *UpdateHealthCheckInput) (req *request.Request, output *UpdateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opUpdateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &UpdateHealthCheckInput{}
	}

	output = &UpdateHealthCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateHealthCheck API operation for Amazon Route 53.
//
// Updates an existing health check. Note that some values can't be updated.
//
// For more information about updating health checks, see Creating, Updating,
// and Deleting Health Checks (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHealthCheck "NoSuchHealthCheck"
//   No health check exists with the specified ID.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeHealthCheckVersionMismatch "HealthCheckVersionMismatch"
//   The value of HealthCheckVersion in the request doesn't match the value of
//   HealthCheckVersion in the health check.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck
func (c *Route53) UpdateHealthCheck(input *UpdateHealthCheckInput) (*UpdateHealthCheckOutput, error) {
	req, out := c.UpdateHealthCheckRequest(input)
	return out, req.Send()
}

// UpdateHealthCheckWithContext is the same as UpdateHealthCheck with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateHealthCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) UpdateHealthCheckWithContext(ctx aws.Context, input *UpdateHealthCheckInput, opts ...request.Option) (*UpdateHealthCheckOutput, error) {
	req, out := c.UpdateHealthCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateHostedZoneComment = "UpdateHostedZoneComment"

// UpdateHostedZoneCommentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHostedZoneComment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateHostedZoneComment for more information on using the UpdateHostedZoneComment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateHostedZoneCommentRequest method.
//    req, resp := client.UpdateHostedZoneCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment
func (c *Route53) UpdateHostedZoneCommentRequest(input *UpdateHostedZoneCommentInput) (req *request.Request, output *UpdateHostedZoneCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateHostedZoneComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &UpdateHostedZoneCommentInput{}
	}

	output = &UpdateHostedZoneCommentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateHostedZoneComment API operation for Amazon Route 53.
//
// Updates the comment for a specified hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateHostedZoneComment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchHostedZone "NoSuchHostedZone"
//   No hosted zone exists with the ID that you specified.
//
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment
func (c *Route53) UpdateHostedZoneComment(input *UpdateHostedZoneCommentInput) (*UpdateHostedZoneCommentOutput, error) {
	req, out := c.UpdateHostedZoneCommentRequest(input)
	return out, req.Send()
}

// UpdateHostedZoneCommentWithContext is the same as UpdateHostedZoneComment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateHostedZoneComment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) UpdateHostedZoneCommentWithContext(ctx aws.Context, input *UpdateHostedZoneCommentInput, opts ...request.Option) (*UpdateHostedZoneCommentOutput, error) {
	req, out := c.UpdateHostedZoneCommentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrafficPolicyComment = "UpdateTrafficPolicyComment"

// UpdateTrafficPolicyCommentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrafficPolicyComment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrafficPolicyComment for more information on using the UpdateTrafficPolicyComment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrafficPolicyCommentRequest method.
//    req, resp := client.UpdateTrafficPolicyCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment
func (c *Route53) UpdateTrafficPolicyCommentRequest(input *UpdateTrafficPolicyCommentInput) (req *request.Request, output *UpdateTrafficPolicyCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicyComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &UpdateTrafficPolicyCommentInput{}
	}

	output = &UpdateTrafficPolicyCommentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrafficPolicyComment API operation for Amazon Route 53.
//
// Updates the comment for a specified traffic policy version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateTrafficPolicyComment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
//   * ErrCodeConcurrentModification "ConcurrentModification"
//   Another user submitted a request to create, update, or delete the object
//   at the same time that you did. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment
func (c *Route53) UpdateTrafficPolicyComment(input *UpdateTrafficPolicyCommentInput) (*UpdateTrafficPolicyCommentOutput, error) {
	req, out := c.UpdateTrafficPolicyCommentRequest(input)
	return out, req.Send()
}

// UpdateTrafficPolicyCommentWithContext is the same as UpdateTrafficPolicyComment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrafficPolicyComment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) UpdateTrafficPolicyCommentWithContext(ctx aws.Context, input *UpdateTrafficPolicyCommentInput, opts ...request.Option) (*UpdateTrafficPolicyCommentOutput, error) {
	req, out := c.UpdateTrafficPolicyCommentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrafficPolicyInstance = "UpdateTrafficPolicyInstance"

// UpdateTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrafficPolicyInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrafficPolicyInstance for more information on using the UpdateTrafficPolicyInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrafficPolicyInstanceRequest method.
//    req, resp := client.UpdateTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance
func (c *Route53) UpdateTrafficPolicyInstanceRequest(input *UpdateTrafficPolicyInstanceInput) (req *request.Request, output *UpdateTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicyInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &UpdateTrafficPolicyInstanceInput{}
	}

	output = &UpdateTrafficPolicyInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrafficPolicyInstance API operation for Amazon Route 53.
//
// Updates the resource record sets in a specified hosted zone that were created
// based on the settings in a specified traffic policy version.
//
// When you update a traffic policy instance, Amazon Route 53 continues to respond
// to DNS queries for the root resource record set name (such as example.com)
// while it replaces one group of resource record sets with another. Route 53
// performs the following operations:
//
// Route 53 creates a new group of resource record sets based on the specified
// traffic policy. This is true regardless of how significant the differences
// are between the existing resource record sets and the new resource record
// sets.
//
// When all of the new resource record sets have been created, Route 53 starts
// to respond to DNS queries for the root resource record set name (such as
// example.com) by using the new resource record sets.
//
// Route 53 deletes the old group of resource record sets that are associated
// with the root resource record set name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInput "InvalidInput"
//   The input is not valid.
//
//   * ErrCodeNoSuchTrafficPolicy "NoSuchTrafficPolicy"
//   No traffic policy exists with the specified ID.
//
//   * ErrCodeNoSuchTrafficPolicyInstance "NoSuchTrafficPolicyInstance"
//   No traffic policy instance exists with the specified ID.
//
//   * ErrCodePriorRequestNotComplete "PriorRequestNotComplete"
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Route 53 returns this error repeatedly for
//   the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ErrCodeConflictingTypes "ConflictingTypes"
//   You tried to update a traffic policy instance by using a traffic policy version
//   that has a different DNS type than the current type for the instance. You
//   specified the type in the JSON document in the CreateTrafficPolicy or CreateTrafficPolicyVersionrequest.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance
func (c *Route53) UpdateTrafficPolicyInstance(input *UpdateTrafficPolicyInstanceInput) (*UpdateTrafficPolicyInstanceOutput, error) {
	req, out := c.UpdateTrafficPolicyInstanceRequest(input)
	return out, req.Send()
}

// UpdateTrafficPolicyInstanceWithContext is the same as UpdateTrafficPolicyInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrafficPolicyInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53) UpdateTrafficPolicyInstanceWithContext(ctx aws.Context, input *UpdateTrafficPolicyInstanceInput, opts ...request.Option) (*UpdateTrafficPolicyInstanceOutput, error) {
	req, out := c.UpdateTrafficPolicyInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The limit that you requested. Valid values include the following:
	//
	//    * MAX_HEALTH_CHECKS_BY_OWNER: The maximum number of health checks that
	//    you can create using the current account.
	//
	//    * MAX_HOSTED_ZONES_BY_OWNER: The maximum number of hosted zones that you
	//    can create using the current account.
	//
	//    * MAX_REUSABLE_DELEGATION_SETS_BY_OWNER: The maximum number of reusable
	//    delegation sets that you can create using the current account.
	//
	//    * MAX_TRAFFIC_POLICIES_BY_OWNER: The maximum number of traffic policies
	//    that you can create using the current account.
	//
	//    * MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER: The maximum number of traffic
	//    policy instances that you can create using the current account. (Traffic
	//    policy instances are referred to as traffic flow policy records in the
	//    Amazon Route 53 console.)
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"AccountLimitType"`

	// The current value for the limit that is specified by Type (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AccountLimit.html#Route53-Type-AccountLimit-Type).
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AccountLimit) SetType(v string) *AccountLimit {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccountLimit) SetValue(v int64) *AccountLimit {
	s.Value = &v
	return s
}

type ActivateKeySigningKeyInput struct {
	_ struct{} `locationName:"ActivateKeySigningKeyRequest" type:"structure"`

	// A unique string used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"HostedZoneId" type:"string" required:"true"`

	// A string used to identify a key-signing key (KSK). Name can include numbers,
	// letters, and underscores (_). Name must be unique for each key-signing key
	// in the same hosted zone.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivateKeySigningKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateKeySigningKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateKeySigningKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateKeySigningKeyInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ActivateKeySigningKeyInput) SetHostedZoneId(v string) *ActivateKeySigningKeyInput {
	s.HostedZoneId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActivateKeySigningKeyInput) SetName(v string) *ActivateKeySigningKeyInput {
	s.Name = &v
	return s
}

type ActivateKeySigningKeyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s ActivateKeySigningKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateKeySigningKeyOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *ActivateKeySigningKeyOutput) SetChangeInfo(v *ChangeInfo) *ActivateKeySigningKeyOutput {
	s.ChangeInfo = v
	return s
}

// A complex type that identifies the CloudWatch alarm that you want Amazon
// Route 53 health checkers to use to determine whether the specified health
// check is healthy.
type AlarmIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch alarm that you want Amazon Route 53 health checkers
	// to use to determine whether this health check is healthy.
	//
	// Route 53 supports CloudWatch alarms with the following features:
	//
	//    * Standard-resolution metrics. High-resolution metrics aren't supported.
	//    For more information, see High-Resolution Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics)
	//    in the Amazon CloudWatch User Guide.
	//
	//    * Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended
	//    statistics aren't supported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// For the CloudWatch alarm that you want Route 53 health checkers to use to
	// determine whether this health check is healthy, the region that the alarm
	// was created in.
	//
	// For the current list of CloudWatch regions, see Amazon CloudWatch endpoints
	// and quotas (https://docs.aws.amazon.com/general/latest/gr/cw_region.html)
	// in the Amazon Web Services General Reference.
	//
	// Region is a required field
	Region *string `min:"1" type:"string" required:"true" enum:"CloudWatchRegion"`
}

// String returns the string representation
func (s AlarmIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlarmIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlarmIdentifier"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AlarmIdentifier) SetName(v string) *AlarmIdentifier {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *AlarmIdentifier) SetRegion(v string) *AlarmIdentifier {
	s.Region = &v
	return s
}

// Alias resource record sets only: Information about the Amazon Web Services
// resource, such as a CloudFront distribution or an Amazon S3 bucket, that
// you want to route traffic to.
//
// When creating resource record sets for a private hosted zone, note the following:
//
//    * Creating geolocation alias resource record sets or latency alias resource
//    record sets in a private hosted zone is unsupported.
//
//    * For information about creating failover resource record sets in a private
//    hosted zone, see Configuring Failover in a Private Hosted Zone (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html).
type AliasTarget struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: The value that you specify depends on where
	// you want to route queries:
	//
	// Amazon API Gateway custom regional APIs and edge-optimized APIs
	//
	// Specify the applicable domain name for your API. You can get the applicable
	// value using the CLI command get-domain-names (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html):
	//
	//    * For regional APIs, specify the value of regionalDomainName.
	//
	//    * For edge-optimized APIs, specify the value of distributionDomainName.
	//    This is the name of the associated CloudFront distribution, such as da1b2c3d4e5.cloudfront.net.
	//
	// The name of the record that you're creating must match a custom domain name
	// for your API, such as api.example.com.
	//
	// Amazon Virtual Private Cloud interface VPC endpoint
	//
	// Enter the API endpoint for the interface endpoint, such as vpce-123456789abcdef01-example-us-east-1a.elasticloadbalancing.us-east-1.vpce.amazonaws.com.
	// For edge-optimized APIs, this is the domain name for the corresponding CloudFront
	// distribution. You can get the value of DnsName using the CLI command describe-vpc-endpoints
	// (https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html).
	//
	// CloudFront distribution
	//
	// Specify the domain name that CloudFront assigned when you created your distribution.
	//
	// Your CloudFront distribution must include an alternate domain name that matches
	// the name of the resource record set. For example, if the name of the resource
	// record set is acme.example.com, your CloudFront distribution must include
	// acme.example.com as one of the alternate domain names. For more information,
	// see Using Alternate Domain Names (CNAMEs) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// You can't create a resource record set in a private hosted zone to route
	// traffic to a CloudFront distribution.
	//
	// For failover alias records, you can't specify a CloudFront distribution for
	// both the primary and secondary records. A distribution must include an alternate
	// domain name that matches the name of the record. However, the primary and
	// secondary records have the same name, and you can't include the same alternate
	// domain name in more than one distribution.
	//
	// Elastic Beanstalk environment
	//
	// If the domain name for your Elastic Beanstalk environment includes the region
	// that you deployed the environment in, you can create an alias record that
	// routes traffic to the environment. For example, the domain name my-environment.us-west-2.elasticbeanstalk.com
	// is a regionalized domain name.
	//
	// For environments that were created before early 2016, the domain name doesn't
	// include the region. To route traffic to these environments, you must create
	// a CNAME record instead of an alias record. Note that you can't create a CNAME
	// record for the root domain name. For example, if your domain name is example.com,
	// you can create a record that routes traffic for acme.example.com to your
	// Elastic Beanstalk environment, but you can't create a record that routes
	// traffic for example.com to your Elastic Beanstalk environment.
	//
	// For Elastic Beanstalk environments that have regionalized subdomains, specify
	// the CNAME attribute for the environment. You can use the following methods
	// to get the value of the CNAME attribute:
	//
	//    * Management Console: For information about how to get the value by using
	//    the console, see Using Custom Domains with Elastic Beanstalk (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html)
	//    in the Elastic Beanstalk Developer Guide.
	//
	//    * Elastic Beanstalk API: Use the DescribeEnvironments action to get the
	//    value of the CNAME attribute. For more information, see DescribeEnvironments
	//    (https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html)
	//    in the Elastic Beanstalk API Reference.
	//
	//    * CLI: Use the describe-environments command to get the value of the CNAME
	//    attribute. For more information, see describe-environments (https://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html)
	//    in the CLI Command Reference.
	//
	// ELB load balancer
	//
	// Specify the DNS name that is associated with the load balancer. Get the DNS
	// name by using the Management Console, the ELB API, or the CLI.
	//
	//    * Management Console: Go to the EC2 page, choose Load Balancers in the
	//    navigation pane, choose the load balancer, choose the Description tab,
	//    and get the value of the DNS name field. If you're routing traffic to
	//    a Classic Load Balancer, get the value that begins with dualstack. If
	//    you're routing traffic to another type of load balancer, get the value
	//    that applies to the record type, A or AAAA.
	//
	//    * Elastic Load Balancing API: Use DescribeLoadBalancers to get the value
	//    of DNSName. For more information, see the applicable guide: Classic Load
	//    Balancers: DescribeLoadBalancers (https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html)
	//    Application and Network Load Balancers: DescribeLoadBalancers (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	//
	//    * CLI: Use describe-load-balancers to get the value of DNSName. For more
	//    information, see the applicable guide: Classic Load Balancers: describe-load-balancers
	//    (http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html)
	//    Application and Network Load Balancers: describe-load-balancers (http://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html)
	//
	// Global Accelerator accelerator
	//
	// Specify the DNS name for your accelerator:
	//
	//    * Global Accelerator API: To get the DNS name, use DescribeAccelerator
	//    (https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAccelerator.html).
	//
	//    * CLI: To get the DNS name, use describe-accelerator (https://docs.aws.amazon.com/cli/latest/reference/globalaccelerator/describe-accelerator.html).
	//
	// Amazon S3 bucket that is configured as a static website
	//
	// Specify the domain name of the Amazon S3 website endpoint that you created
	// the bucket in, for example, s3-website.us-east-2.amazonaws.com. For more
	// information about valid values, see the table Amazon S3 Website Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints)
	// in the Amazon Web Services General Reference. For more information about
	// using S3 buckets for websites, see Getting Started with Amazon Route 53 (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Another Route 53 resource record set
	//
	// Specify the value of the Name element for a resource record set in the current
	// hosted zone.
	//
	// If you're creating an alias record that has the same name as the hosted zone
	// (known as the zone apex), you can't specify the domain name for a record
	// for which the value of Type is CNAME. This is because the alias record must
	// have the same type as the record that you're routing traffic to, and creating
	// a CNAME record for the zone apex isn't supported even for an alias record.
	//
	// DNSName is a required field
	DNSName *string `type:"string" required:"true"`

	// Applies only to alias, failover alias, geolocation alias, latency alias,
	// and weighted alias resource record sets: When EvaluateTargetHealth is true,
	// an alias resource record set inherits the health of the referenced Amazon
	// Web Services resource, such as an ELB load balancer or another resource record
	// set in the hosted zone.
	//
	// Note the following:
	//
	// CloudFront distributions
	//
	// You can't set EvaluateTargetHealth to true when the alias target is a CloudFront
	// distribution.
	//
	// Elastic Beanstalk environments that have regionalized subdomains
	//
	// If you specify an Elastic Beanstalk environment in DNSName and the environment
	// contains an ELB load balancer, Elastic Load Balancing routes queries only
	// to the healthy Amazon EC2 instances that are registered with the load balancer.
	// (An environment automatically contains an ELB load balancer if it includes
	// more than one Amazon EC2 instance.) If you set EvaluateTargetHealth to true
	// and either no Amazon EC2 instances are healthy or the load balancer itself
	// is unhealthy, Route 53 routes queries to other available resources that are
	// healthy, if any.
	//
	// If the environment contains a single Amazon EC2 instance, there are no special
	// requirements.
	//
	// ELB load balancers
	//
	// Health checking behavior depends on the type of load balancer:
	//
	//    * Classic Load Balancers: If you specify an ELB Classic Load Balancer
	//    in DNSName, Elastic Load Balancing routes queries only to the healthy
	//    Amazon EC2 instances that are registered with the load balancer. If you
	//    set EvaluateTargetHealth to true and either no EC2 instances are healthy
	//    or the load balancer itself is unhealthy, Route 53 routes queries to other
	//    resources.
	//
	//    * Application and Network Load Balancers: If you specify an ELB Application
	//    or Network Load Balancer and you set EvaluateTargetHealth to true, Route
	//    53 routes queries to the load balancer based on the health of the target
	//    groups that are associated with the load balancer: For an Application
	//    or Network Load Balancer to be considered healthy, every target group
	//    that contains targets must contain at least one healthy target. If any
	//    target group contains only unhealthy targets, the load balancer is considered
	//    unhealthy, and Route 53 routes queries to other resources. A target group
	//    that has no registered targets is considered unhealthy.
	//
	// When you create a load balancer, you configure settings for Elastic Load
	// Balancing health checks; they're not Route 53 health checks, but they perform
	// a similar function. Do not create Route 53 health checks for the EC2 instances
	// that you register with an ELB load balancer.
	//
	// S3 buckets
	//
	// There are no special requirements for setting EvaluateTargetHealth to true
	// when the alias target is an S3 bucket.
	//
	// Other records in the same hosted zone
	//
	// If the Amazon Web Services resource that you specify in DNSName is a record
	// or a group of records (for example, a group of weighted records) but is not
	// another alias record, we recommend that you associate a health check with
	// all of the records in the alias target. For more information, see What Happens
	// When You Omit Health Checks? (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting)
	// in the Amazon Route 53 Developer Guide.
	//
	// For more information and examples, see Amazon Route 53 Health Checks and
	// DNS Failover (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// EvaluateTargetHealth is a required field
	EvaluateTargetHealth *bool `type:"boolean" required:"true"`

	// Alias resource records sets only: The value used depends on where you want
	// to route traffic:
	//
	// Amazon API Gateway custom regional APIs and edge-optimized APIs
	//
	// Specify the hosted zone ID for your API. You can get the applicable value
	// using the CLI command get-domain-names (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html):
	//
	//    * For regional APIs, specify the value of regionalHostedZoneId.
	//
	//    * For edge-optimized APIs, specify the value of distributionHostedZoneId.
	//
	// Amazon Virtual Private Cloud interface VPC endpoint
	//
	// Specify the hosted zone ID for your interface endpoint. You can get the value
	// of HostedZoneId using the CLI command describe-vpc-endpoints (https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html).
	//
	// CloudFront distribution
	//
	// Specify Z2FDTNDATAQYW2.
	//
	// Alias resource record sets for CloudFront can't be created in a private zone.
	//
	// Elastic Beanstalk environment
	//
	// Specify the hosted zone ID for the region that you created the environment
	// in. The environment must have a regionalized subdomain. For a list of regions
	// and the corresponding hosted zone IDs, see Elastic Beanstalk endpoints and
	// quotas (https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html)
	// in the the Amazon Web Services General Reference.
	//
	// ELB load balancer
	//
	// Specify the value of the hosted zone ID for the load balancer. Use the following
	// methods to get the hosted zone ID:
	//
	//    * Elastic Load Balancing endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/elb.html)
	//    topic in the Amazon Web Services General Reference: Use the value that
	//    corresponds with the region that you created your load balancer in. Note
	//    that there are separate columns for Application and Classic Load Balancers
	//    and for Network Load Balancers.
	//
	//    * Management Console: Go to the Amazon EC2 page, choose Load Balancers
	//    in the navigation pane, select the load balancer, and get the value of
	//    the Hosted zone field on the Description tab.
	//
	//    * Elastic Load Balancing API: Use DescribeLoadBalancers to get the applicable
	//    value. For more information, see the applicable guide: Classic Load Balancers:
	//    Use DescribeLoadBalancers (https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html)
	//    to get the value of CanonicalHostedZoneNameId. Application and Network
	//    Load Balancers: Use DescribeLoadBalancers (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	//    to get the value of CanonicalHostedZoneId.
	//
	//    * CLI: Use describe-load-balancers to get the applicable value. For more
	//    information, see the applicable guide: Classic Load Balancers: Use describe-load-balancers
	//    (http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html)
	//    to get the value of CanonicalHostedZoneNameId. Application and Network
	//    Load Balancers: Use describe-load-balancers (http://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html)
	//    to get the value of CanonicalHostedZoneId.
	//
	// Global Accelerator accelerator
	//
	// Specify Z2BJ6XQ5FK7U4H.
	//
	// An Amazon S3 bucket configured as a static website
	//
	// Specify the hosted zone ID for the region that you created the bucket in.
	// For more information about valid values, see the table Amazon S3 Website
	// Endpoints (https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints)
	// in the Amazon Web Services General Reference.
	//
	// Another Route 53 resource record set in your hosted zone
	//
	// Specify the hosted zone ID of your hosted zone. (An alias resource record
	// set can't reference a resource record set in a different hosted zone.)
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AliasTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AliasTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AliasTarget"}
	if s.DNSName == nil {
		invalidParams.Add(request.NewErrParamRequired("DNSName"))
	}
	if s.EvaluateTargetHealth == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluateTargetHealth"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDNSName sets the DNSName field's value.
func (s *AliasTarget) SetDNSName(v string) *AliasTarget {
	s.DNSName = &v
	return s
}

// SetEvaluateTargetHealth sets the EvaluateTargetHealth field's value.
func (s *AliasTarget) SetEvaluateTargetHealth(v bool) *AliasTarget {
	s.EvaluateTargetHealth = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AliasTarget) SetHostedZoneId(v string) *AliasTarget {
	s.HostedZoneId = &v
	return s
}

// A complex type that contains information about the request to associate a
// VPC with a private hosted zone.
type AssociateVPCWithHostedZoneInput struct {
	_ struct{} `locationName:"AssociateVPCWithHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Optional: A comment about the association request.
	Comment *string `type:"string"`

	// The ID of the private hosted zone that you want to associate an Amazon VPC
	// with.
	//
	// Note that you can't associate a VPC with a hosted zone that doesn't have
	// an existing VPC association.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A complex type that contains information about the VPC that you want to associate
	// with a private hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateVPCWithHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateVPCWithHostedZoneInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.VPC == nil {
		invalidParams.Add(request.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *AssociateVPCWithHostedZoneInput) SetComment(v string) *AssociateVPCWithHostedZoneInput {
	s.Comment = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AssociateVPCWithHostedZoneInput) SetHostedZoneId(v string) *AssociateVPCWithHostedZoneInput {
	s.HostedZoneId = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *AssociateVPCWithHostedZoneInput) SetVPC(v *VPC) *AssociateVPCWithHostedZoneInput {
	s.VPC = v
	return s
}

// A complex type that contains the response information for the AssociateVPCWithHostedZone
// request.
type AssociateVPCWithHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes the changes made to your hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *AssociateVPCWithHostedZoneOutput) SetChangeInfo(v *ChangeInfo) *AssociateVPCWithHostedZoneOutput {
	s.ChangeInfo = v
	return s
}

// The information for each resource record set that you want to change.
type Change struct {
	_ struct{} `type:"structure"`

	// The action to perform:
	//
	//    * CREATE: Creates a resource record set that has the specified values.
	//
	//    * DELETE: Deletes a existing resource record set. To delete the resource
	//    record set that is associated with a traffic policy instance, use DeleteTrafficPolicyInstance
	//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html).
	//    Amazon Route 53 will delete the resource record set automatically. If
	//    you delete the resource record set by using ChangeResourceRecordSets,
	//    Route 53 doesn't automatically delete the traffic policy instance, and
	//    you'll continue to be charged for it even though it's no longer in use.
	//
	//    * UPSERT: If a resource record set doesn't already exist, Route 53 creates
	//    it. If a resource record set does exist, Route 53 updates it with the
	//    values in the request.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the resource record set to create, delete, or update.
	//
	// ResourceRecordSet is a required field
	ResourceRecordSet *ResourceRecordSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Change) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Change"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ResourceRecordSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceRecordSet"))
	}
	if s.ResourceRecordSet != nil {
		if err := s.ResourceRecordSet.Validate(); err != nil {
			invalidParams.AddNested("ResourceRecordSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *Change) SetAction(v string) *Change {
	s.Action = &v
	return s
}

// SetResourceRecordSet sets the ResourceRecordSet field's value.
func (s *Change) SetResourceRecordSet(v *ResourceRecordSet) *Change {
	s.ResourceRecordSet = v
	return s
}

// The information for a change request.
type ChangeBatch struct {
	_ struct{} `type:"structure"`

	// Information about the changes to make to the record sets.
	//
	// Changes is a required field
	Changes []*Change `locationNameList:"Change" min:"1" type:"list" required:"true"`

	// Optional: Any comments you want to include about a change batch request.
	Comment *string `type:"string"`
}

// String returns the string representation
func (s ChangeBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeBatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeBatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeBatch"}
	if s.Changes == nil {
		invalidParams.Add(request.NewErrParamRequired("Changes"))
	}
	if s.Changes != nil && len(s.Changes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Changes", 1))
	}
	if s.Changes != nil {
		for i, v := range s.Changes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Changes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChanges sets the Changes field's value.
func (s *ChangeBatch) SetChanges(v []*Change) *ChangeBatch {
	s.Changes = v
	return s
}

// SetComment sets the Comment field's value.
func (s *ChangeBatch) SetComment(v string) *ChangeBatch {
	s.Comment = &v
	return s
}

// A complex type that describes change information about changes made to your
// hosted zone.
type ChangeInfo struct {
	_ struct{} `type:"structure"`

	// A comment you can provide.
	Comment *string `type:"string"`

	// This element contains an ID that you use when performing a GetChange (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html)
	// action to get detailed information about the change.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ChangeStatus"`

	// The date and time that the change request was submitted in ISO 8601 format
	// (https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal Time (UTC).
	// For example, the value 2017-03-27T17:48:16.751Z represents March 27, 2017
	// at 17:48:16.751 UTC.
	//
	// SubmittedAt is a required field
	SubmittedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ChangeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeInfo) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *ChangeInfo) SetComment(v string) *ChangeInfo {
	s.Comment = &v
	return s
}

// SetId sets the Id field's value.
func (s *ChangeInfo) SetId(v string) *ChangeInfo {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeInfo) SetStatus(v string) *ChangeInfo {
	s.Status = &v
	return s
}

// SetSubmittedAt sets the SubmittedAt field's value.
func (s *ChangeInfo) SetSubmittedAt(v time.Time) *ChangeInfo {
	s.SubmittedAt = &v
	return s
}

// A complex type that contains change information for the resource record set.
type ChangeResourceRecordSetsInput struct {
	_ struct{} `locationName:"ChangeResourceRecordSetsRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains an optional comment and the Changes element.
	//
	// ChangeBatch is a required field
	ChangeBatch *ChangeBatch `type:"structure" required:"true"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to change.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeResourceRecordSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeResourceRecordSetsInput"}
	if s.ChangeBatch == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeBatch"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.ChangeBatch != nil {
		if err := s.ChangeBatch.Validate(); err != nil {
			invalidParams.AddNested("ChangeBatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeBatch sets the ChangeBatch field's value.
func (s *ChangeResourceRecordSetsInput) SetChangeBatch(v *ChangeBatch) *ChangeResourceRecordSetsInput {
	s.ChangeBatch = v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ChangeResourceRecordSetsInput) SetHostedZoneId(v string) *ChangeResourceRecordSetsInput {
	s.HostedZoneId = &v
	return s
}

// A complex type containing the response for the request.
type ChangeResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about changes made to your hosted
	// zone.
	//
	// This element contains an ID that you use when performing a GetChange (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html)
	// action to get detailed information about the change.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *ChangeResourceRecordSetsOutput) SetChangeInfo(v *ChangeInfo) *ChangeResourceRecordSetsOutput {
	s.ChangeInfo = v
	return s
}

// A complex type that contains information about the tags that you want to
// add, edit, or delete.
type ChangeTagsForResourceInput struct {
	_ struct{} `locationName:"ChangeTagsForResourceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains a list of the tags that you want to add to the
	// specified health check or hosted zone and/or the tags that you want to edit
	// Value for.
	//
	// You can add a maximum of 10 tags to a health check or a hosted zone.
	AddTags []*Tag `locationNameList:"Tag" min:"1" type:"list"`

	// A complex type that contains a list of the tags that you want to delete from
	// the specified health check or hosted zone. You can specify up to 10 keys.
	RemoveTagKeys []*string `locationNameList:"Key" min:"1" type:"list"`

	// The ID of the resource for which you want to add, change, or delete tags.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ChangeTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeTagsForResourceInput"}
	if s.AddTags != nil && len(s.AddTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddTags", 1))
	}
	if s.RemoveTagKeys != nil && len(s.RemoveTagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveTagKeys", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddTags sets the AddTags field's value.
func (s *ChangeTagsForResourceInput) SetAddTags(v []*Tag) *ChangeTagsForResourceInput {
	s.AddTags = v
	return s
}

// SetRemoveTagKeys sets the RemoveTagKeys field's value.
func (s *ChangeTagsForResourceInput) SetRemoveTagKeys(v []*string) *ChangeTagsForResourceInput {
	s.RemoveTagKeys = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ChangeTagsForResourceInput) SetResourceId(v string) *ChangeTagsForResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ChangeTagsForResourceInput) SetResourceType(v string) *ChangeTagsForResourceInput {
	s.ResourceType = &v
	return s
}

// Empty response for the request.
type ChangeTagsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangeTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the CloudWatch alarm that
// Amazon Route 53 is monitoring for this health check.
type CloudWatchAlarmConfiguration struct {
	_ struct{} `type:"structure"`

	// For the metric that the CloudWatch alarm is associated with, the arithmetic
	// operation that is used for the comparison.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// For the metric that the CloudWatch alarm is associated with, a complex type
	// that contains information about the dimensions for the metric. For information,
	// see Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
	// in the Amazon CloudWatch User Guide.
	Dimensions []*Dimension `locationNameList:"Dimension" type:"list"`

	// For the metric that the CloudWatch alarm is associated with, the number of
	// periods that the metric is compared to the threshold.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The name of the CloudWatch metric that the alarm is associated with.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric that the alarm is associated with. For more information,
	// see Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
	// in the Amazon CloudWatch User Guide.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the duration
	// of one evaluation period in seconds.
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the statistic
	// that is applied to the metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"Statistic"`

	// For the metric that the CloudWatch alarm is associated with, the value the
	// metric is compared with.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s CloudWatchAlarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchAlarmConfiguration) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *CloudWatchAlarmConfiguration) SetComparisonOperator(v string) *CloudWatchAlarmConfiguration {
	s.ComparisonOperator = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *CloudWatchAlarmConfiguration) SetDimensions(v []*Dimension) *CloudWatchAlarmConfiguration {
	s.Dimensions = v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *CloudWatchAlarmConfiguration) SetEvaluationPeriods(v int64) *CloudWatchAlarmConfiguration {
	s.EvaluationPeriods = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CloudWatchAlarmConfiguration) SetMetricName(v string) *CloudWatchAlarmConfiguration {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CloudWatchAlarmConfiguration) SetNamespace(v string) *CloudWatchAlarmConfiguration {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CloudWatchAlarmConfiguration) SetPeriod(v int64) *CloudWatchAlarmConfiguration {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CloudWatchAlarmConfiguration) SetStatistic(v string) *CloudWatchAlarmConfiguration {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *CloudWatchAlarmConfiguration) SetThreshold(v float64) *CloudWatchAlarmConfiguration {
	s.Threshold = &v
	return s
}

// A complex type that contains the health check request information.
type CreateHealthCheckInput struct {
	_ struct{} `locationName:"CreateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows you to retry
	// a failed CreateHealthCheck request without the risk of creating two identical
	// health checks:
	//
	//    * If you send a CreateHealthCheck request with the same CallerReference
	//    and settings as a previous request, and if the health check doesn't exist,
	//    Amazon Route 53 creates the health check. If the health check does exist,
	//    Route 53 returns the settings for the existing health check.
	//
	//    * If you send a CreateHealthCheck request with the same CallerReference
	//    as a deleted health check, regardless of the settings, Route 53 returns
	//    a HealthCheckAlreadyExists error.
	//
	//    * If you send a CreateHealthCheck request with the same CallerReference
	//    as an existing health check but with different settings, Route 53 returns
	//    a HealthCheckAlreadyExists error.
	//
	//    * If you send a CreateHealthCheck request with a unique CallerReference
	//    but settings identical to an existing health check, Route 53 creates the
	//    health check.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains settings for a new health check.
	//
	// HealthCheckConfig is a required field
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHealthCheckInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}
	if s.HealthCheckConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckConfig"))
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *CreateHealthCheckInput) SetCallerReference(v string) *CreateHealthCheckInput {
	s.CallerReference = &v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *CreateHealthCheckInput) SetHealthCheckConfig(v *HealthCheckConfig) *CreateHealthCheckInput {
	s.HealthCheckConfig = v
	return s
}

// A complex type containing the response information for the new health check.
type CreateHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains identifying information about the health check.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The unique URL representing the new health check.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckOutput) GoString() string {
	return s.String()
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *CreateHealthCheckOutput) SetHealthCheck(v *HealthCheck) *CreateHealthCheckOutput {
	s.HealthCheck = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateHealthCheckOutput) SetLocation(v string) *CreateHealthCheckOutput {
	s.Location = &v
	return s
}

// A complex type that contains information about the request to create a public
// or private hosted zone.
type CreateHostedZoneInput struct {
	_ struct{} `locationName:"CreateHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows failed CreateHostedZone
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you submit a CreateHostedZone
	// request. CallerReference can be any unique string, for example, a date/time
	// stamp.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// If you want to associate a reusable delegation set with this hosted zone,
	// the ID that Amazon Route 53 assigned to the reusable delegation set when
	// you created it. For more information about reusable delegation sets, see
	// CreateReusableDelegationSet (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html).
	DelegationSetId *string `type:"string"`

	// (Optional) A complex type that contains the following optional values:
	//
	//    * For public and private hosted zones, an optional comment
	//
	//    * For private hosted zones, an optional PrivateZone element
	//
	// If you don't specify a comment or the PrivateZone element, omit HostedZoneConfig
	// and the other elements.
	HostedZoneConfig *HostedZoneConfig `type:"structure"`

	// The name of the domain. Specify a fully qualified domain name, for example,
	// www.example.com. The trailing dot is optional; Amazon Route 53 assumes that
	// the domain name is fully qualified. This means that Route 53 treats www.example.com
	// (without a trailing dot) and www.example.com. (with a trailing dot) as identical.
	//
	// If you're creating a public hosted zone, this is the name you have registered
	// with your DNS registrar. If your domain name is registered with a registrar
	// other than Route 53, change the name servers for your domain to the set of
	// NameServers that CreateHostedZone returns in DelegationSet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// (Private hosted zones only) A complex type that contains information about
	// the Amazon VPC that you're associating with this hosted zone.
	//
	// You can specify only one Amazon VPC when you create a private hosted zone.
	// To associate additional Amazon VPCs with the hosted zone, use AssociateVPCWithHostedZone
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html)
	// after you create a hosted zone.
	VPC *VPC `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHostedZoneInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *CreateHostedZoneInput) SetCallerReference(v string) *CreateHostedZoneInput {
	s.CallerReference = &v
	return s
}

// SetDelegationSetId sets the DelegationSetId field's value.
func (s *CreateHostedZoneInput) SetDelegationSetId(v string) *CreateHostedZoneInput {
	s.DelegationSetId = &v
	return s
}

// SetHostedZoneConfig sets the HostedZoneConfig field's value.
func (s *CreateHostedZoneInput) SetHostedZoneConfig(v *HostedZoneConfig) *CreateHostedZoneInput {
	s.HostedZoneConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateHostedZoneInput) SetName(v string) *CreateHostedZoneInput {
	s.Name = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *CreateHostedZoneInput) SetVPC(v *VPC) *CreateHostedZoneInput {
	s.VPC = v
	return s
}

// A complex type containing the response information for the hosted zone.
type CreateHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the CreateHostedZone request.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	// A complex type that describes the name servers for this hosted zone.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`

	// The unique URL representing the new hosted zone.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains information about an Amazon VPC that you associated
	// with this hosted zone.
	VPC *VPC `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *CreateHostedZoneOutput) SetChangeInfo(v *ChangeInfo) *CreateHostedZoneOutput {
	s.ChangeInfo = v
	return s
}

// SetDelegationSet sets the DelegationSet field's value.
func (s *CreateHostedZoneOutput) SetDelegationSet(v *DelegationSet) *CreateHostedZoneOutput {
	s.DelegationSet = v
	return s
}

// SetHostedZone sets the HostedZone field's value.
func (s *CreateHostedZoneOutput) SetHostedZone(v *HostedZone) *CreateHostedZoneOutput {
	s.HostedZone = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateHostedZoneOutput) SetLocation(v string) *CreateHostedZoneOutput {
	s.Location = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *CreateHostedZoneOutput) SetVPC(v *VPC) *CreateHostedZoneOutput {
	s.VPC = v
	return s
}

type CreateKeySigningKeyInput struct {
	_ struct{} `locationName:"CreateKeySigningKeyRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// The unique string (ID) used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The Amazon resource name (ARN) for a customer managed customer master key
	// (CMK) in Key Management Service (KMS). The KeyManagementServiceArn must be
	// unique for each key-signing key (KSK) in a single hosted zone. To see an
	// example of KeyManagementServiceArn that grants the correct permissions for
	// DNSSEC, scroll down to Example.
	//
	// You must configure the customer managed CMK as follows:
	//
	// Status
	//
	// Enabled
	//
	// Key spec
	//
	// ECC_NIST_P256
	//
	// Key usage
	//
	// Sign and verify
	//
	// Key policy
	//
	// The key policy must give permission for the following actions:
	//
	//    * DescribeKey
	//
	//    * GetPublicKey
	//
	//    * Sign
	//
	// The key policy must also include the Amazon Route 53 service in the principal
	// for your account. Specify the following:
	//
	//    * "Service": "dnssec-route53.amazonaws.com"
	//
	// For more information about working with a customer managed CMK in KMS, see
	// Key Management Service concepts (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
	//
	// KeyManagementServiceArn is a required field
	KeyManagementServiceArn *string `type:"string" required:"true"`

	// A string used to identify a key-signing key (KSK). Name can include numbers,
	// letters, and underscores (_). Name must be unique for each key-signing key
	// in the same hosted zone.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// A string specifying the initial status of the key-signing key (KSK). You
	// can set the value to ACTIVE or INACTIVE.
	//
	// Status is a required field
	Status *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateKeySigningKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeySigningKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeySigningKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeySigningKeyInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.KeyManagementServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyManagementServiceArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Status != nil && len(*s.Status) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Status", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *CreateKeySigningKeyInput) SetCallerReference(v string) *CreateKeySigningKeyInput {
	s.CallerReference = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *CreateKeySigningKeyInput) SetHostedZoneId(v string) *CreateKeySigningKeyInput {
	s.HostedZoneId = &v
	return s
}

// SetKeyManagementServiceArn sets the KeyManagementServiceArn field's value.
func (s *CreateKeySigningKeyInput) SetKeyManagementServiceArn(v string) *CreateKeySigningKeyInput {
	s.KeyManagementServiceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateKeySigningKeyInput) SetName(v string) *CreateKeySigningKeyInput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKeySigningKeyInput) SetStatus(v string) *CreateKeySigningKeyInput {
	s.Status = &v
	return s
}

type CreateKeySigningKeyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	// The key-signing key (KSK) that the request creates.
	//
	// KeySigningKey is a required field
	KeySigningKey *KeySigningKey `type:"structure" required:"true"`

	// The unique URL representing the new key-signing key (KSK).
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateKeySigningKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeySigningKeyOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *CreateKeySigningKeyOutput) SetChangeInfo(v *ChangeInfo) *CreateKeySigningKeyOutput {
	s.ChangeInfo = v
	return s
}

// SetKeySigningKey sets the KeySigningKey field's value.
func (s *CreateKeySigningKeyOutput) SetKeySigningKey(v *KeySigningKey) *CreateKeySigningKeyOutput {
	s.KeySigningKey = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateKeySigningKeyOutput) SetLocation(v string) *CreateKeySigningKeyOutput {
	s.Location = &v
	return s
}

type CreateQueryLoggingConfigInput struct {
	_ struct{} `locationName:"CreateQueryLoggingConfigRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The Amazon Resource Name (ARN) for the log group that you want to Amazon
	// Route 53 to send query logs to. This is the format of the ARN:
	//
	// arn:aws:logs:region:account-id:log-group:log_group_name
	//
	// To get the ARN for a log group, you can use the CloudWatch console, the DescribeLogGroups
	// (https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html)
	// API action, the describe-log-groups (https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html)
	// command, or the applicable command in one of the Amazon Web Services SDKs.
	//
	// CloudWatchLogsLogGroupArn is a required field
	CloudWatchLogsLogGroupArn *string `type:"string" required:"true"`

	// The ID of the hosted zone that you want to log queries for. You can log queries
	// only for public hosted zones.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateQueryLoggingConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQueryLoggingConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueryLoggingConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueryLoggingConfigInput"}
	if s.CloudWatchLogsLogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogsLogGroupArn"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *CreateQueryLoggingConfigInput) SetCloudWatchLogsLogGroupArn(v string) *CreateQueryLoggingConfigInput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *CreateQueryLoggingConfigInput) SetHostedZoneId(v string) *CreateQueryLoggingConfigInput {
	s.HostedZoneId = &v
	return s
}

type CreateQueryLoggingConfigOutput struct {
	_ struct{} `type:"structure"`

	// The unique URL representing the new query logging configuration.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains the ID for a query logging configuration, the
	// ID of the hosted zone that you want to log queries for, and the ARN for the
	// log group that you want Amazon Route 53 to send query logs to.
	//
	// QueryLoggingConfig is a required field
	QueryLoggingConfig *QueryLoggingConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateQueryLoggingConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQueryLoggingConfigOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateQueryLoggingConfigOutput) SetLocation(v string) *CreateQueryLoggingConfigOutput {
	s.Location = &v
	return s
}

// SetQueryLoggingConfig sets the QueryLoggingConfig field's value.
func (s *CreateQueryLoggingConfigOutput) SetQueryLoggingConfig(v *QueryLoggingConfig) *CreateQueryLoggingConfigOutput {
	s.QueryLoggingConfig = v
	return s
}

type CreateReusableDelegationSetInput struct {
	_ struct{} `locationName:"CreateReusableDelegationSetRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request, and that allows you to retry
	// failed CreateReusableDelegationSet requests without the risk of executing
	// the operation twice. You must use a unique CallerReference string every time
	// you submit a CreateReusableDelegationSet request. CallerReference can be
	// any unique string, for example a date/time stamp.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// If you want to mark the delegation set for an existing hosted zone as reusable,
	// the ID for that hosted zone.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s CreateReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReusableDelegationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReusableDelegationSetInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *CreateReusableDelegationSetInput) SetCallerReference(v string) *CreateReusableDelegationSetInput {
	s.CallerReference = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *CreateReusableDelegationSetInput) SetHostedZoneId(v string) *CreateReusableDelegationSetInput {
	s.HostedZoneId = &v
	return s
}

type CreateReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains name server information.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// The unique URL representing the new reusable delegation set.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// SetDelegationSet sets the DelegationSet field's value.
func (s *CreateReusableDelegationSetOutput) SetDelegationSet(v *DelegationSet) *CreateReusableDelegationSetOutput {
	s.DelegationSet = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateReusableDelegationSetOutput) SetLocation(v string) *CreateReusableDelegationSetOutput {
	s.Location = &v
	return s
}

// A complex type that contains information about the traffic policy that you
// want to create.
type CreateTrafficPolicyInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// (Optional) Any comments that you want to include about the traffic policy.
	Comment *string `type:"string"`

	// The definition of this traffic policy in JSON format. For more information,
	// see Traffic Policy Document Format (https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The name of the traffic policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CreateTrafficPolicyInput) SetComment(v string) *CreateTrafficPolicyInput {
	s.Comment = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *CreateTrafficPolicyInput) SetDocument(v string) *CreateTrafficPolicyInput {
	s.Document = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrafficPolicyInput) SetName(v string) *CreateTrafficPolicyInput {
	s.Name = &v
	return s
}

// A complex type that contains information about the resource record sets that
// you want to create based on a specified traffic policy.
type CreateTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyInstanceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the hosted zone that you want Amazon Route 53 to create resource
	// record sets in by using the configuration in a traffic policy.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The domain name (such as example.com) or subdomain name (such as www.example.com)
	// for which Amazon Route 53 responds to DNS queries by using the resource record
	// sets that Route 53 creates for this traffic policy instance.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// (Optional) The TTL that you want Amazon Route 53 to assign to all of the
	// resource record sets that it creates in the specified hosted zone.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that you want to use to create resource record
	// sets in the specified hosted zone.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// The version of the traffic policy that you want to use to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyInstanceInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.TTL == nil {
		invalidParams.Add(request.NewErrParamRequired("TTL"))
	}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}
	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *CreateTrafficPolicyInstanceInput) SetHostedZoneId(v string) *CreateTrafficPolicyInstanceInput {
	s.HostedZoneId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrafficPolicyInstanceInput) SetName(v string) *CreateTrafficPolicyInstanceInput {
	s.Name = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *CreateTrafficPolicyInstanceInput) SetTTL(v int64) *CreateTrafficPolicyInstanceInput {
	s.TTL = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *CreateTrafficPolicyInstanceInput) SetTrafficPolicyId(v string) *CreateTrafficPolicyInstanceInput {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyVersion sets the TrafficPolicyVersion field's value.
func (s *CreateTrafficPolicyInstanceInput) SetTrafficPolicyVersion(v int64) *CreateTrafficPolicyInstanceInput {
	s.TrafficPolicyVersion = &v
	return s
}

// A complex type that contains the response information for the CreateTrafficPolicyInstance
// request.
type CreateTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy instance.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy instance.
	//
	// TrafficPolicyInstance is a required field
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateTrafficPolicyInstanceOutput) SetLocation(v string) *CreateTrafficPolicyInstanceOutput {
	s.Location = &v
	return s
}

// SetTrafficPolicyInstance sets the TrafficPolicyInstance field's value.
func (s *CreateTrafficPolicyInstanceOutput) SetTrafficPolicyInstance(v *TrafficPolicyInstance) *CreateTrafficPolicyInstanceOutput {
	s.TrafficPolicyInstance = v
	return s
}

// A complex type that contains the response information for the CreateTrafficPolicy
// request.
type CreateTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateTrafficPolicyOutput) SetLocation(v string) *CreateTrafficPolicyOutput {
	s.Location = &v
	return s
}

// SetTrafficPolicy sets the TrafficPolicy field's value.
func (s *CreateTrafficPolicyOutput) SetTrafficPolicy(v *TrafficPolicy) *CreateTrafficPolicyOutput {
	s.TrafficPolicy = v
	return s
}

// A complex type that contains information about the traffic policy that you
// want to create a new version for.
type CreateTrafficPolicyVersionInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyVersionRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The comment that you specified in the CreateTrafficPolicyVersion request,
	// if any.
	Comment *string `type:"string"`

	// The definition of this version of the traffic policy, in JSON format. You
	// specified the JSON in the CreateTrafficPolicyVersion request. For more information
	// about the JSON format, see CreateTrafficPolicy (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html).
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ID of the traffic policy for which you want to create a new version.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyVersionInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CreateTrafficPolicyVersionInput) SetComment(v string) *CreateTrafficPolicyVersionInput {
	s.Comment = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *CreateTrafficPolicyVersionInput) SetDocument(v string) *CreateTrafficPolicyVersionInput {
	s.Document = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateTrafficPolicyVersionInput) SetId(v string) *CreateTrafficPolicyVersionInput {
	s.Id = &v
	return s
}

// A complex type that contains the response information for the CreateTrafficPolicyVersion
// request.
type CreateTrafficPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy version.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new version of the traffic
	// policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyVersionOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateTrafficPolicyVersionOutput) SetLocation(v string) *CreateTrafficPolicyVersionOutput {
	s.Location = &v
	return s
}

// SetTrafficPolicy sets the TrafficPolicy field's value.
func (s *CreateTrafficPolicyVersionOutput) SetTrafficPolicy(v *TrafficPolicy) *CreateTrafficPolicyVersionOutput {
	s.TrafficPolicy = v
	return s
}

// A complex type that contains information about the request to authorize associating
// a VPC with your private hosted zone. Authorization is only required when
// a private hosted zone and a VPC were created by using different accounts.
type CreateVPCAssociationAuthorizationInput struct {
	_ struct{} `locationName:"CreateVPCAssociationAuthorizationRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the private hosted zone that you want to authorize associating
	// a VPC with.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A complex type that contains the VPC ID and region for the VPC that you want
	// to authorize associating with your hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVPCAssociationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVPCAssociationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVPCAssociationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVPCAssociationAuthorizationInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.VPC == nil {
		invalidParams.Add(request.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *CreateVPCAssociationAuthorizationInput) SetHostedZoneId(v string) *CreateVPCAssociationAuthorizationInput {
	s.HostedZoneId = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *CreateVPCAssociationAuthorizationInput) SetVPC(v *VPC) *CreateVPCAssociationAuthorizationInput {
	s.VPC = v
	return s
}

// A complex type that contains the response information from a CreateVPCAssociationAuthorization
// request.
type CreateVPCAssociationAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that you authorized associating a VPC with.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The VPC that you authorized associating with a hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVPCAssociationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVPCAssociationAuthorizationOutput) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *CreateVPCAssociationAuthorizationOutput) SetHostedZoneId(v string) *CreateVPCAssociationAuthorizationOutput {
	s.HostedZoneId = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *CreateVPCAssociationAuthorizationOutput) SetVPC(v *VPC) *CreateVPCAssociationAuthorizationOutput {
	s.VPC = v
	return s
}

// A string repesenting the status of DNSSEC signing.
type DNSSECStatus struct {
	_ struct{} `type:"structure"`

	// A string that represents the current hosted zone signing status.
	//
	// Status can have one of the following values:
	//
	// SIGNING
	//
	// DNSSEC signing is enabled for the hosted zone.
	//
	// NOT_SIGNING
	//
	// DNSSEC signing is not enabled for the hosted zone.
	//
	// DELETING
	//
	// DNSSEC signing is in the process of being removed for the hosted zone.
	//
	// ACTION_NEEDED
	//
	// There is a problem with signing in the hosted zone that requires you to take
	// action to resolve. For example, the customer managed customer master key
	// (CMK) might have been deleted, or the permissions for the customer managed
	// CMK might have been changed.
	//
	// INTERNAL_FAILURE
	//
	// There was an error during a request. Before you can continue to work with
	// DNSSEC signing, including with key-signing keys (KSKs), you must correct
	// the problem by enabling or disabling DNSSEC signing for the hosted zone.
	ServeSignature *string `min:"1" type:"string"`

	// The status message provided for the following DNSSEC signing status: INTERNAL_FAILURE.
	// The status message includes information about what the problem might be and
	// steps that you can take to correct the issue.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s DNSSECStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DNSSECStatus) GoString() string {
	return s.String()
}

// SetServeSignature sets the ServeSignature field's value.
func (s *DNSSECStatus) SetServeSignature(v string) *DNSSECStatus {
	s.ServeSignature = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DNSSECStatus) SetStatusMessage(v string) *DNSSECStatus {
	s.StatusMessage = &v
	return s
}

type DeactivateKeySigningKeyInput struct {
	_ struct{} `locationName:"DeactivateKeySigningKeyRequest" type:"structure"`

	// A unique string used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"HostedZoneId" type:"string" required:"true"`

	// A string used to identify a key-signing key (KSK).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivateKeySigningKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateKeySigningKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateKeySigningKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateKeySigningKeyInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DeactivateKeySigningKeyInput) SetHostedZoneId(v string) *DeactivateKeySigningKeyInput {
	s.HostedZoneId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeactivateKeySigningKeyInput) SetName(v string) *DeactivateKeySigningKeyInput {
	s.Name = &v
	return s
}

type DeactivateKeySigningKeyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeactivateKeySigningKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateKeySigningKeyOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *DeactivateKeySigningKeyOutput) SetChangeInfo(v *ChangeInfo) *DeactivateKeySigningKeyOutput {
	s.ChangeInfo = v
	return s
}

// A complex type that lists the name servers in a delegation set, as well as
// the CallerReference and the ID for the delegation set.
type DelegationSet struct {
	_ struct{} `type:"structure"`

	// The value that you specified for CallerReference when you created the reusable
	// delegation set.
	CallerReference *string `min:"1" type:"string"`

	// The ID that Amazon Route 53 assigns to a reusable delegation set.
	Id *string `type:"string"`

	// A complex type that contains a list of the authoritative name servers for
	// a hosted zone or for a reusable delegation set.
	//
	// NameServers is a required field
	NameServers []*string `locationNameList:"NameServer" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DelegationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegationSet) GoString() string {
	return s.String()
}

// SetCallerReference sets the CallerReference field's value.
func (s *DelegationSet) SetCallerReference(v string) *DelegationSet {
	s.CallerReference = &v
	return s
}

// SetId sets the Id field's value.
func (s *DelegationSet) SetId(v string) *DelegationSet {
	s.Id = &v
	return s
}

// SetNameServers sets the NameServers field's value.
func (s *DelegationSet) SetNameServers(v []*string) *DelegationSet {
	s.NameServers = v
	return s
}

// This action deletes a health check.
type DeleteHealthCheckInput struct {
	_ struct{} `locationName:"DeleteHealthCheckRequest" type:"structure"`

	// The ID of the health check that you want to delete.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHealthCheckInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}
	if s.HealthCheckId != nil && len(*s.HealthCheckId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheckId sets the HealthCheckId field's value.
func (s *DeleteHealthCheckInput) SetHealthCheckId(v string) *DeleteHealthCheckInput {
	s.HealthCheckId = &v
	return s
}

// An empty element.
type DeleteHealthCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckOutput) GoString() string {
	return s.String()
}

// A request to delete a hosted zone.
type DeleteHostedZoneInput struct {
	_ struct{} `locationName:"DeleteHostedZoneRequest" type:"structure"`

	// The ID of the hosted zone you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHostedZoneInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteHostedZoneInput) SetId(v string) *DeleteHostedZoneInput {
	s.Id = &v
	return s
}

// A complex type that contains the response to a DeleteHostedZone request.
type DeleteHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID, the status, and the date and time of
	// a request to delete a hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *DeleteHostedZoneOutput) SetChangeInfo(v *ChangeInfo) *DeleteHostedZoneOutput {
	s.ChangeInfo = v
	return s
}

type DeleteKeySigningKeyInput struct {
	_ struct{} `locationName:"DeleteKeySigningKeyRequest" type:"structure"`

	// A unique string used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"HostedZoneId" type:"string" required:"true"`

	// A string used to identify a key-signing key (KSK).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeySigningKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeySigningKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeySigningKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeySigningKeyInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DeleteKeySigningKeyInput) SetHostedZoneId(v string) *DeleteKeySigningKeyInput {
	s.HostedZoneId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteKeySigningKeyInput) SetName(v string) *DeleteKeySigningKeyInput {
	s.Name = &v
	return s
}

type DeleteKeySigningKeyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteKeySigningKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeySigningKeyOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *DeleteKeySigningKeyOutput) SetChangeInfo(v *ChangeInfo) *DeleteKeySigningKeyOutput {
	s.ChangeInfo = v
	return s
}

type DeleteQueryLoggingConfigInput struct {
	_ struct{} `locationName:"DeleteQueryLoggingConfigRequest" type:"structure"`

	// The ID of the configuration that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteQueryLoggingConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteQueryLoggingConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQueryLoggingConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQueryLoggingConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteQueryLoggingConfigInput) SetId(v string) *DeleteQueryLoggingConfigInput {
	s.Id = &v
	return s
}

type DeleteQueryLoggingConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteQueryLoggingConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteQueryLoggingConfigOutput) GoString() string {
	return s.String()
}

// A request to delete a reusable delegation set.
type DeleteReusableDelegationSetInput struct {
	_ struct{} `locationName:"DeleteReusableDelegationSetRequest" type:"structure"`

	// The ID of the reusable delegation set that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReusableDelegationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReusableDelegationSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteReusableDelegationSetInput) SetId(v string) *DeleteReusableDelegationSetInput {
	s.Id = &v
	return s
}

// An empty element.
type DeleteReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A request to delete a specified traffic policy version.
type DeleteTrafficPolicyInput struct {
	_ struct{} `locationName:"DeleteTrafficPolicyRequest" type:"structure"`

	// The ID of the traffic policy that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`

	// The version number of the traffic policy that you want to delete.
	//
	// Version is a required field
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrafficPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteTrafficPolicyInput) SetId(v string) *DeleteTrafficPolicyInput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteTrafficPolicyInput) SetVersion(v int64) *DeleteTrafficPolicyInput {
	s.Version = &v
	return s
}

// A request to delete a specified traffic policy instance.
type DeleteTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"DeleteTrafficPolicyInstanceRequest" type:"structure"`

	// The ID of the traffic policy instance that you want to delete.
	//
	// When you delete a traffic policy instance, Amazon Route 53 also deletes all
	// of the resource record sets that were created when you created the traffic
	// policy instance.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrafficPolicyInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteTrafficPolicyInstanceInput) SetId(v string) *DeleteTrafficPolicyInstanceInput {
	s.Id = &v
	return s
}

// An empty element.
type DeleteTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// An empty element.
type DeleteTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to remove authorization
// to associate a VPC that was created by one account with a hosted zone that
// was created with a different account.
type DeleteVPCAssociationAuthorizationInput struct {
	_ struct{} `locationName:"DeleteVPCAssociationAuthorizationRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// When removing authorization to associate a VPC that was created by one account
	// with a hosted zone that was created with a different account, the ID of the
	// hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// When removing authorization to associate a VPC that was created by one account
	// with a hosted zone that was created with a different account, a complex type
	// that includes the ID and region of the VPC.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVPCAssociationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVPCAssociationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVPCAssociationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVPCAssociationAuthorizationInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.VPC == nil {
		invalidParams.Add(request.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DeleteVPCAssociationAuthorizationInput) SetHostedZoneId(v string) *DeleteVPCAssociationAuthorizationInput {
	s.HostedZoneId = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *DeleteVPCAssociationAuthorizationInput) SetVPC(v *VPC) *DeleteVPCAssociationAuthorizationInput {
	s.VPC = v
	return s
}

// Empty response for the request.
type DeleteVPCAssociationAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVPCAssociationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVPCAssociationAuthorizationOutput) GoString() string {
	return s.String()
}

// For the metric that the CloudWatch alarm is associated with, a complex type
// that contains information about one dimension.
type Dimension struct {
	_ struct{} `type:"structure"`

	// For the metric that the CloudWatch alarm is associated with, the name of
	// one dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the value of
	// one dimension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimension) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

type DisableHostedZoneDNSSECInput struct {
	_ struct{} `locationName:"DisableHostedZoneDNSSECRequest" type:"structure"`

	// A unique string used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableHostedZoneDNSSECInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableHostedZoneDNSSECInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableHostedZoneDNSSECInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableHostedZoneDNSSECInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DisableHostedZoneDNSSECInput) SetHostedZoneId(v string) *DisableHostedZoneDNSSECInput {
	s.HostedZoneId = &v
	return s
}

type DisableHostedZoneDNSSECOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisableHostedZoneDNSSECOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableHostedZoneDNSSECOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *DisableHostedZoneDNSSECOutput) SetChangeInfo(v *ChangeInfo) *DisableHostedZoneDNSSECOutput {
	s.ChangeInfo = v
	return s
}

// A complex type that contains information about the VPC that you want to disassociate
// from a specified private hosted zone.
type DisassociateVPCFromHostedZoneInput struct {
	_ struct{} `locationName:"DisassociateVPCFromHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Optional: A comment about the disassociation request.
	Comment *string `type:"string"`

	// The ID of the private hosted zone that you want to disassociate a VPC from.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A complex type that contains information about the VPC that you're disassociating
	// from the specified hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateVPCFromHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateVPCFromHostedZoneInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.VPC == nil {
		invalidParams.Add(request.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *DisassociateVPCFromHostedZoneInput) SetComment(v string) *DisassociateVPCFromHostedZoneInput {
	s.Comment = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DisassociateVPCFromHostedZoneInput) SetHostedZoneId(v string) *DisassociateVPCFromHostedZoneInput {
	s.HostedZoneId = &v
	return s
}

// SetVPC sets the VPC field's value.
func (s *DisassociateVPCFromHostedZoneInput) SetVPC(v *VPC) *DisassociateVPCFromHostedZoneInput {
	s.VPC = v
	return s
}

// A complex type that contains the response information for the disassociate
// request.
type DisassociateVPCFromHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes the changes made to the specified private hosted
	// zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *DisassociateVPCFromHostedZoneOutput) SetChangeInfo(v *ChangeInfo) *DisassociateVPCFromHostedZoneOutput {
	s.ChangeInfo = v
	return s
}

type EnableHostedZoneDNSSECInput struct {
	_ struct{} `locationName:"EnableHostedZoneDNSSECRequest" type:"structure"`

	// A unique string used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableHostedZoneDNSSECInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableHostedZoneDNSSECInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableHostedZoneDNSSECInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableHostedZoneDNSSECInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *EnableHostedZoneDNSSECInput) SetHostedZoneId(v string) *EnableHostedZoneDNSSECInput {
	s.HostedZoneId = &v
	return s
}

type EnableHostedZoneDNSSECOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s EnableHostedZoneDNSSECOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableHostedZoneDNSSECOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *EnableHostedZoneDNSSECOutput) SetChangeInfo(v *ChangeInfo) *EnableHostedZoneDNSSECOutput {
	s.ChangeInfo = v
	return s
}

// A complex type that contains information about a geographic location.
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// The two-letter code for the continent.
	//
	// Amazon Route 53 supports the following continent codes:
	//
	//    * AF: Africa
	//
	//    * AN: Antarctica
	//
	//    * AS: Asia
	//
	//    * EU: Europe
	//
	//    * OC: Oceania
	//
	//    * NA: North America
	//
	//    * SA: South America
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `min:"2" type:"string"`

	// For geolocation resource record sets, the two-letter code for a country.
	//
	// Amazon Route 53 uses the two-letter country codes that are specified in ISO
	// standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	CountryCode *string `min:"1" type:"string"`

	// For geolocation resource record sets, the two-letter code for a state of
	// the United States. Route 53 doesn't support any other values for SubdivisionCode.
	// For a list of state abbreviations, see Appendix B: Two–Letter State and
	// Possession Abbreviations (https://pe.usps.com/text/pub28/28apb.htm) on the
	// United States Postal Service website.
	//
	// If you specify subdivisioncode, you must also specify US for CountryCode.
	SubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoLocation"}
	if s.ContinentCode != nil && len(*s.ContinentCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ContinentCode", 2))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 1))
	}
	if s.SubdivisionCode != nil && len(*s.SubdivisionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContinentCode sets the ContinentCode field's value.
func (s *GeoLocation) SetContinentCode(v string) *GeoLocation {
	s.ContinentCode = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *GeoLocation) SetCountryCode(v string) *GeoLocation {
	s.CountryCode = &v
	return s
}

// SetSubdivisionCode sets the SubdivisionCode field's value.
func (s *GeoLocation) SetSubdivisionCode(v string) *GeoLocation {
	s.SubdivisionCode = &v
	return s
}

// A complex type that contains the codes and full continent, country, and subdivision
// names for the specified geolocation code.
type GeoLocationDetails struct {
	_ struct{} `type:"structure"`

	// The two-letter code for the continent.
	ContinentCode *string `min:"2" type:"string"`

	// The full name of the continent.
	ContinentName *string `min:"1" type:"string"`

	// The two-letter code for the country.
	CountryCode *string `min:"1" type:"string"`

	// The name of the country.
	CountryName *string `min:"1" type:"string"`

	// The code for the subdivision, such as a particular state within the United
	// States. For a list of US state abbreviations, see Appendix B: Two–Letter
	// State and Possession Abbreviations (https://pe.usps.com/text/pub28/28apb.htm)
	// on the United States Postal Service website. For a list of all supported
	// subdivision codes, use the ListGeoLocations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html)
	// API.
	SubdivisionCode *string `min:"1" type:"string"`

	// The full name of the subdivision. Route 53 currently supports only states
	// in the United States.
	SubdivisionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocationDetails) GoString() string {
	return s.String()
}

// SetContinentCode sets the ContinentCode field's value.
func (s *GeoLocationDetails) SetContinentCode(v string) *GeoLocationDetails {
	s.ContinentCode = &v
	return s
}

// SetContinentName sets the ContinentName field's value.
func (s *GeoLocationDetails) SetContinentName(v string) *GeoLocationDetails {
	s.ContinentName = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *GeoLocationDetails) SetCountryCode(v string) *GeoLocationDetails {
	s.CountryCode = &v
	return s
}

// SetCountryName sets the CountryName field's value.
func (s *GeoLocationDetails) SetCountryName(v string) *GeoLocationDetails {
	s.CountryName = &v
	return s
}

// SetSubdivisionCode sets the SubdivisionCode field's value.
func (s *GeoLocationDetails) SetSubdivisionCode(v string) *GeoLocationDetails {
	s.SubdivisionCode = &v
	return s
}

// SetSubdivisionName sets the SubdivisionName field's value.
func (s *GeoLocationDetails) SetSubdivisionName(v string) *GeoLocationDetails {
	s.SubdivisionName = &v
	return s
}

// A complex type that contains information about the request to create a hosted
// zone.
type GetAccountLimitInput struct {
	_ struct{} `locationName:"GetAccountLimitRequest" type:"structure"`

	// The limit that you want to get. Valid values include the following:
	//
	//    * MAX_HEALTH_CHECKS_BY_OWNER: The maximum number of health checks that
	//    you can create using the current account.
	//
	//    * MAX_HOSTED_ZONES_BY_OWNER: The maximum number of hosted zones that you
	//    can create using the current account.
	//
	//    * MAX_REUSABLE_DELEGATION_SETS_BY_OWNER: The maximum number of reusable
	//    delegation sets that you can create using the current account.
	//
	//    * MAX_TRAFFIC_POLICIES_BY_OWNER: The maximum number of traffic policies
	//    that you can create using the current account.
	//
	//    * MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER: The maximum number of traffic
	//    policy instances that you can create using the current account. (Traffic
	//    policy instances are referred to as traffic flow policy records in the
	//    Amazon Route 53 console.)
	//
	// Type is a required field
	Type *string `location:"uri" locationName:"Type" type:"string" required:"true" enum:"AccountLimitType"`
}

// String returns the string representation
func (s GetAccountLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccountLimitInput"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *GetAccountLimitInput) SetType(v string) *GetAccountLimitInput {
	s.Type = &v
	return s
}

// A complex type that contains the requested limit.
type GetAccountLimitOutput struct {
	_ struct{} `type:"structure"`

	// The current number of entities that you have created of the specified type.
	// For example, if you specified MAX_HEALTH_CHECKS_BY_OWNER for the value of
	// Type in the request, the value of Count is the current number of health checks
	// that you have created using the current account.
	//
	// Count is a required field
	Count *int64 `type:"long" required:"true"`

	// The current setting for the specified limit. For example, if you specified
	// MAX_HEALTH_CHECKS_BY_OWNER for the value of Type in the request, the value
	// of Limit is the maximum number of health checks that you can create using
	// the current account.
	//
	// Limit is a required field
	Limit *AccountLimit `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAccountLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountLimitOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GetAccountLimitOutput) SetCount(v int64) *GetAccountLimitOutput {
	s.Count = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAccountLimitOutput) SetLimit(v *AccountLimit) *GetAccountLimitOutput {
	s.Limit = v
	return s
}

// The input for a GetChange request.
type GetChangeInput struct {
	_ struct{} `locationName:"GetChangeRequest" type:"structure"`

	// The ID of the change batch request. The value that you specify here is the
	// value that ChangeResourceRecordSets returned in the Id element when you submitted
	// the request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChangeInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetChangeInput) SetId(v string) *GetChangeInput {
	s.Id = &v
	return s
}

// A complex type that contains the ChangeInfo element.
type GetChangeOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the specified change batch.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeOutput) GoString() string {
	return s.String()
}

// SetChangeInfo sets the ChangeInfo field's value.
func (s *GetChangeOutput) SetChangeInfo(v *ChangeInfo) *GetChangeOutput {
	s.ChangeInfo = v
	return s
}

// Empty request.
type GetCheckerIpRangesInput struct {
	_ struct{} `locationName:"GetCheckerIpRangesRequest" type:"structure"`
}

// String returns the string representation
func (s GetCheckerIpRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesInput) GoString() string {
	return s.String()
}

// A complex type that contains the CheckerIpRanges element.
type GetCheckerIpRangesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains sorted list of IP ranges in CIDR format for
	// Amazon Route 53 health checkers.
	//
	// CheckerIpRanges is a required field
	CheckerIpRanges []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetCheckerIpRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesOutput) GoString() string {
	return s.String()
}

// SetCheckerIpRanges sets the CheckerIpRanges field's value.
func (s *GetCheckerIpRangesOutput) SetCheckerIpRanges(v []*string) *GetCheckerIpRangesOutput {
	s.CheckerIpRanges = v
	return s
}

type GetDNSSECInput struct {
	_ struct{} `locationName:"GetDNSSECRequest" type:"structure"`

	// A unique string used to identify a hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDNSSECInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDNSSECInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDNSSECInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDNSSECInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *GetDNSSECInput) SetHostedZoneId(v string) *GetDNSSECInput {
	s.HostedZoneId = &v
	return s
}

type GetDNSSECOutput struct {
	_ struct{} `type:"structure"`

	// The key-signing keys (KSKs) in your account.
	//
	// KeySigningKeys is a required field
	KeySigningKeys []*KeySigningKey `type:"list" required:"true"`

	// A string repesenting the status of DNSSEC.
	//
	// Status is a required field
	Status *DNSSECStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDNSSECOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDNSSECOutput) GoString() string {
	return s.String()
}

// SetKeySigningKeys sets the KeySigningKeys field's value.
func (s *GetDNSSECOutput) SetKeySigningKeys(v []*KeySigningKey) *GetDNSSECOutput {
	s.KeySigningKeys = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDNSSECOutput) SetStatus(v *DNSSECStatus) *GetDNSSECOutput {
	s.Status = v
	return s
}

// A request for information about whether a specified geographic location is
// supported for Amazon Route 53 geolocation resource record sets.
type GetGeoLocationInput struct {
	_ struct{} `locationName:"GetGeoLocationRequest" type:"structure"`

	// For geolocation resource record sets, a two-letter abbreviation that identifies
	// a continent. Amazon Route 53 supports the following continent codes:
	//
	//    * AF: Africa
	//
	//    * AN: Antarctica
	//
	//    * AS: Asia
	//
	//    * EU: Europe
	//
	//    * OC: Oceania
	//
	//    * NA: North America
	//
	//    * SA: South America
	ContinentCode *string `location:"querystring" locationName:"continentcode" min:"2" type:"string"`

	// Amazon Route 53 uses the two-letter country codes that are specified in ISO
	// standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	CountryCode *string `location:"querystring" locationName:"countrycode" min:"1" type:"string"`

	// The code for the subdivision, such as a particular state within the United
	// States. For a list of US state abbreviations, see Appendix B: Two–Letter
	// State and Possession Abbreviations (https://pe.usps.com/text/pub28/28apb.htm)
	// on the United States Postal Service website. For a list of all supported
	// subdivision codes, use the ListGeoLocations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html)
	// API.
	SubdivisionCode *string `location:"querystring" locationName:"subdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s GetGeoLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeoLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeoLocationInput"}
	if s.ContinentCode != nil && len(*s.ContinentCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ContinentCode", 2))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 1))
	}
	if s.SubdivisionCode != nil && len(*s.SubdivisionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContinentCode sets the ContinentCode field's value.
func (s *GetGeoLocationInput) SetContinentCode(v string) *GetGeoLocationInput {
	s.ContinentCode = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *GetGeoLocationInput) SetCountryCode(v string) *GetGeoLocationInput {
	s.CountryCode = &v
	return s
}

// SetSubdivisionCode sets the SubdivisionCode field's value.
func (s *GetGeoLocationInput) SetSubdivisionCode(v string) *GetGeoLocationInput {
	s.SubdivisionCode = &v
	return s
}

// A complex type that contains the response information for the specified geolocation
// code.
type GetGeoLocationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the codes and full continent, country, and subdivision
	// names for the specified geolocation code.
	//
	// GeoLocationDetails is a required field
	GeoLocationDetails *GeoLocationDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGeoLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationOutput) GoString() string {
	return s.String()
}

// SetGeoLocationDetails sets the GeoLocationDetails field's value.
func (s *GetGeoLocationOutput) SetGeoLocationDetails(v *GeoLocationDetails) *GetGeoLocationOutput {
	s.GeoLocationDetails = v
	return s
}

// A request for the number of health checks that are associated with the current
// account.
type GetHealthCheckCountInput struct {
	_ struct{} `locationName:"GetHealthCheckCountRequest" type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the response to a GetHealthCheckCount request.
type GetHealthCheckCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of health checks associated with the current account.
	//
	// HealthCheckCount is a required field
	HealthCheckCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountOutput) GoString() string {
	return s.String()
}

// SetHealthCheckCount sets the HealthCheckCount field's value.
func (s *GetHealthCheckCountOutput) SetHealthCheckCount(v int64) *GetHealthCheckCountOutput {
	s.HealthCheckCount = &v
	return s
}

// A request to get information about a specified health check.
type GetHealthCheckInput struct {
	_ struct{} `locationName:"GetHealthCheckRequest" type:"structure"`

	// The identifier that Amazon Route 53 assigned to the health check when you
	// created it. When you add or update a resource record set, you use this value
	// to specify which health check to use. The value can be up to 64 characters
	// long.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthCheckInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}
	if s.HealthCheckId != nil && len(*s.HealthCheckId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheckId sets the HealthCheckId field's value.
func (s *GetHealthCheckInput) SetHealthCheckId(v string) *GetHealthCheckInput {
	s.HealthCheckId = &v
	return s
}

// A request for the reason that a health check failed most recently.
type GetHealthCheckLastFailureReasonInput struct {
	_ struct{} `locationName:"GetHealthCheckLastFailureReasonRequest" type:"structure"`

	// The ID for the health check for which you want the last failure reason. When
	// you created the health check, CreateHealthCheck returned the ID in the response,
	// in the HealthCheckId element.
	//
	// If you want to get the last failure reason for a calculated health check,
	// you must use the Amazon Route 53 console or the CloudWatch console. You can't
	// use GetHealthCheckLastFailureReason for a calculated health check.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthCheckLastFailureReasonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthCheckLastFailureReasonInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}
	if s.HealthCheckId != nil && len(*s.HealthCheckId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheckId sets the HealthCheckId field's value.
func (s *GetHealthCheckLastFailureReasonInput) SetHealthCheckId(v string) *GetHealthCheckLastFailureReasonInput {
	s.HealthCheckId = &v
	return s
}

// A complex type that contains the response to a GetHealthCheckLastFailureReason
// request.
type GetHealthCheckLastFailureReasonOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one Observation element for each Amazon Route 53 health
	// checker that is reporting a last failure reason.
	//
	// HealthCheckObservations is a required field
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) GoString() string {
	return s.String()
}

// SetHealthCheckObservations sets the HealthCheckObservations field's value.
func (s *GetHealthCheckLastFailureReasonOutput) SetHealthCheckObservations(v []*HealthCheckObservation) *GetHealthCheckLastFailureReasonOutput {
	s.HealthCheckObservations = v
	return s
}

// A complex type that contains the response to a GetHealthCheck request.
type GetHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about one health check that is associated
	// with the current account.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckOutput) GoString() string {
	return s.String()
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *GetHealthCheckOutput) SetHealthCheck(v *HealthCheck) *GetHealthCheckOutput {
	s.HealthCheck = v
	return s
}

// A request to get the status for a health check.
type GetHealthCheckStatusInput struct {
	_ struct{} `locationName:"GetHealthCheckStatusRequest" type:"structure"`

	// The ID for the health check that you want the current status for. When you
	// created the health check, CreateHealthCheck returned the ID in the response,
	// in the HealthCheckId element.
	//
	// If you want to check the status of a calculated health check, you must use
	// the Amazon Route 53 console or the CloudWatch console. You can't use GetHealthCheckStatus
	// to get the status of a calculated health check.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthCheckStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthCheckStatusInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}
	if s.HealthCheckId != nil && len(*s.HealthCheckId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheckId sets the HealthCheckId field's value.
func (s *GetHealthCheckStatusInput) SetHealthCheckId(v string) *GetHealthCheckStatusInput {
	s.HealthCheckId = &v
	return s
}

// A complex type that contains the response to a GetHealthCheck request.
type GetHealthCheckStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one HealthCheckObservation element for each Amazon Route
	// 53 health checker that is reporting a status about the health check endpoint.
	//
	// HealthCheckObservations is a required field
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusOutput) GoString() string {
	return s.String()
}

// SetHealthCheckObservations sets the HealthCheckObservations field's value.
func (s *GetHealthCheckStatusOutput) SetHealthCheckObservations(v []*HealthCheckObservation) *GetHealthCheckStatusOutput {
	s.HealthCheckObservations = v
	return s
}

// A request to retrieve a count of all the hosted zones that are associated
// with the current account.
type GetHostedZoneCountInput struct {
	_ struct{} `locationName:"GetHostedZoneCountRequest" type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the response to a GetHostedZoneCount request.
type GetHostedZoneCountOutput struct {
	_ struct{} `type:"structure"`

	// The total number of public and private hosted zones that are associated with
	// the current account.
	//
	// HostedZoneCount is a required field
	HostedZoneCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountOutput) GoString() string {
	return s.String()
}

// SetHostedZoneCount sets the HostedZoneCount field's value.
func (s *GetHostedZoneCountOutput) SetHostedZoneCount(v int64) *GetHostedZoneCountOutput {
	s.HostedZoneCount = &v
	return s
}

// A request to get information about a specified hosted zone.
type GetHostedZoneInput struct {
	_ struct{} `locationName:"GetHostedZoneRequest" type:"structure"`

	// The ID of the hosted zone that you want to get information about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHostedZoneInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetHostedZoneInput) SetId(v string) *GetHostedZoneInput {
	s.Id = &v
	return s
}

// A complex type that contains information about the request to create a hosted
// zone.
type GetHostedZoneLimitInput struct {
	_ struct{} `locationName:"GetHostedZoneLimitRequest" type:"structure"`

	// The ID of the hosted zone that you want to get a limit for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The limit that you want to get. Valid values include the following:
	//
	//    * MAX_RRSETS_BY_ZONE: The maximum number of records that you can create
	//    in the specified hosted zone.
	//
	//    * MAX_VPCS_ASSOCIATED_BY_ZONE: The maximum number of Amazon VPCs that
	//    you can associate with the specified private hosted zone.
	//
	// Type is a required field
	Type *string `location:"uri" locationName:"Type" type:"string" required:"true" enum:"HostedZoneLimitType"`
}

// String returns the string representation
func (s GetHostedZoneLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostedZoneLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHostedZoneLimitInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *GetHostedZoneLimitInput) SetHostedZoneId(v string) *GetHostedZoneLimitInput {
	s.HostedZoneId = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetHostedZoneLimitInput) SetType(v string) *GetHostedZoneLimitInput {
	s.Type = &v
	return s
}

// A complex type that contains the requested limit.
type GetHostedZoneLimitOutput struct {
	_ struct{} `type:"structure"`

	// The current number of entities that you have created of the specified type.
	// For example, if you specified MAX_RRSETS_BY_ZONE for the value of Type in
	// the request, the value of Count is the current number of records that you
	// have created in the specified hosted zone.
	//
	// Count is a required field
	Count *int64 `type:"long" required:"true"`

	// The current setting for the specified limit. For example, if you specified
	// MAX_RRSETS_BY_ZONE for the value of Type in the request, the value of Limit
	// is the maximum number of records that you can create in the specified hosted
	// zone.
	//
	// Limit is a required field
	Limit *HostedZoneLimit `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneLimitOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GetHostedZoneLimitOutput) SetCount(v int64) *GetHostedZoneLimitOutput {
	s.Count = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetHostedZoneLimitOutput) SetLimit(v *HostedZoneLimit) *GetHostedZoneLimitOutput {
	s.Limit = v
	return s
}

// A complex type that contain the response to a GetHostedZone request.
type GetHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that lists the Amazon Route 53 name servers for the specified
	// hosted zone.
	DelegationSet *DelegationSet `type:"structure"`

	// A complex type that contains general information about the specified hosted
	// zone.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`

	// A complex type that contains information about the VPCs that are associated
	// with the specified hosted zone.
	VPCs []*VPC `locationNameList:"VPC" min:"1" type:"list"`
}

// String returns the string representation
func (s GetHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneOutput) GoString() string {
	return s.String()
}

// SetDelegationSet sets the DelegationSet field's value.
func (s *GetHostedZoneOutput) SetDelegationSet(v *DelegationSet) *GetHostedZoneOutput {
	s.DelegationSet = v
	return s
}

// SetHostedZone sets the HostedZone field's value.
func (s *GetHostedZoneOutput) SetHostedZone(v *HostedZone) *GetHostedZoneOutput {
	s.HostedZone = v
	return s
}

// SetVPCs sets the VPCs field's value.
func (s *GetHostedZoneOutput) SetVPCs(v []*VPC) *GetHostedZoneOutput {
	s.VPCs = v
	return s
}

type GetQueryLoggingConfigInput struct {
	_ struct{} `locationName:"GetQueryLoggingConfigRequest" type:"structure"`

	// The ID of the configuration for DNS query logging that you want to get information
	// about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryLoggingConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryLoggingConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryLoggingConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryLoggingConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetQueryLoggingConfigInput) SetId(v string) *GetQueryLoggingConfigInput {
	s.Id = &v
	return s
}

type GetQueryLoggingConfigOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the query logging configuration
	// that you specified in a GetQueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html)
	// request.
	//
	// QueryLoggingConfig is a required field
	QueryLoggingConfig *QueryLoggingConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetQueryLoggingConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryLoggingConfigOutput) GoString() string {
	return s.String()
}

// SetQueryLoggingConfig sets the QueryLoggingConfig field's value.
func (s *GetQueryLoggingConfigOutput) SetQueryLoggingConfig(v *QueryLoggingConfig) *GetQueryLoggingConfigOutput {
	s.QueryLoggingConfig = v
	return s
}

// A request to get information about a specified reusable delegation set.
type GetReusableDelegationSetInput struct {
	_ struct{} `locationName:"GetReusableDelegationSetRequest" type:"structure"`

	// The ID of the reusable delegation set that you want to get a list of name
	// servers for.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReusableDelegationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReusableDelegationSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetReusableDelegationSetInput) SetId(v string) *GetReusableDelegationSetInput {
	s.Id = &v
	return s
}

// A complex type that contains information about the request to create a hosted
// zone.
type GetReusableDelegationSetLimitInput struct {
	_ struct{} `locationName:"GetReusableDelegationSetLimitRequest" type:"structure"`

	// The ID of the delegation set that you want to get the limit for.
	//
	// DelegationSetId is a required field
	DelegationSetId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// Specify MAX_ZONES_BY_REUSABLE_DELEGATION_SET to get the maximum number of
	// hosted zones that you can associate with the specified reusable delegation
	// set.
	//
	// Type is a required field
	Type *string `location:"uri" locationName:"Type" type:"string" required:"true" enum:"ReusableDelegationSetLimitType"`
}

// String returns the string representation
func (s GetReusableDelegationSetLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReusableDelegationSetLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReusableDelegationSetLimitInput"}
	if s.DelegationSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DelegationSetId"))
	}
	if s.DelegationSetId != nil && len(*s.DelegationSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DelegationSetId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelegationSetId sets the DelegationSetId field's value.
func (s *GetReusableDelegationSetLimitInput) SetDelegationSetId(v string) *GetReusableDelegationSetLimitInput {
	s.DelegationSetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetReusableDelegationSetLimitInput) SetType(v string) *GetReusableDelegationSetLimitInput {
	s.Type = &v
	return s
}

// A complex type that contains the requested limit.
type GetReusableDelegationSetLimitOutput struct {
	_ struct{} `type:"structure"`

	// The current number of hosted zones that you can associate with the specified
	// reusable delegation set.
	//
	// Count is a required field
	Count *int64 `type:"long" required:"true"`

	// The current setting for the limit on hosted zones that you can associate
	// with the specified reusable delegation set.
	//
	// Limit is a required field
	Limit *ReusableDelegationSetLimit `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetLimitOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GetReusableDelegationSetLimitOutput) SetCount(v int64) *GetReusableDelegationSetLimitOutput {
	s.Count = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetReusableDelegationSetLimitOutput) SetLimit(v *ReusableDelegationSetLimit) *GetReusableDelegationSetLimitOutput {
	s.Limit = v
	return s
}

// A complex type that contains the response to the GetReusableDelegationSet
// request.
type GetReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the reusable delegation set.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// SetDelegationSet sets the DelegationSet field's value.
func (s *GetReusableDelegationSetOutput) SetDelegationSet(v *DelegationSet) *GetReusableDelegationSetOutput {
	s.DelegationSet = v
	return s
}

// Gets information about a specific traffic policy version.
type GetTrafficPolicyInput struct {
	_ struct{} `locationName:"GetTrafficPolicyRequest" type:"structure"`

	// The ID of the traffic policy that you want to get information about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`

	// The version number of the traffic policy that you want to get information
	// about.
	//
	// Version is a required field
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrafficPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetTrafficPolicyInput) SetId(v string) *GetTrafficPolicyInput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetTrafficPolicyInput) SetVersion(v int64) *GetTrafficPolicyInput {
	s.Version = &v
	return s
}

// Request to get the number of traffic policy instances that are associated
// with the current account.
type GetTrafficPolicyInstanceCountInput struct {
	_ struct{} `locationName:"GetTrafficPolicyInstanceCountRequest" type:"structure"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceCountInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type GetTrafficPolicyInstanceCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of traffic policy instances that are associated with the current
	// account.
	//
	// TrafficPolicyInstanceCount is a required field
	TrafficPolicyInstanceCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceCountOutput) GoString() string {
	return s.String()
}

// SetTrafficPolicyInstanceCount sets the TrafficPolicyInstanceCount field's value.
func (s *GetTrafficPolicyInstanceCountOutput) SetTrafficPolicyInstanceCount(v int64) *GetTrafficPolicyInstanceCountOutput {
	s.TrafficPolicyInstanceCount = &v
	return s
}

// Gets information about a specified traffic policy instance.
type GetTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"GetTrafficPolicyInstanceRequest" type:"structure"`

	// The ID of the traffic policy instance that you want to get information about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrafficPolicyInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetTrafficPolicyInstanceInput) SetId(v string) *GetTrafficPolicyInstanceInput {
	s.Id = &v
	return s
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type GetTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the traffic policy instance.
	//
	// TrafficPolicyInstance is a required field
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// SetTrafficPolicyInstance sets the TrafficPolicyInstance field's value.
func (s *GetTrafficPolicyInstanceOutput) SetTrafficPolicyInstance(v *TrafficPolicyInstance) *GetTrafficPolicyInstanceOutput {
	s.TrafficPolicyInstance = v
	return s
}

// A complex type that contains the response information for the request.
type GetTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyOutput) GoString() string {
	return s.String()
}

// SetTrafficPolicy sets the TrafficPolicy field's value.
func (s *GetTrafficPolicyOutput) SetTrafficPolicy(v *TrafficPolicy) *GetTrafficPolicyOutput {
	s.TrafficPolicy = v
	return s
}

// A complex type that contains information about one health check that is associated
// with the current Amazon Web Services account.
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// A unique string that you specified when you created the health check.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains information about the CloudWatch alarm that
	// Amazon Route 53 is monitoring for this health check.
	CloudWatchAlarmConfiguration *CloudWatchAlarmConfiguration `type:"structure"`

	// A complex type that contains detailed information about one health check.
	//
	// HealthCheckConfig is a required field
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`

	// The version of the health check. You can optionally pass this value in a
	// call to UpdateHealthCheck to prevent overwriting another change to the health
	// check.
	//
	// HealthCheckVersion is a required field
	HealthCheckVersion *int64 `min:"1" type:"long" required:"true"`

	// The identifier that Amazon Route 53 assigned to the health check when you
	// created it. When you add or update a resource record set, you use this value
	// to specify which health check to use. The value can be up to 64 characters
	// long.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If the health check was created by another service, the service that created
	// the health check. When a health check is created by another service, you
	// can't edit or delete it using Amazon Route 53.
	LinkedService *LinkedService `type:"structure"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheck) GoString() string {
	return s.String()
}

// SetCallerReference sets the CallerReference field's value.
func (s *HealthCheck) SetCallerReference(v string) *HealthCheck {
	s.CallerReference = &v
	return s
}

// SetCloudWatchAlarmConfiguration sets the CloudWatchAlarmConfiguration field's value.
func (s *HealthCheck) SetCloudWatchAlarmConfiguration(v *CloudWatchAlarmConfiguration) *HealthCheck {
	s.CloudWatchAlarmConfiguration = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *HealthCheck) SetHealthCheckConfig(v *HealthCheckConfig) *HealthCheck {
	s.HealthCheckConfig = v
	return s
}

// SetHealthCheckVersion sets the HealthCheckVersion field's value.
func (s *HealthCheck) SetHealthCheckVersion(v int64) *HealthCheck {
	s.HealthCheckVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *HealthCheck) SetId(v string) *HealthCheck {
	s.Id = &v
	return s
}

// SetLinkedService sets the LinkedService field's value.
func (s *HealthCheck) SetLinkedService(v *LinkedService) *HealthCheck {
	s.LinkedService = v
	return s
}

// A complex type that contains information about the health check.
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that identifies the CloudWatch alarm that you want Amazon
	// Route 53 health checkers to use to determine whether the specified health
	// check is healthy.
	AlarmIdentifier *AlarmIdentifier `type:"structure"`

	// (CALCULATED Health Checks Only) A complex type that contains one ChildHealthCheck
	// element for each health check that you want to associate with a CALCULATED
	// health check.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// Stops Route 53 from performing health checks. When you disable a health check,
	// here's what happens:
	//
	//    * Health checks that check the health of endpoints: Route 53 stops submitting
	//    requests to your application, server, or other resource.
	//
	//    * Calculated health checks: Route 53 stops aggregating the status of the
	//    referenced health checks.
	//
	//    * Health checks that monitor CloudWatch alarms: Route 53 stops monitoring
	//    the corresponding CloudWatch metrics.
	//
	// After you disable a health check, Route 53 considers the status of the health
	// check to always be healthy. If you configured DNS failover, Route 53 continues
	// to route traffic to the corresponding resources. If you want to stop routing
	// traffic to a resource, change the value of Inverted (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted).
	//
	// Charges for a health check still apply when the health check is disabled.
	// For more information, see Amazon Route 53 Pricing (http://aws.amazon.com/route53/pricing/).
	Disabled *bool `type:"boolean"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. This
	// allows the endpoint to respond to HTTPS health check requests with the applicable
	// SSL/TLS certificate.
	//
	// Some endpoints require that HTTPS requests include the host name in the client_hello
	// message. If you don't enable SNI, the status of the health check will be
	// SSL alert handshake_failure. A health check can also have that status for
	// other reasons. If SNI is enabled and you're still getting the error, check
	// the SSL/TLS configuration on your endpoint and confirm that your certificate
	// is valid.
	//
	// The SSL/TLS certificate on your endpoint includes a domain name in the Common
	// Name field and possibly several more in the Subject Alternative Names field.
	// One of the domain names in the certificate should match the value that you
	// specify for FullyQualifiedDomainName. If the endpoint responds to the client_hello
	// message with a certificate that does not include the domain name that you
	// specified in FullyQualifiedDomainName, a health checker will retry the handshake.
	// In the second attempt, the health checker will omit FullyQualifiedDomainName
	// from the client_hello message.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Amazon Route 53 Determines
	// Whether an Endpoint Is Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// If you don't specify a value for FailureThreshold, the default value is three
	// health checks.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
	//
	// If you specify a value for IPAddress:
	//
	// Amazon Route 53 sends health check requests to the specified IPv4 or IPv6
	// address and passes the value of FullyQualifiedDomainName in the Host header
	// for all health checks except TCP health checks. This is typically the fully
	// qualified DNS name of the endpoint on which you want Route 53 to perform
	// health checks.
	//
	// When Route 53 checks the health of an endpoint, here is how it constructs
	// the Host header:
	//
	//    * If you specify a value of 80 for Port and HTTP or HTTP_STR_MATCH for
	//    Type, Route 53 passes the value of FullyQualifiedDomainName to the endpoint
	//    in the Host header.
	//
	//    * If you specify a value of 443 for Port and HTTPS or HTTPS_STR_MATCH
	//    for Type, Route 53 passes the value of FullyQualifiedDomainName to the
	//    endpoint in the Host header.
	//
	//    * If you specify another value for Port and any value except TCP for Type,
	//    Route 53 passes FullyQualifiedDomainName:Port to the endpoint in the Host
	//    header.
	//
	// If you don't specify a value for FullyQualifiedDomainName, Route 53 substitutes
	// the value of IPAddress in the Host header in each of the preceding cases.
	//
	// If you don't specify a value for IPAddress :
	//
	// Route 53 sends a DNS request to the domain that you specify for FullyQualifiedDomainName
	// at the interval that you specify for RequestInterval. Using an IPv4 address
	// that DNS returns, Route 53 then checks the health of the endpoint.
	//
	// If you don't specify a value for IPAddress, Route 53 uses only IPv4 to send
	// health checks to the endpoint. If there's no resource record set with a type
	// of A for the name that you specify for FullyQualifiedDomainName, the health
	// check fails with a "DNS resolution failed" error.
	//
	// If you want to check the health of weighted, latency, or failover resource
	// record sets and you choose to specify the endpoint only by FullyQualifiedDomainName,
	// we recommend that you create a separate health check for each endpoint. For
	// example, create a health check for each HTTP server that is serving content
	// for www.example.com. For the value of FullyQualifiedDomainName, specify the
	// domain name of the server (such as us-east-2-www.example.com), not the name
	// of the resource record sets (www.example.com).
	//
	// In this configuration, if you create a health check for which the value of
	// FullyQualifiedDomainName matches the name of the resource record sets and
	// you then associate the health check with those resource record sets, health
	// check results will be unpredictable.
	//
	// In addition, if the value that you specify for Type is HTTP, HTTPS, HTTP_STR_MATCH,
	// or HTTPS_STR_MATCH, Route 53 passes the value of FullyQualifiedDomainName
	// in the Host header, as it does when you specify a value for IPAddress. If
	// the value of Type is TCP, Route 53 doesn't pass a Host header.
	FullyQualifiedDomainName *string `type:"string"`

	// The number of child health checks that are associated with a CALCULATED health
	// check that Amazon Route 53 must consider healthy for the CALCULATED health
	// check to be considered healthy. To specify the child health checks that you
	// want to associate with a CALCULATED health check, use the ChildHealthChecks
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks)
	// element.
	//
	// Note the following:
	//
	//    * If you specify a number greater than the number of child health checks,
	//    Route 53 always considers this health check to be unhealthy.
	//
	//    * If you specify 0, Route 53 always considers this health check to be
	//    healthy.
	HealthThreshold *int64 `type:"integer"`

	// The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53
	// to perform health checks on. If you don't specify a value for IPAddress,
	// Route 53 sends a DNS request to resolve the domain name that you specify
	// in FullyQualifiedDomainName at the interval that you specify in RequestInterval.
	// Using an IP address returned by DNS, Route 53 then checks the health of the
	// endpoint.
	//
	// Use one of the following formats for the value of IPAddress:
	//
	//    * IPv4 address: four values between 0 and 255, separated by periods (.),
	//    for example, 192.0.2.44.
	//
	//    * IPv6 address: eight groups of four hexadecimal values, separated by
	//    colons (:), for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345. You
	//    can also shorten IPv6 addresses as described in RFC 5952, for example,
	//    2001:db8:85a3::abcd:1:2345.
	//
	// If the endpoint is an EC2 instance, we recommend that you create an Elastic
	// IP address, associate it with your EC2 instance, and specify the Elastic
	// IP address for IPAddress. This ensures that the IP address of your instance
	// will never change.
	//
	// For more information, see FullyQualifiedDomainName (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
	//
	// Constraints: Route 53 can't check the health of endpoints for which the IP
	// address is in local, private, non-routable, or multicast ranges. For more
	// information about IP addresses for which you can't create health checks,
	// see the following documents:
	//
	//    * RFC 5735, Special Use IPv4 Addresses (https://tools.ietf.org/html/rfc5735)
	//
	//    * RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space (https://tools.ietf.org/html/rfc6598)
	//
	//    * RFC 5156, Special-Use IPv6 Addresses (https://tools.ietf.org/html/rfc5156)
	//
	// When the value of Type is CALCULATED or CLOUDWATCH_METRIC, omit IPAddress.
	IPAddress *string `type:"string"`

	// When CloudWatch has insufficient data about the metric to determine the alarm
	// state, the status that you want Amazon Route 53 to assign to the health check:
	//
	//    * Healthy: Route 53 considers the health check to be healthy.
	//
	//    * Unhealthy: Route 53 considers the health check to be unhealthy.
	//
	//    * LastKnownStatus: Route 53 uses the status of the health check from the
	//    last time that CloudWatch had sufficient data to determine the alarm state.
	//    For new health checks that have no last known status, the default status
	//    for the health check is healthy.
	InsufficientDataHealthStatus *string `type:"string" enum:"InsufficientDataHealthStatus"`

	// Specify whether you want Amazon Route 53 to invert the status of a health
	// check, for example, to consider a health check unhealthy when it otherwise
	// would be considered healthy.
	Inverted *bool `type:"boolean"`

	// Specify whether you want Amazon Route 53 to measure the latency between health
	// checkers in multiple Amazon Web Services regions and your endpoint, and to
	// display CloudWatch latency graphs on the Health Checks page in the Route
	// 53 console.
	//
	// You can't change the value of MeasureLatency after you create a health check.
	MeasureLatency *bool `type:"boolean"`

	// The port on the endpoint that you want Amazon Route 53 to perform health
	// checks on.
	//
	// Don't specify a value for Port when you specify a value for Type of CLOUDWATCH_METRIC
	// or CALCULATED.
	Port *int64 `min:"1" type:"integer"`

	// A complex type that contains one Region element for each region from which
	// you want Amazon Route 53 health checkers to check the specified endpoint.
	//
	// If you don't specify any regions, Route 53 health checkers automatically
	// performs checks from all of the regions that are listed under Valid Values.
	//
	// If you update a health check to remove a region that has been performing
	// health checks, Route 53 will briefly continue to perform checks from that
	// region to ensure that some health checkers are always checking the endpoint
	// (for example, if you replace three regions with four different regions).
	Regions []*string `locationNameList:"Region" min:"3" type:"list"`

	// The number of seconds between the time that Amazon Route 53 gets a response
	// from your endpoint and the time that it sends the next health check request.
	// Each Route 53 health checker makes requests at this interval.
	//
	// You can't change the value of RequestInterval after you create a health check.
	//
	// If you don't specify a value for RequestInterval, the default value is 30
	// seconds.
	RequestInterval *int64 `min:"10" type:"integer"`

	// The path, if any, that you want Amazon Route 53 to request when performing
	// health checks. The path can be any value for which your endpoint will return
	// an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example,
	// the file /docs/route53-health-check.html. You can also include query string
	// parameters, for example, /welcome.html?language=jp&login=y.
	ResourcePath *string `type:"string"`

	// The Amazon Resource Name (ARN) for Route53 Application Recovery Controller
	// routing control.
	RoutingControlArn *string `min:"1" type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTPS_STR_MATCH, the string that
	// you want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Route 53 considers
	// the resource healthy.
	//
	// Route 53 considers case when searching for SearchString in the response body.
	SearchString *string `type:"string"`

	// The type of health check that you want to create, which indicates how Amazon
	// Route 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//    * HTTP: Route 53 tries to establish a TCP connection. If successful, Route
	//    53 submits an HTTP request and waits for an HTTP status code of 200 or
	//    greater and less than 400.
	//
	//    * HTTPS: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTPS request and waits for an HTTP status code of
	//    200 or greater and less than 400. If you specify HTTPS for the value of
	//    Type, the endpoint must support TLS v1.0 or later.
	//
	//    * HTTP_STR_MATCH: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTP request and searches the first 5,120 bytes of
	//    the response body for the string that you specify in SearchString.
	//
	//    * HTTPS_STR_MATCH: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTPS request and searches the first 5,120 bytes of
	//    the response body for the string that you specify in SearchString.
	//
	//    * TCP: Route 53 tries to establish a TCP connection.
	//
	//    * CLOUDWATCH_METRIC: The health check is associated with a CloudWatch
	//    alarm. If the state of the alarm is OK, the health check is considered
	//    healthy. If the state is ALARM, the health check is considered unhealthy.
	//    If CloudWatch doesn't have sufficient data to determine whether the state
	//    is OK or ALARM, the health check status depends on the setting for InsufficientDataHealthStatus:
	//    Healthy, Unhealthy, or LastKnownStatus.
	//
	//    * CALCULATED: For health checks that monitor the status of other health
	//    checks, Route 53 adds up the number of health checks that Route 53 health
	//    checkers consider to be healthy and compares that number with the value
	//    of HealthThreshold.
	//
	//    * RECOVERY_CONTROL: The health check is assocated with a Route53 Application
	//    Recovery Controller routing control. If the routing control state is ON,
	//    the health check is considered healthy. If the state is OFF, the health
	//    check is considered unhealthy.
	//
	// For more information, see How Route 53 Determines Whether an Endpoint Is
	// Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"HealthCheckType"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Regions != nil && len(s.Regions) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 3))
	}
	if s.RequestInterval != nil && *s.RequestInterval < 10 {
		invalidParams.Add(request.NewErrParamMinValue("RequestInterval", 10))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.AlarmIdentifier != nil {
		if err := s.AlarmIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlarmIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmIdentifier sets the AlarmIdentifier field's value.
func (s *HealthCheckConfig) SetAlarmIdentifier(v *AlarmIdentifier) *HealthCheckConfig {
	s.AlarmIdentifier = v
	return s
}

// SetChildHealthChecks sets the ChildHealthChecks field's value.
func (s *HealthCheckConfig) SetChildHealthChecks(v []*string) *HealthCheckConfig {
	s.ChildHealthChecks = v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *HealthCheckConfig) SetDisabled(v bool) *HealthCheckConfig {
	s.Disabled = &v
	return s
}

// SetEnableSNI sets the EnableSNI field's value.
func (s *HealthCheckConfig) SetEnableSNI(v bool) *HealthCheckConfig {
	s.EnableSNI = &v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *HealthCheckConfig) SetFailureThreshold(v int64) *HealthCheckConfig {
	s.FailureThreshold = &v
	return s
}

// SetFullyQualifiedDomainName sets the FullyQualifiedDomainName field's value.
func (s *HealthCheckConfig) SetFullyQualifiedDomainName(v string) *HealthCheckConfig {
	s.FullyQualifiedDomainName = &v
	return s
}

// SetHealthThreshold sets the HealthThreshold field's value.
func (s *HealthCheckConfig) SetHealthThreshold(v int64) *HealthCheckConfig {
	s.HealthThreshold = &v
	return s
}

// SetIPAddress sets the IPAddress field's value.
func (s *HealthCheckConfig) SetIPAddress(v string) *HealthCheckConfig {
	s.IPAddress = &v
	return s
}

// SetInsufficientDataHealthStatus sets the InsufficientDataHealthStatus field's value.
func (s *HealthCheckConfig) SetInsufficientDataHealthStatus(v string) *HealthCheckConfig {
	s.InsufficientDataHealthStatus = &v
	return s
}

// SetInverted sets the Inverted field's value.
func (s *HealthCheckConfig) SetInverted(v bool) *HealthCheckConfig {
	s.Inverted = &v
	return s
}

// SetMeasureLatency sets the MeasureLatency field's value.
func (s *HealthCheckConfig) SetMeasureLatency(v bool) *HealthCheckConfig {
	s.MeasureLatency = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckConfig) SetPort(v int64) *HealthCheckConfig {
	s.Port = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *HealthCheckConfig) SetRegions(v []*string) *HealthCheckConfig {
	s.Regions = v
	return s
}

// SetRequestInterval sets the RequestInterval field's value.
func (s *HealthCheckConfig) SetRequestInterval(v int64) *HealthCheckConfig {
	s.RequestInterval = &v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *HealthCheckConfig) SetResourcePath(v string) *HealthCheckConfig {
	s.ResourcePath = &v
	return s
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *HealthCheckConfig) SetRoutingControlArn(v string) *HealthCheckConfig {
	s.RoutingControlArn = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *HealthCheckConfig) SetSearchString(v string) *HealthCheckConfig {
	s.SearchString = &v
	return s
}

// SetType sets the Type field's value.
func (s *HealthCheckConfig) SetType(v string) *HealthCheckConfig {
	s.Type = &v
	return s
}

// A complex type that contains the last failure reason as reported by one Amazon
// Route 53 health checker.
type HealthCheckObservation struct {
	_ struct{} `type:"structure"`

	// The IP address of the Amazon Route 53 health checker that provided the failure
	// reason in StatusReport.
	IPAddress *string `type:"string"`

	// The region of the Amazon Route 53 health checker that provided the status
	// in StatusReport.
	Region *string `min:"1" type:"string" enum:"HealthCheckRegion"`

	// A complex type that contains the last failure reason as reported by one Amazon
	// Route 53 health checker and the time of the failed health check.
	StatusReport *StatusReport `type:"structure"`
}

// String returns the string representation
func (s HealthCheckObservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckObservation) GoString() string {
	return s.String()
}

// SetIPAddress sets the IPAddress field's value.
func (s *HealthCheckObservation) SetIPAddress(v string) *HealthCheckObservation {
	s.IPAddress = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *HealthCheckObservation) SetRegion(v string) *HealthCheckObservation {
	s.Region = &v
	return s
}

// SetStatusReport sets the StatusReport field's value.
func (s *HealthCheckObservation) SetStatusReport(v *StatusReport) *HealthCheckObservation {
	s.StatusReport = v
	return s
}

// A complex type that contains general information about the hosted zone.
type HostedZone struct {
	_ struct{} `type:"structure"`

	// The value that you specified for CallerReference when you created the hosted
	// zone.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that includes the Comment and PrivateZone elements. If you
	// omitted the HostedZoneConfig and Comment elements from the request, the Config
	// and Comment elements don't appear in the response.
	Config *HostedZoneConfig `type:"structure"`

	// The ID that Amazon Route 53 assigned to the hosted zone when you created
	// it.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If the hosted zone was created by another service, the service that created
	// the hosted zone. When a hosted zone is created by another service, you can't
	// edit or delete it using Route 53.
	LinkedService *LinkedService `type:"structure"`

	// The name of the domain. For public hosted zones, this is the name that you
	// have registered with your DNS registrar.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see CreateHostedZone
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html).
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The number of resource record sets in the hosted zone.
	ResourceRecordSetCount *int64 `type:"long"`
}

// String returns the string representation
func (s HostedZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZone) GoString() string {
	return s.String()
}

// SetCallerReference sets the CallerReference field's value.
func (s *HostedZone) SetCallerReference(v string) *HostedZone {
	s.CallerReference = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *HostedZone) SetConfig(v *HostedZoneConfig) *HostedZone {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *HostedZone) SetId(v string) *HostedZone {
	s.Id = &v
	return s
}

// SetLinkedService sets the LinkedService field's value.
func (s *HostedZone) SetLinkedService(v *LinkedService) *HostedZone {
	s.LinkedService = v
	return s
}

// SetName sets the Name field's value.
func (s *HostedZone) SetName(v string) *HostedZone {
	s.Name = &v
	return s
}

// SetResourceRecordSetCount sets the ResourceRecordSetCount field's value.
func (s *HostedZone) SetResourceRecordSetCount(v int64) *HostedZone {
	s.ResourceRecordSetCount = &v
	return s
}

// A complex type that contains an optional comment about your hosted zone.
// If you don't want to specify a comment, omit both the HostedZoneConfig and
// Comment elements.
type HostedZoneConfig struct {
	_ struct{} `type:"structure"`

	// Any comments that you want to include about the hosted zone.
	Comment *string `type:"string"`

	// A value that indicates whether this is a private hosted zone.
	PrivateZone *bool `type:"boolean"`
}

// String returns the string representation
func (s HostedZoneConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneConfig) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *HostedZoneConfig) SetComment(v string) *HostedZoneConfig {
	s.Comment = &v
	return s
}

// SetPrivateZone sets the PrivateZone field's value.
func (s *HostedZoneConfig) SetPrivateZone(v bool) *HostedZoneConfig {
	s.PrivateZone = &v
	return s
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
type HostedZoneLimit struct {
	_ struct{} `type:"structure"`

	// The limit that you requested. Valid values include the following:
	//
	//    * MAX_RRSETS_BY_ZONE: The maximum number of records that you can create
	//    in the specified hosted zone.
	//
	//    * MAX_VPCS_ASSOCIATED_BY_ZONE: The maximum number of Amazon VPCs that
	//    you can associate with the specified private hosted zone.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"HostedZoneLimitType"`

	// The current value for the limit that is specified by Type.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s HostedZoneLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneLimit) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *HostedZoneLimit) SetType(v string) *HostedZoneLimit {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HostedZoneLimit) SetValue(v int64) *HostedZoneLimit {
	s.Value = &v
	return s
}

// A complex type that identifies a hosted zone that a specified Amazon VPC
// is associated with and the owner of the hosted zone. If there is a value
// for OwningAccount, there is no value for OwningService, and vice versa.
type HostedZoneOwner struct {
	_ struct{} `type:"structure"`

	// If the hosted zone was created by an account, or was created by an Amazon
	// Web Services service that creates hosted zones using the current account,
	// OwningAccount contains the account ID of that account. For example, when
	// you use Cloud Map to create a hosted zone, Cloud Map creates the hosted zone
	// using the current account.
	OwningAccount *string `type:"string"`

	// If an Amazon Web Services service uses its own account to create a hosted
	// zone and associate the specified VPC with that hosted zone, OwningService
	// contains an abbreviation that identifies the service. For example, if Amazon
	// Elastic File System (Amazon EFS) created a hosted zone and associated a VPC
	// with the hosted zone, the value of OwningService is efs.amazonaws.com.
	OwningService *string `type:"string"`
}

// String returns the string representation
func (s HostedZoneOwner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneOwner) GoString() string {
	return s.String()
}

// SetOwningAccount sets the OwningAccount field's value.
func (s *HostedZoneOwner) SetOwningAccount(v string) *HostedZoneOwner {
	s.OwningAccount = &v
	return s
}

// SetOwningService sets the OwningService field's value.
func (s *HostedZoneOwner) SetOwningService(v string) *HostedZoneOwner {
	s.OwningService = &v
	return s
}

// In the response to a ListHostedZonesByVPC request, the HostedZoneSummaries
// element contains one HostedZoneSummary element for each hosted zone that
// the specified Amazon VPC is associated with. Each HostedZoneSummary element
// contains the hosted zone name and ID, and information about who owns the
// hosted zone.
type HostedZoneSummary struct {
	_ struct{} `type:"structure"`

	// The Route 53 hosted zone ID of a private hosted zone that the specified VPC
	// is associated with.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The name of the private hosted zone, such as example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The owner of a private hosted zone that the specified VPC is associated with.
	// The owner can be either an account or an Amazon Web Services service.
	//
	// Owner is a required field
	Owner *HostedZoneOwner `type:"structure" required:"true"`
}

// String returns the string representation
func (s HostedZoneSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneSummary) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *HostedZoneSummary) SetHostedZoneId(v string) *HostedZoneSummary {
	s.HostedZoneId = &v
	return s
}

// SetName sets the Name field's value.
func (s *HostedZoneSummary) SetName(v string) *HostedZoneSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *HostedZoneSummary) SetOwner(v *HostedZoneOwner) *HostedZoneSummary {
	s.Owner = v
	return s
}

// A key-signing key (KSK) is a complex type that represents a public/private
// key pair. The private key is used to generate a digital signature for the
// zone signing key (ZSK). The public key is stored in the DNS and is used to
// authenticate the ZSK. A KSK is always associated with a hosted zone; it cannot
// exist by itself.
type KeySigningKey struct {
	_ struct{} `type:"structure"`

	// The date when the key-signing key (KSK) was created.
	CreatedDate *time.Time `type:"timestamp"`

	// A string that represents a DNSKEY record.
	DNSKEYRecord *string `type:"string"`

	// A string that represents a delegation signer (DS) record.
	DSRecord *string `type:"string"`

	// A string used to represent the delegation signer digest algorithm. This value
	// must follow the guidelines provided by RFC-8624 Section 3.3 (https://tools.ietf.org/html/rfc8624#section-3.3).
	DigestAlgorithmMnemonic *string `type:"string"`

	// An integer used to represent the delegation signer digest algorithm. This
	// value must follow the guidelines provided by RFC-8624 Section 3.3 (https://tools.ietf.org/html/rfc8624#section-3.3).
	DigestAlgorithmType *int64 `type:"integer"`

	// A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are
	// used to publish the public key that resolvers can use to verify DNSSEC signatures
	// that are used to secure certain kinds of information provided by the DNS
	// system.
	DigestValue *string `type:"string"`

	// An integer that specifies how the key is used. For key-signing key (KSK),
	// this value is always 257.
	Flag *int64 `type:"integer"`

	// An integer used to identify the DNSSEC record for the domain name. The process
	// used to calculate the value is described in RFC-4034 Appendix B (https://tools.ietf.org/rfc/rfc4034.txt).
	KeyTag *int64 `type:"integer"`

	// The Amazon resource name (ARN) used to identify the customer managed customer
	// master key (CMK) in Key Management Service (KMS). The KmsArn must be unique
	// for each key-signing key (KSK) in a single hosted zone.
	//
	// You must configure the CMK as follows:
	//
	// Status
	//
	// Enabled
	//
	// Key spec
	//
	// ECC_NIST_P256
	//
	// Key usage
	//
	// Sign and verify
	//
	// Key policy
	//
	// The key policy must give permission for the following actions:
	//
	//    * DescribeKey
	//
	//    * GetPublicKey
	//
	//    * Sign
	//
	// The key policy must also include the Amazon Route 53 service in the principal
	// for your account. Specify the following:
	//
	//    * "Service": "dnssec-route53.amazonaws.com"
	//
	// For more information about working with the customer managed CMK in KMS,
	// see Key Management Service concepts (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
	KmsArn *string `type:"string"`

	// The last time that the key-signing key (KSK) was changed.
	LastModifiedDate *time.Time `type:"timestamp"`

	// A string used to identify a key-signing key (KSK). Name can include numbers,
	// letters, and underscores (_). Name must be unique for each key-signing key
	// in the same hosted zone.
	Name *string `min:"3" type:"string"`

	// The public key, represented as a Base64 encoding, as required by RFC-4034
	// Page 5 (https://tools.ietf.org/rfc/rfc4034.txt).
	PublicKey *string `type:"string"`

	// A string used to represent the signing algorithm. This value must follow
	// the guidelines provided by RFC-8624 Section 3.1 (https://tools.ietf.org/html/rfc8624#section-3.1).
	SigningAlgorithmMnemonic *string `type:"string"`

	// An integer used to represent the signing algorithm. This value must follow
	// the guidelines provided by RFC-8624 Section 3.1 (https://tools.ietf.org/html/rfc8624#section-3.1).
	SigningAlgorithmType *int64 `type:"integer"`

	// A string that represents the current key-signing key (KSK) status.
	//
	// Status can have one of the following values:
	//
	// ACTIVE
	//
	// The KSK is being used for signing.
	//
	// INACTIVE
	//
	// The KSK is not being used for signing.
	//
	// DELETING
	//
	// The KSK is in the process of being deleted.
	//
	// ACTION_NEEDED
	//
	// There is a problem with the KSK that requires you to take action to resolve.
	// For example, the customer managed customer master key (CMK) might have been
	// deleted, or the permissions for the customer managed CMK might have been
	// changed.
	//
	// INTERNAL_FAILURE
	//
	// There was an error during a request. Before you can continue to work with
	// DNSSEC signing, including actions that involve this KSK, you must correct
	// the problem. For example, you may need to activate or deactivate the KSK.
	Status *string `min:"5" type:"string"`

	// The status message provided for the following key-signing key (KSK) statuses:
	// ACTION_NEEDED or INTERNAL_FAILURE. The status message includes information
	// about what the problem might be and steps that you can take to correct the
	// issue.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s KeySigningKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeySigningKey) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *KeySigningKey) SetCreatedDate(v time.Time) *KeySigningKey {
	s.CreatedDate = &v
	return s
}

// SetDNSKEYRecord sets the DNSKEYRecord field's value.
func (s *KeySigningKey) SetDNSKEYRecord(v string) *KeySigningKey {
	s.DNSKEYRecord = &v
	return s
}

// SetDSRecord sets the DSRecord field's value.
func (s *KeySigningKey) SetDSRecord(v string) *KeySigningKey {
	s.DSRecord = &v
	return s
}

// SetDigestAlgorithmMnemonic sets the DigestAlgorithmMnemonic field's value.
func (s *KeySigningKey) SetDigestAlgorithmMnemonic(v string) *KeySigningKey {
	s.DigestAlgorithmMnemonic = &v
	return s
}

// SetDigestAlgorithmType sets the DigestAlgorithmType field's value.
func (s *KeySigningKey) SetDigestAlgorithmType(v int64) *KeySigningKey {
	s.DigestAlgorithmType = &v
	return s
}

// SetDigestValue sets the DigestValue field's value.
func (s *KeySigningKey) SetDigestValue(v string) *KeySigningKey {
	s.DigestValue = &v
	return s
}

// SetFlag sets the Flag field's value.
func (s *KeySigningKey) SetFlag(v int64) *KeySigningKey {
	s.Flag = &v
	return s
}

// SetKeyTag sets the KeyTag field's value.
func (s *KeySigningKey) SetKeyTag(v int64) *KeySigningKey {
	s.KeyTag = &v
	return s
}

// SetKmsArn sets the KmsArn field's value.
func (s *KeySigningKey) SetKmsArn(v string) *KeySigningKey {
	s.KmsArn = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *KeySigningKey) SetLastModifiedDate(v time.Time) *KeySigningKey {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *KeySigningKey) SetName(v string) *KeySigningKey {
	s.Name = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *KeySigningKey) SetPublicKey(v string) *KeySigningKey {
	s.PublicKey = &v
	return s
}

// SetSigningAlgorithmMnemonic sets the SigningAlgorithmMnemonic field's value.
func (s *KeySigningKey) SetSigningAlgorithmMnemonic(v string) *KeySigningKey {
	s.SigningAlgorithmMnemonic = &v
	return s
}

// SetSigningAlgorithmType sets the SigningAlgorithmType field's value.
func (s *KeySigningKey) SetSigningAlgorithmType(v int64) *KeySigningKey {
	s.SigningAlgorithmType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KeySigningKey) SetStatus(v string) *KeySigningKey {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *KeySigningKey) SetStatusMessage(v string) *KeySigningKey {
	s.StatusMessage = &v
	return s
}

// If a health check or hosted zone was created by another service, LinkedService
// is a complex type that describes the service that created the resource. When
// a resource is created by another service, you can't edit or delete it using
// Amazon Route 53.
type LinkedService struct {
	_ struct{} `type:"structure"`

	// If the health check or hosted zone was created by another service, an optional
	// description that can be provided by the other service. When a resource is
	// created by another service, you can't edit or delete it using Amazon Route
	// 53.
	Description *string `type:"string"`

	// If the health check or hosted zone was created by another service, the service
	// that created the resource. When a resource is created by another service,
	// you can't edit or delete it using Amazon Route 53.
	ServicePrincipal *string `type:"string"`
}

// String returns the string representation
func (s LinkedService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LinkedService) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *LinkedService) SetDescription(v string) *LinkedService {
	s.Description = &v
	return s
}

// SetServicePrincipal sets the ServicePrincipal field's value.
func (s *LinkedService) SetServicePrincipal(v string) *LinkedService {
	s.ServicePrincipal = &v
	return s
}

// A request to get a list of geographic locations that Amazon Route 53 supports
// for geolocation resource record sets.
type ListGeoLocationsInput struct {
	_ struct{} `locationName:"ListGeoLocationsRequest" type:"structure"`

	// (Optional) The maximum number of geolocations to be included in the response
	// body for this request. If more than maxitems geolocations remain to be listed,
	// then the value of the IsTruncated element in the response is true.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The code for the continent with which you want to start listing locations
	// that Amazon Route 53 supports for geolocation. If Route 53 has already returned
	// a page or more of results, if IsTruncated is true, and if NextContinentCode
	// from the previous response has a value, enter that value in startcontinentcode
	// to return the next page of results.
	//
	// Include startcontinentcode only if you want to list continents. Don't include
	// startcontinentcode when you're listing countries or countries with their
	// subdivisions.
	StartContinentCode *string `location:"querystring" locationName:"startcontinentcode" min:"2" type:"string"`

	// The code for the country with which you want to start listing locations that
	// Amazon Route 53 supports for geolocation. If Route 53 has already returned
	// a page or more of results, if IsTruncated is true, and if NextCountryCode
	// from the previous response has a value, enter that value in startcountrycode
	// to return the next page of results.
	StartCountryCode *string `location:"querystring" locationName:"startcountrycode" min:"1" type:"string"`

	// The code for the state of the United States with which you want to start
	// listing locations that Amazon Route 53 supports for geolocation. If Route
	// 53 has already returned a page or more of results, if IsTruncated is true,
	// and if NextSubdivisionCode from the previous response has a value, enter
	// that value in startsubdivisioncode to return the next page of results.
	//
	// To list subdivisions (U.S. states), you must include both startcountrycode
	// and startsubdivisioncode.
	StartSubdivisionCode *string `location:"querystring" locationName:"startsubdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeoLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeoLocationsInput"}
	if s.StartContinentCode != nil && len(*s.StartContinentCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("StartContinentCode", 2))
	}
	if s.StartCountryCode != nil && len(*s.StartCountryCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartCountryCode", 1))
	}
	if s.StartSubdivisionCode != nil && len(*s.StartSubdivisionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartSubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListGeoLocationsInput) SetMaxItems(v string) *ListGeoLocationsInput {
	s.MaxItems = &v
	return s
}

// SetStartContinentCode sets the StartContinentCode field's value.
func (s *ListGeoLocationsInput) SetStartContinentCode(v string) *ListGeoLocationsInput {
	s.StartContinentCode = &v
	return s
}

// SetStartCountryCode sets the StartCountryCode field's value.
func (s *ListGeoLocationsInput) SetStartCountryCode(v string) *ListGeoLocationsInput {
	s.StartCountryCode = &v
	return s
}

// SetStartSubdivisionCode sets the StartSubdivisionCode field's value.
func (s *ListGeoLocationsInput) SetStartSubdivisionCode(v string) *ListGeoLocationsInput {
	s.StartSubdivisionCode = &v
	return s
}

// A complex type containing the response information for the request.
type ListGeoLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one GeoLocationDetails element for each location
	// that Amazon Route 53 supports for geolocation.
	//
	// GeoLocationDetailsList is a required field
	GeoLocationDetailsList []*GeoLocationDetails `locationNameList:"GeoLocationDetails" type:"list" required:"true"`

	// A value that indicates whether more locations remain to be listed after the
	// last location in this response. If so, the value of IsTruncated is true.
	// To get more values, submit another request and include the values of NextContinentCode,
	// NextCountryCode, and NextSubdivisionCode in the startcontinentcode, startcountrycode,
	// and startsubdivisioncode, as applicable.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for MaxItems in the request.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, you can make a follow-up request to display more
	// locations. Enter the value of NextContinentCode in the startcontinentcode
	// parameter in another ListGeoLocations request.
	NextContinentCode *string `min:"2" type:"string"`

	// If IsTruncated is true, you can make a follow-up request to display more
	// locations. Enter the value of NextCountryCode in the startcountrycode parameter
	// in another ListGeoLocations request.
	NextCountryCode *string `min:"1" type:"string"`

	// If IsTruncated is true, you can make a follow-up request to display more
	// locations. Enter the value of NextSubdivisionCode in the startsubdivisioncode
	// parameter in another ListGeoLocations request.
	NextSubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsOutput) GoString() string {
	return s.String()
}

// SetGeoLocationDetailsList sets the GeoLocationDetailsList field's value.
func (s *ListGeoLocationsOutput) SetGeoLocationDetailsList(v []*GeoLocationDetails) *ListGeoLocationsOutput {
	s.GeoLocationDetailsList = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListGeoLocationsOutput) SetIsTruncated(v bool) *ListGeoLocationsOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListGeoLocationsOutput) SetMaxItems(v string) *ListGeoLocationsOutput {
	s.MaxItems = &v
	return s
}

// SetNextContinentCode sets the NextContinentCode field's value.
func (s *ListGeoLocationsOutput) SetNextContinentCode(v string) *ListGeoLocationsOutput {
	s.NextContinentCode = &v
	return s
}

// SetNextCountryCode sets the NextCountryCode field's value.
func (s *ListGeoLocationsOutput) SetNextCountryCode(v string) *ListGeoLocationsOutput {
	s.NextCountryCode = &v
	return s
}

// SetNextSubdivisionCode sets the NextSubdivisionCode field's value.
func (s *ListGeoLocationsOutput) SetNextSubdivisionCode(v string) *ListGeoLocationsOutput {
	s.NextSubdivisionCode = &v
	return s
}

// A request to retrieve a list of the health checks that are associated with
// the current account.
type ListHealthChecksInput struct {
	_ struct{} `locationName:"ListHealthChecksRequest" type:"structure"`

	// If the value of IsTruncated in the previous response was true, you have more
	// health checks. To get another group, submit another ListHealthChecks request.
	//
	// For the value of marker, specify the value of NextMarker from the previous
	// response, which is the ID of the first health check that Amazon Route 53
	// will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more health checks to get.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of health checks that you want ListHealthChecks to return
	// in response to the current request. Amazon Route 53 returns a maximum of
	// 100 items. If you set MaxItems to a value greater than 100, Route 53 returns
	// only the first 100 health checks.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHealthChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListHealthChecksInput) SetMarker(v string) *ListHealthChecksInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHealthChecksInput) SetMaxItems(v string) *ListHealthChecksInput {
	s.MaxItems = &v
	return s
}

// A complex type that contains the response to a ListHealthChecks request.
type ListHealthChecksOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one HealthCheck element for each health check
	// that is associated with the current account.
	//
	// HealthChecks is a required field
	HealthChecks []*HealthCheck `locationNameList:"HealthCheck" type:"list" required:"true"`

	// A flag that indicates whether there are more health checks to be listed.
	// If the response was truncated, you can get the next group of health checks
	// by submitting another ListHealthChecks request and specifying the value of
	// NextMarker in the marker parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListHealthChecks, Marker is the value
	// that you specified for the marker parameter in the previous request.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHealthChecks
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the first health
	// check that Amazon Route 53 returns if you submit another ListHealthChecks
	// request and specify the value of NextMarker in the marker parameter.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHealthChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksOutput) GoString() string {
	return s.String()
}

// SetHealthChecks sets the HealthChecks field's value.
func (s *ListHealthChecksOutput) SetHealthChecks(v []*HealthCheck) *ListHealthChecksOutput {
	s.HealthChecks = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListHealthChecksOutput) SetIsTruncated(v bool) *ListHealthChecksOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListHealthChecksOutput) SetMarker(v string) *ListHealthChecksOutput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHealthChecksOutput) SetMaxItems(v string) *ListHealthChecksOutput {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListHealthChecksOutput) SetNextMarker(v string) *ListHealthChecksOutput {
	s.NextMarker = &v
	return s
}

// Retrieves a list of the public and private hosted zones that are associated
// with the current account in ASCII order by domain name.
type ListHostedZonesByNameInput struct {
	_ struct{} `locationName:"ListHostedZonesByNameRequest" type:"structure"`

	// (Optional) For your first request to ListHostedZonesByName, include the dnsname
	// parameter only if you want to specify the name of the first hosted zone in
	// the response. If you don't include the dnsname parameter, Amazon Route 53
	// returns all of the hosted zones that were created by the current account,
	// in ASCII order. For subsequent requests, include both dnsname and hostedzoneid
	// parameters. For dnsname, specify the value of NextDNSName from the previous
	// response.
	DNSName *string `location:"querystring" locationName:"dnsname" type:"string"`

	// (Optional) For your first request to ListHostedZonesByName, do not include
	// the hostedzoneid parameter.
	//
	// If you have more hosted zones than the value of maxitems, ListHostedZonesByName
	// returns only the first maxitems hosted zones. To get the next group of maxitems
	// hosted zones, submit another request to ListHostedZonesByName and include
	// both dnsname and hostedzoneid parameters. For the value of hostedzoneid,
	// specify the value of the NextHostedZoneId element from the previous response.
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of hosted zones to be included in the response body for
	// this request. If you have more than maxitems hosted zones, then the value
	// of the IsTruncated element in the response is true, and the values of NextDNSName
	// and NextHostedZoneId specify the first hosted zone in the next group of maxitems
	// hosted zones.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameInput) GoString() string {
	return s.String()
}

// SetDNSName sets the DNSName field's value.
func (s *ListHostedZonesByNameInput) SetDNSName(v string) *ListHostedZonesByNameInput {
	s.DNSName = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListHostedZonesByNameInput) SetHostedZoneId(v string) *ListHostedZonesByNameInput {
	s.HostedZoneId = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHostedZonesByNameInput) SetMaxItems(v string) *ListHostedZonesByNameInput {
	s.MaxItems = &v
	return s
}

// A complex type that contains the response information for the request.
type ListHostedZonesByNameOutput struct {
	_ struct{} `type:"structure"`

	// For the second and subsequent calls to ListHostedZonesByName, DNSName is
	// the value that you specified for the dnsname parameter in the request that
	// produced the current response.
	DNSName *string `type:"string"`

	// The ID that Amazon Route 53 assigned to the hosted zone when you created
	// it.
	HostedZoneId *string `type:"string"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZones is a required field
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag that indicates whether there are more hosted zones to be listed. If
	// the response was truncated, you can get the next group of maxitems hosted
	// zones by calling ListHostedZonesByName again and specifying the values of
	// NextDNSName and NextHostedZoneId elements in the dnsname and hostedzoneid
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHostedZonesByName
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextDNSName is the name of the first
	// hosted zone in the next group of maxitems hosted zones. Call ListHostedZonesByName
	// again and specify the value of NextDNSName and NextHostedZoneId in the dnsname
	// and hostedzoneid parameters, respectively.
	//
	// This element is present only if IsTruncated is true.
	NextDNSName *string `type:"string"`

	// If IsTruncated is true, the value of NextHostedZoneId identifies the first
	// hosted zone in the next group of maxitems hosted zones. Call ListHostedZonesByName
	// again and specify the value of NextDNSName and NextHostedZoneId in the dnsname
	// and hostedzoneid parameters, respectively.
	//
	// This element is present only if IsTruncated is true.
	NextHostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameOutput) GoString() string {
	return s.String()
}

// SetDNSName sets the DNSName field's value.
func (s *ListHostedZonesByNameOutput) SetDNSName(v string) *ListHostedZonesByNameOutput {
	s.DNSName = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListHostedZonesByNameOutput) SetHostedZoneId(v string) *ListHostedZonesByNameOutput {
	s.HostedZoneId = &v
	return s
}

// SetHostedZones sets the HostedZones field's value.
func (s *ListHostedZonesByNameOutput) SetHostedZones(v []*HostedZone) *ListHostedZonesByNameOutput {
	s.HostedZones = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListHostedZonesByNameOutput) SetIsTruncated(v bool) *ListHostedZonesByNameOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHostedZonesByNameOutput) SetMaxItems(v string) *ListHostedZonesByNameOutput {
	s.MaxItems = &v
	return s
}

// SetNextDNSName sets the NextDNSName field's value.
func (s *ListHostedZonesByNameOutput) SetNextDNSName(v string) *ListHostedZonesByNameOutput {
	s.NextDNSName = &v
	return s
}

// SetNextHostedZoneId sets the NextHostedZoneId field's value.
func (s *ListHostedZonesByNameOutput) SetNextHostedZoneId(v string) *ListHostedZonesByNameOutput {
	s.NextHostedZoneId = &v
	return s
}

// Lists all the private hosted zones that a specified VPC is associated with,
// regardless of which account created the hosted zones.
type ListHostedZonesByVPCInput struct {
	_ struct{} `locationName:"ListHostedZonesByVPCRequest" type:"structure"`

	// (Optional) The maximum number of hosted zones that you want Amazon Route
	// 53 to return. If the specified VPC is associated with more than MaxItems
	// hosted zones, the response includes a NextToken element. NextToken contains
	// an encrypted token that identifies the first hosted zone that Route 53 will
	// return if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// If the previous response included a NextToken element, the specified VPC
	// is associated with more hosted zones. To get more hosted zones, submit another
	// ListHostedZonesByVPC request.
	//
	// For the value of NextToken, specify the value of NextToken from the previous
	// response.
	//
	// If the previous response didn't include a NextToken element, there are no
	// more hosted zones to get.
	NextToken *string `location:"querystring" locationName:"nexttoken" type:"string"`

	// The ID of the Amazon VPC that you want to list hosted zones for.
	//
	// VPCId is a required field
	VPCId *string `location:"querystring" locationName:"vpcid" type:"string" required:"true"`

	// For the Amazon VPC that you specified for VPCId, the Amazon Web Services
	// Region that you created the VPC in.
	//
	// VPCRegion is a required field
	VPCRegion *string `location:"querystring" locationName:"vpcregion" min:"1" type:"string" required:"true" enum:"VPCRegion"`
}

// String returns the string representation
func (s ListHostedZonesByVPCInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByVPCInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHostedZonesByVPCInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHostedZonesByVPCInput"}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCRegion"))
	}
	if s.VPCRegion != nil && len(*s.VPCRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHostedZonesByVPCInput) SetMaxItems(v string) *ListHostedZonesByVPCInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHostedZonesByVPCInput) SetNextToken(v string) *ListHostedZonesByVPCInput {
	s.NextToken = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *ListHostedZonesByVPCInput) SetVPCId(v string) *ListHostedZonesByVPCInput {
	s.VPCId = &v
	return s
}

// SetVPCRegion sets the VPCRegion field's value.
func (s *ListHostedZonesByVPCInput) SetVPCRegion(v string) *ListHostedZonesByVPCInput {
	s.VPCRegion = &v
	return s
}

type ListHostedZonesByVPCOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one HostedZoneSummary element for each hosted zone that
	// the specified Amazon VPC is associated with. Each HostedZoneSummary element
	// contains the hosted zone name and ID, and information about who owns the
	// hosted zone.
	//
	// HostedZoneSummaries is a required field
	HostedZoneSummaries []*HostedZoneSummary `locationNameList:"HostedZoneSummary" type:"list" required:"true"`

	// The value that you specified for MaxItems in the most recent ListHostedZonesByVPC
	// request.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// The value that you will use for NextToken in the next ListHostedZonesByVPC
	// request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByVPCOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByVPCOutput) GoString() string {
	return s.String()
}

// SetHostedZoneSummaries sets the HostedZoneSummaries field's value.
func (s *ListHostedZonesByVPCOutput) SetHostedZoneSummaries(v []*HostedZoneSummary) *ListHostedZonesByVPCOutput {
	s.HostedZoneSummaries = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHostedZonesByVPCOutput) SetMaxItems(v string) *ListHostedZonesByVPCOutput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHostedZonesByVPCOutput) SetNextToken(v string) *ListHostedZonesByVPCOutput {
	s.NextToken = &v
	return s
}

// A request to retrieve a list of the public and private hosted zones that
// are associated with the current account.
type ListHostedZonesInput struct {
	_ struct{} `locationName:"ListHostedZonesRequest" type:"structure"`

	// If you're using reusable delegation sets and you want to list all of the
	// hosted zones that are associated with a reusable delegation set, specify
	// the ID of that reusable delegation set.
	DelegationSetId *string `location:"querystring" locationName:"delegationsetid" type:"string"`

	// If the value of IsTruncated in the previous response was true, you have more
	// hosted zones. To get more hosted zones, submit another ListHostedZones request.
	//
	// For the value of marker, specify the value of NextMarker from the previous
	// response, which is the ID of the first hosted zone that Amazon Route 53 will
	// return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more hosted zones to get.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// (Optional) The maximum number of hosted zones that you want Amazon Route
	// 53 to return. If you have more than maxitems hosted zones, the value of IsTruncated
	// in the response is true, and the value of NextMarker is the hosted zone ID
	// of the first hosted zone that Route 53 will return if you submit another
	// request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHostedZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesInput) GoString() string {
	return s.String()
}

// SetDelegationSetId sets the DelegationSetId field's value.
func (s *ListHostedZonesInput) SetDelegationSetId(v string) *ListHostedZonesInput {
	s.DelegationSetId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListHostedZonesInput) SetMarker(v string) *ListHostedZonesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHostedZonesInput) SetMaxItems(v string) *ListHostedZonesInput {
	s.MaxItems = &v
	return s
}

type ListHostedZonesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZones is a required field
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag indicating whether there are more hosted zones to be listed. If the
	// response was truncated, you can get more hosted zones by submitting another
	// ListHostedZones request and specifying the value of NextMarker in the marker
	// parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListHostedZones, Marker is the value
	// that you specified for the marker parameter in the request that produced
	// the current response.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHostedZones
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the first hosted
	// zone in the next group of hosted zones. Submit another ListHostedZones request,
	// and specify the value of NextMarker from the response in the marker parameter.
	//
	// This element is present only if IsTruncated is true.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesOutput) GoString() string {
	return s.String()
}

// SetHostedZones sets the HostedZones field's value.
func (s *ListHostedZonesOutput) SetHostedZones(v []*HostedZone) *ListHostedZonesOutput {
	s.HostedZones = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListHostedZonesOutput) SetIsTruncated(v bool) *ListHostedZonesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListHostedZonesOutput) SetMarker(v string) *ListHostedZonesOutput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListHostedZonesOutput) SetMaxItems(v string) *ListHostedZonesOutput {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListHostedZonesOutput) SetNextMarker(v string) *ListHostedZonesOutput {
	s.NextMarker = &v
	return s
}

type ListQueryLoggingConfigsInput struct {
	_ struct{} `locationName:"ListQueryLoggingConfigsRequest" type:"structure"`

	// (Optional) If you want to list the query logging configuration that is associated
	// with a hosted zone, specify the ID in HostedZoneId.
	//
	// If you don't specify a hosted zone ID, ListQueryLoggingConfigs returns all
	// of the configurations that are associated with the current account.
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// (Optional) The maximum number of query logging configurations that you want
	// Amazon Route 53 to return in response to the current request. If the current
	// account has more than MaxResults configurations, use the value of NextToken
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax)
	// in the response to get the next page of results.
	//
	// If you don't specify a value for MaxResults, Route 53 returns up to 100 configurations.
	MaxResults *string `location:"querystring" locationName:"maxresults" type:"string"`

	// (Optional) If the current account has more than MaxResults query logging
	// configurations, use NextToken to get the second and subsequent pages of results.
	//
	// For the first ListQueryLoggingConfigs request, omit this value.
	//
	// For the second and subsequent requests, get the value of NextToken from the
	// previous response and specify that value for NextToken in the request.
	NextToken *string `location:"querystring" locationName:"nexttoken" type:"string"`
}

// String returns the string representation
func (s ListQueryLoggingConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryLoggingConfigsInput) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListQueryLoggingConfigsInput) SetHostedZoneId(v string) *ListQueryLoggingConfigsInput {
	s.HostedZoneId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueryLoggingConfigsInput) SetMaxResults(v string) *ListQueryLoggingConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryLoggingConfigsInput) SetNextToken(v string) *ListQueryLoggingConfigsInput {
	s.NextToken = &v
	return s
}

type ListQueryLoggingConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If a response includes the last of the query logging configurations that
	// are associated with the current account, NextToken doesn't appear in the
	// response.
	//
	// If a response doesn't include the last of the configurations, you can get
	// more configurations by submitting another ListQueryLoggingConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html)
	// request. Get the value of NextToken that Amazon Route 53 returned in the
	// previous response and include it in NextToken in the next request.
	NextToken *string `type:"string"`

	// An array that contains one QueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html)
	// element for each configuration for DNS query logging that is associated with
	// the current account.
	//
	// QueryLoggingConfigs is a required field
	QueryLoggingConfigs []*QueryLoggingConfig `locationNameList:"QueryLoggingConfig" type:"list" required:"true"`
}

// String returns the string representation
func (s ListQueryLoggingConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryLoggingConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryLoggingConfigsOutput) SetNextToken(v string) *ListQueryLoggingConfigsOutput {
	s.NextToken = &v
	return s
}

// SetQueryLoggingConfigs sets the QueryLoggingConfigs field's value.
func (s *ListQueryLoggingConfigsOutput) SetQueryLoggingConfigs(v []*QueryLoggingConfig) *ListQueryLoggingConfigsOutput {
	s.QueryLoggingConfigs = v
	return s
}

// A request for the resource record sets that are associated with a specified
// hosted zone.
type ListResourceRecordSetsInput struct {
	_ struct{} `locationName:"ListResourceRecordSetsRequest" type:"structure"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to list.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// (Optional) The maximum number of resource records sets to include in the
	// response body for this request. If the response includes more than maxitems
	// resource record sets, the value of the IsTruncated element in the response
	// is true, and the values of the NextRecordName and NextRecordType elements
	// in the response identify the first resource record set in the next group
	// of maxitems resource record sets.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// Resource record sets that have a routing policy other than simple: If results
	// were truncated for a given DNS name and type, specify the value of NextRecordIdentifier
	// from the previous response to get the next resource record set that has the
	// current DNS name and type.
	StartRecordIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The first name in the lexicographic ordering of resource record sets that
	// you want to list. If the specified record name doesn't exist, the results
	// begin with the first resource record set that has a name greater than the
	// value of name.
	StartRecordName *string `location:"querystring" locationName:"name" type:"string"`

	// The type of resource record set to begin the record listing from.
	//
	// Valid values for basic resource record sets: A | AAAA | CAA | CNAME | MX
	// | NAPTR | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geolocation, and failover resource record sets:
	// A | AAAA | CAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT
	//
	// Values for alias resource record sets:
	//
	//    * API Gateway custom regional API or edge-optimized API: A
	//
	//    * CloudFront distribution: A or AAAA
	//
	//    * Elastic Beanstalk environment that has a regionalized subdomain: A
	//
	//    * Elastic Load Balancing load balancer: A | AAAA
	//
	//    * S3 bucket: A
	//
	//    * VPC interface VPC endpoint: A
	//
	//    * Another resource record set in this hosted zone: The type of the resource
	//    record set that the alias references.
	//
	// Constraint: Specifying type without specifying name returns an InvalidInput
	// error.
	StartRecordType *string `location:"querystring" locationName:"type" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceRecordSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceRecordSetsInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}
	if s.StartRecordIdentifier != nil && len(*s.StartRecordIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartRecordIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListResourceRecordSetsInput) SetHostedZoneId(v string) *ListResourceRecordSetsInput {
	s.HostedZoneId = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListResourceRecordSetsInput) SetMaxItems(v string) *ListResourceRecordSetsInput {
	s.MaxItems = &v
	return s
}

// SetStartRecordIdentifier sets the StartRecordIdentifier field's value.
func (s *ListResourceRecordSetsInput) SetStartRecordIdentifier(v string) *ListResourceRecordSetsInput {
	s.StartRecordIdentifier = &v
	return s
}

// SetStartRecordName sets the StartRecordName field's value.
func (s *ListResourceRecordSetsInput) SetStartRecordName(v string) *ListResourceRecordSetsInput {
	s.StartRecordName = &v
	return s
}

// SetStartRecordType sets the StartRecordType field's value.
func (s *ListResourceRecordSetsInput) SetStartRecordType(v string) *ListResourceRecordSetsInput {
	s.StartRecordType = &v
	return s
}

// A complex type that contains list information for the resource record set.
type ListResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more resource record sets remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// by using the NextRecordName element.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// Resource record sets that have a routing policy other than simple: If results
	// were truncated for a given DNS name and type, the value of SetIdentifier
	// for the next resource record set that has the current DNS name and type.
	//
	// For information about routing policies, see Choosing a Routing Policy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html)
	// in the Amazon Route 53 Developer Guide.
	NextRecordIdentifier *string `min:"1" type:"string"`

	// If the results were truncated, the name of the next record in the list.
	//
	// This element is present only if IsTruncated is true.
	NextRecordName *string `type:"string"`

	// If the results were truncated, the type of the next record in the list.
	//
	// This element is present only if IsTruncated is true.
	NextRecordType *string `type:"string" enum:"RRType"`

	// Information about multiple resource record sets.
	//
	// ResourceRecordSets is a required field
	ResourceRecordSets []*ResourceRecordSet `locationNameList:"ResourceRecordSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListResourceRecordSetsOutput) SetIsTruncated(v bool) *ListResourceRecordSetsOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListResourceRecordSetsOutput) SetMaxItems(v string) *ListResourceRecordSetsOutput {
	s.MaxItems = &v
	return s
}

// SetNextRecordIdentifier sets the NextRecordIdentifier field's value.
func (s *ListResourceRecordSetsOutput) SetNextRecordIdentifier(v string) *ListResourceRecordSetsOutput {
	s.NextRecordIdentifier = &v
	return s
}

// SetNextRecordName sets the NextRecordName field's value.
func (s *ListResourceRecordSetsOutput) SetNextRecordName(v string) *ListResourceRecordSetsOutput {
	s.NextRecordName = &v
	return s
}

// SetNextRecordType sets the NextRecordType field's value.
func (s *ListResourceRecordSetsOutput) SetNextRecordType(v string) *ListResourceRecordSetsOutput {
	s.NextRecordType = &v
	return s
}

// SetResourceRecordSets sets the ResourceRecordSets field's value.
func (s *ListResourceRecordSetsOutput) SetResourceRecordSets(v []*ResourceRecordSet) *ListResourceRecordSetsOutput {
	s.ResourceRecordSets = v
	return s
}

// A request to get a list of the reusable delegation sets that are associated
// with the current account.
type ListReusableDelegationSetsInput struct {
	_ struct{} `locationName:"ListReusableDelegationSetsRequest" type:"structure"`

	// If the value of IsTruncated in the previous response was true, you have more
	// reusable delegation sets. To get another group, submit another ListReusableDelegationSets
	// request.
	//
	// For the value of marker, specify the value of NextMarker from the previous
	// response, which is the ID of the first reusable delegation set that Amazon
	// Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more reusable delegation sets to get.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The number of reusable delegation sets that you want Amazon Route 53 to return
	// in the response to this request. If you specify a value greater than 100,
	// Route 53 returns only the first 100 reusable delegation sets.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListReusableDelegationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListReusableDelegationSetsInput) SetMarker(v string) *ListReusableDelegationSetsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListReusableDelegationSetsInput) SetMaxItems(v string) *ListReusableDelegationSetsInput {
	s.MaxItems = &v
	return s
}

// A complex type that contains information about the reusable delegation sets
// that are associated with the current account.
type ListReusableDelegationSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one DelegationSet element for each reusable
	// delegation set that was created by the current account.
	//
	// DelegationSets is a required field
	DelegationSets []*DelegationSet `locationNameList:"DelegationSet" type:"list" required:"true"`

	// A flag that indicates whether there are more reusable delegation sets to
	// be listed.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListReusableDelegationSets, Marker
	// is the value that you specified for the marker parameter in the request that
	// produced the current response.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListReusableDelegationSets
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the next reusable
	// delegation set that Amazon Route 53 will return if you submit another ListReusableDelegationSets
	// request and specify the value of NextMarker in the marker parameter.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListReusableDelegationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsOutput) GoString() string {
	return s.String()
}

// SetDelegationSets sets the DelegationSets field's value.
func (s *ListReusableDelegationSetsOutput) SetDelegationSets(v []*DelegationSet) *ListReusableDelegationSetsOutput {
	s.DelegationSets = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListReusableDelegationSetsOutput) SetIsTruncated(v bool) *ListReusableDelegationSetsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListReusableDelegationSetsOutput) SetMarker(v string) *ListReusableDelegationSetsOutput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListReusableDelegationSetsOutput) SetMaxItems(v string) *ListReusableDelegationSetsOutput {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListReusableDelegationSetsOutput) SetNextMarker(v string) *ListReusableDelegationSetsOutput {
	s.NextMarker = &v
	return s
}

// A complex type containing information about a request for a list of the tags
// that are associated with an individual resource.
type ListTagsForResourceInput struct {
	_ struct{} `locationName:"ListTagsForResourceRequest" type:"structure"`

	// The ID of the resource for which you want to retrieve tags.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ListTagsForResourceInput) SetResourceId(v string) *ListTagsForResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListTagsForResourceInput) SetResourceType(v string) *ListTagsForResourceInput {
	s.ResourceType = &v
	return s
}

// A complex type that contains information about the health checks or hosted
// zones for which you want to list tags.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A ResourceTagSet containing tags associated with the specified resource.
	//
	// ResourceTagSet is a required field
	ResourceTagSet *ResourceTagSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceTagSet sets the ResourceTagSet field's value.
func (s *ListTagsForResourceOutput) SetResourceTagSet(v *ResourceTagSet) *ListTagsForResourceOutput {
	s.ResourceTagSet = v
	return s
}

// A complex type that contains information about the health checks or hosted
// zones for which you want to list tags.
type ListTagsForResourcesInput struct {
	_ struct{} `locationName:"ListTagsForResourcesRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains the ResourceId element for each resource for
	// which you want to get a list of tags.
	//
	// ResourceIds is a required field
	ResourceIds []*string `locationNameList:"ResourceId" min:"1" type:"list" required:"true"`

	// The type of the resources.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ListTagsForResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourcesInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ListTagsForResourcesInput) SetResourceIds(v []*string) *ListTagsForResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListTagsForResourcesInput) SetResourceType(v string) *ListTagsForResourcesInput {
	s.ResourceType = &v
	return s
}

// A complex type containing tags for the specified resources.
type ListTagsForResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ResourceTagSets containing tags associated with the specified resources.
	//
	// ResourceTagSets is a required field
	ResourceTagSets []*ResourceTagSet `locationNameList:"ResourceTagSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesOutput) GoString() string {
	return s.String()
}

// SetResourceTagSets sets the ResourceTagSets field's value.
func (s *ListTagsForResourcesOutput) SetResourceTagSets(v []*ResourceTagSet) *ListTagsForResourcesOutput {
	s.ResourceTagSets = v
	return s
}

// A complex type that contains the information about the request to list the
// traffic policies that are associated with the current account.
type ListTrafficPoliciesInput struct {
	_ struct{} `locationName:"ListTrafficPoliciesRequest" type:"structure"`

	// (Optional) The maximum number of traffic policies that you want Amazon Route
	// 53 to return in response to this request. If you have more than MaxItems
	// traffic policies, the value of IsTruncated in the response is true, and the
	// value of TrafficPolicyIdMarker is the ID of the first traffic policy that
	// Route 53 will return if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// (Conditional) For your first request to ListTrafficPolicies, don't include
	// the TrafficPolicyIdMarker parameter.
	//
	// If you have more traffic policies than the value of MaxItems, ListTrafficPolicies
	// returns only the first MaxItems traffic policies. To get the next group of
	// policies, submit another request to ListTrafficPolicies. For the value of
	// TrafficPolicyIdMarker, specify the value of TrafficPolicyIdMarker that was
	// returned in the previous response.
	TrafficPolicyIdMarker *string `location:"querystring" locationName:"trafficpolicyid" min:"1" type:"string"`
}

// String returns the string representation
func (s ListTrafficPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPoliciesInput"}
	if s.TrafficPolicyIdMarker != nil && len(*s.TrafficPolicyIdMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyIdMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPoliciesInput) SetMaxItems(v string) *ListTrafficPoliciesInput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyIdMarker sets the TrafficPolicyIdMarker field's value.
func (s *ListTrafficPoliciesInput) SetTrafficPolicyIdMarker(v string) *ListTrafficPoliciesInput {
	s.TrafficPolicyIdMarker = &v
	return s
}

// A complex type that contains the response information for the request.
type ListTrafficPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policies to be listed.
	// If the response was truncated, you can get the next group of traffic policies
	// by submitting another ListTrafficPolicies request and specifying the value
	// of TrafficPolicyIdMarker in the TrafficPolicyIdMarker request parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the ListTrafficPolicies
	// request that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If the value of IsTruncated is true, TrafficPolicyIdMarker is the ID of the
	// first traffic policy in the next group of MaxItems traffic policies.
	//
	// TrafficPolicyIdMarker is a required field
	TrafficPolicyIdMarker *string `min:"1" type:"string" required:"true"`

	// A list that contains one TrafficPolicySummary element for each traffic policy
	// that was created by the current account.
	//
	// TrafficPolicySummaries is a required field
	TrafficPolicySummaries []*TrafficPolicySummary `locationNameList:"TrafficPolicySummary" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPoliciesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListTrafficPoliciesOutput) SetIsTruncated(v bool) *ListTrafficPoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPoliciesOutput) SetMaxItems(v string) *ListTrafficPoliciesOutput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyIdMarker sets the TrafficPolicyIdMarker field's value.
func (s *ListTrafficPoliciesOutput) SetTrafficPolicyIdMarker(v string) *ListTrafficPoliciesOutput {
	s.TrafficPolicyIdMarker = &v
	return s
}

// SetTrafficPolicySummaries sets the TrafficPolicySummaries field's value.
func (s *ListTrafficPoliciesOutput) SetTrafficPolicySummaries(v []*TrafficPolicySummary) *ListTrafficPoliciesOutput {
	s.TrafficPolicySummaries = v
	return s
}

// A request for the traffic policy instances that you created in a specified
// hosted zone.
type ListTrafficPolicyInstancesByHostedZoneInput struct {
	_ struct{} `locationName:"ListTrafficPolicyInstancesByHostedZoneRequest" type:"structure"`

	// The ID of the hosted zone that you want to list traffic policy instances
	// for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance that Amazon Route 53 will return
	// if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// If the value of IsTruncated in the previous response is true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of trafficpolicyinstancename,
	// specify the value of TrafficPolicyInstanceNameMarker from the previous response,
	// which is the name of the first traffic policy instance in the next group
	// of traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// If the value of IsTruncated in the previous response is true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of trafficpolicyinstancetype,
	// specify the value of TrafficPolicyInstanceTypeMarker from the previous response,
	// which is the type of the first traffic policy instance in the next group
	// of traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPolicyInstancesByHostedZoneInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) SetHostedZoneId(v string) *ListTrafficPolicyInstancesByHostedZoneInput {
	s.HostedZoneId = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) SetMaxItems(v string) *ListTrafficPolicyInstancesByHostedZoneInput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyInstanceNameMarker sets the TrafficPolicyInstanceNameMarker field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) SetTrafficPolicyInstanceNameMarker(v string) *ListTrafficPolicyInstancesByHostedZoneInput {
	s.TrafficPolicyInstanceNameMarker = &v
	return s
}

// SetTrafficPolicyInstanceTypeMarker sets the TrafficPolicyInstanceTypeMarker field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) SetTrafficPolicyInstanceTypeMarker(v string) *ListTrafficPolicyInstancesByHostedZoneInput {
	s.TrafficPolicyInstanceTypeMarker = &v
	return s
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of traffic
	// policy instances by submitting another ListTrafficPolicyInstancesByHostedZone
	// request and specifying the values of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker in the corresponding request parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the ListTrafficPolicyInstancesByHostedZone
	// request that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of traffic policy instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneOutput) SetIsTruncated(v bool) *ListTrafficPolicyInstancesByHostedZoneOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneOutput) SetMaxItems(v string) *ListTrafficPolicyInstancesByHostedZoneOutput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyInstanceNameMarker sets the TrafficPolicyInstanceNameMarker field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneOutput) SetTrafficPolicyInstanceNameMarker(v string) *ListTrafficPolicyInstancesByHostedZoneOutput {
	s.TrafficPolicyInstanceNameMarker = &v
	return s
}

// SetTrafficPolicyInstanceTypeMarker sets the TrafficPolicyInstanceTypeMarker field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneOutput) SetTrafficPolicyInstanceTypeMarker(v string) *ListTrafficPolicyInstancesByHostedZoneOutput {
	s.TrafficPolicyInstanceTypeMarker = &v
	return s
}

// SetTrafficPolicyInstances sets the TrafficPolicyInstances field's value.
func (s *ListTrafficPolicyInstancesByHostedZoneOutput) SetTrafficPolicyInstances(v []*TrafficPolicyInstance) *ListTrafficPolicyInstancesByHostedZoneOutput {
	s.TrafficPolicyInstances = v
	return s
}

// A complex type that contains the information about the request to list your
// traffic policy instances.
type ListTrafficPolicyInstancesByPolicyInput struct {
	_ struct{} `locationName:"ListTrafficPolicyInstancesByPolicyRequest" type:"structure"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstancesByPolicy request.
	//
	// For the value of hostedzoneid, specify the value of HostedZoneIdMarker from
	// the previous response, which is the hosted zone ID of the first traffic policy
	// instance that Amazon Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance that Amazon Route 53 will return
	// if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The ID of the traffic policy for which you want to list traffic policy instances.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `location:"querystring" locationName:"id" min:"1" type:"string" required:"true"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstancesByPolicy request.
	//
	// For the value of trafficpolicyinstancename, specify the value of TrafficPolicyInstanceNameMarker
	// from the previous response, which is the name of the first traffic policy
	// instance that Amazon Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstancesByPolicy request.
	//
	// For the value of trafficpolicyinstancetype, specify the value of TrafficPolicyInstanceTypeMarker
	// from the previous response, which is the name of the first traffic policy
	// instance that Amazon Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`

	// The version of the traffic policy for which you want to list traffic policy
	// instances. The version must be associated with the traffic policy that is
	// specified by TrafficPolicyId.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `location:"querystring" locationName:"version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyInstancesByPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPolicyInstancesByPolicyInput"}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}
	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneIdMarker sets the HostedZoneIdMarker field's value.
func (s *ListTrafficPolicyInstancesByPolicyInput) SetHostedZoneIdMarker(v string) *ListTrafficPolicyInstancesByPolicyInput {
	s.HostedZoneIdMarker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyInstancesByPolicyInput) SetMaxItems(v string) *ListTrafficPolicyInstancesByPolicyInput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *ListTrafficPolicyInstancesByPolicyInput) SetTrafficPolicyId(v string) *ListTrafficPolicyInstancesByPolicyInput {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyInstanceNameMarker sets the TrafficPolicyInstanceNameMarker field's value.
func (s *ListTrafficPolicyInstancesByPolicyInput) SetTrafficPolicyInstanceNameMarker(v string) *ListTrafficPolicyInstancesByPolicyInput {
	s.TrafficPolicyInstanceNameMarker = &v
	return s
}

// SetTrafficPolicyInstanceTypeMarker sets the TrafficPolicyInstanceTypeMarker field's value.
func (s *ListTrafficPolicyInstancesByPolicyInput) SetTrafficPolicyInstanceTypeMarker(v string) *ListTrafficPolicyInstancesByPolicyInput {
	s.TrafficPolicyInstanceTypeMarker = &v
	return s
}

// SetTrafficPolicyVersion sets the TrafficPolicyVersion field's value.
func (s *ListTrafficPolicyInstancesByPolicyInput) SetTrafficPolicyVersion(v int64) *ListTrafficPolicyInstancesByPolicyInput {
	s.TrafficPolicyVersion = &v
	return s
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance in the next group of traffic policy instances.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of traffic
	// policy instances by calling ListTrafficPolicyInstancesByPolicy again and
	// specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstancesByPolicy
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) GoString() string {
	return s.String()
}

// SetHostedZoneIdMarker sets the HostedZoneIdMarker field's value.
func (s *ListTrafficPolicyInstancesByPolicyOutput) SetHostedZoneIdMarker(v string) *ListTrafficPolicyInstancesByPolicyOutput {
	s.HostedZoneIdMarker = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListTrafficPolicyInstancesByPolicyOutput) SetIsTruncated(v bool) *ListTrafficPolicyInstancesByPolicyOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyInstancesByPolicyOutput) SetMaxItems(v string) *ListTrafficPolicyInstancesByPolicyOutput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyInstanceNameMarker sets the TrafficPolicyInstanceNameMarker field's value.
func (s *ListTrafficPolicyInstancesByPolicyOutput) SetTrafficPolicyInstanceNameMarker(v string) *ListTrafficPolicyInstancesByPolicyOutput {
	s.TrafficPolicyInstanceNameMarker = &v
	return s
}

// SetTrafficPolicyInstanceTypeMarker sets the TrafficPolicyInstanceTypeMarker field's value.
func (s *ListTrafficPolicyInstancesByPolicyOutput) SetTrafficPolicyInstanceTypeMarker(v string) *ListTrafficPolicyInstancesByPolicyOutput {
	s.TrafficPolicyInstanceTypeMarker = &v
	return s
}

// SetTrafficPolicyInstances sets the TrafficPolicyInstances field's value.
func (s *ListTrafficPolicyInstancesByPolicyOutput) SetTrafficPolicyInstances(v []*TrafficPolicyInstance) *ListTrafficPolicyInstancesByPolicyOutput {
	s.TrafficPolicyInstances = v
	return s
}

// A request to get information about the traffic policy instances that you
// created by using the current account.
type ListTrafficPolicyInstancesInput struct {
	_ struct{} `locationName:"ListTrafficPolicyInstancesRequest" type:"structure"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of HostedZoneId, specify
	// the value of HostedZoneIdMarker from the previous response, which is the
	// hosted zone ID of the first traffic policy instance in the next group of
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances that you want Amazon Route
	// 53 to return in response to a ListTrafficPolicyInstances request. If you
	// have more than MaxItems traffic policy instances, the value of the IsTruncated
	// element in the response is true, and the values of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker represent the first traffic policy instance
	// in the next group of MaxItems traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of trafficpolicyinstancename,
	// specify the value of TrafficPolicyInstanceNameMarker from the previous response,
	// which is the name of the first traffic policy instance in the next group
	// of traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of trafficpolicyinstancetype,
	// specify the value of TrafficPolicyInstanceTypeMarker from the previous response,
	// which is the type of the first traffic policy instance in the next group
	// of traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesInput) GoString() string {
	return s.String()
}

// SetHostedZoneIdMarker sets the HostedZoneIdMarker field's value.
func (s *ListTrafficPolicyInstancesInput) SetHostedZoneIdMarker(v string) *ListTrafficPolicyInstancesInput {
	s.HostedZoneIdMarker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyInstancesInput) SetMaxItems(v string) *ListTrafficPolicyInstancesInput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyInstanceNameMarker sets the TrafficPolicyInstanceNameMarker field's value.
func (s *ListTrafficPolicyInstancesInput) SetTrafficPolicyInstanceNameMarker(v string) *ListTrafficPolicyInstancesInput {
	s.TrafficPolicyInstanceNameMarker = &v
	return s
}

// SetTrafficPolicyInstanceTypeMarker sets the TrafficPolicyInstanceTypeMarker field's value.
func (s *ListTrafficPolicyInstancesInput) SetTrafficPolicyInstanceTypeMarker(v string) *ListTrafficPolicyInstancesInput {
	s.TrafficPolicyInstanceTypeMarker = &v
	return s
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance that Route 53 will return if you submit
	// another ListTrafficPolicyInstances request.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get more traffic policy
	// instances by calling ListTrafficPolicyInstances again and specifying the
	// values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// in the corresponding request parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstances
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance that Route 53 will return if you submit another
	// ListTrafficPolicyInstances request.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance that Amazon Route 53 will return if you submit another ListTrafficPolicyInstances
	// request.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesOutput) GoString() string {
	return s.String()
}

// SetHostedZoneIdMarker sets the HostedZoneIdMarker field's value.
func (s *ListTrafficPolicyInstancesOutput) SetHostedZoneIdMarker(v string) *ListTrafficPolicyInstancesOutput {
	s.HostedZoneIdMarker = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListTrafficPolicyInstancesOutput) SetIsTruncated(v bool) *ListTrafficPolicyInstancesOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyInstancesOutput) SetMaxItems(v string) *ListTrafficPolicyInstancesOutput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyInstanceNameMarker sets the TrafficPolicyInstanceNameMarker field's value.
func (s *ListTrafficPolicyInstancesOutput) SetTrafficPolicyInstanceNameMarker(v string) *ListTrafficPolicyInstancesOutput {
	s.TrafficPolicyInstanceNameMarker = &v
	return s
}

// SetTrafficPolicyInstanceTypeMarker sets the TrafficPolicyInstanceTypeMarker field's value.
func (s *ListTrafficPolicyInstancesOutput) SetTrafficPolicyInstanceTypeMarker(v string) *ListTrafficPolicyInstancesOutput {
	s.TrafficPolicyInstanceTypeMarker = &v
	return s
}

// SetTrafficPolicyInstances sets the TrafficPolicyInstances field's value.
func (s *ListTrafficPolicyInstancesOutput) SetTrafficPolicyInstances(v []*TrafficPolicyInstance) *ListTrafficPolicyInstancesOutput {
	s.TrafficPolicyInstances = v
	return s
}

// A complex type that contains the information about the request to list your
// traffic policies.
type ListTrafficPolicyVersionsInput struct {
	_ struct{} `locationName:"ListTrafficPolicyVersionsRequest" type:"structure"`

	// Specify the value of Id of the traffic policy for which you want to list
	// all versions.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`

	// The maximum number of traffic policy versions that you want Amazon Route
	// 53 to include in the response body for this request. If the specified traffic
	// policy has more than MaxItems versions, the value of IsTruncated in the response
	// is true, and the value of the TrafficPolicyVersionMarker element is the ID
	// of the first version that Route 53 will return if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For your first request to ListTrafficPolicyVersions, don't include the TrafficPolicyVersionMarker
	// parameter.
	//
	// If you have more traffic policy versions than the value of MaxItems, ListTrafficPolicyVersions
	// returns only the first group of MaxItems versions. To get more traffic policy
	// versions, submit another ListTrafficPolicyVersions request. For the value
	// of TrafficPolicyVersionMarker, specify the value of TrafficPolicyVersionMarker
	// in the previous response.
	TrafficPolicyVersionMarker *string `location:"querystring" locationName:"trafficpolicyversion" type:"string"`
}

// String returns the string representation
func (s ListTrafficPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPolicyVersionsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ListTrafficPolicyVersionsInput) SetId(v string) *ListTrafficPolicyVersionsInput {
	s.Id = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyVersionsInput) SetMaxItems(v string) *ListTrafficPolicyVersionsInput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicyVersionMarker sets the TrafficPolicyVersionMarker field's value.
func (s *ListTrafficPolicyVersionsInput) SetTrafficPolicyVersionMarker(v string) *ListTrafficPolicyVersionsInput {
	s.TrafficPolicyVersionMarker = &v
	return s
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policies to be listed.
	// If the response was truncated, you can get the next group of traffic policies
	// by submitting another ListTrafficPolicyVersions request and specifying the
	// value of NextMarker in the marker parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the maxitems parameter in the ListTrafficPolicyVersions
	// request that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// A list that contains one TrafficPolicy element for each traffic policy version
	// that is associated with the specified traffic policy.
	//
	// TrafficPolicies is a required field
	TrafficPolicies []*TrafficPolicy `locationNameList:"TrafficPolicy" type:"list" required:"true"`

	// If IsTruncated is true, the value of TrafficPolicyVersionMarker identifies
	// the first traffic policy that Amazon Route 53 will return if you submit another
	// request. Call ListTrafficPolicyVersions again and specify the value of TrafficPolicyVersionMarker
	// in the TrafficPolicyVersionMarker request parameter.
	//
	// This element is present only if IsTruncated is true.
	//
	// TrafficPolicyVersionMarker is a required field
	TrafficPolicyVersionMarker *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyVersionsOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListTrafficPolicyVersionsOutput) SetIsTruncated(v bool) *ListTrafficPolicyVersionsOutput {
	s.IsTruncated = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTrafficPolicyVersionsOutput) SetMaxItems(v string) *ListTrafficPolicyVersionsOutput {
	s.MaxItems = &v
	return s
}

// SetTrafficPolicies sets the TrafficPolicies field's value.
func (s *ListTrafficPolicyVersionsOutput) SetTrafficPolicies(v []*TrafficPolicy) *ListTrafficPolicyVersionsOutput {
	s.TrafficPolicies = v
	return s
}

// SetTrafficPolicyVersionMarker sets the TrafficPolicyVersionMarker field's value.
func (s *ListTrafficPolicyVersionsOutput) SetTrafficPolicyVersionMarker(v string) *ListTrafficPolicyVersionsOutput {
	s.TrafficPolicyVersionMarker = &v
	return s
}

// A complex type that contains information about that can be associated with
// your hosted zone.
type ListVPCAssociationAuthorizationsInput struct {
	_ struct{} `locationName:"ListVPCAssociationAuthorizationsRequest" type:"structure"`

	// The ID of the hosted zone for which you want a list of VPCs that can be associated
	// with the hosted zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// Optional: An integer that specifies the maximum number of VPCs that you want
	// Amazon Route 53 to return. If you don't specify a value for MaxResults, Route
	// 53 returns up to 50 VPCs per page.
	MaxResults *string `location:"querystring" locationName:"maxresults" type:"string"`

	// Optional: If a response includes a NextToken element, there are more VPCs
	// that can be associated with the specified hosted zone. To get the next page
	// of results, submit another request, and include the value of NextToken from
	// the response in the nexttoken parameter in another ListVPCAssociationAuthorizations
	// request.
	NextToken *string `location:"querystring" locationName:"nexttoken" type:"string"`
}

// String returns the string representation
func (s ListVPCAssociationAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVPCAssociationAuthorizationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVPCAssociationAuthorizationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVPCAssociationAuthorizationsInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.HostedZoneId != nil && len(*s.HostedZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostedZoneId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListVPCAssociationAuthorizationsInput) SetHostedZoneId(v string) *ListVPCAssociationAuthorizationsInput {
	s.HostedZoneId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVPCAssociationAuthorizationsInput) SetMaxResults(v string) *ListVPCAssociationAuthorizationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVPCAssociationAuthorizationsInput) SetNextToken(v string) *ListVPCAssociationAuthorizationsInput {
	s.NextToken = &v
	return s
}

// A complex type that contains the response information for the request.
type ListVPCAssociationAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that you can associate the listed VPCs with.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// When the response includes a NextToken element, there are more VPCs that
	// can be associated with the specified hosted zone. To get the next page of
	// VPCs, submit another ListVPCAssociationAuthorizations request, and include
	// the value of the NextToken element from the response in the nexttoken request
	// parameter.
	NextToken *string `type:"string"`

	// The list of VPCs that are authorized to be associated with the specified
	// hosted zone.
	//
	// VPCs is a required field
	VPCs []*VPC `locationNameList:"VPC" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ListVPCAssociationAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVPCAssociationAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *ListVPCAssociationAuthorizationsOutput) SetHostedZoneId(v string) *ListVPCAssociationAuthorizationsOutput {
	s.HostedZoneId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVPCAssociationAuthorizationsOutput) SetNextToken(v string) *ListVPCAssociationAuthorizationsOutput {
	s.NextToken = &v
	return s
}

// SetVPCs sets the VPCs field's value.
func (s *ListVPCAssociationAuthorizationsOutput) SetVPCs(v []*VPC) *ListVPCAssociationAuthorizationsOutput {
	s.VPCs = v
	return s
}

// A complex type that contains information about a configuration for DNS query
// logging.
type QueryLoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon
	// Route 53 is publishing logs to.
	//
	// CloudWatchLogsLogGroupArn is a required field
	CloudWatchLogsLogGroupArn *string `type:"string" required:"true"`

	// The ID of the hosted zone that CloudWatch Logs is logging queries for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The ID for a configuration for DNS query logging.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s QueryLoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryLoggingConfig) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *QueryLoggingConfig) SetCloudWatchLogsLogGroupArn(v string) *QueryLoggingConfig {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *QueryLoggingConfig) SetHostedZoneId(v string) *QueryLoggingConfig {
	s.HostedZoneId = &v
	return s
}

// SetId sets the Id field's value.
func (s *QueryLoggingConfig) SetId(v string) *QueryLoggingConfig {
	s.Id = &v
	return s
}

// Information specific to the resource record.
//
// If you're creating an alias resource record set, omit ResourceRecord.
type ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The current or new DNS record value, not to exceed 4,000 characters. In the
	// case of a DELETE action, if the current value does not match the actual value,
	// an error is returned. For descriptions about how to format Value for different
	// record types, see Supported DNS Resource Record Types (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can specify more than one value for all record types except CNAME and
	// SOA.
	//
	// If you're creating an alias resource record set, omit Value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecord) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRecord) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceRecord"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *ResourceRecord) SetValue(v string) *ResourceRecord {
	s.Value = &v
	return s
}

// Information about the resource record set to create or delete.
type ResourceRecordSet struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: Information about the Amazon Web Services
	// resource, such as a CloudFront distribution or an Amazon S3 bucket, that
	// you want to route traffic to.
	//
	// If you're creating resource records sets for a private hosted zone, note
	// the following:
	//
	//    * You can't create an alias resource record set in a private hosted zone
	//    to route traffic to a CloudFront distribution.
	//
	//    * Creating geolocation alias resource record sets or latency alias resource
	//    record sets in a private hosted zone is unsupported.
	//
	//    * For information about creating failover resource record sets in a private
	//    hosted zone, see Configuring Failover in a Private Hosted Zone (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	//    in the Amazon Route 53 Developer Guide.
	AliasTarget *AliasTarget `type:"structure"`

	// Failover resource record sets only: To configure failover, you add the Failover
	// element to two resource record sets. For one resource record set, you specify
	// PRIMARY as the value for Failover; for the other resource record set, you
	// specify SECONDARY. In addition, you include the HealthCheckId element and
	// specify the health check that you want Amazon Route 53 to perform for each
	// resource record set.
	//
	// Except where noted, the following failover behaviors assume that you have
	// included the HealthCheckId element in both resource record sets:
	//
	//    * When the primary resource record set is healthy, Route 53 responds to
	//    DNS queries with the applicable value from the primary resource record
	//    set regardless of the health of the secondary resource record set.
	//
	//    * When the primary resource record set is unhealthy and the secondary
	//    resource record set is healthy, Route 53 responds to DNS queries with
	//    the applicable value from the secondary resource record set.
	//
	//    * When the secondary resource record set is unhealthy, Route 53 responds
	//    to DNS queries with the applicable value from the primary resource record
	//    set regardless of the health of the primary resource record set.
	//
	//    * If you omit the HealthCheckId element for the secondary resource record
	//    set, and if the primary resource record set is unhealthy, Route 53 always
	//    responds to DNS queries with the applicable value from the secondary resource
	//    record set. This is true regardless of the health of the associated endpoint.
	//
	// You can't create non-failover resource record sets that have the same values
	// for the Name and Type elements as failover resource record sets.
	//
	// For failover alias resource record sets, you must also include the EvaluateTargetHealth
	// element and set the value to true.
	//
	// For more information about configuring failover for Route 53, see the following
	// topics in the Amazon Route 53 Developer Guide:
	//
	//    * Route 53 Health Checks and DNS Failover (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	//
	//    * Configuring Failover in a Private Hosted Zone (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	Failover *string `type:"string" enum:"ResourceRecordSetFailover"`

	// Geolocation resource record sets only: A complex type that lets you control
	// how Amazon Route 53 responds to DNS queries based on the geographic origin
	// of the query. For example, if you want all queries from Africa to be routed
	// to a web server with an IP address of 192.0.2.111, create a resource record
	// set with a Type of A and a ContinentCode of AF.
	//
	// Although creating geolocation and geolocation alias resource record sets
	// in a private hosted zone is allowed, it's not supported.
	//
	// If you create separate resource record sets for overlapping geographic regions
	// (for example, one resource record set for a continent and one for a country
	// on the same continent), priority goes to the smallest geographic region.
	// This allows you to route most queries for a continent to one resource and
	// to route queries for a country on that continent to a different resource.
	//
	// You can't create two geolocation resource record sets that specify the same
	// geographic location.
	//
	// The value * in the CountryCode element matches all geographic locations that
	// aren't specified in other geolocation resource record sets that have the
	// same values for the Name and Type elements.
	//
	// Geolocation works by mapping IP addresses to locations. However, some IP
	// addresses aren't mapped to geographic locations, so even if you create geolocation
	// resource record sets that cover all seven continents, Route 53 will receive
	// some DNS queries from locations that it can't identify. We recommend that
	// you create a resource record set for which the value of CountryCode is *.
	// Two groups of queries are routed to the resource that you specify in this
	// record: queries that come from locations for which you haven't created geolocation
	// resource record sets and queries from IP addresses that aren't mapped to
	// a location. If you don't create a * resource record set, Route 53 returns
	// a "no answer" response for queries from those locations.
	//
	// You can't create non-geolocation resource record sets that have the same
	// values for the Name and Type elements as geolocation resource record sets.
	GeoLocation *GeoLocation `type:"structure"`

	// If you want Amazon Route 53 to return this resource record set in response
	// to a DNS query only when the status of a health check is healthy, include
	// the HealthCheckId element and specify the ID of the applicable health check.
	//
	// Route 53 determines whether a resource record set is healthy based on one
	// of the following:
	//
	//    * By periodically sending a request to the endpoint that is specified
	//    in the health check
	//
	//    * By aggregating the status of a specified group of health checks (calculated
	//    health checks)
	//
	//    * By determining the current state of a CloudWatch alarm (CloudWatch metric
	//    health checks)
	//
	// Route 53 doesn't check the health of the endpoint that is specified in the
	// resource record set, for example, the endpoint specified by the IP address
	// in the Value element. When you add a HealthCheckId element to a resource
	// record set, Route 53 checks the health of the endpoint that you specified
	// in the health check.
	//
	// For more information, see the following topics in the Amazon Route 53 Developer
	// Guide:
	//
	//    * How Amazon Route 53 Determines Whether an Endpoint Is Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	//
	//    * Route 53 Health Checks and DNS Failover (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	//
	//    * Configuring Failover in a Private Hosted Zone (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	//
	// When to Specify HealthCheckId
	//
	// Specifying a value for HealthCheckId is useful only when Route 53 is choosing
	// between two or more resource record sets to respond to a DNS query, and you
	// want Route 53 to base the choice in part on the status of a health check.
	// Configuring health checks makes sense only in the following configurations:
	//
	//    * Non-alias resource record sets: You're checking the health of a group
	//    of non-alias resource record sets that have the same routing policy, name,
	//    and type (such as multiple weighted records named www.example.com with
	//    a type of A) and you specify health check IDs for all the resource record
	//    sets. If the health check status for a resource record set is healthy,
	//    Route 53 includes the record among the records that it responds to DNS
	//    queries with. If the health check status for a resource record set is
	//    unhealthy, Route 53 stops responding to DNS queries using the value for
	//    that resource record set. If the health check status for all resource
	//    record sets in the group is unhealthy, Route 53 considers all resource
	//    record sets in the group healthy and responds to DNS queries accordingly.
	//
	//    * Alias resource record sets: You specify the following settings: You
	//    set EvaluateTargetHealth to true for an alias resource record set in a
	//    group of resource record sets that have the same routing policy, name,
	//    and type (such as multiple weighted records named www.example.com with
	//    a type of A). You configure the alias resource record set to route traffic
	//    to a non-alias resource record set in the same hosted zone. You specify
	//    a health check ID for the non-alias resource record set. If the health
	//    check status is healthy, Route 53 considers the alias resource record
	//    set to be healthy and includes the alias record among the records that
	//    it responds to DNS queries with. If the health check status is unhealthy,
	//    Route 53 stops responding to DNS queries using the alias resource record
	//    set. The alias resource record set can also route traffic to a group of
	//    non-alias resource record sets that have the same routing policy, name,
	//    and type. In that configuration, associate health checks with all of the
	//    resource record sets in the group of non-alias resource record sets.
	//
	// Geolocation Routing
	//
	// For geolocation resource record sets, if an endpoint is unhealthy, Route
	// 53 looks for a resource record set for the larger, associated geographic
	// region. For example, suppose you have resource record sets for a state in
	// the United States, for the entire United States, for North America, and a
	// resource record set that has * for CountryCode is *, which applies to all
	// locations. If the endpoint for the state resource record set is unhealthy,
	// Route 53 checks for healthy resource record sets in the following order until
	// it finds a resource record set for which the endpoint is healthy:
	//
	//    * The United States
	//
	//    * North America
	//
	//    * The default resource record set
	//
	// Specifying the Health Check Endpoint by Domain Name
	//
	// If your health checks specify the endpoint only by domain name, we recommend
	// that you create a separate health check for each endpoint. For example, create
	// a health check for each HTTP server that is serving content for www.example.com.
	// For the value of FullyQualifiedDomainName, specify the domain name of the
	// server (such as us-east-2-www.example.com), not the name of the resource
	// record sets (www.example.com).
	//
	// Health check results will be unpredictable if you do the following:
	//
	//    * Create a health check that has the same value for FullyQualifiedDomainName
	//    as the name of a resource record set.
	//
	//    * Associate that health check with the resource record set.
	HealthCheckId *string `type:"string"`

	// Multivalue answer resource record sets only: To route traffic approximately
	// randomly to multiple resources, such as web servers, create one multivalue
	// answer record for each resource and specify true for MultiValueAnswer. Note
	// the following:
	//
	//    * If you associate a health check with a multivalue answer resource record
	//    set, Amazon Route 53 responds to DNS queries with the corresponding IP
	//    address only when the health check is healthy.
	//
	//    * If you don't associate a health check with a multivalue answer record,
	//    Route 53 always considers the record to be healthy.
	//
	//    * Route 53 responds to DNS queries with up to eight healthy records; if
	//    you have eight or fewer healthy records, Route 53 responds to all DNS
	//    queries with all the healthy records.
	//
	//    * If you have more than eight healthy records, Route 53 responds to different
	//    DNS resolvers with different combinations of healthy records.
	//
	//    * When all records are unhealthy, Route 53 responds to DNS queries with
	//    up to eight unhealthy records.
	//
	//    * If a resource becomes unavailable after a resolver caches a response,
	//    client software typically tries another of the IP addresses in the response.
	//
	// You can't create multivalue answer alias records.
	MultiValueAnswer *bool `type:"boolean"`

	// For ChangeResourceRecordSets requests, the name of the record that you want
	// to create, update, or delete. For ListResourceRecordSets responses, the name
	// of a record in the specified hosted zone.
	//
	// ChangeResourceRecordSets Only
	//
	// Enter a fully qualified domain name, for example, www.example.com. You can
	// optionally include a trailing dot. If you omit the trailing dot, Amazon Route
	// 53 assumes that the domain name that you specify is fully qualified. This
	// means that Route 53 treats www.example.com (without a trailing dot) and www.example.com.
	// (with a trailing dot) as identical.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see DNS Domain
	// Name Format (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can use the asterisk (*) wildcard to replace the leftmost label in a
	// domain name, for example, *.example.com. Note the following:
	//
	//    * The * must replace the entire label. For example, you can't specify
	//    *prod.example.com or prod*.example.com.
	//
	//    * The * can't replace any of the middle labels, for example, marketing.*.example.com.
	//
	//    * If you include * in any position other than the leftmost label in a
	//    domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.
	//    You can't use the * wildcard for resource records sets that have a type
	//    of NS.
	//
	// You can use the * wildcard as the leftmost label in a domain name, for example,
	// *.example.com. You can't use an * for one of the middle labels, for example,
	// marketing.*.example.com. In addition, the * must replace the entire label;
	// for example, you can't specify prod*.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Latency-based resource record sets only: The Amazon EC2 Region where you
	// created the resource that this resource record set refers to. The resource
	// typically is an Amazon Web Services resource, such as an EC2 instance or
	// an ELB load balancer, and is referred to by an IP address or a DNS domain
	// name, depending on the record type.
	//
	// Although creating latency and latency alias resource record sets in a private
	// hosted zone is allowed, it's not supported.
	//
	// When Amazon Route 53 receives a DNS query for a domain name and type for
	// which you have created latency resource record sets, Route 53 selects the
	// latency resource record set that has the lowest latency between the end user
	// and the associated Amazon EC2 Region. Route 53 then returns the value that
	// is associated with the selected resource record set.
	//
	// Note the following:
	//
	//    * You can only specify one ResourceRecord per latency resource record
	//    set.
	//
	//    * You can only create one latency resource record set for each Amazon
	//    EC2 Region.
	//
	//    * You aren't required to create latency resource record sets for all Amazon
	//    EC2 Regions. Route 53 will choose the region with the best latency from
	//    among the regions that you create latency resource record sets for.
	//
	//    * You can't create non-latency resource record sets that have the same
	//    values for the Name and Type elements as latency resource record sets.
	Region *string `min:"1" type:"string" enum:"ResourceRecordSetRegion"`

	// Information about the resource records to act upon.
	//
	// If you're creating an alias resource record set, omit ResourceRecords.
	ResourceRecords []*ResourceRecord `locationNameList:"ResourceRecord" min:"1" type:"list"`

	// Resource record sets that have a routing policy other than simple: An identifier
	// that differentiates among multiple resource record sets that have the same
	// combination of name and type, such as multiple weighted resource record sets
	// named acme.example.com that have a type of A. In a group of resource record
	// sets that have the same name and type, the value of SetIdentifier must be
	// unique for each resource record set.
	//
	// For information about routing policies, see Choosing a Routing Policy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html)
	// in the Amazon Route 53 Developer Guide.
	SetIdentifier *string `min:"1" type:"string"`

	// The resource record cache time to live (TTL), in seconds. Note the following:
	//
	//    * If you're creating or updating an alias resource record set, omit TTL.
	//    Amazon Route 53 uses the value of TTL for the alias target.
	//
	//    * If you're associating this resource record set with a health check (if
	//    you're adding a HealthCheckId element), we recommend that you specify
	//    a TTL of 60 seconds or less so clients respond quickly to changes in health
	//    status.
	//
	//    * All of the resource record sets in a group of weighted resource record
	//    sets must have the same value for TTL.
	//
	//    * If a group of weighted resource record sets includes one or more weighted
	//    alias resource record sets for which the alias target is an ELB load balancer,
	//    we recommend that you specify a TTL of 60 seconds for all of the non-alias
	//    weighted resource record sets that have the same name and type. Values
	//    other than 60 seconds (the TTL for load balancers) will change the effect
	//    of the values that you specify for Weight.
	TTL *int64 `type:"long"`

	// When you create a traffic policy instance, Amazon Route 53 automatically
	// creates a resource record set. TrafficPolicyInstanceId is the ID of the traffic
	// policy instance that Route 53 created this resource record set for.
	//
	// To delete the resource record set that is associated with a traffic policy
	// instance, use DeleteTrafficPolicyInstance. Route 53 will delete the resource
	// record set automatically. If you delete the resource record set by using
	// ChangeResourceRecordSets, Route 53 doesn't automatically delete the traffic
	// policy instance, and you'll continue to be charged for it even though it's
	// no longer in use.
	TrafficPolicyInstanceId *string `min:"1" type:"string"`

	// The DNS record type. For information about different record types and how
	// data is encoded for them, see Supported DNS Resource Record Types (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Valid values for basic resource record sets: A | AAAA | CAA | CNAME | DS
	// |MX | NAPTR | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geolocation, and failover resource record sets:
	// A | AAAA | CAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT. When creating
	// a group of weighted, latency, geolocation, or failover resource record sets,
	// specify the same value for all of the resource record sets in the group.
	//
	// Valid values for multivalue answer resource record sets: A | AAAA | MX |
	// NAPTR | PTR | SPF | SRV | TXT
	//
	// SPF records were formerly used to verify the identity of the sender of email
	// messages. However, we no longer recommend that you create resource record
	// sets for which the value of Type is SPF. RFC 7208, Sender Policy Framework
	// (SPF) for Authorizing Use of Domains in Email, Version 1, has been updated
	// to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to
	// some interoperability issues. Accordingly, its use is no longer appropriate
	// for SPF version 1; implementations are not to use it." In RFC 7208, see section
	// 14.1, The SPF DNS Record Type (http://tools.ietf.org/html/rfc7208#section-14.1).
	//
	// Values for alias resource record sets:
	//
	//    * Amazon API Gateway custom regional APIs and edge-optimized APIs: A
	//
	//    * CloudFront distributions: A If IPv6 is enabled for the distribution,
	//    create two resource record sets to route traffic to your distribution,
	//    one with a value of A and one with a value of AAAA.
	//
	//    * Amazon API Gateway environment that has a regionalized subdomain: A
	//
	//    * ELB load balancers: A | AAAA
	//
	//    * Amazon S3 buckets: A
	//
	//    * Amazon Virtual Private Cloud interface VPC endpoints A
	//
	//    * Another resource record set in this hosted zone: Specify the type of
	//    the resource record set that you're creating the alias for. All values
	//    are supported except NS and SOA. If you're creating an alias record that
	//    has the same name as the hosted zone (known as the zone apex), you can't
	//    route traffic to a record for which the value of Type is CNAME. This is
	//    because the alias record must have the same type as the record you're
	//    routing traffic to, and creating a CNAME record for the zone apex isn't
	//    supported even for an alias record.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RRType"`

	// Weighted resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that determines the proportion
	// of DNS queries that Amazon Route 53 responds to using the current resource
	// record set. Route 53 calculates the sum of the weights for the resource record
	// sets that have the same combination of DNS name and type. Route 53 then responds
	// to queries based on the ratio of a resource's weight to the total. Note the
	// following:
	//
	//    * You must specify a value for the Weight element for every weighted resource
	//    record set.
	//
	//    * You can only specify one ResourceRecord per weighted resource record
	//    set.
	//
	//    * You can't create latency, failover, or geolocation resource record sets
	//    that have the same values for the Name and Type elements as weighted resource
	//    record sets.
	//
	//    * You can create a maximum of 100 weighted resource record sets that have
	//    the same values for the Name and Type elements.
	//
	//    * For weighted (but not weighted alias) resource record sets, if you set
	//    Weight to 0 for a resource record set, Route 53 never responds to queries
	//    with the applicable value for that resource record set. However, if you
	//    set Weight to 0 for all resource record sets that have the same combination
	//    of DNS name and type, traffic is routed to all resources with equal probability.
	//    The effect of setting Weight to 0 is different when you associate health
	//    checks with weighted resource record sets. For more information, see Options
	//    for Configuring Route 53 Active-Active and Active-Passive Failover (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html)
	//    in the Amazon Route 53 Developer Guide.
	Weight *int64 `type:"long"`
}

// String returns the string representation
func (s ResourceRecordSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecordSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRecordSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceRecordSet"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.ResourceRecords != nil && len(s.ResourceRecords) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceRecords", 1))
	}
	if s.SetIdentifier != nil && len(*s.SetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SetIdentifier", 1))
	}
	if s.TrafficPolicyInstanceId != nil && len(*s.TrafficPolicyInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyInstanceId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.AliasTarget != nil {
		if err := s.AliasTarget.Validate(); err != nil {
			invalidParams.AddNested("AliasTarget", err.(request.ErrInvalidParams))
		}
	}
	if s.GeoLocation != nil {
		if err := s.GeoLocation.Validate(); err != nil {
			invalidParams.AddNested("GeoLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceRecords != nil {
		for i, v := range s.ResourceRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasTarget sets the AliasTarget field's value.
func (s *ResourceRecordSet) SetAliasTarget(v *AliasTarget) *ResourceRecordSet {
	s.AliasTarget = v
	return s
}

// SetFailover sets the Failover field's value.
func (s *ResourceRecordSet) SetFailover(v string) *ResourceRecordSet {
	s.Failover = &v
	return s
}

// SetGeoLocation sets the GeoLocation field's value.
func (s *ResourceRecordSet) SetGeoLocation(v *GeoLocation) *ResourceRecordSet {
	s.GeoLocation = v
	return s
}

// SetHealthCheckId sets the HealthCheckId field's value.
func (s *ResourceRecordSet) SetHealthCheckId(v string) *ResourceRecordSet {
	s.HealthCheckId = &v
	return s
}

// SetMultiValueAnswer sets the MultiValueAnswer field's value.
func (s *ResourceRecordSet) SetMultiValueAnswer(v bool) *ResourceRecordSet {
	s.MultiValueAnswer = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceRecordSet) SetName(v string) *ResourceRecordSet {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ResourceRecordSet) SetRegion(v string) *ResourceRecordSet {
	s.Region = &v
	return s
}

// SetResourceRecords sets the ResourceRecords field's value.
func (s *ResourceRecordSet) SetResourceRecords(v []*ResourceRecord) *ResourceRecordSet {
	s.ResourceRecords = v
	return s
}

// SetSetIdentifier sets the SetIdentifier field's value.
func (s *ResourceRecordSet) SetSetIdentifier(v string) *ResourceRecordSet {
	s.SetIdentifier = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *ResourceRecordSet) SetTTL(v int64) *ResourceRecordSet {
	s.TTL = &v
	return s
}

// SetTrafficPolicyInstanceId sets the TrafficPolicyInstanceId field's value.
func (s *ResourceRecordSet) SetTrafficPolicyInstanceId(v string) *ResourceRecordSet {
	s.TrafficPolicyInstanceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceRecordSet) SetType(v string) *ResourceRecordSet {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ResourceRecordSet) SetWeight(v int64) *ResourceRecordSet {
	s.Weight = &v
	return s
}

// A complex type containing a resource and its associated tags.
type ResourceTagSet struct {
	_ struct{} `type:"structure"`

	// The ID for the specified resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	ResourceType *string `type:"string" enum:"TagResourceType"`

	// The tags associated with the specified resource.
	Tags []*Tag `locationNameList:"Tag" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTagSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagSet) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceTagSet) SetResourceId(v string) *ResourceTagSet {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceTagSet) SetResourceType(v string) *ResourceTagSet {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceTagSet) SetTags(v []*Tag) *ResourceTagSet {
	s.Tags = v
	return s
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
type ReusableDelegationSetLimit struct {
	_ struct{} `type:"structure"`

	// The limit that you requested: MAX_ZONES_BY_REUSABLE_DELEGATION_SET, the maximum
	// number of hosted zones that you can associate with the specified reusable
	// delegation set.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ReusableDelegationSetLimitType"`

	// The current value for the MAX_ZONES_BY_REUSABLE_DELEGATION_SET limit.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s ReusableDelegationSetLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReusableDelegationSetLimit) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *ReusableDelegationSetLimit) SetType(v string) *ReusableDelegationSetLimit {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ReusableDelegationSetLimit) SetValue(v int64) *ReusableDelegationSetLimit {
	s.Value = &v
	return s
}

// A complex type that contains the status that one Amazon Route 53 health checker
// reports and the time of the health check.
type StatusReport struct {
	_ struct{} `type:"structure"`

	// The date and time that the health checker performed the health check in ISO
	// 8601 format (https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal
	// Time (UTC). For example, the value 2017-03-27T17:48:16.751Z represents March
	// 27, 2017 at 17:48:16.751 UTC.
	CheckedTime *time.Time `type:"timestamp"`

	// A description of the status of the health check endpoint as reported by one
	// of the Amazon Route 53 health checkers.
	Status *string `type:"string"`
}

// String returns the string representation
func (s StatusReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusReport) GoString() string {
	return s.String()
}

// SetCheckedTime sets the CheckedTime field's value.
func (s *StatusReport) SetCheckedTime(v time.Time) *StatusReport {
	s.CheckedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StatusReport) SetStatus(v string) *StatusReport {
	s.Status = &v
	return s
}

// A complex type that contains information about a tag that you want to add
// or edit for the specified health check or hosted zone.
type Tag struct {
	_ struct{} `type:"structure"`

	// The value of Key depends on the operation that you want to perform:
	//
	//    * Add a tag to a health check or hosted zone: Key is the name that you
	//    want to give the new tag.
	//
	//    * Edit a tag: Key is the name of the tag that you want to change the Value
	//    for.
	//
	//    * Delete a key: Key is the name of the tag you want to remove.
	//
	//    * Give a name to a health check: Edit the default Name tag. In the Amazon
	//    Route 53 console, the list of your health checks includes a Name column
	//    that lets you see the name that you've given to each health check.
	Key *string `type:"string"`

	// The value of Value depends on the operation that you want to perform:
	//
	//    * Add a tag to a health check or hosted zone: Value is the value that
	//    you want to give the new tag.
	//
	//    * Edit a tag: Value is the new value that you want to assign the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Gets the value that Amazon Route 53 returns in response to a DNS request
// for a specified record name and type. You can optionally specify the IP address
// of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
type TestDNSAnswerInput struct {
	_ struct{} `locationName:"TestDNSAnswerRequest" type:"structure"`

	// If the resolver that you specified for resolverip supports EDNS0, specify
	// the IPv4 or IPv6 address of a client in the applicable location, for example,
	// 192.0.2.44 or 2001:db8:85a3::8a2e:370:7334.
	EDNS0ClientSubnetIP *string `location:"querystring" locationName:"edns0clientsubnetip" type:"string"`

	// If you specify an IP address for edns0clientsubnetip, you can optionally
	// specify the number of bits of the IP address that you want the checking tool
	// to include in the DNS query. For example, if you specify 192.0.2.44 for edns0clientsubnetip
	// and 24 for edns0clientsubnetmask, the checking tool will simulate a request
	// from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64
	// bits for IPv6 addresses.
	//
	// The range of valid values depends on whether edns0clientsubnetip is an IPv4
	// or an IPv6 address:
	//
	//    * IPv4: Specify a value between 0 and 32
	//
	//    * IPv6: Specify a value between 0 and 128
	EDNS0ClientSubnetMask *string `location:"querystring" locationName:"edns0clientsubnetmask" type:"string"`

	// The ID of the hosted zone that you want Amazon Route 53 to simulate a query
	// for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string" required:"true"`

	// The name of the resource record set that you want Amazon Route 53 to simulate
	// a query for.
	//
	// RecordName is a required field
	RecordName *string `location:"querystring" locationName:"recordname" type:"string" required:"true"`

	// The type of the resource record set.
	//
	// RecordType is a required field
	RecordType *string `location:"querystring" locationName:"recordtype" type:"string" required:"true" enum:"RRType"`

	// If you want to simulate a request from a specific DNS resolver, specify the
	// IP address for that resolver. If you omit this value, TestDnsAnswer uses
	// the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia)
	// Region (us-east-1).
	ResolverIP *string `location:"querystring" locationName:"resolverip" type:"string"`
}

// String returns the string representation
func (s TestDNSAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestDNSAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestDNSAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestDNSAnswerInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.RecordName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordName"))
	}
	if s.RecordType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEDNS0ClientSubnetIP sets the EDNS0ClientSubnetIP field's value.
func (s *TestDNSAnswerInput) SetEDNS0ClientSubnetIP(v string) *TestDNSAnswerInput {
	s.EDNS0ClientSubnetIP = &v
	return s
}

// SetEDNS0ClientSubnetMask sets the EDNS0ClientSubnetMask field's value.
func (s *TestDNSAnswerInput) SetEDNS0ClientSubnetMask(v string) *TestDNSAnswerInput {
	s.EDNS0ClientSubnetMask = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *TestDNSAnswerInput) SetHostedZoneId(v string) *TestDNSAnswerInput {
	s.HostedZoneId = &v
	return s
}

// SetRecordName sets the RecordName field's value.
func (s *TestDNSAnswerInput) SetRecordName(v string) *TestDNSAnswerInput {
	s.RecordName = &v
	return s
}

// SetRecordType sets the RecordType field's value.
func (s *TestDNSAnswerInput) SetRecordType(v string) *TestDNSAnswerInput {
	s.RecordType = &v
	return s
}

// SetResolverIP sets the ResolverIP field's value.
func (s *TestDNSAnswerInput) SetResolverIP(v string) *TestDNSAnswerInput {
	s.ResolverIP = &v
	return s
}

// A complex type that contains the response to a TestDNSAnswer request.
type TestDNSAnswerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Route 53 name server used to respond to the request.
	//
	// Nameserver is a required field
	Nameserver *string `type:"string" required:"true"`

	// The protocol that Amazon Route 53 used to respond to the request, either
	// UDP or TCP.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true"`

	// A list that contains values that Amazon Route 53 returned for this resource
	// record set.
	//
	// RecordData is a required field
	RecordData []*string `locationNameList:"RecordDataEntry" type:"list" required:"true"`

	// The name of the resource record set that you submitted a request for.
	//
	// RecordName is a required field
	RecordName *string `type:"string" required:"true"`

	// The type of the resource record set that you submitted a request for.
	//
	// RecordType is a required field
	RecordType *string `type:"string" required:"true" enum:"RRType"`

	// A code that indicates whether the request is valid or not. The most common
	// response code is NOERROR, meaning that the request is valid. If the response
	// is not valid, Amazon Route 53 returns a response code that describes the
	// error. For a list of possible response codes, see DNS RCODES (http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6)
	// on the IANA website.
	//
	// ResponseCode is a required field
	ResponseCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestDNSAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestDNSAnswerOutput) GoString() string {
	return s.String()
}

// SetNameserver sets the Nameserver field's value.
func (s *TestDNSAnswerOutput) SetNameserver(v string) *TestDNSAnswerOutput {
	s.Nameserver = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *TestDNSAnswerOutput) SetProtocol(v string) *TestDNSAnswerOutput {
	s.Protocol = &v
	return s
}

// SetRecordData sets the RecordData field's value.
func (s *TestDNSAnswerOutput) SetRecordData(v []*string) *TestDNSAnswerOutput {
	s.RecordData = v
	return s
}

// SetRecordName sets the RecordName field's value.
func (s *TestDNSAnswerOutput) SetRecordName(v string) *TestDNSAnswerOutput {
	s.RecordName = &v
	return s
}

// SetRecordType sets the RecordType field's value.
func (s *TestDNSAnswerOutput) SetRecordType(v string) *TestDNSAnswerOutput {
	s.RecordType = &v
	return s
}

// SetResponseCode sets the ResponseCode field's value.
func (s *TestDNSAnswerOutput) SetResponseCode(v string) *TestDNSAnswerOutput {
	s.ResponseCode = &v
	return s
}

// A complex type that contains settings for a traffic policy.
type TrafficPolicy struct {
	_ struct{} `type:"structure"`

	// The comment that you specify in the CreateTrafficPolicy request, if any.
	Comment *string `type:"string"`

	// The definition of a traffic policy in JSON format. You specify the JSON document
	// to use for a new traffic policy in the CreateTrafficPolicy request. For more
	// information about the JSON format, see Traffic Policy Document Format (https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ID that Amazon Route 53 assigned to a traffic policy when you created
	// it.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name that you specified when you created the traffic policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The DNS type of the resource record sets that Amazon Route 53 creates when
	// you use a traffic policy to create a traffic policy instance.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RRType"`

	// The version number that Amazon Route 53 assigns to a traffic policy. For
	// a new traffic policy, the value of Version is always 1.
	//
	// Version is a required field
	Version *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicy) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *TrafficPolicy) SetComment(v string) *TrafficPolicy {
	s.Comment = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *TrafficPolicy) SetDocument(v string) *TrafficPolicy {
	s.Document = &v
	return s
}

// SetId sets the Id field's value.
func (s *TrafficPolicy) SetId(v string) *TrafficPolicy {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *TrafficPolicy) SetName(v string) *TrafficPolicy {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *TrafficPolicy) SetType(v string) *TrafficPolicy {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *TrafficPolicy) SetVersion(v int64) *TrafficPolicy {
	s.Version = &v
	return s
}

// A complex type that contains settings for the new traffic policy instance.
type TrafficPolicyInstance struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that Amazon Route 53 created resource record sets
	// in.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The ID that Amazon Route 53 assigned to the new traffic policy instance.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// If State is Failed, an explanation of the reason for the failure. If State
	// is another value, Message is empty.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The DNS name, such as www.example.com, for which Amazon Route 53 responds
	// to queries by using the resource record sets that are associated with this
	// traffic policy instance.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of State is one of the following values:
	//
	// Applied
	//
	// Amazon Route 53 has finished creating resource record sets, and changes have
	// propagated to all Route 53 edge locations.
	//
	// Creating
	//
	// Route 53 is creating the resource record sets. Use GetTrafficPolicyInstance
	// to confirm that the CreateTrafficPolicyInstance request completed successfully.
	//
	// Failed
	//
	// Route 53 wasn't able to create or update the resource record sets. When the
	// value of State is Failed, see Message for an explanation of what caused the
	// request to fail.
	//
	// State is a required field
	State *string `type:"string" required:"true"`

	// The TTL that Amazon Route 53 assigned to all of the resource record sets
	// that it created in the specified hosted zone.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// The DNS type that Amazon Route 53 assigned to all of the resource record
	// sets that it created for this traffic policy instance.
	//
	// TrafficPolicyType is a required field
	TrafficPolicyType *string `type:"string" required:"true" enum:"RRType"`

	// The version of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicyInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicyInstance) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *TrafficPolicyInstance) SetHostedZoneId(v string) *TrafficPolicyInstance {
	s.HostedZoneId = &v
	return s
}

// SetId sets the Id field's value.
func (s *TrafficPolicyInstance) SetId(v string) *TrafficPolicyInstance {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TrafficPolicyInstance) SetMessage(v string) *TrafficPolicyInstance {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *TrafficPolicyInstance) SetName(v string) *TrafficPolicyInstance {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *TrafficPolicyInstance) SetState(v string) *TrafficPolicyInstance {
	s.State = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *TrafficPolicyInstance) SetTTL(v int64) *TrafficPolicyInstance {
	s.TTL = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *TrafficPolicyInstance) SetTrafficPolicyId(v string) *TrafficPolicyInstance {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyType sets the TrafficPolicyType field's value.
func (s *TrafficPolicyInstance) SetTrafficPolicyType(v string) *TrafficPolicyInstance {
	s.TrafficPolicyType = &v
	return s
}

// SetTrafficPolicyVersion sets the TrafficPolicyVersion field's value.
func (s *TrafficPolicyInstance) SetTrafficPolicyVersion(v int64) *TrafficPolicyInstance {
	s.TrafficPolicyVersion = &v
	return s
}

// A complex type that contains information about the latest version of one
// traffic policy that is associated with the current account.
type TrafficPolicySummary struct {
	_ struct{} `type:"structure"`

	// The ID that Amazon Route 53 assigned to the traffic policy when you created
	// it.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The version number of the latest version of the traffic policy.
	//
	// LatestVersion is a required field
	LatestVersion *int64 `min:"1" type:"integer" required:"true"`

	// The name that you specified for the traffic policy when you created it.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The number of traffic policies that are associated with the current account.
	//
	// TrafficPolicyCount is a required field
	TrafficPolicyCount *int64 `min:"1" type:"integer" required:"true"`

	// The DNS type of the resource record sets that Amazon Route 53 creates when
	// you use a traffic policy to create a traffic policy instance.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RRType"`
}

// String returns the string representation
func (s TrafficPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicySummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TrafficPolicySummary) SetId(v string) *TrafficPolicySummary {
	s.Id = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *TrafficPolicySummary) SetLatestVersion(v int64) *TrafficPolicySummary {
	s.LatestVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *TrafficPolicySummary) SetName(v string) *TrafficPolicySummary {
	s.Name = &v
	return s
}

// SetTrafficPolicyCount sets the TrafficPolicyCount field's value.
func (s *TrafficPolicySummary) SetTrafficPolicyCount(v int64) *TrafficPolicySummary {
	s.TrafficPolicyCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *TrafficPolicySummary) SetType(v string) *TrafficPolicySummary {
	s.Type = &v
	return s
}

// A complex type that contains information about a request to update a health
// check.
type UpdateHealthCheckInput struct {
	_ struct{} `locationName:"UpdateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that identifies the CloudWatch alarm that you want Amazon
	// Route 53 health checkers to use to determine whether the specified health
	// check is healthy.
	AlarmIdentifier *AlarmIdentifier `type:"structure"`

	// A complex type that contains one ChildHealthCheck element for each health
	// check that you want to associate with a CALCULATED health check.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// Stops Route 53 from performing health checks. When you disable a health check,
	// here's what happens:
	//
	//    * Health checks that check the health of endpoints: Route 53 stops submitting
	//    requests to your application, server, or other resource.
	//
	//    * Calculated health checks: Route 53 stops aggregating the status of the
	//    referenced health checks.
	//
	//    * Health checks that monitor CloudWatch alarms: Route 53 stops monitoring
	//    the corresponding CloudWatch metrics.
	//
	// After you disable a health check, Route 53 considers the status of the health
	// check to always be healthy. If you configured DNS failover, Route 53 continues
	// to route traffic to the corresponding resources. If you want to stop routing
	// traffic to a resource, change the value of Inverted (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted).
	//
	// Charges for a health check still apply when the health check is disabled.
	// For more information, see Amazon Route 53 Pricing (http://aws.amazon.com/route53/pricing/).
	Disabled *bool `type:"boolean"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. This
	// allows the endpoint to respond to HTTPS health check requests with the applicable
	// SSL/TLS certificate.
	//
	// Some endpoints require that HTTPS requests include the host name in the client_hello
	// message. If you don't enable SNI, the status of the health check will be
	// SSL alert handshake_failure. A health check can also have that status for
	// other reasons. If SNI is enabled and you're still getting the error, check
	// the SSL/TLS configuration on your endpoint and confirm that your certificate
	// is valid.
	//
	// The SSL/TLS certificate on your endpoint includes a domain name in the Common
	// Name field and possibly several more in the Subject Alternative Names field.
	// One of the domain names in the certificate should match the value that you
	// specify for FullyQualifiedDomainName. If the endpoint responds to the client_hello
	// message with a certificate that does not include the domain name that you
	// specified in FullyQualifiedDomainName, a health checker will retry the handshake.
	// In the second attempt, the health checker will omit FullyQualifiedDomainName
	// from the client_hello message.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Amazon Route 53 Determines
	// Whether an Endpoint Is Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// If you don't specify a value for FailureThreshold, the default value is three
	// health checks.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
	//
	// If a health check already has a value for IPAddress, you can change the value.
	// However, you can't update an existing health check to add or remove the value
	// of IPAddress.
	//
	// If you specify a value for IPAddress:
	//
	// Route 53 sends health check requests to the specified IPv4 or IPv6 address
	// and passes the value of FullyQualifiedDomainName in the Host header for all
	// health checks except TCP health checks. This is typically the fully qualified
	// DNS name of the endpoint on which you want Route 53 to perform health checks.
	//
	// When Route 53 checks the health of an endpoint, here is how it constructs
	// the Host header:
	//
	//    * If you specify a value of 80 for Port and HTTP or HTTP_STR_MATCH for
	//    Type, Route 53 passes the value of FullyQualifiedDomainName to the endpoint
	//    in the Host header.
	//
	//    * If you specify a value of 443 for Port and HTTPS or HTTPS_STR_MATCH
	//    for Type, Route 53 passes the value of FullyQualifiedDomainName to the
	//    endpoint in the Host header.
	//
	//    * If you specify another value for Port and any value except TCP for Type,
	//    Route 53 passes FullyQualifiedDomainName:Port to the endpoint in the Host
	//    header.
	//
	// If you don't specify a value for FullyQualifiedDomainName, Route 53 substitutes
	// the value of IPAddress in the Host header in each of the above cases.
	//
	// If you don't specify a value for IPAddress:
	//
	// If you don't specify a value for IPAddress, Route 53 sends a DNS request
	// to the domain that you specify in FullyQualifiedDomainName at the interval
	// you specify in RequestInterval. Using an IPv4 address that is returned by
	// DNS, Route 53 then checks the health of the endpoint.
	//
	// If you don't specify a value for IPAddress, Route 53 uses only IPv4 to send
	// health checks to the endpoint. If there's no resource record set with a type
	// of A for the name that you specify for FullyQualifiedDomainName, the health
	// check fails with a "DNS resolution failed" error.
	//
	// If you want to check the health of weighted, latency, or failover resource
	// record sets and you choose to specify the endpoint only by FullyQualifiedDomainName,
	// we recommend that you create a separate health check for each endpoint. For
	// example, create a health check for each HTTP server that is serving content
	// for www.example.com. For the value of FullyQualifiedDomainName, specify the
	// domain name of the server (such as us-east-2-www.example.com), not the name
	// of the resource record sets (www.example.com).
	//
	// In this configuration, if the value of FullyQualifiedDomainName matches the
	// name of the resource record sets and you then associate the health check
	// with those resource record sets, health check results will be unpredictable.
	//
	// In addition, if the value of Type is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH,
	// Route 53 passes the value of FullyQualifiedDomainName in the Host header,
	// as it does when you specify a value for IPAddress. If the value of Type is
	// TCP, Route 53 doesn't pass a Host header.
	FullyQualifiedDomainName *string `type:"string"`

	// The ID for the health check for which you want detailed information. When
	// you created the health check, CreateHealthCheck returned the ID in the response,
	// in the HealthCheckId element.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	// A sequential counter that Amazon Route 53 sets to 1 when you create a health
	// check and increments by 1 each time you update settings for the health check.
	//
	// We recommend that you use GetHealthCheck or ListHealthChecks to get the current
	// value of HealthCheckVersion for the health check that you want to update,
	// and that you include that value in your UpdateHealthCheck request. This prevents
	// Route 53 from overwriting an intervening update:
	//
	//    * If the value in the UpdateHealthCheck request matches the value of HealthCheckVersion
	//    in the health check, Route 53 updates the health check with the new settings.
	//
	//    * If the value of HealthCheckVersion in the health check is greater, the
	//    health check was changed after you got the version number. Route 53 does
	//    not update the health check, and it returns a HealthCheckVersionMismatch
	//    error.
	HealthCheckVersion *int64 `min:"1" type:"long"`

	// The number of child health checks that are associated with a CALCULATED health
	// that Amazon Route 53 must consider healthy for the CALCULATED health check
	// to be considered healthy. To specify the child health checks that you want
	// to associate with a CALCULATED health check, use the ChildHealthChecks and
	// ChildHealthCheck elements.
	//
	// Note the following:
	//
	//    * If you specify a number greater than the number of child health checks,
	//    Route 53 always considers this health check to be unhealthy.
	//
	//    * If you specify 0, Route 53 always considers this health check to be
	//    healthy.
	HealthThreshold *int64 `type:"integer"`

	// The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53
	// to perform health checks on. If you don't specify a value for IPAddress,
	// Route 53 sends a DNS request to resolve the domain name that you specify
	// in FullyQualifiedDomainName at the interval that you specify in RequestInterval.
	// Using an IP address that is returned by DNS, Route 53 then checks the health
	// of the endpoint.
	//
	// Use one of the following formats for the value of IPAddress:
	//
	//    * IPv4 address: four values between 0 and 255, separated by periods (.),
	//    for example, 192.0.2.44.
	//
	//    * IPv6 address: eight groups of four hexadecimal values, separated by
	//    colons (:), for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345. You
	//    can also shorten IPv6 addresses as described in RFC 5952, for example,
	//    2001:db8:85a3::abcd:1:2345.
	//
	// If the endpoint is an EC2 instance, we recommend that you create an Elastic
	// IP address, associate it with your EC2 instance, and specify the Elastic
	// IP address for IPAddress. This ensures that the IP address of your instance
	// never changes. For more information, see the applicable documentation:
	//
	//    * Linux: Elastic IP Addresses (EIP) (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	//    in the Amazon EC2 User Guide for Linux Instances
	//
	//    * Windows: Elastic IP Addresses (EIP) (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html)
	//    in the Amazon EC2 User Guide for Windows Instances
	//
	// If a health check already has a value for IPAddress, you can change the value.
	// However, you can't update an existing health check to add or remove the value
	// of IPAddress.
	//
	// For more information, see FullyQualifiedDomainName (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
	//
	// Constraints: Route 53 can't check the health of endpoints for which the IP
	// address is in local, private, non-routable, or multicast ranges. For more
	// information about IP addresses for which you can't create health checks,
	// see the following documents:
	//
	//    * RFC 5735, Special Use IPv4 Addresses (https://tools.ietf.org/html/rfc5735)
	//
	//    * RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space (https://tools.ietf.org/html/rfc6598)
	//
	//    * RFC 5156, Special-Use IPv6 Addresses (https://tools.ietf.org/html/rfc5156)
	IPAddress *string `type:"string"`

	// When CloudWatch has insufficient data about the metric to determine the alarm
	// state, the status that you want Amazon Route 53 to assign to the health check:
	//
	//    * Healthy: Route 53 considers the health check to be healthy.
	//
	//    * Unhealthy: Route 53 considers the health check to be unhealthy.
	//
	//    * LastKnownStatus: Route 53 uses the status of the health check from the
	//    last time CloudWatch had sufficient data to determine the alarm state.
	//    For new health checks that have no last known status, the default status
	//    for the health check is healthy.
	InsufficientDataHealthStatus *string `type:"string" enum:"InsufficientDataHealthStatus"`

	// Specify whether you want Amazon Route 53 to invert the status of a health
	// check, for example, to consider a health check unhealthy when it otherwise
	// would be considered healthy.
	Inverted *bool `type:"boolean"`

	// The port on the endpoint that you want Amazon Route 53 to perform health
	// checks on.
	//
	// Don't specify a value for Port when you specify a value for Type of CLOUDWATCH_METRIC
	// or CALCULATED.
	Port *int64 `min:"1" type:"integer"`

	// A complex type that contains one Region element for each region that you
	// want Amazon Route 53 health checkers to check the specified endpoint from.
	Regions []*string `locationNameList:"Region" min:"3" type:"list"`

	// A complex type that contains one ResettableElementName element for each element
	// that you want to reset to the default value. Valid values for ResettableElementName
	// include the following:
	//
	//    * ChildHealthChecks: Amazon Route 53 resets ChildHealthChecks (https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks)
	//    to null.
	//
	//    * FullyQualifiedDomainName: Route 53 resets FullyQualifiedDomainName (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
	//    to null.
	//
	//    * Regions: Route 53 resets the Regions (https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions)
	//    list to the default set of regions.
	//
	//    * ResourcePath: Route 53 resets ResourcePath (https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath)
	//    to null.
	ResetElements []*string `locationNameList:"ResettableElementName" type:"list"`

	// The path that you want Amazon Route 53 to request when performing health
	// checks. The path can be any value for which your endpoint will return an
	// HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
	// the file /docs/route53-health-check.html. You can also include query string
	// parameters, for example, /welcome.html?language=jp&login=y.
	//
	// Specify this value only if you want to change it.
	ResourcePath *string `type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTPS_STR_MATCH, the string that
	// you want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Route 53 considers
	// the resource healthy. (You can't change the value of Type when you update
	// a health check.)
	SearchString *string `type:"string"`
}

// String returns the string representation
func (s UpdateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHealthCheckInput"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}
	if s.HealthCheckId != nil && len(*s.HealthCheckId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckId", 1))
	}
	if s.HealthCheckVersion != nil && *s.HealthCheckVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckVersion", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Regions != nil && len(s.Regions) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 3))
	}
	if s.AlarmIdentifier != nil {
		if err := s.AlarmIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlarmIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmIdentifier sets the AlarmIdentifier field's value.
func (s *UpdateHealthCheckInput) SetAlarmIdentifier(v *AlarmIdentifier) *UpdateHealthCheckInput {
	s.AlarmIdentifier = v
	return s
}

// SetChildHealthChecks sets the ChildHealthChecks field's value.
func (s *UpdateHealthCheckInput) SetChildHealthChecks(v []*string) *UpdateHealthCheckInput {
	s.ChildHealthChecks = v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *UpdateHealthCheckInput) SetDisabled(v bool) *UpdateHealthCheckInput {
	s.Disabled = &v
	return s
}

// SetEnableSNI sets the EnableSNI field's value.
func (s *UpdateHealthCheckInput) SetEnableSNI(v bool) *UpdateHealthCheckInput {
	s.EnableSNI = &v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *UpdateHealthCheckInput) SetFailureThreshold(v int64) *UpdateHealthCheckInput {
	s.FailureThreshold = &v
	return s
}

// SetFullyQualifiedDomainName sets the FullyQualifiedDomainName field's value.
func (s *UpdateHealthCheckInput) SetFullyQualifiedDomainName(v string) *UpdateHealthCheckInput {
	s.FullyQualifiedDomainName = &v
	return s
}

// SetHealthCheckId sets the HealthCheckId field's value.
func (s *UpdateHealthCheckInput) SetHealthCheckId(v string) *UpdateHealthCheckInput {
	s.HealthCheckId = &v
	return s
}

// SetHealthCheckVersion sets the HealthCheckVersion field's value.
func (s *UpdateHealthCheckInput) SetHealthCheckVersion(v int64) *UpdateHealthCheckInput {
	s.HealthCheckVersion = &v
	return s
}

// SetHealthThreshold sets the HealthThreshold field's value.
func (s *UpdateHealthCheckInput) SetHealthThreshold(v int64) *UpdateHealthCheckInput {
	s.HealthThreshold = &v
	return s
}

// SetIPAddress sets the IPAddress field's value.
func (s *UpdateHealthCheckInput) SetIPAddress(v string) *UpdateHealthCheckInput {
	s.IPAddress = &v
	return s
}

// SetInsufficientDataHealthStatus sets the InsufficientDataHealthStatus field's value.
func (s *UpdateHealthCheckInput) SetInsufficientDataHealthStatus(v string) *UpdateHealthCheckInput {
	s.InsufficientDataHealthStatus = &v
	return s
}

// SetInverted sets the Inverted field's value.
func (s *UpdateHealthCheckInput) SetInverted(v bool) *UpdateHealthCheckInput {
	s.Inverted = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateHealthCheckInput) SetPort(v int64) *UpdateHealthCheckInput {
	s.Port = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *UpdateHealthCheckInput) SetRegions(v []*string) *UpdateHealthCheckInput {
	s.Regions = v
	return s
}

// SetResetElements sets the ResetElements field's value.
func (s *UpdateHealthCheckInput) SetResetElements(v []*string) *UpdateHealthCheckInput {
	s.ResetElements = v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *UpdateHealthCheckInput) SetResourcePath(v string) *UpdateHealthCheckInput {
	s.ResourcePath = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *UpdateHealthCheckInput) SetSearchString(v string) *UpdateHealthCheckInput {
	s.SearchString = &v
	return s
}

// A complex type that contains the response to the UpdateHealthCheck request.
type UpdateHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the response to an UpdateHealthCheck request.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckOutput) GoString() string {
	return s.String()
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *UpdateHealthCheckOutput) SetHealthCheck(v *HealthCheck) *UpdateHealthCheckOutput {
	s.HealthCheck = v
	return s
}

// A request to update the comment for a hosted zone.
type UpdateHostedZoneCommentInput struct {
	_ struct{} `locationName:"UpdateHostedZoneCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The new comment for the hosted zone. If you don't specify a value for Comment,
	// Amazon Route 53 deletes the existing value of the Comment element, if any.
	Comment *string `type:"string"`

	// The ID for the hosted zone that you want to update the comment for.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHostedZoneCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHostedZoneCommentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *UpdateHostedZoneCommentInput) SetComment(v string) *UpdateHostedZoneCommentInput {
	s.Comment = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateHostedZoneCommentInput) SetId(v string) *UpdateHostedZoneCommentInput {
	s.Id = &v
	return s
}

// A complex type that contains the response to the UpdateHostedZoneComment
// request.
type UpdateHostedZoneCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the response to the UpdateHostedZoneComment
	// request.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentOutput) GoString() string {
	return s.String()
}

// SetHostedZone sets the HostedZone field's value.
func (s *UpdateHostedZoneCommentOutput) SetHostedZone(v *HostedZone) *UpdateHostedZoneCommentOutput {
	s.HostedZone = v
	return s
}

// A complex type that contains information about the traffic policy that you
// want to update the comment for.
type UpdateTrafficPolicyCommentInput struct {
	_ struct{} `locationName:"UpdateTrafficPolicyCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The new comment for the specified traffic policy and version.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The value of Id for the traffic policy that you want to update the comment
	// for.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`

	// The value of Version for the traffic policy that you want to update the comment
	// for.
	//
	// Version is a required field
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrafficPolicyCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrafficPolicyCommentInput"}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *UpdateTrafficPolicyCommentInput) SetComment(v string) *UpdateTrafficPolicyCommentInput {
	s.Comment = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateTrafficPolicyCommentInput) SetId(v string) *UpdateTrafficPolicyCommentInput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateTrafficPolicyCommentInput) SetVersion(v int64) *UpdateTrafficPolicyCommentInput {
	s.Version = &v
	return s
}

// A complex type that contains the response information for the traffic policy.
type UpdateTrafficPolicyCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyCommentOutput) GoString() string {
	return s.String()
}

// SetTrafficPolicy sets the TrafficPolicy field's value.
func (s *UpdateTrafficPolicyCommentOutput) SetTrafficPolicy(v *TrafficPolicy) *UpdateTrafficPolicyCommentOutput {
	s.TrafficPolicy = v
	return s
}

// A complex type that contains information about the resource record sets that
// you want to update based on a specified traffic policy instance.
type UpdateTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"UpdateTrafficPolicyInstanceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the traffic policy instance that you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`

	// The TTL that you want Amazon Route 53 to assign to all of the updated resource
	// record sets.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that you want Amazon Route 53 to use to update
	// resource record sets for the specified traffic policy instance.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// The version of the traffic policy that you want Amazon Route 53 to use to
	// update resource record sets for the specified traffic policy instance.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrafficPolicyInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.TTL == nil {
		invalidParams.Add(request.NewErrParamRequired("TTL"))
	}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}
	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateTrafficPolicyInstanceInput) SetId(v string) *UpdateTrafficPolicyInstanceInput {
	s.Id = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *UpdateTrafficPolicyInstanceInput) SetTTL(v int64) *UpdateTrafficPolicyInstanceInput {
	s.TTL = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *UpdateTrafficPolicyInstanceInput) SetTrafficPolicyId(v string) *UpdateTrafficPolicyInstanceInput {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyVersion sets the TrafficPolicyVersion field's value.
func (s *UpdateTrafficPolicyInstanceInput) SetTrafficPolicyVersion(v int64) *UpdateTrafficPolicyInstanceInput {
	s.TrafficPolicyVersion = &v
	return s
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type UpdateTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the updated traffic policy instance.
	//
	// TrafficPolicyInstance is a required field
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// SetTrafficPolicyInstance sets the TrafficPolicyInstance field's value.
func (s *UpdateTrafficPolicyInstanceOutput) SetTrafficPolicyInstance(v *TrafficPolicyInstance) *UpdateTrafficPolicyInstanceOutput {
	s.TrafficPolicyInstance = v
	return s
}

// (Private hosted zones only) A complex type that contains information about
// an Amazon VPC.
type VPC struct {
	_ struct{} `type:"structure"`

	// (Private hosted zones only) The ID of an Amazon VPC.
	VPCId *string `type:"string"`

	// (Private hosted zones only) The region that an Amazon VPC was created in.
	VPCRegion *string `min:"1" type:"string" enum:"VPCRegion"`
}

// String returns the string representation
func (s VPC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPC) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VPC) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VPC"}
	if s.VPCRegion != nil && len(*s.VPCRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVPCId sets the VPCId field's value.
func (s *VPC) SetVPCId(v string) *VPC {
	s.VPCId = &v
	return s
}

// SetVPCRegion sets the VPCRegion field's value.
func (s *VPC) SetVPCRegion(v string) *VPC {
	s.VPCRegion = &v
	return s
}

const (
	// AccountLimitTypeMaxHealthChecksByOwner is a AccountLimitType enum value
	AccountLimitTypeMaxHealthChecksByOwner = "MAX_HEALTH_CHECKS_BY_OWNER"

	// AccountLimitTypeMaxHostedZonesByOwner is a AccountLimitType enum value
	AccountLimitTypeMaxHostedZonesByOwner = "MAX_HOSTED_ZONES_BY_OWNER"

	// AccountLimitTypeMaxTrafficPolicyInstancesByOwner is a AccountLimitType enum value
	AccountLimitTypeMaxTrafficPolicyInstancesByOwner = "MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER"

	// AccountLimitTypeMaxReusableDelegationSetsByOwner is a AccountLimitType enum value
	AccountLimitTypeMaxReusableDelegationSetsByOwner = "MAX_REUSABLE_DELEGATION_SETS_BY_OWNER"

	// AccountLimitTypeMaxTrafficPoliciesByOwner is a AccountLimitType enum value
	AccountLimitTypeMaxTrafficPoliciesByOwner = "MAX_TRAFFIC_POLICIES_BY_OWNER"
)

// AccountLimitType_Values returns all elements of the AccountLimitType enum
func AccountLimitType_Values() []string {
	return []string{
		AccountLimitTypeMaxHealthChecksByOwner,
		AccountLimitTypeMaxHostedZonesByOwner,
		AccountLimitTypeMaxTrafficPolicyInstancesByOwner,
		AccountLimitTypeMaxReusableDelegationSetsByOwner,
		AccountLimitTypeMaxTrafficPoliciesByOwner,
	}
}

const (
	// ChangeActionCreate is a ChangeAction enum value
	ChangeActionCreate = "CREATE"

	// ChangeActionDelete is a ChangeAction enum value
	ChangeActionDelete = "DELETE"

	// ChangeActionUpsert is a ChangeAction enum value
	ChangeActionUpsert = "UPSERT"
)

// ChangeAction_Values returns all elements of the ChangeAction enum
func ChangeAction_Values() []string {
	return []string{
		ChangeActionCreate,
		ChangeActionDelete,
		ChangeActionUpsert,
	}
}

const (
	// ChangeStatusPending is a ChangeStatus enum value
	ChangeStatusPending = "PENDING"

	// ChangeStatusInsync is a ChangeStatus enum value
	ChangeStatusInsync = "INSYNC"
)

// ChangeStatus_Values returns all elements of the ChangeStatus enum
func ChangeStatus_Values() []string {
	return []string{
		ChangeStatusPending,
		ChangeStatusInsync,
	}
}

const (
	// CloudWatchRegionUsEast1 is a CloudWatchRegion enum value
	CloudWatchRegionUsEast1 = "us-east-1"

	// CloudWatchRegionUsEast2 is a CloudWatchRegion enum value
	CloudWatchRegionUsEast2 = "us-east-2"

	// CloudWatchRegionUsWest1 is a CloudWatchRegion enum value
	CloudWatchRegionUsWest1 = "us-west-1"

	// CloudWatchRegionUsWest2 is a CloudWatchRegion enum value
	CloudWatchRegionUsWest2 = "us-west-2"

	// CloudWatchRegionCaCentral1 is a CloudWatchRegion enum value
	CloudWatchRegionCaCentral1 = "ca-central-1"

	// CloudWatchRegionEuCentral1 is a CloudWatchRegion enum value
	CloudWatchRegionEuCentral1 = "eu-central-1"

	// CloudWatchRegionEuWest1 is a CloudWatchRegion enum value
	CloudWatchRegionEuWest1 = "eu-west-1"

	// CloudWatchRegionEuWest2 is a CloudWatchRegion enum value
	CloudWatchRegionEuWest2 = "eu-west-2"

	// CloudWatchRegionEuWest3 is a CloudWatchRegion enum value
	CloudWatchRegionEuWest3 = "eu-west-3"

	// CloudWatchRegionApEast1 is a CloudWatchRegion enum value
	CloudWatchRegionApEast1 = "ap-east-1"

	// CloudWatchRegionMeSouth1 is a CloudWatchRegion enum value
	CloudWatchRegionMeSouth1 = "me-south-1"

	// CloudWatchRegionApSouth1 is a CloudWatchRegion enum value
	CloudWatchRegionApSouth1 = "ap-south-1"

	// CloudWatchRegionApSoutheast1 is a CloudWatchRegion enum value
	CloudWatchRegionApSoutheast1 = "ap-southeast-1"

	// CloudWatchRegionApSoutheast2 is a CloudWatchRegion enum value
	CloudWatchRegionApSoutheast2 = "ap-southeast-2"

	// CloudWatchRegionApNortheast1 is a CloudWatchRegion enum value
	CloudWatchRegionApNortheast1 = "ap-northeast-1"

	// CloudWatchRegionApNortheast2 is a CloudWatchRegion enum value
	CloudWatchRegionApNortheast2 = "ap-northeast-2"

	// CloudWatchRegionApNortheast3 is a CloudWatchRegion enum value
	CloudWatchRegionApNortheast3 = "ap-northeast-3"

	// CloudWatchRegionEuNorth1 is a CloudWatchRegion enum value
	CloudWatchRegionEuNorth1 = "eu-north-1"

	// CloudWatchRegionSaEast1 is a CloudWatchRegion enum value
	CloudWatchRegionSaEast1 = "sa-east-1"

	// CloudWatchRegionCnNorthwest1 is a CloudWatchRegion enum value
	CloudWatchRegionCnNorthwest1 = "cn-northwest-1"

	// CloudWatchRegionCnNorth1 is a CloudWatchRegion enum value
	CloudWatchRegionCnNorth1 = "cn-north-1"

	// CloudWatchRegionAfSouth1 is a CloudWatchRegion enum value
	CloudWatchRegionAfSouth1 = "af-south-1"

	// CloudWatchRegionEuSouth1 is a CloudWatchRegion enum value
	CloudWatchRegionEuSouth1 = "eu-south-1"

	// CloudWatchRegionUsGovWest1 is a CloudWatchRegion enum value
	CloudWatchRegionUsGovWest1 = "us-gov-west-1"

	// CloudWatchRegionUsGovEast1 is a CloudWatchRegion enum value
	CloudWatchRegionUsGovEast1 = "us-gov-east-1"

	// CloudWatchRegionUsIsoEast1 is a CloudWatchRegion enum value
	CloudWatchRegionUsIsoEast1 = "us-iso-east-1"

	// CloudWatchRegionUsIsobEast1 is a CloudWatchRegion enum value
	CloudWatchRegionUsIsobEast1 = "us-isob-east-1"
)

// CloudWatchRegion_Values returns all elements of the CloudWatchRegion enum
func CloudWatchRegion_Values() []string {
	return []string{
		CloudWatchRegionUsEast1,
		CloudWatchRegionUsEast2,
		CloudWatchRegionUsWest1,
		CloudWatchRegionUsWest2,
		CloudWatchRegionCaCentral1,
		CloudWatchRegionEuCentral1,
		CloudWatchRegionEuWest1,
		CloudWatchRegionEuWest2,
		CloudWatchRegionEuWest3,
		CloudWatchRegionApEast1,
		CloudWatchRegionMeSouth1,
		CloudWatchRegionApSouth1,
		CloudWatchRegionApSoutheast1,
		CloudWatchRegionApSoutheast2,
		CloudWatchRegionApNortheast1,
		CloudWatchRegionApNortheast2,
		CloudWatchRegionApNortheast3,
		CloudWatchRegionEuNorth1,
		CloudWatchRegionSaEast1,
		CloudWatchRegionCnNorthwest1,
		CloudWatchRegionCnNorth1,
		CloudWatchRegionAfSouth1,
		CloudWatchRegionEuSouth1,
		CloudWatchRegionUsGovWest1,
		CloudWatchRegionUsGovEast1,
		CloudWatchRegionUsIsoEast1,
		CloudWatchRegionUsIsobEast1,
	}
}

const (
	// ComparisonOperatorGreaterThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorGreaterThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorLessThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorLessThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorGreaterThanOrEqualToThreshold,
		ComparisonOperatorGreaterThanThreshold,
		ComparisonOperatorLessThanThreshold,
		ComparisonOperatorLessThanOrEqualToThreshold,
	}
}

const (
	// HealthCheckRegionUsEast1 is a HealthCheckRegion enum value
	HealthCheckRegionUsEast1 = "us-east-1"

	// HealthCheckRegionUsWest1 is a HealthCheckRegion enum value
	HealthCheckRegionUsWest1 = "us-west-1"

	// HealthCheckRegionUsWest2 is a HealthCheckRegion enum value
	HealthCheckRegionUsWest2 = "us-west-2"

	// HealthCheckRegionEuWest1 is a HealthCheckRegion enum value
	HealthCheckRegionEuWest1 = "eu-west-1"

	// HealthCheckRegionApSoutheast1 is a HealthCheckRegion enum value
	HealthCheckRegionApSoutheast1 = "ap-southeast-1"

	// HealthCheckRegionApSoutheast2 is a HealthCheckRegion enum value
	HealthCheckRegionApSoutheast2 = "ap-southeast-2"

	// HealthCheckRegionApNortheast1 is a HealthCheckRegion enum value
	HealthCheckRegionApNortheast1 = "ap-northeast-1"

	// HealthCheckRegionSaEast1 is a HealthCheckRegion enum value
	HealthCheckRegionSaEast1 = "sa-east-1"
)

// HealthCheckRegion_Values returns all elements of the HealthCheckRegion enum
func HealthCheckRegion_Values() []string {
	return []string{
		HealthCheckRegionUsEast1,
		HealthCheckRegionUsWest1,
		HealthCheckRegionUsWest2,
		HealthCheckRegionEuWest1,
		HealthCheckRegionApSoutheast1,
		HealthCheckRegionApSoutheast2,
		HealthCheckRegionApNortheast1,
		HealthCheckRegionSaEast1,
	}
}

const (
	// HealthCheckTypeHttp is a HealthCheckType enum value
	HealthCheckTypeHttp = "HTTP"

	// HealthCheckTypeHttps is a HealthCheckType enum value
	HealthCheckTypeHttps = "HTTPS"

	// HealthCheckTypeHttpStrMatch is a HealthCheckType enum value
	HealthCheckTypeHttpStrMatch = "HTTP_STR_MATCH"

	// HealthCheckTypeHttpsStrMatch is a HealthCheckType enum value
	HealthCheckTypeHttpsStrMatch = "HTTPS_STR_MATCH"

	// HealthCheckTypeTcp is a HealthCheckType enum value
	HealthCheckTypeTcp = "TCP"

	// HealthCheckTypeCalculated is a HealthCheckType enum value
	HealthCheckTypeCalculated = "CALCULATED"

	// HealthCheckTypeCloudwatchMetric is a HealthCheckType enum value
	HealthCheckTypeCloudwatchMetric = "CLOUDWATCH_METRIC"

	// HealthCheckTypeRecoveryControl is a HealthCheckType enum value
	HealthCheckTypeRecoveryControl = "RECOVERY_CONTROL"
)

// HealthCheckType_Values returns all elements of the HealthCheckType enum
func HealthCheckType_Values() []string {
	return []string{
		HealthCheckTypeHttp,
		HealthCheckTypeHttps,
		HealthCheckTypeHttpStrMatch,
		HealthCheckTypeHttpsStrMatch,
		HealthCheckTypeTcp,
		HealthCheckTypeCalculated,
		HealthCheckTypeCloudwatchMetric,
		HealthCheckTypeRecoveryControl,
	}
}

const (
	// HostedZoneLimitTypeMaxRrsetsByZone is a HostedZoneLimitType enum value
	HostedZoneLimitTypeMaxRrsetsByZone = "MAX_RRSETS_BY_ZONE"

	// HostedZoneLimitTypeMaxVpcsAssociatedByZone is a HostedZoneLimitType enum value
	HostedZoneLimitTypeMaxVpcsAssociatedByZone = "MAX_VPCS_ASSOCIATED_BY_ZONE"
)

// HostedZoneLimitType_Values returns all elements of the HostedZoneLimitType enum
func HostedZoneLimitType_Values() []string {
	return []string{
		HostedZoneLimitTypeMaxRrsetsByZone,
		HostedZoneLimitTypeMaxVpcsAssociatedByZone,
	}
}

const (
	// InsufficientDataHealthStatusHealthy is a InsufficientDataHealthStatus enum value
	InsufficientDataHealthStatusHealthy = "Healthy"

	// InsufficientDataHealthStatusUnhealthy is a InsufficientDataHealthStatus enum value
	InsufficientDataHealthStatusUnhealthy = "Unhealthy"

	// InsufficientDataHealthStatusLastKnownStatus is a InsufficientDataHealthStatus enum value
	InsufficientDataHealthStatusLastKnownStatus = "LastKnownStatus"
)

// InsufficientDataHealthStatus_Values returns all elements of the InsufficientDataHealthStatus enum
func InsufficientDataHealthStatus_Values() []string {
	return []string{
		InsufficientDataHealthStatusHealthy,
		InsufficientDataHealthStatusUnhealthy,
		InsufficientDataHealthStatusLastKnownStatus,
	}
}

const (
	// RRTypeSoa is a RRType enum value
	RRTypeSoa = "SOA"

	// RRTypeA is a RRType enum value
	RRTypeA = "A"

	// RRTypeTxt is a RRType enum value
	RRTypeTxt = "TXT"

	// RRTypeNs is a RRType enum value
	RRTypeNs = "NS"

	// RRTypeCname is a RRType enum value
	RRTypeCname = "CNAME"

	// RRTypeMx is a RRType enum value
	RRTypeMx = "MX"

	// RRTypeNaptr is a RRType enum value
	RRTypeNaptr = "NAPTR"

	// RRTypePtr is a RRType enum value
	RRTypePtr = "PTR"

	// RRTypeSrv is a RRType enum value
	RRTypeSrv = "SRV"

	// RRTypeSpf is a RRType enum value
	RRTypeSpf = "SPF"

	// RRTypeAaaa is a RRType enum value
	RRTypeAaaa = "AAAA"

	// RRTypeCaa is a RRType enum value
	RRTypeCaa = "CAA"

	// RRTypeDs is a RRType enum value
	RRTypeDs = "DS"
)

// RRType_Values returns all elements of the RRType enum
func RRType_Values() []string {
	return []string{
		RRTypeSoa,
		RRTypeA,
		RRTypeTxt,
		RRTypeNs,
		RRTypeCname,
		RRTypeMx,
		RRTypeNaptr,
		RRTypePtr,
		RRTypeSrv,
		RRTypeSpf,
		RRTypeAaaa,
		RRTypeCaa,
		RRTypeDs,
	}
}

const (
	// ResettableElementNameFullyQualifiedDomainName is a ResettableElementName enum value
	ResettableElementNameFullyQualifiedDomainName = "FullyQualifiedDomainName"

	// ResettableElementNameRegions is a ResettableElementName enum value
	ResettableElementNameRegions = "Regions"

	// ResettableElementNameResourcePath is a ResettableElementName enum value
	ResettableElementNameResourcePath = "ResourcePath"

	// ResettableElementNameChildHealthChecks is a ResettableElementName enum value
	ResettableElementNameChildHealthChecks = "ChildHealthChecks"
)

// ResettableElementName_Values returns all elements of the ResettableElementName enum
func ResettableElementName_Values() []string {
	return []string{
		ResettableElementNameFullyQualifiedDomainName,
		ResettableElementNameRegions,
		ResettableElementNameResourcePath,
		ResettableElementNameChildHealthChecks,
	}
}

const (
	// ResourceRecordSetFailoverPrimary is a ResourceRecordSetFailover enum value
	ResourceRecordSetFailoverPrimary = "PRIMARY"

	// ResourceRecordSetFailoverSecondary is a ResourceRecordSetFailover enum value
	ResourceRecordSetFailoverSecondary = "SECONDARY"
)

// ResourceRecordSetFailover_Values returns all elements of the ResourceRecordSetFailover enum
func ResourceRecordSetFailover_Values() []string {
	return []string{
		ResourceRecordSetFailoverPrimary,
		ResourceRecordSetFailoverSecondary,
	}
}

const (
	// ResourceRecordSetRegionUsEast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsEast1 = "us-east-1"

	// ResourceRecordSetRegionUsEast2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsEast2 = "us-east-2"

	// ResourceRecordSetRegionUsWest1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsWest1 = "us-west-1"

	// ResourceRecordSetRegionUsWest2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsWest2 = "us-west-2"

	// ResourceRecordSetRegionCaCentral1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionCaCentral1 = "ca-central-1"

	// ResourceRecordSetRegionEuWest1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuWest1 = "eu-west-1"

	// ResourceRecordSetRegionEuWest2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuWest2 = "eu-west-2"

	// ResourceRecordSetRegionEuWest3 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuWest3 = "eu-west-3"

	// ResourceRecordSetRegionEuCentral1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuCentral1 = "eu-central-1"

	// ResourceRecordSetRegionApSoutheast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApSoutheast1 = "ap-southeast-1"

	// ResourceRecordSetRegionApSoutheast2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApSoutheast2 = "ap-southeast-2"

	// ResourceRecordSetRegionApNortheast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApNortheast1 = "ap-northeast-1"

	// ResourceRecordSetRegionApNortheast2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApNortheast2 = "ap-northeast-2"

	// ResourceRecordSetRegionApNortheast3 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApNortheast3 = "ap-northeast-3"

	// ResourceRecordSetRegionEuNorth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuNorth1 = "eu-north-1"

	// ResourceRecordSetRegionSaEast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionSaEast1 = "sa-east-1"

	// ResourceRecordSetRegionCnNorth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionCnNorth1 = "cn-north-1"

	// ResourceRecordSetRegionCnNorthwest1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionCnNorthwest1 = "cn-northwest-1"

	// ResourceRecordSetRegionApEast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApEast1 = "ap-east-1"

	// ResourceRecordSetRegionMeSouth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionMeSouth1 = "me-south-1"

	// ResourceRecordSetRegionApSouth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApSouth1 = "ap-south-1"

	// ResourceRecordSetRegionAfSouth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionAfSouth1 = "af-south-1"

	// ResourceRecordSetRegionEuSouth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuSouth1 = "eu-south-1"
)

// ResourceRecordSetRegion_Values returns all elements of the ResourceRecordSetRegion enum
func ResourceRecordSetRegion_Values() []string {
	return []string{
		ResourceRecordSetRegionUsEast1,
		ResourceRecordSetRegionUsEast2,
		ResourceRecordSetRegionUsWest1,
		ResourceRecordSetRegionUsWest2,
		ResourceRecordSetRegionCaCentral1,
		ResourceRecordSetRegionEuWest1,
		ResourceRecordSetRegionEuWest2,
		ResourceRecordSetRegionEuWest3,
		ResourceRecordSetRegionEuCentral1,
		ResourceRecordSetRegionApSoutheast1,
		ResourceRecordSetRegionApSoutheast2,
		ResourceRecordSetRegionApNortheast1,
		ResourceRecordSetRegionApNortheast2,
		ResourceRecordSetRegionApNortheast3,
		ResourceRecordSetRegionEuNorth1,
		ResourceRecordSetRegionSaEast1,
		ResourceRecordSetRegionCnNorth1,
		ResourceRecordSetRegionCnNorthwest1,
		ResourceRecordSetRegionApEast1,
		ResourceRecordSetRegionMeSouth1,
		ResourceRecordSetRegionApSouth1,
		ResourceRecordSetRegionAfSouth1,
		ResourceRecordSetRegionEuSouth1,
	}
}

const (
	// ReusableDelegationSetLimitTypeMaxZonesByReusableDelegationSet is a ReusableDelegationSetLimitType enum value
	ReusableDelegationSetLimitTypeMaxZonesByReusableDelegationSet = "MAX_ZONES_BY_REUSABLE_DELEGATION_SET"
)

// ReusableDelegationSetLimitType_Values returns all elements of the ReusableDelegationSetLimitType enum
func ReusableDelegationSetLimitType_Values() []string {
	return []string{
		ReusableDelegationSetLimitTypeMaxZonesByReusableDelegationSet,
	}
}

const (
	// StatisticAverage is a Statistic enum value
	StatisticAverage = "Average"

	// StatisticSum is a Statistic enum value
	StatisticSum = "Sum"

	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SampleCount"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "Maximum"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "Minimum"
)

// Statistic_Values returns all elements of the Statistic enum
func Statistic_Values() []string {
	return []string{
		StatisticAverage,
		StatisticSum,
		StatisticSampleCount,
		StatisticMaximum,
		StatisticMinimum,
	}
}

const (
	// TagResourceTypeHealthcheck is a TagResourceType enum value
	TagResourceTypeHealthcheck = "healthcheck"

	// TagResourceTypeHostedzone is a TagResourceType enum value
	TagResourceTypeHostedzone = "hostedzone"
)

// TagResourceType_Values returns all elements of the TagResourceType enum
func TagResourceType_Values() []string {
	return []string{
		TagResourceTypeHealthcheck,
		TagResourceTypeHostedzone,
	}
}

const (
	// VPCRegionUsEast1 is a VPCRegion enum value
	VPCRegionUsEast1 = "us-east-1"

	// VPCRegionUsEast2 is a VPCRegion enum value
	VPCRegionUsEast2 = "us-east-2"

	// VPCRegionUsWest1 is a VPCRegion enum value
	VPCRegionUsWest1 = "us-west-1"

	// VPCRegionUsWest2 is a VPCRegion enum value
	VPCRegionUsWest2 = "us-west-2"

	// VPCRegionEuWest1 is a VPCRegion enum value
	VPCRegionEuWest1 = "eu-west-1"

	// VPCRegionEuWest2 is a VPCRegion enum value
	VPCRegionEuWest2 = "eu-west-2"

	// VPCRegionEuWest3 is a VPCRegion enum value
	VPCRegionEuWest3 = "eu-west-3"

	// VPCRegionEuCentral1 is a VPCRegion enum value
	VPCRegionEuCentral1 = "eu-central-1"

	// VPCRegionApEast1 is a VPCRegion enum value
	VPCRegionApEast1 = "ap-east-1"

	// VPCRegionMeSouth1 is a VPCRegion enum value
	VPCRegionMeSouth1 = "me-south-1"

	// VPCRegionUsGovWest1 is a VPCRegion enum value
	VPCRegionUsGovWest1 = "us-gov-west-1"

	// VPCRegionUsGovEast1 is a VPCRegion enum value
	VPCRegionUsGovEast1 = "us-gov-east-1"

	// VPCRegionUsIsoEast1 is a VPCRegion enum value
	VPCRegionUsIsoEast1 = "us-iso-east-1"

	// VPCRegionUsIsobEast1 is a VPCRegion enum value
	VPCRegionUsIsobEast1 = "us-isob-east-1"

	// VPCRegionApSoutheast1 is a VPCRegion enum value
	VPCRegionApSoutheast1 = "ap-southeast-1"

	// VPCRegionApSoutheast2 is a VPCRegion enum value
	VPCRegionApSoutheast2 = "ap-southeast-2"

	// VPCRegionApSouth1 is a VPCRegion enum value
	VPCRegionApSouth1 = "ap-south-1"

	// VPCRegionApNortheast1 is a VPCRegion enum value
	VPCRegionApNortheast1 = "ap-northeast-1"

	// VPCRegionApNortheast2 is a VPCRegion enum value
	VPCRegionApNortheast2 = "ap-northeast-2"

	// VPCRegionApNortheast3 is a VPCRegion enum value
	VPCRegionApNortheast3 = "ap-northeast-3"

	// VPCRegionEuNorth1 is a VPCRegion enum value
	VPCRegionEuNorth1 = "eu-north-1"

	// VPCRegionSaEast1 is a VPCRegion enum value
	VPCRegionSaEast1 = "sa-east-1"

	// VPCRegionCaCentral1 is a VPCRegion enum value
	VPCRegionCaCentral1 = "ca-central-1"

	// VPCRegionCnNorth1 is a VPCRegion enum value
	VPCRegionCnNorth1 = "cn-north-1"

	// VPCRegionAfSouth1 is a VPCRegion enum value
	VPCRegionAfSouth1 = "af-south-1"

	// VPCRegionEuSouth1 is a VPCRegion enum value
	VPCRegionEuSouth1 = "eu-south-1"
)

// VPCRegion_Values returns all elements of the VPCRegion enum
func VPCRegion_Values() []string {
	return []string{
		VPCRegionUsEast1,
		VPCRegionUsEast2,
		VPCRegionUsWest1,
		VPCRegionUsWest2,
		VPCRegionEuWest1,
		VPCRegionEuWest2,
		VPCRegionEuWest3,
		VPCRegionEuCentral1,
		VPCRegionApEast1,
		VPCRegionMeSouth1,
		VPCRegionUsGovWest1,
		VPCRegionUsGovEast1,
		VPCRegionUsIsoEast1,
		VPCRegionUsIsobEast1,
		VPCRegionApSoutheast1,
		VPCRegionApSoutheast2,
		VPCRegionApSouth1,
		VPCRegionApNortheast1,
		VPCRegionApNortheast2,
		VPCRegionApNortheast3,
		VPCRegionEuNorth1,
		VPCRegionSaEast1,
		VPCRegionCaCentral1,
		VPCRegionCnNorth1,
		VPCRegionAfSouth1,
		VPCRegionEuSouth1,
	}
}
