// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/entity_type.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents kinds of entities.
type EntityType_Kind int32

const (
	// Not specified. This value should be never used.
	EntityType_KIND_UNSPECIFIED EntityType_Kind = 0
	// Map entity types allow mapping of a group of synonyms to a canonical
	// value.
	EntityType_KIND_MAP EntityType_Kind = 1
	// List entity types contain a set of entries that do not map to canonical
	// values. However, list entity types can contain references to other entity
	// types (with or without aliases).
	EntityType_KIND_LIST EntityType_Kind = 2
)

var EntityType_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	1: "KIND_MAP",
	2: "KIND_LIST",
}

var EntityType_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED": 0,
	"KIND_MAP":         1,
	"KIND_LIST":        2,
}

func (x EntityType_Kind) String() string {
	return proto.EnumName(EntityType_Kind_name, int32(x))
}

func (EntityType_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{0, 0}
}

// Represents different entity type expansion modes. Automated expansion
// allows an agent to recognize values that have not been explicitly listed in
// the entity (for example, new kinds of shopping list items).
type EntityType_AutoExpansionMode int32

const (
	// Auto expansion disabled for the entity.
	EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED EntityType_AutoExpansionMode = 0
	// Allows an agent to recognize values that have not been explicitly
	// listed in the entity.
	EntityType_AUTO_EXPANSION_MODE_DEFAULT EntityType_AutoExpansionMode = 1
)

var EntityType_AutoExpansionMode_name = map[int32]string{
	0: "AUTO_EXPANSION_MODE_UNSPECIFIED",
	1: "AUTO_EXPANSION_MODE_DEFAULT",
}

var EntityType_AutoExpansionMode_value = map[string]int32{
	"AUTO_EXPANSION_MODE_UNSPECIFIED": 0,
	"AUTO_EXPANSION_MODE_DEFAULT":     1,
}

func (x EntityType_AutoExpansionMode) String() string {
	return proto.EnumName(EntityType_AutoExpansionMode_name, int32(x))
}

func (EntityType_AutoExpansionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{0, 1}
}

// Represents an entity type.
// Entity types serve as a tool for extracting parameter values from natural
// language queries.
type EntityType struct {
	// The unique identifier of the entity type.
	// Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
	// [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
	// Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the entity type.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Indicates the kind of entity type.
	Kind EntityType_Kind `protobuf:"varint,3,opt,name=kind,proto3,enum=google.cloud.dialogflow.v2.EntityType_Kind" json:"kind,omitempty"`
	// Optional. Indicates whether the entity type can be automatically
	// expanded.
	AutoExpansionMode EntityType_AutoExpansionMode `protobuf:"varint,4,opt,name=auto_expansion_mode,json=autoExpansionMode,proto3,enum=google.cloud.dialogflow.v2.EntityType_AutoExpansionMode" json:"auto_expansion_mode,omitempty"`
	// Optional. The collection of entity entries associated with the entity type.
	Entities             []*EntityType_Entity `protobuf:"bytes,6,rep,name=entities,proto3" json:"entities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *EntityType) Reset()         { *m = EntityType{} }
func (m *EntityType) String() string { return proto.CompactTextString(m) }
func (*EntityType) ProtoMessage()    {}
func (*EntityType) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{0}
}

func (m *EntityType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityType.Unmarshal(m, b)
}
func (m *EntityType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityType.Marshal(b, m, deterministic)
}
func (m *EntityType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityType.Merge(m, src)
}
func (m *EntityType) XXX_Size() int {
	return xxx_messageInfo_EntityType.Size(m)
}
func (m *EntityType) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityType.DiscardUnknown(m)
}

var xxx_messageInfo_EntityType proto.InternalMessageInfo

func (m *EntityType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EntityType) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *EntityType) GetKind() EntityType_Kind {
	if m != nil {
		return m.Kind
	}
	return EntityType_KIND_UNSPECIFIED
}

func (m *EntityType) GetAutoExpansionMode() EntityType_AutoExpansionMode {
	if m != nil {
		return m.AutoExpansionMode
	}
	return EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED
}

func (m *EntityType) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

// An **entity entry** for an associated entity type.
type EntityType_Entity struct {
	// Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*.
	//
	// For `KIND_MAP` entity types:
	//
	// *   A canonical value to be used in place of synonyms.
	//
	// For `KIND_LIST` entity types:
	//
	// *   A string that can contain references to other entity types (with or
	//     without aliases).
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. A collection of value synonyms. For example, if the entity type
	// is *vegetable*, and `value` is *scallions*, a synonym could be *green
	// onions*.
	//
	// For `KIND_LIST` entity types:
	//
	// *   This collection must contain exactly one synonym equal to `value`.
	Synonyms             []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityType_Entity) Reset()         { *m = EntityType_Entity{} }
func (m *EntityType_Entity) String() string { return proto.CompactTextString(m) }
func (*EntityType_Entity) ProtoMessage()    {}
func (*EntityType_Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{0, 0}
}

func (m *EntityType_Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityType_Entity.Unmarshal(m, b)
}
func (m *EntityType_Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityType_Entity.Marshal(b, m, deterministic)
}
func (m *EntityType_Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityType_Entity.Merge(m, src)
}
func (m *EntityType_Entity) XXX_Size() int {
	return xxx_messageInfo_EntityType_Entity.Size(m)
}
func (m *EntityType_Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityType_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_EntityType_Entity proto.InternalMessageInfo

func (m *EntityType_Entity) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *EntityType_Entity) GetSynonyms() []string {
	if m != nil {
		return m.Synonyms
	}
	return nil
}

// The request message for [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2.EntityTypes.ListEntityTypes].
type ListEntityTypesRequest struct {
	// Required. The agent to list all entity types from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to list entity synonyms for. If not specified,
	// the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntityTypesRequest) Reset()         { *m = ListEntityTypesRequest{} }
func (m *ListEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*ListEntityTypesRequest) ProtoMessage()    {}
func (*ListEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{1}
}

func (m *ListEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntityTypesRequest.Unmarshal(m, b)
}
func (m *ListEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntityTypesRequest.Marshal(b, m, deterministic)
}
func (m *ListEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntityTypesRequest.Merge(m, src)
}
func (m *ListEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_ListEntityTypesRequest.Size(m)
}
func (m *ListEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntityTypesRequest proto.InternalMessageInfo

func (m *ListEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEntityTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListEntityTypesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEntityTypesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2.EntityTypes.ListEntityTypes].
type ListEntityTypesResponse struct {
	// The list of agent entity types. There will be a maximum number of items
	// returned based on the page_size field in the request.
	EntityTypes []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntityTypesResponse) Reset()         { *m = ListEntityTypesResponse{} }
func (m *ListEntityTypesResponse) String() string { return proto.CompactTextString(m) }
func (*ListEntityTypesResponse) ProtoMessage()    {}
func (*ListEntityTypesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{2}
}

func (m *ListEntityTypesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntityTypesResponse.Unmarshal(m, b)
}
func (m *ListEntityTypesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntityTypesResponse.Marshal(b, m, deterministic)
}
func (m *ListEntityTypesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntityTypesResponse.Merge(m, src)
}
func (m *ListEntityTypesResponse) XXX_Size() int {
	return xxx_messageInfo_ListEntityTypesResponse.Size(m)
}
func (m *ListEntityTypesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntityTypesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntityTypesResponse proto.InternalMessageInfo

func (m *ListEntityTypesResponse) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func (m *ListEntityTypesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [EntityTypes.GetEntityType][google.cloud.dialogflow.v2.EntityTypes.GetEntityType].
type GetEntityTypeRequest struct {
	// Required. The name of the entity type.
	// Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The language to retrieve entity synonyms for. If not specified,
	// the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEntityTypeRequest) Reset()         { *m = GetEntityTypeRequest{} }
func (m *GetEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntityTypeRequest) ProtoMessage()    {}
func (*GetEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{3}
}

func (m *GetEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntityTypeRequest.Unmarshal(m, b)
}
func (m *GetEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *GetEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntityTypeRequest.Merge(m, src)
}
func (m *GetEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntityTypeRequest.Size(m)
}
func (m *GetEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntityTypeRequest proto.InternalMessageInfo

func (m *GetEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.CreateEntityType][google.cloud.dialogflow.v2.EntityTypes.CreateEntityType].
type CreateEntityTypeRequest struct {
	// Required. The agent to create a entity type for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entity type to create.
	EntityType *EntityType `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The language of entity synonyms defined in `entity_type`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateEntityTypeRequest) Reset()         { *m = CreateEntityTypeRequest{} }
func (m *CreateEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntityTypeRequest) ProtoMessage()    {}
func (*CreateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{4}
}

func (m *CreateEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntityTypeRequest.Unmarshal(m, b)
}
func (m *CreateEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *CreateEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntityTypeRequest.Merge(m, src)
}
func (m *CreateEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntityTypeRequest.Size(m)
}
func (m *CreateEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntityTypeRequest proto.InternalMessageInfo

func (m *CreateEntityTypeRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntityTypeRequest) GetEntityType() *EntityType {
	if m != nil {
		return m.EntityType
	}
	return nil
}

func (m *CreateEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType].
type UpdateEntityTypeRequest struct {
	// Required. The entity type to update.
	EntityType *EntityType `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The language of entity synonyms defined in `entity_type`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntityTypeRequest) Reset()         { *m = UpdateEntityTypeRequest{} }
func (m *UpdateEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntityTypeRequest) ProtoMessage()    {}
func (*UpdateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{5}
}

func (m *UpdateEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntityTypeRequest.Unmarshal(m, b)
}
func (m *UpdateEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntityTypeRequest.Merge(m, src)
}
func (m *UpdateEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntityTypeRequest.Size(m)
}
func (m *UpdateEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntityTypeRequest proto.InternalMessageInfo

func (m *UpdateEntityTypeRequest) GetEntityType() *EntityType {
	if m != nil {
		return m.EntityType
	}
	return nil
}

func (m *UpdateEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *UpdateEntityTypeRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [EntityTypes.DeleteEntityType][google.cloud.dialogflow.v2.EntityTypes.DeleteEntityType].
type DeleteEntityTypeRequest struct {
	// Required. The name of the entity type to delete.
	// Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntityTypeRequest) Reset()         { *m = DeleteEntityTypeRequest{} }
func (m *DeleteEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntityTypeRequest) ProtoMessage()    {}
func (*DeleteEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{6}
}

func (m *DeleteEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntityTypeRequest.Unmarshal(m, b)
}
func (m *DeleteEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntityTypeRequest.Merge(m, src)
}
func (m *DeleteEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntityTypeRequest.Size(m)
}
func (m *DeleteEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntityTypeRequest proto.InternalMessageInfo

func (m *DeleteEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes].
type BatchUpdateEntityTypesRequest struct {
	// Required. The name of the agent to update or create entity types in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source of the entity type batch.
	//
	// For each entity type in the batch:
	//
	// *   If `name` is specified, we update an existing entity type.
	// *   If `name` is not specified, we create a new entity type.
	//
	// Types that are valid to be assigned to EntityTypeBatch:
	//	*BatchUpdateEntityTypesRequest_EntityTypeBatchUri
	//	*BatchUpdateEntityTypesRequest_EntityTypeBatchInline
	EntityTypeBatch isBatchUpdateEntityTypesRequest_EntityTypeBatch `protobuf_oneof:"entity_type_batch"`
	// Optional. The language of entity synonyms defined in `entity_types`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateEntityTypesRequest) Reset()         { *m = BatchUpdateEntityTypesRequest{} }
func (m *BatchUpdateEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntityTypesRequest) ProtoMessage()    {}
func (*BatchUpdateEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{7}
}

func (m *BatchUpdateEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Unmarshal(m, b)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntityTypesRequest.Merge(m, src)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Size(m)
}
func (m *BatchUpdateEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntityTypesRequest proto.InternalMessageInfo

func (m *BatchUpdateEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isBatchUpdateEntityTypesRequest_EntityTypeBatch interface {
	isBatchUpdateEntityTypesRequest_EntityTypeBatch()
}

type BatchUpdateEntityTypesRequest_EntityTypeBatchUri struct {
	EntityTypeBatchUri string `protobuf:"bytes,2,opt,name=entity_type_batch_uri,json=entityTypeBatchUri,proto3,oneof"`
}

type BatchUpdateEntityTypesRequest_EntityTypeBatchInline struct {
	EntityTypeBatchInline *EntityTypeBatch `protobuf:"bytes,3,opt,name=entity_type_batch_inline,json=entityTypeBatchInline,proto3,oneof"`
}

func (*BatchUpdateEntityTypesRequest_EntityTypeBatchUri) isBatchUpdateEntityTypesRequest_EntityTypeBatch() {
}

func (*BatchUpdateEntityTypesRequest_EntityTypeBatchInline) isBatchUpdateEntityTypesRequest_EntityTypeBatch() {
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatch() isBatchUpdateEntityTypesRequest_EntityTypeBatch {
	if m != nil {
		return m.EntityTypeBatch
	}
	return nil
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatchUri() string {
	if x, ok := m.GetEntityTypeBatch().(*BatchUpdateEntityTypesRequest_EntityTypeBatchUri); ok {
		return x.EntityTypeBatchUri
	}
	return ""
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatchInline() *EntityTypeBatch {
	if x, ok := m.GetEntityTypeBatch().(*BatchUpdateEntityTypesRequest_EntityTypeBatchInline); ok {
		return x.EntityTypeBatchInline
	}
	return nil
}

func (m *BatchUpdateEntityTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateEntityTypesRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchUpdateEntityTypesRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchUpdateEntityTypesRequest_EntityTypeBatchUri)(nil),
		(*BatchUpdateEntityTypesRequest_EntityTypeBatchInline)(nil),
	}
}

// The response message for [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes].
type BatchUpdateEntityTypesResponse struct {
	// The collection of updated or created entity types.
	EntityTypes          []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchUpdateEntityTypesResponse) Reset()         { *m = BatchUpdateEntityTypesResponse{} }
func (m *BatchUpdateEntityTypesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntityTypesResponse) ProtoMessage()    {}
func (*BatchUpdateEntityTypesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{8}
}

func (m *BatchUpdateEntityTypesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Unmarshal(m, b)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Marshal(b, m, deterministic)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntityTypesResponse.Merge(m, src)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Size(m)
}
func (m *BatchUpdateEntityTypesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntityTypesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntityTypesResponse proto.InternalMessageInfo

func (m *BatchUpdateEntityTypesResponse) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

// The request message for [EntityTypes.BatchDeleteEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchDeleteEntityTypes].
type BatchDeleteEntityTypesRequest struct {
	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names entity types to delete. All names must point to the
	// same agent as `parent`.
	EntityTypeNames      []string `protobuf:"bytes,2,rep,name=entity_type_names,json=entityTypeNames,proto3" json:"entity_type_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteEntityTypesRequest) Reset()         { *m = BatchDeleteEntityTypesRequest{} }
func (m *BatchDeleteEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteEntityTypesRequest) ProtoMessage()    {}
func (*BatchDeleteEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{9}
}

func (m *BatchDeleteEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Unmarshal(m, b)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteEntityTypesRequest.Merge(m, src)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Size(m)
}
func (m *BatchDeleteEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteEntityTypesRequest proto.InternalMessageInfo

func (m *BatchDeleteEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteEntityTypesRequest) GetEntityTypeNames() []string {
	if m != nil {
		return m.EntityTypeNames
	}
	return nil
}

// The request message for [EntityTypes.BatchCreateEntities][google.cloud.dialogflow.v2.EntityTypes.BatchCreateEntities].
type BatchCreateEntitiesRequest struct {
	// Required. The name of the entity type to create entities in. Format:
	// `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entities to create.
	Entities []*EntityType_Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchCreateEntitiesRequest) Reset()         { *m = BatchCreateEntitiesRequest{} }
func (m *BatchCreateEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateEntitiesRequest) ProtoMessage()    {}
func (*BatchCreateEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{10}
}

func (m *BatchCreateEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchCreateEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateEntitiesRequest.Merge(m, src)
}
func (m *BatchCreateEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Size(m)
}
func (m *BatchCreateEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateEntitiesRequest proto.InternalMessageInfo

func (m *BatchCreateEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateEntitiesRequest) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *BatchCreateEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.BatchUpdateEntities][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntities].
type BatchUpdateEntitiesRequest struct {
	// Required. The name of the entity type to update or create entities in.
	// Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entities to update or create.
	Entities []*EntityType_Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateEntitiesRequest) Reset()         { *m = BatchUpdateEntitiesRequest{} }
func (m *BatchUpdateEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntitiesRequest) ProtoMessage()    {}
func (*BatchUpdateEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{11}
}

func (m *BatchUpdateEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchUpdateEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntitiesRequest.Merge(m, src)
}
func (m *BatchUpdateEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Size(m)
}
func (m *BatchUpdateEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntitiesRequest proto.InternalMessageInfo

func (m *BatchUpdateEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchUpdateEntitiesRequest) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *BatchUpdateEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateEntitiesRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [EntityTypes.BatchDeleteEntities][google.cloud.dialogflow.v2.EntityTypes.BatchDeleteEntities].
type BatchDeleteEntitiesRequest struct {
	// Required. The name of the entity type to delete entries for. Format:
	// `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The canonical `values` of the entities to delete. Note that
	// these are not fully-qualified names, i.e. they don't start with
	// `projects/<Project ID>`.
	EntityValues []string `protobuf:"bytes,2,rep,name=entity_values,json=entityValues,proto3" json:"entity_values,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteEntitiesRequest) Reset()         { *m = BatchDeleteEntitiesRequest{} }
func (m *BatchDeleteEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteEntitiesRequest) ProtoMessage()    {}
func (*BatchDeleteEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{12}
}

func (m *BatchDeleteEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchDeleteEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteEntitiesRequest.Merge(m, src)
}
func (m *BatchDeleteEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Size(m)
}
func (m *BatchDeleteEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteEntitiesRequest proto.InternalMessageInfo

func (m *BatchDeleteEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteEntitiesRequest) GetEntityValues() []string {
	if m != nil {
		return m.EntityValues
	}
	return nil
}

func (m *BatchDeleteEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// This message is a wrapper around a collection of entity types.
type EntityTypeBatch struct {
	// A collection of entity types.
	EntityTypes          []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EntityTypeBatch) Reset()         { *m = EntityTypeBatch{} }
func (m *EntityTypeBatch) String() string { return proto.CompactTextString(m) }
func (*EntityTypeBatch) ProtoMessage()    {}
func (*EntityTypeBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_252de8d6c5f5c76d, []int{13}
}

func (m *EntityTypeBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityTypeBatch.Unmarshal(m, b)
}
func (m *EntityTypeBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityTypeBatch.Marshal(b, m, deterministic)
}
func (m *EntityTypeBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityTypeBatch.Merge(m, src)
}
func (m *EntityTypeBatch) XXX_Size() int {
	return xxx_messageInfo_EntityTypeBatch.Size(m)
}
func (m *EntityTypeBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityTypeBatch.DiscardUnknown(m)
}

var xxx_messageInfo_EntityTypeBatch proto.InternalMessageInfo

func (m *EntityTypeBatch) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2.EntityType_Kind", EntityType_Kind_name, EntityType_Kind_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.EntityType_AutoExpansionMode", EntityType_AutoExpansionMode_name, EntityType_AutoExpansionMode_value)
	proto.RegisterType((*EntityType)(nil), "google.cloud.dialogflow.v2.EntityType")
	proto.RegisterType((*EntityType_Entity)(nil), "google.cloud.dialogflow.v2.EntityType.Entity")
	proto.RegisterType((*ListEntityTypesRequest)(nil), "google.cloud.dialogflow.v2.ListEntityTypesRequest")
	proto.RegisterType((*ListEntityTypesResponse)(nil), "google.cloud.dialogflow.v2.ListEntityTypesResponse")
	proto.RegisterType((*GetEntityTypeRequest)(nil), "google.cloud.dialogflow.v2.GetEntityTypeRequest")
	proto.RegisterType((*CreateEntityTypeRequest)(nil), "google.cloud.dialogflow.v2.CreateEntityTypeRequest")
	proto.RegisterType((*UpdateEntityTypeRequest)(nil), "google.cloud.dialogflow.v2.UpdateEntityTypeRequest")
	proto.RegisterType((*DeleteEntityTypeRequest)(nil), "google.cloud.dialogflow.v2.DeleteEntityTypeRequest")
	proto.RegisterType((*BatchUpdateEntityTypesRequest)(nil), "google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest")
	proto.RegisterType((*BatchUpdateEntityTypesResponse)(nil), "google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse")
	proto.RegisterType((*BatchDeleteEntityTypesRequest)(nil), "google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest")
	proto.RegisterType((*BatchCreateEntitiesRequest)(nil), "google.cloud.dialogflow.v2.BatchCreateEntitiesRequest")
	proto.RegisterType((*BatchUpdateEntitiesRequest)(nil), "google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest")
	proto.RegisterType((*BatchDeleteEntitiesRequest)(nil), "google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest")
	proto.RegisterType((*EntityTypeBatch)(nil), "google.cloud.dialogflow.v2.EntityTypeBatch")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/entity_type.proto", fileDescriptor_252de8d6c5f5c76d)
}

var fileDescriptor_252de8d6c5f5c76d = []byte{
	// 1282 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x98, 0xdf, 0x6f, 0xdb, 0x54,
	0x14, 0xc7, 0x77, 0xd3, 0xac, 0x6a, 0x4f, 0xda, 0x35, 0xbb, 0xeb, 0xda, 0xe0, 0xd2, 0xad, 0xb8,
	0xd2, 0x54, 0xba, 0x35, 0x86, 0x54, 0x43, 0x5b, 0x27, 0x60, 0x69, 0x93, 0x76, 0xa1, 0xbf, 0x22,
	0xb7, 0x9d, 0x18, 0x42, 0xb2, 0xdc, 0xe4, 0x36, 0x35, 0x75, 0xee, 0x35, 0xb1, 0xd3, 0x36, 0x43,
	0xe3, 0x81, 0x57, 0x78, 0x01, 0x5e, 0x11, 0x48, 0x88, 0x27, 0x24, 0xc4, 0x0b, 0x2f, 0x88, 0x57,
	0x9e, 0xe0, 0x0d, 0xfe, 0x02, 0x24, 0xfe, 0x08, 0x5e, 0x90, 0x90, 0xaf, 0xed, 0xda, 0x71, 0x9c,
	0xc4, 0x15, 0x65, 0xe2, 0x2d, 0xbe, 0xf7, 0xf8, 0x9c, 0xcf, 0xf9, 0x71, 0xef, 0x37, 0x09, 0xdc,
	0xa9, 0x31, 0x56, 0xd3, 0x89, 0x54, 0xd1, 0x59, 0xb3, 0x2a, 0x55, 0x35, 0x55, 0x67, 0xb5, 0x03,
	0x9d, 0x9d, 0x48, 0xc7, 0x39, 0x89, 0x50, 0x4b, 0xb3, 0x5a, 0x8a, 0xd5, 0x32, 0x48, 0xd6, 0x68,
	0x30, 0x8b, 0x61, 0xc1, 0xb1, 0xce, 0x72, 0xeb, 0xac, 0x6f, 0x9d, 0x3d, 0xce, 0x09, 0x2f, 0xba,
	0x9e, 0x54, 0x43, 0x93, 0x54, 0x4a, 0x99, 0xa5, 0x5a, 0x1a, 0xa3, 0xa6, 0xf3, 0xa6, 0x30, 0xeb,
	0xee, 0xea, 0x8c, 0xd6, 0x1a, 0x4d, 0x4a, 0x35, 0x5a, 0x93, 0x98, 0x41, 0x1a, 0x6d, 0x46, 0x53,
	0xae, 0x11, 0x7f, 0xda, 0x6f, 0x1e, 0x48, 0xa4, 0x6e, 0x58, 0x2d, 0x77, 0x73, 0x26, 0xbc, 0x79,
	0xa0, 0x11, 0xbd, 0xaa, 0xd4, 0x55, 0xf3, 0xc8, 0xb5, 0x98, 0x0c, 0x10, 0x54, 0x74, 0x8d, 0x50,
	0xcb, 0xd9, 0x10, 0x3f, 0x4e, 0x02, 0x14, 0x79, 0x32, 0xbb, 0x2d, 0x83, 0x60, 0x0c, 0x49, 0xaa,
	0xd6, 0x49, 0x06, 0xcd, 0xa0, 0xb9, 0x61, 0x99, 0x7f, 0xc6, 0x2f, 0xc1, 0x48, 0x55, 0x33, 0x0d,
	0x5d, 0x6d, 0x29, 0x7c, 0x2f, 0xc1, 0xf7, 0x52, 0xee, 0xda, 0x96, 0x6d, 0xf2, 0x26, 0x24, 0x8f,
	0x34, 0x5a, 0xcd, 0x0c, 0xcc, 0xa0, 0xb9, 0x2b, 0xb9, 0xdb, 0xd9, 0xee, 0xb5, 0xc8, 0xfa, 0xc1,
	0xb2, 0xeb, 0x1a, 0xad, 0xca, 0xfc, 0x45, 0x7c, 0x08, 0xd7, 0xd4, 0xa6, 0xc5, 0x14, 0x72, 0x6a,
	0xa8, 0xd4, 0xd4, 0x18, 0x55, 0xea, 0xac, 0x4a, 0x32, 0x49, 0xee, 0xef, 0x5e, 0x4c, 0x7f, 0xf9,
	0xa6, 0xc5, 0x8a, 0x9e, 0x83, 0x4d, 0x56, 0x25, 0xf2, 0x55, 0x35, 0xbc, 0x84, 0x4b, 0x30, 0xc4,
	0x9b, 0xa7, 0x11, 0x33, 0x33, 0x38, 0x33, 0x30, 0x97, 0xca, 0x2d, 0xc4, 0x74, 0xef, 0x7c, 0x94,
	0xcf, 0x5e, 0x17, 0x96, 0x60, 0xd0, 0x59, 0xc3, 0xe3, 0x70, 0xf9, 0x58, 0xd5, 0x9b, 0x5e, 0xdd,
	0x9c, 0x07, 0x2c, 0xc0, 0x90, 0xd9, 0xa2, 0x8c, 0xb6, 0xea, 0x66, 0x26, 0x31, 0x33, 0x30, 0x37,
	0x2c, 0x9f, 0x3d, 0x8b, 0xf7, 0x21, 0x69, 0xa7, 0x8f, 0xc7, 0x21, 0xbd, 0x5e, 0xda, 0x2a, 0x28,
	0x7b, 0x5b, 0x3b, 0xe5, 0xe2, 0x4a, 0x69, 0xb5, 0x54, 0x2c, 0xa4, 0x2f, 0xe1, 0x11, 0x18, 0xe2,
	0xab, 0x9b, 0xf9, 0x72, 0x1a, 0xe1, 0x51, 0x18, 0xe6, 0x4f, 0x1b, 0xa5, 0x9d, 0xdd, 0x74, 0x42,
	0x7c, 0x02, 0x57, 0x3b, 0x32, 0xc5, 0xb3, 0x70, 0x33, 0xbf, 0xb7, 0xbb, 0xad, 0x14, 0xdf, 0x2e,
	0xe7, 0xb7, 0x76, 0x4a, 0xdb, 0x5b, 0xca, 0xe6, 0x76, 0xa1, 0x18, 0x72, 0x7b, 0x13, 0xa6, 0xa2,
	0x8c, 0x0a, 0xc5, 0xd5, 0xfc, 0xde, 0xc6, 0x6e, 0x1a, 0x89, 0x9f, 0x22, 0x98, 0xd8, 0xd0, 0x4c,
	0xcb, 0xcf, 0xda, 0x94, 0xc9, 0xfb, 0x4d, 0x62, 0x5a, 0x78, 0x02, 0x06, 0x0d, 0xb5, 0x41, 0xa8,
	0xe5, 0xe6, 0xe8, 0x3e, 0xe1, 0x59, 0x18, 0xd5, 0x55, 0x5a, 0x6b, 0xaa, 0x35, 0xa2, 0x54, 0xec,
	0x9e, 0x39, 0xe3, 0x31, 0xe2, 0x2d, 0xae, 0xd8, 0x74, 0x53, 0x30, 0x6c, 0xd8, 0x06, 0xa6, 0xf6,
	0x94, 0xf0, 0x21, 0xb9, 0x2c, 0x0f, 0xd9, 0x0b, 0x3b, 0xda, 0x53, 0x82, 0xa7, 0x01, 0xf8, 0xa6,
	0xc5, 0x8e, 0x08, 0xe5, 0x2d, 0x1f, 0x96, 0xb9, 0xf9, 0xae, 0xbd, 0x20, 0x7e, 0x82, 0x60, 0xb2,
	0x83, 0xc9, 0x34, 0x18, 0x35, 0xed, 0x66, 0x8e, 0x04, 0x4e, 0xa2, 0x99, 0x41, 0xbc, 0xa1, 0xb7,
	0xe2, 0x35, 0x54, 0x4e, 0x11, 0xdf, 0x25, 0xbe, 0x05, 0x63, 0x94, 0x9c, 0x5a, 0x4a, 0x00, 0xc5,
	0xc9, 0x64, 0xd4, 0x5e, 0x2e, 0x9f, 0xe1, 0x6c, 0xc3, 0xf8, 0x1a, 0x09, 0xc0, 0x78, 0xf5, 0x89,
	0x3a, 0x39, 0x71, 0x6a, 0x23, 0x7e, 0x85, 0x60, 0x72, 0xa5, 0x41, 0x54, 0x8b, 0x74, 0x3a, 0xed,
	0x56, 0xf4, 0x35, 0x48, 0x05, 0xf2, 0xe6, 0x6e, 0xe3, 0xa7, 0x0d, 0x7e, 0xda, 0x9d, 0x84, 0x03,
	0x11, 0x84, 0x3f, 0x23, 0x98, 0xdc, 0x33, 0xaa, 0x91, 0x84, 0x21, 0x12, 0x74, 0x71, 0x24, 0x51,
	0x73, 0xf4, 0x00, 0x52, 0x4d, 0x0e, 0xc2, 0xef, 0x36, 0x0e, 0x9b, 0xca, 0x09, 0x5e, 0x34, 0xef,
	0xfa, 0xcb, 0xae, 0xda, 0xd7, 0xdf, 0xa6, 0x6a, 0x1e, 0xc9, 0xe0, 0x98, 0xdb, 0x9f, 0xc5, 0x05,
	0x98, 0x2c, 0x10, 0x9d, 0x44, 0x65, 0x11, 0xd1, 0x3c, 0xf1, 0xd7, 0x04, 0x4c, 0x2f, 0xab, 0x56,
	0xe5, 0x30, 0x9c, 0x7a, 0xdf, 0x23, 0xb1, 0x08, 0xd7, 0x03, 0x35, 0x51, 0xf6, 0x6d, 0x27, 0x4a,
	0xb3, 0xa1, 0x39, 0x29, 0x3d, 0xba, 0x24, 0x63, 0x3f, 0x6f, 0x27, 0x42, 0x43, 0xc3, 0x07, 0x90,
	0xe9, 0x7c, 0x49, 0xa3, 0xba, 0x46, 0x89, 0x9b, 0x67, 0xcc, 0x6b, 0x95, 0x7b, 0x7c, 0x74, 0x49,
	0xbe, 0x1e, 0x0a, 0x52, 0xe2, 0xbe, 0x3a, 0xeb, 0x9c, 0xec, 0x5f, 0xe7, 0xcb, 0xe7, 0xa9, 0xf3,
	0xf2, 0x35, 0xb8, 0xda, 0x91, 0x89, 0x78, 0x04, 0x37, 0xba, 0x15, 0xf3, 0xc2, 0xcf, 0xb2, 0x58,
	0x71, 0x3b, 0x17, 0x6e, 0x77, 0xdf, 0xce, 0xcd, 0xb7, 0xa3, 0xdb, 0x73, 0xe0, 0x5d, 0xdd, 0x63,
	0x7e, 0x00, 0x5b, 0xf2, 0x4c, 0xf1, 0x1b, 0x04, 0x02, 0x8f, 0x12, 0x38, 0xbc, 0x5a, 0xff, 0x10,
	0x41, 0xfd, 0x49, 0xfc, 0x2b, 0xfd, 0x89, 0x77, 0x78, 0xff, 0xf0, 0x30, 0x03, 0x95, 0xff, 0xff,
	0x61, 0x86, 0x27, 0x2e, 0x79, 0xae, 0x93, 0xfd, 0xa1, 0x9b, 0x62, 0xa0, 0xdf, 0x5a, 0x2c, 0xe5,
	0x72, 0x9b, 0xcd, 0xe5, 0xda, 0x6b, 0xb4, 0x3b, 0x85, 0x8f, 0xf9, 0x5a, 0xbc, 0x1a, 0xbf, 0x0b,
	0x63, 0xa1, 0xf3, 0x77, 0x81, 0xd3, 0x9c, 0xfb, 0xfb, 0x0a, 0xa4, 0x02, 0x33, 0x8c, 0xbf, 0x43,
	0x30, 0x16, 0x12, 0x44, 0x9c, 0xeb, 0xe5, 0x38, 0x5a, 0xd1, 0x85, 0xc5, 0x73, 0xbd, 0xe3, 0x9c,
	0x52, 0xf1, 0xd5, 0x8f, 0x7e, 0xff, 0xf3, 0xf3, 0xc4, 0x6d, 0xfc, 0xb2, 0xfd, 0x2d, 0xf8, 0x03,
	0xa7, 0x92, 0xaf, 0x1b, 0x0d, 0xf6, 0x1e, 0xa9, 0x58, 0xa6, 0x34, 0x2f, 0xa9, 0x35, 0x42, 0xad,
	0x67, 0x52, 0x50, 0x59, 0xbf, 0x40, 0x30, 0xda, 0x26, 0x99, 0xf8, 0x95, 0x5e, 0x91, 0xa3, 0xd4,
	0x55, 0x88, 0x59, 0xb8, 0x10, 0x9e, 0x7d, 0x7e, 0x3b, 0xe0, 0x82, 0x6c, 0xd2, 0xfc, 0x33, 0xfc,
	0x3d, 0x82, 0x74, 0x58, 0x7f, 0x71, 0xcf, 0xda, 0x74, 0x51, 0xeb, 0xd8, 0x90, 0x6f, 0x70, 0xc8,
	0x7b, 0x62, 0xfc, 0x1a, 0x2e, 0x05, 0x45, 0x16, 0xff, 0x84, 0x20, 0x1d, 0xbe, 0x47, 0x7b, 0x13,
	0x77, 0x51, 0xef, 0xd8, 0xc4, 0x6f, 0x71, 0xe2, 0x42, 0xee, 0x2e, 0x27, 0x0e, 0xfe, 0xf8, 0x89,
	0x53, 0xe2, 0x76, 0xfa, 0xcf, 0x10, 0xa4, 0xc3, 0x17, 0x73, 0x6f, 0xfa, 0x2e, 0xaa, 0x2d, 0x4c,
	0x74, 0x5c, 0x0f, 0x45, 0xfb, 0x47, 0x91, 0x37, 0x04, 0xf3, 0xe7, 0x18, 0x82, 0x1f, 0x10, 0x4c,
	0x44, 0xeb, 0x13, 0xbe, 0xdf, 0x0b, 0xad, 0xe7, 0x17, 0x04, 0x61, 0xda, 0x7b, 0x35, 0xf0, 0xd3,
	0x2e, 0xbb, 0xed, 0xfd, 0xb4, 0x13, 0x1f, 0x72, 0xce, 0x25, 0xf1, 0x6e, 0xfc, 0x39, 0xd8, 0xf7,
	0xe3, 0x2d, 0xa1, 0x79, 0x1f, 0xbb, 0x43, 0xe9, 0x62, 0x60, 0x77, 0x53, 0xc7, 0xff, 0x0a, 0xdb,
	0x89, 0x67, 0x63, 0xff, 0x88, 0xe0, 0x5a, 0x84, 0x74, 0xe2, 0xd7, 0xfa, 0x32, 0x47, 0x6a, 0x6d,
	0x3f, 0xe0, 0x75, 0x0e, 0x5c, 0x14, 0x1f, 0xf6, 0x02, 0x0e, 0x4d, 0x84, 0xe4, 0xc9, 0x97, 0xc3,
	0xee, 0xc4, 0x6d, 0x63, 0x6f, 0xd7, 0xd3, 0x18, 0xec, 0x91, 0x02, 0xfc, 0x1c, 0xd8, 0xfd, 0x71,
	0x39, 0x63, 0x6f, 0x17, 0xca, 0x18, 0xec, 0x91, 0xca, 0xfa, 0x1c, 0xd8, 0xcf, 0x66, 0x46, 0x38,
	0xfd, 0x25, 0xff, 0x42, 0x00, 0xcc, 0x09, 0xac, 0x1a, 0x9a, 0x99, 0xad, 0xb0, 0xfa, 0x6f, 0xf9,
	0x27, 0x87, 0x96, 0x65, 0x98, 0x4b, 0x92, 0x74, 0x72, 0x12, 0xde, 0x94, 0xd4, 0xa6, 0x75, 0xe8,
	0xfc, 0x8b, 0xb3, 0x60, 0xe8, 0xaa, 0x75, 0xc0, 0x1a, 0xf5, 0x3b, 0xfd, 0xcc, 0xfd, 0x50, 0xcb,
	0x5f, 0x22, 0xb8, 0x51, 0x61, 0xf5, 0x1e, 0x35, 0x5a, 0x0e, 0xc8, 0x7f, 0xd9, 0xbe, 0x8b, 0xca,
	0xe8, 0x9d, 0x82, 0x6b, 0x5e, 0x63, 0xf6, 0x57, 0x85, 0x2c, 0x6b, 0xd4, 0xa4, 0x1a, 0xa1, 0xfc,
	0xa6, 0x92, 0xfc, 0x80, 0x51, 0x7f, 0x2e, 0x3d, 0xf0, 0x9f, 0xfe, 0x42, 0xe8, 0xeb, 0x44, 0xa2,
	0xb0, 0xfa, 0x6d, 0x42, 0x58, 0x73, 0xdc, 0xad, 0xf0, 0xe8, 0x05, 0x3f, 0xfa, 0xe3, 0xdc, 0xfe,
	0x20, 0xf7, 0xba, 0xf8, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0xe9, 0x1d, 0x28, 0xb1, 0x12,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// EntityTypesClient is the client API for EntityTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EntityTypesClient interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Updates the specified entity type.
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes the specified entity type.
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// Operation <response: [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse]>
	BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type entityTypesClient struct {
	cc *grpc.ClientConn
}

func NewEntityTypesClient(cc *grpc.ClientConn) EntityTypesClient {
	return &entityTypesClient{cc}
}

func (c *entityTypesClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/ListEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/GetEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/CreateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/UpdateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/DeleteEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/BatchUpdateEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/BatchDeleteEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/BatchCreateEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/BatchUpdateEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.EntityTypes/BatchDeleteEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityTypesServer is the server API for EntityTypes service.
type EntityTypesServer interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error)
	// Updates the specified entity type.
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes the specified entity type.
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*empty.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// Operation <response: [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse]>
	BatchUpdateEntityTypes(context.Context, *BatchUpdateEntityTypesRequest) (*longrunning.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntityTypes(context.Context, *BatchDeleteEntityTypesRequest) (*longrunning.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchCreateEntities(context.Context, *BatchCreateEntitiesRequest) (*longrunning.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchUpdateEntities(context.Context, *BatchUpdateEntitiesRequest) (*longrunning.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntities(context.Context, *BatchDeleteEntitiesRequest) (*longrunning.Operation, error)
}

func RegisterEntityTypesServer(s *grpc.Server, srv EntityTypesServer) {
	s.RegisterService(&_EntityTypes_serviceDesc, srv)
}

func _EntityTypes_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/ListEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/GetEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/CreateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/UpdateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/DeleteEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/BatchUpdateEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, req.(*BatchUpdateEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/BatchDeleteEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, req.(*BatchDeleteEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchCreateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/BatchCreateEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, req.(*BatchCreateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/BatchUpdateEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, req.(*BatchUpdateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.EntityTypes/BatchDeleteEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, req.(*BatchDeleteEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EntityTypes_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.EntityTypes",
	HandlerType: (*EntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEntityTypes",
			Handler:    _EntityTypes_ListEntityTypes_Handler,
		},
		{
			MethodName: "GetEntityType",
			Handler:    _EntityTypes_GetEntityType_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _EntityTypes_CreateEntityType_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _EntityTypes_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _EntityTypes_DeleteEntityType_Handler,
		},
		{
			MethodName: "BatchUpdateEntityTypes",
			Handler:    _EntityTypes_BatchUpdateEntityTypes_Handler,
		},
		{
			MethodName: "BatchDeleteEntityTypes",
			Handler:    _EntityTypes_BatchDeleteEntityTypes_Handler,
		},
		{
			MethodName: "BatchCreateEntities",
			Handler:    _EntityTypes_BatchCreateEntities_Handler,
		},
		{
			MethodName: "BatchUpdateEntities",
			Handler:    _EntityTypes_BatchUpdateEntities_Handler,
		},
		{
			MethodName: "BatchDeleteEntities",
			Handler:    _EntityTypes_BatchDeleteEntities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/entity_type.proto",
}
