// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/core/v1/generated.proto

/*
	Package v1 is a generated protocol buffer package.

	It is generated from these files:
		k8s.io/api/core/v1/generated.proto

	It has these top-level messages:
		AWSElasticBlockStoreVolumeSource
		Affinity
		AttachedVolume
		AvoidPods
		AzureDiskVolumeSource
		AzureFilePersistentVolumeSource
		AzureFileVolumeSource
		Binding
		CSIPersistentVolumeSource
		Capabilities
		CephFSPersistentVolumeSource
		CephFSVolumeSource
		CinderVolumeSource
		ClientIPConfig
		ComponentCondition
		ComponentStatus
		ComponentStatusList
		ConfigMap
		ConfigMapEnvSource
		ConfigMapKeySelector
		ConfigMapList
		ConfigMapProjection
		ConfigMapVolumeSource
		Container
		ContainerImage
		ContainerPort
		ContainerState
		ContainerStateRunning
		ContainerStateTerminated
		ContainerStateWaiting
		ContainerStatus
		DaemonEndpoint
		DeleteOptions
		DownwardAPIProjection
		DownwardAPIVolumeFile
		DownwardAPIVolumeSource
		EmptyDirVolumeSource
		EndpointAddress
		EndpointPort
		EndpointSubset
		Endpoints
		EndpointsList
		EnvFromSource
		EnvVar
		EnvVarSource
		Event
		EventList
		EventSeries
		EventSource
		ExecAction
		FCVolumeSource
		FlexPersistentVolumeSource
		FlexVolumeSource
		FlockerVolumeSource
		GCEPersistentDiskVolumeSource
		GitRepoVolumeSource
		GlusterfsVolumeSource
		HTTPGetAction
		HTTPHeader
		Handler
		HostAlias
		HostPathVolumeSource
		ISCSIPersistentVolumeSource
		ISCSIVolumeSource
		KeyToPath
		Lifecycle
		LimitRange
		LimitRangeItem
		LimitRangeList
		LimitRangeSpec
		List
		ListOptions
		LoadBalancerIngress
		LoadBalancerStatus
		LocalObjectReference
		LocalVolumeSource
		NFSVolumeSource
		Namespace
		NamespaceList
		NamespaceSpec
		NamespaceStatus
		Node
		NodeAddress
		NodeAffinity
		NodeCondition
		NodeConfigSource
		NodeDaemonEndpoints
		NodeList
		NodeProxyOptions
		NodeResources
		NodeSelector
		NodeSelectorRequirement
		NodeSelectorTerm
		NodeSpec
		NodeStatus
		NodeSystemInfo
		ObjectFieldSelector
		ObjectMeta
		ObjectReference
		PersistentVolume
		PersistentVolumeClaim
		PersistentVolumeClaimCondition
		PersistentVolumeClaimList
		PersistentVolumeClaimSpec
		PersistentVolumeClaimStatus
		PersistentVolumeClaimVolumeSource
		PersistentVolumeList
		PersistentVolumeSource
		PersistentVolumeSpec
		PersistentVolumeStatus
		PhotonPersistentDiskVolumeSource
		Pod
		PodAffinity
		PodAffinityTerm
		PodAntiAffinity
		PodAttachOptions
		PodCondition
		PodDNSConfig
		PodDNSConfigOption
		PodExecOptions
		PodList
		PodLogOptions
		PodPortForwardOptions
		PodProxyOptions
		PodSecurityContext
		PodSignature
		PodSpec
		PodStatus
		PodStatusResult
		PodTemplate
		PodTemplateList
		PodTemplateSpec
		PortworxVolumeSource
		Preconditions
		PreferAvoidPodsEntry
		PreferredSchedulingTerm
		Probe
		ProjectedVolumeSource
		QuobyteVolumeSource
		RBDPersistentVolumeSource
		RBDVolumeSource
		RangeAllocation
		ReplicationController
		ReplicationControllerCondition
		ReplicationControllerList
		ReplicationControllerSpec
		ReplicationControllerStatus
		ResourceFieldSelector
		ResourceQuota
		ResourceQuotaList
		ResourceQuotaSpec
		ResourceQuotaStatus
		ResourceRequirements
		SELinuxOptions
		ScaleIOPersistentVolumeSource
		ScaleIOVolumeSource
		Secret
		SecretEnvSource
		SecretKeySelector
		SecretList
		SecretProjection
		SecretReference
		SecretVolumeSource
		SecurityContext
		SerializedReference
		Service
		ServiceAccount
		ServiceAccountList
		ServiceList
		ServicePort
		ServiceProxyOptions
		ServiceSpec
		ServiceStatus
		SessionAffinityConfig
		StorageOSPersistentVolumeSource
		StorageOSVolumeSource
		Sysctl
		TCPSocketAction
		Taint
		Toleration
		Volume
		VolumeDevice
		VolumeMount
		VolumeNodeAffinity
		VolumeProjection
		VolumeSource
		VsphereVirtualDiskVolumeSource
		WeightedPodAffinityTerm
*/
package v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/ericchiang/k8s/apis/apiextensions/v1beta1"
import k8s_io_apimachinery_pkg_api_resource "github.com/ericchiang/k8s/apis/resource"
import k8s_io_apimachinery_pkg_apis_meta_v1 "github.com/ericchiang/k8s/apis/meta/v1"
import k8s_io_apimachinery_pkg_runtime "github.com/ericchiang/k8s/runtime"
import _ "github.com/ericchiang/k8s/runtime/schema"
import k8s_io_apimachinery_pkg_util_intstr "github.com/ericchiang/k8s/util/intstr"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents a Persistent Disk resource in AWS.
//
// An AWS EBS disk must exist before mounting to a container. The disk
// must also be in the same AWS zone as the kubelet. An AWS EBS disk
// can only be mounted as read/write once. AWS EBS volumes support
// ownership management and SELinux relabeling.
type AWSElasticBlockStoreVolumeSource struct {
	// Unique ID of the persistent disk resource in AWS (Amazon EBS volume).
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	VolumeID *string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID,omitempty"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// The partition in the volume that you want to mount.
	// If omitted, the default is to mount by volume name.
	// Examples: For volume /dev/sda1, you specify the partition as "1".
	// Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
	// +optional
	Partition *int32 `protobuf:"varint,3,opt,name=partition" json:"partition,omitempty"`
	// Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".
	// If omitted, the default is "false".
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// +optional
	ReadOnly         *bool  `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AWSElasticBlockStoreVolumeSource) Reset()         { *m = AWSElasticBlockStoreVolumeSource{} }
func (m *AWSElasticBlockStoreVolumeSource) String() string { return proto.CompactTextString(m) }
func (*AWSElasticBlockStoreVolumeSource) ProtoMessage()    {}
func (*AWSElasticBlockStoreVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{0}
}

func (m *AWSElasticBlockStoreVolumeSource) GetVolumeID() string {
	if m != nil && m.VolumeID != nil {
		return *m.VolumeID
	}
	return ""
}

func (m *AWSElasticBlockStoreVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *AWSElasticBlockStoreVolumeSource) GetPartition() int32 {
	if m != nil && m.Partition != nil {
		return *m.Partition
	}
	return 0
}

func (m *AWSElasticBlockStoreVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Affinity is a group of affinity scheduling rules.
type Affinity struct {
	// Describes node affinity scheduling rules for the pod.
	// +optional
	NodeAffinity *NodeAffinity `protobuf:"bytes,1,opt,name=nodeAffinity" json:"nodeAffinity,omitempty"`
	// Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
	// +optional
	PodAffinity *PodAffinity `protobuf:"bytes,2,opt,name=podAffinity" json:"podAffinity,omitempty"`
	// Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
	// +optional
	PodAntiAffinity  *PodAntiAffinity `protobuf:"bytes,3,opt,name=podAntiAffinity" json:"podAntiAffinity,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Affinity) Reset()                    { *m = Affinity{} }
func (m *Affinity) String() string            { return proto.CompactTextString(m) }
func (*Affinity) ProtoMessage()               {}
func (*Affinity) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{1} }

func (m *Affinity) GetNodeAffinity() *NodeAffinity {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

func (m *Affinity) GetPodAffinity() *PodAffinity {
	if m != nil {
		return m.PodAffinity
	}
	return nil
}

func (m *Affinity) GetPodAntiAffinity() *PodAntiAffinity {
	if m != nil {
		return m.PodAntiAffinity
	}
	return nil
}

// AttachedVolume describes a volume attached to a node
type AttachedVolume struct {
	// Name of the attached volume
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// DevicePath represents the device path where the volume should be available
	DevicePath       *string `protobuf:"bytes,2,opt,name=devicePath" json:"devicePath,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AttachedVolume) Reset()                    { *m = AttachedVolume{} }
func (m *AttachedVolume) String() string            { return proto.CompactTextString(m) }
func (*AttachedVolume) ProtoMessage()               {}
func (*AttachedVolume) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{2} }

func (m *AttachedVolume) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *AttachedVolume) GetDevicePath() string {
	if m != nil && m.DevicePath != nil {
		return *m.DevicePath
	}
	return ""
}

// AvoidPods describes pods that should avoid this node. This is the value for a
// Node annotation with key scheduler.alpha.kubernetes.io/preferAvoidPods and
// will eventually become a field of NodeStatus.
type AvoidPods struct {
	// Bounded-sized list of signatures of pods that should avoid this node, sorted
	// in timestamp order from oldest to newest. Size of the slice is unspecified.
	// +optional
	PreferAvoidPods  []*PreferAvoidPodsEntry `protobuf:"bytes,1,rep,name=preferAvoidPods" json:"preferAvoidPods,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *AvoidPods) Reset()                    { *m = AvoidPods{} }
func (m *AvoidPods) String() string            { return proto.CompactTextString(m) }
func (*AvoidPods) ProtoMessage()               {}
func (*AvoidPods) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{3} }

func (m *AvoidPods) GetPreferAvoidPods() []*PreferAvoidPodsEntry {
	if m != nil {
		return m.PreferAvoidPods
	}
	return nil
}

// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
type AzureDiskVolumeSource struct {
	// The Name of the data disk in the blob storage
	DiskName *string `protobuf:"bytes,1,opt,name=diskName" json:"diskName,omitempty"`
	// The URI the data disk in the blob storage
	DiskURI *string `protobuf:"bytes,2,opt,name=diskURI" json:"diskURI,omitempty"`
	// Host Caching mode: None, Read Only, Read Write.
	// +optional
	CachingMode *string `protobuf:"bytes,3,opt,name=cachingMode" json:"cachingMode,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,4,opt,name=fsType" json:"fsType,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,5,opt,name=readOnly" json:"readOnly,omitempty"`
	// Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
	Kind             *string `protobuf:"bytes,6,opt,name=kind" json:"kind,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AzureDiskVolumeSource) Reset()                    { *m = AzureDiskVolumeSource{} }
func (m *AzureDiskVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*AzureDiskVolumeSource) ProtoMessage()               {}
func (*AzureDiskVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{4} }

func (m *AzureDiskVolumeSource) GetDiskName() string {
	if m != nil && m.DiskName != nil {
		return *m.DiskName
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetDiskURI() string {
	if m != nil && m.DiskURI != nil {
		return *m.DiskURI
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetCachingMode() string {
	if m != nil && m.CachingMode != nil {
		return *m.CachingMode
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *AzureDiskVolumeSource) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
type AzureFilePersistentVolumeSource struct {
	// the name of secret that contains Azure Storage Account Name and Key
	SecretName *string `protobuf:"bytes,1,opt,name=secretName" json:"secretName,omitempty"`
	// Share Name
	ShareName *string `protobuf:"bytes,2,opt,name=shareName" json:"shareName,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	// the namespace of the secret that contains Azure Storage Account Name and Key
	// default is the same as the Pod
	// +optional
	SecretNamespace  *string `protobuf:"bytes,4,opt,name=secretNamespace" json:"secretNamespace,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AzureFilePersistentVolumeSource) Reset()         { *m = AzureFilePersistentVolumeSource{} }
func (m *AzureFilePersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*AzureFilePersistentVolumeSource) ProtoMessage()    {}
func (*AzureFilePersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{5}
}

func (m *AzureFilePersistentVolumeSource) GetSecretName() string {
	if m != nil && m.SecretName != nil {
		return *m.SecretName
	}
	return ""
}

func (m *AzureFilePersistentVolumeSource) GetShareName() string {
	if m != nil && m.ShareName != nil {
		return *m.ShareName
	}
	return ""
}

func (m *AzureFilePersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *AzureFilePersistentVolumeSource) GetSecretNamespace() string {
	if m != nil && m.SecretNamespace != nil {
		return *m.SecretNamespace
	}
	return ""
}

// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
type AzureFileVolumeSource struct {
	// the name of secret that contains Azure Storage Account Name and Key
	SecretName *string `protobuf:"bytes,1,opt,name=secretName" json:"secretName,omitempty"`
	// Share Name
	ShareName *string `protobuf:"bytes,2,opt,name=shareName" json:"shareName,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly         *bool  `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AzureFileVolumeSource) Reset()                    { *m = AzureFileVolumeSource{} }
func (m *AzureFileVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*AzureFileVolumeSource) ProtoMessage()               {}
func (*AzureFileVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{6} }

func (m *AzureFileVolumeSource) GetSecretName() string {
	if m != nil && m.SecretName != nil {
		return *m.SecretName
	}
	return ""
}

func (m *AzureFileVolumeSource) GetShareName() string {
	if m != nil && m.ShareName != nil {
		return *m.ShareName
	}
	return ""
}

func (m *AzureFileVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Binding ties one object to another; for example, a pod is bound to a node by a scheduler.
// Deprecated in 1.7, please use the bindings subresource of pods instead.
type Binding struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The target object that you want to bind to the standard object.
	Target           *ObjectReference `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Binding) Reset()                    { *m = Binding{} }
func (m *Binding) String() string            { return proto.CompactTextString(m) }
func (*Binding) ProtoMessage()               {}
func (*Binding) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{7} }

func (m *Binding) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Binding) GetTarget() *ObjectReference {
	if m != nil {
		return m.Target
	}
	return nil
}

// Represents storage that is managed by an external CSI volume driver (Beta feature)
type CSIPersistentVolumeSource struct {
	// Driver is the name of the driver to use for this volume.
	// Required.
	Driver *string `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	// VolumeHandle is the unique volume name returned by the CSI volume
	// plugin’s CreateVolume to refer to the volume on all subsequent calls.
	// Required.
	VolumeHandle *string `protobuf:"bytes,2,opt,name=volumeHandle" json:"volumeHandle,omitempty"`
	// Optional: The value to pass to ControllerPublishVolumeRequest.
	// Defaults to false (read/write).
	// +optional
	ReadOnly *bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,4,opt,name=fsType" json:"fsType,omitempty"`
	// Attributes of the volume to publish.
	// +optional
	VolumeAttributes map[string]string `protobuf:"bytes,5,rep,name=volumeAttributes" json:"volumeAttributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ControllerPublishSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// ControllerPublishVolume and ControllerUnpublishVolume calls.
	// This field is optional, and  may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	ControllerPublishSecretRef *SecretReference `protobuf:"bytes,6,opt,name=controllerPublishSecretRef" json:"controllerPublishSecretRef,omitempty"`
	// NodeStageSecretRef is a reference to the secret object containing sensitive
	// information to pass to the CSI driver to complete the CSI NodeStageVolume
	// and NodeStageVolume and NodeUnstageVolume calls.
	// This field is optional, and  may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	NodeStageSecretRef *SecretReference `protobuf:"bytes,7,opt,name=nodeStageSecretRef" json:"nodeStageSecretRef,omitempty"`
	// NodePublishSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// NodePublishVolume and NodeUnpublishVolume calls.
	// This field is optional, and  may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	NodePublishSecretRef *SecretReference `protobuf:"bytes,8,opt,name=nodePublishSecretRef" json:"nodePublishSecretRef,omitempty"`
	XXX_unrecognized     []byte           `json:"-"`
}

func (m *CSIPersistentVolumeSource) Reset()         { *m = CSIPersistentVolumeSource{} }
func (m *CSIPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*CSIPersistentVolumeSource) ProtoMessage()    {}
func (*CSIPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{8}
}

func (m *CSIPersistentVolumeSource) GetDriver() string {
	if m != nil && m.Driver != nil {
		return *m.Driver
	}
	return ""
}

func (m *CSIPersistentVolumeSource) GetVolumeHandle() string {
	if m != nil && m.VolumeHandle != nil {
		return *m.VolumeHandle
	}
	return ""
}

func (m *CSIPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *CSIPersistentVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *CSIPersistentVolumeSource) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetControllerPublishSecretRef() *SecretReference {
	if m != nil {
		return m.ControllerPublishSecretRef
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetNodeStageSecretRef() *SecretReference {
	if m != nil {
		return m.NodeStageSecretRef
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetNodePublishSecretRef() *SecretReference {
	if m != nil {
		return m.NodePublishSecretRef
	}
	return nil
}

// Adds and removes POSIX capabilities from running containers.
type Capabilities struct {
	// Added capabilities
	// +optional
	Add []string `protobuf:"bytes,1,rep,name=add" json:"add,omitempty"`
	// Removed capabilities
	// +optional
	Drop             []string `protobuf:"bytes,2,rep,name=drop" json:"drop,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Capabilities) Reset()                    { *m = Capabilities{} }
func (m *Capabilities) String() string            { return proto.CompactTextString(m) }
func (*Capabilities) ProtoMessage()               {}
func (*Capabilities) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{9} }

func (m *Capabilities) GetAdd() []string {
	if m != nil {
		return m.Add
	}
	return nil
}

func (m *Capabilities) GetDrop() []string {
	if m != nil {
		return m.Drop
	}
	return nil
}

// Represents a Ceph Filesystem mount that lasts the lifetime of a pod
// Cephfs volumes do not support ownership management or SELinux relabeling.
type CephFSPersistentVolumeSource struct {
	// Required: Monitors is a collection of Ceph monitors
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// Optional: Used as the mounted root, rather than the full Ceph tree, default is /
	// +optional
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Optional: User is the rados user name, default is admin
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	User *string `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	// Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretFile *string `protobuf:"bytes,4,opt,name=secretFile" json:"secretFile,omitempty"`
	// Optional: SecretRef is reference to the authentication secret for User, default is empty.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	ReadOnly         *bool  `protobuf:"varint,6,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *CephFSPersistentVolumeSource) Reset()         { *m = CephFSPersistentVolumeSource{} }
func (m *CephFSPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*CephFSPersistentVolumeSource) ProtoMessage()    {}
func (*CephFSPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{10}
}

func (m *CephFSPersistentVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *CephFSPersistentVolumeSource) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *CephFSPersistentVolumeSource) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *CephFSPersistentVolumeSource) GetSecretFile() string {
	if m != nil && m.SecretFile != nil {
		return *m.SecretFile
	}
	return ""
}

func (m *CephFSPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *CephFSPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Represents a Ceph Filesystem mount that lasts the lifetime of a pod
// Cephfs volumes do not support ownership management or SELinux relabeling.
type CephFSVolumeSource struct {
	// Required: Monitors is a collection of Ceph monitors
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// Optional: Used as the mounted root, rather than the full Ceph tree, default is /
	// +optional
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Optional: User is the rados user name, default is admin
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	User *string `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	// Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretFile *string `protobuf:"bytes,4,opt,name=secretFile" json:"secretFile,omitempty"`
	// Optional: SecretRef is reference to the authentication secret for User, default is empty.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
	// +optional
	ReadOnly         *bool  `protobuf:"varint,6,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *CephFSVolumeSource) Reset()                    { *m = CephFSVolumeSource{} }
func (m *CephFSVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*CephFSVolumeSource) ProtoMessage()               {}
func (*CephFSVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{11} }

func (m *CephFSVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *CephFSVolumeSource) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *CephFSVolumeSource) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *CephFSVolumeSource) GetSecretFile() string {
	if m != nil && m.SecretFile != nil {
		return *m.SecretFile
	}
	return ""
}

func (m *CephFSVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *CephFSVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Represents a cinder volume resource in Openstack.
// A Cinder volume must exist before mounting to a container.
// The volume must also be in the same region as the kubelet.
// Cinder volumes support ownership management and SELinux relabeling.
type CinderVolumeSource struct {
	// volume id used to identify the volume in cinder
	// More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
	VolumeID *string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
	// +optional
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
	// +optional
	ReadOnly         *bool  `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *CinderVolumeSource) Reset()                    { *m = CinderVolumeSource{} }
func (m *CinderVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*CinderVolumeSource) ProtoMessage()               {}
func (*CinderVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{12} }

func (m *CinderVolumeSource) GetVolumeID() string {
	if m != nil && m.VolumeID != nil {
		return *m.VolumeID
	}
	return ""
}

func (m *CinderVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *CinderVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// ClientIPConfig represents the configurations of Client IP based session affinity.
type ClientIPConfig struct {
	// timeoutSeconds specifies the seconds of ClientIP type session sticky time.
	// The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP".
	// Default value is 10800(for 3 hours).
	// +optional
	TimeoutSeconds   *int32 `protobuf:"varint,1,opt,name=timeoutSeconds" json:"timeoutSeconds,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ClientIPConfig) Reset()                    { *m = ClientIPConfig{} }
func (m *ClientIPConfig) String() string            { return proto.CompactTextString(m) }
func (*ClientIPConfig) ProtoMessage()               {}
func (*ClientIPConfig) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{13} }

func (m *ClientIPConfig) GetTimeoutSeconds() int32 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return 0
}

// Information about the condition of a component.
type ComponentCondition struct {
	// Type of condition for a component.
	// Valid value: "Healthy"
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Status of the condition for a component.
	// Valid values for "Healthy": "True", "False", or "Unknown".
	Status *string `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// Message about the condition for a component.
	// For example, information about a health check.
	// +optional
	Message *string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// Condition error code for a component.
	// For example, a health check error code.
	// +optional
	Error            *string `protobuf:"bytes,4,opt,name=error" json:"error,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ComponentCondition) Reset()                    { *m = ComponentCondition{} }
func (m *ComponentCondition) String() string            { return proto.CompactTextString(m) }
func (*ComponentCondition) ProtoMessage()               {}
func (*ComponentCondition) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{14} }

func (m *ComponentCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *ComponentCondition) GetStatus() string {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ""
}

func (m *ComponentCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *ComponentCondition) GetError() string {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ""
}

// ComponentStatus (and ComponentStatusList) holds the cluster validation info.
type ComponentStatus struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of component conditions observed
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions       []*ComponentCondition `protobuf:"bytes,2,rep,name=conditions" json:"conditions,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *ComponentStatus) Reset()                    { *m = ComponentStatus{} }
func (m *ComponentStatus) String() string            { return proto.CompactTextString(m) }
func (*ComponentStatus) ProtoMessage()               {}
func (*ComponentStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{15} }

func (m *ComponentStatus) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ComponentStatus) GetConditions() []*ComponentCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// Status of all the conditions for the component as a list of ComponentStatus objects.
type ComponentStatusList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of ComponentStatus objects.
	Items            []*ComponentStatus `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *ComponentStatusList) Reset()                    { *m = ComponentStatusList{} }
func (m *ComponentStatusList) String() string            { return proto.CompactTextString(m) }
func (*ComponentStatusList) ProtoMessage()               {}
func (*ComponentStatusList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{16} }

func (m *ComponentStatusList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ComponentStatusList) GetItems() []*ComponentStatus {
	if m != nil {
		return m.Items
	}
	return nil
}

// ConfigMap holds configuration data for pods to consume.
type ConfigMap struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Data contains the configuration data.
	// Each key must consist of alphanumeric characters, '-', '_' or '.'.
	// Values with non-UTF-8 byte sequences must use the BinaryData field.
	// The keys stored in Data must not overlap with the keys in
	// the BinaryData field, this is enforced during validation process.
	// +optional
	Data map[string]string `protobuf:"bytes,2,rep,name=data" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// BinaryData contains the binary data.
	// Each key must consist of alphanumeric characters, '-', '_' or '.'.
	// BinaryData can contain byte sequences that are not in the UTF-8 range.
	// The keys stored in BinaryData must not overlap with the ones in
	// the Data field, this is enforced during validation process.
	// Using this field will require 1.10+ apiserver and
	// kubelet.
	// +optional
	BinaryData       map[string][]byte `protobuf:"bytes,3,rep,name=binaryData" json:"binaryData,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ConfigMap) Reset()                    { *m = ConfigMap{} }
func (m *ConfigMap) String() string            { return proto.CompactTextString(m) }
func (*ConfigMap) ProtoMessage()               {}
func (*ConfigMap) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{17} }

func (m *ConfigMap) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ConfigMap) GetData() map[string]string {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ConfigMap) GetBinaryData() map[string][]byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

// ConfigMapEnvSource selects a ConfigMap to populate the environment
// variables with.
//
// The contents of the target ConfigMap's Data field will represent the
// key-value pairs as environment variables.
type ConfigMapEnvSource struct {
	// The ConfigMap to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// Specify whether the ConfigMap must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,2,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConfigMapEnvSource) Reset()                    { *m = ConfigMapEnvSource{} }
func (m *ConfigMapEnvSource) String() string            { return proto.CompactTextString(m) }
func (*ConfigMapEnvSource) ProtoMessage()               {}
func (*ConfigMapEnvSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{18} }

func (m *ConfigMapEnvSource) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapEnvSource) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// Selects a key from a ConfigMap.
type ConfigMapKeySelector struct {
	// The ConfigMap to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// The key to select.
	Key *string `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	// Specify whether the ConfigMap or it's key must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,3,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConfigMapKeySelector) Reset()                    { *m = ConfigMapKeySelector{} }
func (m *ConfigMapKeySelector) String() string            { return proto.CompactTextString(m) }
func (*ConfigMapKeySelector) ProtoMessage()               {}
func (*ConfigMapKeySelector) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{19} }

func (m *ConfigMapKeySelector) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapKeySelector) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *ConfigMapKeySelector) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// ConfigMapList is a resource containing a list of ConfigMap objects.
type ConfigMapList struct {
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is the list of ConfigMaps.
	Items            []*ConfigMap `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ConfigMapList) Reset()                    { *m = ConfigMapList{} }
func (m *ConfigMapList) String() string            { return proto.CompactTextString(m) }
func (*ConfigMapList) ProtoMessage()               {}
func (*ConfigMapList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{20} }

func (m *ConfigMapList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ConfigMapList) GetItems() []*ConfigMap {
	if m != nil {
		return m.Items
	}
	return nil
}

// Adapts a ConfigMap into a projected volume.
//
// The contents of the target ConfigMap's Data field will be presented in a
// projected volume as files using the keys in the Data field as the file names,
// unless the items element is populated with specific mappings of keys to paths.
// Note that this is identical to a configmap volume source without the default
// mode.
type ConfigMapProjection struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// ConfigMap will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the ConfigMap,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Specify whether the ConfigMap or it's keys must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,4,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConfigMapProjection) Reset()                    { *m = ConfigMapProjection{} }
func (m *ConfigMapProjection) String() string            { return proto.CompactTextString(m) }
func (*ConfigMapProjection) ProtoMessage()               {}
func (*ConfigMapProjection) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{21} }

func (m *ConfigMapProjection) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapProjection) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ConfigMapProjection) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// Adapts a ConfigMap into a volume.
//
// The contents of the target ConfigMap's Data field will be presented in a
// volume as files using the keys in the Data field as the file names, unless
// the items element is populated with specific mappings of keys to paths.
// ConfigMap volumes support ownership management and SELinux relabeling.
type ConfigMapVolumeSource struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// ConfigMap will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the ConfigMap,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Optional: mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode *int32 `protobuf:"varint,3,opt,name=defaultMode" json:"defaultMode,omitempty"`
	// Specify whether the ConfigMap or it's keys must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,4,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConfigMapVolumeSource) Reset()                    { *m = ConfigMapVolumeSource{} }
func (m *ConfigMapVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*ConfigMapVolumeSource) ProtoMessage()               {}
func (*ConfigMapVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{22} }

func (m *ConfigMapVolumeSource) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapVolumeSource) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ConfigMapVolumeSource) GetDefaultMode() int32 {
	if m != nil && m.DefaultMode != nil {
		return *m.DefaultMode
	}
	return 0
}

func (m *ConfigMapVolumeSource) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// A single application container that you want to run within a pod.
type Container struct {
	// Name of the container specified as a DNS_LABEL.
	// Each container in a pod must have a unique name (DNS_LABEL).
	// Cannot be updated.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Docker image name.
	// More info: https://kubernetes.io/docs/concepts/containers/images
	// This field is optional to allow higher level config management to default or override
	// container images in workload controllers like Deployments and StatefulSets.
	// +optional
	Image *string `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// Entrypoint array. Not executed within a shell.
	// The docker image's ENTRYPOINT is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
	// cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax
	// can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Arguments to the entrypoint.
	// The docker image's CMD is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
	// cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax
	// can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Container's working directory.
	// If not specified, the container runtime's default will be used, which
	// might be configured in the container image.
	// Cannot be updated.
	// +optional
	WorkingDir *string `protobuf:"bytes,5,opt,name=workingDir" json:"workingDir,omitempty"`
	// List of ports to expose from the container. Exposing a port here gives
	// the system additional information about the network connections a
	// container uses, but is primarily informational. Not specifying a port here
	// DOES NOT prevent that port from being exposed. Any port which is
	// listening on the default "0.0.0.0" address inside a container will be
	// accessible from the network.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=containerPort
	// +patchStrategy=merge
	Ports []*ContainerPort `protobuf:"bytes,6,rep,name=ports" json:"ports,omitempty"`
	// List of sources to populate environment variables in the container.
	// The keys defined within a source must be a C_IDENTIFIER. All invalid keys
	// will be reported as an event when the container is starting. When a key exists in multiple
	// sources, the value associated with the last source will take precedence.
	// Values defined by an Env with a duplicate key will take precedence.
	// Cannot be updated.
	// +optional
	EnvFrom []*EnvFromSource `protobuf:"bytes,19,rep,name=envFrom" json:"envFrom,omitempty"`
	// List of environment variables to set in the container.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	Env []*EnvVar `protobuf:"bytes,7,rep,name=env" json:"env,omitempty"`
	// Compute Resources required by this container.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
	// +optional
	Resources *ResourceRequirements `protobuf:"bytes,8,opt,name=resources" json:"resources,omitempty"`
	// Pod volumes to mount into the container's filesystem.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=mountPath
	// +patchStrategy=merge
	VolumeMounts []*VolumeMount `protobuf:"bytes,9,rep,name=volumeMounts" json:"volumeMounts,omitempty"`
	// volumeDevices is the list of block devices to be used by the container.
	// This is an alpha feature and may change in the future.
	// +patchMergeKey=devicePath
	// +patchStrategy=merge
	// +optional
	VolumeDevices []*VolumeDevice `protobuf:"bytes,21,rep,name=volumeDevices" json:"volumeDevices,omitempty"`
	// Periodic probe of container liveness.
	// Container will be restarted if the probe fails.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	LivenessProbe *Probe `protobuf:"bytes,10,opt,name=livenessProbe" json:"livenessProbe,omitempty"`
	// Periodic probe of container service readiness.
	// Container will be removed from service endpoints if the probe fails.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	ReadinessProbe *Probe `protobuf:"bytes,11,opt,name=readinessProbe" json:"readinessProbe,omitempty"`
	// Actions that the management system should take in response to container lifecycle events.
	// Cannot be updated.
	// +optional
	Lifecycle *Lifecycle `protobuf:"bytes,12,opt,name=lifecycle" json:"lifecycle,omitempty"`
	// Optional: Path at which the file to which the container's termination message
	// will be written is mounted into the container's filesystem.
	// Message written is intended to be brief final status, such as an assertion failure message.
	// Will be truncated by the node if greater than 4096 bytes. The total message length across
	// all containers will be limited to 12kb.
	// Defaults to /dev/termination-log.
	// Cannot be updated.
	// +optional
	TerminationMessagePath *string `protobuf:"bytes,13,opt,name=terminationMessagePath" json:"terminationMessagePath,omitempty"`
	// Indicate how the termination message should be populated. File will use the contents of
	// terminationMessagePath to populate the container status message on both success and failure.
	// FallbackToLogsOnError will use the last chunk of container log output if the termination
	// message file is empty and the container exited with an error.
	// The log output is limited to 2048 bytes or 80 lines, whichever is smaller.
	// Defaults to File.
	// Cannot be updated.
	// +optional
	TerminationMessagePolicy *string `protobuf:"bytes,20,opt,name=terminationMessagePolicy" json:"terminationMessagePolicy,omitempty"`
	// Image pull policy.
	// One of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
	// +optional
	ImagePullPolicy *string `protobuf:"bytes,14,opt,name=imagePullPolicy" json:"imagePullPolicy,omitempty"`
	// Security options the pod should run with.
	// More info: https://kubernetes.io/docs/concepts/policy/security-context/
	// More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	// +optional
	SecurityContext *SecurityContext `protobuf:"bytes,15,opt,name=securityContext" json:"securityContext,omitempty"`
	// Whether this container should allocate a buffer for stdin in the container runtime. If this
	// is not set, reads from stdin in the container will always result in EOF.
	// Default is false.
	// +optional
	Stdin *bool `protobuf:"varint,16,opt,name=stdin" json:"stdin,omitempty"`
	// Whether the container runtime should close the stdin channel after it has been opened by
	// a single attach. When stdin is true the stdin stream will remain open across multiple attach
	// sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the
	// first client attaches to stdin, and then remains open and accepts data until the client disconnects,
	// at which time stdin is closed and remains closed until the container is restarted. If this
	// flag is false, a container processes that reads from stdin will never receive an EOF.
	// Default is false
	// +optional
	StdinOnce *bool `protobuf:"varint,17,opt,name=stdinOnce" json:"stdinOnce,omitempty"`
	// Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
	// Default is false.
	// +optional
	Tty              *bool  `protobuf:"varint,18,opt,name=tty" json:"tty,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{23} }

func (m *Container) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Container) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *Container) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *Container) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Container) GetWorkingDir() string {
	if m != nil && m.WorkingDir != nil {
		return *m.WorkingDir
	}
	return ""
}

func (m *Container) GetPorts() []*ContainerPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *Container) GetEnvFrom() []*EnvFromSource {
	if m != nil {
		return m.EnvFrom
	}
	return nil
}

func (m *Container) GetEnv() []*EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *Container) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Container) GetVolumeMounts() []*VolumeMount {
	if m != nil {
		return m.VolumeMounts
	}
	return nil
}

func (m *Container) GetVolumeDevices() []*VolumeDevice {
	if m != nil {
		return m.VolumeDevices
	}
	return nil
}

func (m *Container) GetLivenessProbe() *Probe {
	if m != nil {
		return m.LivenessProbe
	}
	return nil
}

func (m *Container) GetReadinessProbe() *Probe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *Container) GetLifecycle() *Lifecycle {
	if m != nil {
		return m.Lifecycle
	}
	return nil
}

func (m *Container) GetTerminationMessagePath() string {
	if m != nil && m.TerminationMessagePath != nil {
		return *m.TerminationMessagePath
	}
	return ""
}

func (m *Container) GetTerminationMessagePolicy() string {
	if m != nil && m.TerminationMessagePolicy != nil {
		return *m.TerminationMessagePolicy
	}
	return ""
}

func (m *Container) GetImagePullPolicy() string {
	if m != nil && m.ImagePullPolicy != nil {
		return *m.ImagePullPolicy
	}
	return ""
}

func (m *Container) GetSecurityContext() *SecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *Container) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

func (m *Container) GetStdinOnce() bool {
	if m != nil && m.StdinOnce != nil {
		return *m.StdinOnce
	}
	return false
}

func (m *Container) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

// Describe a container image
type ContainerImage struct {
	// Names by which this image is known.
	// e.g. ["k8s.gcr.io/hyperkube:v1.0.7", "dockerhub.io/google_containers/hyperkube:v1.0.7"]
	Names []string `protobuf:"bytes,1,rep,name=names" json:"names,omitempty"`
	// The size of the image in bytes.
	// +optional
	SizeBytes        *int64 `protobuf:"varint,2,opt,name=sizeBytes" json:"sizeBytes,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ContainerImage) Reset()                    { *m = ContainerImage{} }
func (m *ContainerImage) String() string            { return proto.CompactTextString(m) }
func (*ContainerImage) ProtoMessage()               {}
func (*ContainerImage) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{24} }

func (m *ContainerImage) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *ContainerImage) GetSizeBytes() int64 {
	if m != nil && m.SizeBytes != nil {
		return *m.SizeBytes
	}
	return 0
}

// ContainerPort represents a network port in a single container.
type ContainerPort struct {
	// If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
	// named port in a pod must have a unique name. Name for the port that can be
	// referred to by services.
	// +optional
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Number of port to expose on the host.
	// If specified, this must be a valid port number, 0 < x < 65536.
	// If HostNetwork is specified, this must match ContainerPort.
	// Most containers do not need this.
	// +optional
	HostPort *int32 `protobuf:"varint,2,opt,name=hostPort" json:"hostPort,omitempty"`
	// Number of port to expose on the pod's IP address.
	// This must be a valid port number, 0 < x < 65536.
	ContainerPort *int32 `protobuf:"varint,3,opt,name=containerPort" json:"containerPort,omitempty"`
	// Protocol for port. Must be UDP or TCP.
	// Defaults to "TCP".
	// +optional
	Protocol *string `protobuf:"bytes,4,opt,name=protocol" json:"protocol,omitempty"`
	// What host IP to bind the external port to.
	// +optional
	HostIP           *string `protobuf:"bytes,5,opt,name=hostIP" json:"hostIP,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerPort) Reset()                    { *m = ContainerPort{} }
func (m *ContainerPort) String() string            { return proto.CompactTextString(m) }
func (*ContainerPort) ProtoMessage()               {}
func (*ContainerPort) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{25} }

func (m *ContainerPort) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ContainerPort) GetHostPort() int32 {
	if m != nil && m.HostPort != nil {
		return *m.HostPort
	}
	return 0
}

func (m *ContainerPort) GetContainerPort() int32 {
	if m != nil && m.ContainerPort != nil {
		return *m.ContainerPort
	}
	return 0
}

func (m *ContainerPort) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

func (m *ContainerPort) GetHostIP() string {
	if m != nil && m.HostIP != nil {
		return *m.HostIP
	}
	return ""
}

// ContainerState holds a possible state of container.
// Only one of its members may be specified.
// If none of them is specified, the default one is ContainerStateWaiting.
type ContainerState struct {
	// Details about a waiting container
	// +optional
	Waiting *ContainerStateWaiting `protobuf:"bytes,1,opt,name=waiting" json:"waiting,omitempty"`
	// Details about a running container
	// +optional
	Running *ContainerStateRunning `protobuf:"bytes,2,opt,name=running" json:"running,omitempty"`
	// Details about a terminated container
	// +optional
	Terminated       *ContainerStateTerminated `protobuf:"bytes,3,opt,name=terminated" json:"terminated,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *ContainerState) Reset()                    { *m = ContainerState{} }
func (m *ContainerState) String() string            { return proto.CompactTextString(m) }
func (*ContainerState) ProtoMessage()               {}
func (*ContainerState) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{26} }

func (m *ContainerState) GetWaiting() *ContainerStateWaiting {
	if m != nil {
		return m.Waiting
	}
	return nil
}

func (m *ContainerState) GetRunning() *ContainerStateRunning {
	if m != nil {
		return m.Running
	}
	return nil
}

func (m *ContainerState) GetTerminated() *ContainerStateTerminated {
	if m != nil {
		return m.Terminated
	}
	return nil
}

// ContainerStateRunning is a running state of a container.
type ContainerStateRunning struct {
	// Time at which the container was last (re-)started
	// +optional
	StartedAt        *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,1,opt,name=startedAt" json:"startedAt,omitempty"`
	XXX_unrecognized []byte                                     `json:"-"`
}

func (m *ContainerStateRunning) Reset()                    { *m = ContainerStateRunning{} }
func (m *ContainerStateRunning) String() string            { return proto.CompactTextString(m) }
func (*ContainerStateRunning) ProtoMessage()               {}
func (*ContainerStateRunning) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{27} }

func (m *ContainerStateRunning) GetStartedAt() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

// ContainerStateTerminated is a terminated state of a container.
type ContainerStateTerminated struct {
	// Exit status from the last termination of the container
	ExitCode *int32 `protobuf:"varint,1,opt,name=exitCode" json:"exitCode,omitempty"`
	// Signal from the last termination of the container
	// +optional
	Signal *int32 `protobuf:"varint,2,opt,name=signal" json:"signal,omitempty"`
	// (brief) reason from the last termination of the container
	// +optional
	Reason *string `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
	// Message regarding the last termination of the container
	// +optional
	Message *string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	// Time at which previous execution of the container started
	// +optional
	StartedAt *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,5,opt,name=startedAt" json:"startedAt,omitempty"`
	// Time at which the container last terminated
	// +optional
	FinishedAt *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,6,opt,name=finishedAt" json:"finishedAt,omitempty"`
	// Container's ID in the format 'docker://<container_id>'
	// +optional
	ContainerID      *string `protobuf:"bytes,7,opt,name=containerID" json:"containerID,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerStateTerminated) Reset()         { *m = ContainerStateTerminated{} }
func (m *ContainerStateTerminated) String() string { return proto.CompactTextString(m) }
func (*ContainerStateTerminated) ProtoMessage()    {}
func (*ContainerStateTerminated) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{28}
}

func (m *ContainerStateTerminated) GetExitCode() int32 {
	if m != nil && m.ExitCode != nil {
		return *m.ExitCode
	}
	return 0
}

func (m *ContainerStateTerminated) GetSignal() int32 {
	if m != nil && m.Signal != nil {
		return *m.Signal
	}
	return 0
}

func (m *ContainerStateTerminated) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *ContainerStateTerminated) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *ContainerStateTerminated) GetStartedAt() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

func (m *ContainerStateTerminated) GetFinishedAt() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.FinishedAt
	}
	return nil
}

func (m *ContainerStateTerminated) GetContainerID() string {
	if m != nil && m.ContainerID != nil {
		return *m.ContainerID
	}
	return ""
}

// ContainerStateWaiting is a waiting state of a container.
type ContainerStateWaiting struct {
	// (brief) reason the container is not yet running.
	// +optional
	Reason *string `protobuf:"bytes,1,opt,name=reason" json:"reason,omitempty"`
	// Message regarding why the container is not yet running.
	// +optional
	Message          *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerStateWaiting) Reset()                    { *m = ContainerStateWaiting{} }
func (m *ContainerStateWaiting) String() string            { return proto.CompactTextString(m) }
func (*ContainerStateWaiting) ProtoMessage()               {}
func (*ContainerStateWaiting) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{29} }

func (m *ContainerStateWaiting) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *ContainerStateWaiting) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// ContainerStatus contains details for the current status of this container.
type ContainerStatus struct {
	// This must be a DNS_LABEL. Each container in a pod must have a unique name.
	// Cannot be updated.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Details about the container's current condition.
	// +optional
	State *ContainerState `protobuf:"bytes,2,opt,name=state" json:"state,omitempty"`
	// Details about the container's last termination condition.
	// +optional
	LastState *ContainerState `protobuf:"bytes,3,opt,name=lastState" json:"lastState,omitempty"`
	// Specifies whether the container has passed its readiness probe.
	Ready *bool `protobuf:"varint,4,opt,name=ready" json:"ready,omitempty"`
	// The number of times the container has been restarted, currently based on
	// the number of dead containers that have not yet been removed.
	// Note that this is calculated from dead containers. But those containers are subject to
	// garbage collection. This value will get capped at 5 by GC.
	RestartCount *int32 `protobuf:"varint,5,opt,name=restartCount" json:"restartCount,omitempty"`
	// The image the container is running.
	// More info: https://kubernetes.io/docs/concepts/containers/images
	// TODO(dchen1107): Which image the container is running with?
	Image *string `protobuf:"bytes,6,opt,name=image" json:"image,omitempty"`
	// ImageID of the container's image.
	ImageID *string `protobuf:"bytes,7,opt,name=imageID" json:"imageID,omitempty"`
	// Container's ID in the format 'docker://<container_id>'.
	// +optional
	ContainerID      *string `protobuf:"bytes,8,opt,name=containerID" json:"containerID,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerStatus) Reset()                    { *m = ContainerStatus{} }
func (m *ContainerStatus) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatus) ProtoMessage()               {}
func (*ContainerStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{30} }

func (m *ContainerStatus) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ContainerStatus) GetState() *ContainerState {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *ContainerStatus) GetLastState() *ContainerState {
	if m != nil {
		return m.LastState
	}
	return nil
}

func (m *ContainerStatus) GetReady() bool {
	if m != nil && m.Ready != nil {
		return *m.Ready
	}
	return false
}

func (m *ContainerStatus) GetRestartCount() int32 {
	if m != nil && m.RestartCount != nil {
		return *m.RestartCount
	}
	return 0
}

func (m *ContainerStatus) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *ContainerStatus) GetImageID() string {
	if m != nil && m.ImageID != nil {
		return *m.ImageID
	}
	return ""
}

func (m *ContainerStatus) GetContainerID() string {
	if m != nil && m.ContainerID != nil {
		return *m.ContainerID
	}
	return ""
}

// DaemonEndpoint contains information about a single Daemon endpoint.
type DaemonEndpoint struct {
	// Port number of the given endpoint.
	Port             *int32 `protobuf:"varint,1,opt,name=Port" json:"Port,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DaemonEndpoint) Reset()                    { *m = DaemonEndpoint{} }
func (m *DaemonEndpoint) String() string            { return proto.CompactTextString(m) }
func (*DaemonEndpoint) ProtoMessage()               {}
func (*DaemonEndpoint) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{31} }

func (m *DaemonEndpoint) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

// DeleteOptions may be provided when deleting an API object
// DEPRECATED: This type has been moved to meta/v1 and will be removed soon.
// +k8s:openapi-gen=false
type DeleteOptions struct {
	// The duration in seconds before the object should be deleted. Value must be non-negative integer.
	// The value zero indicates delete immediately. If this value is nil, the default grace period for the
	// specified type will be used.
	// Defaults to a per object value if not specified. zero means delete immediately.
	// +optional
	GracePeriodSeconds *int64 `protobuf:"varint,1,opt,name=gracePeriodSeconds" json:"gracePeriodSeconds,omitempty"`
	// Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be
	// returned.
	// +optional
	Preconditions *Preconditions `protobuf:"bytes,2,opt,name=preconditions" json:"preconditions,omitempty"`
	// Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7.
	// Should the dependent objects be orphaned. If true/false, the "orphan"
	// finalizer will be added to/removed from the object's finalizers list.
	// Either this field or PropagationPolicy may be set, but not both.
	// +optional
	OrphanDependents *bool `protobuf:"varint,3,opt,name=orphanDependents" json:"orphanDependents,omitempty"`
	// Whether and how garbage collection will be performed.
	// Either this field or OrphanDependents may be set, but not both.
	// The default policy is decided by the existing finalizer set in the
	// metadata.finalizers and the resource-specific default policy.
	// Acceptable values are: 'Orphan' - orphan the dependents; 'Background' -
	// allow the garbage collector to delete the dependents in the background;
	// 'Foreground' - a cascading policy that deletes all dependents in the
	// foreground.
	// +optional
	PropagationPolicy *string `protobuf:"bytes,4,opt,name=propagationPolicy" json:"propagationPolicy,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *DeleteOptions) Reset()                    { *m = DeleteOptions{} }
func (m *DeleteOptions) String() string            { return proto.CompactTextString(m) }
func (*DeleteOptions) ProtoMessage()               {}
func (*DeleteOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{32} }

func (m *DeleteOptions) GetGracePeriodSeconds() int64 {
	if m != nil && m.GracePeriodSeconds != nil {
		return *m.GracePeriodSeconds
	}
	return 0
}

func (m *DeleteOptions) GetPreconditions() *Preconditions {
	if m != nil {
		return m.Preconditions
	}
	return nil
}

func (m *DeleteOptions) GetOrphanDependents() bool {
	if m != nil && m.OrphanDependents != nil {
		return *m.OrphanDependents
	}
	return false
}

func (m *DeleteOptions) GetPropagationPolicy() string {
	if m != nil && m.PropagationPolicy != nil {
		return *m.PropagationPolicy
	}
	return ""
}

// Represents downward API info for projecting into a projected volume.
// Note that this is identical to a downwardAPI volume source without the default
// mode.
type DownwardAPIProjection struct {
	// Items is a list of DownwardAPIVolume file
	// +optional
	Items            []*DownwardAPIVolumeFile `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *DownwardAPIProjection) Reset()                    { *m = DownwardAPIProjection{} }
func (m *DownwardAPIProjection) String() string            { return proto.CompactTextString(m) }
func (*DownwardAPIProjection) ProtoMessage()               {}
func (*DownwardAPIProjection) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{33} }

func (m *DownwardAPIProjection) GetItems() []*DownwardAPIVolumeFile {
	if m != nil {
		return m.Items
	}
	return nil
}

// DownwardAPIVolumeFile represents information to create the file containing the pod field
type DownwardAPIVolumeFile struct {
	// Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
	Path *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
	// +optional
	FieldRef *ObjectFieldSelector `protobuf:"bytes,2,opt,name=fieldRef" json:"fieldRef,omitempty"`
	// Selects a resource of the container: only resources limits and requests
	// (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
	// +optional
	ResourceFieldRef *ResourceFieldSelector `protobuf:"bytes,3,opt,name=resourceFieldRef" json:"resourceFieldRef,omitempty"`
	// Optional: mode bits to use on this file, must be a value between 0
	// and 0777. If not specified, the volume defaultMode will be used.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	Mode             *int32 `protobuf:"varint,4,opt,name=mode" json:"mode,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DownwardAPIVolumeFile) Reset()                    { *m = DownwardAPIVolumeFile{} }
func (m *DownwardAPIVolumeFile) String() string            { return proto.CompactTextString(m) }
func (*DownwardAPIVolumeFile) ProtoMessage()               {}
func (*DownwardAPIVolumeFile) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{34} }

func (m *DownwardAPIVolumeFile) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *DownwardAPIVolumeFile) GetFieldRef() *ObjectFieldSelector {
	if m != nil {
		return m.FieldRef
	}
	return nil
}

func (m *DownwardAPIVolumeFile) GetResourceFieldRef() *ResourceFieldSelector {
	if m != nil {
		return m.ResourceFieldRef
	}
	return nil
}

func (m *DownwardAPIVolumeFile) GetMode() int32 {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return 0
}

// DownwardAPIVolumeSource represents a volume containing downward API info.
// Downward API volumes support ownership management and SELinux relabeling.
type DownwardAPIVolumeSource struct {
	// Items is a list of downward API volume file
	// +optional
	Items []*DownwardAPIVolumeFile `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	// Optional: mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode      *int32 `protobuf:"varint,2,opt,name=defaultMode" json:"defaultMode,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DownwardAPIVolumeSource) Reset()         { *m = DownwardAPIVolumeSource{} }
func (m *DownwardAPIVolumeSource) String() string { return proto.CompactTextString(m) }
func (*DownwardAPIVolumeSource) ProtoMessage()    {}
func (*DownwardAPIVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{35}
}

func (m *DownwardAPIVolumeSource) GetItems() []*DownwardAPIVolumeFile {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *DownwardAPIVolumeSource) GetDefaultMode() int32 {
	if m != nil && m.DefaultMode != nil {
		return *m.DefaultMode
	}
	return 0
}

// Represents an empty directory for a pod.
// Empty directory volumes support ownership management and SELinux relabeling.
type EmptyDirVolumeSource struct {
	// What type of storage medium should back this directory.
	// The default is "" which means to use the node's default medium.
	// Must be an empty string (default) or Memory.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
	// +optional
	Medium *string `protobuf:"bytes,1,opt,name=medium" json:"medium,omitempty"`
	// Total amount of local storage required for this EmptyDir volume.
	// The size limit is also applicable for memory medium.
	// The maximum usage on memory medium EmptyDir would be the minimum value between
	// the SizeLimit specified here and the sum of memory limits of all containers in a pod.
	// The default is nil which means that the limit is undefined.
	// More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
	// +optional
	SizeLimit        *k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,2,opt,name=sizeLimit" json:"sizeLimit,omitempty"`
	XXX_unrecognized []byte                                         `json:"-"`
}

func (m *EmptyDirVolumeSource) Reset()                    { *m = EmptyDirVolumeSource{} }
func (m *EmptyDirVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*EmptyDirVolumeSource) ProtoMessage()               {}
func (*EmptyDirVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{36} }

func (m *EmptyDirVolumeSource) GetMedium() string {
	if m != nil && m.Medium != nil {
		return *m.Medium
	}
	return ""
}

func (m *EmptyDirVolumeSource) GetSizeLimit() *k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.SizeLimit
	}
	return nil
}

// EndpointAddress is a tuple that describes single IP address.
type EndpointAddress struct {
	// The IP of this endpoint.
	// May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16),
	// or link-local multicast ((224.0.0.0/24).
	// IPv6 is also accepted but not fully supported on all platforms. Also, certain
	// kubernetes components, like kube-proxy, are not IPv6 ready.
	// TODO: This should allow hostname or IP, See #4447.
	Ip *string `protobuf:"bytes,1,opt,name=ip" json:"ip,omitempty"`
	// The Hostname of this endpoint
	// +optional
	Hostname *string `protobuf:"bytes,3,opt,name=hostname" json:"hostname,omitempty"`
	// Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
	// +optional
	NodeName *string `protobuf:"bytes,4,opt,name=nodeName" json:"nodeName,omitempty"`
	// Reference to object providing the endpoint.
	// +optional
	TargetRef        *ObjectReference `protobuf:"bytes,2,opt,name=targetRef" json:"targetRef,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *EndpointAddress) Reset()                    { *m = EndpointAddress{} }
func (m *EndpointAddress) String() string            { return proto.CompactTextString(m) }
func (*EndpointAddress) ProtoMessage()               {}
func (*EndpointAddress) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{37} }

func (m *EndpointAddress) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

func (m *EndpointAddress) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *EndpointAddress) GetNodeName() string {
	if m != nil && m.NodeName != nil {
		return *m.NodeName
	}
	return ""
}

func (m *EndpointAddress) GetTargetRef() *ObjectReference {
	if m != nil {
		return m.TargetRef
	}
	return nil
}

// EndpointPort is a tuple that describes a single port.
type EndpointPort struct {
	// The name of this port (corresponds to ServicePort.Name).
	// Must be a DNS_LABEL.
	// Optional only if one port is defined.
	// +optional
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The port number of the endpoint.
	Port *int32 `protobuf:"varint,2,opt,name=port" json:"port,omitempty"`
	// The IP protocol for this port.
	// Must be UDP or TCP.
	// Default is TCP.
	// +optional
	Protocol         *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *EndpointPort) Reset()                    { *m = EndpointPort{} }
func (m *EndpointPort) String() string            { return proto.CompactTextString(m) }
func (*EndpointPort) ProtoMessage()               {}
func (*EndpointPort) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{38} }

func (m *EndpointPort) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *EndpointPort) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

func (m *EndpointPort) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

// EndpointSubset is a group of addresses with a common set of ports. The
// expanded set of endpoints is the Cartesian product of Addresses x Ports.
// For example, given:
//   {
//     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
//     Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
//   }
// The resulting set of endpoints can be viewed as:
//     a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
//     b: [ 10.10.1.1:309, 10.10.2.2:309 ]
type EndpointSubset struct {
	// IP addresses which offer the related ports that are marked as ready. These endpoints
	// should be considered safe for load balancers and clients to utilize.
	// +optional
	Addresses []*EndpointAddress `protobuf:"bytes,1,rep,name=addresses" json:"addresses,omitempty"`
	// IP addresses which offer the related ports but are not currently marked as ready
	// because they have not yet finished starting, have recently failed a readiness check,
	// or have recently failed a liveness check.
	// +optional
	NotReadyAddresses []*EndpointAddress `protobuf:"bytes,2,rep,name=notReadyAddresses" json:"notReadyAddresses,omitempty"`
	// Port numbers available on the related IP addresses.
	// +optional
	Ports            []*EndpointPort `protobuf:"bytes,3,rep,name=ports" json:"ports,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *EndpointSubset) Reset()                    { *m = EndpointSubset{} }
func (m *EndpointSubset) String() string            { return proto.CompactTextString(m) }
func (*EndpointSubset) ProtoMessage()               {}
func (*EndpointSubset) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{39} }

func (m *EndpointSubset) GetAddresses() []*EndpointAddress {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *EndpointSubset) GetNotReadyAddresses() []*EndpointAddress {
	if m != nil {
		return m.NotReadyAddresses
	}
	return nil
}

func (m *EndpointSubset) GetPorts() []*EndpointPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

// Endpoints is a collection of endpoints that implement the actual service. Example:
//   Name: "mysvc",
//   Subsets: [
//     {
//       Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
//       Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
//     },
//     {
//       Addresses: [{"ip": "10.10.3.3"}],
//       Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
//     },
//  ]
type Endpoints struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The set of all endpoints is the union of all subsets. Addresses are placed into
	// subsets according to the IPs they share. A single address with multiple ports,
	// some of which are ready and some of which are not (because they come from
	// different containers) will result in the address being displayed in different
	// subsets for the different ports. No address will appear in both Addresses and
	// NotReadyAddresses in the same subset.
	// Sets of addresses and ports that comprise a service.
	// +optional
	Subsets          []*EndpointSubset `protobuf:"bytes,2,rep,name=subsets" json:"subsets,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Endpoints) Reset()                    { *m = Endpoints{} }
func (m *Endpoints) String() string            { return proto.CompactTextString(m) }
func (*Endpoints) ProtoMessage()               {}
func (*Endpoints) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{40} }

func (m *Endpoints) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Endpoints) GetSubsets() []*EndpointSubset {
	if m != nil {
		return m.Subsets
	}
	return nil
}

// EndpointsList is a list of endpoints.
type EndpointsList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of endpoints.
	Items            []*Endpoints `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *EndpointsList) Reset()                    { *m = EndpointsList{} }
func (m *EndpointsList) String() string            { return proto.CompactTextString(m) }
func (*EndpointsList) ProtoMessage()               {}
func (*EndpointsList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{41} }

func (m *EndpointsList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EndpointsList) GetItems() []*Endpoints {
	if m != nil {
		return m.Items
	}
	return nil
}

// EnvFromSource represents the source of a set of ConfigMaps
type EnvFromSource struct {
	// An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
	// +optional
	Prefix *string `protobuf:"bytes,1,opt,name=prefix" json:"prefix,omitempty"`
	// The ConfigMap to select from
	// +optional
	ConfigMapRef *ConfigMapEnvSource `protobuf:"bytes,2,opt,name=configMapRef" json:"configMapRef,omitempty"`
	// The Secret to select from
	// +optional
	SecretRef        *SecretEnvSource `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *EnvFromSource) Reset()                    { *m = EnvFromSource{} }
func (m *EnvFromSource) String() string            { return proto.CompactTextString(m) }
func (*EnvFromSource) ProtoMessage()               {}
func (*EnvFromSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{42} }

func (m *EnvFromSource) GetPrefix() string {
	if m != nil && m.Prefix != nil {
		return *m.Prefix
	}
	return ""
}

func (m *EnvFromSource) GetConfigMapRef() *ConfigMapEnvSource {
	if m != nil {
		return m.ConfigMapRef
	}
	return nil
}

func (m *EnvFromSource) GetSecretRef() *SecretEnvSource {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// EnvVar represents an environment variable present in a Container.
type EnvVar struct {
	// Name of the environment variable. Must be a C_IDENTIFIER.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Variable references $(VAR_NAME) are expanded
	// using the previous defined environment variables in the container and
	// any service environment variables. If a variable cannot be resolved,
	// the reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not.
	// Defaults to "".
	// +optional
	Value *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// Source for the environment variable's value. Cannot be used if value is not empty.
	// +optional
	ValueFrom        *EnvVarSource `protobuf:"bytes,3,opt,name=valueFrom" json:"valueFrom,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *EnvVar) Reset()                    { *m = EnvVar{} }
func (m *EnvVar) String() string            { return proto.CompactTextString(m) }
func (*EnvVar) ProtoMessage()               {}
func (*EnvVar) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{43} }

func (m *EnvVar) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *EnvVar) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *EnvVar) GetValueFrom() *EnvVarSource {
	if m != nil {
		return m.ValueFrom
	}
	return nil
}

// EnvVarSource represents a source for the value of an EnvVar.
type EnvVarSource struct {
	// Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations,
	// spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP.
	// +optional
	FieldRef *ObjectFieldSelector `protobuf:"bytes,1,opt,name=fieldRef" json:"fieldRef,omitempty"`
	// Selects a resource of the container: only resources limits and requests
	// (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
	// +optional
	ResourceFieldRef *ResourceFieldSelector `protobuf:"bytes,2,opt,name=resourceFieldRef" json:"resourceFieldRef,omitempty"`
	// Selects a key of a ConfigMap.
	// +optional
	ConfigMapKeyRef *ConfigMapKeySelector `protobuf:"bytes,3,opt,name=configMapKeyRef" json:"configMapKeyRef,omitempty"`
	// Selects a key of a secret in the pod's namespace
	// +optional
	SecretKeyRef     *SecretKeySelector `protobuf:"bytes,4,opt,name=secretKeyRef" json:"secretKeyRef,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *EnvVarSource) Reset()                    { *m = EnvVarSource{} }
func (m *EnvVarSource) String() string            { return proto.CompactTextString(m) }
func (*EnvVarSource) ProtoMessage()               {}
func (*EnvVarSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{44} }

func (m *EnvVarSource) GetFieldRef() *ObjectFieldSelector {
	if m != nil {
		return m.FieldRef
	}
	return nil
}

func (m *EnvVarSource) GetResourceFieldRef() *ResourceFieldSelector {
	if m != nil {
		return m.ResourceFieldRef
	}
	return nil
}

func (m *EnvVarSource) GetConfigMapKeyRef() *ConfigMapKeySelector {
	if m != nil {
		return m.ConfigMapKeyRef
	}
	return nil
}

func (m *EnvVarSource) GetSecretKeyRef() *SecretKeySelector {
	if m != nil {
		return m.SecretKeyRef
	}
	return nil
}

// Event is a report of an event somewhere in the cluster.
type Event struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The object that this event is about.
	InvolvedObject *ObjectReference `protobuf:"bytes,2,opt,name=involvedObject" json:"involvedObject,omitempty"`
	// This should be a short, machine understandable string that gives the reason
	// for the transition into the object's current status.
	// TODO: provide exact specification for format.
	// +optional
	Reason *string `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
	// A human-readable description of the status of this operation.
	// TODO: decide on maximum length.
	// +optional
	Message *string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	// The component reporting this event. Should be a short machine understandable string.
	// +optional
	Source *EventSource `protobuf:"bytes,5,opt,name=source" json:"source,omitempty"`
	// The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
	// +optional
	FirstTimestamp *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,6,opt,name=firstTimestamp" json:"firstTimestamp,omitempty"`
	// The time at which the most recent occurrence of this event was recorded.
	// +optional
	LastTimestamp *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,7,opt,name=lastTimestamp" json:"lastTimestamp,omitempty"`
	// The number of times this event has occurred.
	// +optional
	Count *int32 `protobuf:"varint,8,opt,name=count" json:"count,omitempty"`
	// Type of this event (Normal, Warning), new types could be added in the future
	// +optional
	Type *string `protobuf:"bytes,9,opt,name=type" json:"type,omitempty"`
	// Time when this Event was first observed.
	// +optional
	EventTime *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime `protobuf:"bytes,10,opt,name=eventTime" json:"eventTime,omitempty"`
	// Data about the Event series this event represents or nil if it's a singleton Event.
	// +optional
	Series *EventSeries `protobuf:"bytes,11,opt,name=series" json:"series,omitempty"`
	// What action was taken/failed regarding to the Regarding object.
	// +optional
	Action *string `protobuf:"bytes,12,opt,name=action" json:"action,omitempty"`
	// Optional secondary object for more complex actions.
	// +optional
	Related *ObjectReference `protobuf:"bytes,13,opt,name=related" json:"related,omitempty"`
	// Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
	// +optional
	ReportingComponent *string `protobuf:"bytes,14,opt,name=reportingComponent" json:"reportingComponent,omitempty"`
	// ID of the controller instance, e.g. `kubelet-xyzf`.
	// +optional
	ReportingInstance *string `protobuf:"bytes,15,opt,name=reportingInstance" json:"reportingInstance,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{45} }

func (m *Event) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Event) GetInvolvedObject() *ObjectReference {
	if m != nil {
		return m.InvolvedObject
	}
	return nil
}

func (m *Event) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *Event) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *Event) GetSource() *EventSource {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Event) GetFirstTimestamp() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.FirstTimestamp
	}
	return nil
}

func (m *Event) GetLastTimestamp() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastTimestamp
	}
	return nil
}

func (m *Event) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *Event) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *Event) GetEventTime() *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *Event) GetSeries() *EventSeries {
	if m != nil {
		return m.Series
	}
	return nil
}

func (m *Event) GetAction() string {
	if m != nil && m.Action != nil {
		return *m.Action
	}
	return ""
}

func (m *Event) GetRelated() *ObjectReference {
	if m != nil {
		return m.Related
	}
	return nil
}

func (m *Event) GetReportingComponent() string {
	if m != nil && m.ReportingComponent != nil {
		return *m.ReportingComponent
	}
	return ""
}

func (m *Event) GetReportingInstance() string {
	if m != nil && m.ReportingInstance != nil {
		return *m.ReportingInstance
	}
	return ""
}

// EventList is a list of events.
type EventList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of events
	Items            []*Event `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *EventList) Reset()                    { *m = EventList{} }
func (m *EventList) String() string            { return proto.CompactTextString(m) }
func (*EventList) ProtoMessage()               {}
func (*EventList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{46} }

func (m *EventList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EventList) GetItems() []*Event {
	if m != nil {
		return m.Items
	}
	return nil
}

// EventSeries contain information on series of events, i.e. thing that was/is happening
// continuously for some time.
type EventSeries struct {
	// Number of occurrences in this series up to the last heartbeat time
	Count *int32 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	// Time of the last occurrence observed
	LastObservedTime *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime `protobuf:"bytes,2,opt,name=lastObservedTime" json:"lastObservedTime,omitempty"`
	// State of this Series: Ongoing or Finished
	State            *string `protobuf:"bytes,3,opt,name=state" json:"state,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *EventSeries) Reset()                    { *m = EventSeries{} }
func (m *EventSeries) String() string            { return proto.CompactTextString(m) }
func (*EventSeries) ProtoMessage()               {}
func (*EventSeries) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{47} }

func (m *EventSeries) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *EventSeries) GetLastObservedTime() *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime {
	if m != nil {
		return m.LastObservedTime
	}
	return nil
}

func (m *EventSeries) GetState() string {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ""
}

// EventSource contains information for an event.
type EventSource struct {
	// Component from which the event is generated.
	// +optional
	Component *string `protobuf:"bytes,1,opt,name=component" json:"component,omitempty"`
	// Node name on which the event is generated.
	// +optional
	Host             *string `protobuf:"bytes,2,opt,name=host" json:"host,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *EventSource) Reset()                    { *m = EventSource{} }
func (m *EventSource) String() string            { return proto.CompactTextString(m) }
func (*EventSource) ProtoMessage()               {}
func (*EventSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{48} }

func (m *EventSource) GetComponent() string {
	if m != nil && m.Component != nil {
		return *m.Component
	}
	return ""
}

func (m *EventSource) GetHost() string {
	if m != nil && m.Host != nil {
		return *m.Host
	}
	return ""
}

// ExecAction describes a "run in container" action.
type ExecAction struct {
	// Command is the command line to execute inside the container, the working directory for the
	// command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
	// not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
	// a shell, you need to explicitly call out to that shell.
	// Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
	// +optional
	Command          []string `protobuf:"bytes,1,rep,name=command" json:"command,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ExecAction) Reset()                    { *m = ExecAction{} }
func (m *ExecAction) String() string            { return proto.CompactTextString(m) }
func (*ExecAction) ProtoMessage()               {}
func (*ExecAction) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{49} }

func (m *ExecAction) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// Represents a Fibre Channel volume.
// Fibre Channel volumes can only be mounted as read/write once.
// Fibre Channel volumes support ownership management and SELinux relabeling.
type FCVolumeSource struct {
	// Optional: FC target worldwide names (WWNs)
	// +optional
	TargetWWNs []string `protobuf:"bytes,1,rep,name=targetWWNs" json:"targetWWNs,omitempty"`
	// Optional: FC target lun number
	// +optional
	Lun *int32 `protobuf:"varint,2,opt,name=lun" json:"lun,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,3,opt,name=fsType" json:"fsType,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	// Optional: FC volume world wide identifiers (wwids)
	// Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
	// +optional
	Wwids            []string `protobuf:"bytes,5,rep,name=wwids" json:"wwids,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *FCVolumeSource) Reset()                    { *m = FCVolumeSource{} }
func (m *FCVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*FCVolumeSource) ProtoMessage()               {}
func (*FCVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{50} }

func (m *FCVolumeSource) GetTargetWWNs() []string {
	if m != nil {
		return m.TargetWWNs
	}
	return nil
}

func (m *FCVolumeSource) GetLun() int32 {
	if m != nil && m.Lun != nil {
		return *m.Lun
	}
	return 0
}

func (m *FCVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *FCVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *FCVolumeSource) GetWwids() []string {
	if m != nil {
		return m.Wwids
	}
	return nil
}

// FlexPersistentVolumeSource represents a generic persistent volume resource that is
// provisioned/attached using an exec based plugin.
type FlexPersistentVolumeSource struct {
	// Driver is the name of the driver to use for this volume.
	Driver *string `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
	// +optional
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// Optional: SecretRef is reference to the secret object containing
	// sensitive information to pass to the plugin scripts. This may be
	// empty if no secret object is specified. If the secret object
	// contains more than one secret, all secrets are passed to the plugin
	// scripts.
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	// Optional: Extra command options if any.
	// +optional
	Options          map[string]string `protobuf:"bytes,5,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *FlexPersistentVolumeSource) Reset()         { *m = FlexPersistentVolumeSource{} }
func (m *FlexPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*FlexPersistentVolumeSource) ProtoMessage()    {}
func (*FlexPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{51}
}

func (m *FlexPersistentVolumeSource) GetDriver() string {
	if m != nil && m.Driver != nil {
		return *m.Driver
	}
	return ""
}

func (m *FlexPersistentVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *FlexPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *FlexPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *FlexPersistentVolumeSource) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

// FlexVolume represents a generic volume resource that is
// provisioned/attached using an exec based plugin.
type FlexVolumeSource struct {
	// Driver is the name of the driver to use for this volume.
	Driver *string `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
	// +optional
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// Optional: SecretRef is reference to the secret object containing
	// sensitive information to pass to the plugin scripts. This may be
	// empty if no secret object is specified. If the secret object
	// contains more than one secret, all secrets are passed to the plugin
	// scripts.
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	// Optional: Extra command options if any.
	// +optional
	Options          map[string]string `protobuf:"bytes,5,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *FlexVolumeSource) Reset()                    { *m = FlexVolumeSource{} }
func (m *FlexVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*FlexVolumeSource) ProtoMessage()               {}
func (*FlexVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{52} }

func (m *FlexVolumeSource) GetDriver() string {
	if m != nil && m.Driver != nil {
		return *m.Driver
	}
	return ""
}

func (m *FlexVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *FlexVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *FlexVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *FlexVolumeSource) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

// Represents a Flocker volume mounted by the Flocker agent.
// One and only one of datasetName and datasetUUID should be set.
// Flocker volumes do not support ownership management or SELinux relabeling.
type FlockerVolumeSource struct {
	// Name of the dataset stored as metadata -> name on the dataset for Flocker
	// should be considered as deprecated
	// +optional
	DatasetName *string `protobuf:"bytes,1,opt,name=datasetName" json:"datasetName,omitempty"`
	// UUID of the dataset. This is unique identifier of a Flocker dataset
	// +optional
	DatasetUUID      *string `protobuf:"bytes,2,opt,name=datasetUUID" json:"datasetUUID,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FlockerVolumeSource) Reset()                    { *m = FlockerVolumeSource{} }
func (m *FlockerVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*FlockerVolumeSource) ProtoMessage()               {}
func (*FlockerVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{53} }

func (m *FlockerVolumeSource) GetDatasetName() string {
	if m != nil && m.DatasetName != nil {
		return *m.DatasetName
	}
	return ""
}

func (m *FlockerVolumeSource) GetDatasetUUID() string {
	if m != nil && m.DatasetUUID != nil {
		return *m.DatasetUUID
	}
	return ""
}

// Represents a Persistent Disk resource in Google Compute Engine.
//
// A GCE PD must exist before mounting to a container. The disk must
// also be in the same GCE project and zone as the kubelet. A GCE PD
// can only be mounted as read/write once or read-only many times. GCE
// PDs support ownership management and SELinux relabeling.
type GCEPersistentDiskVolumeSource struct {
	// Unique name of the PD resource in GCE. Used to identify the disk in GCE.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	PdName *string `protobuf:"bytes,1,opt,name=pdName" json:"pdName,omitempty"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// The partition in the volume that you want to mount.
	// If omitted, the default is to mount by volume name.
	// Examples: For volume /dev/sda1, you specify the partition as "1".
	// Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	Partition *int32 `protobuf:"varint,3,opt,name=partition" json:"partition,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	ReadOnly         *bool  `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *GCEPersistentDiskVolumeSource) Reset()         { *m = GCEPersistentDiskVolumeSource{} }
func (m *GCEPersistentDiskVolumeSource) String() string { return proto.CompactTextString(m) }
func (*GCEPersistentDiskVolumeSource) ProtoMessage()    {}
func (*GCEPersistentDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{54}
}

func (m *GCEPersistentDiskVolumeSource) GetPdName() string {
	if m != nil && m.PdName != nil {
		return *m.PdName
	}
	return ""
}

func (m *GCEPersistentDiskVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *GCEPersistentDiskVolumeSource) GetPartition() int32 {
	if m != nil && m.Partition != nil {
		return *m.Partition
	}
	return 0
}

func (m *GCEPersistentDiskVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Represents a volume that is populated with the contents of a git repository.
// Git repo volumes do not support ownership management.
// Git repo volumes support SELinux relabeling.
type GitRepoVolumeSource struct {
	// Repository URL
	Repository *string `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Commit hash for the specified revision.
	// +optional
	Revision *string `protobuf:"bytes,2,opt,name=revision" json:"revision,omitempty"`
	// Target directory name.
	// Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the
	// git repository.  Otherwise, if specified, the volume will contain the git repository in
	// the subdirectory with the given name.
	// +optional
	Directory        *string `protobuf:"bytes,3,opt,name=directory" json:"directory,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GitRepoVolumeSource) Reset()                    { *m = GitRepoVolumeSource{} }
func (m *GitRepoVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*GitRepoVolumeSource) ProtoMessage()               {}
func (*GitRepoVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{55} }

func (m *GitRepoVolumeSource) GetRepository() string {
	if m != nil && m.Repository != nil {
		return *m.Repository
	}
	return ""
}

func (m *GitRepoVolumeSource) GetRevision() string {
	if m != nil && m.Revision != nil {
		return *m.Revision
	}
	return ""
}

func (m *GitRepoVolumeSource) GetDirectory() string {
	if m != nil && m.Directory != nil {
		return *m.Directory
	}
	return ""
}

// Represents a Glusterfs mount that lasts the lifetime of a pod.
// Glusterfs volumes do not support ownership management or SELinux relabeling.
type GlusterfsVolumeSource struct {
	// EndpointsName is the endpoint name that details Glusterfs topology.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
	Endpoints *string `protobuf:"bytes,1,opt,name=endpoints" json:"endpoints,omitempty"`
	// Path is the Glusterfs volume path.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.
	// Defaults to false.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
	// +optional
	ReadOnly         *bool  `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *GlusterfsVolumeSource) Reset()                    { *m = GlusterfsVolumeSource{} }
func (m *GlusterfsVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*GlusterfsVolumeSource) ProtoMessage()               {}
func (*GlusterfsVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{56} }

func (m *GlusterfsVolumeSource) GetEndpoints() string {
	if m != nil && m.Endpoints != nil {
		return *m.Endpoints
	}
	return ""
}

func (m *GlusterfsVolumeSource) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *GlusterfsVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// HTTPGetAction describes an action based on HTTP Get requests.
type HTTPGetAction struct {
	// Path to access on the HTTP server.
	// +optional
	Path *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// Name or number of the port to access on the container.
	// Number must be in the range 1 to 65535.
	// Name must be an IANA_SVC_NAME.
	Port *k8s_io_apimachinery_pkg_util_intstr.IntOrString `protobuf:"bytes,2,opt,name=port" json:"port,omitempty"`
	// Host name to connect to, defaults to the pod IP. You probably want to set
	// "Host" in httpHeaders instead.
	// +optional
	Host *string `protobuf:"bytes,3,opt,name=host" json:"host,omitempty"`
	// Scheme to use for connecting to the host.
	// Defaults to HTTP.
	// +optional
	Scheme *string `protobuf:"bytes,4,opt,name=scheme" json:"scheme,omitempty"`
	// Custom headers to set in the request. HTTP allows repeated headers.
	// +optional
	HttpHeaders      []*HTTPHeader `protobuf:"bytes,5,rep,name=httpHeaders" json:"httpHeaders,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *HTTPGetAction) Reset()                    { *m = HTTPGetAction{} }
func (m *HTTPGetAction) String() string            { return proto.CompactTextString(m) }
func (*HTTPGetAction) ProtoMessage()               {}
func (*HTTPGetAction) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{57} }

func (m *HTTPGetAction) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *HTTPGetAction) GetPort() *k8s_io_apimachinery_pkg_util_intstr.IntOrString {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *HTTPGetAction) GetHost() string {
	if m != nil && m.Host != nil {
		return *m.Host
	}
	return ""
}

func (m *HTTPGetAction) GetScheme() string {
	if m != nil && m.Scheme != nil {
		return *m.Scheme
	}
	return ""
}

func (m *HTTPGetAction) GetHttpHeaders() []*HTTPHeader {
	if m != nil {
		return m.HttpHeaders
	}
	return nil
}

// HTTPHeader describes a custom header to be used in HTTP probes
type HTTPHeader struct {
	// The header field name
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The header field value
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *HTTPHeader) Reset()                    { *m = HTTPHeader{} }
func (m *HTTPHeader) String() string            { return proto.CompactTextString(m) }
func (*HTTPHeader) ProtoMessage()               {}
func (*HTTPHeader) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{58} }

func (m *HTTPHeader) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// Handler defines a specific action that should be taken
// TODO: pass structured data to these actions, and document that data here.
type Handler struct {
	// One and only one of the following should be specified.
	// Exec specifies the action to take.
	// +optional
	Exec *ExecAction `protobuf:"bytes,1,opt,name=exec" json:"exec,omitempty"`
	// HTTPGet specifies the http request to perform.
	// +optional
	HttpGet *HTTPGetAction `protobuf:"bytes,2,opt,name=httpGet" json:"httpGet,omitempty"`
	// TCPSocket specifies an action involving a TCP port.
	// TCP hooks not yet supported
	// TODO: implement a realistic TCP lifecycle hook
	// +optional
	TcpSocket        *TCPSocketAction `protobuf:"bytes,3,opt,name=tcpSocket" json:"tcpSocket,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Handler) Reset()                    { *m = Handler{} }
func (m *Handler) String() string            { return proto.CompactTextString(m) }
func (*Handler) ProtoMessage()               {}
func (*Handler) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{59} }

func (m *Handler) GetExec() *ExecAction {
	if m != nil {
		return m.Exec
	}
	return nil
}

func (m *Handler) GetHttpGet() *HTTPGetAction {
	if m != nil {
		return m.HttpGet
	}
	return nil
}

func (m *Handler) GetTcpSocket() *TCPSocketAction {
	if m != nil {
		return m.TcpSocket
	}
	return nil
}

// HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the
// pod's hosts file.
type HostAlias struct {
	// IP address of the host file entry.
	Ip *string `protobuf:"bytes,1,opt,name=ip" json:"ip,omitempty"`
	// Hostnames for the above IP address.
	Hostnames        []string `protobuf:"bytes,2,rep,name=hostnames" json:"hostnames,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *HostAlias) Reset()                    { *m = HostAlias{} }
func (m *HostAlias) String() string            { return proto.CompactTextString(m) }
func (*HostAlias) ProtoMessage()               {}
func (*HostAlias) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{60} }

func (m *HostAlias) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

func (m *HostAlias) GetHostnames() []string {
	if m != nil {
		return m.Hostnames
	}
	return nil
}

// Represents a host path mapped into a pod.
// Host path volumes do not support ownership management or SELinux relabeling.
type HostPathVolumeSource struct {
	// Path of the directory on the host.
	// If the path is a symlink, it will follow the link to the real path.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	Path *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// Type for HostPath Volume
	// Defaults to ""
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	// +optional
	Type             *string `protobuf:"bytes,2,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *HostPathVolumeSource) Reset()                    { *m = HostPathVolumeSource{} }
func (m *HostPathVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*HostPathVolumeSource) ProtoMessage()               {}
func (*HostPathVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{61} }

func (m *HostPathVolumeSource) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *HostPathVolumeSource) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

// ISCSIPersistentVolumeSource represents an ISCSI disk.
// ISCSI volumes can only be mounted as read/write once.
// ISCSI volumes support ownership management and SELinux relabeling.
type ISCSIPersistentVolumeSource struct {
	// iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	TargetPortal *string `protobuf:"bytes,1,opt,name=targetPortal" json:"targetPortal,omitempty"`
	// Target iSCSI Qualified Name.
	Iqn *string `protobuf:"bytes,2,opt,name=iqn" json:"iqn,omitempty"`
	// iSCSI Target Lun number.
	Lun *int32 `protobuf:"varint,3,opt,name=lun" json:"lun,omitempty"`
	// iSCSI Interface Name that uses an iSCSI transport.
	// Defaults to 'default' (tcp).
	// +optional
	IscsiInterface *string `protobuf:"bytes,4,opt,name=iscsiInterface" json:"iscsiInterface,omitempty"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,5,opt,name=fsType" json:"fsType,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// +optional
	ReadOnly *bool `protobuf:"varint,6,opt,name=readOnly" json:"readOnly,omitempty"`
	// iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	// +optional
	Portals []string `protobuf:"bytes,7,rep,name=portals" json:"portals,omitempty"`
	// whether support iSCSI Discovery CHAP authentication
	// +optional
	ChapAuthDiscovery *bool `protobuf:"varint,8,opt,name=chapAuthDiscovery" json:"chapAuthDiscovery,omitempty"`
	// whether support iSCSI Session CHAP authentication
	// +optional
	ChapAuthSession *bool `protobuf:"varint,11,opt,name=chapAuthSession" json:"chapAuthSession,omitempty"`
	// CHAP Secret for iSCSI target and initiator authentication
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,10,opt,name=secretRef" json:"secretRef,omitempty"`
	// Custom iSCSI Initiator Name.
	// If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
	// <target portal>:<volume name> will be created for the connection.
	// +optional
	InitiatorName    *string `protobuf:"bytes,12,opt,name=initiatorName" json:"initiatorName,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ISCSIPersistentVolumeSource) Reset()         { *m = ISCSIPersistentVolumeSource{} }
func (m *ISCSIPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*ISCSIPersistentVolumeSource) ProtoMessage()    {}
func (*ISCSIPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{62}
}

func (m *ISCSIPersistentVolumeSource) GetTargetPortal() string {
	if m != nil && m.TargetPortal != nil {
		return *m.TargetPortal
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetIqn() string {
	if m != nil && m.Iqn != nil {
		return *m.Iqn
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetLun() int32 {
	if m != nil && m.Lun != nil {
		return *m.Lun
	}
	return 0
}

func (m *ISCSIPersistentVolumeSource) GetIscsiInterface() string {
	if m != nil && m.IscsiInterface != nil {
		return *m.IscsiInterface
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *ISCSIPersistentVolumeSource) GetPortals() []string {
	if m != nil {
		return m.Portals
	}
	return nil
}

func (m *ISCSIPersistentVolumeSource) GetChapAuthDiscovery() bool {
	if m != nil && m.ChapAuthDiscovery != nil {
		return *m.ChapAuthDiscovery
	}
	return false
}

func (m *ISCSIPersistentVolumeSource) GetChapAuthSession() bool {
	if m != nil && m.ChapAuthSession != nil {
		return *m.ChapAuthSession
	}
	return false
}

func (m *ISCSIPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ISCSIPersistentVolumeSource) GetInitiatorName() string {
	if m != nil && m.InitiatorName != nil {
		return *m.InitiatorName
	}
	return ""
}

// Represents an ISCSI disk.
// ISCSI volumes can only be mounted as read/write once.
// ISCSI volumes support ownership management and SELinux relabeling.
type ISCSIVolumeSource struct {
	// iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	TargetPortal *string `protobuf:"bytes,1,opt,name=targetPortal" json:"targetPortal,omitempty"`
	// Target iSCSI Qualified Name.
	Iqn *string `protobuf:"bytes,2,opt,name=iqn" json:"iqn,omitempty"`
	// iSCSI Target Lun number.
	Lun *int32 `protobuf:"varint,3,opt,name=lun" json:"lun,omitempty"`
	// iSCSI Interface Name that uses an iSCSI transport.
	// Defaults to 'default' (tcp).
	// +optional
	IscsiInterface *string `protobuf:"bytes,4,opt,name=iscsiInterface" json:"iscsiInterface,omitempty"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,5,opt,name=fsType" json:"fsType,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// +optional
	ReadOnly *bool `protobuf:"varint,6,opt,name=readOnly" json:"readOnly,omitempty"`
	// iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	// +optional
	Portals []string `protobuf:"bytes,7,rep,name=portals" json:"portals,omitempty"`
	// whether support iSCSI Discovery CHAP authentication
	// +optional
	ChapAuthDiscovery *bool `protobuf:"varint,8,opt,name=chapAuthDiscovery" json:"chapAuthDiscovery,omitempty"`
	// whether support iSCSI Session CHAP authentication
	// +optional
	ChapAuthSession *bool `protobuf:"varint,11,opt,name=chapAuthSession" json:"chapAuthSession,omitempty"`
	// CHAP Secret for iSCSI target and initiator authentication
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,10,opt,name=secretRef" json:"secretRef,omitempty"`
	// Custom iSCSI Initiator Name.
	// If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
	// <target portal>:<volume name> will be created for the connection.
	// +optional
	InitiatorName    *string `protobuf:"bytes,12,opt,name=initiatorName" json:"initiatorName,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ISCSIVolumeSource) Reset()                    { *m = ISCSIVolumeSource{} }
func (m *ISCSIVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*ISCSIVolumeSource) ProtoMessage()               {}
func (*ISCSIVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{63} }

func (m *ISCSIVolumeSource) GetTargetPortal() string {
	if m != nil && m.TargetPortal != nil {
		return *m.TargetPortal
	}
	return ""
}

func (m *ISCSIVolumeSource) GetIqn() string {
	if m != nil && m.Iqn != nil {
		return *m.Iqn
	}
	return ""
}

func (m *ISCSIVolumeSource) GetLun() int32 {
	if m != nil && m.Lun != nil {
		return *m.Lun
	}
	return 0
}

func (m *ISCSIVolumeSource) GetIscsiInterface() string {
	if m != nil && m.IscsiInterface != nil {
		return *m.IscsiInterface
	}
	return ""
}

func (m *ISCSIVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *ISCSIVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *ISCSIVolumeSource) GetPortals() []string {
	if m != nil {
		return m.Portals
	}
	return nil
}

func (m *ISCSIVolumeSource) GetChapAuthDiscovery() bool {
	if m != nil && m.ChapAuthDiscovery != nil {
		return *m.ChapAuthDiscovery
	}
	return false
}

func (m *ISCSIVolumeSource) GetChapAuthSession() bool {
	if m != nil && m.ChapAuthSession != nil {
		return *m.ChapAuthSession
	}
	return false
}

func (m *ISCSIVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ISCSIVolumeSource) GetInitiatorName() string {
	if m != nil && m.InitiatorName != nil {
		return *m.InitiatorName
	}
	return ""
}

// Maps a string key to a path within a volume.
type KeyToPath struct {
	// The key to project.
	Key *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The relative path of the file to map the key to.
	// May not be an absolute path.
	// May not contain the path element '..'.
	// May not start with the string '..'.
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Optional: mode bits to use on this file, must be a value between 0
	// and 0777. If not specified, the volume defaultMode will be used.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	Mode             *int32 `protobuf:"varint,3,opt,name=mode" json:"mode,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *KeyToPath) Reset()                    { *m = KeyToPath{} }
func (m *KeyToPath) String() string            { return proto.CompactTextString(m) }
func (*KeyToPath) ProtoMessage()               {}
func (*KeyToPath) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{64} }

func (m *KeyToPath) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *KeyToPath) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *KeyToPath) GetMode() int32 {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return 0
}

// Lifecycle describes actions that the management system should take in response to container lifecycle
// events. For the PostStart and PreStop lifecycle handlers, management of the container blocks
// until the action is complete, unless the container process fails, in which case the handler is aborted.
type Lifecycle struct {
	// PostStart is called immediately after a container is created. If the handler fails,
	// the container is terminated and restarted according to its restart policy.
	// Other management of the container blocks until the hook completes.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	// +optional
	PostStart *Handler `protobuf:"bytes,1,opt,name=postStart" json:"postStart,omitempty"`
	// PreStop is called immediately before a container is terminated.
	// The container is terminated after the handler completes.
	// The reason for termination is passed to the handler.
	// Regardless of the outcome of the handler, the container is eventually terminated.
	// Other management of the container blocks until the hook completes.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	// +optional
	PreStop          *Handler `protobuf:"bytes,2,opt,name=preStop" json:"preStop,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Lifecycle) Reset()                    { *m = Lifecycle{} }
func (m *Lifecycle) String() string            { return proto.CompactTextString(m) }
func (*Lifecycle) ProtoMessage()               {}
func (*Lifecycle) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{65} }

func (m *Lifecycle) GetPostStart() *Handler {
	if m != nil {
		return m.PostStart
	}
	return nil
}

func (m *Lifecycle) GetPreStop() *Handler {
	if m != nil {
		return m.PreStop
	}
	return nil
}

// LimitRange sets resource usage limits for each kind of resource in a Namespace.
type LimitRange struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the limits enforced.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec             *LimitRangeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *LimitRange) Reset()                    { *m = LimitRange{} }
func (m *LimitRange) String() string            { return proto.CompactTextString(m) }
func (*LimitRange) ProtoMessage()               {}
func (*LimitRange) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{66} }

func (m *LimitRange) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *LimitRange) GetSpec() *LimitRangeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
type LimitRangeItem struct {
	// Type of resource that this limit applies to.
	// +optional
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Max usage constraints on this kind by resource name.
	// +optional
	Max map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,2,rep,name=max" json:"max,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Min usage constraints on this kind by resource name.
	// +optional
	Min map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,3,rep,name=min" json:"min,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Default resource requirement limit value by resource name if resource limit is omitted.
	// +optional
	Default map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,4,rep,name=default" json:"default,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
	// +optional
	DefaultRequest map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,5,rep,name=defaultRequest" json:"defaultRequest,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
	// +optional
	MaxLimitRequestRatio map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,6,rep,name=maxLimitRequestRatio" json:"maxLimitRequestRatio,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized     []byte                                                    `json:"-"`
}

func (m *LimitRangeItem) Reset()                    { *m = LimitRangeItem{} }
func (m *LimitRangeItem) String() string            { return proto.CompactTextString(m) }
func (*LimitRangeItem) ProtoMessage()               {}
func (*LimitRangeItem) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{67} }

func (m *LimitRangeItem) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *LimitRangeItem) GetMax() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Max
	}
	return nil
}

func (m *LimitRangeItem) GetMin() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Min
	}
	return nil
}

func (m *LimitRangeItem) GetDefault() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Default
	}
	return nil
}

func (m *LimitRangeItem) GetDefaultRequest() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.DefaultRequest
	}
	return nil
}

func (m *LimitRangeItem) GetMaxLimitRequestRatio() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.MaxLimitRequestRatio
	}
	return nil
}

// LimitRangeList is a list of LimitRange items.
type LimitRangeList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of LimitRange objects.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	Items            []*LimitRange `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *LimitRangeList) Reset()                    { *m = LimitRangeList{} }
func (m *LimitRangeList) String() string            { return proto.CompactTextString(m) }
func (*LimitRangeList) ProtoMessage()               {}
func (*LimitRangeList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{68} }

func (m *LimitRangeList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *LimitRangeList) GetItems() []*LimitRange {
	if m != nil {
		return m.Items
	}
	return nil
}

// LimitRangeSpec defines a min/max usage limit for resources that match on kind.
type LimitRangeSpec struct {
	// Limits is the list of LimitRangeItem objects that are enforced.
	Limits           []*LimitRangeItem `protobuf:"bytes,1,rep,name=limits" json:"limits,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *LimitRangeSpec) Reset()                    { *m = LimitRangeSpec{} }
func (m *LimitRangeSpec) String() string            { return proto.CompactTextString(m) }
func (*LimitRangeSpec) ProtoMessage()               {}
func (*LimitRangeSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{69} }

func (m *LimitRangeSpec) GetLimits() []*LimitRangeItem {
	if m != nil {
		return m.Limits
	}
	return nil
}

// List holds a list of objects, which may not be known by the server.
type List struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of objects
	Items            []*k8s_io_apimachinery_pkg_runtime.RawExtension `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte                                          `json:"-"`
}

func (m *List) Reset()                    { *m = List{} }
func (m *List) String() string            { return proto.CompactTextString(m) }
func (*List) ProtoMessage()               {}
func (*List) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{70} }

func (m *List) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *List) GetItems() []*k8s_io_apimachinery_pkg_runtime.RawExtension {
	if m != nil {
		return m.Items
	}
	return nil
}

// ListOptions is the query options to a standard REST list call.
// DEPRECATED: This type has been moved to meta/v1 and will be removed soon.
// +k8s:openapi-gen=false
type ListOptions struct {
	// A selector to restrict the list of returned objects by their labels.
	// Defaults to everything.
	// +optional
	LabelSelector *string `protobuf:"bytes,1,opt,name=labelSelector" json:"labelSelector,omitempty"`
	// A selector to restrict the list of returned objects by their fields.
	// Defaults to everything.
	// +optional
	FieldSelector *string `protobuf:"bytes,2,opt,name=fieldSelector" json:"fieldSelector,omitempty"`
	// If true, partially initialized resources are included in the response.
	// +optional
	IncludeUninitialized *bool `protobuf:"varint,6,opt,name=includeUninitialized" json:"includeUninitialized,omitempty"`
	// Watch for changes to the described resources and return them as a stream of
	// add, update, and remove notifications. Specify resourceVersion.
	// +optional
	Watch *bool `protobuf:"varint,3,opt,name=watch" json:"watch,omitempty"`
	// When specified with a watch call, shows changes that occur after that particular version of a resource.
	// Defaults to changes from the beginning of history.
	// When specified for list:
	// - if unset, then the result is returned from remote storage based on quorum-read flag;
	// - if it's 0, then we simply return what we currently have in cache, no guarantee;
	// - if set to non zero, then the result is at least as fresh as given rv.
	// +optional
	ResourceVersion *string `protobuf:"bytes,4,opt,name=resourceVersion" json:"resourceVersion,omitempty"`
	// Timeout for the list/watch call.
	// +optional
	TimeoutSeconds   *int64 `protobuf:"varint,5,opt,name=timeoutSeconds" json:"timeoutSeconds,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ListOptions) Reset()                    { *m = ListOptions{} }
func (m *ListOptions) String() string            { return proto.CompactTextString(m) }
func (*ListOptions) ProtoMessage()               {}
func (*ListOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{71} }

func (m *ListOptions) GetLabelSelector() string {
	if m != nil && m.LabelSelector != nil {
		return *m.LabelSelector
	}
	return ""
}

func (m *ListOptions) GetFieldSelector() string {
	if m != nil && m.FieldSelector != nil {
		return *m.FieldSelector
	}
	return ""
}

func (m *ListOptions) GetIncludeUninitialized() bool {
	if m != nil && m.IncludeUninitialized != nil {
		return *m.IncludeUninitialized
	}
	return false
}

func (m *ListOptions) GetWatch() bool {
	if m != nil && m.Watch != nil {
		return *m.Watch
	}
	return false
}

func (m *ListOptions) GetResourceVersion() string {
	if m != nil && m.ResourceVersion != nil {
		return *m.ResourceVersion
	}
	return ""
}

func (m *ListOptions) GetTimeoutSeconds() int64 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return 0
}

// LoadBalancerIngress represents the status of a load-balancer ingress point:
// traffic intended for the service should be sent to an ingress point.
type LoadBalancerIngress struct {
	// IP is set for load-balancer ingress points that are IP based
	// (typically GCE or OpenStack load-balancers)
	// +optional
	Ip *string `protobuf:"bytes,1,opt,name=ip" json:"ip,omitempty"`
	// Hostname is set for load-balancer ingress points that are DNS based
	// (typically AWS load-balancers)
	// +optional
	Hostname         *string `protobuf:"bytes,2,opt,name=hostname" json:"hostname,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LoadBalancerIngress) Reset()                    { *m = LoadBalancerIngress{} }
func (m *LoadBalancerIngress) String() string            { return proto.CompactTextString(m) }
func (*LoadBalancerIngress) ProtoMessage()               {}
func (*LoadBalancerIngress) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{72} }

func (m *LoadBalancerIngress) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

func (m *LoadBalancerIngress) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

// LoadBalancerStatus represents the status of a load-balancer.
type LoadBalancerStatus struct {
	// Ingress is a list containing ingress points for the load-balancer.
	// Traffic intended for the service should be sent to these ingress points.
	// +optional
	Ingress          []*LoadBalancerIngress `protobuf:"bytes,1,rep,name=ingress" json:"ingress,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *LoadBalancerStatus) Reset()                    { *m = LoadBalancerStatus{} }
func (m *LoadBalancerStatus) String() string            { return proto.CompactTextString(m) }
func (*LoadBalancerStatus) ProtoMessage()               {}
func (*LoadBalancerStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{73} }

func (m *LoadBalancerStatus) GetIngress() []*LoadBalancerIngress {
	if m != nil {
		return m.Ingress
	}
	return nil
}

// LocalObjectReference contains enough information to let you locate the
// referenced object inside the same namespace.
type LocalObjectReference struct {
	// Name of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	// TODO: Add other useful fields. apiVersion, kind, uid?
	// +optional
	Name             *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LocalObjectReference) Reset()                    { *m = LocalObjectReference{} }
func (m *LocalObjectReference) String() string            { return proto.CompactTextString(m) }
func (*LocalObjectReference) ProtoMessage()               {}
func (*LocalObjectReference) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{74} }

func (m *LocalObjectReference) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

// Local represents directly-attached storage with node affinity
type LocalVolumeSource struct {
	// The full path to the volume on the node
	// For alpha, this path must be a directory
	// Once block as a source is supported, then this path can point to a block device
	Path             *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LocalVolumeSource) Reset()                    { *m = LocalVolumeSource{} }
func (m *LocalVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*LocalVolumeSource) ProtoMessage()               {}
func (*LocalVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{75} }

func (m *LocalVolumeSource) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

// Represents an NFS mount that lasts the lifetime of a pod.
// NFS volumes do not support ownership management or SELinux relabeling.
type NFSVolumeSource struct {
	// Server is the hostname or IP address of the NFS server.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	Server *string `protobuf:"bytes,1,opt,name=server" json:"server,omitempty"`
	// Path that is exported by the NFS server.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// ReadOnly here will force
	// the NFS export to be mounted with read-only permissions.
	// Defaults to false.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	// +optional
	ReadOnly         *bool  `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *NFSVolumeSource) Reset()                    { *m = NFSVolumeSource{} }
func (m *NFSVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*NFSVolumeSource) ProtoMessage()               {}
func (*NFSVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{76} }

func (m *NFSVolumeSource) GetServer() string {
	if m != nil && m.Server != nil {
		return *m.Server
	}
	return ""
}

func (m *NFSVolumeSource) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *NFSVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Namespace provides a scope for Names.
// Use of multiple namespaces is optional.
type Namespace struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the behavior of the Namespace.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *NamespaceSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status describes the current status of a Namespace.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *NamespaceStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Namespace) Reset()                    { *m = Namespace{} }
func (m *Namespace) String() string            { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()               {}
func (*Namespace) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{77} }

func (m *Namespace) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Namespace) GetSpec() *NamespaceSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Namespace) GetStatus() *NamespaceStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// NamespaceList is a list of Namespaces.
type NamespaceList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is the list of Namespace objects in the list.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	Items            []*Namespace `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *NamespaceList) Reset()                    { *m = NamespaceList{} }
func (m *NamespaceList) String() string            { return proto.CompactTextString(m) }
func (*NamespaceList) ProtoMessage()               {}
func (*NamespaceList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{78} }

func (m *NamespaceList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NamespaceList) GetItems() []*Namespace {
	if m != nil {
		return m.Items
	}
	return nil
}

// NamespaceSpec describes the attributes on a Namespace.
type NamespaceSpec struct {
	// Finalizers is an opaque list of values that must be empty to permanently remove object from storage.
	// More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
	// +optional
	Finalizers       []string `protobuf:"bytes,1,rep,name=finalizers" json:"finalizers,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *NamespaceSpec) Reset()                    { *m = NamespaceSpec{} }
func (m *NamespaceSpec) String() string            { return proto.CompactTextString(m) }
func (*NamespaceSpec) ProtoMessage()               {}
func (*NamespaceSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{79} }

func (m *NamespaceSpec) GetFinalizers() []string {
	if m != nil {
		return m.Finalizers
	}
	return nil
}

// NamespaceStatus is information about the current status of a Namespace.
type NamespaceStatus struct {
	// Phase is the current lifecycle phase of the namespace.
	// More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
	// +optional
	Phase            *string `protobuf:"bytes,1,opt,name=phase" json:"phase,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NamespaceStatus) Reset()                    { *m = NamespaceStatus{} }
func (m *NamespaceStatus) String() string            { return proto.CompactTextString(m) }
func (*NamespaceStatus) ProtoMessage()               {}
func (*NamespaceStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{80} }

func (m *NamespaceStatus) GetPhase() string {
	if m != nil && m.Phase != nil {
		return *m.Phase
	}
	return ""
}

// Node is a worker node in Kubernetes.
// Each node will have a unique identifier in the cache (i.e. in etcd).
type Node struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the behavior of a node.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *NodeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Most recently observed status of the node.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *NodeStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{81} }

func (m *Node) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Node) GetSpec() *NodeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Node) GetStatus() *NodeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// NodeAddress contains information for the node's address.
type NodeAddress struct {
	// Node address type, one of Hostname, ExternalIP or InternalIP.
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// The node address.
	Address          *string `protobuf:"bytes,2,opt,name=address" json:"address,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NodeAddress) Reset()                    { *m = NodeAddress{} }
func (m *NodeAddress) String() string            { return proto.CompactTextString(m) }
func (*NodeAddress) ProtoMessage()               {}
func (*NodeAddress) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{82} }

func (m *NodeAddress) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *NodeAddress) GetAddress() string {
	if m != nil && m.Address != nil {
		return *m.Address
	}
	return ""
}

// Node affinity is a group of node affinity scheduling rules.
type NodeAffinity struct {
	// If the affinity requirements specified by this field are not met at
	// scheduling time, the pod will not be scheduled onto the node.
	// If the affinity requirements specified by this field cease to be met
	// at some point during pod execution (e.g. due to an update), the system
	// may or may not try to eventually evict the pod from its node.
	// +optional
	RequiredDuringSchedulingIgnoredDuringExecution *NodeSelector `protobuf:"bytes,1,opt,name=requiredDuringSchedulingIgnoredDuringExecution" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	// The scheduler will prefer to schedule pods to nodes that satisfy
	// the affinity expressions specified by this field, but it may choose
	// a node that violates one or more of the expressions. The node that is
	// most preferred is the one with the greatest sum of weights, i.e.
	// for each node that meets all of the scheduling requirements (resource
	// request, requiredDuringScheduling affinity expressions, etc.),
	// compute a sum by iterating through the elements of this field and adding
	// "weight" to the sum if the node matches the corresponding matchExpressions; the
	// node(s) with the highest sum are the most preferred.
	// +optional
	PreferredDuringSchedulingIgnoredDuringExecution []*PreferredSchedulingTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
	XXX_unrecognized                                []byte                     `json:"-"`
}

func (m *NodeAffinity) Reset()                    { *m = NodeAffinity{} }
func (m *NodeAffinity) String() string            { return proto.CompactTextString(m) }
func (*NodeAffinity) ProtoMessage()               {}
func (*NodeAffinity) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{83} }

func (m *NodeAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() *NodeSelector {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *NodeAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*PreferredSchedulingTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// NodeCondition contains condition information for a node.
type NodeCondition struct {
	// Type of node condition.
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Status of the condition, one of True, False, Unknown.
	Status *string `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// Last time we got an update on a given condition.
	// +optional
	LastHeartbeatTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,3,opt,name=lastHeartbeatTime" json:"lastHeartbeatTime,omitempty"`
	// Last time the condition transit from one status to another.
	// +optional
	LastTransitionTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,4,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// (brief) reason for the condition's last transition.
	// +optional
	Reason *string `protobuf:"bytes,5,opt,name=reason" json:"reason,omitempty"`
	// Human readable message indicating details about last transition.
	// +optional
	Message          *string `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NodeCondition) Reset()                    { *m = NodeCondition{} }
func (m *NodeCondition) String() string            { return proto.CompactTextString(m) }
func (*NodeCondition) ProtoMessage()               {}
func (*NodeCondition) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{84} }

func (m *NodeCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *NodeCondition) GetStatus() string {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ""
}

func (m *NodeCondition) GetLastHeartbeatTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *NodeCondition) GetLastTransitionTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *NodeCondition) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *NodeCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.
type NodeConfigSource struct {
	ConfigMapRef     *ObjectReference `protobuf:"bytes,1,opt,name=configMapRef" json:"configMapRef,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *NodeConfigSource) Reset()                    { *m = NodeConfigSource{} }
func (m *NodeConfigSource) String() string            { return proto.CompactTextString(m) }
func (*NodeConfigSource) ProtoMessage()               {}
func (*NodeConfigSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{85} }

func (m *NodeConfigSource) GetConfigMapRef() *ObjectReference {
	if m != nil {
		return m.ConfigMapRef
	}
	return nil
}

// NodeDaemonEndpoints lists ports opened by daemons running on the Node.
type NodeDaemonEndpoints struct {
	// Endpoint on which Kubelet is listening.
	// +optional
	KubeletEndpoint  *DaemonEndpoint `protobuf:"bytes,1,opt,name=kubeletEndpoint" json:"kubeletEndpoint,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *NodeDaemonEndpoints) Reset()                    { *m = NodeDaemonEndpoints{} }
func (m *NodeDaemonEndpoints) String() string            { return proto.CompactTextString(m) }
func (*NodeDaemonEndpoints) ProtoMessage()               {}
func (*NodeDaemonEndpoints) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{86} }

func (m *NodeDaemonEndpoints) GetKubeletEndpoint() *DaemonEndpoint {
	if m != nil {
		return m.KubeletEndpoint
	}
	return nil
}

// NodeList is the whole list of all Nodes which have been registered with master.
type NodeList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of nodes
	Items            []*Node `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NodeList) Reset()                    { *m = NodeList{} }
func (m *NodeList) String() string            { return proto.CompactTextString(m) }
func (*NodeList) ProtoMessage()               {}
func (*NodeList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{87} }

func (m *NodeList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeList) GetItems() []*Node {
	if m != nil {
		return m.Items
	}
	return nil
}

// NodeProxyOptions is the query options to a Node's proxy call.
type NodeProxyOptions struct {
	// Path is the URL path to use for the current proxy request to node.
	// +optional
	Path             *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NodeProxyOptions) Reset()                    { *m = NodeProxyOptions{} }
func (m *NodeProxyOptions) String() string            { return proto.CompactTextString(m) }
func (*NodeProxyOptions) ProtoMessage()               {}
func (*NodeProxyOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{88} }

func (m *NodeProxyOptions) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

// NodeResources is an object for conveying resource information about a node.
// see http://releases.k8s.io/HEAD/docs/design/resources.md for more details.
type NodeResources struct {
	// Capacity represents the available resources of a node
	Capacity         map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,1,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte                                                    `json:"-"`
}

func (m *NodeResources) Reset()                    { *m = NodeResources{} }
func (m *NodeResources) String() string            { return proto.CompactTextString(m) }
func (*NodeResources) ProtoMessage()               {}
func (*NodeResources) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{89} }

func (m *NodeResources) GetCapacity() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

// A node selector represents the union of the results of one or more label queries
// over a set of nodes; that is, it represents the OR of the selectors represented
// by the node selector terms.
type NodeSelector struct {
	// Required. A list of node selector terms. The terms are ORed.
	NodeSelectorTerms []*NodeSelectorTerm `protobuf:"bytes,1,rep,name=nodeSelectorTerms" json:"nodeSelectorTerms,omitempty"`
	XXX_unrecognized  []byte              `json:"-"`
}

func (m *NodeSelector) Reset()                    { *m = NodeSelector{} }
func (m *NodeSelector) String() string            { return proto.CompactTextString(m) }
func (*NodeSelector) ProtoMessage()               {}
func (*NodeSelector) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{90} }

func (m *NodeSelector) GetNodeSelectorTerms() []*NodeSelectorTerm {
	if m != nil {
		return m.NodeSelectorTerms
	}
	return nil
}

// A node selector requirement is a selector that contains values, a key, and an operator
// that relates the key and values.
type NodeSelectorRequirement struct {
	// The label key that the selector applies to.
	Key *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Represents a key's relationship to a set of values.
	// Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
	Operator *string `protobuf:"bytes,2,opt,name=operator" json:"operator,omitempty"`
	// An array of string values. If the operator is In or NotIn,
	// the values array must be non-empty. If the operator is Exists or DoesNotExist,
	// the values array must be empty. If the operator is Gt or Lt, the values
	// array must have a single element, which will be interpreted as an integer.
	// This array is replaced during a strategic merge patch.
	// +optional
	Values           []string `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *NodeSelectorRequirement) Reset()         { *m = NodeSelectorRequirement{} }
func (m *NodeSelectorRequirement) String() string { return proto.CompactTextString(m) }
func (*NodeSelectorRequirement) ProtoMessage()    {}
func (*NodeSelectorRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{91}
}

func (m *NodeSelectorRequirement) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *NodeSelectorRequirement) GetOperator() string {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return ""
}

func (m *NodeSelectorRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// A null or empty node selector term matches no objects.
type NodeSelectorTerm struct {
	// Required. A list of node selector requirements. The requirements are ANDed.
	MatchExpressions []*NodeSelectorRequirement `protobuf:"bytes,1,rep,name=matchExpressions" json:"matchExpressions,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *NodeSelectorTerm) Reset()                    { *m = NodeSelectorTerm{} }
func (m *NodeSelectorTerm) String() string            { return proto.CompactTextString(m) }
func (*NodeSelectorTerm) ProtoMessage()               {}
func (*NodeSelectorTerm) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{92} }

func (m *NodeSelectorTerm) GetMatchExpressions() []*NodeSelectorRequirement {
	if m != nil {
		return m.MatchExpressions
	}
	return nil
}

// NodeSpec describes the attributes that a node is created with.
type NodeSpec struct {
	// PodCIDR represents the pod IP range assigned to the node.
	// +optional
	PodCIDR *string `protobuf:"bytes,1,opt,name=podCIDR" json:"podCIDR,omitempty"`
	// External ID of the node assigned by some machine database (e.g. a cloud provider).
	// Deprecated.
	// +optional
	ExternalID *string `protobuf:"bytes,2,opt,name=externalID" json:"externalID,omitempty"`
	// ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
	// +optional
	ProviderID *string `protobuf:"bytes,3,opt,name=providerID" json:"providerID,omitempty"`
	// Unschedulable controls node schedulability of new pods. By default, node is schedulable.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
	// +optional
	Unschedulable *bool `protobuf:"varint,4,opt,name=unschedulable" json:"unschedulable,omitempty"`
	// If specified, the node's taints.
	// +optional
	Taints []*Taint `protobuf:"bytes,5,rep,name=taints" json:"taints,omitempty"`
	// If specified, the source to get node configuration from
	// The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field
	// +optional
	ConfigSource     *NodeConfigSource `protobuf:"bytes,6,opt,name=configSource" json:"configSource,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *NodeSpec) Reset()                    { *m = NodeSpec{} }
func (m *NodeSpec) String() string            { return proto.CompactTextString(m) }
func (*NodeSpec) ProtoMessage()               {}
func (*NodeSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{93} }

func (m *NodeSpec) GetPodCIDR() string {
	if m != nil && m.PodCIDR != nil {
		return *m.PodCIDR
	}
	return ""
}

func (m *NodeSpec) GetExternalID() string {
	if m != nil && m.ExternalID != nil {
		return *m.ExternalID
	}
	return ""
}

func (m *NodeSpec) GetProviderID() string {
	if m != nil && m.ProviderID != nil {
		return *m.ProviderID
	}
	return ""
}

func (m *NodeSpec) GetUnschedulable() bool {
	if m != nil && m.Unschedulable != nil {
		return *m.Unschedulable
	}
	return false
}

func (m *NodeSpec) GetTaints() []*Taint {
	if m != nil {
		return m.Taints
	}
	return nil
}

func (m *NodeSpec) GetConfigSource() *NodeConfigSource {
	if m != nil {
		return m.ConfigSource
	}
	return nil
}

// NodeStatus is information about the current status of a node.
type NodeStatus struct {
	// Capacity represents the total resources of a node.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
	// +optional
	Capacity map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,1,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Allocatable represents the resources of a node that are available for scheduling.
	// Defaults to Capacity.
	// +optional
	Allocatable map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,2,rep,name=allocatable" json:"allocatable,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// NodePhase is the recently observed lifecycle phase of the node.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#phase
	// The field is never populated, and now is deprecated.
	// +optional
	Phase *string `protobuf:"bytes,3,opt,name=phase" json:"phase,omitempty"`
	// Conditions is an array of current observed node conditions.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*NodeCondition `protobuf:"bytes,4,rep,name=conditions" json:"conditions,omitempty"`
	// List of addresses reachable to the node.
	// Queried from cloud provider, if available.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Addresses []*NodeAddress `protobuf:"bytes,5,rep,name=addresses" json:"addresses,omitempty"`
	// Endpoints of daemons running on the Node.
	// +optional
	DaemonEndpoints *NodeDaemonEndpoints `protobuf:"bytes,6,opt,name=daemonEndpoints" json:"daemonEndpoints,omitempty"`
	// Set of ids/uuids to uniquely identify the node.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#info
	// +optional
	NodeInfo *NodeSystemInfo `protobuf:"bytes,7,opt,name=nodeInfo" json:"nodeInfo,omitempty"`
	// List of container images on this node
	// +optional
	Images []*ContainerImage `protobuf:"bytes,8,rep,name=images" json:"images,omitempty"`
	// List of attachable volumes in use (mounted) by the node.
	// +optional
	VolumesInUse []string `protobuf:"bytes,9,rep,name=volumesInUse" json:"volumesInUse,omitempty"`
	// List of volumes that are attached to the node.
	// +optional
	VolumesAttached  []*AttachedVolume `protobuf:"bytes,10,rep,name=volumesAttached" json:"volumesAttached,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *NodeStatus) Reset()                    { *m = NodeStatus{} }
func (m *NodeStatus) String() string            { return proto.CompactTextString(m) }
func (*NodeStatus) ProtoMessage()               {}
func (*NodeStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{94} }

func (m *NodeStatus) GetCapacity() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *NodeStatus) GetAllocatable() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Allocatable
	}
	return nil
}

func (m *NodeStatus) GetPhase() string {
	if m != nil && m.Phase != nil {
		return *m.Phase
	}
	return ""
}

func (m *NodeStatus) GetConditions() []*NodeCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *NodeStatus) GetAddresses() []*NodeAddress {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *NodeStatus) GetDaemonEndpoints() *NodeDaemonEndpoints {
	if m != nil {
		return m.DaemonEndpoints
	}
	return nil
}

func (m *NodeStatus) GetNodeInfo() *NodeSystemInfo {
	if m != nil {
		return m.NodeInfo
	}
	return nil
}

func (m *NodeStatus) GetImages() []*ContainerImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *NodeStatus) GetVolumesInUse() []string {
	if m != nil {
		return m.VolumesInUse
	}
	return nil
}

func (m *NodeStatus) GetVolumesAttached() []*AttachedVolume {
	if m != nil {
		return m.VolumesAttached
	}
	return nil
}

// NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
type NodeSystemInfo struct {
	// MachineID reported by the node. For unique machine identification
	// in the cluster this field is preferred. Learn more from man(5)
	// machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
	MachineID *string `protobuf:"bytes,1,opt,name=machineID" json:"machineID,omitempty"`
	// SystemUUID reported by the node. For unique machine identification
	// MachineID is preferred. This field is specific to Red Hat hosts
	// https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html
	SystemUUID *string `protobuf:"bytes,2,opt,name=systemUUID" json:"systemUUID,omitempty"`
	// Boot ID reported by the node.
	BootID *string `protobuf:"bytes,3,opt,name=bootID" json:"bootID,omitempty"`
	// Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
	KernelVersion *string `protobuf:"bytes,4,opt,name=kernelVersion" json:"kernelVersion,omitempty"`
	// OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
	OsImage *string `protobuf:"bytes,5,opt,name=osImage" json:"osImage,omitempty"`
	// ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).
	ContainerRuntimeVersion *string `protobuf:"bytes,6,opt,name=containerRuntimeVersion" json:"containerRuntimeVersion,omitempty"`
	// Kubelet Version reported by the node.
	KubeletVersion *string `protobuf:"bytes,7,opt,name=kubeletVersion" json:"kubeletVersion,omitempty"`
	// KubeProxy Version reported by the node.
	KubeProxyVersion *string `protobuf:"bytes,8,opt,name=kubeProxyVersion" json:"kubeProxyVersion,omitempty"`
	// The Operating System reported by the node
	OperatingSystem *string `protobuf:"bytes,9,opt,name=operatingSystem" json:"operatingSystem,omitempty"`
	// The Architecture reported by the node
	Architecture     *string `protobuf:"bytes,10,opt,name=architecture" json:"architecture,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NodeSystemInfo) Reset()                    { *m = NodeSystemInfo{} }
func (m *NodeSystemInfo) String() string            { return proto.CompactTextString(m) }
func (*NodeSystemInfo) ProtoMessage()               {}
func (*NodeSystemInfo) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{95} }

func (m *NodeSystemInfo) GetMachineID() string {
	if m != nil && m.MachineID != nil {
		return *m.MachineID
	}
	return ""
}

func (m *NodeSystemInfo) GetSystemUUID() string {
	if m != nil && m.SystemUUID != nil {
		return *m.SystemUUID
	}
	return ""
}

func (m *NodeSystemInfo) GetBootID() string {
	if m != nil && m.BootID != nil {
		return *m.BootID
	}
	return ""
}

func (m *NodeSystemInfo) GetKernelVersion() string {
	if m != nil && m.KernelVersion != nil {
		return *m.KernelVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetOsImage() string {
	if m != nil && m.OsImage != nil {
		return *m.OsImage
	}
	return ""
}

func (m *NodeSystemInfo) GetContainerRuntimeVersion() string {
	if m != nil && m.ContainerRuntimeVersion != nil {
		return *m.ContainerRuntimeVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetKubeletVersion() string {
	if m != nil && m.KubeletVersion != nil {
		return *m.KubeletVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetKubeProxyVersion() string {
	if m != nil && m.KubeProxyVersion != nil {
		return *m.KubeProxyVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetOperatingSystem() string {
	if m != nil && m.OperatingSystem != nil {
		return *m.OperatingSystem
	}
	return ""
}

func (m *NodeSystemInfo) GetArchitecture() string {
	if m != nil && m.Architecture != nil {
		return *m.Architecture
	}
	return ""
}

// ObjectFieldSelector selects an APIVersioned field of an object.
type ObjectFieldSelector struct {
	// Version of the schema the FieldPath is written in terms of, defaults to "v1".
	// +optional
	ApiVersion *string `protobuf:"bytes,1,opt,name=apiVersion" json:"apiVersion,omitempty"`
	// Path of the field to select in the specified API version.
	FieldPath        *string `protobuf:"bytes,2,opt,name=fieldPath" json:"fieldPath,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ObjectFieldSelector) Reset()                    { *m = ObjectFieldSelector{} }
func (m *ObjectFieldSelector) String() string            { return proto.CompactTextString(m) }
func (*ObjectFieldSelector) ProtoMessage()               {}
func (*ObjectFieldSelector) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{96} }

func (m *ObjectFieldSelector) GetApiVersion() string {
	if m != nil && m.ApiVersion != nil {
		return *m.ApiVersion
	}
	return ""
}

func (m *ObjectFieldSelector) GetFieldPath() string {
	if m != nil && m.FieldPath != nil {
		return *m.FieldPath
	}
	return ""
}

// ObjectMeta is metadata that all persisted resources must have, which includes all objects
// users must create.
// DEPRECATED: Use k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta instead - this type will be removed soon.
// +k8s:openapi-gen=false
type ObjectMeta struct {
	// Name must be unique within a namespace. Is required when creating resources, although
	// some resources may allow a client to request the generation of an appropriate name
	// automatically. Name is primarily intended for creation idempotence and configuration
	// definition.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	// +optional
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// GenerateName is an optional prefix, used by the server, to generate a unique
	// name ONLY IF the Name field has not been provided.
	// If this field is used, the name returned to the client will be different
	// than the name passed. This value will also be combined with a unique suffix.
	// The provided value has the same validation rules as the Name field,
	// and may be truncated by the length of the suffix required to make the value
	// unique on the server.
	//
	// If this field is specified and the generated name exists, the server will
	// NOT return a 409 - instead, it will either return 201 Created or 500 with Reason
	// ServerTimeout indicating a unique name could not be found in the time allotted, and the client
	// should retry (optionally after the time indicated in the Retry-After header).
	//
	// Applied only if Name is not specified.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency
	// +optional
	GenerateName *string `protobuf:"bytes,2,opt,name=generateName" json:"generateName,omitempty"`
	// Namespace defines the space within each name must be unique. An empty namespace is
	// equivalent to the "default" namespace, but "default" is the canonical representation.
	// Not all objects are required to be scoped to a namespace - the value of this field for
	// those objects will be empty.
	//
	// Must be a DNS_LABEL.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	// +optional
	Namespace *string `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	// SelfLink is a URL representing this object.
	// Populated by the system.
	// Read-only.
	// +optional
	SelfLink *string `protobuf:"bytes,4,opt,name=selfLink" json:"selfLink,omitempty"`
	// UID is the unique in time and space value for this object. It is typically generated by
	// the server on successful creation of a resource and is not allowed to change on PUT
	// operations.
	//
	// Populated by the system.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
	// +optional
	Uid *string `protobuf:"bytes,5,opt,name=uid" json:"uid,omitempty"`
	// An opaque value that represents the internal version of this object that can
	// be used by clients to determine when objects have changed. May be used for optimistic
	// concurrency, change detection, and the watch operation on a resource or set of resources.
	// Clients must treat these values as opaque and passed unmodified back to the server.
	// They may only be valid for a particular resource or set of resources.
	//
	// Populated by the system.
	// Read-only.
	// Value must be treated as opaque by clients and .
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
	// +optional
	ResourceVersion *string `protobuf:"bytes,6,opt,name=resourceVersion" json:"resourceVersion,omitempty"`
	// A sequence number representing a specific generation of the desired state.
	// Populated by the system. Read-only.
	// +optional
	Generation *int64 `protobuf:"varint,7,opt,name=generation" json:"generation,omitempty"`
	// CreationTimestamp is a timestamp representing the server time when this object was
	// created. It is not guaranteed to be set in happens-before order across separate operations.
	// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
	//
	// Populated by the system.
	// Read-only.
	// Null for lists.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	CreationTimestamp *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,8,opt,name=creationTimestamp" json:"creationTimestamp,omitempty"`
	// DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This
	// field is set by the server when a graceful deletion is requested by the user, and is not
	// directly settable by a client. The resource is expected to be deleted (no longer visible
	// from resource lists, and not reachable by name) after the time in this field. Once set,
	// this value may not be unset or be set further into the future, although it may be shortened
	// or the resource may be deleted prior to this time. For example, a user may request that
	// a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination
	// signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard
	// termination signal (SIGKILL) to the container and after cleanup, remove the pod from the
	// API. In the presence of network partitions, this object may still exist after this
	// timestamp, until an administrator or automated process can determine the resource is
	// fully terminated.
	// If not set, graceful deletion of the object has not been requested.
	//
	// Populated by the system when a graceful deletion is requested.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	DeletionTimestamp *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,9,opt,name=deletionTimestamp" json:"deletionTimestamp,omitempty"`
	// Number of seconds allowed for this object to gracefully terminate before
	// it will be removed from the system. Only set when deletionTimestamp is also set.
	// May only be shortened.
	// Read-only.
	// +optional
	DeletionGracePeriodSeconds *int64 `protobuf:"varint,10,opt,name=deletionGracePeriodSeconds" json:"deletionGracePeriodSeconds,omitempty"`
	// Map of string keys and values that can be used to organize and categorize
	// (scope and select) objects. May match selectors of replication controllers
	// and services.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	// +optional
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map stored with a resource that may be
	// set by external tools to store and retrieve arbitrary metadata. They are not
	// queryable and should be preserved when modifying objects.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	// +optional
	Annotations map[string]string `protobuf:"bytes,12,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// List of objects depended by this object. If ALL objects in the list have
	// been deleted, this object will be garbage collected. If this object is managed by a controller,
	// then an entry in this list will point to this controller, with the controller field set to true.
	// There cannot be more than one managing controller.
	// +optional
	// +patchMergeKey=uid
	// +patchStrategy=merge
	OwnerReferences []*k8s_io_apimachinery_pkg_apis_meta_v1.OwnerReference `protobuf:"bytes,13,rep,name=ownerReferences" json:"ownerReferences,omitempty"`
	// An initializer is a controller which enforces some system invariant at object creation time.
	// This field is a list of initializers that have not yet acted on this object. If nil or empty,
	// this object has been completely initialized. Otherwise, the object is considered uninitialized
	// and is hidden (in list/watch and get calls) from clients that haven't explicitly asked to
	// observe uninitialized objects.
	//
	// When an object is created, the system will populate this list with the current set of initializers.
	// Only privileged users may set or modify this list. Once it is empty, it may not be modified further
	// by any user.
	Initializers *k8s_io_apimachinery_pkg_apis_meta_v1.Initializers `protobuf:"bytes,16,opt,name=initializers" json:"initializers,omitempty"`
	// Must be empty before the object is deleted from the registry. Each entry
	// is an identifier for the responsible component that will remove the entry
	// from the list. If the deletionTimestamp of the object is non-nil, entries
	// in this list can only be removed.
	// +optional
	// +patchStrategy=merge
	Finalizers []string `protobuf:"bytes,14,rep,name=finalizers" json:"finalizers,omitempty"`
	// The name of the cluster which the object belongs to.
	// This is used to distinguish resources with same name and namespace in different clusters.
	// This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
	// +optional
	ClusterName      *string `protobuf:"bytes,15,opt,name=clusterName" json:"clusterName,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ObjectMeta) Reset()                    { *m = ObjectMeta{} }
func (m *ObjectMeta) String() string            { return proto.CompactTextString(m) }
func (*ObjectMeta) ProtoMessage()               {}
func (*ObjectMeta) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{97} }

func (m *ObjectMeta) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ObjectMeta) GetGenerateName() string {
	if m != nil && m.GenerateName != nil {
		return *m.GenerateName
	}
	return ""
}

func (m *ObjectMeta) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ObjectMeta) GetSelfLink() string {
	if m != nil && m.SelfLink != nil {
		return *m.SelfLink
	}
	return ""
}

func (m *ObjectMeta) GetUid() string {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return ""
}

func (m *ObjectMeta) GetResourceVersion() string {
	if m != nil && m.ResourceVersion != nil {
		return *m.ResourceVersion
	}
	return ""
}

func (m *ObjectMeta) GetGeneration() int64 {
	if m != nil && m.Generation != nil {
		return *m.Generation
	}
	return 0
}

func (m *ObjectMeta) GetCreationTimestamp() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.CreationTimestamp
	}
	return nil
}

func (m *ObjectMeta) GetDeletionTimestamp() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.DeletionTimestamp
	}
	return nil
}

func (m *ObjectMeta) GetDeletionGracePeriodSeconds() int64 {
	if m != nil && m.DeletionGracePeriodSeconds != nil {
		return *m.DeletionGracePeriodSeconds
	}
	return 0
}

func (m *ObjectMeta) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ObjectMeta) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ObjectMeta) GetOwnerReferences() []*k8s_io_apimachinery_pkg_apis_meta_v1.OwnerReference {
	if m != nil {
		return m.OwnerReferences
	}
	return nil
}

func (m *ObjectMeta) GetInitializers() *k8s_io_apimachinery_pkg_apis_meta_v1.Initializers {
	if m != nil {
		return m.Initializers
	}
	return nil
}

func (m *ObjectMeta) GetFinalizers() []string {
	if m != nil {
		return m.Finalizers
	}
	return nil
}

func (m *ObjectMeta) GetClusterName() string {
	if m != nil && m.ClusterName != nil {
		return *m.ClusterName
	}
	return ""
}

// ObjectReference contains enough information to let you inspect or modify the referred object.
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
type ObjectReference struct {
	// Kind of the referent.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Kind *string `protobuf:"bytes,1,opt,name=kind" json:"kind,omitempty"`
	// Namespace of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	// +optional
	Namespace *string `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	// Name of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	// +optional
	Name *string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// UID of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
	// +optional
	Uid *string `protobuf:"bytes,4,opt,name=uid" json:"uid,omitempty"`
	// API version of the referent.
	// +optional
	ApiVersion *string `protobuf:"bytes,5,opt,name=apiVersion" json:"apiVersion,omitempty"`
	// Specific resourceVersion to which this reference is made, if any.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
	// +optional
	ResourceVersion *string `protobuf:"bytes,6,opt,name=resourceVersion" json:"resourceVersion,omitempty"`
	// If referring to a piece of an object instead of an entire object, this string
	// should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2].
	// For example, if the object reference is to a container within a pod, this would take on a value like:
	// "spec.containers{name}" (where "name" refers to the name of the container that triggered
	// the event) or if no container name is specified "spec.containers[2]" (container with
	// index 2 in this pod). This syntax is chosen only to have some well-defined way of
	// referencing a part of an object.
	// TODO: this design is not final and this field is subject to change in the future.
	// +optional
	FieldPath        *string `protobuf:"bytes,7,opt,name=fieldPath" json:"fieldPath,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ObjectReference) Reset()                    { *m = ObjectReference{} }
func (m *ObjectReference) String() string            { return proto.CompactTextString(m) }
func (*ObjectReference) ProtoMessage()               {}
func (*ObjectReference) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{98} }

func (m *ObjectReference) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ObjectReference) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ObjectReference) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ObjectReference) GetUid() string {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return ""
}

func (m *ObjectReference) GetApiVersion() string {
	if m != nil && m.ApiVersion != nil {
		return *m.ApiVersion
	}
	return ""
}

func (m *ObjectReference) GetResourceVersion() string {
	if m != nil && m.ResourceVersion != nil {
		return *m.ResourceVersion
	}
	return ""
}

func (m *ObjectReference) GetFieldPath() string {
	if m != nil && m.FieldPath != nil {
		return *m.FieldPath
	}
	return ""
}

// PersistentVolume (PV) is a storage resource provisioned by an administrator.
// It is analogous to a node.
// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
type PersistentVolume struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines a specification of a persistent volume owned by the cluster.
	// Provisioned by an administrator.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
	// +optional
	Spec *PersistentVolumeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status represents the current information/status for the persistent volume.
	// Populated by the system.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
	// +optional
	Status           *PersistentVolumeStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *PersistentVolume) Reset()                    { *m = PersistentVolume{} }
func (m *PersistentVolume) String() string            { return proto.CompactTextString(m) }
func (*PersistentVolume) ProtoMessage()               {}
func (*PersistentVolume) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{99} }

func (m *PersistentVolume) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolume) GetSpec() *PersistentVolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PersistentVolume) GetStatus() *PersistentVolumeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PersistentVolumeClaim is a user's request for and claim to a persistent volume
type PersistentVolumeClaim struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the desired characteristics of a volume requested by a pod author.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	Spec *PersistentVolumeClaimSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status represents the current information/status of a persistent volume claim.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	Status           *PersistentVolumeClaimStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte                       `json:"-"`
}

func (m *PersistentVolumeClaim) Reset()                    { *m = PersistentVolumeClaim{} }
func (m *PersistentVolumeClaim) String() string            { return proto.CompactTextString(m) }
func (*PersistentVolumeClaim) ProtoMessage()               {}
func (*PersistentVolumeClaim) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{100} }

func (m *PersistentVolumeClaim) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeClaim) GetSpec() *PersistentVolumeClaimSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PersistentVolumeClaim) GetStatus() *PersistentVolumeClaimStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PersistentVolumeClaimCondition contails details about state of pvc
type PersistentVolumeClaimCondition struct {
	Type   *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Status *string `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// Last time we probed the condition.
	// +optional
	LastProbeTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,3,opt,name=lastProbeTime" json:"lastProbeTime,omitempty"`
	// Last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,4,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// Unique, this should be a short, machine understandable string that gives the reason
	// for condition's last transition. If it reports "ResizeStarted" that means the underlying
	// persistent volume is being resized.
	// +optional
	Reason *string `protobuf:"bytes,5,opt,name=reason" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	// +optional
	Message          *string `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PersistentVolumeClaimCondition) Reset()         { *m = PersistentVolumeClaimCondition{} }
func (m *PersistentVolumeClaimCondition) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimCondition) ProtoMessage()    {}
func (*PersistentVolumeClaimCondition) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{101}
}

func (m *PersistentVolumeClaimCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetStatus() string {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetLastProbeTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastProbeTime
	}
	return nil
}

func (m *PersistentVolumeClaimCondition) GetLastTransitionTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *PersistentVolumeClaimCondition) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
type PersistentVolumeClaimList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// A list of persistent volume claims.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	Items            []*PersistentVolumeClaim `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *PersistentVolumeClaimList) Reset()         { *m = PersistentVolumeClaimList{} }
func (m *PersistentVolumeClaimList) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimList) ProtoMessage()    {}
func (*PersistentVolumeClaimList) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{102}
}

func (m *PersistentVolumeClaimList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeClaimList) GetItems() []*PersistentVolumeClaim {
	if m != nil {
		return m.Items
	}
	return nil
}

// PersistentVolumeClaimSpec describes the common attributes of storage devices
// and allows a Source for provider-specific attributes
type PersistentVolumeClaimSpec struct {
	// AccessModes contains the desired access modes the volume should have.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
	// +optional
	AccessModes []string `protobuf:"bytes,1,rep,name=accessModes" json:"accessModes,omitempty"`
	// A label query over volumes to consider for binding.
	// +optional
	Selector *k8s_io_apimachinery_pkg_apis_meta_v1.LabelSelector `protobuf:"bytes,4,opt,name=selector" json:"selector,omitempty"`
	// Resources represents the minimum resources the volume should have.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
	// +optional
	Resources *ResourceRequirements `protobuf:"bytes,2,opt,name=resources" json:"resources,omitempty"`
	// VolumeName is the binding reference to the PersistentVolume backing this claim.
	// +optional
	VolumeName *string `protobuf:"bytes,3,opt,name=volumeName" json:"volumeName,omitempty"`
	// Name of the StorageClass required by the claim.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
	// +optional
	StorageClassName *string `protobuf:"bytes,5,opt,name=storageClassName" json:"storageClassName,omitempty"`
	// volumeMode defines what type of volume is required by the claim.
	// Value of Filesystem is implied when not included in claim spec.
	// This is an alpha feature and may change in the future.
	// +optional
	VolumeMode       *string `protobuf:"bytes,6,opt,name=volumeMode" json:"volumeMode,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PersistentVolumeClaimSpec) Reset()         { *m = PersistentVolumeClaimSpec{} }
func (m *PersistentVolumeClaimSpec) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimSpec) ProtoMessage()    {}
func (*PersistentVolumeClaimSpec) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{103}
}

func (m *PersistentVolumeClaimSpec) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetSelector() *k8s_io_apimachinery_pkg_apis_meta_v1.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetVolumeName() string {
	if m != nil && m.VolumeName != nil {
		return *m.VolumeName
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetStorageClassName() string {
	if m != nil && m.StorageClassName != nil {
		return *m.StorageClassName
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetVolumeMode() string {
	if m != nil && m.VolumeMode != nil {
		return *m.VolumeMode
	}
	return ""
}

// PersistentVolumeClaimStatus is the current status of a persistent volume claim.
type PersistentVolumeClaimStatus struct {
	// Phase represents the current phase of PersistentVolumeClaim.
	// +optional
	Phase *string `protobuf:"bytes,1,opt,name=phase" json:"phase,omitempty"`
	// AccessModes contains the actual access modes the volume backing the PVC has.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
	// +optional
	AccessModes []string `protobuf:"bytes,2,rep,name=accessModes" json:"accessModes,omitempty"`
	// Represents the actual resources of the underlying volume.
	// +optional
	Capacity map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,3,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Current Condition of persistent volume claim. If underlying persistent volume is being
	// resized then the Condition will be set to 'ResizeStarted'.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions       []*PersistentVolumeClaimCondition `protobuf:"bytes,4,rep,name=conditions" json:"conditions,omitempty"`
	XXX_unrecognized []byte                            `json:"-"`
}

func (m *PersistentVolumeClaimStatus) Reset()         { *m = PersistentVolumeClaimStatus{} }
func (m *PersistentVolumeClaimStatus) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimStatus) ProtoMessage()    {}
func (*PersistentVolumeClaimStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{104}
}

func (m *PersistentVolumeClaimStatus) GetPhase() string {
	if m != nil && m.Phase != nil {
		return *m.Phase
	}
	return ""
}

func (m *PersistentVolumeClaimStatus) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeClaimStatus) GetCapacity() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *PersistentVolumeClaimStatus) GetConditions() []*PersistentVolumeClaimCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace.
// This volume finds the bound PV and mounts that volume for the pod. A
// PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another
// type of volume that is owned by someone else (the system).
type PersistentVolumeClaimVolumeSource struct {
	// ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	ClaimName *string `protobuf:"bytes,1,opt,name=claimName" json:"claimName,omitempty"`
	// Will force the ReadOnly setting in VolumeMounts.
	// Default false.
	// +optional
	ReadOnly         *bool  `protobuf:"varint,2,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PersistentVolumeClaimVolumeSource) Reset()         { *m = PersistentVolumeClaimVolumeSource{} }
func (m *PersistentVolumeClaimVolumeSource) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeClaimVolumeSource) ProtoMessage()    {}
func (*PersistentVolumeClaimVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{105}
}

func (m *PersistentVolumeClaimVolumeSource) GetClaimName() string {
	if m != nil && m.ClaimName != nil {
		return *m.ClaimName
	}
	return ""
}

func (m *PersistentVolumeClaimVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// PersistentVolumeList is a list of PersistentVolume items.
type PersistentVolumeList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of persistent volumes.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
	Items            []*PersistentVolume `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *PersistentVolumeList) Reset()                    { *m = PersistentVolumeList{} }
func (m *PersistentVolumeList) String() string            { return proto.CompactTextString(m) }
func (*PersistentVolumeList) ProtoMessage()               {}
func (*PersistentVolumeList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{106} }

func (m *PersistentVolumeList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeList) GetItems() []*PersistentVolume {
	if m != nil {
		return m.Items
	}
	return nil
}

// PersistentVolumeSource is similar to VolumeSource but meant for the
// administrator who creates PVs. Exactly one of its members must be set.
type PersistentVolumeSource struct {
	// GCEPersistentDisk represents a GCE Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod. Provisioned by an admin.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	GcePersistentDisk *GCEPersistentDiskVolumeSource `protobuf:"bytes,1,opt,name=gcePersistentDisk" json:"gcePersistentDisk,omitempty"`
	// AWSElasticBlockStore represents an AWS Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// +optional
	AwsElasticBlockStore *AWSElasticBlockStoreVolumeSource `protobuf:"bytes,2,opt,name=awsElasticBlockStore" json:"awsElasticBlockStore,omitempty"`
	// HostPath represents a directory on the host.
	// Provisioned by a developer or tester.
	// This is useful for single-node development and testing only!
	// On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	// +optional
	HostPath *HostPathVolumeSource `protobuf:"bytes,3,opt,name=hostPath" json:"hostPath,omitempty"`
	// Glusterfs represents a Glusterfs volume that is attached to a host and
	// exposed to the pod. Provisioned by an admin.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md
	// +optional
	Glusterfs *GlusterfsVolumeSource `protobuf:"bytes,4,opt,name=glusterfs" json:"glusterfs,omitempty"`
	// NFS represents an NFS mount on the host. Provisioned by an admin.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	// +optional
	Nfs *NFSVolumeSource `protobuf:"bytes,5,opt,name=nfs" json:"nfs,omitempty"`
	// RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md
	// +optional
	Rbd *RBDPersistentVolumeSource `protobuf:"bytes,6,opt,name=rbd" json:"rbd,omitempty"`
	// ISCSI represents an ISCSI Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod. Provisioned by an admin.
	// +optional
	Iscsi *ISCSIPersistentVolumeSource `protobuf:"bytes,7,opt,name=iscsi" json:"iscsi,omitempty"`
	// Cinder represents a cinder volume attached and mounted on kubelets host machine
	// More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
	// +optional
	Cinder *CinderVolumeSource `protobuf:"bytes,8,opt,name=cinder" json:"cinder,omitempty"`
	// CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
	// +optional
	Cephfs *CephFSPersistentVolumeSource `protobuf:"bytes,9,opt,name=cephfs" json:"cephfs,omitempty"`
	// FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
	// +optional
	Fc *FCVolumeSource `protobuf:"bytes,10,opt,name=fc" json:"fc,omitempty"`
	// Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
	// +optional
	Flocker *FlockerVolumeSource `protobuf:"bytes,11,opt,name=flocker" json:"flocker,omitempty"`
	// FlexVolume represents a generic volume resource that is
	// provisioned/attached using an exec based plugin.
	// +optional
	FlexVolume *FlexPersistentVolumeSource `protobuf:"bytes,12,opt,name=flexVolume" json:"flexVolume,omitempty"`
	// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
	// +optional
	AzureFile *AzureFilePersistentVolumeSource `protobuf:"bytes,13,opt,name=azureFile" json:"azureFile,omitempty"`
	// VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
	// +optional
	VsphereVolume *VsphereVirtualDiskVolumeSource `protobuf:"bytes,14,opt,name=vsphereVolume" json:"vsphereVolume,omitempty"`
	// Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
	// +optional
	Quobyte *QuobyteVolumeSource `protobuf:"bytes,15,opt,name=quobyte" json:"quobyte,omitempty"`
	// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
	// +optional
	AzureDisk *AzureDiskVolumeSource `protobuf:"bytes,16,opt,name=azureDisk" json:"azureDisk,omitempty"`
	// PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
	PhotonPersistentDisk *PhotonPersistentDiskVolumeSource `protobuf:"bytes,17,opt,name=photonPersistentDisk" json:"photonPersistentDisk,omitempty"`
	// PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
	// +optional
	PortworxVolume *PortworxVolumeSource `protobuf:"bytes,18,opt,name=portworxVolume" json:"portworxVolume,omitempty"`
	// ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
	// +optional
	ScaleIO *ScaleIOPersistentVolumeSource `protobuf:"bytes,19,opt,name=scaleIO" json:"scaleIO,omitempty"`
	// Local represents directly-attached storage with node affinity
	// +optional
	Local *LocalVolumeSource `protobuf:"bytes,20,opt,name=local" json:"local,omitempty"`
	// StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod
	// More info: https://releases.k8s.io/HEAD/examples/volumes/storageos/README.md
	// +optional
	Storageos *StorageOSPersistentVolumeSource `protobuf:"bytes,21,opt,name=storageos" json:"storageos,omitempty"`
	// CSI represents storage that handled by an external CSI driver (Beta feature).
	// +optional
	Csi              *CSIPersistentVolumeSource `protobuf:"bytes,22,opt,name=csi" json:"csi,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *PersistentVolumeSource) Reset()         { *m = PersistentVolumeSource{} }
func (m *PersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeSource) ProtoMessage()    {}
func (*PersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{107}
}

func (m *PersistentVolumeSource) GetGcePersistentDisk() *GCEPersistentDiskVolumeSource {
	if m != nil {
		return m.GcePersistentDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetAwsElasticBlockStore() *AWSElasticBlockStoreVolumeSource {
	if m != nil {
		return m.AwsElasticBlockStore
	}
	return nil
}

func (m *PersistentVolumeSource) GetHostPath() *HostPathVolumeSource {
	if m != nil {
		return m.HostPath
	}
	return nil
}

func (m *PersistentVolumeSource) GetGlusterfs() *GlusterfsVolumeSource {
	if m != nil {
		return m.Glusterfs
	}
	return nil
}

func (m *PersistentVolumeSource) GetNfs() *NFSVolumeSource {
	if m != nil {
		return m.Nfs
	}
	return nil
}

func (m *PersistentVolumeSource) GetRbd() *RBDPersistentVolumeSource {
	if m != nil {
		return m.Rbd
	}
	return nil
}

func (m *PersistentVolumeSource) GetIscsi() *ISCSIPersistentVolumeSource {
	if m != nil {
		return m.Iscsi
	}
	return nil
}

func (m *PersistentVolumeSource) GetCinder() *CinderVolumeSource {
	if m != nil {
		return m.Cinder
	}
	return nil
}

func (m *PersistentVolumeSource) GetCephfs() *CephFSPersistentVolumeSource {
	if m != nil {
		return m.Cephfs
	}
	return nil
}

func (m *PersistentVolumeSource) GetFc() *FCVolumeSource {
	if m != nil {
		return m.Fc
	}
	return nil
}

func (m *PersistentVolumeSource) GetFlocker() *FlockerVolumeSource {
	if m != nil {
		return m.Flocker
	}
	return nil
}

func (m *PersistentVolumeSource) GetFlexVolume() *FlexPersistentVolumeSource {
	if m != nil {
		return m.FlexVolume
	}
	return nil
}

func (m *PersistentVolumeSource) GetAzureFile() *AzureFilePersistentVolumeSource {
	if m != nil {
		return m.AzureFile
	}
	return nil
}

func (m *PersistentVolumeSource) GetVsphereVolume() *VsphereVirtualDiskVolumeSource {
	if m != nil {
		return m.VsphereVolume
	}
	return nil
}

func (m *PersistentVolumeSource) GetQuobyte() *QuobyteVolumeSource {
	if m != nil {
		return m.Quobyte
	}
	return nil
}

func (m *PersistentVolumeSource) GetAzureDisk() *AzureDiskVolumeSource {
	if m != nil {
		return m.AzureDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetPhotonPersistentDisk() *PhotonPersistentDiskVolumeSource {
	if m != nil {
		return m.PhotonPersistentDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetPortworxVolume() *PortworxVolumeSource {
	if m != nil {
		return m.PortworxVolume
	}
	return nil
}

func (m *PersistentVolumeSource) GetScaleIO() *ScaleIOPersistentVolumeSource {
	if m != nil {
		return m.ScaleIO
	}
	return nil
}

func (m *PersistentVolumeSource) GetLocal() *LocalVolumeSource {
	if m != nil {
		return m.Local
	}
	return nil
}

func (m *PersistentVolumeSource) GetStorageos() *StorageOSPersistentVolumeSource {
	if m != nil {
		return m.Storageos
	}
	return nil
}

func (m *PersistentVolumeSource) GetCsi() *CSIPersistentVolumeSource {
	if m != nil {
		return m.Csi
	}
	return nil
}

// PersistentVolumeSpec is the specification of a persistent volume.
type PersistentVolumeSpec struct {
	// A description of the persistent volume's resources and capacity.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
	// +optional
	Capacity map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,1,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The actual volume backing the persistent volume.
	PersistentVolumeSource *PersistentVolumeSource `protobuf:"bytes,2,opt,name=persistentVolumeSource" json:"persistentVolumeSource,omitempty"`
	// AccessModes contains all ways the volume can be mounted.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
	// +optional
	AccessModes []string `protobuf:"bytes,3,rep,name=accessModes" json:"accessModes,omitempty"`
	// ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
	// Expected to be non-nil when bound.
	// claim.VolumeName is the authoritative bind between PV and PVC.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
	// +optional
	ClaimRef *ObjectReference `protobuf:"bytes,4,opt,name=claimRef" json:"claimRef,omitempty"`
	// What happens to a persistent volume when released from its claim.
	// Valid options are Retain (default for manually created PersistentVolumes), Delete (default
	// for dynamically provisioned PersistentVolumes), and Recycle (deprecated).
	// Recycle must be supported by the volume plugin underlying this PersistentVolume.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
	// +optional
	PersistentVolumeReclaimPolicy *string `protobuf:"bytes,5,opt,name=persistentVolumeReclaimPolicy" json:"persistentVolumeReclaimPolicy,omitempty"`
	// Name of StorageClass to which this persistent volume belongs. Empty value
	// means that this volume does not belong to any StorageClass.
	// +optional
	StorageClassName *string `protobuf:"bytes,6,opt,name=storageClassName" json:"storageClassName,omitempty"`
	// A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will
	// simply fail if one is invalid.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
	// +optional
	MountOptions []string `protobuf:"bytes,7,rep,name=mountOptions" json:"mountOptions,omitempty"`
	// volumeMode defines if a volume is intended to be used with a formatted filesystem
	// or to remain in raw block state. Value of Filesystem is implied when not included in spec.
	// This is an alpha feature and may change in the future.
	// +optional
	VolumeMode *string `protobuf:"bytes,8,opt,name=volumeMode" json:"volumeMode,omitempty"`
	// NodeAffinity defines constraints that limit what nodes this volume can be accessed from.
	// This field influences the scheduling of pods that use this volume.
	// +optional
	NodeAffinity     *VolumeNodeAffinity `protobuf:"bytes,9,opt,name=nodeAffinity" json:"nodeAffinity,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *PersistentVolumeSpec) Reset()                    { *m = PersistentVolumeSpec{} }
func (m *PersistentVolumeSpec) String() string            { return proto.CompactTextString(m) }
func (*PersistentVolumeSpec) ProtoMessage()               {}
func (*PersistentVolumeSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{108} }

func (m *PersistentVolumeSpec) GetCapacity() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeSource() *PersistentVolumeSource {
	if m != nil {
		return m.PersistentVolumeSource
	}
	return nil
}

func (m *PersistentVolumeSpec) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeSpec) GetClaimRef() *ObjectReference {
	if m != nil {
		return m.ClaimRef
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeReclaimPolicy() string {
	if m != nil && m.PersistentVolumeReclaimPolicy != nil {
		return *m.PersistentVolumeReclaimPolicy
	}
	return ""
}

func (m *PersistentVolumeSpec) GetStorageClassName() string {
	if m != nil && m.StorageClassName != nil {
		return *m.StorageClassName
	}
	return ""
}

func (m *PersistentVolumeSpec) GetMountOptions() []string {
	if m != nil {
		return m.MountOptions
	}
	return nil
}

func (m *PersistentVolumeSpec) GetVolumeMode() string {
	if m != nil && m.VolumeMode != nil {
		return *m.VolumeMode
	}
	return ""
}

func (m *PersistentVolumeSpec) GetNodeAffinity() *VolumeNodeAffinity {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

// PersistentVolumeStatus is the current status of a persistent volume.
type PersistentVolumeStatus struct {
	// Phase indicates if a volume is available, bound to a claim, or released by a claim.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
	// +optional
	Phase *string `protobuf:"bytes,1,opt,name=phase" json:"phase,omitempty"`
	// A human-readable message indicating details about why the volume is in this state.
	// +optional
	Message *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	// Reason is a brief CamelCase string that describes any failure and is meant
	// for machine parsing and tidy display in the CLI.
	// +optional
	Reason           *string `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PersistentVolumeStatus) Reset()         { *m = PersistentVolumeStatus{} }
func (m *PersistentVolumeStatus) String() string { return proto.CompactTextString(m) }
func (*PersistentVolumeStatus) ProtoMessage()    {}
func (*PersistentVolumeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{109}
}

func (m *PersistentVolumeStatus) GetPhase() string {
	if m != nil && m.Phase != nil {
		return *m.Phase
	}
	return ""
}

func (m *PersistentVolumeStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *PersistentVolumeStatus) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

// Represents a Photon Controller persistent disk resource.
type PhotonPersistentDiskVolumeSource struct {
	// ID that identifies Photon Controller persistent disk
	PdID *string `protobuf:"bytes,1,opt,name=pdID" json:"pdID,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	FsType           *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PhotonPersistentDiskVolumeSource) Reset()         { *m = PhotonPersistentDiskVolumeSource{} }
func (m *PhotonPersistentDiskVolumeSource) String() string { return proto.CompactTextString(m) }
func (*PhotonPersistentDiskVolumeSource) ProtoMessage()    {}
func (*PhotonPersistentDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{110}
}

func (m *PhotonPersistentDiskVolumeSource) GetPdID() string {
	if m != nil && m.PdID != nil {
		return *m.PdID
	}
	return ""
}

func (m *PhotonPersistentDiskVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

// Pod is a collection of containers that can run on a host. This resource is created
// by clients and scheduled onto hosts.
type Pod struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Specification of the desired behavior of the pod.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *PodSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Most recently observed status of the pod.
	// This data may not be up to date.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *PodStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *Pod) Reset()                    { *m = Pod{} }
func (m *Pod) String() string            { return proto.CompactTextString(m) }
func (*Pod) ProtoMessage()               {}
func (*Pod) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{111} }

func (m *Pod) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Pod) GetSpec() *PodSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Pod) GetStatus() *PodStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Pod affinity is a group of inter pod affinity scheduling rules.
type PodAffinity struct {
	// If the affinity requirements specified by this field are not met at
	// scheduling time, the pod will not be scheduled onto the node.
	// If the affinity requirements specified by this field cease to be met
	// at some point during pod execution (e.g. due to a pod label update), the
	// system may or may not try to eventually evict the pod from its node.
	// When there are multiple elements, the lists of nodes corresponding to each
	// podAffinityTerm are intersected, i.e. all terms must be satisfied.
	// +optional
	RequiredDuringSchedulingIgnoredDuringExecution []*PodAffinityTerm `protobuf:"bytes,1,rep,name=requiredDuringSchedulingIgnoredDuringExecution" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	// The scheduler will prefer to schedule pods to nodes that satisfy
	// the affinity expressions specified by this field, but it may choose
	// a node that violates one or more of the expressions. The node that is
	// most preferred is the one with the greatest sum of weights, i.e.
	// for each node that meets all of the scheduling requirements (resource
	// request, requiredDuringScheduling affinity expressions, etc.),
	// compute a sum by iterating through the elements of this field and adding
	// "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
	// node(s) with the highest sum are the most preferred.
	// +optional
	PreferredDuringSchedulingIgnoredDuringExecution []*WeightedPodAffinityTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
	XXX_unrecognized                                []byte                     `json:"-"`
}

func (m *PodAffinity) Reset()                    { *m = PodAffinity{} }
func (m *PodAffinity) String() string            { return proto.CompactTextString(m) }
func (*PodAffinity) ProtoMessage()               {}
func (*PodAffinity) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{112} }

func (m *PodAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() []*PodAffinityTerm {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *PodAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*WeightedPodAffinityTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// Defines a set of pods (namely those matching the labelSelector
// relative to the given namespace(s)) that this pod should be
// co-located (affinity) or not co-located (anti-affinity) with,
// where co-located is defined as running on a node whose value of
// the label with key <topologyKey> matches that of any node on which
// a pod of the set of pods is running
type PodAffinityTerm struct {
	// A label query over a set of resources, in this case pods.
	// +optional
	LabelSelector *k8s_io_apimachinery_pkg_apis_meta_v1.LabelSelector `protobuf:"bytes,1,opt,name=labelSelector" json:"labelSelector,omitempty"`
	// namespaces specifies which namespaces the labelSelector applies to (matches against);
	// null or empty list means "this pod's namespace"
	// +optional
	Namespaces []string `protobuf:"bytes,2,rep,name=namespaces" json:"namespaces,omitempty"`
	// This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
	// the labelSelector in the specified namespaces, where co-located is defined as running on a node
	// whose value of the label with key topologyKey matches that of any node on which any of the
	// selected pods is running.
	// Empty topologyKey is not allowed.
	TopologyKey      *string `protobuf:"bytes,3,opt,name=topologyKey" json:"topologyKey,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodAffinityTerm) Reset()                    { *m = PodAffinityTerm{} }
func (m *PodAffinityTerm) String() string            { return proto.CompactTextString(m) }
func (*PodAffinityTerm) ProtoMessage()               {}
func (*PodAffinityTerm) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{113} }

func (m *PodAffinityTerm) GetLabelSelector() *k8s_io_apimachinery_pkg_apis_meta_v1.LabelSelector {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

func (m *PodAffinityTerm) GetNamespaces() []string {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *PodAffinityTerm) GetTopologyKey() string {
	if m != nil && m.TopologyKey != nil {
		return *m.TopologyKey
	}
	return ""
}

// Pod anti affinity is a group of inter pod anti affinity scheduling rules.
type PodAntiAffinity struct {
	// If the anti-affinity requirements specified by this field are not met at
	// scheduling time, the pod will not be scheduled onto the node.
	// If the anti-affinity requirements specified by this field cease to be met
	// at some point during pod execution (e.g. due to a pod label update), the
	// system may or may not try to eventually evict the pod from its node.
	// When there are multiple elements, the lists of nodes corresponding to each
	// podAffinityTerm are intersected, i.e. all terms must be satisfied.
	// +optional
	RequiredDuringSchedulingIgnoredDuringExecution []*PodAffinityTerm `protobuf:"bytes,1,rep,name=requiredDuringSchedulingIgnoredDuringExecution" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	// The scheduler will prefer to schedule pods to nodes that satisfy
	// the anti-affinity expressions specified by this field, but it may choose
	// a node that violates one or more of the expressions. The node that is
	// most preferred is the one with the greatest sum of weights, i.e.
	// for each node that meets all of the scheduling requirements (resource
	// request, requiredDuringScheduling anti-affinity expressions, etc.),
	// compute a sum by iterating through the elements of this field and adding
	// "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
	// node(s) with the highest sum are the most preferred.
	// +optional
	PreferredDuringSchedulingIgnoredDuringExecution []*WeightedPodAffinityTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
	XXX_unrecognized                                []byte                     `json:"-"`
}

func (m *PodAntiAffinity) Reset()                    { *m = PodAntiAffinity{} }
func (m *PodAntiAffinity) String() string            { return proto.CompactTextString(m) }
func (*PodAntiAffinity) ProtoMessage()               {}
func (*PodAntiAffinity) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{114} }

func (m *PodAntiAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() []*PodAffinityTerm {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *PodAntiAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*WeightedPodAffinityTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// PodAttachOptions is the query options to a Pod's remote attach call.
// ---
// TODO: merge w/ PodExecOptions below for stdin, stdout, etc
// and also when we cut V2, we should export a "StreamOptions" or somesuch that contains Stdin, Stdout, Stder and TTY
type PodAttachOptions struct {
	// Stdin if true, redirects the standard input stream of the pod for this call.
	// Defaults to false.
	// +optional
	Stdin *bool `protobuf:"varint,1,opt,name=stdin" json:"stdin,omitempty"`
	// Stdout if true indicates that stdout is to be redirected for the attach call.
	// Defaults to true.
	// +optional
	Stdout *bool `protobuf:"varint,2,opt,name=stdout" json:"stdout,omitempty"`
	// Stderr if true indicates that stderr is to be redirected for the attach call.
	// Defaults to true.
	// +optional
	Stderr *bool `protobuf:"varint,3,opt,name=stderr" json:"stderr,omitempty"`
	// TTY if true indicates that a tty will be allocated for the attach call.
	// This is passed through the container runtime so the tty
	// is allocated on the worker node by the container runtime.
	// Defaults to false.
	// +optional
	Tty *bool `protobuf:"varint,4,opt,name=tty" json:"tty,omitempty"`
	// The container in which to execute the command.
	// Defaults to only container if there is only one container in the pod.
	// +optional
	Container        *string `protobuf:"bytes,5,opt,name=container" json:"container,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodAttachOptions) Reset()                    { *m = PodAttachOptions{} }
func (m *PodAttachOptions) String() string            { return proto.CompactTextString(m) }
func (*PodAttachOptions) ProtoMessage()               {}
func (*PodAttachOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{115} }

func (m *PodAttachOptions) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

func (m *PodAttachOptions) GetStdout() bool {
	if m != nil && m.Stdout != nil {
		return *m.Stdout
	}
	return false
}

func (m *PodAttachOptions) GetStderr() bool {
	if m != nil && m.Stderr != nil {
		return *m.Stderr
	}
	return false
}

func (m *PodAttachOptions) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

func (m *PodAttachOptions) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

// PodCondition contains details for the current condition of this pod.
type PodCondition struct {
	// Type is the type of the condition.
	// Currently only Ready.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Status is the status of the condition.
	// Can be True, False, Unknown.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
	Status *string `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// Last time we probed the condition.
	// +optional
	LastProbeTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,3,opt,name=lastProbeTime" json:"lastProbeTime,omitempty"`
	// Last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,4,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// Unique, one-word, CamelCase reason for the condition's last transition.
	// +optional
	Reason *string `protobuf:"bytes,5,opt,name=reason" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	// +optional
	Message          *string `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodCondition) Reset()                    { *m = PodCondition{} }
func (m *PodCondition) String() string            { return proto.CompactTextString(m) }
func (*PodCondition) ProtoMessage()               {}
func (*PodCondition) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{116} }

func (m *PodCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *PodCondition) GetStatus() string {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ""
}

func (m *PodCondition) GetLastProbeTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastProbeTime
	}
	return nil
}

func (m *PodCondition) GetLastTransitionTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *PodCondition) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *PodCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// PodDNSConfig defines the DNS parameters of a pod in addition to
// those generated from DNSPolicy.
type PodDNSConfig struct {
	// A list of DNS name server IP addresses.
	// This will be appended to the base nameservers generated from DNSPolicy.
	// Duplicated nameservers will be removed.
	// +optional
	Nameservers []string `protobuf:"bytes,1,rep,name=nameservers" json:"nameservers,omitempty"`
	// A list of DNS search domains for host-name lookup.
	// This will be appended to the base search paths generated from DNSPolicy.
	// Duplicated search paths will be removed.
	// +optional
	Searches []string `protobuf:"bytes,2,rep,name=searches" json:"searches,omitempty"`
	// A list of DNS resolver options.
	// This will be merged with the base options generated from DNSPolicy.
	// Duplicated entries will be removed. Resolution options given in Options
	// will override those that appear in the base DNSPolicy.
	// +optional
	Options          []*PodDNSConfigOption `protobuf:"bytes,3,rep,name=options" json:"options,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *PodDNSConfig) Reset()                    { *m = PodDNSConfig{} }
func (m *PodDNSConfig) String() string            { return proto.CompactTextString(m) }
func (*PodDNSConfig) ProtoMessage()               {}
func (*PodDNSConfig) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{117} }

func (m *PodDNSConfig) GetNameservers() []string {
	if m != nil {
		return m.Nameservers
	}
	return nil
}

func (m *PodDNSConfig) GetSearches() []string {
	if m != nil {
		return m.Searches
	}
	return nil
}

func (m *PodDNSConfig) GetOptions() []*PodDNSConfigOption {
	if m != nil {
		return m.Options
	}
	return nil
}

// PodDNSConfigOption defines DNS resolver options of a pod.
type PodDNSConfigOption struct {
	// Required.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// +optional
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodDNSConfigOption) Reset()                    { *m = PodDNSConfigOption{} }
func (m *PodDNSConfigOption) String() string            { return proto.CompactTextString(m) }
func (*PodDNSConfigOption) ProtoMessage()               {}
func (*PodDNSConfigOption) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{118} }

func (m *PodDNSConfigOption) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PodDNSConfigOption) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// PodExecOptions is the query options to a Pod's remote exec call.
// ---
// TODO: This is largely identical to PodAttachOptions above, make sure they stay in sync and see about merging
// and also when we cut V2, we should export a "StreamOptions" or somesuch that contains Stdin, Stdout, Stder and TTY
type PodExecOptions struct {
	// Redirect the standard input stream of the pod for this call.
	// Defaults to false.
	// +optional
	Stdin *bool `protobuf:"varint,1,opt,name=stdin" json:"stdin,omitempty"`
	// Redirect the standard output stream of the pod for this call.
	// Defaults to true.
	// +optional
	Stdout *bool `protobuf:"varint,2,opt,name=stdout" json:"stdout,omitempty"`
	// Redirect the standard error stream of the pod for this call.
	// Defaults to true.
	// +optional
	Stderr *bool `protobuf:"varint,3,opt,name=stderr" json:"stderr,omitempty"`
	// TTY if true indicates that a tty will be allocated for the exec call.
	// Defaults to false.
	// +optional
	Tty *bool `protobuf:"varint,4,opt,name=tty" json:"tty,omitempty"`
	// Container in which to execute the command.
	// Defaults to only container if there is only one container in the pod.
	// +optional
	Container *string `protobuf:"bytes,5,opt,name=container" json:"container,omitempty"`
	// Command is the remote command to execute. argv array. Not executed within a shell.
	Command          []string `protobuf:"bytes,6,rep,name=command" json:"command,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *PodExecOptions) Reset()                    { *m = PodExecOptions{} }
func (m *PodExecOptions) String() string            { return proto.CompactTextString(m) }
func (*PodExecOptions) ProtoMessage()               {}
func (*PodExecOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{119} }

func (m *PodExecOptions) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

func (m *PodExecOptions) GetStdout() bool {
	if m != nil && m.Stdout != nil {
		return *m.Stdout
	}
	return false
}

func (m *PodExecOptions) GetStderr() bool {
	if m != nil && m.Stderr != nil {
		return *m.Stderr
	}
	return false
}

func (m *PodExecOptions) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

func (m *PodExecOptions) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

func (m *PodExecOptions) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// PodList is a list of Pods.
type PodList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of pods.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md
	Items            []*Pod `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PodList) Reset()                    { *m = PodList{} }
func (m *PodList) String() string            { return proto.CompactTextString(m) }
func (*PodList) ProtoMessage()               {}
func (*PodList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{120} }

func (m *PodList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodList) GetItems() []*Pod {
	if m != nil {
		return m.Items
	}
	return nil
}

// PodLogOptions is the query options for a Pod's logs REST call.
type PodLogOptions struct {
	// The container for which to stream logs. Defaults to only container if there is one container in the pod.
	// +optional
	Container *string `protobuf:"bytes,1,opt,name=container" json:"container,omitempty"`
	// Follow the log stream of the pod. Defaults to false.
	// +optional
	Follow *bool `protobuf:"varint,2,opt,name=follow" json:"follow,omitempty"`
	// Return previous terminated container logs. Defaults to false.
	// +optional
	Previous *bool `protobuf:"varint,3,opt,name=previous" json:"previous,omitempty"`
	// A relative time in seconds before the current time from which to show logs. If this value
	// precedes the time a pod was started, only logs since the pod start will be returned.
	// If this value is in the future, no logs will be returned.
	// Only one of sinceSeconds or sinceTime may be specified.
	// +optional
	SinceSeconds *int64 `protobuf:"varint,4,opt,name=sinceSeconds" json:"sinceSeconds,omitempty"`
	// An RFC3339 timestamp from which to show logs. If this value
	// precedes the time a pod was started, only logs since the pod start will be returned.
	// If this value is in the future, no logs will be returned.
	// Only one of sinceSeconds or sinceTime may be specified.
	// +optional
	SinceTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,5,opt,name=sinceTime" json:"sinceTime,omitempty"`
	// If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line
	// of log output. Defaults to false.
	// +optional
	Timestamps *bool `protobuf:"varint,6,opt,name=timestamps" json:"timestamps,omitempty"`
	// If set, the number of lines from the end of the logs to show. If not specified,
	// logs are shown from the creation of the container or sinceSeconds or sinceTime
	// +optional
	TailLines *int64 `protobuf:"varint,7,opt,name=tailLines" json:"tailLines,omitempty"`
	// If set, the number of bytes to read from the server before terminating the
	// log output. This may not display a complete final line of logging, and may return
	// slightly more or slightly less than the specified limit.
	// +optional
	LimitBytes       *int64 `protobuf:"varint,8,opt,name=limitBytes" json:"limitBytes,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PodLogOptions) Reset()                    { *m = PodLogOptions{} }
func (m *PodLogOptions) String() string            { return proto.CompactTextString(m) }
func (*PodLogOptions) ProtoMessage()               {}
func (*PodLogOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{121} }

func (m *PodLogOptions) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

func (m *PodLogOptions) GetFollow() bool {
	if m != nil && m.Follow != nil {
		return *m.Follow
	}
	return false
}

func (m *PodLogOptions) GetPrevious() bool {
	if m != nil && m.Previous != nil {
		return *m.Previous
	}
	return false
}

func (m *PodLogOptions) GetSinceSeconds() int64 {
	if m != nil && m.SinceSeconds != nil {
		return *m.SinceSeconds
	}
	return 0
}

func (m *PodLogOptions) GetSinceTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.SinceTime
	}
	return nil
}

func (m *PodLogOptions) GetTimestamps() bool {
	if m != nil && m.Timestamps != nil {
		return *m.Timestamps
	}
	return false
}

func (m *PodLogOptions) GetTailLines() int64 {
	if m != nil && m.TailLines != nil {
		return *m.TailLines
	}
	return 0
}

func (m *PodLogOptions) GetLimitBytes() int64 {
	if m != nil && m.LimitBytes != nil {
		return *m.LimitBytes
	}
	return 0
}

// PodPortForwardOptions is the query options to a Pod's port forward call
// when using WebSockets.
// The `port` query parameter must specify the port or
// ports (comma separated) to forward over.
// Port forwarding over SPDY does not use these options. It requires the port
// to be passed in the `port` header as part of request.
type PodPortForwardOptions struct {
	// List of ports to forward
	// Required when using WebSockets
	// +optional
	Ports            []int32 `protobuf:"varint,1,rep,name=ports" json:"ports,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodPortForwardOptions) Reset()                    { *m = PodPortForwardOptions{} }
func (m *PodPortForwardOptions) String() string            { return proto.CompactTextString(m) }
func (*PodPortForwardOptions) ProtoMessage()               {}
func (*PodPortForwardOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{122} }

func (m *PodPortForwardOptions) GetPorts() []int32 {
	if m != nil {
		return m.Ports
	}
	return nil
}

// PodProxyOptions is the query options to a Pod's proxy call.
type PodProxyOptions struct {
	// Path is the URL path to use for the current proxy request to pod.
	// +optional
	Path             *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodProxyOptions) Reset()                    { *m = PodProxyOptions{} }
func (m *PodProxyOptions) String() string            { return proto.CompactTextString(m) }
func (*PodProxyOptions) ProtoMessage()               {}
func (*PodProxyOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{123} }

func (m *PodProxyOptions) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

// PodSecurityContext holds pod-level security attributes and common container settings.
// Some fields are also present in container.securityContext.  Field values of
// container.securityContext take precedence over field values of PodSecurityContext.
type PodSecurityContext struct {
	// The SELinux context to be applied to all containers.
	// If unspecified, the container runtime will allocate a random SELinux context for each
	// container.  May also be set in SecurityContext.  If set in
	// both SecurityContext and PodSecurityContext, the value specified in SecurityContext
	// takes precedence for that container.
	// +optional
	SeLinuxOptions *SELinuxOptions `protobuf:"bytes,1,opt,name=seLinuxOptions" json:"seLinuxOptions,omitempty"`
	// The UID to run the entrypoint of the container process.
	// Defaults to user specified in image metadata if unspecified.
	// May also be set in SecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence
	// for that container.
	// +optional
	RunAsUser *int64 `protobuf:"varint,2,opt,name=runAsUser" json:"runAsUser,omitempty"`
	// The GID to run the entrypoint of the container process.
	// Uses runtime default if unset.
	// May also be set in SecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence
	// for that container.
	// +optional
	RunAsGroup *int64 `protobuf:"varint,6,opt,name=runAsGroup" json:"runAsGroup,omitempty"`
	// Indicates that the container must run as a non-root user.
	// If true, the Kubelet will validate the image at runtime to ensure that it
	// does not run as UID 0 (root) and fail to start the container if it does.
	// If unset or false, no such validation will be performed.
	// May also be set in SecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsNonRoot *bool `protobuf:"varint,3,opt,name=runAsNonRoot" json:"runAsNonRoot,omitempty"`
	// A list of groups applied to the first process run in each container, in addition
	// to the container's primary GID.  If unspecified, no groups will be added to
	// any container.
	// +optional
	SupplementalGroups []int64 `protobuf:"varint,4,rep,name=supplementalGroups" json:"supplementalGroups,omitempty"`
	// A special supplemental group that applies to all containers in a pod.
	// Some volume types allow the Kubelet to change the ownership of that volume
	// to be owned by the pod:
	//
	// 1. The owning GID will be the FSGroup
	// 2. The setgid bit is set (new files created in the volume will be owned by FSGroup)
	// 3. The permission bits are OR'd with rw-rw----
	//
	// If unset, the Kubelet will not modify the ownership and permissions of any volume.
	// +optional
	FsGroup          *int64 `protobuf:"varint,5,opt,name=fsGroup" json:"fsGroup,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PodSecurityContext) Reset()                    { *m = PodSecurityContext{} }
func (m *PodSecurityContext) String() string            { return proto.CompactTextString(m) }
func (*PodSecurityContext) ProtoMessage()               {}
func (*PodSecurityContext) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{124} }

func (m *PodSecurityContext) GetSeLinuxOptions() *SELinuxOptions {
	if m != nil {
		return m.SeLinuxOptions
	}
	return nil
}

func (m *PodSecurityContext) GetRunAsUser() int64 {
	if m != nil && m.RunAsUser != nil {
		return *m.RunAsUser
	}
	return 0
}

func (m *PodSecurityContext) GetRunAsGroup() int64 {
	if m != nil && m.RunAsGroup != nil {
		return *m.RunAsGroup
	}
	return 0
}

func (m *PodSecurityContext) GetRunAsNonRoot() bool {
	if m != nil && m.RunAsNonRoot != nil {
		return *m.RunAsNonRoot
	}
	return false
}

func (m *PodSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

func (m *PodSecurityContext) GetFsGroup() int64 {
	if m != nil && m.FsGroup != nil {
		return *m.FsGroup
	}
	return 0
}

// Describes the class of pods that should avoid this node.
// Exactly one field should be set.
type PodSignature struct {
	// Reference to controller whose pods should avoid this node.
	// +optional
	PodController    *k8s_io_apimachinery_pkg_apis_meta_v1.OwnerReference `protobuf:"bytes,1,opt,name=podController" json:"podController,omitempty"`
	XXX_unrecognized []byte                                               `json:"-"`
}

func (m *PodSignature) Reset()                    { *m = PodSignature{} }
func (m *PodSignature) String() string            { return proto.CompactTextString(m) }
func (*PodSignature) ProtoMessage()               {}
func (*PodSignature) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{125} }

func (m *PodSignature) GetPodController() *k8s_io_apimachinery_pkg_apis_meta_v1.OwnerReference {
	if m != nil {
		return m.PodController
	}
	return nil
}

// PodSpec is a description of a pod.
type PodSpec struct {
	// List of volumes that can be mounted by containers belonging to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge,retainKeys
	Volumes []*Volume `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
	// List of initialization containers belonging to the pod.
	// Init containers are executed in order prior to containers being started. If any
	// init container fails, the pod is considered to have failed and is handled according
	// to its restartPolicy. The name for an init container or normal container must be
	// unique among all containers.
	// Init containers may not have Lifecycle actions, Readiness probes, or Liveness probes.
	// The resourceRequirements of an init container are taken into account during scheduling
	// by finding the highest request/limit for each resource type, and then using the max of
	// of that value or the sum of the normal containers. Limits are applied to init containers
	// in a similar fashion.
	// Init containers cannot currently be added or removed.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
	// +patchMergeKey=name
	// +patchStrategy=merge
	InitContainers []*Container `protobuf:"bytes,20,rep,name=initContainers" json:"initContainers,omitempty"`
	// List of containers belonging to the pod.
	// Containers cannot currently be added or removed.
	// There must be at least one container in a Pod.
	// Cannot be updated.
	// +patchMergeKey=name
	// +patchStrategy=merge
	Containers []*Container `protobuf:"bytes,2,rep,name=containers" json:"containers,omitempty"`
	// Restart policy for all containers within the pod.
	// One of Always, OnFailure, Never.
	// Default to Always.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
	// +optional
	RestartPolicy *string `protobuf:"bytes,3,opt,name=restartPolicy" json:"restartPolicy,omitempty"`
	// Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request.
	// Value must be non-negative integer. The value zero indicates delete immediately.
	// If this value is nil, the default grace period will be used instead.
	// The grace period is the duration in seconds after the processes running in the pod are sent
	// a termination signal and the time when the processes are forcibly halted with a kill signal.
	// Set this value longer than the expected cleanup time for your process.
	// Defaults to 30 seconds.
	// +optional
	TerminationGracePeriodSeconds *int64 `protobuf:"varint,4,opt,name=terminationGracePeriodSeconds" json:"terminationGracePeriodSeconds,omitempty"`
	// Optional duration in seconds the pod may be active on the node relative to
	// StartTime before the system will actively try to mark it failed and kill associated containers.
	// Value must be a positive integer.
	// +optional
	ActiveDeadlineSeconds *int64 `protobuf:"varint,5,opt,name=activeDeadlineSeconds" json:"activeDeadlineSeconds,omitempty"`
	// Set DNS policy for the pod.
	// Defaults to "ClusterFirst".
	// Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.
	// DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.
	// To have DNS options set along with hostNetwork, you have to specify DNS policy
	// explicitly to 'ClusterFirstWithHostNet'.
	// +optional
	DnsPolicy *string `protobuf:"bytes,6,opt,name=dnsPolicy" json:"dnsPolicy,omitempty"`
	// NodeSelector is a selector which must be true for the pod to fit on a node.
	// Selector which must match a node's labels for the pod to be scheduled on that node.
	// More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
	// +optional
	NodeSelector map[string]string `protobuf:"bytes,7,rep,name=nodeSelector" json:"nodeSelector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ServiceAccountName is the name of the ServiceAccount to use to run this pod.
	// More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
	// +optional
	ServiceAccountName *string `protobuf:"bytes,8,opt,name=serviceAccountName" json:"serviceAccountName,omitempty"`
	// DeprecatedServiceAccount is a depreciated alias for ServiceAccountName.
	// Deprecated: Use serviceAccountName instead.
	// +k8s:conversion-gen=false
	// +optional
	ServiceAccount *string `protobuf:"bytes,9,opt,name=serviceAccount" json:"serviceAccount,omitempty"`
	// AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
	// +optional
	AutomountServiceAccountToken *bool `protobuf:"varint,21,opt,name=automountServiceAccountToken" json:"automountServiceAccountToken,omitempty"`
	// NodeName is a request to schedule this pod onto a specific node. If it is non-empty,
	// the scheduler simply schedules this pod onto that node, assuming that it fits resource
	// requirements.
	// +optional
	NodeName *string `protobuf:"bytes,10,opt,name=nodeName" json:"nodeName,omitempty"`
	// Host networking requested for this pod. Use the host's network namespace.
	// If this option is set, the ports that will be used must be specified.
	// Default to false.
	// +k8s:conversion-gen=false
	// +optional
	HostNetwork *bool `protobuf:"varint,11,opt,name=hostNetwork" json:"hostNetwork,omitempty"`
	// Use the host's pid namespace.
	// Optional: Default to false.
	// +k8s:conversion-gen=false
	// +optional
	HostPID *bool `protobuf:"varint,12,opt,name=hostPID" json:"hostPID,omitempty"`
	// Use the host's ipc namespace.
	// Optional: Default to false.
	// +k8s:conversion-gen=false
	// +optional
	HostIPC *bool `protobuf:"varint,13,opt,name=hostIPC" json:"hostIPC,omitempty"`
	// Share a single process namespace between all of the containers in a pod.
	// When this is set containers will be able to view and signal processes from other containers
	// in the same pod, and the first process in each container will not be assigned PID 1.
	// HostPID and ShareProcessNamespace cannot both be set.
	// Optional: Default to false.
	// This field is alpha-level and is honored only by servers that enable the PodShareProcessNamespace feature.
	// +k8s:conversion-gen=false
	// +optional
	ShareProcessNamespace *bool `protobuf:"varint,27,opt,name=shareProcessNamespace" json:"shareProcessNamespace,omitempty"`
	// SecurityContext holds pod-level security attributes and common container settings.
	// Optional: Defaults to empty.  See type description for default values of each field.
	// +optional
	SecurityContext *PodSecurityContext `protobuf:"bytes,14,opt,name=securityContext" json:"securityContext,omitempty"`
	// ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec.
	// If specified, these secrets will be passed to individual puller implementations for them to use. For example,
	// in the case of docker, only DockerConfig type secrets are honored.
	// More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	ImagePullSecrets []*LocalObjectReference `protobuf:"bytes,15,rep,name=imagePullSecrets" json:"imagePullSecrets,omitempty"`
	// Specifies the hostname of the Pod
	// If not specified, the pod's hostname will be set to a system-defined value.
	// +optional
	Hostname *string `protobuf:"bytes,16,opt,name=hostname" json:"hostname,omitempty"`
	// If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
	// If not specified, the pod will not have a domainname at all.
	// +optional
	Subdomain *string `protobuf:"bytes,17,opt,name=subdomain" json:"subdomain,omitempty"`
	// If specified, the pod's scheduling constraints
	// +optional
	Affinity *Affinity `protobuf:"bytes,18,opt,name=affinity" json:"affinity,omitempty"`
	// If specified, the pod will be dispatched by specified scheduler.
	// If not specified, the pod will be dispatched by default scheduler.
	// +optional
	SchedulerName *string `protobuf:"bytes,19,opt,name=schedulerName" json:"schedulerName,omitempty"`
	// If specified, the pod's tolerations.
	// +optional
	Tolerations []*Toleration `protobuf:"bytes,22,rep,name=tolerations" json:"tolerations,omitempty"`
	// HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts
	// file if specified. This is only valid for non-hostNetwork pods.
	// +optional
	// +patchMergeKey=ip
	// +patchStrategy=merge
	HostAliases []*HostAlias `protobuf:"bytes,23,rep,name=hostAliases" json:"hostAliases,omitempty"`
	// If specified, indicates the pod's priority. "system-node-critical" and
	// "system-cluster-critical" are two special keywords which indicate the
	// highest priorities with the former being the highest priority. Any other
	// name must be defined by creating a PriorityClass object with that name.
	// If not specified, the pod priority will be default or zero if there is no
	// default.
	// +optional
	PriorityClassName *string `protobuf:"bytes,24,opt,name=priorityClassName" json:"priorityClassName,omitempty"`
	// The priority value. Various system components use this field to find the
	// priority of the pod. When Priority Admission Controller is enabled, it
	// prevents users from setting this field. The admission controller populates
	// this field from PriorityClassName.
	// The higher the value, the higher the priority.
	// +optional
	Priority *int32 `protobuf:"varint,25,opt,name=priority" json:"priority,omitempty"`
	// Specifies the DNS parameters of a pod.
	// Parameters specified here will be merged to the generated DNS
	// configuration based on DNSPolicy.
	// +optional
	DnsConfig        *PodDNSConfig `protobuf:"bytes,26,opt,name=dnsConfig" json:"dnsConfig,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *PodSpec) Reset()                    { *m = PodSpec{} }
func (m *PodSpec) String() string            { return proto.CompactTextString(m) }
func (*PodSpec) ProtoMessage()               {}
func (*PodSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{126} }

func (m *PodSpec) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *PodSpec) GetInitContainers() []*Container {
	if m != nil {
		return m.InitContainers
	}
	return nil
}

func (m *PodSpec) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *PodSpec) GetRestartPolicy() string {
	if m != nil && m.RestartPolicy != nil {
		return *m.RestartPolicy
	}
	return ""
}

func (m *PodSpec) GetTerminationGracePeriodSeconds() int64 {
	if m != nil && m.TerminationGracePeriodSeconds != nil {
		return *m.TerminationGracePeriodSeconds
	}
	return 0
}

func (m *PodSpec) GetActiveDeadlineSeconds() int64 {
	if m != nil && m.ActiveDeadlineSeconds != nil {
		return *m.ActiveDeadlineSeconds
	}
	return 0
}

func (m *PodSpec) GetDnsPolicy() string {
	if m != nil && m.DnsPolicy != nil {
		return *m.DnsPolicy
	}
	return ""
}

func (m *PodSpec) GetNodeSelector() map[string]string {
	if m != nil {
		return m.NodeSelector
	}
	return nil
}

func (m *PodSpec) GetServiceAccountName() string {
	if m != nil && m.ServiceAccountName != nil {
		return *m.ServiceAccountName
	}
	return ""
}

func (m *PodSpec) GetServiceAccount() string {
	if m != nil && m.ServiceAccount != nil {
		return *m.ServiceAccount
	}
	return ""
}

func (m *PodSpec) GetAutomountServiceAccountToken() bool {
	if m != nil && m.AutomountServiceAccountToken != nil {
		return *m.AutomountServiceAccountToken
	}
	return false
}

func (m *PodSpec) GetNodeName() string {
	if m != nil && m.NodeName != nil {
		return *m.NodeName
	}
	return ""
}

func (m *PodSpec) GetHostNetwork() bool {
	if m != nil && m.HostNetwork != nil {
		return *m.HostNetwork
	}
	return false
}

func (m *PodSpec) GetHostPID() bool {
	if m != nil && m.HostPID != nil {
		return *m.HostPID
	}
	return false
}

func (m *PodSpec) GetHostIPC() bool {
	if m != nil && m.HostIPC != nil {
		return *m.HostIPC
	}
	return false
}

func (m *PodSpec) GetShareProcessNamespace() bool {
	if m != nil && m.ShareProcessNamespace != nil {
		return *m.ShareProcessNamespace
	}
	return false
}

func (m *PodSpec) GetSecurityContext() *PodSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *PodSpec) GetImagePullSecrets() []*LocalObjectReference {
	if m != nil {
		return m.ImagePullSecrets
	}
	return nil
}

func (m *PodSpec) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *PodSpec) GetSubdomain() string {
	if m != nil && m.Subdomain != nil {
		return *m.Subdomain
	}
	return ""
}

func (m *PodSpec) GetAffinity() *Affinity {
	if m != nil {
		return m.Affinity
	}
	return nil
}

func (m *PodSpec) GetSchedulerName() string {
	if m != nil && m.SchedulerName != nil {
		return *m.SchedulerName
	}
	return ""
}

func (m *PodSpec) GetTolerations() []*Toleration {
	if m != nil {
		return m.Tolerations
	}
	return nil
}

func (m *PodSpec) GetHostAliases() []*HostAlias {
	if m != nil {
		return m.HostAliases
	}
	return nil
}

func (m *PodSpec) GetPriorityClassName() string {
	if m != nil && m.PriorityClassName != nil {
		return *m.PriorityClassName
	}
	return ""
}

func (m *PodSpec) GetPriority() int32 {
	if m != nil && m.Priority != nil {
		return *m.Priority
	}
	return 0
}

func (m *PodSpec) GetDnsConfig() *PodDNSConfig {
	if m != nil {
		return m.DnsConfig
	}
	return nil
}

// PodStatus represents information about the status of a pod. Status may trail the actual
// state of a system.
type PodStatus struct {
	// Current condition of the pod.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
	// +optional
	Phase *string `protobuf:"bytes,1,opt,name=phase" json:"phase,omitempty"`
	// Current service state of pod.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*PodCondition `protobuf:"bytes,2,rep,name=conditions" json:"conditions,omitempty"`
	// A human readable message indicating details about why the pod is in this condition.
	// +optional
	Message *string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// A brief CamelCase message indicating details about why the pod is in this state.
	// e.g. 'Evicted'
	// +optional
	Reason *string `protobuf:"bytes,4,opt,name=reason" json:"reason,omitempty"`
	// nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be
	// scheduled right away as preemption victims receive their graceful termination periods.
	// This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide
	// to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to
	// give the resources on this node to a higher priority pod that is created after preemption.
	// As a result, this field may be different than PodSpec.nodeName when the pod is
	// scheduled.
	// +optional
	NominatedNodeName *string `protobuf:"bytes,11,opt,name=nominatedNodeName" json:"nominatedNodeName,omitempty"`
	// IP address of the host to which the pod is assigned. Empty if not yet scheduled.
	// +optional
	HostIP *string `protobuf:"bytes,5,opt,name=hostIP" json:"hostIP,omitempty"`
	// IP address allocated to the pod. Routable at least within the cluster.
	// Empty if not yet allocated.
	// +optional
	PodIP *string `protobuf:"bytes,6,opt,name=podIP" json:"podIP,omitempty"`
	// RFC 3339 date and time at which the object was acknowledged by the Kubelet.
	// This is before the Kubelet pulled the container image(s) for the pod.
	// +optional
	StartTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,7,opt,name=startTime" json:"startTime,omitempty"`
	// The list has one entry per init container in the manifest. The most recent successful
	// init container will have ready = true, the most recently started container will have
	// startTime set.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
	InitContainerStatuses []*ContainerStatus `protobuf:"bytes,10,rep,name=initContainerStatuses" json:"initContainerStatuses,omitempty"`
	// The list has one entry per container in the manifest. Each entry is currently the output
	// of `docker inspect`.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
	// +optional
	ContainerStatuses []*ContainerStatus `protobuf:"bytes,8,rep,name=containerStatuses" json:"containerStatuses,omitempty"`
	// The Quality of Service (QOS) classification assigned to the pod based on resource requirements
	// See PodQOSClass type for available QOS classes
	// More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
	// +optional
	QosClass         *string `protobuf:"bytes,9,opt,name=qosClass" json:"qosClass,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodStatus) Reset()                    { *m = PodStatus{} }
func (m *PodStatus) String() string            { return proto.CompactTextString(m) }
func (*PodStatus) ProtoMessage()               {}
func (*PodStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{127} }

func (m *PodStatus) GetPhase() string {
	if m != nil && m.Phase != nil {
		return *m.Phase
	}
	return ""
}

func (m *PodStatus) GetConditions() []*PodCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *PodStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *PodStatus) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *PodStatus) GetNominatedNodeName() string {
	if m != nil && m.NominatedNodeName != nil {
		return *m.NominatedNodeName
	}
	return ""
}

func (m *PodStatus) GetHostIP() string {
	if m != nil && m.HostIP != nil {
		return *m.HostIP
	}
	return ""
}

func (m *PodStatus) GetPodIP() string {
	if m != nil && m.PodIP != nil {
		return *m.PodIP
	}
	return ""
}

func (m *PodStatus) GetStartTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *PodStatus) GetInitContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.InitContainerStatuses
	}
	return nil
}

func (m *PodStatus) GetContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.ContainerStatuses
	}
	return nil
}

func (m *PodStatus) GetQosClass() string {
	if m != nil && m.QosClass != nil {
		return *m.QosClass
	}
	return ""
}

// PodStatusResult is a wrapper for PodStatus returned by kubelet that can be encode/decoded
type PodStatusResult struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Most recently observed status of the pod.
	// This data may not be up to date.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *PodStatus `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *PodStatusResult) Reset()                    { *m = PodStatusResult{} }
func (m *PodStatusResult) String() string            { return proto.CompactTextString(m) }
func (*PodStatusResult) ProtoMessage()               {}
func (*PodStatusResult) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{128} }

func (m *PodStatusResult) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodStatusResult) GetStatus() *PodStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PodTemplate describes a template for creating copies of a predefined pod.
type PodTemplate struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Template defines the pods that will be created from this pod template.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Template         *PodTemplateSpec `protobuf:"bytes,2,opt,name=template" json:"template,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *PodTemplate) Reset()                    { *m = PodTemplate{} }
func (m *PodTemplate) String() string            { return proto.CompactTextString(m) }
func (*PodTemplate) ProtoMessage()               {}
func (*PodTemplate) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{129} }

func (m *PodTemplate) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodTemplate) GetTemplate() *PodTemplateSpec {
	if m != nil {
		return m.Template
	}
	return nil
}

// PodTemplateList is a list of PodTemplates.
type PodTemplateList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of pod templates
	Items            []*PodTemplate `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *PodTemplateList) Reset()                    { *m = PodTemplateList{} }
func (m *PodTemplateList) String() string            { return proto.CompactTextString(m) }
func (*PodTemplateList) ProtoMessage()               {}
func (*PodTemplateList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{130} }

func (m *PodTemplateList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodTemplateList) GetItems() []*PodTemplate {
	if m != nil {
		return m.Items
	}
	return nil
}

// PodTemplateSpec describes the data a pod should have when created from a template
type PodTemplateSpec struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Specification of the desired behavior of the pod.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec             *PodSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *PodTemplateSpec) Reset()                    { *m = PodTemplateSpec{} }
func (m *PodTemplateSpec) String() string            { return proto.CompactTextString(m) }
func (*PodTemplateSpec) ProtoMessage()               {}
func (*PodTemplateSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{131} }

func (m *PodTemplateSpec) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodTemplateSpec) GetSpec() *PodSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// PortworxVolumeSource represents a Portworx volume resource.
type PortworxVolumeSource struct {
	// VolumeID uniquely identifies a Portworx volume
	VolumeID *string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID,omitempty"`
	// FSType represents the filesystem type to mount
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly         *bool  `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PortworxVolumeSource) Reset()                    { *m = PortworxVolumeSource{} }
func (m *PortworxVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*PortworxVolumeSource) ProtoMessage()               {}
func (*PortworxVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{132} }

func (m *PortworxVolumeSource) GetVolumeID() string {
	if m != nil && m.VolumeID != nil {
		return *m.VolumeID
	}
	return ""
}

func (m *PortworxVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *PortworxVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
// +k8s:openapi-gen=false
type Preconditions struct {
	// Specifies the target UID.
	// +optional
	Uid              *string `protobuf:"bytes,1,opt,name=uid" json:"uid,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Preconditions) Reset()                    { *m = Preconditions{} }
func (m *Preconditions) String() string            { return proto.CompactTextString(m) }
func (*Preconditions) ProtoMessage()               {}
func (*Preconditions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{133} }

func (m *Preconditions) GetUid() string {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return ""
}

// Describes a class of pods that should avoid this node.
type PreferAvoidPodsEntry struct {
	// The class of pods.
	PodSignature *PodSignature `protobuf:"bytes,1,opt,name=podSignature" json:"podSignature,omitempty"`
	// Time at which this entry was added to the list.
	// +optional
	EvictionTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,2,opt,name=evictionTime" json:"evictionTime,omitempty"`
	// (brief) reason why this entry was added to the list.
	// +optional
	Reason *string `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
	// Human readable message indicating why this entry was added to the list.
	// +optional
	Message          *string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PreferAvoidPodsEntry) Reset()                    { *m = PreferAvoidPodsEntry{} }
func (m *PreferAvoidPodsEntry) String() string            { return proto.CompactTextString(m) }
func (*PreferAvoidPodsEntry) ProtoMessage()               {}
func (*PreferAvoidPodsEntry) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{134} }

func (m *PreferAvoidPodsEntry) GetPodSignature() *PodSignature {
	if m != nil {
		return m.PodSignature
	}
	return nil
}

func (m *PreferAvoidPodsEntry) GetEvictionTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.EvictionTime
	}
	return nil
}

func (m *PreferAvoidPodsEntry) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *PreferAvoidPodsEntry) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// An empty preferred scheduling term matches all objects with implicit weight 0
// (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
type PreferredSchedulingTerm struct {
	// Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
	Weight *int32 `protobuf:"varint,1,opt,name=weight" json:"weight,omitempty"`
	// A node selector term, associated with the corresponding weight.
	Preference       *NodeSelectorTerm `protobuf:"bytes,2,opt,name=preference" json:"preference,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PreferredSchedulingTerm) Reset()         { *m = PreferredSchedulingTerm{} }
func (m *PreferredSchedulingTerm) String() string { return proto.CompactTextString(m) }
func (*PreferredSchedulingTerm) ProtoMessage()    {}
func (*PreferredSchedulingTerm) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{135}
}

func (m *PreferredSchedulingTerm) GetWeight() int32 {
	if m != nil && m.Weight != nil {
		return *m.Weight
	}
	return 0
}

func (m *PreferredSchedulingTerm) GetPreference() *NodeSelectorTerm {
	if m != nil {
		return m.Preference
	}
	return nil
}

// Probe describes a health check to be performed against a container to determine whether it is
// alive or ready to receive traffic.
type Probe struct {
	// The action taken to determine the health of a container
	Handler *Handler `protobuf:"bytes,1,opt,name=handler" json:"handler,omitempty"`
	// Number of seconds after the container has started before liveness probes are initiated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	InitialDelaySeconds *int32 `protobuf:"varint,2,opt,name=initialDelaySeconds" json:"initialDelaySeconds,omitempty"`
	// Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	TimeoutSeconds *int32 `protobuf:"varint,3,opt,name=timeoutSeconds" json:"timeoutSeconds,omitempty"`
	// How often (in seconds) to perform the probe.
	// Default to 10 seconds. Minimum value is 1.
	// +optional
	PeriodSeconds *int32 `protobuf:"varint,4,opt,name=periodSeconds" json:"periodSeconds,omitempty"`
	// Minimum consecutive successes for the probe to be considered successful after having failed.
	// Defaults to 1. Must be 1 for liveness. Minimum value is 1.
	// +optional
	SuccessThreshold *int32 `protobuf:"varint,5,opt,name=successThreshold" json:"successThreshold,omitempty"`
	// Minimum consecutive failures for the probe to be considered failed after having succeeded.
	// Defaults to 3. Minimum value is 1.
	// +optional
	FailureThreshold *int32 `protobuf:"varint,6,opt,name=failureThreshold" json:"failureThreshold,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Probe) Reset()                    { *m = Probe{} }
func (m *Probe) String() string            { return proto.CompactTextString(m) }
func (*Probe) ProtoMessage()               {}
func (*Probe) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{136} }

func (m *Probe) GetHandler() *Handler {
	if m != nil {
		return m.Handler
	}
	return nil
}

func (m *Probe) GetInitialDelaySeconds() int32 {
	if m != nil && m.InitialDelaySeconds != nil {
		return *m.InitialDelaySeconds
	}
	return 0
}

func (m *Probe) GetTimeoutSeconds() int32 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return 0
}

func (m *Probe) GetPeriodSeconds() int32 {
	if m != nil && m.PeriodSeconds != nil {
		return *m.PeriodSeconds
	}
	return 0
}

func (m *Probe) GetSuccessThreshold() int32 {
	if m != nil && m.SuccessThreshold != nil {
		return *m.SuccessThreshold
	}
	return 0
}

func (m *Probe) GetFailureThreshold() int32 {
	if m != nil && m.FailureThreshold != nil {
		return *m.FailureThreshold
	}
	return 0
}

// Represents a projected volume source
type ProjectedVolumeSource struct {
	// list of volume projections
	Sources []*VolumeProjection `protobuf:"bytes,1,rep,name=sources" json:"sources,omitempty"`
	// Mode bits to use on created files by default. Must be a value between
	// 0 and 0777.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode      *int32 `protobuf:"varint,2,opt,name=defaultMode" json:"defaultMode,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ProjectedVolumeSource) Reset()                    { *m = ProjectedVolumeSource{} }
func (m *ProjectedVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*ProjectedVolumeSource) ProtoMessage()               {}
func (*ProjectedVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{137} }

func (m *ProjectedVolumeSource) GetSources() []*VolumeProjection {
	if m != nil {
		return m.Sources
	}
	return nil
}

func (m *ProjectedVolumeSource) GetDefaultMode() int32 {
	if m != nil && m.DefaultMode != nil {
		return *m.DefaultMode
	}
	return 0
}

// Represents a Quobyte mount that lasts the lifetime of a pod.
// Quobyte volumes do not support ownership management or SELinux relabeling.
type QuobyteVolumeSource struct {
	// Registry represents a single or multiple Quobyte Registry services
	// specified as a string as host:port pair (multiple entries are separated with commas)
	// which acts as the central registry for volumes
	Registry *string `protobuf:"bytes,1,opt,name=registry" json:"registry,omitempty"`
	// Volume is a string that references an already created Quobyte volume by name.
	Volume *string `protobuf:"bytes,2,opt,name=volume" json:"volume,omitempty"`
	// ReadOnly here will force the Quobyte volume to be mounted with read-only permissions.
	// Defaults to false.
	// +optional
	ReadOnly *bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly,omitempty"`
	// User to map volume access to
	// Defaults to serivceaccount user
	// +optional
	User *string `protobuf:"bytes,4,opt,name=user" json:"user,omitempty"`
	// Group to map volume access to
	// Default is no group
	// +optional
	Group            *string `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *QuobyteVolumeSource) Reset()                    { *m = QuobyteVolumeSource{} }
func (m *QuobyteVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*QuobyteVolumeSource) ProtoMessage()               {}
func (*QuobyteVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{138} }

func (m *QuobyteVolumeSource) GetRegistry() string {
	if m != nil && m.Registry != nil {
		return *m.Registry
	}
	return ""
}

func (m *QuobyteVolumeSource) GetVolume() string {
	if m != nil && m.Volume != nil {
		return *m.Volume
	}
	return ""
}

func (m *QuobyteVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *QuobyteVolumeSource) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *QuobyteVolumeSource) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

// Represents a Rados Block Device mount that lasts the lifetime of a pod.
// RBD volumes support ownership management and SELinux relabeling.
type RBDPersistentVolumeSource struct {
	// A collection of Ceph monitors.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// The rados image name.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	Image *string `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,3,opt,name=fsType" json:"fsType,omitempty"`
	// The rados pool name.
	// Default is rbd.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	Pool *string `protobuf:"bytes,4,opt,name=pool" json:"pool,omitempty"`
	// The rados user name.
	// Default is admin.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	User *string `protobuf:"bytes,5,opt,name=user" json:"user,omitempty"`
	// Keyring is the path to key ring for RBDUser.
	// Default is /etc/ceph/keyring.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	Keyring *string `protobuf:"bytes,6,opt,name=keyring" json:"keyring,omitempty"`
	// SecretRef is name of the authentication secret for RBDUser. If provided
	// overrides keyring.
	// Default is nil.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,7,opt,name=secretRef" json:"secretRef,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	ReadOnly         *bool  `protobuf:"varint,8,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RBDPersistentVolumeSource) Reset()         { *m = RBDPersistentVolumeSource{} }
func (m *RBDPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*RBDPersistentVolumeSource) ProtoMessage()    {}
func (*RBDPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{139}
}

func (m *RBDPersistentVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *RBDPersistentVolumeSource) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetPool() string {
	if m != nil && m.Pool != nil {
		return *m.Pool
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetKeyring() string {
	if m != nil && m.Keyring != nil {
		return *m.Keyring
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *RBDPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Represents a Rados Block Device mount that lasts the lifetime of a pod.
// RBD volumes support ownership management and SELinux relabeling.
type RBDVolumeSource struct {
	// A collection of Ceph monitors.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// The rados image name.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	Image *string `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType *string `protobuf:"bytes,3,opt,name=fsType" json:"fsType,omitempty"`
	// The rados pool name.
	// Default is rbd.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	Pool *string `protobuf:"bytes,4,opt,name=pool" json:"pool,omitempty"`
	// The rados user name.
	// Default is admin.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	User *string `protobuf:"bytes,5,opt,name=user" json:"user,omitempty"`
	// Keyring is the path to key ring for RBDUser.
	// Default is /etc/ceph/keyring.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	Keyring *string `protobuf:"bytes,6,opt,name=keyring" json:"keyring,omitempty"`
	// SecretRef is name of the authentication secret for RBDUser. If provided
	// overrides keyring.
	// Default is nil.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,7,opt,name=secretRef" json:"secretRef,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
	// +optional
	ReadOnly         *bool  `protobuf:"varint,8,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RBDVolumeSource) Reset()                    { *m = RBDVolumeSource{} }
func (m *RBDVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*RBDVolumeSource) ProtoMessage()               {}
func (*RBDVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{140} }

func (m *RBDVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *RBDVolumeSource) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *RBDVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *RBDVolumeSource) GetPool() string {
	if m != nil && m.Pool != nil {
		return *m.Pool
	}
	return ""
}

func (m *RBDVolumeSource) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *RBDVolumeSource) GetKeyring() string {
	if m != nil && m.Keyring != nil {
		return *m.Keyring
	}
	return ""
}

func (m *RBDVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *RBDVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// RangeAllocation is not a public type.
type RangeAllocation struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Range is string that identifies the range represented by 'data'.
	Range *string `protobuf:"bytes,2,opt,name=range" json:"range,omitempty"`
	// Data is a bit array containing all allocated addresses in the previous segment.
	Data             []byte `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RangeAllocation) Reset()                    { *m = RangeAllocation{} }
func (m *RangeAllocation) String() string            { return proto.CompactTextString(m) }
func (*RangeAllocation) ProtoMessage()               {}
func (*RangeAllocation) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{141} }

func (m *RangeAllocation) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *RangeAllocation) GetRange() string {
	if m != nil && m.Range != nil {
		return *m.Range
	}
	return ""
}

func (m *RangeAllocation) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// ReplicationController represents the configuration of a replication controller.
type ReplicationController struct {
	// If the Labels of a ReplicationController are empty, they are defaulted to
	// be the same as the Pod(s) that the replication controller manages.
	// Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the specification of the desired behavior of the replication controller.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *ReplicationControllerSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status is the most recently observed status of the replication controller.
	// This data may be out of date by some window of time.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *ReplicationControllerStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte                       `json:"-"`
}

func (m *ReplicationController) Reset()                    { *m = ReplicationController{} }
func (m *ReplicationController) String() string            { return proto.CompactTextString(m) }
func (*ReplicationController) ProtoMessage()               {}
func (*ReplicationController) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{142} }

func (m *ReplicationController) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ReplicationController) GetSpec() *ReplicationControllerSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *ReplicationController) GetStatus() *ReplicationControllerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// ReplicationControllerCondition describes the state of a replication controller at a certain point.
type ReplicationControllerCondition struct {
	// Type of replication controller condition.
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Status of the condition, one of True, False, Unknown.
	Status *string `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// The last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,3,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// The reason for the condition's last transition.
	// +optional
	Reason *string `protobuf:"bytes,4,opt,name=reason" json:"reason,omitempty"`
	// A human readable message indicating details about the transition.
	// +optional
	Message          *string `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ReplicationControllerCondition) Reset()         { *m = ReplicationControllerCondition{} }
func (m *ReplicationControllerCondition) String() string { return proto.CompactTextString(m) }
func (*ReplicationControllerCondition) ProtoMessage()    {}
func (*ReplicationControllerCondition) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{143}
}

func (m *ReplicationControllerCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *ReplicationControllerCondition) GetStatus() string {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ""
}

func (m *ReplicationControllerCondition) GetLastTransitionTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *ReplicationControllerCondition) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *ReplicationControllerCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// ReplicationControllerList is a collection of replication controllers.
type ReplicationControllerList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of replication controllers.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
	Items            []*ReplicationController `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *ReplicationControllerList) Reset()         { *m = ReplicationControllerList{} }
func (m *ReplicationControllerList) String() string { return proto.CompactTextString(m) }
func (*ReplicationControllerList) ProtoMessage()    {}
func (*ReplicationControllerList) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{144}
}

func (m *ReplicationControllerList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ReplicationControllerList) GetItems() []*ReplicationController {
	if m != nil {
		return m.Items
	}
	return nil
}

// ReplicationControllerSpec is the specification of a replication controller.
type ReplicationControllerSpec struct {
	// Replicas is the number of desired replicas.
	// This is a pointer to distinguish between explicit zero and unspecified.
	// Defaults to 1.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
	// +optional
	Replicas *int32 `protobuf:"varint,1,opt,name=replicas" json:"replicas,omitempty"`
	// Minimum number of seconds for which a newly created pod should be ready
	// without any of its container crashing, for it to be considered available.
	// Defaults to 0 (pod will be considered available as soon as it is ready)
	// +optional
	MinReadySeconds *int32 `protobuf:"varint,4,opt,name=minReadySeconds" json:"minReadySeconds,omitempty"`
	// Selector is a label query over pods that should match the Replicas count.
	// If Selector is empty, it is defaulted to the labels present on the Pod template.
	// Label keys and values that must match in order to be controlled by this replication
	// controller, if empty defaulted to labels on Pod template.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
	// +optional
	Selector map[string]string `protobuf:"bytes,2,rep,name=selector" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Template is the object that describes the pod that will be created if
	// insufficient replicas are detected. This takes precedence over a TemplateRef.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
	// +optional
	Template         *PodTemplateSpec `protobuf:"bytes,3,opt,name=template" json:"template,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ReplicationControllerSpec) Reset()         { *m = ReplicationControllerSpec{} }
func (m *ReplicationControllerSpec) String() string { return proto.CompactTextString(m) }
func (*ReplicationControllerSpec) ProtoMessage()    {}
func (*ReplicationControllerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{145}
}

func (m *ReplicationControllerSpec) GetReplicas() int32 {
	if m != nil && m.Replicas != nil {
		return *m.Replicas
	}
	return 0
}

func (m *ReplicationControllerSpec) GetMinReadySeconds() int32 {
	if m != nil && m.MinReadySeconds != nil {
		return *m.MinReadySeconds
	}
	return 0
}

func (m *ReplicationControllerSpec) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *ReplicationControllerSpec) GetTemplate() *PodTemplateSpec {
	if m != nil {
		return m.Template
	}
	return nil
}

// ReplicationControllerStatus represents the current status of a replication
// controller.
type ReplicationControllerStatus struct {
	// Replicas is the most recently oberved number of replicas.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
	Replicas *int32 `protobuf:"varint,1,opt,name=replicas" json:"replicas,omitempty"`
	// The number of pods that have labels matching the labels of the pod template of the replication controller.
	// +optional
	FullyLabeledReplicas *int32 `protobuf:"varint,2,opt,name=fullyLabeledReplicas" json:"fullyLabeledReplicas,omitempty"`
	// The number of ready replicas for this replication controller.
	// +optional
	ReadyReplicas *int32 `protobuf:"varint,4,opt,name=readyReplicas" json:"readyReplicas,omitempty"`
	// The number of available replicas (ready for at least minReadySeconds) for this replication controller.
	// +optional
	AvailableReplicas *int32 `protobuf:"varint,5,opt,name=availableReplicas" json:"availableReplicas,omitempty"`
	// ObservedGeneration reflects the generation of the most recently observed replication controller.
	// +optional
	ObservedGeneration *int64 `protobuf:"varint,3,opt,name=observedGeneration" json:"observedGeneration,omitempty"`
	// Represents the latest available observations of a replication controller's current state.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions       []*ReplicationControllerCondition `protobuf:"bytes,6,rep,name=conditions" json:"conditions,omitempty"`
	XXX_unrecognized []byte                            `json:"-"`
}

func (m *ReplicationControllerStatus) Reset()         { *m = ReplicationControllerStatus{} }
func (m *ReplicationControllerStatus) String() string { return proto.CompactTextString(m) }
func (*ReplicationControllerStatus) ProtoMessage()    {}
func (*ReplicationControllerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{146}
}

func (m *ReplicationControllerStatus) GetReplicas() int32 {
	if m != nil && m.Replicas != nil {
		return *m.Replicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetFullyLabeledReplicas() int32 {
	if m != nil && m.FullyLabeledReplicas != nil {
		return *m.FullyLabeledReplicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetReadyReplicas() int32 {
	if m != nil && m.ReadyReplicas != nil {
		return *m.ReadyReplicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetAvailableReplicas() int32 {
	if m != nil && m.AvailableReplicas != nil {
		return *m.AvailableReplicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetObservedGeneration() int64 {
	if m != nil && m.ObservedGeneration != nil {
		return *m.ObservedGeneration
	}
	return 0
}

func (m *ReplicationControllerStatus) GetConditions() []*ReplicationControllerCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// ResourceFieldSelector represents container resources (cpu, memory) and their output format
type ResourceFieldSelector struct {
	// Container name: required for volumes, optional for env vars
	// +optional
	ContainerName *string `protobuf:"bytes,1,opt,name=containerName" json:"containerName,omitempty"`
	// Required: resource to select
	Resource *string `protobuf:"bytes,2,opt,name=resource" json:"resource,omitempty"`
	// Specifies the output format of the exposed resources, defaults to "1"
	// +optional
	Divisor          *k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,3,opt,name=divisor" json:"divisor,omitempty"`
	XXX_unrecognized []byte                                         `json:"-"`
}

func (m *ResourceFieldSelector) Reset()                    { *m = ResourceFieldSelector{} }
func (m *ResourceFieldSelector) String() string            { return proto.CompactTextString(m) }
func (*ResourceFieldSelector) ProtoMessage()               {}
func (*ResourceFieldSelector) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{147} }

func (m *ResourceFieldSelector) GetContainerName() string {
	if m != nil && m.ContainerName != nil {
		return *m.ContainerName
	}
	return ""
}

func (m *ResourceFieldSelector) GetResource() string {
	if m != nil && m.Resource != nil {
		return *m.Resource
	}
	return ""
}

func (m *ResourceFieldSelector) GetDivisor() *k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Divisor
	}
	return nil
}

// ResourceQuota sets aggregate quota restrictions enforced per namespace
type ResourceQuota struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the desired quota.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *ResourceQuotaSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status defines the actual enforced quota and its current usage.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *ResourceQuotaStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *ResourceQuota) Reset()                    { *m = ResourceQuota{} }
func (m *ResourceQuota) String() string            { return proto.CompactTextString(m) }
func (*ResourceQuota) ProtoMessage()               {}
func (*ResourceQuota) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{148} }

func (m *ResourceQuota) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ResourceQuota) GetSpec() *ResourceQuotaSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *ResourceQuota) GetStatus() *ResourceQuotaStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// ResourceQuotaList is a list of ResourceQuota items.
type ResourceQuotaList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of ResourceQuota objects.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	Items            []*ResourceQuota `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ResourceQuotaList) Reset()                    { *m = ResourceQuotaList{} }
func (m *ResourceQuotaList) String() string            { return proto.CompactTextString(m) }
func (*ResourceQuotaList) ProtoMessage()               {}
func (*ResourceQuotaList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{149} }

func (m *ResourceQuotaList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ResourceQuotaList) GetItems() []*ResourceQuota {
	if m != nil {
		return m.Items
	}
	return nil
}

// ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
type ResourceQuotaSpec struct {
	// Hard is the set of desired hard limits for each named resource.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	// +optional
	Hard map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,1,rep,name=hard" json:"hard,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// A collection of filters that must match each object tracked by a quota.
	// If not specified, the quota matches all objects.
	// +optional
	Scopes           []string `protobuf:"bytes,2,rep,name=scopes" json:"scopes,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ResourceQuotaSpec) Reset()                    { *m = ResourceQuotaSpec{} }
func (m *ResourceQuotaSpec) String() string            { return proto.CompactTextString(m) }
func (*ResourceQuotaSpec) ProtoMessage()               {}
func (*ResourceQuotaSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{150} }

func (m *ResourceQuotaSpec) GetHard() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Hard
	}
	return nil
}

func (m *ResourceQuotaSpec) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

// ResourceQuotaStatus defines the enforced hard limits and observed use.
type ResourceQuotaStatus struct {
	// Hard is the set of enforced hard limits for each named resource.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	// +optional
	Hard map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,1,rep,name=hard" json:"hard,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Used is the current observed total usage of the resource in the namespace.
	// +optional
	Used             map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,2,rep,name=used" json:"used,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte                                                    `json:"-"`
}

func (m *ResourceQuotaStatus) Reset()                    { *m = ResourceQuotaStatus{} }
func (m *ResourceQuotaStatus) String() string            { return proto.CompactTextString(m) }
func (*ResourceQuotaStatus) ProtoMessage()               {}
func (*ResourceQuotaStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{151} }

func (m *ResourceQuotaStatus) GetHard() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Hard
	}
	return nil
}

func (m *ResourceQuotaStatus) GetUsed() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Used
	}
	return nil
}

// ResourceRequirements describes the compute resource requirements.
type ResourceRequirements struct {
	// Limits describes the maximum amount of compute resources allowed.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	// +optional
	Limits map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,1,rep,name=limits" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Requests describes the minimum amount of compute resources required.
	// If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
	// otherwise to an implementation-defined value.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	// +optional
	Requests         map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity `protobuf:"bytes,2,rep,name=requests" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte                                                    `json:"-"`
}

func (m *ResourceRequirements) Reset()                    { *m = ResourceRequirements{} }
func (m *ResourceRequirements) String() string            { return proto.CompactTextString(m) }
func (*ResourceRequirements) ProtoMessage()               {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{152} }

func (m *ResourceRequirements) GetLimits() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *ResourceRequirements) GetRequests() map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity {
	if m != nil {
		return m.Requests
	}
	return nil
}

// SELinuxOptions are the labels to be applied to the container
type SELinuxOptions struct {
	// User is a SELinux user label that applies to the container.
	// +optional
	User *string `protobuf:"bytes,1,opt,name=user" json:"user,omitempty"`
	// Role is a SELinux role label that applies to the container.
	// +optional
	Role *string `protobuf:"bytes,2,opt,name=role" json:"role,omitempty"`
	// Type is a SELinux type label that applies to the container.
	// +optional
	Type *string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	// Level is SELinux level label that applies to the container.
	// +optional
	Level            *string `protobuf:"bytes,4,opt,name=level" json:"level,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SELinuxOptions) Reset()                    { *m = SELinuxOptions{} }
func (m *SELinuxOptions) String() string            { return proto.CompactTextString(m) }
func (*SELinuxOptions) ProtoMessage()               {}
func (*SELinuxOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{153} }

func (m *SELinuxOptions) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *SELinuxOptions) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *SELinuxOptions) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *SELinuxOptions) GetLevel() string {
	if m != nil && m.Level != nil {
		return *m.Level
	}
	return ""
}

// ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
type ScaleIOPersistentVolumeSource struct {
	// The host address of the ScaleIO API Gateway.
	Gateway *string `protobuf:"bytes,1,opt,name=gateway" json:"gateway,omitempty"`
	// The name of the storage system as configured in ScaleIO.
	System *string `protobuf:"bytes,2,opt,name=system" json:"system,omitempty"`
	// SecretRef references to the secret for ScaleIO user and other
	// sensitive information. If this is not provided, Login operation will fail.
	SecretRef *SecretReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Flag to enable/disable SSL communication with Gateway, default false
	// +optional
	SslEnabled *bool `protobuf:"varint,4,opt,name=sslEnabled" json:"sslEnabled,omitempty"`
	// The name of the ScaleIO Protection Domain for the configured storage.
	// +optional
	ProtectionDomain *string `protobuf:"bytes,5,opt,name=protectionDomain" json:"protectionDomain,omitempty"`
	// The ScaleIO Storage Pool associated with the protection domain.
	// +optional
	StoragePool *string `protobuf:"bytes,6,opt,name=storagePool" json:"storagePool,omitempty"`
	// Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
	// +optional
	StorageMode *string `protobuf:"bytes,7,opt,name=storageMode" json:"storageMode,omitempty"`
	// The name of a volume already created in the ScaleIO system
	// that is associated with this volume source.
	VolumeName *string `protobuf:"bytes,8,opt,name=volumeName" json:"volumeName,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,9,opt,name=fsType" json:"fsType,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly         *bool  `protobuf:"varint,10,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ScaleIOPersistentVolumeSource) Reset()         { *m = ScaleIOPersistentVolumeSource{} }
func (m *ScaleIOPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*ScaleIOPersistentVolumeSource) ProtoMessage()    {}
func (*ScaleIOPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{154}
}

func (m *ScaleIOPersistentVolumeSource) GetGateway() string {
	if m != nil && m.Gateway != nil {
		return *m.Gateway
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetSystem() string {
	if m != nil && m.System != nil {
		return *m.System
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ScaleIOPersistentVolumeSource) GetSslEnabled() bool {
	if m != nil && m.SslEnabled != nil {
		return *m.SslEnabled
	}
	return false
}

func (m *ScaleIOPersistentVolumeSource) GetProtectionDomain() string {
	if m != nil && m.ProtectionDomain != nil {
		return *m.ProtectionDomain
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetStoragePool() string {
	if m != nil && m.StoragePool != nil {
		return *m.StoragePool
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetStorageMode() string {
	if m != nil && m.StorageMode != nil {
		return *m.StorageMode
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetVolumeName() string {
	if m != nil && m.VolumeName != nil {
		return *m.VolumeName
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// ScaleIOVolumeSource represents a persistent ScaleIO volume
type ScaleIOVolumeSource struct {
	// The host address of the ScaleIO API Gateway.
	Gateway *string `protobuf:"bytes,1,opt,name=gateway" json:"gateway,omitempty"`
	// The name of the storage system as configured in ScaleIO.
	System *string `protobuf:"bytes,2,opt,name=system" json:"system,omitempty"`
	// SecretRef references to the secret for ScaleIO user and other
	// sensitive information. If this is not provided, Login operation will fail.
	SecretRef *LocalObjectReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Flag to enable/disable SSL communication with Gateway, default false
	// +optional
	SslEnabled *bool `protobuf:"varint,4,opt,name=sslEnabled" json:"sslEnabled,omitempty"`
	// The name of the ScaleIO Protection Domain for the configured storage.
	// +optional
	ProtectionDomain *string `protobuf:"bytes,5,opt,name=protectionDomain" json:"protectionDomain,omitempty"`
	// The ScaleIO Storage Pool associated with the protection domain.
	// +optional
	StoragePool *string `protobuf:"bytes,6,opt,name=storagePool" json:"storagePool,omitempty"`
	// Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
	// +optional
	StorageMode *string `protobuf:"bytes,7,opt,name=storageMode" json:"storageMode,omitempty"`
	// The name of a volume already created in the ScaleIO system
	// that is associated with this volume source.
	VolumeName *string `protobuf:"bytes,8,opt,name=volumeName" json:"volumeName,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,9,opt,name=fsType" json:"fsType,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly         *bool  `protobuf:"varint,10,opt,name=readOnly" json:"readOnly,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ScaleIOVolumeSource) Reset()                    { *m = ScaleIOVolumeSource{} }
func (m *ScaleIOVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*ScaleIOVolumeSource) ProtoMessage()               {}
func (*ScaleIOVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{155} }

func (m *ScaleIOVolumeSource) GetGateway() string {
	if m != nil && m.Gateway != nil {
		return *m.Gateway
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetSystem() string {
	if m != nil && m.System != nil {
		return *m.System
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ScaleIOVolumeSource) GetSslEnabled() bool {
	if m != nil && m.SslEnabled != nil {
		return *m.SslEnabled
	}
	return false
}

func (m *ScaleIOVolumeSource) GetProtectionDomain() string {
	if m != nil && m.ProtectionDomain != nil {
		return *m.ProtectionDomain
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetStoragePool() string {
	if m != nil && m.StoragePool != nil {
		return *m.StoragePool
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetStorageMode() string {
	if m != nil && m.StorageMode != nil {
		return *m.StorageMode
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetVolumeName() string {
	if m != nil && m.VolumeName != nil {
		return *m.VolumeName
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

// Secret holds secret data of a certain type. The total bytes of the values in
// the Data field must be less than MaxSecretSize bytes.
type Secret struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Data contains the secret data. Each key must consist of alphanumeric
	// characters, '-', '_' or '.'. The serialized form of the secret data is a
	// base64 encoded string, representing the arbitrary (possibly non-string)
	// data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
	// +optional
	Data map[string][]byte `protobuf:"bytes,2,rep,name=data" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// stringData allows specifying non-binary secret data in string form.
	// It is provided as a write-only convenience method.
	// All keys and values are merged into the data field on write, overwriting any existing values.
	// It is never output when reading from the API.
	// +k8s:conversion-gen=false
	// +optional
	StringData map[string]string `protobuf:"bytes,4,rep,name=stringData" json:"stringData,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Used to facilitate programmatic handling of secret data.
	// +optional
	Type             *string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Secret) Reset()                    { *m = Secret{} }
func (m *Secret) String() string            { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()               {}
func (*Secret) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{156} }

func (m *Secret) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Secret) GetData() map[string][]byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Secret) GetStringData() map[string]string {
	if m != nil {
		return m.StringData
	}
	return nil
}

func (m *Secret) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

// SecretEnvSource selects a Secret to populate the environment
// variables with.
//
// The contents of the target Secret's Data field will represent the
// key-value pairs as environment variables.
type SecretEnvSource struct {
	// The Secret to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// Specify whether the Secret must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,2,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *SecretEnvSource) Reset()                    { *m = SecretEnvSource{} }
func (m *SecretEnvSource) String() string            { return proto.CompactTextString(m) }
func (*SecretEnvSource) ProtoMessage()               {}
func (*SecretEnvSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{157} }

func (m *SecretEnvSource) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretEnvSource) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// SecretKeySelector selects a key of a Secret.
type SecretKeySelector struct {
	// The name of the secret in the pod's namespace to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// The key of the secret to select from.  Must be a valid secret key.
	Key *string `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	// Specify whether the Secret or it's key must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,3,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *SecretKeySelector) Reset()                    { *m = SecretKeySelector{} }
func (m *SecretKeySelector) String() string            { return proto.CompactTextString(m) }
func (*SecretKeySelector) ProtoMessage()               {}
func (*SecretKeySelector) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{158} }

func (m *SecretKeySelector) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretKeySelector) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *SecretKeySelector) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// SecretList is a list of Secret.
type SecretList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of secret objects.
	// More info: https://kubernetes.io/docs/concepts/configuration/secret
	Items            []*Secret `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *SecretList) Reset()                    { *m = SecretList{} }
func (m *SecretList) String() string            { return proto.CompactTextString(m) }
func (*SecretList) ProtoMessage()               {}
func (*SecretList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{159} }

func (m *SecretList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SecretList) GetItems() []*Secret {
	if m != nil {
		return m.Items
	}
	return nil
}

// Adapts a secret into a projected volume.
//
// The contents of the target Secret's Data field will be presented in a
// projected volume as files using the keys in the Data field as the file names.
// Note that this is identical to a secret volume source without the default
// mode.
type SecretProjection struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// Secret will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the Secret,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Specify whether the Secret or its key must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,4,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *SecretProjection) Reset()                    { *m = SecretProjection{} }
func (m *SecretProjection) String() string            { return proto.CompactTextString(m) }
func (*SecretProjection) ProtoMessage()               {}
func (*SecretProjection) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{160} }

func (m *SecretProjection) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretProjection) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *SecretProjection) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// SecretReference represents a Secret Reference. It has enough information to retrieve secret
// in any namespace
type SecretReference struct {
	// Name is unique within a namespace to reference a secret resource.
	// +optional
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Namespace defines the space within which the secret name must be unique.
	// +optional
	Namespace        *string `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SecretReference) Reset()                    { *m = SecretReference{} }
func (m *SecretReference) String() string            { return proto.CompactTextString(m) }
func (*SecretReference) ProtoMessage()               {}
func (*SecretReference) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{161} }

func (m *SecretReference) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *SecretReference) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

// Adapts a Secret into a volume.
//
// The contents of the target Secret's Data field will be presented in a volume
// as files using the keys in the Data field as the file names.
// Secret volumes support ownership management and SELinux relabeling.
type SecretVolumeSource struct {
	// Name of the secret in the pod's namespace to use.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
	// +optional
	SecretName *string `protobuf:"bytes,1,opt,name=secretName" json:"secretName,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// Secret will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the Secret,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Optional: mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode *int32 `protobuf:"varint,3,opt,name=defaultMode" json:"defaultMode,omitempty"`
	// Specify whether the Secret or it's keys must be defined
	// +optional
	Optional         *bool  `protobuf:"varint,4,opt,name=optional" json:"optional,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *SecretVolumeSource) Reset()                    { *m = SecretVolumeSource{} }
func (m *SecretVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*SecretVolumeSource) ProtoMessage()               {}
func (*SecretVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{162} }

func (m *SecretVolumeSource) GetSecretName() string {
	if m != nil && m.SecretName != nil {
		return *m.SecretName
	}
	return ""
}

func (m *SecretVolumeSource) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *SecretVolumeSource) GetDefaultMode() int32 {
	if m != nil && m.DefaultMode != nil {
		return *m.DefaultMode
	}
	return 0
}

func (m *SecretVolumeSource) GetOptional() bool {
	if m != nil && m.Optional != nil {
		return *m.Optional
	}
	return false
}

// SecurityContext holds security configuration that will be applied to a container.
// Some fields are present in both SecurityContext and PodSecurityContext.  When both
// are set, the values in SecurityContext take precedence.
type SecurityContext struct {
	// The capabilities to add/drop when running containers.
	// Defaults to the default set of capabilities granted by the container runtime.
	// +optional
	Capabilities *Capabilities `protobuf:"bytes,1,opt,name=capabilities" json:"capabilities,omitempty"`
	// Run container in privileged mode.
	// Processes in privileged containers are essentially equivalent to root on the host.
	// Defaults to false.
	// +optional
	Privileged *bool `protobuf:"varint,2,opt,name=privileged" json:"privileged,omitempty"`
	// The SELinux context to be applied to the container.
	// If unspecified, the container runtime will allocate a random SELinux context for each
	// container.  May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	SeLinuxOptions *SELinuxOptions `protobuf:"bytes,3,opt,name=seLinuxOptions" json:"seLinuxOptions,omitempty"`
	// The UID to run the entrypoint of the container process.
	// Defaults to user specified in image metadata if unspecified.
	// May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsUser *int64 `protobuf:"varint,4,opt,name=runAsUser" json:"runAsUser,omitempty"`
	// The GID to run the entrypoint of the container process.
	// Uses runtime default if unset.
	// May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsGroup *int64 `protobuf:"varint,8,opt,name=runAsGroup" json:"runAsGroup,omitempty"`
	// Indicates that the container must run as a non-root user.
	// If true, the Kubelet will validate the image at runtime to ensure that it
	// does not run as UID 0 (root) and fail to start the container if it does.
	// If unset or false, no such validation will be performed.
	// May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsNonRoot *bool `protobuf:"varint,5,opt,name=runAsNonRoot" json:"runAsNonRoot,omitempty"`
	// Whether this container has a read-only root filesystem.
	// Default is false.
	// +optional
	ReadOnlyRootFilesystem *bool `protobuf:"varint,6,opt,name=readOnlyRootFilesystem" json:"readOnlyRootFilesystem,omitempty"`
	// AllowPrivilegeEscalation controls whether a process can gain more
	// privileges than its parent process. This bool directly controls if
	// the no_new_privs flag will be set on the container process.
	// AllowPrivilegeEscalation is true always when the container is:
	// 1) run as Privileged
	// 2) has CAP_SYS_ADMIN
	// +optional
	AllowPrivilegeEscalation *bool  `protobuf:"varint,7,opt,name=allowPrivilegeEscalation" json:"allowPrivilegeEscalation,omitempty"`
	XXX_unrecognized         []byte `json:"-"`
}

func (m *SecurityContext) Reset()                    { *m = SecurityContext{} }
func (m *SecurityContext) String() string            { return proto.CompactTextString(m) }
func (*SecurityContext) ProtoMessage()               {}
func (*SecurityContext) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{163} }

func (m *SecurityContext) GetCapabilities() *Capabilities {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *SecurityContext) GetPrivileged() bool {
	if m != nil && m.Privileged != nil {
		return *m.Privileged
	}
	return false
}

func (m *SecurityContext) GetSeLinuxOptions() *SELinuxOptions {
	if m != nil {
		return m.SeLinuxOptions
	}
	return nil
}

func (m *SecurityContext) GetRunAsUser() int64 {
	if m != nil && m.RunAsUser != nil {
		return *m.RunAsUser
	}
	return 0
}

func (m *SecurityContext) GetRunAsGroup() int64 {
	if m != nil && m.RunAsGroup != nil {
		return *m.RunAsGroup
	}
	return 0
}

func (m *SecurityContext) GetRunAsNonRoot() bool {
	if m != nil && m.RunAsNonRoot != nil {
		return *m.RunAsNonRoot
	}
	return false
}

func (m *SecurityContext) GetReadOnlyRootFilesystem() bool {
	if m != nil && m.ReadOnlyRootFilesystem != nil {
		return *m.ReadOnlyRootFilesystem
	}
	return false
}

func (m *SecurityContext) GetAllowPrivilegeEscalation() bool {
	if m != nil && m.AllowPrivilegeEscalation != nil {
		return *m.AllowPrivilegeEscalation
	}
	return false
}

// SerializedReference is a reference to serialized object.
type SerializedReference struct {
	// The reference to an object in the system.
	// +optional
	Reference        *ObjectReference `protobuf:"bytes,1,opt,name=reference" json:"reference,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *SerializedReference) Reset()                    { *m = SerializedReference{} }
func (m *SerializedReference) String() string            { return proto.CompactTextString(m) }
func (*SerializedReference) ProtoMessage()               {}
func (*SerializedReference) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{164} }

func (m *SerializedReference) GetReference() *ObjectReference {
	if m != nil {
		return m.Reference
	}
	return nil
}

// Service is a named abstraction of software service (for example, mysql) consisting of local port
// (for example 3306) that the proxy listens on, and the selector that determines which pods
// will answer requests sent through the proxy.
type Service struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the behavior of a service.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *ServiceSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Most recently observed status of the service.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status           *ServiceStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (m *Service) String() string            { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{165} }

func (m *Service) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Service) GetSpec() *ServiceSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Service) GetStatus() *ServiceStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// ServiceAccount binds together:
// * a name, understood by users, and perhaps by peripheral systems, for an identity
// * a principal that can be authenticated and authorized
// * a set of secrets
type ServiceAccount struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount.
	// More info: https://kubernetes.io/docs/concepts/configuration/secret
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	Secrets []*ObjectReference `protobuf:"bytes,2,rep,name=secrets" json:"secrets,omitempty"`
	// ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images
	// in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets
	// can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet.
	// More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
	// +optional
	ImagePullSecrets []*LocalObjectReference `protobuf:"bytes,3,rep,name=imagePullSecrets" json:"imagePullSecrets,omitempty"`
	// AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted.
	// Can be overridden at the pod level.
	// +optional
	AutomountServiceAccountToken *bool  `protobuf:"varint,4,opt,name=automountServiceAccountToken" json:"automountServiceAccountToken,omitempty"`
	XXX_unrecognized             []byte `json:"-"`
}

func (m *ServiceAccount) Reset()                    { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string            { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()               {}
func (*ServiceAccount) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{166} }

func (m *ServiceAccount) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceAccount) GetSecrets() []*ObjectReference {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ServiceAccount) GetImagePullSecrets() []*LocalObjectReference {
	if m != nil {
		return m.ImagePullSecrets
	}
	return nil
}

func (m *ServiceAccount) GetAutomountServiceAccountToken() bool {
	if m != nil && m.AutomountServiceAccountToken != nil {
		return *m.AutomountServiceAccountToken
	}
	return false
}

// ServiceAccountList is a list of ServiceAccount objects
type ServiceAccountList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of ServiceAccounts.
	// More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
	Items            []*ServiceAccount `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ServiceAccountList) Reset()                    { *m = ServiceAccountList{} }
func (m *ServiceAccountList) String() string            { return proto.CompactTextString(m) }
func (*ServiceAccountList) ProtoMessage()               {}
func (*ServiceAccountList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{167} }

func (m *ServiceAccountList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceAccountList) GetItems() []*ServiceAccount {
	if m != nil {
		return m.Items
	}
	return nil
}

// ServiceList holds a list of services.
type ServiceList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of services
	Items            []*Service `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ServiceList) Reset()                    { *m = ServiceList{} }
func (m *ServiceList) String() string            { return proto.CompactTextString(m) }
func (*ServiceList) ProtoMessage()               {}
func (*ServiceList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{168} }

func (m *ServiceList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceList) GetItems() []*Service {
	if m != nil {
		return m.Items
	}
	return nil
}

// ServicePort contains information on service's port.
type ServicePort struct {
	// The name of this port within the service. This must be a DNS_LABEL.
	// All ports within a ServiceSpec must have unique names. This maps to
	// the 'Name' field in EndpointPort objects.
	// Optional if only one ServicePort is defined on this service.
	// +optional
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The IP protocol for this port. Supports "TCP" and "UDP".
	// Default is TCP.
	// +optional
	Protocol *string `protobuf:"bytes,2,opt,name=protocol" json:"protocol,omitempty"`
	// The port that will be exposed by this service.
	Port *int32 `protobuf:"varint,3,opt,name=port" json:"port,omitempty"`
	// Number or name of the port to access on the pods targeted by the service.
	// Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
	// If this is a string, it will be looked up as a named port in the
	// target Pod's container ports. If this is not specified, the value
	// of the 'port' field is used (an identity map).
	// This field is ignored for services with clusterIP=None, and should be
	// omitted or set equal to the 'port' field.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
	// +optional
	TargetPort *k8s_io_apimachinery_pkg_util_intstr.IntOrString `protobuf:"bytes,4,opt,name=targetPort" json:"targetPort,omitempty"`
	// The port on each node on which this service is exposed when type=NodePort or LoadBalancer.
	// Usually assigned by the system. If specified, it will be allocated to the service
	// if unused or else creation of the service will fail.
	// Default is to auto-allocate a port if the ServiceType of this Service requires one.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
	// +optional
	NodePort         *int32 `protobuf:"varint,5,opt,name=nodePort" json:"nodePort,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ServicePort) Reset()                    { *m = ServicePort{} }
func (m *ServicePort) String() string            { return proto.CompactTextString(m) }
func (*ServicePort) ProtoMessage()               {}
func (*ServicePort) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{169} }

func (m *ServicePort) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ServicePort) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

func (m *ServicePort) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

func (m *ServicePort) GetTargetPort() *k8s_io_apimachinery_pkg_util_intstr.IntOrString {
	if m != nil {
		return m.TargetPort
	}
	return nil
}

func (m *ServicePort) GetNodePort() int32 {
	if m != nil && m.NodePort != nil {
		return *m.NodePort
	}
	return 0
}

// ServiceProxyOptions is the query options to a Service's proxy call.
type ServiceProxyOptions struct {
	// Path is the part of URLs that include service endpoints, suffixes,
	// and parameters to use for the current proxy request to service.
	// For example, the whole request URL is
	// http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy.
	// Path is _search?q=user:kimchy.
	// +optional
	Path             *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ServiceProxyOptions) Reset()                    { *m = ServiceProxyOptions{} }
func (m *ServiceProxyOptions) String() string            { return proto.CompactTextString(m) }
func (*ServiceProxyOptions) ProtoMessage()               {}
func (*ServiceProxyOptions) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{170} }

func (m *ServiceProxyOptions) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

// ServiceSpec describes the attributes that a user creates on a service.
type ServiceSpec struct {
	// The list of ports that are exposed by this service.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
	// +patchMergeKey=port
	// +patchStrategy=merge
	Ports []*ServicePort `protobuf:"bytes,1,rep,name=ports" json:"ports,omitempty"`
	// Route service traffic to pods with label keys and values matching this
	// selector. If empty or not present, the service is assumed to have an
	// external process managing its endpoints, which Kubernetes will not
	// modify. Only applies to types ClusterIP, NodePort, and LoadBalancer.
	// Ignored if type is ExternalName.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/
	// +optional
	Selector map[string]string `protobuf:"bytes,2,rep,name=selector" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// clusterIP is the IP address of the service and is usually assigned
	// randomly by the master. If an address is specified manually and is not in
	// use by others, it will be allocated to the service; otherwise, creation
	// of the service will fail. This field can not be changed through updates.
	// Valid values are "None", empty string (""), or a valid IP address. "None"
	// can be specified for headless services when proxying is not required.
	// Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if
	// type is ExternalName.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
	// +optional
	ClusterIP *string `protobuf:"bytes,3,opt,name=clusterIP" json:"clusterIP,omitempty"`
	// type determines how the Service is exposed. Defaults to ClusterIP. Valid
	// options are ExternalName, ClusterIP, NodePort, and LoadBalancer.
	// "ExternalName" maps to the specified externalName.
	// "ClusterIP" allocates a cluster-internal IP address for load-balancing to
	// endpoints. Endpoints are determined by the selector or if that is not
	// specified, by manual construction of an Endpoints object. If clusterIP is
	// "None", no virtual IP is allocated and the endpoints are published as a
	// set of endpoints rather than a stable IP.
	// "NodePort" builds on ClusterIP and allocates a port on every node which
	// routes to the clusterIP.
	// "LoadBalancer" builds on NodePort and creates an
	// external load-balancer (if supported in the current cloud) which routes
	// to the clusterIP.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types
	// +optional
	Type *string `protobuf:"bytes,4,opt,name=type" json:"type,omitempty"`
	// externalIPs is a list of IP addresses for which nodes in the cluster
	// will also accept traffic for this service.  These IPs are not managed by
	// Kubernetes.  The user is responsible for ensuring that traffic arrives
	// at a node with this IP.  A common example is external load-balancers
	// that are not part of the Kubernetes system.
	// +optional
	ExternalIPs []string `protobuf:"bytes,5,rep,name=externalIPs" json:"externalIPs,omitempty"`
	// Supports "ClientIP" and "None". Used to maintain session affinity.
	// Enable client IP based session affinity.
	// Must be ClientIP or None.
	// Defaults to None.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
	// +optional
	SessionAffinity *string `protobuf:"bytes,7,opt,name=sessionAffinity" json:"sessionAffinity,omitempty"`
	// Only applies to Service Type: LoadBalancer
	// LoadBalancer will get created with the IP specified in this field.
	// This feature depends on whether the underlying cloud-provider supports specifying
	// the loadBalancerIP when a load balancer is created.
	// This field will be ignored if the cloud-provider does not support the feature.
	// +optional
	LoadBalancerIP *string `protobuf:"bytes,8,opt,name=loadBalancerIP" json:"loadBalancerIP,omitempty"`
	// If specified and supported by the platform, this will restrict traffic through the cloud-provider
	// load-balancer will be restricted to the specified client IPs. This field will be ignored if the
	// cloud-provider does not support the feature."
	// More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
	// +optional
	LoadBalancerSourceRanges []string `protobuf:"bytes,9,rep,name=loadBalancerSourceRanges" json:"loadBalancerSourceRanges,omitempty"`
	// externalName is the external reference that kubedns or equivalent will
	// return as a CNAME record for this service. No proxying will be involved.
	// Must be a valid RFC-1123 hostname (https://tools.ietf.org/html/rfc1123)
	// and requires Type to be ExternalName.
	// +optional
	ExternalName *string `protobuf:"bytes,10,opt,name=externalName" json:"externalName,omitempty"`
	// externalTrafficPolicy denotes if this Service desires to route external
	// traffic to node-local or cluster-wide endpoints. "Local" preserves the
	// client source IP and avoids a second hop for LoadBalancer and Nodeport
	// type services, but risks potentially imbalanced traffic spreading.
	// "Cluster" obscures the client source IP and may cause a second hop to
	// another node, but should have good overall load-spreading.
	// +optional
	ExternalTrafficPolicy *string `protobuf:"bytes,11,opt,name=externalTrafficPolicy" json:"externalTrafficPolicy,omitempty"`
	// healthCheckNodePort specifies the healthcheck nodePort for the service.
	// If not specified, HealthCheckNodePort is created by the service api
	// backend with the allocated nodePort. Will use user-specified nodePort value
	// if specified by the client. Only effects when Type is set to LoadBalancer
	// and ExternalTrafficPolicy is set to Local.
	// +optional
	HealthCheckNodePort *int32 `protobuf:"varint,12,opt,name=healthCheckNodePort" json:"healthCheckNodePort,omitempty"`
	// publishNotReadyAddresses, when set to true, indicates that DNS implementations
	// must publish the notReadyAddresses of subsets for the Endpoints associated with
	// the Service. The default value is false.
	// The primary use case for setting this field is to use a StatefulSet's Headless Service
	// to propagate SRV records for its Pods without respect to their readiness for purpose
	// of peer discovery.
	// This field will replace the service.alpha.kubernetes.io/tolerate-unready-endpoints
	// when that annotation is deprecated and all clients have been converted to use this
	// field.
	// +optional
	PublishNotReadyAddresses *bool `protobuf:"varint,13,opt,name=publishNotReadyAddresses" json:"publishNotReadyAddresses,omitempty"`
	// sessionAffinityConfig contains the configurations of session affinity.
	// +optional
	SessionAffinityConfig *SessionAffinityConfig `protobuf:"bytes,14,opt,name=sessionAffinityConfig" json:"sessionAffinityConfig,omitempty"`
	XXX_unrecognized      []byte                 `json:"-"`
}

func (m *ServiceSpec) Reset()                    { *m = ServiceSpec{} }
func (m *ServiceSpec) String() string            { return proto.CompactTextString(m) }
func (*ServiceSpec) ProtoMessage()               {}
func (*ServiceSpec) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{171} }

func (m *ServiceSpec) GetPorts() []*ServicePort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *ServiceSpec) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *ServiceSpec) GetClusterIP() string {
	if m != nil && m.ClusterIP != nil {
		return *m.ClusterIP
	}
	return ""
}

func (m *ServiceSpec) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *ServiceSpec) GetExternalIPs() []string {
	if m != nil {
		return m.ExternalIPs
	}
	return nil
}

func (m *ServiceSpec) GetSessionAffinity() string {
	if m != nil && m.SessionAffinity != nil {
		return *m.SessionAffinity
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerIP() string {
	if m != nil && m.LoadBalancerIP != nil {
		return *m.LoadBalancerIP
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerSourceRanges() []string {
	if m != nil {
		return m.LoadBalancerSourceRanges
	}
	return nil
}

func (m *ServiceSpec) GetExternalName() string {
	if m != nil && m.ExternalName != nil {
		return *m.ExternalName
	}
	return ""
}

func (m *ServiceSpec) GetExternalTrafficPolicy() string {
	if m != nil && m.ExternalTrafficPolicy != nil {
		return *m.ExternalTrafficPolicy
	}
	return ""
}

func (m *ServiceSpec) GetHealthCheckNodePort() int32 {
	if m != nil && m.HealthCheckNodePort != nil {
		return *m.HealthCheckNodePort
	}
	return 0
}

func (m *ServiceSpec) GetPublishNotReadyAddresses() bool {
	if m != nil && m.PublishNotReadyAddresses != nil {
		return *m.PublishNotReadyAddresses
	}
	return false
}

func (m *ServiceSpec) GetSessionAffinityConfig() *SessionAffinityConfig {
	if m != nil {
		return m.SessionAffinityConfig
	}
	return nil
}

// ServiceStatus represents the current status of a service.
type ServiceStatus struct {
	// LoadBalancer contains the current status of the load-balancer,
	// if one is present.
	// +optional
	LoadBalancer     *LoadBalancerStatus `protobuf:"bytes,1,opt,name=loadBalancer" json:"loadBalancer,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *ServiceStatus) Reset()                    { *m = ServiceStatus{} }
func (m *ServiceStatus) String() string            { return proto.CompactTextString(m) }
func (*ServiceStatus) ProtoMessage()               {}
func (*ServiceStatus) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{172} }

func (m *ServiceStatus) GetLoadBalancer() *LoadBalancerStatus {
	if m != nil {
		return m.LoadBalancer
	}
	return nil
}

// SessionAffinityConfig represents the configurations of session affinity.
type SessionAffinityConfig struct {
	// clientIP contains the configurations of Client IP based session affinity.
	// +optional
	ClientIP         *ClientIPConfig `protobuf:"bytes,1,opt,name=clientIP" json:"clientIP,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *SessionAffinityConfig) Reset()                    { *m = SessionAffinityConfig{} }
func (m *SessionAffinityConfig) String() string            { return proto.CompactTextString(m) }
func (*SessionAffinityConfig) ProtoMessage()               {}
func (*SessionAffinityConfig) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{173} }

func (m *SessionAffinityConfig) GetClientIP() *ClientIPConfig {
	if m != nil {
		return m.ClientIP
	}
	return nil
}

// Represents a StorageOS persistent volume resource.
type StorageOSPersistentVolumeSource struct {
	// VolumeName is the human-readable name of the StorageOS volume.  Volume
	// names are only unique within a namespace.
	VolumeName *string `protobuf:"bytes,1,opt,name=volumeName" json:"volumeName,omitempty"`
	// VolumeNamespace specifies the scope of the volume within StorageOS.  If no
	// namespace is specified then the Pod's namespace will be used.  This allows the
	// Kubernetes name scoping to be mirrored within StorageOS for tighter integration.
	// Set VolumeName to any name to override the default behaviour.
	// Set to "default" if you are not using namespaces within StorageOS.
	// Namespaces that do not pre-exist within StorageOS will be created.
	// +optional
	VolumeNamespace *string `protobuf:"bytes,2,opt,name=volumeNamespace" json:"volumeNamespace,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,3,opt,name=fsType" json:"fsType,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	// SecretRef specifies the secret to use for obtaining the StorageOS API
	// credentials.  If not specified, default values will be attempted.
	// +optional
	SecretRef        *ObjectReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *StorageOSPersistentVolumeSource) Reset()         { *m = StorageOSPersistentVolumeSource{} }
func (m *StorageOSPersistentVolumeSource) String() string { return proto.CompactTextString(m) }
func (*StorageOSPersistentVolumeSource) ProtoMessage()    {}
func (*StorageOSPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{174}
}

func (m *StorageOSPersistentVolumeSource) GetVolumeName() string {
	if m != nil && m.VolumeName != nil {
		return *m.VolumeName
	}
	return ""
}

func (m *StorageOSPersistentVolumeSource) GetVolumeNamespace() string {
	if m != nil && m.VolumeNamespace != nil {
		return *m.VolumeNamespace
	}
	return ""
}

func (m *StorageOSPersistentVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *StorageOSPersistentVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *StorageOSPersistentVolumeSource) GetSecretRef() *ObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// Represents a StorageOS persistent volume resource.
type StorageOSVolumeSource struct {
	// VolumeName is the human-readable name of the StorageOS volume.  Volume
	// names are only unique within a namespace.
	VolumeName *string `protobuf:"bytes,1,opt,name=volumeName" json:"volumeName,omitempty"`
	// VolumeNamespace specifies the scope of the volume within StorageOS.  If no
	// namespace is specified then the Pod's namespace will be used.  This allows the
	// Kubernetes name scoping to be mirrored within StorageOS for tighter integration.
	// Set VolumeName to any name to override the default behaviour.
	// Set to "default" if you are not using namespaces within StorageOS.
	// Namespaces that do not pre-exist within StorageOS will be created.
	// +optional
	VolumeNamespace *string `protobuf:"bytes,2,opt,name=volumeNamespace" json:"volumeNamespace,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,3,opt,name=fsType" json:"fsType,omitempty"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly *bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly,omitempty"`
	// SecretRef specifies the secret to use for obtaining the StorageOS API
	// credentials.  If not specified, default values will be attempted.
	// +optional
	SecretRef        *LocalObjectReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *StorageOSVolumeSource) Reset()                    { *m = StorageOSVolumeSource{} }
func (m *StorageOSVolumeSource) String() string            { return proto.CompactTextString(m) }
func (*StorageOSVolumeSource) ProtoMessage()               {}
func (*StorageOSVolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{175} }

func (m *StorageOSVolumeSource) GetVolumeName() string {
	if m != nil && m.VolumeName != nil {
		return *m.VolumeName
	}
	return ""
}

func (m *StorageOSVolumeSource) GetVolumeNamespace() string {
	if m != nil && m.VolumeNamespace != nil {
		return *m.VolumeNamespace
	}
	return ""
}

func (m *StorageOSVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *StorageOSVolumeSource) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *StorageOSVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// Sysctl defines a kernel parameter to be set
type Sysctl struct {
	// Name of a property to set
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Value of a property to set
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Sysctl) Reset()                    { *m = Sysctl{} }
func (m *Sysctl) String() string            { return proto.CompactTextString(m) }
func (*Sysctl) ProtoMessage()               {}
func (*Sysctl) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{176} }

func (m *Sysctl) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Sysctl) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// TCPSocketAction describes an action based on opening a socket
type TCPSocketAction struct {
	// Number or name of the port to access on the container.
	// Number must be in the range 1 to 65535.
	// Name must be an IANA_SVC_NAME.
	Port *k8s_io_apimachinery_pkg_util_intstr.IntOrString `protobuf:"bytes,1,opt,name=port" json:"port,omitempty"`
	// Optional: Host name to connect to, defaults to the pod IP.
	// +optional
	Host             *string `protobuf:"bytes,2,opt,name=host" json:"host,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TCPSocketAction) Reset()                    { *m = TCPSocketAction{} }
func (m *TCPSocketAction) String() string            { return proto.CompactTextString(m) }
func (*TCPSocketAction) ProtoMessage()               {}
func (*TCPSocketAction) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{177} }

func (m *TCPSocketAction) GetPort() *k8s_io_apimachinery_pkg_util_intstr.IntOrString {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *TCPSocketAction) GetHost() string {
	if m != nil && m.Host != nil {
		return *m.Host
	}
	return ""
}

// The node this Taint is attached to has the "effect" on
// any pod that does not tolerate the Taint.
type Taint struct {
	// Required. The taint key to be applied to a node.
	Key *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Required. The taint value corresponding to the taint key.
	// +optional
	Value *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// Required. The effect of the taint on pods
	// that do not tolerate the taint.
	// Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
	Effect *string `protobuf:"bytes,3,opt,name=effect" json:"effect,omitempty"`
	// TimeAdded represents the time at which the taint was added.
	// It is only written for NoExecute taints.
	// +optional
	TimeAdded        *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,4,opt,name=timeAdded" json:"timeAdded,omitempty"`
	XXX_unrecognized []byte                                     `json:"-"`
}

func (m *Taint) Reset()                    { *m = Taint{} }
func (m *Taint) String() string            { return proto.CompactTextString(m) }
func (*Taint) ProtoMessage()               {}
func (*Taint) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{178} }

func (m *Taint) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *Taint) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *Taint) GetEffect() string {
	if m != nil && m.Effect != nil {
		return *m.Effect
	}
	return ""
}

func (m *Taint) GetTimeAdded() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.TimeAdded
	}
	return nil
}

// The pod this Toleration is attached to tolerates any taint that matches
// the triple <key,value,effect> using the matching operator <operator>.
type Toleration struct {
	// Key is the taint key that the toleration applies to. Empty means match all taint keys.
	// If the key is empty, operator must be Exists; this combination means to match all values and all keys.
	// +optional
	Key *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Operator represents a key's relationship to the value.
	// Valid operators are Exists and Equal. Defaults to Equal.
	// Exists is equivalent to wildcard for value, so that a pod can
	// tolerate all taints of a particular category.
	// +optional
	Operator *string `protobuf:"bytes,2,opt,name=operator" json:"operator,omitempty"`
	// Value is the taint value the toleration matches to.
	// If the operator is Exists, the value should be empty, otherwise just a regular string.
	// +optional
	Value *string `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	// Effect indicates the taint effect to match. Empty means match all taint effects.
	// When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
	// +optional
	Effect *string `protobuf:"bytes,4,opt,name=effect" json:"effect,omitempty"`
	// TolerationSeconds represents the period of time the toleration (which must be
	// of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
	// it is not set, which means tolerate the taint forever (do not evict). Zero and
	// negative values will be treated as 0 (evict immediately) by the system.
	// +optional
	TolerationSeconds *int64 `protobuf:"varint,5,opt,name=tolerationSeconds" json:"tolerationSeconds,omitempty"`
	XXX_unrecognized  []byte `json:"-"`
}

func (m *Toleration) Reset()                    { *m = Toleration{} }
func (m *Toleration) String() string            { return proto.CompactTextString(m) }
func (*Toleration) ProtoMessage()               {}
func (*Toleration) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{179} }

func (m *Toleration) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *Toleration) GetOperator() string {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return ""
}

func (m *Toleration) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *Toleration) GetEffect() string {
	if m != nil && m.Effect != nil {
		return *m.Effect
	}
	return ""
}

func (m *Toleration) GetTolerationSeconds() int64 {
	if m != nil && m.TolerationSeconds != nil {
		return *m.TolerationSeconds
	}
	return 0
}

// Volume represents a named volume in a pod that may be accessed by any container in the pod.
type Volume struct {
	// Volume's name.
	// Must be a DNS_LABEL and unique within the pod.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// VolumeSource represents the location and type of the mounted volume.
	// If not specified, the Volume is implied to be an EmptyDir.
	// This implied behavior is deprecated and will be removed in a future version.
	VolumeSource     *VolumeSource `protobuf:"bytes,2,opt,name=volumeSource" json:"volumeSource,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Volume) Reset()                    { *m = Volume{} }
func (m *Volume) String() string            { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()               {}
func (*Volume) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{180} }

func (m *Volume) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Volume) GetVolumeSource() *VolumeSource {
	if m != nil {
		return m.VolumeSource
	}
	return nil
}

// volumeDevice describes a mapping of a raw block device within a container.
type VolumeDevice struct {
	// name must match the name of a persistentVolumeClaim in the pod
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// devicePath is the path inside of the container that the device will be mapped to.
	DevicePath       *string `protobuf:"bytes,2,opt,name=devicePath" json:"devicePath,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *VolumeDevice) Reset()                    { *m = VolumeDevice{} }
func (m *VolumeDevice) String() string            { return proto.CompactTextString(m) }
func (*VolumeDevice) ProtoMessage()               {}
func (*VolumeDevice) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{181} }

func (m *VolumeDevice) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *VolumeDevice) GetDevicePath() string {
	if m != nil && m.DevicePath != nil {
		return *m.DevicePath
	}
	return ""
}

// VolumeMount describes a mounting of a Volume within a container.
type VolumeMount struct {
	// This must match the Name of a Volume.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Mounted read-only if true, read-write otherwise (false or unspecified).
	// Defaults to false.
	// +optional
	ReadOnly *bool `protobuf:"varint,2,opt,name=readOnly" json:"readOnly,omitempty"`
	// Path within the container at which the volume should be mounted.  Must
	// not contain ':'.
	MountPath *string `protobuf:"bytes,3,opt,name=mountPath" json:"mountPath,omitempty"`
	// Path within the volume from which the container's volume should be mounted.
	// Defaults to "" (volume's root).
	// +optional
	SubPath *string `protobuf:"bytes,4,opt,name=subPath" json:"subPath,omitempty"`
	// mountPropagation determines how mounts are propagated from the host
	// to container and the other way around.
	// When not set, MountPropagationHostToContainer is used.
	// This field is beta in 1.10.
	// +optional
	MountPropagation *string `protobuf:"bytes,5,opt,name=mountPropagation" json:"mountPropagation,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *VolumeMount) Reset()                    { *m = VolumeMount{} }
func (m *VolumeMount) String() string            { return proto.CompactTextString(m) }
func (*VolumeMount) ProtoMessage()               {}
func (*VolumeMount) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{182} }

func (m *VolumeMount) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *VolumeMount) GetReadOnly() bool {
	if m != nil && m.ReadOnly != nil {
		return *m.ReadOnly
	}
	return false
}

func (m *VolumeMount) GetMountPath() string {
	if m != nil && m.MountPath != nil {
		return *m.MountPath
	}
	return ""
}

func (m *VolumeMount) GetSubPath() string {
	if m != nil && m.SubPath != nil {
		return *m.SubPath
	}
	return ""
}

func (m *VolumeMount) GetMountPropagation() string {
	if m != nil && m.MountPropagation != nil {
		return *m.MountPropagation
	}
	return ""
}

// VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
type VolumeNodeAffinity struct {
	// Required specifies hard node constraints that must be met.
	Required         *NodeSelector `protobuf:"bytes,1,opt,name=required" json:"required,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *VolumeNodeAffinity) Reset()                    { *m = VolumeNodeAffinity{} }
func (m *VolumeNodeAffinity) String() string            { return proto.CompactTextString(m) }
func (*VolumeNodeAffinity) ProtoMessage()               {}
func (*VolumeNodeAffinity) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{183} }

func (m *VolumeNodeAffinity) GetRequired() *NodeSelector {
	if m != nil {
		return m.Required
	}
	return nil
}

// Projection that may be projected along with other supported volume types
type VolumeProjection struct {
	// information about the secret data to project
	Secret *SecretProjection `protobuf:"bytes,1,opt,name=secret" json:"secret,omitempty"`
	// information about the downwardAPI data to project
	DownwardAPI *DownwardAPIProjection `protobuf:"bytes,2,opt,name=downwardAPI" json:"downwardAPI,omitempty"`
	// information about the configMap data to project
	ConfigMap        *ConfigMapProjection `protobuf:"bytes,3,opt,name=configMap" json:"configMap,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *VolumeProjection) Reset()                    { *m = VolumeProjection{} }
func (m *VolumeProjection) String() string            { return proto.CompactTextString(m) }
func (*VolumeProjection) ProtoMessage()               {}
func (*VolumeProjection) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{184} }

func (m *VolumeProjection) GetSecret() *SecretProjection {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *VolumeProjection) GetDownwardAPI() *DownwardAPIProjection {
	if m != nil {
		return m.DownwardAPI
	}
	return nil
}

func (m *VolumeProjection) GetConfigMap() *ConfigMapProjection {
	if m != nil {
		return m.ConfigMap
	}
	return nil
}

// Represents the source of a volume to mount.
// Only one of its members may be specified.
type VolumeSource struct {
	// HostPath represents a pre-existing file or directory on the host
	// machine that is directly exposed to the container. This is generally
	// used for system agents or other privileged things that are allowed
	// to see the host machine. Most containers will NOT need this.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	// ---
	// TODO(jonesdl) We need to restrict who can use host directory mounts and who can/can not
	// mount host directories as read/write.
	// +optional
	HostPath *HostPathVolumeSource `protobuf:"bytes,1,opt,name=hostPath" json:"hostPath,omitempty"`
	// EmptyDir represents a temporary directory that shares a pod's lifetime.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
	// +optional
	EmptyDir *EmptyDirVolumeSource `protobuf:"bytes,2,opt,name=emptyDir" json:"emptyDir,omitempty"`
	// GCEPersistentDisk represents a GCE Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	GcePersistentDisk *GCEPersistentDiskVolumeSource `protobuf:"bytes,3,opt,name=gcePersistentDisk" json:"gcePersistentDisk,omitempty"`
	// AWSElasticBlockStore represents an AWS Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// +optional
	AwsElasticBlockStore *AWSElasticBlockStoreVolumeSource `protobuf:"bytes,4,opt,name=awsElasticBlockStore" json:"awsElasticBlockStore,omitempty"`
	// GitRepo represents a git repository at a particular revision.
	// +optional
	GitRepo *GitRepoVolumeSource `protobuf:"bytes,5,opt,name=gitRepo" json:"gitRepo,omitempty"`
	// Secret represents a secret that should populate this volume.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
	// +optional
	Secret *SecretVolumeSource `protobuf:"bytes,6,opt,name=secret" json:"secret,omitempty"`
	// NFS represents an NFS mount on the host that shares a pod's lifetime
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	// +optional
	Nfs *NFSVolumeSource `protobuf:"bytes,7,opt,name=nfs" json:"nfs,omitempty"`
	// ISCSI represents an ISCSI Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/iscsi/README.md
	// +optional
	Iscsi *ISCSIVolumeSource `protobuf:"bytes,8,opt,name=iscsi" json:"iscsi,omitempty"`
	// Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md
	// +optional
	Glusterfs *GlusterfsVolumeSource `protobuf:"bytes,9,opt,name=glusterfs" json:"glusterfs,omitempty"`
	// PersistentVolumeClaimVolumeSource represents a reference to a
	// PersistentVolumeClaim in the same namespace.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	PersistentVolumeClaim *PersistentVolumeClaimVolumeSource `protobuf:"bytes,10,opt,name=persistentVolumeClaim" json:"persistentVolumeClaim,omitempty"`
	// RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.
	// More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md
	// +optional
	Rbd *RBDVolumeSource `protobuf:"bytes,11,opt,name=rbd" json:"rbd,omitempty"`
	// FlexVolume represents a generic volume resource that is
	// provisioned/attached using an exec based plugin.
	// +optional
	FlexVolume *FlexVolumeSource `protobuf:"bytes,12,opt,name=flexVolume" json:"flexVolume,omitempty"`
	// Cinder represents a cinder volume attached and mounted on kubelets host machine
	// More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
	// +optional
	Cinder *CinderVolumeSource `protobuf:"bytes,13,opt,name=cinder" json:"cinder,omitempty"`
	// CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
	// +optional
	Cephfs *CephFSVolumeSource `protobuf:"bytes,14,opt,name=cephfs" json:"cephfs,omitempty"`
	// Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
	// +optional
	Flocker *FlockerVolumeSource `protobuf:"bytes,15,opt,name=flocker" json:"flocker,omitempty"`
	// DownwardAPI represents downward API about the pod that should populate this volume
	// +optional
	DownwardAPI *DownwardAPIVolumeSource `protobuf:"bytes,16,opt,name=downwardAPI" json:"downwardAPI,omitempty"`
	// FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
	// +optional
	Fc *FCVolumeSource `protobuf:"bytes,17,opt,name=fc" json:"fc,omitempty"`
	// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
	// +optional
	AzureFile *AzureFileVolumeSource `protobuf:"bytes,18,opt,name=azureFile" json:"azureFile,omitempty"`
	// ConfigMap represents a configMap that should populate this volume
	// +optional
	ConfigMap *ConfigMapVolumeSource `protobuf:"bytes,19,opt,name=configMap" json:"configMap,omitempty"`
	// VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
	// +optional
	VsphereVolume *VsphereVirtualDiskVolumeSource `protobuf:"bytes,20,opt,name=vsphereVolume" json:"vsphereVolume,omitempty"`
	// Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
	// +optional
	Quobyte *QuobyteVolumeSource `protobuf:"bytes,21,opt,name=quobyte" json:"quobyte,omitempty"`
	// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
	// +optional
	AzureDisk *AzureDiskVolumeSource `protobuf:"bytes,22,opt,name=azureDisk" json:"azureDisk,omitempty"`
	// PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
	PhotonPersistentDisk *PhotonPersistentDiskVolumeSource `protobuf:"bytes,23,opt,name=photonPersistentDisk" json:"photonPersistentDisk,omitempty"`
	// Items for all in one resources secrets, configmaps, and downward API
	Projected *ProjectedVolumeSource `protobuf:"bytes,26,opt,name=projected" json:"projected,omitempty"`
	// PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
	// +optional
	PortworxVolume *PortworxVolumeSource `protobuf:"bytes,24,opt,name=portworxVolume" json:"portworxVolume,omitempty"`
	// ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
	// +optional
	ScaleIO *ScaleIOVolumeSource `protobuf:"bytes,25,opt,name=scaleIO" json:"scaleIO,omitempty"`
	// StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
	// +optional
	Storageos        *StorageOSVolumeSource `protobuf:"bytes,27,opt,name=storageos" json:"storageos,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *VolumeSource) Reset()                    { *m = VolumeSource{} }
func (m *VolumeSource) String() string            { return proto.CompactTextString(m) }
func (*VolumeSource) ProtoMessage()               {}
func (*VolumeSource) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{185} }

func (m *VolumeSource) GetHostPath() *HostPathVolumeSource {
	if m != nil {
		return m.HostPath
	}
	return nil
}

func (m *VolumeSource) GetEmptyDir() *EmptyDirVolumeSource {
	if m != nil {
		return m.EmptyDir
	}
	return nil
}

func (m *VolumeSource) GetGcePersistentDisk() *GCEPersistentDiskVolumeSource {
	if m != nil {
		return m.GcePersistentDisk
	}
	return nil
}

func (m *VolumeSource) GetAwsElasticBlockStore() *AWSElasticBlockStoreVolumeSource {
	if m != nil {
		return m.AwsElasticBlockStore
	}
	return nil
}

func (m *VolumeSource) GetGitRepo() *GitRepoVolumeSource {
	if m != nil {
		return m.GitRepo
	}
	return nil
}

func (m *VolumeSource) GetSecret() *SecretVolumeSource {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *VolumeSource) GetNfs() *NFSVolumeSource {
	if m != nil {
		return m.Nfs
	}
	return nil
}

func (m *VolumeSource) GetIscsi() *ISCSIVolumeSource {
	if m != nil {
		return m.Iscsi
	}
	return nil
}

func (m *VolumeSource) GetGlusterfs() *GlusterfsVolumeSource {
	if m != nil {
		return m.Glusterfs
	}
	return nil
}

func (m *VolumeSource) GetPersistentVolumeClaim() *PersistentVolumeClaimVolumeSource {
	if m != nil {
		return m.PersistentVolumeClaim
	}
	return nil
}

func (m *VolumeSource) GetRbd() *RBDVolumeSource {
	if m != nil {
		return m.Rbd
	}
	return nil
}

func (m *VolumeSource) GetFlexVolume() *FlexVolumeSource {
	if m != nil {
		return m.FlexVolume
	}
	return nil
}

func (m *VolumeSource) GetCinder() *CinderVolumeSource {
	if m != nil {
		return m.Cinder
	}
	return nil
}

func (m *VolumeSource) GetCephfs() *CephFSVolumeSource {
	if m != nil {
		return m.Cephfs
	}
	return nil
}

func (m *VolumeSource) GetFlocker() *FlockerVolumeSource {
	if m != nil {
		return m.Flocker
	}
	return nil
}

func (m *VolumeSource) GetDownwardAPI() *DownwardAPIVolumeSource {
	if m != nil {
		return m.DownwardAPI
	}
	return nil
}

func (m *VolumeSource) GetFc() *FCVolumeSource {
	if m != nil {
		return m.Fc
	}
	return nil
}

func (m *VolumeSource) GetAzureFile() *AzureFileVolumeSource {
	if m != nil {
		return m.AzureFile
	}
	return nil
}

func (m *VolumeSource) GetConfigMap() *ConfigMapVolumeSource {
	if m != nil {
		return m.ConfigMap
	}
	return nil
}

func (m *VolumeSource) GetVsphereVolume() *VsphereVirtualDiskVolumeSource {
	if m != nil {
		return m.VsphereVolume
	}
	return nil
}

func (m *VolumeSource) GetQuobyte() *QuobyteVolumeSource {
	if m != nil {
		return m.Quobyte
	}
	return nil
}

func (m *VolumeSource) GetAzureDisk() *AzureDiskVolumeSource {
	if m != nil {
		return m.AzureDisk
	}
	return nil
}

func (m *VolumeSource) GetPhotonPersistentDisk() *PhotonPersistentDiskVolumeSource {
	if m != nil {
		return m.PhotonPersistentDisk
	}
	return nil
}

func (m *VolumeSource) GetProjected() *ProjectedVolumeSource {
	if m != nil {
		return m.Projected
	}
	return nil
}

func (m *VolumeSource) GetPortworxVolume() *PortworxVolumeSource {
	if m != nil {
		return m.PortworxVolume
	}
	return nil
}

func (m *VolumeSource) GetScaleIO() *ScaleIOVolumeSource {
	if m != nil {
		return m.ScaleIO
	}
	return nil
}

func (m *VolumeSource) GetStorageos() *StorageOSVolumeSource {
	if m != nil {
		return m.Storageos
	}
	return nil
}

// Represents a vSphere volume resource.
type VsphereVirtualDiskVolumeSource struct {
	// Path that identifies vSphere volume vmdk
	VolumePath *string `protobuf:"bytes,1,opt,name=volumePath" json:"volumePath,omitempty"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType *string `protobuf:"bytes,2,opt,name=fsType" json:"fsType,omitempty"`
	// Storage Policy Based Management (SPBM) profile name.
	// +optional
	StoragePolicyName *string `protobuf:"bytes,3,opt,name=storagePolicyName" json:"storagePolicyName,omitempty"`
	// Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
	// +optional
	StoragePolicyID  *string `protobuf:"bytes,4,opt,name=storagePolicyID" json:"storagePolicyID,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *VsphereVirtualDiskVolumeSource) Reset()         { *m = VsphereVirtualDiskVolumeSource{} }
func (m *VsphereVirtualDiskVolumeSource) String() string { return proto.CompactTextString(m) }
func (*VsphereVirtualDiskVolumeSource) ProtoMessage()    {}
func (*VsphereVirtualDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{186}
}

func (m *VsphereVirtualDiskVolumeSource) GetVolumePath() string {
	if m != nil && m.VolumePath != nil {
		return *m.VolumePath
	}
	return ""
}

func (m *VsphereVirtualDiskVolumeSource) GetFsType() string {
	if m != nil && m.FsType != nil {
		return *m.FsType
	}
	return ""
}

func (m *VsphereVirtualDiskVolumeSource) GetStoragePolicyName() string {
	if m != nil && m.StoragePolicyName != nil {
		return *m.StoragePolicyName
	}
	return ""
}

func (m *VsphereVirtualDiskVolumeSource) GetStoragePolicyID() string {
	if m != nil && m.StoragePolicyID != nil {
		return *m.StoragePolicyID
	}
	return ""
}

// The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)
type WeightedPodAffinityTerm struct {
	// weight associated with matching the corresponding podAffinityTerm,
	// in the range 1-100.
	Weight *int32 `protobuf:"varint,1,opt,name=weight" json:"weight,omitempty"`
	// Required. A pod affinity term, associated with the corresponding weight.
	PodAffinityTerm  *PodAffinityTerm `protobuf:"bytes,2,opt,name=podAffinityTerm" json:"podAffinityTerm,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *WeightedPodAffinityTerm) Reset()         { *m = WeightedPodAffinityTerm{} }
func (m *WeightedPodAffinityTerm) String() string { return proto.CompactTextString(m) }
func (*WeightedPodAffinityTerm) ProtoMessage()    {}
func (*WeightedPodAffinityTerm) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{187}
}

func (m *WeightedPodAffinityTerm) GetWeight() int32 {
	if m != nil && m.Weight != nil {
		return *m.Weight
	}
	return 0
}

func (m *WeightedPodAffinityTerm) GetPodAffinityTerm() *PodAffinityTerm {
	if m != nil {
		return m.PodAffinityTerm
	}
	return nil
}

func init() {
	proto.RegisterType((*AWSElasticBlockStoreVolumeSource)(nil), "k8s.io.api.core.v1.AWSElasticBlockStoreVolumeSource")
	proto.RegisterType((*Affinity)(nil), "k8s.io.api.core.v1.Affinity")
	proto.RegisterType((*AttachedVolume)(nil), "k8s.io.api.core.v1.AttachedVolume")
	proto.RegisterType((*AvoidPods)(nil), "k8s.io.api.core.v1.AvoidPods")
	proto.RegisterType((*AzureDiskVolumeSource)(nil), "k8s.io.api.core.v1.AzureDiskVolumeSource")
	proto.RegisterType((*AzureFilePersistentVolumeSource)(nil), "k8s.io.api.core.v1.AzureFilePersistentVolumeSource")
	proto.RegisterType((*AzureFileVolumeSource)(nil), "k8s.io.api.core.v1.AzureFileVolumeSource")
	proto.RegisterType((*Binding)(nil), "k8s.io.api.core.v1.Binding")
	proto.RegisterType((*CSIPersistentVolumeSource)(nil), "k8s.io.api.core.v1.CSIPersistentVolumeSource")
	proto.RegisterType((*Capabilities)(nil), "k8s.io.api.core.v1.Capabilities")
	proto.RegisterType((*CephFSPersistentVolumeSource)(nil), "k8s.io.api.core.v1.CephFSPersistentVolumeSource")
	proto.RegisterType((*CephFSVolumeSource)(nil), "k8s.io.api.core.v1.CephFSVolumeSource")
	proto.RegisterType((*CinderVolumeSource)(nil), "k8s.io.api.core.v1.CinderVolumeSource")
	proto.RegisterType((*ClientIPConfig)(nil), "k8s.io.api.core.v1.ClientIPConfig")
	proto.RegisterType((*ComponentCondition)(nil), "k8s.io.api.core.v1.ComponentCondition")
	proto.RegisterType((*ComponentStatus)(nil), "k8s.io.api.core.v1.ComponentStatus")
	proto.RegisterType((*ComponentStatusList)(nil), "k8s.io.api.core.v1.ComponentStatusList")
	proto.RegisterType((*ConfigMap)(nil), "k8s.io.api.core.v1.ConfigMap")
	proto.RegisterType((*ConfigMapEnvSource)(nil), "k8s.io.api.core.v1.ConfigMapEnvSource")
	proto.RegisterType((*ConfigMapKeySelector)(nil), "k8s.io.api.core.v1.ConfigMapKeySelector")
	proto.RegisterType((*ConfigMapList)(nil), "k8s.io.api.core.v1.ConfigMapList")
	proto.RegisterType((*ConfigMapProjection)(nil), "k8s.io.api.core.v1.ConfigMapProjection")
	proto.RegisterType((*ConfigMapVolumeSource)(nil), "k8s.io.api.core.v1.ConfigMapVolumeSource")
	proto.RegisterType((*Container)(nil), "k8s.io.api.core.v1.Container")
	proto.RegisterType((*ContainerImage)(nil), "k8s.io.api.core.v1.ContainerImage")
	proto.RegisterType((*ContainerPort)(nil), "k8s.io.api.core.v1.ContainerPort")
	proto.RegisterType((*ContainerState)(nil), "k8s.io.api.core.v1.ContainerState")
	proto.RegisterType((*ContainerStateRunning)(nil), "k8s.io.api.core.v1.ContainerStateRunning")
	proto.RegisterType((*ContainerStateTerminated)(nil), "k8s.io.api.core.v1.ContainerStateTerminated")
	proto.RegisterType((*ContainerStateWaiting)(nil), "k8s.io.api.core.v1.ContainerStateWaiting")
	proto.RegisterType((*ContainerStatus)(nil), "k8s.io.api.core.v1.ContainerStatus")
	proto.RegisterType((*DaemonEndpoint)(nil), "k8s.io.api.core.v1.DaemonEndpoint")
	proto.RegisterType((*DeleteOptions)(nil), "k8s.io.api.core.v1.DeleteOptions")
	proto.RegisterType((*DownwardAPIProjection)(nil), "k8s.io.api.core.v1.DownwardAPIProjection")
	proto.RegisterType((*DownwardAPIVolumeFile)(nil), "k8s.io.api.core.v1.DownwardAPIVolumeFile")
	proto.RegisterType((*DownwardAPIVolumeSource)(nil), "k8s.io.api.core.v1.DownwardAPIVolumeSource")
	proto.RegisterType((*EmptyDirVolumeSource)(nil), "k8s.io.api.core.v1.EmptyDirVolumeSource")
	proto.RegisterType((*EndpointAddress)(nil), "k8s.io.api.core.v1.EndpointAddress")
	proto.RegisterType((*EndpointPort)(nil), "k8s.io.api.core.v1.EndpointPort")
	proto.RegisterType((*EndpointSubset)(nil), "k8s.io.api.core.v1.EndpointSubset")
	proto.RegisterType((*Endpoints)(nil), "k8s.io.api.core.v1.Endpoints")
	proto.RegisterType((*EndpointsList)(nil), "k8s.io.api.core.v1.EndpointsList")
	proto.RegisterType((*EnvFromSource)(nil), "k8s.io.api.core.v1.EnvFromSource")
	proto.RegisterType((*EnvVar)(nil), "k8s.io.api.core.v1.EnvVar")
	proto.RegisterType((*EnvVarSource)(nil), "k8s.io.api.core.v1.EnvVarSource")
	proto.RegisterType((*Event)(nil), "k8s.io.api.core.v1.Event")
	proto.RegisterType((*EventList)(nil), "k8s.io.api.core.v1.EventList")
	proto.RegisterType((*EventSeries)(nil), "k8s.io.api.core.v1.EventSeries")
	proto.RegisterType((*EventSource)(nil), "k8s.io.api.core.v1.EventSource")
	proto.RegisterType((*ExecAction)(nil), "k8s.io.api.core.v1.ExecAction")
	proto.RegisterType((*FCVolumeSource)(nil), "k8s.io.api.core.v1.FCVolumeSource")
	proto.RegisterType((*FlexPersistentVolumeSource)(nil), "k8s.io.api.core.v1.FlexPersistentVolumeSource")
	proto.RegisterType((*FlexVolumeSource)(nil), "k8s.io.api.core.v1.FlexVolumeSource")
	proto.RegisterType((*FlockerVolumeSource)(nil), "k8s.io.api.core.v1.FlockerVolumeSource")
	proto.RegisterType((*GCEPersistentDiskVolumeSource)(nil), "k8s.io.api.core.v1.GCEPersistentDiskVolumeSource")
	proto.RegisterType((*GitRepoVolumeSource)(nil), "k8s.io.api.core.v1.GitRepoVolumeSource")
	proto.RegisterType((*GlusterfsVolumeSource)(nil), "k8s.io.api.core.v1.GlusterfsVolumeSource")
	proto.RegisterType((*HTTPGetAction)(nil), "k8s.io.api.core.v1.HTTPGetAction")
	proto.RegisterType((*HTTPHeader)(nil), "k8s.io.api.core.v1.HTTPHeader")
	proto.RegisterType((*Handler)(nil), "k8s.io.api.core.v1.Handler")
	proto.RegisterType((*HostAlias)(nil), "k8s.io.api.core.v1.HostAlias")
	proto.RegisterType((*HostPathVolumeSource)(nil), "k8s.io.api.core.v1.HostPathVolumeSource")
	proto.RegisterType((*ISCSIPersistentVolumeSource)(nil), "k8s.io.api.core.v1.ISCSIPersistentVolumeSource")
	proto.RegisterType((*ISCSIVolumeSource)(nil), "k8s.io.api.core.v1.ISCSIVolumeSource")
	proto.RegisterType((*KeyToPath)(nil), "k8s.io.api.core.v1.KeyToPath")
	proto.RegisterType((*Lifecycle)(nil), "k8s.io.api.core.v1.Lifecycle")
	proto.RegisterType((*LimitRange)(nil), "k8s.io.api.core.v1.LimitRange")
	proto.RegisterType((*LimitRangeItem)(nil), "k8s.io.api.core.v1.LimitRangeItem")
	proto.RegisterType((*LimitRangeList)(nil), "k8s.io.api.core.v1.LimitRangeList")
	proto.RegisterType((*LimitRangeSpec)(nil), "k8s.io.api.core.v1.LimitRangeSpec")
	proto.RegisterType((*List)(nil), "k8s.io.api.core.v1.List")
	proto.RegisterType((*ListOptions)(nil), "k8s.io.api.core.v1.ListOptions")
	proto.RegisterType((*LoadBalancerIngress)(nil), "k8s.io.api.core.v1.LoadBalancerIngress")
	proto.RegisterType((*LoadBalancerStatus)(nil), "k8s.io.api.core.v1.LoadBalancerStatus")
	proto.RegisterType((*LocalObjectReference)(nil), "k8s.io.api.core.v1.LocalObjectReference")
	proto.RegisterType((*LocalVolumeSource)(nil), "k8s.io.api.core.v1.LocalVolumeSource")
	proto.RegisterType((*NFSVolumeSource)(nil), "k8s.io.api.core.v1.NFSVolumeSource")
	proto.RegisterType((*Namespace)(nil), "k8s.io.api.core.v1.Namespace")
	proto.RegisterType((*NamespaceList)(nil), "k8s.io.api.core.v1.NamespaceList")
	proto.RegisterType((*NamespaceSpec)(nil), "k8s.io.api.core.v1.NamespaceSpec")
	proto.RegisterType((*NamespaceStatus)(nil), "k8s.io.api.core.v1.NamespaceStatus")
	proto.RegisterType((*Node)(nil), "k8s.io.api.core.v1.Node")
	proto.RegisterType((*NodeAddress)(nil), "k8s.io.api.core.v1.NodeAddress")
	proto.RegisterType((*NodeAffinity)(nil), "k8s.io.api.core.v1.NodeAffinity")
	proto.RegisterType((*NodeCondition)(nil), "k8s.io.api.core.v1.NodeCondition")
	proto.RegisterType((*NodeConfigSource)(nil), "k8s.io.api.core.v1.NodeConfigSource")
	proto.RegisterType((*NodeDaemonEndpoints)(nil), "k8s.io.api.core.v1.NodeDaemonEndpoints")
	proto.RegisterType((*NodeList)(nil), "k8s.io.api.core.v1.NodeList")
	proto.RegisterType((*NodeProxyOptions)(nil), "k8s.io.api.core.v1.NodeProxyOptions")
	proto.RegisterType((*NodeResources)(nil), "k8s.io.api.core.v1.NodeResources")
	proto.RegisterType((*NodeSelector)(nil), "k8s.io.api.core.v1.NodeSelector")
	proto.RegisterType((*NodeSelectorRequirement)(nil), "k8s.io.api.core.v1.NodeSelectorRequirement")
	proto.RegisterType((*NodeSelectorTerm)(nil), "k8s.io.api.core.v1.NodeSelectorTerm")
	proto.RegisterType((*NodeSpec)(nil), "k8s.io.api.core.v1.NodeSpec")
	proto.RegisterType((*NodeStatus)(nil), "k8s.io.api.core.v1.NodeStatus")
	proto.RegisterType((*NodeSystemInfo)(nil), "k8s.io.api.core.v1.NodeSystemInfo")
	proto.RegisterType((*ObjectFieldSelector)(nil), "k8s.io.api.core.v1.ObjectFieldSelector")
	proto.RegisterType((*ObjectMeta)(nil), "k8s.io.api.core.v1.ObjectMeta")
	proto.RegisterType((*ObjectReference)(nil), "k8s.io.api.core.v1.ObjectReference")
	proto.RegisterType((*PersistentVolume)(nil), "k8s.io.api.core.v1.PersistentVolume")
	proto.RegisterType((*PersistentVolumeClaim)(nil), "k8s.io.api.core.v1.PersistentVolumeClaim")
	proto.RegisterType((*PersistentVolumeClaimCondition)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimCondition")
	proto.RegisterType((*PersistentVolumeClaimList)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimList")
	proto.RegisterType((*PersistentVolumeClaimSpec)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimSpec")
	proto.RegisterType((*PersistentVolumeClaimStatus)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimStatus")
	proto.RegisterType((*PersistentVolumeClaimVolumeSource)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimVolumeSource")
	proto.RegisterType((*PersistentVolumeList)(nil), "k8s.io.api.core.v1.PersistentVolumeList")
	proto.RegisterType((*PersistentVolumeSource)(nil), "k8s.io.api.core.v1.PersistentVolumeSource")
	proto.RegisterType((*PersistentVolumeSpec)(nil), "k8s.io.api.core.v1.PersistentVolumeSpec")
	proto.RegisterType((*PersistentVolumeStatus)(nil), "k8s.io.api.core.v1.PersistentVolumeStatus")
	proto.RegisterType((*PhotonPersistentDiskVolumeSource)(nil), "k8s.io.api.core.v1.PhotonPersistentDiskVolumeSource")
	proto.RegisterType((*Pod)(nil), "k8s.io.api.core.v1.Pod")
	proto.RegisterType((*PodAffinity)(nil), "k8s.io.api.core.v1.PodAffinity")
	proto.RegisterType((*PodAffinityTerm)(nil), "k8s.io.api.core.v1.PodAffinityTerm")
	proto.RegisterType((*PodAntiAffinity)(nil), "k8s.io.api.core.v1.PodAntiAffinity")
	proto.RegisterType((*PodAttachOptions)(nil), "k8s.io.api.core.v1.PodAttachOptions")
	proto.RegisterType((*PodCondition)(nil), "k8s.io.api.core.v1.PodCondition")
	proto.RegisterType((*PodDNSConfig)(nil), "k8s.io.api.core.v1.PodDNSConfig")
	proto.RegisterType((*PodDNSConfigOption)(nil), "k8s.io.api.core.v1.PodDNSConfigOption")
	proto.RegisterType((*PodExecOptions)(nil), "k8s.io.api.core.v1.PodExecOptions")
	proto.RegisterType((*PodList)(nil), "k8s.io.api.core.v1.PodList")
	proto.RegisterType((*PodLogOptions)(nil), "k8s.io.api.core.v1.PodLogOptions")
	proto.RegisterType((*PodPortForwardOptions)(nil), "k8s.io.api.core.v1.PodPortForwardOptions")
	proto.RegisterType((*PodProxyOptions)(nil), "k8s.io.api.core.v1.PodProxyOptions")
	proto.RegisterType((*PodSecurityContext)(nil), "k8s.io.api.core.v1.PodSecurityContext")
	proto.RegisterType((*PodSignature)(nil), "k8s.io.api.core.v1.PodSignature")
	proto.RegisterType((*PodSpec)(nil), "k8s.io.api.core.v1.PodSpec")
	proto.RegisterType((*PodStatus)(nil), "k8s.io.api.core.v1.PodStatus")
	proto.RegisterType((*PodStatusResult)(nil), "k8s.io.api.core.v1.PodStatusResult")
	proto.RegisterType((*PodTemplate)(nil), "k8s.io.api.core.v1.PodTemplate")
	proto.RegisterType((*PodTemplateList)(nil), "k8s.io.api.core.v1.PodTemplateList")
	proto.RegisterType((*PodTemplateSpec)(nil), "k8s.io.api.core.v1.PodTemplateSpec")
	proto.RegisterType((*PortworxVolumeSource)(nil), "k8s.io.api.core.v1.PortworxVolumeSource")
	proto.RegisterType((*Preconditions)(nil), "k8s.io.api.core.v1.Preconditions")
	proto.RegisterType((*PreferAvoidPodsEntry)(nil), "k8s.io.api.core.v1.PreferAvoidPodsEntry")
	proto.RegisterType((*PreferredSchedulingTerm)(nil), "k8s.io.api.core.v1.PreferredSchedulingTerm")
	proto.RegisterType((*Probe)(nil), "k8s.io.api.core.v1.Probe")
	proto.RegisterType((*ProjectedVolumeSource)(nil), "k8s.io.api.core.v1.ProjectedVolumeSource")
	proto.RegisterType((*QuobyteVolumeSource)(nil), "k8s.io.api.core.v1.QuobyteVolumeSource")
	proto.RegisterType((*RBDPersistentVolumeSource)(nil), "k8s.io.api.core.v1.RBDPersistentVolumeSource")
	proto.RegisterType((*RBDVolumeSource)(nil), "k8s.io.api.core.v1.RBDVolumeSource")
	proto.RegisterType((*RangeAllocation)(nil), "k8s.io.api.core.v1.RangeAllocation")
	proto.RegisterType((*ReplicationController)(nil), "k8s.io.api.core.v1.ReplicationController")
	proto.RegisterType((*ReplicationControllerCondition)(nil), "k8s.io.api.core.v1.ReplicationControllerCondition")
	proto.RegisterType((*ReplicationControllerList)(nil), "k8s.io.api.core.v1.ReplicationControllerList")
	proto.RegisterType((*ReplicationControllerSpec)(nil), "k8s.io.api.core.v1.ReplicationControllerSpec")
	proto.RegisterType((*ReplicationControllerStatus)(nil), "k8s.io.api.core.v1.ReplicationControllerStatus")
	proto.RegisterType((*ResourceFieldSelector)(nil), "k8s.io.api.core.v1.ResourceFieldSelector")
	proto.RegisterType((*ResourceQuota)(nil), "k8s.io.api.core.v1.ResourceQuota")
	proto.RegisterType((*ResourceQuotaList)(nil), "k8s.io.api.core.v1.ResourceQuotaList")
	proto.RegisterType((*ResourceQuotaSpec)(nil), "k8s.io.api.core.v1.ResourceQuotaSpec")
	proto.RegisterType((*ResourceQuotaStatus)(nil), "k8s.io.api.core.v1.ResourceQuotaStatus")
	proto.RegisterType((*ResourceRequirements)(nil), "k8s.io.api.core.v1.ResourceRequirements")
	proto.RegisterType((*SELinuxOptions)(nil), "k8s.io.api.core.v1.SELinuxOptions")
	proto.RegisterType((*ScaleIOPersistentVolumeSource)(nil), "k8s.io.api.core.v1.ScaleIOPersistentVolumeSource")
	proto.RegisterType((*ScaleIOVolumeSource)(nil), "k8s.io.api.core.v1.ScaleIOVolumeSource")
	proto.RegisterType((*Secret)(nil), "k8s.io.api.core.v1.Secret")
	proto.RegisterType((*SecretEnvSource)(nil), "k8s.io.api.core.v1.SecretEnvSource")
	proto.RegisterType((*SecretKeySelector)(nil), "k8s.io.api.core.v1.SecretKeySelector")
	proto.RegisterType((*SecretList)(nil), "k8s.io.api.core.v1.SecretList")
	proto.RegisterType((*SecretProjection)(nil), "k8s.io.api.core.v1.SecretProjection")
	proto.RegisterType((*SecretReference)(nil), "k8s.io.api.core.v1.SecretReference")
	proto.RegisterType((*SecretVolumeSource)(nil), "k8s.io.api.core.v1.SecretVolumeSource")
	proto.RegisterType((*SecurityContext)(nil), "k8s.io.api.core.v1.SecurityContext")
	proto.RegisterType((*SerializedReference)(nil), "k8s.io.api.core.v1.SerializedReference")
	proto.RegisterType((*Service)(nil), "k8s.io.api.core.v1.Service")
	proto.RegisterType((*ServiceAccount)(nil), "k8s.io.api.core.v1.ServiceAccount")
	proto.RegisterType((*ServiceAccountList)(nil), "k8s.io.api.core.v1.ServiceAccountList")
	proto.RegisterType((*ServiceList)(nil), "k8s.io.api.core.v1.ServiceList")
	proto.RegisterType((*ServicePort)(nil), "k8s.io.api.core.v1.ServicePort")
	proto.RegisterType((*ServiceProxyOptions)(nil), "k8s.io.api.core.v1.ServiceProxyOptions")
	proto.RegisterType((*ServiceSpec)(nil), "k8s.io.api.core.v1.ServiceSpec")
	proto.RegisterType((*ServiceStatus)(nil), "k8s.io.api.core.v1.ServiceStatus")
	proto.RegisterType((*SessionAffinityConfig)(nil), "k8s.io.api.core.v1.SessionAffinityConfig")
	proto.RegisterType((*StorageOSPersistentVolumeSource)(nil), "k8s.io.api.core.v1.StorageOSPersistentVolumeSource")
	proto.RegisterType((*StorageOSVolumeSource)(nil), "k8s.io.api.core.v1.StorageOSVolumeSource")
	proto.RegisterType((*Sysctl)(nil), "k8s.io.api.core.v1.Sysctl")
	proto.RegisterType((*TCPSocketAction)(nil), "k8s.io.api.core.v1.TCPSocketAction")
	proto.RegisterType((*Taint)(nil), "k8s.io.api.core.v1.Taint")
	proto.RegisterType((*Toleration)(nil), "k8s.io.api.core.v1.Toleration")
	proto.RegisterType((*Volume)(nil), "k8s.io.api.core.v1.Volume")
	proto.RegisterType((*VolumeDevice)(nil), "k8s.io.api.core.v1.VolumeDevice")
	proto.RegisterType((*VolumeMount)(nil), "k8s.io.api.core.v1.VolumeMount")
	proto.RegisterType((*VolumeNodeAffinity)(nil), "k8s.io.api.core.v1.VolumeNodeAffinity")
	proto.RegisterType((*VolumeProjection)(nil), "k8s.io.api.core.v1.VolumeProjection")
	proto.RegisterType((*VolumeSource)(nil), "k8s.io.api.core.v1.VolumeSource")
	proto.RegisterType((*VsphereVirtualDiskVolumeSource)(nil), "k8s.io.api.core.v1.VsphereVirtualDiskVolumeSource")
	proto.RegisterType((*WeightedPodAffinityTerm)(nil), "k8s.io.api.core.v1.WeightedPodAffinityTerm")
}
func (m *AWSElasticBlockStoreVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AWSElasticBlockStoreVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.VolumeID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeID)))
		i += copy(dAtA[i:], *m.VolumeID)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.Partition != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Partition))
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Affinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Affinity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeAffinity != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.NodeAffinity.Size()))
		n1, err := m.NodeAffinity.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.PodAffinity != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PodAffinity.Size()))
		n2, err := m.PodAffinity.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.PodAntiAffinity != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PodAntiAffinity.Size()))
		n3, err := m.PodAntiAffinity.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AttachedVolume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachedVolume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.DevicePath != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DevicePath)))
		i += copy(dAtA[i:], *m.DevicePath)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AvoidPods) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AvoidPods) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PreferAvoidPods) > 0 {
		for _, msg := range m.PreferAvoidPods {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AzureDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DiskName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DiskName)))
		i += copy(dAtA[i:], *m.DiskName)
	}
	if m.DiskURI != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DiskURI)))
		i += copy(dAtA[i:], *m.DiskURI)
	}
	if m.CachingMode != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.CachingMode)))
		i += copy(dAtA[i:], *m.CachingMode)
	}
	if m.FsType != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x28
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Kind != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Kind)))
		i += copy(dAtA[i:], *m.Kind)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AzureFilePersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureFilePersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SecretName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SecretName)))
		i += copy(dAtA[i:], *m.SecretName)
	}
	if m.ShareName != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ShareName)))
		i += copy(dAtA[i:], *m.ShareName)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SecretNamespace != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SecretNamespace)))
		i += copy(dAtA[i:], *m.SecretNamespace)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AzureFileVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureFileVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SecretName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SecretName)))
		i += copy(dAtA[i:], *m.SecretName)
	}
	if m.ShareName != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ShareName)))
		i += copy(dAtA[i:], *m.ShareName)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Binding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Binding) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n4, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Target != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Target.Size()))
		n5, err := m.Target.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CSIPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSIPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Driver)))
		i += copy(dAtA[i:], *m.Driver)
	}
	if m.VolumeHandle != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeHandle)))
		i += copy(dAtA[i:], *m.VolumeHandle)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.FsType != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if len(m.VolumeAttributes) > 0 {
		for k, _ := range m.VolumeAttributes {
			dAtA[i] = 0x2a
			i++
			v := m.VolumeAttributes[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.ControllerPublishSecretRef != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ControllerPublishSecretRef.Size()))
		n6, err := m.ControllerPublishSecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.NodeStageSecretRef != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.NodeStageSecretRef.Size()))
		n7, err := m.NodeStageSecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.NodePublishSecretRef != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.NodePublishSecretRef.Size()))
		n8, err := m.NodePublishSecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Capabilities) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Capabilities) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Add) > 0 {
		for _, s := range m.Add {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Drop) > 0 {
		for _, s := range m.Drop {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CephFSPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CephFSPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.User != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.SecretFile != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SecretFile)))
		i += copy(dAtA[i:], *m.SecretFile)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n9, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x30
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CephFSVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CephFSVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.User != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.SecretFile != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SecretFile)))
		i += copy(dAtA[i:], *m.SecretFile)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n10, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x30
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CinderVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CinderVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.VolumeID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeID)))
		i += copy(dAtA[i:], *m.VolumeID)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClientIPConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientIPConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TimeoutSeconds != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.TimeoutSeconds))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ComponentCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentCondition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Status)))
		i += copy(dAtA[i:], *m.Status)
	}
	if m.Message != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.Error != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Error)))
		i += copy(dAtA[i:], *m.Error)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ComponentStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n11, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ComponentStatusList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentStatusList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n12, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigMap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n13, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if len(m.Data) > 0 {
		for k, _ := range m.Data {
			dAtA[i] = 0x12
			i++
			v := m.Data[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.BinaryData) > 0 {
		for k, _ := range m.BinaryData {
			dAtA[i] = 0x1a
			i++
			v := m.BinaryData[k]
			byteSize := 0
			if v != nil {
				byteSize = 1 + len(v) + sovGenerated(uint64(len(v)))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + byteSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigMapEnvSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapEnvSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n14, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Optional != nil {
		dAtA[i] = 0x10
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigMapKeySelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapKeySelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n15, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.Key != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Optional != nil {
		dAtA[i] = 0x18
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigMapList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n16, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigMapProjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapProjection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n17, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Optional != nil {
		dAtA[i] = 0x20
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigMapVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n18, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DefaultMode != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.DefaultMode))
	}
	if m.Optional != nil {
		dAtA[i] = 0x20
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Container) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Container) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Image != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Image)))
		i += copy(dAtA[i:], *m.Image)
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.WorkingDir != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.WorkingDir)))
		i += copy(dAtA[i:], *m.WorkingDir)
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0x32
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Env) > 0 {
		for _, msg := range m.Env {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Resources != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Resources.Size()))
		n19, err := m.Resources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.VolumeMounts) > 0 {
		for _, msg := range m.VolumeMounts {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LivenessProbe != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LivenessProbe.Size()))
		n20, err := m.LivenessProbe.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.ReadinessProbe != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ReadinessProbe.Size()))
		n21, err := m.ReadinessProbe.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Lifecycle != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Lifecycle.Size()))
		n22, err := m.Lifecycle.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.TerminationMessagePath != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.TerminationMessagePath)))
		i += copy(dAtA[i:], *m.TerminationMessagePath)
	}
	if m.ImagePullPolicy != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ImagePullPolicy)))
		i += copy(dAtA[i:], *m.ImagePullPolicy)
	}
	if m.SecurityContext != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecurityContext.Size()))
		n23, err := m.SecurityContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.Stdin != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		if *m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.StdinOnce != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		if *m.StdinOnce {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Tty != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		if *m.Tty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.EnvFrom) > 0 {
		for _, msg := range m.EnvFrom {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.TerminationMessagePolicy != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.TerminationMessagePolicy)))
		i += copy(dAtA[i:], *m.TerminationMessagePolicy)
	}
	if len(m.VolumeDevices) > 0 {
		for _, msg := range m.VolumeDevices {
			dAtA[i] = 0xaa
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerImage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerImage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.SizeBytes != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.SizeBytes))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerPort) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.HostPort != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.HostPort))
	}
	if m.ContainerPort != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ContainerPort))
	}
	if m.Protocol != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Protocol)))
		i += copy(dAtA[i:], *m.Protocol)
	}
	if m.HostIP != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.HostIP)))
		i += copy(dAtA[i:], *m.HostIP)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Waiting != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Waiting.Size()))
		n24, err := m.Waiting.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.Running != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Running.Size()))
		n25, err := m.Running.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.Terminated != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Terminated.Size()))
		n26, err := m.Terminated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerStateRunning) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateRunning) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StartedAt != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.StartedAt.Size()))
		n27, err := m.StartedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerStateTerminated) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateTerminated) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ExitCode != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ExitCode))
	}
	if m.Signal != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Signal))
	}
	if m.Reason != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.StartedAt != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.StartedAt.Size()))
		n28, err := m.StartedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.FinishedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.FinishedAt.Size()))
		n29, err := m.FinishedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.ContainerID != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ContainerID)))
		i += copy(dAtA[i:], *m.ContainerID)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerStateWaiting) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateWaiting) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Reason != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.State != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.State.Size()))
		n30, err := m.State.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.LastState != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastState.Size()))
		n31, err := m.LastState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.Ready != nil {
		dAtA[i] = 0x20
		i++
		if *m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RestartCount != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.RestartCount))
	}
	if m.Image != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Image)))
		i += copy(dAtA[i:], *m.Image)
	}
	if m.ImageID != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ImageID)))
		i += copy(dAtA[i:], *m.ImageID)
	}
	if m.ContainerID != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ContainerID)))
		i += copy(dAtA[i:], *m.ContainerID)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DaemonEndpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DaemonEndpoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Port))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DeleteOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GracePeriodSeconds != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.GracePeriodSeconds))
	}
	if m.Preconditions != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Preconditions.Size()))
		n32, err := m.Preconditions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.OrphanDependents != nil {
		dAtA[i] = 0x18
		i++
		if *m.OrphanDependents {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PropagationPolicy != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PropagationPolicy)))
		i += copy(dAtA[i:], *m.PropagationPolicy)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownwardAPIProjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownwardAPIProjection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownwardAPIVolumeFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownwardAPIVolumeFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.FieldRef != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.FieldRef.Size()))
		n33, err := m.FieldRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.ResourceFieldRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ResourceFieldRef.Size()))
		n34, err := m.ResourceFieldRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.Mode != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownwardAPIVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownwardAPIVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DefaultMode != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.DefaultMode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EmptyDirVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmptyDirVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Medium != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Medium)))
		i += copy(dAtA[i:], *m.Medium)
	}
	if m.SizeLimit != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SizeLimit.Size()))
		n35, err := m.SizeLimit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EndpointAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Ip != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Ip)))
		i += copy(dAtA[i:], *m.Ip)
	}
	if m.TargetRef != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.TargetRef.Size()))
		n36, err := m.TargetRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.Hostname != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.NodeName != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.NodeName)))
		i += copy(dAtA[i:], *m.NodeName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EndpointPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointPort) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Port != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Port))
	}
	if m.Protocol != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Protocol)))
		i += copy(dAtA[i:], *m.Protocol)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EndpointSubset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointSubset) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addresses) > 0 {
		for _, msg := range m.Addresses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.NotReadyAddresses) > 0 {
		for _, msg := range m.NotReadyAddresses {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Endpoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Endpoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n37, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if len(m.Subsets) > 0 {
		for _, msg := range m.Subsets {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EndpointsList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointsList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n38, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EnvFromSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvFromSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Prefix != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Prefix)))
		i += copy(dAtA[i:], *m.Prefix)
	}
	if m.ConfigMapRef != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ConfigMapRef.Size()))
		n39, err := m.ConfigMapRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n40, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EnvVar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvVar) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.ValueFrom != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ValueFrom.Size()))
		n41, err := m.ValueFrom.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EnvVarSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvVarSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FieldRef != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.FieldRef.Size()))
		n42, err := m.FieldRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.ResourceFieldRef != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ResourceFieldRef.Size()))
		n43, err := m.ResourceFieldRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.ConfigMapKeyRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ConfigMapKeyRef.Size()))
		n44, err := m.ConfigMapKeyRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	if m.SecretKeyRef != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretKeyRef.Size()))
		n45, err := m.SecretKeyRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n46, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	if m.InvolvedObject != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.InvolvedObject.Size()))
		n47, err := m.InvolvedObject.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.Reason != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.Source != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Source.Size()))
		n48, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	if m.FirstTimestamp != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.FirstTimestamp.Size()))
		n49, err := m.FirstTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	if m.LastTimestamp != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastTimestamp.Size()))
		n50, err := m.LastTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n50
	}
	if m.Count != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Count))
	}
	if m.Type != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.EventTime != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.EventTime.Size()))
		n51, err := m.EventTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.Series != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Series.Size()))
		n52, err := m.Series.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if m.Action != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Action)))
		i += copy(dAtA[i:], *m.Action)
	}
	if m.Related != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Related.Size()))
		n53, err := m.Related.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n53
	}
	if m.ReportingComponent != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ReportingComponent)))
		i += copy(dAtA[i:], *m.ReportingComponent)
	}
	if m.ReportingInstance != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ReportingInstance)))
		i += copy(dAtA[i:], *m.ReportingInstance)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n54, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n54
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EventSeries) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventSeries) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Count != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Count))
	}
	if m.LastObservedTime != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastObservedTime.Size()))
		n55, err := m.LastObservedTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	if m.State != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.State)))
		i += copy(dAtA[i:], *m.State)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EventSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Component != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Component)))
		i += copy(dAtA[i:], *m.Component)
	}
	if m.Host != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Host)))
		i += copy(dAtA[i:], *m.Host)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExecAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FCVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FCVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TargetWWNs) > 0 {
		for _, s := range m.TargetWWNs {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Lun != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Lun))
	}
	if m.FsType != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Wwids) > 0 {
		for _, s := range m.Wwids {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FlexPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlexPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Driver)))
		i += copy(dAtA[i:], *m.Driver)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n56, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n56
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			dAtA[i] = 0x2a
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FlexVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlexVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Driver)))
		i += copy(dAtA[i:], *m.Driver)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n57, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n57
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			dAtA[i] = 0x2a
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FlockerVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlockerVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DatasetName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DatasetName)))
		i += copy(dAtA[i:], *m.DatasetName)
	}
	if m.DatasetUUID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DatasetUUID)))
		i += copy(dAtA[i:], *m.DatasetUUID)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GCEPersistentDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCEPersistentDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PdName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PdName)))
		i += copy(dAtA[i:], *m.PdName)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.Partition != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Partition))
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GitRepoVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitRepoVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Repository != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Repository)))
		i += copy(dAtA[i:], *m.Repository)
	}
	if m.Revision != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Revision)))
		i += copy(dAtA[i:], *m.Revision)
	}
	if m.Directory != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Directory)))
		i += copy(dAtA[i:], *m.Directory)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GlusterfsVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlusterfsVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Endpoints != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Endpoints)))
		i += copy(dAtA[i:], *m.Endpoints)
	}
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HTTPGetAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPGetAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.Port != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Port.Size()))
		n58, err := m.Port.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n58
	}
	if m.Host != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Host)))
		i += copy(dAtA[i:], *m.Host)
	}
	if m.Scheme != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Scheme)))
		i += copy(dAtA[i:], *m.Scheme)
	}
	if len(m.HttpHeaders) > 0 {
		for _, msg := range m.HttpHeaders {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HTTPHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Handler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Handler) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Exec != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Exec.Size()))
		n59, err := m.Exec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n59
	}
	if m.HttpGet != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.HttpGet.Size()))
		n60, err := m.HttpGet.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n60
	}
	if m.TcpSocket != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.TcpSocket.Size()))
		n61, err := m.TcpSocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n61
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HostAlias) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HostAlias) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Ip != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Ip)))
		i += copy(dAtA[i:], *m.Ip)
	}
	if len(m.Hostnames) > 0 {
		for _, s := range m.Hostnames {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HostPathVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HostPathVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.Type != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ISCSIPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ISCSIPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TargetPortal != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.TargetPortal)))
		i += copy(dAtA[i:], *m.TargetPortal)
	}
	if m.Iqn != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Iqn)))
		i += copy(dAtA[i:], *m.Iqn)
	}
	if m.Lun != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Lun))
	}
	if m.IscsiInterface != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.IscsiInterface)))
		i += copy(dAtA[i:], *m.IscsiInterface)
	}
	if m.FsType != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x30
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Portals) > 0 {
		for _, s := range m.Portals {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ChapAuthDiscovery != nil {
		dAtA[i] = 0x40
		i++
		if *m.ChapAuthDiscovery {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n62, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n62
	}
	if m.ChapAuthSession != nil {
		dAtA[i] = 0x58
		i++
		if *m.ChapAuthSession {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.InitiatorName != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.InitiatorName)))
		i += copy(dAtA[i:], *m.InitiatorName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ISCSIVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ISCSIVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TargetPortal != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.TargetPortal)))
		i += copy(dAtA[i:], *m.TargetPortal)
	}
	if m.Iqn != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Iqn)))
		i += copy(dAtA[i:], *m.Iqn)
	}
	if m.Lun != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Lun))
	}
	if m.IscsiInterface != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.IscsiInterface)))
		i += copy(dAtA[i:], *m.IscsiInterface)
	}
	if m.FsType != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x30
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Portals) > 0 {
		for _, s := range m.Portals {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ChapAuthDiscovery != nil {
		dAtA[i] = 0x40
		i++
		if *m.ChapAuthDiscovery {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n63, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n63
	}
	if m.ChapAuthSession != nil {
		dAtA[i] = 0x58
		i++
		if *m.ChapAuthSession {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.InitiatorName != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.InitiatorName)))
		i += copy(dAtA[i:], *m.InitiatorName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *KeyToPath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyToPath) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.Mode != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Lifecycle) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Lifecycle) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PostStart != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PostStart.Size()))
		n64, err := m.PostStart.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n64
	}
	if m.PreStop != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PreStop.Size()))
		n65, err := m.PreStop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n65
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LimitRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRange) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n66, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n66
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n67, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n67
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LimitRangeItem) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeItem) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if len(m.Max) > 0 {
		for k, _ := range m.Max {
			dAtA[i] = 0x12
			i++
			v := m.Max[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n68, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n68
			}
		}
	}
	if len(m.Min) > 0 {
		for k, _ := range m.Min {
			dAtA[i] = 0x1a
			i++
			v := m.Min[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n69, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n69
			}
		}
	}
	if len(m.Default) > 0 {
		for k, _ := range m.Default {
			dAtA[i] = 0x22
			i++
			v := m.Default[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n70, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n70
			}
		}
	}
	if len(m.DefaultRequest) > 0 {
		for k, _ := range m.DefaultRequest {
			dAtA[i] = 0x2a
			i++
			v := m.DefaultRequest[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n71, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n71
			}
		}
	}
	if len(m.MaxLimitRequestRatio) > 0 {
		for k, _ := range m.MaxLimitRequestRatio {
			dAtA[i] = 0x32
			i++
			v := m.MaxLimitRequestRatio[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n72, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n72
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LimitRangeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n73, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n73
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LimitRangeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, msg := range m.Limits {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *List) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *List) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n74, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n74
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LabelSelector != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.LabelSelector)))
		i += copy(dAtA[i:], *m.LabelSelector)
	}
	if m.FieldSelector != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FieldSelector)))
		i += copy(dAtA[i:], *m.FieldSelector)
	}
	if m.Watch != nil {
		dAtA[i] = 0x18
		i++
		if *m.Watch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ResourceVersion != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ResourceVersion)))
		i += copy(dAtA[i:], *m.ResourceVersion)
	}
	if m.TimeoutSeconds != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.TimeoutSeconds))
	}
	if m.IncludeUninitialized != nil {
		dAtA[i] = 0x30
		i++
		if *m.IncludeUninitialized {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LoadBalancerIngress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerIngress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Ip != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Ip)))
		i += copy(dAtA[i:], *m.Ip)
	}
	if m.Hostname != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LoadBalancerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ingress) > 0 {
		for _, msg := range m.Ingress {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalObjectReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalObjectReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NFSVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NFSVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Server != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Server)))
		i += copy(dAtA[i:], *m.Server)
	}
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Namespace) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n75, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n75
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n76, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n76
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n77, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n77
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NamespaceList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n78, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n78
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NamespaceSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Finalizers) > 0 {
		for _, s := range m.Finalizers {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NamespaceStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Phase != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Phase)))
		i += copy(dAtA[i:], *m.Phase)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n79, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n79
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n80, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n80
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n81, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n81
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Address != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Address)))
		i += copy(dAtA[i:], *m.Address)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeAffinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeAffinity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.RequiredDuringSchedulingIgnoredDuringExecution.Size()))
		n82, err := m.RequiredDuringSchedulingIgnoredDuringExecution.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n82
	}
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, msg := range m.PreferredDuringSchedulingIgnoredDuringExecution {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeCondition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Status)))
		i += copy(dAtA[i:], *m.Status)
	}
	if m.LastHeartbeatTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastHeartbeatTime.Size()))
		n83, err := m.LastHeartbeatTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n83
	}
	if m.LastTransitionTime != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastTransitionTime.Size()))
		n84, err := m.LastTransitionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n84
	}
	if m.Reason != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeConfigSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ConfigMapRef != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ConfigMapRef.Size()))
		n85, err := m.ConfigMapRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n85
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeDaemonEndpoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeDaemonEndpoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.KubeletEndpoint != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.KubeletEndpoint.Size()))
		n86, err := m.KubeletEndpoint.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n86
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n87, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n87
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeProxyOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeProxyOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k, _ := range m.Capacity {
			dAtA[i] = 0xa
			i++
			v := m.Capacity[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n88, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n88
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeSelectorTerms) > 0 {
		for _, msg := range m.NodeSelectorTerms {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeSelectorRequirement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelectorRequirement) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Operator != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Operator)))
		i += copy(dAtA[i:], *m.Operator)
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeSelectorTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelectorTerm) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.MatchExpressions) > 0 {
		for _, msg := range m.MatchExpressions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PodCIDR != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PodCIDR)))
		i += copy(dAtA[i:], *m.PodCIDR)
	}
	if m.ExternalID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ExternalID)))
		i += copy(dAtA[i:], *m.ExternalID)
	}
	if m.ProviderID != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ProviderID)))
		i += copy(dAtA[i:], *m.ProviderID)
	}
	if m.Unschedulable != nil {
		dAtA[i] = 0x20
		i++
		if *m.Unschedulable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Taints) > 0 {
		for _, msg := range m.Taints {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ConfigSource != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ConfigSource.Size()))
		n89, err := m.ConfigSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n89
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k, _ := range m.Capacity {
			dAtA[i] = 0xa
			i++
			v := m.Capacity[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n90, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n90
			}
		}
	}
	if len(m.Allocatable) > 0 {
		for k, _ := range m.Allocatable {
			dAtA[i] = 0x12
			i++
			v := m.Allocatable[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n91, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n91
			}
		}
	}
	if m.Phase != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Phase)))
		i += copy(dAtA[i:], *m.Phase)
	}
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0x22
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Addresses) > 0 {
		for _, msg := range m.Addresses {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DaemonEndpoints != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DaemonEndpoints.Size()))
		n92, err := m.DaemonEndpoints.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n92
	}
	if m.NodeInfo != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.NodeInfo.Size()))
		n93, err := m.NodeInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n93
	}
	if len(m.Images) > 0 {
		for _, msg := range m.Images {
			dAtA[i] = 0x42
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.VolumesInUse) > 0 {
		for _, s := range m.VolumesInUse {
			dAtA[i] = 0x4a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.VolumesAttached) > 0 {
		for _, msg := range m.VolumesAttached {
			dAtA[i] = 0x52
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeSystemInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSystemInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MachineID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.MachineID)))
		i += copy(dAtA[i:], *m.MachineID)
	}
	if m.SystemUUID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SystemUUID)))
		i += copy(dAtA[i:], *m.SystemUUID)
	}
	if m.BootID != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.BootID)))
		i += copy(dAtA[i:], *m.BootID)
	}
	if m.KernelVersion != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.KernelVersion)))
		i += copy(dAtA[i:], *m.KernelVersion)
	}
	if m.OsImage != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.OsImage)))
		i += copy(dAtA[i:], *m.OsImage)
	}
	if m.ContainerRuntimeVersion != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ContainerRuntimeVersion)))
		i += copy(dAtA[i:], *m.ContainerRuntimeVersion)
	}
	if m.KubeletVersion != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.KubeletVersion)))
		i += copy(dAtA[i:], *m.KubeletVersion)
	}
	if m.KubeProxyVersion != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.KubeProxyVersion)))
		i += copy(dAtA[i:], *m.KubeProxyVersion)
	}
	if m.OperatingSystem != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.OperatingSystem)))
		i += copy(dAtA[i:], *m.OperatingSystem)
	}
	if m.Architecture != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Architecture)))
		i += copy(dAtA[i:], *m.Architecture)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ObjectFieldSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObjectFieldSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ApiVersion != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ApiVersion)))
		i += copy(dAtA[i:], *m.ApiVersion)
	}
	if m.FieldPath != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FieldPath)))
		i += copy(dAtA[i:], *m.FieldPath)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ObjectMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObjectMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.GenerateName != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.GenerateName)))
		i += copy(dAtA[i:], *m.GenerateName)
	}
	if m.Namespace != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Namespace)))
		i += copy(dAtA[i:], *m.Namespace)
	}
	if m.SelfLink != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SelfLink)))
		i += copy(dAtA[i:], *m.SelfLink)
	}
	if m.Uid != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Uid)))
		i += copy(dAtA[i:], *m.Uid)
	}
	if m.ResourceVersion != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ResourceVersion)))
		i += copy(dAtA[i:], *m.ResourceVersion)
	}
	if m.Generation != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Generation))
	}
	if m.CreationTimestamp != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.CreationTimestamp.Size()))
		n94, err := m.CreationTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n94
	}
	if m.DeletionTimestamp != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DeletionTimestamp.Size()))
		n95, err := m.DeletionTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n95
	}
	if m.DeletionGracePeriodSeconds != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.DeletionGracePeriodSeconds))
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x5a
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Annotations) > 0 {
		for k, _ := range m.Annotations {
			dAtA[i] = 0x62
			i++
			v := m.Annotations[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.OwnerReferences) > 0 {
		for _, msg := range m.OwnerReferences {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Finalizers) > 0 {
		for _, s := range m.Finalizers {
			dAtA[i] = 0x72
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ClusterName != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ClusterName)))
		i += copy(dAtA[i:], *m.ClusterName)
	}
	if m.Initializers != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Initializers.Size()))
		n96, err := m.Initializers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n96
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ObjectReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObjectReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Kind != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Kind)))
		i += copy(dAtA[i:], *m.Kind)
	}
	if m.Namespace != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Namespace)))
		i += copy(dAtA[i:], *m.Namespace)
	}
	if m.Name != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Uid != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Uid)))
		i += copy(dAtA[i:], *m.Uid)
	}
	if m.ApiVersion != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ApiVersion)))
		i += copy(dAtA[i:], *m.ApiVersion)
	}
	if m.ResourceVersion != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ResourceVersion)))
		i += copy(dAtA[i:], *m.ResourceVersion)
	}
	if m.FieldPath != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FieldPath)))
		i += copy(dAtA[i:], *m.FieldPath)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n97, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n97
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n98, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n98
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n99, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n99
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeClaim) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaim) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n100, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n100
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n101, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n101
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n102, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n102
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeClaimCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimCondition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Status)))
		i += copy(dAtA[i:], *m.Status)
	}
	if m.LastProbeTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastProbeTime.Size()))
		n103, err := m.LastProbeTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n103
	}
	if m.LastTransitionTime != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastTransitionTime.Size()))
		n104, err := m.LastTransitionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n104
	}
	if m.Reason != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeClaimList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n105, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n105
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeClaimSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AccessModes) > 0 {
		for _, s := range m.AccessModes {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Resources != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Resources.Size()))
		n106, err := m.Resources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n106
	}
	if m.VolumeName != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeName)))
		i += copy(dAtA[i:], *m.VolumeName)
	}
	if m.Selector != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Selector.Size()))
		n107, err := m.Selector.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n107
	}
	if m.StorageClassName != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StorageClassName)))
		i += copy(dAtA[i:], *m.StorageClassName)
	}
	if m.VolumeMode != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeMode)))
		i += copy(dAtA[i:], *m.VolumeMode)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeClaimStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Phase != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Phase)))
		i += copy(dAtA[i:], *m.Phase)
	}
	if len(m.AccessModes) > 0 {
		for _, s := range m.AccessModes {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Capacity) > 0 {
		for k, _ := range m.Capacity {
			dAtA[i] = 0x1a
			i++
			v := m.Capacity[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n108, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n108
			}
		}
	}
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0x22
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeClaimVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeClaimVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClaimName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ClaimName)))
		i += copy(dAtA[i:], *m.ClaimName)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x10
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n109, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n109
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GcePersistentDisk != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.GcePersistentDisk.Size()))
		n110, err := m.GcePersistentDisk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n110
	}
	if m.AwsElasticBlockStore != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AwsElasticBlockStore.Size()))
		n111, err := m.AwsElasticBlockStore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n111
	}
	if m.HostPath != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.HostPath.Size()))
		n112, err := m.HostPath.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n112
	}
	if m.Glusterfs != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Glusterfs.Size()))
		n113, err := m.Glusterfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n113
	}
	if m.Nfs != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Nfs.Size()))
		n114, err := m.Nfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n114
	}
	if m.Rbd != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Rbd.Size()))
		n115, err := m.Rbd.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n115
	}
	if m.Iscsi != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Iscsi.Size()))
		n116, err := m.Iscsi.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n116
	}
	if m.Cinder != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Cinder.Size()))
		n117, err := m.Cinder.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n117
	}
	if m.Cephfs != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Cephfs.Size()))
		n118, err := m.Cephfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n118
	}
	if m.Fc != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Fc.Size()))
		n119, err := m.Fc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n119
	}
	if m.Flocker != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Flocker.Size()))
		n120, err := m.Flocker.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n120
	}
	if m.FlexVolume != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.FlexVolume.Size()))
		n121, err := m.FlexVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n121
	}
	if m.AzureFile != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AzureFile.Size()))
		n122, err := m.AzureFile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n122
	}
	if m.VsphereVolume != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.VsphereVolume.Size()))
		n123, err := m.VsphereVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n123
	}
	if m.Quobyte != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Quobyte.Size()))
		n124, err := m.Quobyte.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n124
	}
	if m.AzureDisk != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AzureDisk.Size()))
		n125, err := m.AzureDisk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n125
	}
	if m.PhotonPersistentDisk != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PhotonPersistentDisk.Size()))
		n126, err := m.PhotonPersistentDisk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n126
	}
	if m.PortworxVolume != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PortworxVolume.Size()))
		n127, err := m.PortworxVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n127
	}
	if m.ScaleIO != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ScaleIO.Size()))
		n128, err := m.ScaleIO.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n128
	}
	if m.Local != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Local.Size()))
		n129, err := m.Local.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n129
	}
	if m.Storageos != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Storageos.Size()))
		n130, err := m.Storageos.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n130
	}
	if m.Csi != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Csi.Size()))
		n131, err := m.Csi.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n131
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k, _ := range m.Capacity {
			dAtA[i] = 0xa
			i++
			v := m.Capacity[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n132, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n132
			}
		}
	}
	if m.PersistentVolumeSource != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PersistentVolumeSource.Size()))
		n133, err := m.PersistentVolumeSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n133
	}
	if len(m.AccessModes) > 0 {
		for _, s := range m.AccessModes {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ClaimRef != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ClaimRef.Size()))
		n134, err := m.ClaimRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n134
	}
	if m.PersistentVolumeReclaimPolicy != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PersistentVolumeReclaimPolicy)))
		i += copy(dAtA[i:], *m.PersistentVolumeReclaimPolicy)
	}
	if m.StorageClassName != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StorageClassName)))
		i += copy(dAtA[i:], *m.StorageClassName)
	}
	if len(m.MountOptions) > 0 {
		for _, s := range m.MountOptions {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.VolumeMode != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeMode)))
		i += copy(dAtA[i:], *m.VolumeMode)
	}
	if m.NodeAffinity != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.NodeAffinity.Size()))
		n135, err := m.NodeAffinity.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n135
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PersistentVolumeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentVolumeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Phase != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Phase)))
		i += copy(dAtA[i:], *m.Phase)
	}
	if m.Message != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.Reason != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PhotonPersistentDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PhotonPersistentDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PdID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PdID)))
		i += copy(dAtA[i:], *m.PdID)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Pod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pod) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n136, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n136
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n137, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n137
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n138, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n138
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodAffinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodAffinity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RequiredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, msg := range m.RequiredDuringSchedulingIgnoredDuringExecution {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, msg := range m.PreferredDuringSchedulingIgnoredDuringExecution {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodAffinityTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodAffinityTerm) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LabelSelector != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LabelSelector.Size()))
		n139, err := m.LabelSelector.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n139
	}
	if len(m.Namespaces) > 0 {
		for _, s := range m.Namespaces {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.TopologyKey != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.TopologyKey)))
		i += copy(dAtA[i:], *m.TopologyKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodAntiAffinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodAntiAffinity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RequiredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, msg := range m.RequiredDuringSchedulingIgnoredDuringExecution {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, msg := range m.PreferredDuringSchedulingIgnoredDuringExecution {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodAttachOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodAttachOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Stdin != nil {
		dAtA[i] = 0x8
		i++
		if *m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Stdout != nil {
		dAtA[i] = 0x10
		i++
		if *m.Stdout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Stderr != nil {
		dAtA[i] = 0x18
		i++
		if *m.Stderr {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Tty != nil {
		dAtA[i] = 0x20
		i++
		if *m.Tty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Container != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Container)))
		i += copy(dAtA[i:], *m.Container)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodCondition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Status)))
		i += copy(dAtA[i:], *m.Status)
	}
	if m.LastProbeTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastProbeTime.Size()))
		n140, err := m.LastProbeTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n140
	}
	if m.LastTransitionTime != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastTransitionTime.Size()))
		n141, err := m.LastTransitionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n141
	}
	if m.Reason != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodDNSConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodDNSConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nameservers) > 0 {
		for _, s := range m.Nameservers {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Searches) > 0 {
		for _, s := range m.Searches {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Options) > 0 {
		for _, msg := range m.Options {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodDNSConfigOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodDNSConfigOption) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodExecOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodExecOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Stdin != nil {
		dAtA[i] = 0x8
		i++
		if *m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Stdout != nil {
		dAtA[i] = 0x10
		i++
		if *m.Stdout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Stderr != nil {
		dAtA[i] = 0x18
		i++
		if *m.Stderr {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Tty != nil {
		dAtA[i] = 0x20
		i++
		if *m.Tty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Container != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Container)))
		i += copy(dAtA[i:], *m.Container)
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n142, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n142
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodLogOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodLogOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Container != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Container)))
		i += copy(dAtA[i:], *m.Container)
	}
	if m.Follow != nil {
		dAtA[i] = 0x10
		i++
		if *m.Follow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Previous != nil {
		dAtA[i] = 0x18
		i++
		if *m.Previous {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SinceSeconds != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.SinceSeconds))
	}
	if m.SinceTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SinceTime.Size()))
		n143, err := m.SinceTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n143
	}
	if m.Timestamps != nil {
		dAtA[i] = 0x30
		i++
		if *m.Timestamps {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.TailLines != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.TailLines))
	}
	if m.LimitBytes != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.LimitBytes))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodPortForwardOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodPortForwardOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, num := range m.Ports {
			dAtA[i] = 0x8
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(num))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodProxyOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodProxyOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodSecurityContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSecurityContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SeLinuxOptions != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SeLinuxOptions.Size()))
		n144, err := m.SeLinuxOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n144
	}
	if m.RunAsUser != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.RunAsUser))
	}
	if m.RunAsNonRoot != nil {
		dAtA[i] = 0x18
		i++
		if *m.RunAsNonRoot {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SupplementalGroups) > 0 {
		for _, num := range m.SupplementalGroups {
			dAtA[i] = 0x20
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(num))
		}
	}
	if m.FsGroup != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.FsGroup))
	}
	if m.RunAsGroup != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.RunAsGroup))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodSignature) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSignature) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PodController != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PodController.Size()))
		n145, err := m.PodController.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n145
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Containers) > 0 {
		for _, msg := range m.Containers {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.RestartPolicy != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.RestartPolicy)))
		i += copy(dAtA[i:], *m.RestartPolicy)
	}
	if m.TerminationGracePeriodSeconds != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.TerminationGracePeriodSeconds))
	}
	if m.ActiveDeadlineSeconds != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ActiveDeadlineSeconds))
	}
	if m.DnsPolicy != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DnsPolicy)))
		i += copy(dAtA[i:], *m.DnsPolicy)
	}
	if len(m.NodeSelector) > 0 {
		for k, _ := range m.NodeSelector {
			dAtA[i] = 0x3a
			i++
			v := m.NodeSelector[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.ServiceAccountName != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ServiceAccountName)))
		i += copy(dAtA[i:], *m.ServiceAccountName)
	}
	if m.ServiceAccount != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ServiceAccount)))
		i += copy(dAtA[i:], *m.ServiceAccount)
	}
	if m.NodeName != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.NodeName)))
		i += copy(dAtA[i:], *m.NodeName)
	}
	if m.HostNetwork != nil {
		dAtA[i] = 0x58
		i++
		if *m.HostNetwork {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.HostPID != nil {
		dAtA[i] = 0x60
		i++
		if *m.HostPID {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.HostIPC != nil {
		dAtA[i] = 0x68
		i++
		if *m.HostIPC {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SecurityContext != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecurityContext.Size()))
		n146, err := m.SecurityContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n146
	}
	if len(m.ImagePullSecrets) > 0 {
		for _, msg := range m.ImagePullSecrets {
			dAtA[i] = 0x7a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Hostname != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.Subdomain != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Subdomain)))
		i += copy(dAtA[i:], *m.Subdomain)
	}
	if m.Affinity != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Affinity.Size()))
		n147, err := m.Affinity.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n147
	}
	if m.SchedulerName != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SchedulerName)))
		i += copy(dAtA[i:], *m.SchedulerName)
	}
	if len(m.InitContainers) > 0 {
		for _, msg := range m.InitContainers {
			dAtA[i] = 0xa2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AutomountServiceAccountToken != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x1
		i++
		if *m.AutomountServiceAccountToken {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Tolerations) > 0 {
		for _, msg := range m.Tolerations {
			dAtA[i] = 0xb2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HostAliases) > 0 {
		for _, msg := range m.HostAliases {
			dAtA[i] = 0xba
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.PriorityClassName != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PriorityClassName)))
		i += copy(dAtA[i:], *m.PriorityClassName)
	}
	if m.Priority != nil {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Priority))
	}
	if m.DnsConfig != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DnsConfig.Size()))
		n148, err := m.DnsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n148
	}
	if m.ShareProcessNamespace != nil {
		dAtA[i] = 0xd8
		i++
		dAtA[i] = 0x1
		i++
		if *m.ShareProcessNamespace {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Phase != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Phase)))
		i += copy(dAtA[i:], *m.Phase)
	}
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Message != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.Reason != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.HostIP != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.HostIP)))
		i += copy(dAtA[i:], *m.HostIP)
	}
	if m.PodIP != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.PodIP)))
		i += copy(dAtA[i:], *m.PodIP)
	}
	if m.StartTime != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.StartTime.Size()))
		n149, err := m.StartTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n149
	}
	if len(m.ContainerStatuses) > 0 {
		for _, msg := range m.ContainerStatuses {
			dAtA[i] = 0x42
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.QosClass != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.QosClass)))
		i += copy(dAtA[i:], *m.QosClass)
	}
	if len(m.InitContainerStatuses) > 0 {
		for _, msg := range m.InitContainerStatuses {
			dAtA[i] = 0x52
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.NominatedNodeName != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.NominatedNodeName)))
		i += copy(dAtA[i:], *m.NominatedNodeName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodStatusResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodStatusResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n150, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n150
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n151, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n151
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodTemplate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodTemplate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n152, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n152
	}
	if m.Template != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Template.Size()))
		n153, err := m.Template.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n153
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodTemplateList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodTemplateList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n154, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n154
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PodTemplateSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodTemplateSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n155, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n155
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n156, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n156
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PortworxVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortworxVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.VolumeID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeID)))
		i += copy(dAtA[i:], *m.VolumeID)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Preconditions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Preconditions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Uid != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Uid)))
		i += copy(dAtA[i:], *m.Uid)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PreferAvoidPodsEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PreferAvoidPodsEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PodSignature != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PodSignature.Size()))
		n157, err := m.PodSignature.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n157
	}
	if m.EvictionTime != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.EvictionTime.Size()))
		n158, err := m.EvictionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n158
	}
	if m.Reason != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PreferredSchedulingTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PreferredSchedulingTerm) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Weight != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Weight))
	}
	if m.Preference != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Preference.Size()))
		n159, err := m.Preference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n159
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Probe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Probe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Handler != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Handler.Size()))
		n160, err := m.Handler.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n160
	}
	if m.InitialDelaySeconds != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.InitialDelaySeconds))
	}
	if m.TimeoutSeconds != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.TimeoutSeconds))
	}
	if m.PeriodSeconds != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.PeriodSeconds))
	}
	if m.SuccessThreshold != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.SuccessThreshold))
	}
	if m.FailureThreshold != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.FailureThreshold))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProjectedVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProjectedVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sources) > 0 {
		for _, msg := range m.Sources {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DefaultMode != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.DefaultMode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *QuobyteVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuobyteVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Registry != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Registry)))
		i += copy(dAtA[i:], *m.Registry)
	}
	if m.Volume != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Volume)))
		i += copy(dAtA[i:], *m.Volume)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x18
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.User != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.Group != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Group)))
		i += copy(dAtA[i:], *m.Group)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RBDPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RBDPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Image != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Image)))
		i += copy(dAtA[i:], *m.Image)
	}
	if m.FsType != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.Pool != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Pool)))
		i += copy(dAtA[i:], *m.Pool)
	}
	if m.User != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.Keyring != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Keyring)))
		i += copy(dAtA[i:], *m.Keyring)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n161, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n161
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x40
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RBDVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RBDVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Image != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Image)))
		i += copy(dAtA[i:], *m.Image)
	}
	if m.FsType != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.Pool != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Pool)))
		i += copy(dAtA[i:], *m.Pool)
	}
	if m.User != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.Keyring != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Keyring)))
		i += copy(dAtA[i:], *m.Keyring)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n162, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n162
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x40
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RangeAllocation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeAllocation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n163, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n163
	}
	if m.Range != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Range)))
		i += copy(dAtA[i:], *m.Range)
	}
	if m.Data != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReplicationController) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationController) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n164, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n164
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n165, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n165
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n166, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n166
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReplicationControllerCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationControllerCondition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Status)))
		i += copy(dAtA[i:], *m.Status)
	}
	if m.LastTransitionTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastTransitionTime.Size()))
		n167, err := m.LastTransitionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n167
	}
	if m.Reason != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReplicationControllerList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationControllerList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n168, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n168
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReplicationControllerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationControllerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Replicas != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Replicas))
	}
	if len(m.Selector) > 0 {
		for k, _ := range m.Selector {
			dAtA[i] = 0x12
			i++
			v := m.Selector[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.Template != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Template.Size()))
		n169, err := m.Template.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n169
	}
	if m.MinReadySeconds != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MinReadySeconds))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReplicationControllerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationControllerStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Replicas != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Replicas))
	}
	if m.FullyLabeledReplicas != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.FullyLabeledReplicas))
	}
	if m.ObservedGeneration != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ObservedGeneration))
	}
	if m.ReadyReplicas != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ReadyReplicas))
	}
	if m.AvailableReplicas != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.AvailableReplicas))
	}
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0x32
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceFieldSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceFieldSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ContainerName)))
		i += copy(dAtA[i:], *m.ContainerName)
	}
	if m.Resource != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Resource)))
		i += copy(dAtA[i:], *m.Resource)
	}
	if m.Divisor != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Divisor.Size()))
		n170, err := m.Divisor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n170
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceQuota) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceQuota) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n171, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n171
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n172, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n172
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n173, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n173
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceQuotaList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceQuotaList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n174, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n174
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceQuotaSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceQuotaSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Hard) > 0 {
		for k, _ := range m.Hard {
			dAtA[i] = 0xa
			i++
			v := m.Hard[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n175, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n175
			}
		}
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceQuotaStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceQuotaStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Hard) > 0 {
		for k, _ := range m.Hard {
			dAtA[i] = 0xa
			i++
			v := m.Hard[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n176, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n176
			}
		}
	}
	if len(m.Used) > 0 {
		for k, _ := range m.Used {
			dAtA[i] = 0x12
			i++
			v := m.Used[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n177, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n177
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceRequirements) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceRequirements) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for k, _ := range m.Limits {
			dAtA[i] = 0xa
			i++
			v := m.Limits[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n178, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n178
			}
		}
	}
	if len(m.Requests) > 0 {
		for k, _ := range m.Requests {
			dAtA[i] = 0x12
			i++
			v := m.Requests[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n179, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n179
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SELinuxOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SELinuxOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.User != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.Role != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if m.Type != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Level != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Level)))
		i += copy(dAtA[i:], *m.Level)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ScaleIOPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScaleIOPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Gateway != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Gateway)))
		i += copy(dAtA[i:], *m.Gateway)
	}
	if m.System != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.System)))
		i += copy(dAtA[i:], *m.System)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n180, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n180
	}
	if m.SslEnabled != nil {
		dAtA[i] = 0x20
		i++
		if *m.SslEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ProtectionDomain != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ProtectionDomain)))
		i += copy(dAtA[i:], *m.ProtectionDomain)
	}
	if m.StoragePool != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StoragePool)))
		i += copy(dAtA[i:], *m.StoragePool)
	}
	if m.StorageMode != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StorageMode)))
		i += copy(dAtA[i:], *m.StorageMode)
	}
	if m.VolumeName != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeName)))
		i += copy(dAtA[i:], *m.VolumeName)
	}
	if m.FsType != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x50
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ScaleIOVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScaleIOVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Gateway != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Gateway)))
		i += copy(dAtA[i:], *m.Gateway)
	}
	if m.System != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.System)))
		i += copy(dAtA[i:], *m.System)
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n181, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n181
	}
	if m.SslEnabled != nil {
		dAtA[i] = 0x20
		i++
		if *m.SslEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ProtectionDomain != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ProtectionDomain)))
		i += copy(dAtA[i:], *m.ProtectionDomain)
	}
	if m.StoragePool != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StoragePool)))
		i += copy(dAtA[i:], *m.StoragePool)
	}
	if m.StorageMode != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StorageMode)))
		i += copy(dAtA[i:], *m.StorageMode)
	}
	if m.VolumeName != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeName)))
		i += copy(dAtA[i:], *m.VolumeName)
	}
	if m.FsType != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x50
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Secret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n182, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n182
	}
	if len(m.Data) > 0 {
		for k, _ := range m.Data {
			dAtA[i] = 0x12
			i++
			v := m.Data[k]
			byteSize := 0
			if v != nil {
				byteSize = 1 + len(v) + sovGenerated(uint64(len(v)))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + byteSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	if m.Type != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if len(m.StringData) > 0 {
		for k, _ := range m.StringData {
			dAtA[i] = 0x22
			i++
			v := m.StringData[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecretEnvSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretEnvSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n183, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n183
	}
	if m.Optional != nil {
		dAtA[i] = 0x10
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecretKeySelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretKeySelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n184, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n184
	}
	if m.Key != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Optional != nil {
		dAtA[i] = 0x18
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecretList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n185, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n185
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecretProjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretProjection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LocalObjectReference.Size()))
		n186, err := m.LocalObjectReference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n186
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Optional != nil {
		dAtA[i] = 0x20
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecretReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Namespace != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Namespace)))
		i += copy(dAtA[i:], *m.Namespace)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecretVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SecretName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SecretName)))
		i += copy(dAtA[i:], *m.SecretName)
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DefaultMode != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.DefaultMode))
	}
	if m.Optional != nil {
		dAtA[i] = 0x20
		i++
		if *m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SecurityContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecurityContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Capabilities != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Capabilities.Size()))
		n187, err := m.Capabilities.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n187
	}
	if m.Privileged != nil {
		dAtA[i] = 0x10
		i++
		if *m.Privileged {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SeLinuxOptions != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SeLinuxOptions.Size()))
		n188, err := m.SeLinuxOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n188
	}
	if m.RunAsUser != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.RunAsUser))
	}
	if m.RunAsNonRoot != nil {
		dAtA[i] = 0x28
		i++
		if *m.RunAsNonRoot {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ReadOnlyRootFilesystem != nil {
		dAtA[i] = 0x30
		i++
		if *m.ReadOnlyRootFilesystem {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.AllowPrivilegeEscalation != nil {
		dAtA[i] = 0x38
		i++
		if *m.AllowPrivilegeEscalation {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RunAsGroup != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.RunAsGroup))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SerializedReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SerializedReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Reference != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Reference.Size()))
		n189, err := m.Reference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n189
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Service) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Service) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n190, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n190
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n191, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n191
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n192, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n192
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServiceAccount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceAccount) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n193, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n193
	}
	if len(m.Secrets) > 0 {
		for _, msg := range m.Secrets {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ImagePullSecrets) > 0 {
		for _, msg := range m.ImagePullSecrets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AutomountServiceAccountToken != nil {
		dAtA[i] = 0x20
		i++
		if *m.AutomountServiceAccountToken {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServiceAccountList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceAccountList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n194, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n194
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServiceList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n195, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n195
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServicePort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServicePort) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Protocol != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Protocol)))
		i += copy(dAtA[i:], *m.Protocol)
	}
	if m.Port != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Port))
	}
	if m.TargetPort != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.TargetPort.Size()))
		n196, err := m.TargetPort.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n196
	}
	if m.NodePort != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.NodePort))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServiceProxyOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceProxyOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Path != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServiceSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Selector) > 0 {
		for k, _ := range m.Selector {
			dAtA[i] = 0x12
			i++
			v := m.Selector[k]
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.ClusterIP != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ClusterIP)))
		i += copy(dAtA[i:], *m.ClusterIP)
	}
	if m.Type != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if len(m.ExternalIPs) > 0 {
		for _, s := range m.ExternalIPs {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.SessionAffinity != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SessionAffinity)))
		i += copy(dAtA[i:], *m.SessionAffinity)
	}
	if m.LoadBalancerIP != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.LoadBalancerIP)))
		i += copy(dAtA[i:], *m.LoadBalancerIP)
	}
	if len(m.LoadBalancerSourceRanges) > 0 {
		for _, s := range m.LoadBalancerSourceRanges {
			dAtA[i] = 0x4a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ExternalName != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ExternalName)))
		i += copy(dAtA[i:], *m.ExternalName)
	}
	if m.ExternalTrafficPolicy != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ExternalTrafficPolicy)))
		i += copy(dAtA[i:], *m.ExternalTrafficPolicy)
	}
	if m.HealthCheckNodePort != nil {
		dAtA[i] = 0x60
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.HealthCheckNodePort))
	}
	if m.PublishNotReadyAddresses != nil {
		dAtA[i] = 0x68
		i++
		if *m.PublishNotReadyAddresses {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SessionAffinityConfig != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SessionAffinityConfig.Size()))
		n197, err := m.SessionAffinityConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n197
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServiceStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LoadBalancer != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LoadBalancer.Size()))
		n198, err := m.LoadBalancer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n198
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SessionAffinityConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SessionAffinityConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClientIP != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ClientIP.Size()))
		n199, err := m.ClientIP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n199
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StorageOSPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageOSPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.VolumeName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeName)))
		i += copy(dAtA[i:], *m.VolumeName)
	}
	if m.VolumeNamespace != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeNamespace)))
		i += copy(dAtA[i:], *m.VolumeNamespace)
	}
	if m.FsType != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n200, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n200
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StorageOSVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageOSVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.VolumeName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeName)))
		i += copy(dAtA[i:], *m.VolumeName)
	}
	if m.VolumeNamespace != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumeNamespace)))
		i += copy(dAtA[i:], *m.VolumeNamespace)
	}
	if m.FsType != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x20
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SecretRef != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.SecretRef.Size()))
		n201, err := m.SecretRef.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n201
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Sysctl) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sysctl) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TCPSocketAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TCPSocketAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Port.Size()))
		n202, err := m.Port.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n202
	}
	if m.Host != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Host)))
		i += copy(dAtA[i:], *m.Host)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Taint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Taint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.Effect != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Effect)))
		i += copy(dAtA[i:], *m.Effect)
	}
	if m.TimeAdded != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.TimeAdded.Size()))
		n203, err := m.TimeAdded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n203
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Toleration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Toleration) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Operator != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Operator)))
		i += copy(dAtA[i:], *m.Operator)
	}
	if m.Value != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.Effect != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Effect)))
		i += copy(dAtA[i:], *m.Effect)
	}
	if m.TolerationSeconds != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.TolerationSeconds))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Volume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Volume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.VolumeSource != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.VolumeSource.Size()))
		n204, err := m.VolumeSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n204
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VolumeDevice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VolumeDevice) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.DevicePath != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.DevicePath)))
		i += copy(dAtA[i:], *m.DevicePath)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VolumeMount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VolumeMount) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.ReadOnly != nil {
		dAtA[i] = 0x10
		i++
		if *m.ReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MountPath != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.MountPath)))
		i += copy(dAtA[i:], *m.MountPath)
	}
	if m.SubPath != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SubPath)))
		i += copy(dAtA[i:], *m.SubPath)
	}
	if m.MountPropagation != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.MountPropagation)))
		i += copy(dAtA[i:], *m.MountPropagation)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VolumeNodeAffinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VolumeNodeAffinity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Required != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Required.Size()))
		n205, err := m.Required.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n205
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VolumeProjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VolumeProjection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Secret != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Secret.Size()))
		n206, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n206
	}
	if m.DownwardAPI != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DownwardAPI.Size()))
		n207, err := m.DownwardAPI.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n207
	}
	if m.ConfigMap != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ConfigMap.Size()))
		n208, err := m.ConfigMap.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n208
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HostPath != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.HostPath.Size()))
		n209, err := m.HostPath.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n209
	}
	if m.EmptyDir != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.EmptyDir.Size()))
		n210, err := m.EmptyDir.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n210
	}
	if m.GcePersistentDisk != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.GcePersistentDisk.Size()))
		n211, err := m.GcePersistentDisk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n211
	}
	if m.AwsElasticBlockStore != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AwsElasticBlockStore.Size()))
		n212, err := m.AwsElasticBlockStore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n212
	}
	if m.GitRepo != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.GitRepo.Size()))
		n213, err := m.GitRepo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n213
	}
	if m.Secret != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Secret.Size()))
		n214, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n214
	}
	if m.Nfs != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Nfs.Size()))
		n215, err := m.Nfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n215
	}
	if m.Iscsi != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Iscsi.Size()))
		n216, err := m.Iscsi.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n216
	}
	if m.Glusterfs != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Glusterfs.Size()))
		n217, err := m.Glusterfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n217
	}
	if m.PersistentVolumeClaim != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PersistentVolumeClaim.Size()))
		n218, err := m.PersistentVolumeClaim.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n218
	}
	if m.Rbd != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Rbd.Size()))
		n219, err := m.Rbd.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n219
	}
	if m.FlexVolume != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.FlexVolume.Size()))
		n220, err := m.FlexVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n220
	}
	if m.Cinder != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Cinder.Size()))
		n221, err := m.Cinder.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n221
	}
	if m.Cephfs != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Cephfs.Size()))
		n222, err := m.Cephfs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n222
	}
	if m.Flocker != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Flocker.Size()))
		n223, err := m.Flocker.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n223
	}
	if m.DownwardAPI != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DownwardAPI.Size()))
		n224, err := m.DownwardAPI.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n224
	}
	if m.Fc != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Fc.Size()))
		n225, err := m.Fc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n225
	}
	if m.AzureFile != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AzureFile.Size()))
		n226, err := m.AzureFile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n226
	}
	if m.ConfigMap != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ConfigMap.Size()))
		n227, err := m.ConfigMap.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n227
	}
	if m.VsphereVolume != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.VsphereVolume.Size()))
		n228, err := m.VsphereVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n228
	}
	if m.Quobyte != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Quobyte.Size()))
		n229, err := m.Quobyte.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n229
	}
	if m.AzureDisk != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AzureDisk.Size()))
		n230, err := m.AzureDisk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n230
	}
	if m.PhotonPersistentDisk != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PhotonPersistentDisk.Size()))
		n231, err := m.PhotonPersistentDisk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n231
	}
	if m.PortworxVolume != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PortworxVolume.Size()))
		n232, err := m.PortworxVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n232
	}
	if m.ScaleIO != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ScaleIO.Size()))
		n233, err := m.ScaleIO.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n233
	}
	if m.Projected != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Projected.Size()))
		n234, err := m.Projected.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n234
	}
	if m.Storageos != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Storageos.Size()))
		n235, err := m.Storageos.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n235
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VsphereVirtualDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VsphereVirtualDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.VolumePath != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.VolumePath)))
		i += copy(dAtA[i:], *m.VolumePath)
	}
	if m.FsType != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.FsType)))
		i += copy(dAtA[i:], *m.FsType)
	}
	if m.StoragePolicyName != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StoragePolicyName)))
		i += copy(dAtA[i:], *m.StoragePolicyName)
	}
	if m.StoragePolicyID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.StoragePolicyID)))
		i += copy(dAtA[i:], *m.StoragePolicyID)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WeightedPodAffinityTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WeightedPodAffinityTerm) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Weight != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Weight))
	}
	if m.PodAffinityTerm != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.PodAffinityTerm.Size()))
		n236, err := m.PodAffinityTerm.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n236
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *AWSElasticBlockStoreVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.VolumeID != nil {
		l = len(*m.VolumeID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Partition != nil {
		n += 1 + sovGenerated(uint64(*m.Partition))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Affinity) Size() (n int) {
	var l int
	_ = l
	if m.NodeAffinity != nil {
		l = m.NodeAffinity.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PodAffinity != nil {
		l = m.PodAffinity.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PodAntiAffinity != nil {
		l = m.PodAntiAffinity.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachedVolume) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DevicePath != nil {
		l = len(*m.DevicePath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AvoidPods) Size() (n int) {
	var l int
	_ = l
	if len(m.PreferAvoidPods) > 0 {
		for _, e := range m.PreferAvoidPods {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AzureDiskVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.DiskName != nil {
		l = len(*m.DiskName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DiskURI != nil {
		l = len(*m.DiskURI)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.CachingMode != nil {
		l = len(*m.CachingMode)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AzureFilePersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.SecretName != nil {
		l = len(*m.SecretName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ShareName != nil {
		l = len(*m.ShareName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.SecretNamespace != nil {
		l = len(*m.SecretNamespace)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AzureFileVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.SecretName != nil {
		l = len(*m.SecretName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ShareName != nil {
		l = len(*m.ShareName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Binding) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Target != nil {
		l = m.Target.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CSIPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Driver != nil {
		l = len(*m.Driver)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeHandle != nil {
		l = len(*m.VolumeHandle)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.VolumeAttributes) > 0 {
		for k, v := range m.VolumeAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.ControllerPublishSecretRef != nil {
		l = m.ControllerPublishSecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodeStageSecretRef != nil {
		l = m.NodeStageSecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodePublishSecretRef != nil {
		l = m.NodePublishSecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Capabilities) Size() (n int) {
	var l int
	_ = l
	if len(m.Add) > 0 {
		for _, s := range m.Add {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Drop) > 0 {
		for _, s := range m.Drop {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CephFSPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretFile != nil {
		l = len(*m.SecretFile)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CephFSVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretFile != nil {
		l = len(*m.SecretFile)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CinderVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.VolumeID != nil {
		l = len(*m.VolumeID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClientIPConfig) Size() (n int) {
	var l int
	_ = l
	if m.TimeoutSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.TimeoutSeconds))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComponentCondition) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = len(*m.Status)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Error != nil {
		l = len(*m.Error)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComponentStatus) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComponentStatusList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigMap) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Data) > 0 {
		for k, v := range m.Data {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.BinaryData) > 0 {
		for k, v := range m.BinaryData {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = 1 + len(v) + sovGenerated(uint64(len(v)))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigMapEnvSource) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigMapKeySelector) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigMapList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigMapProjection) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigMapVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.DefaultMode != nil {
		n += 1 + sovGenerated(uint64(*m.DefaultMode))
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Container) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.WorkingDir != nil {
		l = len(*m.WorkingDir)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, e := range m.Env {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.VolumeMounts) > 0 {
		for _, e := range m.VolumeMounts {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.LivenessProbe != nil {
		l = m.LivenessProbe.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadinessProbe != nil {
		l = m.ReadinessProbe.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Lifecycle != nil {
		l = m.Lifecycle.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TerminationMessagePath != nil {
		l = len(*m.TerminationMessagePath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ImagePullPolicy != nil {
		l = len(*m.ImagePullPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecurityContext != nil {
		l = m.SecurityContext.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Stdin != nil {
		n += 3
	}
	if m.StdinOnce != nil {
		n += 3
	}
	if m.Tty != nil {
		n += 3
	}
	if len(m.EnvFrom) > 0 {
		for _, e := range m.EnvFrom {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.TerminationMessagePolicy != nil {
		l = len(*m.TerminationMessagePolicy)
		n += 2 + l + sovGenerated(uint64(l))
	}
	if len(m.VolumeDevices) > 0 {
		for _, e := range m.VolumeDevices {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerImage) Size() (n int) {
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.SizeBytes != nil {
		n += 1 + sovGenerated(uint64(*m.SizeBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerPort) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HostPort != nil {
		n += 1 + sovGenerated(uint64(*m.HostPort))
	}
	if m.ContainerPort != nil {
		n += 1 + sovGenerated(uint64(*m.ContainerPort))
	}
	if m.Protocol != nil {
		l = len(*m.Protocol)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HostIP != nil {
		l = len(*m.HostIP)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerState) Size() (n int) {
	var l int
	_ = l
	if m.Waiting != nil {
		l = m.Waiting.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Running != nil {
		l = m.Running.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Terminated != nil {
		l = m.Terminated.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerStateRunning) Size() (n int) {
	var l int
	_ = l
	if m.StartedAt != nil {
		l = m.StartedAt.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerStateTerminated) Size() (n int) {
	var l int
	_ = l
	if m.ExitCode != nil {
		n += 1 + sovGenerated(uint64(*m.ExitCode))
	}
	if m.Signal != nil {
		n += 1 + sovGenerated(uint64(*m.Signal))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StartedAt != nil {
		l = m.StartedAt.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FinishedAt != nil {
		l = m.FinishedAt.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ContainerID != nil {
		l = len(*m.ContainerID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerStateWaiting) Size() (n int) {
	var l int
	_ = l
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerStatus) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastState != nil {
		l = m.LastState.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Ready != nil {
		n += 2
	}
	if m.RestartCount != nil {
		n += 1 + sovGenerated(uint64(*m.RestartCount))
	}
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ImageID != nil {
		l = len(*m.ImageID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ContainerID != nil {
		l = len(*m.ContainerID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DaemonEndpoint) Size() (n int) {
	var l int
	_ = l
	if m.Port != nil {
		n += 1 + sovGenerated(uint64(*m.Port))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteOptions) Size() (n int) {
	var l int
	_ = l
	if m.GracePeriodSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.GracePeriodSeconds))
	}
	if m.Preconditions != nil {
		l = m.Preconditions.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.OrphanDependents != nil {
		n += 2
	}
	if m.PropagationPolicy != nil {
		l = len(*m.PropagationPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownwardAPIProjection) Size() (n int) {
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownwardAPIVolumeFile) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FieldRef != nil {
		l = m.FieldRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ResourceFieldRef != nil {
		l = m.ResourceFieldRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Mode != nil {
		n += 1 + sovGenerated(uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownwardAPIVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.DefaultMode != nil {
		n += 1 + sovGenerated(uint64(*m.DefaultMode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmptyDirVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Medium != nil {
		l = len(*m.Medium)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SizeLimit != nil {
		l = m.SizeLimit.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EndpointAddress) Size() (n int) {
	var l int
	_ = l
	if m.Ip != nil {
		l = len(*m.Ip)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TargetRef != nil {
		l = m.TargetRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodeName != nil {
		l = len(*m.NodeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EndpointPort) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Port != nil {
		n += 1 + sovGenerated(uint64(*m.Port))
	}
	if m.Protocol != nil {
		l = len(*m.Protocol)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EndpointSubset) Size() (n int) {
	var l int
	_ = l
	if len(m.Addresses) > 0 {
		for _, e := range m.Addresses {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.NotReadyAddresses) > 0 {
		for _, e := range m.NotReadyAddresses {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Endpoints) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Subsets) > 0 {
		for _, e := range m.Subsets {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EndpointsList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvFromSource) Size() (n int) {
	var l int
	_ = l
	if m.Prefix != nil {
		l = len(*m.Prefix)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ConfigMapRef != nil {
		l = m.ConfigMapRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvVar) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ValueFrom != nil {
		l = m.ValueFrom.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvVarSource) Size() (n int) {
	var l int
	_ = l
	if m.FieldRef != nil {
		l = m.FieldRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ResourceFieldRef != nil {
		l = m.ResourceFieldRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ConfigMapKeyRef != nil {
		l = m.ConfigMapKeyRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretKeyRef != nil {
		l = m.SecretKeyRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.InvolvedObject != nil {
		l = m.InvolvedObject.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Source != nil {
		l = m.Source.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FirstTimestamp != nil {
		l = m.FirstTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastTimestamp != nil {
		l = m.LastTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Count != nil {
		n += 1 + sovGenerated(uint64(*m.Count))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.EventTime != nil {
		l = m.EventTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Action != nil {
		l = len(*m.Action)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Related != nil {
		l = m.Related.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReportingComponent != nil {
		l = len(*m.ReportingComponent)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReportingInstance != nil {
		l = len(*m.ReportingInstance)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventSeries) Size() (n int) {
	var l int
	_ = l
	if m.Count != nil {
		n += 1 + sovGenerated(uint64(*m.Count))
	}
	if m.LastObservedTime != nil {
		l = m.LastObservedTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.State != nil {
		l = len(*m.State)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventSource) Size() (n int) {
	var l int
	_ = l
	if m.Component != nil {
		l = len(*m.Component)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Host != nil {
		l = len(*m.Host)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecAction) Size() (n int) {
	var l int
	_ = l
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FCVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.TargetWWNs) > 0 {
		for _, s := range m.TargetWWNs {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Lun != nil {
		n += 1 + sovGenerated(uint64(*m.Lun))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if len(m.Wwids) > 0 {
		for _, s := range m.Wwids {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FlexPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Driver != nil {
		l = len(*m.Driver)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FlexVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Driver != nil {
		l = len(*m.Driver)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FlockerVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.DatasetName != nil {
		l = len(*m.DatasetName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DatasetUUID != nil {
		l = len(*m.DatasetUUID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCEPersistentDiskVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.PdName != nil {
		l = len(*m.PdName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Partition != nil {
		n += 1 + sovGenerated(uint64(*m.Partition))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GitRepoVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Repository != nil {
		l = len(*m.Repository)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Revision != nil {
		l = len(*m.Revision)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Directory != nil {
		l = len(*m.Directory)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GlusterfsVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Endpoints != nil {
		l = len(*m.Endpoints)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPGetAction) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Host != nil {
		l = len(*m.Host)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Scheme != nil {
		l = len(*m.Scheme)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.HttpHeaders) > 0 {
		for _, e := range m.HttpHeaders {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPHeader) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Handler) Size() (n int) {
	var l int
	_ = l
	if m.Exec != nil {
		l = m.Exec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HttpGet != nil {
		l = m.HttpGet.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TcpSocket != nil {
		l = m.TcpSocket.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HostAlias) Size() (n int) {
	var l int
	_ = l
	if m.Ip != nil {
		l = len(*m.Ip)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Hostnames) > 0 {
		for _, s := range m.Hostnames {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HostPathVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ISCSIPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.TargetPortal != nil {
		l = len(*m.TargetPortal)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Iqn != nil {
		l = len(*m.Iqn)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Lun != nil {
		n += 1 + sovGenerated(uint64(*m.Lun))
	}
	if m.IscsiInterface != nil {
		l = len(*m.IscsiInterface)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if len(m.Portals) > 0 {
		for _, s := range m.Portals {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.ChapAuthDiscovery != nil {
		n += 2
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ChapAuthSession != nil {
		n += 2
	}
	if m.InitiatorName != nil {
		l = len(*m.InitiatorName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ISCSIVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.TargetPortal != nil {
		l = len(*m.TargetPortal)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Iqn != nil {
		l = len(*m.Iqn)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Lun != nil {
		n += 1 + sovGenerated(uint64(*m.Lun))
	}
	if m.IscsiInterface != nil {
		l = len(*m.IscsiInterface)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if len(m.Portals) > 0 {
		for _, s := range m.Portals {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.ChapAuthDiscovery != nil {
		n += 2
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ChapAuthSession != nil {
		n += 2
	}
	if m.InitiatorName != nil {
		l = len(*m.InitiatorName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyToPath) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Mode != nil {
		n += 1 + sovGenerated(uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Lifecycle) Size() (n int) {
	var l int
	_ = l
	if m.PostStart != nil {
		l = m.PostStart.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PreStop != nil {
		l = m.PreStop.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LimitRange) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LimitRangeItem) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Max) > 0 {
		for k, v := range m.Max {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Min) > 0 {
		for k, v := range m.Min {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Default) > 0 {
		for k, v := range m.Default {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.DefaultRequest) > 0 {
		for k, v := range m.DefaultRequest {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.MaxLimitRequestRatio) > 0 {
		for k, v := range m.MaxLimitRequestRatio {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LimitRangeList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LimitRangeSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, e := range m.Limits {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *List) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListOptions) Size() (n int) {
	var l int
	_ = l
	if m.LabelSelector != nil {
		l = len(*m.LabelSelector)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FieldSelector != nil {
		l = len(*m.FieldSelector)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Watch != nil {
		n += 2
	}
	if m.ResourceVersion != nil {
		l = len(*m.ResourceVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TimeoutSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.TimeoutSeconds))
	}
	if m.IncludeUninitialized != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadBalancerIngress) Size() (n int) {
	var l int
	_ = l
	if m.Ip != nil {
		l = len(*m.Ip)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadBalancerStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Ingress) > 0 {
		for _, e := range m.Ingress {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalObjectReference) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NFSVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Server != nil {
		l = len(*m.Server)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Namespace) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NamespaceList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NamespaceSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Finalizers) > 0 {
		for _, s := range m.Finalizers {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NamespaceStatus) Size() (n int) {
	var l int
	_ = l
	if m.Phase != nil {
		l = len(*m.Phase)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeAddress) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Address != nil {
		l = len(*m.Address)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeAffinity) Size() (n int) {
	var l int
	_ = l
	if m.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		l = m.RequiredDuringSchedulingIgnoredDuringExecution.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, e := range m.PreferredDuringSchedulingIgnoredDuringExecution {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeCondition) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = len(*m.Status)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastHeartbeatTime != nil {
		l = m.LastHeartbeatTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastTransitionTime != nil {
		l = m.LastTransitionTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeConfigSource) Size() (n int) {
	var l int
	_ = l
	if m.ConfigMapRef != nil {
		l = m.ConfigMapRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeDaemonEndpoints) Size() (n int) {
	var l int
	_ = l
	if m.KubeletEndpoint != nil {
		l = m.KubeletEndpoint.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeProxyOptions) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeResources) Size() (n int) {
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k, v := range m.Capacity {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSelector) Size() (n int) {
	var l int
	_ = l
	if len(m.NodeSelectorTerms) > 0 {
		for _, e := range m.NodeSelectorTerms {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSelectorRequirement) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Operator != nil {
		l = len(*m.Operator)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSelectorTerm) Size() (n int) {
	var l int
	_ = l
	if len(m.MatchExpressions) > 0 {
		for _, e := range m.MatchExpressions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSpec) Size() (n int) {
	var l int
	_ = l
	if m.PodCIDR != nil {
		l = len(*m.PodCIDR)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ExternalID != nil {
		l = len(*m.ExternalID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ProviderID != nil {
		l = len(*m.ProviderID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Unschedulable != nil {
		n += 2
	}
	if len(m.Taints) > 0 {
		for _, e := range m.Taints {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.ConfigSource != nil {
		l = m.ConfigSource.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k, v := range m.Capacity {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Allocatable) > 0 {
		for k, v := range m.Allocatable {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.Phase != nil {
		l = len(*m.Phase)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Addresses) > 0 {
		for _, e := range m.Addresses {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.DaemonEndpoints != nil {
		l = m.DaemonEndpoints.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodeInfo != nil {
		l = m.NodeInfo.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Images) > 0 {
		for _, e := range m.Images {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.VolumesInUse) > 0 {
		for _, s := range m.VolumesInUse {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.VolumesAttached) > 0 {
		for _, e := range m.VolumesAttached {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSystemInfo) Size() (n int) {
	var l int
	_ = l
	if m.MachineID != nil {
		l = len(*m.MachineID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SystemUUID != nil {
		l = len(*m.SystemUUID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.BootID != nil {
		l = len(*m.BootID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.KernelVersion != nil {
		l = len(*m.KernelVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.OsImage != nil {
		l = len(*m.OsImage)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ContainerRuntimeVersion != nil {
		l = len(*m.ContainerRuntimeVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.KubeletVersion != nil {
		l = len(*m.KubeletVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.KubeProxyVersion != nil {
		l = len(*m.KubeProxyVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.OperatingSystem != nil {
		l = len(*m.OperatingSystem)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Architecture != nil {
		l = len(*m.Architecture)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ObjectFieldSelector) Size() (n int) {
	var l int
	_ = l
	if m.ApiVersion != nil {
		l = len(*m.ApiVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FieldPath != nil {
		l = len(*m.FieldPath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ObjectMeta) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.GenerateName != nil {
		l = len(*m.GenerateName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SelfLink != nil {
		l = len(*m.SelfLink)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Uid != nil {
		l = len(*m.Uid)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ResourceVersion != nil {
		l = len(*m.ResourceVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Generation != nil {
		n += 1 + sovGenerated(uint64(*m.Generation))
	}
	if m.CreationTimestamp != nil {
		l = m.CreationTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DeletionTimestamp != nil {
		l = m.DeletionTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DeletionGracePeriodSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.DeletionGracePeriodSeconds))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.OwnerReferences) > 0 {
		for _, e := range m.OwnerReferences {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Finalizers) > 0 {
		for _, s := range m.Finalizers {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.ClusterName != nil {
		l = len(*m.ClusterName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Initializers != nil {
		l = m.Initializers.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ObjectReference) Size() (n int) {
	var l int
	_ = l
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Uid != nil {
		l = len(*m.Uid)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ApiVersion != nil {
		l = len(*m.ApiVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ResourceVersion != nil {
		l = len(*m.ResourceVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FieldPath != nil {
		l = len(*m.FieldPath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolume) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeClaim) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeClaimCondition) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = len(*m.Status)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastProbeTime != nil {
		l = m.LastProbeTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastTransitionTime != nil {
		l = m.LastTransitionTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeClaimList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeClaimSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.AccessModes) > 0 {
		for _, s := range m.AccessModes {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeName != nil {
		l = len(*m.VolumeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Selector != nil {
		l = m.Selector.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StorageClassName != nil {
		l = len(*m.StorageClassName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeMode != nil {
		l = len(*m.VolumeMode)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeClaimStatus) Size() (n int) {
	var l int
	_ = l
	if m.Phase != nil {
		l = len(*m.Phase)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.AccessModes) > 0 {
		for _, s := range m.AccessModes {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Capacity) > 0 {
		for k, v := range m.Capacity {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeClaimVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.ClaimName != nil {
		l = len(*m.ClaimName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.GcePersistentDisk != nil {
		l = m.GcePersistentDisk.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.AwsElasticBlockStore != nil {
		l = m.AwsElasticBlockStore.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HostPath != nil {
		l = m.HostPath.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Glusterfs != nil {
		l = m.Glusterfs.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Nfs != nil {
		l = m.Nfs.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Rbd != nil {
		l = m.Rbd.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Iscsi != nil {
		l = m.Iscsi.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Cinder != nil {
		l = m.Cinder.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Cephfs != nil {
		l = m.Cephfs.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Fc != nil {
		l = m.Fc.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Flocker != nil {
		l = m.Flocker.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FlexVolume != nil {
		l = m.FlexVolume.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.AzureFile != nil {
		l = m.AzureFile.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VsphereVolume != nil {
		l = m.VsphereVolume.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Quobyte != nil {
		l = m.Quobyte.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.AzureDisk != nil {
		l = m.AzureDisk.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.PhotonPersistentDisk != nil {
		l = m.PhotonPersistentDisk.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.PortworxVolume != nil {
		l = m.PortworxVolume.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.ScaleIO != nil {
		l = m.ScaleIO.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Local != nil {
		l = m.Local.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Storageos != nil {
		l = m.Storageos.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Csi != nil {
		l = m.Csi.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k, v := range m.Capacity {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.PersistentVolumeSource != nil {
		l = m.PersistentVolumeSource.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.AccessModes) > 0 {
		for _, s := range m.AccessModes {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.ClaimRef != nil {
		l = m.ClaimRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PersistentVolumeReclaimPolicy != nil {
		l = len(*m.PersistentVolumeReclaimPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StorageClassName != nil {
		l = len(*m.StorageClassName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.MountOptions) > 0 {
		for _, s := range m.MountOptions {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.VolumeMode != nil {
		l = len(*m.VolumeMode)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodeAffinity != nil {
		l = m.NodeAffinity.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PersistentVolumeStatus) Size() (n int) {
	var l int
	_ = l
	if m.Phase != nil {
		l = len(*m.Phase)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PhotonPersistentDiskVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.PdID != nil {
		l = len(*m.PdID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Pod) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodAffinity) Size() (n int) {
	var l int
	_ = l
	if len(m.RequiredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, e := range m.RequiredDuringSchedulingIgnoredDuringExecution {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, e := range m.PreferredDuringSchedulingIgnoredDuringExecution {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodAffinityTerm) Size() (n int) {
	var l int
	_ = l
	if m.LabelSelector != nil {
		l = m.LabelSelector.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Namespaces) > 0 {
		for _, s := range m.Namespaces {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.TopologyKey != nil {
		l = len(*m.TopologyKey)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodAntiAffinity) Size() (n int) {
	var l int
	_ = l
	if len(m.RequiredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, e := range m.RequiredDuringSchedulingIgnoredDuringExecution {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for _, e := range m.PreferredDuringSchedulingIgnoredDuringExecution {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodAttachOptions) Size() (n int) {
	var l int
	_ = l
	if m.Stdin != nil {
		n += 2
	}
	if m.Stdout != nil {
		n += 2
	}
	if m.Stderr != nil {
		n += 2
	}
	if m.Tty != nil {
		n += 2
	}
	if m.Container != nil {
		l = len(*m.Container)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodCondition) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = len(*m.Status)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastProbeTime != nil {
		l = m.LastProbeTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastTransitionTime != nil {
		l = m.LastTransitionTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodDNSConfig) Size() (n int) {
	var l int
	_ = l
	if len(m.Nameservers) > 0 {
		for _, s := range m.Nameservers {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Searches) > 0 {
		for _, s := range m.Searches {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Options) > 0 {
		for _, e := range m.Options {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodDNSConfigOption) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodExecOptions) Size() (n int) {
	var l int
	_ = l
	if m.Stdin != nil {
		n += 2
	}
	if m.Stdout != nil {
		n += 2
	}
	if m.Stderr != nil {
		n += 2
	}
	if m.Tty != nil {
		n += 2
	}
	if m.Container != nil {
		l = len(*m.Container)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodLogOptions) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		l = len(*m.Container)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Follow != nil {
		n += 2
	}
	if m.Previous != nil {
		n += 2
	}
	if m.SinceSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.SinceSeconds))
	}
	if m.SinceTime != nil {
		l = m.SinceTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Timestamps != nil {
		n += 2
	}
	if m.TailLines != nil {
		n += 1 + sovGenerated(uint64(*m.TailLines))
	}
	if m.LimitBytes != nil {
		n += 1 + sovGenerated(uint64(*m.LimitBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodPortForwardOptions) Size() (n int) {
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			n += 1 + sovGenerated(uint64(e))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodProxyOptions) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodSecurityContext) Size() (n int) {
	var l int
	_ = l
	if m.SeLinuxOptions != nil {
		l = m.SeLinuxOptions.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.RunAsUser != nil {
		n += 1 + sovGenerated(uint64(*m.RunAsUser))
	}
	if m.RunAsNonRoot != nil {
		n += 2
	}
	if len(m.SupplementalGroups) > 0 {
		for _, e := range m.SupplementalGroups {
			n += 1 + sovGenerated(uint64(e))
		}
	}
	if m.FsGroup != nil {
		n += 1 + sovGenerated(uint64(*m.FsGroup))
	}
	if m.RunAsGroup != nil {
		n += 1 + sovGenerated(uint64(*m.RunAsGroup))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodSignature) Size() (n int) {
	var l int
	_ = l
	if m.PodController != nil {
		l = m.PodController.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.RestartPolicy != nil {
		l = len(*m.RestartPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TerminationGracePeriodSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.TerminationGracePeriodSeconds))
	}
	if m.ActiveDeadlineSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.ActiveDeadlineSeconds))
	}
	if m.DnsPolicy != nil {
		l = len(*m.DnsPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.NodeSelector) > 0 {
		for k, v := range m.NodeSelector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.ServiceAccountName != nil {
		l = len(*m.ServiceAccountName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ServiceAccount != nil {
		l = len(*m.ServiceAccount)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodeName != nil {
		l = len(*m.NodeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HostNetwork != nil {
		n += 2
	}
	if m.HostPID != nil {
		n += 2
	}
	if m.HostIPC != nil {
		n += 2
	}
	if m.SecurityContext != nil {
		l = m.SecurityContext.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.ImagePullSecrets) > 0 {
		for _, e := range m.ImagePullSecrets {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Subdomain != nil {
		l = len(*m.Subdomain)
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Affinity != nil {
		l = m.Affinity.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.SchedulerName != nil {
		l = len(*m.SchedulerName)
		n += 2 + l + sovGenerated(uint64(l))
	}
	if len(m.InitContainers) > 0 {
		for _, e := range m.InitContainers {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.AutomountServiceAccountToken != nil {
		n += 3
	}
	if len(m.Tolerations) > 0 {
		for _, e := range m.Tolerations {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.HostAliases) > 0 {
		for _, e := range m.HostAliases {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.PriorityClassName != nil {
		l = len(*m.PriorityClassName)
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Priority != nil {
		n += 2 + sovGenerated(uint64(*m.Priority))
	}
	if m.DnsConfig != nil {
		l = m.DnsConfig.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.ShareProcessNamespace != nil {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodStatus) Size() (n int) {
	var l int
	_ = l
	if m.Phase != nil {
		l = len(*m.Phase)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HostIP != nil {
		l = len(*m.HostIP)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PodIP != nil {
		l = len(*m.PodIP)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.ContainerStatuses) > 0 {
		for _, e := range m.ContainerStatuses {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.QosClass != nil {
		l = len(*m.QosClass)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.InitContainerStatuses) > 0 {
		for _, e := range m.InitContainerStatuses {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.NominatedNodeName != nil {
		l = len(*m.NominatedNodeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodStatusResult) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodTemplate) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Template != nil {
		l = m.Template.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodTemplateList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PodTemplateSpec) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PortworxVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.VolumeID != nil {
		l = len(*m.VolumeID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Preconditions) Size() (n int) {
	var l int
	_ = l
	if m.Uid != nil {
		l = len(*m.Uid)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PreferAvoidPodsEntry) Size() (n int) {
	var l int
	_ = l
	if m.PodSignature != nil {
		l = m.PodSignature.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.EvictionTime != nil {
		l = m.EvictionTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PreferredSchedulingTerm) Size() (n int) {
	var l int
	_ = l
	if m.Weight != nil {
		n += 1 + sovGenerated(uint64(*m.Weight))
	}
	if m.Preference != nil {
		l = m.Preference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Probe) Size() (n int) {
	var l int
	_ = l
	if m.Handler != nil {
		l = m.Handler.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.InitialDelaySeconds != nil {
		n += 1 + sovGenerated(uint64(*m.InitialDelaySeconds))
	}
	if m.TimeoutSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.TimeoutSeconds))
	}
	if m.PeriodSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.PeriodSeconds))
	}
	if m.SuccessThreshold != nil {
		n += 1 + sovGenerated(uint64(*m.SuccessThreshold))
	}
	if m.FailureThreshold != nil {
		n += 1 + sovGenerated(uint64(*m.FailureThreshold))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProjectedVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.Sources) > 0 {
		for _, e := range m.Sources {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.DefaultMode != nil {
		n += 1 + sovGenerated(uint64(*m.DefaultMode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuobyteVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Registry != nil {
		l = len(*m.Registry)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Volume != nil {
		l = len(*m.Volume)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RBDPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Pool != nil {
		l = len(*m.Pool)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Keyring != nil {
		l = len(*m.Keyring)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RBDVolumeSource) Size() (n int) {
	var l int
	_ = l
	if len(m.Monitors) > 0 {
		for _, s := range m.Monitors {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Pool != nil {
		l = len(*m.Pool)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Keyring != nil {
		l = len(*m.Keyring)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RangeAllocation) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Range != nil {
		l = len(*m.Range)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationController) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationControllerCondition) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = len(*m.Status)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastTransitionTime != nil {
		l = m.LastTransitionTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationControllerList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationControllerSpec) Size() (n int) {
	var l int
	_ = l
	if m.Replicas != nil {
		n += 1 + sovGenerated(uint64(*m.Replicas))
	}
	if len(m.Selector) > 0 {
		for k, v := range m.Selector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.Template != nil {
		l = m.Template.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.MinReadySeconds != nil {
		n += 1 + sovGenerated(uint64(*m.MinReadySeconds))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplicationControllerStatus) Size() (n int) {
	var l int
	_ = l
	if m.Replicas != nil {
		n += 1 + sovGenerated(uint64(*m.Replicas))
	}
	if m.FullyLabeledReplicas != nil {
		n += 1 + sovGenerated(uint64(*m.FullyLabeledReplicas))
	}
	if m.ObservedGeneration != nil {
		n += 1 + sovGenerated(uint64(*m.ObservedGeneration))
	}
	if m.ReadyReplicas != nil {
		n += 1 + sovGenerated(uint64(*m.ReadyReplicas))
	}
	if m.AvailableReplicas != nil {
		n += 1 + sovGenerated(uint64(*m.AvailableReplicas))
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceFieldSelector) Size() (n int) {
	var l int
	_ = l
	if m.ContainerName != nil {
		l = len(*m.ContainerName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Resource != nil {
		l = len(*m.Resource)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Divisor != nil {
		l = m.Divisor.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceQuota) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceQuotaList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceQuotaSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Hard) > 0 {
		for k, v := range m.Hard {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceQuotaStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Hard) > 0 {
		for k, v := range m.Hard {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Used) > 0 {
		for k, v := range m.Used {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceRequirements) Size() (n int) {
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for k, v := range m.Limits {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Requests) > 0 {
		for k, v := range m.Requests {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SELinuxOptions) Size() (n int) {
	var l int
	_ = l
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Level != nil {
		l = len(*m.Level)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScaleIOPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Gateway != nil {
		l = len(*m.Gateway)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.System != nil {
		l = len(*m.System)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SslEnabled != nil {
		n += 2
	}
	if m.ProtectionDomain != nil {
		l = len(*m.ProtectionDomain)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StoragePool != nil {
		l = len(*m.StoragePool)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StorageMode != nil {
		l = len(*m.StorageMode)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeName != nil {
		l = len(*m.VolumeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScaleIOVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.Gateway != nil {
		l = len(*m.Gateway)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.System != nil {
		l = len(*m.System)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SslEnabled != nil {
		n += 2
	}
	if m.ProtectionDomain != nil {
		l = len(*m.ProtectionDomain)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StoragePool != nil {
		l = len(*m.StoragePool)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StorageMode != nil {
		l = len(*m.StorageMode)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeName != nil {
		l = len(*m.VolumeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Secret) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Data) > 0 {
		for k, v := range m.Data {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = 1 + len(v) + sovGenerated(uint64(len(v)))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.StringData) > 0 {
		for k, v := range m.StringData {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretEnvSource) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretKeySelector) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretProjection) Size() (n int) {
	var l int
	_ = l
	if m.LocalObjectReference != nil {
		l = m.LocalObjectReference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretReference) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.SecretName != nil {
		l = len(*m.SecretName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.DefaultMode != nil {
		n += 1 + sovGenerated(uint64(*m.DefaultMode))
	}
	if m.Optional != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecurityContext) Size() (n int) {
	var l int
	_ = l
	if m.Capabilities != nil {
		l = m.Capabilities.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Privileged != nil {
		n += 2
	}
	if m.SeLinuxOptions != nil {
		l = m.SeLinuxOptions.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.RunAsUser != nil {
		n += 1 + sovGenerated(uint64(*m.RunAsUser))
	}
	if m.RunAsNonRoot != nil {
		n += 2
	}
	if m.ReadOnlyRootFilesystem != nil {
		n += 2
	}
	if m.AllowPrivilegeEscalation != nil {
		n += 2
	}
	if m.RunAsGroup != nil {
		n += 1 + sovGenerated(uint64(*m.RunAsGroup))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SerializedReference) Size() (n int) {
	var l int
	_ = l
	if m.Reference != nil {
		l = m.Reference.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Service) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceAccount) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.ImagePullSecrets) > 0 {
		for _, e := range m.ImagePullSecrets {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.AutomountServiceAccountToken != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceAccountList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServicePort) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Protocol != nil {
		l = len(*m.Protocol)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Port != nil {
		n += 1 + sovGenerated(uint64(*m.Port))
	}
	if m.TargetPort != nil {
		l = m.TargetPort.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.NodePort != nil {
		n += 1 + sovGenerated(uint64(*m.NodePort))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceProxyOptions) Size() (n int) {
	var l int
	_ = l
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Selector) > 0 {
		for k, v := range m.Selector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.ClusterIP != nil {
		l = len(*m.ClusterIP)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.ExternalIPs) > 0 {
		for _, s := range m.ExternalIPs {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.SessionAffinity != nil {
		l = len(*m.SessionAffinity)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LoadBalancerIP != nil {
		l = len(*m.LoadBalancerIP)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.LoadBalancerSourceRanges) > 0 {
		for _, s := range m.LoadBalancerSourceRanges {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.ExternalName != nil {
		l = len(*m.ExternalName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ExternalTrafficPolicy != nil {
		l = len(*m.ExternalTrafficPolicy)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.HealthCheckNodePort != nil {
		n += 1 + sovGenerated(uint64(*m.HealthCheckNodePort))
	}
	if m.PublishNotReadyAddresses != nil {
		n += 2
	}
	if m.SessionAffinityConfig != nil {
		l = m.SessionAffinityConfig.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceStatus) Size() (n int) {
	var l int
	_ = l
	if m.LoadBalancer != nil {
		l = m.LoadBalancer.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SessionAffinityConfig) Size() (n int) {
	var l int
	_ = l
	if m.ClientIP != nil {
		l = m.ClientIP.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StorageOSPersistentVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.VolumeName != nil {
		l = len(*m.VolumeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeNamespace != nil {
		l = len(*m.VolumeNamespace)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StorageOSVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.VolumeName != nil {
		l = len(*m.VolumeName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeNamespace != nil {
		l = len(*m.VolumeNamespace)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.SecretRef != nil {
		l = m.SecretRef.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Sysctl) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TCPSocketAction) Size() (n int) {
	var l int
	_ = l
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Host != nil {
		l = len(*m.Host)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Taint) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Effect != nil {
		l = len(*m.Effect)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TimeAdded != nil {
		l = m.TimeAdded.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Toleration) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Operator != nil {
		l = len(*m.Operator)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Effect != nil {
		l = len(*m.Effect)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.TolerationSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.TolerationSeconds))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Volume) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.VolumeSource != nil {
		l = m.VolumeSource.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VolumeDevice) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DevicePath != nil {
		l = len(*m.DevicePath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VolumeMount) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReadOnly != nil {
		n += 2
	}
	if m.MountPath != nil {
		l = len(*m.MountPath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.SubPath != nil {
		l = len(*m.SubPath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.MountPropagation != nil {
		l = len(*m.MountPropagation)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VolumeNodeAffinity) Size() (n int) {
	var l int
	_ = l
	if m.Required != nil {
		l = m.Required.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VolumeProjection) Size() (n int) {
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DownwardAPI != nil {
		l = m.DownwardAPI.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ConfigMap != nil {
		l = m.ConfigMap.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.HostPath != nil {
		l = m.HostPath.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.EmptyDir != nil {
		l = m.EmptyDir.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.GcePersistentDisk != nil {
		l = m.GcePersistentDisk.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.AwsElasticBlockStore != nil {
		l = m.AwsElasticBlockStore.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.GitRepo != nil {
		l = m.GitRepo.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Nfs != nil {
		l = m.Nfs.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Iscsi != nil {
		l = m.Iscsi.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Glusterfs != nil {
		l = m.Glusterfs.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.PersistentVolumeClaim != nil {
		l = m.PersistentVolumeClaim.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Rbd != nil {
		l = m.Rbd.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FlexVolume != nil {
		l = m.FlexVolume.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Cinder != nil {
		l = m.Cinder.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Cephfs != nil {
		l = m.Cephfs.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Flocker != nil {
		l = m.Flocker.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DownwardAPI != nil {
		l = m.DownwardAPI.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Fc != nil {
		l = m.Fc.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.AzureFile != nil {
		l = m.AzureFile.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.ConfigMap != nil {
		l = m.ConfigMap.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.VsphereVolume != nil {
		l = m.VsphereVolume.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Quobyte != nil {
		l = m.Quobyte.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.AzureDisk != nil {
		l = m.AzureDisk.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.PhotonPersistentDisk != nil {
		l = m.PhotonPersistentDisk.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.PortworxVolume != nil {
		l = m.PortworxVolume.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.ScaleIO != nil {
		l = m.ScaleIO.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Projected != nil {
		l = m.Projected.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Storageos != nil {
		l = m.Storageos.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VsphereVirtualDiskVolumeSource) Size() (n int) {
	var l int
	_ = l
	if m.VolumePath != nil {
		l = len(*m.VolumePath)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.FsType != nil {
		l = len(*m.FsType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StoragePolicyName != nil {
		l = len(*m.StoragePolicyName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.StoragePolicyID != nil {
		l = len(*m.StoragePolicyID)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WeightedPodAffinityTerm) Size() (n int) {
	var l int
	_ = l
	if m.Weight != nil {
		n += 1 + sovGenerated(uint64(*m.Weight))
	}
	if m.PodAffinityTerm != nil {
		l = m.PodAffinityTerm.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AWSElasticBlockStoreVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AWSElasticBlockStoreVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AWSElasticBlockStoreVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.VolumeID = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partition", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Partition = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Affinity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Affinity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Affinity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeAffinity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeAffinity == nil {
				m.NodeAffinity = &NodeAffinity{}
			}
			if err := m.NodeAffinity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodAffinity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PodAffinity == nil {
				m.PodAffinity = &PodAffinity{}
			}
			if err := m.PodAffinity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodAntiAffinity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PodAntiAffinity == nil {
				m.PodAntiAffinity = &PodAntiAffinity{}
			}
			if err := m.PodAntiAffinity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttachedVolume) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttachedVolume: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttachedVolume: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DevicePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.DevicePath = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AvoidPods) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AvoidPods: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AvoidPods: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreferAvoidPods", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PreferAvoidPods = append(m.PreferAvoidPods, &PreferAvoidPodsEntry{})
			if err := m.PreferAvoidPods[len(m.PreferAvoidPods)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AzureDiskVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AzureDiskVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AzureDiskVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.DiskName = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.DiskURI = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CachingMode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.CachingMode = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AzureFilePersistentVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AzureFilePersistentVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AzureFilePersistentVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SecretName = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShareName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ShareName = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SecretNamespace = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AzureFileVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AzureFileVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AzureFileVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SecretName = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShareName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ShareName = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Binding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Binding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Binding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Target == nil {
				m.Target = &ObjectReference{}
			}
			if err := m.Target.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CSIPersistentVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CSIPersistentVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CSIPersistentVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Driver = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeHandle", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.VolumeHandle = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VolumeAttributes == nil {
				m.VolumeAttributes = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.VolumeAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ControllerPublishSecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ControllerPublishSecretRef == nil {
				m.ControllerPublishSecretRef = &SecretReference{}
			}
			if err := m.ControllerPublishSecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeStageSecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeStageSecretRef == nil {
				m.NodeStageSecretRef = &SecretReference{}
			}
			if err := m.NodeStageSecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodePublishSecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodePublishSecretRef == nil {
				m.NodePublishSecretRef = &SecretReference{}
			}
			if err := m.NodePublishSecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Capabilities) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Capabilities: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Capabilities: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Add", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Add = append(m.Add, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Drop", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Drop = append(m.Drop, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CephFSPersistentVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CephFSPersistentVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CephFSPersistentVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Monitors", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Monitors = append(m.Monitors, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.User = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SecretFile = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &SecretReference{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CephFSVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CephFSVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CephFSVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Monitors", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Monitors = append(m.Monitors, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.User = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SecretFile = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &LocalObjectReference{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CinderVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CinderVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CinderVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.VolumeID = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientIPConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientIPConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientIPConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSeconds", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TimeoutSeconds = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComponentCondition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComponentCondition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComponentCondition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Status = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Error = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComponentStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComponentStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComponentStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, &ComponentCondition{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComponentStatusList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComponentStatusList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComponentStatusList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ComponentStatus{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigMap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigMap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigMap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Data[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinaryData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BinaryData == nil {
				m.BinaryData = make(map[string][]byte)
			}
			var mapkey string
			mapvalue := []byte{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapbyteLen uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapbyteLen |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intMapbyteLen := int(mapbyteLen)
					if intMapbyteLen < 0 {
						return ErrInvalidLengthGenerated
					}
					postbytesIndex := iNdEx + intMapbyteLen
					if postbytesIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = make([]byte, mapbyteLen)
					copy(mapvalue, dAtA[iNdEx:postbytesIndex])
					iNdEx = postbytesIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.BinaryData[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigMapEnvSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigMapEnvSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigMapEnvSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalObjectReference", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalObjectReference == nil {
				m.LocalObjectReference = &LocalObjectReference{}
			}
			if err := m.LocalObjectReference.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Optional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Optional = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigMapKeySelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigMapKeySelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigMapKeySelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalObjectReference", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalObjectReference == nil {
				m.LocalObjectReference = &LocalObjectReference{}
			}
			if err := m.LocalObjectReference.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Optional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Optional = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigMapList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigMapList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigMapList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ConfigMap{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigMapProjection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigMapProjection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigMapProjection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalObjectReference", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalObjectReference == nil {
				m.LocalObjectReference = &LocalObjectReference{}
			}
			if err := m.LocalObjectReference.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &KeyToPath{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Optional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Optional = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigMapVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigMapVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigMapVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalObjectReference", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalObjectReference == nil {
				m.LocalObjectReference = &LocalObjectReference{}
			}
			if err := m.LocalObjectReference.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &KeyToPath{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultMode", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DefaultMode = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Optional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Optional = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Container) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Container: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Container: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Image = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkingDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.WorkingDir = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &ContainerPort{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, &EnvVar{})
			if err := m.Env[len(m.Env)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &ResourceRequirements{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeMounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VolumeMounts = append(m.VolumeMounts, &VolumeMount{})
			if err := m.VolumeMounts[len(m.VolumeMounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LivenessProbe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LivenessProbe == nil {
				m.LivenessProbe = &Probe{}
			}
			if err := m.LivenessProbe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadinessProbe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadinessProbe == nil {
				m.ReadinessProbe = &Probe{}
			}
			if err := m.ReadinessProbe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lifecycle", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lifecycle == nil {
				m.Lifecycle = &Lifecycle{}
			}
			if err := m.Lifecycle.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TerminationMessagePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.TerminationMessagePath = &s
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImagePullPolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ImagePullPolicy = &s
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecurityContext == nil {
				m.SecurityContext = &SecurityContext{}
			}
			if err := m.SecurityContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Stdin = &b
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StdinOnce", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.StdinOnce = &b
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tty", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Tty = &b
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvFrom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvFrom = append(m.EnvFrom, &EnvFromSource{})
			if err := m.EnvFrom[len(m.EnvFrom)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TerminationMessagePolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.TerminationMessagePolicy = &s
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeDevices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VolumeDevices = append(m.VolumeDevices, &VolumeDevice{})
			if err := m.VolumeDevices[len(m.VolumeDevices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerImage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerImage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerImage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeBytes", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SizeBytes = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerPort) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerPort: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerPort: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPort", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HostPort = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPort", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainerPort = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Protocol = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostIP", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.HostIP = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Waiting", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Waiting == nil {
				m.Waiting = &ContainerStateWaiting{}
			}
			if err := m.Waiting.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Running", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Running == nil {
				m.Running = &ContainerStateRunning{}
			}
			if err := m.Running.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Terminated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Terminated == nil {
				m.Terminated = &ContainerStateTerminated{}
			}
			if err := m.Terminated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStateRunning) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStateRunning: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStateRunning: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedAt == nil {
				m.StartedAt = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.StartedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStateTerminated) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStateTerminated: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStateTerminated: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitCode", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExitCode = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signal", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Signal = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Reason = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedAt == nil {
				m.StartedAt = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.StartedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FinishedAt == nil {
				m.FinishedAt = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.FinishedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ContainerID = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStateWaiting) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStateWaiting: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStateWaiting: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Reason = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.State == nil {
				m.State = &ContainerState{}
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastState == nil {
				m.LastState = &ContainerState{}
			}
			if err := m.LastState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Ready = &b
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RestartCount", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RestartCount = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Image = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ImageID = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ContainerID = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DaemonEndpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DaemonEndpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DaemonEndpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GracePeriodSeconds", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.GracePeriodSeconds = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Preconditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Preconditions == nil {
				m.Preconditions = &Preconditions{}
			}
			if err := m.Preconditions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrphanDependents", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.OrphanDependents = &b
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PropagationPolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PropagationPolicy = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownwardAPIProjection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownwardAPIProjection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownwardAPIProjection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &DownwardAPIVolumeFile{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownwardAPIVolumeFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownwardAPIVolumeFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownwardAPIVolumeFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FieldRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FieldRef == nil {
				m.FieldRef = &ObjectFieldSelector{}
			}
			if err := m.FieldRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceFieldRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceFieldRef == nil {
				m.ResourceFieldRef = &ResourceFieldSelector{}
			}
			if err := m.ResourceFieldRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mode = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownwardAPIVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownwardAPIVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownwardAPIVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &DownwardAPIVolumeFile{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultMode", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DefaultMode = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EmptyDirVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EmptyDirVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EmptyDirVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Medium", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Medium = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeLimit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SizeLimit == nil {
				m.SizeLimit = &k8s_io_apimachinery_pkg_api_resource.Quantity{}
			}
			if err := m.SizeLimit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Ip = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TargetRef == nil {
				m.TargetRef = &ObjectReference{}
			}
			if err := m.TargetRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.NodeName = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointPort) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointPort: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointPort: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Protocol = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointSubset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointSubset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointSubset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, &EndpointAddress{})
			if err := m.Addresses[len(m.Addresses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotReadyAddresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotReadyAddresses = append(m.NotReadyAddresses, &EndpointAddress{})
			if err := m.NotReadyAddresses[len(m.NotReadyAddresses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &EndpointPort{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Endpoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Endpoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Endpoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subsets = append(m.Subsets, &EndpointSubset{})
			if err := m.Subsets[len(m.Subsets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointsList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointsList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointsList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Endpoints{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvFromSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvFromSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvFromSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Prefix = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigMapRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConfigMapRef == nil {
				m.ConfigMapRef = &ConfigMapEnvSource{}
			}
			if err := m.ConfigMapRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &SecretEnvSource{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvVar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvVar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvVar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueFrom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValueFrom == nil {
				m.ValueFrom = &EnvVarSource{}
			}
			if err := m.ValueFrom.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvVarSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvVarSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvVarSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FieldRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FieldRef == nil {
				m.FieldRef = &ObjectFieldSelector{}
			}
			if err := m.FieldRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceFieldRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceFieldRef == nil {
				m.ResourceFieldRef = &ResourceFieldSelector{}
			}
			if err := m.ResourceFieldRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigMapKeyRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConfigMapKeyRef == nil {
				m.ConfigMapKeyRef = &ConfigMapKeySelector{}
			}
			if err := m.ConfigMapKeyRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretKeyRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretKeyRef == nil {
				m.SecretKeyRef = &SecretKeySelector{}
			}
			if err := m.SecretKeyRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InvolvedObject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InvolvedObject == nil {
				m.InvolvedObject = &ObjectReference{}
			}
			if err := m.InvolvedObject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Reason = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Source == nil {
				m.Source = &EventSource{}
			}
			if err := m.Source.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstTimestamp == nil {
				m.FirstTimestamp = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.FirstTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastTimestamp == nil {
				m.LastTimestamp = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.LastTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Count = &v
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EventTime == nil {
				m.EventTime = &k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime{}
			}
			if err := m.EventTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Series == nil {
				m.Series = &EventSeries{}
			}
			if err := m.Series.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Action = &s
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Related", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Related == nil {
				m.Related = &ObjectReference{}
			}
			if err := m.Related.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingComponent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ReportingComponent = &s
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingInstance", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ReportingInstance = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Event{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventSeries) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventSeries: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventSeries: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Count = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastObservedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastObservedTime == nil {
				m.LastObservedTime = &k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime{}
			}
			if err := m.LastObservedTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.State = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Component", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Component = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Host = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FCVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FCVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FCVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetWWNs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetWWNs = append(m.TargetWWNs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lun", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Lun = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Wwids", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Wwids = append(m.Wwids, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlexPersistentVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlexPersistentVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlexPersistentVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Driver = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &SecretReference{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlexVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlexVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlexVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Driver = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &LocalObjectReference{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlockerVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlockerVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlockerVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatasetName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.DatasetName = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatasetUUID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.DatasetUUID = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCEPersistentDiskVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCEPersistentDiskVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCEPersistentDiskVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PdName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PdName = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partition", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Partition = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GitRepoVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitRepoVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitRepoVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Repository", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Repository = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Revision = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Directory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Directory = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GlusterfsVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GlusterfsVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GlusterfsVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoints", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Endpoints = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPGetAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPGetAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPGetAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &k8s_io_apimachinery_pkg_util_intstr.IntOrString{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Host = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheme", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Scheme = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpHeaders = append(m.HttpHeaders, &HTTPHeader{})
			if err := m.HttpHeaders[len(m.HttpHeaders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Handler) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Handler: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Handler: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Exec == nil {
				m.Exec = &ExecAction{}
			}
			if err := m.Exec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpGet", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpGet == nil {
				m.HttpGet = &HTTPGetAction{}
			}
			if err := m.HttpGet.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpSocket == nil {
				m.TcpSocket = &TCPSocketAction{}
			}
			if err := m.TcpSocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HostAlias) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HostAlias: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HostAlias: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Ip = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostnames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostnames = append(m.Hostnames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HostPathVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HostPathVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HostPathVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ISCSIPersistentVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ISCSIPersistentVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ISCSIPersistentVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetPortal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.TargetPortal = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iqn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Iqn = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lun", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Lun = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IscsiInterface", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.IscsiInterface = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Portals", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Portals = append(m.Portals, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChapAuthDiscovery", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ChapAuthDiscovery = &b
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &SecretReference{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChapAuthSession", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ChapAuthSession = &b
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatorName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.InitiatorName = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ISCSIVolumeSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ISCSIVolumeSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ISCSIVolumeSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetPortal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.TargetPortal = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iqn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Iqn = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lun", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Lun = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IscsiInterface", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.IscsiInterface = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FsType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.FsType = &s
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadOnly = &b
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Portals", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Portals = append(m.Portals, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChapAuthDiscovery", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ChapAuthDiscovery = &b
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecretRef == nil {
				m.SecretRef = &LocalObjectReference{}
			}
			if err := m.SecretRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChapAuthSession", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ChapAuthSession = &b
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatorName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.InitiatorName = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyToPath) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyToPath: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyToPath: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mode = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Lifecycle) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lifecycle: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lifecycle: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PostStart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PostStart == nil {
				m.PostStart = &Handler{}
			}
			if err := m.PostStart.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreStop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PreStop == nil {
				m.PreStop = &Handler{}
			}
			if err := m.PreStop.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LimitRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LimitRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LimitRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &LimitRangeSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LimitRangeItem) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LimitRangeItem: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LimitRangeItem: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Max == nil {
				m.Max = make(map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity)
			}
			var mapkey string
			var mapvalue *k8s_io_apimachinery_pkg_api_resource.Quantity
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &k8s_io_apimachinery_pkg_api_resource.Quantity{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Max[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Min == nil {
				m.Min = make(map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity)
			}
			var mapkey string
			var mapvalue *k8s_io_apimachinery_pkg_api_resource.Quantity
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &k8s_io_apimachinery_pkg_api_resource.Quantity{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Min[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Default == nil {
				m.Default = make(map[string]*k8s_io_apimachinery_pkg_api_resource.Quantity)
			}
			var mapkey string
			var mapvalue *k8s_io_apimachinery_pkg_api_resource.Quantity
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
	