//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package dataprotection

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/dataprotection/mgmt/2021-07-01/dataprotection"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AbsoluteMarker = original.AbsoluteMarker

const (
	AbsoluteMarkerAllBackup    AbsoluteMarker = original.AbsoluteMarkerAllBackup
	AbsoluteMarkerFirstOfDay   AbsoluteMarker = original.AbsoluteMarkerFirstOfDay
	AbsoluteMarkerFirstOfMonth AbsoluteMarker = original.AbsoluteMarkerFirstOfMonth
	AbsoluteMarkerFirstOfWeek  AbsoluteMarker = original.AbsoluteMarkerFirstOfWeek
	AbsoluteMarkerFirstOfYear  AbsoluteMarker = original.AbsoluteMarkerFirstOfYear
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type CurrentProtectionState = original.CurrentProtectionState

const (
	CurrentProtectionStateBackupSchedulesSuspended    CurrentProtectionState = original.CurrentProtectionStateBackupSchedulesSuspended
	CurrentProtectionStateConfiguringProtection       CurrentProtectionState = original.CurrentProtectionStateConfiguringProtection
	CurrentProtectionStateConfiguringProtectionFailed CurrentProtectionState = original.CurrentProtectionStateConfiguringProtectionFailed
	CurrentProtectionStateInvalid                     CurrentProtectionState = original.CurrentProtectionStateInvalid
	CurrentProtectionStateNotProtected                CurrentProtectionState = original.CurrentProtectionStateNotProtected
	CurrentProtectionStateProtectionConfigured        CurrentProtectionState = original.CurrentProtectionStateProtectionConfigured
	CurrentProtectionStateProtectionError             CurrentProtectionState = original.CurrentProtectionStateProtectionError
	CurrentProtectionStateProtectionStopped           CurrentProtectionState = original.CurrentProtectionStateProtectionStopped
	CurrentProtectionStateRetentionSchedulesSuspended CurrentProtectionState = original.CurrentProtectionStateRetentionSchedulesSuspended
	CurrentProtectionStateSoftDeleted                 CurrentProtectionState = original.CurrentProtectionStateSoftDeleted
	CurrentProtectionStateSoftDeleting                CurrentProtectionState = original.CurrentProtectionStateSoftDeleting
	CurrentProtectionStateUpdatingProtection          CurrentProtectionState = original.CurrentProtectionStateUpdatingProtection
)

type DataStoreTypes = original.DataStoreTypes

const (
	DataStoreTypesArchiveStore     DataStoreTypes = original.DataStoreTypesArchiveStore
	DataStoreTypesOperationalStore DataStoreTypes = original.DataStoreTypesOperationalStore
	DataStoreTypesVaultStore       DataStoreTypes = original.DataStoreTypesVaultStore
)

type DayOfWeek = original.DayOfWeek

const (
	DayOfWeekFriday    DayOfWeek = original.DayOfWeekFriday
	DayOfWeekMonday    DayOfWeek = original.DayOfWeekMonday
	DayOfWeekSaturday  DayOfWeek = original.DayOfWeekSaturday
	DayOfWeekSunday    DayOfWeek = original.DayOfWeekSunday
	DayOfWeekThursday  DayOfWeek = original.DayOfWeekThursday
	DayOfWeekTuesday   DayOfWeek = original.DayOfWeekTuesday
	DayOfWeekWednesday DayOfWeek = original.DayOfWeekWednesday
)

type FeatureSupportStatus = original.FeatureSupportStatus

const (
	FeatureSupportStatusAlphaPreview       FeatureSupportStatus = original.FeatureSupportStatusAlphaPreview
	FeatureSupportStatusGenerallyAvailable FeatureSupportStatus = original.FeatureSupportStatusGenerallyAvailable
	FeatureSupportStatusInvalid            FeatureSupportStatus = original.FeatureSupportStatusInvalid
	FeatureSupportStatusNotSupported       FeatureSupportStatus = original.FeatureSupportStatusNotSupported
	FeatureSupportStatusPrivatePreview     FeatureSupportStatus = original.FeatureSupportStatusPrivatePreview
	FeatureSupportStatusPublicPreview      FeatureSupportStatus = original.FeatureSupportStatusPublicPreview
)

type FeatureType = original.FeatureType

const (
	FeatureTypeDataSourceType FeatureType = original.FeatureTypeDataSourceType
	FeatureTypeInvalid        FeatureType = original.FeatureTypeInvalid
)

type Month = original.Month

const (
	MonthApril     Month = original.MonthApril
	MonthAugust    Month = original.MonthAugust
	MonthDecember  Month = original.MonthDecember
	MonthFebruary  Month = original.MonthFebruary
	MonthJanuary   Month = original.MonthJanuary
	MonthJuly      Month = original.MonthJuly
	MonthJune      Month = original.MonthJune
	MonthMarch     Month = original.MonthMarch
	MonthMay       Month = original.MonthMay
	MonthNovember  Month = original.MonthNovember
	MonthOctober   Month = original.MonthOctober
	MonthSeptember Month = original.MonthSeptember
)

type ObjectType = original.ObjectType

const (
	ObjectTypeAuthCredentials                 ObjectType = original.ObjectTypeAuthCredentials
	ObjectTypeSecretStoreBasedAuthCredentials ObjectType = original.ObjectTypeSecretStoreBasedAuthCredentials
)

type ObjectTypeBasicAzureBackupRecoveryPoint = original.ObjectTypeBasicAzureBackupRecoveryPoint

const (
	ObjectTypeBasicAzureBackupRecoveryPointObjectTypeAzureBackupDiscreteRecoveryPoint ObjectTypeBasicAzureBackupRecoveryPoint = original.ObjectTypeBasicAzureBackupRecoveryPointObjectTypeAzureBackupDiscreteRecoveryPoint
	ObjectTypeBasicAzureBackupRecoveryPointObjectTypeAzureBackupRecoveryPoint         ObjectTypeBasicAzureBackupRecoveryPoint = original.ObjectTypeBasicAzureBackupRecoveryPointObjectTypeAzureBackupRecoveryPoint
)

type ObjectTypeBasicAzureBackupRestoreRequest = original.ObjectTypeBasicAzureBackupRestoreRequest

const (
	ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRecoveryPointBasedRestoreRequest ObjectTypeBasicAzureBackupRestoreRequest = original.ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRecoveryPointBasedRestoreRequest
	ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest  ObjectTypeBasicAzureBackupRestoreRequest = original.ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest
	ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRestoreRequest                   ObjectTypeBasicAzureBackupRestoreRequest = original.ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRestoreRequest
	ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRestoreWithRehydrationRequest    ObjectTypeBasicAzureBackupRestoreRequest = original.ObjectTypeBasicAzureBackupRestoreRequestObjectTypeAzureBackupRestoreWithRehydrationRequest
)

type ObjectTypeBasicBackupCriteria = original.ObjectTypeBasicBackupCriteria

const (
	ObjectTypeBasicBackupCriteriaObjectTypeBackupCriteria              ObjectTypeBasicBackupCriteria = original.ObjectTypeBasicBackupCriteriaObjectTypeBackupCriteria
	ObjectTypeBasicBackupCriteriaObjectTypeScheduleBasedBackupCriteria ObjectTypeBasicBackupCriteria = original.ObjectTypeBasicBackupCriteriaObjectTypeScheduleBasedBackupCriteria
)

type ObjectTypeBasicBackupParameters = original.ObjectTypeBasicBackupParameters

const (
	ObjectTypeBasicBackupParametersObjectTypeAzureBackupParams ObjectTypeBasicBackupParameters = original.ObjectTypeBasicBackupParametersObjectTypeAzureBackupParams
	ObjectTypeBasicBackupParametersObjectTypeBackupParameters  ObjectTypeBasicBackupParameters = original.ObjectTypeBasicBackupParametersObjectTypeBackupParameters
)

type ObjectTypeBasicBaseBackupPolicy = original.ObjectTypeBasicBaseBackupPolicy

const (
	ObjectTypeBasicBaseBackupPolicyObjectTypeBackupPolicy     ObjectTypeBasicBaseBackupPolicy = original.ObjectTypeBasicBaseBackupPolicyObjectTypeBackupPolicy
	ObjectTypeBasicBaseBackupPolicyObjectTypeBaseBackupPolicy ObjectTypeBasicBaseBackupPolicy = original.ObjectTypeBasicBaseBackupPolicyObjectTypeBaseBackupPolicy
)

type ObjectTypeBasicBasePolicyRule = original.ObjectTypeBasicBasePolicyRule

const (
	ObjectTypeBasicBasePolicyRuleObjectTypeAzureBackupRule    ObjectTypeBasicBasePolicyRule = original.ObjectTypeBasicBasePolicyRuleObjectTypeAzureBackupRule
	ObjectTypeBasicBasePolicyRuleObjectTypeAzureRetentionRule ObjectTypeBasicBasePolicyRule = original.ObjectTypeBasicBasePolicyRuleObjectTypeAzureRetentionRule
	ObjectTypeBasicBasePolicyRuleObjectTypeBasePolicyRule     ObjectTypeBasicBasePolicyRule = original.ObjectTypeBasicBasePolicyRuleObjectTypeBasePolicyRule
)

type ObjectTypeBasicCopyOption = original.ObjectTypeBasicCopyOption

const (
	ObjectTypeBasicCopyOptionObjectTypeCopyOnExpiryOption  ObjectTypeBasicCopyOption = original.ObjectTypeBasicCopyOptionObjectTypeCopyOnExpiryOption
	ObjectTypeBasicCopyOptionObjectTypeCopyOption          ObjectTypeBasicCopyOption = original.ObjectTypeBasicCopyOptionObjectTypeCopyOption
	ObjectTypeBasicCopyOptionObjectTypeCustomCopyOption    ObjectTypeBasicCopyOption = original.ObjectTypeBasicCopyOptionObjectTypeCustomCopyOption
	ObjectTypeBasicCopyOptionObjectTypeImmediateCopyOption ObjectTypeBasicCopyOption = original.ObjectTypeBasicCopyOptionObjectTypeImmediateCopyOption
)

type ObjectTypeBasicDataStoreParameters = original.ObjectTypeBasicDataStoreParameters

const (
	ObjectTypeBasicDataStoreParametersObjectTypeAzureOperationalStoreParameters ObjectTypeBasicDataStoreParameters = original.ObjectTypeBasicDataStoreParametersObjectTypeAzureOperationalStoreParameters
	ObjectTypeBasicDataStoreParametersObjectTypeDataStoreParameters             ObjectTypeBasicDataStoreParameters = original.ObjectTypeBasicDataStoreParametersObjectTypeDataStoreParameters
)

type ObjectTypeBasicDeleteOption = original.ObjectTypeBasicDeleteOption

const (
	ObjectTypeBasicDeleteOptionObjectTypeAbsoluteDeleteOption ObjectTypeBasicDeleteOption = original.ObjectTypeBasicDeleteOptionObjectTypeAbsoluteDeleteOption
	ObjectTypeBasicDeleteOptionObjectTypeDeleteOption         ObjectTypeBasicDeleteOption = original.ObjectTypeBasicDeleteOptionObjectTypeDeleteOption
)

type ObjectTypeBasicFeatureValidationRequestBase = original.ObjectTypeBasicFeatureValidationRequestBase

const (
	ObjectTypeBasicFeatureValidationRequestBaseObjectTypeFeatureValidationRequest     ObjectTypeBasicFeatureValidationRequestBase = original.ObjectTypeBasicFeatureValidationRequestBaseObjectTypeFeatureValidationRequest
	ObjectTypeBasicFeatureValidationRequestBaseObjectTypeFeatureValidationRequestBase ObjectTypeBasicFeatureValidationRequestBase = original.ObjectTypeBasicFeatureValidationRequestBaseObjectTypeFeatureValidationRequestBase
)

type ObjectTypeBasicFeatureValidationResponseBase = original.ObjectTypeBasicFeatureValidationResponseBase

const (
	ObjectTypeBasicFeatureValidationResponseBaseObjectTypeFeatureValidationResponse     ObjectTypeBasicFeatureValidationResponseBase = original.ObjectTypeBasicFeatureValidationResponseBaseObjectTypeFeatureValidationResponse
	ObjectTypeBasicFeatureValidationResponseBaseObjectTypeFeatureValidationResponseBase ObjectTypeBasicFeatureValidationResponseBase = original.ObjectTypeBasicFeatureValidationResponseBaseObjectTypeFeatureValidationResponseBase
)

type ObjectTypeBasicItemLevelRestoreCriteria = original.ObjectTypeBasicItemLevelRestoreCriteria

const (
	ObjectTypeBasicItemLevelRestoreCriteriaObjectTypeItemLevelRestoreCriteria           ObjectTypeBasicItemLevelRestoreCriteria = original.ObjectTypeBasicItemLevelRestoreCriteriaObjectTypeItemLevelRestoreCriteria
	ObjectTypeBasicItemLevelRestoreCriteriaObjectTypeRangeBasedItemLevelRestoreCriteria ObjectTypeBasicItemLevelRestoreCriteria = original.ObjectTypeBasicItemLevelRestoreCriteriaObjectTypeRangeBasedItemLevelRestoreCriteria
)

type ObjectTypeBasicOperationExtendedInfo = original.ObjectTypeBasicOperationExtendedInfo

const (
	ObjectTypeBasicOperationExtendedInfoObjectTypeOperationExtendedInfo    ObjectTypeBasicOperationExtendedInfo = original.ObjectTypeBasicOperationExtendedInfoObjectTypeOperationExtendedInfo
	ObjectTypeBasicOperationExtendedInfoObjectTypeOperationJobExtendedInfo ObjectTypeBasicOperationExtendedInfo = original.ObjectTypeBasicOperationExtendedInfoObjectTypeOperationJobExtendedInfo
)

type ObjectTypeBasicRestoreTargetInfoBase = original.ObjectTypeBasicRestoreTargetInfoBase

const (
	ObjectTypeBasicRestoreTargetInfoBaseObjectTypeItemLevelRestoreTargetInfo ObjectTypeBasicRestoreTargetInfoBase = original.ObjectTypeBasicRestoreTargetInfoBaseObjectTypeItemLevelRestoreTargetInfo
	ObjectTypeBasicRestoreTargetInfoBaseObjectTypeRestoreFilesTargetInfo     ObjectTypeBasicRestoreTargetInfoBase = original.ObjectTypeBasicRestoreTargetInfoBaseObjectTypeRestoreFilesTargetInfo
	ObjectTypeBasicRestoreTargetInfoBaseObjectTypeRestoreTargetInfo          ObjectTypeBasicRestoreTargetInfoBase = original.ObjectTypeBasicRestoreTargetInfoBaseObjectTypeRestoreTargetInfo
	ObjectTypeBasicRestoreTargetInfoBaseObjectTypeRestoreTargetInfoBase      ObjectTypeBasicRestoreTargetInfoBase = original.ObjectTypeBasicRestoreTargetInfoBaseObjectTypeRestoreTargetInfoBase
)

type ObjectTypeBasicTriggerContext = original.ObjectTypeBasicTriggerContext

const (
	ObjectTypeBasicTriggerContextObjectTypeAdhocBasedTriggerContext    ObjectTypeBasicTriggerContext = original.ObjectTypeBasicTriggerContextObjectTypeAdhocBasedTriggerContext
	ObjectTypeBasicTriggerContextObjectTypeScheduleBasedTriggerContext ObjectTypeBasicTriggerContext = original.ObjectTypeBasicTriggerContextObjectTypeScheduleBasedTriggerContext
	ObjectTypeBasicTriggerContextObjectTypeTriggerContext              ObjectTypeBasicTriggerContext = original.ObjectTypeBasicTriggerContextObjectTypeTriggerContext
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateFailed       ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateProvisioning ProvisioningState = original.ProvisioningStateProvisioning
	ProvisioningStateSucceeded    ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUnknown      ProvisioningState = original.ProvisioningStateUnknown
	ProvisioningStateUpdating     ProvisioningState = original.ProvisioningStateUpdating
)

type RehydrationPriority = original.RehydrationPriority

const (
	RehydrationPriorityHigh     RehydrationPriority = original.RehydrationPriorityHigh
	RehydrationPriorityInvalid  RehydrationPriority = original.RehydrationPriorityInvalid
	RehydrationPriorityStandard RehydrationPriority = original.RehydrationPriorityStandard
)

type RehydrationStatus = original.RehydrationStatus

const (
	RehydrationStatusCOMPLETED        RehydrationStatus = original.RehydrationStatusCOMPLETED
	RehydrationStatusCREATEINPROGRESS RehydrationStatus = original.RehydrationStatusCREATEINPROGRESS
	RehydrationStatusDELETED          RehydrationStatus = original.RehydrationStatusDELETED
	RehydrationStatusDELETEINPROGRESS RehydrationStatus = original.RehydrationStatusDELETEINPROGRESS
	RehydrationStatusFAILED           RehydrationStatus = original.RehydrationStatusFAILED
)

type ResourceMoveState = original.ResourceMoveState

const (
	ResourceMoveStateCommitFailed    ResourceMoveState = original.ResourceMoveStateCommitFailed
	ResourceMoveStateCommitTimedout  ResourceMoveState = original.ResourceMoveStateCommitTimedout
	ResourceMoveStateCriticalFailure ResourceMoveState = original.ResourceMoveStateCriticalFailure
	ResourceMoveStateFailed          ResourceMoveState = original.ResourceMoveStateFailed
	ResourceMoveStateInProgress      ResourceMoveState = original.ResourceMoveStateInProgress
	ResourceMoveStateMoveSucceeded   ResourceMoveState = original.ResourceMoveStateMoveSucceeded
	ResourceMoveStatePartialSuccess  ResourceMoveState = original.ResourceMoveStatePartialSuccess
	ResourceMoveStatePrepareFailed   ResourceMoveState = original.ResourceMoveStatePrepareFailed
	ResourceMoveStatePrepareTimedout ResourceMoveState = original.ResourceMoveStatePrepareTimedout
	ResourceMoveStateUnknown         ResourceMoveState = original.ResourceMoveStateUnknown
)

type RestoreSourceDataStoreType = original.RestoreSourceDataStoreType

const (
	RestoreSourceDataStoreTypeArchiveStore     RestoreSourceDataStoreType = original.RestoreSourceDataStoreTypeArchiveStore
	RestoreSourceDataStoreTypeOperationalStore RestoreSourceDataStoreType = original.RestoreSourceDataStoreTypeOperationalStore
	RestoreSourceDataStoreTypeVaultStore       RestoreSourceDataStoreType = original.RestoreSourceDataStoreTypeVaultStore
)

type RestoreTargetLocationType = original.RestoreTargetLocationType

const (
	RestoreTargetLocationTypeAzureBlobs RestoreTargetLocationType = original.RestoreTargetLocationTypeAzureBlobs
	RestoreTargetLocationTypeAzureFiles RestoreTargetLocationType = original.RestoreTargetLocationTypeAzureFiles
	RestoreTargetLocationTypeInvalid    RestoreTargetLocationType = original.RestoreTargetLocationTypeInvalid
)

type SecretStoreType = original.SecretStoreType

const (
	SecretStoreTypeAzureKeyVault SecretStoreType = original.SecretStoreTypeAzureKeyVault
	SecretStoreTypeInvalid       SecretStoreType = original.SecretStoreTypeInvalid
)

type SourceDataStoreType = original.SourceDataStoreType

const (
	SourceDataStoreTypeArchiveStore  SourceDataStoreType = original.SourceDataStoreTypeArchiveStore
	SourceDataStoreTypeSnapshotStore SourceDataStoreType = original.SourceDataStoreTypeSnapshotStore
	SourceDataStoreTypeVaultStore    SourceDataStoreType = original.SourceDataStoreTypeVaultStore
)

type Status = original.Status

const (
	StatusConfiguringProtection       Status = original.StatusConfiguringProtection
	StatusConfiguringProtectionFailed Status = original.StatusConfiguringProtectionFailed
	StatusProtectionConfigured        Status = original.StatusProtectionConfigured
	StatusProtectionStopped           Status = original.StatusProtectionStopped
	StatusSoftDeleted                 Status = original.StatusSoftDeleted
	StatusSoftDeleting                Status = original.StatusSoftDeleting
)

type StorageSettingStoreTypes = original.StorageSettingStoreTypes

const (
	StorageSettingStoreTypesArchiveStore  StorageSettingStoreTypes = original.StorageSettingStoreTypesArchiveStore
	StorageSettingStoreTypesSnapshotStore StorageSettingStoreTypes = original.StorageSettingStoreTypesSnapshotStore
	StorageSettingStoreTypesVaultStore    StorageSettingStoreTypes = original.StorageSettingStoreTypesVaultStore
)

type StorageSettingTypes = original.StorageSettingTypes

const (
	StorageSettingTypesGeoRedundant     StorageSettingTypes = original.StorageSettingTypesGeoRedundant
	StorageSettingTypesLocallyRedundant StorageSettingTypes = original.StorageSettingTypesLocallyRedundant
)

type WeekNumber = original.WeekNumber

const (
	WeekNumberFirst  WeekNumber = original.WeekNumberFirst
	WeekNumberFourth WeekNumber = original.WeekNumberFourth
	WeekNumberLast   WeekNumber = original.WeekNumberLast
	WeekNumberSecond WeekNumber = original.WeekNumberSecond
	WeekNumberThird  WeekNumber = original.WeekNumberThird
)

type AbsoluteDeleteOption = original.AbsoluteDeleteOption
type AdHocBackupRuleOptions = original.AdHocBackupRuleOptions
type AdhocBackupTriggerOption = original.AdhocBackupTriggerOption
type AdhocBasedTaggingCriteria = original.AdhocBasedTaggingCriteria
type AdhocBasedTriggerContext = original.AdhocBasedTriggerContext
type AuthCredentials = original.AuthCredentials
type AzureBackupDiscreteRecoveryPoint = original.AzureBackupDiscreteRecoveryPoint
type AzureBackupFindRestorableTimeRangesRequest = original.AzureBackupFindRestorableTimeRangesRequest
type AzureBackupFindRestorableTimeRangesRequestResource = original.AzureBackupFindRestorableTimeRangesRequestResource
type AzureBackupFindRestorableTimeRangesResponse = original.AzureBackupFindRestorableTimeRangesResponse
type AzureBackupFindRestorableTimeRangesResponseResource = original.AzureBackupFindRestorableTimeRangesResponseResource
type AzureBackupJob = original.AzureBackupJob
type AzureBackupJobResource = original.AzureBackupJobResource
type AzureBackupJobResourceList = original.AzureBackupJobResourceList
type AzureBackupJobResourceListIterator = original.AzureBackupJobResourceListIterator
type AzureBackupJobResourceListPage = original.AzureBackupJobResourceListPage
type AzureBackupParams = original.AzureBackupParams
type AzureBackupRecoveryPoint = original.AzureBackupRecoveryPoint
type AzureBackupRecoveryPointBasedRestoreRequest = original.AzureBackupRecoveryPointBasedRestoreRequest
type AzureBackupRecoveryPointResource = original.AzureBackupRecoveryPointResource
type AzureBackupRecoveryPointResourceList = original.AzureBackupRecoveryPointResourceList
type AzureBackupRecoveryPointResourceListIterator = original.AzureBackupRecoveryPointResourceListIterator
type AzureBackupRecoveryPointResourceListPage = original.AzureBackupRecoveryPointResourceListPage
type AzureBackupRecoveryTimeBasedRestoreRequest = original.AzureBackupRecoveryTimeBasedRestoreRequest
type AzureBackupRehydrationRequest = original.AzureBackupRehydrationRequest
type AzureBackupRestoreRequest = original.AzureBackupRestoreRequest
type AzureBackupRestoreWithRehydrationRequest = original.AzureBackupRestoreWithRehydrationRequest
type AzureBackupRule = original.AzureBackupRule
type AzureOperationalStoreParameters = original.AzureOperationalStoreParameters
type AzureRetentionRule = original.AzureRetentionRule
type BackupCriteria = original.BackupCriteria
type BackupInstance = original.BackupInstance
type BackupInstanceResource = original.BackupInstanceResource
type BackupInstanceResourceList = original.BackupInstanceResourceList
type BackupInstanceResourceListIterator = original.BackupInstanceResourceListIterator
type BackupInstanceResourceListPage = original.BackupInstanceResourceListPage
type BackupInstancesAdhocBackupFuture = original.BackupInstancesAdhocBackupFuture
type BackupInstancesClient = original.BackupInstancesClient
type BackupInstancesCreateOrUpdateFuture = original.BackupInstancesCreateOrUpdateFuture
type BackupInstancesDeleteFuture = original.BackupInstancesDeleteFuture
type BackupInstancesTriggerRehydrateFuture = original.BackupInstancesTriggerRehydrateFuture
type BackupInstancesTriggerRestoreFuture = original.BackupInstancesTriggerRestoreFuture
type BackupInstancesValidateForBackupFuture = original.BackupInstancesValidateForBackupFuture
type BackupInstancesValidateForRestoreFuture = original.BackupInstancesValidateForRestoreFuture
type BackupParameters = original.BackupParameters
type BackupPoliciesClient = original.BackupPoliciesClient
type BackupPolicy = original.BackupPolicy
type BackupSchedule = original.BackupSchedule
type BackupVault = original.BackupVault
type BackupVaultOperationResultsClient = original.BackupVaultOperationResultsClient
type BackupVaultResource = original.BackupVaultResource
type BackupVaultResourceList = original.BackupVaultResourceList
type BackupVaultResourceListIterator = original.BackupVaultResourceListIterator
type BackupVaultResourceListPage = original.BackupVaultResourceListPage
type BackupVaultsClient = original.BackupVaultsClient
type BackupVaultsCreateOrUpdateFuture = original.BackupVaultsCreateOrUpdateFuture
type BackupVaultsUpdateFuture = original.BackupVaultsUpdateFuture
type BaseBackupPolicy = original.BaseBackupPolicy
type BaseBackupPolicyResource = original.BaseBackupPolicyResource
type BaseBackupPolicyResourceList = original.BaseBackupPolicyResourceList
type BaseBackupPolicyResourceListIterator = original.BaseBackupPolicyResourceListIterator
type BaseBackupPolicyResourceListPage = original.BaseBackupPolicyResourceListPage
type BaseClient = original.BaseClient
type BasePolicyRule = original.BasePolicyRule
type BasicAuthCredentials = original.BasicAuthCredentials
type BasicAzureBackupRecoveryPoint = original.BasicAzureBackupRecoveryPoint
type BasicAzureBackupRecoveryPointBasedRestoreRequest = original.BasicAzureBackupRecoveryPointBasedRestoreRequest
type BasicAzureBackupRestoreRequest = original.BasicAzureBackupRestoreRequest
type BasicBackupCriteria = original.BasicBackupCriteria
type BasicBackupParameters = original.BasicBackupParameters
type BasicBaseBackupPolicy = original.BasicBaseBackupPolicy
type BasicBasePolicyRule = original.BasicBasePolicyRule
type BasicCopyOption = original.BasicCopyOption
type BasicDataStoreParameters = original.BasicDataStoreParameters
type BasicDeleteOption = original.BasicDeleteOption
type BasicFeatureValidationRequestBase = original.BasicFeatureValidationRequestBase
type BasicFeatureValidationResponseBase = original.BasicFeatureValidationResponseBase
type BasicItemLevelRestoreCriteria = original.BasicItemLevelRestoreCriteria
type BasicOperationExtendedInfo = original.BasicOperationExtendedInfo
type BasicRestoreTargetInfoBase = original.BasicRestoreTargetInfoBase
type BasicTriggerContext = original.BasicTriggerContext
type CheckNameAvailabilityRequest = original.CheckNameAvailabilityRequest
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type Client = original.Client
type ClientDiscoveryDisplay = original.ClientDiscoveryDisplay
type ClientDiscoveryForLogSpecification = original.ClientDiscoveryForLogSpecification
type ClientDiscoveryForProperties = original.ClientDiscoveryForProperties
type ClientDiscoveryForServiceSpecification = original.ClientDiscoveryForServiceSpecification
type ClientDiscoveryResponse = original.ClientDiscoveryResponse
type ClientDiscoveryResponseIterator = original.ClientDiscoveryResponseIterator
type ClientDiscoveryResponsePage = original.ClientDiscoveryResponsePage
type ClientDiscoveryValueForSingleAPI = original.ClientDiscoveryValueForSingleAPI
type CloudError = original.CloudError
type CopyOnExpiryOption = original.CopyOnExpiryOption
type CopyOption = original.CopyOption
type CustomCopyOption = original.CustomCopyOption
type DataStoreInfoBase = original.DataStoreInfoBase
type DataStoreParameters = original.DataStoreParameters
type Datasource = original.Datasource
type DatasourceSet = original.DatasourceSet
type Day = original.Day
type DeleteOption = original.DeleteOption
type DppBaseResource = original.DppBaseResource
type DppBaseResourceList = original.DppBaseResourceList
type DppBaseResourceListIterator = original.DppBaseResourceListIterator
type DppBaseResourceListPage = original.DppBaseResourceListPage
type DppIdentityDetails = original.DppIdentityDetails
type DppResource = original.DppResource
type DppResourceList = original.DppResourceList
type DppTrackedResource = original.DppTrackedResource
type DppTrackedResourceList = original.DppTrackedResourceList
type DppWorkerRequest = original.DppWorkerRequest
type Error = original.Error
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ExportJobsClient = original.ExportJobsClient
type ExportJobsOperationResultClient = original.ExportJobsOperationResultClient
type ExportJobsResult = original.ExportJobsResult
type ExportJobsTriggerFuture = original.ExportJobsTriggerFuture
type FeatureValidationRequest = original.FeatureValidationRequest
type FeatureValidationRequestBase = original.FeatureValidationRequestBase
type FeatureValidationResponse = original.FeatureValidationResponse
type FeatureValidationResponseBase = original.FeatureValidationResponseBase
type FeatureValidationResponseBaseModel = original.FeatureValidationResponseBaseModel
type ImmediateCopyOption = original.ImmediateCopyOption
type InnerError = original.InnerError
type ItemLevelRestoreCriteria = original.ItemLevelRestoreCriteria
type ItemLevelRestoreTargetInfo = original.ItemLevelRestoreTargetInfo
type JobExtendedInfo = original.JobExtendedInfo
type JobSubTask = original.JobSubTask
type JobsClient = original.JobsClient
type OperationExtendedInfo = original.OperationExtendedInfo
type OperationJobExtendedInfo = original.OperationJobExtendedInfo
type OperationResource = original.OperationResource
type OperationResultClient = original.OperationResultClient
type OperationStatusClient = original.OperationStatusClient
type OperationsClient = original.OperationsClient
type PatchResourceRequestInput = original.PatchResourceRequestInput
type PolicyInfo = original.PolicyInfo
type PolicyParameters = original.PolicyParameters
type ProtectionStatusDetails = original.ProtectionStatusDetails
type RangeBasedItemLevelRestoreCriteria = original.RangeBasedItemLevelRestoreCriteria
type RecoveryPointDataStoreDetails = original.RecoveryPointDataStoreDetails
type RecoveryPointsClient = original.RecoveryPointsClient
type RecoveryPointsFilters = original.RecoveryPointsFilters
type ResourceGuard = original.ResourceGuard
type ResourceGuardOperation = original.ResourceGuardOperation
type ResourceGuardResource = original.ResourceGuardResource
type ResourceGuardResourceList = original.ResourceGuardResourceList
type ResourceGuardResourceListIterator = original.ResourceGuardResourceListIterator
type ResourceGuardResourceListPage = original.ResourceGuardResourceListPage
type ResourceGuardsClient = original.ResourceGuardsClient
type ResourceMoveDetails = original.ResourceMoveDetails
type RestorableTimeRange = original.RestorableTimeRange
type RestorableTimeRangesClient = original.RestorableTimeRangesClient
type RestoreFilesTargetInfo = original.RestoreFilesTargetInfo
type RestoreJobRecoveryPointDetails = original.RestoreJobRecoveryPointDetails
type RestoreTargetInfo = original.RestoreTargetInfo
type RestoreTargetInfoBase = original.RestoreTargetInfoBase
type RetentionTag = original.RetentionTag
type ScheduleBasedBackupCriteria = original.ScheduleBasedBackupCriteria
type ScheduleBasedTriggerContext = original.ScheduleBasedTriggerContext
type SecretStoreBasedAuthCredentials = original.SecretStoreBasedAuthCredentials
type SecretStoreResource = original.SecretStoreResource
type SourceLifeCycle = original.SourceLifeCycle
type StorageSetting = original.StorageSetting
type SupportedFeature = original.SupportedFeature
type SystemData = original.SystemData
type TaggingCriteria = original.TaggingCriteria
type TargetCopySetting = original.TargetCopySetting
type TargetDetails = original.TargetDetails
type TriggerBackupRequest = original.TriggerBackupRequest
type TriggerContext = original.TriggerContext
type UserFacingError = original.UserFacingError
type ValidateForBackupRequest = original.ValidateForBackupRequest
type ValidateRestoreRequestObject = original.ValidateRestoreRequestObject

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAzureBackupJobResourceListIterator(page AzureBackupJobResourceListPage) AzureBackupJobResourceListIterator {
	return original.NewAzureBackupJobResourceListIterator(page)
}
func NewAzureBackupJobResourceListPage(cur AzureBackupJobResourceList, getNextPage func(context.Context, AzureBackupJobResourceList) (AzureBackupJobResourceList, error)) AzureBackupJobResourceListPage {
	return original.NewAzureBackupJobResourceListPage(cur, getNextPage)
}
func NewAzureBackupRecoveryPointResourceListIterator(page AzureBackupRecoveryPointResourceListPage) AzureBackupRecoveryPointResourceListIterator {
	return original.NewAzureBackupRecoveryPointResourceListIterator(page)
}
func NewAzureBackupRecoveryPointResourceListPage(cur AzureBackupRecoveryPointResourceList, getNextPage func(context.Context, AzureBackupRecoveryPointResourceList) (AzureBackupRecoveryPointResourceList, error)) AzureBackupRecoveryPointResourceListPage {
	return original.NewAzureBackupRecoveryPointResourceListPage(cur, getNextPage)
}
func NewBackupInstanceResourceListIterator(page BackupInstanceResourceListPage) BackupInstanceResourceListIterator {
	return original.NewBackupInstanceResourceListIterator(page)
}
func NewBackupInstanceResourceListPage(cur BackupInstanceResourceList, getNextPage func(context.Context, BackupInstanceResourceList) (BackupInstanceResourceList, error)) BackupInstanceResourceListPage {
	return original.NewBackupInstanceResourceListPage(cur, getNextPage)
}
func NewBackupInstancesClient(subscriptionID string) BackupInstancesClient {
	return original.NewBackupInstancesClient(subscriptionID)
}
func NewBackupInstancesClientWithBaseURI(baseURI string, subscriptionID string) BackupInstancesClient {
	return original.NewBackupInstancesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBackupPoliciesClient(subscriptionID string) BackupPoliciesClient {
	return original.NewBackupPoliciesClient(subscriptionID)
}
func NewBackupPoliciesClientWithBaseURI(baseURI string, subscriptionID string) BackupPoliciesClient {
	return original.NewBackupPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBackupVaultOperationResultsClient(subscriptionID string) BackupVaultOperationResultsClient {
	return original.NewBackupVaultOperationResultsClient(subscriptionID)
}
func NewBackupVaultOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) BackupVaultOperationResultsClient {
	return original.NewBackupVaultOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBackupVaultResourceListIterator(page BackupVaultResourceListPage) BackupVaultResourceListIterator {
	return original.NewBackupVaultResourceListIterator(page)
}
func NewBackupVaultResourceListPage(cur BackupVaultResourceList, getNextPage func(context.Context, BackupVaultResourceList) (BackupVaultResourceList, error)) BackupVaultResourceListPage {
	return original.NewBackupVaultResourceListPage(cur, getNextPage)
}
func NewBackupVaultsClient(subscriptionID string) BackupVaultsClient {
	return original.NewBackupVaultsClient(subscriptionID)
}
func NewBackupVaultsClientWithBaseURI(baseURI string, subscriptionID string) BackupVaultsClient {
	return original.NewBackupVaultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBaseBackupPolicyResourceListIterator(page BaseBackupPolicyResourceListPage) BaseBackupPolicyResourceListIterator {
	return original.NewBaseBackupPolicyResourceListIterator(page)
}
func NewBaseBackupPolicyResourceListPage(cur BaseBackupPolicyResourceList, getNextPage func(context.Context, BaseBackupPolicyResourceList) (BaseBackupPolicyResourceList, error)) BaseBackupPolicyResourceListPage {
	return original.NewBaseBackupPolicyResourceListPage(cur, getNextPage)
}
func NewClient(subscriptionID string) Client {
	return original.NewClient(subscriptionID)
}
func NewClientDiscoveryResponseIterator(page ClientDiscoveryResponsePage) ClientDiscoveryResponseIterator {
	return original.NewClientDiscoveryResponseIterator(page)
}
func NewClientDiscoveryResponsePage(cur ClientDiscoveryResponse, getNextPage func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)) ClientDiscoveryResponsePage {
	return original.NewClientDiscoveryResponsePage(cur, getNextPage)
}
func NewClientWithBaseURI(baseURI string, subscriptionID string) Client {
	return original.NewClientWithBaseURI(baseURI, subscriptionID)
}
func NewDppBaseResourceListIterator(page DppBaseResourceListPage) DppBaseResourceListIterator {
	return original.NewDppBaseResourceListIterator(page)
}
func NewDppBaseResourceListPage(cur DppBaseResourceList, getNextPage func(context.Context, DppBaseResourceList) (DppBaseResourceList, error)) DppBaseResourceListPage {
	return original.NewDppBaseResourceListPage(cur, getNextPage)
}
func NewExportJobsClient(subscriptionID string) ExportJobsClient {
	return original.NewExportJobsClient(subscriptionID)
}
func NewExportJobsClientWithBaseURI(baseURI string, subscriptionID string) ExportJobsClient {
	return original.NewExportJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExportJobsOperationResultClient(subscriptionID string) ExportJobsOperationResultClient {
	return original.NewExportJobsOperationResultClient(subscriptionID)
}
func NewExportJobsOperationResultClientWithBaseURI(baseURI string, subscriptionID string) ExportJobsOperationResultClient {
	return original.NewExportJobsOperationResultClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobsClient(subscriptionID string) JobsClient {
	return original.NewJobsClient(subscriptionID)
}
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationResultClient(subscriptionID string) OperationResultClient {
	return original.NewOperationResultClient(subscriptionID)
}
func NewOperationResultClientWithBaseURI(baseURI string, subscriptionID string) OperationResultClient {
	return original.NewOperationResultClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationStatusClient(subscriptionID string) OperationStatusClient {
	return original.NewOperationStatusClient(subscriptionID)
}
func NewOperationStatusClientWithBaseURI(baseURI string, subscriptionID string) OperationStatusClient {
	return original.NewOperationStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRecoveryPointsClient(subscriptionID string) RecoveryPointsClient {
	return original.NewRecoveryPointsClient(subscriptionID)
}
func NewRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string) RecoveryPointsClient {
	return original.NewRecoveryPointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceGuardResourceListIterator(page ResourceGuardResourceListPage) ResourceGuardResourceListIterator {
	return original.NewResourceGuardResourceListIterator(page)
}
func NewResourceGuardResourceListPage(cur ResourceGuardResourceList, getNextPage func(context.Context, ResourceGuardResourceList) (ResourceGuardResourceList, error)) ResourceGuardResourceListPage {
	return original.NewResourceGuardResourceListPage(cur, getNextPage)
}
func NewResourceGuardsClient(subscriptionID string) ResourceGuardsClient {
	return original.NewResourceGuardsClient(subscriptionID)
}
func NewResourceGuardsClientWithBaseURI(baseURI string, subscriptionID string) ResourceGuardsClient {
	return original.NewResourceGuardsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableTimeRangesClient(subscriptionID string) RestorableTimeRangesClient {
	return original.NewRestorableTimeRangesClient(subscriptionID)
}
func NewRestorableTimeRangesClientWithBaseURI(baseURI string, subscriptionID string) RestorableTimeRangesClient {
	return original.NewRestorableTimeRangesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAbsoluteMarkerValues() []AbsoluteMarker {
	return original.PossibleAbsoluteMarkerValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleCurrentProtectionStateValues() []CurrentProtectionState {
	return original.PossibleCurrentProtectionStateValues()
}
func PossibleDataStoreTypesValues() []DataStoreTypes {
	return original.PossibleDataStoreTypesValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleFeatureSupportStatusValues() []FeatureSupportStatus {
	return original.PossibleFeatureSupportStatusValues()
}
func PossibleFeatureTypeValues() []FeatureType {
	return original.PossibleFeatureTypeValues()
}
func PossibleMonthValues() []Month {
	return original.PossibleMonthValues()
}
func PossibleObjectTypeBasicAzureBackupRecoveryPointValues() []ObjectTypeBasicAzureBackupRecoveryPoint {
	return original.PossibleObjectTypeBasicAzureBackupRecoveryPointValues()
}
func PossibleObjectTypeBasicAzureBackupRestoreRequestValues() []ObjectTypeBasicAzureBackupRestoreRequest {
	return original.PossibleObjectTypeBasicAzureBackupRestoreRequestValues()
}
func PossibleObjectTypeBasicBackupCriteriaValues() []ObjectTypeBasicBackupCriteria {
	return original.PossibleObjectTypeBasicBackupCriteriaValues()
}
func PossibleObjectTypeBasicBackupParametersValues() []ObjectTypeBasicBackupParameters {
	return original.PossibleObjectTypeBasicBackupParametersValues()
}
func PossibleObjectTypeBasicBaseBackupPolicyValues() []ObjectTypeBasicBaseBackupPolicy {
	return original.PossibleObjectTypeBasicBaseBackupPolicyValues()
}
func PossibleObjectTypeBasicBasePolicyRuleValues() []ObjectTypeBasicBasePolicyRule {
	return original.PossibleObjectTypeBasicBasePolicyRuleValues()
}
func PossibleObjectTypeBasicCopyOptionValues() []ObjectTypeBasicCopyOption {
	return original.PossibleObjectTypeBasicCopyOptionValues()
}
func PossibleObjectTypeBasicDataStoreParametersValues() []ObjectTypeBasicDataStoreParameters {
	return original.PossibleObjectTypeBasicDataStoreParametersValues()
}
func PossibleObjectTypeBasicDeleteOptionValues() []ObjectTypeBasicDeleteOption {
	return original.PossibleObjectTypeBasicDeleteOptionValues()
}
func PossibleObjectTypeBasicFeatureValidationRequestBaseValues() []ObjectTypeBasicFeatureValidationRequestBase {
	return original.PossibleObjectTypeBasicFeatureValidationRequestBaseValues()
}
func PossibleObjectTypeBasicFeatureValidationResponseBaseValues() []ObjectTypeBasicFeatureValidationResponseBase {
	return original.PossibleObjectTypeBasicFeatureValidationResponseBaseValues()
}
func PossibleObjectTypeBasicItemLevelRestoreCriteriaValues() []ObjectTypeBasicItemLevelRestoreCriteria {
	return original.PossibleObjectTypeBasicItemLevelRestoreCriteriaValues()
}
func PossibleObjectTypeBasicOperationExtendedInfoValues() []ObjectTypeBasicOperationExtendedInfo {
	return original.PossibleObjectTypeBasicOperationExtendedInfoValues()
}
func PossibleObjectTypeBasicRestoreTargetInfoBaseValues() []ObjectTypeBasicRestoreTargetInfoBase {
	return original.PossibleObjectTypeBasicRestoreTargetInfoBaseValues()
}
func PossibleObjectTypeBasicTriggerContextValues() []ObjectTypeBasicTriggerContext {
	return original.PossibleObjectTypeBasicTriggerContextValues()
}
func PossibleObjectTypeValues() []ObjectType {
	return original.PossibleObjectTypeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleRehydrationPriorityValues() []RehydrationPriority {
	return original.PossibleRehydrationPriorityValues()
}
func PossibleRehydrationStatusValues() []RehydrationStatus {
	return original.PossibleRehydrationStatusValues()
}
func PossibleResourceMoveStateValues() []ResourceMoveState {
	return original.PossibleResourceMoveStateValues()
}
func PossibleRestoreSourceDataStoreTypeValues() []RestoreSourceDataStoreType {
	return original.PossibleRestoreSourceDataStoreTypeValues()
}
func PossibleRestoreTargetLocationTypeValues() []RestoreTargetLocationType {
	return original.PossibleRestoreTargetLocationTypeValues()
}
func PossibleSecretStoreTypeValues() []SecretStoreType {
	return original.PossibleSecretStoreTypeValues()
}
func PossibleSourceDataStoreTypeValues() []SourceDataStoreType {
	return original.PossibleSourceDataStoreTypeValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleStorageSettingStoreTypesValues() []StorageSettingStoreTypes {
	return original.PossibleStorageSettingStoreTypesValues()
}
func PossibleStorageSettingTypesValues() []StorageSettingTypes {
	return original.PossibleStorageSettingTypesValues()
}
func PossibleWeekNumberValues() []WeekNumber {
	return original.PossibleWeekNumberValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
