//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package mysqlflexibleservers

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/mysql/mgmt/2021-05-01/mysqlflexibleservers"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ConfigurationSource = original.ConfigurationSource

const (
	ConfigurationSourceSystemDefault ConfigurationSource = original.ConfigurationSourceSystemDefault
	ConfigurationSourceUserOverride  ConfigurationSource = original.ConfigurationSourceUserOverride
)

type CreateMode = original.CreateMode

const (
	CreateModeDefault            CreateMode = original.CreateModeDefault
	CreateModeGeoRestore         CreateMode = original.CreateModeGeoRestore
	CreateModePointInTimeRestore CreateMode = original.CreateModePointInTimeRestore
	CreateModeReplica            CreateMode = original.CreateModeReplica
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type EnableStatusEnum = original.EnableStatusEnum

const (
	EnableStatusEnumDisabled EnableStatusEnum = original.EnableStatusEnumDisabled
	EnableStatusEnumEnabled  EnableStatusEnum = original.EnableStatusEnumEnabled
)

type HighAvailabilityMode = original.HighAvailabilityMode

const (
	HighAvailabilityModeDisabled      HighAvailabilityMode = original.HighAvailabilityModeDisabled
	HighAvailabilityModeSameZone      HighAvailabilityMode = original.HighAvailabilityModeSameZone
	HighAvailabilityModeZoneRedundant HighAvailabilityMode = original.HighAvailabilityModeZoneRedundant
)

type HighAvailabilityState = original.HighAvailabilityState

const (
	HighAvailabilityStateCreatingStandby HighAvailabilityState = original.HighAvailabilityStateCreatingStandby
	HighAvailabilityStateFailingOver     HighAvailabilityState = original.HighAvailabilityStateFailingOver
	HighAvailabilityStateHealthy         HighAvailabilityState = original.HighAvailabilityStateHealthy
	HighAvailabilityStateNotEnabled      HighAvailabilityState = original.HighAvailabilityStateNotEnabled
	HighAvailabilityStateRemovingStandby HighAvailabilityState = original.HighAvailabilityStateRemovingStandby
)

type IsConfigPendingRestart = original.IsConfigPendingRestart

const (
	IsConfigPendingRestartFalse IsConfigPendingRestart = original.IsConfigPendingRestartFalse
	IsConfigPendingRestartTrue  IsConfigPendingRestart = original.IsConfigPendingRestartTrue
)

type IsDynamicConfig = original.IsDynamicConfig

const (
	IsDynamicConfigFalse IsDynamicConfig = original.IsDynamicConfigFalse
	IsDynamicConfigTrue  IsDynamicConfig = original.IsDynamicConfigTrue
)

type IsReadOnly = original.IsReadOnly

const (
	IsReadOnlyFalse IsReadOnly = original.IsReadOnlyFalse
	IsReadOnlyTrue  IsReadOnly = original.IsReadOnlyTrue
)

type ReplicationRole = original.ReplicationRole

const (
	ReplicationRoleNone    ReplicationRole = original.ReplicationRoleNone
	ReplicationRoleReplica ReplicationRole = original.ReplicationRoleReplica
	ReplicationRoleSource  ReplicationRole = original.ReplicationRoleSource
)

type ServerState = original.ServerState

const (
	ServerStateDisabled ServerState = original.ServerStateDisabled
	ServerStateDropping ServerState = original.ServerStateDropping
	ServerStateReady    ServerState = original.ServerStateReady
	ServerStateStarting ServerState = original.ServerStateStarting
	ServerStateStopped  ServerState = original.ServerStateStopped
	ServerStateStopping ServerState = original.ServerStateStopping
	ServerStateUpdating ServerState = original.ServerStateUpdating
)

type ServerVersion = original.ServerVersion

const (
	ServerVersionEightFullStopZeroFullStopTwoOne ServerVersion = original.ServerVersionEightFullStopZeroFullStopTwoOne
	ServerVersionFiveFullStopSeven               ServerVersion = original.ServerVersionFiveFullStopSeven
)

type SkuTier = original.SkuTier

const (
	SkuTierBurstable       SkuTier = original.SkuTierBurstable
	SkuTierGeneralPurpose  SkuTier = original.SkuTierGeneralPurpose
	SkuTierMemoryOptimized SkuTier = original.SkuTierMemoryOptimized
)

type AzureEntityResource = original.AzureEntityResource
type Backup = original.Backup
type BackupsClient = original.BackupsClient
type BaseClient = original.BaseClient
type CapabilitiesListResult = original.CapabilitiesListResult
type CapabilitiesListResultIterator = original.CapabilitiesListResultIterator
type CapabilitiesListResultPage = original.CapabilitiesListResultPage
type CapabilityProperties = original.CapabilityProperties
type CheckNameAvailabilityClient = original.CheckNameAvailabilityClient
type CheckVirtualNetworkSubnetUsageClient = original.CheckVirtualNetworkSubnetUsageClient
type CloudError = original.CloudError
type Configuration = original.Configuration
type ConfigurationForBatchUpdate = original.ConfigurationForBatchUpdate
type ConfigurationForBatchUpdateProperties = original.ConfigurationForBatchUpdateProperties
type ConfigurationListForBatchUpdate = original.ConfigurationListForBatchUpdate
type ConfigurationListResult = original.ConfigurationListResult
type ConfigurationListResultIterator = original.ConfigurationListResultIterator
type ConfigurationListResultPage = original.ConfigurationListResultPage
type ConfigurationProperties = original.ConfigurationProperties
type ConfigurationsBatchUpdateFuture = original.ConfigurationsBatchUpdateFuture
type ConfigurationsClient = original.ConfigurationsClient
type ConfigurationsUpdateFuture = original.ConfigurationsUpdateFuture
type Database = original.Database
type DatabaseListResult = original.DatabaseListResult
type DatabaseListResultIterator = original.DatabaseListResultIterator
type DatabaseListResultPage = original.DatabaseListResultPage
type DatabaseProperties = original.DatabaseProperties
type DatabasesClient = original.DatabasesClient
type DatabasesCreateOrUpdateFuture = original.DatabasesCreateOrUpdateFuture
type DatabasesDeleteFuture = original.DatabasesDeleteFuture
type DelegatedSubnetUsage = original.DelegatedSubnetUsage
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorResponse = original.ErrorResponse
type FirewallRule = original.FirewallRule
type FirewallRuleListResult = original.FirewallRuleListResult
type FirewallRuleListResultIterator = original.FirewallRuleListResultIterator
type FirewallRuleListResultPage = original.FirewallRuleListResultPage
type FirewallRuleProperties = original.FirewallRuleProperties
type FirewallRulesClient = original.FirewallRulesClient
type FirewallRulesCreateOrUpdateFuture = original.FirewallRulesCreateOrUpdateFuture
type FirewallRulesDeleteFuture = original.FirewallRulesDeleteFuture
type GetPrivateDNSZoneSuffixClient = original.GetPrivateDNSZoneSuffixClient
type GetPrivateDNSZoneSuffixResponse = original.GetPrivateDNSZoneSuffixResponse
type HighAvailability = original.HighAvailability
type LocationBasedCapabilitiesClient = original.LocationBasedCapabilitiesClient
type MaintenanceWindow = original.MaintenanceWindow
type NameAvailability = original.NameAvailability
type NameAvailabilityRequest = original.NameAvailabilityRequest
type Network = original.Network
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type ReplicasClient = original.ReplicasClient
type Resource = original.Resource
type Server = original.Server
type ServerBackup = original.ServerBackup
type ServerBackupListResult = original.ServerBackupListResult
type ServerBackupListResultIterator = original.ServerBackupListResultIterator
type ServerBackupListResultPage = original.ServerBackupListResultPage
type ServerBackupProperties = original.ServerBackupProperties
type ServerEditionCapability = original.ServerEditionCapability
type ServerForUpdate = original.ServerForUpdate
type ServerListResult = original.ServerListResult
type ServerListResultIterator = original.ServerListResultIterator
type ServerListResultPage = original.ServerListResultPage
type ServerProperties = original.ServerProperties
type ServerPropertiesForUpdate = original.ServerPropertiesForUpdate
type ServerRestartParameter = original.ServerRestartParameter
type ServerVersionCapability = original.ServerVersionCapability
type ServersClient = original.ServersClient
type ServersCreateFuture = original.ServersCreateFuture
type ServersDeleteFuture = original.ServersDeleteFuture
type ServersFailoverFuture = original.ServersFailoverFuture
type ServersRestartFuture = original.ServersRestartFuture
type ServersStartFuture = original.ServersStartFuture
type ServersStopFuture = original.ServersStopFuture
type ServersUpdateFuture = original.ServersUpdateFuture
type Sku = original.Sku
type SkuCapability = original.SkuCapability
type Storage = original.Storage
type StorageEditionCapability = original.StorageEditionCapability
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type VirtualNetworkSubnetUsageParameter = original.VirtualNetworkSubnetUsageParameter
type VirtualNetworkSubnetUsageResult = original.VirtualNetworkSubnetUsageResult

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewBackupsClient(subscriptionID string) BackupsClient {
	return original.NewBackupsClient(subscriptionID)
}
func NewBackupsClientWithBaseURI(baseURI string, subscriptionID string) BackupsClient {
	return original.NewBackupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCapabilitiesListResultIterator(page CapabilitiesListResultPage) CapabilitiesListResultIterator {
	return original.NewCapabilitiesListResultIterator(page)
}
func NewCapabilitiesListResultPage(cur CapabilitiesListResult, getNextPage func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)) CapabilitiesListResultPage {
	return original.NewCapabilitiesListResultPage(cur, getNextPage)
}
func NewCheckNameAvailabilityClient(subscriptionID string) CheckNameAvailabilityClient {
	return original.NewCheckNameAvailabilityClient(subscriptionID)
}
func NewCheckNameAvailabilityClientWithBaseURI(baseURI string, subscriptionID string) CheckNameAvailabilityClient {
	return original.NewCheckNameAvailabilityClientWithBaseURI(baseURI, subscriptionID)
}
func NewCheckVirtualNetworkSubnetUsageClient(subscriptionID string) CheckVirtualNetworkSubnetUsageClient {
	return original.NewCheckVirtualNetworkSubnetUsageClient(subscriptionID)
}
func NewCheckVirtualNetworkSubnetUsageClientWithBaseURI(baseURI string, subscriptionID string) CheckVirtualNetworkSubnetUsageClient {
	return original.NewCheckVirtualNetworkSubnetUsageClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationListResultIterator(page ConfigurationListResultPage) ConfigurationListResultIterator {
	return original.NewConfigurationListResultIterator(page)
}
func NewConfigurationListResultPage(cur ConfigurationListResult, getNextPage func(context.Context, ConfigurationListResult) (ConfigurationListResult, error)) ConfigurationListResultPage {
	return original.NewConfigurationListResultPage(cur, getNextPage)
}
func NewConfigurationsClient(subscriptionID string) ConfigurationsClient {
	return original.NewConfigurationsClient(subscriptionID)
}
func NewConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationsClient {
	return original.NewConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseListResultIterator(page DatabaseListResultPage) DatabaseListResultIterator {
	return original.NewDatabaseListResultIterator(page)
}
func NewDatabaseListResultPage(cur DatabaseListResult, getNextPage func(context.Context, DatabaseListResult) (DatabaseListResult, error)) DatabaseListResultPage {
	return original.NewDatabaseListResultPage(cur, getNextPage)
}
func NewDatabasesClient(subscriptionID string) DatabasesClient {
	return original.NewDatabasesClient(subscriptionID)
}
func NewDatabasesClientWithBaseURI(baseURI string, subscriptionID string) DatabasesClient {
	return original.NewDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return original.NewFirewallRuleListResultIterator(page)
}
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return original.NewFirewallRuleListResultPage(cur, getNextPage)
}
func NewFirewallRulesClient(subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClient(subscriptionID)
}
func NewFirewallRulesClientWithBaseURI(baseURI string, subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewGetPrivateDNSZoneSuffixClient(subscriptionID string) GetPrivateDNSZoneSuffixClient {
	return original.NewGetPrivateDNSZoneSuffixClient(subscriptionID)
}
func NewGetPrivateDNSZoneSuffixClientWithBaseURI(baseURI string, subscriptionID string) GetPrivateDNSZoneSuffixClient {
	return original.NewGetPrivateDNSZoneSuffixClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationBasedCapabilitiesClient(subscriptionID string) LocationBasedCapabilitiesClient {
	return original.NewLocationBasedCapabilitiesClient(subscriptionID)
}
func NewLocationBasedCapabilitiesClientWithBaseURI(baseURI string, subscriptionID string) LocationBasedCapabilitiesClient {
	return original.NewLocationBasedCapabilitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewReplicasClient(subscriptionID string) ReplicasClient {
	return original.NewReplicasClient(subscriptionID)
}
func NewReplicasClientWithBaseURI(baseURI string, subscriptionID string) ReplicasClient {
	return original.NewReplicasClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerBackupListResultIterator(page ServerBackupListResultPage) ServerBackupListResultIterator {
	return original.NewServerBackupListResultIterator(page)
}
func NewServerBackupListResultPage(cur ServerBackupListResult, getNextPage func(context.Context, ServerBackupListResult) (ServerBackupListResult, error)) ServerBackupListResultPage {
	return original.NewServerBackupListResultPage(cur, getNextPage)
}
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return original.NewServerListResultIterator(page)
}
func NewServerListResultPage(cur ServerListResult, getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return original.NewServerListResultPage(cur, getNextPage)
}
func NewServersClient(subscriptionID string) ServersClient {
	return original.NewServersClient(subscriptionID)
}
func NewServersClientWithBaseURI(baseURI string, subscriptionID string) ServersClient {
	return original.NewServersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleConfigurationSourceValues() []ConfigurationSource {
	return original.PossibleConfigurationSourceValues()
}
func PossibleCreateModeValues() []CreateMode {
	return original.PossibleCreateModeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleEnableStatusEnumValues() []EnableStatusEnum {
	return original.PossibleEnableStatusEnumValues()
}
func PossibleHighAvailabilityModeValues() []HighAvailabilityMode {
	return original.PossibleHighAvailabilityModeValues()
}
func PossibleHighAvailabilityStateValues() []HighAvailabilityState {
	return original.PossibleHighAvailabilityStateValues()
}
func PossibleIsConfigPendingRestartValues() []IsConfigPendingRestart {
	return original.PossibleIsConfigPendingRestartValues()
}
func PossibleIsDynamicConfigValues() []IsDynamicConfig {
	return original.PossibleIsDynamicConfigValues()
}
func PossibleIsReadOnlyValues() []IsReadOnly {
	return original.PossibleIsReadOnlyValues()
}
func PossibleReplicationRoleValues() []ReplicationRole {
	return original.PossibleReplicationRoleValues()
}
func PossibleServerStateValues() []ServerState {
	return original.PossibleServerStateValues()
}
func PossibleServerVersionValues() []ServerVersion {
	return original.PossibleServerVersionValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
