// Package spark implements the Azure ARM Spark service API version 2019-11-01-preview.
//
//
package spark

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultLivyAPIVersion is the default value for livy api version
	DefaultLivyAPIVersion = "2019-11-01-preview"
)

// BaseClient is the base client for Spark.
type BaseClient struct {
	autorest.Client
	Endpoint       string
	LivyAPIVersion string
	SparkPoolName  string
}

// New creates an instance of the BaseClient client.
func New(endpoint string, sparkPoolName string) BaseClient {
	return NewWithoutDefaults(endpoint, sparkPoolName, DefaultLivyAPIVersion)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(endpoint string, sparkPoolName string, livyAPIVersion string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		Endpoint:       endpoint,
		LivyAPIVersion: livyAPIVersion,
		SparkPoolName:  sparkPoolName,
	}
}
