// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: copy.gen.go.tmpl

package arrowutil

import (
	"fmt"

	"github.com/apache/arrow/go/arrow/array"
)

// CopyTo will copy the contents of the array into a new array builder.
func CopyTo(b array.Builder, arr array.Interface) {
	switch arr := arr.(type) {

	case *array.Int64:
		CopyInt64sTo(b.(*array.Int64Builder), arr)

	case *array.Uint64:
		CopyUint64sTo(b.(*array.Uint64Builder), arr)

	case *array.Float64:
		CopyFloat64sTo(b.(*array.Float64Builder), arr)

	case *array.Boolean:
		CopyBooleansTo(b.(*array.BooleanBuilder), arr)

	case *array.Binary:
		CopyStringsTo(b.(*array.BinaryBuilder), arr)

	default:
		panic(fmt.Errorf("unsupported array data type: %s", arr.DataType()))
	}
}

// CopyByIndexTo will copy the contents of the array at the given indices into a new array builder.
func CopyByIndexTo(b array.Builder, arr array.Interface, indices *array.Int64) {
	switch arr := arr.(type) {

	case *array.Int64:
		CopyInt64sByIndexTo(b.(*array.Int64Builder), arr, indices)

	case *array.Uint64:
		CopyUint64sByIndexTo(b.(*array.Uint64Builder), arr, indices)

	case *array.Float64:
		CopyFloat64sByIndexTo(b.(*array.Float64Builder), arr, indices)

	case *array.Boolean:
		CopyBooleansByIndexTo(b.(*array.BooleanBuilder), arr, indices)

	case *array.Binary:
		CopyStringsByIndexTo(b.(*array.BinaryBuilder), arr, indices)

	default:
		panic(fmt.Errorf("unsupported array data type: %s", arr.DataType()))
	}
}

// CopyValue will copy an individual value from the array into the builder.
func CopyValue(b array.Builder, arr array.Interface, i int) {
	switch arr := arr.(type) {

	case *array.Int64:
		CopyInt64Value(b.(*array.Int64Builder), arr, i)

	case *array.Uint64:
		CopyUint64Value(b.(*array.Uint64Builder), arr, i)

	case *array.Float64:
		CopyFloat64Value(b.(*array.Float64Builder), arr, i)

	case *array.Boolean:
		CopyBooleanValue(b.(*array.BooleanBuilder), arr, i)

	case *array.Binary:
		CopyStringValue(b.(*array.BinaryBuilder), arr, i)

	default:
		panic(fmt.Errorf("unsupported array data type: %s", arr.DataType()))
	}
}

func CopyInt64sTo(b *array.Int64Builder, arr *array.Int64) {
	b.Reserve(arr.Len())

	for i, n := 0, arr.Len(); i < n; i++ {
		if arr.IsNull(i) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(i))
	}
}

func CopyInt64sByIndexTo(b *array.Int64Builder, arr *array.Int64, indices *array.Int64) {
	b.Reserve(indices.Len())

	for i, n := 0, indices.Len(); i < n; i++ {
		offset := int(indices.Value(i))
		if arr.IsNull(offset) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(offset))
	}
}

func CopyInt64Value(b *array.Int64Builder, arr *array.Int64, i int) {
	if arr.IsNull(i) {
		b.AppendNull()
		return
	}
	b.Append(arr.Value(i))
}

func CopyUint64sTo(b *array.Uint64Builder, arr *array.Uint64) {
	b.Reserve(arr.Len())

	for i, n := 0, arr.Len(); i < n; i++ {
		if arr.IsNull(i) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(i))
	}
}

func CopyUint64sByIndexTo(b *array.Uint64Builder, arr *array.Uint64, indices *array.Int64) {
	b.Reserve(indices.Len())

	for i, n := 0, indices.Len(); i < n; i++ {
		offset := int(indices.Value(i))
		if arr.IsNull(offset) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(offset))
	}
}

func CopyUint64Value(b *array.Uint64Builder, arr *array.Uint64, i int) {
	if arr.IsNull(i) {
		b.AppendNull()
		return
	}
	b.Append(arr.Value(i))
}

func CopyFloat64sTo(b *array.Float64Builder, arr *array.Float64) {
	b.Reserve(arr.Len())

	for i, n := 0, arr.Len(); i < n; i++ {
		if arr.IsNull(i) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(i))
	}
}

func CopyFloat64sByIndexTo(b *array.Float64Builder, arr *array.Float64, indices *array.Int64) {
	b.Reserve(indices.Len())

	for i, n := 0, indices.Len(); i < n; i++ {
		offset := int(indices.Value(i))
		if arr.IsNull(offset) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(offset))
	}
}

func CopyFloat64Value(b *array.Float64Builder, arr *array.Float64, i int) {
	if arr.IsNull(i) {
		b.AppendNull()
		return
	}
	b.Append(arr.Value(i))
}

func CopyBooleansTo(b *array.BooleanBuilder, arr *array.Boolean) {
	b.Reserve(arr.Len())

	for i, n := 0, arr.Len(); i < n; i++ {
		if arr.IsNull(i) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(i))
	}
}

func CopyBooleansByIndexTo(b *array.BooleanBuilder, arr *array.Boolean, indices *array.Int64) {
	b.Reserve(indices.Len())

	for i, n := 0, indices.Len(); i < n; i++ {
		offset := int(indices.Value(i))
		if arr.IsNull(offset) {
			b.AppendNull()
			continue
		}
		b.Append(arr.Value(offset))
	}
}

func CopyBooleanValue(b *array.BooleanBuilder, arr *array.Boolean, i int) {
	if arr.IsNull(i) {
		b.AppendNull()
		return
	}
	b.Append(arr.Value(i))
}

func CopyStringsTo(b *array.BinaryBuilder, arr *array.Binary) {
	b.Reserve(arr.Len())

	{
		sz := 0
		for i, n := 0, arr.Len(); i < n; i++ {
			if arr.IsNull(i) {
				continue
			}
			sz += arr.ValueLen(i)
		}
		b.ReserveData(sz)
	}

	for i, n := 0, arr.Len(); i < n; i++ {
		if arr.IsNull(i) {
			b.AppendNull()
			continue
		}
		b.AppendString(arr.ValueString(i))
	}
}

func CopyStringsByIndexTo(b *array.BinaryBuilder, arr *array.Binary, indices *array.Int64) {
	b.Reserve(indices.Len())

	{
		sz := 0
		for i, n := 0, indices.Len(); i < n; i++ {
			offset := int(indices.Value(i))
			if arr.IsNull(offset) {
				continue
			}
			sz += arr.ValueLen(offset)
		}
		b.ReserveData(sz)
	}

	for i, n := 0, indices.Len(); i < n; i++ {
		offset := int(indices.Value(i))
		if arr.IsNull(offset) {
			b.AppendNull()
			continue
		}
		b.AppendString(arr.ValueString(offset))
	}
}

func CopyStringValue(b *array.BinaryBuilder, arr *array.Binary, i int) {
	if arr.IsNull(i) {
		b.AppendNull()
		return
	}
	b.AppendString(arr.ValueString(i))
}
