// DO NOT EDIT: This file is autogenerated via the builtin command.

package universe

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 48,
					Line:   417,
				},
				File:   "universe.flux",
				Source: "package universe\n\n\nimport \"system\"\nimport \"date\"\nimport \"math\"\nimport \"strings\"\nimport \"regexp\"\n\n// now is a function option whose default behaviour is to return the current system time\noption now = system.time\n\n// Booleans\nbuiltin true : bool\nbuiltin false : bool\n\n// Transformation functions\nbuiltin chandeMomentumOscillator : (<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin columns : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin count : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin covariance : (<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B] where A: Record, B: Record\nbuiltin cumulativeSum : (<-tables: [A], ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin derivative : (\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin die : (msg: string) => A\nbuiltin difference : (<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R] where T: Record, R: Record\nbuiltin distinct : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin drop : (<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin duplicate : (<-tables: [A], column: string, as: string) => [B] where A: Record, B: Record\nbuiltin elapsed : (<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B] where A: Record, B: Record\nbuiltin exponentialMovingAverage : (<-tables: [{B with _value: A}], n: int) => [{B with _value: A}] where A: Numeric\nbuiltin fill : (<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C] where A: Record, C: Record\nbuiltin filter : (<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A] where A: Record\nbuiltin first : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin group : (<-tables: [A], ?mode: string, ?columns: [string]) => [A] where A: Record\nbuiltin histogram : (\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin histogramQuantile : (\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin holtWinters : (\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin hourSelection : (<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A] where A: Record\nbuiltin integral : (\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin join : (<-tables: A, ?method: string, ?on: [string]) => [B] where A: Record, B: Record\nbuiltin kaufmansAMA : (<-tables: [A], n: int, ?column: string) => [B] where A: Record, B: Record\nbuiltin keep : (<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B] where A: Record, B: Record\nbuiltin keyValues : (<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}] where A: Record, C: Record\nbuiltin keys : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin last : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin limit : (<-tables: [A], n: int, ?offset: int) => [A]\nbuiltin map : (<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]\nbuiltin max : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin mean : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin min : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin mode : (<-tables: [A], ?column: string) => [{C with _value: B}] where A: Record, C: Record\nbuiltin movingAverage : (<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric\nbuiltin quantile : (\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A] where\n    A: Record\n\nbuiltin pivot : (<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B] where A: Record, B: Record\nbuiltin range : (\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]\n\nbuiltin reduce : (<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C] where A: Record, B: Record, C: Record\nbuiltin relativeStrengthIndex : (<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin rename : (<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C] where A: Record, B: Record, C: Record\nbuiltin sample : (<-tables: [A], n: int, ?pos: int, ?column: string) => [A] where A: Record\nbuiltin set : (<-tables: [A], key: string, value: string) => [A] where A: Record\nbuiltin tail : (<-tables: [A], n: int, ?offset: int) => [A]\nbuiltin timeShift : (<-tables: [A], duration: duration, ?columns: [string]) => [A]\nbuiltin skew : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin spread : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin sort : (<-tables: [A], ?columns: [string], ?desc: bool) => [A] where A: Record\nbuiltin stateTracking : (\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin stddev : (<-tables: [A], ?column: string, ?mode: string) => [B] where A: Record, B: Record\nbuiltin sum : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin tripleExponentialDerivative : (<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric, B: Record\nbuiltin union : (tables: [[A]]) => [A] where A: Record\nbuiltin unique : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin window : (\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin yield : (<-tables: [A], ?name: string) => [A] where A: Record\n\n// stream/table index functions\nbuiltin tableFind : (<-tables: [A], fn: (key: B) => bool) => [A] where A: Record, B: Record\nbuiltin getColumn : (<-table: [A], column: string) => [B] where A: Record\nbuiltin getRecord : (<-table: [A], idx: int) => A where A: Record\nbuiltin findColumn : (<-tables: [A], fn: (key: B) => bool, column: string) => [C] where A: Record, B: Record\nbuiltin findRecord : (<-tables: [A], fn: (key: B) => bool, idx: int) => A where A: Record, B: Record\n\n// type conversion functions\nbuiltin bool : (v: A) => bool\nbuiltin bytes : (v: A) => bytes\nbuiltin duration : (v: A) => duration\nbuiltin float : (v: A) => float\nbuiltin int : (v: A) => int\nbuiltin string : (v: A) => string\nbuiltin time : (v: A) => time\nbuiltin uint : (v: A) => uint\n\n// contains function\nbuiltin contains : (value: A, set: [A]) => bool where A: Nullable\n\n// other builtins\nbuiltin inf : duration\nbuiltin length : (arr: [A]) => int\nbuiltin linearBins : (start: float, width: float, count: int, ?infinity: bool) => [float]\nbuiltin logarithmicBins : (start: float, factor: float, count: int, ?infinity: bool) => [float]\n\n// sleep is the identity function with the side effect of delaying execution by a specified duration\nbuiltin sleep : (<-v: A, duration: duration) => A\n\n// die returns a fatal error from within a flux script\nbuiltin die : (msg: string) => A\n\n// Time weighted average where values at the beginning and end of the range are linearly interpolated.\ntimeWeightedAvg = (tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))\n\n// covariance function with automatic join\ncov = (x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])\npearsonr = (x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)\n\n// AggregateWindow applies an aggregate function to fixed windows of time.\n// The procedure is to window the data, perform an aggregate operation,\n// and then undo the windowing to produce an output table for every input table.\naggregateWindow = (\n        every,\n        fn,\n        offset=0s,\n        column=\"_value\",\n        timeSrc=\"_stop\",\n        timeDst=\"_time\",\n        createEmpty=true,\n        tables=<-,\n) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)\n\n// Increase returns the total non-negative difference between values in a table.\n// A main usage case is tracking changes in counter values which may wrap over time when they hit\n// a threshold or are reset. In the case of a wrap/reset,\n// we can assume that the absolute delta between two points will be at least their non-negative difference.\nincrease = (tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)\n\n// median returns the 50th percentile.\nmedian = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)\n\n// stateCount computes the number of consecutive records in a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state count will be incremented\n// When a point evaluates as false, the state count is reset.\n//\n// The state count will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state count.\nstateCount = (fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)\n\n// stateDuration computes the duration of a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state duration will be\n// incremented by the duration between points. When a point evaluates as false,\n// the state duration is reset.\n//\n// The state duration will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state duration.\n//\n// Note that as the first point in the given state has no previous point, its\n// state duration will be 0.\n//\n// The duration is represented as an integer in the units specified.\nstateDuration = (\n        fn,\n        column=\"stateDuration\",\n        timeColumn=\"_time\",\n        unit=1s,\n        tables=<-,\n) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)\n\n// _sortLimit is a helper function, which sorts and limits a table.\n_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)\n\n// top sorts a table by columns and keeps only the top n records.\ntop = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)\n\n// top sorts a table by columns and keeps only the bottom n records.\nbottom = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)\n\n// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n// then it selects the highest or lowest records based on the column and the _sortLimit function.\n// The default reducer assumes no reducing needs to be performed.\n_highestOrLowest = (\n        n,\n        _sortLimit,\n        reducer,\n        column=\"_value\",\n        groupColumns=[],\n        tables=<-,\n) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])\n\n// highestMax returns the top N records from all groups using the maximum of each group.\nhighestMax = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )\n\n// highestAverage returns the top N records from all groups using the average of each group.\nhighestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> mean(column: column),\n        _sortLimit: top,\n    )\n\n// highestCurrent returns the top N records from all groups using the last value of each group.\nhighestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> last(column: column),\n        _sortLimit: top,\n    )\n\n// lowestMin returns the bottom N records from all groups using the minimum of each group.\nlowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> min(column: column),\n        _sortLimit: bottom,\n    )\n\n// lowestAverage returns the bottom N records from all groups using the average of each group.\nlowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> mean(column: column),\n        _sortLimit: bottom,\n    )\n\n// lowestCurrent returns the bottom N records from all groups using the last value of each group.\nlowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> last(column: column),\n        _sortLimit: bottom,\n    )\n\n// timedMovingAverage constructs a simple moving average over windows of 'period' duration\n// eg: A 5 year moving average would be called as such:\n//    movingAverage(1y, 5y)\ntimedMovingAverage = (every, period, column=\"_value\", tables=<-) => tables\n    |> window(every: every, period: period)\n    |> mean(column: column)\n    |> duplicate(column: \"_stop\", as: \"_time\")\n    |> window(every: inf)\n\n// Double Exponential Moving Average computes the double exponential moving averages of the `_value` column.\n// eg: A 5 point double exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> doubleEMA(n: 5)\ndoubleEMA = (n, tables=<-) => tables\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema\")\n    |> exponentialMovingAverage(n: n)\n    |> map(fn: (r) => ({r with _value: 2.0 * r.__ema - r._value}))\n    |> drop(columns: [\"__ema\"])\n\n// Triple Exponential Moving Average computes the triple exponential moving averages of the `_value` column.\n// eg: A 5 point triple exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> tripleEMA(n: 5)\ntripleEMA = (n, tables=<-) => tables\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema1\")\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema2\")\n    |> exponentialMovingAverage(n: n)\n    |> map(fn: (r) => ({r with _value: 3.0 * r.__ema1 - 3.0 * r.__ema2 + r._value}))\n    |> drop(columns: [\"__ema1\", \"__ema2\"])\n\n// truncateTimeColumn takes in a time column t and a Duration unit and truncates each value of t to the given unit via map\n// Change from _time to timeColumn once Flux Issue 1122 is resolved\ntruncateTimeColumn = (timeColumn=\"_time\", unit, tables=<-) => tables\n    |> map(fn: (r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))\n\n// kaufmansER computes Kaufman's Efficiency Ratios of the `_value` column\nkaufmansER = (n, tables=<-) => tables\n    |> chandeMomentumOscillator(n: n)\n    |> map(fn: (r) => ({r with _value: math.abs(x: r._value) / 100.0}))\ntoString = (tables=<-) => tables |> map(fn: (r) => ({r with _value: string(v: r._value)}))\ntoInt = (tables=<-) => tables |> map(fn: (r) => ({r with _value: int(v: r._value)}))\ntoUInt = (tables=<-) => tables |> map(fn: (r) => ({r with _value: uint(v: r._value)}))\ntoFloat = (tables=<-) => tables |> map(fn: (r) => ({r with _value: float(v: r._value)}))\ntoBool = (tables=<-) => tables |> map(fn: (r) => ({r with _value: bool(v: r._value)}))\ntoTime = (tables=<-) => tables |> map(fn: (r) => ({r with _value: time(v: r._value)}))\n\n// today returns the now() timestamp truncated to the day unit\ntoday = () => date.truncate(t: now(), unit: 1d)",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   11,
						},
						File:   "universe.flux",
						Source: "now = system.time",
						Start: ast.Position{
							Column: 8,
							Line:   11,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   11,
							},
							File:   "universe.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   11,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   11,
							},
							File:   "universe.flux",
							Source: "system.time",
							Start: ast.Position{
								Column: 14,
								Line:   11,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   11,
								},
								File:   "universe.flux",
								Source: "system",
								Start: ast.Position{
									Column: 14,
									Line:   11,
								},
							},
						},
						Name: "system",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   11,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 21,
									Line:   11,
								},
							},
						},
						Name: "time",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// now is a function option whose default behaviour is to return the current system time\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   11,
					},
					File:   "universe.flux",
					Source: "option now = system.time",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Booleans\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   14,
					},
					File:   "universe.flux",
					Source: "builtin true",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   14,
						},
						File:   "universe.flux",
						Source: "true",
						Start: ast.Position{
							Column: 9,
							Line:   14,
						},
					},
				},
				Name: "true",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   14,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 16,
							Line:   14,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   14,
							},
							File:   "universe.flux",
							Source: "bool",
							Start: ast.Position{
								Column: 16,
								Line:   14,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   14,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 16,
									Line:   14,
								},
							},
						},
						Name: "bool",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   15,
					},
					File:   "universe.flux",
					Source: "builtin false",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "false",
						Start: ast.Position{
							Column: 9,
							Line:   15,
						},
					},
				},
				Name: "false",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 17,
							Line:   15,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   15,
							},
							File:   "universe.flux",
							Source: "bool",
							Start: ast.Position{
								Column: 17,
								Line:   15,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 17,
									Line:   15,
								},
							},
						},
						Name: "bool",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Transformation functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   18,
					},
					File:   "universe.flux",
					Source: "builtin chandeMomentumOscillator",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "chandeMomentumOscillator",
						Start: ast.Position{
							Column: 9,
							Line:   18,
						},
					},
				},
				Name: "chandeMomentumOscillator",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 113,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 36,
							Line:   18,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   18,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   18,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   18,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   18,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   18,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   18,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 36,
								Line:   18,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 37,
									Line:   18,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   18,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 47,
										Line:   18,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 48,
											Line:   18,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   18,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 48,
												Line:   18,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 52,
									Line:   18,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 52,
										Line:   18,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 55,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 55,
											Line:   18,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 60,
									Line:   18,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 61,
										Line:   18,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 70,
										Line:   18,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 71,
											Line:   18,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   18,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 71,
												Line:   18,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 83,
									Line:   18,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 84,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 84,
											Line:   18,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   19,
					},
					File:   "universe.flux",
					Source: "builtin columns",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "columns",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "columns",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 19,
							Line:   19,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   19,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   19,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   19,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 76,
								Line:   19,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   19,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 76,
									Line:   19,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 19,
								Line:   19,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 20,
									Line:   19,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   19,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 30,
										Line:   19,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   19,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   19,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   19,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 35,
									Line:   19,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 36,
										Line:   19,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   19,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   19,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   19,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   19,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   19,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   20,
					},
					File:   "universe.flux",
					Source: "builtin count",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "count",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "count",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   20,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   20,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 63,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 66,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 63,
									Line:   20,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   20,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 74,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 77,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 74,
									Line:   20,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   20,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   20,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   20,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   20,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   20,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   20,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   20,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   20,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   20,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 33,
									Line:   20,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 34,
										Line:   20,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   20,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   20,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 53,
									Line:   20,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 54,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   20,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 54,
											Line:   20,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   21,
					},
					File:   "universe.flux",
					Source: "builtin covariance",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   21,
						},
						File:   "universe.flux",
						Source: "covariance",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Name: "covariance",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   21,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   21,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   21,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 106,
								Line:   21,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 109,
									Line:   21,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 106,
									Line:   21,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   21,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 117,
								Line:   21,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 120,
									Line:   21,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 117,
									Line:   21,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   21,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B]",
							Start: ast.Position{
								Column: 22,
								Line:   21,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   21,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   21,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   21,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   21,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   21,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   21,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "?pearsonr: bool",
								Start: ast.Position{
									Column: 38,
									Line:   21,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "pearsonr",
									Start: ast.Position{
										Column: 39,
										Line:   21,
									},
								},
							},
							Name: "pearsonr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 49,
										Line:   21,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 49,
											Line:   21,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "?valueDst: string",
								Start: ast.Position{
									Column: 55,
									Line:   21,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "valueDst",
									Start: ast.Position{
										Column: 56,
										Line:   21,
									},
								},
							},
							Name: "valueDst",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 66,
										Line:   21,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 66,
											Line:   21,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "columns: [string]",
								Start: ast.Position{
									Column: 74,
									Line:   21,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 74,
										Line:   21,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 83,
										Line:   21,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 84,
											Line:   21,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   21,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 84,
												Line:   21,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 96,
									Line:   21,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 97,
										Line:   21,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 97,
											Line:   21,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   22,
					},
					File:   "universe.flux",
					Source: "builtin cumulativeSum",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   22,
						},
						File:   "universe.flux",
						Source: "cumulativeSum",
						Start: ast.Position{
							Column: 9,
							Line:   22,
						},
					},
				},
				Name: "cumulativeSum",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   22,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 25,
							Line:   22,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   22,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 74,
								Line:   22,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 77,
									Line:   22,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 74,
									Line:   22,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   22,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 85,
								Line:   22,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 88,
									Line:   22,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 85,
									Line:   22,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   22,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 25,
								Line:   22,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 26,
									Line:   22,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   22,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   22,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   22,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   22,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   22,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 41,
									Line:   22,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 42,
										Line:   22,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 51,
										Line:   22,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 52,
											Line:   22,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   22,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 52,
												Line:   22,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 64,
									Line:   22,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 65,
										Line:   22,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 65,
											Line:   22,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   23,
					},
					File:   "universe.flux",
					Source: "builtin derivative",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   23,
						},
						File:   "universe.flux",
						Source: "derivative",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Name: "derivative",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   31,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   23,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   30,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   30,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   30,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   30,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   30,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   30,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   31,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   31,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   31,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   29,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 22,
								Line:   23,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   24,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   24,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   24,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   24,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   24,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   24,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   24,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   24,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   24,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   25,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   25,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 6,
										Line:   25,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   25,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   25,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   25,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   25,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   26,
								},
								File:   "universe.flux",
								Source: "?nonNegative: bool",
								Start: ast.Position{
									Column: 5,
									Line:   26,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   26,
									},
									File:   "universe.flux",
									Source: "nonNegative",
									Start: ast.Position{
										Column: 6,
										Line:   26,
									},
								},
							},
							Name: "nonNegative",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   26,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 19,
										Line:   26,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   26,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   26,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   27,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   27,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 6,
										Line:   27,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   27,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 15,
										Line:   27,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   27,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 16,
											Line:   27,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   27,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 16,
												Line:   27,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   28,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   28,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   28,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   28,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   28,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   28,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   28,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   29,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   29,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   29,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   29,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   29,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   29,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   33,
					},
					File:   "universe.flux",
					Source: "builtin die",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "die",
						Start: ast.Position{
							Column: 9,
							Line:   33,
						},
					},
				},
				Name: "die",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "(msg: string) => A",
						Start: ast.Position{
							Column: 15,
							Line:   33,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "(msg: string) => A",
							Start: ast.Position{
								Column: 15,
								Line:   33,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "msg: string",
								Start: ast.Position{
									Column: 16,
									Line:   33,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "msg",
									Start: ast.Position{
										Column: 16,
										Line:   33,
									},
								},
							},
							Name: "msg",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   33,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   33,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 32,
									Line:   33,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   33,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   34,
					},
					File:   "universe.flux",
					Source: "builtin difference",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "difference",
						Start: ast.Position{
							Column: 9,
							Line:   34,
						},
					},
				},
				Name: "difference",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 129,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "(<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R] where T: Record, R: Record",
						Start: ast.Position{
							Column: 22,
							Line:   34,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 118,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "T: Record",
							Start: ast.Position{
								Column: 109,
								Line:   34,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 112,
									Line:   34,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "T",
								Start: ast.Position{
									Column: 109,
									Line:   34,
								},
							},
						},
						Name: "T",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 129,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "R: Record",
							Start: ast.Position{
								Column: 120,
								Line:   34,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 129,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 123,
									Line:   34,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "R",
								Start: ast.Position{
									Column: 120,
									Line:   34,
								},
							},
						},
						Name: "R",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "(<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R]",
							Start: ast.Position{
								Column: 22,
								Line:   34,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "<-tables: [T]",
								Start: ast.Position{
									Column: 23,
									Line:   34,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   34,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "[T]",
									Start: ast.Position{
										Column: 33,
										Line:   34,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "T",
										Start: ast.Position{
											Column: 34,
											Line:   34,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   34,
											},
											File:   "universe.flux",
											Source: "T",
											Start: ast.Position{
												Column: 34,
												Line:   34,
											},
										},
									},
									Name: "T",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "?nonNegative: bool",
								Start: ast.Position{
									Column: 38,
									Line:   34,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "nonNegative",
									Start: ast.Position{
										Column: 39,
										Line:   34,
									},
								},
							},
							Name: "nonNegative",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 52,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 52,
											Line:   34,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 58,
									Line:   34,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 59,
										Line:   34,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 68,
										Line:   34,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 69,
											Line:   34,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   34,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 69,
												Line:   34,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "?keepFirst: bool",
								Start: ast.Position{
									Column: 78,
									Line:   34,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "keepFirst",
									Start: ast.Position{
										Column: 79,
										Line:   34,
									},
								},
							},
							Name: "keepFirst",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 90,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 90,
											Line:   34,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "[R]",
								Start: ast.Position{
									Column: 99,
									Line:   34,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "R",
									Start: ast.Position{
										Column: 100,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "R",
										Start: ast.Position{
											Column: 100,
											Line:   34,
										},
									},
								},
								Name: "R",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   35,
					},
					File:   "universe.flux",
					Source: "builtin distinct",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "distinct",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Name: "distinct",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 86,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 20,
							Line:   35,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 66,
								Line:   35,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 69,
									Line:   35,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 66,
									Line:   35,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 77,
								Line:   35,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 80,
									Line:   35,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 77,
									Line:   35,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 20,
								Line:   35,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 21,
									Line:   35,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   35,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   35,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   35,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   35,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 36,
									Line:   35,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 37,
										Line:   35,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   35,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 56,
									Line:   35,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 57,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 57,
											Line:   35,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   36,
					},
					File:   "universe.flux",
					Source: "builtin drop",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "drop",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Name: "drop",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 116,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   36,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 96,
								Line:   36,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 99,
									Line:   36,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 96,
									Line:   36,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 107,
								Line:   36,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   36,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 107,
									Line:   36,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   36,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   36,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   36,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   36,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   36,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   36,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => bool",
								Start: ast.Position{
									Column: 32,
									Line:   36,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 33,
										Line:   36,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "(column: string) => bool",
									Start: ast.Position{
										Column: 37,
										Line:   36,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 38,
											Line:   36,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   36,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 46,
												Line:   36,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   36,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 46,
													Line:   36,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 57,
											Line:   36,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 57,
												Line:   36,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 63,
									Line:   36,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 64,
										Line:   36,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 73,
										Line:   36,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 74,
											Line:   36,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 74,
												Line:   36,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 86,
									Line:   36,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 87,
										Line:   36,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 87,
											Line:   36,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   37,
					},
					File:   "universe.flux",
					Source: "builtin duplicate",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "duplicate",
						Start: ast.Position{
							Column: 9,
							Line:   37,
						},
					},
				},
				Name: "duplicate",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 98,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], column: string, as: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   37,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 78,
								Line:   37,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 81,
									Line:   37,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 78,
									Line:   37,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 89,
								Line:   37,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   37,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 89,
									Line:   37,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], column: string, as: string) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   37,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   37,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   37,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   37,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   37,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   37,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   37,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 37,
									Line:   37,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 37,
										Line:   37,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   37,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "as: string",
								Start: ast.Position{
									Column: 53,
									Line:   37,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "as",
									Start: ast.Position{
										Column: 53,
										Line:   37,
									},
								},
							},
							Name: "as",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 57,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 57,
											Line:   37,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 68,
									Line:   37,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 69,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 69,
											Line:   37,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   38,
					},
					File:   "universe.flux",
					Source: "builtin elapsed",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "elapsed",
						Start: ast.Position{
							Column: 9,
							Line:   38,
						},
					},
				},
				Name: "elapsed",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 127,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 19,
							Line:   38,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 107,
								Line:   38,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   38,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 107,
									Line:   38,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 127,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 118,
								Line:   38,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 121,
									Line:   38,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 119,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 118,
									Line:   38,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B]",
							Start: ast.Position{
								Column: 19,
								Line:   38,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 20,
									Line:   38,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   38,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 30,
										Line:   38,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   38,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   38,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 35,
									Line:   38,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 36,
										Line:   38,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 42,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 42,
											Line:   38,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 52,
									Line:   38,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 53,
										Line:   38,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 65,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 65,
											Line:   38,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "?columnName: string",
								Start: ast.Position{
									Column: 73,
									Line:   38,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "columnName",
									Start: ast.Position{
										Column: 74,
										Line:   38,
									},
								},
							},
							Name: "columnName",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 86,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 86,
											Line:   38,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 97,
									Line:   38,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 98,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 98,
											Line:   38,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   39,
					},
					File:   "universe.flux",
					Source: "builtin exponentialMovingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "exponentialMovingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Name: "exponentialMovingAverage",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 117,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: A}] where A: Numeric",
						Start: ast.Position{
							Column: 36,
							Line:   39,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 117,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 107,
								Line:   39,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 117,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 110,
									Line:   39,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 107,
									Line:   39,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: A}]",
							Start: ast.Position{
								Column: 36,
								Line:   39,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 37,
									Line:   39,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   39,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 47,
										Line:   39,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 48,
											Line:   39,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   39,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 56,
												Line:   39,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   39,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 56,
													Line:   39,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   39,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 64,
													Line:   39,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   39,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 64,
														Line:   39,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   39,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 49,
												Line:   39,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 69,
									Line:   39,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 69,
										Line:   39,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 72,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 72,
											Line:   39,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "[{B with _value: A}]",
								Start: ast.Position{
									Column: 80,
									Line:   39,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "{B with _value: A}",
									Start: ast.Position{
										Column: 81,
										Line:   39,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "_value: A",
										Start: ast.Position{
											Column: 89,
											Line:   39,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   39,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 89,
												Line:   39,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   39,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 97,
												Line:   39,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   39,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 97,
													Line:   39,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 82,
											Line:   39,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   40,
					},
					File:   "universe.flux",
					Source: "builtin fill",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "fill",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "fill",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 113,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C] where A: Record, C: Record",
						Start: ast.Position{
							Column: 16,
							Line:   40,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   40,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 104,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 104,
									Line:   40,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C]",
							Start: ast.Position{
								Column: 16,
								Line:   40,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   40,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   40,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   40,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   40,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   40,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   40,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   40,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   40,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "?value: B",
								Start: ast.Position{
									Column: 49,
									Line:   40,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 50,
										Line:   40,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 57,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 57,
											Line:   40,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "?usePrevious: bool",
								Start: ast.Position{
									Column: 60,
									Line:   40,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "usePrevious",
									Start: ast.Position{
										Column: 61,
										Line:   40,
									},
								},
							},
							Name: "usePrevious",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 74,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 74,
											Line:   40,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   40,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   40,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   41,
					},
					File:   "universe.flux",
					Source: "builtin filter",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "filter",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "filter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   41,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   41,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 85,
								Line:   41,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 88,
									Line:   41,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 85,
									Line:   41,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   41,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   41,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   41,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   41,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   41,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   41,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   41,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   41,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => bool",
								Start: ast.Position{
									Column: 34,
									Line:   41,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 34,
										Line:   41,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "(r: A) => bool",
									Start: ast.Position{
										Column: 38,
										Line:   41,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 39,
											Line:   41,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   41,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 39,
												Line:   41,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   41,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 42,
												Line:   41,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   41,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 42,
													Line:   41,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 48,
											Line:   41,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   41,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 48,
												Line:   41,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "?onEmpty: string",
								Start: ast.Position{
									Column: 54,
									Line:   41,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "onEmpty",
									Start: ast.Position{
										Column: 55,
										Line:   41,
									},
								},
							},
							Name: "onEmpty",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 64,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 64,
											Line:   41,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 75,
									Line:   41,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 76,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 76,
											Line:   41,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   42,
					},
					File:   "universe.flux",
					Source: "builtin first",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   42,
						},
						File:   "universe.flux",
						Source: "first",
						Start: ast.Position{
							Column: 9,
							Line:   42,
						},
					},
				},
				Name: "first",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   42,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   42,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   42,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 63,
								Line:   42,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 66,
									Line:   42,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 63,
									Line:   42,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   42,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   42,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   42,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   42,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   42,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   42,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   42,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   42,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 33,
									Line:   42,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 34,
										Line:   42,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   42,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   42,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 53,
									Line:   42,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 54,
										Line:   42,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 54,
											Line:   42,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   43,
					},
					File:   "universe.flux",
					Source: "builtin group",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   43,
						},
						File:   "universe.flux",
						Source: "group",
						Start: ast.Position{
							Column: 9,
							Line:   43,
						},
					},
				},
				Name: "group",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   43,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?mode: string, ?columns: [string]) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   43,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   43,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 81,
								Line:   43,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 84,
									Line:   43,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 81,
									Line:   43,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   43,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?mode: string, ?columns: [string]) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   43,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   43,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   43,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   43,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   43,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   43,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   43,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   43,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "?mode: string",
								Start: ast.Position{
									Column: 33,
									Line:   43,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "mode",
									Start: ast.Position{
										Column: 34,
										Line:   43,
									},
								},
							},
							Name: "mode",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   43,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   43,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   43,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 48,
									Line:   43,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 49,
										Line:   43,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 58,
										Line:   43,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   43,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 59,
											Line:   43,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   43,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 59,
												Line:   43,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 71,
									Line:   43,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 72,
										Line:   43,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   43,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 72,
											Line:   43,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   44,
					},
					File:   "universe.flux",
					Source: "builtin histogram",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   44,
						},
						File:   "universe.flux",
						Source: "histogram",
						Start: ast.Position{
							Column: 9,
							Line:   44,
						},
					},
				},
				Name: "histogram",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   53,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   44,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   52,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   52,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   52,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   52,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   52,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   53,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   53,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   53,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   53,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   51,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   44,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   45,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   45,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   45,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   45,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   45,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   45,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   45,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   45,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   45,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   46,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   46,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   46,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   46,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   46,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   46,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   46,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   47,
								},
								File:   "universe.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   47,
									},
									File:   "universe.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   47,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   47,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   47,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   47,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   47,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   48,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   48,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   48,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   48,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   48,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   48,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   48,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   48,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   49,
								},
								File:   "universe.flux",
								Source: "bins: [float]",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   49,
									},
									File:   "universe.flux",
									Source: "bins",
									Start: ast.Position{
										Column: 5,
										Line:   49,
									},
								},
							},
							Name: "bins",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   49,
									},
									File:   "universe.flux",
									Source: "[float]",
									Start: ast.Position{
										Column: 11,
										Line:   49,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   49,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 12,
											Line:   49,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   49,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 12,
												Line:   49,
											},
										},
									},
									Name: "float",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   50,
								},
								File:   "universe.flux",
								Source: "?normalize: bool",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   50,
									},
									File:   "universe.flux",
									Source: "normalize",
									Start: ast.Position{
										Column: 6,
										Line:   50,
									},
								},
							},
							Name: "normalize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   50,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 17,
										Line:   50,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   50,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 17,
											Line:   50,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   51,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   51,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   51,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   51,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   51,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   51,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   55,
					},
					File:   "universe.flux",
					Source: "builtin histogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   55,
						},
						File:   "universe.flux",
						Source: "histogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   55,
						},
					},
				},
				Name: "histogramQuantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   64,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 29,
							Line:   55,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   63,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   63,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   63,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   63,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   63,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   63,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   64,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   64,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   64,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   64,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   64,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   64,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   62,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B]",
							Start: ast.Position{
								Column: 29,
								Line:   55,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   56,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   56,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   56,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   56,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   56,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   56,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   56,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   56,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   56,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   57,
								},
								File:   "universe.flux",
								Source: "?quantile: float",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   57,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 6,
										Line:   57,
									},
								},
							},
							Name: "quantile",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   57,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   57,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   57,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   57,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   58,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   58,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   58,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   58,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   58,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   58,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   58,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   58,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   59,
								},
								File:   "universe.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   59,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   59,
									},
									File:   "universe.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   59,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   59,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   59,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   59,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   59,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   60,
								},
								File:   "universe.flux",
								Source: "?valueColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   60,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   60,
									},
									File:   "universe.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 6,
										Line:   60,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   60,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   60,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   60,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   60,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   61,
								},
								File:   "universe.flux",
								Source: "?minValue: float",
								Start: ast.Position{
									Column: 5,
									Line:   61,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   61,
									},
									File:   "universe.flux",
									Source: "minValue",
									Start: ast.Position{
										Column: 6,
										Line:   61,
									},
								},
							},
							Name: "minValue",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   61,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   61,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   61,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   61,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   62,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   62,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   62,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   62,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   62,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   62,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   66,
					},
					File:   "universe.flux",
					Source: "builtin holtWinters",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   66,
						},
						File:   "universe.flux",
						Source: "holtWinters",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "holtWinters",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   76,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 23,
							Line:   66,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   75,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   75,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   75,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   75,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   76,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   76,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   76,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   76,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   76,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   76,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   74,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B]",
							Start: ast.Position{
								Column: 23,
								Line:   66,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   67,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   67,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   67,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   67,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   67,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   67,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   67,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   67,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   67,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   68,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   68,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 5,
										Line:   68,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   68,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 8,
										Line:   68,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   68,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 8,
											Line:   68,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   69,
								},
								File:   "universe.flux",
								Source: "interval: duration",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   69,
									},
									File:   "universe.flux",
									Source: "interval",
									Start: ast.Position{
										Column: 5,
										Line:   69,
									},
								},
							},
							Name: "interval",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   69,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 15,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   69,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 15,
											Line:   69,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   70,
								},
								File:   "universe.flux",
								Source: "?withFit: bool",
								Start: ast.Position{
									Column: 5,
									Line:   70,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   70,
									},
									File:   "universe.flux",
									Source: "withFit",
									Start: ast.Position{
										Column: 6,
										Line:   70,
									},
								},
							},
							Name: "withFit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   70,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 15,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   70,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 15,
											Line:   70,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   71,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   71,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   71,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   71,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   71,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   71,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   71,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   71,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   72,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   72,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   72,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   72,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   72,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   72,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   72,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   73,
								},
								File:   "universe.flux",
								Source: "?seasonality: int",
								Start: ast.Position{
									Column: 5,
									Line:   73,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   73,
									},
									File:   "universe.flux",
									Source: "seasonality",
									Start: ast.Position{
										Column: 6,
										Line:   73,
									},
								},
							},
							Name: "seasonality",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   73,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 19,
										Line:   73,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   73,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 19,
											Line:   73,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   74,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   74,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   74,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   74,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   78,
					},
					File:   "universe.flux",
					Source: "builtin hourSelection",
					Start: ast.Position{
						Column: 1,
						Line:   78,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   78,
						},
						File:   "universe.flux",
						Source: "hourSelection",
						Start: ast.Position{
							Column: 9,
							Line:   78,
						},
					},
				},
				Name: "hourSelection",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 107,
							Line:   78,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 25,
							Line:   78,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 107,
								Line:   78,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 98,
								Line:   78,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 101,
									Line:   78,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 98,
									Line:   78,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 91,
								Line:   78,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A]",
							Start: ast.Position{
								Column: 25,
								Line:   78,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 26,
									Line:   78,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   78,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   78,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   78,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   78,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   78,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "start: int",
								Start: ast.Position{
									Column: 41,
									Line:   78,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 41,
										Line:   78,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 48,
											Line:   78,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "stop: int",
								Start: ast.Position{
									Column: 53,
									Line:   78,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 53,
										Line:   78,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 59,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 59,
											Line:   78,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 64,
									Line:   78,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 65,
										Line:   78,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 77,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 77,
											Line:   78,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 88,
									Line:   78,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 90,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 89,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 89,
											Line:   78,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   79,
					},
					File:   "universe.flux",
					Source: "builtin integral",
					Start: ast.Position{
						Column: 1,
						Line:   79,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   79,
						},
						File:   "universe.flux",
						Source: "integral",
						Start: ast.Position{
							Column: 9,
							Line:   79,
						},
					},
				},
				Name: "integral",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   87,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 20,
							Line:   79,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   86,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   86,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   86,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   87,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   87,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   87,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   85,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B]",
							Start: ast.Position{
								Column: 20,
								Line:   79,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   80,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   80,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   80,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   80,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   80,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   80,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   80,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   80,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   80,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   81,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   81,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 6,
										Line:   81,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   81,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   81,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   81,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   81,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   82,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   82,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   82,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   82,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   82,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   82,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   82,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   82,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   83,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   83,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   83,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   83,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   83,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   83,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   83,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   83,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "?interpolate: string",
								Start: ast.Position{
									Column: 5,
									Line:   84,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "interpolate",
									Start: ast.Position{
										Column: 6,
										Line:   84,
									},
								},
							},
							Name: "interpolate",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   84,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   84,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   84,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   85,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   85,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   85,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   85,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   89,
					},
					File:   "universe.flux",
					Source: "builtin join",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "join",
						Start: ast.Position{
							Column: 9,
							Line:   89,
						},
					},
				},
				Name: "join",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 95,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "(<-tables: A, ?method: string, ?on: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   89,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 75,
								Line:   89,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 78,
									Line:   89,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 75,
									Line:   89,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 86,
								Line:   89,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 89,
									Line:   89,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 86,
									Line:   89,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "(<-tables: A, ?method: string, ?on: [string]) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   89,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "<-tables: A",
								Start: ast.Position{
									Column: 17,
									Line:   89,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   89,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 27,
										Line:   89,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   89,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "?method: string",
								Start: ast.Position{
									Column: 30,
									Line:   89,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "method",
									Start: ast.Position{
										Column: 31,
										Line:   89,
									},
								},
							},
							Name: "method",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 39,
										Line:   89,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 39,
											Line:   89,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "?on: [string]",
								Start: ast.Position{
									Column: 47,
									Line:   89,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "on",
									Start: ast.Position{
										Column: 48,
										Line:   89,
									},
								},
							},
							Name: "on",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 52,
										Line:   89,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 53,
											Line:   89,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 53,
												Line:   89,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 65,
									Line:   89,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 66,
										Line:   89,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 66,
											Line:   89,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   90,
					},
					File:   "universe.flux",
					Source: "builtin kaufmansAMA",
					Start: ast.Position{
						Column: 1,
						Line:   90,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   90,
						},
						File:   "universe.flux",
						Source: "kaufmansAMA",
						Start: ast.Position{
							Column: 9,
							Line:   90,
						},
					},
				},
				Name: "kaufmansAMA",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   90,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 23,
							Line:   90,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 77,
								Line:   90,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 80,
									Line:   90,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 77,
									Line:   90,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 88,
								Line:   90,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 91,
									Line:   90,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 88,
									Line:   90,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?column: string) => [B]",
							Start: ast.Position{
								Column: 23,
								Line:   90,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 24,
									Line:   90,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 26,
										Line:   90,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 34,
										Line:   90,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 35,
											Line:   90,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   90,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 35,
												Line:   90,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 39,
									Line:   90,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 39,
										Line:   90,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 42,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 42,
											Line:   90,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 47,
									Line:   90,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 48,
										Line:   90,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 56,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 56,
											Line:   90,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 67,
									Line:   90,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 68,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 68,
											Line:   90,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   91,
					},
					File:   "universe.flux",
					Source: "builtin keep",
					Start: ast.Position{
						Column: 1,
						Line:   91,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   91,
						},
						File:   "universe.flux",
						Source: "keep",
						Start: ast.Position{
							Column: 9,
							Line:   91,
						},
					},
				},
				Name: "keep",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 116,
							Line:   91,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   91,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   91,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 96,
								Line:   91,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 99,
									Line:   91,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 96,
									Line:   91,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   91,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 107,
								Line:   91,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   91,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 107,
									Line:   91,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   91,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   91,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   91,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   91,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   91,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   91,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   91,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 32,
									Line:   91,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   91,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   91,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   91,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   91,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => bool",
								Start: ast.Position{
									Column: 52,
									Line:   91,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 53,
										Line:   91,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "(column: string) => bool",
									Start: ast.Position{
										Column: 57,
										Line:   91,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 58,
											Line:   91,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 58,
												Line:   91,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 66,
												Line:   91,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   91,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 66,
													Line:   91,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 77,
											Line:   91,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 77,
												Line:   91,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 86,
									Line:   91,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 87,
										Line:   91,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 87,
											Line:   91,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   92,
					},
					File:   "universe.flux",
					Source: "builtin keyValues",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "keyValues",
						Start: ast.Position{
							Column: 9,
							Line:   92,
						},
					},
				},
				Name: "keyValues",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}] where A: Record, C: Record",
						Start: ast.Position{
							Column: 21,
							Line:   92,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   92,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 104,
								Line:   92,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   92,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 104,
									Line:   92,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   92,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   92,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   92,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   92,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   92,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}]",
							Start: ast.Position{
								Column: 21,
								Line:   92,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   92,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   92,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   92,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   92,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   92,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "?keyColumns: [string]",
								Start: ast.Position{
									Column: 37,
									Line:   92,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "keyColumns",
									Start: ast.Position{
										Column: 38,
										Line:   92,
									},
								},
							},
							Name: "keyColumns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 50,
										Line:   92,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 51,
											Line:   92,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 51,
												Line:   92,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "[{C with _key: string, _value: B}]",
								Start: ast.Position{
									Column: 63,
									Line:   92,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "{C with _key: string, _value: B}",
									Start: ast.Position{
										Column: 64,
										Line:   92,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "_key: string",
										Start: ast.Position{
											Column: 72,
											Line:   92,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "_key",
											Start: ast.Position{
												Column: 72,
												Line:   92,
											},
										},
									},
									Name: "_key",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 78,
												Line:   92,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   92,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 78,
													Line:   92,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "_value: B",
										Start: ast.Position{
											Column: 86,
											Line:   92,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 86,
												Line:   92,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 94,
												Line:   92,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   92,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 94,
													Line:   92,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 65,
											Line:   92,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   93,
					},
					File:   "universe.flux",
					Source: "builtin keys",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "keys",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Name: "keys",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   93,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   93,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   93,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   93,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   93,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   93,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   93,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   93,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   93,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   93,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   93,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   93,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   93,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   93,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   93,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   93,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   93,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   93,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   93,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   94,
					},
					File:   "universe.flux",
					Source: "builtin last",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "last",
						Start: ast.Position{
							Column: 9,
							Line:   94,
						},
					},
				},
				Name: "last",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   94,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   94,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   94,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   94,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   94,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   94,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   94,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   94,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   94,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   94,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   94,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   94,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   94,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   94,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   94,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   94,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 52,
									Line:   94,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 53,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 53,
											Line:   94,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   95,
					},
					File:   "universe.flux",
					Source: "builtin limit",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "limit",
						Start: ast.Position{
							Column: 9,
							Line:   95,
						},
					},
				},
				Name: "limit",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
						Start: ast.Position{
							Column: 17,
							Line:   95,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   95,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   95,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   95,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   95,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   95,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   95,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   95,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 33,
									Line:   95,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 33,
										Line:   95,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 36,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 36,
											Line:   95,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "?offset: int",
								Start: ast.Position{
									Column: 41,
									Line:   95,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 42,
										Line:   95,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 50,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 50,
											Line:   95,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 58,
									Line:   95,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 59,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 59,
											Line:   95,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   96,
					},
					File:   "universe.flux",
					Source: "builtin map",
					Start: ast.Position{
						Column: 1,
						Line:   96,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "map",
						Start: ast.Position{
							Column: 9,
							Line:   96,
						},
					},
				},
				Name: "map",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]",
						Start: ast.Position{
							Column: 15,
							Line:   96,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   96,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]",
							Start: ast.Position{
								Column: 15,
								Line:   96,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   96,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   96,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   96,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   96,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   96,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => B",
								Start: ast.Position{
									Column: 31,
									Line:   96,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 31,
										Line:   96,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "(r: A) => B",
									Start: ast.Position{
										Column: 35,
										Line:   96,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 36,
											Line:   96,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 36,
												Line:   96,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 39,
												Line:   96,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   96,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 39,
													Line:   96,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 45,
											Line:   96,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 45,
												Line:   96,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "?mergeKey: bool",
								Start: ast.Position{
									Column: 48,
									Line:   96,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "mergeKey",
									Start: ast.Position{
										Column: 49,
										Line:   96,
									},
								},
							},
							Name: "mergeKey",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 59,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 59,
											Line:   96,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 68,
									Line:   96,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 69,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 69,
											Line:   96,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   97,
					},
					File:   "universe.flux",
					Source: "builtin max",
					Start: ast.Position{
						Column: 1,
						Line:   97,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   97,
						},
						File:   "universe.flux",
						Source: "max",
						Start: ast.Position{
							Column: 9,
							Line:   97,
						},
					},
				},
				Name: "max",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   97,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   97,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   97,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   97,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   97,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   97,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   97,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   97,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   97,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   97,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   97,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   97,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   97,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   97,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   97,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   97,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   97,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   97,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   97,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   97,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   97,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   98,
					},
					File:   "universe.flux",
					Source: "builtin mean",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   98,
						},
						File:   "universe.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 9,
							Line:   98,
						},
					},
				},
				Name: "mean",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   98,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   98,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   98,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   98,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   98,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   98,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   98,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   98,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   98,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   98,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   98,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   98,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   98,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   98,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   98,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   98,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   98,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   98,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   98,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   98,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   98,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   98,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   98,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   98,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   99,
					},
					File:   "universe.flux",
					Source: "builtin min",
					Start: ast.Position{
						Column: 1,
						Line:   99,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   99,
						},
						File:   "universe.flux",
						Source: "min",
						Start: ast.Position{
							Column: 9,
							Line:   99,
						},
					},
				},
				Name: "min",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   99,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   99,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   99,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   99,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   99,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   99,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   99,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   99,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   99,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   99,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   99,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   99,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   99,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   99,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   99,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   99,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   99,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   99,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   99,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   99,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   99,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   99,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   99,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   99,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   100,
					},
					File:   "universe.flux",
					Source: "builtin mode",
					Start: ast.Position{
						Column: 1,
						Line:   100,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   100,
						},
						File:   "universe.flux",
						Source: "mode",
						Start: ast.Position{
							Column: 9,
							Line:   100,
						},
					},
				},
				Name: "mode",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   100,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [{C with _value: B}] where A: Record, C: Record",
						Start: ast.Position{
							Column: 16,
							Line:   100,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   100,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 79,
								Line:   100,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 82,
									Line:   100,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 79,
									Line:   100,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   100,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 90,
								Line:   100,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   100,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 90,
									Line:   100,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   100,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [{C with _value: B}]",
							Start: ast.Position{
								Column: 16,
								Line:   100,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   100,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   100,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   100,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   100,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   100,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   100,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   100,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   100,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   100,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   100,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   100,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   100,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "[{C with _value: B}]",
								Start: ast.Position{
									Column: 52,
									Line:   100,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "{C with _value: B}",
									Start: ast.Position{
										Column: 53,
										Line:   100,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   100,
										},
										File:   "universe.flux",
										Source: "_value: B",
										Start: ast.Position{
											Column: 61,
											Line:   100,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   100,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 61,
												Line:   100,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   100,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 69,
												Line:   100,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   100,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 69,
													Line:   100,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   100,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 54,
											Line:   100,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   101,
					},
					File:   "universe.flux",
					Source: "builtin movingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   101,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   101,
						},
						File:   "universe.flux",
						Source: "movingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   101,
						},
					},
				},
				Name: "movingAverage",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   101,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric",
						Start: ast.Position{
							Column: 25,
							Line:   101,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   101,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 100,
								Line:   101,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 103,
									Line:   101,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 100,
									Line:   101,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   101,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 25,
								Line:   101,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 26,
									Line:   101,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   101,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 36,
										Line:   101,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 37,
											Line:   101,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   101,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 45,
												Line:   101,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   101,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 45,
													Line:   101,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   101,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 53,
													Line:   101,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   101,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 53,
														Line:   101,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   101,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 38,
												Line:   101,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 58,
									Line:   101,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 58,
										Line:   101,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 61,
										Line:   101,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 61,
											Line:   101,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 69,
									Line:   101,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 70,
										Line:   101,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 78,
											Line:   101,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   101,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 78,
												Line:   101,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   101,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 86,
												Line:   101,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   101,
												},
												File:   "universe.flux",
												Source: "float",
												Start: ast.Position{
													Column: 86,
													Line:   101,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 71,
											Line:   101,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   102,
					},
					File:   "universe.flux",
					Source: "builtin quantile",
					Start: ast.Position{
						Column: 1,
						Line:   102,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   102,
						},
						File:   "universe.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 9,
							Line:   102,
						},
					},
				},
				Name: "quantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   109,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A] where\n    A: Record",
						Start: ast.Position{
							Column: 20,
							Line:   102,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   109,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   109,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   109,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   109,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   109,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   109,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   108,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A]",
							Start: ast.Position{
								Column: 20,
								Line:   102,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   103,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   103,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   103,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   103,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   103,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   103,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   103,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   103,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   103,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   103,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   104,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   104,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   104,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   104,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   104,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "q: float",
								Start: ast.Position{
									Column: 5,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "q",
									Start: ast.Position{
										Column: 5,
										Line:   105,
									},
								},
							},
							Name: "q",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 8,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 8,
											Line:   105,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "?compression: float",
								Start: ast.Position{
									Column: 5,
									Line:   106,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "compression",
									Start: ast.Position{
										Column: 6,
										Line:   106,
									},
								},
							},
							Name: "compression",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   106,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   106,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   107,
								},
								File:   "universe.flux",
								Source: "?method: string",
								Start: ast.Position{
									Column: 5,
									Line:   107,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   107,
									},
									File:   "universe.flux",
									Source: "method",
									Start: ast.Position{
										Column: 6,
										Line:   107,
									},
								},
							},
							Name: "method",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   107,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   107,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   107,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   107,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 6,
									Line:   108,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 7,
										Line:   108,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 7,
											Line:   108,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   111,
					},
					File:   "universe.flux",
					Source: "builtin pivot",
					Start: ast.Position{
						Column: 1,
						Line:   111,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   111,
						},
						File:   "universe.flux",
						Source: "pivot",
						Start: ast.Position{
							Column: 9,
							Line:   111,
						},
					},
				},
				Name: "pivot",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   111,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   111,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 106,
								Line:   111,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 109,
									Line:   111,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 106,
									Line:   111,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 117,
								Line:   111,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 120,
									Line:   111,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 117,
									Line:   111,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   111,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   111,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   111,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   111,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   111,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   111,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   111,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "rowKey: [string]",
								Start: ast.Position{
									Column: 33,
									Line:   111,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "rowKey",
									Start: ast.Position{
										Column: 33,
										Line:   111,
									},
								},
							},
							Name: "rowKey",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 41,
										Line:   111,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   111,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   111,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 42,
												Line:   111,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "columnKey: [string]",
								Start: ast.Position{
									Column: 51,
									Line:   111,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "columnKey",
									Start: ast.Position{
										Column: 51,
										Line:   111,
									},
								},
							},
							Name: "columnKey",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 62,
										Line:   111,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 63,
											Line:   111,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   111,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 63,
												Line:   111,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "valueColumn: string",
								Start: ast.Position{
									Column: 72,
									Line:   111,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 72,
										Line:   111,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 85,
										Line:   111,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 85,
											Line:   111,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 96,
									Line:   111,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 97,
										Line:   111,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 97,
											Line:   111,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   112,
					},
					File:   "universe.flux",
					Source: "builtin range",
					Start: ast.Position{
						Column: 1,
						Line:   112,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   112,
						},
						File:   "universe.flux",
						Source: "range",
						Start: ast.Position{
							Column: 9,
							Line:   112,
						},
					},
				},
				Name: "range",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   120,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
						Start: ast.Position{
							Column: 17,
							Line:   112,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   120,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
							Start: ast.Position{
								Column: 17,
								Line:   112,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   113,
								},
								File:   "universe.flux",
								Source: "<-tables: [{A with _time: time}]",
								Start: ast.Position{
									Column: 5,
									Line:   113,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   113,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   113,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   113,
									},
									File:   "universe.flux",
									Source: "[{A with _time: time}]",
									Start: ast.Position{
										Column: 15,
										Line:   113,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   113,
										},
										File:   "universe.flux",
										Source: "{A with _time: time}",
										Start: ast.Position{
											Column: 16,
											Line:   113,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   113,
											},
											File:   "universe.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 24,
												Line:   113,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   113,
												},
												File:   "universe.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 24,
													Line:   113,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   113,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 31,
													Line:   113,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   113,
													},
													File:   "universe.flux",
													Source: "time",
													Start: ast.Position{
														Column: 31,
														Line:   113,
													},
												},
											},
											Name: "time",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   113,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 17,
												Line:   113,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   114,
								},
								File:   "universe.flux",
								Source: "start: B",
								Start: ast.Position{
									Column: 5,
									Line:   114,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   114,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 5,
										Line:   114,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   114,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 12,
										Line:   114,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   114,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 12,
											Line:   114,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "?stop: C",
								Start: ast.Position{
									Column: 5,
									Line:   115,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 6,
										Line:   115,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 12,
										Line:   115,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 12,
											Line:   115,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "[{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
								Start: ast.Position{
									Column: 6,
									Line:   116,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}",
									Start: ast.Position{
										Column: 7,
										Line:   116,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   117,
										},
										File:   "universe.flux",
										Source: "_time: time",
										Start: ast.Position{
											Column: 5,
											Line:   117,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   117,
											},
											File:   "universe.flux",
											Source: "_time",
											Start: ast.Position{
												Column: 5,
												Line:   117,
											},
										},
									},
									Name: "_time",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   117,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 12,
												Line:   117,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   117,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 12,
													Line:   117,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   118,
										},
										File:   "universe.flux",
										Source: "_start: time",
										Start: ast.Position{
											Column: 5,
											Line:   118,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   118,
											},
											File:   "universe.flux",
											Source: "_start",
											Start: ast.Position{
												Column: 5,
												Line:   118,
											},
										},
									},
									Name: "_start",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   118,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 13,
												Line:   118,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   118,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 13,
													Line:   118,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "_stop: time",
										Start: ast.Position{
											Column: 5,
											Line:   119,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "_stop",
											Start: ast.Position{
												Column: 5,
												Line:   119,
											},
										},
									},
									Name: "_stop",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 12,
												Line:   119,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   119,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 12,
													Line:   119,
												},
											},
										},
										Name: "time",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 8,
											Line:   116,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   122,
					},
					File:   "universe.flux",
					Source: "builtin reduce",
					Start: ast.Position{
						Column: 1,
						Line:   122,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "reduce",
						Start: ast.Position{
							Column: 9,
							Line:   122,
						},
					},
				},
				Name: "reduce",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   122,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   122,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   122,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   122,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   122,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   122,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   122,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   122,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   122,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   122,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C]",
							Start: ast.Position{
								Column: 18,
								Line:   122,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   122,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   122,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   122,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   122,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   122,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "fn: (r: A, accumulator: B) => B",
								Start: ast.Position{
									Column: 34,
									Line:   122,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 34,
										Line:   122,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "(r: A, accumulator: B) => B",
									Start: ast.Position{
										Column: 38,
										Line:   122,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 39,
											Line:   122,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 39,
												Line:   122,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 42,
												Line:   122,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   122,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 42,
													Line:   122,
												},
											},
										},
										Name: "A",
									},
								},
							}, &ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "accumulator: B",
										Start: ast.Position{
											Column: 45,
											Line:   122,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "accumulator",
											Start: ast.Position{
												Column: 45,
												Line:   122,
											},
										},
									},
									Name: "accumulator",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 58,
												Line:   122,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   122,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 58,
													Line:   122,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 64,
											Line:   122,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 64,
												Line:   122,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "identity: B",
								Start: ast.Position{
									Column: 67,
									Line:   122,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "identity",
									Start: ast.Position{
										Column: 67,
										Line:   122,
									},
								},
							},
							Name: "identity",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 77,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 77,
											Line:   122,
										},
									},
								},
								Name: "B",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   122,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   122,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   123,
					},
					File:   "universe.flux",
					Source: "builtin relativeStrengthIndex",
					Start: ast.Position{
						Column: 1,
						Line:   123,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "relativeStrengthIndex",
						Start: ast.Position{
							Column: 9,
							Line:   123,
						},
					},
				},
				Name: "relativeStrengthIndex",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 33,
							Line:   123,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 90,
								Line:   123,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   123,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 90,
									Line:   123,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 101,
								Line:   123,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 104,
									Line:   123,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 101,
									Line:   123,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 33,
								Line:   123,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 34,
									Line:   123,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 36,
										Line:   123,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 44,
										Line:   123,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 45,
											Line:   123,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   123,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 45,
												Line:   123,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 49,
									Line:   123,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 49,
										Line:   123,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 52,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 52,
											Line:   123,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 57,
									Line:   123,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 58,
										Line:   123,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 67,
										Line:   123,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   123,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   123,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   123,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 80,
									Line:   123,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 81,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 81,
											Line:   123,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   124,
					},
					File:   "universe.flux",
					Source: "builtin rename",
					Start: ast.Position{
						Column: 1,
						Line:   124,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   124,
						},
						File:   "universe.flux",
						Source: "rename",
						Start: ast.Position{
							Column: 9,
							Line:   124,
						},
					},
				},
				Name: "rename",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   124,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   124,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   124,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   124,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   124,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   124,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   124,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   124,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   124,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   124,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   124,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C]",
							Start: ast.Position{
								Column: 18,
								Line:   124,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   124,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   124,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   124,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   124,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   124,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => string",
								Start: ast.Position{
									Column: 34,
									Line:   124,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 35,
										Line:   124,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "(column: string) => string",
									Start: ast.Position{
										Column: 39,
										Line:   124,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 40,
											Line:   124,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 40,
												Line:   124,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 48,
												Line:   124,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   124,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 48,
													Line:   124,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 59,
											Line:   124,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 59,
												Line:   124,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "?columns: B",
								Start: ast.Position{
									Column: 67,
									Line:   124,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 68,
										Line:   124,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 77,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 77,
											Line:   124,
										},
									},
								},
								Name: "B",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   124,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   124,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   125,
					},
					File:   "universe.flux",
					Source: "builtin sample",
					Start: ast.Position{
						Column: 1,
						Line:   125,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "sample",
						Start: ast.Position{
							Column: 9,
							Line:   125,
						},
					},
				},
				Name: "sample",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?pos: int, ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   125,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   125,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 83,
								Line:   125,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 86,
									Line:   125,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 83,
									Line:   125,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 76,
								Line:   125,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?pos: int, ?column: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   125,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   125,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   125,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   125,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   125,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   125,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 34,
									Line:   125,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 34,
										Line:   125,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 37,
										Line:   125,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 37,
											Line:   125,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "?pos: int",
								Start: ast.Position{
									Column: 42,
									Line:   125,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "pos",
									Start: ast.Position{
										Column: 43,
										Line:   125,
									},
								},
							},
							Name: "pos",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   125,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 48,
											Line:   125,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 53,
									Line:   125,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 54,
										Line:   125,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 62,
										Line:   125,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 62,
											Line:   125,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 73,
									Line:   125,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 74,
										Line:   125,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 74,
											Line:   125,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   126,
					},
					File:   "universe.flux",
					Source: "builtin set",
					Start: ast.Position{
						Column: 1,
						Line:   126,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   126,
						},
						File:   "universe.flux",
						Source: "set",
						Start: ast.Position{
							Column: 9,
							Line:   126,
						},
					},
				},
				Name: "set",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   126,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], key: string, value: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   126,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   126,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 72,
								Line:   126,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   126,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 72,
									Line:   126,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   126,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], key: string, value: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   126,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   126,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   126,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   126,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   126,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   126,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   126,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "key: string",
								Start: ast.Position{
									Column: 31,
									Line:   126,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "key",
									Start: ast.Position{
										Column: 31,
										Line:   126,
									},
								},
							},
							Name: "key",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   126,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   126,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "value: string",
								Start: ast.Position{
									Column: 44,
									Line:   126,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 44,
										Line:   126,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 51,
										Line:   126,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 51,
											Line:   126,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 62,
									Line:   126,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 63,
										Line:   126,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   126,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   127,
					},
					File:   "universe.flux",
					Source: "builtin tail",
					Start: ast.Position{
						Column: 1,
						Line:   127,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   127,
						},
						File:   "universe.flux",
						Source: "tail",
						Start: ast.Position{
							Column: 9,
							Line:   127,
						},
					},
				},
				Name: "tail",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 60,
							Line:   127,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
						Start: ast.Position{
							Column: 16,
							Line:   127,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   127,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   127,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   127,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   127,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   127,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   127,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   127,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   127,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 32,
									Line:   127,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 32,
										Line:   127,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 35,
										Line:   127,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 35,
											Line:   127,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "?offset: int",
								Start: ast.Position{
									Column: 40,
									Line:   127,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 41,
										Line:   127,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 49,
										Line:   127,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 49,
											Line:   127,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 57,
									Line:   127,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 58,
										Line:   127,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 58,
											Line:   127,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   128,
					},
					File:   "universe.flux",
					Source: "builtin timeShift",
					Start: ast.Position{
						Column: 1,
						Line:   128,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   128,
						},
						File:   "universe.flux",
						Source: "timeShift",
						Start: ast.Position{
							Column: 9,
							Line:   128,
						},
					},
				},
				Name: "timeShift",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   128,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], duration: duration, ?columns: [string]) => [A]",
						Start: ast.Position{
							Column: 21,
							Line:   128,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], duration: duration, ?columns: [string]) => [A]",
							Start: ast.Position{
								Column: 21,
								Line:   128,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   128,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   128,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   128,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   128,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   128,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   128,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "duration: duration",
								Start: ast.Position{
									Column: 37,
									Line:   128,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 37,
										Line:   128,
									},
								},
							},
							Name: "duration",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 47,
										Line:   128,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 47,
											Line:   128,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 57,
									Line:   128,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 58,
										Line:   128,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 67,
										Line:   128,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   128,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   128,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   128,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 80,
									Line:   128,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 81,
										Line:   128,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 81,
											Line:   128,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   129,
					},
					File:   "universe.flux",
					Source: "builtin skew",
					Start: ast.Position{
						Column: 1,
						Line:   129,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   129,
						},
						File:   "universe.flux",
						Source: "skew",
						Start: ast.Position{
							Column: 9,
							Line:   129,
						},
					},
				},
				Name: "skew",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   129,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   129,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   129,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   129,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   129,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   129,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   129,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   129,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   129,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   129,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   129,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   129,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   129,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   129,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   129,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   129,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   129,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   129,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   129,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   129,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   129,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   129,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   129,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   129,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   129,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   129,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   129,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   129,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   130,
					},
					File:   "universe.flux",
					Source: "builtin spread",
					Start: ast.Position{
						Column: 1,
						Line:   130,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   130,
						},
						File:   "universe.flux",
						Source: "spread",
						Start: ast.Position{
							Column: 9,
							Line:   130,
						},
					},
				},
				Name: "spread",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 84,
							Line:   130,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   130,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   130,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 64,
								Line:   130,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 67,
									Line:   130,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 64,
									Line:   130,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   130,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 75,
								Line:   130,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 78,
									Line:   130,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 75,
									Line:   130,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   130,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   130,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   130,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   130,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   130,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   130,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   130,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   130,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   130,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   130,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   130,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 54,
									Line:   130,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 55,
										Line:   130,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 55,
											Line:   130,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   131,
					},
					File:   "universe.flux",
					Source: "builtin sort",
					Start: ast.Position{
						Column: 1,
						Line:   131,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   131,
						},
						File:   "universe.flux",
						Source: "sort",
						Start: ast.Position{
							Column: 9,
							Line:   131,
						},
					},
				},
				Name: "sort",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 87,
							Line:   131,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string], ?desc: bool) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   131,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   131,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 78,
								Line:   131,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 81,
									Line:   131,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 78,
									Line:   131,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   131,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string], ?desc: bool) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   131,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   131,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   131,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   131,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   131,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   131,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   131,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 32,
									Line:   131,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   131,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   131,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   131,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   131,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   131,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "?desc: bool",
								Start: ast.Position{
									Column: 52,
									Line:   131,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "desc",
									Start: ast.Position{
										Column: 53,
										Line:   131,
									},
								},
							},
							Name: "desc",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 59,
										Line:   131,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 59,
											Line:   131,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 68,
									Line:   131,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 69,
										Line:   131,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 69,
											Line:   131,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   132,
					},
					File:   "universe.flux",
					Source: "builtin stateTracking",
					Start: ast.Position{
						Column: 1,
						Line:   132,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   132,
						},
						File:   "universe.flux",
						Source: "stateTracking",
						Start: ast.Position{
							Column: 9,
							Line:   132,
						},
					},
				},
				Name: "stateTracking",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   141,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 25,
							Line:   132,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   140,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   140,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   140,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   140,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   141,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   141,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   141,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   139,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 25,
								Line:   132,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   133,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   133,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   133,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   133,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   133,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   133,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   133,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   133,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   133,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   133,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   134,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => bool",
								Start: ast.Position{
									Column: 5,
									Line:   134,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   134,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 5,
										Line:   134,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   134,
									},
									File:   "universe.flux",
									Source: "(r: A) => bool",
									Start: ast.Position{
										Column: 9,
										Line:   134,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   134,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 10,
											Line:   134,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   134,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   134,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   134,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 13,
												Line:   134,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   134,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 13,
													Line:   134,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   134,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   134,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   134,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 19,
												Line:   134,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   135,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   135,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   135,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   135,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   135,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "?durationColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   136,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "durationColumn",
									Start: ast.Position{
										Column: 6,
										Line:   136,
									},
								},
							},
							Name: "durationColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   136,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   136,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "?durationUnit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   137,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "durationUnit",
									Start: ast.Position{
										Column: 6,
										Line:   137,
									},
								},
							},
							Name: "durationUnit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 20,
										Line:   137,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   137,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 20,
											Line:   137,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   138,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   138,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   138,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   138,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   138,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   138,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   138,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   139,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   139,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   139,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   139,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   139,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   139,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   143,
					},
					File:   "universe.flux",
					Source: "builtin stddev",
					Start: ast.Position{
						Column: 1,
						Line:   143,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   143,
						},
						File:   "universe.flux",
						Source: "stddev",
						Start: ast.Position{
							Column: 9,
							Line:   143,
						},
					},
				},
				Name: "stddev",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   143,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string, ?mode: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   143,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   143,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 79,
								Line:   143,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 82,
									Line:   143,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 79,
									Line:   143,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   143,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 90,
								Line:   143,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   143,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 90,
									Line:   143,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   143,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string, ?mode: string) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   143,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   143,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   143,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   143,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   143,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   143,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   143,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   143,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   143,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   143,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   143,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "?mode: string",
								Start: ast.Position{
									Column: 51,
									Line:   143,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "mode",
									Start: ast.Position{
										Column: 52,
										Line:   143,
									},
								},
							},
							Name: "mode",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 58,
										Line:   143,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 58,
											Line:   143,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 69,
									Line:   143,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 70,
										Line:   143,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 70,
											Line:   143,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   144,
					},
					File:   "universe.flux",
					Source: "builtin sum",
					Start: ast.Position{
						Column: 1,
						Line:   144,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   144,
						},
						File:   "universe.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 9,
							Line:   144,
						},
					},
				},
				Name: "sum",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   144,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 15,
							Line:   144,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   144,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   144,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   144,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   144,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   144,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 72,
								Line:   144,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   144,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 72,
									Line:   144,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   144,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 15,
								Line:   144,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   144,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   144,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   144,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   144,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   144,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   144,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   144,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   144,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   144,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 51,
									Line:   144,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 52,
										Line:   144,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 52,
											Line:   144,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   145,
					},
					File:   "universe.flux",
					Source: "builtin tripleExponentialDerivative",
					Start: ast.Position{
						Column: 1,
						Line:   145,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   145,
						},
						File:   "universe.flux",
						Source: "tripleExponentialDerivative",
						Start: ast.Position{
							Column: 9,
							Line:   145,
						},
					},
				},
				Name: "tripleExponentialDerivative",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 135,
							Line:   145,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric, B: Record",
						Start: ast.Position{
							Column: 39,
							Line:   145,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   145,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 114,
								Line:   145,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 117,
									Line:   145,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 114,
									Line:   145,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 135,
								Line:   145,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 126,
								Line:   145,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 135,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 129,
									Line:   145,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 126,
									Line:   145,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 107,
								Line:   145,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 39,
								Line:   145,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 40,
									Line:   145,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   145,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 50,
										Line:   145,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   145,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 51,
											Line:   145,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   145,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 59,
												Line:   145,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   145,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 59,
													Line:   145,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   145,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 67,
													Line:   145,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   145,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 67,
														Line:   145,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   145,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 52,
												Line:   145,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 72,
									Line:   145,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 72,
										Line:   145,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 75,
										Line:   145,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   145,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 75,
											Line:   145,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 83,
									Line:   145,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 106,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 84,
										Line:   145,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   145,
										},
										File:   "universe.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 92,
											Line:   145,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   145,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 92,
												Line:   145,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 105,
												Line:   145,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 100,
												Line:   145,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   145,
												},
												File:   "universe.flux",
												Source: "float",
												Start: ast.Position{
													Column: 100,
													Line:   145,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   145,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 85,
											Line:   145,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   146,
					},
					File:   "universe.flux",
					Source: "builtin union",
					Start: ast.Position{
						Column: 1,
						Line:   146,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   146,
						},
						File:   "universe.flux",
						Source: "union",
						Start: ast.Position{
							Column: 9,
							Line:   146,
						},
					},
				},
				Name: "union",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   146,
						},
						File:   "universe.flux",
						Source: "(tables: [[A]]) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   146,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   146,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 46,
								Line:   146,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   146,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 49,
									Line:   146,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   146,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 46,
									Line:   146,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   146,
							},
							File:   "universe.flux",
							Source: "(tables: [[A]]) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   146,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   146,
								},
								File:   "universe.flux",
								Source: "tables: [[A]]",
								Start: ast.Position{
									Column: 18,
									Line:   146,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   146,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "[[A]]",
									Start: ast.Position{
										Column: 26,
										Line:   146,
									},
								},
							},
							ElementType: &ast.ArrayType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   146,
										},
										File:   "universe.flux",
										Source: "[A]",
										Start: ast.Position{
											Column: 27,
											Line:   146,
										},
									},
								},
								ElementType: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   146,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   146,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   146,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 28,
													Line:   146,
												},
											},
										},
										Name: "A",
									},
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   146,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 36,
									Line:   146,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 37,
										Line:   146,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   146,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   146,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   147,
					},
					File:   "universe.flux",
					Source: "builtin unique",
					Start: ast.Position{
						Column: 1,
						Line:   147,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   147,
						},
						File:   "universe.flux",
						Source: "unique",
						Start: ast.Position{
							Column: 9,
							Line:   147,
						},
					},
				},
				Name: "unique",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   147,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   147,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 64,
								Line:   147,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 67,
									Line:   147,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 64,
									Line:   147,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   147,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   147,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   147,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   147,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   147,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   147,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   147,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   147,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   147,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   147,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   147,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   147,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   147,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 54,
									Line:   147,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 55,
										Line:   147,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   147,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 55,
											Line:   147,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   148,
					},
					File:   "universe.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   148,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   148,
						},
						File:   "universe.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   148,
						},
					},
				},
				Name: "window",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   159,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   148,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   158,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   158,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   158,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   159,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   159,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   159,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   159,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   157,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   148,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   149,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   149,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   149,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   149,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   149,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   149,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   149,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   149,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   149,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   149,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   150,
								},
								File:   "universe.flux",
								Source: "?every: duration",
								Start: ast.Position{
									Column: 5,
									Line:   150,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   150,
									},
									File:   "universe.flux",
									Source: "every",
									Start: ast.Position{
										Column: 6,
										Line:   150,
									},
								},
							},
							Name: "every",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   150,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 13,
										Line:   150,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   150,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 13,
											Line:   150,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   151,
								},
								File:   "universe.flux",
								Source: "?period: duration",
								Start: ast.Position{
									Column: 5,
									Line:   151,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   151,
									},
									File:   "universe.flux",
									Source: "period",
									Start: ast.Position{
										Column: 6,
										Line:   151,
									},
								},
							},
							Name: "period",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   151,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   151,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   151,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   151,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "?offset: duration",
								Start: ast.Position{
									Column: 5,
									Line:   152,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 6,
										Line:   152,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   152,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   152,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   152,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   153,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   153,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   153,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   153,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   153,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   153,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   153,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   153,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   154,
								},
								File:   "universe.flux",
								Source: "?startColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   154,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   154,
									},
									File:   "universe.flux",
									Source: "startColumn",
									Start: ast.Position{
										Column: 6,
										Line:   154,
									},
								},
							},
							Name: "startColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   154,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   154,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   154,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   154,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "?stopColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   155,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "stopColumn",
									Start: ast.Position{
										Column: 6,
										Line:   155,
									},
								},
							},
							Name: "stopColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   155,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   155,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "?createEmpty: bool",
								Start: ast.Position{
									Column: 5,
									Line:   156,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "createEmpty",
									Start: ast.Position{
										Column: 6,
										Line:   156,
									},
								},
							},
							Name: "createEmpty",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 19,
										Line:   156,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   156,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   156,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   157,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   157,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   157,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   157,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   157,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   157,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   161,
					},
					File:   "universe.flux",
					Source: "builtin yield",
					Start: ast.Position{
						Column: 1,
						Line:   161,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   161,
						},
						File:   "universe.flux",
						Source: "yield",
						Start: ast.Position{
							Column: 9,
							Line:   161,
						},
					},
				},
				Name: "yield",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   161,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?name: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   161,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   161,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   161,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   161,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   161,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   161,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?name: string) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   161,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   161,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   161,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   161,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   161,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   161,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   161,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "?name: string",
								Start: ast.Position{
									Column: 33,
									Line:   161,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "name",
									Start: ast.Position{
										Column: 34,
										Line:   161,
									},
								},
							},
							Name: "name",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   161,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   161,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   161,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   161,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   161,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// stream/table index functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   164,
					},
					File:   "universe.flux",
					Source: "builtin tableFind",
					Start: ast.Position{
						Column: 1,
						Line:   164,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   164,
						},
						File:   "universe.flux",
						Source: "tableFind",
						Start: ast.Position{
							Column: 9,
							Line:   164,
						},
					},
				},
				Name: "tableFind",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   164,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool) => [A] where A: Record, B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   164,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 72,
								Line:   164,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   164,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 72,
									Line:   164,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 83,
								Line:   164,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 86,
									Line:   164,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 83,
									Line:   164,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool) => [A]",
							Start: ast.Position{
								Column: 21,
								Line:   164,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   164,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   164,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   164,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   164,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   164,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 37,
									Line:   164,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 37,
										Line:   164,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 41,
										Line:   164,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 42,
											Line:   164,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 42,
												Line:   164,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 47,
												Line:   164,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   164,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 47,
													Line:   164,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 53,
											Line:   164,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 53,
												Line:   164,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 62,
									Line:   164,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 63,
										Line:   164,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   164,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   165,
					},
					File:   "universe.flux",
					Source: "builtin getColumn",
					Start: ast.Position{
						Column: 1,
						Line:   165,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "getColumn",
						Start: ast.Position{
							Column: 9,
							Line:   165,
						},
					},
				},
				Name: "getColumn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 74,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "(<-table: [A], column: string) => [B] where A: Record",
						Start: ast.Position{
							Column: 21,
							Line:   165,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   165,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   165,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   165,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "(<-table: [A], column: string) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   165,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "<-table: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   165,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "table",
									Start: ast.Position{
										Column: 24,
										Line:   165,
									},
								},
							},
							Name: "table",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   165,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   165,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   165,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   165,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 36,
									Line:   165,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 36,
										Line:   165,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   165,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   165,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   165,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   165,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   165,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   166,
					},
					File:   "universe.flux",
					Source: "builtin getRecord",
					Start: ast.Position{
						Column: 1,
						Line:   166,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   166,
						},
						File:   "universe.flux",
						Source: "getRecord",
						Start: ast.Position{
							Column: 9,
							Line:   166,
						},
					},
				},
				Name: "getRecord",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   166,
						},
						File:   "universe.flux",
						Source: "(<-table: [A], idx: int) => A where A: Record",
						Start: ast.Position{
							Column: 21,
							Line:   166,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   166,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 57,
								Line:   166,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 60,
									Line:   166,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 57,
									Line:   166,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   166,
							},
							File:   "universe.flux",
							Source: "(<-table: [A], idx: int) => A",
							Start: ast.Position{
								Column: 21,
								Line:   166,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "<-table: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   166,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "table",
									Start: ast.Position{
										Column: 24,
										Line:   166,
									},
								},
							},
							Name: "table",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   166,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   166,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   166,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   166,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   166,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "idx: int",
								Start: ast.Position{
									Column: 36,
									Line:   166,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "idx",
									Start: ast.Position{
										Column: 36,
										Line:   166,
									},
								},
							},
							Name: "idx",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 41,
										Line:   166,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   166,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 41,
											Line:   166,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 49,
									Line:   166,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 49,
										Line:   166,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   167,
					},
					File:   "universe.flux",
					Source: "builtin findColumn",
					Start: ast.Position{
						Column: 1,
						Line:   167,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   167,
						},
						File:   "universe.flux",
						Source: "findColumn",
						Start: ast.Position{
							Column: 9,
							Line:   167,
						},
					},
				},
				Name: "findColumn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 109,
							Line:   167,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool, column: string) => [C] where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   167,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   167,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 89,
								Line:   167,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   167,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 89,
									Line:   167,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   167,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 100,
								Line:   167,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 103,
									Line:   167,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 100,
									Line:   167,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   167,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool, column: string) => [C]",
							Start: ast.Position{
								Column: 22,
								Line:   167,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   167,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   167,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   167,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   167,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   167,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 38,
									Line:   167,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 38,
										Line:   167,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 42,
										Line:   167,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 43,
											Line:   167,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 43,
												Line:   167,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 48,
												Line:   167,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 48,
													Line:   167,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 54,
											Line:   167,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 54,
												Line:   167,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 60,
									Line:   167,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 60,
										Line:   167,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 68,
										Line:   167,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   167,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 79,
									Line:   167,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 80,
										Line:   167,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 80,
											Line:   167,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   168,
					},
					File:   "universe.flux",
					Source: "builtin findRecord",
					Start: ast.Position{
						Column: 1,
						Line:   168,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "findRecord",
						Start: ast.Position{
							Column: 9,
							Line:   168,
						},
					},
				},
				Name: "findRecord",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool, idx: int) => A where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   168,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   168,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 81,
								Line:   168,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 84,
									Line:   168,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 81,
									Line:   168,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   168,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 92,
								Line:   168,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 95,
									Line:   168,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 92,
									Line:   168,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   168,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool, idx: int) => A",
							Start: ast.Position{
								Column: 22,
								Line:   168,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   168,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   168,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   168,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   168,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   168,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 38,
									Line:   168,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 38,
										Line:   168,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 42,
										Line:   168,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 43,
											Line:   168,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 43,
												Line:   168,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 48,
												Line:   168,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   168,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 48,
													Line:   168,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 54,
											Line:   168,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 54,
												Line:   168,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "idx: int",
								Start: ast.Position{
									Column: 60,
									Line:   168,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "idx",
									Start: ast.Position{
										Column: 60,
										Line:   168,
									},
								},
							},
							Name: "idx",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 65,
										Line:   168,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 65,
											Line:   168,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 73,
									Line:   168,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 73,
										Line:   168,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// type conversion functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   171,
					},
					File:   "universe.flux",
					Source: "builtin bool",
					Start: ast.Position{
						Column: 1,
						Line:   171,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   171,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 9,
							Line:   171,
						},
					},
				},
				Name: "bool",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   171,
						},
						File:   "universe.flux",
						Source: "(v: A) => bool",
						Start: ast.Position{
							Column: 16,
							Line:   171,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   171,
							},
							File:   "universe.flux",
							Source: "(v: A) => bool",
							Start: ast.Position{
								Column: 16,
								Line:   171,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   171,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   171,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   171,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   171,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   171,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 26,
									Line:   171,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 26,
										Line:   171,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   172,
					},
					File:   "universe.flux",
					Source: "builtin bytes",
					Start: ast.Position{
						Column: 1,
						Line:   172,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   172,
						},
						File:   "universe.flux",
						Source: "bytes",
						Start: ast.Position{
							Column: 9,
							Line:   172,
						},
					},
				},
				Name: "bytes",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   172,
						},
						File:   "universe.flux",
						Source: "(v: A) => bytes",
						Start: ast.Position{
							Column: 17,
							Line:   172,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   172,
							},
							File:   "universe.flux",
							Source: "(v: A) => bytes",
							Start: ast.Position{
								Column: 17,
								Line:   172,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 18,
									Line:   172,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   172,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 21,
										Line:   172,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   172,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 21,
											Line:   172,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "bytes",
								Start: ast.Position{
									Column: 27,
									Line:   172,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "bytes",
									Start: ast.Position{
										Column: 27,
										Line:   172,
									},
								},
							},
							Name: "bytes",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   173,
					},
					File:   "universe.flux",
					Source: "builtin duration",
					Start: ast.Position{
						Column: 1,
						Line:   173,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   173,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 9,
							Line:   173,
						},
					},
				},
				Name: "duration",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   173,
						},
						File:   "universe.flux",
						Source: "(v: A) => duration",
						Start: ast.Position{
							Column: 20,
							Line:   173,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "(v: A) => duration",
							Start: ast.Position{
								Column: 20,
								Line:   173,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 21,
									Line:   173,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   173,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 24,
										Line:   173,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   173,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 24,
											Line:   173,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "duration",
								Start: ast.Position{
									Column: 30,
									Line:   173,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 30,
										Line:   173,
									},
								},
							},
							Name: "duration",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   174,
					},
					File:   "universe.flux",
					Source: "builtin float",
					Start: ast.Position{
						Column: 1,
						Line:   174,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   174,
						},
						File:   "universe.flux",
						Source: "float",
						Start: ast.Position{
							Column: 9,
							Line:   174,
						},
					},
				},
				Name: "float",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   174,
						},
						File:   "universe.flux",
						Source: "(v: A) => float",
						Start: ast.Position{
							Column: 17,
							Line:   174,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   174,
							},
							File:   "universe.flux",
							Source: "(v: A) => float",
							Start: ast.Position{
								Column: 17,
								Line:   174,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   174,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 18,
									Line:   174,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   174,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   174,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   174,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 21,
										Line:   174,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   174,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 21,
											Line:   174,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   174,
								},
								File:   "universe.flux",
								Source: "float",
								Start: ast.Position{
									Column: 27,
									Line:   174,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   174,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 27,
										Line:   174,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   175,
					},
					File:   "universe.flux",
					Source: "builtin int",
					Start: ast.Position{
						Column: 1,
						Line:   175,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   175,
						},
						File:   "universe.flux",
						Source: "int",
						Start: ast.Position{
							Column: 9,
							Line:   175,
						},
					},
				},
				Name: "int",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   175,
						},
						File:   "universe.flux",
						Source: "(v: A) => int",
						Start: ast.Position{
							Column: 15,
							Line:   175,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   175,
							},
							File:   "universe.flux",
							Source: "(v: A) => int",
							Start: ast.Position{
								Column: 15,
								Line:   175,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   175,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 16,
									Line:   175,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 16,
										Line:   175,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 19,
										Line:   175,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   175,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 19,
											Line:   175,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   175,
								},
								File:   "universe.flux",
								Source: "int",
								Start: ast.Position{
									Column: 25,
									Line:   175,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 25,
										Line:   175,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   176,
					},
					File:   "universe.flux",
					Source: "builtin string",
					Start: ast.Position{
						Column: 1,
						Line:   176,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   176,
						},
						File:   "universe.flux",
						Source: "string",
						Start: ast.Position{
							Column: 9,
							Line:   176,
						},
					},
				},
				Name: "string",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   176,
						},
						File:   "universe.flux",
						Source: "(v: A) => string",
						Start: ast.Position{
							Column: 18,
							Line:   176,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   176,
							},
							File:   "universe.flux",
							Source: "(v: A) => string",
							Start: ast.Position{
								Column: 18,
								Line:   176,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 19,
									Line:   176,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 19,
										Line:   176,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 22,
										Line:   176,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   176,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 22,
											Line:   176,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "string",
								Start: ast.Position{
									Column: 28,
									Line:   176,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 28,
										Line:   176,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   177,
					},
					File:   "universe.flux",
					Source: "builtin time",
					Start: ast.Position{
						Column: 1,
						Line:   177,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   177,
						},
						File:   "universe.flux",
						Source: "time",
						Start: ast.Position{
							Column: 9,
							Line:   177,
						},
					},
				},
				Name: "time",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   177,
						},
						File:   "universe.flux",
						Source: "(v: A) => time",
						Start: ast.Position{
							Column: 16,
							Line:   177,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   177,
							},
							File:   "universe.flux",
							Source: "(v: A) => time",
							Start: ast.Position{
								Column: 16,
								Line:   177,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   177,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   177,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   177,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   177,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 26,
									Line:   177,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "time",
									Start: ast.Position{
										Column: 26,
										Line:   177,
									},
								},
							},
							Name: "time",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   178,
					},
					File:   "universe.flux",
					Source: "builtin uint",
					Start: ast.Position{
						Column: 1,
						Line:   178,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 9,
							Line:   178,
						},
					},
				},
				Name: "uint",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "(v: A) => uint",
						Start: ast.Position{
							Column: 16,
							Line:   178,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   178,
							},
							File:   "universe.flux",
							Source: "(v: A) => uint",
							Start: ast.Position{
								Column: 16,
								Line:   178,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   178,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   178,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   178,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "uint",
								Start: ast.Position{
									Column: 26,
									Line:   178,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "uint",
									Start: ast.Position{
										Column: 26,
										Line:   178,
									},
								},
							},
							Name: "uint",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// contains function\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   181,
					},
					File:   "universe.flux",
					Source: "builtin contains",
					Start: ast.Position{
						Column: 1,
						Line:   181,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   181,
						},
						File:   "universe.flux",
						Source: "contains",
						Start: ast.Position{
							Column: 9,
							Line:   181,
						},
					},
				},
				Name: "contains",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   181,
						},
						File:   "universe.flux",
						Source: "(value: A, set: [A]) => bool where A: Nullable",
						Start: ast.Position{
							Column: 20,
							Line:   181,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   181,
							},
							File:   "universe.flux",
							Source: "A: Nullable",
							Start: ast.Position{
								Column: 55,
								Line:   181,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "Nullable",
								Start: ast.Position{
									Column: 58,
									Line:   181,
								},
							},
						},
						Name: "Nullable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 55,
									Line:   181,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   181,
							},
							File:   "universe.flux",
							Source: "(value: A, set: [A]) => bool",
							Start: ast.Position{
								Column: 20,
								Line:   181,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "value: A",
								Start: ast.Position{
									Column: 21,
									Line:   181,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 21,
										Line:   181,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 28,
										Line:   181,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   181,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   181,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "set: [A]",
								Start: ast.Position{
									Column: 31,
									Line:   181,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "set",
									Start: ast.Position{
										Column: 31,
										Line:   181,
									},
								},
							},
							Name: "set",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   181,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   181,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   181,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   181,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   181,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 44,
									Line:   181,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 44,
										Line:   181,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// other builtins\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   184,
					},
					File:   "universe.flux",
					Source: "builtin inf",
					Start: ast.Position{
						Column: 1,
						Line:   184,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   184,
						},
						File:   "universe.flux",
						Source: "inf",
						Start: ast.Position{
							Column: 9,
							Line:   184,
						},
					},
				},
				Name: "inf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   184,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 15,
							Line:   184,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   184,
							},
							File:   "universe.flux",
							Source: "duration",
							Start: ast.Position{
								Column: 15,
								Line:   184,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "duration",
								Start: ast.Position{
									Column: 15,
									Line:   184,
								},
							},
						},
						Name: "duration",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   185,
					},
					File:   "universe.flux",
					Source: "builtin length",
					Start: ast.Position{
						Column: 1,
						Line:   185,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   185,
						},
						File:   "universe.flux",
						Source: "length",
						Start: ast.Position{
							Column: 9,
							Line:   185,
						},
					},
				},
				Name: "length",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   185,
						},
						File:   "universe.flux",
						Source: "(arr: [A]) => int",
						Start: ast.Position{
							Column: 18,
							Line:   185,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   185,
							},
							File:   "universe.flux",
							Source: "(arr: [A]) => int",
							Start: ast.Position{
								Column: 18,
								Line:   185,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "arr: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   185,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   185,
									},
									File:   "universe.flux",
									Source: "arr",
									Start: ast.Position{
										Column: 19,
										Line:   185,
									},
								},
							},
							Name: "arr",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   185,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 24,
										Line:   185,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   185,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 25,
											Line:   185,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   185,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 25,
												Line:   185,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "int",
								Start: ast.Position{
									Column: 32,
									Line:   185,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   185,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 32,
										Line:   185,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   186,
					},
					File:   "universe.flux",
					Source: "builtin linearBins",
					Start: ast.Position{
						Column: 1,
						Line:   186,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   186,
						},
						File:   "universe.flux",
						Source: "linearBins",
						Start: ast.Position{
							Column: 9,
							Line:   186,
						},
					},
				},
				Name: "linearBins",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   186,
						},
						File:   "universe.flux",
						Source: "(start: float, width: float, count: int, ?infinity: bool) => [float]",
						Start: ast.Position{
							Column: 22,
							Line:   186,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   186,
							},
							File:   "universe.flux",
							Source: "(start: float, width: float, count: int, ?infinity: bool) => [float]",
							Start: ast.Position{
								Column: 22,
								Line:   186,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   186,
								},
								File:   "universe.flux",
								Source: "start: float",
								Start: ast.Position{
									Column: 23,
									Line:   186,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 23,
										Line:   186,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   186,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   186,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 30,
											Line:   186,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   186,
								},
								File:   "universe.flux",
								Source: "width: float",
								Start: ast.Position{
									Column: 37,
									Line:   186,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "width",
									Start: ast.Position{
										Column: 37,
										Line:   186,
									},
								},
							},
							Name: "width",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   186,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   186,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 44,
											Line:   186,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   186,
								},
								File:   "universe.flux",
								Source: "count: int",
								Start: ast.Position{
									Column: 51,
									Line:   186,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "count",
									Start: ast.Position{
										Column: 51,
										Line:   186,
									},
								},
							},
							Name: "count",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 58,
										Line:   186,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   186,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 58,
											Line:   186,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   186,
								},
								File:   "universe.flux",
								Source: "?infinity: bool",
								Start: ast.Position{
									Column: 63,
									Line:   186,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "infinity",
									Start: ast.Position{
										Column: 64,
										Line:   186,
									},
								},
							},
							Name: "infinity",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 74,
										Line:   186,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   186,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 74,
											Line:   186,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   186,
								},
								File:   "universe.flux",
								Source: "[float]",
								Start: ast.Position{
									Column: 83,
									Line:   186,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 84,
										Line:   186,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   186,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 84,
											Line:   186,
										},
									},
								},
								Name: "float",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   187,
					},
					File:   "universe.flux",
					Source: "builtin logarithmicBins",
					Start: ast.Position{
						Column: 1,
						Line:   187,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   187,
						},
						File:   "universe.flux",
						Source: "logarithmicBins",
						Start: ast.Position{
							Column: 9,
							Line:   187,
						},
					},
				},
				Name: "logarithmicBins",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   187,
						},
						File:   "universe.flux",
						Source: "(start: float, factor: float, count: int, ?infinity: bool) => [float]",
						Start: ast.Position{
							Column: 27,
							Line:   187,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   187,
							},
							File:   "universe.flux",
							Source: "(start: float, factor: float, count: int, ?infinity: bool) => [float]",
							Start: ast.Position{
								Column: 27,
								Line:   187,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "start: float",
								Start: ast.Position{
									Column: 28,
									Line:   187,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 28,
										Line:   187,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 35,
										Line:   187,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 35,
											Line:   187,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "factor: float",
								Start: ast.Position{
									Column: 42,
									Line:   187,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "factor",
									Start: ast.Position{
										Column: 42,
										Line:   187,
									},
								},
							},
							Name: "factor",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 50,
										Line:   187,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 50,
											Line:   187,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "count: int",
								Start: ast.Position{
									Column: 57,
									Line:   187,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "count",
									Start: ast.Position{
										Column: 57,
										Line:   187,
									},
								},
							},
							Name: "count",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 64,
										Line:   187,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 64,
											Line:   187,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "?infinity: bool",
								Start: ast.Position{
									Column: 69,
									Line:   187,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "infinity",
									Start: ast.Position{
										Column: 70,
										Line:   187,
									},
								},
							},
							Name: "infinity",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 80,
										Line:   187,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 80,
											Line:   187,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "[float]",
								Start: ast.Position{
									Column: 89,
									Line:   187,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 90,
										Line:   187,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 90,
											Line:   187,
										},
									},
								},
								Name: "float",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// sleep is the identity function with the side effect of delaying execution by a specified duration\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   190,
					},
					File:   "universe.flux",
					Source: "builtin sleep",
					Start: ast.Position{
						Column: 1,
						Line:   190,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   190,
						},
						File:   "universe.flux",
						Source: "sleep",
						Start: ast.Position{
							Column: 9,
							Line:   190,
						},
					},
				},
				Name: "sleep",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   190,
						},
						File:   "universe.flux",
						Source: "(<-v: A, duration: duration) => A",
						Start: ast.Position{
							Column: 17,
							Line:   190,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   190,
							},
							File:   "universe.flux",
							Source: "(<-v: A, duration: duration) => A",
							Start: ast.Position{
								Column: 17,
								Line:   190,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   190,
								},
								File:   "universe.flux",
								Source: "<-v: A",
								Start: ast.Position{
									Column: 18,
									Line:   190,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   190,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   190,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   190,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 23,
										Line:   190,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   190,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 23,
											Line:   190,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   190,
								},
								File:   "universe.flux",
								Source: "duration: duration",
								Start: ast.Position{
									Column: 26,
									Line:   190,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   190,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 26,
										Line:   190,
									},
								},
							},
							Name: "duration",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   190,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 36,
										Line:   190,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   190,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 36,
											Line:   190,
										},
									},
								},
								Name: "duration",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   190,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 49,
									Line:   190,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   190,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 49,
										Line:   190,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// die returns a fatal error from within a flux script\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   193,
					},
					File:   "universe.flux",
					Source: "builtin die",
					Start: ast.Position{
						Column: 1,
						Line:   193,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   193,
						},
						File:   "universe.flux",
						Source: "die",
						Start: ast.Position{
							Column: 9,
							Line:   193,
						},
					},
				},
				Name: "die",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   193,
						},
						File:   "universe.flux",
						Source: "(msg: string) => A",
						Start: ast.Position{
							Column: 15,
							Line:   193,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   193,
							},
							File:   "universe.flux",
							Source: "(msg: string) => A",
							Start: ast.Position{
								Column: 15,
								Line:   193,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   193,
								},
								File:   "universe.flux",
								Source: "msg: string",
								Start: ast.Position{
									Column: 16,
									Line:   193,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   193,
									},
									File:   "universe.flux",
									Source: "msg",
									Start: ast.Position{
										Column: 16,
										Line:   193,
									},
								},
							},
							Name: "msg",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   193,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   193,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   193,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   193,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   193,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 32,
									Line:   193,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   193,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   193,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 124,
						Line:   198,
					},
					File:   "universe.flux",
					Source: "timeWeightedAvg = (tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
					Start: ast.Position{
						Column: 1,
						Line:   196,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Time weighted average where values at the beginning and end of the range are linearly interpolated.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   196,
						},
						File:   "universe.flux",
						Source: "timeWeightedAvg",
						Start: ast.Position{
							Column: 1,
							Line:   196,
						},
					},
				},
				Name: "timeWeightedAvg",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   198,
						},
						File:   "universe.flux",
						Source: "(tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
						Start: ast.Position{
							Column: 19,
							Line:   196,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   196,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 40,
										Line:   196,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "tables\n    |> integral(unit: unit, interpolate: \"linear\")",
								Start: ast.Position{
									Column: 40,
									Line:   196,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "unit: unit, interpolate: \"linear\"",
										Start: ast.Position{
											Column: 17,
											Line:   197,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   197,
											},
											File:   "universe.flux",
											Source: "unit: unit",
											Start: ast.Position{
												Column: 17,
												Line:   197,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   197,
												},
												File:   "universe.flux",
												Source: "unit",
												Start: ast.Position{
													Column: 17,
													Line:   197,
												},
											},
										},
										Name: "unit",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   197,
												},
												File:   "universe.flux",
												Source: "unit",
												Start: ast.Position{
													Column: 23,
													Line:   197,
												},
											},
										},
										Name: "unit",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   197,
											},
											File:   "universe.flux",
											Source: "interpolate: \"linear\"",
											Start: ast.Position{
												Column: 29,
												Line:   197,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   197,
												},
												File:   "universe.flux",
												Source: "interpolate",
												Start: ast.Position{
													Column: 29,
													Line:   197,
												},
											},
										},
										Name: "interpolate",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   197,
												},
												File:   "universe.flux",
												Source: "\"linear\"",
												Start: ast.Position{
													Column: 42,
													Line:   197,
												},
											},
										},
										Value: "linear",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   197,
									},
									File:   "universe.flux",
									Source: "integral(unit: unit, interpolate: \"linear\")",
									Start: ast.Position{
										Column: 8,
										Line:   197,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "integral",
										Start: ast.Position{
											Column: 8,
											Line:   197,
										},
									},
								},
								Name: "integral",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   198,
							},
							File:   "universe.flux",
							Source: "tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
							Start: ast.Position{
								Column: 40,
								Line:   196,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 123,
										Line:   198,
									},
									File:   "universe.flux",
									Source: "fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
									Start: ast.Position{
										Column: 12,
										Line:   198,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 123,
											Line:   198,
										},
										File:   "universe.flux",
										Source: "fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
										Start: ast.Position{
											Column: 12,
											Line:   198,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   198,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   198,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   198,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
											Start: ast.Position{
												Column: 16,
												Line:   198,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 123,
													Line:   198,
												},
												File:   "universe.flux",
												Source: "({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
												Start: ast.Position{
													Column: 23,
													Line:   198,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 122,
														Line:   198,
													},
													File:   "universe.flux",
													Source: "{r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}",
													Start: ast.Position{
														Column: 24,
														Line:   198,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 121,
															Line:   198,
														},
														File:   "universe.flux",
														Source: "_value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))",
														Start: ast.Position{
															Column: 32,
															Line:   198,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   198,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   198,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 121,
																Line:   198,
															},
															File:   "universe.flux",
															Source: "r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))",
															Start: ast.Position{
																Column: 40,
																Line:   198,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   198,
																},
																File:   "universe.flux",
																Source: "r._value * float(v: uint(v: unit))",
																Start: ast.Position{
																	Column: 40,
																	Line:   198,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   198,
																	},
																	File:   "universe.flux",
																	Source: "r._value",
																	Start: ast.Position{
																		Column: 40,
																		Line:   198,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   198,
																		},
																		File:   "universe.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 40,
																			Line:   198,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   198,
																		},
																		File:   "universe.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 42,
																			Line:   198,
																		},
																	},
																},
																Name: "_value",
															},
															Rbrack: nil,
														},
														Operator: 1,
														Right: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   198,
																		},
																		File:   "universe.flux",
																		Source: "v: uint(v: unit)",
																		Start: ast.Position{
																			Column: 57,
																			Line:   198,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   198,
																			},
																			File:   "universe.flux",
																			Source: "v: uint(v: unit)",
																			Start: ast.Position{
																				Column: 57,
																				Line:   198,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   198,
																				},
																				File:   "universe.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 57,
																					Line:   198,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 72,
																						Line:   198,
																					},
																					File:   "universe.flux",
																					Source: "v: unit",
																					Start: ast.Position{
																						Column: 65,
																						Line:   198,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 72,
																							Line:   198,
																						},
																						File:   "universe.flux",
																						Source: "v: unit",
																						Start: ast.Position{
																							Column: 65,
																							Line:   198,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 66,
																								Line:   198,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 65,
																								Line:   198,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 72,
																								Line:   198,
																							},
																							File:   "universe.flux",
																							Source: "unit",
																							Start: ast.Position{
																								Column: 68,
																								Line:   198,
																							},
																						},
																					},
																					Name: "unit",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 73,
																					Line:   198,
																				},
																				File:   "universe.flux",
																				Source: "uint(v: unit)",
																				Start: ast.Position{
																					Column: 60,
																					Line:   198,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   198,
																					},
																					File:   "universe.flux",
																					Source: "uint",
																					Start: ast.Position{
																						Column: 60,
																						Line:   198,
																					},
																				},
																			},
																			Name: "uint",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   198,
																	},
																	File:   "universe.flux",
																	Source: "float(v: uint(v: unit))",
																	Start: ast.Position{
																		Column: 51,
																		Line:   198,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   198,
																		},
																		File:   "universe.flux",
																		Source: "float",
																		Start: ast.Position{
																			Column: 51,
																			Line:   198,
																		},
																	},
																},
																Name: "float",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													Operator: 2,
													Right: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 120,
																		Line:   198,
																	},
																	File:   "universe.flux",
																	Source: "v: int(v: r._stop) - int(v: r._start)",
																	Start: ast.Position{
																		Column: 83,
																		Line:   198,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 120,
																			Line:   198,
																		},
																		File:   "universe.flux",
																		Source: "v: int(v: r._stop) - int(v: r._start)",
																		Start: ast.Position{
																			Column: 83,
																			Line:   198,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   198,
																			},
																			File:   "universe.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 83,
																				Line:   198,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 120,
																				Line:   198,
																			},
																			File:   "universe.flux",
																			Source: "int(v: r._stop) - int(v: r._start)",
																			Start: ast.Position{
																				Column: 86,
																				Line:   198,
																			},
																		},
																	},
																	Left: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 100,
																						Line:   198,
																					},
																					File:   "universe.flux",
																					Source: "v: r._stop",
																					Start: ast.Position{
																						Column: 90,
																						Line:   198,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 100,
																							Line:   198,
																						},
																						File:   "universe.flux",
																						Source: "v: r._stop",
																						Start: ast.Position{
																							Column: 90,
																							Line:   198,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 91,
																								Line:   198,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 90,
																								Line:   198,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 100,
																								Line:   198,
																							},
																							File:   "universe.flux",
																							Source: "r._stop",
																							Start: ast.Position{
																								Column: 93,
																								Line:   198,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 94,
																									Line:   198,
																								},
																								File:   "universe.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 93,
																									Line:   198,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 100,
																									Line:   198,
																								},
																								File:   "universe.flux",
																								Source: "_stop",
																								Start: ast.Position{
																									Column: 95,
																									Line:   198,
																								},
																							},
																						},
																						Name: "_stop",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 101,
																					Line:   198,
																				},
																				File:   "universe.flux",
																				Source: "int(v: r._stop)",
																				Start: ast.Position{
																					Column: 86,
																					Line:   198,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 89,
																						Line:   198,
																					},
																					File:   "universe.flux",
																					Source: "int",
																					Start: ast.Position{
																						Column: 86,
																						Line:   198,
																					},
																				},
																			},
																			Name: "int",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																	Operator: 6,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 119,
																						Line:   198,
																					},
																					File:   "universe.flux",
																					Source: "v: r._start",
																					Start: ast.Position{
																						Column: 108,
																						Line:   198,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 119,
																							Line:   198,
																						},
																						File:   "universe.flux",
																						Source: "v: r._start",
																						Start: ast.Position{
																							Column: 108,
																							Line:   198,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 109,
																								Line:   198,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 108,
																								Line:   198,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 119,
																								Line:   198,
																							},
																							File:   "universe.flux",
																							Source: "r._start",
																							Start: ast.Position{
																								Column: 111,
																								Line:   198,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 112,
																									Line:   198,
																								},
																								File:   "universe.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 111,
																									Line:   198,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 119,
																									Line:   198,
																								},
																								File:   "universe.flux",
																								Source: "_start",
																								Start: ast.Position{
																									Column: 113,
																									Line:   198,
																								},
																							},
																						},
																						Name: "_start",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 120,
																					Line:   198,
																				},
																				File:   "universe.flux",
																				Source: "int(v: r._start)",
																				Start: ast.Position{
																					Column: 104,
																					Line:   198,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 107,
																						Line:   198,
																					},
																					File:   "universe.flux",
																					Source: "int",
																					Start: ast.Position{
																						Column: 104,
																						Line:   198,
																					},
																				},
																			},
																			Name: "int",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 121,
																	Line:   198,
																},
																File:   "universe.flux",
																Source: "float(v: int(v: r._stop) - int(v: r._start))",
																Start: ast.Position{
																	Column: 77,
																	Line:   198,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 82,
																		Line:   198,
																	},
																	File:   "universe.flux",
																	Source: "float",
																	Start: ast.Position{
																		Column: 77,
																		Line:   198,
																	},
																},
															},
															Name: "float",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   198,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   198,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   198,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   198,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   198,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   198,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   198,
								},
								File:   "universe.flux",
								Source: "map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
								Start: ast.Position{
									Column: 8,
									Line:   198,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   198,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   198,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 20,
								Line:   196,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 20,
									Line:   196,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   196,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "unit",
							Start: ast.Position{
								Column: 31,
								Line:   196,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 31,
									Line:   196,
								},
							},
						},
						Name: "unit",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 73,
						Line:   205,
					},
					File:   "universe.flux",
					Source: "cov = (x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
					Start: ast.Position{
						Column: 1,
						Line:   201,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// covariance function with automatic join\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   201,
						},
						File:   "universe.flux",
						Source: "cov",
						Start: ast.Position{
							Column: 1,
							Line:   201,
						},
					},
				},
				Name: "cov",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   205,
						},
						File:   "universe.flux",
						Source: "(x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
						Start: ast.Position{
							Column: 7,
							Line:   201,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   203,
									},
									File:   "universe.flux",
									Source: "tables: {x: x, y: y},\n    on: on",
									Start: ast.Position{
										Column: 5,
										Line:   202,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   202,
										},
										File:   "universe.flux",
										Source: "tables: {x: x, y: y}",
										Start: ast.Position{
											Column: 5,
											Line:   202,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   202,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   202,
											},
										},
									},
									Name: "tables",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   202,
											},
											File:   "universe.flux",
											Source: "{x: x, y: y}",
											Start: ast.Position{
												Column: 13,
												Line:   202,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   202,
												},
												File:   "universe.flux",
												Source: "x: x",
												Start: ast.Position{
													Column: 14,
													Line:   202,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 14,
														Line:   202,
													},
												},
											},
											Name: "x",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 17,
														Line:   202,
													},
												},
											},
											Name: "x",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   202,
												},
												File:   "universe.flux",
												Source: "y: y",
												Start: ast.Position{
													Column: 20,
													Line:   202,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 20,
														Line:   202,
													},
												},
											},
											Name: "y",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 23,
														Line:   202,
													},
												},
											},
											Name: "y",
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   203,
										},
										File:   "universe.flux",
										Source: "on: on",
										Start: ast.Position{
											Column: 5,
											Line:   203,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   203,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 5,
												Line:   203,
											},
										},
									},
									Name: "on",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   203,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 9,
												Line:   203,
											},
										},
									},
									Name: "on",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   204,
								},
								File:   "universe.flux",
								Source: "join(\n    tables: {x: x, y: y},\n    on: on,\n)",
								Start: ast.Position{
									Column: 37,
									Line:   201,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   201,
									},
									File:   "universe.flux",
									Source: "join",
									Start: ast.Position{
										Column: 37,
										Line:   201,
									},
								},
							},
							Name: "join",
						},
						Lparen: nil,
						Rparen: nil,
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   205,
							},
							File:   "universe.flux",
							Source: "join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
							Start: ast.Position{
								Column: 37,
								Line:   201,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   205,
									},
									File:   "universe.flux",
									Source: "pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"]",
									Start: ast.Position{
										Column: 19,
										Line:   205,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   205,
										},
										File:   "universe.flux",
										Source: "pearsonr: pearsonr",
										Start: ast.Position{
											Column: 19,
											Line:   205,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   205,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 19,
												Line:   205,
											},
										},
									},
									Name: "pearsonr",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   205,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 29,
												Line:   205,
											},
										},
									},
									Name: "pearsonr",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   205,
										},
										File:   "universe.flux",
										Source: "columns: [\"_value_x\", \"_value_y\"]",
										Start: ast.Position{
											Column: 39,
											Line:   205,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   205,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 39,
												Line:   205,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   205,
											},
											File:   "universe.flux",
											Source: "[\"_value_x\", \"_value_y\"]",
											Start: ast.Position{
												Column: 48,
												Line:   205,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   205,
												},
												File:   "universe.flux",
												Source: "\"_value_x\"",
												Start: ast.Position{
													Column: 49,
													Line:   205,
												},
											},
										},
										Value: "_value_x",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   205,
												},
												File:   "universe.flux",
												Source: "\"_value_y\"",
												Start: ast.Position{
													Column: 61,
													Line:   205,
												},
											},
										},
										Value: "_value_y",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   205,
								},
								File:   "universe.flux",
								Source: "covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
								Start: ast.Position{
									Column: 8,
									Line:   205,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   205,
									},
									File:   "universe.flux",
									Source: "covariance",
									Start: ast.Position{
										Column: 8,
										Line:   205,
									},
								},
							},
							Name: "covariance",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   201,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 8,
								Line:   201,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   201,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 8,
									Line:   201,
								},
							},
						},
						Name: "x",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   201,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 11,
								Line:   201,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   201,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 11,
									Line:   201,
								},
							},
						},
						Name: "y",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   201,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 14,
								Line:   201,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   201,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 14,
									Line:   201,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   201,
							},
							File:   "universe.flux",
							Source: "pearsonr=false",
							Start: ast.Position{
								Column: 18,
								Line:   201,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   201,
								},
								File:   "universe.flux",
								Source: "pearsonr",
								Start: ast.Position{
									Column: 18,
									Line:   201,
								},
							},
						},
						Name: "pearsonr",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   201,
								},
								File:   "universe.flux",
								Source: "false",
								Start: ast.Position{
									Column: 27,
									Line:   201,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 65,
						Line:   206,
					},
					File:   "universe.flux",
					Source: "pearsonr = (x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)",
					Start: ast.Position{
						Column: 1,
						Line:   206,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   206,
						},
						File:   "universe.flux",
						Source: "pearsonr",
						Start: ast.Position{
							Column: 1,
							Line:   206,
						},
					},
				},
				Name: "pearsonr",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   206,
						},
						File:   "universe.flux",
						Source: "(x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)",
						Start: ast.Position{
							Column: 12,
							Line:   206,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "x: x, y: y, on: on, pearsonr: true",
								Start: ast.Position{
									Column: 30,
									Line:   206,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   206,
									},
									File:   "universe.flux",
									Source: "x: x",
									Start: ast.Position{
										Column: 30,
										Line:   206,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 30,
											Line:   206,
										},
									},
								},
								Name: "x",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 33,
											Line:   206,
										},
									},
								},
								Name: "x",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   206,
									},
									File:   "universe.flux",
									Source: "y: y",
									Start: ast.Position{
										Column: 36,
										Line:   206,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 36,
											Line:   206,
										},
									},
								},
								Name: "y",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 39,
											Line:   206,
										},
									},
								},
								Name: "y",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   206,
									},
									File:   "universe.flux",
									Source: "on: on",
									Start: ast.Position{
										Column: 42,
										Line:   206,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 42,
											Line:   206,
										},
									},
								},
								Name: "on",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 46,
											Line:   206,
										},
									},
								},
								Name: "on",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   206,
									},
									File:   "universe.flux",
									Source: "pearsonr: true",
									Start: ast.Position{
										Column: 50,
										Line:   206,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "pearsonr",
										Start: ast.Position{
											Column: 50,
											Line:   206,
										},
									},
								},
								Name: "pearsonr",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "true",
										Start: ast.Position{
											Column: 60,
											Line:   206,
										},
									},
								},
								Name: "true",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   206,
							},
							File:   "universe.flux",
							Source: "cov(x: x, y: y, on: on, pearsonr: true)",
							Start: ast.Position{
								Column: 26,
								Line:   206,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "cov",
								Start: ast.Position{
									Column: 26,
									Line:   206,
								},
							},
						},
						Name: "cov",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   206,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 13,
								Line:   206,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 13,
									Line:   206,
								},
							},
						},
						Name: "x",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   206,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 16,
								Line:   206,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 16,
									Line:   206,
								},
							},
						},
						Name: "y",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   206,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 19,
								Line:   206,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 19,
									Line:   206,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 47,
						Line:   224,
					},
					File:   "universe.flux",
					Source: "aggregateWindow = (\n        every,\n        fn,\n        offset=0s,\n        column=\"_value\",\n        timeSrc=\"_stop\",\n        timeDst=\"_time\",\n        createEmpty=true,\n        tables=<-,\n) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
					Start: ast.Position{
						Column: 1,
						Line:   211,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// AggregateWindow applies an aggregate function to fixed windows of time.\n"}, ast.Comment{Text: "// The procedure is to window the data, perform an aggregate operation,\n"}, ast.Comment{Text: "// and then undo the windowing to produce an output table for every input table.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   211,
						},
						File:   "universe.flux",
						Source: "aggregateWindow",
						Start: ast.Position{
							Column: 1,
							Line:   211,
						},
					},
				},
				Name: "aggregateWindow",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   224,
						},
						File:   "universe.flux",
						Source: "(\n        every,\n        fn,\n        offset=0s,\n        column=\"_value\",\n        timeSrc=\"_stop\",\n        timeDst=\"_time\",\n        createEmpty=true,\n        tables=<-,\n) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
						Start: ast.Position{
							Column: 19,
							Line:   211,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   220,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 6,
												Line:   220,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   221,
										},
										File:   "universe.flux",
										Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)",
										Start: ast.Position{
											Column: 6,
											Line:   220,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   221,
												},
												File:   "universe.flux",
												Source: "every: every, offset: offset, createEmpty: createEmpty",
												Start: ast.Position{
													Column: 15,
													Line:   221,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   221,
													},
													File:   "universe.flux",
													Source: "every: every",
													Start: ast.Position{
														Column: 15,
														Line:   221,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 15,
															Line:   221,
														},
													},
												},
												Name: "every",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 22,
															Line:   221,
														},
													},
												},
												Name: "every",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   221,
													},
													File:   "universe.flux",
													Source: "offset: offset",
													Start: ast.Position{
														Column: 29,
														Line:   221,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "offset",
														Start: ast.Position{
															Column: 29,
															Line:   221,
														},
													},
												},
												Name: "offset",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "offset",
														Start: ast.Position{
															Column: 37,
															Line:   221,
														},
													},
												},
												Name: "offset",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   221,
													},
													File:   "universe.flux",
													Source: "createEmpty: createEmpty",
													Start: ast.Position{
														Column: 45,
														Line:   221,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 45,
															Line:   221,
														},
													},
												},
												Name: "createEmpty",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 58,
															Line:   221,
														},
													},
												},
												Name: "createEmpty",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   221,
											},
											File:   "universe.flux",
											Source: "window(every: every, offset: offset, createEmpty: createEmpty)",
											Start: ast.Position{
												Column: 8,
												Line:   221,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   221,
												},
												File:   "universe.flux",
												Source: "window",
												Start: ast.Position{
													Column: 8,
													Line:   221,
												},
											},
										},
										Name: "window",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   222,
									},
									File:   "universe.flux",
									Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)",
									Start: ast.Position{
										Column: 6,
										Line:   220,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   222,
											},
											File:   "universe.flux",
											Source: "column: column",
											Start: ast.Position{
												Column: 11,
												Line:   222,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   222,
												},
												File:   "universe.flux",
												Source: "column: column",
												Start: ast.Position{
													Column: 11,
													Line:   222,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   222,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 11,
														Line:   222,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   222,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 19,
														Line:   222,
													},
												},
											},
											Name: "column",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   222,
										},
										File:   "universe.flux",
										Source: "fn(column: column)",
										Start: ast.Position{
											Column: 8,
											Line:   222,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   222,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 8,
												Line:   222,
											},
										},
									},
									Name: "fn",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   223,
								},
								File:   "universe.flux",
								Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)",
								Start: ast.Position{
									Column: 6,
									Line:   220,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   223,
										},
										File:   "universe.flux",
										Source: "column: timeSrc, as: timeDst",
										Start: ast.Position{
											Column: 18,
											Line:   223,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   223,
											},
											File:   "universe.flux",
											Source: "column: timeSrc",
											Start: ast.Position{
												Column: 18,
												Line:   223,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   223,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 18,
													Line:   223,
												},
											},
										},
										Name: "column",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   223,
												},
												File:   "universe.flux",
												Source: "timeSrc",
												Start: ast.Position{
													Column: 26,
													Line:   223,
												},
											},
										},
										Name: "timeSrc",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   223,
											},
											File:   "universe.flux",
											Source: "as: timeDst",
											Start: ast.Position{
												Column: 35,
												Line:   223,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   223,
												},
												File:   "universe.flux",
												Source: "as",
												Start: ast.Position{
													Column: 35,
													Line:   223,
												},
											},
										},
										Name: "as",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   223,
												},
												File:   "universe.flux",
												Source: "timeDst",
												Start: ast.Position{
													Column: 39,
													Line:   223,
												},
											},
										},
										Name: "timeDst",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   223,
									},
									File:   "universe.flux",
									Source: "duplicate(column: timeSrc, as: timeDst)",
									Start: ast.Position{
										Column: 8,
										Line:   223,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   223,
										},
										File:   "universe.flux",
										Source: "duplicate",
										Start: ast.Position{
											Column: 8,
											Line:   223,
										},
									},
								},
								Name: "duplicate",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   224,
							},
							File:   "universe.flux",
							Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
							Start: ast.Position{
								Column: 6,
								Line:   220,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   224,
									},
									File:   "universe.flux",
									Source: "every: inf, timeColumn: timeDst",
									Start: ast.Position{
										Column: 15,
										Line:   224,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   224,
										},
										File:   "universe.flux",
										Source: "every: inf",
										Start: ast.Position{
											Column: 15,
											Line:   224,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "every",
											Start: ast.Position{
												Column: 15,
												Line:   224,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "inf",
											Start: ast.Position{
												Column: 22,
												Line:   224,
											},
										},
									},
									Name: "inf",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   224,
										},
										File:   "universe.flux",
										Source: "timeColumn: timeDst",
										Start: ast.Position{
											Column: 27,
											Line:   224,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 27,
												Line:   224,
											},
										},
									},
									Name: "timeColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "timeDst",
											Start: ast.Position{
												Column: 39,
												Line:   224,
											},
										},
									},
									Name: "timeDst",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   224,
								},
								File:   "universe.flux",
								Source: "window(every: inf, timeColumn: timeDst)",
								Start: ast.Position{
									Column: 8,
									Line:   224,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   224,
									},
									File:   "universe.flux",
									Source: "window",
									Start: ast.Position{
										Column: 8,
										Line:   224,
									},
								},
							},
							Name: "window",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   212,
							},
							File:   "universe.flux",
							Source: "every",
							Start: ast.Position{
								Column: 9,
								Line:   212,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   212,
								},
								File:   "universe.flux",
								Source: "every",
								Start: ast.Position{
									Column: 9,
									Line:   212,
								},
							},
						},
						Name: "every",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   213,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 9,
								Line:   213,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   213,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 9,
									Line:   213,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "offset=0s",
							Start: ast.Position{
								Column: 9,
								Line:   214,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "offset",
								Start: ast.Position{
									Column: 9,
									Line:   214,
								},
							},
						},
						Name: "offset",
					},
					Separator: nil,
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "0s",
								Start: ast.Position{
									Column: 16,
									Line:   214,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(0),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   215,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 9,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   215,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   215,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   215,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 16,
									Line:   215,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   216,
							},
							File:   "universe.flux",
							Source: "timeSrc=\"_stop\"",
							Start: ast.Position{
								Column: 9,
								Line:   216,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   216,
								},
								File:   "universe.flux",
								Source: "timeSrc",
								Start: ast.Position{
									Column: 9,
									Line:   216,
								},
							},
						},
						Name: "timeSrc",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   216,
								},
								File:   "universe.flux",
								Source: "\"_stop\"",
								Start: ast.Position{
									Column: 17,
									Line:   216,
								},
							},
						},
						Value: "_stop",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "timeDst=\"_time\"",
							Start: ast.Position{
								Column: 9,
								Line:   217,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "timeDst",
								Start: ast.Position{
									Column: 9,
									Line:   217,
								},
							},
						},
						Name: "timeDst",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 17,
									Line:   217,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   218,
							},
							File:   "universe.flux",
							Source: "createEmpty=true",
							Start: ast.Position{
								Column: 9,
								Line:   218,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   218,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 9,
									Line:   218,
								},
							},
						},
						Name: "createEmpty",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   218,
								},
								File:   "universe.flux",
								Source: "true",
								Start: ast.Position{
									Column: 21,
									Line:   218,
								},
							},
						},
						Name: "true",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   219,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   219,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   219,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   232,
					},
					File:   "universe.flux",
					Source: "increase = (tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
					Start: ast.Position{
						Column: 1,
						Line:   230,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Increase returns the total non-negative difference between values in a table.\n"}, ast.Comment{Text: "// A main usage case is tracking changes in counter values which may wrap over time when they hit\n"}, ast.Comment{Text: "// a threshold or are reset. In the case of a wrap/reset,\n"}, ast.Comment{Text: "// we can assume that the absolute delta between two points will be at least their non-negative difference.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   230,
						},
						File:   "universe.flux",
						Source: "increase",
						Start: ast.Position{
							Column: 1,
							Line:   230,
						},
					},
				},
				Name: "increase",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   232,
						},
						File:   "universe.flux",
						Source: "(tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
						Start: ast.Position{
							Column: 12,
							Line:   230,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   230,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 47,
										Line:   230,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   231,
								},
								File:   "universe.flux",
								Source: "tables\n    |> difference(nonNegative: true, columns: columns)",
								Start: ast.Position{
									Column: 47,
									Line:   230,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   231,
										},
										File:   "universe.flux",
										Source: "nonNegative: true, columns: columns",
										Start: ast.Position{
											Column: 19,
											Line:   231,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   231,
											},
											File:   "universe.flux",
											Source: "nonNegative: true",
											Start: ast.Position{
												Column: 19,
												Line:   231,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   231,
												},
												File:   "universe.flux",
												Source: "nonNegative",
												Start: ast.Position{
													Column: 19,
													Line:   231,
												},
											},
										},
										Name: "nonNegative",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   231,
												},
												File:   "universe.flux",
												Source: "true",
												Start: ast.Position{
													Column: 32,
													Line:   231,
												},
											},
										},
										Name: "true",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   231,
											},
											File:   "universe.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 38,
												Line:   231,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   231,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 38,
													Line:   231,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   231,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   231,
												},
											},
										},
										Name: "columns",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   231,
									},
									File:   "universe.flux",
									Source: "difference(nonNegative: true, columns: columns)",
									Start: ast.Position{
										Column: 8,
										Line:   231,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   231,
										},
										File:   "universe.flux",
										Source: "difference",
										Start: ast.Position{
											Column: 8,
											Line:   231,
										},
									},
								},
								Name: "difference",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   232,
							},
							File:   "universe.flux",
							Source: "tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
							Start: ast.Position{
								Column: 47,
								Line:   230,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   232,
									},
									File:   "universe.flux",
									Source: "columns: columns",
									Start: ast.Position{
										Column: 22,
										Line:   232,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   232,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 22,
											Line:   232,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   232,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 22,
												Line:   232,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   232,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 31,
												Line:   232,
											},
										},
									},
									Name: "columns",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   232,
								},
								File:   "universe.flux",
								Source: "cumulativeSum(columns: columns)",
								Start: ast.Position{
									Column: 8,
									Line:   232,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   232,
									},
									File:   "universe.flux",
									Source: "cumulativeSum",
									Start: ast.Position{
										Column: 8,
										Line:   232,
									},
								},
							},
							Name: "cumulativeSum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   230,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   230,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   230,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   230,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   230,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   230,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   230,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   230,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   236,
					},
					File:   "universe.flux",
					Source: "median = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
					Start: ast.Position{
						Column: 1,
						Line:   235,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// median returns the 50th percentile.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   235,
						},
						File:   "universe.flux",
						Source: "median",
						Start: ast.Position{
							Column: 1,
							Line:   235,
						},
					},
				},
				Name: "median",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   236,
						},
						File:   "universe.flux",
						Source: "(method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
						Start: ast.Position{
							Column: 10,
							Line:   235,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 86,
									Line:   235,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   236,
							},
							File:   "universe.flux",
							Source: "tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
							Start: ast.Position{
								Column: 86,
								Line:   235,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   236,
									},
									File:   "universe.flux",
									Source: "q: 0.5, method: method, compression: compression, column: column",
									Start: ast.Position{
										Column: 17,
										Line:   236,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   236,
										},
										File:   "universe.flux",
										Source: "q: 0.5",
										Start: ast.Position{
											Column: 17,
											Line:   236,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "q",
											Start: ast.Position{
												Column: 17,
												Line:   236,
											},
										},
									},
									Name: "q",
								},
								Separator: nil,
								Value: &ast.FloatLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "0.5",
											Start: ast.Position{
												Column: 20,
												Line:   236,
											},
										},
									},
									Value: 0.5,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   236,
										},
										File:   "universe.flux",
										Source: "method: method",
										Start: ast.Position{
											Column: 25,
											Line:   236,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 25,
												Line:   236,
											},
										},
									},
									Name: "method",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 33,
												Line:   236,
											},
										},
									},
									Name: "method",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   236,
										},
										File:   "universe.flux",
										Source: "compression: compression",
										Start: ast.Position{
											Column: 41,
											Line:   236,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 41,
												Line:   236,
											},
										},
									},
									Name: "compression",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 54,
												Line:   236,
											},
										},
									},
									Name: "compression",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   236,
										},
										File:   "universe.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 67,
											Line:   236,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 67,
												Line:   236,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 75,
												Line:   236,
											},
										},
									},
									Name: "column",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "quantile(q: 0.5, method: method, compression: compression, column: column)",
								Start: ast.Position{
									Column: 8,
									Line:   236,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   236,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 8,
										Line:   236,
									},
								},
							},
							Name: "quantile",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   235,
							},
							File:   "universe.flux",
							Source: "method=\"estimate_tdigest\"",
							Start: ast.Position{
								Column: 11,
								Line:   235,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "method",
								Start: ast.Position{
									Column: 11,
									Line:   235,
								},
							},
						},
						Name: "method",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "\"estimate_tdigest\"",
								Start: ast.Position{
									Column: 18,
									Line:   235,
								},
							},
						},
						Value: "estimate_tdigest",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   235,
							},
							File:   "universe.flux",
							Source: "compression=0.0",
							Start: ast.Position{
								Column: 38,
								Line:   235,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "compression",
								Start: ast.Position{
									Column: 38,
									Line:   235,
								},
							},
						},
						Name: "compression",
					},
					Separator: nil,
					Value: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 50,
									Line:   235,
								},
							},
						},
						Value: 0.0,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   235,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 55,
								Line:   235,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 55,
									Line:   235,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 62,
									Line:   235,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   235,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 72,
								Line:   235,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   235,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 72,
									Line:   235,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   235,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 79,
								Line:   235,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   248,
					},
					File:   "universe.flux",
					Source: "stateCount = (fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)",
					Start: ast.Position{
						Column: 1,
						Line:   247,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateCount computes the number of consecutive records in a given state.\n"}, ast.Comment{Text: "// The state is defined via the function fn. For each consecutive point for\n"}, ast.Comment{Text: "// which the expression evaluates as true, the state count will be incremented\n"}, ast.Comment{Text: "// When a point evaluates as false, the state count is reset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The state count will be added as an additional column to each record. If the\n"}, ast.Comment{Text: "// expression evaluates as false, the value will be -1. If the expression\n"}, ast.Comment{Text: "// generates an error during evaluation, the point is discarded, and does not\n"}, ast.Comment{Text: "// affect the state count.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   247,
						},
						File:   "universe.flux",
						Source: "stateCount",
						Start: ast.Position{
							Column: 1,
							Line:   247,
						},
					},
				},
				Name: "stateCount",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   248,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)",
						Start: ast.Position{
							Column: 14,
							Line:   247,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 54,
									Line:   247,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "tables\n    |> stateTracking(countColumn: column, fn: fn)",
							Start: ast.Position{
								Column: 54,
								Line:   247,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   248,
									},
									File:   "universe.flux",
									Source: "countColumn: column, fn: fn",
									Start: ast.Position{
										Column: 22,
										Line:   248,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   248,
										},
										File:   "universe.flux",
										Source: "countColumn: column",
										Start: ast.Position{
											Column: 22,
											Line:   248,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "countColumn",
											Start: ast.Position{
												Column: 22,
												Line:   248,
											},
										},
									},
									Name: "countColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 35,
												Line:   248,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   248,
										},
										File:   "universe.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 43,
											Line:   248,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   248,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 47,
												Line:   248,
											},
										},
									},
									Name: "fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "stateTracking(countColumn: column, fn: fn)",
								Start: ast.Position{
									Column: 8,
									Line:   248,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   248,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 8,
										Line:   248,
									},
								},
							},
							Name: "stateTracking",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 15,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 15,
									Line:   247,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "column=\"stateCount\"",
							Start: ast.Position{
								Column: 19,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 19,
									Line:   247,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "\"stateCount\"",
								Start: ast.Position{
									Column: 26,
									Line:   247,
								},
							},
						},
						Value: "stateCount",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 40,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 40,
									Line:   247,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 47,
								Line:   247,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 97,
						Line:   272,
					},
					File:   "universe.flux",
					Source: "stateDuration = (\n        fn,\n        column=\"stateDuration\",\n        timeColumn=\"_time\",\n        unit=1s,\n        tables=<-,\n) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
					Start: ast.Position{
						Column: 1,
						Line:   265,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateDuration computes the duration of a given state.\n"}, ast.Comment{Text: "// The state is defined via the function fn. For each consecutive point for\n"}, ast.Comment{Text: "// which the expression evaluates as true, the state duration will be\n"}, ast.Comment{Text: "// incremented by the duration between points. When a point evaluates as false,\n"}, ast.Comment{Text: "// the state duration is reset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The state duration will be added as an additional column to each record. If the\n"}, ast.Comment{Text: "// expression evaluates as false, the value will be -1. If the expression\n"}, ast.Comment{Text: "// generates an error during evaluation, the point is discarded, and does not\n"}, ast.Comment{Text: "// affect the state duration.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Note that as the first point in the given state has no previous point, its\n"}, ast.Comment{Text: "// state duration will be 0.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The duration is represented as an integer in the units specified.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   265,
						},
						File:   "universe.flux",
						Source: "stateDuration",
						Start: ast.Position{
							Column: 1,
							Line:   265,
						},
					},
				},
				Name: "stateDuration",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   272,
						},
						File:   "universe.flux",
						Source: "(\n        fn,\n        column=\"stateDuration\",\n        timeColumn=\"_time\",\n        unit=1s,\n        tables=<-,\n) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
						Start: ast.Position{
							Column: 17,
							Line:   265,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   271,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 6,
									Line:   271,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   272,
							},
							File:   "universe.flux",
							Source: "tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
							Start: ast.Position{
								Column: 6,
								Line:   271,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   272,
									},
									File:   "universe.flux",
									Source: "durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit",
									Start: ast.Position{
										Column: 22,
										Line:   272,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   272,
										},
										File:   "universe.flux",
										Source: "durationColumn: column",
										Start: ast.Position{
											Column: 22,
											Line:   272,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "durationColumn",
											Start: ast.Position{
												Column: 22,
												Line:   272,
											},
										},
									},
									Name: "durationColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   272,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   272,
										},
										File:   "universe.flux",
										Source: "timeColumn: timeColumn",
										Start: ast.Position{
											Column: 46,
											Line:   272,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 46,
												Line:   272,
											},
										},
									},
									Name: "timeColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 58,
												Line:   272,
											},
										},
									},
									Name: "timeColumn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   272,
										},
										File:   "universe.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 70,
											Line:   272,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 70,
												Line:   272,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 74,
												Line:   272,
											},
										},
									},
									Name: "fn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   272,
										},
										File:   "universe.flux",
										Source: "durationUnit: unit",
										Start: ast.Position{
											Column: 78,
											Line:   272,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "durationUnit",
											Start: ast.Position{
												Column: 78,
												Line:   272,
											},
										},
									},
									Name: "durationUnit",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   272,
											},
											File:   "universe.flux",
											Source: "unit",
											Start: ast.Position{
												Column: 92,
												Line:   272,
											},
										},
									},
									Name: "unit",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   272,
								},
								File:   "universe.flux",
								Source: "stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
								Start: ast.Position{
									Column: 8,
									Line:   272,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   272,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 8,
										Line:   272,
									},
								},
							},
							Name: "stateTracking",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 9,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 9,
									Line:   266,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   267,
							},
							File:   "universe.flux",
							Source: "column=\"stateDuration\"",
							Start: ast.Position{
								Column: 9,
								Line:   267,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   267,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   267,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   267,
								},
								File:   "universe.flux",
								Source: "\"stateDuration\"",
								Start: ast.Position{
									Column: 16,
									Line:   267,
								},
							},
						},
						Value: "stateDuration",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   268,
							},
							File:   "universe.flux",
							Source: "timeColumn=\"_time\"",
							Start: ast.Position{
								Column: 9,
								Line:   268,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   268,
								},
								File:   "universe.flux",
								Source: "timeColumn",
								Start: ast.Position{
									Column: 9,
									Line:   268,
								},
							},
						},
						Name: "timeColumn",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   268,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 20,
									Line:   268,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   269,
							},
							File:   "universe.flux",
							Source: "unit=1s",
							Start: ast.Position{
								Column: 9,
								Line:   269,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   269,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 9,
									Line:   269,
								},
							},
						},
						Name: "unit",
					},
					Separator: nil,
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   269,
								},
								File:   "universe.flux",
								Source: "1s",
								Start: ast.Position{
									Column: 14,
									Line:   269,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(1),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   270,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   270,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   270,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   270,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   270,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   270,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   277,
					},
					File:   "universe.flux",
					Source: "_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
					Start: ast.Position{
						Column: 1,
						Line:   275,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _sortLimit is a helper function, which sorts and limits a table.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   275,
						},
						File:   "universe.flux",
						Source: "_sortLimit",
						Start: ast.Position{
							Column: 1,
							Line:   275,
						},
					},
				},
				Name: "_sortLimit",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   277,
						},
						File:   "universe.flux",
						Source: "(n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
						Start: ast.Position{
							Column: 14,
							Line:   275,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   275,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 58,
										Line:   275,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   276,
								},
								File:   "universe.flux",
								Source: "tables\n    |> sort(columns: columns, desc: desc)",
								Start: ast.Position{
									Column: 58,
									Line:   275,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   276,
										},
										File:   "universe.flux",
										Source: "columns: columns, desc: desc",
										Start: ast.Position{
											Column: 13,
											Line:   276,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   276,
											},
											File:   "universe.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 13,
												Line:   276,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   276,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   276,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   276,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 22,
													Line:   276,
												},
											},
										},
										Name: "columns",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   276,
											},
											File:   "universe.flux",
											Source: "desc: desc",
											Start: ast.Position{
												Column: 31,
												Line:   276,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   276,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 31,
													Line:   276,
												},
											},
										},
										Name: "desc",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   276,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 37,
													Line:   276,
												},
											},
										},
										Name: "desc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   276,
									},
									File:   "universe.flux",
									Source: "sort(columns: columns, desc: desc)",
									Start: ast.Position{
										Column: 8,
										Line:   276,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   276,
										},
										File:   "universe.flux",
										Source: "sort",
										Start: ast.Position{
											Column: 8,
											Line:   276,
										},
									},
								},
								Name: "sort",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   277,
							},
							File:   "universe.flux",
							Source: "tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
							Start: ast.Position{
								Column: 58,
								Line:   275,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   277,
									},
									File:   "universe.flux",
									Source: "n: n",
									Start: ast.Position{
										Column: 14,
										Line:   277,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   277,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 14,
											Line:   277,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   277,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 14,
												Line:   277,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   277,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   277,
											},
										},
									},
									Name: "n",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   277,
								},
								File:   "universe.flux",
								Source: "limit(n: n)",
								Start: ast.Position{
									Column: 8,
									Line:   277,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   277,
									},
									File:   "universe.flux",
									Source: "limit",
									Start: ast.Position{
										Column: 8,
										Line:   277,
									},
								},
							},
							Name: "limit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   275,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   275,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   275,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   275,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   275,
							},
							File:   "universe.flux",
							Source: "desc",
							Start: ast.Position{
								Column: 18,
								Line:   275,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   275,
								},
								File:   "universe.flux",
								Source: "desc",
								Start: ast.Position{
									Column: 18,
									Line:   275,
								},
							},
						},
						Name: "desc",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   275,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   275,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   275,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   275,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   275,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   275,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   275,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   275,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   275,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 44,
								Line:   275,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   275,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 44,
									Line:   275,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   275,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 51,
								Line:   275,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 54,
						Line:   281,
					},
					File:   "universe.flux",
					Source: "top = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
					Start: ast.Position{
						Column: 1,
						Line:   280,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// top sorts a table by columns and keeps only the top n records.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   280,
						},
						File:   "universe.flux",
						Source: "top",
						Start: ast.Position{
							Column: 1,
							Line:   280,
						},
					},
				},
				Name: "top",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   281,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
						Start: ast.Position{
							Column: 7,
							Line:   280,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   280,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 45,
									Line:   280,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   281,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
							Start: ast.Position{
								Column: 45,
								Line:   280,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   281,
									},
									File:   "universe.flux",
									Source: "n: n, columns: columns, desc: true",
									Start: ast.Position{
										Column: 19,
										Line:   281,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   281,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   281,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   281,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   281,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   281,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   281,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   281,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 25,
											Line:   281,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   281,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   281,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   281,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 34,
												Line:   281,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   281,
										},
										File:   "universe.flux",
										Source: "desc: true",
										Start: ast.Position{
											Column: 43,
											Line:   281,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   281,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 43,
												Line:   281,
											},
										},
									},
									Name: "desc",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   281,
											},
											File:   "universe.flux",
											Source: "true",
											Start: ast.Position{
												Column: 49,
												Line:   281,
											},
										},
									},
									Name: "true",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   281,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: columns, desc: true)",
								Start: ast.Position{
									Column: 8,
									Line:   281,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   281,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   281,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   280,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 8,
								Line:   280,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   280,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 8,
									Line:   280,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   280,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 11,
								Line:   280,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   280,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 11,
									Line:   280,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   280,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 19,
									Line:   280,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   280,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 20,
										Line:   280,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   280,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 31,
								Line:   280,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   280,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 31,
									Line:   280,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   280,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   280,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 55,
						Line:   285,
					},
					File:   "universe.flux",
					Source: "bottom = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
					Start: ast.Position{
						Column: 1,
						Line:   284,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// top sorts a table by columns and keeps only the bottom n records.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   284,
						},
						File:   "universe.flux",
						Source: "bottom",
						Start: ast.Position{
							Column: 1,
							Line:   284,
						},
					},
				},
				Name: "bottom",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   285,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
						Start: ast.Position{
							Column: 10,
							Line:   284,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   284,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 48,
									Line:   284,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   285,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
							Start: ast.Position{
								Column: 48,
								Line:   284,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   285,
									},
									File:   "universe.flux",
									Source: "n: n, columns: columns, desc: false",
									Start: ast.Position{
										Column: 19,
										Line:   285,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   285,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   285,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   285,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   285,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   285,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   285,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   285,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 25,
											Line:   285,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   285,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   285,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   285,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 34,
												Line:   285,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   285,
										},
										File:   "universe.flux",
										Source: "desc: false",
										Start: ast.Position{
											Column: 43,
											Line:   285,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   285,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 43,
												Line:   285,
											},
										},
									},
									Name: "desc",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   285,
											},
											File:   "universe.flux",
											Source: "false",
											Start: ast.Position{
												Column: 49,
												Line:   285,
											},
										},
									},
									Name: "false",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   285,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: columns, desc: false)",
								Start: ast.Position{
									Column: 8,
									Line:   285,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   285,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   285,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   284,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 11,
								Line:   284,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   284,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 11,
									Line:   284,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   284,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 14,
								Line:   284,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   284,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 14,
									Line:   284,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   284,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 22,
									Line:   284,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   284,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 23,
										Line:   284,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   284,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 34,
								Line:   284,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   284,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 34,
									Line:   284,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   284,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   284,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   301,
					},
					File:   "universe.flux",
					Source: "_highestOrLowest = (\n        n,\n        _sortLimit,\n        reducer,\n        column=\"_value\",\n        groupColumns=[],\n        tables=<-,\n) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
					Start: ast.Position{
						Column: 1,
						Line:   290,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n"}, ast.Comment{Text: "// then it selects the highest or lowest records based on the column and the _sortLimit function.\n"}, ast.Comment{Text: "// The default reducer assumes no reducing needs to be performed.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   290,
						},
						File:   "universe.flux",
						Source: "_highestOrLowest",
						Start: ast.Position{
							Column: 1,
							Line:   290,
						},
					},
				},
				Name: "_highestOrLowest",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   301,
						},
						File:   "universe.flux",
						Source: "(\n        n,\n        _sortLimit,\n        reducer,\n        column=\"_value\",\n        groupColumns=[],\n        tables=<-,\n) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
						Start: ast.Position{
							Column: 20,
							Line:   290,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   297,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 6,
												Line:   297,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   298,
										},
										File:   "universe.flux",
										Source: "tables\n    |> group(columns: groupColumns)",
										Start: ast.Position{
											Column: 6,
											Line:   297,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   298,
												},
												File:   "universe.flux",
												Source: "columns: groupColumns",
												Start: ast.Position{
													Column: 14,
													Line:   298,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   298,
													},
													File:   "universe.flux",
													Source: "columns: groupColumns",
													Start: ast.Position{
														Column: 14,
														Line:   298,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   298,
														},
														File:   "universe.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 14,
															Line:   298,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   298,
														},
														File:   "universe.flux",
														Source: "groupColumns",
														Start: ast.Position{
															Column: 23,
															Line:   298,
														},
													},
												},
												Name: "groupColumns",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   298,
											},
											File:   "universe.flux",
											Source: "group(columns: groupColumns)",
											Start: ast.Position{
												Column: 8,
												Line:   298,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   298,
												},
												File:   "universe.flux",
												Source: "group",
												Start: ast.Position{
													Column: 8,
													Line:   298,
												},
											},
										},
										Name: "group",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   299,
									},
									File:   "universe.flux",
									Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()",
									Start: ast.Position{
										Column: 6,
										Line:   297,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   299,
										},
										File:   "universe.flux",
										Source: "reducer()",
										Start: ast.Position{
											Column: 8,
											Line:   299,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   299,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 8,
												Line:   299,
											},
										},
									},
									Name: "reducer",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   300,
								},
								File:   "universe.flux",
								Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])",
								Start: ast.Position{
									Column: 6,
									Line:   297,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   300,
										},
										File:   "universe.flux",
										Source: "columns: []",
										Start: ast.Position{
											Column: 14,
											Line:   300,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   300,
											},
											File:   "universe.flux",
											Source: "columns: []",
											Start: ast.Position{
												Column: 14,
												Line:   300,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   300,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   300,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   300,
												},
												File:   "universe.flux",
												Source: "[]",
												Start: ast.Position{
													Column: 23,
													Line:   300,
												},
											},
										},
										Elements: []ast.Expression{},
										Lbrack:   nil,
										Rbrack:   nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   300,
									},
									File:   "universe.flux",
									Source: "group(columns: [])",
									Start: ast.Position{
										Column: 8,
										Line:   300,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   300,
										},
										File:   "universe.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   300,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   301,
							},
							File:   "universe.flux",
							Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
							Start: ast.Position{
								Column: 6,
								Line:   297,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   301,
									},
									File:   "universe.flux",
									Source: "n: n, columns: [column]",
									Start: ast.Position{
										Column: 19,
										Line:   301,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   301,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   301,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   301,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   301,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   301,
										},
										File:   "universe.flux",
										Source: "columns: [column]",
										Start: ast.Position{
											Column: 25,
											Line:   301,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   301,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "[column]",
											Start: ast.Position{
												Column: 34,
												Line:   301,
											},
										},
									},
									Elements: []ast.Expression{&ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   301,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 35,
													Line:   301,
												},
											},
										},
										Name: "column",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   301,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: [column])",
								Start: ast.Position{
									Column: 8,
									Line:   301,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   301,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   301,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   291,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 9,
								Line:   291,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   291,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 9,
									Line:   291,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   292,
							},
							File:   "universe.flux",
							Source: "_sortLimit",
							Start: ast.Position{
								Column: 9,
								Line:   292,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   292,
								},
								File:   "universe.flux",
								Source: "_sortLimit",
								Start: ast.Position{
									Column: 9,
									Line:   292,
								},
							},
						},
						Name: "_sortLimit",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   293,
							},
							File:   "universe.flux",
							Source: "reducer",
							Start: ast.Position{
								Column: 9,
								Line:   293,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   293,
								},
								File:   "universe.flux",
								Source: "reducer",
								Start: ast.Position{
									Column: 9,
									Line:   293,
								},
							},
						},
						Name: "reducer",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   294,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 9,
								Line:   294,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   294,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   294,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   294,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 16,
									Line:   294,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   295,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 9,
								Line:   295,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   295,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 9,
									Line:   295,
								},
							},
						},
						Name: "groupColumns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   295,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 22,
									Line:   295,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   296,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   296,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   296,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   296,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   296,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   296,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   312,
					},
					File:   "universe.flux",
					Source: "highestMax = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   304,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// highestMax returns the top N records from all groups using the maximum of each group.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   304,
						},
						File:   "universe.flux",
						Source: "highestMax",
						Start: ast.Position{
							Column: 1,
							Line:   304,
						},
					},
				},
				Name: "highestMax",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   312,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
						Start: ast.Position{
							Column: 14,
							Line:   304,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   304,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 66,
									Line:   304,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   312,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
							Start: ast.Position{
								Column: 66,
								Line:   304,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   311,
									},
									File:   "universe.flux",
									Source: "n: n,\n        column: column,\n        groupColumns: groupColumns,