+++
title = "Fine-grained access control references"
description = "Refer to fine-grained access control references"
keywords = ["grafana", "fine-grained-access-control", "roles", "fixed-roles", "built-in-role-assignments", "permissions", "enterprise"]
weight = 130
+++

# Fine-grained access control references

The reference information that follows complements conceptual information about [Roles]({{< relref "./roles.md" >}}).

## Fine-grained access fixed roles

| Fixed roles                            | Permissions                                                                                                                                                                                                                                                              | Descriptions                                                                                                                                                                                                                                                                          |
| -------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `fixed:roles:reader`                   | `roles:read`<br>`roles:list`<br>`users.roles:list`<br>`users.permissions:list`<br>`roles.builtin:list`                                                                                                                                                                   | Read all access control roles, roles and permissions assigned to users and built-in role assignments.                                                                                                                                                                                 |
| `fixed:roles:writer`                   | All permissions from `fixed:roles:reader` and <br>`roles:write`<br>`roles:delete`<br>`users.roles:add`<br>`users.roles:remove`<br>`roles.builtin:add`<br>`roles.builtin:remove`                                                                                          | Create, read, update, or delete all roles, assign or unassign roles to users and built-in role assignments.                                                                                                                                                                           |
| `fixed:reports:reader`                 | `reports:read`<br>`reports:send`<br>`reports.settings:read`                                                                                                                                                                                                              | Read all reports and shared report settings.                                                                                                                                                                                                                                          |
| `fixed:reports:writer`                 | All permissions from `fixed:reports:reader` and <br>`reports.admin:write`<br>`reports:delete`<br>`reports.settings:write`                                                                                                                                                | Create, read, update, or delete all reports and shared report settings.                                                                                                                                                                                                               |
| `fixed:users:reader`                   | `users:read`<br>`users.quotas:list`<br>`users.authtoken:list`<br>`users.teams:read`                                                                                                                                                                                      | Read all users and their information, such as team memberships, authentication tokens, and quotas.                                                                                                                                                                                    |
| `fixed:users:writer`                   | All permissions from `fixed:users:reader` and <br>`users:write`<br>`users:create`<br>`users:delete`<br>`users:enable`<br>`users:disable`<br>`users.password:update`<br>`users.permissions:update`<br>`users:logout`<br>`users.authtoken:update`<br>`users.quotas:update` | Read and update all attributes and settings for all users in Grafana: update user information, read user information, create or enable or disable a user, make a user a Grafana administrator, sign out a user, update a user’s authentication token, or update quotas for all users. |
| `fixed:org.users:reader`               | `org.users:read`                                                                                                                                                                                                                                                         | Read users within a single organization.                                                                                                                                                                                                                                              |
| `fixed:org.users:writer`               | All permissions from `fixed:org.users:reader` and <br>`org.users:add`<br>`org.users:remove`<br>`org.users.role:update`                                                                                                                                                   | Within a single organization, add a user, invite a user, read information about a user and their role, remove a user from that organization, or change the role of a user.                                                                                                            |
| `fixed:ldap:reader`                    | `ldap.user:read`<br>`ldap.status:read`                                                                                                                                                                                                                                   | Read the LDAP configuration and LDAP status information.                                                                                                                                                                                                                              |
| `fixed:ldap:writer`                    | All permissions from `fixed:ldap:reader` and <br>`ldap.user:sync`<br>`ldap.config:reload`                                                                                                                                                                                | Read and update the LDAP configuration, and read LDAP status information.                                                                                                                                                                                                             |
| `fixed:stats:reader`                   | `server.stats:read`                                                                                                                                                                                                                                                      | Read Grafana instance statistics.                                                                                                                                                                                                                                                     |
| `fixed:settings:reader`                | `settings:read`                                                                                                                                                                                                                                                          | Read Grafana instance settings.                                                                                                                                                                                                                                                       |
| `fixed:settings:writer`                | All permissions from `fixed:settings:reader` and<br>`settings:write`                                                                                                                                                                                                     | Read and update Grafana instance settings.                                                                                                                                                                                                                                            |
| `fixed:datasources:explorer`           | `datasources:explore`                                                                                                                                                                                                                                                    | Enable the Explore feature. Data source permissions still apply, you can only query data sources for which you have query permissions.                                                                                                                                                |
| `fixed:datasources:reader`             | `datasources:read`<br>`datasources:query`                                                                                                                                                                                                                                | Read and query data sources.                                                                                                                                                                                                                                                          |
| `fixed:datasources:writer`             | All permissions from `fixed:datasources:reader` and <br>`datasources:create`<br>`datasources:write`<br>`datasources:delete`                                                                                                                                              | Read, query, create, delete, or update a data source.                                                                                                                                                                                                                                 |
| `fixed:datasources:id:reader`          | `datasources.id:read`                                                                                                                                                                                                                                                    | Read the ID of a data source based on its name.                                                                                                                                                                                                                                       |
| `fixed:datasources.permissions:reader` | `datasources.permissions:read`                                                                                                                                                                                                                                           | Read data source permissions.                                                                                                                                                                                                                                                         |
| `fixed:datasources.permissions:writer` | All permissions from `fixed:datasources.permissions:reader` and <br>`datasources.permissions:create`<br>`datasources.permissions:delete`<br>`datasources.permissions:toggle`                                                                                             | Create, read, or delete permissions of a data source.                                                                                                                                                                                                                                 |
| `fixed:licensing:reader`               | `licensing:read`<br>`licensing.reports:read`                                                                                                                                                                                                                             | Read licensing information and licensing reports.                                                                                                                                                                                                                                     |
| `fixed:licensing:writer`               | All permissions from `fixed:licensing:viewer` and <br>`licensing:update`<br>`licensing:delete`                                                                                                                                                                           | Read licensing information and licensing reports, update and delete the license token.                                                                                                                                                                                                |
| `fixed:provisioning:writer`            | `provisioning:reload`                                                                                                                                                                                                                                                    | Reload provisioning.                                                                                                                                                                                                                                                                  |
| `fixed:organization:reader`            | `orgs:read`<br>`orgs.quotas:read`                                                                                                                                                                                                                                        | Read an organization and its quotas.                                                                                                                                                                                                                                                  |
| `fixed:organization:writer`            | All permissions from `fixed:organization:reader` and <br> `orgs:write`<br>`orgs.preferences:read`<br>`orgs.preferences:write`                                                                                                                                            | Read an organization, its quotas, or its preferences. Update organization properties, or its preferences.                                                                                                                                                                             |
| `fixed:organization:maintainer`        | All permissions from `fixed:organization:reader` and <br> `orgs:write`<br>`orgs:create`<br>`orgs:delete`<br>`orgs.quotas:write`                                                                                                                                          | Create, read, write, or delete an organization. Read or write its quotas. This role needs to be assigned globally.                                                                                                                                                                    |
|                                        |

## Default built-in role assignments

| Built-in role | Associated role                                                                                                                                                                                                                                                                                                                                                                                                                           | Description                                                                                                                 |
| ------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------- |
| Grafana Admin | `fixed:roles:reader`<br>`fixed:roles:writer`<br>`fixed:users:reader`<br>`fixed:users:writer`<br>`fixed:org.users:reader`<br>`fixed:org.users:writer`<br>`fixed:ldap:reader`<br>`fixed:ldap:writer`<br>`fixed:stats:reader`<br>`fixed:settings:reader`<br>`fixed:settings:writer`<br>`fixed:provisioning:writer`<br>`fixed:organization:reader`<br>`fixed:organization:maintainer`<br>`fixed:licensing:reader`<br>`fixed:licensing:writer` | Default [Grafana server administrator]({{< relref "../../permissions/_index.md#grafana-server-admin-role" >}}) assignments. |
| Admin         | `fixed:reports:reader`<br>`fixed:reports:writer`<br>`fixed:datasources:reader`<br>`fixed:datasources:writer`<br>`fixed:organization:writer`<br>`fixed:datasources.permissions:reader`<br>`fixed:datasources.permissions:writer`<br>                                                                                                                                                                                                       | Default [Grafana organization administrator]({{< relref "../../permissions/organization_roles.md" >}}) assignments.         |
| Editor        | `fixed:datasources:explorer`                                                                                                                                                                                                                                                                                                                                                                                                              | Default [Editor]({{< relref "../../permissions/organization_roles.md" >}}) assignments.                                     |
| Viewer        | `fixed:datasources:id:reader`<br>`fixed:organization:reader`                                                                                                                                                                                                                                                                                                                                                                              | Default [Viewer]({{< relref "../../permissions/organization_roles.md" >}}) assignments.                                     |
