// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire gen -tags "oss"
//go:build !wireinject
// +build !wireinject

package runner

import (
	"context"
	"github.com/google/wire"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/bus"
	"github.com/grafana/grafana/pkg/infra/localcache"
	"github.com/grafana/grafana/pkg/infra/usagestats"
	"github.com/grafana/grafana/pkg/services/encryption/ossencryption"
	"github.com/grafana/grafana/pkg/services/kmsproviders/osskmsproviders"
	"github.com/grafana/grafana/pkg/services/secrets"
	"github.com/grafana/grafana/pkg/services/secrets/database"
	"github.com/grafana/grafana/pkg/services/secrets/manager"
	"github.com/grafana/grafana/pkg/services/sqlstore"
	"github.com/grafana/grafana/pkg/services/sqlstore/migrations"
	"github.com/grafana/grafana/pkg/setting"
	"github.com/grafana/grafana/pkg/web"
)

// Injectors from wire.go:

func Initialize(cfg *setting.Cfg) (Runner, error) {
	cacheService := localcache.ProvideService()
	inProcBus := bus.ProvideBus()
	ossMigrations := migrations.ProvideOSSMigrations()
	sqlStore, err := sqlstore.ProvideService(cfg, cacheService, inProcBus, ossMigrations)
	if err != nil {
		return Runner{}, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	service := ossencryption.ProvideService()
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	osskmsprovidersService := osskmsproviders.ProvideService(service, ossImpl)
	usagestatsService := _wireNoOpUsageStatsValue
	secretsService, err := manager.ProvideSecretsService(secretsStoreImpl, osskmsprovidersService, service, ossImpl, usagestatsService)
	if err != nil {
		return Runner{}, err
	}
	runner := New(cfg, sqlStore, ossImpl, service, secretsService)
	return runner, nil
}

var (
	_wireNoOpUsageStatsValue = noOpUsageStats{}
)

// wire.go:

var wireSet = wire.NewSet(
	New, localcache.ProvideService, bus.ProvideBus, wire.Bind(new(bus.Bus), new(*bus.InProcBus)), sqlstore.ProvideService, wire.InterfaceValue(new(usagestats.Service), noOpUsageStats{}), wire.InterfaceValue(new(routing.RouteRegister), noOpRouteRegister{}), database.ProvideSecretsStore, wire.Bind(new(secrets.Store), new(*database.SecretsStoreImpl)), manager.ProvideSecretsService, wire.Bind(new(secrets.Service), new(*manager.SecretsService)),
)

type noOpUsageStats struct{}

func (noOpUsageStats) GetUsageReport(context.Context) (usagestats.Report, error) {
	return usagestats.Report{}, nil
}

func (noOpUsageStats) RegisterMetricsFunc(_ usagestats.MetricsFunc) {}

func (noOpUsageStats) RegisterSendReportCallback(_ usagestats.SendReportCallbackFunc) {}

func (noOpUsageStats) ShouldBeReported(string) bool { return false }

type noOpRouteRegister struct{}

func (noOpRouteRegister) Get(string, ...web.Handler) {}

func (noOpRouteRegister) Post(string, ...web.Handler) {}

func (noOpRouteRegister) Delete(string, ...web.Handler) {}

func (noOpRouteRegister) Put(string, ...web.Handler) {}

func (noOpRouteRegister) Patch(string, ...web.Handler) {}

func (noOpRouteRegister) Any(string, ...web.Handler) {}

func (noOpRouteRegister) Group(string, func(routing.RouteRegister), ...web.Handler) {}

func (noOpRouteRegister) Insert(string, func(routing.RouteRegister), ...web.Handler) {}

func (noOpRouteRegister) Register(routing.Router) {}

func (noOpRouteRegister) Reset() {}
