// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateWebACL = "AssociateWebACL"

// AssociateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWebACL for more information on using the AssociateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWebACLRequest method.
//    req, resp := client.AssociateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL
func (c *WAFV2) AssociateWebACLRequest(input *AssociateWebACLInput) (req *request.Request, output *AssociateWebACLOutput) {
	op := &request.Operation{
		Name:       opAssociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateWebACLInput{}
	}

	output = &AssociateWebACLOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateWebACL API operation for AWS WAFV2.
//
// Associates a web ACL with a regional application resource, to protect the
// resource. A regional application can be an Application Load Balancer (ALB),
// an Amazon API Gateway REST API, or an AppSync GraphQL API.
//
// For Amazon CloudFront, don't use this call. Instead, use your CloudFront
// distribution configuration. To associate a web ACL, in the CloudFront call
// UpdateDistribution, set the web ACL ID to the Amazon Resource Name (ARN)
// of the web ACL. For information, see UpdateDistribution (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation AssociateWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL
func (c *WAFV2) AssociateWebACL(input *AssociateWebACLInput) (*AssociateWebACLOutput, error) {
	req, out := c.AssociateWebACLRequest(input)
	return out, req.Send()
}

// AssociateWebACLWithContext is the same as AssociateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) AssociateWebACLWithContext(ctx aws.Context, input *AssociateWebACLInput, opts ...request.Option) (*AssociateWebACLOutput, error) {
	req, out := c.AssociateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCheckCapacity = "CheckCapacity"

// CheckCapacityRequest generates a "aws/request.Request" representing the
// client's request for the CheckCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CheckCapacity for more information on using the CheckCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CheckCapacityRequest method.
//    req, resp := client.CheckCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity
func (c *WAFV2) CheckCapacityRequest(input *CheckCapacityInput) (req *request.Request, output *CheckCapacityOutput) {
	op := &request.Operation{
		Name:       opCheckCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckCapacityInput{}
	}

	output = &CheckCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CheckCapacity API operation for AWS WAFV2.
//
// Returns the web ACL capacity unit (WCU) requirements for a specified scope
// and set of rules. You can use this to check the capacity requirements for
// the rules you want to use in a RuleGroup or WebACL.
//
// WAF uses WCUs to calculate and control the operating resources that are used
// to run your rules, rule groups, and web ACLs. WAF calculates capacity differently
// for each rule type, to reflect the relative cost of each rule. Simple rules
// that cost little to run use fewer WCUs than more complex rules that use more
// processing power. Rule group capacity is fixed at creation, which helps users
// plan their web ACL WCU usage when they use a rule group. The WCU limit for
// web ACLs is 1,500.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation CheckCapacity for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFInvalidResourceException
//   WAF couldn’t perform the operation because the resource that you requested
//   isn’t valid. Check the resource, and try again.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFSubscriptionNotFoundException
//   You tried to use a managed rule group that's available by subscription, but
//   you aren't subscribed to it yet.
//
//   * WAFExpiredManagedRuleGroupVersionException
//   The operation failed because the specified version for the managed rule group
//   has expired. You can retrieve the available versions for the managed rule
//   group by calling ListAvailableManagedRuleGroupVersions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity
func (c *WAFV2) CheckCapacity(input *CheckCapacityInput) (*CheckCapacityOutput, error) {
	req, out := c.CheckCapacityRequest(input)
	return out, req.Send()
}

// CheckCapacityWithContext is the same as CheckCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See CheckCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) CheckCapacityWithContext(ctx aws.Context, input *CheckCapacityInput, opts ...request.Option) (*CheckCapacityOutput, error) {
	req, out := c.CheckCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIPSet for more information on using the CreateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIPSetRequest method.
//    req, resp := client.CreateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet
func (c *WAFV2) CreateIPSetRequest(input *CreateIPSetInput) (req *request.Request, output *CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIPSetInput{}
	}

	output = &CreateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIPSet API operation for AWS WAFV2.
//
// Creates an IPSet, which you use to identify web requests that originate from
// specific IP addresses or ranges of IP addresses. For example, if you're receiving
// a lot of requests from a ranges of IP addresses, you can configure WAF to
// block them using an IPSet that lists those IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation CreateIPSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet
func (c *WAFV2) CreateIPSet(input *CreateIPSetInput) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	return out, req.Send()
}

// CreateIPSetWithContext is the same as CreateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) CreateIPSetWithContext(ctx aws.Context, input *CreateIPSetInput, opts ...request.Option) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegexPatternSet = "CreateRegexPatternSet"

// CreateRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegexPatternSet for more information on using the CreateRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegexPatternSetRequest method.
//    req, resp := client.CreateRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet
func (c *WAFV2) CreateRegexPatternSetRequest(input *CreateRegexPatternSetInput) (req *request.Request, output *CreateRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opCreateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRegexPatternSetInput{}
	}

	output = &CreateRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegexPatternSet API operation for AWS WAFV2.
//
// Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement,
// to have WAF inspect a web request component for the specified patterns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation CreateRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet
func (c *WAFV2) CreateRegexPatternSet(input *CreateRegexPatternSetInput) (*CreateRegexPatternSetOutput, error) {
	req, out := c.CreateRegexPatternSetRequest(input)
	return out, req.Send()
}

// CreateRegexPatternSetWithContext is the same as CreateRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) CreateRegexPatternSetWithContext(ctx aws.Context, input *CreateRegexPatternSetInput, opts ...request.Option) (*CreateRegexPatternSetOutput, error) {
	req, out := c.CreateRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleGroup = "CreateRuleGroup"

// CreateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleGroup for more information on using the CreateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleGroupRequest method.
//    req, resp := client.CreateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup
func (c *WAFV2) CreateRuleGroupRequest(input *CreateRuleGroupInput) (req *request.Request, output *CreateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opCreateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleGroupInput{}
	}

	output = &CreateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleGroup API operation for AWS WAFV2.
//
// Creates a RuleGroup per the specifications provided.
//
// A rule group defines a collection of rules to inspect and control web requests
// that you can use in a WebACL. When you create a rule group, you define an
// immutable capacity limit. If you update a rule group, you must stay within
// the capacity. This allows others to reuse the rule group with confidence
// in its capacity requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation CreateRuleGroup for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFSubscriptionNotFoundException
//   You tried to use a managed rule group that's available by subscription, but
//   you aren't subscribed to it yet.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup
func (c *WAFV2) CreateRuleGroup(input *CreateRuleGroupInput) (*CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	return out, req.Send()
}

// CreateRuleGroupWithContext is the same as CreateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) CreateRuleGroupWithContext(ctx aws.Context, input *CreateRuleGroupInput, opts ...request.Option) (*CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebACL = "CreateWebACL"

// CreateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWebACL for more information on using the CreateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWebACLRequest method.
//    req, resp := client.CreateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL
func (c *WAFV2) CreateWebACLRequest(input *CreateWebACLInput) (req *request.Request, output *CreateWebACLOutput) {
	op := &request.Operation{
		Name:       opCreateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWebACLInput{}
	}

	output = &CreateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWebACL API operation for AWS WAFV2.
//
// Creates a WebACL per the specifications provided.
//
// A web ACL defines a collection of rules to use to inspect and control web
// requests. Each rule has an action defined (allow, block, or count) for requests
// that match the statement of the rule. In the web ACL, you assign a default
// action to take (allow, block) for any request that does not match any of
// the rules. The rules in a web ACL can be a combination of the types Rule,
// RuleGroup, and managed rule group. You can associate a web ACL with one or
// more Amazon Web Services resources to protect. The resources can be an Amazon
// CloudFront distribution, an Amazon API Gateway REST API, an Application Load
// Balancer, or an AppSync GraphQL API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation CreateWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFInvalidResourceException
//   WAF couldn’t perform the operation because the resource that you requested
//   isn’t valid. Check the resource, and try again.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFSubscriptionNotFoundException
//   You tried to use a managed rule group that's available by subscription, but
//   you aren't subscribed to it yet.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL
func (c *WAFV2) CreateWebACL(input *CreateWebACLInput) (*CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	return out, req.Send()
}

// CreateWebACLWithContext is the same as CreateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) CreateWebACLWithContext(ctx aws.Context, input *CreateWebACLInput, opts ...request.Option) (*CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFirewallManagerRuleGroups = "DeleteFirewallManagerRuleGroups"

// DeleteFirewallManagerRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFirewallManagerRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFirewallManagerRuleGroups for more information on using the DeleteFirewallManagerRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFirewallManagerRuleGroupsRequest method.
//    req, resp := client.DeleteFirewallManagerRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups
func (c *WAFV2) DeleteFirewallManagerRuleGroupsRequest(input *DeleteFirewallManagerRuleGroupsInput) (req *request.Request, output *DeleteFirewallManagerRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opDeleteFirewallManagerRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFirewallManagerRuleGroupsInput{}
	}

	output = &DeleteFirewallManagerRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFirewallManagerRuleGroups API operation for AWS WAFV2.
//
// Deletes all rule groups that are managed by Firewall Manager for the specified
// web ACL.
//
// You can only use this if ManagedByFirewallManager is false in the specified
// WebACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeleteFirewallManagerRuleGroups for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups
func (c *WAFV2) DeleteFirewallManagerRuleGroups(input *DeleteFirewallManagerRuleGroupsInput) (*DeleteFirewallManagerRuleGroupsOutput, error) {
	req, out := c.DeleteFirewallManagerRuleGroupsRequest(input)
	return out, req.Send()
}

// DeleteFirewallManagerRuleGroupsWithContext is the same as DeleteFirewallManagerRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFirewallManagerRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeleteFirewallManagerRuleGroupsWithContext(ctx aws.Context, input *DeleteFirewallManagerRuleGroupsInput, opts ...request.Option) (*DeleteFirewallManagerRuleGroupsOutput, error) {
	req, out := c.DeleteFirewallManagerRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIPSet for more information on using the DeleteIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIPSetRequest method.
//    req, resp := client.DeleteIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet
func (c *WAFV2) DeleteIPSetRequest(input *DeleteIPSetInput) (req *request.Request, output *DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIPSetInput{}
	}

	output = &DeleteIPSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIPSet API operation for AWS WAFV2.
//
// Deletes the specified IPSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeleteIPSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFAssociatedItemException
//   WAF couldn’t perform the operation because your resource is being used
//   by another resource or it’s associated with another resource.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet
func (c *WAFV2) DeleteIPSet(input *DeleteIPSetInput) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	return out, req.Send()
}

// DeleteIPSetWithContext is the same as DeleteIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeleteIPSetWithContext(ctx aws.Context, input *DeleteIPSetInput, opts ...request.Option) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggingConfiguration = "DeleteLoggingConfiguration"

// DeleteLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggingConfiguration for more information on using the DeleteLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoggingConfigurationRequest method.
//    req, resp := client.DeleteLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration
func (c *WAFV2) DeleteLoggingConfigurationRequest(input *DeleteLoggingConfigurationInput) (req *request.Request, output *DeleteLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoggingConfigurationInput{}
	}

	output = &DeleteLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoggingConfiguration API operation for AWS WAFV2.
//
// Deletes the LoggingConfiguration from the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeleteLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration
func (c *WAFV2) DeleteLoggingConfiguration(input *DeleteLoggingConfigurationInput) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLoggingConfigurationWithContext is the same as DeleteLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeleteLoggingConfigurationWithContext(ctx aws.Context, input *DeleteLoggingConfigurationInput, opts ...request.Option) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionPolicy = "DeletePermissionPolicy"

// DeletePermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionPolicy for more information on using the DeletePermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePermissionPolicyRequest method.
//    req, resp := client.DeletePermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy
func (c *WAFV2) DeletePermissionPolicyRequest(input *DeletePermissionPolicyInput) (req *request.Request, output *DeletePermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionPolicyInput{}
	}

	output = &DeletePermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermissionPolicy API operation for AWS WAFV2.
//
// Permanently deletes an IAM policy from the specified rule group.
//
// You must be the owner of the rule group to perform this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeletePermissionPolicy for usage and error information.
//
// Returned Error Types:
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy
func (c *WAFV2) DeletePermissionPolicy(input *DeletePermissionPolicyInput) (*DeletePermissionPolicyOutput, error) {
	req, out := c.DeletePermissionPolicyRequest(input)
	return out, req.Send()
}

// DeletePermissionPolicyWithContext is the same as DeletePermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeletePermissionPolicyWithContext(ctx aws.Context, input *DeletePermissionPolicyInput, opts ...request.Option) (*DeletePermissionPolicyOutput, error) {
	req, out := c.DeletePermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegexPatternSet = "DeleteRegexPatternSet"

// DeleteRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegexPatternSet for more information on using the DeleteRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegexPatternSetRequest method.
//    req, resp := client.DeleteRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet
func (c *WAFV2) DeleteRegexPatternSetRequest(input *DeleteRegexPatternSetInput) (req *request.Request, output *DeleteRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opDeleteRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRegexPatternSetInput{}
	}

	output = &DeleteRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRegexPatternSet API operation for AWS WAFV2.
//
// Deletes the specified RegexPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeleteRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFAssociatedItemException
//   WAF couldn’t perform the operation because your resource is being used
//   by another resource or it’s associated with another resource.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet
func (c *WAFV2) DeleteRegexPatternSet(input *DeleteRegexPatternSetInput) (*DeleteRegexPatternSetOutput, error) {
	req, out := c.DeleteRegexPatternSetRequest(input)
	return out, req.Send()
}

// DeleteRegexPatternSetWithContext is the same as DeleteRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeleteRegexPatternSetWithContext(ctx aws.Context, input *DeleteRegexPatternSetInput, opts ...request.Option) (*DeleteRegexPatternSetOutput, error) {
	req, out := c.DeleteRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleGroup = "DeleteRuleGroup"

// DeleteRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleGroup for more information on using the DeleteRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleGroupRequest method.
//    req, resp := client.DeleteRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup
func (c *WAFV2) DeleteRuleGroupRequest(input *DeleteRuleGroupInput) (req *request.Request, output *DeleteRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleGroupInput{}
	}

	output = &DeleteRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRuleGroup API operation for AWS WAFV2.
//
// Deletes the specified RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeleteRuleGroup for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFAssociatedItemException
//   WAF couldn’t perform the operation because your resource is being used
//   by another resource or it’s associated with another resource.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup
func (c *WAFV2) DeleteRuleGroup(input *DeleteRuleGroupInput) (*DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	return out, req.Send()
}

// DeleteRuleGroupWithContext is the same as DeleteRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeleteRuleGroupWithContext(ctx aws.Context, input *DeleteRuleGroupInput, opts ...request.Option) (*DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebACL = "DeleteWebACL"

// DeleteWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWebACL for more information on using the DeleteWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWebACLRequest method.
//    req, resp := client.DeleteWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL
func (c *WAFV2) DeleteWebACLRequest(input *DeleteWebACLInput) (req *request.Request, output *DeleteWebACLOutput) {
	op := &request.Operation{
		Name:       opDeleteWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWebACLInput{}
	}

	output = &DeleteWebACLOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWebACL API operation for AWS WAFV2.
//
// Deletes the specified WebACL.
//
// You can only use this if ManagedByFirewallManager is false in the specified
// WebACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DeleteWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFAssociatedItemException
//   WAF couldn’t perform the operation because your resource is being used
//   by another resource or it’s associated with another resource.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL
func (c *WAFV2) DeleteWebACL(input *DeleteWebACLInput) (*DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	return out, req.Send()
}

// DeleteWebACLWithContext is the same as DeleteWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DeleteWebACLWithContext(ctx aws.Context, input *DeleteWebACLInput, opts ...request.Option) (*DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeManagedRuleGroup = "DescribeManagedRuleGroup"

// DescribeManagedRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeManagedRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeManagedRuleGroup for more information on using the DescribeManagedRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeManagedRuleGroupRequest method.
//    req, resp := client.DescribeManagedRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup
func (c *WAFV2) DescribeManagedRuleGroupRequest(input *DescribeManagedRuleGroupInput) (req *request.Request, output *DescribeManagedRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeManagedRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeManagedRuleGroupInput{}
	}

	output = &DescribeManagedRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeManagedRuleGroup API operation for AWS WAFV2.
//
// Provides high-level information for a managed rule group, including descriptions
// of the rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DescribeManagedRuleGroup for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidResourceException
//   WAF couldn’t perform the operation because the resource that you requested
//   isn’t valid. Check the resource, and try again.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
//   * WAFExpiredManagedRuleGroupVersionException
//   The operation failed because the specified version for the managed rule group
//   has expired. You can retrieve the available versions for the managed rule
//   group by calling ListAvailableManagedRuleGroupVersions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup
func (c *WAFV2) DescribeManagedRuleGroup(input *DescribeManagedRuleGroupInput) (*DescribeManagedRuleGroupOutput, error) {
	req, out := c.DescribeManagedRuleGroupRequest(input)
	return out, req.Send()
}

// DescribeManagedRuleGroupWithContext is the same as DescribeManagedRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeManagedRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DescribeManagedRuleGroupWithContext(ctx aws.Context, input *DescribeManagedRuleGroupInput, opts ...request.Option) (*DescribeManagedRuleGroupOutput, error) {
	req, out := c.DescribeManagedRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWebACL = "DisassociateWebACL"

// DisassociateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWebACL for more information on using the DisassociateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWebACLRequest method.
//    req, resp := client.DisassociateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL
func (c *WAFV2) DisassociateWebACLRequest(input *DisassociateWebACLInput) (req *request.Request, output *DisassociateWebACLOutput) {
	op := &request.Operation{
		Name:       opDisassociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateWebACLInput{}
	}

	output = &DisassociateWebACLOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWebACL API operation for AWS WAFV2.
//
// Disassociates a web ACL from a regional application resource. A regional
// application can be an Application Load Balancer (ALB), an Amazon API Gateway
// REST API, or an AppSync GraphQL API.
//
// For Amazon CloudFront, don't use this call. Instead, use your CloudFront
// distribution configuration. To disassociate a web ACL, provide an empty web
// ACL ID in the CloudFront call UpdateDistribution. For information, see UpdateDistribution
// (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation DisassociateWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL
func (c *WAFV2) DisassociateWebACL(input *DisassociateWebACLInput) (*DisassociateWebACLOutput, error) {
	req, out := c.DisassociateWebACLRequest(input)
	return out, req.Send()
}

// DisassociateWebACLWithContext is the same as DisassociateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) DisassociateWebACLWithContext(ctx aws.Context, input *DisassociateWebACLInput, opts ...request.Option) (*DisassociateWebACLOutput, error) {
	req, out := c.DisassociateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a "aws/request.Request" representing the
// client's request for the GetIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIPSet for more information on using the GetIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIPSetRequest method.
//    req, resp := client.GetIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet
func (c *WAFV2) GetIPSetRequest(input *GetIPSetInput) (req *request.Request, output *GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIPSetInput{}
	}

	output = &GetIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIPSet API operation for AWS WAFV2.
//
// Retrieves the specified IPSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetIPSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet
func (c *WAFV2) GetIPSet(input *GetIPSetInput) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	return out, req.Send()
}

// GetIPSetWithContext is the same as GetIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetIPSetWithContext(ctx aws.Context, input *GetIPSetInput, opts ...request.Option) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingConfiguration = "GetLoggingConfiguration"

// GetLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingConfiguration for more information on using the GetLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggingConfigurationRequest method.
//    req, resp := client.GetLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration
func (c *WAFV2) GetLoggingConfigurationRequest(input *GetLoggingConfigurationInput) (req *request.Request, output *GetLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoggingConfigurationInput{}
	}

	output = &GetLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingConfiguration API operation for AWS WAFV2.
//
// Returns the LoggingConfiguration for the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration
func (c *WAFV2) GetLoggingConfiguration(input *GetLoggingConfigurationInput) (*GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetLoggingConfigurationWithContext is the same as GetLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetLoggingConfigurationWithContext(ctx aws.Context, input *GetLoggingConfigurationInput, opts ...request.Option) (*GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetManagedRuleSet = "GetManagedRuleSet"

// GetManagedRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the GetManagedRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetManagedRuleSet for more information on using the GetManagedRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetManagedRuleSetRequest method.
//    req, resp := client.GetManagedRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetManagedRuleSet
func (c *WAFV2) GetManagedRuleSetRequest(input *GetManagedRuleSetInput) (req *request.Request, output *GetManagedRuleSetOutput) {
	op := &request.Operation{
		Name:       opGetManagedRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetManagedRuleSetInput{}
	}

	output = &GetManagedRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetManagedRuleSet API operation for AWS WAFV2.
//
// Retrieves the specified managed rule set.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetManagedRuleSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetManagedRuleSet
func (c *WAFV2) GetManagedRuleSet(input *GetManagedRuleSetInput) (*GetManagedRuleSetOutput, error) {
	req, out := c.GetManagedRuleSetRequest(input)
	return out, req.Send()
}

// GetManagedRuleSetWithContext is the same as GetManagedRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetManagedRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetManagedRuleSetWithContext(ctx aws.Context, input *GetManagedRuleSetInput, opts ...request.Option) (*GetManagedRuleSetOutput, error) {
	req, out := c.GetManagedRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPermissionPolicy = "GetPermissionPolicy"

// GetPermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPermissionPolicy for more information on using the GetPermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPermissionPolicyRequest method.
//    req, resp := client.GetPermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy
func (c *WAFV2) GetPermissionPolicyRequest(input *GetPermissionPolicyInput) (req *request.Request, output *GetPermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPermissionPolicyInput{}
	}

	output = &GetPermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPermissionPolicy API operation for AWS WAFV2.
//
// Returns the IAM policy that is attached to the specified rule group.
//
// You must be the owner of the rule group to perform this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetPermissionPolicy for usage and error information.
//
// Returned Error Types:
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy
func (c *WAFV2) GetPermissionPolicy(input *GetPermissionPolicyInput) (*GetPermissionPolicyOutput, error) {
	req, out := c.GetPermissionPolicyRequest(input)
	return out, req.Send()
}

// GetPermissionPolicyWithContext is the same as GetPermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetPermissionPolicyWithContext(ctx aws.Context, input *GetPermissionPolicyInput, opts ...request.Option) (*GetPermissionPolicyOutput, error) {
	req, out := c.GetPermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRateBasedStatementManagedKeys = "GetRateBasedStatementManagedKeys"

// GetRateBasedStatementManagedKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetRateBasedStatementManagedKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRateBasedStatementManagedKeys for more information on using the GetRateBasedStatementManagedKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRateBasedStatementManagedKeysRequest method.
//    req, resp := client.GetRateBasedStatementManagedKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys
func (c *WAFV2) GetRateBasedStatementManagedKeysRequest(input *GetRateBasedStatementManagedKeysInput) (req *request.Request, output *GetRateBasedStatementManagedKeysOutput) {
	op := &request.Operation{
		Name:       opGetRateBasedStatementManagedKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRateBasedStatementManagedKeysInput{}
	}

	output = &GetRateBasedStatementManagedKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRateBasedStatementManagedKeys API operation for AWS WAFV2.
//
// Retrieves the keys that are currently blocked by a rate-based rule. The maximum
// number of managed keys that can be blocked for a single rate-based rule is
// 10,000. If more than 10,000 addresses exceed the rate limit, those with the
// highest rates are blocked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetRateBasedStatementManagedKeys for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys
func (c *WAFV2) GetRateBasedStatementManagedKeys(input *GetRateBasedStatementManagedKeysInput) (*GetRateBasedStatementManagedKeysOutput, error) {
	req, out := c.GetRateBasedStatementManagedKeysRequest(input)
	return out, req.Send()
}

// GetRateBasedStatementManagedKeysWithContext is the same as GetRateBasedStatementManagedKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetRateBasedStatementManagedKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetRateBasedStatementManagedKeysWithContext(ctx aws.Context, input *GetRateBasedStatementManagedKeysInput, opts ...request.Option) (*GetRateBasedStatementManagedKeysOutput, error) {
	req, out := c.GetRateBasedStatementManagedKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegexPatternSet = "GetRegexPatternSet"

// GetRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the GetRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegexPatternSet for more information on using the GetRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegexPatternSetRequest method.
//    req, resp := client.GetRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet
func (c *WAFV2) GetRegexPatternSetRequest(input *GetRegexPatternSetInput) (req *request.Request, output *GetRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opGetRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegexPatternSetInput{}
	}

	output = &GetRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegexPatternSet API operation for AWS WAFV2.
//
// Retrieves the specified RegexPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet
func (c *WAFV2) GetRegexPatternSet(input *GetRegexPatternSetInput) (*GetRegexPatternSetOutput, error) {
	req, out := c.GetRegexPatternSetRequest(input)
	return out, req.Send()
}

// GetRegexPatternSetWithContext is the same as GetRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetRegexPatternSetWithContext(ctx aws.Context, input *GetRegexPatternSetInput, opts ...request.Option) (*GetRegexPatternSetOutput, error) {
	req, out := c.GetRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRuleGroup = "GetRuleGroup"

// GetRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRuleGroup for more information on using the GetRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRuleGroupRequest method.
//    req, resp := client.GetRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup
func (c *WAFV2) GetRuleGroupRequest(input *GetRuleGroupInput) (req *request.Request, output *GetRuleGroupOutput) {
	op := &request.Operation{
		Name:       opGetRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleGroupInput{}
	}

	output = &GetRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRuleGroup API operation for AWS WAFV2.
//
// Retrieves the specified RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetRuleGroup for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup
func (c *WAFV2) GetRuleGroup(input *GetRuleGroupInput) (*GetRuleGroupOutput, error) {
	req, out := c.GetRuleGroupRequest(input)
	return out, req.Send()
}

// GetRuleGroupWithContext is the same as GetRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetRuleGroupWithContext(ctx aws.Context, input *GetRuleGroupInput, opts ...request.Option) (*GetRuleGroupOutput, error) {
	req, out := c.GetRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSampledRequests = "GetSampledRequests"

// GetSampledRequestsRequest generates a "aws/request.Request" representing the
// client's request for the GetSampledRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSampledRequests for more information on using the GetSampledRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSampledRequestsRequest method.
//    req, resp := client.GetSampledRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests
func (c *WAFV2) GetSampledRequestsRequest(input *GetSampledRequestsInput) (req *request.Request, output *GetSampledRequestsOutput) {
	op := &request.Operation{
		Name:       opGetSampledRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSampledRequestsInput{}
	}

	output = &GetSampledRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSampledRequests API operation for AWS WAFV2.
//
// Gets detailed information about a specified number of requests--a sample--that
// WAF randomly selects from among the first 5,000 requests that your Amazon
// Web Services resource received during a time range that you choose. You can
// specify a sample size of up to 500 requests, and you can specify any time
// range in the previous three hours.
//
// GetSampledRequests returns a time range, which is usually the time range
// that you specified. However, if your resource (such as a CloudFront distribution)
// received 5,000 requests before the specified time range elapsed, GetSampledRequests
// returns an updated time range. This new time range indicates the actual period
// during which WAF selected the requests in the sample.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetSampledRequests for usage and error information.
//
// Returned Error Types:
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests
func (c *WAFV2) GetSampledRequests(input *GetSampledRequestsInput) (*GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	return out, req.Send()
}

// GetSampledRequestsWithContext is the same as GetSampledRequests with the addition of
// the ability to pass a context and additional request options.
//
// See GetSampledRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetSampledRequestsWithContext(ctx aws.Context, input *GetSampledRequestsInput, opts ...request.Option) (*GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACL = "GetWebACL"

// GetWebACLRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWebACL for more information on using the GetWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWebACLRequest method.
//    req, resp := client.GetWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL
func (c *WAFV2) GetWebACLRequest(input *GetWebACLInput) (req *request.Request, output *GetWebACLOutput) {
	op := &request.Operation{
		Name:       opGetWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLInput{}
	}

	output = &GetWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACL API operation for AWS WAFV2.
//
// Retrieves the specified WebACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL
func (c *WAFV2) GetWebACL(input *GetWebACLInput) (*GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	return out, req.Send()
}

// GetWebACLWithContext is the same as GetWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetWebACLWithContext(ctx aws.Context, input *GetWebACLInput, opts ...request.Option) (*GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACLForResource = "GetWebACLForResource"

// GetWebACLForResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACLForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWebACLForResource for more information on using the GetWebACLForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWebACLForResourceRequest method.
//    req, resp := client.GetWebACLForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource
func (c *WAFV2) GetWebACLForResourceRequest(input *GetWebACLForResourceInput) (req *request.Request, output *GetWebACLForResourceOutput) {
	op := &request.Operation{
		Name:       opGetWebACLForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLForResourceInput{}
	}

	output = &GetWebACLForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACLForResource API operation for AWS WAFV2.
//
// Retrieves the WebACL for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation GetWebACLForResource for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource
func (c *WAFV2) GetWebACLForResource(input *GetWebACLForResourceInput) (*GetWebACLForResourceOutput, error) {
	req, out := c.GetWebACLForResourceRequest(input)
	return out, req.Send()
}

// GetWebACLForResourceWithContext is the same as GetWebACLForResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACLForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) GetWebACLForResourceWithContext(ctx aws.Context, input *GetWebACLForResourceInput, opts ...request.Option) (*GetWebACLForResourceOutput, error) {
	req, out := c.GetWebACLForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableManagedRuleGroupVersions = "ListAvailableManagedRuleGroupVersions"

// ListAvailableManagedRuleGroupVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableManagedRuleGroupVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableManagedRuleGroupVersions for more information on using the ListAvailableManagedRuleGroupVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAvailableManagedRuleGroupVersionsRequest method.
//    req, resp := client.ListAvailableManagedRuleGroupVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroupVersions
func (c *WAFV2) ListAvailableManagedRuleGroupVersionsRequest(input *ListAvailableManagedRuleGroupVersionsInput) (req *request.Request, output *ListAvailableManagedRuleGroupVersionsOutput) {
	op := &request.Operation{
		Name:       opListAvailableManagedRuleGroupVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableManagedRuleGroupVersionsInput{}
	}

	output = &ListAvailableManagedRuleGroupVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableManagedRuleGroupVersions API operation for AWS WAFV2.
//
// Returns a list of the available versions for the specified managed rule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListAvailableManagedRuleGroupVersions for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroupVersions
func (c *WAFV2) ListAvailableManagedRuleGroupVersions(input *ListAvailableManagedRuleGroupVersionsInput) (*ListAvailableManagedRuleGroupVersionsOutput, error) {
	req, out := c.ListAvailableManagedRuleGroupVersionsRequest(input)
	return out, req.Send()
}

// ListAvailableManagedRuleGroupVersionsWithContext is the same as ListAvailableManagedRuleGroupVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableManagedRuleGroupVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListAvailableManagedRuleGroupVersionsWithContext(ctx aws.Context, input *ListAvailableManagedRuleGroupVersionsInput, opts ...request.Option) (*ListAvailableManagedRuleGroupVersionsOutput, error) {
	req, out := c.ListAvailableManagedRuleGroupVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableManagedRuleGroups = "ListAvailableManagedRuleGroups"

// ListAvailableManagedRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableManagedRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableManagedRuleGroups for more information on using the ListAvailableManagedRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAvailableManagedRuleGroupsRequest method.
//    req, resp := client.ListAvailableManagedRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups
func (c *WAFV2) ListAvailableManagedRuleGroupsRequest(input *ListAvailableManagedRuleGroupsInput) (req *request.Request, output *ListAvailableManagedRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListAvailableManagedRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableManagedRuleGroupsInput{}
	}

	output = &ListAvailableManagedRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableManagedRuleGroups API operation for AWS WAFV2.
//
// Retrieves an array of managed rule groups that are available for you to use.
// This list includes all Amazon Web Services Managed Rules rule groups and
// all of the Marketplace managed rule groups that you're subscribed to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListAvailableManagedRuleGroups for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups
func (c *WAFV2) ListAvailableManagedRuleGroups(input *ListAvailableManagedRuleGroupsInput) (*ListAvailableManagedRuleGroupsOutput, error) {
	req, out := c.ListAvailableManagedRuleGroupsRequest(input)
	return out, req.Send()
}

// ListAvailableManagedRuleGroupsWithContext is the same as ListAvailableManagedRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableManagedRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListAvailableManagedRuleGroupsWithContext(ctx aws.Context, input *ListAvailableManagedRuleGroupsInput, opts ...request.Option) (*ListAvailableManagedRuleGroupsOutput, error) {
	req, out := c.ListAvailableManagedRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIPSets for more information on using the ListIPSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets
func (c *WAFV2) ListIPSetsRequest(input *ListIPSetsInput) (req *request.Request, output *ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIPSetsInput{}
	}

	output = &ListIPSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIPSets API operation for AWS WAFV2.
//
// Retrieves an array of IPSetSummary objects for the IP sets that you manage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListIPSets for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets
func (c *WAFV2) ListIPSets(input *ListIPSetsInput) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListIPSetsWithContext(ctx aws.Context, input *ListIPSetsInput, opts ...request.Option) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggingConfigurations = "ListLoggingConfigurations"

// ListLoggingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggingConfigurations for more information on using the ListLoggingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggingConfigurationsRequest method.
//    req, resp := client.ListLoggingConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations
func (c *WAFV2) ListLoggingConfigurationsRequest(input *ListLoggingConfigurationsInput) (req *request.Request, output *ListLoggingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListLoggingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLoggingConfigurationsInput{}
	}

	output = &ListLoggingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggingConfigurations API operation for AWS WAFV2.
//
// Retrieves an array of your LoggingConfiguration objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListLoggingConfigurations for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations
func (c *WAFV2) ListLoggingConfigurations(input *ListLoggingConfigurationsInput) (*ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	return out, req.Send()
}

// ListLoggingConfigurationsWithContext is the same as ListLoggingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListLoggingConfigurationsWithContext(ctx aws.Context, input *ListLoggingConfigurationsInput, opts ...request.Option) (*ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListManagedRuleSets = "ListManagedRuleSets"

// ListManagedRuleSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedRuleSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedRuleSets for more information on using the ListManagedRuleSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListManagedRuleSetsRequest method.
//    req, resp := client.ListManagedRuleSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListManagedRuleSets
func (c *WAFV2) ListManagedRuleSetsRequest(input *ListManagedRuleSetsInput) (req *request.Request, output *ListManagedRuleSetsOutput) {
	op := &request.Operation{
		Name:       opListManagedRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListManagedRuleSetsInput{}
	}

	output = &ListManagedRuleSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedRuleSets API operation for AWS WAFV2.
//
// Retrieves the managed rule sets that you own.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListManagedRuleSets for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListManagedRuleSets
func (c *WAFV2) ListManagedRuleSets(input *ListManagedRuleSetsInput) (*ListManagedRuleSetsOutput, error) {
	req, out := c.ListManagedRuleSetsRequest(input)
	return out, req.Send()
}

// ListManagedRuleSetsWithContext is the same as ListManagedRuleSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedRuleSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListManagedRuleSetsWithContext(ctx aws.Context, input *ListManagedRuleSetsInput, opts ...request.Option) (*ListManagedRuleSetsOutput, error) {
	req, out := c.ListManagedRuleSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRegexPatternSets = "ListRegexPatternSets"

// ListRegexPatternSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegexPatternSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegexPatternSets for more information on using the ListRegexPatternSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegexPatternSetsRequest method.
//    req, resp := client.ListRegexPatternSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets
func (c *WAFV2) ListRegexPatternSetsRequest(input *ListRegexPatternSetsInput) (req *request.Request, output *ListRegexPatternSetsOutput) {
	op := &request.Operation{
		Name:       opListRegexPatternSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRegexPatternSetsInput{}
	}

	output = &ListRegexPatternSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegexPatternSets API operation for AWS WAFV2.
//
// Retrieves an array of RegexPatternSetSummary objects for the regex pattern
// sets that you manage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListRegexPatternSets for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets
func (c *WAFV2) ListRegexPatternSets(input *ListRegexPatternSetsInput) (*ListRegexPatternSetsOutput, error) {
	req, out := c.ListRegexPatternSetsRequest(input)
	return out, req.Send()
}

// ListRegexPatternSetsWithContext is the same as ListRegexPatternSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegexPatternSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListRegexPatternSetsWithContext(ctx aws.Context, input *ListRegexPatternSetsInput, opts ...request.Option) (*ListRegexPatternSetsOutput, error) {
	req, out := c.ListRegexPatternSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourcesForWebACL = "ListResourcesForWebACL"

// ListResourcesForWebACLRequest generates a "aws/request.Request" representing the
// client's request for the ListResourcesForWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourcesForWebACL for more information on using the ListResourcesForWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesForWebACLRequest method.
//    req, resp := client.ListResourcesForWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL
func (c *WAFV2) ListResourcesForWebACLRequest(input *ListResourcesForWebACLInput) (req *request.Request, output *ListResourcesForWebACLOutput) {
	op := &request.Operation{
		Name:       opListResourcesForWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesForWebACLInput{}
	}

	output = &ListResourcesForWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourcesForWebACL API operation for AWS WAFV2.
//
// Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources
// that are associated with the specified web ACL. If you want the list of Amazon
// CloudFront resources, use the CloudFront call ListDistributionsByWebACLId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListResourcesForWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL
func (c *WAFV2) ListResourcesForWebACL(input *ListResourcesForWebACLInput) (*ListResourcesForWebACLOutput, error) {
	req, out := c.ListResourcesForWebACLRequest(input)
	return out, req.Send()
}

// ListResourcesForWebACLWithContext is the same as ListResourcesForWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourcesForWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListResourcesForWebACLWithContext(ctx aws.Context, input *ListResourcesForWebACLInput, opts ...request.Option) (*ListResourcesForWebACLOutput, error) {
	req, out := c.ListResourcesForWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleGroups = "ListRuleGroups"

// ListRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleGroups for more information on using the ListRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRuleGroupsRequest method.
//    req, resp := client.ListRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups
func (c *WAFV2) ListRuleGroupsRequest(input *ListRuleGroupsInput) (req *request.Request, output *ListRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleGroupsInput{}
	}

	output = &ListRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleGroups API operation for AWS WAFV2.
//
// Retrieves an array of RuleGroupSummary objects for the rule groups that you
// manage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListRuleGroups for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups
func (c *WAFV2) ListRuleGroups(input *ListRuleGroupsInput) (*ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	return out, req.Send()
}

// ListRuleGroupsWithContext is the same as ListRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListRuleGroupsWithContext(ctx aws.Context, input *ListRuleGroupsInput, opts ...request.Option) (*ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource
func (c *WAFV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS WAFV2.
//
// Retrieves the TagInfoForResource for the specified resource. Tags are key:value
// pairs that you can use to categorize and manage your resources, for purposes
// like billing. For example, you might set the tag key to "customer" and the
// value to the customer name or ID. You can specify one or more tags to add
// to each Amazon Web Services resource, up to 50 tags for a resource.
//
// You can tag the Amazon Web Services resources that you manage through WAF:
// web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage
// or view tags through the WAF console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource
func (c *WAFV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWebACLs = "ListWebACLs"

// ListWebACLsRequest generates a "aws/request.Request" representing the
// client's request for the ListWebACLs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebACLs for more information on using the ListWebACLs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWebACLsRequest method.
//    req, resp := client.ListWebACLsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs
func (c *WAFV2) ListWebACLsRequest(input *ListWebACLsInput) (req *request.Request, output *ListWebACLsOutput) {
	op := &request.Operation{
		Name:       opListWebACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListWebACLsInput{}
	}

	output = &ListWebACLsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebACLs API operation for AWS WAFV2.
//
// Retrieves an array of WebACLSummary objects for the web ACLs that you manage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation ListWebACLs for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs
func (c *WAFV2) ListWebACLs(input *ListWebACLsInput) (*ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	return out, req.Send()
}

// ListWebACLsWithContext is the same as ListWebACLs with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebACLs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) ListWebACLsWithContext(ctx aws.Context, input *ListWebACLsInput, opts ...request.Option) (*ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingConfiguration = "PutLoggingConfiguration"

// PutLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingConfiguration for more information on using the PutLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingConfigurationRequest method.
//    req, resp := client.PutLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration
func (c *WAFV2) PutLoggingConfigurationRequest(input *PutLoggingConfigurationInput) (req *request.Request, output *PutLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLoggingConfigurationInput{}
	}

	output = &PutLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLoggingConfiguration API operation for AWS WAFV2.
//
// Enables the specified LoggingConfiguration, to start logging from a web ACL,
// according to the configuration provided.
//
// You can access information about all traffic that WAF inspects using the
// following steps:
//
// Create an Amazon Kinesis Data Firehose.
//
// Create the data firehose with a PUT source and in the Region that you are
// operating. If you are capturing logs for Amazon CloudFront, always create
// the firehose in US East (N. Virginia).
//
// Give the data firehose a name that starts with the prefix aws-waf-logs-.
// For example, aws-waf-logs-us-east-2-analytics.
//
// Do not create the data firehose using a Kinesis stream as your source.
//
// Associate that firehose to your web ACL using a PutLoggingConfiguration request.
//
// When you successfully enable logging using a PutLoggingConfiguration request,
// WAF will create a service linked role with the necessary permissions to write
// logs to the Amazon Kinesis Data Firehose. For more information, see Logging
// Web ACL Traffic Information (https://docs.aws.amazon.com/waf/latest/developerguide/logging.html)
// in the WAF Developer Guide.
//
// This operation completely replaces the mutable specifications that you already
// have for the logging configuration with the ones that you provide to this
// call. To modify the logging configuration, retrieve it by calling GetLoggingConfiguration,
// update the settings as needed, and then provide the complete logging configuration
// specification to this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation PutLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFServiceLinkedRoleErrorException
//   WAF is not able to access the service linked role. This can be caused by
//   a previous PutLoggingConfiguration request, which can lock the service linked
//   role for about 20 seconds. Please try your request again. The service linked
//   role can also be locked by a previous DeleteServiceLinkedRole request, which
//   can lock the role for 15 minutes or more. If you recently made a call to
//   DeleteServiceLinkedRole, wait at least 15 minutes and try the request again.
//   If you receive this same exception again, you will have to wait additional
//   time until the role is unlocked.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration
func (c *WAFV2) PutLoggingConfiguration(input *PutLoggingConfigurationInput) (*PutLoggingConfigurationOutput, error) {
	req, out := c.PutLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutLoggingConfigurationWithContext is the same as PutLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) PutLoggingConfigurationWithContext(ctx aws.Context, input *PutLoggingConfigurationInput, opts ...request.Option) (*PutLoggingConfigurationOutput, error) {
	req, out := c.PutLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutManagedRuleSetVersions = "PutManagedRuleSetVersions"

// PutManagedRuleSetVersionsRequest generates a "aws/request.Request" representing the
// client's request for the PutManagedRuleSetVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutManagedRuleSetVersions for more information on using the PutManagedRuleSetVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutManagedRuleSetVersionsRequest method.
//    req, resp := client.PutManagedRuleSetVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutManagedRuleSetVersions
func (c *WAFV2) PutManagedRuleSetVersionsRequest(input *PutManagedRuleSetVersionsInput) (req *request.Request, output *PutManagedRuleSetVersionsOutput) {
	op := &request.Operation{
		Name:       opPutManagedRuleSetVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutManagedRuleSetVersionsInput{}
	}

	output = &PutManagedRuleSetVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutManagedRuleSetVersions API operation for AWS WAFV2.
//
// Defines the versions of your managed rule set that you are offering to the
// customers. Customers see your offerings as managed rule groups with versioning.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
//
// Customers retrieve their managed rule group list by calling ListAvailableManagedRuleGroups.
// The name that you provide here for your managed rule set is the name the
// customer sees for the corresponding managed rule group. Customers can retrieve
// the available versions for a managed rule group by calling ListAvailableManagedRuleGroupVersions.
// You provide a rule group specification for each version. For each managed
// rule set, you must specify a version that you recommend using.
//
// To initiate the expiration of a managed rule group version, use UpdateManagedRuleSetVersionExpiryDate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation PutManagedRuleSetVersions for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutManagedRuleSetVersions
func (c *WAFV2) PutManagedRuleSetVersions(input *PutManagedRuleSetVersionsInput) (*PutManagedRuleSetVersionsOutput, error) {
	req, out := c.PutManagedRuleSetVersionsRequest(input)
	return out, req.Send()
}

// PutManagedRuleSetVersionsWithContext is the same as PutManagedRuleSetVersions with the addition of
// the ability to pass a context and additional request options.
//
// See PutManagedRuleSetVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) PutManagedRuleSetVersionsWithContext(ctx aws.Context, input *PutManagedRuleSetVersionsInput, opts ...request.Option) (*PutManagedRuleSetVersionsOutput, error) {
	req, out := c.PutManagedRuleSetVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPermissionPolicy = "PutPermissionPolicy"

// PutPermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPermissionPolicy for more information on using the PutPermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPermissionPolicyRequest method.
//    req, resp := client.PutPermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy
func (c *WAFV2) PutPermissionPolicyRequest(input *PutPermissionPolicyInput) (req *request.Request, output *PutPermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPermissionPolicyInput{}
	}

	output = &PutPermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPermissionPolicy API operation for AWS WAFV2.
//
// Attaches an IAM policy to the specified resource. Use this to share a rule
// group across accounts.
//
// You must be the owner of the rule group to perform this operation.
//
// This action is subject to the following restrictions:
//
//    * You can attach only one policy with each PutPermissionPolicy request.
//
//    * The ARN in the request must be a valid WAF RuleGroup ARN and the rule
//    group must exist in the same Region.
//
//    * The user making the request must be the owner of the rule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation PutPermissionPolicy for usage and error information.
//
// Returned Error Types:
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFInvalidPermissionPolicyException
//   The operation failed because the specified policy isn't in the proper format.
//
//   The policy specifications must conform to the following:
//
//      * The policy must be composed using IAM Policy version 2012-10-17 or version
//      2015-01-01.
//
//      * The policy must include specifications for Effect, Action, and Principal.
//
//      * Effect must specify Allow.
//
//      * Action must specify wafv2:CreateWebACL, wafv2:UpdateWebACL, and wafv2:PutFirewallManagerRuleGroups.
//      WAF rejects any extra actions or wildcard actions in the policy.
//
//      * The policy must not include a Resource parameter.
//
//   For more information, see IAM Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy
func (c *WAFV2) PutPermissionPolicy(input *PutPermissionPolicyInput) (*PutPermissionPolicyOutput, error) {
	req, out := c.PutPermissionPolicyRequest(input)
	return out, req.Send()
}

// PutPermissionPolicyWithContext is the same as PutPermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) PutPermissionPolicyWithContext(ctx aws.Context, input *PutPermissionPolicyInput, opts ...request.Option) (*PutPermissionPolicyOutput, error) {
	req, out := c.PutPermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource
func (c *WAFV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS WAFV2.
//
// Associates tags with the specified Amazon Web Services resource. Tags are
// key:value pairs that you can use to categorize and manage your resources,
// for purposes like billing. For example, you might set the tag key to "customer"
// and the value to the customer name or ID. You can specify one or more tags
// to add to each Amazon Web Services resource, up to 50 tags for a resource.
//
// You can tag the Amazon Web Services resources that you manage through WAF:
// web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage
// or view tags through the WAF console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource
func (c *WAFV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource
func (c *WAFV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS WAFV2.
//
// Disassociates tags from an Amazon Web Services resource. Tags are key:value
// pairs that you can associate with Amazon Web Services resources. For example,
// the tag key might be "customer" and the tag value might be "companyA." You
// can specify one or more tags to add to each container. You can add up to
// 50 tags to each Amazon Web Services resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFTagOperationException
//   An error occurred during the tagging operation. Retry your request.
//
//   * WAFTagOperationInternalErrorException
//   WAF couldn’t perform your tagging operation because of an internal error.
//   Retry your request.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource
func (c *WAFV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIPSet for more information on using the UpdateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIPSetRequest method.
//    req, resp := client.UpdateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet
func (c *WAFV2) UpdateIPSetRequest(input *UpdateIPSetInput) (req *request.Request, output *UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIPSetInput{}
	}

	output = &UpdateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIPSet API operation for AWS WAFV2.
//
// Updates the specified IPSet.
//
// This operation completely replaces the mutable specifications that you already
// have for the IP set with the ones that you provide to this call. To modify
// the IP set, retrieve it by calling GetIPSet, update the settings as needed,
// and then provide the complete IP set specification to this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation UpdateIPSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet
func (c *WAFV2) UpdateIPSet(input *UpdateIPSetInput) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	return out, req.Send()
}

// UpdateIPSetWithContext is the same as UpdateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) UpdateIPSetWithContext(ctx aws.Context, input *UpdateIPSetInput, opts ...request.Option) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateManagedRuleSetVersionExpiryDate = "UpdateManagedRuleSetVersionExpiryDate"

// UpdateManagedRuleSetVersionExpiryDateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateManagedRuleSetVersionExpiryDate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateManagedRuleSetVersionExpiryDate for more information on using the UpdateManagedRuleSetVersionExpiryDate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateManagedRuleSetVersionExpiryDateRequest method.
//    req, resp := client.UpdateManagedRuleSetVersionExpiryDateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateManagedRuleSetVersionExpiryDate
func (c *WAFV2) UpdateManagedRuleSetVersionExpiryDateRequest(input *UpdateManagedRuleSetVersionExpiryDateInput) (req *request.Request, output *UpdateManagedRuleSetVersionExpiryDateOutput) {
	op := &request.Operation{
		Name:       opUpdateManagedRuleSetVersionExpiryDate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateManagedRuleSetVersionExpiryDateInput{}
	}

	output = &UpdateManagedRuleSetVersionExpiryDateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateManagedRuleSetVersionExpiryDate API operation for AWS WAFV2.
//
// Updates the expiration information for your managed rule set. Use this to
// initiate the expiration of a managed rule group version. After you initiate
// expiration for a version, WAF excludes it from the reponse to ListAvailableManagedRuleGroupVersions
// for the managed rule group.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation UpdateManagedRuleSetVersionExpiryDate for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateManagedRuleSetVersionExpiryDate
func (c *WAFV2) UpdateManagedRuleSetVersionExpiryDate(input *UpdateManagedRuleSetVersionExpiryDateInput) (*UpdateManagedRuleSetVersionExpiryDateOutput, error) {
	req, out := c.UpdateManagedRuleSetVersionExpiryDateRequest(input)
	return out, req.Send()
}

// UpdateManagedRuleSetVersionExpiryDateWithContext is the same as UpdateManagedRuleSetVersionExpiryDate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateManagedRuleSetVersionExpiryDate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) UpdateManagedRuleSetVersionExpiryDateWithContext(ctx aws.Context, input *UpdateManagedRuleSetVersionExpiryDateInput, opts ...request.Option) (*UpdateManagedRuleSetVersionExpiryDateOutput, error) {
	req, out := c.UpdateManagedRuleSetVersionExpiryDateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegexPatternSet = "UpdateRegexPatternSet"

// UpdateRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegexPatternSet for more information on using the UpdateRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegexPatternSetRequest method.
//    req, resp := client.UpdateRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet
func (c *WAFV2) UpdateRegexPatternSetRequest(input *UpdateRegexPatternSetInput) (req *request.Request, output *UpdateRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opUpdateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRegexPatternSetInput{}
	}

	output = &UpdateRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegexPatternSet API operation for AWS WAFV2.
//
// Updates the specified RegexPatternSet.
//
// This operation completely replaces the mutable specifications that you already
// have for the regex pattern set with the ones that you provide to this call.
// To modify the regex pattern set, retrieve it by calling GetRegexPatternSet,
// update the settings as needed, and then provide the complete regex pattern
// set specification to this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation UpdateRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet
func (c *WAFV2) UpdateRegexPatternSet(input *UpdateRegexPatternSetInput) (*UpdateRegexPatternSetOutput, error) {
	req, out := c.UpdateRegexPatternSetRequest(input)
	return out, req.Send()
}

// UpdateRegexPatternSetWithContext is the same as UpdateRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) UpdateRegexPatternSetWithContext(ctx aws.Context, input *UpdateRegexPatternSetInput, opts ...request.Option) (*UpdateRegexPatternSetOutput, error) {
	req, out := c.UpdateRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleGroup = "UpdateRuleGroup"

// UpdateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleGroup for more information on using the UpdateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleGroupRequest method.
//    req, resp := client.UpdateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup
func (c *WAFV2) UpdateRuleGroupRequest(input *UpdateRuleGroupInput) (req *request.Request, output *UpdateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleGroupInput{}
	}

	output = &UpdateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleGroup API operation for AWS WAFV2.
//
// Updates the specified RuleGroup.
//
// This operation completely replaces the mutable specifications that you already
// have for the rule group with the ones that you provide to this call. To modify
// the rule group, retrieve it by calling GetRuleGroup, update the settings
// as needed, and then provide the complete rule group specification to this
// call.
//
// A rule group defines a collection of rules to inspect and control web requests
// that you can use in a WebACL. When you create a rule group, you define an
// immutable capacity limit. If you update a rule group, you must stay within
// the capacity. This allows others to reuse the rule group with confidence
// in its capacity requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation UpdateRuleGroup for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFSubscriptionNotFoundException
//   You tried to use a managed rule group that's available by subscription, but
//   you aren't subscribed to it yet.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup
func (c *WAFV2) UpdateRuleGroup(input *UpdateRuleGroupInput) (*UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	return out, req.Send()
}

// UpdateRuleGroupWithContext is the same as UpdateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) UpdateRuleGroupWithContext(ctx aws.Context, input *UpdateRuleGroupInput, opts ...request.Option) (*UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWebACL = "UpdateWebACL"

// UpdateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWebACL for more information on using the UpdateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWebACLRequest method.
//    req, resp := client.UpdateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL
func (c *WAFV2) UpdateWebACLRequest(input *UpdateWebACLInput) (req *request.Request, output *UpdateWebACLOutput) {
	op := &request.Operation{
		Name:       opUpdateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWebACLInput{}
	}

	output = &UpdateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWebACL API operation for AWS WAFV2.
//
// Updates the specified WebACL.
//
// This operation completely replaces the mutable specifications that you already
// have for the web ACL with the ones that you provide to this call. To modify
// the web ACL, retrieve it by calling GetWebACL, update the settings as needed,
// and then provide the complete web ACL specification to this call.
//
// A web ACL defines a collection of rules to use to inspect and control web
// requests. Each rule has an action defined (allow, block, or count) for requests
// that match the statement of the rule. In the web ACL, you assign a default
// action to take (allow, block) for any request that does not match any of
// the rules. The rules in a web ACL can be a combination of the types Rule,
// RuleGroup, and managed rule group. You can associate a web ACL with one or
// more Amazon Web Services resources to protect. The resources can be an Amazon
// CloudFront distribution, an Amazon API Gateway REST API, an Application Load
// Balancer, or an AppSync GraphQL API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAFV2's
// API operation UpdateWebACL for usage and error information.
//
// Returned Error Types:
//   * WAFInternalErrorException
//   Your request is valid, but WAF couldn’t perform the operation because of
//   a system problem. Retry your request.
//
//   * WAFInvalidParameterException
//   The operation failed because WAF didn't recognize a parameter in the request.
//   For example:
//
//      * You specified a parameter name or value that isn't valid.
//
//      * Your nested statement isn't valid. You might have tried to nest a statement
//      that can’t be nested.
//
//      * You tried to update a WebACL with a DefaultAction that isn't among the
//      types available at DefaultAction.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL can't be associated.
//
//   * WAFNonexistentItemException
//   WAF couldn’t perform the operation because your resource doesn’t exist.
//
//   * WAFDuplicateItemException
//   WAF couldn’t perform the operation because the resource that you tried
//   to save is a duplicate of an existing one.
//
//   * WAFOptimisticLockException
//   WAF couldn’t save your changes because you tried to update or delete a
//   resource that has changed since you last retrieved it. Get the resource again,
//   make any changes you need to make to the new copy, and retry your operation.
//
//   * WAFLimitsExceededException
//   WAF couldn’t perform the operation because you exceeded your resource limit.
//   For example, the maximum number of WebACL objects that you can create for
//   an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the WAF Developer Guide.
//
//   * WAFInvalidResourceException
//   WAF couldn’t perform the operation because the resource that you requested
//   isn’t valid. Check the resource, and try again.
//
//   * WAFUnavailableEntityException
//   WAF couldn’t retrieve the resource that you requested. Retry your request.
//
//   * WAFSubscriptionNotFoundException
//   You tried to use a managed rule group that's available by subscription, but
//   you aren't subscribed to it yet.
//
//   * WAFInvalidOperationException
//   The operation isn't valid.
//
//   * WAFExpiredManagedRuleGroupVersionException
//   The operation failed because the specified version for the managed rule group
//   has expired. You can retrieve the available versions for the managed rule
//   group by calling ListAvailableManagedRuleGroupVersions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL
func (c *WAFV2) UpdateWebACL(input *UpdateWebACLInput) (*UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	return out, req.Send()
}

// UpdateWebACLWithContext is the same as UpdateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFV2) UpdateWebACLWithContext(ctx aws.Context, input *UpdateWebACLInput, opts ...request.Option) (*UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A single action condition for a Condition in a logging filter.
type ActionCondition struct {
	_ struct{} `type:"structure"`

	// The action setting that a log record must contain in order to meet the condition.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ActionValue"`
}

// String returns the string representation
func (s ActionCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionCondition"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ActionCondition) SetAction(v string) *ActionCondition {
	s.Action = &v
	return s
}

// Inspect all of the elements that WAF has parsed and extracted from the web
// request JSON body that are within the JsonBody MatchScope. This is used with
// the FieldToMatch option JsonBody.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type All struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s All) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s All) GoString() string {
	return s.String()
}

// All query arguments of a web request.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type AllQueryArguments struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AllQueryArguments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllQueryArguments) GoString() string {
	return s.String()
}

// Specifies that WAF should allow the request and optionally defines additional
// custom handling for the request.
//
// This is used in the context of other settings, for example to specify values
// for RuleAction and web ACL DefaultAction.
type AllowAction struct {
	_ struct{} `type:"structure"`

	// Defines custom handling for the web request.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomRequestHandling *CustomRequestHandling `type:"structure"`
}

// String returns the string representation
func (s AllowAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllowAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowAction"}
	if s.CustomRequestHandling != nil {
		if err := s.CustomRequestHandling.Validate(); err != nil {
			invalidParams.AddNested("CustomRequestHandling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomRequestHandling sets the CustomRequestHandling field's value.
func (s *AllowAction) SetCustomRequestHandling(v *CustomRequestHandling) *AllowAction {
	s.CustomRequestHandling = v
	return s
}

// A logical rule statement used to combine other rule statements with AND logic.
// You provide more than one Statement within the AndStatement.
type AndStatement struct {
	_ struct{} `type:"structure"`

	// The statements to combine with AND logic. You can use any statements that
	// can be nested.
	//
	// Statements is a required field
	Statements []*Statement `type:"list" required:"true"`
}

// String returns the string representation
func (s AndStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AndStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AndStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AndStatement"}
	if s.Statements == nil {
		invalidParams.Add(request.NewErrParamRequired("Statements"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatements sets the Statements field's value.
func (s *AndStatement) SetStatements(v []*Statement) *AndStatement {
	s.Statements = v
	return s
}

type AssociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to associate with the web
	// ACL.
	//
	// The ARN must be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway REST API: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	//    * For an AppSync GraphQL API: arn:aws:appsync:region:account-id:apis/GraphQLApiId
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate
	// with the resource.
	//
	// WebACLArn is a required field
	WebACLArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWebACLInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.WebACLArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLArn"))
	}
	if s.WebACLArn != nil && len(*s.WebACLArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AssociateWebACLInput) SetResourceArn(v string) *AssociateWebACLInput {
	s.ResourceArn = &v
	return s
}

// SetWebACLArn sets the WebACLArn field's value.
func (s *AssociateWebACLInput) SetWebACLArn(v string) *AssociateWebACLInput {
	s.WebACLArn = &v
	return s
}

type AssociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebACLOutput) GoString() string {
	return s.String()
}

// Specifies that WAF should block the request and optionally defines additional
// custom handling for the response to the web request.
//
// This is used in the context of other settings, for example to specify values
// for RuleAction and web ACL DefaultAction.
type BlockAction struct {
	_ struct{} `type:"structure"`

	// Defines a custom response for the web request.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponse *CustomResponse `type:"structure"`
}

// String returns the string representation
func (s BlockAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlockAction"}
	if s.CustomResponse != nil {
		if err := s.CustomResponse.Validate(); err != nil {
			invalidParams.AddNested("CustomResponse", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomResponse sets the CustomResponse field's value.
func (s *BlockAction) SetCustomResponse(v *CustomResponse) *BlockAction {
	s.CustomResponse = v
	return s
}

// The body of a web request. This immediately follows the request headers.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type Body struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Body) GoString() string {
	return s.String()
}

// A rule statement that defines a string match search for WAF to apply to web
// requests. The byte match statement provides the bytes to search for, the
// location in requests that you want WAF to search, and other settings. The
// bytes to search for are typically a string that corresponds with ASCII characters.
// In the WAF console and the developer guide, this is refered to as a string
// match statement.
type ByteMatchStatement struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The area within the portion of a web request that you want WAF to search
	// for SearchString. Valid values include the following:
	//
	// CONTAINS
	//
	// The specified part of the web request must include the value of SearchString,
	// but the location doesn't matter.
	//
	// CONTAINS_WORD
	//
	// The specified part of the web request must include the value of SearchString,
	// and SearchString must contain only alphanumeric characters or underscore
	// (A-Z, a-z, 0-9, or _). In addition, SearchString must be a word, which means
	// that both of the following are true:
	//
	//    * SearchString is at the beginning of the specified part of the web request
	//    or is preceded by a character other than an alphanumeric character or
	//    underscore (_). Examples include the value of a header and ;BadBot.
	//
	//    * SearchString is at the end of the specified part of the web request
	//    or is followed by a character other than an alphanumeric character or
	//    underscore (_), for example, BadBot; and -BadBot;.
	//
	// EXACTLY
	//
	// The value of the specified part of the web request must exactly match the
	// value of SearchString.
	//
	// STARTS_WITH
	//
	// The value of SearchString must appear at the beginning of the specified part
	// of the web request.
	//
	// ENDS_WITH
	//
	// The value of SearchString must appear at the end of the specified part of
	// the web request.
	//
	// PositionalConstraint is a required field
	PositionalConstraint *string `type:"string" required:"true" enum:"PositionalConstraint"`

	// A string value that you want WAF to search for. WAF searches only in the
	// part of web requests that you designate for inspection in FieldToMatch. The
	// maximum length of the value is 50 bytes.
	//
	// Valid values depend on the component that you specify for inspection in FieldToMatch:
	//
	//    * Method: The HTTP method that you want WAF to search for. This indicates
	//    the type of operation specified in the request.
	//
	//    * UriPath: The value that you want WAF to search for in the URI path,
	//    for example, /images/daily-ad.jpg.
	//
	// If SearchString includes alphabetic characters A-Z and a-z, note that the
	// value is case sensitive.
	//
	// If you're using the WAF API
	//
	// Specify a base64-encoded version of the value. The maximum length of the
	// value before you base64-encode it is 50 bytes.
	//
	// For example, suppose the value of Type is HEADER and the value of Data is
	// User-Agent. If you want to search the User-Agent header for the value BadBot,
	// you base64-encode BadBot using MIME base64-encoding and include the resulting
	// value, QmFkQm90, in the value of SearchString.
	//
	// If you're using the CLI or one of the Amazon Web Services SDKs
	//
	// The value that you want WAF to search for. The SDK automatically base64 encodes
	// the value.
	//
	// SearchString is automatically base64 encoded/decoded by the SDK.
	//
	// SearchString is a required field
	SearchString []byte `type:"blob" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []*TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ByteMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ByteMatchStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ByteMatchStatement"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.PositionalConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("PositionalConstraint"))
	}
	if s.SearchString == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchString"))
	}
	if s.TextTransformations == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *ByteMatchStatement) SetFieldToMatch(v *FieldToMatch) *ByteMatchStatement {
	s.FieldToMatch = v
	return s
}

// SetPositionalConstraint sets the PositionalConstraint field's value.
func (s *ByteMatchStatement) SetPositionalConstraint(v string) *ByteMatchStatement {
	s.PositionalConstraint = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *ByteMatchStatement) SetSearchString(v []byte) *ByteMatchStatement {
	s.SearchString = v
	return s
}

// SetTextTransformations sets the TextTransformations field's value.
func (s *ByteMatchStatement) SetTextTransformations(v []*TextTransformation) *ByteMatchStatement {
	s.TextTransformations = v
	return s
}

type CheckCapacityInput struct {
	_ struct{} `type:"structure"`

	// An array of Rule that you're configuring to use in a rule group or web ACL.
	//
	// Rules is a required field
	Rules []*Rule `type:"list" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s CheckCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckCapacityInput"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *CheckCapacityInput) SetRules(v []*Rule) *CheckCapacityInput {
	s.Rules = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CheckCapacityInput) SetScope(v string) *CheckCapacityInput {
	s.Scope = &v
	return s
}

type CheckCapacityOutput struct {
	_ struct{} `type:"structure"`

	// The capacity required by the rules and scope.
	Capacity *int64 `type:"long"`
}

// String returns the string representation
func (s CheckCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckCapacityOutput) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *CheckCapacityOutput) SetCapacity(v int64) *CheckCapacityOutput {
	s.Capacity = &v
	return s
}

// A single match condition for a Filter.
type Condition struct {
	_ struct{} `type:"structure"`

	// A single action condition.
	ActionCondition *ActionCondition `type:"structure"`

	// A single label name condition.
	LabelNameCondition *LabelNameCondition `type:"structure"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.ActionCondition != nil {
		if err := s.ActionCondition.Validate(); err != nil {
			invalidParams.AddNested("ActionCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.LabelNameCondition != nil {
		if err := s.LabelNameCondition.Validate(); err != nil {
			invalidParams.AddNested("LabelNameCondition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionCondition sets the ActionCondition field's value.
func (s *Condition) SetActionCondition(v *ActionCondition) *Condition {
	s.ActionCondition = v
	return s
}

// SetLabelNameCondition sets the LabelNameCondition field's value.
func (s *Condition) SetLabelNameCondition(v *LabelNameCondition) *Condition {
	s.LabelNameCondition = v
	return s
}

// Specifies that WAF should count the request. Optionally defines additional
// custom handling for the request.
//
// This is used in the context of other settings, for example to specify values
// for RuleAction and web ACL DefaultAction.
type CountAction struct {
	_ struct{} `type:"structure"`

	// Defines custom handling for the web request.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomRequestHandling *CustomRequestHandling `type:"structure"`
}

// String returns the string representation
func (s CountAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CountAction"}
	if s.CustomRequestHandling != nil {
		if err := s.CustomRequestHandling.Validate(); err != nil {
			invalidParams.AddNested("CustomRequestHandling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomRequestHandling sets the CustomRequestHandling field's value.
func (s *CountAction) SetCustomRequestHandling(v *CustomRequestHandling) *CountAction {
	s.CustomRequestHandling = v
	return s
}

type CreateIPSetInput struct {
	_ struct{} `type:"structure"`

	// Contains an array of strings that specify one or more IP addresses or blocks
	// of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports
	// all IPv4 and IPv6 CIDR ranges except for /0.
	//
	// Examples:
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff,
	//    specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Addresses is a required field
	Addresses []*string `type:"list" required:"true"`

	// A description of the IP set that helps with identification.
	Description *string `min:"1" type:"string"`

	// The version of the IP addresses, either IPV4 or IPV6.
	//
	// IPAddressVersion is a required field
	IPAddressVersion *string `type:"string" required:"true" enum:"IPAddressVersion"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// An array of key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIPSetInput"}
	if s.Addresses == nil {
		invalidParams.Add(request.NewErrParamRequired("Addresses"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.IPAddressVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("IPAddressVersion"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddresses sets the Addresses field's value.
func (s *CreateIPSetInput) SetAddresses(v []*string) *CreateIPSetInput {
	s.Addresses = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIPSetInput) SetDescription(v string) *CreateIPSetInput {
	s.Description = &v
	return s
}

// SetIPAddressVersion sets the IPAddressVersion field's value.
func (s *CreateIPSetInput) SetIPAddressVersion(v string) *CreateIPSetInput {
	s.IPAddressVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIPSetInput) SetName(v string) *CreateIPSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateIPSetInput) SetScope(v string) *CreateIPSetInput {
	s.Scope = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIPSetInput) SetTags(v []*Tag) *CreateIPSetInput {
	s.Tags = v
	return s
}

type CreateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// High-level information about an IPSet, returned by operations like create
	// and list. This provides information like the ID, that you can use to retrieve
	// and manage an IPSet, and the ARN, that you provide to the IPSetReferenceStatement
	// to use the address set in a Rule.
	Summary *IPSetSummary `type:"structure"`
}

// String returns the string representation
func (s CreateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateIPSetOutput) SetSummary(v *IPSetSummary) *CreateIPSetOutput {
	s.Summary = v
	return s
}

type CreateRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// A description of the set that helps with identification.
	Description *string `min:"1" type:"string"`

	// The name of the set. You cannot change the name after you create the set.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Array of regular expression strings.
	//
	// RegularExpressionList is a required field
	RegularExpressionList []*Regex `type:"list" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// An array of key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRegexPatternSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RegularExpressionList == nil {
		invalidParams.Add(request.NewErrParamRequired("RegularExpressionList"))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.RegularExpressionList != nil {
		for i, v := range s.RegularExpressionList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RegularExpressionList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRegexPatternSetInput) SetDescription(v string) *CreateRegexPatternSetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRegexPatternSetInput) SetName(v string) *CreateRegexPatternSetInput {
	s.Name = &v
	return s
}

// SetRegularExpressionList sets the RegularExpressionList field's value.
func (s *CreateRegexPatternSetInput) SetRegularExpressionList(v []*Regex) *CreateRegexPatternSetInput {
	s.RegularExpressionList = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateRegexPatternSetInput) SetScope(v string) *CreateRegexPatternSetInput {
	s.Scope = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRegexPatternSetInput) SetTags(v []*Tag) *CreateRegexPatternSetInput {
	s.Tags = v
	return s
}

type CreateRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// High-level information about a RegexPatternSet, returned by operations like
	// create and list. This provides information like the ID, that you can use
	// to retrieve and manage a RegexPatternSet, and the ARN, that you provide to
	// the RegexPatternSetReferenceStatement to use the pattern set in a Rule.
	Summary *RegexPatternSetSummary `type:"structure"`
}

// String returns the string representation
func (s CreateRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateRegexPatternSetOutput) SetSummary(v *RegexPatternSetSummary) *CreateRegexPatternSetOutput {
	s.Summary = v
	return s
}

type CreateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The web ACL capacity units (WCUs) required for this rule group.
	//
	// When you create your own rule group, you define this, and you cannot change
	// it after creation. When you add or modify the rules in a rule group, WAF
	// enforces this limit. You can check the capacity for a set of rules using
	// CheckCapacity.
	//
	// WAF uses WCUs to calculate and control the operating resources that are used
	// to run your rules, rule groups, and web ACLs. WAF calculates capacity differently
	// for each rule type, to reflect the relative cost of each rule. Simple rules
	// that cost little to run use fewer WCUs than more complex rules that use more
	// processing power. Rule group capacity is fixed at creation, which helps users
	// plan their web ACL WCU usage when they use a rule group. The WCU limit for
	// web ACLs is 1,500.
	//
	// Capacity is a required field
	Capacity *int64 `min:"1" type:"long" required:"true"`

	// A map of custom response keys and content bodies. When you create a rule
	// with a block action, you can send a custom response to the web request. You
	// define these for the rule group, and then use them in the rules that you
	// define in the rule group.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]*CustomResponseBody `min:"1" type:"map"`

	// A description of the rule group that helps with identification.
	Description *string `min:"1" type:"string"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses
	// to identify matching web requests, and parameters that govern how WAF handles
	// them.
	Rules []*Rule `type:"list"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// An array of key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleGroupInput"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.Capacity != nil && *s.Capacity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Capacity", 1))
	}
	if s.CustomResponseBodies != nil && len(s.CustomResponseBodies) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomResponseBodies", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VisibilityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibilityConfig"))
	}
	if s.CustomResponseBodies != nil {
		for i, v := range s.CustomResponseBodies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomResponseBodies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *CreateRuleGroupInput) SetCapacity(v int64) *CreateRuleGroupInput {
	s.Capacity = &v
	return s
}

// SetCustomResponseBodies sets the CustomResponseBodies field's value.
func (s *CreateRuleGroupInput) SetCustomResponseBodies(v map[string]*CustomResponseBody) *CreateRuleGroupInput {
	s.CustomResponseBodies = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRuleGroupInput) SetDescription(v string) *CreateRuleGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleGroupInput) SetName(v string) *CreateRuleGroupInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateRuleGroupInput) SetRules(v []*Rule) *CreateRuleGroupInput {
	s.Rules = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateRuleGroupInput) SetScope(v string) *CreateRuleGroupInput {
	s.Scope = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleGroupInput) SetTags(v []*Tag) *CreateRuleGroupInput {
	s.Tags = v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *CreateRuleGroupInput) SetVisibilityConfig(v *VisibilityConfig) *CreateRuleGroupInput {
	s.VisibilityConfig = v
	return s
}

type CreateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// High-level information about a RuleGroup, returned by operations like create
	// and list. This provides information like the ID, that you can use to retrieve
	// and manage a RuleGroup, and the ARN, that you provide to the RuleGroupReferenceStatement
	// to use the rule group in a Rule.
	Summary *RuleGroupSummary `type:"structure"`
}

// String returns the string representation
func (s CreateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleGroupOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateRuleGroupOutput) SetSummary(v *RuleGroupSummary) *CreateRuleGroupOutput {
	s.Summary = v
	return s
}

type CreateWebACLInput struct {
	_ struct{} `type:"structure"`

	// A map of custom response keys and content bodies. When you create a rule
	// with a block action, you can send a custom response to the web request. You
	// define these for the web ACL, and then use them in the rules and default
	// actions that you define in the web ACL.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]*CustomResponseBody `min:"1" type:"map"`

	// The action to perform if none of the Rules contained in the WebACL match.
	//
	// DefaultAction is a required field
	DefaultAction *DefaultAction `type:"structure" required:"true"`

	// A description of the web ACL that helps with identification.
	Description *string `min:"1" type:"string"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses
	// to identify matching web requests, and parameters that govern how WAF handles
	// them.
	Rules []*Rule `type:"list"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// An array of key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWebACLInput"}
	if s.CustomResponseBodies != nil && len(s.CustomResponseBodies) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomResponseBodies", 1))
	}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VisibilityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibilityConfig"))
	}
	if s.CustomResponseBodies != nil {
		for i, v := range s.CustomResponseBodies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomResponseBodies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DefaultAction != nil {
		if err := s.DefaultAction.Validate(); err != nil {
			invalidParams.AddNested("DefaultAction", err.(request.ErrInvalidParams))
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomResponseBodies sets the CustomResponseBodies field's value.
func (s *CreateWebACLInput) SetCustomResponseBodies(v map[string]*CustomResponseBody) *CreateWebACLInput {
	s.CustomResponseBodies = v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *CreateWebACLInput) SetDefaultAction(v *DefaultAction) *CreateWebACLInput {
	s.DefaultAction = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWebACLInput) SetDescription(v string) *CreateWebACLInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWebACLInput) SetName(v string) *CreateWebACLInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateWebACLInput) SetRules(v []*Rule) *CreateWebACLInput {
	s.Rules = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateWebACLInput) SetScope(v string) *CreateWebACLInput {
	s.Scope = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWebACLInput) SetTags(v []*Tag) *CreateWebACLInput {
	s.Tags = v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *CreateWebACLInput) SetVisibilityConfig(v *VisibilityConfig) *CreateWebACLInput {
	s.VisibilityConfig = v
	return s
}

type CreateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// High-level information about a WebACL, returned by operations like create
	// and list. This provides information like the ID, that you can use to retrieve
	// and manage a WebACL, and the ARN, that you provide to operations like AssociateWebACL.
	Summary *WebACLSummary `type:"structure"`
}

// String returns the string representation
func (s CreateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebACLOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateWebACLOutput) SetSummary(v *WebACLSummary) *CreateWebACLOutput {
	s.Summary = v
	return s
}

// A custom header for custom request and response handling. This is used in
// CustomResponse and CustomRequestHandling.
type CustomHTTPHeader struct {
	_ struct{} `type:"structure"`

	// The name of the custom header.
	//
	// For custom request header insertion, when WAF inserts the header into the
	// request, it prefixes this name x-amzn-waf-, to avoid confusion with the headers
	// that are already in the request. For example, for the header name sample,
	// WAF inserts the header x-amzn-waf-sample.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the custom header.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomHTTPHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHTTPHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomHTTPHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomHTTPHeader"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CustomHTTPHeader) SetName(v string) *CustomHTTPHeader {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomHTTPHeader) SetValue(v string) *CustomHTTPHeader {
	s.Value = &v
	return s
}

// Custom request handling behavior that inserts custom headers into a web request.
// You can add custom request handling for the rule actions allow and count.
//
// For information about customizing web requests and responses, see Customizing
// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
type CustomRequestHandling struct {
	_ struct{} `type:"structure"`

	// The HTTP headers to insert into the request. Duplicate header names are not
	// allowed.
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// InsertHeaders is a required field
	InsertHeaders []*CustomHTTPHeader `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CustomRequestHandling) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomRequestHandling) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomRequestHandling) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomRequestHandling"}
	if s.InsertHeaders == nil {
		invalidParams.Add(request.NewErrParamRequired("InsertHeaders"))
	}
	if s.InsertHeaders != nil && len(s.InsertHeaders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsertHeaders", 1))
	}
	if s.InsertHeaders != nil {
		for i, v := range s.InsertHeaders {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InsertHeaders", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsertHeaders sets the InsertHeaders field's value.
func (s *CustomRequestHandling) SetInsertHeaders(v []*CustomHTTPHeader) *CustomRequestHandling {
	s.InsertHeaders = v
	return s
}

// A custom response to send to the client. You can define a custom response
// for rule actions and default web ACL actions that are set to BlockAction.
//
// For information about customizing web requests and responses, see Customizing
// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
type CustomResponse struct {
	_ struct{} `type:"structure"`

	// References the response body that you want WAF to return to the web request
	// client. You can define a custom response for a rule action or a default web
	// ACL action that is set to block. To do this, you first define the response
	// body key and value in the CustomResponseBodies setting for the WebACL or
	// RuleGroup where you want to use it. Then, in the rule action or web ACL default
	// action BlockAction setting, you reference the response body using this key.
	CustomResponseBodyKey *string `min:"1" type:"string"`

	// The HTTP status code to return to the client.
	//
	// For a list of status codes that you can use in your custom reqponses, see
	// Supported status codes for custom response (https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// ResponseCode is a required field
	ResponseCode *int64 `min:"200" type:"integer" required:"true"`

	// The HTTP headers to use in the response. Duplicate header names are not allowed.
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	ResponseHeaders []*CustomHTTPHeader `min:"1" type:"list"`
}

// String returns the string representation
func (s CustomResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomResponse) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomResponse) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomResponse"}
	if s.CustomResponseBodyKey != nil && len(*s.CustomResponseBodyKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomResponseBodyKey", 1))
	}
	if s.ResponseCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponseCode"))
	}
	if s.ResponseCode != nil && *s.ResponseCode < 200 {
		invalidParams.Add(request.NewErrParamMinValue("ResponseCode", 200))
	}
	if s.ResponseHeaders != nil && len(s.ResponseHeaders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseHeaders", 1))
	}
	if s.ResponseHeaders != nil {
		for i, v := range s.ResponseHeaders {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResponseHeaders", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomResponseBodyKey sets the CustomResponseBodyKey field's value.
func (s *CustomResponse) SetCustomResponseBodyKey(v string) *CustomResponse {
	s.CustomResponseBodyKey = &v
	return s
}

// SetResponseCode sets the ResponseCode field's value.
func (s *CustomResponse) SetResponseCode(v int64) *CustomResponse {
	s.ResponseCode = &v
	return s
}

// SetResponseHeaders sets the ResponseHeaders field's value.
func (s *CustomResponse) SetResponseHeaders(v []*CustomHTTPHeader) *CustomResponse {
	s.ResponseHeaders = v
	return s
}

// The response body to use in a custom response to a web request. This is referenced
// by key from CustomResponse CustomResponseBodyKey.
type CustomResponseBody struct {
	_ struct{} `type:"structure"`

	// The payload of the custom response.
	//
	// You can use JSON escape strings in JSON content. To do this, you must specify
	// JSON content in the ContentType setting.
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The type of content in the payload that you are defining in the Content string.
	//
	// ContentType is a required field
	ContentType *string `type:"string" required:"true" enum:"ResponseContentType"`
}

// String returns the string representation
func (s CustomResponseBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomResponseBody) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomResponseBody) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomResponseBody"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CustomResponseBody) SetContent(v string) *CustomResponseBody {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CustomResponseBody) SetContentType(v string) *CustomResponseBody {
	s.ContentType = &v
	return s
}

// In a WebACL, this is the action that you want WAF to perform when a web request
// doesn't match any of the rules in the WebACL. The default action must be
// a terminating action, so you can't use count.
type DefaultAction struct {
	_ struct{} `type:"structure"`

	// Specifies that WAF should allow requests by default.
	Allow *AllowAction `type:"structure"`

	// Specifies that WAF should block requests by default.
	Block *BlockAction `type:"structure"`
}

// String returns the string representation
func (s DefaultAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefaultAction"}
	if s.Allow != nil {
		if err := s.Allow.Validate(); err != nil {
			invalidParams.AddNested("Allow", err.(request.ErrInvalidParams))
		}
	}
	if s.Block != nil {
		if err := s.Block.Validate(); err != nil {
			invalidParams.AddNested("Block", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllow sets the Allow field's value.
func (s *DefaultAction) SetAllow(v *AllowAction) *DefaultAction {
	s.Allow = v
	return s
}

// SetBlock sets the Block field's value.
func (s *DefaultAction) SetBlock(v *BlockAction) *DefaultAction {
	s.Block = v
	return s
}

type DeleteFirewallManagerRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the web ACL.
	//
	// WebACLArn is a required field
	WebACLArn *string `min:"20" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// WebACLLockToken is a required field
	WebACLLockToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFirewallManagerRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFirewallManagerRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFirewallManagerRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFirewallManagerRuleGroupsInput"}
	if s.WebACLArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLArn"))
	}
	if s.WebACLArn != nil && len(*s.WebACLArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLArn", 20))
	}
	if s.WebACLLockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLLockToken"))
	}
	if s.WebACLLockToken != nil && len(*s.WebACLLockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLLockToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWebACLArn sets the WebACLArn field's value.
func (s *DeleteFirewallManagerRuleGroupsInput) SetWebACLArn(v string) *DeleteFirewallManagerRuleGroupsInput {
	s.WebACLArn = &v
	return s
}

// SetWebACLLockToken sets the WebACLLockToken field's value.
func (s *DeleteFirewallManagerRuleGroupsInput) SetWebACLLockToken(v string) *DeleteFirewallManagerRuleGroupsInput {
	s.WebACLLockToken = &v
	return s
}

type DeleteFirewallManagerRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	NextWebACLLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFirewallManagerRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFirewallManagerRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetNextWebACLLockToken sets the NextWebACLLockToken field's value.
func (s *DeleteFirewallManagerRuleGroupsOutput) SetNextWebACLLockToken(v string) *DeleteFirewallManagerRuleGroupsOutput {
	s.NextWebACLLockToken = &v
	return s
}

type DeleteIPSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s DeleteIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIPSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteIPSetInput) SetId(v string) *DeleteIPSetInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *DeleteIPSetInput) SetLockToken(v string) *DeleteIPSetInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteIPSetInput) SetName(v string) *DeleteIPSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *DeleteIPSetInput) SetScope(v string) *DeleteIPSetInput {
	s.Scope = &v
	return s
}

type DeleteIPSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetOutput) GoString() string {
	return s.String()
}

type DeleteLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the web ACL from which you want to delete
	// the LoggingConfiguration.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoggingConfigurationInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteLoggingConfigurationInput) SetResourceArn(v string) *DeleteLoggingConfigurationInput {
	s.ResourceArn = &v
	return s
}

type DeleteLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggingConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePermissionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group from which you want to delete
	// the policy.
	//
	// You must be the owner of the rule group to perform this operation.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePermissionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionPolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeletePermissionPolicyInput) SetResourceArn(v string) *DeletePermissionPolicyInput {
	s.ResourceArn = &v
	return s
}

type DeletePermissionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePermissionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionPolicyOutput) GoString() string {
	return s.String()
}

type DeleteRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the set. You cannot change the name after you create the set.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s DeleteRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRegexPatternSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteRegexPatternSetInput) SetId(v string) *DeleteRegexPatternSetInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *DeleteRegexPatternSetInput) SetLockToken(v string) *DeleteRegexPatternSetInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteRegexPatternSetInput) SetName(v string) *DeleteRegexPatternSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *DeleteRegexPatternSetInput) SetScope(v string) *DeleteRegexPatternSetInput {
	s.Scope = &v
	return s
}

type DeleteRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegexPatternSetOutput) GoString() string {
	return s.String()
}

type DeleteRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s DeleteRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteRuleGroupInput) SetId(v string) *DeleteRuleGroupInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *DeleteRuleGroupInput) SetLockToken(v string) *DeleteRuleGroupInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteRuleGroupInput) SetName(v string) *DeleteRuleGroupInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *DeleteRuleGroupInput) SetScope(v string) *DeleteRuleGroupInput {
	s.Scope = &v
	return s
}

type DeleteRuleGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleGroupOutput) GoString() string {
	return s.String()
}

type DeleteWebACLInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s DeleteWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWebACLInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWebACLInput) SetId(v string) *DeleteWebACLInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *DeleteWebACLInput) SetLockToken(v string) *DeleteWebACLInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteWebACLInput) SetName(v string) *DeleteWebACLInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *DeleteWebACLInput) SetScope(v string) *DeleteWebACLInput {
	s.Scope = &v
	return s
}

type DeleteWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebACLOutput) GoString() string {
	return s.String()
}

type DescribeManagedRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	//
	// VendorName is a required field
	VendorName *string `min:"1" type:"string" required:"true"`

	// The version of the rule group. You can only use a version that is not scheduled
	// for expiration. If you don't provide this, WAF uses the vendor's default
	// version.
	VersionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeManagedRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeManagedRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeManagedRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeManagedRuleGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.VendorName == nil {
		invalidParams.Add(request.NewErrParamRequired("VendorName"))
	}
	if s.VendorName != nil && len(*s.VendorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorName", 1))
	}
	if s.VersionName != nil && len(*s.VersionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeManagedRuleGroupInput) SetName(v string) *DescribeManagedRuleGroupInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *DescribeManagedRuleGroupInput) SetScope(v string) *DescribeManagedRuleGroupInput {
	s.Scope = &v
	return s
}

// SetVendorName sets the VendorName field's value.
func (s *DescribeManagedRuleGroupInput) SetVendorName(v string) *DescribeManagedRuleGroupInput {
	s.VendorName = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DescribeManagedRuleGroupInput) SetVersionName(v string) *DescribeManagedRuleGroupInput {
	s.VersionName = &v
	return s
}

type DescribeManagedRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The labels that one or more rules in this rule group add to matching web
	// requests. These labels are defined in the RuleLabels for a Rule.
	AvailableLabels []*LabelSummary `type:"list"`

	// The web ACL capacity units (WCUs) required for this rule group. WAF uses
	// web ACL capacity units (WCU) to calculate and control the operating resources
	// that are used to run your rules, rule groups, and web ACLs. WAF calculates
	// capacity differently for each rule type, to reflect each rule's relative
	// cost. Rule group capacity is fixed at creation, so users can plan their web
	// ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
	Capacity *int64 `min:"1" type:"long"`

	// The labels that one or more rules in this rule group match against in label
	// match statements. These labels are defined in a LabelMatchStatement specification,
	// in the Statement definition of a rule.
	ConsumedLabels []*LabelSummary `type:"list"`

	// The label namespace prefix for this rule group. All labels added by rules
	// in this rule group have this prefix.
	//
	//    * The syntax for the label namespace prefix for a managed rule group is
	//    the following: awswaf:managed:<vendor>:<rule group name>:
	//
	//    * When a rule with a label matches a web request, WAF adds the fully qualified
	//    label to the request. A fully qualified label is made up of the label
	//    namespace from the rule group or web ACL where the rule is defined and
	//    the label from the rule, separated by a colon: <label namespace>:<label
	//    from rule>
	LabelNamespace *string `min:"1" type:"string"`

	Rules []*RuleSummary `type:"list"`

	// The Amazon resource name (ARN) of the Amazon Simple Notification Service
	// SNS topic that's used to record changes to the managed rule group. You can
	// subscribe to the SNS topic to receive notifications when the managed rule
	// group is modified, such as for new versions and for version expiration. For
	// more information, see the Amazon Simple Notification Service Developer Guide
	// (https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
	SnsTopicArn *string `min:"20" type:"string"`

	// The managed rule group's version.
	VersionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeManagedRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeManagedRuleGroupOutput) GoString() string {
	return s.String()
}

// SetAvailableLabels sets the AvailableLabels field's value.
func (s *DescribeManagedRuleGroupOutput) SetAvailableLabels(v []*LabelSummary) *DescribeManagedRuleGroupOutput {
	s.AvailableLabels = v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *DescribeManagedRuleGroupOutput) SetCapacity(v int64) *DescribeManagedRuleGroupOutput {
	s.Capacity = &v
	return s
}

// SetConsumedLabels sets the ConsumedLabels field's value.
func (s *DescribeManagedRuleGroupOutput) SetConsumedLabels(v []*LabelSummary) *DescribeManagedRuleGroupOutput {
	s.ConsumedLabels = v
	return s
}

// SetLabelNamespace sets the LabelNamespace field's value.
func (s *DescribeManagedRuleGroupOutput) SetLabelNamespace(v string) *DescribeManagedRuleGroupOutput {
	s.LabelNamespace = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *DescribeManagedRuleGroupOutput) SetRules(v []*RuleSummary) *DescribeManagedRuleGroupOutput {
	s.Rules = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *DescribeManagedRuleGroupOutput) SetSnsTopicArn(v string) *DescribeManagedRuleGroupOutput {
	s.SnsTopicArn = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DescribeManagedRuleGroupOutput) SetVersionName(v string) *DescribeManagedRuleGroupOutput {
	s.VersionName = &v
	return s
}

type DisassociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to disassociate from the web
	// ACL.
	//
	// The ARN must be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway REST API: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	//    * For an AppSync GraphQL API: arn:aws:appsync:region:account-id:apis/GraphQLApiId
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWebACLInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DisassociateWebACLInput) SetResourceArn(v string) *DisassociateWebACLInput {
	s.ResourceArn = &v
	return s
}

type DisassociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebACLOutput) GoString() string {
	return s.String()
}

// Specifies a single rule to exclude from the rule group. Excluding a rule
// overrides its action setting for the rule group in the web ACL, setting it
// to COUNT. This effectively excludes the rule from acting on web requests.
type ExcludedRule struct {
	_ struct{} `type:"structure"`

	// The name of the rule to exclude.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExcludedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExcludedRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExcludedRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExcludedRule"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ExcludedRule) SetName(v string) *ExcludedRule {
	s.Name = &v
	return s
}

// The part of a web request that you want WAF to inspect. Include the single
// FieldToMatch type that you want to inspect, with additional specifications
// as needed, according to the type. You specify a single request component
// in FieldToMatch for each rule statement that requires it. To inspect more
// than one component of a web request, create a separate rule statement for
// each component.
type FieldToMatch struct {
	_ struct{} `type:"structure"`

	// Inspect all query arguments.
	AllQueryArguments *AllQueryArguments `type:"structure"`

	// Inspect the request body as plain text. The request body immediately follows
	// the request headers. This is the part of a request that contains any additional
	// data that you want to send to your web server as the HTTP request body, such
	// as data from a form.
	//
	// Note that only the first 8 KB (8192 bytes) of the request body are forwarded
	// to WAF for inspection by the underlying host service. If you don't need to
	// inspect more than 8 KB, you can guarantee that you don't allow additional
	// bytes in by combining a statement that inspects the body of the web request,
	// such as ByteMatchStatement or RegexPatternSetReferenceStatement, with a SizeConstraintStatement
	// that enforces an 8 KB size limit on the body of the request. WAF doesn't
	// support inspecting the entire contents of web requests whose bodies exceed
	// the 8 KB limit.
	Body *Body `type:"structure"`

	// Inspect the request body as JSON. The request body immediately follows the
	// request headers. This is the part of a request that contains any additional
	// data that you want to send to your web server as the HTTP request body, such
	// as data from a form.
	//
	// Note that only the first 8 KB (8192 bytes) of the request body are forwarded
	// to WAF for inspection by the underlying host service. If you don't need to
	// inspect more than 8 KB, you can guarantee that you don't allow additional
	// bytes in by combining a statement that inspects the body of the web request,
	// such as ByteMatchStatement or RegexPatternSetReferenceStatement, with a SizeConstraintStatement
	// that enforces an 8 KB size limit on the body of the request. WAF doesn't
	// support inspecting the entire contents of web requests whose bodies exceed
	// the 8 KB limit.
	JsonBody *JsonBody `type:"structure"`

	// Inspect the HTTP method. The method indicates the type of operation that
	// the request is asking the origin to perform.
	Method *Method `type:"structure"`

	// Inspect the query string. This is the part of a URL that appears after a
	// ? character, if any.
	QueryString *QueryString `type:"structure"`

	// Inspect a single header. Provide the name of the header to inspect, for example,
	// User-Agent or Referer. This setting isn't case sensitive.
	//
	// Example JSON: "SingleHeader": { "Name": "haystack" }
	SingleHeader *SingleHeader `type:"structure"`

	// Inspect a single query argument. Provide the name of the query argument to
	// inspect, such as UserName or SalesRegion. The name can be up to 30 characters
	// long and isn't case sensitive.
	//
	// This is used only to indicate the web request component for WAF to inspect,
	// in the FieldToMatch specification.
	//
	// Example JSON: "SingleQueryArgument": { "Name": "myArgument" }
	SingleQueryArgument *SingleQueryArgument `type:"structure"`

	// Inspect the request URI path. This is the part of a web request that identifies
	// a resource, for example, /images/daily-ad.jpg.
	UriPath *UriPath `type:"structure"`
}

// String returns the string representation
func (s FieldToMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldToMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldToMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldToMatch"}
	if s.JsonBody != nil {
		if err := s.JsonBody.Validate(); err != nil {
			invalidParams.AddNested("JsonBody", err.(request.ErrInvalidParams))
		}
	}
	if s.SingleHeader != nil {
		if err := s.SingleHeader.Validate(); err != nil {
			invalidParams.AddNested("SingleHeader", err.(request.ErrInvalidParams))
		}
	}
	if s.SingleQueryArgument != nil {
		if err := s.SingleQueryArgument.Validate(); err != nil {
			invalidParams.AddNested("SingleQueryArgument", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllQueryArguments sets the AllQueryArguments field's value.
func (s *FieldToMatch) SetAllQueryArguments(v *AllQueryArguments) *FieldToMatch {
	s.AllQueryArguments = v
	return s
}

// SetBody sets the Body field's value.
func (s *FieldToMatch) SetBody(v *Body) *FieldToMatch {
	s.Body = v
	return s
}

// SetJsonBody sets the JsonBody field's value.
func (s *FieldToMatch) SetJsonBody(v *JsonBody) *FieldToMatch {
	s.JsonBody = v
	return s
}

// SetMethod sets the Method field's value.
func (s *FieldToMatch) SetMethod(v *Method) *FieldToMatch {
	s.Method = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *FieldToMatch) SetQueryString(v *QueryString) *FieldToMatch {
	s.QueryString = v
	return s
}

// SetSingleHeader sets the SingleHeader field's value.
func (s *FieldToMatch) SetSingleHeader(v *SingleHeader) *FieldToMatch {
	s.SingleHeader = v
	return s
}

// SetSingleQueryArgument sets the SingleQueryArgument field's value.
func (s *FieldToMatch) SetSingleQueryArgument(v *SingleQueryArgument) *FieldToMatch {
	s.SingleQueryArgument = v
	return s
}

// SetUriPath sets the UriPath field's value.
func (s *FieldToMatch) SetUriPath(v *UriPath) *FieldToMatch {
	s.UriPath = v
	return s
}

// A single logging filter, used in LoggingFilter.
type Filter struct {
	_ struct{} `type:"structure"`

	// How to handle logs that satisfy the filter's conditions and requirement.
	//
	// Behavior is a required field
	Behavior *string `type:"string" required:"true" enum:"FilterBehavior"`

	// Match conditions for the filter.
	//
	// Conditions is a required field
	Conditions []*Condition `min:"1" type:"list" required:"true"`

	// Logic to apply to the filtering conditions. You can specify that, in order
	// to satisfy the filter, a log must match all conditions or must match at least
	// one condition.
	//
	// Requirement is a required field
	Requirement *string `type:"string" required:"true" enum:"FilterRequirement"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Behavior == nil {
		invalidParams.Add(request.NewErrParamRequired("Behavior"))
	}
	if s.Conditions == nil {
		invalidParams.Add(request.NewErrParamRequired("Conditions"))
	}
	if s.Conditions != nil && len(s.Conditions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Conditions", 1))
	}
	if s.Requirement == nil {
		invalidParams.Add(request.NewErrParamRequired("Requirement"))
	}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBehavior sets the Behavior field's value.
func (s *Filter) SetBehavior(v string) *Filter {
	s.Behavior = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *Filter) SetConditions(v []*Condition) *Filter {
	s.Conditions = v
	return s
}

// SetRequirement sets the Requirement field's value.
func (s *Filter) SetRequirement(v string) *Filter {
	s.Requirement = &v
	return s
}

// A rule group that's defined for an Firewall Manager WAF policy.
type FirewallManagerRuleGroup struct {
	_ struct{} `type:"structure"`

	// The processing guidance for an Firewall Manager rule. This is like a regular
	// rule Statement, but it can only contain a rule group reference.
	//
	// FirewallManagerStatement is a required field
	FirewallManagerStatement *FirewallManagerStatement `type:"structure" required:"true"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The override action to apply to the rules in a rule group. Used only for
	// rule statements that reference a rule group, like RuleGroupReferenceStatement
	// and ManagedRuleGroupStatement.
	//
	// Set the override action to none to leave the rule actions in effect. Set
	// it to count to only count matches, regardless of the rule action settings.
	//
	// In a Rule, you must specify either this OverrideAction setting or the rule
	// Action setting, but not both:
	//
	//    * If the rule statement references a rule group, use this override action
	//    setting and not the action setting.
	//
	//    * If the rule statement does not reference a rule group, use the rule
	//    action setting and not this rule override action setting.
	//
	// OverrideAction is a required field
	OverrideAction *OverrideAction `type:"structure" required:"true"`

	// If you define more than one rule group in the first or last Firewall Manager
	// rule groups, WAF evaluates each request against the rule groups in order,
	// starting from the lowest priority setting. The priorities don't need to be
	// consecutive, but they must all be different.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s FirewallManagerRuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FirewallManagerRuleGroup) GoString() string {
	return s.String()
}

// SetFirewallManagerStatement sets the FirewallManagerStatement field's value.
func (s *FirewallManagerRuleGroup) SetFirewallManagerStatement(v *FirewallManagerStatement) *FirewallManagerRuleGroup {
	s.FirewallManagerStatement = v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallManagerRuleGroup) SetName(v string) *FirewallManagerRuleGroup {
	s.Name = &v
	return s
}

// SetOverrideAction sets the OverrideAction field's value.
func (s *FirewallManagerRuleGroup) SetOverrideAction(v *OverrideAction) *FirewallManagerRuleGroup {
	s.OverrideAction = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *FirewallManagerRuleGroup) SetPriority(v int64) *FirewallManagerRuleGroup {
	s.Priority = &v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *FirewallManagerRuleGroup) SetVisibilityConfig(v *VisibilityConfig) *FirewallManagerRuleGroup {
	s.VisibilityConfig = v
	return s
}

// The processing guidance for an Firewall Manager rule. This is like a regular
// rule Statement, but it can only contain a rule group reference.
type FirewallManagerStatement struct {
	_ struct{} `type:"structure"`

	// A rule statement used to run the rules that are defined in a managed rule
	// group. To use this, provide the vendor name and the name of the rule group
	// in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
	//
	// You cannot nest a ManagedRuleGroupStatement, for example for use inside a
	// NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	ManagedRuleGroupStatement *ManagedRuleGroupStatement `type:"structure"`

	// A rule statement used to run the rules that are defined in a RuleGroup. To
	// use this, create a rule group with your rules, then provide the ARN of the
	// rule group in this statement.
	//
	// You cannot nest a RuleGroupReferenceStatement, for example for use inside
	// a NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	RuleGroupReferenceStatement *RuleGroupReferenceStatement `type:"structure"`
}

// String returns the string representation
func (s FirewallManagerStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FirewallManagerStatement) GoString() string {
	return s.String()
}

// SetManagedRuleGroupStatement sets the ManagedRuleGroupStatement field's value.
func (s *FirewallManagerStatement) SetManagedRuleGroupStatement(v *ManagedRuleGroupStatement) *FirewallManagerStatement {
	s.ManagedRuleGroupStatement = v
	return s
}

// SetRuleGroupReferenceStatement sets the RuleGroupReferenceStatement field's value.
func (s *FirewallManagerStatement) SetRuleGroupReferenceStatement(v *RuleGroupReferenceStatement) *FirewallManagerStatement {
	s.RuleGroupReferenceStatement = v
	return s
}

// The configuration for inspecting IP addresses in an HTTP header that you
// specify, instead of using the IP address that's reported by the web request
// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
// any header name.
//
// If the specified header isn't present in the request, WAF doesn't apply the
// rule to the web request at all.
//
// This configuration is used for GeoMatchStatement and RateBasedStatement.
// For IPSetReferenceStatement, use IPSetForwardedIPConfig instead.
//
// WAF only evaluates the first IP address found in the specified HTTP header.
type ForwardedIPConfig struct {
	_ struct{} `type:"structure"`

	// The match status to assign to the web request if the request doesn't have
	// a valid IP address in the specified position.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	//
	// You can specify the following fallback behaviors:
	//
	//    * MATCH - Treat the web request as matching the rule statement. WAF applies
	//    the rule action to the request.
	//
	//    * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// FallbackBehavior is a required field
	FallbackBehavior *string `type:"string" required:"true" enum:"FallbackBehavior"`

	// The name of the HTTP header to use for the IP address. For example, to use
	// the X-Forwarded-For (XFF) header, set this to X-Forwarded-For.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	//
	// HeaderName is a required field
	HeaderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForwardedIPConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardedIPConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardedIPConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForwardedIPConfig"}
	if s.FallbackBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("FallbackBehavior"))
	}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderName != nil && len(*s.HeaderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HeaderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFallbackBehavior sets the FallbackBehavior field's value.
func (s *ForwardedIPConfig) SetFallbackBehavior(v string) *ForwardedIPConfig {
	s.FallbackBehavior = &v
	return s
}

// SetHeaderName sets the HeaderName field's value.
func (s *ForwardedIPConfig) SetHeaderName(v string) *ForwardedIPConfig {
	s.HeaderName = &v
	return s
}

// A rule statement used to identify web requests based on country of origin.
type GeoMatchStatement struct {
	_ struct{} `type:"structure"`

	// An array of two-character country codes, for example, [ "US", "CN" ], from
	// the alpha-2 country ISO codes of the ISO 3166 international standard.
	CountryCodes []*string `min:"1" type:"list"`

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	ForwardedIPConfig *ForwardedIPConfig `type:"structure"`
}

// String returns the string representation
func (s GeoMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoMatchStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoMatchStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoMatchStatement"}
	if s.CountryCodes != nil && len(s.CountryCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCodes", 1))
	}
	if s.ForwardedIPConfig != nil {
		if err := s.ForwardedIPConfig.Validate(); err != nil {
			invalidParams.AddNested("ForwardedIPConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountryCodes sets the CountryCodes field's value.
func (s *GeoMatchStatement) SetCountryCodes(v []*string) *GeoMatchStatement {
	s.CountryCodes = v
	return s
}

// SetForwardedIPConfig sets the ForwardedIPConfig field's value.
func (s *GeoMatchStatement) SetForwardedIPConfig(v *ForwardedIPConfig) *GeoMatchStatement {
	s.ForwardedIPConfig = v
	return s
}

type GetIPSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s GetIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIPSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetIPSetInput) SetId(v string) *GetIPSetInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetIPSetInput) SetName(v string) *GetIPSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetIPSetInput) SetScope(v string) *GetIPSetInput {
	s.Scope = &v
	return s
}

type GetIPSetOutput struct {
	_ struct{} `type:"structure"`

	// Contains one or more IP addresses or blocks of IP addresses specified in
	// Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and
	// IPv6 CIDR ranges except for /0. For information about CIDR notation, see
	// the Wikipedia entry Classless Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// WAF assigns an ARN to each IPSet that you create. To use an IP set in a rule,
	// you provide the ARN to the Rule statement IPSetReferenceStatement.
	IPSet *IPSet `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetOutput) GoString() string {
	return s.String()
}

// SetIPSet sets the IPSet field's value.
func (s *GetIPSetOutput) SetIPSet(v *IPSet) *GetIPSetOutput {
	s.IPSet = v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *GetIPSetOutput) SetLockToken(v string) *GetIPSetOutput {
	s.LockToken = &v
	return s
}

type GetLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the web ACL for which you want to get the
	// LoggingConfiguration.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggingConfigurationInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetLoggingConfigurationInput) SetResourceArn(v string) *GetLoggingConfigurationInput {
	s.ResourceArn = &v
	return s
}

type GetLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The LoggingConfiguration for the specified web ACL.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *GetLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *GetLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type GetManagedRuleSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the managed rule set. The ID is returned in the responses
	// to commands like list. You provide it to operations like get and update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the managed rule set. You use this, along with the rule set ID,
	// to identify the rule set.
	//
	// This name is assigned to the corresponding managed rule group, which your
	// customers can access and use.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s GetManagedRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetManagedRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetManagedRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetManagedRuleSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetManagedRuleSetInput) SetId(v string) *GetManagedRuleSetInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetManagedRuleSetInput) SetName(v string) *GetManagedRuleSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetManagedRuleSetInput) SetScope(v string) *GetManagedRuleSetInput {
	s.Scope = &v
	return s
}

type GetManagedRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The managed rule set that you requested.
	ManagedRuleSet *ManagedRuleSet `type:"structure"`
}

// String returns the string representation
func (s GetManagedRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetManagedRuleSetOutput) GoString() string {
	return s.String()
}

// SetLockToken sets the LockToken field's value.
func (s *GetManagedRuleSetOutput) SetLockToken(v string) *GetManagedRuleSetOutput {
	s.LockToken = &v
	return s
}

// SetManagedRuleSet sets the ManagedRuleSet field's value.
func (s *GetManagedRuleSetOutput) SetManagedRuleSet(v *ManagedRuleSet) *GetManagedRuleSetOutput {
	s.ManagedRuleSet = v
	return s
}

type GetPermissionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group for which you want to get
	// the policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPermissionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPermissionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPermissionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPermissionPolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetPermissionPolicyInput) SetResourceArn(v string) *GetPermissionPolicyInput {
	s.ResourceArn = &v
	return s
}

type GetPermissionPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The IAM policy that is attached to the specified rule group.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetPermissionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPermissionPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPermissionPolicyOutput) SetPolicy(v string) *GetPermissionPolicyOutput {
	s.Policy = &v
	return s
}

type GetRateBasedStatementManagedKeysInput struct {
	_ struct{} `type:"structure"`

	// The name of the rate-based rule to get the keys for.
	//
	// RuleName is a required field
	RuleName *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// The unique identifier for the web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// WebACLName is a required field
	WebACLName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRateBasedStatementManagedKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRateBasedStatementManagedKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRateBasedStatementManagedKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRateBasedStatementManagedKeysInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}
	if s.WebACLName == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLName"))
	}
	if s.WebACLName != nil && len(*s.WebACLName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *GetRateBasedStatementManagedKeysInput) SetRuleName(v string) *GetRateBasedStatementManagedKeysInput {
	s.RuleName = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetRateBasedStatementManagedKeysInput) SetScope(v string) *GetRateBasedStatementManagedKeysInput {
	s.Scope = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *GetRateBasedStatementManagedKeysInput) SetWebACLId(v string) *GetRateBasedStatementManagedKeysInput {
	s.WebACLId = &v
	return s
}

// SetWebACLName sets the WebACLName field's value.
func (s *GetRateBasedStatementManagedKeysInput) SetWebACLName(v string) *GetRateBasedStatementManagedKeysInput {
	s.WebACLName = &v
	return s
}

type GetRateBasedStatementManagedKeysOutput struct {
	_ struct{} `type:"structure"`

	// The keys that are of Internet Protocol version 4 (IPv4).
	ManagedKeysIPV4 *RateBasedStatementManagedKeysIPSet `type:"structure"`

	// The keys that are of Internet Protocol version 6 (IPv6).
	ManagedKeysIPV6 *RateBasedStatementManagedKeysIPSet `type:"structure"`
}

// String returns the string representation
func (s GetRateBasedStatementManagedKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRateBasedStatementManagedKeysOutput) GoString() string {
	return s.String()
}

// SetManagedKeysIPV4 sets the ManagedKeysIPV4 field's value.
func (s *GetRateBasedStatementManagedKeysOutput) SetManagedKeysIPV4(v *RateBasedStatementManagedKeysIPSet) *GetRateBasedStatementManagedKeysOutput {
	s.ManagedKeysIPV4 = v
	return s
}

// SetManagedKeysIPV6 sets the ManagedKeysIPV6 field's value.
func (s *GetRateBasedStatementManagedKeysOutput) SetManagedKeysIPV6(v *RateBasedStatementManagedKeysIPSet) *GetRateBasedStatementManagedKeysOutput {
	s.ManagedKeysIPV6 = v
	return s
}

type GetRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the set. You cannot change the name after you create the set.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s GetRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRegexPatternSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetRegexPatternSetInput) SetId(v string) *GetRegexPatternSetInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRegexPatternSetInput) SetName(v string) *GetRegexPatternSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetRegexPatternSetInput) SetScope(v string) *GetRegexPatternSetInput {
	s.Scope = &v
	return s
}

type GetRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// Contains one or more regular expressions.
	//
	// WAF assigns an ARN to each RegexPatternSet that you create. To use a set
	// in a rule, you provide the ARN to the Rule statement RegexPatternSetReferenceStatement.
	RegexPatternSet *RegexPatternSet `type:"structure"`
}

// String returns the string representation
func (s GetRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetLockToken sets the LockToken field's value.
func (s *GetRegexPatternSetOutput) SetLockToken(v string) *GetRegexPatternSetOutput {
	s.LockToken = &v
	return s
}

// SetRegexPatternSet sets the RegexPatternSet field's value.
func (s *GetRegexPatternSetOutput) SetRegexPatternSet(v *RegexPatternSet) *GetRegexPatternSetOutput {
	s.RegexPatternSet = v
	return s
}

type GetRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"1" type:"string"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	Name *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	Scope *string `type:"string" enum:"Scope"`
}

// String returns the string representation
func (s GetRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleGroupInput"}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *GetRuleGroupInput) SetARN(v string) *GetRuleGroupInput {
	s.ARN = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetRuleGroupInput) SetId(v string) *GetRuleGroupInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRuleGroupInput) SetName(v string) *GetRuleGroupInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetRuleGroupInput) SetScope(v string) *GetRuleGroupInput {
	s.Scope = &v
	return s
}

type GetRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// A rule group defines a collection of rules to inspect and control web requests
	// that you can use in a WebACL. When you create a rule group, you define an
	// immutable capacity limit. If you update a rule group, you must stay within
	// the capacity. This allows others to reuse the rule group with confidence
	// in its capacity requirements.
	RuleGroup *RuleGroup `type:"structure"`
}

// String returns the string representation
func (s GetRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleGroupOutput) GoString() string {
	return s.String()
}

// SetLockToken sets the LockToken field's value.
func (s *GetRuleGroupOutput) SetLockToken(v string) *GetRuleGroupOutput {
	s.LockToken = &v
	return s
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *GetRuleGroupOutput) SetRuleGroup(v *RuleGroup) *GetRuleGroupOutput {
	s.RuleGroup = v
	return s
}

type GetSampledRequestsInput struct {
	_ struct{} `type:"structure"`

	// The number of requests that you want WAF to return from among the first 5,000
	// requests that your Amazon Web Services resource received during the time
	// range. If your resource received fewer requests than the value of MaxItems,
	// GetSampledRequests returns information about all of them.
	//
	// MaxItems is a required field
	MaxItems *int64 `min:"1" type:"long" required:"true"`

	// The metric name assigned to the Rule or RuleGroup for which you want a sample
	// of requests.
	//
	// RuleMetricName is a required field
	RuleMetricName *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// The start date and time and the end date and time of the range for which
	// you want GetSampledRequests to return a sample of requests. You must specify
	// the times in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z". You can specify
	// any time range in the previous three hours. If you specify a start time that's
	// earlier than three hours ago, WAF sets it to three hours ago.
	//
	// TimeWindow is a required field
	TimeWindow *TimeWindow `type:"structure" required:"true"`

	// The Amazon resource name (ARN) of the WebACL for which you want a sample
	// of requests.
	//
	// WebAclArn is a required field
	WebAclArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSampledRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSampledRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSampledRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSampledRequestsInput"}
	if s.MaxItems == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxItems"))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.RuleMetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleMetricName"))
	}
	if s.RuleMetricName != nil && len(*s.RuleMetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleMetricName", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.TimeWindow == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeWindow"))
	}
	if s.WebAclArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WebAclArn"))
	}
	if s.WebAclArn != nil && len(*s.WebAclArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WebAclArn", 20))
	}
	if s.TimeWindow != nil {
		if err := s.TimeWindow.Validate(); err != nil {
			invalidParams.AddNested("TimeWindow", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *GetSampledRequestsInput) SetMaxItems(v int64) *GetSampledRequestsInput {
	s.MaxItems = &v
	return s
}

// SetRuleMetricName sets the RuleMetricName field's value.
func (s *GetSampledRequestsInput) SetRuleMetricName(v string) *GetSampledRequestsInput {
	s.RuleMetricName = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetSampledRequestsInput) SetScope(v string) *GetSampledRequestsInput {
	s.Scope = &v
	return s
}

// SetTimeWindow sets the TimeWindow field's value.
func (s *GetSampledRequestsInput) SetTimeWindow(v *TimeWindow) *GetSampledRequestsInput {
	s.TimeWindow = v
	return s
}

// SetWebAclArn sets the WebAclArn field's value.
func (s *GetSampledRequestsInput) SetWebAclArn(v string) *GetSampledRequestsInput {
	s.WebAclArn = &v
	return s
}

type GetSampledRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The total number of requests from which GetSampledRequests got a sample of
	// MaxItems requests. If PopulationSize is less than MaxItems, the sample includes
	// every request that your Amazon Web Services resource received during the
	// specified time range.
	PopulationSize *int64 `type:"long"`

	// A complex type that contains detailed information about each of the requests
	// in the sample.
	SampledRequests []*SampledHTTPRequest `type:"list"`

	// Usually, TimeWindow is the time range that you specified in the GetSampledRequests
	// request. However, if your Amazon Web Services resource received more than
	// 5,000 requests during the time range that you specified in the request, GetSampledRequests
	// returns the time range for the first 5,000 requests. Times are in Coordinated
	// Universal Time (UTC) format.
	TimeWindow *TimeWindow `type:"structure"`
}

// String returns the string representation
func (s GetSampledRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSampledRequestsOutput) GoString() string {
	return s.String()
}

// SetPopulationSize sets the PopulationSize field's value.
func (s *GetSampledRequestsOutput) SetPopulationSize(v int64) *GetSampledRequestsOutput {
	s.PopulationSize = &v
	return s
}

// SetSampledRequests sets the SampledRequests field's value.
func (s *GetSampledRequestsOutput) SetSampledRequests(v []*SampledHTTPRequest) *GetSampledRequestsOutput {
	s.SampledRequests = v
	return s
}

// SetTimeWindow sets the TimeWindow field's value.
func (s *GetSampledRequestsOutput) SetTimeWindow(v *TimeWindow) *GetSampledRequestsOutput {
	s.TimeWindow = v
	return s
}

type GetWebACLForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWebACLForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebACLForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWebACLForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetWebACLForResourceInput) SetResourceArn(v string) *GetWebACLForResourceInput {
	s.ResourceArn = &v
	return s
}

type GetWebACLForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The web ACL that is associated with the resource. If there is no associated
	// resource, WAF returns a null web ACL.
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s GetWebACLForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLForResourceOutput) GoString() string {
	return s.String()
}

// SetWebACL sets the WebACL field's value.
func (s *GetWebACLForResourceOutput) SetWebACL(v *WebACL) *GetWebACLForResourceOutput {
	s.WebACL = v
	return s
}

type GetWebACLInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s GetWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWebACLInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWebACLInput) SetId(v string) *GetWebACLInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWebACLInput) SetName(v string) *GetWebACLInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetWebACLInput) SetScope(v string) *GetWebACLInput {
	s.Scope = &v
	return s
}

type GetWebACLOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The web ACL specification. You can modify the settings in this web ACL and
	// use it to update this web ACL or create a new one.
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s GetWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLOutput) GoString() string {
	return s.String()
}

// SetLockToken sets the LockToken field's value.
func (s *GetWebACLOutput) SetLockToken(v string) *GetWebACLOutput {
	s.LockToken = &v
	return s
}

// SetWebACL sets the WebACL field's value.
func (s *GetWebACLOutput) SetWebACL(v *WebACL) *GetWebACLOutput {
	s.WebACL = v
	return s
}

// Part of the response from GetSampledRequests. This is a complex type that
// appears as Headers in the response syntax. HTTPHeader contains the names
// and values of all of the headers that appear in one of the web requests.
type HTTPHeader struct {
	_ struct{} `type:"structure"`

	// The name of the HTTP header.
	Name *string `type:"string"`

	// The value of the HTTP header.
	Value *string `type:"string"`
}

// String returns the string representation
func (s HTTPHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeader) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HTTPHeader) SetName(v string) *HTTPHeader {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HTTPHeader) SetValue(v string) *HTTPHeader {
	s.Value = &v
	return s
}

// Part of the response from GetSampledRequests. This is a complex type that
// appears as Request in the response syntax. HTTPRequest contains information
// about one of the web requests.
type HTTPRequest struct {
	_ struct{} `type:"structure"`

	// The IP address that the request originated from. If the web ACL is associated
	// with a CloudFront distribution, this is the value of one of the following
	// fields in CloudFront access logs:
	//
	//    * c-ip, if the viewer did not use an HTTP proxy or a load balancer to
	//    send the request
	//
	//    * x-forwarded-for, if the viewer did use an HTTP proxy or a load balancer
	//    to send the request
	ClientIP *string `type:"string"`

	// The two-letter country code for the country that the request originated from.
	// For a current list of country codes, see the Wikipedia entry ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	Country *string `type:"string"`

	// The HTTP version specified in the sampled web request, for example, HTTP/1.1.
	HTTPVersion *string `type:"string"`

	// A complex type that contains the name and value for each header in the sampled
	// web request.
	Headers []*HTTPHeader `type:"list"`

	// The HTTP method specified in the sampled web request.
	Method *string `type:"string"`

	// The URI path of the request, which identifies the resource, for example,
	// /images/daily-ad.jpg.
	URI *string `type:"string"`
}

// String returns the string representation
func (s HTTPRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPRequest) GoString() string {
	return s.String()
}

// SetClientIP sets the ClientIP field's value.
func (s *HTTPRequest) SetClientIP(v string) *HTTPRequest {
	s.ClientIP = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *HTTPRequest) SetCountry(v string) *HTTPRequest {
	s.Country = &v
	return s
}

// SetHTTPVersion sets the HTTPVersion field's value.
func (s *HTTPRequest) SetHTTPVersion(v string) *HTTPRequest {
	s.HTTPVersion = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *HTTPRequest) SetHeaders(v []*HTTPHeader) *HTTPRequest {
	s.Headers = v
	return s
}

// SetMethod sets the Method field's value.
func (s *HTTPRequest) SetMethod(v string) *HTTPRequest {
	s.Method = &v
	return s
}

// SetURI sets the URI field's value.
func (s *HTTPRequest) SetURI(v string) *HTTPRequest {
	s.URI = &v
	return s
}

// Contains one or more IP addresses or blocks of IP addresses specified in
// Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and
// IPv6 CIDR ranges except for /0. For information about CIDR notation, see
// the Wikipedia entry Classless Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// WAF assigns an ARN to each IPSet that you create. To use an IP set in a rule,
// you provide the ARN to the Rule statement IPSetReferenceStatement.
type IPSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// Contains an array of strings that specify one or more IP addresses or blocks
	// of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports
	// all IPv4 and IPv6 CIDR ranges except for /0.
	//
	// Examples:
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff,
	//    specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Addresses is a required field
	Addresses []*string `type:"list" required:"true"`

	// A description of the IP set that helps with identification.
	Description *string `min:"1" type:"string"`

	// The version of the IP addresses, either IPV4 or IPV6.
	//
	// IPAddressVersion is a required field
	IPAddressVersion *string `type:"string" required:"true" enum:"IPAddressVersion"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IPSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSet) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *IPSet) SetARN(v string) *IPSet {
	s.ARN = &v
	return s
}

// SetAddresses sets the Addresses field's value.
func (s *IPSet) SetAddresses(v []*string) *IPSet {
	s.Addresses = v
	return s
}

// SetDescription sets the Description field's value.
func (s *IPSet) SetDescription(v string) *IPSet {
	s.Description = &v
	return s
}

// SetIPAddressVersion sets the IPAddressVersion field's value.
func (s *IPSet) SetIPAddressVersion(v string) *IPSet {
	s.IPAddressVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *IPSet) SetId(v string) *IPSet {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *IPSet) SetName(v string) *IPSet {
	s.Name = &v
	return s
}

// The configuration for inspecting IP addresses in an HTTP header that you
// specify, instead of using the IP address that's reported by the web request
// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
// any header name.
//
// If the specified header isn't present in the request, WAF doesn't apply the
// rule to the web request at all.
//
// This configuration is used only for IPSetReferenceStatement. For GeoMatchStatement
// and RateBasedStatement, use ForwardedIPConfig instead.
type IPSetForwardedIPConfig struct {
	_ struct{} `type:"structure"`

	// The match status to assign to the web request if the request doesn't have
	// a valid IP address in the specified position.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	//
	// You can specify the following fallback behaviors:
	//
	//    * MATCH - Treat the web request as matching the rule statement. WAF applies
	//    the rule action to the request.
	//
	//    * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// FallbackBehavior is a required field
	FallbackBehavior *string `type:"string" required:"true" enum:"FallbackBehavior"`

	// The name of the HTTP header to use for the IP address. For example, to use
	// the X-Forwarded-For (XFF) header, set this to X-Forwarded-For.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	//
	// HeaderName is a required field
	HeaderName *string `min:"1" type:"string" required:"true"`

	// The position in the header to search for the IP address. The header can contain
	// IP addresses of the original client and also of proxies. For example, the
	// header value could be 10.1.1.1, 127.0.0.0, 10.10.10.10 where the first IP
	// address identifies the original client and the rest identify proxies that
	// the request went through.
	//
	// The options for this setting are the following:
	//
	//    * FIRST - Inspect the first IP address in the list of IP addresses in
	//    the header. This is usually the client's original IP.
	//
	//    * LAST - Inspect the last IP address in the list of IP addresses in the
	//    header.
	//
	//    * ANY - Inspect all IP addresses in the header for a match. If the header
	//    contains more than 10 IP addresses, WAF inspects the last 10.
	//
	// Position is a required field
	Position *string `type:"string" required:"true" enum:"ForwardedIPPosition"`
}

// String returns the string representation
func (s IPSetForwardedIPConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetForwardedIPConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSetForwardedIPConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IPSetForwardedIPConfig"}
	if s.FallbackBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("FallbackBehavior"))
	}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderName != nil && len(*s.HeaderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HeaderName", 1))
	}
	if s.Position == nil {
		invalidParams.Add(request.NewErrParamRequired("Position"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFallbackBehavior sets the FallbackBehavior field's value.
func (s *IPSetForwardedIPConfig) SetFallbackBehavior(v string) *IPSetForwardedIPConfig {
	s.FallbackBehavior = &v
	return s
}

// SetHeaderName sets the HeaderName field's value.
func (s *IPSetForwardedIPConfig) SetHeaderName(v string) *IPSetForwardedIPConfig {
	s.HeaderName = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *IPSetForwardedIPConfig) SetPosition(v string) *IPSetForwardedIPConfig {
	s.Position = &v
	return s
}

// A rule statement used to detect web requests coming from particular IP addresses
// or address ranges. To use this, create an IPSet that specifies the addresses
// you want to detect, then use the ARN of that set in this statement. To create
// an IP set, see CreateIPSet.
//
// Each IP set rule statement references an IP set. You create and maintain
// the set independent of your rules. This allows you to use the single set
// in multiple rules. When you update the referenced set, WAF automatically
// updates all rules that reference it.
type IPSetReferenceStatement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IPSet that this statement references.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	IPSetForwardedIPConfig *IPSetForwardedIPConfig `type:"structure"`
}

// String returns the string representation
func (s IPSetReferenceStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetReferenceStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSetReferenceStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IPSetReferenceStatement"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.IPSetForwardedIPConfig != nil {
		if err := s.IPSetForwardedIPConfig.Validate(); err != nil {
			invalidParams.AddNested("IPSetForwardedIPConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *IPSetReferenceStatement) SetARN(v string) *IPSetReferenceStatement {
	s.ARN = &v
	return s
}

// SetIPSetForwardedIPConfig sets the IPSetForwardedIPConfig field's value.
func (s *IPSetReferenceStatement) SetIPSetForwardedIPConfig(v *IPSetForwardedIPConfig) *IPSetReferenceStatement {
	s.IPSetForwardedIPConfig = v
	return s
}

// High-level information about an IPSet, returned by operations like create
// and list. This provides information like the ID, that you can use to retrieve
// and manage an IPSet, and the ARN, that you provide to the IPSetReferenceStatement
// to use the address set in a Rule.
type IPSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the IP set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IPSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *IPSetSummary) SetARN(v string) *IPSetSummary {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IPSetSummary) SetDescription(v string) *IPSetSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *IPSetSummary) SetId(v string) *IPSetSummary {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *IPSetSummary) SetLockToken(v string) *IPSetSummary {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *IPSetSummary) SetName(v string) *IPSetSummary {
	s.Name = &v
	return s
}

// The body of a web request, inspected as JSON. The body immediately follows
// the request headers. This is used in the FieldToMatch specification.
//
// Use the specifications in this object to indicate which parts of the JSON
// body to inspect using the rule's inspection criteria. WAF inspects only the
// parts of the JSON that result from the matches that you indicate.
type JsonBody struct {
	_ struct{} `type:"structure"`

	// What WAF should do if it fails to completely parse the JSON body. The options
	// are the following:
	//
	//    * EVALUATE_AS_STRING - Inspect the body as plain text. WAF applies the
	//    text transformations and inspection criteria that you defined for the
	//    JSON inspection to the body text string.
	//
	//    * MATCH - Treat the web request as matching the rule statement. WAF applies
	//    the rule action to the request.
	//
	//    * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// If you don't provide this setting, WAF parses and evaluates the content only
	// up to the first parsing failure that it encounters.
	//
	// WAF does its best to parse the entire JSON body, but might be forced to stop
	// for reasons such as invalid characters, duplicate keys, truncation, and any
	// content whose root node isn't an object or an array.
	//
	// WAF parses the JSON in the following examples as two valid key, value pairs:
	//
	//    * Missing comma: {"key1":"value1""key2":"value2"}
	//
	//    * Missing colon: {"key1":"value1","key2""value2"}
	//
	//    * Extra colons: {"key1"::"value1","key2""value2"}
	InvalidFallbackBehavior *string `type:"string" enum:"BodyParsingFallbackBehavior"`

	// The patterns to look for in the JSON body. WAF inspects the results of these
	// pattern matches against the rule inspection criteria.
	//
	// MatchPattern is a required field
	MatchPattern *JsonMatchPattern `type:"structure" required:"true"`

	// The parts of the JSON to match against using the MatchPattern. If you specify
	// All, WAF matches against keys and values.
	//
	// MatchScope is a required field
	MatchScope *string `type:"string" required:"true" enum:"JsonMatchScope"`
}

// String returns the string representation
func (s JsonBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JsonBody) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JsonBody) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JsonBody"}
	if s.MatchPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchPattern"))
	}
	if s.MatchScope == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchScope"))
	}
	if s.MatchPattern != nil {
		if err := s.MatchPattern.Validate(); err != nil {
			invalidParams.AddNested("MatchPattern", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvalidFallbackBehavior sets the InvalidFallbackBehavior field's value.
func (s *JsonBody) SetInvalidFallbackBehavior(v string) *JsonBody {
	s.InvalidFallbackBehavior = &v
	return s
}

// SetMatchPattern sets the MatchPattern field's value.
func (s *JsonBody) SetMatchPattern(v *JsonMatchPattern) *JsonBody {
	s.MatchPattern = v
	return s
}

// SetMatchScope sets the MatchScope field's value.
func (s *JsonBody) SetMatchScope(v string) *JsonBody {
	s.MatchScope = &v
	return s
}

// The patterns to look for in the JSON body. WAF inspects the results of these
// pattern matches against the rule inspection criteria. This is used with the
// FieldToMatch option JsonBody.
type JsonMatchPattern struct {
	_ struct{} `type:"structure"`

	// Match all of the elements. See also MatchScope in JsonBody.
	//
	// You must specify either this setting or the IncludedPaths setting, but not
	// both.
	All *All `type:"structure"`

	// Match only the specified include paths. See also MatchScope in JsonBody.
	//
	// Provide the include paths using JSON Pointer syntax. For example, "IncludedPaths":
	// ["/dogs/0/name", "/dogs/1/name"]. For information about this syntax, see
	// the Internet Engineering Task Force (IETF) documentation JavaScript Object
	// Notation (JSON) Pointer (https://tools.ietf.org/html/rfc6901).
	//
	// You must specify either this setting or the All setting, but not both.
	//
	// Don't use this option to include all paths. Instead, use the All setting.
	IncludedPaths []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s JsonMatchPattern) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JsonMatchPattern) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JsonMatchPattern) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JsonMatchPattern"}
	if s.IncludedPaths != nil && len(s.IncludedPaths) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncludedPaths", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAll sets the All field's value.
func (s *JsonMatchPattern) SetAll(v *All) *JsonMatchPattern {
	s.All = v
	return s
}

// SetIncludedPaths sets the IncludedPaths field's value.
func (s *JsonMatchPattern) SetIncludedPaths(v []*string) *JsonMatchPattern {
	s.IncludedPaths = v
	return s
}

// A single label container. This is used as an element of a label array in
// multiple contexts, for example, in RuleLabels inside a Rule and in Labels
// inside a SampledHTTPRequest.
type Label struct {
	_ struct{} `type:"structure"`

	// The label string.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Label) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Label) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Label) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Label"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Label) SetName(v string) *Label {
	s.Name = &v
	return s
}

// A rule statement that defines a string match search against labels that have
// been added to the web request by rules that have already run in the web ACL.
//
// The label match statement provides the label or namespace string to search
// for. The label string can represent a part or all of the fully qualified
// label name that had been added to the web request. Fully qualified labels
// have a prefix, optional namespaces, and label name. The prefix identifies
// the rule group or web ACL context of the rule that added the label. If you
// do not provide the fully qualified name in your label match string, WAF performs
// the search for labels that were added in the same context as the label match
// statement.
type LabelMatchStatement struct {
	_ struct{} `type:"structure"`

	// The string to match against. The setting you provide for this depends on
	// the match statement's Scope setting:
	//
	//    * If the Scope indicates LABEL, then this specification must include the
	//    name and can include any number of preceding namespace specifications
	//    and prefix up to providing the fully qualified label name.
	//
	//    * If the Scope indicates NAMESPACE, then this specification can include
	//    any number of contiguous namespace strings, and can include the entire
	//    label namespace prefix from the rule group or web ACL where the label
	//    originates.
	//
	// Labels are case sensitive and components of a label must be separated by
	// colon, for example NS1:NS2:name.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Specify whether you want to match using the label name or just the namespace.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"LabelMatchScope"`
}

// String returns the string representation
func (s LabelMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelMatchStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelMatchStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelMatchStatement"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *LabelMatchStatement) SetKey(v string) *LabelMatchStatement {
	s.Key = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *LabelMatchStatement) SetScope(v string) *LabelMatchStatement {
	s.Scope = &v
	return s
}

// A single label name condition for a Condition in a logging filter.
type LabelNameCondition struct {
	_ struct{} `type:"structure"`

	// The label name that a log record must contain in order to meet the condition.
	// This must be a fully qualified label name. Fully qualified labels have a
	// prefix, optional namespaces, and label name. The prefix identifies the rule
	// group or web ACL context of the rule that added the label.
	//
	// LabelName is a required field
	LabelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LabelNameCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelNameCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelNameCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelNameCondition"}
	if s.LabelName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelName"))
	}
	if s.LabelName != nil && len(*s.LabelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelName sets the LabelName field's value.
func (s *LabelNameCondition) SetLabelName(v string) *LabelNameCondition {
	s.LabelName = &v
	return s
}

// List of labels used by one or more of the rules of a RuleGroup. This summary
// object is used for the following rule group lists:
//
//    * AvailableLabels - Labels that rules add to matching requests. These
//    labels are defined in the RuleLabels for a Rule.
//
//    * ConsumedLabels - Labels that rules match against. These labels are defined
//    in a LabelMatchStatement specification, in the Statement definition of
//    a rule.
type LabelSummary struct {
	_ struct{} `type:"structure"`

	// An individual label specification.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LabelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *LabelSummary) SetName(v string) *LabelSummary {
	s.Name = &v
	return s
}

type ListAvailableManagedRuleGroupVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	//
	// VendorName is a required field
	VendorName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAvailableManagedRuleGroupVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableManagedRuleGroupVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableManagedRuleGroupVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableManagedRuleGroupVersionsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.VendorName == nil {
		invalidParams.Add(request.NewErrParamRequired("VendorName"))
	}
	if s.VendorName != nil && len(*s.VendorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListAvailableManagedRuleGroupVersionsInput) SetLimit(v int64) *ListAvailableManagedRuleGroupVersionsInput {
	s.Limit = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAvailableManagedRuleGroupVersionsInput) SetName(v string) *ListAvailableManagedRuleGroupVersionsInput {
	s.Name = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAvailableManagedRuleGroupVersionsInput) SetNextMarker(v string) *ListAvailableManagedRuleGroupVersionsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListAvailableManagedRuleGroupVersionsInput) SetScope(v string) *ListAvailableManagedRuleGroupVersionsInput {
	s.Scope = &v
	return s
}

// SetVendorName sets the VendorName field's value.
func (s *ListAvailableManagedRuleGroupVersionsInput) SetVendorName(v string) *ListAvailableManagedRuleGroupVersionsInput {
	s.VendorName = &v
	return s
}

type ListAvailableManagedRuleGroupVersionsOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// The versions that are currently available for the specified managed rule
	// group.
	Versions []*ManagedRuleGroupVersion `type:"list"`
}

// String returns the string representation
func (s ListAvailableManagedRuleGroupVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableManagedRuleGroupVersionsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAvailableManagedRuleGroupVersionsOutput) SetNextMarker(v string) *ListAvailableManagedRuleGroupVersionsOutput {
	s.NextMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListAvailableManagedRuleGroupVersionsOutput) SetVersions(v []*ManagedRuleGroupVersion) *ListAvailableManagedRuleGroupVersionsOutput {
	s.Versions = v
	return s
}

type ListAvailableManagedRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s ListAvailableManagedRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableManagedRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableManagedRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableManagedRuleGroupsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListAvailableManagedRuleGroupsInput) SetLimit(v int64) *ListAvailableManagedRuleGroupsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAvailableManagedRuleGroupsInput) SetNextMarker(v string) *ListAvailableManagedRuleGroupsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListAvailableManagedRuleGroupsInput) SetScope(v string) *ListAvailableManagedRuleGroupsInput {
	s.Scope = &v
	return s
}

type ListAvailableManagedRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	ManagedRuleGroups []*ManagedRuleGroupSummary `type:"list"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAvailableManagedRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableManagedRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetManagedRuleGroups sets the ManagedRuleGroups field's value.
func (s *ListAvailableManagedRuleGroupsOutput) SetManagedRuleGroups(v []*ManagedRuleGroupSummary) *ListAvailableManagedRuleGroupsOutput {
	s.ManagedRuleGroups = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAvailableManagedRuleGroupsOutput) SetNextMarker(v string) *ListAvailableManagedRuleGroupsOutput {
	s.NextMarker = &v
	return s
}

type ListIPSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s ListIPSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIPSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIPSetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListIPSetsInput) SetLimit(v int64) *ListIPSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListIPSetsInput) SetNextMarker(v string) *ListIPSetsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListIPSetsInput) SetScope(v string) *ListIPSetsInput {
	s.Scope = &v
	return s
}

type ListIPSetsOutput struct {
	_ struct{} `type:"structure"`

	// Array of IPSets. This may not be the full list of IPSets that you have defined.
	// See the Limit specification for this request.
	IPSets []*IPSetSummary `type:"list"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIPSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsOutput) GoString() string {
	return s.String()
}

// SetIPSets sets the IPSets field's value.
func (s *ListIPSetsOutput) SetIPSets(v []*IPSetSummary) *ListIPSetsOutput {
	s.IPSets = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListIPSetsOutput) SetNextMarker(v string) *ListIPSetsOutput {
	s.NextMarker = &v
	return s
}

type ListLoggingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	Scope *string `type:"string" enum:"Scope"`
}

// String returns the string representation
func (s ListLoggingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoggingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLoggingConfigurationsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListLoggingConfigurationsInput) SetLimit(v int64) *ListLoggingConfigurationsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLoggingConfigurationsInput) SetNextMarker(v string) *ListLoggingConfigurationsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListLoggingConfigurationsInput) SetScope(v string) *ListLoggingConfigurationsInput {
	s.Scope = &v
	return s
}

type ListLoggingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	LoggingConfigurations []*LoggingConfiguration `type:"list"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLoggingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetLoggingConfigurations sets the LoggingConfigurations field's value.
func (s *ListLoggingConfigurationsOutput) SetLoggingConfigurations(v []*LoggingConfiguration) *ListLoggingConfigurationsOutput {
	s.LoggingConfigurations = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLoggingConfigurationsOutput) SetNextMarker(v string) *ListLoggingConfigurationsOutput {
	s.NextMarker = &v
	return s
}

type ListManagedRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s ListManagedRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListManagedRuleSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedRuleSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedRuleSetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListManagedRuleSetsInput) SetLimit(v int64) *ListManagedRuleSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListManagedRuleSetsInput) SetNextMarker(v string) *ListManagedRuleSetsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListManagedRuleSetsInput) SetScope(v string) *ListManagedRuleSetsInput {
	s.Scope = &v
	return s
}

type ListManagedRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// Your managed rule sets.
	ManagedRuleSets []*ManagedRuleSetSummary `type:"list"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListManagedRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListManagedRuleSetsOutput) GoString() string {
	return s.String()
}

// SetManagedRuleSets sets the ManagedRuleSets field's value.
func (s *ListManagedRuleSetsOutput) SetManagedRuleSets(v []*ManagedRuleSetSummary) *ListManagedRuleSetsOutput {
	s.ManagedRuleSets = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListManagedRuleSetsOutput) SetNextMarker(v string) *ListManagedRuleSetsOutput {
	s.NextMarker = &v
	return s
}

type ListRegexPatternSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s ListRegexPatternSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegexPatternSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRegexPatternSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRegexPatternSetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRegexPatternSetsInput) SetLimit(v int64) *ListRegexPatternSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRegexPatternSetsInput) SetNextMarker(v string) *ListRegexPatternSetsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListRegexPatternSetsInput) SetScope(v string) *ListRegexPatternSetsInput {
	s.Scope = &v
	return s
}

type ListRegexPatternSetsOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	RegexPatternSets []*RegexPatternSetSummary `type:"list"`
}

// String returns the string representation
func (s ListRegexPatternSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegexPatternSetsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRegexPatternSetsOutput) SetNextMarker(v string) *ListRegexPatternSetsOutput {
	s.NextMarker = &v
	return s
}

// SetRegexPatternSets sets the RegexPatternSets field's value.
func (s *ListRegexPatternSetsOutput) SetRegexPatternSets(v []*RegexPatternSetSummary) *ListRegexPatternSetsOutput {
	s.RegexPatternSets = v
	return s
}

type ListResourcesForWebACLInput struct {
	_ struct{} `type:"structure"`

	// Used for web ACLs that are scoped for regional applications. A regional application
	// can be an Application Load Balancer (ALB), an Amazon API Gateway REST API,
	// or an AppSync GraphQL API.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// The Amazon Resource Name (ARN) of the web ACL.
	//
	// WebACLArn is a required field
	WebACLArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesForWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesForWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesForWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesForWebACLInput"}
	if s.WebACLArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLArn"))
	}
	if s.WebACLArn != nil && len(*s.WebACLArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *ListResourcesForWebACLInput) SetResourceType(v string) *ListResourcesForWebACLInput {
	s.ResourceType = &v
	return s
}

// SetWebACLArn sets the WebACLArn field's value.
func (s *ListResourcesForWebACLInput) SetWebACLArn(v string) *ListResourcesForWebACLInput {
	s.WebACLArn = &v
	return s
}

type ListResourcesForWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The array of Amazon Resource Names (ARNs) of the associated resources.
	ResourceArns []*string `type:"list"`
}

// String returns the string representation
func (s ListResourcesForWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesForWebACLOutput) GoString() string {
	return s.String()
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ListResourcesForWebACLOutput) SetResourceArns(v []*string) *ListResourcesForWebACLOutput {
	s.ResourceArns = v
	return s
}

type ListRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s ListRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleGroupsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRuleGroupsInput) SetLimit(v int64) *ListRuleGroupsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRuleGroupsInput) SetNextMarker(v string) *ListRuleGroupsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListRuleGroupsInput) SetScope(v string) *ListRuleGroupsInput {
	s.Scope = &v
	return s
}

type ListRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	RuleGroups []*RuleGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRuleGroupsOutput) SetNextMarker(v string) *ListRuleGroupsOutput {
	s.NextMarker = &v
	return s
}

// SetRuleGroups sets the RuleGroups field's value.
func (s *ListRuleGroupsOutput) SetRuleGroups(v []*RuleGroupSummary) *ListRuleGroupsOutput {
	s.RuleGroups = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListTagsForResourceInput) SetNextMarker(v string) *ListTagsForResourceInput {
	s.NextMarker = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// The collection of tagging definitions for the resource.
	TagInfoForResource *TagInfoForResource `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListTagsForResourceOutput) SetNextMarker(v string) *ListTagsForResourceOutput {
	s.NextMarker = &v
	return s
}

// SetTagInfoForResource sets the TagInfoForResource field's value.
func (s *ListTagsForResourceOutput) SetTagInfoForResource(v *TagInfoForResource) *ListTagsForResourceOutput {
	s.TagInfoForResource = v
	return s
}

type ListWebACLsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want WAF to return for this request.
	// If more objects are available, in the response, WAF provides a NextMarker
	// value that you can use in a subsequent call to get the next batch of objects.
	Limit *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s ListWebACLsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebACLsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebACLsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWebACLsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListWebACLsInput) SetLimit(v int64) *ListWebACLsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListWebACLsInput) SetNextMarker(v string) *ListWebACLsInput {
	s.NextMarker = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListWebACLsInput) SetScope(v string) *ListWebACLsInput {
	s.Scope = &v
	return s
}

type ListWebACLsOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a Limit setting, if the number of
	// objects that are still available for retrieval exceeds the limit, WAF returns
	// a NextMarker value in the response. To retrieve the next batch of objects,
	// provide the marker from the prior call in your next request.
	NextMarker *string `min:"1" type:"string"`

	WebACLs []*WebACLSummary `type:"list"`
}

// String returns the string representation
func (s ListWebACLsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebACLsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListWebACLsOutput) SetNextMarker(v string) *ListWebACLsOutput {
	s.NextMarker = &v
	return s
}

// SetWebACLs sets the WebACLs field's value.
func (s *ListWebACLsOutput) SetWebACLs(v []*WebACLSummary) *ListWebACLsOutput {
	s.WebACLs = v
	return s
}

// Defines an association between Amazon Kinesis Data Firehose destinations
// and a web ACL resource, for logging from WAF. As part of the association,
// you can specify parts of the standard logging fields to keep out of the logs
// and you can specify filters so that you log only a subset of the logging
// records.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Kinesis Data Firehose Amazon Resource Name (ARNs) that you want
	// to associate with the web ACL.
	//
	// LogDestinationConfigs is a required field
	LogDestinationConfigs []*string `min:"1" type:"list" required:"true"`

	// Filtering that specifies which web requests are kept in the logs and which
	// are dropped. You can filter on the rule action and on the web request labels
	// that were applied by matching rules during web ACL evaluation.
	LoggingFilter *LoggingFilter `type:"structure"`

	// Indicates whether the logging configuration was created by Firewall Manager,
	// as part of an WAF policy configuration. If true, only Firewall Manager can
	// modify or delete the configuration.
	ManagedByFirewallManager *bool `type:"boolean"`

	// The parts of the request that you want to keep out of the logs. For example,
	// if you redact the HEADER field, the HEADER field in the firehose will be
	// xxx.
	//
	// You must use one of the following values: URI, QUERY_STRING, HEADER, or METHOD.
	RedactedFields []*FieldToMatch `type:"list"`

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate
	// with LogDestinationConfigs.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfiguration"}
	if s.LogDestinationConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDestinationConfigs"))
	}
	if s.LogDestinationConfigs != nil && len(s.LogDestinationConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogDestinationConfigs", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.LoggingFilter != nil {
		if err := s.LoggingFilter.Validate(); err != nil {
			invalidParams.AddNested("LoggingFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.RedactedFields != nil {
		for i, v := range s.RedactedFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RedactedFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogDestinationConfigs sets the LogDestinationConfigs field's value.
func (s *LoggingConfiguration) SetLogDestinationConfigs(v []*string) *LoggingConfiguration {
	s.LogDestinationConfigs = v
	return s
}

// SetLoggingFilter sets the LoggingFilter field's value.
func (s *LoggingConfiguration) SetLoggingFilter(v *LoggingFilter) *LoggingConfiguration {
	s.LoggingFilter = v
	return s
}

// SetManagedByFirewallManager sets the ManagedByFirewallManager field's value.
func (s *LoggingConfiguration) SetManagedByFirewallManager(v bool) *LoggingConfiguration {
	s.ManagedByFirewallManager = &v
	return s
}

// SetRedactedFields sets the RedactedFields field's value.
func (s *LoggingConfiguration) SetRedactedFields(v []*FieldToMatch) *LoggingConfiguration {
	s.RedactedFields = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LoggingConfiguration) SetResourceArn(v string) *LoggingConfiguration {
	s.ResourceArn = &v
	return s
}

// Filtering that specifies which web requests are kept in the logs and which
// are dropped, defined for a web ACL's LoggingConfiguration.
//
// You can filter on the rule action and on the web request labels that were
// applied by matching rules during web ACL evaluation.
type LoggingFilter struct {
	_ struct{} `type:"structure"`

	// Default handling for logs that don't match any of the specified filtering
	// conditions.
	//
	// DefaultBehavior is a required field
	DefaultBehavior *string `type:"string" required:"true" enum:"FilterBehavior"`

	// The filters that you want to apply to the logs.
	//
	// Filters is a required field
	Filters []*Filter `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s LoggingFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingFilter"}
	if s.DefaultBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultBehavior"))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultBehavior sets the DefaultBehavior field's value.
func (s *LoggingFilter) SetDefaultBehavior(v string) *LoggingFilter {
	s.DefaultBehavior = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *LoggingFilter) SetFilters(v []*Filter) *LoggingFilter {
	s.Filters = v
	return s
}

// A rule statement used to run the rules that are defined in a managed rule
// group. To use this, provide the vendor name and the name of the rule group
// in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
//
// You cannot nest a ManagedRuleGroupStatement, for example for use inside a
// NotStatement or OrStatement. It can only be referenced as a top-level statement
// within a rule.
type ManagedRuleGroupStatement struct {
	_ struct{} `type:"structure"`

	// The rules whose actions are set to COUNT by the web ACL, regardless of the
	// action that is set on the rule. This effectively excludes the rule from acting
	// on web requests.
	ExcludedRules []*ExcludedRule `type:"list"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An optional nested statement that narrows the scope of the web requests that
	// are evaluated by the managed rule group. Requests are only evaluated by the
	// rule group if they match the scope-down statement. You can use any nestable
	// Statement in the scope-down statement, and you can nest statements at any
	// level, the same as you can for a rule statement.
	ScopeDownStatement *Statement `type:"structure"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	//
	// VendorName is a required field
	VendorName *string `min:"1" type:"string" required:"true"`

	// The version of the managed rule group to use. If you specify this, the version
	// setting is fixed until you change it. If you don't specify this, WAF uses
	// the vendor's default version, and then keeps the version at the vendor's
	// default when the vendor updates the managed rule group settings.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ManagedRuleGroupStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedRuleGroupStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedRuleGroupStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagedRuleGroupStatement"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VendorName == nil {
		invalidParams.Add(request.NewErrParamRequired("VendorName"))
	}
	if s.VendorName != nil && len(*s.VendorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorName", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.ExcludedRules != nil {
		for i, v := range s.ExcludedRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScopeDownStatement != nil {
		if err := s.ScopeDownStatement.Validate(); err != nil {
			invalidParams.AddNested("ScopeDownStatement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludedRules sets the ExcludedRules field's value.
func (s *ManagedRuleGroupStatement) SetExcludedRules(v []*ExcludedRule) *ManagedRuleGroupStatement {
	s.ExcludedRules = v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedRuleGroupStatement) SetName(v string) *ManagedRuleGroupStatement {
	s.Name = &v
	return s
}

// SetScopeDownStatement sets the ScopeDownStatement field's value.
func (s *ManagedRuleGroupStatement) SetScopeDownStatement(v *Statement) *ManagedRuleGroupStatement {
	s.ScopeDownStatement = v
	return s
}

// SetVendorName sets the VendorName field's value.
func (s *ManagedRuleGroupStatement) SetVendorName(v string) *ManagedRuleGroupStatement {
	s.VendorName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ManagedRuleGroupStatement) SetVersion(v string) *ManagedRuleGroupStatement {
	s.Version = &v
	return s
}

// High-level information about a managed rule group, returned by ListAvailableManagedRuleGroups.
// This provides information like the name and vendor name, that you provide
// when you add a ManagedRuleGroupStatement to a web ACL. Managed rule groups
// include Amazon Web Services Managed Rules rule groups, which are free of
// charge to WAF customers, and Marketplace managed rule groups, which you can
// subscribe to through Marketplace.
type ManagedRuleGroupSummary struct {
	_ struct{} `type:"structure"`

	// The description of the managed rule group, provided by Amazon Web Services
	// Managed Rules or the Marketplace seller who manages it.
	Description *string `min:"1" type:"string"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	Name *string `min:"1" type:"string"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	VendorName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ManagedRuleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedRuleGroupSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ManagedRuleGroupSummary) SetDescription(v string) *ManagedRuleGroupSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedRuleGroupSummary) SetName(v string) *ManagedRuleGroupSummary {
	s.Name = &v
	return s
}

// SetVendorName sets the VendorName field's value.
func (s *ManagedRuleGroupSummary) SetVendorName(v string) *ManagedRuleGroupSummary {
	s.VendorName = &v
	return s
}

// Describes a single version of a managed rule group.
type ManagedRuleGroupVersion struct {
	_ struct{} `type:"structure"`

	// The date and time that the managed rule group owner updated the rule group
	// version information.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// The version name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ManagedRuleGroupVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedRuleGroupVersion) GoString() string {
	return s.String()
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *ManagedRuleGroupVersion) SetLastUpdateTimestamp(v time.Time) *ManagedRuleGroupVersion {
	s.LastUpdateTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedRuleGroupVersion) SetName(v string) *ManagedRuleGroupVersion {
	s.Name = &v
	return s
}

// A set of rules that is managed by Amazon Web Services and Marketplace sellers
// to provide versioned managed rule groups for customers of WAF.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
type ManagedRuleSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// A description of the set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the managed rule set. The ID is returned in the responses
	// to commands like list. You provide it to operations like get and update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The label namespace prefix for the managed rule groups that are offered to
	// customers from this managed rule set. All labels that are added by rules
	// in the managed rule group have this prefix.
	//
	//    * The syntax for the label namespace prefix for a managed rule group is
	//    the following: awswaf:managed:<vendor>:<rule group name>:
	//
	//    * When a rule with a label matches a web request, WAF adds the fully qualified
	//    label to the request. A fully qualified label is made up of the label
	//    namespace from the rule group or web ACL where the rule is defined and
	//    the label from the rule, separated by a colon: <label namespace>:<label
	//    from rule>
	LabelNamespace *string `min:"1" type:"string"`

	// The name of the managed rule set. You use this, along with the rule set ID,
	// to identify the rule set.
	//
	// This name is assigned to the corresponding managed rule group, which your
	// customers can access and use.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The versions of this managed rule set that are available for use by customers.
	PublishedVersions map[string]*ManagedRuleSetVersion `type:"map"`

	// The version that you would like your customers to use.
	RecommendedVersion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ManagedRuleSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedRuleSet) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ManagedRuleSet) SetARN(v string) *ManagedRuleSet {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ManagedRuleSet) SetDescription(v string) *ManagedRuleSet {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ManagedRuleSet) SetId(v string) *ManagedRuleSet {
	s.Id = &v
	return s
}

// SetLabelNamespace sets the LabelNamespace field's value.
func (s *ManagedRuleSet) SetLabelNamespace(v string) *ManagedRuleSet {
	s.LabelNamespace = &v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedRuleSet) SetName(v string) *ManagedRuleSet {
	s.Name = &v
	return s
}

// SetPublishedVersions sets the PublishedVersions field's value.
func (s *ManagedRuleSet) SetPublishedVersions(v map[string]*ManagedRuleSetVersion) *ManagedRuleSet {
	s.PublishedVersions = v
	return s
}

// SetRecommendedVersion sets the RecommendedVersion field's value.
func (s *ManagedRuleSet) SetRecommendedVersion(v string) *ManagedRuleSet {
	s.RecommendedVersion = &v
	return s
}

// High-level information for a managed rule set.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
type ManagedRuleSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the managed rule set. The ID is returned in the responses
	// to commands like list. You provide it to operations like get and update.
	Id *string `min:"1" type:"string"`

	// The label namespace prefix for the managed rule groups that are offered to
	// customers from this managed rule set. All labels that are added by rules
	// in the managed rule group have this prefix.
	//
	//    * The syntax for the label namespace prefix for a managed rule group is
	//    the following: awswaf:managed:<vendor>:<rule group name>:
	//
	//    * When a rule with a label matches a web request, WAF adds the fully qualified
	//    label to the request. A fully qualified label is made up of the label
	//    namespace from the rule group or web ACL where the rule is defined and
	//    the label from the rule, separated by a colon: <label namespace>:<label
	//    from rule>
	LabelNamespace *string `min:"1" type:"string"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the managed rule set. You use this, along with the rule set ID,
	// to identify the rule set.
	//
	// This name is assigned to the corresponding managed rule group, which your
	// customers can access and use.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ManagedRuleSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedRuleSetSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ManagedRuleSetSummary) SetARN(v string) *ManagedRuleSetSummary {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ManagedRuleSetSummary) SetDescription(v string) *ManagedRuleSetSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ManagedRuleSetSummary) SetId(v string) *ManagedRuleSetSummary {
	s.Id = &v
	return s
}

// SetLabelNamespace sets the LabelNamespace field's value.
func (s *ManagedRuleSetSummary) SetLabelNamespace(v string) *ManagedRuleSetSummary {
	s.LabelNamespace = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *ManagedRuleSetSummary) SetLockToken(v string) *ManagedRuleSetSummary {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedRuleSetSummary) SetName(v string) *ManagedRuleSetSummary {
	s.Name = &v
	return s
}

// Information for a single version of a managed rule set.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
type ManagedRuleSetVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the vendor rule group that's used to define
	// the published version of your managed rule group.
	AssociatedRuleGroupArn *string `min:"20" type:"string"`

	// The web ACL capacity units (WCUs) required for this rule group.
	//
	// WAF uses WCUs to calculate and control the operating resources that are used
	// to run your rules, rule groups, and web ACLs. WAF calculates capacity differently
	// for each rule type, to reflect the relative cost of each rule. Simple rules
	// that cost little to run use fewer WCUs than more complex rules that use more
	// processing power. Rule group capacity is fixed at creation, which helps users
	// plan their web ACL WCU usage when they use a rule group. The WCU limit for
	// web ACLs is 1,500.
	Capacity *int64 `min:"1" type:"long"`

	// The time that this version is set to expire.
	//
	// Times are in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z".
	ExpiryTimestamp *time.Time `type:"timestamp"`

	// The amount of time you expect this version of your managed rule group to
	// last, in days.
	ForecastedLifetime *int64 `min:"1" type:"integer"`

	// The last time that you updated this version.
	//
	// Times are in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z".
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// The time that you first published this version.
	//
	// Times are in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z".
	PublishTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ManagedRuleSetVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedRuleSetVersion) GoString() string {
	return s.String()
}

// SetAssociatedRuleGroupArn sets the AssociatedRuleGroupArn field's value.
func (s *ManagedRuleSetVersion) SetAssociatedRuleGroupArn(v string) *ManagedRuleSetVersion {
	s.AssociatedRuleGroupArn = &v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *ManagedRuleSetVersion) SetCapacity(v int64) *ManagedRuleSetVersion {
	s.Capacity = &v
	return s
}

// SetExpiryTimestamp sets the ExpiryTimestamp field's value.
func (s *ManagedRuleSetVersion) SetExpiryTimestamp(v time.Time) *ManagedRuleSetVersion {
	s.ExpiryTimestamp = &v
	return s
}

// SetForecastedLifetime sets the ForecastedLifetime field's value.
func (s *ManagedRuleSetVersion) SetForecastedLifetime(v int64) *ManagedRuleSetVersion {
	s.ForecastedLifetime = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *ManagedRuleSetVersion) SetLastUpdateTimestamp(v time.Time) *ManagedRuleSetVersion {
	s.LastUpdateTimestamp = &v
	return s
}

// SetPublishTimestamp sets the PublishTimestamp field's value.
func (s *ManagedRuleSetVersion) SetPublishTimestamp(v time.Time) *ManagedRuleSetVersion {
	s.PublishTimestamp = &v
	return s
}

// The HTTP method of a web request. The method indicates the type of operation
// that the request is asking the origin to perform.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type Method struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Method) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Method) GoString() string {
	return s.String()
}

// Specifies that WAF should do nothing. This is generally used to try out a
// rule without performing any actions. You set the OverrideAction on the Rule.
//
// This is used in the context of other settings, for example to specify values
// for RuleAction and web ACL DefaultAction.
type NoneAction struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s NoneAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoneAction) GoString() string {
	return s.String()
}

// A logical rule statement used to negate the results of another rule statement.
// You provide one Statement within the NotStatement.
type NotStatement struct {
	_ struct{} `type:"structure"`

	// The statement to negate. You can use any statement that can be nested.
	//
	// Statement is a required field
	Statement *Statement `type:"structure" required:"true"`
}

// String returns the string representation
func (s NotStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotStatement"}
	if s.Statement == nil {
		invalidParams.Add(request.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil {
		if err := s.Statement.Validate(); err != nil {
			invalidParams.AddNested("Statement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatement sets the Statement field's value.
func (s *NotStatement) SetStatement(v *Statement) *NotStatement {
	s.Statement = v
	return s
}

// A logical rule statement used to combine other rule statements with OR logic.
// You provide more than one Statement within the OrStatement.
type OrStatement struct {
	_ struct{} `type:"structure"`

	// The statements to combine with OR logic. You can use any statements that
	// can be nested.
	//
	// Statements is a required field
	Statements []*Statement `type:"list" required:"true"`
}

// String returns the string representation
func (s OrStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrStatement"}
	if s.Statements == nil {
		invalidParams.Add(request.NewErrParamRequired("Statements"))
	}
	if s.Statements != nil {
		for i, v := range s.Statements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Statements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatements sets the Statements field's value.
func (s *OrStatement) SetStatements(v []*Statement) *OrStatement {
	s.Statements = v
	return s
}

// The override action to apply to the rules in a rule group. Used only for
// rule statements that reference a rule group, like RuleGroupReferenceStatement
// and ManagedRuleGroupStatement.
//
// Set the override action to none to leave the rule actions in effect. Set
// it to count to only count matches, regardless of the rule action settings.
//
// In a Rule, you must specify either this OverrideAction setting or the rule
// Action setting, but not both:
//
//    * If the rule statement references a rule group, use this override action
//    setting and not the action setting.
//
//    * If the rule statement does not reference a rule group, use the rule
//    action setting and not this rule override action setting.
type OverrideAction struct {
	_ struct{} `type:"structure"`

	// Override the rule action setting to count.
	Count *CountAction `type:"structure"`

	// Don't override the rule action setting.
	None *NoneAction `type:"structure"`
}

// String returns the string representation
func (s OverrideAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OverrideAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OverrideAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OverrideAction"}
	if s.Count != nil {
		if err := s.Count.Validate(); err != nil {
			invalidParams.AddNested("Count", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *OverrideAction) SetCount(v *CountAction) *OverrideAction {
	s.Count = v
	return s
}

// SetNone sets the None field's value.
func (s *OverrideAction) SetNone(v *NoneAction) *OverrideAction {
	s.None = v
	return s
}

type PutLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Defines an association between Amazon Kinesis Data Firehose destinations
	// and a web ACL resource, for logging from WAF. As part of the association,
	// you can specify parts of the standard logging fields to keep out of the logs
	// and you can specify filters so that you log only a subset of the logging
	// records.
	//
	// LoggingConfiguration is a required field
	LoggingConfiguration *LoggingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingConfigurationInput"}
	if s.LoggingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingConfiguration"))
	}
	if s.LoggingConfiguration != nil {
		if err := s.LoggingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutLoggingConfigurationInput) SetLoggingConfiguration(v *LoggingConfiguration) *PutLoggingConfigurationInput {
	s.LoggingConfiguration = v
	return s
}

type PutLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Defines an association between Amazon Kinesis Data Firehose destinations
	// and a web ACL resource, for logging from WAF. As part of the association,
	// you can specify parts of the standard logging fields to keep out of the logs
	// and you can specify filters so that you log only a subset of the logging
	// records.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *PutLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type PutManagedRuleSetVersionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the managed rule set. The ID is returned in the responses
	// to commands like list. You provide it to operations like get and update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the managed rule set. You use this, along with the rule set ID,
	// to identify the rule set.
	//
	// This name is assigned to the corresponding managed rule group, which your
	// customers can access and use.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of the named managed rule group that you'd like your customers
	// to choose, from among your version offerings.
	RecommendedVersion *string `min:"1" type:"string"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// The versions of the named managed rule group that you want to offer to your
	// customers.
	VersionsToPublish map[string]*VersionToPublish `type:"map"`
}

// String returns the string representation
func (s PutManagedRuleSetVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutManagedRuleSetVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutManagedRuleSetVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutManagedRuleSetVersionsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecommendedVersion != nil && len(*s.RecommendedVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendedVersion", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.VersionsToPublish != nil {
		for i, v := range s.VersionsToPublish {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VersionsToPublish", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *PutManagedRuleSetVersionsInput) SetId(v string) *PutManagedRuleSetVersionsInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *PutManagedRuleSetVersionsInput) SetLockToken(v string) *PutManagedRuleSetVersionsInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutManagedRuleSetVersionsInput) SetName(v string) *PutManagedRuleSetVersionsInput {
	s.Name = &v
	return s
}

// SetRecommendedVersion sets the RecommendedVersion field's value.
func (s *PutManagedRuleSetVersionsInput) SetRecommendedVersion(v string) *PutManagedRuleSetVersionsInput {
	s.RecommendedVersion = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *PutManagedRuleSetVersionsInput) SetScope(v string) *PutManagedRuleSetVersionsInput {
	s.Scope = &v
	return s
}

// SetVersionsToPublish sets the VersionsToPublish field's value.
func (s *PutManagedRuleSetVersionsInput) SetVersionsToPublish(v map[string]*VersionToPublish) *PutManagedRuleSetVersionsInput {
	s.VersionsToPublish = v
	return s
}

type PutManagedRuleSetVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutManagedRuleSetVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutManagedRuleSetVersionsOutput) GoString() string {
	return s.String()
}

// SetNextLockToken sets the NextLockToken field's value.
func (s *PutManagedRuleSetVersionsOutput) SetNextLockToken(v string) *PutManagedRuleSetVersionsOutput {
	s.NextLockToken = &v
	return s
}

type PutPermissionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy to attach to the specified rule group.
	//
	// The policy specifications must conform to the following:
	//
	//    * The policy must be composed using IAM Policy version 2012-10-17 or version
	//    2015-01-01.
	//
	//    * The policy must include specifications for Effect, Action, and Principal.
	//
	//    * Effect must specify Allow.
	//
	//    * Action must specify wafv2:CreateWebACL, wafv2:UpdateWebACL, and wafv2:PutFirewallManagerRuleGroups.
	//    WAF rejects any extra actions or wildcard actions in the policy.
	//
	//    * The policy must not include a Resource parameter.
	//
	// For more information, see IAM Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach
	// the policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s PutPermissionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPermissionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPermissionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPermissionPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutPermissionPolicyInput) SetPolicy(v string) *PutPermissionPolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutPermissionPolicyInput) SetResourceArn(v string) *PutPermissionPolicyInput {
	s.ResourceArn = &v
	return s
}

type PutPermissionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutPermissionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPermissionPolicyOutput) GoString() string {
	return s.String()
}

// The query string of a web request. This is the part of a URL that appears
// after a ? character, if any.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type QueryString struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s QueryString) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryString) GoString() string {
	return s.String()
}

// A rate-based rule tracks the rate of requests for each originating IP address,
// and triggers the rule action when the rate exceeds a limit that you specify
// on the number of requests in any 5-minute time span. You can use this to
// put a temporary block on requests from an IP address that is sending excessive
// requests.
//
// When the rule action triggers, WAF blocks additional requests from the IP
// address until the request rate falls below the limit.
//
// You can optionally nest another statement inside the rate-based statement,
// to narrow the scope of the rule so that it only counts requests that match
// the nested statement. For example, based on recent requests that you have
// seen from an attacker, you might create a rate-based rule with a nested AND
// rule statement that contains the following nested statements:
//
//    * An IP match statement with an IP set that specified the address 192.0.2.44.
//
//    * A string match statement that searches in the User-Agent header for
//    the string BadBot.
//
// In this rate-based rule, you also define a rate limit. For this example,
// the rate limit is 1,000. Requests that meet both of the conditions in the
// statements are counted. If the count exceeds 1,000 requests per five minutes,
// the rule action triggers. Requests that do not meet both conditions are not
// counted towards the rate limit and are not affected by this rule.
//
// You cannot nest a RateBasedStatement, for example for use inside a NotStatement
// or OrStatement. It can only be referenced as a top-level statement within
// a rule.
type RateBasedStatement struct {
	_ struct{} `type:"structure"`

	// Setting that indicates how to aggregate the request counts. The options are
	// the following:
	//
	//    * IP - Aggregate the request counts on the IP address from the web request
	//    origin.
	//
	//    * FORWARDED_IP - Aggregate the request counts on the first IP address
	//    in an HTTP header. If you use this, configure the ForwardedIPConfig, to
	//    specify the header to use.
	//
	// AggregateKeyType is a required field
	AggregateKeyType *string `type:"string" required:"true" enum:"RateBasedStatementAggregateKeyType"`

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name.
	//
	// If the specified header isn't present in the request, WAF doesn't apply the
	// rule to the web request at all.
	//
	// This is required if AggregateKeyType is set to FORWARDED_IP.
	ForwardedIPConfig *ForwardedIPConfig `type:"structure"`

	// The limit on requests per 5-minute period for a single originating IP address.
	// If the statement includes a ScopeDownStatement, this limit is applied only
	// to the requests that match the statement.
	//
	// Limit is a required field
	Limit *int64 `min:"100" type:"long" required:"true"`

	// An optional nested statement that narrows the scope of the web requests that
	// are evaluated by the rate-based statement. Requests are only tracked by the
	// rate-based statement if they match the scope-down statement. You can use
	// any nestable Statement in the scope-down statement, and you can nest statements
	// at any level, the same as you can for a rule statement.
	ScopeDownStatement *Statement `type:"structure"`
}

// String returns the string representation
func (s RateBasedStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RateBasedStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RateBasedStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RateBasedStatement"}
	if s.AggregateKeyType == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregateKeyType"))
	}
	if s.Limit == nil {
		invalidParams.Add(request.NewErrParamRequired("Limit"))
	}
	if s.Limit != nil && *s.Limit < 100 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 100))
	}
	if s.ForwardedIPConfig != nil {
		if err := s.ForwardedIPConfig.Validate(); err != nil {
			invalidParams.AddNested("ForwardedIPConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ScopeDownStatement != nil {
		if err := s.ScopeDownStatement.Validate(); err != nil {
			invalidParams.AddNested("ScopeDownStatement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregateKeyType sets the AggregateKeyType field's value.
func (s *RateBasedStatement) SetAggregateKeyType(v string) *RateBasedStatement {
	s.AggregateKeyType = &v
	return s
}

// SetForwardedIPConfig sets the ForwardedIPConfig field's value.
func (s *RateBasedStatement) SetForwardedIPConfig(v *ForwardedIPConfig) *RateBasedStatement {
	s.ForwardedIPConfig = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *RateBasedStatement) SetLimit(v int64) *RateBasedStatement {
	s.Limit = &v
	return s
}

// SetScopeDownStatement sets the ScopeDownStatement field's value.
func (s *RateBasedStatement) SetScopeDownStatement(v *Statement) *RateBasedStatement {
	s.ScopeDownStatement = v
	return s
}

// The set of IP addresses that are currently blocked for a rate-based statement.
type RateBasedStatementManagedKeysIPSet struct {
	_ struct{} `type:"structure"`

	// The IP addresses that are currently blocked.
	Addresses []*string `type:"list"`

	// The version of the IP addresses, either IPV4 or IPV6.
	IPAddressVersion *string `type:"string" enum:"IPAddressVersion"`
}

// String returns the string representation
func (s RateBasedStatementManagedKeysIPSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RateBasedStatementManagedKeysIPSet) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *RateBasedStatementManagedKeysIPSet) SetAddresses(v []*string) *RateBasedStatementManagedKeysIPSet {
	s.Addresses = v
	return s
}

// SetIPAddressVersion sets the IPAddressVersion field's value.
func (s *RateBasedStatementManagedKeysIPSet) SetIPAddressVersion(v string) *RateBasedStatementManagedKeysIPSet {
	s.IPAddressVersion = &v
	return s
}

// A single regular expression. This is used in a RegexPatternSet.
type Regex struct {
	_ struct{} `type:"structure"`

	// The string representing the regular expression.
	RegexString *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Regex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Regex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Regex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Regex"}
	if s.RegexString != nil && len(*s.RegexString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegexString sets the RegexString field's value.
func (s *Regex) SetRegexString(v string) *Regex {
	s.RegexString = &v
	return s
}

// Contains one or more regular expressions.
//
// WAF assigns an ARN to each RegexPatternSet that you create. To use a set
// in a rule, you provide the ARN to the Rule statement RegexPatternSetReferenceStatement.
type RegexPatternSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string `min:"1" type:"string"`

	// The name of the set. You cannot change the name after you create the set.
	Name *string `min:"1" type:"string"`

	// The regular expression patterns in the set.
	RegularExpressionList []*Regex `type:"list"`
}

// String returns the string representation
func (s RegexPatternSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexPatternSet) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RegexPatternSet) SetARN(v string) *RegexPatternSet {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RegexPatternSet) SetDescription(v string) *RegexPatternSet {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *RegexPatternSet) SetId(v string) *RegexPatternSet {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *RegexPatternSet) SetName(v string) *RegexPatternSet {
	s.Name = &v
	return s
}

// SetRegularExpressionList sets the RegularExpressionList field's value.
func (s *RegexPatternSet) SetRegularExpressionList(v []*Regex) *RegexPatternSet {
	s.RegularExpressionList = v
	return s
}

// A rule statement used to search web request components for matches with regular
// expressions. To use this, create a RegexPatternSet that specifies the expressions
// that you want to detect, then use the ARN of that set in this statement.
// A web request matches the pattern set rule statement if the request component
// matches any of the patterns in the set. To create a regex pattern set, see
// CreateRegexPatternSet.
//
// Each regex pattern set rule statement references a regex pattern set. You
// create and maintain the set independent of your rules. This allows you to
// use the single set in multiple rules. When you update the referenced set,
// WAF automatically updates all rules that reference it.
type RegexPatternSetReferenceStatement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RegexPatternSet that this statement
	// references.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []*TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RegexPatternSetReferenceStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexPatternSetReferenceStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegexPatternSetReferenceStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegexPatternSetReferenceStatement"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.TextTransformations == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RegexPatternSetReferenceStatement) SetARN(v string) *RegexPatternSetReferenceStatement {
	s.ARN = &v
	return s
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *RegexPatternSetReferenceStatement) SetFieldToMatch(v *FieldToMatch) *RegexPatternSetReferenceStatement {
	s.FieldToMatch = v
	return s
}

// SetTextTransformations sets the TextTransformations field's value.
func (s *RegexPatternSetReferenceStatement) SetTextTransformations(v []*TextTransformation) *RegexPatternSetReferenceStatement {
	s.TextTransformations = v
	return s
}

// High-level information about a RegexPatternSet, returned by operations like
// create and list. This provides information like the ID, that you can use
// to retrieve and manage a RegexPatternSet, and the ARN, that you provide to
// the RegexPatternSetReferenceStatement to use the pattern set in a Rule.
type RegexPatternSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the data type instance. You cannot change the name after you
	// create the instance.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RegexPatternSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexPatternSetSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RegexPatternSetSummary) SetARN(v string) *RegexPatternSetSummary {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RegexPatternSetSummary) SetDescription(v string) *RegexPatternSetSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *RegexPatternSetSummary) SetId(v string) *RegexPatternSetSummary {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *RegexPatternSetSummary) SetLockToken(v string) *RegexPatternSetSummary {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *RegexPatternSetSummary) SetName(v string) *RegexPatternSetSummary {
	s.Name = &v
	return s
}

// A single rule, which you can use in a WebACL or RuleGroup to identify web
// requests that you want to allow, block, or count. Each rule includes one
// top-level Statement that WAF uses to identify matching web requests, and
// parameters that govern how WAF handles them.
type Rule struct {
	_ struct{} `type:"structure"`

	// The action that WAF should take on a web request when it matches the rule
	// statement. Settings at the web ACL level can override the rule action setting.
	//
	// This is used only for rules whose statements do not reference a rule group.
	// Rule statements that reference a rule group include RuleGroupReferenceStatement
	// and ManagedRuleGroupStatement.
	//
	// You must specify either this Action setting or the rule OverrideAction setting,
	// but not both:
	//
	//    * If the rule statement does not reference a rule group, use this rule
	//    action setting and not the rule override action setting.
	//
	//    * If the rule statement references a rule group, use the override action
	//    setting and not this action setting.
	Action *RuleAction `type:"structure"`

	// The name of the rule. You can't change the name of a Rule after you create
	// it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The override action to apply to the rules in a rule group. Used only for
	// rule statements that reference a rule group, like RuleGroupReferenceStatement
	// and ManagedRuleGroupStatement.
	//
	// Set the override action to none to leave the rule actions in effect. Set
	// it to count to only count matches, regardless of the rule action settings.
	//
	// In a Rule, you must specify either this OverrideAction setting or the rule
	// Action setting, but not both:
	//
	//    * If the rule statement references a rule group, use this override action
	//    setting and not the action setting.
	//
	//    * If the rule statement does not reference a rule group, use the rule
	//    action setting and not this rule override action setting.
	OverrideAction *OverrideAction `type:"structure"`

	// If you define more than one Rule in a WebACL, WAF evaluates each request
	// against the Rules in order based on the value of Priority. WAF processes
	// rules with lower priority first. The priorities don't need to be consecutive,
	// but they must all be different.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// Labels to apply to web requests that match the rule match statement. WAF
	// applies fully qualified labels to matching web requests. A fully qualified
	// label is the concatenation of a label namespace and a rule label. The rule's
	// rule group or web ACL defines the label namespace.
	//
	// Rules that run after this rule in the web ACL can match against these labels
	// using a LabelMatchStatement.
	//
	// For each label, provide a case-sensitive string containing optional namespaces
	// and a label name, according to the following guidelines:
	//
	//    * Separate each component of the label with a colon.
	//
	//    * Each namespace or name can have up to 128 characters.
	//
	//    * You can specify up to 5 namespaces in a label.
	//
	//    * Don't use the following reserved words in your label specification:
	//    aws, waf, managed, rulegroup, webacl, regexpatternset, or ipset.
	//
	// For example, myLabelName or nameSpace1:nameSpace2:myLabelName.
	RuleLabels []*Label `type:"list"`

	// The WAF processing statement for the rule, for example ByteMatchStatement
	// or SizeConstraintStatement.
	//
	// Statement is a required field
	Statement *Statement `type:"structure" required:"true"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Statement == nil {
		invalidParams.Add(request.NewErrParamRequired("Statement"))
	}
	if s.VisibilityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibilityConfig"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.OverrideAction != nil {
		if err := s.OverrideAction.Validate(); err != nil {
			invalidParams.AddNested("OverrideAction", err.(request.ErrInvalidParams))
		}
	}
	if s.RuleLabels != nil {
		for i, v := range s.RuleLabels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RuleLabels", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Statement != nil {
		if err := s.Statement.Validate(); err != nil {
			invalidParams.AddNested("Statement", err.(request.ErrInvalidParams))
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *Rule) SetAction(v *RuleAction) *Rule {
	s.Action = v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetOverrideAction sets the OverrideAction field's value.
func (s *Rule) SetOverrideAction(v *OverrideAction) *Rule {
	s.OverrideAction = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *Rule) SetPriority(v int64) *Rule {
	s.Priority = &v
	return s
}

// SetRuleLabels sets the RuleLabels field's value.
func (s *Rule) SetRuleLabels(v []*Label) *Rule {
	s.RuleLabels = v
	return s
}

// SetStatement sets the Statement field's value.
func (s *Rule) SetStatement(v *Statement) *Rule {
	s.Statement = v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *Rule) SetVisibilityConfig(v *VisibilityConfig) *Rule {
	s.VisibilityConfig = v
	return s
}

// The action that WAF should take on a web request when it matches a rule's
// statement. Settings at the web ACL level can override the rule action setting.
type RuleAction struct {
	_ struct{} `type:"structure"`

	// Instructs WAF to allow the web request.
	Allow *AllowAction `type:"structure"`

	// Instructs WAF to block the web request.
	Block *BlockAction `type:"structure"`

	// Instructs WAF to count the web request and allow it.
	Count *CountAction `type:"structure"`
}

// String returns the string representation
func (s RuleAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleAction"}
	if s.Allow != nil {
		if err := s.Allow.Validate(); err != nil {
			invalidParams.AddNested("Allow", err.(request.ErrInvalidParams))
		}
	}
	if s.Block != nil {
		if err := s.Block.Validate(); err != nil {
			invalidParams.AddNested("Block", err.(request.ErrInvalidParams))
		}
	}
	if s.Count != nil {
		if err := s.Count.Validate(); err != nil {
			invalidParams.AddNested("Count", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllow sets the Allow field's value.
func (s *RuleAction) SetAllow(v *AllowAction) *RuleAction {
	s.Allow = v
	return s
}

// SetBlock sets the Block field's value.
func (s *RuleAction) SetBlock(v *BlockAction) *RuleAction {
	s.Block = v
	return s
}

// SetCount sets the Count field's value.
func (s *RuleAction) SetCount(v *CountAction) *RuleAction {
	s.Count = v
	return s
}

// A rule group defines a collection of rules to inspect and control web requests
// that you can use in a WebACL. When you create a rule group, you define an
// immutable capacity limit. If you update a rule group, you must stay within
// the capacity. This allows others to reuse the rule group with confidence
// in its capacity requirements.
type RuleGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The labels that one or more rules in this rule group add to matching web
	// requests. These labels are defined in the RuleLabels for a Rule.
	AvailableLabels []*LabelSummary `type:"list"`

	// The web ACL capacity units (WCUs) required for this rule group.
	//
	// When you create your own rule group, you define this, and you cannot change
	// it after creation. When you add or modify the rules in a rule group, WAF
	// enforces this limit. You can check the capacity for a set of rules using
	// CheckCapacity.
	//
	// WAF uses WCUs to calculate and control the operating resources that are used
	// to run your rules, rule groups, and web ACLs. WAF calculates capacity differently
	// for each rule type, to reflect the relative cost of each rule. Simple rules
	// that cost little to run use fewer WCUs than more complex rules that use more
	// processing power. Rule group capacity is fixed at creation, which helps users
	// plan their web ACL WCU usage when they use a rule group. The WCU limit for
	// web ACLs is 1,500.
	//
	// Capacity is a required field
	Capacity *int64 `min:"1" type:"long" required:"true"`

	// The labels that one or more rules in this rule group match against in label
	// match statements. These labels are defined in a LabelMatchStatement specification,
	// in the Statement definition of a rule.
	ConsumedLabels []*LabelSummary `type:"list"`

	// A map of custom response keys and content bodies. When you create a rule
	// with a block action, you can send a custom response to the web request. You
	// define these for the rule group, and then use them in the rules that you
	// define in the rule group.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]*CustomResponseBody `min:"1" type:"map"`

	// A description of the rule group that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The label namespace prefix for this rule group. All labels added by rules
	// in this rule group have this prefix.
	//
	//    * The syntax for the label namespace prefix for your rule groups is the
	//    following: awswaf:<account ID>:rulegroup:<rule group name>:
	//
	//    * When a rule with a label matches a web request, WAF adds the fully qualified
	//    label to the request. A fully qualified label is made up of the label
	//    namespace from the rule group or web ACL where the rule is defined and
	//    the label from the rule, separated by a colon: <label namespace>:<label
	//    from rule>
	LabelNamespace *string `min:"1" type:"string"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses
	// to identify matching web requests, and parameters that govern how WAF handles
	// them.
	Rules []*Rule `type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s RuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RuleGroup) SetARN(v string) *RuleGroup {
	s.ARN = &v
	return s
}

// SetAvailableLabels sets the AvailableLabels field's value.
func (s *RuleGroup) SetAvailableLabels(v []*LabelSummary) *RuleGroup {
	s.AvailableLabels = v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *RuleGroup) SetCapacity(v int64) *RuleGroup {
	s.Capacity = &v
	return s
}

// SetConsumedLabels sets the ConsumedLabels field's value.
func (s *RuleGroup) SetConsumedLabels(v []*LabelSummary) *RuleGroup {
	s.ConsumedLabels = v
	return s
}

// SetCustomResponseBodies sets the CustomResponseBodies field's value.
func (s *RuleGroup) SetCustomResponseBodies(v map[string]*CustomResponseBody) *RuleGroup {
	s.CustomResponseBodies = v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuleGroup) SetDescription(v string) *RuleGroup {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *RuleGroup) SetId(v string) *RuleGroup {
	s.Id = &v
	return s
}

// SetLabelNamespace sets the LabelNamespace field's value.
func (s *RuleGroup) SetLabelNamespace(v string) *RuleGroup {
	s.LabelNamespace = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleGroup) SetName(v string) *RuleGroup {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *RuleGroup) SetRules(v []*Rule) *RuleGroup {
	s.Rules = v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *RuleGroup) SetVisibilityConfig(v *VisibilityConfig) *RuleGroup {
	s.VisibilityConfig = v
	return s
}

// A rule statement used to run the rules that are defined in a RuleGroup. To
// use this, create a rule group with your rules, then provide the ARN of the
// rule group in this statement.
//
// You cannot nest a RuleGroupReferenceStatement, for example for use inside
// a NotStatement or OrStatement. It can only be referenced as a top-level statement
// within a rule.
type RuleGroupReferenceStatement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The names of rules that are in the referenced rule group, but that you want
	// WAF to exclude from processing for this rule statement.
	ExcludedRules []*ExcludedRule `type:"list"`
}

// String returns the string representation
func (s RuleGroupReferenceStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleGroupReferenceStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleGroupReferenceStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleGroupReferenceStatement"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.ExcludedRules != nil {
		for i, v := range s.ExcludedRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RuleGroupReferenceStatement) SetARN(v string) *RuleGroupReferenceStatement {
	s.ARN = &v
	return s
}

// SetExcludedRules sets the ExcludedRules field's value.
func (s *RuleGroupReferenceStatement) SetExcludedRules(v []*ExcludedRule) *RuleGroupReferenceStatement {
	s.ExcludedRules = v
	return s
}

// High-level information about a RuleGroup, returned by operations like create
// and list. This provides information like the ID, that you can use to retrieve
// and manage a RuleGroup, and the ARN, that you provide to the RuleGroupReferenceStatement
// to use the rule group in a Rule.
type RuleGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the rule group that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the data type instance. You cannot change the name after you
	// create the instance.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RuleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleGroupSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RuleGroupSummary) SetARN(v string) *RuleGroupSummary {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuleGroupSummary) SetDescription(v string) *RuleGroupSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *RuleGroupSummary) SetId(v string) *RuleGroupSummary {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *RuleGroupSummary) SetLockToken(v string) *RuleGroupSummary {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleGroupSummary) SetName(v string) *RuleGroupSummary {
	s.Name = &v
	return s
}

// High-level information about a Rule, returned by operations like DescribeManagedRuleGroup.
// This provides information like the ID, that you can use to retrieve and manage
// a RuleGroup, and the ARN, that you provide to the RuleGroupReferenceStatement
// to use the rule group in a Rule.
type RuleSummary struct {
	_ struct{} `type:"structure"`

	// The action that WAF should take on a web request when it matches a rule's
	// statement. Settings at the web ACL level can override the rule action setting.
	Action *RuleAction `type:"structure"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleSummary) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RuleSummary) SetAction(v *RuleAction) *RuleSummary {
	s.Action = v
	return s
}

// SetName sets the Name field's value.
func (s *RuleSummary) SetName(v string) *RuleSummary {
	s.Name = &v
	return s
}

// Represents a single sampled web request. The response from GetSampledRequests
// includes a SampledHTTPRequests complex type that appears as SampledRequests
// in the response syntax. SampledHTTPRequests contains an array of SampledHTTPRequest
// objects.
type SampledHTTPRequest struct {
	_ struct{} `type:"structure"`

	// The action for the Rule that the request matched: ALLOW, BLOCK, or COUNT.
	Action *string `type:"string"`

	// Labels applied to the web request by matching rules. WAF applies fully qualified
	// labels to matching web requests. A fully qualified label is the concatenation
	// of a label namespace and a rule label. The rule's rule group or web ACL defines
	// the label namespace.
	//
	// For example, awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA
	// or awswaf:managed:aws:managed-rule-set:header:encoding:utf8.
	Labels []*Label `type:"list"`

	// A complex type that contains detailed information about the request.
	//
	// Request is a required field
	Request *HTTPRequest `type:"structure" required:"true"`

	// Custom request headers inserted by WAF into the request, according to the
	// custom request configuration for the matching rule action.
	RequestHeadersInserted []*HTTPHeader `type:"list"`

	// The response code that was sent for the request.
	ResponseCodeSent *int64 `min:"200" type:"integer"`

	// The name of the Rule that the request matched. For managed rule groups, the
	// format for this name is <vendor name>#<managed rule group name>#<rule name>.
	// For your own rule groups, the format for this name is <rule group name>#<rule
	// name>. If the rule is not in a rule group, this field is absent.
	RuleNameWithinRuleGroup *string `min:"1" type:"string"`

	// The time at which WAF received the request from your Amazon Web Services
	// resource, in Unix time format (in seconds).
	Timestamp *time.Time `type:"timestamp"`

	// A value that indicates how one result in the response relates proportionally
	// to other results in the response. For example, a result that has a weight
	// of 2 represents roughly twice as many web requests as a result that has a
	// weight of 1.
	//
	// Weight is a required field
	Weight *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s SampledHTTPRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SampledHTTPRequest) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *SampledHTTPRequest) SetAction(v string) *SampledHTTPRequest {
	s.Action = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *SampledHTTPRequest) SetLabels(v []*Label) *SampledHTTPRequest {
	s.Labels = v
	return s
}

// SetRequest sets the Request field's value.
func (s *SampledHTTPRequest) SetRequest(v *HTTPRequest) *SampledHTTPRequest {
	s.Request = v
	return s
}

// SetRequestHeadersInserted sets the RequestHeadersInserted field's value.
func (s *SampledHTTPRequest) SetRequestHeadersInserted(v []*HTTPHeader) *SampledHTTPRequest {
	s.RequestHeadersInserted = v
	return s
}

// SetResponseCodeSent sets the ResponseCodeSent field's value.
func (s *SampledHTTPRequest) SetResponseCodeSent(v int64) *SampledHTTPRequest {
	s.ResponseCodeSent = &v
	return s
}

// SetRuleNameWithinRuleGroup sets the RuleNameWithinRuleGroup field's value.
func (s *SampledHTTPRequest) SetRuleNameWithinRuleGroup(v string) *SampledHTTPRequest {
	s.RuleNameWithinRuleGroup = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SampledHTTPRequest) SetTimestamp(v time.Time) *SampledHTTPRequest {
	s.Timestamp = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *SampledHTTPRequest) SetWeight(v int64) *SampledHTTPRequest {
	s.Weight = &v
	return s
}

// One of the headers in a web request, identified by name, for example, User-Agent
// or Referer. This setting isn't case sensitive.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type SingleHeader struct {
	_ struct{} `type:"structure"`

	// The name of the query header to inspect.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SingleHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingleHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingleHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SingleHeader"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SingleHeader) SetName(v string) *SingleHeader {
	s.Name = &v
	return s
}

// One query argument in a web request, identified by name, for example UserName
// or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
type SingleQueryArgument struct {
	_ struct{} `type:"structure"`

	// The name of the query argument to inspect.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SingleQueryArgument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingleQueryArgument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingleQueryArgument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SingleQueryArgument"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SingleQueryArgument) SetName(v string) *SingleQueryArgument {
	s.Name = &v
	return s
}

// A rule statement that compares a number of bytes against the size of a request
// component, using a comparison operator, such as greater than (>) or less
// than (<). For example, you can use a size constraint statement to look for
// query strings that are longer than 100 bytes.
//
// If you configure WAF to inspect the request body, WAF inspects only the first
// 8192 bytes (8 KB). If the request body for your web requests never exceeds
// 8192 bytes, you can create a size constraint condition and block requests
// that have a request body greater than 8192 bytes.
//
// If you choose URI for the value of Part of the request to filter on, the
// slash (/) in the URI counts as one character. For example, the URI /logo.jpg
// is nine characters long.
type SizeConstraintStatement struct {
	_ struct{} `type:"structure"`

	// The operator to use to compare the request part to the size setting.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The size, in byte, to compare to the request part, after any transformations.
	//
	// Size is a required field
	Size *int64 `type:"long" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []*TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SizeConstraintStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SizeConstraintStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SizeConstraintStatement"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.TextTransformations == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *SizeConstraintStatement) SetComparisonOperator(v string) *SizeConstraintStatement {
	s.ComparisonOperator = &v
	return s
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *SizeConstraintStatement) SetFieldToMatch(v *FieldToMatch) *SizeConstraintStatement {
	s.FieldToMatch = v
	return s
}

// SetSize sets the Size field's value.
func (s *SizeConstraintStatement) SetSize(v int64) *SizeConstraintStatement {
	s.Size = &v
	return s
}

// SetTextTransformations sets the TextTransformations field's value.
func (s *SizeConstraintStatement) SetTextTransformations(v []*TextTransformation) *SizeConstraintStatement {
	s.TextTransformations = v
	return s
}

// Attackers sometimes insert malicious SQL code into web requests in an effort
// to extract data from your database. To allow or block web requests that appear
// to contain malicious SQL code, create one or more SQL injection match conditions.
// An SQL injection match condition identifies the part of web requests, such
// as the URI or the query string, that you want WAF to inspect. Later in the
// process, when you create a web ACL, you specify whether to allow or block
// requests that appear to contain malicious SQL code.
type SqliMatchStatement struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []*TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SqliMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqliMatchStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqliMatchStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqliMatchStatement"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.TextTransformations == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *SqliMatchStatement) SetFieldToMatch(v *FieldToMatch) *SqliMatchStatement {
	s.FieldToMatch = v
	return s
}

// SetTextTransformations sets the TextTransformations field's value.
func (s *SqliMatchStatement) SetTextTransformations(v []*TextTransformation) *SqliMatchStatement {
	s.TextTransformations = v
	return s
}

// The processing guidance for a Rule, used by WAF to determine whether a web
// request matches the rule.
type Statement struct {
	_ struct{} `type:"structure"`

	// A logical rule statement used to combine other rule statements with AND logic.
	// You provide more than one Statement within the AndStatement.
	AndStatement *AndStatement `type:"structure"`

	// A rule statement that defines a string match search for WAF to apply to web
	// requests. The byte match statement provides the bytes to search for, the
	// location in requests that you want WAF to search, and other settings. The
	// bytes to search for are typically a string that corresponds with ASCII characters.
	// In the WAF console and the developer guide, this is refered to as a string
	// match statement.
	ByteMatchStatement *ByteMatchStatement `type:"structure"`

	// A rule statement used to identify web requests based on country of origin.
	GeoMatchStatement *GeoMatchStatement `type:"structure"`

	// A rule statement used to detect web requests coming from particular IP addresses
	// or address ranges. To use this, create an IPSet that specifies the addresses
	// you want to detect, then use the ARN of that set in this statement. To create
	// an IP set, see CreateIPSet.
	//
	// Each IP set rule statement references an IP set. You create and maintain
	// the set independent of your rules. This allows you to use the single set
	// in multiple rules. When you update the referenced set, WAF automatically
	// updates all rules that reference it.
	IPSetReferenceStatement *IPSetReferenceStatement `type:"structure"`

	// A rule statement that defines a string match search against labels that have
	// been added to the web request by rules that have already run in the web ACL.
	//
	// The label match statement provides the label or namespace string to search
	// for. The label string can represent a part or all of the fully qualified
	// label name that had been added to the web request. Fully qualified labels
	// have a prefix, optional namespaces, and label name. The prefix identifies
	// the rule group or web ACL context of the rule that added the label. If you
	// do not provide the fully qualified name in your label match string, WAF performs
	// the search for labels that were added in the same context as the label match
	// statement.
	LabelMatchStatement *LabelMatchStatement `type:"structure"`

	// A rule statement used to run the rules that are defined in a managed rule
	// group. To use this, provide the vendor name and the name of the rule group
	// in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
	//
	// You cannot nest a ManagedRuleGroupStatement, for example for use inside a
	// NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	ManagedRuleGroupStatement *ManagedRuleGroupStatement `type:"structure"`

	// A logical rule statement used to negate the results of another rule statement.
	// You provide one Statement within the NotStatement.
	NotStatement *NotStatement `type:"structure"`

	// A logical rule statement used to combine other rule statements with OR logic.
	// You provide more than one Statement within the OrStatement.
	OrStatement *OrStatement `type:"structure"`

	// A rate-based rule tracks the rate of requests for each originating IP address,
	// and triggers the rule action when the rate exceeds a limit that you specify
	// on the number of requests in any 5-minute time span. You can use this to
	// put a temporary block on requests from an IP address that is sending excessive
	// requests.
	//
	// When the rule action triggers, WAF blocks additional requests from the IP
	// address until the request rate falls below the limit.
	//
	// You can optionally nest another statement inside the rate-based statement,
	// to narrow the scope of the rule so that it only counts requests that match
	// the nested statement. For example, based on recent requests that you have
	// seen from an attacker, you might create a rate-based rule with a nested AND
	// rule statement that contains the following nested statements:
	//
	//    * An IP match statement with an IP set that specified the address 192.0.2.44.
	//
	//    * A string match statement that searches in the User-Agent header for
	//    the string BadBot.
	//
	// In this rate-based rule, you also define a rate limit. For this example,
	// the rate limit is 1,000. Requests that meet both of the conditions in the
	// statements are counted. If the count exceeds 1,000 requests per five minutes,
	// the rule action triggers. Requests that do not meet both conditions are not
	// counted towards the rate limit and are not affected by this rule.
	//
	// You cannot nest a RateBasedStatement, for example for use inside a NotStatement
	// or OrStatement. It can only be referenced as a top-level statement within
	// a rule.
	RateBasedStatement *RateBasedStatement `type:"structure"`

	// A rule statement used to search web request components for matches with regular
	// expressions. To use this, create a RegexPatternSet that specifies the expressions
	// that you want to detect, then use the ARN of that set in this statement.
	// A web request matches the pattern set rule statement if the request component
	// matches any of the patterns in the set. To create a regex pattern set, see
	// CreateRegexPatternSet.
	//
	// Each regex pattern set rule statement references a regex pattern set. You
	// create and maintain the set independent of your rules. This allows you to
	// use the single set in multiple rules. When you update the referenced set,
	// WAF automatically updates all rules that reference it.
	RegexPatternSetReferenceStatement *RegexPatternSetReferenceStatement `type:"structure"`

	// A rule statement used to run the rules that are defined in a RuleGroup. To
	// use this, create a rule group with your rules, then provide the ARN of the
	// rule group in this statement.
	//
	// You cannot nest a RuleGroupReferenceStatement, for example for use inside
	// a NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	RuleGroupReferenceStatement *RuleGroupReferenceStatement `type:"structure"`

	// A rule statement that compares a number of bytes against the size of a request
	// component, using a comparison operator, such as greater than (>) or less
	// than (<). For example, you can use a size constraint statement to look for
	// query strings that are longer than 100 bytes.
	//
	// If you configure WAF to inspect the request body, WAF inspects only the first
	// 8192 bytes (8 KB). If the request body for your web requests never exceeds
	// 8192 bytes, you can create a size constraint condition and block requests
	// that have a request body greater than 8192 bytes.
	//
	// If you choose URI for the value of Part of the request to filter on, the
	// slash (/) in the URI counts as one character. For example, the URI /logo.jpg
	// is nine characters long.
	SizeConstraintStatement *SizeConstraintStatement `type:"structure"`

	// Attackers sometimes insert malicious SQL code into web requests in an effort
	// to extract data from your database. To allow or block web requests that appear
	// to contain malicious SQL code, create one or more SQL injection match conditions.
	// An SQL injection match condition identifies the part of web requests, such
	// as the URI or the query string, that you want WAF to inspect. Later in the
	// process, when you create a web ACL, you specify whether to allow or block
	// requests that appear to contain malicious SQL code.
	SqliMatchStatement *SqliMatchStatement `type:"structure"`

	// A rule statement that defines a cross-site scripting (XSS) match search for
	// WAF to apply to web requests. XSS attacks are those where the attacker uses
	// vulnerabilities in a benign website as a vehicle to inject malicious client-site
	// scripts into other legitimate web browsers. The XSS match statement provides
	// the location in requests that you want WAF to search and text transformations
	// to use on the search area before WAF searches for character sequences that
	// are likely to be malicious strings.
	XssMatchStatement *XssMatchStatement `type:"structure"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Statement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Statement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Statement"}
	if s.AndStatement != nil {
		if err := s.AndStatement.Validate(); err != nil {
			invalidParams.AddNested("AndStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.ByteMatchStatement != nil {
		if err := s.ByteMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("ByteMatchStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.GeoMatchStatement != nil {
		if err := s.GeoMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("GeoMatchStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.IPSetReferenceStatement != nil {
		if err := s.IPSetReferenceStatement.Validate(); err != nil {
			invalidParams.AddNested("IPSetReferenceStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.LabelMatchStatement != nil {
		if err := s.LabelMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("LabelMatchStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.ManagedRuleGroupStatement != nil {
		if err := s.ManagedRuleGroupStatement.Validate(); err != nil {
			invalidParams.AddNested("ManagedRuleGroupStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.NotStatement != nil {
		if err := s.NotStatement.Validate(); err != nil {
			invalidParams.AddNested("NotStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.OrStatement != nil {
		if err := s.OrStatement.Validate(); err != nil {
			invalidParams.AddNested("OrStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.RateBasedStatement != nil {
		if err := s.RateBasedStatement.Validate(); err != nil {
			invalidParams.AddNested("RateBasedStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.RegexPatternSetReferenceStatement != nil {
		if err := s.RegexPatternSetReferenceStatement.Validate(); err != nil {
			invalidParams.AddNested("RegexPatternSetReferenceStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.RuleGroupReferenceStatement != nil {
		if err := s.RuleGroupReferenceStatement.Validate(); err != nil {
			invalidParams.AddNested("RuleGroupReferenceStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.SizeConstraintStatement != nil {
		if err := s.SizeConstraintStatement.Validate(); err != nil {
			invalidParams.AddNested("SizeConstraintStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.SqliMatchStatement != nil {
		if err := s.SqliMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("SqliMatchStatement", err.(request.ErrInvalidParams))
		}
	}
	if s.XssMatchStatement != nil {
		if err := s.XssMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("XssMatchStatement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndStatement sets the AndStatement field's value.
func (s *Statement) SetAndStatement(v *AndStatement) *Statement {
	s.AndStatement = v
	return s
}

// SetByteMatchStatement sets the ByteMatchStatement field's value.
func (s *Statement) SetByteMatchStatement(v *ByteMatchStatement) *Statement {
	s.ByteMatchStatement = v
	return s
}

// SetGeoMatchStatement sets the GeoMatchStatement field's value.
func (s *Statement) SetGeoMatchStatement(v *GeoMatchStatement) *Statement {
	s.GeoMatchStatement = v
	return s
}

// SetIPSetReferenceStatement sets the IPSetReferenceStatement field's value.
func (s *Statement) SetIPSetReferenceStatement(v *IPSetReferenceStatement) *Statement {
	s.IPSetReferenceStatement = v
	return s
}

// SetLabelMatchStatement sets the LabelMatchStatement field's value.
func (s *Statement) SetLabelMatchStatement(v *LabelMatchStatement) *Statement {
	s.LabelMatchStatement = v
	return s
}

// SetManagedRuleGroupStatement sets the ManagedRuleGroupStatement field's value.
func (s *Statement) SetManagedRuleGroupStatement(v *ManagedRuleGroupStatement) *Statement {
	s.ManagedRuleGroupStatement = v
	return s
}

// SetNotStatement sets the NotStatement field's value.
func (s *Statement) SetNotStatement(v *NotStatement) *Statement {
	s.NotStatement = v
	return s
}

// SetOrStatement sets the OrStatement field's value.
func (s *Statement) SetOrStatement(v *OrStatement) *Statement {
	s.OrStatement = v
	return s
}

// SetRateBasedStatement sets the RateBasedStatement field's value.
func (s *Statement) SetRateBasedStatement(v *RateBasedStatement) *Statement {
	s.RateBasedStatement = v
	return s
}

// SetRegexPatternSetReferenceStatement sets the RegexPatternSetReferenceStatement field's value.
func (s *Statement) SetRegexPatternSetReferenceStatement(v *RegexPatternSetReferenceStatement) *Statement {
	s.RegexPatternSetReferenceStatement = v
	return s
}

// SetRuleGroupReferenceStatement sets the RuleGroupReferenceStatement field's value.
func (s *Statement) SetRuleGroupReferenceStatement(v *RuleGroupReferenceStatement) *Statement {
	s.RuleGroupReferenceStatement = v
	return s
}

// SetSizeConstraintStatement sets the SizeConstraintStatement field's value.
func (s *Statement) SetSizeConstraintStatement(v *SizeConstraintStatement) *Statement {
	s.SizeConstraintStatement = v
	return s
}

// SetSqliMatchStatement sets the SqliMatchStatement field's value.
func (s *Statement) SetSqliMatchStatement(v *SqliMatchStatement) *Statement {
	s.SqliMatchStatement = v
	return s
}

// SetXssMatchStatement sets the XssMatchStatement field's value.
func (s *Statement) SetXssMatchStatement(v *XssMatchStatement) *Statement {
	s.XssMatchStatement = v
	return s
}

// A tag associated with an Amazon Web Services resource. Tags are key:value
// pairs that you can use to categorize and manage your resources, for purposes
// like billing or other management. Typically, the tag key represents a category,
// such as "environment", and the tag value represents a specific value within
// that category, such as "test," "development," or "production". Or you might
// set the tag key to "customer" and the value to the customer name or ID. You
// can specify one or more tags to add to each Amazon Web Services resource,
// up to 50 tags for a resource.
//
// You can tag the Amazon Web Services resources that you manage through WAF:
// web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage
// or view tags through the WAF console.
type Tag struct {
	_ struct{} `type:"structure"`

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The collection of tagging definitions for an Amazon Web Services resource.
// Tags are key:value pairs that you can use to categorize and manage your resources,
// for purposes like billing or other management. Typically, the tag key represents
// a category, such as "environment", and the tag value represents a specific
// value within that category, such as "test," "development," or "production".
// Or you might set the tag key to "customer" and the value to the customer
// name or ID. You can specify one or more tags to add to each Amazon Web Services
// resource, up to 50 tags for a resource.
//
// You can tag the Amazon Web Services resources that you manage through WAF:
// web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage
// or view tags through the WAF console.
type TagInfoForResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceARN *string `min:"20" type:"string"`

	// The array of Tag objects defined for the resource.
	TagList []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s TagInfoForResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagInfoForResource) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagInfoForResource) SetResourceARN(v string) *TagInfoForResource {
	s.ResourceARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *TagInfoForResource) SetTagList(v []*Tag) *TagInfoForResource {
	s.TagList = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"20" type:"string" required:"true"`

	// An array of key:value pairs to associate with the resource.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Text transformations eliminate some of the unusual formatting that attackers
// use in web requests in an effort to bypass detection.
type TextTransformation struct {
	_ struct{} `type:"structure"`

	// Sets the relative processing order for multiple transformations that are
	// defined for a rule statement. WAF processes all transformations, from lowest
	// priority to highest, before inspecting the transformed content. The priorities
	// don't need to be consecutive, but they must all be different.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// You can specify the following transformation types:
	//
	// BASE64_DECODE - Decode a Base64-encoded string.
	//
	// BASE64_DECODE_EXT - Decode a Base64-encoded string, but use a forgiving implementation
	// that ignores characters that aren't valid.
	//
	// CMD_LINE - Command-line transformations. These are helpful in reducing effectiveness
	// of attackers who inject an operating system command-line command and use
	// unusual formatting to disguise some or all of the command.
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE - Replace these characters with a space character (decimal
	// 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * Non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// CSS_DECODE - Decode characters that were encoded using CSS 2.x escape rules
	// syndata.html#characters. This function uses up to two bytes in the decoding
	// process, so it can help to uncover ASCII characters that were encoded using
	// CSS encoding that wouldn’t typically be encoded. It's also useful in countering
	// evasion, which is a combination of a backslash and non-hexadecimal characters.
	// For example, ja\vascript for javascript.
	//
	// ESCAPE_SEQ_DECODE - Decode the following ANSI C escape sequences: \a, \b,
	// \f, \n, \r, \t, \v, \\, \?, \', \", \xHH (hexadecimal), \0OOO (octal). Encodings
	// that aren't valid remain in the output.
	//
	// HEX_DECODE - Decode a string of hexadecimal characters into a binary.
	//
	// HTML_ENTITY_DECODE - Replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs these operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// JS_DECODE - Decode JavaScript escape sequences. If a \ u HHHH code is in
	// the full-width ASCII code range of FF01-FF5E, then the higher byte is used
	// to detect and adjust the lower byte. If not, only the lower byte is used
	// and the higher byte is zeroed, causing a possible loss of information.
	//
	// LOWERCASE - Convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// MD5 - Calculate an MD5 hash from the data in the input. The computed hash
	// is in a raw binary form.
	//
	// NONE - Specify NONE if you don't want any text transformations.
	//
	// NORMALIZE_PATH - Remove multiple slashes, directory self-references, and
	// directory back-references that are not at the beginning of the input from
	// an input string.
	//
	// NORMALIZE_PATH_WIN - This is the same as NORMALIZE_PATH, but first converts
	// backslash characters to forward slashes.
	//
	// REMOVE_NULLS - Remove all NULL bytes from the input.
	//
	// REPLACE_COMMENTS - Replace each occurrence of a C-style comment (/* ... */)
	// with a single space. Multiple consecutive occurrences are not compressed.
	// Unterminated comments are also replaced with a space (ASCII 0x20). However,
	// a standalone termination of a comment (*/) is not acted upon.
	//
	// REPLACE_NULLS - Replace NULL bytes in the input with space characters (ASCII
	// 0x20).
	//
	// SQL_HEX_DECODE - Decode SQL hex data. Example (0x414243) will be decoded
	// to (ABC).
	//
	// URL_DECODE - Decode a URL-encoded value.
	//
	// URL_DECODE_UNI - Like URL_DECODE, but with support for Microsoft-specific
	// %u encoding. If the code is in the full-width ASCII code range of FF01-FF5E,
	// the higher byte is used to detect and adjust the lower byte. Otherwise, only
	// the lower byte is used and the higher byte is zeroed.
	//
	// UTF8_TO_UNICODE - Convert all UTF-8 character sequences to Unicode. This
	// helps input normalization, and minimizing false-positives and false-negatives
	// for non-English languages.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TextTransformationType"`
}

// String returns the string representation
func (s TextTransformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextTransformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextTransformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextTransformation"}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPriority sets the Priority field's value.
func (s *TextTransformation) SetPriority(v int64) *TextTransformation {
	s.Priority = &v
	return s
}

// SetType sets the Type field's value.
func (s *TextTransformation) SetType(v string) *TextTransformation {
	s.Type = &v
	return s
}

// In a GetSampledRequests request, the StartTime and EndTime objects specify
// the time range for which you want WAF to return a sample of web requests.
//
// You must specify the times in Coordinated Universal Time (UTC) format. UTC
// format includes the special designator, Z. For example, "2016-09-27T14:50Z".
// You can specify any time range in the previous three hours.
//
// In a GetSampledRequests response, the StartTime and EndTime objects specify
// the time range for which WAF actually returned a sample of web requests.
// WAF gets the specified number of requests from among the first 5,000 requests
// that your Amazon Web Services resource receives during the specified time
// period. If your resource receives more than 5,000 requests during that period,
// WAF stops sampling after the 5,000th request. In that case, EndTime is the
// time that WAF received the 5,000th request.
type TimeWindow struct {
	_ struct{} `type:"structure"`

	// The end of the time range from which you want GetSampledRequests to return
	// a sample of the requests that your Amazon Web Services resource received.
	// You must specify the times in Coordinated Universal Time (UTC) format. UTC
	// format includes the special designator, Z. For example, "2016-09-27T14:50Z".
	// You can specify any time range in the previous three hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The beginning of the time range from which you want GetSampledRequests to
	// return a sample of the requests that your Amazon Web Services resource received.
	// You must specify the times in Coordinated Universal Time (UTC) format. UTC
	// format includes the special designator, Z. For example, "2016-09-27T14:50Z".
	// You can specify any time range in the previous three hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TimeWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeWindow"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *TimeWindow) SetEndTime(v time.Time) *TimeWindow {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeWindow) SetStartTime(v time.Time) *TimeWindow {
	s.StartTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"20" type:"string" required:"true"`

	// An array of keys identifying the tags to disassociate from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateIPSetInput struct {
	_ struct{} `type:"structure"`

	// Contains an array of strings that specify one or more IP addresses or blocks
	// of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports
	// all IPv4 and IPv6 CIDR ranges except for /0.
	//
	// Examples:
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
	//
	//    * To configure WAF to allow, block, or count requests that originated
	//    from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff,
	//    specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Addresses is a required field
	Addresses []*string `type:"list" required:"true"`

	// A description of the IP set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s UpdateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIPSetInput"}
	if s.Addresses == nil {
		invalidParams.Add(request.NewErrParamRequired("Addresses"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddresses sets the Addresses field's value.
func (s *UpdateIPSetInput) SetAddresses(v []*string) *UpdateIPSetInput {
	s.Addresses = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIPSetInput) SetDescription(v string) *UpdateIPSetInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateIPSetInput) SetId(v string) *UpdateIPSetInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *UpdateIPSetInput) SetLockToken(v string) *UpdateIPSetInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateIPSetInput) SetName(v string) *UpdateIPSetInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateIPSetInput) SetScope(v string) *UpdateIPSetInput {
	s.Scope = &v
	return s
}

type UpdateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns this token to your update
	// requests. You use NextLockToken in the same manner as you use LockToken.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetOutput) GoString() string {
	return s.String()
}

// SetNextLockToken sets the NextLockToken field's value.
func (s *UpdateIPSetOutput) SetNextLockToken(v string) *UpdateIPSetOutput {
	s.NextLockToken = &v
	return s
}

type UpdateManagedRuleSetVersionExpiryDateInput struct {
	_ struct{} `type:"structure"`

	// The time that you want the version to expire.
	//
	// Times are in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z".
	//
	// ExpiryTimestamp is a required field
	ExpiryTimestamp *time.Time `type:"timestamp" required:"true"`

	// A unique identifier for the managed rule set. The ID is returned in the responses
	// to commands like list. You provide it to operations like get and update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the managed rule set. You use this, along with the rule set ID,
	// to identify the rule set.
	//
	// This name is assigned to the corresponding managed rule group, which your
	// customers can access and use.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// The version that you want to remove from your list of offerings for the named
	// managed rule group.
	//
	// VersionToExpire is a required field
	VersionToExpire *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateManagedRuleSetVersionExpiryDateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateManagedRuleSetVersionExpiryDateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateManagedRuleSetVersionExpiryDateInput"}
	if s.ExpiryTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpiryTimestamp"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.VersionToExpire == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionToExpire"))
	}
	if s.VersionToExpire != nil && len(*s.VersionToExpire) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionToExpire", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpiryTimestamp sets the ExpiryTimestamp field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) SetExpiryTimestamp(v time.Time) *UpdateManagedRuleSetVersionExpiryDateInput {
	s.ExpiryTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) SetId(v string) *UpdateManagedRuleSetVersionExpiryDateInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) SetLockToken(v string) *UpdateManagedRuleSetVersionExpiryDateInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) SetName(v string) *UpdateManagedRuleSetVersionExpiryDateInput {
	s.Name = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) SetScope(v string) *UpdateManagedRuleSetVersionExpiryDateInput {
	s.Scope = &v
	return s
}

// SetVersionToExpire sets the VersionToExpire field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateInput) SetVersionToExpire(v string) *UpdateManagedRuleSetVersionExpiryDateInput {
	s.VersionToExpire = &v
	return s
}

type UpdateManagedRuleSetVersionExpiryDateOutput struct {
	_ struct{} `type:"structure"`

	// The version that is set to expire.
	ExpiringVersion *string `min:"1" type:"string"`

	// The time that the version will expire.
	//
	// Times are in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z".
	ExpiryTimestamp *time.Time `type:"timestamp"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateManagedRuleSetVersionExpiryDateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateManagedRuleSetVersionExpiryDateOutput) GoString() string {
	return s.String()
}

// SetExpiringVersion sets the ExpiringVersion field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateOutput) SetExpiringVersion(v string) *UpdateManagedRuleSetVersionExpiryDateOutput {
	s.ExpiringVersion = &v
	return s
}

// SetExpiryTimestamp sets the ExpiryTimestamp field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateOutput) SetExpiryTimestamp(v time.Time) *UpdateManagedRuleSetVersionExpiryDateOutput {
	s.ExpiryTimestamp = &v
	return s
}

// SetNextLockToken sets the NextLockToken field's value.
func (s *UpdateManagedRuleSetVersionExpiryDateOutput) SetNextLockToken(v string) *UpdateManagedRuleSetVersionExpiryDateOutput {
	s.NextLockToken = &v
	return s
}

type UpdateRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// A description of the set that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the set. You cannot change the name after you create the set.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// RegularExpressionList is a required field
	RegularExpressionList []*Regex `type:"list" required:"true"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`
}

// String returns the string representation
func (s UpdateRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRegexPatternSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RegularExpressionList == nil {
		invalidParams.Add(request.NewErrParamRequired("RegularExpressionList"))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.RegularExpressionList != nil {
		for i, v := range s.RegularExpressionList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RegularExpressionList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRegexPatternSetInput) SetDescription(v string) *UpdateRegexPatternSetInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRegexPatternSetInput) SetId(v string) *UpdateRegexPatternSetInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *UpdateRegexPatternSetInput) SetLockToken(v string) *UpdateRegexPatternSetInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRegexPatternSetInput) SetName(v string) *UpdateRegexPatternSetInput {
	s.Name = &v
	return s
}

// SetRegularExpressionList sets the RegularExpressionList field's value.
func (s *UpdateRegexPatternSetInput) SetRegularExpressionList(v []*Regex) *UpdateRegexPatternSetInput {
	s.RegularExpressionList = v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateRegexPatternSetInput) SetScope(v string) *UpdateRegexPatternSetInput {
	s.Scope = &v
	return s
}

type UpdateRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns this token to your update
	// requests. You use NextLockToken in the same manner as you use LockToken.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetNextLockToken sets the NextLockToken field's value.
func (s *UpdateRegexPatternSetOutput) SetNextLockToken(v string) *UpdateRegexPatternSetOutput {
	s.NextLockToken = &v
	return s
}

type UpdateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// A map of custom response keys and content bodies. When you create a rule
	// with a block action, you can send a custom response to the web request. You
	// define these for the rule group, and then use them in the rules that you
	// define in the rule group.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]*CustomResponseBody `min:"1" type:"map"`

	// A description of the rule group that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses
	// to identify matching web requests, and parameters that govern how WAF handles
	// them.
	Rules []*Rule `type:"list"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleGroupInput"}
	if s.CustomResponseBodies != nil && len(s.CustomResponseBodies) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomResponseBodies", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.VisibilityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibilityConfig"))
	}
	if s.CustomResponseBodies != nil {
		for i, v := range s.CustomResponseBodies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomResponseBodies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomResponseBodies sets the CustomResponseBodies field's value.
func (s *UpdateRuleGroupInput) SetCustomResponseBodies(v map[string]*CustomResponseBody) *UpdateRuleGroupInput {
	s.CustomResponseBodies = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleGroupInput) SetDescription(v string) *UpdateRuleGroupInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRuleGroupInput) SetId(v string) *UpdateRuleGroupInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *UpdateRuleGroupInput) SetLockToken(v string) *UpdateRuleGroupInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRuleGroupInput) SetName(v string) *UpdateRuleGroupInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateRuleGroupInput) SetRules(v []*Rule) *UpdateRuleGroupInput {
	s.Rules = v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateRuleGroupInput) SetScope(v string) *UpdateRuleGroupInput {
	s.Scope = &v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *UpdateRuleGroupInput) SetVisibilityConfig(v *VisibilityConfig) *UpdateRuleGroupInput {
	s.VisibilityConfig = v
	return s
}

type UpdateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns this token to your update
	// requests. You use NextLockToken in the same manner as you use LockToken.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleGroupOutput) GoString() string {
	return s.String()
}

// SetNextLockToken sets the NextLockToken field's value.
func (s *UpdateRuleGroupOutput) SetNextLockToken(v string) *UpdateRuleGroupOutput {
	s.NextLockToken = &v
	return s
}

type UpdateWebACLInput struct {
	_ struct{} `type:"structure"`

	// A map of custom response keys and content bodies. When you create a rule
	// with a block action, you can send a custom response to the web request. You
	// define these for the web ACL, and then use them in the rules and default
	// actions that you define in the web ACL.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]*CustomResponseBody `min:"1" type:"map"`

	// The action to perform if none of the Rules contained in the WebACL match.
	//
	// DefaultAction is a required field
	DefaultAction *DefaultAction `type:"structure" required:"true"`

	// A description of the web ACL that helps with identification.
	Description *string `min:"1" type:"string"`

	// The unique identifier for the web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses
	// to identify matching web requests, and parameters that govern how WAF handles
	// them.
	Rules []*Rule `type:"list"`

	// Specifies whether this is for an Amazon CloudFront distribution or for a
	// regional application. A regional application can be an Application Load Balancer
	// (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"Scope"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWebACLInput"}
	if s.CustomResponseBodies != nil && len(s.CustomResponseBodies) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomResponseBodies", 1))
	}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.LockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.VisibilityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibilityConfig"))
	}
	if s.CustomResponseBodies != nil {
		for i, v := range s.CustomResponseBodies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomResponseBodies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DefaultAction != nil {
		if err := s.DefaultAction.Validate(); err != nil {
			invalidParams.AddNested("DefaultAction", err.(request.ErrInvalidParams))
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomResponseBodies sets the CustomResponseBodies field's value.
func (s *UpdateWebACLInput) SetCustomResponseBodies(v map[string]*CustomResponseBody) *UpdateWebACLInput {
	s.CustomResponseBodies = v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *UpdateWebACLInput) SetDefaultAction(v *DefaultAction) *UpdateWebACLInput {
	s.DefaultAction = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWebACLInput) SetDescription(v string) *UpdateWebACLInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWebACLInput) SetId(v string) *UpdateWebACLInput {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *UpdateWebACLInput) SetLockToken(v string) *UpdateWebACLInput {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWebACLInput) SetName(v string) *UpdateWebACLInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateWebACLInput) SetRules(v []*Rule) *UpdateWebACLInput {
	s.Rules = v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateWebACLInput) SetScope(v string) *UpdateWebACLInput {
	s.Scope = &v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *UpdateWebACLInput) SetVisibilityConfig(v *VisibilityConfig) *UpdateWebACLInput {
	s.VisibilityConfig = v
	return s
}

type UpdateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. WAF returns this token to your update
	// requests. You use NextLockToken in the same manner as you use LockToken.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebACLOutput) GoString() string {
	return s.String()
}

// SetNextLockToken sets the NextLockToken field's value.
func (s *UpdateWebACLOutput) SetNextLockToken(v string) *UpdateWebACLOutput {
	s.NextLockToken = &v
	return s
}

// The path component of the URI of a web request. This is the part of a web
// request that identifies a resource. For example, /images/daily-ad.jpg.
//
// This is used only to indicate the web request component for WAF to inspect,
// in the FieldToMatch specification.
type UriPath struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UriPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UriPath) GoString() string {
	return s.String()
}

// A version of the named managed rule group, that the rule group's vendor publishes
// for use by customers.
//
// This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Marketplace sellers.
//
// Vendors, you can use the managed rule set APIs to provide controlled rollout
// of your versioned managed rule group offerings for your customers. The APIs
// are ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
type VersionToPublish struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the vendor's rule group that's used in
	// the published managed rule group version.
	AssociatedRuleGroupArn *string `min:"20" type:"string"`

	// The amount of time the vendor expects this version of the managed rule group
	// to last, in days.
	ForecastedLifetime *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s VersionToPublish) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersionToPublish) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VersionToPublish) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VersionToPublish"}
	if s.AssociatedRuleGroupArn != nil && len(*s.AssociatedRuleGroupArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AssociatedRuleGroupArn", 20))
	}
	if s.ForecastedLifetime != nil && *s.ForecastedLifetime < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ForecastedLifetime", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedRuleGroupArn sets the AssociatedRuleGroupArn field's value.
func (s *VersionToPublish) SetAssociatedRuleGroupArn(v string) *VersionToPublish {
	s.AssociatedRuleGroupArn = &v
	return s
}

// SetForecastedLifetime sets the ForecastedLifetime field's value.
func (s *VersionToPublish) SetForecastedLifetime(v int64) *VersionToPublish {
	s.ForecastedLifetime = &v
	return s
}

// Defines and enables Amazon CloudWatch metrics and web request sample collection.
type VisibilityConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether the associated resource sends metrics to Amazon
	// CloudWatch. For the list of available metrics, see WAF Metrics (https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
	//
	// CloudWatchMetricsEnabled is a required field
	CloudWatchMetricsEnabled *bool `type:"boolean" required:"true"`

	// A name of the Amazon CloudWatch metric. The name can contain only the characters:
	// A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to
	// 128 characters long. It can't contain whitespace or metric names reserved
	// for WAF, for example "All" and "Default_Action."
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// A boolean indicating whether WAF should store a sampling of the web requests
	// that match the rules. You can view the sampled requests through the WAF console.
	//
	// SampledRequestsEnabled is a required field
	SampledRequestsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s VisibilityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VisibilityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VisibilityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VisibilityConfig"}
	if s.CloudWatchMetricsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchMetricsEnabled"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.SampledRequestsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("SampledRequestsEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchMetricsEnabled sets the CloudWatchMetricsEnabled field's value.
func (s *VisibilityConfig) SetCloudWatchMetricsEnabled(v bool) *VisibilityConfig {
	s.CloudWatchMetricsEnabled = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *VisibilityConfig) SetMetricName(v string) *VisibilityConfig {
	s.MetricName = &v
	return s
}

// SetSampledRequestsEnabled sets the SampledRequestsEnabled field's value.
func (s *VisibilityConfig) SetSampledRequestsEnabled(v bool) *VisibilityConfig {
	s.SampledRequestsEnabled = &v
	return s
}

// WAF couldn’t perform the operation because your resource is being used
// by another resource or it’s associated with another resource.
type WAFAssociatedItemException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFAssociatedItemException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFAssociatedItemException) GoString() string {
	return s.String()
}

func newErrorWAFAssociatedItemException(v protocol.ResponseMetadata) error {
	return &WAFAssociatedItemException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFAssociatedItemException) Code() string {
	return "WAFAssociatedItemException"
}

// Message returns the exception's message.
func (s *WAFAssociatedItemException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFAssociatedItemException) OrigErr() error {
	return nil
}

func (s *WAFAssociatedItemException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFAssociatedItemException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFAssociatedItemException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t perform the operation because the resource that you tried
// to save is a duplicate of an existing one.
type WAFDuplicateItemException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFDuplicateItemException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFDuplicateItemException) GoString() string {
	return s.String()
}

func newErrorWAFDuplicateItemException(v protocol.ResponseMetadata) error {
	return &WAFDuplicateItemException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFDuplicateItemException) Code() string {
	return "WAFDuplicateItemException"
}

// Message returns the exception's message.
func (s *WAFDuplicateItemException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFDuplicateItemException) OrigErr() error {
	return nil
}

func (s *WAFDuplicateItemException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFDuplicateItemException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFDuplicateItemException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified version for the managed rule group
// has expired. You can retrieve the available versions for the managed rule
// group by calling ListAvailableManagedRuleGroupVersions.
type WAFExpiredManagedRuleGroupVersionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFExpiredManagedRuleGroupVersionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFExpiredManagedRuleGroupVersionException) GoString() string {
	return s.String()
}

func newErrorWAFExpiredManagedRuleGroupVersionException(v protocol.ResponseMetadata) error {
	return &WAFExpiredManagedRuleGroupVersionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFExpiredManagedRuleGroupVersionException) Code() string {
	return "WAFExpiredManagedRuleGroupVersionException"
}

// Message returns the exception's message.
func (s *WAFExpiredManagedRuleGroupVersionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFExpiredManagedRuleGroupVersionException) OrigErr() error {
	return nil
}

func (s *WAFExpiredManagedRuleGroupVersionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFExpiredManagedRuleGroupVersionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFExpiredManagedRuleGroupVersionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request is valid, but WAF couldn’t perform the operation because of
// a system problem. Retry your request.
type WAFInternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFInternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFInternalErrorException) GoString() string {
	return s.String()
}

func newErrorWAFInternalErrorException(v protocol.ResponseMetadata) error {
	return &WAFInternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFInternalErrorException) Code() string {
	return "WAFInternalErrorException"
}

// Message returns the exception's message.
func (s *WAFInternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFInternalErrorException) OrigErr() error {
	return nil
}

func (s *WAFInternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFInternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFInternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation isn't valid.
type WAFInvalidOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFInvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFInvalidOperationException) GoString() string {
	return s.String()
}

func newErrorWAFInvalidOperationException(v protocol.ResponseMetadata) error {
	return &WAFInvalidOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFInvalidOperationException) Code() string {
	return "WAFInvalidOperationException"
}

// Message returns the exception's message.
func (s *WAFInvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFInvalidOperationException) OrigErr() error {
	return nil
}

func (s *WAFInvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFInvalidOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFInvalidOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because WAF didn't recognize a parameter in the request.
// For example:
//
//    * You specified a parameter name or value that isn't valid.
//
//    * Your nested statement isn't valid. You might have tried to nest a statement
//    that can’t be nested.
//
//    * You tried to update a WebACL with a DefaultAction that isn't among the
//    types available at DefaultAction.
//
//    * Your request references an ARN that is malformed, or corresponds to
//    a resource with which a web ACL can't be associated.
type WAFInvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The settings where the invalid parameter was found.
	Field *string `type:"string" enum:"ParameterExceptionField"`

	Message_ *string `locationName:"message" type:"string"`

	// The invalid parameter that resulted in the exception.
	Parameter *string `min:"1" type:"string"`

	// Additional information about the exception.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s WAFInvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFInvalidParameterException) GoString() string {
	return s.String()
}

func newErrorWAFInvalidParameterException(v protocol.ResponseMetadata) error {
	return &WAFInvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFInvalidParameterException) Code() string {
	return "WAFInvalidParameterException"
}

// Message returns the exception's message.
func (s *WAFInvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFInvalidParameterException) OrigErr() error {
	return nil
}

func (s *WAFInvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFInvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFInvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified policy isn't in the proper format.
//
// The policy specifications must conform to the following:
//
//    * The policy must be composed using IAM Policy version 2012-10-17 or version
//    2015-01-01.
//
//    * The policy must include specifications for Effect, Action, and Principal.
//
//    * Effect must specify Allow.
//
//    * Action must specify wafv2:CreateWebACL, wafv2:UpdateWebACL, and wafv2:PutFirewallManagerRuleGroups.
//    WAF rejects any extra actions or wildcard actions in the policy.
//
//    * The policy must not include a Resource parameter.
//
// For more information, see IAM Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
type WAFInvalidPermissionPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFInvalidPermissionPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFInvalidPermissionPolicyException) GoString() string {
	return s.String()
}

func newErrorWAFInvalidPermissionPolicyException(v protocol.ResponseMetadata) error {
	return &WAFInvalidPermissionPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFInvalidPermissionPolicyException) Code() string {
	return "WAFInvalidPermissionPolicyException"
}

// Message returns the exception's message.
func (s *WAFInvalidPermissionPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFInvalidPermissionPolicyException) OrigErr() error {
	return nil
}

func (s *WAFInvalidPermissionPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFInvalidPermissionPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFInvalidPermissionPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t perform the operation because the resource that you requested
// isn’t valid. Check the resource, and try again.
type WAFInvalidResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFInvalidResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFInvalidResourceException) GoString() string {
	return s.String()
}

func newErrorWAFInvalidResourceException(v protocol.ResponseMetadata) error {
	return &WAFInvalidResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFInvalidResourceException) Code() string {
	return "WAFInvalidResourceException"
}

// Message returns the exception's message.
func (s *WAFInvalidResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFInvalidResourceException) OrigErr() error {
	return nil
}

func (s *WAFInvalidResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFInvalidResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFInvalidResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t perform the operation because you exceeded your resource limit.
// For example, the maximum number of WebACL objects that you can create for
// an Amazon Web Services account. For more information, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
// in the WAF Developer Guide.
type WAFLimitsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFLimitsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFLimitsExceededException) GoString() string {
	return s.String()
}

func newErrorWAFLimitsExceededException(v protocol.ResponseMetadata) error {
	return &WAFLimitsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFLimitsExceededException) Code() string {
	return "WAFLimitsExceededException"
}

// Message returns the exception's message.
func (s *WAFLimitsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFLimitsExceededException) OrigErr() error {
	return nil
}

func (s *WAFLimitsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFLimitsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFLimitsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t perform the operation because your resource doesn’t exist.
type WAFNonexistentItemException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFNonexistentItemException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFNonexistentItemException) GoString() string {
	return s.String()
}

func newErrorWAFNonexistentItemException(v protocol.ResponseMetadata) error {
	return &WAFNonexistentItemException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFNonexistentItemException) Code() string {
	return "WAFNonexistentItemException"
}

// Message returns the exception's message.
func (s *WAFNonexistentItemException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFNonexistentItemException) OrigErr() error {
	return nil
}

func (s *WAFNonexistentItemException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFNonexistentItemException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFNonexistentItemException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t save your changes because you tried to update or delete a
// resource that has changed since you last retrieved it. Get the resource again,
// make any changes you need to make to the new copy, and retry your operation.
type WAFOptimisticLockException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFOptimisticLockException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFOptimisticLockException) GoString() string {
	return s.String()
}

func newErrorWAFOptimisticLockException(v protocol.ResponseMetadata) error {
	return &WAFOptimisticLockException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFOptimisticLockException) Code() string {
	return "WAFOptimisticLockException"
}

// Message returns the exception's message.
func (s *WAFOptimisticLockException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFOptimisticLockException) OrigErr() error {
	return nil
}

func (s *WAFOptimisticLockException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFOptimisticLockException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFOptimisticLockException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF is not able to access the service linked role. This can be caused by
// a previous PutLoggingConfiguration request, which can lock the service linked
// role for about 20 seconds. Please try your request again. The service linked
// role can also be locked by a previous DeleteServiceLinkedRole request, which
// can lock the role for 15 minutes or more. If you recently made a call to
// DeleteServiceLinkedRole, wait at least 15 minutes and try the request again.
// If you receive this same exception again, you will have to wait additional
// time until the role is unlocked.
type WAFServiceLinkedRoleErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s WAFServiceLinkedRoleErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFServiceLinkedRoleErrorException) GoString() string {
	return s.String()
}

func newErrorWAFServiceLinkedRoleErrorException(v protocol.ResponseMetadata) error {
	return &WAFServiceLinkedRoleErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFServiceLinkedRoleErrorException) Code() string {
	return "WAFServiceLinkedRoleErrorException"
}

// Message returns the exception's message.
func (s *WAFServiceLinkedRoleErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFServiceLinkedRoleErrorException) OrigErr() error {
	return nil
}

func (s *WAFServiceLinkedRoleErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFServiceLinkedRoleErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFServiceLinkedRoleErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You tried to use a managed rule group that's available by subscription, but
// you aren't subscribed to it yet.
type WAFSubscriptionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFSubscriptionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFSubscriptionNotFoundException) GoString() string {
	return s.String()
}

func newErrorWAFSubscriptionNotFoundException(v protocol.ResponseMetadata) error {
	return &WAFSubscriptionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFSubscriptionNotFoundException) Code() string {
	return "WAFSubscriptionNotFoundException"
}

// Message returns the exception's message.
func (s *WAFSubscriptionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFSubscriptionNotFoundException) OrigErr() error {
	return nil
}

func (s *WAFSubscriptionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFSubscriptionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFSubscriptionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error occurred during the tagging operation. Retry your request.
type WAFTagOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFTagOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFTagOperationException) GoString() string {
	return s.String()
}

func newErrorWAFTagOperationException(v protocol.ResponseMetadata) error {
	return &WAFTagOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFTagOperationException) Code() string {
	return "WAFTagOperationException"
}

// Message returns the exception's message.
func (s *WAFTagOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFTagOperationException) OrigErr() error {
	return nil
}

func (s *WAFTagOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFTagOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFTagOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t perform your tagging operation because of an internal error.
// Retry your request.
type WAFTagOperationInternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFTagOperationInternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFTagOperationInternalErrorException) GoString() string {
	return s.String()
}

func newErrorWAFTagOperationInternalErrorException(v protocol.ResponseMetadata) error {
	return &WAFTagOperationInternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFTagOperationInternalErrorException) Code() string {
	return "WAFTagOperationInternalErrorException"
}

// Message returns the exception's message.
func (s *WAFTagOperationInternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFTagOperationInternalErrorException) OrigErr() error {
	return nil
}

func (s *WAFTagOperationInternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFTagOperationInternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFTagOperationInternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// WAF couldn’t retrieve the resource that you requested. Retry your request.
type WAFUnavailableEntityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s WAFUnavailableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WAFUnavailableEntityException) GoString() string {
	return s.String()
}

func newErrorWAFUnavailableEntityException(v protocol.ResponseMetadata) error {
	return &WAFUnavailableEntityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WAFUnavailableEntityException) Code() string {
	return "WAFUnavailableEntityException"
}

// Message returns the exception's message.
func (s *WAFUnavailableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WAFUnavailableEntityException) OrigErr() error {
	return nil
}

func (s *WAFUnavailableEntityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WAFUnavailableEntityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WAFUnavailableEntityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A web ACL defines a collection of rules to use to inspect and control web
// requests. Each rule has an action defined (allow, block, or count) for requests
// that match the statement of the rule. In the web ACL, you assign a default
// action to take (allow, block) for any request that does not match any of
// the rules. The rules in a web ACL can be a combination of the types Rule,
// RuleGroup, and managed rule group. You can associate a web ACL with one or
// more Amazon Web Services resources to protect. The resources can be an Amazon
// CloudFront distribution, an Amazon API Gateway REST API, an Application Load
// Balancer, or an AppSync GraphQL API.
type WebACL struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate
	// with the resource.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The web ACL capacity units (WCUs) currently being used by this web ACL.
	//
	// WAF uses WCUs to calculate and control the operating resources that are used
	// to run your rules, rule groups, and web ACLs. WAF calculates capacity differently
	// for each rule type, to reflect the relative cost of each rule. Simple rules
	// that cost little to run use fewer WCUs than more complex rules that use more
	// processing power. Rule group capacity is fixed at creation, which helps users
	// plan their web ACL WCU usage when they use a rule group. The WCU limit for
	// web ACLs is 1,500.
	Capacity *int64 `type:"long"`

	// A map of custom response keys and content bodies. When you create a rule
	// with a block action, you can send a custom response to the web request. You
	// define these for the web ACL, and then use them in the rules and default
	// actions that you define in the web ACL.
	//
	// For information about customizing web requests and responses, see Customizing
	// web requests and responses in WAF (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
	// in the WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]*CustomResponseBody `min:"1" type:"map"`

	// The action to perform if none of the Rules contained in the WebACL match.
	//
	// DefaultAction is a required field
	DefaultAction *DefaultAction `type:"structure" required:"true"`

	// A description of the web ACL that helps with identification.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the WebACL. This ID is returned in the responses
	// to create and list commands. You use this ID to do things like get, update,
	// and delete a WebACL.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The label namespace prefix for this web ACL. All labels added by rules in
	// this web ACL have this prefix.
	//
	//    * The syntax for the label namespace prefix for a web ACL is the following:
	//    awswaf:<account ID>:webacl:<web ACL name>:
	//
	//    * When a rule with a label matches a web request, WAF adds the fully qualified
	//    label to the request. A fully qualified label is made up of the label
	//    namespace from the rule group or web ACL where the rule is defined and
	//    the label from the rule, separated by a colon: <label namespace>:<label
	//    from rule>
	LabelNamespace *string `min:"1" type:"string"`

	// Indicates whether this web ACL is managed by Firewall Manager. If true, then
	// only Firewall Manager can delete the web ACL or any Firewall Manager rule
	// groups in the web ACL.
	ManagedByFirewallManager *bool `type:"boolean"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The last set of rules for WAF to process in the web ACL. This is defined
	// in an Firewall Manager WAF policy and contains only rule group references.
	// You can't alter these. Any rules and rule groups that you define for the
	// web ACL are prioritized before these.
	//
	// In the Firewall Manager WAF policy, the Firewall Manager administrator can
	// define a set of rule groups to run first in the web ACL and a set of rule
	// groups to run last. Within each set, the administrator prioritizes the rule
	// groups, to determine their relative processing order.
	PostProcessFirewallManagerRuleGroups []*FirewallManagerRuleGroup `type:"list"`

	// The first set of rules for WAF to process in the web ACL. This is defined
	// in an Firewall Manager WAF policy and contains only rule group references.
	// You can't alter these. Any rules and rule groups that you define for the
	// web ACL are prioritized after these.
	//
	// In the Firewall Manager WAF policy, the Firewall Manager administrator can
	// define a set of rule groups to run first in the web ACL and a set of rule
	// groups to run last. Within each set, the administrator prioritizes the rule
	// groups, to determine their relative processing order.
	PreProcessFirewallManagerRuleGroups []*FirewallManagerRuleGroup `type:"list"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses
	// to identify matching web requests, and parameters that govern how WAF handles
	// them.
	Rules []*Rule `type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s WebACL) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACL) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *WebACL) SetARN(v string) *WebACL {
	s.ARN = &v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *WebACL) SetCapacity(v int64) *WebACL {
	s.Capacity = &v
	return s
}

// SetCustomResponseBodies sets the CustomResponseBodies field's value.
func (s *WebACL) SetCustomResponseBodies(v map[string]*CustomResponseBody) *WebACL {
	s.CustomResponseBodies = v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *WebACL) SetDefaultAction(v *DefaultAction) *WebACL {
	s.DefaultAction = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WebACL) SetDescription(v string) *WebACL {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *WebACL) SetId(v string) *WebACL {
	s.Id = &v
	return s
}

// SetLabelNamespace sets the LabelNamespace field's value.
func (s *WebACL) SetLabelNamespace(v string) *WebACL {
	s.LabelNamespace = &v
	return s
}

// SetManagedByFirewallManager sets the ManagedByFirewallManager field's value.
func (s *WebACL) SetManagedByFirewallManager(v bool) *WebACL {
	s.ManagedByFirewallManager = &v
	return s
}

// SetName sets the Name field's value.
func (s *WebACL) SetName(v string) *WebACL {
	s.Name = &v
	return s
}

// SetPostProcessFirewallManagerRuleGroups sets the PostProcessFirewallManagerRuleGroups field's value.
func (s *WebACL) SetPostProcessFirewallManagerRuleGroups(v []*FirewallManagerRuleGroup) *WebACL {
	s.PostProcessFirewallManagerRuleGroups = v
	return s
}

// SetPreProcessFirewallManagerRuleGroups sets the PreProcessFirewallManagerRuleGroups field's value.
func (s *WebACL) SetPreProcessFirewallManagerRuleGroups(v []*FirewallManagerRuleGroup) *WebACL {
	s.PreProcessFirewallManagerRuleGroups = v
	return s
}

// SetRules sets the Rules field's value.
func (s *WebACL) SetRules(v []*Rule) *WebACL {
	s.Rules = v
	return s
}

// SetVisibilityConfig sets the VisibilityConfig field's value.
func (s *WebACL) SetVisibilityConfig(v *VisibilityConfig) *WebACL {
	s.VisibilityConfig = v
	return s
}

// High-level information about a WebACL, returned by operations like create
// and list. This provides information like the ID, that you can use to retrieve
// and manage a WebACL, and the ARN, that you provide to operations like AssociateWebACL.
type WebACLSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the web ACL that helps with identification.
	Description *string `min:"1" type:"string"`

	// The unique identifier for the web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. WAF returns a token to your get and
	// list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebACLSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACLSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *WebACLSummary) SetARN(v string) *WebACLSummary {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WebACLSummary) SetDescription(v string) *WebACLSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *WebACLSummary) SetId(v string) *WebACLSummary {
	s.Id = &v
	return s
}

// SetLockToken sets the LockToken field's value.
func (s *WebACLSummary) SetLockToken(v string) *WebACLSummary {
	s.LockToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *WebACLSummary) SetName(v string) *WebACLSummary {
	s.Name = &v
	return s
}

// A rule statement that defines a cross-site scripting (XSS) match search for
// WAF to apply to web requests. XSS attacks are those where the attacker uses
// vulnerabilities in a benign website as a vehicle to inject malicious client-site
// scripts into other legitimate web browsers. The XSS match statement provides
// the location in requests that you want WAF to search and text transformations
// to use on the search area before WAF searches for character sequences that
// are likely to be malicious strings.
type XssMatchStatement struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []*TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s XssMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s XssMatchStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *XssMatchStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "XssMatchStatement"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.TextTransformations == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *XssMatchStatement) SetFieldToMatch(v *FieldToMatch) *XssMatchStatement {
	s.FieldToMatch = v
	return s
}

// SetTextTransformations sets the TextTransformations field's value.
func (s *XssMatchStatement) SetTextTransformations(v []*TextTransformation) *XssMatchStatement {
	s.TextTransformations = v
	return s
}

const (
	// ActionValueAllow is a ActionValue enum value
	ActionValueAllow = "ALLOW"

	// ActionValueBlock is a ActionValue enum value
	ActionValueBlock = "BLOCK"

	// ActionValueCount is a ActionValue enum value
	ActionValueCount = "COUNT"
)

// ActionValue_Values returns all elements of the ActionValue enum
func ActionValue_Values() []string {
	return []string{
		ActionValueAllow,
		ActionValueBlock,
		ActionValueCount,
	}
}

const (
	// BodyParsingFallbackBehaviorMatch is a BodyParsingFallbackBehavior enum value
	BodyParsingFallbackBehaviorMatch = "MATCH"

	// BodyParsingFallbackBehaviorNoMatch is a BodyParsingFallbackBehavior enum value
	BodyParsingFallbackBehaviorNoMatch = "NO_MATCH"

	// BodyParsingFallbackBehaviorEvaluateAsString is a BodyParsingFallbackBehavior enum value
	BodyParsingFallbackBehaviorEvaluateAsString = "EVALUATE_AS_STRING"
)

// BodyParsingFallbackBehavior_Values returns all elements of the BodyParsingFallbackBehavior enum
func BodyParsingFallbackBehavior_Values() []string {
	return []string{
		BodyParsingFallbackBehaviorMatch,
		BodyParsingFallbackBehaviorNoMatch,
		BodyParsingFallbackBehaviorEvaluateAsString,
	}
}

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorEq,
		ComparisonOperatorNe,
		ComparisonOperatorLe,
		ComparisonOperatorLt,
		ComparisonOperatorGe,
		ComparisonOperatorGt,
	}
}

const (
	// CountryCodeAf is a CountryCode enum value
	CountryCodeAf = "AF"

	// CountryCodeAx is a CountryCode enum value
	CountryCodeAx = "AX"

	// CountryCodeAl is a CountryCode enum value
	CountryCodeAl = "AL"

	// CountryCodeDz is a CountryCode enum value
	CountryCodeDz = "DZ"

	// CountryCodeAs is a CountryCode enum value
	CountryCodeAs = "AS"

	// CountryCodeAd is a CountryCode enum value
	CountryCodeAd = "AD"

	// CountryCodeAo is a CountryCode enum value
	CountryCodeAo = "AO"

	// CountryCodeAi is a CountryCode enum value
	CountryCodeAi = "AI"

	// CountryCodeAq is a CountryCode enum value
	CountryCodeAq = "AQ"

	// CountryCodeAg is a CountryCode enum value
	CountryCodeAg = "AG"

	// CountryCodeAr is a CountryCode enum value
	CountryCodeAr = "AR"

	// CountryCodeAm is a CountryCode enum value
	CountryCodeAm = "AM"

	// CountryCodeAw is a CountryCode enum value
	CountryCodeAw = "AW"

	// CountryCodeAu is a CountryCode enum value
	CountryCodeAu = "AU"

	// CountryCodeAt is a CountryCode enum value
	CountryCodeAt = "AT"

	// CountryCodeAz is a CountryCode enum value
	CountryCodeAz = "AZ"

	// CountryCodeBs is a CountryCode enum value
	CountryCodeBs = "BS"

	// CountryCodeBh is a CountryCode enum value
	CountryCodeBh = "BH"

	// CountryCodeBd is a CountryCode enum value
	CountryCodeBd = "BD"

	// CountryCodeBb is a CountryCode enum value
	CountryCodeBb = "BB"

	// CountryCodeBy is a CountryCode enum value
	CountryCodeBy = "BY"

	// CountryCodeBe is a CountryCode enum value
	CountryCodeBe = "BE"

	// CountryCodeBz is a CountryCode enum value
	CountryCodeBz = "BZ"

	// CountryCodeBj is a CountryCode enum value
	CountryCodeBj = "BJ"

	// CountryCodeBm is a CountryCode enum value
	CountryCodeBm = "BM"

	// CountryCodeBt is a CountryCode enum value
	CountryCodeBt = "BT"

	// CountryCodeBo is a CountryCode enum value
	CountryCodeBo = "BO"

	// CountryCodeBq is a CountryCode enum value
	CountryCodeBq = "BQ"

	// CountryCodeBa is a CountryCode enum value
	CountryCodeBa = "BA"

	// CountryCodeBw is a CountryCode enum value
	CountryCodeBw = "BW"

	// CountryCodeBv is a CountryCode enum value
	CountryCodeBv = "BV"

	// CountryCodeBr is a CountryCode enum value
	CountryCodeBr = "BR"

	// CountryCodeIo is a CountryCode enum value
	CountryCodeIo = "IO"

	// CountryCodeBn is a CountryCode enum value
	CountryCodeBn = "BN"

	// CountryCodeBg is a CountryCode enum value
	CountryCodeBg = "BG"

	// CountryCodeBf is a CountryCode enum value
	CountryCodeBf = "BF"

	// CountryCodeBi is a CountryCode enum value
	CountryCodeBi = "BI"

	// CountryCodeKh is a CountryCode enum value
	CountryCodeKh = "KH"

	// CountryCodeCm is a CountryCode enum value
	CountryCodeCm = "CM"

	// CountryCodeCa is a CountryCode enum value
	CountryCodeCa = "CA"

	// CountryCodeCv is a CountryCode enum value
	CountryCodeCv = "CV"

	// CountryCodeKy is a CountryCode enum value
	CountryCodeKy = "KY"

	// CountryCodeCf is a CountryCode enum value
	CountryCodeCf = "CF"

	// CountryCodeTd is a CountryCode enum value
	CountryCodeTd = "TD"

	// CountryCodeCl is a CountryCode enum value
	CountryCodeCl = "CL"

	// CountryCodeCn is a CountryCode enum value
	CountryCodeCn = "CN"

	// CountryCodeCx is a CountryCode enum value
	CountryCodeCx = "CX"

	// CountryCodeCc is a CountryCode enum value
	CountryCodeCc = "CC"

	// CountryCodeCo is a CountryCode enum value
	CountryCodeCo = "CO"

	// CountryCodeKm is a CountryCode enum value
	CountryCodeKm = "KM"

	// CountryCodeCg is a CountryCode enum value
	CountryCodeCg = "CG"

	// CountryCodeCd is a CountryCode enum value
	CountryCodeCd = "CD"

	// CountryCodeCk is a CountryCode enum value
	CountryCodeCk = "CK"

	// CountryCodeCr is a CountryCode enum value
	CountryCodeCr = "CR"

	// CountryCodeCi is a CountryCode enum value
	CountryCodeCi = "CI"

	// CountryCodeHr is a CountryCode enum value
	CountryCodeHr = "HR"

	// CountryCodeCu is a CountryCode enum value
	CountryCodeCu = "CU"

	// CountryCodeCw is a CountryCode enum value
	CountryCodeCw = "CW"

	// CountryCodeCy is a CountryCode enum value
	CountryCodeCy = "CY"

	// CountryCodeCz is a CountryCode enum value
	CountryCodeCz = "CZ"

	// CountryCodeDk is a CountryCode enum value
	CountryCodeDk = "DK"

	// CountryCodeDj is a CountryCode enum value
	CountryCodeDj = "DJ"

	// CountryCodeDm is a CountryCode enum value
	CountryCodeDm = "DM"

	// CountryCodeDo is a CountryCode enum value
	CountryCodeDo = "DO"

	// CountryCodeEc is a CountryCode enum value
	CountryCodeEc = "EC"

	// CountryCodeEg is a CountryCode enum value
	CountryCodeEg = "EG"

	// CountryCodeSv is a CountryCode enum value
	CountryCodeSv = "SV"

	// CountryCodeGq is a CountryCode enum value
	CountryCodeGq = "GQ"

	// CountryCodeEr is a CountryCode enum value
	CountryCodeEr = "ER"

	// CountryCodeEe is a CountryCode enum value
	CountryCodeEe = "EE"

	// CountryCodeEt is a CountryCode enum value
	CountryCodeEt = "ET"

	// CountryCodeFk is a CountryCode enum value
	CountryCodeFk = "FK"

	// CountryCodeFo is a CountryCode enum value
	CountryCodeFo = "FO"

	// CountryCodeFj is a CountryCode enum value
	CountryCodeFj = "FJ"

	// CountryCodeFi is a CountryCode enum value
	CountryCodeFi = "FI"

	// CountryCodeFr is a CountryCode enum value
	CountryCodeFr = "FR"

	// CountryCodeGf is a CountryCode enum value
	CountryCodeGf = "GF"

	// CountryCodePf is a CountryCode enum value
	CountryCodePf = "PF"

	// CountryCodeTf is a CountryCode enum value
	CountryCodeTf = "TF"

	// CountryCodeGa is a CountryCode enum value
	CountryCodeGa = "GA"

	// CountryCodeGm is a CountryCode enum value
	CountryCodeGm = "GM"

	// CountryCodeGe is a CountryCode enum value
	CountryCodeGe = "GE"

	// CountryCodeDe is a CountryCode enum value
	CountryCodeDe = "DE"

	// CountryCodeGh is a CountryCode enum value
	CountryCodeGh = "GH"

	// CountryCodeGi is a CountryCode enum value
	CountryCodeGi = "GI"

	// CountryCodeGr is a CountryCode enum value
	CountryCodeGr = "GR"

	// CountryCodeGl is a CountryCode enum value
	CountryCodeGl = "GL"

	// CountryCodeGd is a CountryCode enum value
	CountryCodeGd = "GD"

	// CountryCodeGp is a CountryCode enum value
	CountryCodeGp = "GP"

	// CountryCodeGu is a CountryCode enum value
	CountryCodeGu = "GU"

	// CountryCodeGt is a CountryCode enum value
	CountryCodeGt = "GT"

	// CountryCodeGg is a CountryCode enum value
	CountryCodeGg = "GG"

	// CountryCodeGn is a CountryCode enum value
	CountryCodeGn = "GN"

	// CountryCodeGw is a CountryCode enum value
	CountryCodeGw = "GW"

	// CountryCodeGy is a CountryCode enum value
	CountryCodeGy = "GY"

	// CountryCodeHt is a CountryCode enum value
	CountryCodeHt = "HT"

	// CountryCodeHm is a CountryCode enum value
	CountryCodeHm = "HM"

	// CountryCodeVa is a CountryCode enum value
	CountryCodeVa = "VA"

	// CountryCodeHn is a CountryCode enum value
	CountryCodeHn = "HN"

	// CountryCodeHk is a CountryCode enum value
	CountryCodeHk = "HK"

	// CountryCodeHu is a CountryCode enum value
	CountryCodeHu = "HU"

	// CountryCodeIs is a CountryCode enum value
	CountryCodeIs = "IS"

	// CountryCodeIn is a CountryCode enum value
	CountryCodeIn = "IN"

	// CountryCodeId is a CountryCode enum value
	CountryCodeId = "ID"

	// CountryCodeIr is a CountryCode enum value
	CountryCodeIr = "IR"

	// CountryCodeIq is a CountryCode enum value
	CountryCodeIq = "IQ"

	// CountryCodeIe is a CountryCode enum value
	CountryCodeIe = "IE"

	// CountryCodeIm is a CountryCode enum value
	CountryCodeIm = "IM"

	// CountryCodeIl is a CountryCode enum value
	CountryCodeIl = "IL"

	// CountryCodeIt is a CountryCode enum value
	CountryCodeIt = "IT"

	// CountryCodeJm is a CountryCode enum value
	CountryCodeJm = "JM"

	// CountryCodeJp is a CountryCode enum value
	CountryCodeJp = "JP"

	// CountryCodeJe is a CountryCode enum value
	CountryCodeJe = "JE"

	// CountryCodeJo is a CountryCode enum value
	CountryCodeJo = "JO"

	// CountryCodeKz is a CountryCode enum value
	CountryCodeKz = "KZ"

	// CountryCodeKe is a CountryCode enum value
	CountryCodeKe = "KE"

	// CountryCodeKi is a CountryCode enum value
	CountryCodeKi = "KI"

	// CountryCodeKp is a CountryCode enum value
	CountryCodeKp = "KP"

	// CountryCodeKr is a CountryCode enum value
	CountryCodeKr = "KR"

	// CountryCodeKw is a CountryCode enum value
	CountryCodeKw = "KW"

	// CountryCodeKg is a CountryCode enum value
	CountryCodeKg = "KG"

	// CountryCodeLa is a CountryCode enum value
	CountryCodeLa = "LA"

	// CountryCodeLv is a CountryCode enum value
	CountryCodeLv = "LV"

	// CountryCodeLb is a CountryCode enum value
	CountryCodeLb = "LB"

	// CountryCodeLs is a CountryCode enum value
	CountryCodeLs = "LS"

	// CountryCodeLr is a CountryCode enum value
	CountryCodeLr = "LR"

	// CountryCodeLy is a CountryCode enum value
	CountryCodeLy = "LY"

	// CountryCodeLi is a CountryCode enum value
	CountryCodeLi = "LI"

	// CountryCodeLt is a CountryCode enum value
	CountryCodeLt = "LT"

	// CountryCodeLu is a CountryCode enum value
	CountryCodeLu = "LU"

	// CountryCodeMo is a CountryCode enum value
	CountryCodeMo = "MO"

	// CountryCodeMk is a CountryCode enum value
	CountryCodeMk = "MK"

	// CountryCodeMg is a CountryCode enum value
	CountryCodeMg = "MG"

	// CountryCodeMw is a CountryCode enum value
	CountryCodeMw = "MW"

	// CountryCodeMy is a CountryCode enum value
	CountryCodeMy = "MY"

	// CountryCodeMv is a CountryCode enum value
	CountryCodeMv = "MV"

	// CountryCodeMl is a CountryCode enum value
	CountryCodeMl = "ML"

	// CountryCodeMt is a CountryCode enum value
	CountryCodeMt = "MT"

	// CountryCodeMh is a CountryCode enum value
	CountryCodeMh = "MH"

	// CountryCodeMq is a CountryCode enum value
	CountryCodeMq = "MQ"

	// CountryCodeMr is a CountryCode enum value
	CountryCodeMr = "MR"

	// CountryCodeMu is a CountryCode enum value
	CountryCodeMu = "MU"

	// CountryCodeYt is a CountryCode enum value
	CountryCodeYt = "YT"

	// CountryCodeMx is a CountryCode enum value
	CountryCodeMx = "MX"

	// CountryCodeFm is a CountryCode enum value
	CountryCodeFm = "FM"

	// CountryCodeMd is a CountryCode enum value
	CountryCodeMd = "MD"

	// CountryCodeMc is a CountryCode enum value
	CountryCodeMc = "MC"

	// CountryCodeMn is a CountryCode enum value
	CountryCodeMn = "MN"

	// CountryCodeMe is a CountryCode enum value
	CountryCodeMe = "ME"

	// CountryCodeMs is a CountryCode enum value
	CountryCodeMs = "MS"

	// CountryCodeMa is a CountryCode enum value
	CountryCodeMa = "MA"

	// CountryCodeMz is a CountryCode enum value
	CountryCodeMz = "MZ"

	// CountryCodeMm is a CountryCode enum value
	CountryCodeMm = "MM"

	// CountryCodeNa is a CountryCode enum value
	CountryCodeNa = "NA"

	// CountryCodeNr is a CountryCode enum value
	CountryCodeNr = "NR"

	// CountryCodeNp is a CountryCode enum value
	CountryCodeNp = "NP"

	// CountryCodeNl is a CountryCode enum value
	CountryCodeNl = "NL"

	// CountryCodeNc is a CountryCode enum value
	CountryCodeNc = "NC"

	// CountryCodeNz is a CountryCode enum value
	CountryCodeNz = "NZ"

	// CountryCodeNi is a CountryCode enum value
	CountryCodeNi = "NI"

	// CountryCodeNe is a CountryCode enum value
	CountryCodeNe = "NE"

	// CountryCodeNg is a CountryCode enum value
	CountryCodeNg = "NG"

	// CountryCodeNu is a CountryCode enum value
	CountryCodeNu = "NU"

	// CountryCodeNf is a CountryCode enum value
	CountryCodeNf = "NF"

	// CountryCodeMp is a CountryCode enum value
	CountryCodeMp = "MP"

	// CountryCodeNo is a CountryCode enum value
	CountryCodeNo = "NO"

	// CountryCodeOm is a CountryCode enum value
	CountryCodeOm = "OM"

	// CountryCodePk is a CountryCode enum value
	CountryCodePk = "PK"

	// CountryCodePw is a CountryCode enum value
	CountryCodePw = "PW"

	// CountryCodePs is a CountryCode enum value
	CountryCodePs = "PS"

	// CountryCodePa is a CountryCode enum value
	CountryCodePa = "PA"

	// CountryCodePg is a CountryCode enum value
	CountryCodePg = "PG"

	// CountryCodePy is a CountryCode enum value
	CountryCodePy = "PY"

	// CountryCodePe is a CountryCode enum value
	CountryCodePe = "PE"

	// CountryCodePh is a CountryCode enum value
	CountryCodePh = "PH"

	// CountryCodePn is a CountryCode enum value
	CountryCodePn = "PN"

	// CountryCodePl is a CountryCode enum value
	CountryCodePl = "PL"

	// CountryCodePt is a CountryCode enum value
	CountryCodePt = "PT"

	// CountryCodePr is a CountryCode enum value
	CountryCodePr = "PR"

	// CountryCodeQa is a CountryCode enum value
	CountryCodeQa = "QA"

	// CountryCodeRe is a CountryCode enum value
	CountryCodeRe = "RE"

	// CountryCodeRo is a CountryCode enum value
	CountryCodeRo = "RO"

	// CountryCodeRu is a CountryCode enum value
	CountryCodeRu = "RU"

	// CountryCodeRw is a CountryCode enum value
	CountryCodeRw = "RW"

	// CountryCodeBl is a CountryCode enum value
	CountryCodeBl = "BL"

	// CountryCodeSh is a CountryCode enum value
	CountryCodeSh = "SH"

	// CountryCodeKn is a CountryCode enum value
	CountryCodeKn = "KN"

	// CountryCodeLc is a CountryCode enum value
	CountryCodeLc = "LC"

	// CountryCodeMf is a CountryCode enum value
	CountryCodeMf = "MF"

	// CountryCodePm is a CountryCode enum value
	CountryCodePm = "PM"

	// CountryCodeVc is a CountryCode enum value
	CountryCodeVc = "VC"

	// CountryCodeWs is a CountryCode enum value
	CountryCodeWs = "WS"

	// CountryCodeSm is a CountryCode enum value
	CountryCodeSm = "SM"

	// CountryCodeSt is a CountryCode enum value
	CountryCodeSt = "ST"

	// CountryCodeSa is a CountryCode enum value
	CountryCodeSa = "SA"

	// CountryCodeSn is a CountryCode enum value
	CountryCodeSn = "SN"

	// CountryCodeRs is a CountryCode enum value
	CountryCodeRs = "RS"

	// CountryCodeSc is a CountryCode enum value
	CountryCodeSc = "SC"

	// CountryCodeSl is a CountryCode enum value
	CountryCodeSl = "SL"

	// CountryCodeSg is a CountryCode enum value
	CountryCodeSg = "SG"

	// CountryCodeSx is a CountryCode enum value
	CountryCodeSx = "SX"

	// CountryCodeSk is a CountryCode enum value
	CountryCodeSk = "SK"

	// CountryCodeSi is a CountryCode enum value
	CountryCodeSi = "SI"

	// CountryCodeSb is a CountryCode enum value
	CountryCodeSb = "SB"

	// CountryCodeSo is a CountryCode enum value
	CountryCodeSo = "SO"

	// CountryCodeZa is a CountryCode enum value
	CountryCodeZa = "ZA"

	// CountryCodeGs is a CountryCode enum value
	CountryCodeGs = "GS"

	// CountryCodeSs is a CountryCode enum value
	CountryCodeSs = "SS"

	// CountryCodeEs is a CountryCode enum value
	CountryCodeEs = "ES"

	// CountryCodeLk is a CountryCode enum value
	CountryCodeLk = "LK"

	// CountryCodeSd is a CountryCode enum value
	CountryCodeSd = "SD"

	// CountryCodeSr is a CountryCode enum value
	CountryCodeSr = "SR"

	// CountryCodeSj is a CountryCode enum value
	CountryCodeSj = "SJ"

	// CountryCodeSz is a CountryCode enum value
	CountryCodeSz = "SZ"

	// CountryCodeSe is a CountryCode enum value
	CountryCodeSe = "SE"

	// CountryCodeCh is a CountryCode enum value
	CountryCodeCh = "CH"

	// CountryCodeSy is a CountryCode enum value
	CountryCodeSy = "SY"

	// CountryCodeTw is a CountryCode enum value
	CountryCodeTw = "TW"

	// CountryCodeTj is a CountryCode enum value
	CountryCodeTj = "TJ"

	// CountryCodeTz is a CountryCode enum value
	CountryCodeTz = "TZ"

	// CountryCodeTh is a CountryCode enum value
	CountryCodeTh = "TH"

	// CountryCodeTl is a CountryCode enum value
	CountryCodeTl = "TL"

	// CountryCodeTg is a CountryCode enum value
	CountryCodeTg = "TG"

	// CountryCodeTk is a CountryCode enum value
	CountryCodeTk = "TK"

	// CountryCodeTo is a CountryCode enum value
	CountryCodeTo = "TO"

	// CountryCodeTt is a CountryCode enum value
	CountryCodeTt = "TT"

	// CountryCodeTn is a CountryCode enum value
	CountryCodeTn = "TN"

	// CountryCodeTr is a CountryCode enum value
	CountryCodeTr = "TR"

	// CountryCodeTm is a CountryCode enum value
	CountryCodeTm = "TM"

	// CountryCodeTc is a CountryCode enum value
	CountryCodeTc = "TC"

	// CountryCodeTv is a CountryCode enum value
	CountryCodeTv = "TV"

	// CountryCodeUg is a CountryCode enum value
	CountryCodeUg = "UG"

	// CountryCodeUa is a CountryCode enum value
	CountryCodeUa = "UA"

	// CountryCodeAe is a CountryCode enum value
	CountryCodeAe = "AE"

	// CountryCodeGb is a CountryCode enum value
	CountryCodeGb = "GB"

	// CountryCodeUs is a CountryCode enum value
	CountryCodeUs = "US"

	// CountryCodeUm is a CountryCode enum value
	CountryCodeUm = "UM"

	// CountryCodeUy is a CountryCode enum value
	CountryCodeUy = "UY"

	// CountryCodeUz is a CountryCode enum value
	CountryCodeUz = "UZ"

	// CountryCodeVu is a CountryCode enum value
	CountryCodeVu = "VU"

	// CountryCodeVe is a CountryCode enum value
	CountryCodeVe = "VE"

	// CountryCodeVn is a CountryCode enum value
	CountryCodeVn = "VN"

	// CountryCodeVg is a CountryCode enum value
	CountryCodeVg = "VG"

	// CountryCodeVi is a CountryCode enum value
	CountryCodeVi = "VI"

	// CountryCodeWf is a CountryCode enum value
	CountryCodeWf = "WF"

	// CountryCodeEh is a CountryCode enum value
	CountryCodeEh = "EH"

	// CountryCodeYe is a CountryCode enum value
	CountryCodeYe = "YE"

	// CountryCodeZm is a CountryCode enum value
	CountryCodeZm = "ZM"

	// CountryCodeZw is a CountryCode enum value
	CountryCodeZw = "ZW"
)

// CountryCode_Values returns all elements of the CountryCode enum
func CountryCode_Values() []string {
	return []string{
		CountryCodeAf,
		CountryCodeAx,
		CountryCodeAl,
		CountryCodeDz,
		CountryCodeAs,
		CountryCodeAd,
		CountryCodeAo,
		CountryCodeAi,
		CountryCodeAq,
		CountryCodeAg,
		CountryCodeAr,
		CountryCodeAm,
		CountryCodeAw,
		CountryCodeAu,
		CountryCodeAt,
		CountryCodeAz,
		CountryCodeBs,
		CountryCodeBh,
		CountryCodeBd,
		CountryCodeBb,
		CountryCodeBy,
		CountryCodeBe,
		CountryCodeBz,
		CountryCodeBj,
		CountryCodeBm,
		CountryCodeBt,
		CountryCodeBo,
		CountryCodeBq,
		CountryCodeBa,
		CountryCodeBw,
		CountryCodeBv,
		CountryCodeBr,
		CountryCodeIo,
		CountryCodeBn,
		CountryCodeBg,
		CountryCodeBf,
		CountryCodeBi,
		CountryCodeKh,
		CountryCodeCm,
		CountryCodeCa,
		CountryCodeCv,
		CountryCodeKy,
		CountryCodeCf,
		CountryCodeTd,
		CountryCodeCl,
		CountryCodeCn,
		CountryCodeCx,
		CountryCodeCc,
		CountryCodeCo,
		CountryCodeKm,
		CountryCodeCg,
		CountryCodeCd,
		CountryCodeCk,
		CountryCodeCr,
		CountryCodeCi,
		CountryCodeHr,
		CountryCodeCu,
		CountryCodeCw,
		CountryCodeCy,
		CountryCodeCz,
		CountryCodeDk,
		CountryCodeDj,
		CountryCodeDm,
		CountryCodeDo,
		CountryCodeEc,
		CountryCodeEg,
		CountryCodeSv,
		CountryCodeGq,
		CountryCodeEr,
		CountryCodeEe,
		CountryCodeEt,
		CountryCodeFk,
		CountryCodeFo,
		CountryCodeFj,
		CountryCodeFi,
		CountryCodeFr,
		CountryCodeGf,
		CountryCodePf,
		CountryCodeTf,
		CountryCodeGa,
		CountryCodeGm,
		CountryCodeGe,
		CountryCodeDe,
		CountryCodeGh,
		CountryCodeGi,
		CountryCodeGr,
		CountryCodeGl,
		CountryCodeGd,
		CountryCodeGp,
		CountryCodeGu,
		CountryCodeGt,
		CountryCodeGg,
		CountryCodeGn,
		CountryCodeGw,
		CountryCodeGy,
		CountryCodeHt,
		CountryCodeHm,
		CountryCodeVa,
		CountryCodeHn,
		CountryCodeHk,
		CountryCodeHu,
		CountryCodeIs,
		CountryCodeIn,
		CountryCodeId,
		CountryCodeIr,
		CountryCodeIq,
		CountryCodeIe,
		CountryCodeIm,
		CountryCodeIl,
		CountryCodeIt,
		CountryCodeJm,
		CountryCodeJp,
		CountryCodeJe,
		CountryCodeJo,
		CountryCodeKz,
		CountryCodeKe,
		CountryCodeKi,
		CountryCodeKp,
		CountryCodeKr,
		CountryCodeKw,
		CountryCodeKg,
		CountryCodeLa,
		CountryCodeLv,
		CountryCodeLb,
		CountryCodeLs,
		CountryCodeLr,
		CountryCodeLy,
		CountryCodeLi,
		CountryCodeLt,
		CountryCodeLu,
		CountryCodeMo,
		CountryCodeMk,
		CountryCodeMg,
		CountryCodeMw,
		CountryCodeMy,
		CountryCodeMv,
		CountryCodeMl,
		CountryCodeMt,
		CountryCodeMh,
		CountryCodeMq,
		CountryCodeMr,
		CountryCodeMu,
		CountryCodeYt,
		CountryCodeMx,
		CountryCodeFm,
		CountryCodeMd,
		CountryCodeMc,
		CountryCodeMn,
		CountryCodeMe,
		CountryCodeMs,
		CountryCodeMa,
		CountryCodeMz,
		CountryCodeMm,
		CountryCodeNa,
		CountryCodeNr,
		CountryCodeNp,
		CountryCodeNl,
		CountryCodeNc,
		CountryCodeNz,
		CountryCodeNi,
		CountryCodeNe,
		CountryCodeNg,
		CountryCodeNu,
		CountryCodeNf,
		CountryCodeMp,
		CountryCodeNo,
		CountryCodeOm,
		CountryCodePk,
		CountryCodePw,
		CountryCodePs,
		CountryCodePa,
		CountryCodePg,
		CountryCodePy,
		CountryCodePe,
		CountryCodePh,
		CountryCodePn,
		CountryCodePl,
		CountryCodePt,
		CountryCodePr,
		CountryCodeQa,
		CountryCodeRe,
		CountryCodeRo,
		CountryCodeRu,
		CountryCodeRw,
		CountryCodeBl,
		CountryCodeSh,
		CountryCodeKn,
		CountryCodeLc,
		CountryCodeMf,
		CountryCodePm,
		CountryCodeVc,
		CountryCodeWs,
		CountryCodeSm,
		CountryCodeSt,
		CountryCodeSa,
		CountryCodeSn,
		CountryCodeRs,
		CountryCodeSc,
		CountryCodeSl,
		CountryCodeSg,
		CountryCodeSx,
		CountryCodeSk,
		CountryCodeSi,
		CountryCodeSb,
		CountryCodeSo,
		CountryCodeZa,
		CountryCodeGs,
		CountryCodeSs,
		CountryCodeEs,
		CountryCodeLk,
		CountryCodeSd,
		CountryCodeSr,
		CountryCodeSj,
		CountryCodeSz,
		CountryCodeSe,
		CountryCodeCh,
		CountryCodeSy,
		CountryCodeTw,
		CountryCodeTj,
		CountryCodeTz,
		CountryCodeTh,
		CountryCodeTl,
		CountryCodeTg,
		CountryCodeTk,
		CountryCodeTo,
		CountryCodeTt,
		CountryCodeTn,
		CountryCodeTr,
		CountryCodeTm,
		CountryCodeTc,
		CountryCodeTv,
		CountryCodeUg,
		CountryCodeUa,
		CountryCodeAe,
		CountryCodeGb,
		CountryCodeUs,
		CountryCodeUm,
		CountryCodeUy,
		CountryCodeUz,
		CountryCodeVu,
		CountryCodeVe,
		CountryCodeVn,
		CountryCodeVg,
		CountryCodeVi,
		CountryCodeWf,
		CountryCodeEh,
		CountryCodeYe,
		CountryCodeZm,
		CountryCodeZw,
	}
}

const (
	// FallbackBehaviorMatch is a FallbackBehavior enum value
	FallbackBehaviorMatch = "MATCH"

	// FallbackBehaviorNoMatch is a FallbackBehavior enum value
	FallbackBehaviorNoMatch = "NO_MATCH"
)

// FallbackBehavior_Values returns all elements of the FallbackBehavior enum
func FallbackBehavior_Values() []string {
	return []string{
		FallbackBehaviorMatch,
		FallbackBehaviorNoMatch,
	}
}

const (
	// FilterBehaviorKeep is a FilterBehavior enum value
	FilterBehaviorKeep = "KEEP"

	// FilterBehaviorDrop is a FilterBehavior enum value
	FilterBehaviorDrop = "DROP"
)

// FilterBehavior_Values returns all elements of the FilterBehavior enum
func FilterBehavior_Values() []string {
	return []string{
		FilterBehaviorKeep,
		FilterBehaviorDrop,
	}
}

const (
	// FilterRequirementMeetsAll is a FilterRequirement enum value
	FilterRequirementMeetsAll = "MEETS_ALL"

	// FilterRequirementMeetsAny is a FilterRequirement enum value
	FilterRequirementMeetsAny = "MEETS_ANY"
)

// FilterRequirement_Values returns all elements of the FilterRequirement enum
func FilterRequirement_Values() []string {
	return []string{
		FilterRequirementMeetsAll,
		FilterRequirementMeetsAny,
	}
}

const (
	// ForwardedIPPositionFirst is a ForwardedIPPosition enum value
	ForwardedIPPositionFirst = "FIRST"

	// ForwardedIPPositionLast is a ForwardedIPPosition enum value
	ForwardedIPPositionLast = "LAST"

	// ForwardedIPPositionAny is a ForwardedIPPosition enum value
	ForwardedIPPositionAny = "ANY"
)

// ForwardedIPPosition_Values returns all elements of the ForwardedIPPosition enum
func ForwardedIPPosition_Values() []string {
	return []string{
		ForwardedIPPositionFirst,
		ForwardedIPPositionLast,
		ForwardedIPPositionAny,
	}
}

const (
	// IPAddressVersionIpv4 is a IPAddressVersion enum value
	IPAddressVersionIpv4 = "IPV4"

	// IPAddressVersionIpv6 is a IPAddressVersion enum value
	IPAddressVersionIpv6 = "IPV6"
)

// IPAddressVersion_Values returns all elements of the IPAddressVersion enum
func IPAddressVersion_Values() []string {
	return []string{
		IPAddressVersionIpv4,
		IPAddressVersionIpv6,
	}
}

const (
	// JsonMatchScopeAll is a JsonMatchScope enum value
	JsonMatchScopeAll = "ALL"

	// JsonMatchScopeKey is a JsonMatchScope enum value
	JsonMatchScopeKey = "KEY"

	// JsonMatchScopeValue is a JsonMatchScope enum value
	JsonMatchScopeValue = "VALUE"
)

// JsonMatchScope_Values returns all elements of the JsonMatchScope enum
func JsonMatchScope_Values() []string {
	return []string{
		JsonMatchScopeAll,
		JsonMatchScopeKey,
		JsonMatchScopeValue,
	}
}

const (
	// LabelMatchScopeLabel is a LabelMatchScope enum value
	LabelMatchScopeLabel = "LABEL"

	// LabelMatchScopeNamespace is a LabelMatchScope enum value
	LabelMatchScopeNamespace = "NAMESPACE"
)

// LabelMatchScope_Values returns all elements of the LabelMatchScope enum
func LabelMatchScope_Values() []string {
	return []string{
		LabelMatchScopeLabel,
		LabelMatchScopeNamespace,
	}
}

const (
	// ParameterExceptionFieldWebAcl is a ParameterExceptionField enum value
	ParameterExceptionFieldWebAcl = "WEB_ACL"

	// ParameterExceptionFieldRuleGroup is a ParameterExceptionField enum value
	ParameterExceptionFieldRuleGroup = "RULE_GROUP"

	// ParameterExceptionFieldRegexPatternSet is a ParameterExceptionField enum value
	ParameterExceptionFieldRegexPatternSet = "REGEX_PATTERN_SET"

	// ParameterExceptionFieldIpSet is a ParameterExceptionField enum value
	ParameterExceptionFieldIpSet = "IP_SET"

	// ParameterExceptionFieldManagedRuleSet is a ParameterExceptionField enum value
	ParameterExceptionFieldManagedRuleSet = "MANAGED_RULE_SET"

	// ParameterExceptionFieldRule is a ParameterExceptionField enum value
	ParameterExceptionFieldRule = "RULE"

	// ParameterExceptionFieldExcludedRule is a ParameterExceptionField enum value
	ParameterExceptionFieldExcludedRule = "EXCLUDED_RULE"

	// ParameterExceptionFieldStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldStatement = "STATEMENT"

	// ParameterExceptionFieldByteMatchStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchStatement = "BYTE_MATCH_STATEMENT"

	// ParameterExceptionFieldSqliMatchStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldSqliMatchStatement = "SQLI_MATCH_STATEMENT"

	// ParameterExceptionFieldXssMatchStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldXssMatchStatement = "XSS_MATCH_STATEMENT"

	// ParameterExceptionFieldSizeConstraintStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldSizeConstraintStatement = "SIZE_CONSTRAINT_STATEMENT"

	// ParameterExceptionFieldGeoMatchStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldGeoMatchStatement = "GEO_MATCH_STATEMENT"

	// ParameterExceptionFieldRateBasedStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldRateBasedStatement = "RATE_BASED_STATEMENT"

	// ParameterExceptionFieldRuleGroupReferenceStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldRuleGroupReferenceStatement = "RULE_GROUP_REFERENCE_STATEMENT"

	// ParameterExceptionFieldRegexPatternReferenceStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldRegexPatternReferenceStatement = "REGEX_PATTERN_REFERENCE_STATEMENT"

	// ParameterExceptionFieldIpSetReferenceStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldIpSetReferenceStatement = "IP_SET_REFERENCE_STATEMENT"

	// ParameterExceptionFieldManagedRuleSetStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldManagedRuleSetStatement = "MANAGED_RULE_SET_STATEMENT"

	// ParameterExceptionFieldLabelMatchStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldLabelMatchStatement = "LABEL_MATCH_STATEMENT"

	// ParameterExceptionFieldAndStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldAndStatement = "AND_STATEMENT"

	// ParameterExceptionFieldOrStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldOrStatement = "OR_STATEMENT"

	// ParameterExceptionFieldNotStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldNotStatement = "NOT_STATEMENT"

	// ParameterExceptionFieldIpAddress is a ParameterExceptionField enum value
	ParameterExceptionFieldIpAddress = "IP_ADDRESS"

	// ParameterExceptionFieldIpAddressVersion is a ParameterExceptionField enum value
	ParameterExceptionFieldIpAddressVersion = "IP_ADDRESS_VERSION"

	// ParameterExceptionFieldFieldToMatch is a ParameterExceptionField enum value
	ParameterExceptionFieldFieldToMatch = "FIELD_TO_MATCH"

	// ParameterExceptionFieldTextTransformation is a ParameterExceptionField enum value
	ParameterExceptionFieldTextTransformation = "TEXT_TRANSFORMATION"

	// ParameterExceptionFieldSingleQueryArgument is a ParameterExceptionField enum value
	ParameterExceptionFieldSingleQueryArgument = "SINGLE_QUERY_ARGUMENT"

	// ParameterExceptionFieldSingleHeader is a ParameterExceptionField enum value
	ParameterExceptionFieldSingleHeader = "SINGLE_HEADER"

	// ParameterExceptionFieldDefaultAction is a ParameterExceptionField enum value
	ParameterExceptionFieldDefaultAction = "DEFAULT_ACTION"

	// ParameterExceptionFieldRuleAction is a ParameterExceptionField enum value
	ParameterExceptionFieldRuleAction = "RULE_ACTION"

	// ParameterExceptionFieldEntityLimit is a ParameterExceptionField enum value
	ParameterExceptionFieldEntityLimit = "ENTITY_LIMIT"

	// ParameterExceptionFieldOverrideAction is a ParameterExceptionField enum value
	ParameterExceptionFieldOverrideAction = "OVERRIDE_ACTION"

	// ParameterExceptionFieldScopeValue is a ParameterExceptionField enum value
	ParameterExceptionFieldScopeValue = "SCOPE_VALUE"

	// ParameterExceptionFieldResourceArn is a ParameterExceptionField enum value
	ParameterExceptionFieldResourceArn = "RESOURCE_ARN"

	// ParameterExceptionFieldResourceType is a ParameterExceptionField enum value
	ParameterExceptionFieldResourceType = "RESOURCE_TYPE"

	// ParameterExceptionFieldTags is a ParameterExceptionField enum value
	ParameterExceptionFieldTags = "TAGS"

	// ParameterExceptionFieldTagKeys is a ParameterExceptionField enum value
	ParameterExceptionFieldTagKeys = "TAG_KEYS"

	// ParameterExceptionFieldMetricName is a ParameterExceptionField enum value
	ParameterExceptionFieldMetricName = "METRIC_NAME"

	// ParameterExceptionFieldFirewallManagerStatement is a ParameterExceptionField enum value
	ParameterExceptionFieldFirewallManagerStatement = "FIREWALL_MANAGER_STATEMENT"

	// ParameterExceptionFieldFallbackBehavior is a ParameterExceptionField enum value
	ParameterExceptionFieldFallbackBehavior = "FALLBACK_BEHAVIOR"

	// ParameterExceptionFieldPosition is a ParameterExceptionField enum value
	ParameterExceptionFieldPosition = "POSITION"

	// ParameterExceptionFieldForwardedIpConfig is a ParameterExceptionField enum value
	ParameterExceptionFieldForwardedIpConfig = "FORWARDED_IP_CONFIG"

	// ParameterExceptionFieldIpSetForwardedIpConfig is a ParameterExceptionField enum value
	ParameterExceptionFieldIpSetForwardedIpConfig = "IP_SET_FORWARDED_IP_CONFIG"

	// ParameterExceptionFieldHeaderName is a ParameterExceptionField enum value
	ParameterExceptionFieldHeaderName = "HEADER_NAME"

	// ParameterExceptionFieldCustomRequestHandling is a ParameterExceptionField enum value
	ParameterExceptionFieldCustomRequestHandling = "CUSTOM_REQUEST_HANDLING"

	// ParameterExceptionFieldResponseContentType is a ParameterExceptionField enum value
	ParameterExceptionFieldResponseContentType = "RESPONSE_CONTENT_TYPE"

	// ParameterExceptionFieldCustomResponse is a ParameterExceptionField enum value
	ParameterExceptionFieldCustomResponse = "CUSTOM_RESPONSE"

	// ParameterExceptionFieldCustomResponseBody is a ParameterExceptionField enum value
	ParameterExceptionFieldCustomResponseBody = "CUSTOM_RESPONSE_BODY"

	// ParameterExceptionFieldJsonMatchPattern is a ParameterExceptionField enum value
	ParameterExceptionFieldJsonMatchPattern = "JSON_MATCH_PATTERN"

	// ParameterExceptionFieldJsonMatchScope is a ParameterExceptionField enum value
	ParameterExceptionFieldJsonMatchScope = "JSON_MATCH_SCOPE"

	// ParameterExceptionFieldBodyParsingFallbackBehavior is a ParameterExceptionField enum value
	ParameterExceptionFieldBodyParsingFallbackBehavior = "BODY_PARSING_FALLBACK_BEHAVIOR"

	// ParameterExceptionFieldLoggingFilter is a ParameterExceptionField enum value
	ParameterExceptionFieldLoggingFilter = "LOGGING_FILTER"

	// ParameterExceptionFieldFilterCondition is a ParameterExceptionField enum value
	ParameterExceptionFieldFilterCondition = "FILTER_CONDITION"
)

// ParameterExceptionField_Values returns all elements of the ParameterExceptionField enum
func ParameterExceptionField_Values() []string {
	return []string{
		ParameterExceptionFieldWebAcl,
		ParameterExceptionFieldRuleGroup,
		ParameterExceptionFieldRegexPatternSet,
		ParameterExceptionFieldIpSet,
		ParameterExceptionFieldManagedRuleSet,
		ParameterExceptionFieldRule,
		ParameterExceptionFieldExcludedRule,
		ParameterExceptionFieldStatement,
		ParameterExceptionFieldByteMatchStatement,
		ParameterExceptionFieldSqliMatchStatement,
		ParameterExceptionFieldXssMatchStatement,
		ParameterExceptionFieldSizeConstraintStatement,
		ParameterExceptionFieldGeoMatchStatement,
		ParameterExceptionFieldRateBasedStatement,
		ParameterExceptionFieldRuleGroupReferenceStatement,
		ParameterExceptionFieldRegexPatternReferenceStatement,
		ParameterExceptionFieldIpSetReferenceStatement,
		ParameterExceptionFieldManagedRuleSetStatement,
		ParameterExceptionFieldLabelMatchStatement,
		ParameterExceptionFieldAndStatement,
		ParameterExceptionFieldOrStatement,
		ParameterExceptionFieldNotStatement,
		ParameterExceptionFieldIpAddress,
		ParameterExceptionFieldIpAddressVersion,
		ParameterExceptionFieldFieldToMatch,
		ParameterExceptionFieldTextTransformation,
		ParameterExceptionFieldSingleQueryArgument,
		ParameterExceptionFieldSingleHeader,
		ParameterExceptionFieldDefaultAction,
		ParameterExceptionFieldRuleAction,
		ParameterExceptionFieldEntityLimit,
		ParameterExceptionFieldOverrideAction,
		ParameterExceptionFieldScopeValue,
		ParameterExceptionFieldResourceArn,
		ParameterExceptionFieldResourceType,
		ParameterExceptionFieldTags,
		ParameterExceptionFieldTagKeys,
		ParameterExceptionFieldMetricName,
		ParameterExceptionFieldFirewallManagerStatement,
		ParameterExceptionFieldFallbackBehavior,
		ParameterExceptionFieldPosition,
		ParameterExceptionFieldForwardedIpConfig,
		ParameterExceptionFieldIpSetForwardedIpConfig,
		ParameterExceptionFieldHeaderName,
		ParameterExceptionFieldCustomRequestHandling,
		ParameterExceptionFieldResponseContentType,
		ParameterExceptionFieldCustomResponse,
		ParameterExceptionFieldCustomResponseBody,
		ParameterExceptionFieldJsonMatchPattern,
		ParameterExceptionFieldJsonMatchScope,
		ParameterExceptionFieldBodyParsingFallbackBehavior,
		ParameterExceptionFieldLoggingFilter,
		ParameterExceptionFieldFilterCondition,
	}
}

const (
	// PositionalConstraintExactly is a PositionalConstraint enum value
	PositionalConstraintExactly = "EXACTLY"

	// PositionalConstraintStartsWith is a PositionalConstraint enum value
	PositionalConstraintStartsWith = "STARTS_WITH"

	// PositionalConstraintEndsWith is a PositionalConstraint enum value
	PositionalConstraintEndsWith = "ENDS_WITH"

	// PositionalConstraintContains is a PositionalConstraint enum value
	PositionalConstraintContains = "CONTAINS"

	// PositionalConstraintContainsWord is a PositionalConstraint enum value
	PositionalConstraintContainsWord = "CONTAINS_WORD"
)

// PositionalConstraint_Values returns all elements of the PositionalConstraint enum
func PositionalConstraint_Values() []string {
	return []string{
		PositionalConstraintExactly,
		PositionalConstraintStartsWith,
		PositionalConstraintEndsWith,
		PositionalConstraintContains,
		PositionalConstraintContainsWord,
	}
}

const (
	// RateBasedStatementAggregateKeyTypeIp is a RateBasedStatementAggregateKeyType enum value
	RateBasedStatementAggregateKeyTypeIp = "IP"

	// RateBasedStatementAggregateKeyTypeForwardedIp is a RateBasedStatementAggregateKeyType enum value
	RateBasedStatementAggregateKeyTypeForwardedIp = "FORWARDED_IP"
)

// RateBasedStatementAggregateKeyType_Values returns all elements of the RateBasedStatementAggregateKeyType enum
func RateBasedStatementAggregateKeyType_Values() []string {
	return []string{
		RateBasedStatementAggregateKeyTypeIp,
		RateBasedStatementAggregateKeyTypeForwardedIp,
	}
}

const (
	// ResourceTypeApplicationLoadBalancer is a ResourceType enum value
	ResourceTypeApplicationLoadBalancer = "APPLICATION_LOAD_BALANCER"

	// ResourceTypeApiGateway is a ResourceType enum value
	ResourceTypeApiGateway = "API_GATEWAY"

	// ResourceTypeAppsync is a ResourceType enum value
	ResourceTypeAppsync = "APPSYNC"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeApplicationLoadBalancer,
		ResourceTypeApiGateway,
		ResourceTypeAppsync,
	}
}

const (
	// ResponseContentTypeTextPlain is a ResponseContentType enum value
	ResponseContentTypeTextPlain = "TEXT_PLAIN"

	// ResponseContentTypeTextHtml is a ResponseContentType enum value
	ResponseContentTypeTextHtml = "TEXT_HTML"

	// ResponseContentTypeApplicationJson is a ResponseContentType enum value
	ResponseContentTypeApplicationJson = "APPLICATION_JSON"
)

// ResponseContentType_Values returns all elements of the ResponseContentType enum
func ResponseContentType_Values() []string {
	return []string{
		ResponseContentTypeTextPlain,
		ResponseContentTypeTextHtml,
		ResponseContentTypeApplicationJson,
	}
}

const (
	// ScopeCloudfront is a Scope enum value
	ScopeCloudfront = "CLOUDFRONT"

	// ScopeRegional is a Scope enum value
	ScopeRegional = "REGIONAL"
)

// Scope_Values returns all elements of the Scope enum
func Scope_Values() []string {
	return []string{
		ScopeCloudfront,
		ScopeRegional,
	}
}

const (
	// TextTransformationTypeNone is a TextTransformationType enum value
	TextTransformationTypeNone = "NONE"

	// TextTransformationTypeCompressWhiteSpace is a TextTransformationType enum value
	TextTransformationTypeCompressWhiteSpace = "COMPRESS_WHITE_SPACE"

	// TextTransformationTypeHtmlEntityDecode is a TextTransformationType enum value
	TextTransformationTypeHtmlEntityDecode = "HTML_ENTITY_DECODE"

	// TextTransformationTypeLowercase is a TextTransformationType enum value
	TextTransformationTypeLowercase = "LOWERCASE"

	// TextTransformationTypeCmdLine is a TextTransformationType enum value
	TextTransformationTypeCmdLine = "CMD_LINE"

	// TextTransformationTypeUrlDecode is a TextTransformationType enum value
	TextTransformationTypeUrlDecode = "URL_DECODE"

	// TextTransformationTypeBase64Decode is a TextTransformationType enum value
	TextTransformationTypeBase64Decode = "BASE64_DECODE"

	// TextTransformationTypeHexDecode is a TextTransformationType enum value
	TextTransformationTypeHexDecode = "HEX_DECODE"

	// TextTransformationTypeMd5 is a TextTransformationType enum value
	TextTransformationTypeMd5 = "MD5"

	// TextTransformationTypeReplaceComments is a TextTransformationType enum value
	TextTransformationTypeReplaceComments = "REPLACE_COMMENTS"

	// TextTransformationTypeEscapeSeqDecode is a TextTransformationType enum value
	TextTransformationTypeEscapeSeqDecode = "ESCAPE_SEQ_DECODE"

	// TextTransformationTypeSqlHexDecode is a TextTransformationType enum value
	TextTransformationTypeSqlHexDecode = "SQL_HEX_DECODE"

	// TextTransformationTypeCssDecode is a TextTransformationType enum value
	TextTransformationTypeCssDecode = "CSS_DECODE"

	// TextTransformationTypeJsDecode is a TextTransformationType enum value
	TextTransformationTypeJsDecode = "JS_DECODE"

	// TextTransformationTypeNormalizePath is a TextTransformationType enum value
	TextTransformationTypeNormalizePath = "NORMALIZE_PATH"

	// TextTransformationTypeNormalizePathWin is a TextTransformationType enum value
	TextTransformationTypeNormalizePathWin = "NORMALIZE_PATH_WIN"

	// TextTransformationTypeRemoveNulls is a TextTransformationType enum value
	TextTransformationTypeRemoveNulls = "REMOVE_NULLS"

	// TextTransformationTypeReplaceNulls is a TextTransformationType enum value
	TextTransformationTypeReplaceNulls = "REPLACE_NULLS"

	// TextTransformationTypeBase64DecodeExt is a TextTransformationType enum value
	TextTransformationTypeBase64DecodeExt = "BASE64_DECODE_EXT"

	// TextTransformationTypeUrlDecodeUni is a TextTransformationType enum value
	TextTransformationTypeUrlDecodeUni = "URL_DECODE_UNI"

	// TextTransformationTypeUtf8ToUnicode is a TextTransformationType enum value
	TextTransformationTypeUtf8ToUnicode = "UTF8_TO_UNICODE"
)

// TextTransformationType_Values returns all elements of the TextTransformationType enum
func TextTransformationType_Values() []string {
	return []string{
		TextTransformationTypeNone,
		TextTransformationTypeCompressWhiteSpace,
		TextTransformationTypeHtmlEntityDecode,
		TextTransformationTypeLowercase,
		TextTransformationTypeCmdLine,
		TextTransformationTypeUrlDecode,
		TextTransformationTypeBase64Decode,
		TextTransformationTypeHexDecode,
		TextTransformationTypeMd5,
		TextTransformationTypeReplaceComments,
		TextTransformationTypeEscapeSeqDecode,
		TextTransformationTypeSqlHexDecode,
		TextTransformationTypeCssDecode,
		TextTransformationTypeJsDecode,
		TextTransformationTypeNormalizePath,
		TextTransformationTypeNormalizePathWin,
		TextTransformationTypeRemoveNulls,
		TextTransformationTypeReplaceNulls,
		TextTransformationTypeBase64DecodeExt,
		TextTransformationTypeUrlDecodeUni,
		TextTransformationTypeUtf8ToUnicode,
	}
}
