//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package datafactory

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/datafactory/mgmt/2018-06-01/datafactory"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AmazonRdsForOraclePartitionOption = original.AmazonRdsForOraclePartitionOption

const (
	AmazonRdsForOraclePartitionOptionDynamicRange              AmazonRdsForOraclePartitionOption = original.AmazonRdsForOraclePartitionOptionDynamicRange
	AmazonRdsForOraclePartitionOptionNone                      AmazonRdsForOraclePartitionOption = original.AmazonRdsForOraclePartitionOptionNone
	AmazonRdsForOraclePartitionOptionPhysicalPartitionsOfTable AmazonRdsForOraclePartitionOption = original.AmazonRdsForOraclePartitionOptionPhysicalPartitionsOfTable
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeAnonymous                      AuthenticationType = original.AuthenticationTypeAnonymous
	AuthenticationTypeBasic                          AuthenticationType = original.AuthenticationTypeBasic
	AuthenticationTypeClientCertificate              AuthenticationType = original.AuthenticationTypeClientCertificate
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = original.AuthenticationTypeWebLinkedServiceTypeProperties
)

type AuthorizationType = original.AuthorizationType

const (
	AuthorizationTypeKey                          AuthorizationType = original.AuthorizationTypeKey
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = original.AuthorizationTypeLinkedIntegrationRuntimeType
	AuthorizationTypeRBAC                         AuthorizationType = original.AuthorizationTypeRBAC
)

type AvroCompressionCodec = original.AvroCompressionCodec

const (
	AvroCompressionCodecBzip2   AvroCompressionCodec = original.AvroCompressionCodecBzip2
	AvroCompressionCodecDeflate AvroCompressionCodec = original.AvroCompressionCodecDeflate
	AvroCompressionCodecNone    AvroCompressionCodec = original.AvroCompressionCodecNone
	AvroCompressionCodecSnappy  AvroCompressionCodec = original.AvroCompressionCodecSnappy
	AvroCompressionCodecXz      AvroCompressionCodec = original.AvroCompressionCodecXz
)

type AzureFunctionActivityMethod = original.AzureFunctionActivityMethod

const (
	AzureFunctionActivityMethodDELETE  AzureFunctionActivityMethod = original.AzureFunctionActivityMethodDELETE
	AzureFunctionActivityMethodGET     AzureFunctionActivityMethod = original.AzureFunctionActivityMethodGET
	AzureFunctionActivityMethodHEAD    AzureFunctionActivityMethod = original.AzureFunctionActivityMethodHEAD
	AzureFunctionActivityMethodOPTIONS AzureFunctionActivityMethod = original.AzureFunctionActivityMethodOPTIONS
	AzureFunctionActivityMethodPOST    AzureFunctionActivityMethod = original.AzureFunctionActivityMethodPOST
	AzureFunctionActivityMethodPUT     AzureFunctionActivityMethod = original.AzureFunctionActivityMethodPUT
	AzureFunctionActivityMethodTRACE   AzureFunctionActivityMethod = original.AzureFunctionActivityMethodTRACE
)

type AzureSearchIndexWriteBehaviorType = original.AzureSearchIndexWriteBehaviorType

const (
	AzureSearchIndexWriteBehaviorTypeMerge  AzureSearchIndexWriteBehaviorType = original.AzureSearchIndexWriteBehaviorTypeMerge
	AzureSearchIndexWriteBehaviorTypeUpload AzureSearchIndexWriteBehaviorType = original.AzureSearchIndexWriteBehaviorTypeUpload
)

type BlobEventTypes = original.BlobEventTypes

const (
	BlobEventTypesMicrosoftStorageBlobCreated BlobEventTypes = original.BlobEventTypesMicrosoftStorageBlobCreated
	BlobEventTypesMicrosoftStorageBlobDeleted BlobEventTypes = original.BlobEventTypesMicrosoftStorageBlobDeleted
)

type CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevels

const (
	CassandraSourceReadConsistencyLevelsALL         CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsALL
	CassandraSourceReadConsistencyLevelsEACHQUORUM  CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsEACHQUORUM
	CassandraSourceReadConsistencyLevelsLOCALONE    CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsLOCALONE
	CassandraSourceReadConsistencyLevelsLOCALQUORUM CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsLOCALQUORUM
	CassandraSourceReadConsistencyLevelsLOCALSERIAL CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsLOCALSERIAL
	CassandraSourceReadConsistencyLevelsONE         CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsONE
	CassandraSourceReadConsistencyLevelsQUORUM      CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsQUORUM
	CassandraSourceReadConsistencyLevelsSERIAL      CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsSERIAL
	CassandraSourceReadConsistencyLevelsTHREE       CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsTHREE
	CassandraSourceReadConsistencyLevelsTWO         CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevelsTWO
)

type CompressionCodec = original.CompressionCodec

const (
	CompressionCodecBzip2      CompressionCodec = original.CompressionCodecBzip2
	CompressionCodecDeflate    CompressionCodec = original.CompressionCodecDeflate
	CompressionCodecGzip       CompressionCodec = original.CompressionCodecGzip
	CompressionCodecLz4        CompressionCodec = original.CompressionCodecLz4
	CompressionCodecLzo        CompressionCodec = original.CompressionCodecLzo
	CompressionCodecNone       CompressionCodec = original.CompressionCodecNone
	CompressionCodecSnappy     CompressionCodec = original.CompressionCodecSnappy
	CompressionCodecTar        CompressionCodec = original.CompressionCodecTar
	CompressionCodecTarGZip    CompressionCodec = original.CompressionCodecTarGZip
	CompressionCodecZipDeflate CompressionCodec = original.CompressionCodecZipDeflate
)

type CopyBehaviorType = original.CopyBehaviorType

const (
	CopyBehaviorTypeFlattenHierarchy  CopyBehaviorType = original.CopyBehaviorTypeFlattenHierarchy
	CopyBehaviorTypeMergeFiles        CopyBehaviorType = original.CopyBehaviorTypeMergeFiles
	CopyBehaviorTypePreserveHierarchy CopyBehaviorType = original.CopyBehaviorTypePreserveHierarchy
)

type CosmosDbConnectionMode = original.CosmosDbConnectionMode

const (
	CosmosDbConnectionModeDirect  CosmosDbConnectionMode = original.CosmosDbConnectionModeDirect
	CosmosDbConnectionModeGateway CosmosDbConnectionMode = original.CosmosDbConnectionModeGateway
)

type CosmosDbServicePrincipalCredentialType = original.CosmosDbServicePrincipalCredentialType

const (
	CosmosDbServicePrincipalCredentialTypeServicePrincipalCert CosmosDbServicePrincipalCredentialType = original.CosmosDbServicePrincipalCredentialTypeServicePrincipalCert
	CosmosDbServicePrincipalCredentialTypeServicePrincipalKey  CosmosDbServicePrincipalCredentialType = original.CosmosDbServicePrincipalCredentialTypeServicePrincipalKey
)

type DataFlowComputeType = original.DataFlowComputeType

const (
	DataFlowComputeTypeComputeOptimized DataFlowComputeType = original.DataFlowComputeTypeComputeOptimized
	DataFlowComputeTypeGeneral          DataFlowComputeType = original.DataFlowComputeTypeGeneral
	DataFlowComputeTypeMemoryOptimized  DataFlowComputeType = original.DataFlowComputeTypeMemoryOptimized
)

type DataFlowDebugCommandType = original.DataFlowDebugCommandType

const (
	DataFlowDebugCommandTypeExecuteExpressionQuery DataFlowDebugCommandType = original.DataFlowDebugCommandTypeExecuteExpressionQuery
	DataFlowDebugCommandTypeExecutePreviewQuery    DataFlowDebugCommandType = original.DataFlowDebugCommandTypeExecutePreviewQuery
	DataFlowDebugCommandTypeExecuteStatisticsQuery DataFlowDebugCommandType = original.DataFlowDebugCommandTypeExecuteStatisticsQuery
)

type DatasetCompressionLevel = original.DatasetCompressionLevel

const (
	DatasetCompressionLevelFastest DatasetCompressionLevel = original.DatasetCompressionLevelFastest
	DatasetCompressionLevelOptimal DatasetCompressionLevel = original.DatasetCompressionLevelOptimal
)

type DayOfWeek = original.DayOfWeek

const (
	DayOfWeekFriday    DayOfWeek = original.DayOfWeekFriday
	DayOfWeekMonday    DayOfWeek = original.DayOfWeekMonday
	DayOfWeekSaturday  DayOfWeek = original.DayOfWeekSaturday
	DayOfWeekSunday    DayOfWeek = original.DayOfWeekSunday
	DayOfWeekThursday  DayOfWeek = original.DayOfWeekThursday
	DayOfWeekTuesday   DayOfWeek = original.DayOfWeekTuesday
	DayOfWeekWednesday DayOfWeek = original.DayOfWeekWednesday
)

type DaysOfWeek = original.DaysOfWeek

const (
	DaysOfWeekFriday    DaysOfWeek = original.DaysOfWeekFriday
	DaysOfWeekMonday    DaysOfWeek = original.DaysOfWeekMonday
	DaysOfWeekSaturday  DaysOfWeek = original.DaysOfWeekSaturday
	DaysOfWeekSunday    DaysOfWeek = original.DaysOfWeekSunday
	DaysOfWeekThursday  DaysOfWeek = original.DaysOfWeekThursday
	DaysOfWeekTuesday   DaysOfWeek = original.DaysOfWeekTuesday
	DaysOfWeekWednesday DaysOfWeek = original.DaysOfWeekWednesday
)

type Db2AuthenticationType = original.Db2AuthenticationType

const (
	Db2AuthenticationTypeBasic Db2AuthenticationType = original.Db2AuthenticationTypeBasic
)

type DependencyCondition = original.DependencyCondition

const (
	DependencyConditionCompleted DependencyCondition = original.DependencyConditionCompleted
	DependencyConditionFailed    DependencyCondition = original.DependencyConditionFailed
	DependencyConditionSkipped   DependencyCondition = original.DependencyConditionSkipped
	DependencyConditionSucceeded DependencyCondition = original.DependencyConditionSucceeded
)

type DynamicsAuthenticationType = original.DynamicsAuthenticationType

const (
	DynamicsAuthenticationTypeAADServicePrincipal DynamicsAuthenticationType = original.DynamicsAuthenticationTypeAADServicePrincipal
	DynamicsAuthenticationTypeIfd                 DynamicsAuthenticationType = original.DynamicsAuthenticationTypeIfd
	DynamicsAuthenticationTypeOffice365           DynamicsAuthenticationType = original.DynamicsAuthenticationTypeOffice365
)

type DynamicsDeploymentType = original.DynamicsDeploymentType

const (
	DynamicsDeploymentTypeOnline            DynamicsDeploymentType = original.DynamicsDeploymentTypeOnline
	DynamicsDeploymentTypeOnPremisesWithIfd DynamicsDeploymentType = original.DynamicsDeploymentTypeOnPremisesWithIfd
)

type DynamicsSinkWriteBehavior = original.DynamicsSinkWriteBehavior

const (
	DynamicsSinkWriteBehaviorUpsert DynamicsSinkWriteBehavior = original.DynamicsSinkWriteBehaviorUpsert
)

type EventSubscriptionStatus = original.EventSubscriptionStatus

const (
	EventSubscriptionStatusDeprovisioning EventSubscriptionStatus = original.EventSubscriptionStatusDeprovisioning
	EventSubscriptionStatusDisabled       EventSubscriptionStatus = original.EventSubscriptionStatusDisabled
	EventSubscriptionStatusEnabled        EventSubscriptionStatus = original.EventSubscriptionStatusEnabled
	EventSubscriptionStatusProvisioning   EventSubscriptionStatus = original.EventSubscriptionStatusProvisioning
	EventSubscriptionStatusUnknown        EventSubscriptionStatus = original.EventSubscriptionStatusUnknown
)

type FactoryIdentityType = original.FactoryIdentityType

const (
	FactoryIdentityTypeSystemAssigned             FactoryIdentityType = original.FactoryIdentityTypeSystemAssigned
	FactoryIdentityTypeSystemAssignedUserAssigned FactoryIdentityType = original.FactoryIdentityTypeSystemAssignedUserAssigned
	FactoryIdentityTypeUserAssigned               FactoryIdentityType = original.FactoryIdentityTypeUserAssigned
)

type FtpAuthenticationType = original.FtpAuthenticationType

const (
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = original.FtpAuthenticationTypeAnonymous
	FtpAuthenticationTypeBasic     FtpAuthenticationType = original.FtpAuthenticationTypeBasic
)

type GlobalParameterType = original.GlobalParameterType

const (
	GlobalParameterTypeArray  GlobalParameterType = original.GlobalParameterTypeArray
	GlobalParameterTypeBool   GlobalParameterType = original.GlobalParameterTypeBool
	GlobalParameterTypeFloat  GlobalParameterType = original.GlobalParameterTypeFloat
	GlobalParameterTypeInt    GlobalParameterType = original.GlobalParameterTypeInt
	GlobalParameterTypeObject GlobalParameterType = original.GlobalParameterTypeObject
	GlobalParameterTypeString GlobalParameterType = original.GlobalParameterTypeString
)

type GoogleAdWordsAuthenticationType = original.GoogleAdWordsAuthenticationType

const (
	GoogleAdWordsAuthenticationTypeServiceAuthentication GoogleAdWordsAuthenticationType = original.GoogleAdWordsAuthenticationTypeServiceAuthentication
	GoogleAdWordsAuthenticationTypeUserAuthentication    GoogleAdWordsAuthenticationType = original.GoogleAdWordsAuthenticationTypeUserAuthentication
)

type GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationType

const (
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationTypeServiceAuthentication
	GoogleBigQueryAuthenticationTypeUserAuthentication    GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationTypeUserAuthentication
)

type HBaseAuthenticationType = original.HBaseAuthenticationType

const (
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = original.HBaseAuthenticationTypeAnonymous
	HBaseAuthenticationTypeBasic     HBaseAuthenticationType = original.HBaseAuthenticationTypeBasic
)

type HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOption

const (
	HDInsightActivityDebugInfoOptionAlways  HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionAlways
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionFailure
	HDInsightActivityDebugInfoOptionNone    HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionNone
)

type HTTPAuthenticationType = original.HTTPAuthenticationType

const (
	HTTPAuthenticationTypeAnonymous         HTTPAuthenticationType = original.HTTPAuthenticationTypeAnonymous
	HTTPAuthenticationTypeBasic             HTTPAuthenticationType = original.HTTPAuthenticationTypeBasic
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = original.HTTPAuthenticationTypeClientCertificate
	HTTPAuthenticationTypeDigest            HTTPAuthenticationType = original.HTTPAuthenticationTypeDigest
	HTTPAuthenticationTypeWindows           HTTPAuthenticationType = original.HTTPAuthenticationTypeWindows
)

type HdiNodeTypes = original.HdiNodeTypes

const (
	HdiNodeTypesHeadnode   HdiNodeTypes = original.HdiNodeTypesHeadnode
	HdiNodeTypesWorkernode HdiNodeTypes = original.HdiNodeTypesWorkernode
	HdiNodeTypesZookeeper  HdiNodeTypes = original.HdiNodeTypesZookeeper
)

type HiveAuthenticationType = original.HiveAuthenticationType

const (
	HiveAuthenticationTypeAnonymous                    HiveAuthenticationType = original.HiveAuthenticationTypeAnonymous
	HiveAuthenticationTypeUsername                     HiveAuthenticationType = original.HiveAuthenticationTypeUsername
	HiveAuthenticationTypeUsernameAndPassword          HiveAuthenticationType = original.HiveAuthenticationTypeUsernameAndPassword
	HiveAuthenticationTypeWindowsAzureHDInsightService HiveAuthenticationType = original.HiveAuthenticationTypeWindowsAzureHDInsightService
)

type HiveServerType = original.HiveServerType

const (
	HiveServerTypeHiveServer1      HiveServerType = original.HiveServerTypeHiveServer1
	HiveServerTypeHiveServer2      HiveServerType = original.HiveServerTypeHiveServer2
	HiveServerTypeHiveThriftServer HiveServerType = original.HiveServerTypeHiveThriftServer
)

type HiveThriftTransportProtocol = original.HiveThriftTransportProtocol

const (
	HiveThriftTransportProtocolBinary HiveThriftTransportProtocol = original.HiveThriftTransportProtocolBinary
	HiveThriftTransportProtocolHTTP   HiveThriftTransportProtocol = original.HiveThriftTransportProtocolHTTP
	HiveThriftTransportProtocolSASL   HiveThriftTransportProtocol = original.HiveThriftTransportProtocolSASL
)

type ImpalaAuthenticationType = original.ImpalaAuthenticationType

const (
	ImpalaAuthenticationTypeAnonymous           ImpalaAuthenticationType = original.ImpalaAuthenticationTypeAnonymous
	ImpalaAuthenticationTypeSASLUsername        ImpalaAuthenticationType = original.ImpalaAuthenticationTypeSASLUsername
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = original.ImpalaAuthenticationTypeUsernameAndPassword
)

type IntegrationRuntimeAuthKeyName = original.IntegrationRuntimeAuthKeyName

const (
	IntegrationRuntimeAuthKeyNameAuthKey1 IntegrationRuntimeAuthKeyName = original.IntegrationRuntimeAuthKeyNameAuthKey1
	IntegrationRuntimeAuthKeyNameAuthKey2 IntegrationRuntimeAuthKeyName = original.IntegrationRuntimeAuthKeyNameAuthKey2
)

type IntegrationRuntimeAutoUpdate = original.IntegrationRuntimeAutoUpdate

const (
	IntegrationRuntimeAutoUpdateOff IntegrationRuntimeAutoUpdate = original.IntegrationRuntimeAutoUpdateOff
	IntegrationRuntimeAutoUpdateOn  IntegrationRuntimeAutoUpdate = original.IntegrationRuntimeAutoUpdateOn
)

type IntegrationRuntimeEdition = original.IntegrationRuntimeEdition

const (
	IntegrationRuntimeEditionEnterprise IntegrationRuntimeEdition = original.IntegrationRuntimeEditionEnterprise
	IntegrationRuntimeEditionStandard   IntegrationRuntimeEdition = original.IntegrationRuntimeEditionStandard
)

type IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceType

const (
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference      IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeLinkedServiceReference
)

type IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionMode

const (
	IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted
	IntegrationRuntimeInternalChannelEncryptionModeNotSet       IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionModeNotSet
	IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted
)

type IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseType

const (
	IntegrationRuntimeLicenseTypeBasePrice       IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseTypeBasePrice
	IntegrationRuntimeLicenseTypeLicenseIncluded IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseTypeLicenseIncluded
)

type IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTier

const (
	IntegrationRuntimeSsisCatalogPricingTierBasic     IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierBasic
	IntegrationRuntimeSsisCatalogPricingTierPremium   IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremium
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremiumRS
	IntegrationRuntimeSsisCatalogPricingTierStandard  IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierStandard
)

type IntegrationRuntimeState = original.IntegrationRuntimeState

const (
	IntegrationRuntimeStateAccessDenied     IntegrationRuntimeState = original.IntegrationRuntimeStateAccessDenied
	IntegrationRuntimeStateInitial          IntegrationRuntimeState = original.IntegrationRuntimeStateInitial
	IntegrationRuntimeStateLimited          IntegrationRuntimeState = original.IntegrationRuntimeStateLimited
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = original.IntegrationRuntimeStateNeedRegistration
	IntegrationRuntimeStateOffline          IntegrationRuntimeState = original.IntegrationRuntimeStateOffline
	IntegrationRuntimeStateOnline           IntegrationRuntimeState = original.IntegrationRuntimeStateOnline
	IntegrationRuntimeStateStarted          IntegrationRuntimeState = original.IntegrationRuntimeStateStarted
	IntegrationRuntimeStateStarting         IntegrationRuntimeState = original.IntegrationRuntimeStateStarting
	IntegrationRuntimeStateStopped          IntegrationRuntimeState = original.IntegrationRuntimeStateStopped
	IntegrationRuntimeStateStopping         IntegrationRuntimeState = original.IntegrationRuntimeStateStopping
)

type IntegrationRuntimeType = original.IntegrationRuntimeType

const (
	IntegrationRuntimeTypeManaged    IntegrationRuntimeType = original.IntegrationRuntimeTypeManaged
	IntegrationRuntimeTypeSelfHosted IntegrationRuntimeType = original.IntegrationRuntimeTypeSelfHosted
)

type IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResult

const (
	IntegrationRuntimeUpdateResultFail    IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResultFail
	IntegrationRuntimeUpdateResultNone    IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResultNone
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResultSucceed
)

type JSONFormatFilePattern = original.JSONFormatFilePattern

const (
	JSONFormatFilePatternArrayOfObjects JSONFormatFilePattern = original.JSONFormatFilePatternArrayOfObjects
	JSONFormatFilePatternSetOfObjects   JSONFormatFilePattern = original.JSONFormatFilePatternSetOfObjects
)

type JSONWriteFilePattern = original.JSONWriteFilePattern

const (
	JSONWriteFilePatternArrayOfObjects JSONWriteFilePattern = original.JSONWriteFilePatternArrayOfObjects
	JSONWriteFilePatternSetOfObjects   JSONWriteFilePattern = original.JSONWriteFilePatternSetOfObjects
)

type ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatus

const (
	ManagedIntegrationRuntimeNodeStatusAvailable   ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusAvailable
	ManagedIntegrationRuntimeNodeStatusRecycling   ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusRecycling
	ManagedIntegrationRuntimeNodeStatusStarting    ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusStarting
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusUnavailable
)

type MongoDbAuthenticationType = original.MongoDbAuthenticationType

const (
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = original.MongoDbAuthenticationTypeAnonymous
	MongoDbAuthenticationTypeBasic     MongoDbAuthenticationType = original.MongoDbAuthenticationTypeBasic
)

type NetezzaPartitionOption = original.NetezzaPartitionOption

const (
	NetezzaPartitionOptionDataSlice    NetezzaPartitionOption = original.NetezzaPartitionOptionDataSlice
	NetezzaPartitionOptionDynamicRange NetezzaPartitionOption = original.NetezzaPartitionOptionDynamicRange
	NetezzaPartitionOptionNone         NetezzaPartitionOption = original.NetezzaPartitionOptionNone
)

type ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialType

const (
	ODataAadServicePrincipalCredentialTypeServicePrincipalCert ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialTypeServicePrincipalCert
	ODataAadServicePrincipalCredentialTypeServicePrincipalKey  ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialTypeServicePrincipalKey
)

type ODataAuthenticationType = original.ODataAuthenticationType

const (
	ODataAuthenticationTypeAadServicePrincipal    ODataAuthenticationType = original.ODataAuthenticationTypeAadServicePrincipal
	ODataAuthenticationTypeAnonymous              ODataAuthenticationType = original.ODataAuthenticationTypeAnonymous
	ODataAuthenticationTypeBasic                  ODataAuthenticationType = original.ODataAuthenticationTypeBasic
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = original.ODataAuthenticationTypeManagedServiceIdentity
	ODataAuthenticationTypeWindows                ODataAuthenticationType = original.ODataAuthenticationTypeWindows
)

type OraclePartitionOption = original.OraclePartitionOption

const (
	OraclePartitionOptionDynamicRange              OraclePartitionOption = original.OraclePartitionOptionDynamicRange
	OraclePartitionOptionNone                      OraclePartitionOption = original.OraclePartitionOptionNone
	OraclePartitionOptionPhysicalPartitionsOfTable OraclePartitionOption = original.OraclePartitionOptionPhysicalPartitionsOfTable
)

type OrcCompressionCodec = original.OrcCompressionCodec

const (
	OrcCompressionCodecLzo    OrcCompressionCodec = original.OrcCompressionCodecLzo
	OrcCompressionCodecNone   OrcCompressionCodec = original.OrcCompressionCodecNone
	OrcCompressionCodecSnappy OrcCompressionCodec = original.OrcCompressionCodecSnappy
	OrcCompressionCodecZlib   OrcCompressionCodec = original.OrcCompressionCodecZlib
)

type ParameterType = original.ParameterType

const (
	ParameterTypeArray        ParameterType = original.ParameterTypeArray
	ParameterTypeBool         ParameterType = original.ParameterTypeBool
	ParameterTypeFloat        ParameterType = original.ParameterTypeFloat
	ParameterTypeInt          ParameterType = original.ParameterTypeInt
	ParameterTypeObject       ParameterType = original.ParameterTypeObject
	ParameterTypeSecureString ParameterType = original.ParameterTypeSecureString
	ParameterTypeString       ParameterType = original.ParameterTypeString
)

type PhoenixAuthenticationType = original.PhoenixAuthenticationType

const (
	PhoenixAuthenticationTypeAnonymous                    PhoenixAuthenticationType = original.PhoenixAuthenticationTypeAnonymous
	PhoenixAuthenticationTypeUsernameAndPassword          PhoenixAuthenticationType = original.PhoenixAuthenticationTypeUsernameAndPassword
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = original.PhoenixAuthenticationTypeWindowsAzureHDInsightService
)

type PolybaseSettingsRejectType = original.PolybaseSettingsRejectType

const (
	PolybaseSettingsRejectTypePercentage PolybaseSettingsRejectType = original.PolybaseSettingsRejectTypePercentage
	PolybaseSettingsRejectTypeValue      PolybaseSettingsRejectType = original.PolybaseSettingsRejectTypeValue
)

type PrestoAuthenticationType = original.PrestoAuthenticationType

const (
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = original.PrestoAuthenticationTypeAnonymous
	PrestoAuthenticationTypeLDAP      PrestoAuthenticationType = original.PrestoAuthenticationTypeLDAP
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = original.PublicNetworkAccessDisabled
	PublicNetworkAccessEnabled  PublicNetworkAccess = original.PublicNetworkAccessEnabled
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	RecurrenceFrequencyDay          RecurrenceFrequency = original.RecurrenceFrequencyDay
	RecurrenceFrequencyHour         RecurrenceFrequency = original.RecurrenceFrequencyHour
	RecurrenceFrequencyMinute       RecurrenceFrequency = original.RecurrenceFrequencyMinute
	RecurrenceFrequencyMonth        RecurrenceFrequency = original.RecurrenceFrequencyMonth
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = original.RecurrenceFrequencyNotSpecified
	RecurrenceFrequencyWeek         RecurrenceFrequency = original.RecurrenceFrequencyWeek
	RecurrenceFrequencyYear         RecurrenceFrequency = original.RecurrenceFrequencyYear
)

type RestServiceAuthenticationType = original.RestServiceAuthenticationType

const (
	RestServiceAuthenticationTypeAadServicePrincipal    RestServiceAuthenticationType = original.RestServiceAuthenticationTypeAadServicePrincipal
	RestServiceAuthenticationTypeAnonymous              RestServiceAuthenticationType = original.RestServiceAuthenticationTypeAnonymous
	RestServiceAuthenticationTypeBasic                  RestServiceAuthenticationType = original.RestServiceAuthenticationTypeBasic
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = original.RestServiceAuthenticationTypeManagedServiceIdentity
)

type RunQueryFilterOperand = original.RunQueryFilterOperand

const (
	RunQueryFilterOperandActivityName        RunQueryFilterOperand = original.RunQueryFilterOperandActivityName
	RunQueryFilterOperandActivityRunEnd      RunQueryFilterOperand = original.RunQueryFilterOperandActivityRunEnd
	RunQueryFilterOperandActivityRunStart    RunQueryFilterOperand = original.RunQueryFilterOperandActivityRunStart
	RunQueryFilterOperandActivityType        RunQueryFilterOperand = original.RunQueryFilterOperandActivityType
	RunQueryFilterOperandLatestOnly          RunQueryFilterOperand = original.RunQueryFilterOperandLatestOnly
	RunQueryFilterOperandPipelineName        RunQueryFilterOperand = original.RunQueryFilterOperandPipelineName
	RunQueryFilterOperandRunEnd              RunQueryFilterOperand = original.RunQueryFilterOperandRunEnd
	RunQueryFilterOperandRunGroupID          RunQueryFilterOperand = original.RunQueryFilterOperandRunGroupID
	RunQueryFilterOperandRunStart            RunQueryFilterOperand = original.RunQueryFilterOperandRunStart
	RunQueryFilterOperandStatus              RunQueryFilterOperand = original.RunQueryFilterOperandStatus
	RunQueryFilterOperandTriggerName         RunQueryFilterOperand = original.RunQueryFilterOperandTriggerName
	RunQueryFilterOperandTriggerRunTimestamp RunQueryFilterOperand = original.RunQueryFilterOperandTriggerRunTimestamp
)

type RunQueryFilterOperator = original.RunQueryFilterOperator

const (
	RunQueryFilterOperatorEquals    RunQueryFilterOperator = original.RunQueryFilterOperatorEquals
	RunQueryFilterOperatorIn        RunQueryFilterOperator = original.RunQueryFilterOperatorIn
	RunQueryFilterOperatorNotEquals RunQueryFilterOperator = original.RunQueryFilterOperatorNotEquals
	RunQueryFilterOperatorNotIn     RunQueryFilterOperator = original.RunQueryFilterOperatorNotIn
)

type RunQueryOrder = original.RunQueryOrder

const (
	RunQueryOrderASC  RunQueryOrder = original.RunQueryOrderASC
	RunQueryOrderDESC RunQueryOrder = original.RunQueryOrderDESC
)

type RunQueryOrderByField = original.RunQueryOrderByField

const (
	RunQueryOrderByFieldActivityName        RunQueryOrderByField = original.RunQueryOrderByFieldActivityName
	RunQueryOrderByFieldActivityRunEnd      RunQueryOrderByField = original.RunQueryOrderByFieldActivityRunEnd
	RunQueryOrderByFieldActivityRunStart    RunQueryOrderByField = original.RunQueryOrderByFieldActivityRunStart
	RunQueryOrderByFieldPipelineName        RunQueryOrderByField = original.RunQueryOrderByFieldPipelineName
	RunQueryOrderByFieldRunEnd              RunQueryOrderByField = original.RunQueryOrderByFieldRunEnd
	RunQueryOrderByFieldRunStart            RunQueryOrderByField = original.RunQueryOrderByFieldRunStart
	RunQueryOrderByFieldStatus              RunQueryOrderByField = original.RunQueryOrderByFieldStatus
	RunQueryOrderByFieldTriggerName         RunQueryOrderByField = original.RunQueryOrderByFieldTriggerName
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = original.RunQueryOrderByFieldTriggerRunTimestamp
)

type SQLAlwaysEncryptedAkvAuthType = original.SQLAlwaysEncryptedAkvAuthType

const (
	SQLAlwaysEncryptedAkvAuthTypeManagedIdentity  SQLAlwaysEncryptedAkvAuthType = original.SQLAlwaysEncryptedAkvAuthTypeManagedIdentity
	SQLAlwaysEncryptedAkvAuthTypeServicePrincipal SQLAlwaysEncryptedAkvAuthType = original.SQLAlwaysEncryptedAkvAuthTypeServicePrincipal
)

type SQLDWWriteBehaviorEnum = original.SQLDWWriteBehaviorEnum

const (
	SQLDWWriteBehaviorEnumInsert SQLDWWriteBehaviorEnum = original.SQLDWWriteBehaviorEnumInsert
	SQLDWWriteBehaviorEnumUpsert SQLDWWriteBehaviorEnum = original.SQLDWWriteBehaviorEnumUpsert
)

type SQLPartitionOption = original.SQLPartitionOption

const (
	SQLPartitionOptionDynamicRange              SQLPartitionOption = original.SQLPartitionOptionDynamicRange
	SQLPartitionOptionNone                      SQLPartitionOption = original.SQLPartitionOptionNone
	SQLPartitionOptionPhysicalPartitionsOfTable SQLPartitionOption = original.SQLPartitionOptionPhysicalPartitionsOfTable
)

type SQLWriteBehaviorEnum = original.SQLWriteBehaviorEnum

const (
	SQLWriteBehaviorEnumInsert          SQLWriteBehaviorEnum = original.SQLWriteBehaviorEnumInsert
	SQLWriteBehaviorEnumStoredProcedure SQLWriteBehaviorEnum = original.SQLWriteBehaviorEnumStoredProcedure
	SQLWriteBehaviorEnumUpsert          SQLWriteBehaviorEnum = original.SQLWriteBehaviorEnumUpsert
)

type SalesforceSinkWriteBehavior = original.SalesforceSinkWriteBehavior

const (
	SalesforceSinkWriteBehaviorInsert SalesforceSinkWriteBehavior = original.SalesforceSinkWriteBehaviorInsert
	SalesforceSinkWriteBehaviorUpsert SalesforceSinkWriteBehavior = original.SalesforceSinkWriteBehaviorUpsert
)

type SalesforceSourceReadBehavior = original.SalesforceSourceReadBehavior

const (
	SalesforceSourceReadBehaviorQuery    SalesforceSourceReadBehavior = original.SalesforceSourceReadBehaviorQuery
	SalesforceSourceReadBehaviorQueryAll SalesforceSourceReadBehavior = original.SalesforceSourceReadBehaviorQueryAll
)

type SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehavior

const (
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehaviorInsert
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehaviorUpdate
)

type SapHanaAuthenticationType = original.SapHanaAuthenticationType

const (
	SapHanaAuthenticationTypeBasic   SapHanaAuthenticationType = original.SapHanaAuthenticationTypeBasic
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = original.SapHanaAuthenticationTypeWindows
)

type SapHanaPartitionOption = original.SapHanaPartitionOption

const (
	SapHanaPartitionOptionNone                      SapHanaPartitionOption = original.SapHanaPartitionOptionNone
	SapHanaPartitionOptionPhysicalPartitionsOfTable SapHanaPartitionOption = original.SapHanaPartitionOptionPhysicalPartitionsOfTable
	SapHanaPartitionOptionSapHanaDynamicRange       SapHanaPartitionOption = original.SapHanaPartitionOptionSapHanaDynamicRange
)

type SapTablePartitionOption = original.SapTablePartitionOption

const (
	SapTablePartitionOptionNone                     SapTablePartitionOption = original.SapTablePartitionOptionNone
	SapTablePartitionOptionPartitionOnCalendarDate  SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarDate
	SapTablePartitionOptionPartitionOnCalendarMonth SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarMonth
	SapTablePartitionOptionPartitionOnCalendarYear  SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarYear
	SapTablePartitionOptionPartitionOnInt           SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnInt
	SapTablePartitionOptionPartitionOnTime          SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnTime
)

type SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatus

const (
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializeFailed
	SelfHostedIntegrationRuntimeNodeStatusInitializing     SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializing
	SelfHostedIntegrationRuntimeNodeStatusLimited          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusLimited
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusNeedRegistration
	SelfHostedIntegrationRuntimeNodeStatusOffline          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOffline
	SelfHostedIntegrationRuntimeNodeStatusOnline           SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOnline
	SelfHostedIntegrationRuntimeNodeStatusUpgrading        SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusUpgrading
)

type ServiceNowAuthenticationType = original.ServiceNowAuthenticationType

const (
	ServiceNowAuthenticationTypeBasic  ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeBasic
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeOAuth2
)

type ServicePrincipalCredentialType = original.ServicePrincipalCredentialType

const (
	ServicePrincipalCredentialTypeServicePrincipalCert ServicePrincipalCredentialType = original.ServicePrincipalCredentialTypeServicePrincipalCert
	ServicePrincipalCredentialTypeServicePrincipalKey  ServicePrincipalCredentialType = original.ServicePrincipalCredentialTypeServicePrincipalKey
)

type SftpAuthenticationType = original.SftpAuthenticationType

const (
	SftpAuthenticationTypeBasic        SftpAuthenticationType = original.SftpAuthenticationTypeBasic
	SftpAuthenticationTypeMultiFactor  SftpAuthenticationType = original.SftpAuthenticationTypeMultiFactor
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = original.SftpAuthenticationTypeSSHPublicKey
)

type SparkAuthenticationType = original.SparkAuthenticationType

const (
	SparkAuthenticationTypeAnonymous                    SparkAuthenticationType = original.SparkAuthenticationTypeAnonymous
	SparkAuthenticationTypeUsername                     SparkAuthenticationType = original.SparkAuthenticationTypeUsername
	SparkAuthenticationTypeUsernameAndPassword          SparkAuthenticationType = original.SparkAuthenticationTypeUsernameAndPassword
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = original.SparkAuthenticationTypeWindowsAzureHDInsightService
)

type SparkServerType = original.SparkServerType

const (
	SparkServerTypeSharkServer       SparkServerType = original.SparkServerTypeSharkServer
	SparkServerTypeSharkServer2      SparkServerType = original.SparkServerTypeSharkServer2
	SparkServerTypeSparkThriftServer SparkServerType = original.SparkServerTypeSparkThriftServer
)

type SparkThriftTransportProtocol = original.SparkThriftTransportProtocol

const (
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = original.SparkThriftTransportProtocolBinary
	SparkThriftTransportProtocolHTTP   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolHTTP
	SparkThriftTransportProtocolSASL   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolSASL
)

type SsisObjectMetadataType = original.SsisObjectMetadataType

const (
	SsisObjectMetadataTypeEnvironment SsisObjectMetadataType = original.SsisObjectMetadataTypeEnvironment
	SsisObjectMetadataTypeFolder      SsisObjectMetadataType = original.SsisObjectMetadataTypeFolder
	SsisObjectMetadataTypePackage     SsisObjectMetadataType = original.SsisObjectMetadataTypePackage
	SsisObjectMetadataTypeProject     SsisObjectMetadataType = original.SsisObjectMetadataTypeProject
)

type SsisPackageLocationType = original.SsisPackageLocationType

const (
	SsisPackageLocationTypeFile          SsisPackageLocationType = original.SsisPackageLocationTypeFile
	SsisPackageLocationTypeInlinePackage SsisPackageLocationType = original.SsisPackageLocationTypeInlinePackage
	SsisPackageLocationTypePackageStore  SsisPackageLocationType = original.SsisPackageLocationTypePackageStore
	SsisPackageLocationTypeSSISDB        SsisPackageLocationType = original.SsisPackageLocationTypeSSISDB
)

type StoredProcedureParameterType = original.StoredProcedureParameterType

const (
	StoredProcedureParameterTypeBoolean StoredProcedureParameterType = original.StoredProcedureParameterTypeBoolean
	StoredProcedureParameterTypeDate    StoredProcedureParameterType = original.StoredProcedureParameterTypeDate
	StoredProcedureParameterTypeDecimal StoredProcedureParameterType = original.StoredProcedureParameterTypeDecimal
	StoredProcedureParameterTypeGUID    StoredProcedureParameterType = original.StoredProcedureParameterTypeGUID
	StoredProcedureParameterTypeInt     StoredProcedureParameterType = original.StoredProcedureParameterTypeInt
	StoredProcedureParameterTypeInt64   StoredProcedureParameterType = original.StoredProcedureParameterTypeInt64
	StoredProcedureParameterTypeString  StoredProcedureParameterType = original.StoredProcedureParameterTypeString
)

type SybaseAuthenticationType = original.SybaseAuthenticationType

const (
	SybaseAuthenticationTypeBasic   SybaseAuthenticationType = original.SybaseAuthenticationTypeBasic
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = original.SybaseAuthenticationTypeWindows
)

type TeradataAuthenticationType = original.TeradataAuthenticationType

const (
	TeradataAuthenticationTypeBasic   TeradataAuthenticationType = original.TeradataAuthenticationTypeBasic
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = original.TeradataAuthenticationTypeWindows
)

type TeradataPartitionOption = original.TeradataPartitionOption

const (
	TeradataPartitionOptionDynamicRange TeradataPartitionOption = original.TeradataPartitionOptionDynamicRange
	TeradataPartitionOptionHash         TeradataPartitionOption = original.TeradataPartitionOptionHash
	TeradataPartitionOptionNone         TeradataPartitionOption = original.TeradataPartitionOptionNone
)

type TriggerRunStatus = original.TriggerRunStatus

const (
	TriggerRunStatusFailed     TriggerRunStatus = original.TriggerRunStatusFailed
	TriggerRunStatusInprogress TriggerRunStatus = original.TriggerRunStatusInprogress
	TriggerRunStatusSucceeded  TriggerRunStatus = original.TriggerRunStatusSucceeded
)

type TriggerRuntimeState = original.TriggerRuntimeState

const (
	TriggerRuntimeStateDisabled TriggerRuntimeState = original.TriggerRuntimeStateDisabled
	TriggerRuntimeStateStarted  TriggerRuntimeState = original.TriggerRuntimeStateStarted
	TriggerRuntimeStateStopped  TriggerRuntimeState = original.TriggerRuntimeStateStopped
)

type TumblingWindowFrequency = original.TumblingWindowFrequency

const (
	TumblingWindowFrequencyHour   TumblingWindowFrequency = original.TumblingWindowFrequencyHour
	TumblingWindowFrequencyMinute TumblingWindowFrequency = original.TumblingWindowFrequencyMinute
	TumblingWindowFrequencyMonth  TumblingWindowFrequency = original.TumblingWindowFrequencyMonth
)

type Type = original.Type

const (
	TypeAzureKeyVaultSecret Type = original.TypeAzureKeyVaultSecret
	TypeSecretBase          Type = original.TypeSecretBase
	TypeSecureString        Type = original.TypeSecureString
)

type TypeBasicActivity = original.TypeBasicActivity

const (
	TypeBasicActivityTypeActivity                 TypeBasicActivity = original.TypeBasicActivityTypeActivity
	TypeBasicActivityTypeAppendVariable           TypeBasicActivity = original.TypeBasicActivityTypeAppendVariable
	TypeBasicActivityTypeAzureDataExplorerCommand TypeBasicActivity = original.TypeBasicActivityTypeAzureDataExplorerCommand
	TypeBasicActivityTypeAzureFunctionActivity    TypeBasicActivity = original.TypeBasicActivityTypeAzureFunctionActivity
	TypeBasicActivityTypeAzureMLBatchExecution    TypeBasicActivity = original.TypeBasicActivityTypeAzureMLBatchExecution
	TypeBasicActivityTypeAzureMLExecutePipeline   TypeBasicActivity = original.TypeBasicActivityTypeAzureMLExecutePipeline
	TypeBasicActivityTypeAzureMLUpdateResource    TypeBasicActivity = original.TypeBasicActivityTypeAzureMLUpdateResource
	TypeBasicActivityTypeContainer                TypeBasicActivity = original.TypeBasicActivityTypeContainer
	TypeBasicActivityTypeCopy                     TypeBasicActivity = original.TypeBasicActivityTypeCopy
	TypeBasicActivityTypeCustom                   TypeBasicActivity = original.TypeBasicActivityTypeCustom
	TypeBasicActivityTypeDatabricksNotebook       TypeBasicActivity = original.TypeBasicActivityTypeDatabricksNotebook
	TypeBasicActivityTypeDatabricksSparkJar       TypeBasicActivity = original.TypeBasicActivityTypeDatabricksSparkJar
	TypeBasicActivityTypeDatabricksSparkPython    TypeBasicActivity = original.TypeBasicActivityTypeDatabricksSparkPython
	TypeBasicActivityTypeDataLakeAnalyticsUSQL    TypeBasicActivity = original.TypeBasicActivityTypeDataLakeAnalyticsUSQL
	TypeBasicActivityTypeDelete                   TypeBasicActivity = original.TypeBasicActivityTypeDelete
	TypeBasicActivityTypeExecuteDataFlow          TypeBasicActivity = original.TypeBasicActivityTypeExecuteDataFlow
	TypeBasicActivityTypeExecutePipeline          TypeBasicActivity = original.TypeBasicActivityTypeExecutePipeline
	TypeBasicActivityTypeExecuteSSISPackage       TypeBasicActivity = original.TypeBasicActivityTypeExecuteSSISPackage
	TypeBasicActivityTypeExecuteWranglingDataflow TypeBasicActivity = original.TypeBasicActivityTypeExecuteWranglingDataflow
	TypeBasicActivityTypeExecution                TypeBasicActivity = original.TypeBasicActivityTypeExecution
	TypeBasicActivityTypeFilter                   TypeBasicActivity = original.TypeBasicActivityTypeFilter
	TypeBasicActivityTypeForEach                  TypeBasicActivity = original.TypeBasicActivityTypeForEach
	TypeBasicActivityTypeGetMetadata              TypeBasicActivity = original.TypeBasicActivityTypeGetMetadata
	TypeBasicActivityTypeHDInsightHive            TypeBasicActivity = original.TypeBasicActivityTypeHDInsightHive
	TypeBasicActivityTypeHDInsightMapReduce       TypeBasicActivity = original.TypeBasicActivityTypeHDInsightMapReduce
	TypeBasicActivityTypeHDInsightPig             TypeBasicActivity = original.TypeBasicActivityTypeHDInsightPig
	TypeBasicActivityTypeHDInsightSpark           TypeBasicActivity = original.TypeBasicActivityTypeHDInsightSpark
	TypeBasicActivityTypeHDInsightStreaming       TypeBasicActivity = original.TypeBasicActivityTypeHDInsightStreaming
	TypeBasicActivityTypeIfCondition              TypeBasicActivity = original.TypeBasicActivityTypeIfCondition
	TypeBasicActivityTypeLookup                   TypeBasicActivity = original.TypeBasicActivityTypeLookup
	TypeBasicActivityTypeSetVariable              TypeBasicActivity = original.TypeBasicActivityTypeSetVariable
	TypeBasicActivityTypeSQLServerStoredProcedure TypeBasicActivity = original.TypeBasicActivityTypeSQLServerStoredProcedure
	TypeBasicActivityTypeSwitch                   TypeBasicActivity = original.TypeBasicActivityTypeSwitch
	TypeBasicActivityTypeUntil                    TypeBasicActivity = original.TypeBasicActivityTypeUntil
	TypeBasicActivityTypeValidation               TypeBasicActivity = original.TypeBasicActivityTypeValidation
	TypeBasicActivityTypeWait                     TypeBasicActivity = original.TypeBasicActivityTypeWait
	TypeBasicActivityTypeWebActivity              TypeBasicActivity = original.TypeBasicActivityTypeWebActivity
	TypeBasicActivityTypeWebHook                  TypeBasicActivity = original.TypeBasicActivityTypeWebHook
)

type TypeBasicCompressionReadSettings = original.TypeBasicCompressionReadSettings

const (
	TypeBasicCompressionReadSettingsTypeCompressionReadSettings TypeBasicCompressionReadSettings = original.TypeBasicCompressionReadSettingsTypeCompressionReadSettings
	TypeBasicCompressionReadSettingsTypeTarGZipReadSettings     TypeBasicCompressionReadSettings = original.TypeBasicCompressionReadSettingsTypeTarGZipReadSettings
	TypeBasicCompressionReadSettingsTypeTarReadSettings         TypeBasicCompressionReadSettings = original.TypeBasicCompressionReadSettingsTypeTarReadSettings
	TypeBasicCompressionReadSettingsTypeZipDeflateReadSettings  TypeBasicCompressionReadSettings = original.TypeBasicCompressionReadSettingsTypeZipDeflateReadSettings
)

type TypeBasicCopySink = original.TypeBasicCopySink

const (
	TypeBasicCopySinkTypeAvroSink                     TypeBasicCopySink = original.TypeBasicCopySinkTypeAvroSink
	TypeBasicCopySinkTypeAzureBlobFSSink              TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureBlobFSSink
	TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureDatabricksDeltaLakeSink
	TypeBasicCopySinkTypeAzureDataExplorerSink        TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureDataExplorerSink
	TypeBasicCopySinkTypeAzureDataLakeStoreSink       TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureDataLakeStoreSink
	TypeBasicCopySinkTypeAzureMySQLSink               TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureMySQLSink
	TypeBasicCopySinkTypeAzurePostgreSQLSink          TypeBasicCopySink = original.TypeBasicCopySinkTypeAzurePostgreSQLSink
	TypeBasicCopySinkTypeAzureQueueSink               TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureQueueSink
	TypeBasicCopySinkTypeAzureSearchIndexSink         TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureSearchIndexSink
	TypeBasicCopySinkTypeAzureSQLSink                 TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureSQLSink
	TypeBasicCopySinkTypeAzureTableSink               TypeBasicCopySink = original.TypeBasicCopySinkTypeAzureTableSink
	TypeBasicCopySinkTypeBinarySink                   TypeBasicCopySink = original.TypeBasicCopySinkTypeBinarySink
	TypeBasicCopySinkTypeBlobSink                     TypeBasicCopySink = original.TypeBasicCopySinkTypeBlobSink
	TypeBasicCopySinkTypeCommonDataServiceForAppsSink TypeBasicCopySink = original.TypeBasicCopySinkTypeCommonDataServiceForAppsSink
	TypeBasicCopySinkTypeCopySink                     TypeBasicCopySink = original.TypeBasicCopySinkTypeCopySink
	TypeBasicCopySinkTypeCosmosDbMongoDbAPISink       TypeBasicCopySink = original.TypeBasicCopySinkTypeCosmosDbMongoDbAPISink
	TypeBasicCopySinkTypeCosmosDbSQLAPISink           TypeBasicCopySink = original.TypeBasicCopySinkTypeCosmosDbSQLAPISink
	TypeBasicCopySinkTypeDelimitedTextSink            TypeBasicCopySink = original.TypeBasicCopySinkTypeDelimitedTextSink
	TypeBasicCopySinkTypeDocumentDbCollectionSink     TypeBasicCopySink = original.TypeBasicCopySinkTypeDocumentDbCollectionSink
	TypeBasicCopySinkTypeDynamicsCrmSink              TypeBasicCopySink = original.TypeBasicCopySinkTypeDynamicsCrmSink
	TypeBasicCopySinkTypeDynamicsSink                 TypeBasicCopySink = original.TypeBasicCopySinkTypeDynamicsSink
	TypeBasicCopySinkTypeFileSystemSink               TypeBasicCopySink = original.TypeBasicCopySinkTypeFileSystemSink
	TypeBasicCopySinkTypeInformixSink                 TypeBasicCopySink = original.TypeBasicCopySinkTypeInformixSink
	TypeBasicCopySinkTypeJSONSink                     TypeBasicCopySink = original.TypeBasicCopySinkTypeJSONSink
	TypeBasicCopySinkTypeMicrosoftAccessSink          TypeBasicCopySink = original.TypeBasicCopySinkTypeMicrosoftAccessSink
	TypeBasicCopySinkTypeMongoDbAtlasSink             TypeBasicCopySink = original.TypeBasicCopySinkTypeMongoDbAtlasSink
	TypeBasicCopySinkTypeMongoDbV2Sink                TypeBasicCopySink = original.TypeBasicCopySinkTypeMongoDbV2Sink
	TypeBasicCopySinkTypeOdbcSink                     TypeBasicCopySink = original.TypeBasicCopySinkTypeOdbcSink
	TypeBasicCopySinkTypeOracleSink                   TypeBasicCopySink = original.TypeBasicCopySinkTypeOracleSink
	TypeBasicCopySinkTypeOrcSink                      TypeBasicCopySink = original.TypeBasicCopySinkTypeOrcSink
	TypeBasicCopySinkTypeParquetSink                  TypeBasicCopySink = original.TypeBasicCopySinkTypeParquetSink
	TypeBasicCopySinkTypeRestSink                     TypeBasicCopySink = original.TypeBasicCopySinkTypeRestSink
	TypeBasicCopySinkTypeSalesforceServiceCloudSink   TypeBasicCopySink = original.TypeBasicCopySinkTypeSalesforceServiceCloudSink
	TypeBasicCopySinkTypeSalesforceSink               TypeBasicCopySink = original.TypeBasicCopySinkTypeSalesforceSink
	TypeBasicCopySinkTypeSapCloudForCustomerSink      TypeBasicCopySink = original.TypeBasicCopySinkTypeSapCloudForCustomerSink
	TypeBasicCopySinkTypeSnowflakeSink                TypeBasicCopySink = original.TypeBasicCopySinkTypeSnowflakeSink
	TypeBasicCopySinkTypeSQLDWSink                    TypeBasicCopySink = original.TypeBasicCopySinkTypeSQLDWSink
	TypeBasicCopySinkTypeSQLMISink                    TypeBasicCopySink = original.TypeBasicCopySinkTypeSQLMISink
	TypeBasicCopySinkTypeSQLServerSink                TypeBasicCopySink = original.TypeBasicCopySinkTypeSQLServerSink
	TypeBasicCopySinkTypeSQLSink                      TypeBasicCopySink = original.TypeBasicCopySinkTypeSQLSink
)

type TypeBasicCopySource = original.TypeBasicCopySource

const (
	TypeBasicCopySourceTypeAmazonMWSSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeAmazonMWSSource
	TypeBasicCopySourceTypeAmazonRdsForOracleSource       TypeBasicCopySource = original.TypeBasicCopySourceTypeAmazonRdsForOracleSource
	TypeBasicCopySourceTypeAmazonRedshiftSource           TypeBasicCopySource = original.TypeBasicCopySourceTypeAmazonRedshiftSource
	TypeBasicCopySourceTypeAvroSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeAvroSource
	TypeBasicCopySourceTypeAzureBlobFSSource              TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureBlobFSSource
	TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureDatabricksDeltaLakeSource
	TypeBasicCopySourceTypeAzureDataExplorerSource        TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureDataExplorerSource
	TypeBasicCopySourceTypeAzureDataLakeStoreSource       TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureDataLakeStoreSource
	TypeBasicCopySourceTypeAzureMariaDBSource             TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureMariaDBSource
	TypeBasicCopySourceTypeAzureMySQLSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureMySQLSource
	TypeBasicCopySourceTypeAzurePostgreSQLSource          TypeBasicCopySource = original.TypeBasicCopySourceTypeAzurePostgreSQLSource
	TypeBasicCopySourceTypeAzureSQLSource                 TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureSQLSource
	TypeBasicCopySourceTypeAzureTableSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeAzureTableSource
	TypeBasicCopySourceTypeBinarySource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeBinarySource
	TypeBasicCopySourceTypeBlobSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeBlobSource
	TypeBasicCopySourceTypeCassandraSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeCassandraSource
	TypeBasicCopySourceTypeCommonDataServiceForAppsSource TypeBasicCopySource = original.TypeBasicCopySourceTypeCommonDataServiceForAppsSource
	TypeBasicCopySourceTypeConcurSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeConcurSource
	TypeBasicCopySourceTypeCopySource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeCopySource
	TypeBasicCopySourceTypeCosmosDbMongoDbAPISource       TypeBasicCopySource = original.TypeBasicCopySourceTypeCosmosDbMongoDbAPISource
	TypeBasicCopySourceTypeCosmosDbSQLAPISource           TypeBasicCopySource = original.TypeBasicCopySourceTypeCosmosDbSQLAPISource
	TypeBasicCopySourceTypeCouchbaseSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeCouchbaseSource
	TypeBasicCopySourceTypeDb2Source                      TypeBasicCopySource = original.TypeBasicCopySourceTypeDb2Source
	TypeBasicCopySourceTypeDelimitedTextSource            TypeBasicCopySource = original.TypeBasicCopySourceTypeDelimitedTextSource
	TypeBasicCopySourceTypeDocumentDbCollectionSource     TypeBasicCopySource = original.TypeBasicCopySourceTypeDocumentDbCollectionSource
	TypeBasicCopySourceTypeDrillSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeDrillSource
	TypeBasicCopySourceTypeDynamicsAXSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeDynamicsAXSource
	TypeBasicCopySourceTypeDynamicsCrmSource              TypeBasicCopySource = original.TypeBasicCopySourceTypeDynamicsCrmSource
	TypeBasicCopySourceTypeDynamicsSource                 TypeBasicCopySource = original.TypeBasicCopySourceTypeDynamicsSource
	TypeBasicCopySourceTypeEloquaSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeEloquaSource
	TypeBasicCopySourceTypeExcelSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeExcelSource
	TypeBasicCopySourceTypeFileSystemSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeFileSystemSource
	TypeBasicCopySourceTypeGoogleAdWordsSource            TypeBasicCopySource = original.TypeBasicCopySourceTypeGoogleAdWordsSource
	TypeBasicCopySourceTypeGoogleBigQuerySource           TypeBasicCopySource = original.TypeBasicCopySourceTypeGoogleBigQuerySource
	TypeBasicCopySourceTypeGreenplumSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeGreenplumSource
	TypeBasicCopySourceTypeHBaseSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeHBaseSource
	TypeBasicCopySourceTypeHdfsSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeHdfsSource
	TypeBasicCopySourceTypeHiveSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeHiveSource
	TypeBasicCopySourceTypeHTTPSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeHTTPSource
	TypeBasicCopySourceTypeHubspotSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeHubspotSource
	TypeBasicCopySourceTypeImpalaSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeImpalaSource
	TypeBasicCopySourceTypeInformixSource                 TypeBasicCopySource = original.TypeBasicCopySourceTypeInformixSource
	TypeBasicCopySourceTypeJiraSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeJiraSource
	TypeBasicCopySourceTypeJSONSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeJSONSource
	TypeBasicCopySourceTypeMagentoSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeMagentoSource
	TypeBasicCopySourceTypeMariaDBSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeMariaDBSource
	TypeBasicCopySourceTypeMarketoSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeMarketoSource
	TypeBasicCopySourceTypeMicrosoftAccessSource          TypeBasicCopySource = original.TypeBasicCopySourceTypeMicrosoftAccessSource
	TypeBasicCopySourceTypeMongoDbAtlasSource             TypeBasicCopySource = original.TypeBasicCopySourceTypeMongoDbAtlasSource
	TypeBasicCopySourceTypeMongoDbSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeMongoDbSource
	TypeBasicCopySourceTypeMongoDbV2Source                TypeBasicCopySource = original.TypeBasicCopySourceTypeMongoDbV2Source
	TypeBasicCopySourceTypeMySQLSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeMySQLSource
	TypeBasicCopySourceTypeNetezzaSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeNetezzaSource
	TypeBasicCopySourceTypeODataSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeODataSource
	TypeBasicCopySourceTypeOdbcSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeOdbcSource
	TypeBasicCopySourceTypeOffice365Source                TypeBasicCopySource = original.TypeBasicCopySourceTypeOffice365Source
	TypeBasicCopySourceTypeOracleServiceCloudSource       TypeBasicCopySource = original.TypeBasicCopySourceTypeOracleServiceCloudSource
	TypeBasicCopySourceTypeOracleSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeOracleSource
	TypeBasicCopySourceTypeOrcSource                      TypeBasicCopySource = original.TypeBasicCopySourceTypeOrcSource
	TypeBasicCopySourceTypeParquetSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeParquetSource
	TypeBasicCopySourceTypePaypalSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypePaypalSource
	TypeBasicCopySourceTypePhoenixSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypePhoenixSource
	TypeBasicCopySourceTypePostgreSQLSource               TypeBasicCopySource = original.TypeBasicCopySourceTypePostgreSQLSource
	TypeBasicCopySourceTypePrestoSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypePrestoSource
	TypeBasicCopySourceTypeQuickBooksSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeQuickBooksSource
	TypeBasicCopySourceTypeRelationalSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeRelationalSource
	TypeBasicCopySourceTypeResponsysSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeResponsysSource
	TypeBasicCopySourceTypeRestSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeRestSource
	TypeBasicCopySourceTypeSalesforceMarketingCloudSource TypeBasicCopySource = original.TypeBasicCopySourceTypeSalesforceMarketingCloudSource
	TypeBasicCopySourceTypeSalesforceServiceCloudSource   TypeBasicCopySource = original.TypeBasicCopySourceTypeSalesforceServiceCloudSource
	TypeBasicCopySourceTypeSalesforceSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeSalesforceSource
	TypeBasicCopySourceTypeSapBwSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeSapBwSource
	TypeBasicCopySourceTypeSapCloudForCustomerSource      TypeBasicCopySource = original.TypeBasicCopySourceTypeSapCloudForCustomerSource
	TypeBasicCopySourceTypeSapEccSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeSapEccSource
	TypeBasicCopySourceTypeSapHanaSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeSapHanaSource
	TypeBasicCopySourceTypeSapOpenHubSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeSapOpenHubSource
	TypeBasicCopySourceTypeSapTableSource                 TypeBasicCopySource = original.TypeBasicCopySourceTypeSapTableSource
	TypeBasicCopySourceTypeServiceNowSource               TypeBasicCopySource = original.TypeBasicCopySourceTypeServiceNowSource
	TypeBasicCopySourceTypeSharePointOnlineListSource     TypeBasicCopySource = original.TypeBasicCopySourceTypeSharePointOnlineListSource
	TypeBasicCopySourceTypeShopifySource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeShopifySource
	TypeBasicCopySourceTypeSnowflakeSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeSnowflakeSource
	TypeBasicCopySourceTypeSparkSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeSparkSource
	TypeBasicCopySourceTypeSQLDWSource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeSQLDWSource
	TypeBasicCopySourceTypeSQLMISource                    TypeBasicCopySource = original.TypeBasicCopySourceTypeSQLMISource
	TypeBasicCopySourceTypeSQLServerSource                TypeBasicCopySource = original.TypeBasicCopySourceTypeSQLServerSource
	TypeBasicCopySourceTypeSQLSource                      TypeBasicCopySource = original.TypeBasicCopySourceTypeSQLSource
	TypeBasicCopySourceTypeSquareSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeSquareSource
	TypeBasicCopySourceTypeSybaseSource                   TypeBasicCopySource = original.TypeBasicCopySourceTypeSybaseSource
	TypeBasicCopySourceTypeTabularSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeTabularSource
	TypeBasicCopySourceTypeTeradataSource                 TypeBasicCopySource = original.TypeBasicCopySourceTypeTeradataSource
	TypeBasicCopySourceTypeVerticaSource                  TypeBasicCopySource = original.TypeBasicCopySourceTypeVerticaSource
	TypeBasicCopySourceTypeWebSource                      TypeBasicCopySource = original.TypeBasicCopySourceTypeWebSource
	TypeBasicCopySourceTypeXeroSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeXeroSource
	TypeBasicCopySourceTypeXMLSource                      TypeBasicCopySource = original.TypeBasicCopySourceTypeXMLSource
	TypeBasicCopySourceTypeZohoSource                     TypeBasicCopySource = original.TypeBasicCopySourceTypeZohoSource
)

type TypeBasicCopyTranslator = original.TypeBasicCopyTranslator

const (
	TypeBasicCopyTranslatorTypeCopyTranslator    TypeBasicCopyTranslator = original.TypeBasicCopyTranslatorTypeCopyTranslator
	TypeBasicCopyTranslatorTypeTabularTranslator TypeBasicCopyTranslator = original.TypeBasicCopyTranslatorTypeTabularTranslator
)

type TypeBasicCredential = original.TypeBasicCredential

const (
	TypeBasicCredentialTypeCredential       TypeBasicCredential = original.TypeBasicCredentialTypeCredential
	TypeBasicCredentialTypeManagedIdentity  TypeBasicCredential = original.TypeBasicCredentialTypeManagedIdentity
	TypeBasicCredentialTypeServicePrincipal TypeBasicCredential = original.TypeBasicCredentialTypeServicePrincipal
)

type TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBase

const (
	TypeBasicCustomSetupBaseTypeAzPowerShellSetup        TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBaseTypeAzPowerShellSetup
	TypeBasicCustomSetupBaseTypeCmdkeySetup              TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBaseTypeCmdkeySetup
	TypeBasicCustomSetupBaseTypeComponentSetup           TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBaseTypeComponentSetup
	TypeBasicCustomSetupBaseTypeCustomSetupBase          TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBaseTypeCustomSetupBase
	TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup
)

type TypeBasicDataFlow = original.TypeBasicDataFlow

const (
	TypeBasicDataFlowTypeDataFlow          TypeBasicDataFlow = original.TypeBasicDataFlowTypeDataFlow
	TypeBasicDataFlowTypeMappingDataFlow   TypeBasicDataFlow = original.TypeBasicDataFlowTypeMappingDataFlow
	TypeBasicDataFlowTypeWranglingDataFlow TypeBasicDataFlow = original.TypeBasicDataFlowTypeWranglingDataFlow
)

type TypeBasicDataset = original.TypeBasicDataset

const (
	TypeBasicDatasetTypeAmazonMWSObject                 TypeBasicDataset = original.TypeBasicDatasetTypeAmazonMWSObject
	TypeBasicDatasetTypeAmazonRdsForOracleTable         TypeBasicDataset = original.TypeBasicDatasetTypeAmazonRdsForOracleTable
	TypeBasicDatasetTypeAmazonRedshiftTable             TypeBasicDataset = original.TypeBasicDatasetTypeAmazonRedshiftTable
	TypeBasicDatasetTypeAmazonS3Object                  TypeBasicDataset = original.TypeBasicDatasetTypeAmazonS3Object
	TypeBasicDatasetTypeAvro                            TypeBasicDataset = original.TypeBasicDatasetTypeAvro
	TypeBasicDatasetTypeAzureBlob                       TypeBasicDataset = original.TypeBasicDatasetTypeAzureBlob
	TypeBasicDatasetTypeAzureBlobFSFile                 TypeBasicDataset = original.TypeBasicDatasetTypeAzureBlobFSFile
	TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset TypeBasicDataset = original.TypeBasicDatasetTypeAzureDatabricksDeltaLakeDataset
	TypeBasicDatasetTypeAzureDataExplorerTable          TypeBasicDataset = original.TypeBasicDatasetTypeAzureDataExplorerTable
	TypeBasicDatasetTypeAzureDataLakeStoreFile          TypeBasicDataset = original.TypeBasicDatasetTypeAzureDataLakeStoreFile
	TypeBasicDatasetTypeAzureMariaDBTable               TypeBasicDataset = original.TypeBasicDatasetTypeAzureMariaDBTable
	TypeBasicDatasetTypeAzureMySQLTable                 TypeBasicDataset = original.TypeBasicDatasetTypeAzureMySQLTable
	TypeBasicDatasetTypeAzurePostgreSQLTable            TypeBasicDataset = original.TypeBasicDatasetTypeAzurePostgreSQLTable
	TypeBasicDatasetTypeAzureSearchIndex                TypeBasicDataset = original.TypeBasicDatasetTypeAzureSearchIndex
	TypeBasicDatasetTypeAzureSQLDWTable                 TypeBasicDataset = original.TypeBasicDatasetTypeAzureSQLDWTable
	TypeBasicDatasetTypeAzureSQLMITable                 TypeBasicDataset = original.TypeBasicDatasetTypeAzureSQLMITable
	TypeBasicDatasetTypeAzureSQLTable                   TypeBasicDataset = original.TypeBasicDatasetTypeAzureSQLTable
	TypeBasicDatasetTypeAzureTable                      TypeBasicDataset = original.TypeBasicDatasetTypeAzureTable
	TypeBasicDatasetTypeBinary                          TypeBasicDataset = original.TypeBasicDatasetTypeBinary
	TypeBasicDatasetTypeCassandraTable                  TypeBasicDataset = original.TypeBasicDatasetTypeCassandraTable
	TypeBasicDatasetTypeCommonDataServiceForAppsEntity  TypeBasicDataset = original.TypeBasicDatasetTypeCommonDataServiceForAppsEntity
	TypeBasicDatasetTypeConcurObject                    TypeBasicDataset = original.TypeBasicDatasetTypeConcurObject
	TypeBasicDatasetTypeCosmosDbMongoDbAPICollection    TypeBasicDataset = original.TypeBasicDatasetTypeCosmosDbMongoDbAPICollection
	TypeBasicDatasetTypeCosmosDbSQLAPICollection        TypeBasicDataset = original.TypeBasicDatasetTypeCosmosDbSQLAPICollection
	TypeBasicDatasetTypeCouchbaseTable                  TypeBasicDataset = original.TypeBasicDatasetTypeCouchbaseTable
	TypeBasicDatasetTypeCustomDataset                   TypeBasicDataset = original.TypeBasicDatasetTypeCustomDataset
	TypeBasicDatasetTypeDataset                         TypeBasicDataset = original.TypeBasicDatasetTypeDataset
	TypeBasicDatasetTypeDb2Table                        TypeBasicDataset = original.TypeBasicDatasetTypeDb2Table
	TypeBasicDatasetTypeDelimitedText                   TypeBasicDataset = original.TypeBasicDatasetTypeDelimitedText
	TypeBasicDatasetTypeDocumentDbCollection            TypeBasicDataset = original.TypeBasicDatasetTypeDocumentDbCollection
	TypeBasicDatasetTypeDrillTable                      TypeBasicDataset = original.TypeBasicDatasetTypeDrillTable
	TypeBasicDatasetTypeDynamicsAXResource              TypeBasicDataset = original.TypeBasicDatasetTypeDynamicsAXResource
	TypeBasicDatasetTypeDynamicsCrmEntity               TypeBasicDataset = original.TypeBasicDatasetTypeDynamicsCrmEntity
	TypeBasicDatasetTypeDynamicsEntity                  TypeBasicDataset = original.TypeBasicDatasetTypeDynamicsEntity
	TypeBasicDatasetTypeEloquaObject                    TypeBasicDataset = original.TypeBasicDatasetTypeEloquaObject
	TypeBasicDatasetTypeExcel                           TypeBasicDataset = original.TypeBasicDatasetTypeExcel
	TypeBasicDatasetTypeFileShare                       TypeBasicDataset = original.TypeBasicDatasetTypeFileShare
	TypeBasicDatasetTypeGoogleAdWordsObject             TypeBasicDataset = original.TypeBasicDatasetTypeGoogleAdWordsObject
	TypeBasicDatasetTypeGoogleBigQueryObject            TypeBasicDataset = original.TypeBasicDatasetTypeGoogleBigQueryObject
	TypeBasicDatasetTypeGreenplumTable                  TypeBasicDataset = original.TypeBasicDatasetTypeGreenplumTable
	TypeBasicDatasetTypeHBaseObject                     TypeBasicDataset = original.TypeBasicDatasetTypeHBaseObject
	TypeBasicDatasetTypeHiveObject                      TypeBasicDataset = original.TypeBasicDatasetTypeHiveObject
	TypeBasicDatasetTypeHTTPFile                        TypeBasicDataset = original.TypeBasicDatasetTypeHTTPFile
	TypeBasicDatasetTypeHubspotObject                   TypeBasicDataset = original.TypeBasicDatasetTypeHubspotObject
	TypeBasicDatasetTypeImpalaObject                    TypeBasicDataset = original.TypeBasicDatasetTypeImpalaObject
	TypeBasicDatasetTypeInformixTable                   TypeBasicDataset = original.TypeBasicDatasetTypeInformixTable
	TypeBasicDatasetTypeJiraObject                      TypeBasicDataset = original.TypeBasicDatasetTypeJiraObject
	TypeBasicDatasetTypeJSON                            TypeBasicDataset = original.TypeBasicDatasetTypeJSON
	TypeBasicDatasetTypeMagentoObject                   TypeBasicDataset = original.TypeBasicDatasetTypeMagentoObject
	TypeBasicDatasetTypeMariaDBTable                    TypeBasicDataset = original.TypeBasicDatasetTypeMariaDBTable
	TypeBasicDatasetTypeMarketoObject                   TypeBasicDataset = original.TypeBasicDatasetTypeMarketoObject
	TypeBasicDatasetTypeMicrosoftAccessTable            TypeBasicDataset = original.TypeBasicDatasetTypeMicrosoftAccessTable
	TypeBasicDatasetTypeMongoDbAtlasCollection          TypeBasicDataset = original.TypeBasicDatasetTypeMongoDbAtlasCollection
	TypeBasicDatasetTypeMongoDbCollection               TypeBasicDataset = original.TypeBasicDatasetTypeMongoDbCollection
	TypeBasicDatasetTypeMongoDbV2Collection             TypeBasicDataset = original.TypeBasicDatasetTypeMongoDbV2Collection
	TypeBasicDatasetTypeMySQLTable                      TypeBasicDataset = original.TypeBasicDatasetTypeMySQLTable
	TypeBasicDatasetTypeNetezzaTable                    TypeBasicDataset = original.TypeBasicDatasetTypeNetezzaTable
	TypeBasicDatasetTypeODataResource                   TypeBasicDataset = original.TypeBasicDatasetTypeODataResource
	TypeBasicDatasetTypeOdbcTable                       TypeBasicDataset = original.TypeBasicDatasetTypeOdbcTable
	TypeBasicDatasetTypeOffice365Table                  TypeBasicDataset = original.TypeBasicDatasetTypeOffice365Table
	TypeBasicDatasetTypeOracleServiceCloudObject        TypeBasicDataset = original.TypeBasicDatasetTypeOracleServiceCloudObject
	TypeBasicDatasetTypeOracleTable                     TypeBasicDataset = original.TypeBasicDatasetTypeOracleTable
	TypeBasicDatasetTypeOrc                             TypeBasicDataset = original.TypeBasicDatasetTypeOrc
	TypeBasicDatasetTypeParquet                         TypeBasicDataset = original.TypeBasicDatasetTypeParquet
	TypeBasicDatasetTypePaypalObject                    TypeBasicDataset = original.TypeBasicDatasetTypePaypalObject
	TypeBasicDatasetTypePhoenixObject                   TypeBasicDataset = original.TypeBasicDatasetTypePhoenixObject
	TypeBasicDatasetTypePostgreSQLTable                 TypeBasicDataset = original.TypeBasicDatasetTypePostgreSQLTable
	TypeBasicDatasetTypePrestoObject                    TypeBasicDataset = original.TypeBasicDatasetTypePrestoObject
	TypeBasicDatasetTypeQuickBooksObject                TypeBasicDataset = original.TypeBasicDatasetTypeQuickBooksObject
	TypeBasicDatasetTypeRelationalTable                 TypeBasicDataset = original.TypeBasicDatasetTypeRelationalTable
	TypeBasicDatasetTypeResponsysObject                 TypeBasicDataset = original.TypeBasicDatasetTypeResponsysObject
	TypeBasicDatasetTypeRestResource                    TypeBasicDataset = original.TypeBasicDatasetTypeRestResource
	TypeBasicDatasetTypeSalesforceMarketingCloudObject  TypeBasicDataset = original.TypeBasicDatasetTypeSalesforceMarketingCloudObject
	TypeBasicDatasetTypeSalesforceObject                TypeBasicDataset = original.TypeBasicDatasetTypeSalesforceObject
	TypeBasicDatasetTypeSalesforceServiceCloudObject    TypeBasicDataset = original.TypeBasicDatasetTypeSalesforceServiceCloudObject
	TypeBasicDatasetTypeSapBwCube                       TypeBasicDataset = original.TypeBasicDatasetTypeSapBwCube
	TypeBasicDatasetTypeSapCloudForCustomerResource     TypeBasicDataset = original.TypeBasicDatasetTypeSapCloudForCustomerResource
	TypeBasicDatasetTypeSapEccResource                  TypeBasicDataset = original.TypeBasicDatasetTypeSapEccResource
	TypeBasicDatasetTypeSapHanaTable                    TypeBasicDataset = original.TypeBasicDatasetTypeSapHanaTable
	TypeBasicDatasetTypeSapOpenHubTable                 TypeBasicDataset = original.TypeBasicDatasetTypeSapOpenHubTable
	TypeBasicDatasetTypeSapTableResource                TypeBasicDataset = original.TypeBasicDatasetTypeSapTableResource
	TypeBasicDatasetTypeServiceNowObject                TypeBasicDataset = original.TypeBasicDatasetTypeServiceNowObject
	TypeBasicDatasetTypeSharePointOnlineListResource    TypeBasicDataset = original.TypeBasicDatasetTypeSharePointOnlineListResource
	TypeBasicDatasetTypeShopifyObject                   TypeBasicDataset = original.TypeBasicDatasetTypeShopifyObject
	TypeBasicDatasetTypeSnowflakeTable                  TypeBasicDataset = original.TypeBasicDatasetTypeSnowflakeTable
	TypeBasicDatasetTypeSparkObject                     TypeBasicDataset = original.TypeBasicDatasetTypeSparkObject
	TypeBasicDatasetTypeSQLServerTable                  TypeBasicDataset = original.TypeBasicDatasetTypeSQLServerTable
	TypeBasicDatasetTypeSquareObject                    TypeBasicDataset = original.TypeBasicDatasetTypeSquareObject
	TypeBasicDatasetTypeSybaseTable                     TypeBasicDataset = original.TypeBasicDatasetTypeSybaseTable
	TypeBasicDatasetTypeTeradataTable                   TypeBasicDataset = original.TypeBasicDatasetTypeTeradataTable
	TypeBasicDatasetTypeVerticaTable                    TypeBasicDataset = original.TypeBasicDatasetTypeVerticaTable
	TypeBasicDatasetTypeWebTable                        TypeBasicDataset = original.TypeBasicDatasetTypeWebTable
	TypeBasicDatasetTypeXeroObject                      TypeBasicDataset = original.TypeBasicDatasetTypeXeroObject
	TypeBasicDatasetTypeXML                             TypeBasicDataset = original.TypeBasicDatasetTypeXML
	TypeBasicDatasetTypeZohoObject                      TypeBasicDataset = original.TypeBasicDatasetTypeZohoObject
)

type TypeBasicDatasetCompression = original.TypeBasicDatasetCompression

const (
	TypeBasicDatasetCompressionTypeBZip2              TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeBZip2
	TypeBasicDatasetCompressionTypeDatasetCompression TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeDatasetCompression
	TypeBasicDatasetCompressionTypeDeflate            TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeDeflate
	TypeBasicDatasetCompressionTypeGZip               TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeGZip
	TypeBasicDatasetCompressionTypeTar                TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeTar
	TypeBasicDatasetCompressionTypeTarGZip            TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeTarGZip
	TypeBasicDatasetCompressionTypeZipDeflate         TypeBasicDatasetCompression = original.TypeBasicDatasetCompressionTypeZipDeflate
)

type TypeBasicDatasetLocation = original.TypeBasicDatasetLocation

const (
	TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeAmazonS3CompatibleLocation
	TypeBasicDatasetLocationTypeAmazonS3Location           TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeAmazonS3Location
	TypeBasicDatasetLocationTypeAzureBlobFSLocation        TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeAzureBlobFSLocation
	TypeBasicDatasetLocationTypeAzureBlobStorageLocation   TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeAzureBlobStorageLocation
	TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeAzureDataLakeStoreLocation
	TypeBasicDatasetLocationTypeAzureFileStorageLocation   TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeAzureFileStorageLocation
	TypeBasicDatasetLocationTypeDatasetLocation            TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeDatasetLocation
	TypeBasicDatasetLocationTypeFileServerLocation         TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeFileServerLocation
	TypeBasicDatasetLocationTypeFtpServerLocation          TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeFtpServerLocation
	TypeBasicDatasetLocationTypeGoogleCloudStorageLocation TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeGoogleCloudStorageLocation
	TypeBasicDatasetLocationTypeHdfsLocation               TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeHdfsLocation
	TypeBasicDatasetLocationTypeHTTPServerLocation         TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeHTTPServerLocation
	TypeBasicDatasetLocationTypeOracleCloudStorageLocation TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeOracleCloudStorageLocation
	TypeBasicDatasetLocationTypeSftpLocation               TypeBasicDatasetLocation = original.TypeBasicDatasetLocationTypeSftpLocation
)

type TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormat

const (
	TypeBasicDatasetStorageFormatTypeAvroFormat           TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormatTypeAvroFormat
	TypeBasicDatasetStorageFormatTypeDatasetStorageFormat TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormatTypeDatasetStorageFormat
	TypeBasicDatasetStorageFormatTypeJSONFormat           TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormatTypeJSONFormat
	TypeBasicDatasetStorageFormatTypeOrcFormat            TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormatTypeOrcFormat
	TypeBasicDatasetStorageFormatTypeParquetFormat        TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormatTypeParquetFormat
	TypeBasicDatasetStorageFormatTypeTextFormat           TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormatTypeTextFormat
)

type TypeBasicDependencyReference = original.TypeBasicDependencyReference

const (
	TypeBasicDependencyReferenceTypeDependencyReference                          TypeBasicDependencyReference = original.TypeBasicDependencyReferenceTypeDependencyReference
	TypeBasicDependencyReferenceTypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = original.TypeBasicDependencyReferenceTypeSelfDependencyTumblingWindowTriggerReference
	TypeBasicDependencyReferenceTypeTriggerDependencyReference                   TypeBasicDependencyReference = original.TypeBasicDependencyReferenceTypeTriggerDependencyReference
	TypeBasicDependencyReferenceTypeTumblingWindowTriggerDependencyReference     TypeBasicDependencyReference = original.TypeBasicDependencyReferenceTypeTumblingWindowTriggerDependencyReference
)

type TypeBasicExportSettings = original.TypeBasicExportSettings

const (
	TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand TypeBasicExportSettings = original.TypeBasicExportSettingsTypeAzureDatabricksDeltaLakeExportCommand
	TypeBasicExportSettingsTypeExportSettings                        TypeBasicExportSettings = original.TypeBasicExportSettingsTypeExportSettings
	TypeBasicExportSettingsTypeSnowflakeExportCopyCommand            TypeBasicExportSettings = original.TypeBasicExportSettingsTypeSnowflakeExportCopyCommand
)

type TypeBasicFactoryRepoConfiguration = original.TypeBasicFactoryRepoConfiguration

const (
	TypeBasicFactoryRepoConfigurationTypeFactoryGitHubConfiguration TypeBasicFactoryRepoConfiguration = original.TypeBasicFactoryRepoConfigurationTypeFactoryGitHubConfiguration
	TypeBasicFactoryRepoConfigurationTypeFactoryRepoConfiguration   TypeBasicFactoryRepoConfiguration = original.TypeBasicFactoryRepoConfigurationTypeFactoryRepoConfiguration
	TypeBasicFactoryRepoConfigurationTypeFactoryVSTSConfiguration   TypeBasicFactoryRepoConfiguration = original.TypeBasicFactoryRepoConfigurationTypeFactoryVSTSConfiguration
)

type TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettings

const (
	TypeBasicFormatReadSettingsTypeBinaryReadSettings        TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettingsTypeBinaryReadSettings
	TypeBasicFormatReadSettingsTypeDelimitedTextReadSettings TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettingsTypeDelimitedTextReadSettings
	TypeBasicFormatReadSettingsTypeFormatReadSettings        TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettingsTypeFormatReadSettings
	TypeBasicFormatReadSettingsTypeJSONReadSettings          TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettingsTypeJSONReadSettings
	TypeBasicFormatReadSettingsTypeXMLReadSettings           TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettingsTypeXMLReadSettings
)

type TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettings

const (
	TypeBasicFormatWriteSettingsTypeAvroWriteSettings          TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettingsTypeAvroWriteSettings
	TypeBasicFormatWriteSettingsTypeDelimitedTextWriteSettings TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettingsTypeDelimitedTextWriteSettings
	TypeBasicFormatWriteSettingsTypeFormatWriteSettings        TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettingsTypeFormatWriteSettings
	TypeBasicFormatWriteSettingsTypeJSONWriteSettings          TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettingsTypeJSONWriteSettings
	TypeBasicFormatWriteSettingsTypeOrcWriteSettings           TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettingsTypeOrcWriteSettings
	TypeBasicFormatWriteSettingsTypeParquetWriteSettings       TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettingsTypeParquetWriteSettings
)

type TypeBasicImportSettings = original.TypeBasicImportSettings

const (
	TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand TypeBasicImportSettings = original.TypeBasicImportSettingsTypeAzureDatabricksDeltaLakeImportCommand
	TypeBasicImportSettingsTypeImportSettings                        TypeBasicImportSettings = original.TypeBasicImportSettingsTypeImportSettings
	TypeBasicImportSettingsTypeSnowflakeImportCopyCommand            TypeBasicImportSettings = original.TypeBasicImportSettingsTypeSnowflakeImportCopyCommand
)

type TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntime

const (
	TypeBasicIntegrationRuntimeTypeIntegrationRuntime TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntimeTypeIntegrationRuntime
	TypeBasicIntegrationRuntimeTypeManaged            TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntimeTypeManaged
	TypeBasicIntegrationRuntimeTypeSelfHosted         TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntimeTypeSelfHosted
)

type TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatus

const (
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus
	TypeBasicIntegrationRuntimeStatusTypeManaged                  TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeManaged
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted               TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeSelfHosted
)

type TypeBasicLinkedService = original.TypeBasicLinkedService

const (
	TypeBasicLinkedServiceTypeAmazonMWS                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAmazonMWS
	TypeBasicLinkedServiceTypeAmazonRdsForOracle       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAmazonRdsForOracle
	TypeBasicLinkedServiceTypeAmazonRedshift           TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAmazonRedshift
	TypeBasicLinkedServiceTypeAmazonS3                 TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAmazonS3
	TypeBasicLinkedServiceTypeAmazonS3Compatible       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAmazonS3Compatible
	TypeBasicLinkedServiceTypeAzureBatch               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureBatch
	TypeBasicLinkedServiceTypeAzureBlobFS              TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureBlobFS
	TypeBasicLinkedServiceTypeAzureBlobStorage         TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureBlobStorage
	TypeBasicLinkedServiceTypeAzureDatabricks          TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureDatabricks
	TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureDatabricksDeltaLake
	TypeBasicLinkedServiceTypeAzureDataExplorer        TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureDataExplorer
	TypeBasicLinkedServiceTypeAzureDataLakeAnalytics   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureDataLakeAnalytics
	TypeBasicLinkedServiceTypeAzureDataLakeStore       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureDataLakeStore
	TypeBasicLinkedServiceTypeAzureFileStorage         TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureFileStorage
	TypeBasicLinkedServiceTypeAzureFunction            TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureFunction
	TypeBasicLinkedServiceTypeAzureKeyVault            TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureKeyVault
	TypeBasicLinkedServiceTypeAzureMariaDB             TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureMariaDB
	TypeBasicLinkedServiceTypeAzureML                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureML
	TypeBasicLinkedServiceTypeAzureMLService           TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureMLService
	TypeBasicLinkedServiceTypeAzureMySQL               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureMySQL
	TypeBasicLinkedServiceTypeAzurePostgreSQL          TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzurePostgreSQL
	TypeBasicLinkedServiceTypeAzureSearch              TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureSearch
	TypeBasicLinkedServiceTypeAzureSQLDatabase         TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureSQLDatabase
	TypeBasicLinkedServiceTypeAzureSQLDW               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureSQLDW
	TypeBasicLinkedServiceTypeAzureSQLMI               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureSQLMI
	TypeBasicLinkedServiceTypeAzureStorage             TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureStorage
	TypeBasicLinkedServiceTypeAzureTableStorage        TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeAzureTableStorage
	TypeBasicLinkedServiceTypeCassandra                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeCassandra
	TypeBasicLinkedServiceTypeCommonDataServiceForApps TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeCommonDataServiceForApps
	TypeBasicLinkedServiceTypeConcur                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeConcur
	TypeBasicLinkedServiceTypeCosmosDb                 TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeCosmosDb
	TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeCosmosDbMongoDbAPI
	TypeBasicLinkedServiceTypeCouchbase                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeCouchbase
	TypeBasicLinkedServiceTypeCustomDataSource         TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeCustomDataSource
	TypeBasicLinkedServiceTypeDb2                      TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeDb2
	TypeBasicLinkedServiceTypeDrill                    TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeDrill
	TypeBasicLinkedServiceTypeDynamics                 TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeDynamics
	TypeBasicLinkedServiceTypeDynamicsAX               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeDynamicsAX
	TypeBasicLinkedServiceTypeDynamicsCrm              TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeDynamicsCrm
	TypeBasicLinkedServiceTypeEloqua                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeEloqua
	TypeBasicLinkedServiceTypeFileServer               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeFileServer
	TypeBasicLinkedServiceTypeFtpServer                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeFtpServer
	TypeBasicLinkedServiceTypeGoogleAdWords            TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeGoogleAdWords
	TypeBasicLinkedServiceTypeGoogleBigQuery           TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeGoogleBigQuery
	TypeBasicLinkedServiceTypeGoogleCloudStorage       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeGoogleCloudStorage
	TypeBasicLinkedServiceTypeGreenplum                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeGreenplum
	TypeBasicLinkedServiceTypeHBase                    TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHBase
	TypeBasicLinkedServiceTypeHdfs                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHdfs
	TypeBasicLinkedServiceTypeHDInsight                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHDInsight
	TypeBasicLinkedServiceTypeHDInsightOnDemand        TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHDInsightOnDemand
	TypeBasicLinkedServiceTypeHive                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHive
	TypeBasicLinkedServiceTypeHTTPServer               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHTTPServer
	TypeBasicLinkedServiceTypeHubspot                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeHubspot
	TypeBasicLinkedServiceTypeImpala                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeImpala
	TypeBasicLinkedServiceTypeInformix                 TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeInformix
	TypeBasicLinkedServiceTypeJira                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeJira
	TypeBasicLinkedServiceTypeLinkedService            TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeLinkedService
	TypeBasicLinkedServiceTypeMagento                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMagento
	TypeBasicLinkedServiceTypeMariaDB                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMariaDB
	TypeBasicLinkedServiceTypeMarketo                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMarketo
	TypeBasicLinkedServiceTypeMicrosoftAccess          TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMicrosoftAccess
	TypeBasicLinkedServiceTypeMongoDb                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMongoDb
	TypeBasicLinkedServiceTypeMongoDbAtlas             TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMongoDbAtlas
	TypeBasicLinkedServiceTypeMongoDbV2                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMongoDbV2
	TypeBasicLinkedServiceTypeMySQL                    TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeMySQL
	TypeBasicLinkedServiceTypeNetezza                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeNetezza
	TypeBasicLinkedServiceTypeOData                    TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeOData
	TypeBasicLinkedServiceTypeOdbc                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeOdbc
	TypeBasicLinkedServiceTypeOffice365                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeOffice365
	TypeBasicLinkedServiceTypeOracle                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeOracle
	TypeBasicLinkedServiceTypeOracleCloudStorage       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeOracleCloudStorage
	TypeBasicLinkedServiceTypeOracleServiceCloud       TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeOracleServiceCloud
	TypeBasicLinkedServiceTypePaypal                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypePaypal
	TypeBasicLinkedServiceTypePhoenix                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypePhoenix
	TypeBasicLinkedServiceTypePostgreSQL               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypePostgreSQL
	TypeBasicLinkedServiceTypePresto                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypePresto
	TypeBasicLinkedServiceTypeQuickBooks               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeQuickBooks
	TypeBasicLinkedServiceTypeResponsys                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeResponsys
	TypeBasicLinkedServiceTypeRestService              TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeRestService
	TypeBasicLinkedServiceTypeSalesforce               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSalesforce
	TypeBasicLinkedServiceTypeSalesforceMarketingCloud TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSalesforceMarketingCloud
	TypeBasicLinkedServiceTypeSalesforceServiceCloud   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSalesforceServiceCloud
	TypeBasicLinkedServiceTypeSapBW                    TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSapBW
	TypeBasicLinkedServiceTypeSapCloudForCustomer      TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSapCloudForCustomer
	TypeBasicLinkedServiceTypeSapEcc                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSapEcc
	TypeBasicLinkedServiceTypeSapHana                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSapHana
	TypeBasicLinkedServiceTypeSapOpenHub               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSapOpenHub
	TypeBasicLinkedServiceTypeSapTable                 TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSapTable
	TypeBasicLinkedServiceTypeServiceNow               TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeServiceNow
	TypeBasicLinkedServiceTypeSftp                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSftp
	TypeBasicLinkedServiceTypeSharePointOnlineList     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSharePointOnlineList
	TypeBasicLinkedServiceTypeShopify                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeShopify
	TypeBasicLinkedServiceTypeSnowflake                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSnowflake
	TypeBasicLinkedServiceTypeSpark                    TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSpark
	TypeBasicLinkedServiceTypeSQLServer                TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSQLServer
	TypeBasicLinkedServiceTypeSquare                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSquare
	TypeBasicLinkedServiceTypeSybase                   TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeSybase
	TypeBasicLinkedServiceTypeTeradata                 TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeTeradata
	TypeBasicLinkedServiceTypeVertica                  TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeVertica
	TypeBasicLinkedServiceTypeWeb                      TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeWeb
	TypeBasicLinkedServiceTypeXero                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeXero
	TypeBasicLinkedServiceTypeZoho                     TypeBasicLinkedService = original.TypeBasicLinkedServiceTypeZoho
)

type TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadata

const (
	TypeBasicSsisObjectMetadataTypeEnvironment        TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadataTypeEnvironment
	TypeBasicSsisObjectMetadataTypeFolder             TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadataTypeFolder
	TypeBasicSsisObjectMetadataTypePackage            TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadataTypePackage
	TypeBasicSsisObjectMetadataTypeProject            TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadataTypeProject
	TypeBasicSsisObjectMetadataTypeSsisObjectMetadata TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadataTypeSsisObjectMetadata
)

type TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettings

const (
	TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeAmazonS3CompatibleReadSettings
	TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings           TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeAmazonS3ReadSettings
	TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings        TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeAzureBlobFSReadSettings
	TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings   TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeAzureBlobStorageReadSettings
	TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeAzureDataLakeStoreReadSettings
	TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings   TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeAzureFileStorageReadSettings
	TypeBasicStoreReadSettingsTypeFileServerReadSettings         TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeFileServerReadSettings
	TypeBasicStoreReadSettingsTypeFtpReadSettings                TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeFtpReadSettings
	TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeGoogleCloudStorageReadSettings
	TypeBasicStoreReadSettingsTypeHdfsReadSettings               TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeHdfsReadSettings
	TypeBasicStoreReadSettingsTypeHTTPReadSettings               TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeHTTPReadSettings
	TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeOracleCloudStorageReadSettings
	TypeBasicStoreReadSettingsTypeSftpReadSettings               TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeSftpReadSettings
	TypeBasicStoreReadSettingsTypeStoreReadSettings              TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettingsTypeStoreReadSettings
)

type TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettings

const (
	TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings        TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeAzureBlobFSWriteSettings
	TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings   TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeAzureBlobStorageWriteSettings
	TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeAzureDataLakeStoreWriteSettings
	TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings   TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeAzureFileStorageWriteSettings
	TypeBasicStoreWriteSettingsTypeFileServerWriteSettings         TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeFileServerWriteSettings
	TypeBasicStoreWriteSettingsTypeSftpWriteSettings               TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeSftpWriteSettings
	TypeBasicStoreWriteSettingsTypeStoreWriteSettings              TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettingsTypeStoreWriteSettings
)

type TypeBasicTrigger = original.TypeBasicTrigger

const (
	TypeBasicTriggerTypeBlobEventsTrigger          TypeBasicTrigger = original.TypeBasicTriggerTypeBlobEventsTrigger
	TypeBasicTriggerTypeBlobTrigger                TypeBasicTrigger = original.TypeBasicTriggerTypeBlobTrigger
	TypeBasicTriggerTypeChainingTrigger            TypeBasicTrigger = original.TypeBasicTriggerTypeChainingTrigger
	TypeBasicTriggerTypeCustomEventsTrigger        TypeBasicTrigger = original.TypeBasicTriggerTypeCustomEventsTrigger
	TypeBasicTriggerTypeMultiplePipelineTrigger    TypeBasicTrigger = original.TypeBasicTriggerTypeMultiplePipelineTrigger
	TypeBasicTriggerTypeRerunTumblingWindowTrigger TypeBasicTrigger = original.TypeBasicTriggerTypeRerunTumblingWindowTrigger
	TypeBasicTriggerTypeScheduleTrigger            TypeBasicTrigger = original.TypeBasicTriggerTypeScheduleTrigger
	TypeBasicTriggerTypeTrigger                    TypeBasicTrigger = original.TypeBasicTriggerTypeTrigger
	TypeBasicTriggerTypeTumblingWindowTrigger      TypeBasicTrigger = original.TypeBasicTriggerTypeTumblingWindowTrigger
)

type VariableType = original.VariableType

const (
	VariableTypeArray  VariableType = original.VariableTypeArray
	VariableTypeBool   VariableType = original.VariableTypeBool
	VariableTypeString VariableType = original.VariableTypeString
)

type WebActivityMethod = original.WebActivityMethod

const (
	WebActivityMethodDELETE WebActivityMethod = original.WebActivityMethodDELETE
	WebActivityMethodGET    WebActivityMethod = original.WebActivityMethodGET
	WebActivityMethodPOST   WebActivityMethod = original.WebActivityMethodPOST
	WebActivityMethodPUT    WebActivityMethod = original.WebActivityMethodPUT
)

type WebHookActivityMethod = original.WebHookActivityMethod

const (
	WebHookActivityMethodPOST WebHookActivityMethod = original.WebHookActivityMethodPOST
)

type AccessPolicyResponse = original.AccessPolicyResponse
type Activity = original.Activity
type ActivityDependency = original.ActivityDependency
type ActivityPolicy = original.ActivityPolicy
type ActivityRun = original.ActivityRun
type ActivityRunsClient = original.ActivityRunsClient
type ActivityRunsQueryResponse = original.ActivityRunsQueryResponse
type AddDataFlowToDebugSessionResponse = original.AddDataFlowToDebugSessionResponse
type AdditionalColumns = original.AdditionalColumns
type AmazonMWSLinkedService = original.AmazonMWSLinkedService
type AmazonMWSLinkedServiceTypeProperties = original.AmazonMWSLinkedServiceTypeProperties
type AmazonMWSObjectDataset = original.AmazonMWSObjectDataset
type AmazonMWSSource = original.AmazonMWSSource
type AmazonRdsForLinkedServiceTypeProperties = original.AmazonRdsForLinkedServiceTypeProperties
type AmazonRdsForOracleLinkedService = original.AmazonRdsForOracleLinkedService
type AmazonRdsForOraclePartitionSettings = original.AmazonRdsForOraclePartitionSettings
type AmazonRdsForOracleSource = original.AmazonRdsForOracleSource
type AmazonRdsForOracleTableDataset = original.AmazonRdsForOracleTableDataset
type AmazonRdsForOracleTableDatasetTypeProperties = original.AmazonRdsForOracleTableDatasetTypeProperties
type AmazonRedshiftLinkedService = original.AmazonRedshiftLinkedService
type AmazonRedshiftLinkedServiceTypeProperties = original.AmazonRedshiftLinkedServiceTypeProperties
type AmazonRedshiftSource = original.AmazonRedshiftSource
type AmazonRedshiftTableDataset = original.AmazonRedshiftTableDataset
type AmazonRedshiftTableDatasetTypeProperties = original.AmazonRedshiftTableDatasetTypeProperties
type AmazonS3CompatibleLinkedService = original.AmazonS3CompatibleLinkedService
type AmazonS3CompatibleLinkedServiceTypeProperties = original.AmazonS3CompatibleLinkedServiceTypeProperties
type AmazonS3CompatibleLocation = original.AmazonS3CompatibleLocation
type AmazonS3CompatibleReadSettings = original.AmazonS3CompatibleReadSettings
type AmazonS3Dataset = original.AmazonS3Dataset
type AmazonS3DatasetTypeProperties = original.AmazonS3DatasetTypeProperties
type AmazonS3LinkedService = original.AmazonS3LinkedService
type AmazonS3LinkedServiceTypeProperties = original.AmazonS3LinkedServiceTypeProperties
type AmazonS3Location = original.AmazonS3Location
type AmazonS3ReadSettings = original.AmazonS3ReadSettings
type AppendVariableActivity = original.AppendVariableActivity
type AppendVariableActivityTypeProperties = original.AppendVariableActivityTypeProperties
type ArmIDWrapper = original.ArmIDWrapper
type AvroDataset = original.AvroDataset
type AvroDatasetTypeProperties = original.AvroDatasetTypeProperties
type AvroFormat = original.AvroFormat
type AvroSink = original.AvroSink
type AvroSource = original.AvroSource
type AvroWriteSettings = original.AvroWriteSettings
type AzPowerShellSetup = original.AzPowerShellSetup
type AzPowerShellSetupTypeProperties = original.AzPowerShellSetupTypeProperties
type AzureBatchLinkedService = original.AzureBatchLinkedService
type AzureBatchLinkedServiceTypeProperties = original.AzureBatchLinkedServiceTypeProperties
type AzureBlobDataset = original.AzureBlobDataset
type AzureBlobDatasetTypeProperties = original.AzureBlobDatasetTypeProperties
type AzureBlobFSDataset = original.AzureBlobFSDataset
type AzureBlobFSDatasetTypeProperties = original.AzureBlobFSDatasetTypeProperties
type AzureBlobFSLinkedService = original.AzureBlobFSLinkedService
type AzureBlobFSLinkedServiceTypeProperties = original.AzureBlobFSLinkedServiceTypeProperties
type AzureBlobFSLocation = original.AzureBlobFSLocation
type AzureBlobFSReadSettings = original.AzureBlobFSReadSettings
type AzureBlobFSSink = original.AzureBlobFSSink
type AzureBlobFSSource = original.AzureBlobFSSource
type AzureBlobFSWriteSettings = original.AzureBlobFSWriteSettings
type AzureBlobStorageLinkedService = original.AzureBlobStorageLinkedService
type AzureBlobStorageLinkedServiceTypeProperties = original.AzureBlobStorageLinkedServiceTypeProperties
type AzureBlobStorageLocation = original.AzureBlobStorageLocation
type AzureBlobStorageReadSettings = original.AzureBlobStorageReadSettings
type AzureBlobStorageWriteSettings = original.AzureBlobStorageWriteSettings
type AzureDataExplorerCommandActivity = original.AzureDataExplorerCommandActivity
type AzureDataExplorerCommandActivityTypeProperties = original.AzureDataExplorerCommandActivityTypeProperties
type AzureDataExplorerDatasetTypeProperties = original.AzureDataExplorerDatasetTypeProperties
type AzureDataExplorerLinkedService = original.AzureDataExplorerLinkedService
type AzureDataExplorerLinkedServiceTypeProperties = original.AzureDataExplorerLinkedServiceTypeProperties
type AzureDataExplorerSink = original.AzureDataExplorerSink
type AzureDataExplorerSource = original.AzureDataExplorerSource
type AzureDataExplorerTableDataset = original.AzureDataExplorerTableDataset
type AzureDataLakeAnalyticsLinkedService = original.AzureDataLakeAnalyticsLinkedService
type AzureDataLakeAnalyticsLinkedServiceTypeProperties = original.AzureDataLakeAnalyticsLinkedServiceTypeProperties
type AzureDataLakeStoreDataset = original.AzureDataLakeStoreDataset
type AzureDataLakeStoreDatasetTypeProperties = original.AzureDataLakeStoreDatasetTypeProperties
type AzureDataLakeStoreLinkedService = original.AzureDataLakeStoreLinkedService
type AzureDataLakeStoreLinkedServiceTypeProperties = original.AzureDataLakeStoreLinkedServiceTypeProperties
type AzureDataLakeStoreLocation = original.AzureDataLakeStoreLocation
type AzureDataLakeStoreReadSettings = original.AzureDataLakeStoreReadSettings
type AzureDataLakeStoreSink = original.AzureDataLakeStoreSink
type AzureDataLakeStoreSource = original.AzureDataLakeStoreSource
type AzureDataLakeStoreWriteSettings = original.AzureDataLakeStoreWriteSettings
type AzureDatabricksDeltaLakeDataset = original.AzureDatabricksDeltaLakeDataset
type AzureDatabricksDeltaLakeDatasetTypeProperties = original.AzureDatabricksDeltaLakeDatasetTypeProperties
type AzureDatabricksDeltaLakeExportCommand = original.AzureDatabricksDeltaLakeExportCommand
type AzureDatabricksDeltaLakeImportCommand = original.AzureDatabricksDeltaLakeImportCommand
type AzureDatabricksDeltaLakeLinkedService = original.AzureDatabricksDeltaLakeLinkedService
type AzureDatabricksDeltaLakeSink = original.AzureDatabricksDeltaLakeSink
type AzureDatabricksDeltaLakeSource = original.AzureDatabricksDeltaLakeSource
type AzureDatabricksDetltaLakeLinkedServiceTypeProperties = original.AzureDatabricksDetltaLakeLinkedServiceTypeProperties
type AzureDatabricksLinkedService = original.AzureDatabricksLinkedService
type AzureDatabricksLinkedServiceTypeProperties = original.AzureDatabricksLinkedServiceTypeProperties
type AzureFileStorageLinkedService = original.AzureFileStorageLinkedService
type AzureFileStorageLinkedServiceTypeProperties = original.AzureFileStorageLinkedServiceTypeProperties
type AzureFileStorageLocation = original.AzureFileStorageLocation
type AzureFileStorageReadSettings = original.AzureFileStorageReadSettings
type AzureFileStorageWriteSettings = original.AzureFileStorageWriteSettings
type AzureFunctionActivity = original.AzureFunctionActivity
type AzureFunctionActivityTypeProperties = original.AzureFunctionActivityTypeProperties
type AzureFunctionLinkedService = original.AzureFunctionLinkedService
type AzureFunctionLinkedServiceTypeProperties = original.AzureFunctionLinkedServiceTypeProperties
type AzureKeyVaultLinkedService = original.AzureKeyVaultLinkedService
type AzureKeyVaultLinkedServiceTypeProperties = original.AzureKeyVaultLinkedServiceTypeProperties
type AzureKeyVaultSecretReference = original.AzureKeyVaultSecretReference
type AzureMLBatchExecutionActivity = original.AzureMLBatchExecutionActivity
type AzureMLBatchExecutionActivityTypeProperties = original.AzureMLBatchExecutionActivityTypeProperties
type AzureMLExecutePipelineActivity = original.AzureMLExecutePipelineActivity
type AzureMLExecutePipelineActivityTypeProperties = original.AzureMLExecutePipelineActivityTypeProperties
type AzureMLLinkedService = original.AzureMLLinkedService
type AzureMLLinkedServiceTypeProperties = original.AzureMLLinkedServiceTypeProperties
type AzureMLServiceLinkedService = original.AzureMLServiceLinkedService
type AzureMLServiceLinkedServiceTypeProperties = original.AzureMLServiceLinkedServiceTypeProperties
type AzureMLUpdateResourceActivity = original.AzureMLUpdateResourceActivity
type AzureMLUpdateResourceActivityTypeProperties = original.AzureMLUpdateResourceActivityTypeProperties
type AzureMLWebServiceFile = original.AzureMLWebServiceFile
type AzureMariaDBLinkedService = original.AzureMariaDBLinkedService
type AzureMariaDBLinkedServiceTypeProperties = original.AzureMariaDBLinkedServiceTypeProperties
type AzureMariaDBSource = original.AzureMariaDBSource
type AzureMariaDBTableDataset = original.AzureMariaDBTableDataset
type AzureMySQLLinkedService = original.AzureMySQLLinkedService
type AzureMySQLLinkedServiceTypeProperties = original.AzureMySQLLinkedServiceTypeProperties
type AzureMySQLSink = original.AzureMySQLSink
type AzureMySQLSource = original.AzureMySQLSource
type AzureMySQLTableDataset = original.AzureMySQLTableDataset
type AzureMySQLTableDatasetTypeProperties = original.AzureMySQLTableDatasetTypeProperties
type AzurePostgreSQLLinkedService = original.AzurePostgreSQLLinkedService
type AzurePostgreSQLLinkedServiceTypeProperties = original.AzurePostgreSQLLinkedServiceTypeProperties
type AzurePostgreSQLSink = original.AzurePostgreSQLSink
type AzurePostgreSQLSource = original.AzurePostgreSQLSource
type AzurePostgreSQLTableDataset = original.AzurePostgreSQLTableDataset
type AzurePostgreSQLTableDatasetTypeProperties = original.AzurePostgreSQLTableDatasetTypeProperties
type AzureQueueSink = original.AzureQueueSink
type AzureSQLDWLinkedService = original.AzureSQLDWLinkedService
type AzureSQLDWLinkedServiceTypeProperties = original.AzureSQLDWLinkedServiceTypeProperties
type AzureSQLDWTableDataset = original.AzureSQLDWTableDataset
type AzureSQLDWTableDatasetTypeProperties = original.AzureSQLDWTableDatasetTypeProperties
type AzureSQLDatabaseLinkedService = original.AzureSQLDatabaseLinkedService
type AzureSQLDatabaseLinkedServiceTypeProperties = original.AzureSQLDatabaseLinkedServiceTypeProperties
type AzureSQLMILinkedService = original.AzureSQLMILinkedService
type AzureSQLMILinkedServiceTypeProperties = original.AzureSQLMILinkedServiceTypeProperties
type AzureSQLMITableDataset = original.AzureSQLMITableDataset
type AzureSQLMITableDatasetTypeProperties = original.AzureSQLMITableDatasetTypeProperties
type AzureSQLSink = original.AzureSQLSink
type AzureSQLSource = original.AzureSQLSource
type AzureSQLTableDataset = original.AzureSQLTableDataset
type AzureSQLTableDatasetTypeProperties = original.AzureSQLTableDatasetTypeProperties
type AzureSearchIndexDataset = original.AzureSearchIndexDataset
type AzureSearchIndexDatasetTypeProperties = original.AzureSearchIndexDatasetTypeProperties
type AzureSearchIndexSink = original.AzureSearchIndexSink
type AzureSearchLinkedService = original.AzureSearchLinkedService
type AzureSearchLinkedServiceTypeProperties = original.AzureSearchLinkedServiceTypeProperties
type AzureStorageLinkedService = original.AzureStorageLinkedService
type AzureStorageLinkedServiceTypeProperties = original.AzureStorageLinkedServiceTypeProperties
type AzureTableDataset = original.AzureTableDataset
type AzureTableDatasetTypeProperties = original.AzureTableDatasetTypeProperties
type AzureTableSink = original.AzureTableSink
type AzureTableSource = original.AzureTableSource
type AzureTableStorageLinkedService = original.AzureTableStorageLinkedService
type BaseClient = original.BaseClient
type BasicActivity = original.BasicActivity
type BasicCompressionReadSettings = original.BasicCompressionReadSettings
type BasicControlActivity = original.BasicControlActivity
type BasicCopySink = original.BasicCopySink
type BasicCopySource = original.BasicCopySource
type BasicCopyTranslator = original.BasicCopyTranslator
type BasicCredential = original.BasicCredential
type BasicCustomSetupBase = original.BasicCustomSetupBase
type BasicDataFlow = original.BasicDataFlow
type BasicDataset = original.BasicDataset
type BasicDatasetCompression = original.BasicDatasetCompression
type BasicDatasetLocation = original.BasicDatasetLocation
type BasicDatasetStorageFormat = original.BasicDatasetStorageFormat
type BasicDependencyReference = original.BasicDependencyReference
type BasicExecutionActivity = original.BasicExecutionActivity
type BasicExportSettings = original.BasicExportSettings
type BasicFactoryRepoConfiguration = original.BasicFactoryRepoConfiguration
type BasicFormatReadSettings = original.BasicFormatReadSettings
type BasicFormatWriteSettings = original.BasicFormatWriteSettings
type BasicImportSettings = original.BasicImportSettings
type BasicIntegrationRuntime = original.BasicIntegrationRuntime
type BasicIntegrationRuntimeStatus = original.BasicIntegrationRuntimeStatus
type BasicLinkedIntegrationRuntimeType = original.BasicLinkedIntegrationRuntimeType
type BasicLinkedService = original.BasicLinkedService
type BasicMultiplePipelineTrigger = original.BasicMultiplePipelineTrigger
type BasicSecretBase = original.BasicSecretBase
type BasicSsisObjectMetadata = original.BasicSsisObjectMetadata
type BasicStoreReadSettings = original.BasicStoreReadSettings
type BasicStoreWriteSettings = original.BasicStoreWriteSettings
type BasicTabularSource = original.BasicTabularSource
type BasicTrigger = original.BasicTrigger
type BasicTriggerDependencyReference = original.BasicTriggerDependencyReference
type BasicWebLinkedServiceTypeProperties = original.BasicWebLinkedServiceTypeProperties
type BinaryDataset = original.BinaryDataset
type BinaryDatasetTypeProperties = original.BinaryDatasetTypeProperties
type BinaryReadSettings = original.BinaryReadSettings
type BinarySink = original.BinarySink
type BinarySource = original.BinarySource
type BlobEventsTrigger = original.BlobEventsTrigger
type BlobEventsTriggerTypeProperties = original.BlobEventsTriggerTypeProperties
type BlobSink = original.BlobSink
type BlobSource = original.BlobSource
type BlobTrigger = original.BlobTrigger
type BlobTriggerTypeProperties = original.BlobTriggerTypeProperties
type CMKIdentityDefinition = original.CMKIdentityDefinition
type CassandraLinkedService = original.CassandraLinkedService
type CassandraLinkedServiceTypeProperties = original.CassandraLinkedServiceTypeProperties
type CassandraSource = original.CassandraSource
type CassandraTableDataset = original.CassandraTableDataset
type CassandraTableDatasetTypeProperties = original.CassandraTableDatasetTypeProperties
type ChainingTrigger = original.ChainingTrigger
type ChainingTriggerTypeProperties = original.ChainingTriggerTypeProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CmdkeySetup = original.CmdkeySetup
type CmdkeySetupTypeProperties = original.CmdkeySetupTypeProperties
type CommonDataServiceForAppsEntityDataset = original.CommonDataServiceForAppsEntityDataset
type CommonDataServiceForAppsEntityDatasetTypeProperties = original.CommonDataServiceForAppsEntityDatasetTypeProperties
type CommonDataServiceForAppsLinkedService = original.CommonDataServiceForAppsLinkedService
type CommonDataServiceForAppsLinkedServiceTypeProperties = original.CommonDataServiceForAppsLinkedServiceTypeProperties
type CommonDataServiceForAppsSink = original.CommonDataServiceForAppsSink
type CommonDataServiceForAppsSource = original.CommonDataServiceForAppsSource
type ComponentSetup = original.ComponentSetup
type CompressionReadSettings = original.CompressionReadSettings
type ConcurLinkedService = original.ConcurLinkedService
type ConcurLinkedServiceTypeProperties = original.ConcurLinkedServiceTypeProperties
type ConcurObjectDataset = original.ConcurObjectDataset
type ConcurSource = original.ConcurSource
type ConnectionStateProperties = original.ConnectionStateProperties
type ControlActivity = original.ControlActivity
type CopyActivity = original.CopyActivity
type CopyActivityLogSettings = original.CopyActivityLogSettings
type CopyActivityTypeProperties = original.CopyActivityTypeProperties
type CopySink = original.CopySink
type CopySource = original.CopySource
type CopyTranslator = original.CopyTranslator
type CosmosDbLinkedService = original.CosmosDbLinkedService
type CosmosDbLinkedServiceTypeProperties = original.CosmosDbLinkedServiceTypeProperties
type CosmosDbMongoDbAPICollectionDataset = original.CosmosDbMongoDbAPICollectionDataset
type CosmosDbMongoDbAPICollectionDatasetTypeProperties = original.CosmosDbMongoDbAPICollectionDatasetTypeProperties
type CosmosDbMongoDbAPILinkedService = original.CosmosDbMongoDbAPILinkedService
type CosmosDbMongoDbAPILinkedServiceTypeProperties = original.CosmosDbMongoDbAPILinkedServiceTypeProperties
type CosmosDbMongoDbAPISink = original.CosmosDbMongoDbAPISink
type CosmosDbMongoDbAPISource = original.CosmosDbMongoDbAPISource
type CosmosDbSQLAPICollectionDataset = original.CosmosDbSQLAPICollectionDataset
type CosmosDbSQLAPICollectionDatasetTypeProperties = original.CosmosDbSQLAPICollectionDatasetTypeProperties
type CosmosDbSQLAPISink = original.CosmosDbSQLAPISink
type CosmosDbSQLAPISource = original.CosmosDbSQLAPISource
type CouchbaseLinkedService = original.CouchbaseLinkedService
type CouchbaseLinkedServiceTypeProperties = original.CouchbaseLinkedServiceTypeProperties
type CouchbaseSource = original.CouchbaseSource
type CouchbaseTableDataset = original.CouchbaseTableDataset
type CreateDataFlowDebugSessionRequest = original.CreateDataFlowDebugSessionRequest
type CreateDataFlowDebugSessionResponse = original.CreateDataFlowDebugSessionResponse
type CreateLinkedIntegrationRuntimeRequest = original.CreateLinkedIntegrationRuntimeRequest
type CreateRunResponse = original.CreateRunResponse
type Credential = original.Credential
type CredentialReference = original.CredentialReference
type CredentialResource = original.CredentialResource
type CustomActivity = original.CustomActivity
type CustomActivityReferenceObject = original.CustomActivityReferenceObject
type CustomActivityTypeProperties = original.CustomActivityTypeProperties
type CustomDataSourceLinkedService = original.CustomDataSourceLinkedService
type CustomDataset = original.CustomDataset
type CustomEventsTrigger = original.CustomEventsTrigger
type CustomEventsTriggerTypeProperties = original.CustomEventsTriggerTypeProperties
type CustomSetupBase = original.CustomSetupBase
type DWCopyCommandDefaultValue = original.DWCopyCommandDefaultValue
type DWCopyCommandSettings = original.DWCopyCommandSettings
type DataFlow = original.DataFlow
type DataFlowDebugCommandPayload = original.DataFlowDebugCommandPayload
type DataFlowDebugCommandRequest = original.DataFlowDebugCommandRequest
type DataFlowDebugCommandResponse = original.DataFlowDebugCommandResponse
type DataFlowDebugPackage = original.DataFlowDebugPackage
type DataFlowDebugPackageDebugSettings = original.DataFlowDebugPackageDebugSettings
type DataFlowDebugResource = original.DataFlowDebugResource
type DataFlowDebugSessionClient = original.DataFlowDebugSessionClient
type DataFlowDebugSessionCreateFuture = original.DataFlowDebugSessionCreateFuture
type DataFlowDebugSessionExecuteCommandFuture = original.DataFlowDebugSessionExecuteCommandFuture
type DataFlowDebugSessionInfo = original.DataFlowDebugSessionInfo
type DataFlowFolder = original.DataFlowFolder
type DataFlowListResponse = original.DataFlowListResponse
type DataFlowListResponseIterator = original.DataFlowListResponseIterator
type DataFlowListResponsePage = original.DataFlowListResponsePage
type DataFlowReference = original.DataFlowReference
type DataFlowResource = original.DataFlowResource
type DataFlowSink = original.DataFlowSink
type DataFlowSource = original.DataFlowSource
type DataFlowSourceSetting = original.DataFlowSourceSetting
type DataFlowStagingInfo = original.DataFlowStagingInfo
type DataFlowsClient = original.DataFlowsClient
type DataLakeAnalyticsUSQLActivity = original.DataLakeAnalyticsUSQLActivity
type DataLakeAnalyticsUSQLActivityTypeProperties = original.DataLakeAnalyticsUSQLActivityTypeProperties
type DatabricksNotebookActivity = original.DatabricksNotebookActivity
type DatabricksNotebookActivityTypeProperties = original.DatabricksNotebookActivityTypeProperties
type DatabricksSparkJarActivity = original.DatabricksSparkJarActivity
type DatabricksSparkJarActivityTypeProperties = original.DatabricksSparkJarActivityTypeProperties
type DatabricksSparkPythonActivity = original.DatabricksSparkPythonActivity
type DatabricksSparkPythonActivityTypeProperties = original.DatabricksSparkPythonActivityTypeProperties
type Dataset = original.Dataset
type DatasetBZip2Compression = original.DatasetBZip2Compression
type DatasetCompression = original.DatasetCompression
type DatasetDataElement = original.DatasetDataElement
type DatasetDebugResource = original.DatasetDebugResource
type DatasetDeflateCompression = original.DatasetDeflateCompression
type DatasetFolder = original.DatasetFolder
type DatasetGZipCompression = original.DatasetGZipCompression
type DatasetListResponse = original.DatasetListResponse
type DatasetListResponseIterator = original.DatasetListResponseIterator
type DatasetListResponsePage = original.DatasetListResponsePage
type DatasetLocation = original.DatasetLocation
type DatasetReference = original.DatasetReference
type DatasetResource = original.DatasetResource
type DatasetSchemaDataElement = original.DatasetSchemaDataElement
type DatasetStorageFormat = original.DatasetStorageFormat
type DatasetTarCompression = original.DatasetTarCompression
type DatasetTarGZipCompression = original.DatasetTarGZipCompression
type DatasetZipDeflateCompression = original.DatasetZipDeflateCompression
type DatasetsClient = original.DatasetsClient
type Db2LinkedService = original.Db2LinkedService
type Db2LinkedServiceTypeProperties = original.Db2LinkedServiceTypeProperties
type Db2Source = original.Db2Source
type Db2TableDataset = original.Db2TableDataset
type Db2TableDatasetTypeProperties = original.Db2TableDatasetTypeProperties
type DeleteActivity = original.DeleteActivity
type DeleteActivityTypeProperties = original.DeleteActivityTypeProperties
type DeleteDataFlowDebugSessionRequest = original.DeleteDataFlowDebugSessionRequest
type DelimitedTextDataset = original.DelimitedTextDataset
type DelimitedTextDatasetTypeProperties = original.DelimitedTextDatasetTypeProperties
type DelimitedTextReadSettings = original.DelimitedTextReadSettings
type DelimitedTextSink = original.DelimitedTextSink
type DelimitedTextSource = original.DelimitedTextSource
type DelimitedTextWriteSettings = original.DelimitedTextWriteSettings
type DependencyReference = original.DependencyReference
type DistcpSettings = original.DistcpSettings
type DocumentDbCollectionDataset = original.DocumentDbCollectionDataset
type DocumentDbCollectionDatasetTypeProperties = original.DocumentDbCollectionDatasetTypeProperties
type DocumentDbCollectionSink = original.DocumentDbCollectionSink
type DocumentDbCollectionSource = original.DocumentDbCollectionSource
type DrillDatasetTypeProperties = original.DrillDatasetTypeProperties
type DrillLinkedService = original.DrillLinkedService
type DrillLinkedServiceTypeProperties = original.DrillLinkedServiceTypeProperties
type DrillSource = original.DrillSource
type DrillTableDataset = original.DrillTableDataset
type DynamicsAXLinkedService = original.DynamicsAXLinkedService
type DynamicsAXLinkedServiceTypeProperties = original.DynamicsAXLinkedServiceTypeProperties
type DynamicsAXResourceDataset = original.DynamicsAXResourceDataset
type DynamicsAXResourceDatasetTypeProperties = original.DynamicsAXResourceDatasetTypeProperties
type DynamicsAXSource = original.DynamicsAXSource
type DynamicsCrmEntityDataset = original.DynamicsCrmEntityDataset
type DynamicsCrmEntityDatasetTypeProperties = original.DynamicsCrmEntityDatasetTypeProperties
type DynamicsCrmLinkedService = original.DynamicsCrmLinkedService
type DynamicsCrmLinkedServiceTypeProperties = original.DynamicsCrmLinkedServiceTypeProperties
type DynamicsCrmSink = original.DynamicsCrmSink
type DynamicsCrmSource = original.DynamicsCrmSource
type DynamicsEntityDataset = original.DynamicsEntityDataset
type DynamicsEntityDatasetTypeProperties = original.DynamicsEntityDatasetTypeProperties
type DynamicsLinkedService = original.DynamicsLinkedService
type DynamicsLinkedServiceTypeProperties = original.DynamicsLinkedServiceTypeProperties
type DynamicsSink = original.DynamicsSink
type DynamicsSource = original.DynamicsSource
type EloquaLinkedService = original.EloquaLinkedService
type EloquaLinkedServiceTypeProperties = original.EloquaLinkedServiceTypeProperties
type EloquaObjectDataset = original.EloquaObjectDataset
type EloquaSource = original.EloquaSource
type EncryptionConfiguration = original.EncryptionConfiguration
type EntityReference = original.EntityReference
type EnvironmentVariableSetup = original.EnvironmentVariableSetup
type EnvironmentVariableSetupTypeProperties = original.EnvironmentVariableSetupTypeProperties
type ExcelDataset = original.ExcelDataset
type ExcelDatasetTypeProperties = original.ExcelDatasetTypeProperties
type ExcelSource = original.ExcelSource
type ExecuteDataFlowActivity = original.ExecuteDataFlowActivity
type ExecuteDataFlowActivityTypeProperties = original.ExecuteDataFlowActivityTypeProperties
type ExecuteDataFlowActivityTypePropertiesCompute = original.ExecuteDataFlowActivityTypePropertiesCompute
type ExecutePipelineActivity = original.ExecutePipelineActivity
type ExecutePipelineActivityTypeProperties = original.ExecutePipelineActivityTypeProperties
type ExecutePowerQueryActivityTypeProperties = original.ExecutePowerQueryActivityTypeProperties
type ExecuteSSISPackageActivity = original.ExecuteSSISPackageActivity
type ExecuteSSISPackageActivityTypeProperties = original.ExecuteSSISPackageActivityTypeProperties
type ExecuteWranglingDataflowActivity = original.ExecuteWranglingDataflowActivity
type ExecutionActivity = original.ExecutionActivity
type ExportSettings = original.ExportSettings
type ExposureControlBatchRequest = original.ExposureControlBatchRequest
type ExposureControlBatchResponse = original.ExposureControlBatchResponse
type ExposureControlClient = original.ExposureControlClient
type ExposureControlRequest = original.ExposureControlRequest
type ExposureControlResponse = original.ExposureControlResponse
type Expression = original.Expression
type FactoriesClient = original.FactoriesClient
type Factory = original.Factory
type FactoryGitHubConfiguration = original.FactoryGitHubConfiguration
type FactoryIdentity = original.FactoryIdentity
type FactoryListResponse = original.FactoryListResponse
type FactoryListResponseIterator = original.FactoryListResponseIterator
type FactoryListResponsePage = original.FactoryListResponsePage
type FactoryProperties = original.FactoryProperties
type FactoryRepoConfiguration = original.FactoryRepoConfiguration
type FactoryRepoUpdate = original.FactoryRepoUpdate
type FactoryUpdateParameters = original.FactoryUpdateParameters
type FactoryVSTSConfiguration = original.FactoryVSTSConfiguration
type FileServerLinkedService = original.FileServerLinkedService
type FileServerLinkedServiceTypeProperties = original.FileServerLinkedServiceTypeProperties
type FileServerLocation = original.FileServerLocation
type FileServerReadSettings = original.FileServerReadSettings
type FileServerWriteSettings = original.FileServerWriteSettings
type FileShareDataset = original.FileShareDataset
type FileShareDatasetTypeProperties = original.FileShareDatasetTypeProperties
type FileSystemSink = original.FileSystemSink
type FileSystemSource = original.FileSystemSource
type FilterActivity = original.FilterActivity
type FilterActivityTypeProperties = original.FilterActivityTypeProperties
type ForEachActivity = original.ForEachActivity
type ForEachActivityTypeProperties = original.ForEachActivityTypeProperties
type FormatReadSettings = original.FormatReadSettings
type FormatWriteSettings = original.FormatWriteSettings
type FtpReadSettings = original.FtpReadSettings
type FtpServerLinkedService = original.FtpServerLinkedService
type FtpServerLinkedServiceTypeProperties = original.FtpServerLinkedServiceTypeProperties
type FtpServerLocation = original.FtpServerLocation
type GenericDatasetTypeProperties = original.GenericDatasetTypeProperties
type GetDataFactoryOperationStatusResponse = original.GetDataFactoryOperationStatusResponse
type GetMetadataActivity = original.GetMetadataActivity
type GetMetadataActivityTypeProperties = original.GetMetadataActivityTypeProperties
type GetSsisObjectMetadataRequest = original.GetSsisObjectMetadataRequest
type GitHubAccessTokenRequest = original.GitHubAccessTokenRequest
type GitHubAccessTokenResponse = original.GitHubAccessTokenResponse
type GitHubClientSecret = original.GitHubClientSecret
type GlobalParameterSpecification = original.GlobalParameterSpecification
type GoogleAdWordsLinkedService = original.GoogleAdWordsLinkedService
type GoogleAdWordsLinkedServiceTypeProperties = original.GoogleAdWordsLinkedServiceTypeProperties
type GoogleAdWordsObjectDataset = original.GoogleAdWordsObjectDataset
type GoogleAdWordsSource = original.GoogleAdWordsSource
type GoogleBigQueryDatasetTypeProperties = original.GoogleBigQueryDatasetTypeProperties
type GoogleBigQueryLinkedService = original.GoogleBigQueryLinkedService
type GoogleBigQueryLinkedServiceTypeProperties = original.GoogleBigQueryLinkedServiceTypeProperties
type GoogleBigQueryObjectDataset = original.GoogleBigQueryObjectDataset
type GoogleBigQuerySource = original.GoogleBigQuerySource
type GoogleCloudStorageLinkedService = original.GoogleCloudStorageLinkedService
type GoogleCloudStorageLinkedServiceTypeProperties = original.GoogleCloudStorageLinkedServiceTypeProperties
type GoogleCloudStorageLocation = original.GoogleCloudStorageLocation
type GoogleCloudStorageReadSettings = original.GoogleCloudStorageReadSettings
type GreenplumDatasetTypeProperties = original.GreenplumDatasetTypeProperties
type GreenplumLinkedService = original.GreenplumLinkedService
type GreenplumLinkedServiceTypeProperties = original.GreenplumLinkedServiceTypeProperties
type GreenplumSource = original.GreenplumSource
type GreenplumTableDataset = original.GreenplumTableDataset
type HBaseLinkedService = original.HBaseLinkedService
type HBaseLinkedServiceTypeProperties = original.HBaseLinkedServiceTypeProperties
type HBaseObjectDataset = original.HBaseObjectDataset
type HBaseSource = original.HBaseSource
type HDInsightHiveActivity = original.HDInsightHiveActivity
type HDInsightHiveActivityTypeProperties = original.HDInsightHiveActivityTypeProperties
type HDInsightLinkedService = original.HDInsightLinkedService
type HDInsightLinkedServiceTypeProperties = original.HDInsightLinkedServiceTypeProperties
type HDInsightMapReduceActivity = original.HDInsightMapReduceActivity
type HDInsightMapReduceActivityTypeProperties = original.HDInsightMapReduceActivityTypeProperties
type HDInsightOnDemandLinkedService = original.HDInsightOnDemandLinkedService
type HDInsightOnDemandLinkedServiceTypeProperties = original.HDInsightOnDemandLinkedServiceTypeProperties
type HDInsightPigActivity = original.HDInsightPigActivity
type HDInsightPigActivityTypeProperties = original.HDInsightPigActivityTypeProperties
type HDInsightSparkActivity = original.HDInsightSparkActivity
type HDInsightSparkActivityTypeProperties = original.HDInsightSparkActivityTypeProperties
type HDInsightStreamingActivity = original.HDInsightStreamingActivity
type HDInsightStreamingActivityTypeProperties = original.HDInsightStreamingActivityTypeProperties
type HTTPDataset = original.HTTPDataset
type HTTPDatasetTypeProperties = original.HTTPDatasetTypeProperties
type HTTPLinkedService = original.HTTPLinkedService
type HTTPLinkedServiceTypeProperties = original.HTTPLinkedServiceTypeProperties
type HTTPReadSettings = original.HTTPReadSettings
type HTTPServerLocation = original.HTTPServerLocation
type HTTPSource = original.HTTPSource
type HdfsLinkedService = original.HdfsLinkedService
type HdfsLinkedServiceTypeProperties = original.HdfsLinkedServiceTypeProperties
type HdfsLocation = original.HdfsLocation
type HdfsReadSettings = original.HdfsReadSettings
type HdfsSource = original.HdfsSource
type HiveDatasetTypeProperties = original.HiveDatasetTypeProperties
type HiveLinkedService = original.HiveLinkedService
type HiveLinkedServiceTypeProperties = original.HiveLinkedServiceTypeProperties
type HiveObjectDataset = original.HiveObjectDataset
type HiveSource = original.HiveSource
type HubspotLinkedService = original.HubspotLinkedService
type HubspotLinkedServiceTypeProperties = original.HubspotLinkedServiceTypeProperties
type HubspotObjectDataset = original.HubspotObjectDataset
type HubspotSource = original.HubspotSource
type IfConditionActivity = original.IfConditionActivity
type IfConditionActivityTypeProperties = original.IfConditionActivityTypeProperties
type ImpalaDatasetTypeProperties = original.ImpalaDatasetTypeProperties
type ImpalaLinkedService = original.ImpalaLinkedService
type ImpalaLinkedServiceTypeProperties = original.ImpalaLinkedServiceTypeProperties
type ImpalaObjectDataset = original.ImpalaObjectDataset
type ImpalaSource = original.ImpalaSource
type ImportSettings = original.ImportSettings
type InformixLinkedService = original.InformixLinkedService
type InformixLinkedServiceTypeProperties = original.InformixLinkedServiceTypeProperties
type InformixSink = original.InformixSink
type InformixSource = original.InformixSource
type InformixTableDataset = original.InformixTableDataset
type InformixTableDatasetTypeProperties = original.InformixTableDatasetTypeProperties
type IntegrationRuntime = original.IntegrationRuntime
type IntegrationRuntimeAuthKeys = original.IntegrationRuntimeAuthKeys
type IntegrationRuntimeComputeProperties = original.IntegrationRuntimeComputeProperties
type IntegrationRuntimeConnectionInfo = original.IntegrationRuntimeConnectionInfo
type IntegrationRuntimeCustomSetupScriptProperties = original.IntegrationRuntimeCustomSetupScriptProperties
type IntegrationRuntimeDataFlowProperties = original.IntegrationRuntimeDataFlowProperties
type IntegrationRuntimeDataProxyProperties = original.IntegrationRuntimeDataProxyProperties
type IntegrationRuntimeDebugResource = original.IntegrationRuntimeDebugResource
type IntegrationRuntimeListResponse = original.IntegrationRuntimeListResponse
type IntegrationRuntimeListResponseIterator = original.IntegrationRuntimeListResponseIterator
type IntegrationRuntimeListResponsePage = original.IntegrationRuntimeListResponsePage
type IntegrationRuntimeMonitoringData = original.IntegrationRuntimeMonitoringData
type IntegrationRuntimeNodeIPAddress = original.IntegrationRuntimeNodeIPAddress
type IntegrationRuntimeNodeMonitoringData = original.IntegrationRuntimeNodeMonitoringData
type IntegrationRuntimeNodesClient = original.IntegrationRuntimeNodesClient
type IntegrationRuntimeObjectMetadataClient = original.IntegrationRuntimeObjectMetadataClient
type IntegrationRuntimeObjectMetadataRefreshFuture = original.IntegrationRuntimeObjectMetadataRefreshFuture
type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint = original.IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint
type IntegrationRuntimeOutboundNetworkDependenciesEndpoint = original.IntegrationRuntimeOutboundNetworkDependenciesEndpoint
type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails = original.IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails
type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse = original.IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse
type IntegrationRuntimeReference = original.IntegrationRuntimeReference
type IntegrationRuntimeRegenerateKeyParameters = original.IntegrationRuntimeRegenerateKeyParameters
type IntegrationRuntimeResource = original.IntegrationRuntimeResource
type IntegrationRuntimeSsisCatalogInfo = original.IntegrationRuntimeSsisCatalogInfo
type IntegrationRuntimeSsisProperties = original.IntegrationRuntimeSsisProperties
type IntegrationRuntimeStatus = original.IntegrationRuntimeStatus
type IntegrationRuntimeStatusListResponse = original.IntegrationRuntimeStatusListResponse
type IntegrationRuntimeStatusResponse = original.IntegrationRuntimeStatusResponse
type IntegrationRuntimeVNetProperties = original.IntegrationRuntimeVNetProperties
type IntegrationRuntimesClient = original.IntegrationRuntimesClient
type IntegrationRuntimesStartFuture = original.IntegrationRuntimesStartFuture
type IntegrationRuntimesStopFuture = original.IntegrationRuntimesStopFuture
type JSONDataset = original.JSONDataset
type JSONDatasetTypeProperties = original.JSONDatasetTypeProperties
type JSONFormat = original.JSONFormat
type JSONReadSettings = original.JSONReadSettings
type JSONSink = original.JSONSink
type JSONSource = original.JSONSource
type JSONWriteSettings = original.JSONWriteSettings
type JiraLinkedService = original.JiraLinkedService
type JiraLinkedServiceTypeProperties = original.JiraLinkedServiceTypeProperties
type JiraObjectDataset = original.JiraObjectDataset
type JiraSource = original.JiraSource
type LicensedComponentSetupTypeProperties = original.LicensedComponentSetupTypeProperties
type LinkedIntegrationRuntime = original.LinkedIntegrationRuntime
type LinkedIntegrationRuntimeKeyAuthorization = original.LinkedIntegrationRuntimeKeyAuthorization
type LinkedIntegrationRuntimeRbacAuthorization = original.LinkedIntegrationRuntimeRbacAuthorization
type LinkedIntegrationRuntimeRequest = original.LinkedIntegrationRuntimeRequest
type LinkedIntegrationRuntimeType = original.LinkedIntegrationRuntimeType
type LinkedService = original.LinkedService
type LinkedServiceDebugResource = original.LinkedServiceDebugResource
type LinkedServiceListResponse = original.LinkedServiceListResponse
type LinkedServiceListResponseIterator = original.LinkedServiceListResponseIterator
type LinkedServiceListResponsePage = original.LinkedServiceListResponsePage
type LinkedServiceReference = original.LinkedServiceReference
type LinkedServiceResource = original.LinkedServiceResource
type LinkedServicesClient = original.LinkedServicesClient
type LogLocationSettings = original.LogLocationSettings
type LogSettings = original.LogSettings
type LogStorageSettings = original.LogStorageSettings
type LookupActivity = original.LookupActivity
type LookupActivityTypeProperties = original.LookupActivityTypeProperties
type MagentoLinkedService = original.MagentoLinkedService
type MagentoLinkedServiceTypeProperties = original.MagentoLinkedServiceTypeProperties
type MagentoObjectDataset = original.MagentoObjectDataset
type MagentoSource = original.MagentoSource
type ManagedIdentityCredential = original.ManagedIdentityCredential
type ManagedIdentityTypeProperties = original.ManagedIdentityTypeProperties
type ManagedIntegrationRuntime = original.ManagedIntegrationRuntime
type ManagedIntegrationRuntimeError = original.ManagedIntegrationRuntimeError
type ManagedIntegrationRuntimeNode = original.ManagedIntegrationRuntimeNode
type ManagedIntegrationRuntimeOperationResult = original.ManagedIntegrationRuntimeOperationResult
type ManagedIntegrationRuntimeStatus = original.ManagedIntegrationRuntimeStatus
type ManagedIntegrationRuntimeStatusTypeProperties = original.ManagedIntegrationRuntimeStatusTypeProperties
type ManagedIntegrationRuntimeTypeProperties = original.ManagedIntegrationRuntimeTypeProperties
type ManagedPrivateEndpoint = original.ManagedPrivateEndpoint
type ManagedPrivateEndpointListResponse = original.ManagedPrivateEndpointListResponse
type ManagedPrivateEndpointListResponseIterator = original.ManagedPrivateEndpointListResponseIterator
type ManagedPrivateEndpointListResponsePage = original.ManagedPrivateEndpointListResponsePage
type ManagedPrivateEndpointResource = original.ManagedPrivateEndpointResource
type ManagedPrivateEndpointsClient = original.ManagedPrivateEndpointsClient
type ManagedVirtualNetwork = original.ManagedVirtualNetwork
type ManagedVirtualNetworkListResponse = original.ManagedVirtualNetworkListResponse
type ManagedVirtualNetworkListResponseIterator = original.ManagedVirtualNetworkListResponseIterator
type ManagedVirtualNetworkListResponsePage = original.ManagedVirtualNetworkListResponsePage
type ManagedVirtualNetworkReference = original.ManagedVirtualNetworkReference
type ManagedVirtualNetworkResource = original.ManagedVirtualNetworkResource
type ManagedVirtualNetworksClient = original.ManagedVirtualNetworksClient
type MappingDataFlow = original.MappingDataFlow
type MappingDataFlowTypeProperties = original.MappingDataFlowTypeProperties
type MariaDBLinkedService = original.MariaDBLinkedService
type MariaDBLinkedServiceTypeProperties = original.MariaDBLinkedServiceTypeProperties
type MariaDBSource = original.MariaDBSource
type MariaDBTableDataset = original.MariaDBTableDataset
type MarketoLinkedService = original.MarketoLinkedService
type MarketoLinkedServiceTypeProperties = original.MarketoLinkedServiceTypeProperties
type MarketoObjectDataset = original.MarketoObjectDataset
type MarketoSource = original.MarketoSource
type MetadataItem = original.MetadataItem
type MicrosoftAccessLinkedService = original.MicrosoftAccessLinkedService
type MicrosoftAccessLinkedServiceTypeProperties = original.MicrosoftAccessLinkedServiceTypeProperties
type MicrosoftAccessSink = original.MicrosoftAccessSink
type MicrosoftAccessSource = original.MicrosoftAccessSource
type MicrosoftAccessTableDataset = original.MicrosoftAccessTableDataset
type MicrosoftAccessTableDatasetTypeProperties = original.MicrosoftAccessTableDatasetTypeProperties
type MongoDbAtlasCollectionDataset = original.MongoDbAtlasCollectionDataset
type MongoDbAtlasCollectionDatasetTypeProperties = original.MongoDbAtlasCollectionDatasetTypeProperties
type MongoDbAtlasLinkedService = original.MongoDbAtlasLinkedService
type MongoDbAtlasLinkedServiceTypeProperties = original.MongoDbAtlasLinkedServiceTypeProperties
type MongoDbAtlasSink = original.MongoDbAtlasSink
type MongoDbAtlasSource = original.MongoDbAtlasSource
type MongoDbCollectionDataset = original.MongoDbCollectionDataset
type MongoDbCollectionDatasetTypeProperties = original.MongoDbCollectionDatasetTypeProperties
type MongoDbCursorMethodsProperties = original.MongoDbCursorMethodsProperties
type MongoDbLinkedService = original.MongoDbLinkedService
type MongoDbLinkedServiceTypeProperties = original.MongoDbLinkedServiceTypeProperties
type MongoDbSource = original.MongoDbSource
type MongoDbV2CollectionDataset = original.MongoDbV2CollectionDataset
type MongoDbV2CollectionDatasetTypeProperties = original.MongoDbV2CollectionDatasetTypeProperties
type MongoDbV2LinkedService = original.MongoDbV2LinkedService
type MongoDbV2LinkedServiceTypeProperties = original.MongoDbV2LinkedServiceTypeProperties
type MongoDbV2Sink = original.MongoDbV2Sink
type MongoDbV2Source = original.MongoDbV2Source
type MultiplePipelineTrigger = original.MultiplePipelineTrigger
type MySQLLinkedService = original.MySQLLinkedService
type MySQLLinkedServiceTypeProperties = original.MySQLLinkedServiceTypeProperties
type MySQLSource = original.MySQLSource
type MySQLTableDataset = original.MySQLTableDataset
type MySQLTableDatasetTypeProperties = original.MySQLTableDatasetTypeProperties
type NetezzaLinkedService = original.NetezzaLinkedService
type NetezzaLinkedServiceTypeProperties = original.NetezzaLinkedServiceTypeProperties
type NetezzaPartitionSettings = original.NetezzaPartitionSettings
type NetezzaSource = original.NetezzaSource
type NetezzaTableDataset = original.NetezzaTableDataset
type NetezzaTableDatasetTypeProperties = original.NetezzaTableDatasetTypeProperties
type ODataLinkedService = original.ODataLinkedService
type ODataLinkedServiceTypeProperties = original.ODataLinkedServiceTypeProperties
type ODataResourceDataset = original.ODataResourceDataset
type ODataResourceDatasetTypeProperties = original.ODataResourceDatasetTypeProperties
type ODataSource = original.ODataSource
type OdbcLinkedService = original.OdbcLinkedService
type OdbcLinkedServiceTypeProperties = original.OdbcLinkedServiceTypeProperties
type OdbcSink = original.OdbcSink
type OdbcSource = original.OdbcSource
type OdbcTableDataset = original.OdbcTableDataset
type OdbcTableDatasetTypeProperties = original.OdbcTableDatasetTypeProperties
type Office365Dataset = original.Office365Dataset
type Office365DatasetTypeProperties = original.Office365DatasetTypeProperties
type Office365LinkedService = original.Office365LinkedService
type Office365LinkedServiceTypeProperties = original.Office365LinkedServiceTypeProperties
type Office365Source = original.Office365Source
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResponse = original.OperationListResponse
type OperationListResponseIterator = original.OperationListResponseIterator
type OperationListResponsePage = original.OperationListResponsePage
type OperationLogSpecification = original.OperationLogSpecification
type OperationMetricAvailability = original.OperationMetricAvailability
type OperationMetricDimension = original.OperationMetricDimension
type OperationMetricSpecification = original.OperationMetricSpecification
type OperationProperties = original.OperationProperties
type OperationServiceSpecification = original.OperationServiceSpecification
type OperationsClient = original.OperationsClient
type OracleCloudStorageLinkedService = original.OracleCloudStorageLinkedService
type OracleCloudStorageLinkedServiceTypeProperties = original.OracleCloudStorageLinkedServiceTypeProperties
type OracleCloudStorageLocation = original.OracleCloudStorageLocation
type OracleCloudStorageReadSettings = original.OracleCloudStorageReadSettings
type OracleLinkedService = original.OracleLinkedService
type OracleLinkedServiceTypeProperties = original.OracleLinkedServiceTypeProperties
type OraclePartitionSettings = original.OraclePartitionSettings
type OracleServiceCloudLinkedService = original.OracleServiceCloudLinkedService
type OracleServiceCloudLinkedServiceTypeProperties = original.OracleServiceCloudLinkedServiceTypeProperties
type OracleServiceCloudObjectDataset = original.OracleServiceCloudObjectDataset
type OracleServiceCloudSource = original.OracleServiceCloudSource
type OracleSink = original.OracleSink
type OracleSource = original.OracleSource
type OracleTableDataset = original.OracleTableDataset
type OracleTableDatasetTypeProperties = original.OracleTableDatasetTypeProperties
type OrcDataset = original.OrcDataset
type OrcDatasetTypeProperties = original.OrcDatasetTypeProperties
type OrcFormat = original.OrcFormat
type OrcSink = original.OrcSink
type OrcSource = original.OrcSource
type OrcWriteSettings = original.OrcWriteSettings
type PackageStore = original.PackageStore
type ParameterSpecification = original.ParameterSpecification
type ParquetDataset = original.ParquetDataset
type ParquetDatasetTypeProperties = original.ParquetDatasetTypeProperties
type ParquetFormat = original.ParquetFormat
type ParquetSink = original.ParquetSink
type ParquetSource = original.ParquetSource
type ParquetWriteSettings = original.ParquetWriteSettings
type PaypalLinkedService = original.PaypalLinkedService
type PaypalLinkedServiceTypeProperties = original.PaypalLinkedServiceTypeProperties
type PaypalObjectDataset = original.PaypalObjectDataset
type PaypalSource = original.PaypalSource
type PhoenixDatasetTypeProperties = original.PhoenixDatasetTypeProperties
type PhoenixLinkedService = original.PhoenixLinkedService
type PhoenixLinkedServiceTypeProperties = original.PhoenixLinkedServiceTypeProperties
type PhoenixObjectDataset = original.PhoenixObjectDataset
type PhoenixSource = original.PhoenixSource
type Pipeline = original.Pipeline
type PipelineElapsedTimeMetricPolicy = original.PipelineElapsedTimeMetricPolicy
type PipelineFolder = original.PipelineFolder
type PipelineListResponse = original.PipelineListResponse
type PipelineListResponseIterator = original.PipelineListResponseIterator
type PipelineListResponsePage = original.PipelineListResponsePage
type PipelinePolicy = original.PipelinePolicy
type PipelineReference = original.PipelineReference
type PipelineResource = original.PipelineResource
type PipelineRun = original.PipelineRun
type PipelineRunInvokedBy = original.PipelineRunInvokedBy
type PipelineRunsClient = original.PipelineRunsClient
type PipelineRunsQueryResponse = original.PipelineRunsQueryResponse
type PipelinesClient = original.PipelinesClient
type PolybaseSettings = original.PolybaseSettings
type PostgreSQLLinkedService = original.PostgreSQLLinkedService
type PostgreSQLLinkedServiceTypeProperties = original.PostgreSQLLinkedServiceTypeProperties
type PostgreSQLSource = original.PostgreSQLSource
type PostgreSQLTableDataset = original.PostgreSQLTableDataset
type PostgreSQLTableDatasetTypeProperties = original.PostgreSQLTableDatasetTypeProperties
type PowerQuerySink = original.PowerQuerySink
type PowerQuerySource = original.PowerQuerySource
type PowerQueryTypeProperties = original.PowerQueryTypeProperties
type PrestoDatasetTypeProperties = original.PrestoDatasetTypeProperties
type PrestoLinkedService = original.PrestoLinkedService
type PrestoLinkedServiceTypeProperties = original.PrestoLinkedServiceTypeProperties
type PrestoObjectDataset = original.PrestoObjectDataset
type PrestoSource = original.PrestoSource
type PrivateEndPointConnectionsClient = original.PrivateEndPointConnectionsClient
type PrivateEndpointConnectionClient = original.PrivateEndpointConnectionClient
type PrivateEndpointConnectionListResponse = original.PrivateEndpointConnectionListResponse
type PrivateEndpointConnectionListResponseIterator = original.PrivateEndpointConnectionListResponseIterator
type PrivateEndpointConnectionListResponsePage = original.PrivateEndpointConnectionListResponsePage
type PrivateEndpointConnectionResource = original.PrivateEndpointConnectionResource
type PrivateLinkConnectionApprovalRequest = original.PrivateLinkConnectionApprovalRequest
type PrivateLinkConnectionApprovalRequestResource = original.PrivateLinkConnectionApprovalRequestResource
type PrivateLinkConnectionState = original.PrivateLinkConnectionState
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkResourcesWrapper = original.PrivateLinkResourcesWrapper
type QueryDataFlowDebugSessionsResponse = original.QueryDataFlowDebugSessionsResponse
type QueryDataFlowDebugSessionsResponseIterator = original.QueryDataFlowDebugSessionsResponseIterator
type QueryDataFlowDebugSessionsResponsePage = original.QueryDataFlowDebugSessionsResponsePage
type QuickBooksLinkedService = original.QuickBooksLinkedService
type QuickBooksLinkedServiceTypeProperties = original.QuickBooksLinkedServiceTypeProperties
type QuickBooksObjectDataset = original.QuickBooksObjectDataset
type QuickBooksSource = original.QuickBooksSource
type RecurrenceSchedule = original.RecurrenceSchedule
type RecurrenceScheduleOccurrence = original.RecurrenceScheduleOccurrence
type RedirectIncompatibleRowSettings = original.RedirectIncompatibleRowSettings
type RedshiftUnloadSettings = original.RedshiftUnloadSettings
type RelationalSource = original.RelationalSource
type RelationalTableDataset = original.RelationalTableDataset
type RelationalTableDatasetTypeProperties = original.RelationalTableDatasetTypeProperties
type RemotePrivateEndpointConnection = original.RemotePrivateEndpointConnection
type RerunTumblingWindowTrigger = original.RerunTumblingWindowTrigger
type RerunTumblingWindowTriggerTypeProperties = original.RerunTumblingWindowTriggerTypeProperties
type Resource = original.Resource
type ResponsysLinkedService = original.ResponsysLinkedService
type ResponsysLinkedServiceTypeProperties = original.ResponsysLinkedServiceTypeProperties
type ResponsysObjectDataset = original.ResponsysObjectDataset
type ResponsysSource = original.ResponsysSource
type RestResourceDataset = original.RestResourceDataset
type RestResourceDatasetTypeProperties = original.RestResourceDatasetTypeProperties
type RestServiceLinkedService = original.RestServiceLinkedService
type RestServiceLinkedServiceTypeProperties = original.RestServiceLinkedServiceTypeProperties
type RestSink = original.RestSink
type RestSource = original.RestSource
type RetryPolicy = original.RetryPolicy
type RunFilterParameters = original.RunFilterParameters
type RunQueryFilter = original.RunQueryFilter
type RunQueryOrderBy = original.RunQueryOrderBy
type SQLAlwaysEncryptedProperties = original.SQLAlwaysEncryptedProperties
type SQLDWSink = original.SQLDWSink
type SQLDWSource = original.SQLDWSource
type SQLDWUpsertSettings = original.SQLDWUpsertSettings
type SQLMISink = original.SQLMISink
type SQLMISource = original.SQLMISource
type SQLPartitionSettings = original.SQLPartitionSettings
type SQLServerLinkedService = original.SQLServerLinkedService
type SQLServerLinkedServiceTypeProperties = original.SQLServerLinkedServiceTypeProperties
type SQLServerSink = original.SQLServerSink
type SQLServerSource = original.SQLServerSource
type SQLServerStoredProcedureActivity = original.SQLServerStoredProcedureActivity
type SQLServerStoredProcedureActivityTypeProperties = original.SQLServerStoredProcedureActivityTypeProperties
type SQLServerTableDataset = original.SQLServerTableDataset
type SQLServerTableDatasetTypeProperties = original.SQLServerTableDatasetTypeProperties
type SQLSink = original.SQLSink
type SQLSource = original.SQLSource
type SQLUpsertSettings = original.SQLUpsertSettings
type SSISAccessCredential = original.SSISAccessCredential
type SSISChildPackage = original.SSISChildPackage
type SSISExecutionCredential = original.SSISExecutionCredential
type SSISExecutionParameter = original.SSISExecutionParameter
type SSISLogLocation = original.SSISLogLocation
type SSISLogLocationTypeProperties = original.SSISLogLocationTypeProperties
type SSISPackageLocation = original.SSISPackageLocation
type SSISPackageLocationTypeProperties = original.SSISPackageLocationTypeProperties
type SSISPropertyOverride = original.SSISPropertyOverride
type SalesforceLinkedService = original.SalesforceLinkedService
type SalesforceLinkedServiceTypeProperties = original.SalesforceLinkedServiceTypeProperties
type SalesforceMarketingCloudLinkedService = original.SalesforceMarketingCloudLinkedService
type SalesforceMarketingCloudLinkedServiceTypeProperties = original.SalesforceMarketingCloudLinkedServiceTypeProperties
type SalesforceMarketingCloudObjectDataset = original.SalesforceMarketingCloudObjectDataset
type SalesforceMarketingCloudSource = original.SalesforceMarketingCloudSource
type SalesforceObjectDataset = original.SalesforceObjectDataset
type SalesforceObjectDatasetTypeProperties = original.SalesforceObjectDatasetTypeProperties
type SalesforceServiceCloudLinkedService = original.SalesforceServiceCloudLinkedService
type SalesforceServiceCloudLinkedServiceTypeProperties = original.SalesforceServiceCloudLinkedServiceTypeProperties
type SalesforceServiceCloudObjectDataset = original.SalesforceServiceCloudObjectDataset
type SalesforceServiceCloudObjectDatasetTypeProperties = original.SalesforceServiceCloudObjectDatasetTypeProperties
type SalesforceServiceCloudSink = original.SalesforceServiceCloudSink
type SalesforceServiceCloudSource = original.SalesforceServiceCloudSource
type SalesforceSink = original.SalesforceSink
type SalesforceSource = original.SalesforceSource
type SapBWLinkedService = original.SapBWLinkedService
type SapBWLinkedServiceTypeProperties = original.SapBWLinkedServiceTypeProperties
type SapBwCubeDataset = original.SapBwCubeDataset
type SapBwSource = original.SapBwSource
type SapCloudForCustomerLinkedService = original.SapCloudForCustomerLinkedService
type SapCloudForCustomerLinkedServiceTypeProperties = original.SapCloudForCustomerLinkedServiceTypeProperties
type SapCloudForCustomerResourceDataset = original.SapCloudForCustomerResourceDataset
type SapCloudForCustomerResourceDatasetTypeProperties = original.SapCloudForCustomerResourceDatasetTypeProperties
type SapCloudForCustomerSink = original.SapCloudForCustomerSink
type SapCloudForCustomerSource = original.SapCloudForCustomerSource
type SapEccLinkedService = original.SapEccLinkedService
type SapEccLinkedServiceTypeProperties = original.SapEccLinkedServiceTypeProperties
type SapEccResourceDataset = original.SapEccResourceDataset
type SapEccResourceDatasetTypeProperties = original.SapEccResourceDatasetTypeProperties
type SapEccSource = original.SapEccSource
type SapHanaLinkedService = original.SapHanaLinkedService
type SapHanaLinkedServiceProperties = original.SapHanaLinkedServiceProperties
type SapHanaPartitionSettings = original.SapHanaPartitionSettings
type SapHanaSource = original.SapHanaSource
type SapHanaTableDataset = original.SapHanaTableDataset
type SapHanaTableDatasetTypeProperties = original.SapHanaTableDatasetTypeProperties
type SapOpenHubLinkedService = original.SapOpenHubLinkedService
type SapOpenHubLinkedServiceTypeProperties = original.SapOpenHubLinkedServiceTypeProperties
type SapOpenHubSource = original.SapOpenHubSource
type SapOpenHubTableDataset = original.SapOpenHubTableDataset
type SapOpenHubTableDatasetTypeProperties = original.SapOpenHubTableDatasetTypeProperties
type SapTableLinkedService = original.SapTableLinkedService
type SapTableLinkedServiceTypeProperties = original.SapTableLinkedServiceTypeProperties
type SapTablePartitionSettings = original.SapTablePartitionSettings
type SapTableResourceDataset = original.SapTableResourceDataset
type SapTableResourceDatasetTypeProperties = original.SapTableResourceDatasetTypeProperties
type SapTableSource = original.SapTableSource
type ScheduleTrigger = original.ScheduleTrigger
type ScheduleTriggerRecurrence = original.ScheduleTriggerRecurrence
type ScheduleTriggerTypeProperties = original.ScheduleTriggerTypeProperties
type ScriptAction = original.ScriptAction
type SecretBase = original.SecretBase
type SecureString = original.SecureString
type SelfDependencyTumblingWindowTriggerReference = original.SelfDependencyTumblingWindowTriggerReference
type SelfHostedIntegrationRuntime = original.SelfHostedIntegrationRuntime
type SelfHostedIntegrationRuntimeNode = original.SelfHostedIntegrationRuntimeNode
type SelfHostedIntegrationRuntimeStatus = original.SelfHostedIntegrationRuntimeStatus
type SelfHostedIntegrationRuntimeStatusTypeProperties = original.SelfHostedIntegrationRuntimeStatusTypeProperties
type SelfHostedIntegrationRuntimeTypeProperties = original.SelfHostedIntegrationRuntimeTypeProperties
type ServiceNowLinkedService = original.ServiceNowLinkedService
type ServiceNowLinkedServiceTypeProperties = original.ServiceNowLinkedServiceTypeProperties
type ServiceNowObjectDataset = original.ServiceNowObjectDataset
type ServiceNowSource = original.ServiceNowSource
type ServicePrincipalCredential = original.ServicePrincipalCredential
type ServicePrincipalCredentialTypeProperties = original.ServicePrincipalCredentialTypeProperties
type SetVariableActivity = original.SetVariableActivity
type SetVariableActivityTypeProperties = original.SetVariableActivityTypeProperties
type SftpLocation = original.SftpLocation
type SftpReadSettings = original.SftpReadSettings
type SftpServerLinkedService = original.SftpServerLinkedService
type SftpServerLinkedServiceTypeProperties = original.SftpServerLinkedServiceTypeProperties
type SftpWriteSettings = original.SftpWriteSettings
type SharePointOnlineListDatasetTypeProperties = original.SharePointOnlineListDatasetTypeProperties
type SharePointOnlineListLinkedService = original.SharePointOnlineListLinkedService
type SharePointOnlineListLinkedServiceTypeProperties = original.SharePointOnlineListLinkedServiceTypeProperties
type SharePointOnlineListResourceDataset = original.SharePointOnlineListResourceDataset
type SharePointOnlineListSource = original.SharePointOnlineListSource
type ShopifyLinkedService = original.ShopifyLinkedService
type ShopifyLinkedServiceTypeProperties = original.ShopifyLinkedServiceTypeProperties
type ShopifyObjectDataset = original.ShopifyObjectDataset
type ShopifySource = original.ShopifySource
type SkipErrorFile = original.SkipErrorFile
type SnowflakeDataset = original.SnowflakeDataset
type SnowflakeDatasetTypeProperties = original.SnowflakeDatasetTypeProperties
type SnowflakeExportCopyCommand = original.SnowflakeExportCopyCommand
type SnowflakeImportCopyCommand = original.SnowflakeImportCopyCommand
type SnowflakeLinkedService = original.SnowflakeLinkedService
type SnowflakeLinkedServiceTypeProperties = original.SnowflakeLinkedServiceTypeProperties
type SnowflakeSink = original.SnowflakeSink
type SnowflakeSource = original.SnowflakeSource
type SparkDatasetTypeProperties = original.SparkDatasetTypeProperties
type SparkLinkedService = original.SparkLinkedService
type SparkLinkedServiceTypeProperties = original.SparkLinkedServiceTypeProperties
type SparkObjectDataset = original.SparkObjectDataset
type SparkSource = original.SparkSource
type SquareLinkedService = original.SquareLinkedService
type SquareLinkedServiceTypeProperties = original.SquareLinkedServiceTypeProperties
type SquareObjectDataset = original.SquareObjectDataset
type SquareSource = original.SquareSource
type SsisEnvironment = original.SsisEnvironment
type SsisEnvironmentReference = original.SsisEnvironmentReference
type SsisFolder = original.SsisFolder
type SsisObjectMetadata = original.SsisObjectMetadata
type SsisObjectMetadataListResponse = original.SsisObjectMetadataListResponse
type SsisObjectMetadataStatusResponse = original.SsisObjectMetadataStatusResponse
type SsisPackage = original.SsisPackage
type SsisParameter = original.SsisParameter
type SsisProject = original.SsisProject
type SsisVariable = original.SsisVariable
type StagingSettings = original.StagingSettings
type StoreReadSettings = original.StoreReadSettings
type StoreWriteSettings = original.StoreWriteSettings
type StoredProcedureParameter = original.StoredProcedureParameter
type SubResource = original.SubResource
type SubResourceDebugResource = original.SubResourceDebugResource
type SwitchActivity = original.SwitchActivity
type SwitchActivityTypeProperties = original.SwitchActivityTypeProperties
type SwitchCase = original.SwitchCase
type SybaseLinkedService = original.SybaseLinkedService
type SybaseLinkedServiceTypeProperties = original.SybaseLinkedServiceTypeProperties
type SybaseSource = original.SybaseSource
type SybaseTableDataset = original.SybaseTableDataset
type SybaseTableDatasetTypeProperties = original.SybaseTableDatasetTypeProperties
type TabularSource = original.TabularSource
type TabularTranslator = original.TabularTranslator
type TarGZipReadSettings = original.TarGZipReadSettings
type TarReadSettings = original.TarReadSettings
type TeradataLinkedService = original.TeradataLinkedService
type TeradataLinkedServiceTypeProperties = original.TeradataLinkedServiceTypeProperties
type TeradataPartitionSettings = original.TeradataPartitionSettings
type TeradataSource = original.TeradataSource
type TeradataTableDataset = original.TeradataTableDataset
type TeradataTableDatasetTypeProperties = original.TeradataTableDatasetTypeProperties
type TextFormat = original.TextFormat
type Transformation = original.Transformation
type Trigger = original.Trigger
type TriggerDependencyReference = original.TriggerDependencyReference
type TriggerFilterParameters = original.TriggerFilterParameters
type TriggerListResponse = original.TriggerListResponse
type TriggerListResponseIterator = original.TriggerListResponseIterator
type TriggerListResponsePage = original.TriggerListResponsePage
type TriggerPipelineReference = original.TriggerPipelineReference
type TriggerQueryResponse = original.TriggerQueryResponse
type TriggerReference = original.TriggerReference
type TriggerResource = original.TriggerResource
type TriggerRun = original.TriggerRun
type TriggerRunsClient = original.TriggerRunsClient
type TriggerRunsQueryResponse = original.TriggerRunsQueryResponse
type TriggerSubscriptionOperationStatus = original.TriggerSubscriptionOperationStatus
type TriggersClient = original.TriggersClient
type TriggersStartFuture = original.TriggersStartFuture
type TriggersStopFuture = original.TriggersStopFuture
type TriggersSubscribeToEventsFuture = original.TriggersSubscribeToEventsFuture
type TriggersUnsubscribeFromEventsFuture = original.TriggersUnsubscribeFromEventsFuture
type TumblingWindowTrigger = original.TumblingWindowTrigger
type TumblingWindowTriggerDependencyReference = original.TumblingWindowTriggerDependencyReference
type TumblingWindowTriggerTypeProperties = original.TumblingWindowTriggerTypeProperties
type TypeConversionSettings = original.TypeConversionSettings
type UntilActivity = original.UntilActivity
type UntilActivityTypeProperties = original.UntilActivityTypeProperties
type UpdateIntegrationRuntimeNodeRequest = original.UpdateIntegrationRuntimeNodeRequest
type UpdateIntegrationRuntimeRequest = original.UpdateIntegrationRuntimeRequest
type UserAccessPolicy = original.UserAccessPolicy
type UserProperty = original.UserProperty
type ValidationActivity = original.ValidationActivity
type ValidationActivityTypeProperties = original.ValidationActivityTypeProperties
type VariableSpecification = original.VariableSpecification
type VerticaDatasetTypeProperties = original.VerticaDatasetTypeProperties
type VerticaLinkedService = original.VerticaLinkedService
type VerticaLinkedServiceTypeProperties = original.VerticaLinkedServiceTypeProperties
type VerticaSource = original.VerticaSource
type VerticaTableDataset = original.VerticaTableDataset
type WaitActivity = original.WaitActivity
type WaitActivityTypeProperties = original.WaitActivityTypeProperties
type WebActivity = original.WebActivity
type WebActivityAuthentication = original.WebActivityAuthentication
type WebActivityTypeProperties = original.WebActivityTypeProperties
type WebAnonymousAuthentication = original.WebAnonymousAuthentication
type WebBasicAuthentication = original.WebBasicAuthentication
type WebClientCertificateAuthentication = original.WebClientCertificateAuthentication
type WebHookActivity = original.WebHookActivity
type WebHookActivityTypeProperties = original.WebHookActivityTypeProperties
type WebLinkedService = original.WebLinkedService
type WebLinkedServiceTypeProperties = original.WebLinkedServiceTypeProperties
type WebSource = original.WebSource
type WebTableDataset = original.WebTableDataset
type WebTableDatasetTypeProperties = original.WebTableDatasetTypeProperties
type WranglingDataFlow = original.WranglingDataFlow
type XMLDataset = original.XMLDataset
type XMLDatasetTypeProperties = original.XMLDatasetTypeProperties
type XMLReadSettings = original.XMLReadSettings
type XMLSource = original.XMLSource
type XeroLinkedService = original.XeroLinkedService
type XeroLinkedServiceTypeProperties = original.XeroLinkedServiceTypeProperties
type XeroObjectDataset = original.XeroObjectDataset
type XeroSource = original.XeroSource
type ZipDeflateReadSettings = original.ZipDeflateReadSettings
type ZohoLinkedService = original.ZohoLinkedService
type ZohoLinkedServiceTypeProperties = original.ZohoLinkedServiceTypeProperties
type ZohoObjectDataset = original.ZohoObjectDataset
type ZohoSource = original.ZohoSource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewActivityRunsClient(subscriptionID string) ActivityRunsClient {
	return original.NewActivityRunsClient(subscriptionID)
}
func NewActivityRunsClientWithBaseURI(baseURI string, subscriptionID string) ActivityRunsClient {
	return original.NewActivityRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataFlowDebugSessionClient(subscriptionID string) DataFlowDebugSessionClient {
	return original.NewDataFlowDebugSessionClient(subscriptionID)
}
func NewDataFlowDebugSessionClientWithBaseURI(baseURI string, subscriptionID string) DataFlowDebugSessionClient {
	return original.NewDataFlowDebugSessionClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataFlowListResponseIterator(page DataFlowListResponsePage) DataFlowListResponseIterator {
	return original.NewDataFlowListResponseIterator(page)
}
func NewDataFlowListResponsePage(cur DataFlowListResponse, getNextPage func(context.Context, DataFlowListResponse) (DataFlowListResponse, error)) DataFlowListResponsePage {
	return original.NewDataFlowListResponsePage(cur, getNextPage)
}
func NewDataFlowsClient(subscriptionID string) DataFlowsClient {
	return original.NewDataFlowsClient(subscriptionID)
}
func NewDataFlowsClientWithBaseURI(baseURI string, subscriptionID string) DataFlowsClient {
	return original.NewDataFlowsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatasetListResponseIterator(page DatasetListResponsePage) DatasetListResponseIterator {
	return original.NewDatasetListResponseIterator(page)
}
func NewDatasetListResponsePage(cur DatasetListResponse, getNextPage func(context.Context, DatasetListResponse) (DatasetListResponse, error)) DatasetListResponsePage {
	return original.NewDatasetListResponsePage(cur, getNextPage)
}
func NewDatasetsClient(subscriptionID string) DatasetsClient {
	return original.NewDatasetsClient(subscriptionID)
}
func NewDatasetsClientWithBaseURI(baseURI string, subscriptionID string) DatasetsClient {
	return original.NewDatasetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExposureControlClient(subscriptionID string) ExposureControlClient {
	return original.NewExposureControlClient(subscriptionID)
}
func NewExposureControlClientWithBaseURI(baseURI string, subscriptionID string) ExposureControlClient {
	return original.NewExposureControlClientWithBaseURI(baseURI, subscriptionID)
}
func NewFactoriesClient(subscriptionID string) FactoriesClient {
	return original.NewFactoriesClient(subscriptionID)
}
func NewFactoriesClientWithBaseURI(baseURI string, subscriptionID string) FactoriesClient {
	return original.NewFactoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFactoryListResponseIterator(page FactoryListResponsePage) FactoryListResponseIterator {
	return original.NewFactoryListResponseIterator(page)
}
func NewFactoryListResponsePage(cur FactoryListResponse, getNextPage func(context.Context, FactoryListResponse) (FactoryListResponse, error)) FactoryListResponsePage {
	return original.NewFactoryListResponsePage(cur, getNextPage)
}
func NewIntegrationRuntimeListResponseIterator(page IntegrationRuntimeListResponsePage) IntegrationRuntimeListResponseIterator {
	return original.NewIntegrationRuntimeListResponseIterator(page)
}
func NewIntegrationRuntimeListResponsePage(cur IntegrationRuntimeListResponse, getNextPage func(context.Context, IntegrationRuntimeListResponse) (IntegrationRuntimeListResponse, error)) IntegrationRuntimeListResponsePage {
	return original.NewIntegrationRuntimeListResponsePage(cur, getNextPage)
}
func NewIntegrationRuntimeNodesClient(subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClient(subscriptionID)
}
func NewIntegrationRuntimeNodesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeObjectMetadataClient(subscriptionID string) IntegrationRuntimeObjectMetadataClient {
	return original.NewIntegrationRuntimeObjectMetadataClient(subscriptionID)
}
func NewIntegrationRuntimeObjectMetadataClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeObjectMetadataClient {
	return original.NewIntegrationRuntimeObjectMetadataClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimesClient(subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClient(subscriptionID)
}
func NewIntegrationRuntimesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLinkedServiceListResponseIterator(page LinkedServiceListResponsePage) LinkedServiceListResponseIterator {
	return original.NewLinkedServiceListResponseIterator(page)
}
func NewLinkedServiceListResponsePage(cur LinkedServiceListResponse, getNextPage func(context.Context, LinkedServiceListResponse) (LinkedServiceListResponse, error)) LinkedServiceListResponsePage {
	return original.NewLinkedServiceListResponsePage(cur, getNextPage)
}
func NewLinkedServicesClient(subscriptionID string) LinkedServicesClient {
	return original.NewLinkedServicesClient(subscriptionID)
}
func NewLinkedServicesClientWithBaseURI(baseURI string, subscriptionID string) LinkedServicesClient {
	return original.NewLinkedServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagedPrivateEndpointListResponseIterator(page ManagedPrivateEndpointListResponsePage) ManagedPrivateEndpointListResponseIterator {
	return original.NewManagedPrivateEndpointListResponseIterator(page)
}
func NewManagedPrivateEndpointListResponsePage(cur ManagedPrivateEndpointListResponse, getNextPage func(context.Context, ManagedPrivateEndpointListResponse) (ManagedPrivateEndpointListResponse, error)) ManagedPrivateEndpointListResponsePage {
	return original.NewManagedPrivateEndpointListResponsePage(cur, getNextPage)
}
func NewManagedPrivateEndpointsClient(subscriptionID string) ManagedPrivateEndpointsClient {
	return original.NewManagedPrivateEndpointsClient(subscriptionID)
}
func NewManagedPrivateEndpointsClientWithBaseURI(baseURI string, subscriptionID string) ManagedPrivateEndpointsClient {
	return original.NewManagedPrivateEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagedVirtualNetworkListResponseIterator(page ManagedVirtualNetworkListResponsePage) ManagedVirtualNetworkListResponseIterator {
	return original.NewManagedVirtualNetworkListResponseIterator(page)
}
func NewManagedVirtualNetworkListResponsePage(cur ManagedVirtualNetworkListResponse, getNextPage func(context.Context, ManagedVirtualNetworkListResponse) (ManagedVirtualNetworkListResponse, error)) ManagedVirtualNetworkListResponsePage {
	return original.NewManagedVirtualNetworkListResponsePage(cur, getNextPage)
}
func NewManagedVirtualNetworksClient(subscriptionID string) ManagedVirtualNetworksClient {
	return original.NewManagedVirtualNetworksClient(subscriptionID)
}
func NewManagedVirtualNetworksClientWithBaseURI(baseURI string, subscriptionID string) ManagedVirtualNetworksClient {
	return original.NewManagedVirtualNetworksClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResponseIterator(page OperationListResponsePage) OperationListResponseIterator {
	return original.NewOperationListResponseIterator(page)
}
func NewOperationListResponsePage(cur OperationListResponse, getNextPage func(context.Context, OperationListResponse) (OperationListResponse, error)) OperationListResponsePage {
	return original.NewOperationListResponsePage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPipelineListResponseIterator(page PipelineListResponsePage) PipelineListResponseIterator {
	return original.NewPipelineListResponseIterator(page)
}
func NewPipelineListResponsePage(cur PipelineListResponse, getNextPage func(context.Context, PipelineListResponse) (PipelineListResponse, error)) PipelineListResponsePage {
	return original.NewPipelineListResponsePage(cur, getNextPage)
}
func NewPipelineRunsClient(subscriptionID string) PipelineRunsClient {
	return original.NewPipelineRunsClient(subscriptionID)
}
func NewPipelineRunsClientWithBaseURI(baseURI string, subscriptionID string) PipelineRunsClient {
	return original.NewPipelineRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPipelinesClient(subscriptionID string) PipelinesClient {
	return original.NewPipelinesClient(subscriptionID)
}
func NewPipelinesClientWithBaseURI(baseURI string, subscriptionID string) PipelinesClient {
	return original.NewPipelinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndPointConnectionsClient(subscriptionID string) PrivateEndPointConnectionsClient {
	return original.NewPrivateEndPointConnectionsClient(subscriptionID)
}
func NewPrivateEndPointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndPointConnectionsClient {
	return original.NewPrivateEndPointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionClient(subscriptionID string) PrivateEndpointConnectionClient {
	return original.NewPrivateEndpointConnectionClient(subscriptionID)
}
func NewPrivateEndpointConnectionClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionClient {
	return original.NewPrivateEndpointConnectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResponseIterator(page PrivateEndpointConnectionListResponsePage) PrivateEndpointConnectionListResponseIterator {
	return original.NewPrivateEndpointConnectionListResponseIterator(page)
}
func NewPrivateEndpointConnectionListResponsePage(cur PrivateEndpointConnectionListResponse, getNextPage func(context.Context, PrivateEndpointConnectionListResponse) (PrivateEndpointConnectionListResponse, error)) PrivateEndpointConnectionListResponsePage {
	return original.NewPrivateEndpointConnectionListResponsePage(cur, getNextPage)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewQueryDataFlowDebugSessionsResponseIterator(page QueryDataFlowDebugSessionsResponsePage) QueryDataFlowDebugSessionsResponseIterator {
	return original.NewQueryDataFlowDebugSessionsResponseIterator(page)
}
func NewQueryDataFlowDebugSessionsResponsePage(cur QueryDataFlowDebugSessionsResponse, getNextPage func(context.Context, QueryDataFlowDebugSessionsResponse) (QueryDataFlowDebugSessionsResponse, error)) QueryDataFlowDebugSessionsResponsePage {
	return original.NewQueryDataFlowDebugSessionsResponsePage(cur, getNextPage)
}
func NewTriggerListResponseIterator(page TriggerListResponsePage) TriggerListResponseIterator {
	return original.NewTriggerListResponseIterator(page)
}
func NewTriggerListResponsePage(cur TriggerListResponse, getNextPage func(context.Context, TriggerListResponse) (TriggerListResponse, error)) TriggerListResponsePage {
	return original.NewTriggerListResponsePage(cur, getNextPage)
}
func NewTriggerRunsClient(subscriptionID string) TriggerRunsClient {
	return original.NewTriggerRunsClient(subscriptionID)
}
func NewTriggerRunsClientWithBaseURI(baseURI string, subscriptionID string) TriggerRunsClient {
	return original.NewTriggerRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTriggersClient(subscriptionID string) TriggersClient {
	return original.NewTriggersClient(subscriptionID)
}
func NewTriggersClientWithBaseURI(baseURI string, subscriptionID string) TriggersClient {
	return original.NewTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAmazonRdsForOraclePartitionOptionValues() []AmazonRdsForOraclePartitionOption {
	return original.PossibleAmazonRdsForOraclePartitionOptionValues()
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return original.PossibleAuthorizationTypeValues()
}
func PossibleAvroCompressionCodecValues() []AvroCompressionCodec {
	return original.PossibleAvroCompressionCodecValues()
}
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return original.PossibleAzureFunctionActivityMethodValues()
}
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return original.PossibleAzureSearchIndexWriteBehaviorTypeValues()
}
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return original.PossibleBlobEventTypesValues()
}
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return original.PossibleCassandraSourceReadConsistencyLevelsValues()
}
func PossibleCompressionCodecValues() []CompressionCodec {
	return original.PossibleCompressionCodecValues()
}
func PossibleCopyBehaviorTypeValues() []CopyBehaviorType {
	return original.PossibleCopyBehaviorTypeValues()
}
func PossibleCosmosDbConnectionModeValues() []CosmosDbConnectionMode {
	return original.PossibleCosmosDbConnectionModeValues()
}
func PossibleCosmosDbServicePrincipalCredentialTypeValues() []CosmosDbServicePrincipalCredentialType {
	return original.PossibleCosmosDbServicePrincipalCredentialTypeValues()
}
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return original.PossibleDataFlowComputeTypeValues()
}
func PossibleDataFlowDebugCommandTypeValues() []DataFlowDebugCommandType {
	return original.PossibleDataFlowDebugCommandTypeValues()
}
func PossibleDatasetCompressionLevelValues() []DatasetCompressionLevel {
	return original.PossibleDatasetCompressionLevelValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return original.PossibleDaysOfWeekValues()
}
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return original.PossibleDb2AuthenticationTypeValues()
}
func PossibleDependencyConditionValues() []DependencyCondition {
	return original.PossibleDependencyConditionValues()
}
func PossibleDynamicsAuthenticationTypeValues() []DynamicsAuthenticationType {
	return original.PossibleDynamicsAuthenticationTypeValues()
}
func PossibleDynamicsDeploymentTypeValues() []DynamicsDeploymentType {
	return original.PossibleDynamicsDeploymentTypeValues()
}
func PossibleDynamicsSinkWriteBehaviorValues() []DynamicsSinkWriteBehavior {
	return original.PossibleDynamicsSinkWriteBehaviorValues()
}
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return original.PossibleEventSubscriptionStatusValues()
}
func PossibleFactoryIdentityTypeValues() []FactoryIdentityType {
	return original.PossibleFactoryIdentityTypeValues()
}
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return original.PossibleFtpAuthenticationTypeValues()
}
func PossibleGlobalParameterTypeValues() []GlobalParameterType {
	return original.PossibleGlobalParameterTypeValues()
}
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return original.PossibleGoogleAdWordsAuthenticationTypeValues()
}
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return original.PossibleGoogleBigQueryAuthenticationTypeValues()
}
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return original.PossibleHBaseAuthenticationTypeValues()
}
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return original.PossibleHDInsightActivityDebugInfoOptionValues()
}
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return original.PossibleHTTPAuthenticationTypeValues()
}
func PossibleHdiNodeTypesValues() []HdiNodeTypes {
	return original.PossibleHdiNodeTypesValues()
}
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return original.PossibleHiveAuthenticationTypeValues()
}
func PossibleHiveServerTypeValues() []HiveServerType {
	return original.PossibleHiveServerTypeValues()
}
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return original.PossibleHiveThriftTransportProtocolValues()
}
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return original.PossibleImpalaAuthenticationTypeValues()
}
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return original.PossibleIntegrationRuntimeAuthKeyNameValues()
}
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return original.PossibleIntegrationRuntimeAutoUpdateValues()
}
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return original.PossibleIntegrationRuntimeEditionValues()
}
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return original.PossibleIntegrationRuntimeEntityReferenceTypeValues()
}
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return original.PossibleIntegrationRuntimeInternalChannelEncryptionModeValues()
}
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return original.PossibleIntegrationRuntimeLicenseTypeValues()
}
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return original.PossibleIntegrationRuntimeSsisCatalogPricingTierValues()
}
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return original.PossibleIntegrationRuntimeStateValues()
}
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return original.PossibleIntegrationRuntimeTypeValues()
}
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return original.PossibleIntegrationRuntimeUpdateResultValues()
}
func PossibleJSONFormatFilePatternValues() []JSONFormatFilePattern {
	return original.PossibleJSONFormatFilePatternValues()
}
func PossibleJSONWriteFilePatternValues() []JSONWriteFilePattern {
	return original.PossibleJSONWriteFilePatternValues()
}
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return original.PossibleManagedIntegrationRuntimeNodeStatusValues()
}
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return original.PossibleMongoDbAuthenticationTypeValues()
}
func PossibleNetezzaPartitionOptionValues() []NetezzaPartitionOption {
	return original.PossibleNetezzaPartitionOptionValues()
}
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return original.PossibleODataAadServicePrincipalCredentialTypeValues()
}
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return original.PossibleODataAuthenticationTypeValues()
}
func PossibleOraclePartitionOptionValues() []OraclePartitionOption {
	return original.PossibleOraclePartitionOptionValues()
}
func PossibleOrcCompressionCodecValues() []OrcCompressionCodec {
	return original.PossibleOrcCompressionCodecValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return original.PossiblePhoenixAuthenticationTypeValues()
}
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return original.PossiblePolybaseSettingsRejectTypeValues()
}
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return original.PossiblePrestoAuthenticationTypeValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return original.PossibleRestServiceAuthenticationTypeValues()
}
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return original.PossibleRunQueryFilterOperandValues()
}
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return original.PossibleRunQueryFilterOperatorValues()
}
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return original.PossibleRunQueryOrderByFieldValues()
}
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return original.PossibleRunQueryOrderValues()
}
func PossibleSQLAlwaysEncryptedAkvAuthTypeValues() []SQLAlwaysEncryptedAkvAuthType {
	return original.PossibleSQLAlwaysEncryptedAkvAuthTypeValues()
}
func PossibleSQLDWWriteBehaviorEnumValues() []SQLDWWriteBehaviorEnum {
	return original.PossibleSQLDWWriteBehaviorEnumValues()
}
func PossibleSQLPartitionOptionValues() []SQLPartitionOption {
	return original.PossibleSQLPartitionOptionValues()
}
func PossibleSQLWriteBehaviorEnumValues() []SQLWriteBehaviorEnum {
	return original.PossibleSQLWriteBehaviorEnumValues()
}
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return original.PossibleSalesforceSinkWriteBehaviorValues()
}
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return original.PossibleSalesforceSourceReadBehaviorValues()
}
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return original.PossibleSapCloudForCustomerSinkWriteBehaviorValues()
}
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return original.PossibleSapHanaAuthenticationTypeValues()
}
func PossibleSapHanaPartitionOptionValues() []SapHanaPartitionOption {
	return original.PossibleSapHanaPartitionOptionValues()
}
func PossibleSapTablePartitionOptionValues() []SapTablePartitionOption {
	return original.PossibleSapTablePartitionOptionValues()
}
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return original.PossibleSelfHostedIntegrationRuntimeNodeStatusValues()
}
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return original.PossibleServiceNowAuthenticationTypeValues()
}
func PossibleServicePrincipalCredentialTypeValues() []ServicePrincipalCredentialType {
	return original.PossibleServicePrincipalCredentialTypeValues()
}
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return original.PossibleSftpAuthenticationTypeValues()
}
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return original.PossibleSparkAuthenticationTypeValues()
}
func PossibleSparkServerTypeValues() []SparkServerType {
	return original.PossibleSparkServerTypeValues()
}
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return original.PossibleSparkThriftTransportProtocolValues()
}
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return original.PossibleSsisObjectMetadataTypeValues()
}
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return original.PossibleSsisPackageLocationTypeValues()
}
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return original.PossibleStoredProcedureParameterTypeValues()
}
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return original.PossibleSybaseAuthenticationTypeValues()
}
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return original.PossibleTeradataAuthenticationTypeValues()
}
func PossibleTeradataPartitionOptionValues() []TeradataPartitionOption {
	return original.PossibleTeradataPartitionOptionValues()
}
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return original.PossibleTriggerRunStatusValues()
}
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return original.PossibleTriggerRuntimeStateValues()
}
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return original.PossibleTumblingWindowFrequencyValues()
}
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return original.PossibleTypeBasicActivityValues()
}
func PossibleTypeBasicCompressionReadSettingsValues() []TypeBasicCompressionReadSettings {
	return original.PossibleTypeBasicCompressionReadSettingsValues()
}
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return original.PossibleTypeBasicCopySinkValues()
}
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return original.PossibleTypeBasicCopySourceValues()
}
func PossibleTypeBasicCopyTranslatorValues() []TypeBasicCopyTranslator {
	return original.PossibleTypeBasicCopyTranslatorValues()
}
func PossibleTypeBasicCredentialValues() []TypeBasicCredential {
	return original.PossibleTypeBasicCredentialValues()
}
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return original.PossibleTypeBasicCustomSetupBaseValues()
}
func PossibleTypeBasicDataFlowValues() []TypeBasicDataFlow {
	return original.PossibleTypeBasicDataFlowValues()
}
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return original.PossibleTypeBasicDatasetCompressionValues()
}
func PossibleTypeBasicDatasetLocationValues() []TypeBasicDatasetLocation {
	return original.PossibleTypeBasicDatasetLocationValues()
}
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return original.PossibleTypeBasicDatasetStorageFormatValues()
}
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return original.PossibleTypeBasicDatasetValues()
}
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return original.PossibleTypeBasicDependencyReferenceValues()
}
func PossibleTypeBasicExportSettingsValues() []TypeBasicExportSettings {
	return original.PossibleTypeBasicExportSettingsValues()
}
func PossibleTypeBasicFactoryRepoConfigurationValues() []TypeBasicFactoryRepoConfiguration {
	return original.PossibleTypeBasicFactoryRepoConfigurationValues()
}
func PossibleTypeBasicFormatReadSettingsValues() []TypeBasicFormatReadSettings {
	return original.PossibleTypeBasicFormatReadSettingsValues()
}
func PossibleTypeBasicFormatWriteSettingsValues() []TypeBasicFormatWriteSettings {
	return original.PossibleTypeBasicFormatWriteSettingsValues()
}
func PossibleTypeBasicImportSettingsValues() []TypeBasicImportSettings {
	return original.PossibleTypeBasicImportSettingsValues()
}
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return original.PossibleTypeBasicIntegrationRuntimeStatusValues()
}
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return original.PossibleTypeBasicIntegrationRuntimeValues()
}
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return original.PossibleTypeBasicLinkedServiceValues()
}
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return original.PossibleTypeBasicSsisObjectMetadataValues()
}
func PossibleTypeBasicStoreReadSettingsValues() []TypeBasicStoreReadSettings {
	return original.PossibleTypeBasicStoreReadSettingsValues()
}
func PossibleTypeBasicStoreWriteSettingsValues() []TypeBasicStoreWriteSettings {
	return original.PossibleTypeBasicStoreWriteSettingsValues()
}
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return original.PossibleTypeBasicTriggerValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleVariableTypeValues() []VariableType {
	return original.PossibleVariableTypeValues()
}
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return original.PossibleWebActivityMethodValues()
}
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return original.PossibleWebHookActivityMethodValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
