//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package commerce

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/commerce/mgmt/2015-06-01-preview/commerce"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AggregationGranularity = original.AggregationGranularity

const (
	Daily  AggregationGranularity = original.Daily
	Hourly AggregationGranularity = original.Hourly
)

type Name = original.Name

const (
	NameMonetaryCommitment Name = original.NameMonetaryCommitment
	NameMonetaryCredit     Name = original.NameMonetaryCredit
	NameOfferTermInfo      Name = original.NameOfferTermInfo
	NameRecurringCharge    Name = original.NameRecurringCharge
)

type BaseClient = original.BaseClient
type BasicOfferTermInfo = original.BasicOfferTermInfo
type ErrorResponse = original.ErrorResponse
type InfoField = original.InfoField
type MeterInfo = original.MeterInfo
type MonetaryCommitment = original.MonetaryCommitment
type MonetaryCredit = original.MonetaryCredit
type OfferTermInfo = original.OfferTermInfo
type RateCardClient = original.RateCardClient
type RateCardQueryParameters = original.RateCardQueryParameters
type RecurringCharge = original.RecurringCharge
type ResourceRateCardInfo = original.ResourceRateCardInfo
type UsageAggregatesClient = original.UsageAggregatesClient
type UsageAggregation = original.UsageAggregation
type UsageAggregationListResult = original.UsageAggregationListResult
type UsageAggregationListResultIterator = original.UsageAggregationListResultIterator
type UsageAggregationListResultPage = original.UsageAggregationListResultPage
type UsageSample = original.UsageSample

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewRateCardClient(subscriptionID string) RateCardClient {
	return original.NewRateCardClient(subscriptionID)
}
func NewRateCardClientWithBaseURI(baseURI string, subscriptionID string) RateCardClient {
	return original.NewRateCardClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsageAggregatesClient(subscriptionID string) UsageAggregatesClient {
	return original.NewUsageAggregatesClient(subscriptionID)
}
func NewUsageAggregatesClientWithBaseURI(baseURI string, subscriptionID string) UsageAggregatesClient {
	return original.NewUsageAggregatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsageAggregationListResultIterator(page UsageAggregationListResultPage) UsageAggregationListResultIterator {
	return original.NewUsageAggregationListResultIterator(page)
}
func NewUsageAggregationListResultPage(cur UsageAggregationListResult, getNextPage func(context.Context, UsageAggregationListResult) (UsageAggregationListResult, error)) UsageAggregationListResultPage {
	return original.NewUsageAggregationListResultPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAggregationGranularityValues() []AggregationGranularity {
	return original.PossibleAggregationGranularityValues()
}
func PossibleNameValues() []Name {
	return original.PossibleNameValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
