package costmanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GenerateReservationDetailsReportClient is the client for the GenerateReservationDetailsReport methods of the
// Costmanagement service.
type GenerateReservationDetailsReportClient struct {
	BaseClient
}

// NewGenerateReservationDetailsReportClient creates an instance of the GenerateReservationDetailsReportClient client.
func NewGenerateReservationDetailsReportClient(subscriptionID string) GenerateReservationDetailsReportClient {
	return NewGenerateReservationDetailsReportClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGenerateReservationDetailsReportClientWithBaseURI creates an instance of the
// GenerateReservationDetailsReportClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewGenerateReservationDetailsReportClientWithBaseURI(baseURI string, subscriptionID string) GenerateReservationDetailsReportClient {
	return GenerateReservationDetailsReportClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ByBillingAccountID generates the reservations details report for provided date range asynchronously based on
// enrollment id.
// Parameters:
// billingAccountID - enrollment ID (Legacy BillingAccount ID)
// startDate - start Date
// endDate - end Date
func (client GenerateReservationDetailsReportClient) ByBillingAccountID(ctx context.Context, billingAccountID string, startDate string, endDate string) (result GenerateReservationDetailsReportByBillingAccountIDFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GenerateReservationDetailsReportClient.ByBillingAccountID")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ByBillingAccountIDPreparer(ctx, billingAccountID, startDate, endDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.GenerateReservationDetailsReportClient", "ByBillingAccountID", nil, "Failure preparing request")
		return
	}

	result, err = client.ByBillingAccountIDSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.GenerateReservationDetailsReportClient", "ByBillingAccountID", nil, "Failure sending request")
		return
	}

	return
}

// ByBillingAccountIDPreparer prepares the ByBillingAccountID request.
func (client GenerateReservationDetailsReportClient) ByBillingAccountIDPreparer(ctx context.Context, billingAccountID string, startDate string, endDate string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"endDate":     autorest.Encode("query", endDate),
		"startDate":   autorest.Encode("query", startDate),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/generateReservationDetailsReport", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ByBillingAccountIDSender sends the ByBillingAccountID request. The method will close the
// http.Response Body if it receives an error.
func (client GenerateReservationDetailsReportClient) ByBillingAccountIDSender(req *http.Request) (future GenerateReservationDetailsReportByBillingAccountIDFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ByBillingAccountIDResponder handles the response to the ByBillingAccountID request. The method always
// closes the http.Response Body.
func (client GenerateReservationDetailsReportClient) ByBillingAccountIDResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ByBillingProfileID generates the reservations details report for provided date range asynchronously by billing
// profile.
// Parameters:
// billingAccountID - billingAccount ID
// billingProfileID - billingProfile ID
// startDate - start Date
// endDate - end Date
func (client GenerateReservationDetailsReportClient) ByBillingProfileID(ctx context.Context, billingAccountID string, billingProfileID string, startDate string, endDate string) (result GenerateReservationDetailsReportByBillingProfileIDFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GenerateReservationDetailsReportClient.ByBillingProfileID")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ByBillingProfileIDPreparer(ctx, billingAccountID, billingProfileID, startDate, endDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.GenerateReservationDetailsReportClient", "ByBillingProfileID", nil, "Failure preparing request")
		return
	}

	result, err = client.ByBillingProfileIDSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.GenerateReservationDetailsReportClient", "ByBillingProfileID", nil, "Failure sending request")
		return
	}

	return
}

// ByBillingProfileIDPreparer prepares the ByBillingProfileID request.
func (client GenerateReservationDetailsReportClient) ByBillingProfileIDPreparer(ctx context.Context, billingAccountID string, billingProfileID string, startDate string, endDate string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"billingProfileId": autorest.Encode("path", billingProfileID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"endDate":     autorest.Encode("query", endDate),
		"startDate":   autorest.Encode("query", startDate),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.CostManagement/generateReservationDetailsReport", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ByBillingProfileIDSender sends the ByBillingProfileID request. The method will close the
// http.Response Body if it receives an error.
func (client GenerateReservationDetailsReportClient) ByBillingProfileIDSender(req *http.Request) (future GenerateReservationDetailsReportByBillingProfileIDFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ByBillingProfileIDResponder handles the response to the ByBillingProfileID request. The method always
// closes the http.Response Body.
func (client GenerateReservationDetailsReportClient) ByBillingProfileIDResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
