package artifacts

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PipelineClient is the client for the Pipeline methods of the Artifacts service.
type PipelineClient struct {
	BaseClient
}

// NewPipelineClient creates an instance of the PipelineClient client.
func NewPipelineClient(endpoint string) PipelineClient {
	return PipelineClient{New(endpoint)}
}

// CreateOrUpdatePipeline creates or updates a pipeline.
// Parameters:
// pipelineName - the pipeline name.
// pipeline - pipeline resource definition.
// ifMatch - eTag of the pipeline entity.  Should only be specified for update, for which it should match
// existing entity or can be * for unconditional update.
func (client PipelineClient) CreateOrUpdatePipeline(ctx context.Context, pipelineName string, pipeline PipelineResource, ifMatch string) (result PipelineResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineClient.CreateOrUpdatePipeline")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: pipelineName,
			Constraints: []validation.Constraint{{Target: "pipelineName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "pipelineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "pipelineName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}},
		{TargetValue: pipeline,
			Constraints: []validation.Constraint{{Target: "pipeline.Pipeline", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "pipeline.Pipeline.Concurrency", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "pipeline.Pipeline.Concurrency", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("artifacts.PipelineClient", "CreateOrUpdatePipeline", err.Error())
	}

	req, err := client.CreateOrUpdatePipelinePreparer(ctx, pipelineName, pipeline, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "CreateOrUpdatePipeline", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdatePipelineSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "CreateOrUpdatePipeline", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdatePipelineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "CreateOrUpdatePipeline", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePipelinePreparer prepares the CreateOrUpdatePipeline request.
func (client PipelineClient) CreateOrUpdatePipelinePreparer(ctx context.Context, pipelineName string, pipeline PipelineResource, ifMatch string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"pipelineName": autorest.Encode("path", pipelineName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/pipelines/{pipelineName}", pathParameters),
		autorest.WithJSON(pipeline),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdatePipelineSender sends the CreateOrUpdatePipeline request. The method will close the
// http.Response Body if it receives an error.
func (client PipelineClient) CreateOrUpdatePipelineSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdatePipelineResponder handles the response to the CreateOrUpdatePipeline request. The method always
// closes the http.Response Body.
func (client PipelineClient) CreateOrUpdatePipelineResponder(resp *http.Response) (result PipelineResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePipelineRun creates a run of a pipeline.
// Parameters:
// pipelineName - the pipeline name.
// referencePipelineRunID - the pipeline run identifier. If run ID is specified the parameters of the specified
// run will be used to create a new run.
// isRecovery - recovery mode flag. If recovery mode is set to true, the specified referenced pipeline run and
// the new run will be grouped under the same groupId.
// startActivityName - in recovery mode, the rerun will start from this activity. If not specified, all
// activities will run.
// parameters - parameters of the pipeline run. These parameters will be used only if the runId is not
// specified.
func (client PipelineClient) CreatePipelineRun(ctx context.Context, pipelineName string, referencePipelineRunID string, isRecovery *bool, startActivityName string, parameters map[string]interface{}) (result CreateRunResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineClient.CreatePipelineRun")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: pipelineName,
			Constraints: []validation.Constraint{{Target: "pipelineName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "pipelineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "pipelineName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.PipelineClient", "CreatePipelineRun", err.Error())
	}

	req, err := client.CreatePipelineRunPreparer(ctx, pipelineName, referencePipelineRunID, isRecovery, startActivityName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "CreatePipelineRun", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePipelineRunSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "CreatePipelineRun", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePipelineRunResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "CreatePipelineRun", resp, "Failure responding to request")
	}

	return
}

// CreatePipelineRunPreparer prepares the CreatePipelineRun request.
func (client PipelineClient) CreatePipelineRunPreparer(ctx context.Context, pipelineName string, referencePipelineRunID string, isRecovery *bool, startActivityName string, parameters map[string]interface{}) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"pipelineName": autorest.Encode("path", pipelineName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(referencePipelineRunID) > 0 {
		queryParameters["referencePipelineRunId"] = autorest.Encode("query", referencePipelineRunID)
	}
	if isRecovery != nil {
		queryParameters["isRecovery"] = autorest.Encode("query", *isRecovery)
	}
	if len(startActivityName) > 0 {
		queryParameters["startActivityName"] = autorest.Encode("query", startActivityName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/pipelines/{pipelineName}/createRun", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if parameters != nil && len(parameters) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(parameters))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePipelineRunSender sends the CreatePipelineRun request. The method will close the
// http.Response Body if it receives an error.
func (client PipelineClient) CreatePipelineRunSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreatePipelineRunResponder handles the response to the CreatePipelineRun request. The method always
// closes the http.Response Body.
func (client PipelineClient) CreatePipelineRunResponder(resp *http.Response) (result CreateRunResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePipeline deletes a pipeline.
// Parameters:
// pipelineName - the pipeline name.
func (client PipelineClient) DeletePipeline(ctx context.Context, pipelineName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineClient.DeletePipeline")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: pipelineName,
			Constraints: []validation.Constraint{{Target: "pipelineName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "pipelineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "pipelineName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.PipelineClient", "DeletePipeline", err.Error())
	}

	req, err := client.DeletePipelinePreparer(ctx, pipelineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "DeletePipeline", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePipelineSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "DeletePipeline", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePipelineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "DeletePipeline", resp, "Failure responding to request")
	}

	return
}

// DeletePipelinePreparer prepares the DeletePipeline request.
func (client PipelineClient) DeletePipelinePreparer(ctx context.Context, pipelineName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"pipelineName": autorest.Encode("path", pipelineName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/pipelines/{pipelineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePipelineSender sends the DeletePipeline request. The method will close the
// http.Response Body if it receives an error.
func (client PipelineClient) DeletePipelineSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeletePipelineResponder handles the response to the DeletePipeline request. The method always
// closes the http.Response Body.
func (client PipelineClient) DeletePipelineResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetPipeline gets a pipeline.
// Parameters:
// pipelineName - the pipeline name.
// ifNoneMatch - eTag of the pipeline entity. Should only be specified for get. If the ETag matches the
// existing entity tag, or if * was provided, then no content will be returned.
func (client PipelineClient) GetPipeline(ctx context.Context, pipelineName string, ifNoneMatch string) (result PipelineResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineClient.GetPipeline")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: pipelineName,
			Constraints: []validation.Constraint{{Target: "pipelineName", Name: validation.MaxLength, Rule: 260, Chain: nil},
				{Target: "pipelineName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "pipelineName", Name: validation.Pattern, Rule: `^[A-Za-z0-9_][^<>*#.%&:\\+?/]*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.PipelineClient", "GetPipeline", err.Error())
	}

	req, err := client.GetPipelinePreparer(ctx, pipelineName, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "GetPipeline", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPipelineSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "GetPipeline", resp, "Failure sending request")
		return
	}

	result, err = client.GetPipelineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "GetPipeline", resp, "Failure responding to request")
	}

	return
}

// GetPipelinePreparer prepares the GetPipeline request.
func (client PipelineClient) GetPipelinePreparer(ctx context.Context, pipelineName string, ifNoneMatch string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"pipelineName": autorest.Encode("path", pipelineName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/pipelines/{pipelineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPipelineSender sends the GetPipeline request. The method will close the
// http.Response Body if it receives an error.
func (client PipelineClient) GetPipelineSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPipelineResponder handles the response to the GetPipeline request. The method always
// closes the http.Response Body.
func (client PipelineClient) GetPipelineResponder(resp *http.Response) (result PipelineResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotModified),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPipelinesByWorkspace lists pipelines.
func (client PipelineClient) GetPipelinesByWorkspace(ctx context.Context) (result PipelineListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineClient.GetPipelinesByWorkspace")
		defer func() {
			sc := -1
			if result.plr.Response.Response != nil {
				sc = result.plr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getPipelinesByWorkspaceNextResults
	req, err := client.GetPipelinesByWorkspacePreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "GetPipelinesByWorkspace", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPipelinesByWorkspaceSender(req)
	if err != nil {
		result.plr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "GetPipelinesByWorkspace", resp, "Failure sending request")
		return
	}

	result.plr, err = client.GetPipelinesByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "GetPipelinesByWorkspace", resp, "Failure responding to request")
	}

	return
}

// GetPipelinesByWorkspacePreparer prepares the GetPipelinesByWorkspace request.
func (client PipelineClient) GetPipelinesByWorkspacePreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/pipelines"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPipelinesByWorkspaceSender sends the GetPipelinesByWorkspace request. The method will close the
// http.Response Body if it receives an error.
func (client PipelineClient) GetPipelinesByWorkspaceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPipelinesByWorkspaceResponder handles the response to the GetPipelinesByWorkspace request. The method always
// closes the http.Response Body.
func (client PipelineClient) GetPipelinesByWorkspaceResponder(resp *http.Response) (result PipelineListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getPipelinesByWorkspaceNextResults retrieves the next set of results, if any.
func (client PipelineClient) getPipelinesByWorkspaceNextResults(ctx context.Context, lastResults PipelineListResponse) (result PipelineListResponse, err error) {
	req, err := lastResults.pipelineListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "artifacts.PipelineClient", "getPipelinesByWorkspaceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetPipelinesByWorkspaceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "artifacts.PipelineClient", "getPipelinesByWorkspaceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetPipelinesByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.PipelineClient", "getPipelinesByWorkspaceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetPipelinesByWorkspaceComplete enumerates all values, automatically crossing page boundaries as required.
func (client PipelineClient) GetPipelinesByWorkspaceComplete(ctx context.Context) (result PipelineListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineClient.GetPipelinesByWorkspace")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetPipelinesByWorkspace(ctx)
	return
}
