// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the GetIdentityPoolConfiguration operation.
type GetIdentityPoolConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. This is the ID of the pool for which to return
	// a configuration.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIdentityPoolConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityPoolConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIdentityPoolConfigurationInput"}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIdentityPoolConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output for the GetIdentityPoolConfiguration operation.
type GetIdentityPoolConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito.
	IdentityPoolId *string `min:"1" type:"string"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation
func (s GetIdentityPoolConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIdentityPoolConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CognitoStreams != nil {
		v := s.CognitoStreams

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CognitoStreams", v, metadata)
	}
	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PushSync != nil {
		v := s.PushSync

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PushSync", v, metadata)
	}
	return nil
}

const opGetIdentityPoolConfiguration = "GetIdentityPoolConfiguration"

// GetIdentityPoolConfigurationRequest returns a request value for making API operation for
// Amazon Cognito Sync.
//
// Gets the configuration settings of an identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
//    // Example sending a request using GetIdentityPoolConfigurationRequest.
//    req := client.GetIdentityPoolConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetIdentityPoolConfiguration
func (c *Client) GetIdentityPoolConfigurationRequest(input *GetIdentityPoolConfigurationInput) GetIdentityPoolConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetIdentityPoolConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/configuration",
	}

	if input == nil {
		input = &GetIdentityPoolConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetIdentityPoolConfigurationOutput{})
	return GetIdentityPoolConfigurationRequest{Request: req, Input: input, Copy: c.GetIdentityPoolConfigurationRequest}
}

// GetIdentityPoolConfigurationRequest is the request type for the
// GetIdentityPoolConfiguration API operation.
type GetIdentityPoolConfigurationRequest struct {
	*aws.Request
	Input *GetIdentityPoolConfigurationInput
	Copy  func(*GetIdentityPoolConfigurationInput) GetIdentityPoolConfigurationRequest
}

// Send marshals and sends the GetIdentityPoolConfiguration API request.
func (r GetIdentityPoolConfigurationRequest) Send(ctx context.Context) (*GetIdentityPoolConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIdentityPoolConfigurationResponse{
		GetIdentityPoolConfigurationOutput: r.Request.Data.(*GetIdentityPoolConfigurationOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIdentityPoolConfigurationResponse is the response type for the
// GetIdentityPoolConfiguration API operation.
type GetIdentityPoolConfigurationResponse struct {
	*GetIdentityPoolConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIdentityPoolConfiguration request.
func (r *GetIdentityPoolConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
