// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster
func (c *Kafka) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/clusters",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Managed Streaming for Kafka.
//
// Creates a new MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * TooManyRequestsException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster
func (c *Kafka) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguration = "CreateConfiguration"

// CreateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguration for more information on using the CreateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationRequest method.
//    req, resp := client.CreateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration
func (c *Kafka) CreateConfigurationRequest(input *CreateConfigurationInput) (req *request.Request, output *CreateConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/configurations",
	}

	if input == nil {
		input = &CreateConfigurationInput{}
	}

	output = &CreateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguration API operation for Managed Streaming for Kafka.
//
// Creates a new MSK configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * TooManyRequestsException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration
func (c *Kafka) CreateConfiguration(input *CreateConfigurationInput) (*CreateConfigurationOutput, error) {
	req, out := c.CreateConfigurationRequest(input)
	return out, req.Send()
}

// CreateConfigurationWithContext is the same as CreateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateConfigurationWithContext(ctx aws.Context, input *CreateConfigurationInput, opts ...request.Option) (*CreateConfigurationOutput, error) {
	req, out := c.CreateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Kafka) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Managed Streaming for Kafka.
//
// Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Kafka) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster
func (c *Kafka) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Managed Streaming for Kafka.
//
// Returns a description of the MSK cluster whose Amazon Resource Name (ARN)
// is specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster
func (c *Kafka) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterOperation = "DescribeClusterOperation"

// DescribeClusterOperationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterOperation for more information on using the DescribeClusterOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterOperationRequest method.
//    req, resp := client.DescribeClusterOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation
func (c *Kafka) DescribeClusterOperationRequest(input *DescribeClusterOperationInput) (req *request.Request, output *DescribeClusterOperationOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterOperation,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/operations/{clusterOperationArn}",
	}

	if input == nil {
		input = &DescribeClusterOperationInput{}
	}

	output = &DescribeClusterOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterOperation API operation for Managed Streaming for Kafka.
//
// Returns a description of the cluster operation specified by the ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeClusterOperation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation
func (c *Kafka) DescribeClusterOperation(input *DescribeClusterOperationInput) (*DescribeClusterOperationOutput, error) {
	req, out := c.DescribeClusterOperationRequest(input)
	return out, req.Send()
}

// DescribeClusterOperationWithContext is the same as DescribeClusterOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterOperationWithContext(ctx aws.Context, input *DescribeClusterOperationInput, opts ...request.Option) (*DescribeClusterOperationOutput, error) {
	req, out := c.DescribeClusterOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfiguration = "DescribeConfiguration"

// DescribeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfiguration for more information on using the DescribeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRequest method.
//    req, resp := client.DescribeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration
func (c *Kafka) DescribeConfigurationRequest(input *DescribeConfigurationInput) (req *request.Request, output *DescribeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}",
	}

	if input == nil {
		input = &DescribeConfigurationInput{}
	}

	output = &DescribeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfiguration API operation for Managed Streaming for Kafka.
//
// Returns a description of this MSK configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration
func (c *Kafka) DescribeConfiguration(input *DescribeConfigurationInput) (*DescribeConfigurationOutput, error) {
	req, out := c.DescribeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeConfigurationWithContext is the same as DescribeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeConfigurationWithContext(ctx aws.Context, input *DescribeConfigurationInput, opts ...request.Option) (*DescribeConfigurationOutput, error) {
	req, out := c.DescribeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRevision = "DescribeConfigurationRevision"

// DescribeConfigurationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRevision for more information on using the DescribeConfigurationRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRevisionRequest method.
//    req, resp := client.DescribeConfigurationRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision
func (c *Kafka) DescribeConfigurationRevisionRequest(input *DescribeConfigurationRevisionInput) (req *request.Request, output *DescribeConfigurationRevisionOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRevision,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}/revisions/{revision}",
	}

	if input == nil {
		input = &DescribeConfigurationRevisionInput{}
	}

	output = &DescribeConfigurationRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRevision API operation for Managed Streaming for Kafka.
//
// Returns a description of this revision of the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeConfigurationRevision for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision
func (c *Kafka) DescribeConfigurationRevision(input *DescribeConfigurationRevisionInput) (*DescribeConfigurationRevisionOutput, error) {
	req, out := c.DescribeConfigurationRevisionRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRevisionWithContext is the same as DescribeConfigurationRevision with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeConfigurationRevisionWithContext(ctx aws.Context, input *DescribeConfigurationRevisionInput, opts ...request.Option) (*DescribeConfigurationRevisionOutput, error) {
	req, out := c.DescribeConfigurationRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBootstrapBrokers = "GetBootstrapBrokers"

// GetBootstrapBrokersRequest generates a "aws/request.Request" representing the
// client's request for the GetBootstrapBrokers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBootstrapBrokers for more information on using the GetBootstrapBrokers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBootstrapBrokersRequest method.
//    req, resp := client.GetBootstrapBrokersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers
func (c *Kafka) GetBootstrapBrokersRequest(input *GetBootstrapBrokersInput) (req *request.Request, output *GetBootstrapBrokersOutput) {
	op := &request.Operation{
		Name:       opGetBootstrapBrokers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/bootstrap-brokers",
	}

	if input == nil {
		input = &GetBootstrapBrokersInput{}
	}

	output = &GetBootstrapBrokersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBootstrapBrokers API operation for Managed Streaming for Kafka.
//
// A list of brokers that a client application can use to bootstrap.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation GetBootstrapBrokers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers
func (c *Kafka) GetBootstrapBrokers(input *GetBootstrapBrokersInput) (*GetBootstrapBrokersOutput, error) {
	req, out := c.GetBootstrapBrokersRequest(input)
	return out, req.Send()
}

// GetBootstrapBrokersWithContext is the same as GetBootstrapBrokers with the addition of
// the ability to pass a context and additional request options.
//
// See GetBootstrapBrokers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) GetBootstrapBrokersWithContext(ctx aws.Context, input *GetBootstrapBrokersInput, opts ...request.Option) (*GetBootstrapBrokersOutput, error) {
	req, out := c.GetBootstrapBrokersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCompatibleKafkaVersions = "GetCompatibleKafkaVersions"

// GetCompatibleKafkaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCompatibleKafkaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCompatibleKafkaVersions for more information on using the GetCompatibleKafkaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCompatibleKafkaVersionsRequest method.
//    req, resp := client.GetCompatibleKafkaVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions
func (c *Kafka) GetCompatibleKafkaVersionsRequest(input *GetCompatibleKafkaVersionsInput) (req *request.Request, output *GetCompatibleKafkaVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCompatibleKafkaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/compatible-kafka-versions",
	}

	if input == nil {
		input = &GetCompatibleKafkaVersionsInput{}
	}

	output = &GetCompatibleKafkaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCompatibleKafkaVersions API operation for Managed Streaming for Kafka.
//
// Gets the Apache Kafka versions to which you can update the MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation GetCompatibleKafkaVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * TooManyRequestsException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions
func (c *Kafka) GetCompatibleKafkaVersions(input *GetCompatibleKafkaVersionsInput) (*GetCompatibleKafkaVersionsOutput, error) {
	req, out := c.GetCompatibleKafkaVersionsRequest(input)
	return out, req.Send()
}

// GetCompatibleKafkaVersionsWithContext is the same as GetCompatibleKafkaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCompatibleKafkaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) GetCompatibleKafkaVersionsWithContext(ctx aws.Context, input *GetCompatibleKafkaVersionsInput, opts ...request.Option) (*GetCompatibleKafkaVersionsOutput, error) {
	req, out := c.GetCompatibleKafkaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusterOperations = "ListClusterOperations"

// ListClusterOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListClusterOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusterOperations for more information on using the ListClusterOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClusterOperationsRequest method.
//    req, resp := client.ListClusterOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations
func (c *Kafka) ListClusterOperationsRequest(input *ListClusterOperationsInput) (req *request.Request, output *ListClusterOperationsOutput) {
	op := &request.Operation{
		Name:       opListClusterOperations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/operations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClusterOperationsInput{}
	}

	output = &ListClusterOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusterOperations API operation for Managed Streaming for Kafka.
//
// Returns a list of all the operations that have been performed on the specified
// MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClusterOperations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations
func (c *Kafka) ListClusterOperations(input *ListClusterOperationsInput) (*ListClusterOperationsOutput, error) {
	req, out := c.ListClusterOperationsRequest(input)
	return out, req.Send()
}

// ListClusterOperationsWithContext is the same as ListClusterOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusterOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClusterOperationsWithContext(ctx aws.Context, input *ListClusterOperationsInput, opts ...request.Option) (*ListClusterOperationsOutput, error) {
	req, out := c.ListClusterOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClusterOperationsPages iterates over the pages of a ListClusterOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusterOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusterOperations operation.
//    pageNum := 0
//    err := client.ListClusterOperationsPages(params,
//        func(page *kafka.ListClusterOperationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kafka) ListClusterOperationsPages(input *ListClusterOperationsInput, fn func(*ListClusterOperationsOutput, bool) bool) error {
	return c.ListClusterOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClusterOperationsPagesWithContext same as ListClusterOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClusterOperationsPagesWithContext(ctx aws.Context, input *ListClusterOperationsInput, fn func(*ListClusterOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClusterOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClusterOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClusterOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters
func (c *Kafka) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Managed Streaming for Kafka.
//
// Returns a list of all the MSK clusters in the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters
func (c *Kafka) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusters operation.
//    pageNum := 0
//    err := client.ListClustersPages(params,
//        func(page *kafka.ListClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kafka) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurationRevisions = "ListConfigurationRevisions"

// ListConfigurationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationRevisions for more information on using the ListConfigurationRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationRevisionsRequest method.
//    req, resp := client.ListConfigurationRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions
func (c *Kafka) ListConfigurationRevisionsRequest(input *ListConfigurationRevisionsInput) (req *request.Request, output *ListConfigurationRevisionsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}/revisions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationRevisionsInput{}
	}

	output = &ListConfigurationRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationRevisions API operation for Managed Streaming for Kafka.
//
// Returns a list of all the revisions of an MSK configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListConfigurationRevisions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions
func (c *Kafka) ListConfigurationRevisions(input *ListConfigurationRevisionsInput) (*ListConfigurationRevisionsOutput, error) {
	req, out := c.ListConfigurationRevisionsRequest(input)
	return out, req.Send()
}

// ListConfigurationRevisionsWithContext is the same as ListConfigurationRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationRevisionsWithContext(ctx aws.Context, input *ListConfigurationRevisionsInput, opts ...request.Option) (*ListConfigurationRevisionsOutput, error) {
	req, out := c.ListConfigurationRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationRevisionsPages iterates over the pages of a ListConfigurationRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurationRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConfigurationRevisions operation.
//    pageNum := 0
//    err := client.ListConfigurationRevisionsPages(params,
//        func(page *kafka.ListConfigurationRevisionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kafka) ListConfigurationRevisionsPages(input *ListConfigurationRevisionsInput, fn func(*ListConfigurationRevisionsOutput, bool) bool) error {
	return c.ListConfigurationRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationRevisionsPagesWithContext same as ListConfigurationRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationRevisionsPagesWithContext(ctx aws.Context, input *ListConfigurationRevisionsInput, fn func(*ListConfigurationRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationRevisionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurations = "ListConfigurations"

// ListConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurations for more information on using the ListConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationsRequest method.
//    req, resp := client.ListConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations
func (c *Kafka) ListConfigurationsRequest(input *ListConfigurationsInput) (req *request.Request, output *ListConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationsInput{}
	}

	output = &ListConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurations API operation for Managed Streaming for Kafka.
//
// Returns a list of all the MSK configurations in this Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListConfigurations for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations
func (c *Kafka) ListConfigurations(input *ListConfigurationsInput) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	return out, req.Send()
}

// ListConfigurationsWithContext is the same as ListConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationsWithContext(ctx aws.Context, input *ListConfigurationsInput, opts ...request.Option) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationsPages iterates over the pages of a ListConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConfigurations operation.
//    pageNum := 0
//    err := client.ListConfigurationsPages(params,
//        func(page *kafka.ListConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kafka) ListConfigurationsPages(input *ListConfigurationsInput, fn func(*ListConfigurationsOutput, bool) bool) error {
	return c.ListConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationsPagesWithContext same as ListConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListConfigurationsPagesWithContext(ctx aws.Context, input *ListConfigurationsInput, fn func(*ListConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKafkaVersions = "ListKafkaVersions"

// ListKafkaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListKafkaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKafkaVersions for more information on using the ListKafkaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListKafkaVersionsRequest method.
//    req, resp := client.ListKafkaVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions
func (c *Kafka) ListKafkaVersionsRequest(input *ListKafkaVersionsInput) (req *request.Request, output *ListKafkaVersionsOutput) {
	op := &request.Operation{
		Name:       opListKafkaVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/kafka-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKafkaVersionsInput{}
	}

	output = &ListKafkaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKafkaVersions API operation for Managed Streaming for Kafka.
//
// Returns a list of Kafka versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListKafkaVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions
func (c *Kafka) ListKafkaVersions(input *ListKafkaVersionsInput) (*ListKafkaVersionsOutput, error) {
	req, out := c.ListKafkaVersionsRequest(input)
	return out, req.Send()
}

// ListKafkaVersionsWithContext is the same as ListKafkaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListKafkaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListKafkaVersionsWithContext(ctx aws.Context, input *ListKafkaVersionsInput, opts ...request.Option) (*ListKafkaVersionsOutput, error) {
	req, out := c.ListKafkaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKafkaVersionsPages iterates over the pages of a ListKafkaVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKafkaVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKafkaVersions operation.
//    pageNum := 0
//    err := client.ListKafkaVersionsPages(params,
//        func(page *kafka.ListKafkaVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kafka) ListKafkaVersionsPages(input *ListKafkaVersionsInput, fn func(*ListKafkaVersionsOutput, bool) bool) error {
	return c.ListKafkaVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKafkaVersionsPagesWithContext same as ListKafkaVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListKafkaVersionsPagesWithContext(ctx aws.Context, input *ListKafkaVersionsInput, fn func(*ListKafkaVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKafkaVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKafkaVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKafkaVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodesRequest method.
//    req, resp := client.ListNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes
func (c *Kafka) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodes API operation for Managed Streaming for Kafka.
//
// Returns a list of the broker nodes in the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListNodes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes
func (c *Kafka) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListNodesWithContext(ctx aws.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodesPages iterates over the pages of a ListNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNodes operation.
//    pageNum := 0
//    err := client.ListNodesPages(params,
//        func(page *kafka.ListNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kafka) ListNodesPages(input *ListNodesInput, fn func(*ListNodesOutput, bool) bool) error {
	return c.ListNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodesPagesWithContext same as ListNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListNodesPagesWithContext(ctx aws.Context, input *ListNodesInput, fn func(*ListNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource
func (c *Kafka) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Managed Streaming for Kafka.
//
// Returns a list of the tags associated with the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource
func (c *Kafka) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootBroker = "RebootBroker"

// RebootBrokerRequest generates a "aws/request.Request" representing the
// client's request for the RebootBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootBroker for more information on using the RebootBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootBrokerRequest method.
//    req, resp := client.RebootBrokerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker
func (c *Kafka) RebootBrokerRequest(input *RebootBrokerInput) (req *request.Request, output *RebootBrokerOutput) {
	op := &request.Operation{
		Name:       opRebootBroker,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/reboot-broker",
	}

	if input == nil {
		input = &RebootBrokerInput{}
	}

	output = &RebootBrokerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootBroker API operation for Managed Streaming for Kafka.
//
// Executes a reboot on a broker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation RebootBroker for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * TooManyRequestsException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker
func (c *Kafka) RebootBroker(input *RebootBrokerInput) (*RebootBrokerOutput, error) {
	req, out := c.RebootBrokerRequest(input)
	return out, req.Send()
}

// RebootBrokerWithContext is the same as RebootBroker with the addition of
// the ability to pass a context and additional request options.
//
// See RebootBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) RebootBrokerWithContext(ctx aws.Context, input *RebootBrokerInput, opts ...request.Option) (*RebootBrokerOutput, error) {
	req, out := c.RebootBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource
func (c *Kafka) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Managed Streaming for Kafka.
//
// Adds tags to the specified MSK resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource
func (c *Kafka) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource
func (c *Kafka) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Managed Streaming for Kafka.
//
// Removes the tags associated with the keys that are provided in the query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource
func (c *Kafka) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBrokerCount = "UpdateBrokerCount"

// UpdateBrokerCountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBrokerCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBrokerCount for more information on using the UpdateBrokerCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBrokerCountRequest method.
//    req, resp := client.UpdateBrokerCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount
func (c *Kafka) UpdateBrokerCountRequest(input *UpdateBrokerCountInput) (req *request.Request, output *UpdateBrokerCountOutput) {
	op := &request.Operation{
		Name:       opUpdateBrokerCount,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes/count",
	}

	if input == nil {
		input = &UpdateBrokerCountInput{}
	}

	output = &UpdateBrokerCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBrokerCount API operation for Managed Streaming for Kafka.
//
// Updates the number of broker nodes in the cluster. You can use this operation
// to increase the number of brokers in an existing cluster. You can't decrease
// the number of brokers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateBrokerCount for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount
func (c *Kafka) UpdateBrokerCount(input *UpdateBrokerCountInput) (*UpdateBrokerCountOutput, error) {
	req, out := c.UpdateBrokerCountRequest(input)
	return out, req.Send()
}

// UpdateBrokerCountWithContext is the same as UpdateBrokerCount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBrokerCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateBrokerCountWithContext(ctx aws.Context, input *UpdateBrokerCountInput, opts ...request.Option) (*UpdateBrokerCountOutput, error) {
	req, out := c.UpdateBrokerCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBrokerStorage = "UpdateBrokerStorage"

// UpdateBrokerStorageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBrokerStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBrokerStorage for more information on using the UpdateBrokerStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBrokerStorageRequest method.
//    req, resp := client.UpdateBrokerStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage
func (c *Kafka) UpdateBrokerStorageRequest(input *UpdateBrokerStorageInput) (req *request.Request, output *UpdateBrokerStorageOutput) {
	op := &request.Operation{
		Name:       opUpdateBrokerStorage,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes/storage",
	}

	if input == nil {
		input = &UpdateBrokerStorageInput{}
	}

	output = &UpdateBrokerStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBrokerStorage API operation for Managed Streaming for Kafka.
//
// Updates the EBS storage associated with MSK brokers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateBrokerStorage for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage
func (c *Kafka) UpdateBrokerStorage(input *UpdateBrokerStorageInput) (*UpdateBrokerStorageOutput, error) {
	req, out := c.UpdateBrokerStorageRequest(input)
	return out, req.Send()
}

// UpdateBrokerStorageWithContext is the same as UpdateBrokerStorage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBrokerStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateBrokerStorageWithContext(ctx aws.Context, input *UpdateBrokerStorageInput, opts ...request.Option) (*UpdateBrokerStorageOutput, error) {
	req, out := c.UpdateBrokerStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterConfiguration = "UpdateClusterConfiguration"

// UpdateClusterConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterConfiguration for more information on using the UpdateClusterConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterConfigurationRequest method.
//    req, resp := client.UpdateClusterConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration
func (c *Kafka) UpdateClusterConfigurationRequest(input *UpdateClusterConfigurationInput) (req *request.Request, output *UpdateClusterConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/configuration",
	}

	if input == nil {
		input = &UpdateClusterConfigurationInput{}
	}

	output = &UpdateClusterConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterConfiguration API operation for Managed Streaming for Kafka.
//
// Updates the cluster with the configuration that is specified in the request
// body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateClusterConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration
func (c *Kafka) UpdateClusterConfiguration(input *UpdateClusterConfigurationInput) (*UpdateClusterConfigurationOutput, error) {
	req, out := c.UpdateClusterConfigurationRequest(input)
	return out, req.Send()
}

// UpdateClusterConfigurationWithContext is the same as UpdateClusterConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateClusterConfigurationWithContext(ctx aws.Context, input *UpdateClusterConfigurationInput, opts ...request.Option) (*UpdateClusterConfigurationOutput, error) {
	req, out := c.UpdateClusterConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterKafkaVersion = "UpdateClusterKafkaVersion"

// UpdateClusterKafkaVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterKafkaVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterKafkaVersion for more information on using the UpdateClusterKafkaVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterKafkaVersionRequest method.
//    req, resp := client.UpdateClusterKafkaVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion
func (c *Kafka) UpdateClusterKafkaVersionRequest(input *UpdateClusterKafkaVersionInput) (req *request.Request, output *UpdateClusterKafkaVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterKafkaVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/version",
	}

	if input == nil {
		input = &UpdateClusterKafkaVersionInput{}
	}

	output = &UpdateClusterKafkaVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterKafkaVersion API operation for Managed Streaming for Kafka.
//
// Updates the Apache Kafka version for the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateClusterKafkaVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
//   * NotFoundException
//   Returns information about an error.
//
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * TooManyRequestsException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion
func (c *Kafka) UpdateClusterKafkaVersion(input *UpdateClusterKafkaVersionInput) (*UpdateClusterKafkaVersionOutput, error) {
	req, out := c.UpdateClusterKafkaVersionRequest(input)
	return out, req.Send()
}

// UpdateClusterKafkaVersionWithContext is the same as UpdateClusterKafkaVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterKafkaVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateClusterKafkaVersionWithContext(ctx aws.Context, input *UpdateClusterKafkaVersionInput, opts ...request.Option) (*UpdateClusterKafkaVersionOutput, error) {
	req, out := c.UpdateClusterKafkaVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitoring = "UpdateMonitoring"

// UpdateMonitoringRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitoring operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitoring for more information on using the UpdateMonitoring
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMonitoringRequest method.
//    req, resp := client.UpdateMonitoringRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring
func (c *Kafka) UpdateMonitoringRequest(input *UpdateMonitoringInput) (req *request.Request, output *UpdateMonitoringOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitoring,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/clusters/{clusterArn}/monitoring",
	}

	if input == nil {
		input = &UpdateMonitoringInput{}
	}

	output = &UpdateMonitoringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMonitoring API operation for Managed Streaming for Kafka.
//
// Updates the monitoring settings for the cluster. You can use this operation
// to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon
// CloudWatch. You can also specify settings for open monitoring with Prometheus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation UpdateMonitoring for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring
func (c *Kafka) UpdateMonitoring(input *UpdateMonitoringInput) (*UpdateMonitoringOutput, error) {
	req, out := c.UpdateMonitoringRequest(input)
	return out, req.Send()
}

// UpdateMonitoringWithContext is the same as UpdateMonitoring with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitoring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) UpdateMonitoringWithContext(ctx aws.Context, input *UpdateMonitoringInput, opts ...request.Option) (*UpdateMonitoringOutput, error) {
	req, out := c.UpdateMonitoringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Returns information about an error.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the EBS volume upgrade information. The broker identifier must
// be set to the keyword ALL. This means the changes apply to all the brokers
// in the cluster.
type BrokerEBSVolumeInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the broker to update.
	//
	// KafkaBrokerNodeId is a required field
	KafkaBrokerNodeId *string `locationName:"kafkaBrokerNodeId" type:"string" required:"true"`

	// Size of the EBS volume to update.
	//
	// VolumeSizeGB is a required field
	VolumeSizeGB *int64 `locationName:"volumeSizeGB" type:"integer" required:"true"`
}

// String returns the string representation
func (s BrokerEBSVolumeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerEBSVolumeInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerEBSVolumeInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerEBSVolumeInfo"}
	if s.KafkaBrokerNodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaBrokerNodeId"))
	}
	if s.VolumeSizeGB == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSizeGB"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKafkaBrokerNodeId sets the KafkaBrokerNodeId field's value.
func (s *BrokerEBSVolumeInfo) SetKafkaBrokerNodeId(v string) *BrokerEBSVolumeInfo {
	s.KafkaBrokerNodeId = &v
	return s
}

// SetVolumeSizeGB sets the VolumeSizeGB field's value.
func (s *BrokerEBSVolumeInfo) SetVolumeSizeGB(v int64) *BrokerEBSVolumeInfo {
	s.VolumeSizeGB = &v
	return s
}

// The broker logs configuration for this MSK cluster.
type BrokerLogs struct {
	_ struct{} `type:"structure"`

	// Details of the CloudWatch Logs destination for broker logs.
	CloudWatchLogs *CloudWatchLogs `locationName:"cloudWatchLogs" type:"structure"`

	// Details of the Kinesis Data Firehose delivery stream that is the destination
	// for broker logs.
	Firehose *Firehose `locationName:"firehose" type:"structure"`

	// Details of the Amazon S3 destination for broker logs.
	S3 *S3 `locationName:"s3" type:"structure"`
}

// String returns the string representation
func (s BrokerLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerLogs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerLogs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerLogs"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *BrokerLogs) SetCloudWatchLogs(v *CloudWatchLogs) *BrokerLogs {
	s.CloudWatchLogs = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *BrokerLogs) SetFirehose(v *Firehose) *BrokerLogs {
	s.Firehose = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *BrokerLogs) SetS3(v *S3) *BrokerLogs {
	s.S3 = v
	return s
}

// Describes the setup to be used for Kafka broker nodes in the cluster.
type BrokerNodeGroupInfo struct {
	_ struct{} `type:"structure"`

	// The distribution of broker nodes across Availability Zones.
	BrokerAZDistribution *string `locationName:"brokerAZDistribution" type:"string" enum:"BrokerAZDistribution"`

	// The list of subnets to connect to in the client virtual private cloud (VPC).
	// AWS creates elastic network interfaces inside these subnets. Client applications
	// use elastic network interfaces to produce and consume data. Client subnets
	// can't be in Availability Zone us-east-1e.
	//
	// ClientSubnets is a required field
	ClientSubnets []*string `locationName:"clientSubnets" type:"list" required:"true"`

	// The type of Amazon EC2 instances to use for Kafka brokers. The following
	// instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge,
	// kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" min:"5" type:"string" required:"true"`

	// The AWS security groups to associate with the elastic network interfaces
	// in order to specify who can connect to and communicate with the Amazon MSK
	// cluster. If you don't specify a security group, Amazon MSK uses the default
	// security group associated with the VPC. If you specify security groups that
	// were shared with you, you must ensure that you have permissions to them.
	// Specifically, you need the ec2:DescribeSecurityGroups permission.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// Contains information about storage volumes attached to MSK broker nodes.
	StorageInfo *StorageInfo `locationName:"storageInfo" type:"structure"`
}

// String returns the string representation
func (s BrokerNodeGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerNodeGroupInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerNodeGroupInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerNodeGroupInfo"}
	if s.ClientSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSubnets"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 5))
	}
	if s.StorageInfo != nil {
		if err := s.StorageInfo.Validate(); err != nil {
			invalidParams.AddNested("StorageInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerAZDistribution sets the BrokerAZDistribution field's value.
func (s *BrokerNodeGroupInfo) SetBrokerAZDistribution(v string) *BrokerNodeGroupInfo {
	s.BrokerAZDistribution = &v
	return s
}

// SetClientSubnets sets the ClientSubnets field's value.
func (s *BrokerNodeGroupInfo) SetClientSubnets(v []*string) *BrokerNodeGroupInfo {
	s.ClientSubnets = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *BrokerNodeGroupInfo) SetInstanceType(v string) *BrokerNodeGroupInfo {
	s.InstanceType = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *BrokerNodeGroupInfo) SetSecurityGroups(v []*string) *BrokerNodeGroupInfo {
	s.SecurityGroups = v
	return s
}

// SetStorageInfo sets the StorageInfo field's value.
func (s *BrokerNodeGroupInfo) SetStorageInfo(v *StorageInfo) *BrokerNodeGroupInfo {
	s.StorageInfo = v
	return s
}

// BrokerNodeInfo
type BrokerNodeInfo struct {
	_ struct{} `type:"structure"`

	// The attached elastic network interface of the broker.
	AttachedENIId *string `locationName:"attachedENIId" type:"string"`

	// The ID of the broker.
	BrokerId *float64 `locationName:"brokerId" type:"double"`

	// The client subnet to which this broker node belongs.
	ClientSubnet *string `locationName:"clientSubnet" type:"string"`

	// The virtual private cloud (VPC) of the client.
	ClientVpcIpAddress *string `locationName:"clientVpcIpAddress" type:"string"`

	// Information about the version of software currently deployed on the Kafka
	// brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`

	// Endpoints for accessing the broker.
	Endpoints []*string `locationName:"endpoints" type:"list"`
}

// String returns the string representation
func (s BrokerNodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerNodeInfo) GoString() string {
	return s.String()
}

// SetAttachedENIId sets the AttachedENIId field's value.
func (s *BrokerNodeInfo) SetAttachedENIId(v string) *BrokerNodeInfo {
	s.AttachedENIId = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *BrokerNodeInfo) SetBrokerId(v float64) *BrokerNodeInfo {
	s.BrokerId = &v
	return s
}

// SetClientSubnet sets the ClientSubnet field's value.
func (s *BrokerNodeInfo) SetClientSubnet(v string) *BrokerNodeInfo {
	s.ClientSubnet = &v
	return s
}

// SetClientVpcIpAddress sets the ClientVpcIpAddress field's value.
func (s *BrokerNodeInfo) SetClientVpcIpAddress(v string) *BrokerNodeInfo {
	s.ClientVpcIpAddress = &v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *BrokerNodeInfo) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *BrokerNodeInfo {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *BrokerNodeInfo) SetEndpoints(v []*string) *BrokerNodeInfo {
	s.Endpoints = v
	return s
}

// Information about the current software installed on the cluster.
type BrokerSoftwareInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration used for the cluster.
	// This field isn't visible in this preview release.
	ConfigurationArn *string `locationName:"configurationArn" type:"string"`

	// The revision of the configuration to use. This field isn't visible in this
	// preview release.
	ConfigurationRevision *int64 `locationName:"configurationRevision" type:"long"`

	// The version of Apache Kafka.
	KafkaVersion *string `locationName:"kafkaVersion" type:"string"`
}

// String returns the string representation
func (s BrokerSoftwareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerSoftwareInfo) GoString() string {
	return s.String()
}

// SetConfigurationArn sets the ConfigurationArn field's value.
func (s *BrokerSoftwareInfo) SetConfigurationArn(v string) *BrokerSoftwareInfo {
	s.ConfigurationArn = &v
	return s
}

// SetConfigurationRevision sets the ConfigurationRevision field's value.
func (s *BrokerSoftwareInfo) SetConfigurationRevision(v int64) *BrokerSoftwareInfo {
	s.ConfigurationRevision = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *BrokerSoftwareInfo) SetKafkaVersion(v string) *BrokerSoftwareInfo {
	s.KafkaVersion = &v
	return s
}

// Includes all client authentication information.
type ClientAuthentication struct {
	_ struct{} `type:"structure"`

	// Details for ClientAuthentication using TLS.
	Tls *Tls `locationName:"tls" type:"structure"`
}

// String returns the string representation
func (s ClientAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientAuthentication) GoString() string {
	return s.String()
}

// SetTls sets the Tls field's value.
func (s *ClientAuthentication) SetTls(v *Tls) *ClientAuthentication {
	s.Tls = v
	return s
}

// Details of the CloudWatch Logs destination for broker logs.
type CloudWatchLogs struct {
	_ struct{} `type:"structure"`

	// Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The CloudWatch log group that is the destination for broker logs.
	LogGroup *string `locationName:"logGroup" type:"string"`
}

// String returns the string representation
func (s CloudWatchLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLogs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogs"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLogs) SetEnabled(v bool) *CloudWatchLogs {
	s.Enabled = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogs) SetLogGroup(v string) *CloudWatchLogs {
	s.LogGroup = &v
	return s
}

// Returns information about a cluster.
type ClusterInfo struct {
	_ struct{} `type:"structure"`

	// Arn of active cluster operation.
	ActiveOperationArn *string `locationName:"activeOperationArn" type:"string"`

	// Information about the broker nodes.
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure"`

	// Includes all client authentication information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The name of the cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The time when the cluster was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the version of software currently deployed on the Kafka
	// brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`

	// The current version of the MSK cluster. Cluster versions aren't simple integers.
	// You can obtain the current version by describing the cluster. An example
	// version is KTVPDKIKX0DER.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies which metrics are gathered for the MSK cluster. This property has
	// three possible values: DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER. For
	// a list of the metrics associated with each of these three levels of monitoring,
	// see Monitoring (https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// You can configure your MSK cluster to send broker logs to different destination
	// types. This is a container for the configuration details related to broker
	// logs.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The number of broker nodes in the cluster.
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" type:"integer"`

	// Settings for open monitoring using Prometheus.
	OpenMonitoring *OpenMonitoring `locationName:"openMonitoring" type:"structure"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`

	// Tags attached to the cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The connection string to use to connect to the Apache ZooKeeper cluster.
	ZookeeperConnectString *string `locationName:"zookeeperConnectString" type:"string"`
}

// String returns the string representation
func (s ClusterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterInfo) GoString() string {
	return s.String()
}

// SetActiveOperationArn sets the ActiveOperationArn field's value.
func (s *ClusterInfo) SetActiveOperationArn(v string) *ClusterInfo {
	s.ActiveOperationArn = &v
	return s
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *ClusterInfo) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *ClusterInfo {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *ClusterInfo) SetClientAuthentication(v *ClientAuthentication) *ClusterInfo {
	s.ClientAuthentication = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterInfo) SetClusterArn(v string) *ClusterInfo {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ClusterInfo) SetClusterName(v string) *ClusterInfo {
	s.ClusterName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ClusterInfo) SetCreationTime(v time.Time) *ClusterInfo {
	s.CreationTime = &v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *ClusterInfo) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *ClusterInfo {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ClusterInfo) SetCurrentVersion(v string) *ClusterInfo {
	s.CurrentVersion = &v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *ClusterInfo) SetEncryptionInfo(v *EncryptionInfo) *ClusterInfo {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *ClusterInfo) SetEnhancedMonitoring(v string) *ClusterInfo {
	s.EnhancedMonitoring = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *ClusterInfo) SetLoggingInfo(v *LoggingInfo) *ClusterInfo {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *ClusterInfo) SetNumberOfBrokerNodes(v int64) *ClusterInfo {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *ClusterInfo) SetOpenMonitoring(v *OpenMonitoring) *ClusterInfo {
	s.OpenMonitoring = v
	return s
}

// SetState sets the State field's value.
func (s *ClusterInfo) SetState(v string) *ClusterInfo {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterInfo) SetTags(v map[string]*string) *ClusterInfo {
	s.Tags = v
	return s
}

// SetZookeeperConnectString sets the ZookeeperConnectString field's value.
func (s *ClusterInfo) SetZookeeperConnectString(v string) *ClusterInfo {
	s.ZookeeperConnectString = &v
	return s
}

// Returns information about a cluster operation.
type ClusterOperationInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the API request that triggered this operation.
	ClientRequestId *string `locationName:"clientRequestId" type:"string"`

	// ARN of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The time at which operation was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The time at which the operation finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Describes the error if the operation fails.
	ErrorInfo *ErrorInfo `locationName:"errorInfo" type:"structure"`

	// ARN of the cluster operation.
	OperationArn *string `locationName:"operationArn" type:"string"`

	// State of the cluster operation.
	OperationState *string `locationName:"operationState" type:"string"`

	// Steps completed during the operation.
	OperationSteps []*ClusterOperationStep `locationName:"operationSteps" type:"list"`

	// Type of the cluster operation.
	OperationType *string `locationName:"operationType" type:"string"`

	// Information about cluster attributes before a cluster is updated.
	SourceClusterInfo *MutableClusterInfo `locationName:"sourceClusterInfo" type:"structure"`

	// Information about cluster attributes after a cluster is updated.
	TargetClusterInfo *MutableClusterInfo `locationName:"targetClusterInfo" type:"structure"`
}

// String returns the string representation
func (s ClusterOperationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterOperationInfo) GoString() string {
	return s.String()
}

// SetClientRequestId sets the ClientRequestId field's value.
func (s *ClusterOperationInfo) SetClientRequestId(v string) *ClusterOperationInfo {
	s.ClientRequestId = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterOperationInfo) SetClusterArn(v string) *ClusterOperationInfo {
	s.ClusterArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ClusterOperationInfo) SetCreationTime(v time.Time) *ClusterOperationInfo {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ClusterOperationInfo) SetEndTime(v time.Time) *ClusterOperationInfo {
	s.EndTime = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *ClusterOperationInfo) SetErrorInfo(v *ErrorInfo) *ClusterOperationInfo {
	s.ErrorInfo = v
	return s
}

// SetOperationArn sets the OperationArn field's value.
func (s *ClusterOperationInfo) SetOperationArn(v string) *ClusterOperationInfo {
	s.OperationArn = &v
	return s
}

// SetOperationState sets the OperationState field's value.
func (s *ClusterOperationInfo) SetOperationState(v string) *ClusterOperationInfo {
	s.OperationState = &v
	return s
}

// SetOperationSteps sets the OperationSteps field's value.
func (s *ClusterOperationInfo) SetOperationSteps(v []*ClusterOperationStep) *ClusterOperationInfo {
	s.OperationSteps = v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *ClusterOperationInfo) SetOperationType(v string) *ClusterOperationInfo {
	s.OperationType = &v
	return s
}

// SetSourceClusterInfo sets the SourceClusterInfo field's value.
func (s *ClusterOperationInfo) SetSourceClusterInfo(v *MutableClusterInfo) *ClusterOperationInfo {
	s.SourceClusterInfo = v
	return s
}

// SetTargetClusterInfo sets the TargetClusterInfo field's value.
func (s *ClusterOperationInfo) SetTargetClusterInfo(v *MutableClusterInfo) *ClusterOperationInfo {
	s.TargetClusterInfo = v
	return s
}

// Step taken during a cluster operation.
type ClusterOperationStep struct {
	_ struct{} `type:"structure"`

	// Information about the step and its status.
	StepInfo *ClusterOperationStepInfo `locationName:"stepInfo" type:"structure"`

	// The name of the step.
	StepName *string `locationName:"stepName" type:"string"`
}

// String returns the string representation
func (s ClusterOperationStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterOperationStep) GoString() string {
	return s.String()
}

// SetStepInfo sets the StepInfo field's value.
func (s *ClusterOperationStep) SetStepInfo(v *ClusterOperationStepInfo) *ClusterOperationStep {
	s.StepInfo = v
	return s
}

// SetStepName sets the StepName field's value.
func (s *ClusterOperationStep) SetStepName(v string) *ClusterOperationStep {
	s.StepName = &v
	return s
}

// State information about the operation step.
type ClusterOperationStepInfo struct {
	_ struct{} `type:"structure"`

	// The steps current status.
	StepStatus *string `locationName:"stepStatus" type:"string"`
}

// String returns the string representation
func (s ClusterOperationStepInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterOperationStepInfo) GoString() string {
	return s.String()
}

// SetStepStatus sets the StepStatus field's value.
func (s *ClusterOperationStepInfo) SetStepStatus(v string) *ClusterOperationStepInfo {
	s.StepStatus = &v
	return s
}

// Contains source Kafka versions and compatible target Kafka versions.
type CompatibleKafkaVersion struct {
	_ struct{} `type:"structure"`

	SourceVersion *string `locationName:"sourceVersion" type:"string"`

	TargetVersions []*string `locationName:"targetVersions" type:"list"`
}

// String returns the string representation
func (s CompatibleKafkaVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompatibleKafkaVersion) GoString() string {
	return s.String()
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CompatibleKafkaVersion) SetSourceVersion(v string) *CompatibleKafkaVersion {
	s.SourceVersion = &v
	return s
}

// SetTargetVersions sets the TargetVersions field's value.
func (s *CompatibleKafkaVersion) SetTargetVersions(v []*string) *CompatibleKafkaVersion {
	s.TargetVersions = v
	return s
}

// Represents an MSK Configuration.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configuration.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// An array of the versions of Apache Kafka with which you can use this MSK
	// configuration. You can use this configuration for an MSK cluster only if
	// the Apache Kafka version specified for the cluster appears in this array.
	//
	// KafkaVersions is a required field
	KafkaVersions []*string `locationName:"kafkaVersions" type:"list" required:"true"`

	// Latest revision of the configuration.
	//
	// LatestRevision is a required field
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure" required:"true"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Configuration) SetArn(v string) *Configuration {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Configuration) SetCreationTime(v time.Time) *Configuration {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Configuration) SetDescription(v string) *Configuration {
	s.Description = &v
	return s
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *Configuration) SetKafkaVersions(v []*string) *Configuration {
	s.KafkaVersions = v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *Configuration) SetLatestRevision(v *ConfigurationRevision) *Configuration {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *Configuration) SetName(v string) *Configuration {
	s.Name = &v
	return s
}

// Specifies the configuration to use for the brokers.
type ConfigurationInfo struct {
	_ struct{} `type:"structure"`

	// ARN of the configuration to use.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The revision of the configuration to use.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"long" required:"true"`
}

// String returns the string representation
func (s ConfigurationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationInfo"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ConfigurationInfo) SetArn(v string) *ConfigurationInfo {
	s.Arn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ConfigurationInfo) SetRevision(v int64) *ConfigurationInfo {
	s.Revision = &v
	return s
}

// Describes a configuration revision.
type ConfigurationRevision struct {
	_ struct{} `type:"structure"`

	// The time when the configuration revision was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configuration revision.
	Description *string `locationName:"description" type:"string"`

	// The revision number.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"long" required:"true"`
}

// String returns the string representation
func (s ConfigurationRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationRevision) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ConfigurationRevision) SetCreationTime(v time.Time) *ConfigurationRevision {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigurationRevision) SetDescription(v string) *ConfigurationRevision {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ConfigurationRevision) SetRevision(v int64) *ConfigurationRevision {
	s.Revision = &v
	return s
}

// Returns information about an error.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates a cluster.
type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Information about the broker nodes in the cluster.
	//
	// BrokerNodeGroupInfo is a required field
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure" required:"true"`

	// Includes all client authentication related information.
	ClientAuthentication *ClientAuthentication `locationName:"clientAuthentication" type:"structure"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" min:"1" type:"string" required:"true"`

	// Represents the configuration that you want MSK to use for the cluster.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies the level of monitoring for the MSK cluster. The possible values
	// are DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// The version of Apache Kafka.
	//
	// KafkaVersion is a required field
	KafkaVersion *string `locationName:"kafkaVersion" min:"1" type:"string" required:"true"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The number of Kafka broker nodes in the Amazon MSK cluster.
	//
	// NumberOfBrokerNodes is a required field
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" min:"1" type:"integer" required:"true"`

	// The settings for open monitoring.
	OpenMonitoring *OpenMonitoringInfo `locationName:"openMonitoring" type:"structure"`

	// Create tags when creating the cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.BrokerNodeGroupInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerNodeGroupInfo"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.KafkaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaVersion"))
	}
	if s.KafkaVersion != nil && len(*s.KafkaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KafkaVersion", 1))
	}
	if s.NumberOfBrokerNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfBrokerNodes"))
	}
	if s.NumberOfBrokerNodes != nil && *s.NumberOfBrokerNodes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBrokerNodes", 1))
	}
	if s.BrokerNodeGroupInfo != nil {
		if err := s.BrokerNodeGroupInfo.Validate(); err != nil {
			invalidParams.AddNested("BrokerNodeGroupInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionInfo != nil {
		if err := s.EncryptionInfo.Validate(); err != nil {
			invalidParams.AddNested("EncryptionInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.LoggingInfo != nil {
		if err := s.LoggingInfo.Validate(); err != nil {
			invalidParams.AddNested("LoggingInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenMonitoring != nil {
		if err := s.OpenMonitoring.Validate(); err != nil {
			invalidParams.AddNested("OpenMonitoring", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *CreateClusterInput) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *CreateClusterInput {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClientAuthentication sets the ClientAuthentication field's value.
func (s *CreateClusterInput) SetClientAuthentication(v *ClientAuthentication) *CreateClusterInput {
	s.ClientAuthentication = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *CreateClusterInput) SetConfigurationInfo(v *ConfigurationInfo) *CreateClusterInput {
	s.ConfigurationInfo = v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *CreateClusterInput) SetEncryptionInfo(v *EncryptionInfo) *CreateClusterInput {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *CreateClusterInput) SetEnhancedMonitoring(v string) *CreateClusterInput {
	s.EnhancedMonitoring = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *CreateClusterInput) SetKafkaVersion(v string) *CreateClusterInput {
	s.KafkaVersion = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *CreateClusterInput) SetLoggingInfo(v *LoggingInfo) *CreateClusterInput {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *CreateClusterInput) SetNumberOfBrokerNodes(v int64) *CreateClusterInput {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *CreateClusterInput) SetOpenMonitoring(v *OpenMonitoringInfo) *CreateClusterInput {
	s.OpenMonitoring = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// Returns information about the created cluster.
type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The name of the MSK cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateClusterOutput) SetClusterArn(v string) *CreateClusterOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterOutput) SetClusterName(v string) *CreateClusterOutput {
	s.ClusterName = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateClusterOutput) SetState(v string) *CreateClusterOutput {
	s.State = &v
	return s
}

// Request body for CreateConfiguration.
type CreateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The versions of Apache Kafka with which you can use this MSK configuration.
	KafkaVersions []*string `locationName:"kafkaVersions" type:"list"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// ServerProperties is automatically base64 encoded/decoded by the SDK.
	//
	// ServerProperties is a required field
	ServerProperties []byte `locationName:"serverProperties" type:"blob" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ServerProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateConfigurationInput) SetDescription(v string) *CreateConfigurationInput {
	s.Description = &v
	return s
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *CreateConfigurationInput) SetKafkaVersions(v []*string) *CreateConfigurationInput {
	s.KafkaVersions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationInput) SetName(v string) *CreateConfigurationInput {
	s.Name = &v
	return s
}

// SetServerProperties sets the ServerProperties field's value.
func (s *CreateConfigurationInput) SetServerProperties(v []byte) *CreateConfigurationInput {
	s.ServerProperties = v
	return s
}

// Response body for CreateConfiguration
type CreateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateConfigurationOutput) SetArn(v string) *CreateConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateConfigurationOutput) SetCreationTime(v time.Time) *CreateConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *CreateConfigurationOutput) SetLatestRevision(v *ConfigurationRevision) *CreateConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationOutput) SetName(v string) *CreateConfigurationOutput {
	s.Name = &v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	CurrentVersion *string `location:"querystring" locationName:"currentVersion" type:"string"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterInput) SetClusterArn(v string) *DeleteClusterInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *DeleteClusterInput) SetCurrentVersion(v string) *DeleteClusterInput {
	s.CurrentVersion = &v
	return s
}

// Returns information about the deleted cluster.
type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterOutput) SetClusterArn(v string) *DeleteClusterOutput {
	s.ClusterArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteClusterOutput) SetState(v string) *DeleteClusterOutput {
	s.State = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DescribeClusterInput) SetClusterArn(v string) *DescribeClusterInput {
	s.ClusterArn = &v
	return s
}

type DescribeClusterOperationInput struct {
	_ struct{} `type:"structure"`

	// ClusterOperationArn is a required field
	ClusterOperationArn *string `location:"uri" locationName:"clusterOperationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterOperationInput"}
	if s.ClusterOperationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterOperationArn"))
	}
	if s.ClusterOperationArn != nil && len(*s.ClusterOperationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterOperationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *DescribeClusterOperationInput) SetClusterOperationArn(v string) *DescribeClusterOperationInput {
	s.ClusterOperationArn = &v
	return s
}

// Information about a cluster operation.
type DescribeClusterOperationOutput struct {
	_ struct{} `type:"structure"`

	// Cluster operation information
	ClusterOperationInfo *ClusterOperationInfo `locationName:"clusterOperationInfo" type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOperationOutput) GoString() string {
	return s.String()
}

// SetClusterOperationInfo sets the ClusterOperationInfo field's value.
func (s *DescribeClusterOperationOutput) SetClusterOperationInfo(v *ClusterOperationInfo) *DescribeClusterOperationOutput {
	s.ClusterOperationInfo = v
	return s
}

// Returns information about a cluster.
type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster information.
	ClusterInfo *ClusterInfo `locationName:"clusterInfo" type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetClusterInfo sets the ClusterInfo field's value.
func (s *DescribeClusterOutput) SetClusterInfo(v *ClusterInfo) *DescribeClusterOutput {
	s.ClusterInfo = v
	return s
}

type DescribeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationInput) SetArn(v string) *DescribeConfigurationInput {
	s.Arn = &v
	return s
}

// Response body for DescribeConfiguration.
type DescribeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The versions of Apache Kafka with which you can use this MSK configuration.
	KafkaVersions []*string `locationName:"kafkaVersions" type:"list"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationOutput) SetArn(v string) *DescribeConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeConfigurationOutput) SetCreationTime(v time.Time) *DescribeConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConfigurationOutput) SetDescription(v string) *DescribeConfigurationOutput {
	s.Description = &v
	return s
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *DescribeConfigurationOutput) SetKafkaVersions(v []*string) *DescribeConfigurationOutput {
	s.KafkaVersions = v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *DescribeConfigurationOutput) SetLatestRevision(v *ConfigurationRevision) *DescribeConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeConfigurationOutput) SetName(v string) *DescribeConfigurationOutput {
	s.Name = &v
	return s
}

type DescribeConfigurationRevisionInput struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// Revision is a required field
	Revision *int64 `location:"uri" locationName:"revision" type:"long" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationRevisionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationRevisionInput) SetArn(v string) *DescribeConfigurationRevisionInput {
	s.Arn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *DescribeConfigurationRevisionInput) SetRevision(v int64) *DescribeConfigurationRevisionInput {
	s.Revision = &v
	return s
}

// Response body for DescribeConfigurationRevision.
type DescribeConfigurationRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The revision number.
	Revision *int64 `locationName:"revision" type:"long"`

	// ServerProperties is automatically base64 encoded/decoded by the SDK.
	ServerProperties []byte `locationName:"serverProperties" type:"blob"`
}

// String returns the string representation
func (s DescribeConfigurationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRevisionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationRevisionOutput) SetArn(v string) *DescribeConfigurationRevisionOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeConfigurationRevisionOutput) SetCreationTime(v time.Time) *DescribeConfigurationRevisionOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConfigurationRevisionOutput) SetDescription(v string) *DescribeConfigurationRevisionOutput {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *DescribeConfigurationRevisionOutput) SetRevision(v int64) *DescribeConfigurationRevisionOutput {
	s.Revision = &v
	return s
}

// SetServerProperties sets the ServerProperties field's value.
func (s *DescribeConfigurationRevisionOutput) SetServerProperties(v []byte) *DescribeConfigurationRevisionOutput {
	s.ServerProperties = v
	return s
}

// Contains information about the EBS storage volumes attached to Kafka broker
// nodes.
type EBSStorageInfo struct {
	_ struct{} `type:"structure"`

	// The size in GiB of the EBS volume for the data drive on each broker node.
	VolumeSize *int64 `locationName:"volumeSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s EBSStorageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSStorageInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EBSStorageInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EBSStorageInfo"}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSStorageInfo) SetVolumeSize(v int64) *EBSStorageInfo {
	s.VolumeSize = &v
	return s
}

// The data-volume encryption details.
type EncryptionAtRest struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS KMS key for encrypting data at rest. If you don't specify
	// a KMS key, MSK creates one for you and uses it.
	//
	// DataVolumeKMSKeyId is a required field
	DataVolumeKMSKeyId *string `locationName:"dataVolumeKMSKeyId" type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionAtRest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionAtRest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRest"}
	if s.DataVolumeKMSKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataVolumeKMSKeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataVolumeKMSKeyId sets the DataVolumeKMSKeyId field's value.
func (s *EncryptionAtRest) SetDataVolumeKMSKeyId(v string) *EncryptionAtRest {
	s.DataVolumeKMSKeyId = &v
	return s
}

// The settings for encrypting data in transit.
type EncryptionInTransit struct {
	_ struct{} `type:"structure"`

	// Indicates the encryption setting for data in transit between clients and
	// brokers. You must set it to one of the following values.
	//
	// TLS means that client-broker communication is enabled with TLS only.
	//
	// TLS_PLAINTEXT means that client-broker communication is enabled for both
	// TLS-encrypted, as well as plaintext data.
	//
	// PLAINTEXT means that client-broker communication is enabled in plaintext
	// only.
	//
	// The default value is TLS.
	ClientBroker *string `locationName:"clientBroker" type:"string" enum:"ClientBroker"`

	// When set to true, it indicates that data communication among the broker nodes
	// of the cluster is encrypted. When set to false, the communication happens
	// in plaintext.
	//
	// The default value is true.
	InCluster *bool `locationName:"inCluster" type:"boolean"`
}

// String returns the string representation
func (s EncryptionInTransit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionInTransit) GoString() string {
	return s.String()
}

// SetClientBroker sets the ClientBroker field's value.
func (s *EncryptionInTransit) SetClientBroker(v string) *EncryptionInTransit {
	s.ClientBroker = &v
	return s
}

// SetInCluster sets the InCluster field's value.
func (s *EncryptionInTransit) SetInCluster(v bool) *EncryptionInTransit {
	s.InCluster = &v
	return s
}

// Includes encryption-related information, such as the AWS KMS key used for
// encrypting data at rest and whether you want MSK to encrypt your data in
// transit.
type EncryptionInfo struct {
	_ struct{} `type:"structure"`

	// The data-volume encryption details.
	EncryptionAtRest *EncryptionAtRest `locationName:"encryptionAtRest" type:"structure"`

	// The details for encryption in transit.
	EncryptionInTransit *EncryptionInTransit `locationName:"encryptionInTransit" type:"structure"`
}

// String returns the string representation
func (s EncryptionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionInfo"}
	if s.EncryptionAtRest != nil {
		if err := s.EncryptionAtRest.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionAtRest sets the EncryptionAtRest field's value.
func (s *EncryptionInfo) SetEncryptionAtRest(v *EncryptionAtRest) *EncryptionInfo {
	s.EncryptionAtRest = v
	return s
}

// SetEncryptionInTransit sets the EncryptionInTransit field's value.
func (s *EncryptionInfo) SetEncryptionInTransit(v *EncryptionInTransit) *EncryptionInfo {
	s.EncryptionInTransit = v
	return s
}

// Returns information about an error state of the cluster.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// A number describing the error programmatically.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// An optional field to provide more details about the error.
	ErrorString *string `locationName:"errorString" type:"string"`
}

// String returns the string representation
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorInfo) SetErrorCode(v string) *ErrorInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorString sets the ErrorString field's value.
func (s *ErrorInfo) SetErrorString(v string) *ErrorInfo {
	s.ErrorString = &v
	return s
}

// Firehose details for BrokerLogs.
type Firehose struct {
	_ struct{} `type:"structure"`

	// The Kinesis Data Firehose delivery stream that is the destination for broker
	// logs.
	DeliveryStream *string `locationName:"deliveryStream" type:"string"`

	// Specifies whether broker logs get sent to the specified Kinesis Data Firehose
	// delivery stream.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s Firehose) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Firehose) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Firehose) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Firehose"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStream sets the DeliveryStream field's value.
func (s *Firehose) SetDeliveryStream(v string) *Firehose {
	s.DeliveryStream = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Firehose) SetEnabled(v bool) *Firehose {
	s.Enabled = &v
	return s
}

// Returns information about an error.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetBootstrapBrokersInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBootstrapBrokersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBootstrapBrokersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBootstrapBrokersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBootstrapBrokersInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetBootstrapBrokersInput) SetClusterArn(v string) *GetBootstrapBrokersInput {
	s.ClusterArn = &v
	return s
}

// Returns a string containing one or more hostname:port pairs.
type GetBootstrapBrokersOutput struct {
	_ struct{} `type:"structure"`

	// A string containing one or more hostname:port pairs.
	BootstrapBrokerString *string `locationName:"bootstrapBrokerString" type:"string"`

	// A string containing one or more DNS names (or IP) and TLS port pairs. The
	// following is an example.
	//  { "BootstrapBrokerStringTls": "b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094"}
	BootstrapBrokerStringTls *string `locationName:"bootstrapBrokerStringTls" type:"string"`
}

// String returns the string representation
func (s GetBootstrapBrokersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBootstrapBrokersOutput) GoString() string {
	return s.String()
}

// SetBootstrapBrokerString sets the BootstrapBrokerString field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerString(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerString = &v
	return s
}

// SetBootstrapBrokerStringTls sets the BootstrapBrokerStringTls field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerStringTls(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerStringTls = &v
	return s
}

type GetCompatibleKafkaVersionsInput struct {
	_ struct{} `type:"structure"`

	ClusterArn *string `location:"querystring" locationName:"clusterArn" type:"string"`
}

// String returns the string representation
func (s GetCompatibleKafkaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCompatibleKafkaVersionsInput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetCompatibleKafkaVersionsInput) SetClusterArn(v string) *GetCompatibleKafkaVersionsInput {
	s.ClusterArn = &v
	return s
}

// Response body for GetCompatibleKafkaVersions.
type GetCompatibleKafkaVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of CompatibleKafkaVersion objects.
	CompatibleKafkaVersions []*CompatibleKafkaVersion `locationName:"compatibleKafkaVersions" type:"list"`
}

// String returns the string representation
func (s GetCompatibleKafkaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCompatibleKafkaVersionsOutput) GoString() string {
	return s.String()
}

// SetCompatibleKafkaVersions sets the CompatibleKafkaVersions field's value.
func (s *GetCompatibleKafkaVersionsOutput) SetCompatibleKafkaVersions(v []*CompatibleKafkaVersion) *GetCompatibleKafkaVersionsOutput {
	s.CompatibleKafkaVersions = v
	return s
}

// Returns information about an error.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates whether you want to enable or disable the JMX Exporter.
type JmxExporter struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want to enable or disable the JMX Exporter.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation
func (s JmxExporter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JmxExporter) GoString() string {
	return s.String()
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *JmxExporter) SetEnabledInBroker(v bool) *JmxExporter {
	s.EnabledInBroker = &v
	return s
}

// Indicates whether you want to enable or disable the JMX Exporter.
type JmxExporterInfo struct {
	_ struct{} `type:"structure"`

	// JMX Exporter being enabled in broker.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation
func (s JmxExporterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JmxExporterInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JmxExporterInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JmxExporterInfo"}
	if s.EnabledInBroker == nil {
		invalidParams.Add(request.NewErrParamRequired("EnabledInBroker"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *JmxExporterInfo) SetEnabledInBroker(v bool) *JmxExporterInfo {
	s.EnabledInBroker = &v
	return s
}

// Information about a Kafka version.
type KafkaVersion struct {
	_ struct{} `type:"structure"`

	// The status of the Apache Kafka version.
	Status *string `locationName:"status" type:"string" enum:"KafkaVersionStatus"`

	// The Kafka version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s KafkaVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KafkaVersion) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *KafkaVersion) SetStatus(v string) *KafkaVersion {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *KafkaVersion) SetVersion(v string) *KafkaVersion {
	s.Version = &v
	return s
}

type ListClusterOperationsInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClusterOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClusterOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClusterOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClusterOperationsInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListClusterOperationsInput) SetClusterArn(v string) *ListClusterOperationsInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClusterOperationsInput) SetMaxResults(v int64) *ListClusterOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterOperationsInput) SetNextToken(v string) *ListClusterOperationsInput {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster operation information and
// a next token if the response is truncated.
type ListClusterOperationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of cluster operation information objects.
	ClusterOperationInfoList []*ClusterOperationInfo `locationName:"clusterOperationInfoList" type:"list"`

	// If the response of ListClusterOperations is truncated, it returns a NextToken
	// in the response. This Nexttoken should be sent in the subsequent request
	// to ListClusterOperations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClusterOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClusterOperationsOutput) GoString() string {
	return s.String()
}

// SetClusterOperationInfoList sets the ClusterOperationInfoList field's value.
func (s *ListClusterOperationsOutput) SetClusterOperationInfoList(v []*ClusterOperationInfo) *ListClusterOperationsOutput {
	s.ClusterOperationInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterOperationsOutput) SetNextToken(v string) *ListClusterOperationsOutput {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	ClusterNameFilter *string `location:"querystring" locationName:"clusterNameFilter" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterNameFilter sets the ClusterNameFilter field's value.
func (s *ListClustersInput) SetClusterNameFilter(v string) *ListClustersInput {
	s.ClusterNameFilter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster information and a next
// token if the response is truncated.
type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// Information on each of the MSK clusters in the response.
	ClusterInfoList []*ClusterInfo `locationName:"clusterInfoList" type:"list"`

	// The paginated results marker. When the result of a ListClusters operation
	// is truncated, the call returns NextToken in the response. To get another
	// batch of clusters, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterInfoList sets the ClusterInfoList field's value.
func (s *ListClustersOutput) SetClusterInfoList(v []*ClusterInfo) *ListClustersOutput {
	s.ClusterInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListConfigurationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationRevisionsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListConfigurationRevisionsInput) SetArn(v string) *ListConfigurationRevisionsInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationRevisionsInput) SetMaxResults(v int64) *ListConfigurationRevisionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationRevisionsInput) SetNextToken(v string) *ListConfigurationRevisionsInput {
	s.NextToken = &v
	return s
}

// Information about revisions of an MSK configuration.
type ListConfigurationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// Paginated results marker.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of ConfigurationRevision objects.
	Revisions []*ConfigurationRevision `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s ListConfigurationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationRevisionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationRevisionsOutput) SetNextToken(v string) *ListConfigurationRevisionsOutput {
	s.NextToken = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *ListConfigurationRevisionsOutput) SetRevisions(v []*ConfigurationRevision) *ListConfigurationRevisionsOutput {
	s.Revisions = v
	return s
}

type ListConfigurationsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationsInput) SetMaxResults(v int64) *ListConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsInput) SetNextToken(v string) *ListConfigurationsInput {
	s.NextToken = &v
	return s
}

// The response contains an array of Configuration and a next token if the response
// is truncated.
type ListConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of MSK configurations.
	Configurations []*Configuration `locationName:"configurations" type:"list"`

	// The paginated results marker. When the result of a ListConfigurations operation
	// is truncated, the call returns NextToken in the response. To get another
	// batch of configurations, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *ListConfigurationsOutput) SetConfigurations(v []*Configuration) *ListConfigurationsOutput {
	s.Configurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsOutput) SetNextToken(v string) *ListConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListKafkaVersionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListKafkaVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKafkaVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKafkaVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKafkaVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKafkaVersionsInput) SetMaxResults(v int64) *ListKafkaVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKafkaVersionsInput) SetNextToken(v string) *ListKafkaVersionsInput {
	s.NextToken = &v
	return s
}

// Response for ListKafkaVersions.
type ListKafkaVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Kafka version objects.
	KafkaVersions []*KafkaVersion `locationName:"kafkaVersions" type:"list"`

	// Paginated results marker.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListKafkaVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKafkaVersionsOutput) GoString() string {
	return s.String()
}

// SetKafkaVersions sets the KafkaVersions field's value.
func (s *ListKafkaVersionsOutput) SetKafkaVersions(v []*KafkaVersion) *ListKafkaVersionsOutput {
	s.KafkaVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKafkaVersionsOutput) SetNextToken(v string) *ListKafkaVersionsOutput {
	s.NextToken = &v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListNodesInput) SetClusterArn(v string) *ListNodesInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesInput) SetMaxResults(v int64) *ListNodesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesInput) SetNextToken(v string) *ListNodesInput {
	s.NextToken = &v
	return s
}

// Information about nodes in the cluster.
type ListNodesOutput struct {
	_ struct{} `type:"structure"`

	// The paginated results marker. When the result of a ListNodes operation is
	// truncated, the call returns NextToken in the response. To get another batch
	// of nodes, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List containing a NodeInfo object.
	NodeInfoList []*NodeInfo `locationName:"nodeInfoList" type:"list"`
}

// String returns the string representation
func (s ListNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesOutput) SetNextToken(v string) *ListNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodeInfoList sets the NodeInfoList field's value.
func (s *ListNodesOutput) SetNodeInfoList(v []*NodeInfo) *ListNodesOutput {
	s.NodeInfoList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// Response of listing tags for a resource.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// You can configure your MSK cluster to send broker logs to different destination
// types. This is a container for the configuration details related to broker
// logs.
type LoggingInfo struct {
	_ struct{} `type:"structure"`

	// You can configure your MSK cluster to send broker logs to different destination
	// types. This configuration specifies the details of these destinations.
	//
	// BrokerLogs is a required field
	BrokerLogs *BrokerLogs `locationName:"brokerLogs" type:"structure" required:"true"`
}

// String returns the string representation
func (s LoggingInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingInfo"}
	if s.BrokerLogs == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerLogs"))
	}
	if s.BrokerLogs != nil {
		if err := s.BrokerLogs.Validate(); err != nil {
			invalidParams.AddNested("BrokerLogs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerLogs sets the BrokerLogs field's value.
func (s *LoggingInfo) SetBrokerLogs(v *BrokerLogs) *LoggingInfo {
	s.BrokerLogs = v
	return s
}

// Information about cluster attributes that can be updated via update APIs.
type MutableClusterInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the size of the EBS volume and the ID of the associated broker.
	BrokerEBSVolumeInfo []*BrokerEBSVolumeInfo `locationName:"brokerEBSVolumeInfo" type:"list"`

	// Information about the changes in the configuration of the brokers.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon
	// CloudWatch for this cluster.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	KafkaVersion *string `locationName:"kafkaVersion" type:"string"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The number of broker nodes in the cluster.
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" type:"integer"`

	// Settings for open monitoring using Prometheus.
	OpenMonitoring *OpenMonitoring `locationName:"openMonitoring" type:"structure"`
}

// String returns the string representation
func (s MutableClusterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MutableClusterInfo) GoString() string {
	return s.String()
}

// SetBrokerEBSVolumeInfo sets the BrokerEBSVolumeInfo field's value.
func (s *MutableClusterInfo) SetBrokerEBSVolumeInfo(v []*BrokerEBSVolumeInfo) *MutableClusterInfo {
	s.BrokerEBSVolumeInfo = v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *MutableClusterInfo) SetConfigurationInfo(v *ConfigurationInfo) *MutableClusterInfo {
	s.ConfigurationInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *MutableClusterInfo) SetEnhancedMonitoring(v string) *MutableClusterInfo {
	s.EnhancedMonitoring = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *MutableClusterInfo) SetKafkaVersion(v string) *MutableClusterInfo {
	s.KafkaVersion = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *MutableClusterInfo) SetLoggingInfo(v *LoggingInfo) *MutableClusterInfo {
	s.LoggingInfo = v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *MutableClusterInfo) SetNumberOfBrokerNodes(v int64) *MutableClusterInfo {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *MutableClusterInfo) SetOpenMonitoring(v *OpenMonitoring) *MutableClusterInfo {
	s.OpenMonitoring = v
	return s
}

// Indicates whether you want to enable or disable the Node Exporter.
type NodeExporter struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want to enable or disable the Node Exporter.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation
func (s NodeExporter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeExporter) GoString() string {
	return s.String()
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *NodeExporter) SetEnabledInBroker(v bool) *NodeExporter {
	s.EnabledInBroker = &v
	return s
}

// Indicates whether you want to enable or disable the Node Exporter.
type NodeExporterInfo struct {
	_ struct{} `type:"structure"`

	// Node Exporter being enabled in broker.
	//
	// EnabledInBroker is a required field
	EnabledInBroker *bool `locationName:"enabledInBroker" type:"boolean" required:"true"`
}

// String returns the string representation
func (s NodeExporterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeExporterInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeExporterInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeExporterInfo"}
	if s.EnabledInBroker == nil {
		invalidParams.Add(request.NewErrParamRequired("EnabledInBroker"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabledInBroker sets the EnabledInBroker field's value.
func (s *NodeExporterInfo) SetEnabledInBroker(v bool) *NodeExporterInfo {
	s.EnabledInBroker = &v
	return s
}

// The node information object.
type NodeInfo struct {
	_ struct{} `type:"structure"`

	// The start time.
	AddedToClusterTime *string `locationName:"addedToClusterTime" type:"string"`

	// The broker node info.
	BrokerNodeInfo *BrokerNodeInfo `locationName:"brokerNodeInfo" type:"structure"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) of the node.
	NodeARN *string `locationName:"nodeARN" type:"string"`

	// The node type.
	NodeType *string `locationName:"nodeType" type:"string" enum:"NodeType"`

	// The ZookeeperNodeInfo.
	ZookeeperNodeInfo *ZookeeperNodeInfo `locationName:"zookeeperNodeInfo" type:"structure"`
}

// String returns the string representation
func (s NodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeInfo) GoString() string {
	return s.String()
}

// SetAddedToClusterTime sets the AddedToClusterTime field's value.
func (s *NodeInfo) SetAddedToClusterTime(v string) *NodeInfo {
	s.AddedToClusterTime = &v
	return s
}

// SetBrokerNodeInfo sets the BrokerNodeInfo field's value.
func (s *NodeInfo) SetBrokerNodeInfo(v *BrokerNodeInfo) *NodeInfo {
	s.BrokerNodeInfo = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *NodeInfo) SetInstanceType(v string) *NodeInfo {
	s.InstanceType = &v
	return s
}

// SetNodeARN sets the NodeARN field's value.
func (s *NodeInfo) SetNodeARN(v string) *NodeInfo {
	s.NodeARN = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeInfo) SetNodeType(v string) *NodeInfo {
	s.NodeType = &v
	return s
}

// SetZookeeperNodeInfo sets the ZookeeperNodeInfo field's value.
func (s *NodeInfo) SetZookeeperNodeInfo(v *ZookeeperNodeInfo) *NodeInfo {
	s.ZookeeperNodeInfo = v
	return s
}

// Returns information about an error.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// JMX and Node monitoring for the MSK cluster.
type OpenMonitoring struct {
	_ struct{} `type:"structure"`

	// Prometheus settings.
	//
	// Prometheus is a required field
	Prometheus *Prometheus `locationName:"prometheus" type:"structure" required:"true"`
}

// String returns the string representation
func (s OpenMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenMonitoring) GoString() string {
	return s.String()
}

// SetPrometheus sets the Prometheus field's value.
func (s *OpenMonitoring) SetPrometheus(v *Prometheus) *OpenMonitoring {
	s.Prometheus = v
	return s
}

// JMX and Node monitoring for the MSK cluster.
type OpenMonitoringInfo struct {
	_ struct{} `type:"structure"`

	// Prometheus settings.
	//
	// Prometheus is a required field
	Prometheus *PrometheusInfo `locationName:"prometheus" type:"structure" required:"true"`
}

// String returns the string representation
func (s OpenMonitoringInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenMonitoringInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenMonitoringInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenMonitoringInfo"}
	if s.Prometheus == nil {
		invalidParams.Add(request.NewErrParamRequired("Prometheus"))
	}
	if s.Prometheus != nil {
		if err := s.Prometheus.Validate(); err != nil {
			invalidParams.AddNested("Prometheus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrometheus sets the Prometheus field's value.
func (s *OpenMonitoringInfo) SetPrometheus(v *PrometheusInfo) *OpenMonitoringInfo {
	s.Prometheus = v
	return s
}

// Prometheus settings for open monitoring.
type Prometheus struct {
	_ struct{} `type:"structure"`

	// Indicates whether you want to enable or disable the JMX Exporter.
	JmxExporter *JmxExporter `locationName:"jmxExporter" type:"structure"`

	// Indicates whether you want to enable or disable the Node Exporter.
	NodeExporter *NodeExporter `locationName:"nodeExporter" type:"structure"`
}

// String returns the string representation
func (s Prometheus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Prometheus) GoString() string {
	return s.String()
}

// SetJmxExporter sets the JmxExporter field's value.
func (s *Prometheus) SetJmxExporter(v *JmxExporter) *Prometheus {
	s.JmxExporter = v
	return s
}

// SetNodeExporter sets the NodeExporter field's value.
func (s *Prometheus) SetNodeExporter(v *NodeExporter) *Prometheus {
	s.NodeExporter = v
	return s
}

// Prometheus settings.
type PrometheusInfo struct {
	_ struct{} `type:"structure"`

	// JMX Exporter settings.
	JmxExporter *JmxExporterInfo `locationName:"jmxExporter" type:"structure"`

	// Node Exporter settings.
	NodeExporter *NodeExporterInfo `locationName:"nodeExporter" type:"structure"`
}

// String returns the string representation
func (s PrometheusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrometheusInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrometheusInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrometheusInfo"}
	if s.JmxExporter != nil {
		if err := s.JmxExporter.Validate(); err != nil {
			invalidParams.AddNested("JmxExporter", err.(request.ErrInvalidParams))
		}
	}
	if s.NodeExporter != nil {
		if err := s.NodeExporter.Validate(); err != nil {
			invalidParams.AddNested("NodeExporter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJmxExporter sets the JmxExporter field's value.
func (s *PrometheusInfo) SetJmxExporter(v *JmxExporterInfo) *PrometheusInfo {
	s.JmxExporter = v
	return s
}

// SetNodeExporter sets the NodeExporter field's value.
func (s *PrometheusInfo) SetNodeExporter(v *NodeExporterInfo) *PrometheusInfo {
	s.NodeExporter = v
	return s
}

// Request body for RebootBrokerNode action.
type RebootBrokerInput struct {
	_ struct{} `type:"structure"`

	// The list of broker ids to be rebooted.
	//
	// BrokerIds is a required field
	BrokerIds []*string `locationName:"brokerIds" type:"list" required:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootBrokerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootBrokerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootBrokerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootBrokerInput"}
	if s.BrokerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerIds"))
	}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerIds sets the BrokerIds field's value.
func (s *RebootBrokerInput) SetBrokerIds(v []*string) *RebootBrokerInput {
	s.BrokerIds = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *RebootBrokerInput) SetClusterArn(v string) *RebootBrokerInput {
	s.ClusterArn = &v
	return s
}

// Response body for RebootBrokers action.
type RebootBrokerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation
func (s RebootBrokerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootBrokerOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *RebootBrokerOutput) SetClusterArn(v string) *RebootBrokerOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *RebootBrokerOutput) SetClusterOperationArn(v string) *RebootBrokerOutput {
	s.ClusterOperationArn = &v
	return s
}

// The details of the Amazon S3 destination for broker logs.
type S3 struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that is the destination for broker logs.
	Bucket *string `locationName:"bucket" type:"string"`

	// Specifies whether broker logs get sent to the specified Amazon S3 destination.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The S3 prefix that is the destination for broker logs.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s S3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3) SetBucket(v string) *S3 {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *S3) SetEnabled(v bool) *S3 {
	s.Enabled = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3) SetPrefix(v string) *S3 {
	s.Prefix = &v
	return s
}

// Returns information about an error.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about storage volumes attached to MSK broker nodes.
type StorageInfo struct {
	_ struct{} `type:"structure"`

	// EBS volume information.
	EbsStorageInfo *EBSStorageInfo `locationName:"ebsStorageInfo" type:"structure"`
}

// String returns the string representation
func (s StorageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageInfo"}
	if s.EbsStorageInfo != nil {
		if err := s.EbsStorageInfo.Validate(); err != nil {
			invalidParams.AddNested("EbsStorageInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEbsStorageInfo sets the EbsStorageInfo field's value.
func (s *StorageInfo) SetEbsStorageInfo(v *EBSStorageInfo) *StorageInfo {
	s.EbsStorageInfo = v
	return s
}

// Tag a resource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The key-value pair for the resource tag.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Details for client authentication using TLS.
type Tls struct {
	_ struct{} `type:"structure"`

	// List of ACM Certificate Authority ARNs.
	CertificateAuthorityArnList []*string `locationName:"certificateAuthorityArnList" type:"list"`
}

// String returns the string representation
func (s Tls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tls) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArnList sets the CertificateAuthorityArnList field's value.
func (s *Tls) SetCertificateAuthorityArnList(v []*string) *Tls {
	s.CertificateAuthorityArnList = v
	return s
}

// Returns information about an error.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns information about an error.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	InvalidParameter *string `locationName:"invalidParameter" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Request body for UpdateBrokerCount.
type UpdateBrokerCountInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The current version of the cluster.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// The number of broker nodes that you want the cluster to have after this operation
	// completes successfully.
	//
	// TargetNumberOfBrokerNodes is a required field
	TargetNumberOfBrokerNodes *int64 `locationName:"targetNumberOfBrokerNodes" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateBrokerCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBrokerCountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrokerCountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrokerCountInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetNumberOfBrokerNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetNumberOfBrokerNodes"))
	}
	if s.TargetNumberOfBrokerNodes != nil && *s.TargetNumberOfBrokerNodes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetNumberOfBrokerNodes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerCountInput) SetClusterArn(v string) *UpdateBrokerCountInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateBrokerCountInput) SetCurrentVersion(v string) *UpdateBrokerCountInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetNumberOfBrokerNodes sets the TargetNumberOfBrokerNodes field's value.
func (s *UpdateBrokerCountInput) SetTargetNumberOfBrokerNodes(v int64) *UpdateBrokerCountInput {
	s.TargetNumberOfBrokerNodes = &v
	return s
}

// Response body for UpdateBrokerCount.
type UpdateBrokerCountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation
func (s UpdateBrokerCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBrokerCountOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerCountOutput) SetClusterArn(v string) *UpdateBrokerCountOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateBrokerCountOutput) SetClusterOperationArn(v string) *UpdateBrokerCountOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request object for UpdateBrokerStorage.
type UpdateBrokerStorageInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The version of cluster to update from. A successful operation will then generate
	// a new version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Describes the target volume size and the ID of the broker to apply the update
	// to.
	//
	// The value you specify for Target-Volume-in-GiB must be a whole number that
	// is greater than 100 GiB.
	//
	// The storage per broker after the update operation can't exceed 16384 GiB.
	//
	// TargetBrokerEBSVolumeInfo is a required field
	TargetBrokerEBSVolumeInfo []*BrokerEBSVolumeInfo `locationName:"targetBrokerEBSVolumeInfo" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateBrokerStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBrokerStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrokerStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrokerStorageInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetBrokerEBSVolumeInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetBrokerEBSVolumeInfo"))
	}
	if s.TargetBrokerEBSVolumeInfo != nil {
		for i, v := range s.TargetBrokerEBSVolumeInfo {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetBrokerEBSVolumeInfo", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerStorageInput) SetClusterArn(v string) *UpdateBrokerStorageInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateBrokerStorageInput) SetCurrentVersion(v string) *UpdateBrokerStorageInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetBrokerEBSVolumeInfo sets the TargetBrokerEBSVolumeInfo field's value.
func (s *UpdateBrokerStorageInput) SetTargetBrokerEBSVolumeInfo(v []*BrokerEBSVolumeInfo) *UpdateBrokerStorageInput {
	s.TargetBrokerEBSVolumeInfo = v
	return s
}

// Response body for UpdateBrokerStorage.
type UpdateBrokerStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation
func (s UpdateBrokerStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBrokerStorageOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateBrokerStorageOutput) SetClusterArn(v string) *UpdateBrokerStorageOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateBrokerStorageOutput) SetClusterOperationArn(v string) *UpdateBrokerStorageOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateClusterConfiguration.
type UpdateClusterConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// Represents the configuration that you want MSK to use for the cluster.
	//
	// ConfigurationInfo is a required field
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure" required:"true"`

	// The version of the cluster that you want to update.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateClusterConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterConfigurationInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.ConfigurationInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationInfo"))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterConfigurationInput) SetClusterArn(v string) *UpdateClusterConfigurationInput {
	s.ClusterArn = &v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *UpdateClusterConfigurationInput) SetConfigurationInfo(v *ConfigurationInfo) *UpdateClusterConfigurationInput {
	s.ConfigurationInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateClusterConfigurationInput) SetCurrentVersion(v string) *UpdateClusterConfigurationInput {
	s.CurrentVersion = &v
	return s
}

// Response body for UpdateClusterConfiguration.
type UpdateClusterConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation
func (s UpdateClusterConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterConfigurationOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterConfigurationOutput) SetClusterArn(v string) *UpdateClusterConfigurationOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateClusterConfigurationOutput) SetClusterOperationArn(v string) *UpdateClusterConfigurationOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateClusterKafkaVersion.
type UpdateClusterKafkaVersionInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// Specifies the configuration to use for the brokers.
	ConfigurationInfo *ConfigurationInfo `locationName:"configurationInfo" type:"structure"`

	// Current cluster version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Target Kafka version.
	//
	// TargetKafkaVersion is a required field
	TargetKafkaVersion *string `locationName:"targetKafkaVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateClusterKafkaVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterKafkaVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterKafkaVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterKafkaVersionInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.TargetKafkaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKafkaVersion"))
	}
	if s.ConfigurationInfo != nil {
		if err := s.ConfigurationInfo.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterKafkaVersionInput) SetClusterArn(v string) *UpdateClusterKafkaVersionInput {
	s.ClusterArn = &v
	return s
}

// SetConfigurationInfo sets the ConfigurationInfo field's value.
func (s *UpdateClusterKafkaVersionInput) SetConfigurationInfo(v *ConfigurationInfo) *UpdateClusterKafkaVersionInput {
	s.ConfigurationInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateClusterKafkaVersionInput) SetCurrentVersion(v string) *UpdateClusterKafkaVersionInput {
	s.CurrentVersion = &v
	return s
}

// SetTargetKafkaVersion sets the TargetKafkaVersion field's value.
func (s *UpdateClusterKafkaVersionInput) SetTargetKafkaVersion(v string) *UpdateClusterKafkaVersionInput {
	s.TargetKafkaVersion = &v
	return s
}

// Response body for UpdateClusterKafkaVersion.
type UpdateClusterKafkaVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation
func (s UpdateClusterKafkaVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterKafkaVersionOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterKafkaVersionOutput) SetClusterArn(v string) *UpdateClusterKafkaVersionOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateClusterKafkaVersionOutput) SetClusterOperationArn(v string) *UpdateClusterKafkaVersionOutput {
	s.ClusterOperationArn = &v
	return s
}

// Request body for UpdateMonitoring.
type UpdateMonitoringInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The version of cluster to update from. A successful operation will then generate
	// a new version.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `locationName:"currentVersion" type:"string" required:"true"`

	// Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon
	// CloudWatch for this cluster.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// LoggingInfo details.
	LoggingInfo *LoggingInfo `locationName:"loggingInfo" type:"structure"`

	// The settings for open monitoring.
	OpenMonitoring *OpenMonitoringInfo `locationName:"openMonitoring" type:"structure"`
}

// String returns the string representation
func (s UpdateMonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMonitoringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMonitoringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMonitoringInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.LoggingInfo != nil {
		if err := s.LoggingInfo.Validate(); err != nil {
			invalidParams.AddNested("LoggingInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenMonitoring != nil {
		if err := s.OpenMonitoring.Validate(); err != nil {
			invalidParams.AddNested("OpenMonitoring", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateMonitoringInput) SetClusterArn(v string) *UpdateMonitoringInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateMonitoringInput) SetCurrentVersion(v string) *UpdateMonitoringInput {
	s.CurrentVersion = &v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *UpdateMonitoringInput) SetEnhancedMonitoring(v string) *UpdateMonitoringInput {
	s.EnhancedMonitoring = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *UpdateMonitoringInput) SetLoggingInfo(v *LoggingInfo) *UpdateMonitoringInput {
	s.LoggingInfo = v
	return s
}

// SetOpenMonitoring sets the OpenMonitoring field's value.
func (s *UpdateMonitoringInput) SetOpenMonitoring(v *OpenMonitoringInfo) *UpdateMonitoringInput {
	s.OpenMonitoring = v
	return s
}

// Response body for UpdateMonitoring.
type UpdateMonitoringOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster operation.
	ClusterOperationArn *string `locationName:"clusterOperationArn" type:"string"`
}

// String returns the string representation
func (s UpdateMonitoringOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMonitoringOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateMonitoringOutput) SetClusterArn(v string) *UpdateMonitoringOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterOperationArn sets the ClusterOperationArn field's value.
func (s *UpdateMonitoringOutput) SetClusterOperationArn(v string) *UpdateMonitoringOutput {
	s.ClusterOperationArn = &v
	return s
}

// Zookeeper node information.
type ZookeeperNodeInfo struct {
	_ struct{} `type:"structure"`

	// The attached elastic network interface of the broker.
	AttachedENIId *string `locationName:"attachedENIId" type:"string"`

	// The virtual private cloud (VPC) IP address of the client.
	ClientVpcIpAddress *string `locationName:"clientVpcIpAddress" type:"string"`

	// Endpoints for accessing the ZooKeeper.
	Endpoints []*string `locationName:"endpoints" type:"list"`

	// The role-specific ID for Zookeeper.
	ZookeeperId *float64 `locationName:"zookeeperId" type:"double"`

	// The version of Zookeeper.
	ZookeeperVersion *string `locationName:"zookeeperVersion" type:"string"`
}

// String returns the string representation
func (s ZookeeperNodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZookeeperNodeInfo) GoString() string {
	return s.String()
}

// SetAttachedENIId sets the AttachedENIId field's value.
func (s *ZookeeperNodeInfo) SetAttachedENIId(v string) *ZookeeperNodeInfo {
	s.AttachedENIId = &v
	return s
}

// SetClientVpcIpAddress sets the ClientVpcIpAddress field's value.
func (s *ZookeeperNodeInfo) SetClientVpcIpAddress(v string) *ZookeeperNodeInfo {
	s.ClientVpcIpAddress = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *ZookeeperNodeInfo) SetEndpoints(v []*string) *ZookeeperNodeInfo {
	s.Endpoints = v
	return s
}

// SetZookeeperId sets the ZookeeperId field's value.
func (s *ZookeeperNodeInfo) SetZookeeperId(v float64) *ZookeeperNodeInfo {
	s.ZookeeperId = &v
	return s
}

// SetZookeeperVersion sets the ZookeeperVersion field's value.
func (s *ZookeeperNodeInfo) SetZookeeperVersion(v string) *ZookeeperNodeInfo {
	s.ZookeeperVersion = &v
	return s
}

// The distribution of broker nodes across Availability Zones. By default, broker
// nodes are distributed among the Availability Zones of your Region. Currently,
// the only supported value is DEFAULT. You can either specify this value explicitly
// or leave it out.
const (
	// BrokerAZDistributionDefault is a BrokerAZDistribution enum value
	BrokerAZDistributionDefault = "DEFAULT"
)

// Client-broker encryption in transit setting.
const (
	// ClientBrokerTls is a ClientBroker enum value
	ClientBrokerTls = "TLS"

	// ClientBrokerTlsPlaintext is a ClientBroker enum value
	ClientBrokerTlsPlaintext = "TLS_PLAINTEXT"

	// ClientBrokerPlaintext is a ClientBroker enum value
	ClientBrokerPlaintext = "PLAINTEXT"
)

// The state of a Kafka cluster.
const (
	// ClusterStateActive is a ClusterState enum value
	ClusterStateActive = "ACTIVE"

	// ClusterStateCreating is a ClusterState enum value
	ClusterStateCreating = "CREATING"

	// ClusterStateUpdating is a ClusterState enum value
	ClusterStateUpdating = "UPDATING"

	// ClusterStateDeleting is a ClusterState enum value
	ClusterStateDeleting = "DELETING"

	// ClusterStateFailed is a ClusterState enum value
	ClusterStateFailed = "FAILED"
)

// Specifies which metrics are gathered for the MSK cluster. This property has
// three possible values: DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER. For
// a list of the metrics associated with each of these three levels of monitoring,
// see Monitoring (https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
const (
	// EnhancedMonitoringDefault is a EnhancedMonitoring enum value
	EnhancedMonitoringDefault = "DEFAULT"

	// EnhancedMonitoringPerBroker is a EnhancedMonitoring enum value
	EnhancedMonitoringPerBroker = "PER_BROKER"

	// EnhancedMonitoringPerTopicPerBroker is a EnhancedMonitoring enum value
	EnhancedMonitoringPerTopicPerBroker = "PER_TOPIC_PER_BROKER"
)

// The status of a Kafka version.
const (
	// KafkaVersionStatusActive is a KafkaVersionStatus enum value
	KafkaVersionStatusActive = "ACTIVE"

	// KafkaVersionStatusDeprecated is a KafkaVersionStatus enum value
	KafkaVersionStatusDeprecated = "DEPRECATED"
)

// The broker or Zookeeper node.
const (
	// NodeTypeBroker is a NodeType enum value
	NodeTypeBroker = "BROKER"
)
