// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateApp
func (c *SMS) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for AWS Server Migration Service.
//
// Creates an application. An application consists of one or more server groups.
// Each server group contain one or more servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation CreateApp for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateApp
func (c *SMS) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationJob = "CreateReplicationJob"

// CreateReplicationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationJob for more information on using the CreateReplicationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationJobRequest method.
//    req, resp := client.CreateReplicationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJob
func (c *SMS) CreateReplicationJobRequest(input *CreateReplicationJobInput) (req *request.Request, output *CreateReplicationJobOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationJobInput{}
	}

	output = &CreateReplicationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationJob API operation for AWS Server Migration Service.
//
// Creates a replication job. The replication job schedules periodic replication
// runs to replicate your server to AWS. Each replication run creates an Amazon
// Machine Image (AMI).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation CreateReplicationJob for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * ServerCannotBeReplicatedException
//   The specified server cannot be replicated.
//
//   * ReplicationJobAlreadyExistsException
//   The specified replication job already exists.
//
//   * NoConnectorsAvailableException
//   There are no connectors available.
//
//   * InternalError
//   An internal error occurred.
//
//   * TemporarilyUnavailableException
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJob
func (c *SMS) CreateReplicationJob(input *CreateReplicationJobInput) (*CreateReplicationJobOutput, error) {
	req, out := c.CreateReplicationJobRequest(input)
	return out, req.Send()
}

// CreateReplicationJobWithContext is the same as CreateReplicationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) CreateReplicationJobWithContext(ctx aws.Context, input *CreateReplicationJobInput, opts ...request.Option) (*CreateReplicationJobOutput, error) {
	req, out := c.CreateReplicationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteApp
func (c *SMS) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApp API operation for AWS Server Migration Service.
//
// Deletes the specified application. Optionally deletes the launched stack
// associated with the application and all AWS SMS replication jobs for servers
// in the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteApp
func (c *SMS) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppLaunchConfiguration = "DeleteAppLaunchConfiguration"

// DeleteAppLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppLaunchConfiguration for more information on using the DeleteAppLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppLaunchConfigurationRequest method.
//    req, resp := client.DeleteAppLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfiguration
func (c *SMS) DeleteAppLaunchConfigurationRequest(input *DeleteAppLaunchConfigurationInput) (req *request.Request, output *DeleteAppLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteAppLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppLaunchConfigurationInput{}
	}

	output = &DeleteAppLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppLaunchConfiguration API operation for AWS Server Migration Service.
//
// Deletes the launch configuration for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteAppLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfiguration
func (c *SMS) DeleteAppLaunchConfiguration(input *DeleteAppLaunchConfigurationInput) (*DeleteAppLaunchConfigurationOutput, error) {
	req, out := c.DeleteAppLaunchConfigurationRequest(input)
	return out, req.Send()
}

// DeleteAppLaunchConfigurationWithContext is the same as DeleteAppLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteAppLaunchConfigurationWithContext(ctx aws.Context, input *DeleteAppLaunchConfigurationInput, opts ...request.Option) (*DeleteAppLaunchConfigurationOutput, error) {
	req, out := c.DeleteAppLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppReplicationConfiguration = "DeleteAppReplicationConfiguration"

// DeleteAppReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppReplicationConfiguration for more information on using the DeleteAppReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppReplicationConfigurationRequest method.
//    req, resp := client.DeleteAppReplicationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppReplicationConfiguration
func (c *SMS) DeleteAppReplicationConfigurationRequest(input *DeleteAppReplicationConfigurationInput) (req *request.Request, output *DeleteAppReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteAppReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppReplicationConfigurationInput{}
	}

	output = &DeleteAppReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppReplicationConfiguration API operation for AWS Server Migration Service.
//
// Deletes the replication configuration for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteAppReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppReplicationConfiguration
func (c *SMS) DeleteAppReplicationConfiguration(input *DeleteAppReplicationConfigurationInput) (*DeleteAppReplicationConfigurationOutput, error) {
	req, out := c.DeleteAppReplicationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteAppReplicationConfigurationWithContext is the same as DeleteAppReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteAppReplicationConfigurationWithContext(ctx aws.Context, input *DeleteAppReplicationConfigurationInput, opts ...request.Option) (*DeleteAppReplicationConfigurationOutput, error) {
	req, out := c.DeleteAppReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppValidationConfiguration = "DeleteAppValidationConfiguration"

// DeleteAppValidationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppValidationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppValidationConfiguration for more information on using the DeleteAppValidationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppValidationConfigurationRequest method.
//    req, resp := client.DeleteAppValidationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppValidationConfiguration
func (c *SMS) DeleteAppValidationConfigurationRequest(input *DeleteAppValidationConfigurationInput) (req *request.Request, output *DeleteAppValidationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteAppValidationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppValidationConfigurationInput{}
	}

	output = &DeleteAppValidationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppValidationConfiguration API operation for AWS Server Migration Service.
//
// Deletes the validation configuration for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteAppValidationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppValidationConfiguration
func (c *SMS) DeleteAppValidationConfiguration(input *DeleteAppValidationConfigurationInput) (*DeleteAppValidationConfigurationOutput, error) {
	req, out := c.DeleteAppValidationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteAppValidationConfigurationWithContext is the same as DeleteAppValidationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppValidationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteAppValidationConfigurationWithContext(ctx aws.Context, input *DeleteAppValidationConfigurationInput, opts ...request.Option) (*DeleteAppValidationConfigurationOutput, error) {
	req, out := c.DeleteAppValidationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationJob = "DeleteReplicationJob"

// DeleteReplicationJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationJob for more information on using the DeleteReplicationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationJobRequest method.
//    req, resp := client.DeleteReplicationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob
func (c *SMS) DeleteReplicationJobRequest(input *DeleteReplicationJobInput) (req *request.Request, output *DeleteReplicationJobOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationJobInput{}
	}

	output = &DeleteReplicationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationJob API operation for AWS Server Migration Service.
//
// Deletes the specified replication job.
//
// After you delete a replication job, there are no further replication runs.
// AWS deletes the contents of the Amazon S3 bucket used to store AWS SMS artifacts.
// The AMIs created by the replication runs are not deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteReplicationJob for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * ReplicationJobNotFoundException
//   The specified replication job does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob
func (c *SMS) DeleteReplicationJob(input *DeleteReplicationJobInput) (*DeleteReplicationJobOutput, error) {
	req, out := c.DeleteReplicationJobRequest(input)
	return out, req.Send()
}

// DeleteReplicationJobWithContext is the same as DeleteReplicationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteReplicationJobWithContext(ctx aws.Context, input *DeleteReplicationJobInput, opts ...request.Option) (*DeleteReplicationJobOutput, error) {
	req, out := c.DeleteReplicationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServerCatalog = "DeleteServerCatalog"

// DeleteServerCatalogRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServerCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServerCatalog for more information on using the DeleteServerCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServerCatalogRequest method.
//    req, resp := client.DeleteServerCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog
func (c *SMS) DeleteServerCatalogRequest(input *DeleteServerCatalogInput) (req *request.Request, output *DeleteServerCatalogOutput) {
	op := &request.Operation{
		Name:       opDeleteServerCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerCatalogInput{}
	}

	output = &DeleteServerCatalogOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServerCatalog API operation for AWS Server Migration Service.
//
// Deletes all servers from your server catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteServerCatalog for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog
func (c *SMS) DeleteServerCatalog(input *DeleteServerCatalogInput) (*DeleteServerCatalogOutput, error) {
	req, out := c.DeleteServerCatalogRequest(input)
	return out, req.Send()
}

// DeleteServerCatalogWithContext is the same as DeleteServerCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServerCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteServerCatalogWithContext(ctx aws.Context, input *DeleteServerCatalogInput, opts ...request.Option) (*DeleteServerCatalogOutput, error) {
	req, out := c.DeleteServerCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConnector = "DisassociateConnector"

// DisassociateConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConnector for more information on using the DisassociateConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateConnectorRequest method.
//    req, resp := client.DisassociateConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector
func (c *SMS) DisassociateConnectorRequest(input *DisassociateConnectorInput) (req *request.Request, output *DisassociateConnectorOutput) {
	op := &request.Operation{
		Name:       opDisassociateConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectorInput{}
	}

	output = &DisassociateConnectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateConnector API operation for AWS Server Migration Service.
//
// Disassociates the specified connector from AWS SMS.
//
// After you disassociate a connector, it is no longer available to support
// replication jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DisassociateConnector for usage and error information.
//
// Returned Error Types:
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector
func (c *SMS) DisassociateConnector(input *DisassociateConnectorInput) (*DisassociateConnectorOutput, error) {
	req, out := c.DisassociateConnectorRequest(input)
	return out, req.Send()
}

// DisassociateConnectorWithContext is the same as DisassociateConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DisassociateConnectorWithContext(ctx aws.Context, input *DisassociateConnectorInput, opts ...request.Option) (*DisassociateConnectorOutput, error) {
	req, out := c.DisassociateConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateChangeSet = "GenerateChangeSet"

// GenerateChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the GenerateChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateChangeSet for more information on using the GenerateChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GenerateChangeSetRequest method.
//    req, resp := client.GenerateChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateChangeSet
func (c *SMS) GenerateChangeSetRequest(input *GenerateChangeSetInput) (req *request.Request, output *GenerateChangeSetOutput) {
	op := &request.Operation{
		Name:       opGenerateChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateChangeSetInput{}
	}

	output = &GenerateChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateChangeSet API operation for AWS Server Migration Service.
//
// Generates a target change set for a currently launched stack and writes it
// to an Amazon S3 object in the customer’s Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GenerateChangeSet for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateChangeSet
func (c *SMS) GenerateChangeSet(input *GenerateChangeSetInput) (*GenerateChangeSetOutput, error) {
	req, out := c.GenerateChangeSetRequest(input)
	return out, req.Send()
}

// GenerateChangeSetWithContext is the same as GenerateChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GenerateChangeSetWithContext(ctx aws.Context, input *GenerateChangeSetInput, opts ...request.Option) (*GenerateChangeSetOutput, error) {
	req, out := c.GenerateChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateTemplate = "GenerateTemplate"

// GenerateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GenerateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateTemplate for more information on using the GenerateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GenerateTemplateRequest method.
//    req, resp := client.GenerateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplate
func (c *SMS) GenerateTemplateRequest(input *GenerateTemplateInput) (req *request.Request, output *GenerateTemplateOutput) {
	op := &request.Operation{
		Name:       opGenerateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateTemplateInput{}
	}

	output = &GenerateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateTemplate API operation for AWS Server Migration Service.
//
// Generates an AWS CloudFormation template based on the current launch configuration
// and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GenerateTemplate for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplate
func (c *SMS) GenerateTemplate(input *GenerateTemplateInput) (*GenerateTemplateOutput, error) {
	req, out := c.GenerateTemplateRequest(input)
	return out, req.Send()
}

// GenerateTemplateWithContext is the same as GenerateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GenerateTemplateWithContext(ctx aws.Context, input *GenerateTemplateInput, opts ...request.Option) (*GenerateTemplateOutput, error) {
	req, out := c.GenerateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApp = "GetApp"

// GetAppRequest generates a "aws/request.Request" representing the
// client's request for the GetApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApp for more information on using the GetApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppRequest method.
//    req, resp := client.GetAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetApp
func (c *SMS) GetAppRequest(input *GetAppInput) (req *request.Request, output *GetAppOutput) {
	op := &request.Operation{
		Name:       opGetApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppInput{}
	}

	output = &GetAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApp API operation for AWS Server Migration Service.
//
// Retrieve information about the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetApp for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetApp
func (c *SMS) GetApp(input *GetAppInput) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	return out, req.Send()
}

// GetAppWithContext is the same as GetApp with the addition of
// the ability to pass a context and additional request options.
//
// See GetApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetAppWithContext(ctx aws.Context, input *GetAppInput, opts ...request.Option) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppLaunchConfiguration = "GetAppLaunchConfiguration"

// GetAppLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetAppLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppLaunchConfiguration for more information on using the GetAppLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppLaunchConfigurationRequest method.
//    req, resp := client.GetAppLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppLaunchConfiguration
func (c *SMS) GetAppLaunchConfigurationRequest(input *GetAppLaunchConfigurationInput) (req *request.Request, output *GetAppLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetAppLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppLaunchConfigurationInput{}
	}

	output = &GetAppLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppLaunchConfiguration API operation for AWS Server Migration Service.
//
// Retrieves the application launch configuration associated with the specified
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetAppLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppLaunchConfiguration
func (c *SMS) GetAppLaunchConfiguration(input *GetAppLaunchConfigurationInput) (*GetAppLaunchConfigurationOutput, error) {
	req, out := c.GetAppLaunchConfigurationRequest(input)
	return out, req.Send()
}

// GetAppLaunchConfigurationWithContext is the same as GetAppLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetAppLaunchConfigurationWithContext(ctx aws.Context, input *GetAppLaunchConfigurationInput, opts ...request.Option) (*GetAppLaunchConfigurationOutput, error) {
	req, out := c.GetAppLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppReplicationConfiguration = "GetAppReplicationConfiguration"

// GetAppReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetAppReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppReplicationConfiguration for more information on using the GetAppReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppReplicationConfigurationRequest method.
//    req, resp := client.GetAppReplicationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppReplicationConfiguration
func (c *SMS) GetAppReplicationConfigurationRequest(input *GetAppReplicationConfigurationInput) (req *request.Request, output *GetAppReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetAppReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppReplicationConfigurationInput{}
	}

	output = &GetAppReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppReplicationConfiguration API operation for AWS Server Migration Service.
//
// Retrieves the application replication configuration associated with the specified
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetAppReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppReplicationConfiguration
func (c *SMS) GetAppReplicationConfiguration(input *GetAppReplicationConfigurationInput) (*GetAppReplicationConfigurationOutput, error) {
	req, out := c.GetAppReplicationConfigurationRequest(input)
	return out, req.Send()
}

// GetAppReplicationConfigurationWithContext is the same as GetAppReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetAppReplicationConfigurationWithContext(ctx aws.Context, input *GetAppReplicationConfigurationInput, opts ...request.Option) (*GetAppReplicationConfigurationOutput, error) {
	req, out := c.GetAppReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppValidationConfiguration = "GetAppValidationConfiguration"

// GetAppValidationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetAppValidationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppValidationConfiguration for more information on using the GetAppValidationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppValidationConfigurationRequest method.
//    req, resp := client.GetAppValidationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppValidationConfiguration
func (c *SMS) GetAppValidationConfigurationRequest(input *GetAppValidationConfigurationInput) (req *request.Request, output *GetAppValidationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetAppValidationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppValidationConfigurationInput{}
	}

	output = &GetAppValidationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppValidationConfiguration API operation for AWS Server Migration Service.
//
// Retrieves information about a configuration for validating an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetAppValidationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppValidationConfiguration
func (c *SMS) GetAppValidationConfiguration(input *GetAppValidationConfigurationInput) (*GetAppValidationConfigurationOutput, error) {
	req, out := c.GetAppValidationConfigurationRequest(input)
	return out, req.Send()
}

// GetAppValidationConfigurationWithContext is the same as GetAppValidationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppValidationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetAppValidationConfigurationWithContext(ctx aws.Context, input *GetAppValidationConfigurationInput, opts ...request.Option) (*GetAppValidationConfigurationOutput, error) {
	req, out := c.GetAppValidationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppValidationOutput = "GetAppValidationOutput"

// GetAppValidationOutputRequest generates a "aws/request.Request" representing the
// client's request for the GetAppValidationOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppValidationOutput for more information on using the GetAppValidationOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppValidationOutputRequest method.
//    req, resp := client.GetAppValidationOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppValidationOutput
func (c *SMS) GetAppValidationOutputRequest(input *GetAppValidationOutputInput) (req *request.Request, output *GetAppValidationOutputOutput) {
	op := &request.Operation{
		Name:       opGetAppValidationOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppValidationOutputInput{}
	}

	output = &GetAppValidationOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppValidationOutput API operation for AWS Server Migration Service.
//
// Retrieves output from validating an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetAppValidationOutput for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppValidationOutput
func (c *SMS) GetAppValidationOutput(input *GetAppValidationOutputInput) (*GetAppValidationOutputOutput, error) {
	req, out := c.GetAppValidationOutputRequest(input)
	return out, req.Send()
}

// GetAppValidationOutputWithContext is the same as GetAppValidationOutput with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppValidationOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetAppValidationOutputWithContext(ctx aws.Context, input *GetAppValidationOutputInput, opts ...request.Option) (*GetAppValidationOutputOutput, error) {
	req, out := c.GetAppValidationOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectors = "GetConnectors"

// GetConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectors for more information on using the GetConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectorsRequest method.
//    req, resp := client.GetConnectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors
func (c *SMS) GetConnectorsRequest(input *GetConnectorsInput) (req *request.Request, output *GetConnectorsOutput) {
	op := &request.Operation{
		Name:       opGetConnectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConnectorsInput{}
	}

	output = &GetConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectors API operation for AWS Server Migration Service.
//
// Describes the connectors registered with the AWS SMS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetConnectors for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors
func (c *SMS) GetConnectors(input *GetConnectorsInput) (*GetConnectorsOutput, error) {
	req, out := c.GetConnectorsRequest(input)
	return out, req.Send()
}

// GetConnectorsWithContext is the same as GetConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetConnectorsWithContext(ctx aws.Context, input *GetConnectorsInput, opts ...request.Option) (*GetConnectorsOutput, error) {
	req, out := c.GetConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConnectorsPages iterates over the pages of a GetConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetConnectors operation.
//    pageNum := 0
//    err := client.GetConnectorsPages(params,
//        func(page *sms.GetConnectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetConnectorsPages(input *GetConnectorsInput, fn func(*GetConnectorsOutput, bool) bool) error {
	return c.GetConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConnectorsPagesWithContext same as GetConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetConnectorsPagesWithContext(ctx aws.Context, input *GetConnectorsInput, fn func(*GetConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetReplicationJobs = "GetReplicationJobs"

// GetReplicationJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReplicationJobs for more information on using the GetReplicationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReplicationJobsRequest method.
//    req, resp := client.GetReplicationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs
func (c *SMS) GetReplicationJobsRequest(input *GetReplicationJobsInput) (req *request.Request, output *GetReplicationJobsOutput) {
	op := &request.Operation{
		Name:       opGetReplicationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReplicationJobsInput{}
	}

	output = &GetReplicationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationJobs API operation for AWS Server Migration Service.
//
// Describes the specified replication job or all of your replication jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetReplicationJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs
func (c *SMS) GetReplicationJobs(input *GetReplicationJobsInput) (*GetReplicationJobsOutput, error) {
	req, out := c.GetReplicationJobsRequest(input)
	return out, req.Send()
}

// GetReplicationJobsWithContext is the same as GetReplicationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationJobsWithContext(ctx aws.Context, input *GetReplicationJobsInput, opts ...request.Option) (*GetReplicationJobsOutput, error) {
	req, out := c.GetReplicationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetReplicationJobsPages iterates over the pages of a GetReplicationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetReplicationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetReplicationJobs operation.
//    pageNum := 0
//    err := client.GetReplicationJobsPages(params,
//        func(page *sms.GetReplicationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetReplicationJobsPages(input *GetReplicationJobsInput, fn func(*GetReplicationJobsOutput, bool) bool) error {
	return c.GetReplicationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetReplicationJobsPagesWithContext same as GetReplicationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationJobsPagesWithContext(ctx aws.Context, input *GetReplicationJobsInput, fn func(*GetReplicationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetReplicationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReplicationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetReplicationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetReplicationRuns = "GetReplicationRuns"

// GetReplicationRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReplicationRuns for more information on using the GetReplicationRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReplicationRunsRequest method.
//    req, resp := client.GetReplicationRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns
func (c *SMS) GetReplicationRunsRequest(input *GetReplicationRunsInput) (req *request.Request, output *GetReplicationRunsOutput) {
	op := &request.Operation{
		Name:       opGetReplicationRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReplicationRunsInput{}
	}

	output = &GetReplicationRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationRuns API operation for AWS Server Migration Service.
//
// Describes the replication runs for the specified replication job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetReplicationRuns for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns
func (c *SMS) GetReplicationRuns(input *GetReplicationRunsInput) (*GetReplicationRunsOutput, error) {
	req, out := c.GetReplicationRunsRequest(input)
	return out, req.Send()
}

// GetReplicationRunsWithContext is the same as GetReplicationRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationRunsWithContext(ctx aws.Context, input *GetReplicationRunsInput, opts ...request.Option) (*GetReplicationRunsOutput, error) {
	req, out := c.GetReplicationRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetReplicationRunsPages iterates over the pages of a GetReplicationRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetReplicationRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetReplicationRuns operation.
//    pageNum := 0
//    err := client.GetReplicationRunsPages(params,
//        func(page *sms.GetReplicationRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetReplicationRunsPages(input *GetReplicationRunsInput, fn func(*GetReplicationRunsOutput, bool) bool) error {
	return c.GetReplicationRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetReplicationRunsPagesWithContext same as GetReplicationRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationRunsPagesWithContext(ctx aws.Context, input *GetReplicationRunsInput, fn func(*GetReplicationRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetReplicationRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReplicationRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetReplicationRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetServers = "GetServers"

// GetServersRequest generates a "aws/request.Request" representing the
// client's request for the GetServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServers for more information on using the GetServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServersRequest method.
//    req, resp := client.GetServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers
func (c *SMS) GetServersRequest(input *GetServersInput) (req *request.Request, output *GetServersOutput) {
	op := &request.Operation{
		Name:       opGetServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetServersInput{}
	}

	output = &GetServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServers API operation for AWS Server Migration Service.
//
// Describes the servers in your server catalog.
//
// Before you can describe your servers, you must import them using ImportServerCatalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetServers for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers
func (c *SMS) GetServers(input *GetServersInput) (*GetServersOutput, error) {
	req, out := c.GetServersRequest(input)
	return out, req.Send()
}

// GetServersWithContext is the same as GetServers with the addition of
// the ability to pass a context and additional request options.
//
// See GetServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetServersWithContext(ctx aws.Context, input *GetServersInput, opts ...request.Option) (*GetServersOutput, error) {
	req, out := c.GetServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetServersPages iterates over the pages of a GetServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetServers operation.
//    pageNum := 0
//    err := client.GetServersPages(params,
//        func(page *sms.GetServersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetServersPages(input *GetServersInput, fn func(*GetServersOutput, bool) bool) error {
	return c.GetServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetServersPagesWithContext same as GetServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetServersPagesWithContext(ctx aws.Context, input *GetServersInput, fn func(*GetServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opImportAppCatalog = "ImportAppCatalog"

// ImportAppCatalogRequest generates a "aws/request.Request" representing the
// client's request for the ImportAppCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportAppCatalog for more information on using the ImportAppCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportAppCatalogRequest method.
//    req, resp := client.ImportAppCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportAppCatalog
func (c *SMS) ImportAppCatalogRequest(input *ImportAppCatalogInput) (req *request.Request, output *ImportAppCatalogOutput) {
	op := &request.Operation{
		Name:       opImportAppCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportAppCatalogInput{}
	}

	output = &ImportAppCatalogOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ImportAppCatalog API operation for AWS Server Migration Service.
//
// Allows application import from AWS Migration Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation ImportAppCatalog for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportAppCatalog
func (c *SMS) ImportAppCatalog(input *ImportAppCatalogInput) (*ImportAppCatalogOutput, error) {
	req, out := c.ImportAppCatalogRequest(input)
	return out, req.Send()
}

// ImportAppCatalogWithContext is the same as ImportAppCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See ImportAppCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) ImportAppCatalogWithContext(ctx aws.Context, input *ImportAppCatalogInput, opts ...request.Option) (*ImportAppCatalogOutput, error) {
	req, out := c.ImportAppCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportServerCatalog = "ImportServerCatalog"

// ImportServerCatalogRequest generates a "aws/request.Request" representing the
// client's request for the ImportServerCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportServerCatalog for more information on using the ImportServerCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportServerCatalogRequest method.
//    req, resp := client.ImportServerCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog
func (c *SMS) ImportServerCatalogRequest(input *ImportServerCatalogInput) (req *request.Request, output *ImportServerCatalogOutput) {
	op := &request.Operation{
		Name:       opImportServerCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportServerCatalogInput{}
	}

	output = &ImportServerCatalogOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ImportServerCatalog API operation for AWS Server Migration Service.
//
// Gathers a complete list of on-premises servers. Connectors must be installed
// and monitoring all servers to import.
//
// This call returns immediately, but might take additional time to retrieve
// all the servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation ImportServerCatalog for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * NoConnectorsAvailableException
//   There are no connectors available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog
func (c *SMS) ImportServerCatalog(input *ImportServerCatalogInput) (*ImportServerCatalogOutput, error) {
	req, out := c.ImportServerCatalogRequest(input)
	return out, req.Send()
}

// ImportServerCatalogWithContext is the same as ImportServerCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See ImportServerCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) ImportServerCatalogWithContext(ctx aws.Context, input *ImportServerCatalogInput, opts ...request.Option) (*ImportServerCatalogOutput, error) {
	req, out := c.ImportServerCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLaunchApp = "LaunchApp"

// LaunchAppRequest generates a "aws/request.Request" representing the
// client's request for the LaunchApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LaunchApp for more information on using the LaunchApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LaunchAppRequest method.
//    req, resp := client.LaunchAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/LaunchApp
func (c *SMS) LaunchAppRequest(input *LaunchAppInput) (req *request.Request, output *LaunchAppOutput) {
	op := &request.Operation{
		Name:       opLaunchApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LaunchAppInput{}
	}

	output = &LaunchAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// LaunchApp API operation for AWS Server Migration Service.
//
// Launches the specified application as a stack in AWS CloudFormation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation LaunchApp for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/LaunchApp
func (c *SMS) LaunchApp(input *LaunchAppInput) (*LaunchAppOutput, error) {
	req, out := c.LaunchAppRequest(input)
	return out, req.Send()
}

// LaunchAppWithContext is the same as LaunchApp with the addition of
// the ability to pass a context and additional request options.
//
// See LaunchApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) LaunchAppWithContext(ctx aws.Context, input *LaunchAppInput, opts ...request.Option) (*LaunchAppOutput, error) {
	req, out := c.LaunchAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApps = "ListApps"

// ListAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApps for more information on using the ListApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppsRequest method.
//    req, resp := client.ListAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ListApps
func (c *SMS) ListAppsRequest(input *ListAppsInput) (req *request.Request, output *ListAppsOutput) {
	op := &request.Operation{
		Name:       opListApps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	output = &ListAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApps API operation for AWS Server Migration Service.
//
// Retrieves summaries for all applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation ListApps for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ListApps
func (c *SMS) ListApps(input *ListAppsInput) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	return out, req.Send()
}

// ListAppsWithContext is the same as ListApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) ListAppsWithContext(ctx aws.Context, input *ListAppsInput, opts ...request.Option) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opNotifyAppValidationOutput = "NotifyAppValidationOutput"

// NotifyAppValidationOutputRequest generates a "aws/request.Request" representing the
// client's request for the NotifyAppValidationOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyAppValidationOutput for more information on using the NotifyAppValidationOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the NotifyAppValidationOutputRequest method.
//    req, resp := client.NotifyAppValidationOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/NotifyAppValidationOutput
func (c *SMS) NotifyAppValidationOutputRequest(input *NotifyAppValidationOutputInput) (req *request.Request, output *NotifyAppValidationOutputOutput) {
	op := &request.Operation{
		Name:       opNotifyAppValidationOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyAppValidationOutputInput{}
	}

	output = &NotifyAppValidationOutputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// NotifyAppValidationOutput API operation for AWS Server Migration Service.
//
// Provides information to AWS SMS about whether application validation is successful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation NotifyAppValidationOutput for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/NotifyAppValidationOutput
func (c *SMS) NotifyAppValidationOutput(input *NotifyAppValidationOutputInput) (*NotifyAppValidationOutputOutput, error) {
	req, out := c.NotifyAppValidationOutputRequest(input)
	return out, req.Send()
}

// NotifyAppValidationOutputWithContext is the same as NotifyAppValidationOutput with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyAppValidationOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) NotifyAppValidationOutputWithContext(ctx aws.Context, input *NotifyAppValidationOutputInput, opts ...request.Option) (*NotifyAppValidationOutputOutput, error) {
	req, out := c.NotifyAppValidationOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppLaunchConfiguration = "PutAppLaunchConfiguration"

// PutAppLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutAppLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppLaunchConfiguration for more information on using the PutAppLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAppLaunchConfigurationRequest method.
//    req, resp := client.PutAppLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppLaunchConfiguration
func (c *SMS) PutAppLaunchConfigurationRequest(input *PutAppLaunchConfigurationInput) (req *request.Request, output *PutAppLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutAppLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAppLaunchConfigurationInput{}
	}

	output = &PutAppLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAppLaunchConfiguration API operation for AWS Server Migration Service.
//
// Creates or updates the launch configuration for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation PutAppLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppLaunchConfiguration
func (c *SMS) PutAppLaunchConfiguration(input *PutAppLaunchConfigurationInput) (*PutAppLaunchConfigurationOutput, error) {
	req, out := c.PutAppLaunchConfigurationRequest(input)
	return out, req.Send()
}

// PutAppLaunchConfigurationWithContext is the same as PutAppLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) PutAppLaunchConfigurationWithContext(ctx aws.Context, input *PutAppLaunchConfigurationInput, opts ...request.Option) (*PutAppLaunchConfigurationOutput, error) {
	req, out := c.PutAppLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppReplicationConfiguration = "PutAppReplicationConfiguration"

// PutAppReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutAppReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppReplicationConfiguration for more information on using the PutAppReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAppReplicationConfigurationRequest method.
//    req, resp := client.PutAppReplicationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppReplicationConfiguration
func (c *SMS) PutAppReplicationConfigurationRequest(input *PutAppReplicationConfigurationInput) (req *request.Request, output *PutAppReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutAppReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAppReplicationConfigurationInput{}
	}

	output = &PutAppReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAppReplicationConfiguration API operation for AWS Server Migration Service.
//
// Creates or updates the replication configuration for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation PutAppReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppReplicationConfiguration
func (c *SMS) PutAppReplicationConfiguration(input *PutAppReplicationConfigurationInput) (*PutAppReplicationConfigurationOutput, error) {
	req, out := c.PutAppReplicationConfigurationRequest(input)
	return out, req.Send()
}

// PutAppReplicationConfigurationWithContext is the same as PutAppReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) PutAppReplicationConfigurationWithContext(ctx aws.Context, input *PutAppReplicationConfigurationInput, opts ...request.Option) (*PutAppReplicationConfigurationOutput, error) {
	req, out := c.PutAppReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppValidationConfiguration = "PutAppValidationConfiguration"

// PutAppValidationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutAppValidationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppValidationConfiguration for more information on using the PutAppValidationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAppValidationConfigurationRequest method.
//    req, resp := client.PutAppValidationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppValidationConfiguration
func (c *SMS) PutAppValidationConfigurationRequest(input *PutAppValidationConfigurationInput) (req *request.Request, output *PutAppValidationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutAppValidationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAppValidationConfigurationInput{}
	}

	output = &PutAppValidationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAppValidationConfiguration API operation for AWS Server Migration Service.
//
// Creates or updates a validation configuration for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation PutAppValidationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppValidationConfiguration
func (c *SMS) PutAppValidationConfiguration(input *PutAppValidationConfigurationInput) (*PutAppValidationConfigurationOutput, error) {
	req, out := c.PutAppValidationConfigurationRequest(input)
	return out, req.Send()
}

// PutAppValidationConfigurationWithContext is the same as PutAppValidationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppValidationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) PutAppValidationConfigurationWithContext(ctx aws.Context, input *PutAppValidationConfigurationInput, opts ...request.Option) (*PutAppValidationConfigurationOutput, error) {
	req, out := c.PutAppValidationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAppReplication = "StartAppReplication"

// StartAppReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartAppReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAppReplication for more information on using the StartAppReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAppReplicationRequest method.
//    req, resp := client.StartAppReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartAppReplication
func (c *SMS) StartAppReplicationRequest(input *StartAppReplicationInput) (req *request.Request, output *StartAppReplicationOutput) {
	op := &request.Operation{
		Name:       opStartAppReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAppReplicationInput{}
	}

	output = &StartAppReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartAppReplication API operation for AWS Server Migration Service.
//
// Starts replicating the specified application by creating replication jobs
// for each server in the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation StartAppReplication for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartAppReplication
func (c *SMS) StartAppReplication(input *StartAppReplicationInput) (*StartAppReplicationOutput, error) {
	req, out := c.StartAppReplicationRequest(input)
	return out, req.Send()
}

// StartAppReplicationWithContext is the same as StartAppReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartAppReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) StartAppReplicationWithContext(ctx aws.Context, input *StartAppReplicationInput, opts ...request.Option) (*StartAppReplicationOutput, error) {
	req, out := c.StartAppReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOnDemandAppReplication = "StartOnDemandAppReplication"

// StartOnDemandAppReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartOnDemandAppReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOnDemandAppReplication for more information on using the StartOnDemandAppReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartOnDemandAppReplicationRequest method.
//    req, resp := client.StartOnDemandAppReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandAppReplication
func (c *SMS) StartOnDemandAppReplicationRequest(input *StartOnDemandAppReplicationInput) (req *request.Request, output *StartOnDemandAppReplicationOutput) {
	op := &request.Operation{
		Name:       opStartOnDemandAppReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartOnDemandAppReplicationInput{}
	}

	output = &StartOnDemandAppReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartOnDemandAppReplication API operation for AWS Server Migration Service.
//
// Starts an on-demand replication run for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation StartOnDemandAppReplication for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandAppReplication
func (c *SMS) StartOnDemandAppReplication(input *StartOnDemandAppReplicationInput) (*StartOnDemandAppReplicationOutput, error) {
	req, out := c.StartOnDemandAppReplicationRequest(input)
	return out, req.Send()
}

// StartOnDemandAppReplicationWithContext is the same as StartOnDemandAppReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartOnDemandAppReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) StartOnDemandAppReplicationWithContext(ctx aws.Context, input *StartOnDemandAppReplicationInput, opts ...request.Option) (*StartOnDemandAppReplicationOutput, error) {
	req, out := c.StartOnDemandAppReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOnDemandReplicationRun = "StartOnDemandReplicationRun"

// StartOnDemandReplicationRunRequest generates a "aws/request.Request" representing the
// client's request for the StartOnDemandReplicationRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOnDemandReplicationRun for more information on using the StartOnDemandReplicationRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartOnDemandReplicationRunRequest method.
//    req, resp := client.StartOnDemandReplicationRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRun
func (c *SMS) StartOnDemandReplicationRunRequest(input *StartOnDemandReplicationRunInput) (req *request.Request, output *StartOnDemandReplicationRunOutput) {
	op := &request.Operation{
		Name:       opStartOnDemandReplicationRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartOnDemandReplicationRunInput{}
	}

	output = &StartOnDemandReplicationRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOnDemandReplicationRun API operation for AWS Server Migration Service.
//
// Starts an on-demand replication run for the specified replication job. This
// replication run starts immediately. This replication run is in addition to
// the ones already scheduled.
//
// There is a limit on the number of on-demand replications runs that you can
// request in a 24-hour period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation StartOnDemandReplicationRun for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * ReplicationRunLimitExceededException
//   You have exceeded the number of on-demand replication runs you can request
//   in a 24-hour period.
//
//   * DryRunOperationException
//   The user has the required permissions, so the request would have succeeded,
//   but a dry run was performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRun
func (c *SMS) StartOnDemandReplicationRun(input *StartOnDemandReplicationRunInput) (*StartOnDemandReplicationRunOutput, error) {
	req, out := c.StartOnDemandReplicationRunRequest(input)
	return out, req.Send()
}

// StartOnDemandReplicationRunWithContext is the same as StartOnDemandReplicationRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartOnDemandReplicationRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) StartOnDemandReplicationRunWithContext(ctx aws.Context, input *StartOnDemandReplicationRunInput, opts ...request.Option) (*StartOnDemandReplicationRunOutput, error) {
	req, out := c.StartOnDemandReplicationRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAppReplication = "StopAppReplication"

// StopAppReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopAppReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAppReplication for more information on using the StopAppReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopAppReplicationRequest method.
//    req, resp := client.StopAppReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StopAppReplication
func (c *SMS) StopAppReplicationRequest(input *StopAppReplicationInput) (req *request.Request, output *StopAppReplicationOutput) {
	op := &request.Operation{
		Name:       opStopAppReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAppReplicationInput{}
	}

	output = &StopAppReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAppReplication API operation for AWS Server Migration Service.
//
// Stops replicating the specified application by deleting the replication job
// for each server in the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation StopAppReplication for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StopAppReplication
func (c *SMS) StopAppReplication(input *StopAppReplicationInput) (*StopAppReplicationOutput, error) {
	req, out := c.StopAppReplicationRequest(input)
	return out, req.Send()
}

// StopAppReplicationWithContext is the same as StopAppReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopAppReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) StopAppReplicationWithContext(ctx aws.Context, input *StopAppReplicationInput, opts ...request.Option) (*StopAppReplicationOutput, error) {
	req, out := c.StopAppReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateApp = "TerminateApp"

// TerminateAppRequest generates a "aws/request.Request" representing the
// client's request for the TerminateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateApp for more information on using the TerminateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateAppRequest method.
//    req, resp := client.TerminateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/TerminateApp
func (c *SMS) TerminateAppRequest(input *TerminateAppInput) (req *request.Request, output *TerminateAppOutput) {
	op := &request.Operation{
		Name:       opTerminateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateAppInput{}
	}

	output = &TerminateAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TerminateApp API operation for AWS Server Migration Service.
//
// Terminates the stack for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation TerminateApp for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/TerminateApp
func (c *SMS) TerminateApp(input *TerminateAppInput) (*TerminateAppOutput, error) {
	req, out := c.TerminateAppRequest(input)
	return out, req.Send()
}

// TerminateAppWithContext is the same as TerminateApp with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) TerminateAppWithContext(ctx aws.Context, input *TerminateAppInput, opts ...request.Option) (*TerminateAppOutput, error) {
	req, out := c.TerminateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApp = "UpdateApp"

// UpdateAppRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApp for more information on using the UpdateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppRequest method.
//    req, resp := client.UpdateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateApp
func (c *SMS) UpdateAppRequest(input *UpdateAppInput) (req *request.Request, output *UpdateAppOutput) {
	op := &request.Operation{
		Name:       opUpdateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAppInput{}
	}

	output = &UpdateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApp API operation for AWS Server Migration Service.
//
// Updates the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation UpdateApp for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * InternalError
//   An internal error occurred.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateApp
func (c *SMS) UpdateApp(input *UpdateAppInput) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	return out, req.Send()
}

// UpdateAppWithContext is the same as UpdateApp with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) UpdateAppWithContext(ctx aws.Context, input *UpdateAppInput, opts ...request.Option) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationJob = "UpdateReplicationJob"

// UpdateReplicationJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReplicationJob for more information on using the UpdateReplicationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateReplicationJobRequest method.
//    req, resp := client.UpdateReplicationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJob
func (c *SMS) UpdateReplicationJobRequest(input *UpdateReplicationJobInput) (req *request.Request, output *UpdateReplicationJobOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateReplicationJobInput{}
	}

	output = &UpdateReplicationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateReplicationJob API operation for AWS Server Migration Service.
//
// Updates the specified settings for the specified replication job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation UpdateReplicationJob for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A specified parameter is not valid.
//
//   * MissingRequiredParameterException
//   A required parameter is missing.
//
//   * OperationNotPermittedException
//   This operation is not allowed.
//
//   * UnauthorizedOperationException
//   You lack permissions needed to perform this operation. Check your IAM policies,
//   and ensure that you are using the correct access keys.
//
//   * ServerCannotBeReplicatedException
//   The specified server cannot be replicated.
//
//   * ReplicationJobNotFoundException
//   The specified replication job does not exist.
//
//   * InternalError
//   An internal error occurred.
//
//   * TemporarilyUnavailableException
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJob
func (c *SMS) UpdateReplicationJob(input *UpdateReplicationJobInput) (*UpdateReplicationJobOutput, error) {
	req, out := c.UpdateReplicationJobRequest(input)
	return out, req.Send()
}

// UpdateReplicationJobWithContext is the same as UpdateReplicationJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) UpdateReplicationJobWithContext(ctx aws.Context, input *UpdateReplicationJobInput, opts ...request.Option) (*UpdateReplicationJobOutput, error) {
	req, out := c.UpdateReplicationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about the application.
type AppSummary struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application.
	AppId *string `locationName:"appId" type:"string"`

	// The creation time of the application.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The ID of the application.
	ImportedAppId *string `locationName:"importedAppId" type:"string"`

	// The last modified time of the application.
	LastModified *time.Time `locationName:"lastModified" type:"timestamp"`

	// The timestamp of the application's most recent successful replication.
	LatestReplicationTime *time.Time `locationName:"latestReplicationTime" type:"timestamp"`

	// Status of the launch configuration.
	LaunchConfigurationStatus *string `locationName:"launchConfigurationStatus" type:"string" enum:"AppLaunchConfigurationStatus"`

	// Details about the latest launch of the application.
	LaunchDetails *LaunchDetails `locationName:"launchDetails" type:"structure"`

	// The launch status of the application.
	LaunchStatus *string `locationName:"launchStatus" type:"string" enum:"AppLaunchStatus"`

	// A message related to the launch status of the application.
	LaunchStatusMessage *string `locationName:"launchStatusMessage" type:"string"`

	// The name of the application.
	Name *string `locationName:"name" type:"string"`

	// Status of the replication configuration.
	ReplicationConfigurationStatus *string `locationName:"replicationConfigurationStatus" type:"string" enum:"AppReplicationConfigurationStatus"`

	// The replication status of the application.
	ReplicationStatus *string `locationName:"replicationStatus" type:"string" enum:"AppReplicationStatus"`

	// A message related to the replication status of the application.
	ReplicationStatusMessage *string `locationName:"replicationStatusMessage" type:"string"`

	// The name of the service role in the customer's account used by AWS SMS.
	RoleName *string `locationName:"roleName" type:"string"`

	// Status of the application.
	Status *string `locationName:"status" type:"string" enum:"AppStatus"`

	// A message related to the status of the application
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The number of server groups present in the application.
	TotalServerGroups *int64 `locationName:"totalServerGroups" type:"integer"`

	// The number of servers present in the application.
	TotalServers *int64 `locationName:"totalServers" type:"integer"`
}

// String returns the string representation
func (s AppSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppSummary) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *AppSummary) SetAppId(v string) *AppSummary {
	s.AppId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AppSummary) SetCreationTime(v time.Time) *AppSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AppSummary) SetDescription(v string) *AppSummary {
	s.Description = &v
	return s
}

// SetImportedAppId sets the ImportedAppId field's value.
func (s *AppSummary) SetImportedAppId(v string) *AppSummary {
	s.ImportedAppId = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AppSummary) SetLastModified(v time.Time) *AppSummary {
	s.LastModified = &v
	return s
}

// SetLatestReplicationTime sets the LatestReplicationTime field's value.
func (s *AppSummary) SetLatestReplicationTime(v time.Time) *AppSummary {
	s.LatestReplicationTime = &v
	return s
}

// SetLaunchConfigurationStatus sets the LaunchConfigurationStatus field's value.
func (s *AppSummary) SetLaunchConfigurationStatus(v string) *AppSummary {
	s.LaunchConfigurationStatus = &v
	return s
}

// SetLaunchDetails sets the LaunchDetails field's value.
func (s *AppSummary) SetLaunchDetails(v *LaunchDetails) *AppSummary {
	s.LaunchDetails = v
	return s
}

// SetLaunchStatus sets the LaunchStatus field's value.
func (s *AppSummary) SetLaunchStatus(v string) *AppSummary {
	s.LaunchStatus = &v
	return s
}

// SetLaunchStatusMessage sets the LaunchStatusMessage field's value.
func (s *AppSummary) SetLaunchStatusMessage(v string) *AppSummary {
	s.LaunchStatusMessage = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppSummary) SetName(v string) *AppSummary {
	s.Name = &v
	return s
}

// SetReplicationConfigurationStatus sets the ReplicationConfigurationStatus field's value.
func (s *AppSummary) SetReplicationConfigurationStatus(v string) *AppSummary {
	s.ReplicationConfigurationStatus = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *AppSummary) SetReplicationStatus(v string) *AppSummary {
	s.ReplicationStatus = &v
	return s
}

// SetReplicationStatusMessage sets the ReplicationStatusMessage field's value.
func (s *AppSummary) SetReplicationStatusMessage(v string) *AppSummary {
	s.ReplicationStatusMessage = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AppSummary) SetRoleName(v string) *AppSummary {
	s.RoleName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppSummary) SetStatus(v string) *AppSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AppSummary) SetStatusMessage(v string) *AppSummary {
	s.StatusMessage = &v
	return s
}

// SetTotalServerGroups sets the TotalServerGroups field's value.
func (s *AppSummary) SetTotalServerGroups(v int64) *AppSummary {
	s.TotalServerGroups = &v
	return s
}

// SetTotalServers sets the TotalServers field's value.
func (s *AppSummary) SetTotalServers(v int64) *AppSummary {
	s.TotalServers = &v
	return s
}

// Configuration for validating an application.
type AppValidationConfiguration struct {
	_ struct{} `type:"structure"`

	// The validation strategy.
	AppValidationStrategy *string `locationName:"appValidationStrategy" type:"string" enum:"AppValidationStrategy"`

	// The name of the configuration.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The validation parameters.
	SsmValidationParameters *SSMValidationParameters `locationName:"ssmValidationParameters" type:"structure"`

	// The ID of the validation.
	ValidationId *string `locationName:"validationId" type:"string"`
}

// String returns the string representation
func (s AppValidationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppValidationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppValidationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppValidationConfiguration"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SsmValidationParameters != nil {
		if err := s.SsmValidationParameters.Validate(); err != nil {
			invalidParams.AddNested("SsmValidationParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppValidationStrategy sets the AppValidationStrategy field's value.
func (s *AppValidationConfiguration) SetAppValidationStrategy(v string) *AppValidationConfiguration {
	s.AppValidationStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppValidationConfiguration) SetName(v string) *AppValidationConfiguration {
	s.Name = &v
	return s
}

// SetSsmValidationParameters sets the SsmValidationParameters field's value.
func (s *AppValidationConfiguration) SetSsmValidationParameters(v *SSMValidationParameters) *AppValidationConfiguration {
	s.SsmValidationParameters = v
	return s
}

// SetValidationId sets the ValidationId field's value.
func (s *AppValidationConfiguration) SetValidationId(v string) *AppValidationConfiguration {
	s.ValidationId = &v
	return s
}

// Output from validating an application.
type AppValidationOutput struct {
	_ struct{} `type:"structure"`

	// Output from using SSM to validate the application.
	SsmOutput *SSMOutput `locationName:"ssmOutput" type:"structure"`
}

// String returns the string representation
func (s AppValidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppValidationOutput) GoString() string {
	return s.String()
}

// SetSsmOutput sets the SsmOutput field's value.
func (s *AppValidationOutput) SetSsmOutput(v *SSMOutput) *AppValidationOutput {
	s.SsmOutput = v
	return s
}

// Represents a connector.
type Connector struct {
	_ struct{} `type:"structure"`

	// The time the connector was associated.
	AssociatedOn *time.Time `locationName:"associatedOn" type:"timestamp"`

	// The capabilities of the connector.
	CapabilityList []*string `locationName:"capabilityList" type:"list"`

	// The ID of the connector.
	ConnectorId *string `locationName:"connectorId" type:"string"`

	// The IP address of the connector.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The MAC address of the connector.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// The status of the connector.
	Status *string `locationName:"status" type:"string" enum:"ConnectorStatus"`

	// The connector version.
	Version *string `locationName:"version" type:"string"`

	// The ID of the VM manager.
	VmManagerId *string `locationName:"vmManagerId" type:"string"`

	// The name of the VM manager.
	VmManagerName *string `locationName:"vmManagerName" type:"string"`

	// The VM management product.
	VmManagerType *string `locationName:"vmManagerType" type:"string" enum:"VmManagerType"`
}

// String returns the string representation
func (s Connector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connector) GoString() string {
	return s.String()
}

// SetAssociatedOn sets the AssociatedOn field's value.
func (s *Connector) SetAssociatedOn(v time.Time) *Connector {
	s.AssociatedOn = &v
	return s
}

// SetCapabilityList sets the CapabilityList field's value.
func (s *Connector) SetCapabilityList(v []*string) *Connector {
	s.CapabilityList = v
	return s
}

// SetConnectorId sets the ConnectorId field's value.
func (s *Connector) SetConnectorId(v string) *Connector {
	s.ConnectorId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Connector) SetIpAddress(v string) *Connector {
	s.IpAddress = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *Connector) SetMacAddress(v string) *Connector {
	s.MacAddress = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connector) SetStatus(v string) *Connector {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Connector) SetVersion(v string) *Connector {
	s.Version = &v
	return s
}

// SetVmManagerId sets the VmManagerId field's value.
func (s *Connector) SetVmManagerId(v string) *Connector {
	s.VmManagerId = &v
	return s
}

// SetVmManagerName sets the VmManagerName field's value.
func (s *Connector) SetVmManagerName(v string) *Connector {
	s.VmManagerName = &v
	return s
}

// SetVmManagerType sets the VmManagerType field's value.
func (s *Connector) SetVmManagerType(v string) *Connector {
	s.VmManagerType = &v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of application creation.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The description of the new application
	Description *string `locationName:"description" type:"string"`

	// The name of the new application.
	Name *string `locationName:"name" type:"string"`

	// The name of the service role in the customer's account to be used by AWS
	// SMS.
	RoleName *string `locationName:"roleName" type:"string"`

	// The server groups to include in the application.
	ServerGroups []*ServerGroup `locationName:"serverGroups" type:"list"`

	// The tags to be associated with the application.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAppInput) SetClientToken(v string) *CreateAppInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAppInput) SetDescription(v string) *CreateAppInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInput) SetName(v string) *CreateAppInput {
	s.Name = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateAppInput) SetRoleName(v string) *CreateAppInput {
	s.RoleName = &v
	return s
}

// SetServerGroups sets the ServerGroups field's value.
func (s *CreateAppInput) SetServerGroups(v []*ServerGroup) *CreateAppInput {
	s.ServerGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInput) SetTags(v []*Tag) *CreateAppInput {
	s.Tags = v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure"`

	// A summary description of the application.
	AppSummary *AppSummary `locationName:"appSummary" type:"structure"`

	// The server groups included in the application.
	ServerGroups []*ServerGroup `locationName:"serverGroups" type:"list"`

	// The tags associated with the application.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetAppSummary sets the AppSummary field's value.
func (s *CreateAppOutput) SetAppSummary(v *AppSummary) *CreateAppOutput {
	s.AppSummary = v
	return s
}

// SetServerGroups sets the ServerGroups field's value.
func (s *CreateAppOutput) SetServerGroups(v []*ServerGroup) *CreateAppOutput {
	s.ServerGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppOutput) SetTags(v []*Tag) *CreateAppOutput {
	s.Tags = v
	return s
}

type CreateReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The description of the replication job.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the replication job produces encrypted AMIs.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The time between consecutive replication runs, in hours.
	Frequency *int64 `locationName:"frequency" type:"integer"`

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	//    * KMS key ID
	//
	//    * KMS key alias
	//
	//    * ARN referring to the KMS key ID
	//
	//    * ARN referring to the KMS key alias
	//
	// If encrypted is true but a KMS key ID is not specified, the customer's default
	// KMS key for Amazon EBS is used.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The license type to be used for the AMI created by a successful replication
	// run.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// The maximum number of SMS-created AMIs to retain. The oldest is deleted after
	// the maximum number is reached and a new AMI is created.
	NumberOfRecentAmisToKeep *int64 `locationName:"numberOfRecentAmisToKeep" type:"integer"`

	// The name of the IAM role to be used by the AWS SMS.
	RoleName *string `locationName:"roleName" type:"string"`

	// Indicates whether to run the replication job one time.
	RunOnce *bool `locationName:"runOnce" type:"boolean"`

	// The seed replication time.
	//
	// SeedReplicationTime is a required field
	SeedReplicationTime *time.Time `locationName:"seedReplicationTime" type:"timestamp" required:"true"`

	// The ID of the server.
	//
	// ServerId is a required field
	ServerId *string `locationName:"serverId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationJobInput"}
	if s.SeedReplicationTime == nil {
		invalidParams.Add(request.NewErrParamRequired("SeedReplicationTime"))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateReplicationJobInput) SetDescription(v string) *CreateReplicationJobInput {
	s.Description = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CreateReplicationJobInput) SetEncrypted(v bool) *CreateReplicationJobInput {
	s.Encrypted = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *CreateReplicationJobInput) SetFrequency(v int64) *CreateReplicationJobInput {
	s.Frequency = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateReplicationJobInput) SetKmsKeyId(v string) *CreateReplicationJobInput {
	s.KmsKeyId = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *CreateReplicationJobInput) SetLicenseType(v string) *CreateReplicationJobInput {
	s.LicenseType = &v
	return s
}

// SetNumberOfRecentAmisToKeep sets the NumberOfRecentAmisToKeep field's value.
func (s *CreateReplicationJobInput) SetNumberOfRecentAmisToKeep(v int64) *CreateReplicationJobInput {
	s.NumberOfRecentAmisToKeep = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateReplicationJobInput) SetRoleName(v string) *CreateReplicationJobInput {
	s.RoleName = &v
	return s
}

// SetRunOnce sets the RunOnce field's value.
func (s *CreateReplicationJobInput) SetRunOnce(v bool) *CreateReplicationJobInput {
	s.RunOnce = &v
	return s
}

// SetSeedReplicationTime sets the SeedReplicationTime field's value.
func (s *CreateReplicationJobInput) SetSeedReplicationTime(v time.Time) *CreateReplicationJobInput {
	s.SeedReplicationTime = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateReplicationJobInput) SetServerId(v string) *CreateReplicationJobInput {
	s.ServerId = &v
	return s
}

type CreateReplicationJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the replication job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`
}

// String returns the string representation
func (s CreateReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationJobOutput) GoString() string {
	return s.String()
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *CreateReplicationJobOutput) SetReplicationJobId(v string) *CreateReplicationJobOutput {
	s.ReplicationJobId = &v
	return s
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`

	// Indicates whether to stop all replication jobs corresponding to the servers
	// in the application while deleting the application.
	ForceStopAppReplication *bool `locationName:"forceStopAppReplication" type:"boolean"`

	// Indicates whether to terminate the stack corresponding to the application
	// while deleting the application.
	ForceTerminateApp *bool `locationName:"forceTerminateApp" type:"boolean"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteAppInput) SetAppId(v string) *DeleteAppInput {
	s.AppId = &v
	return s
}

// SetForceStopAppReplication sets the ForceStopAppReplication field's value.
func (s *DeleteAppInput) SetForceStopAppReplication(v bool) *DeleteAppInput {
	s.ForceStopAppReplication = &v
	return s
}

// SetForceTerminateApp sets the ForceTerminateApp field's value.
func (s *DeleteAppInput) SetForceTerminateApp(v bool) *DeleteAppInput {
	s.ForceTerminateApp = &v
	return s
}

type DeleteAppLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s DeleteAppLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppLaunchConfigurationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteAppLaunchConfigurationInput) SetAppId(v string) *DeleteAppLaunchConfigurationInput {
	s.AppId = &v
	return s
}

type DeleteAppLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppLaunchConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

type DeleteAppReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s DeleteAppReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppReplicationConfigurationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteAppReplicationConfigurationInput) SetAppId(v string) *DeleteAppReplicationConfigurationInput {
	s.AppId = &v
	return s
}

type DeleteAppReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppReplicationConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteAppValidationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppValidationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppValidationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppValidationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppValidationConfigurationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteAppValidationConfigurationInput) SetAppId(v string) *DeleteAppValidationConfigurationInput {
	s.AppId = &v
	return s
}

type DeleteAppValidationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppValidationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppValidationConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the replication job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationJobInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *DeleteReplicationJobInput) SetReplicationJobId(v string) *DeleteReplicationJobInput {
	s.ReplicationJobId = &v
	return s
}

type DeleteReplicationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationJobOutput) GoString() string {
	return s.String()
}

type DeleteServerCatalogInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCatalogInput) GoString() string {
	return s.String()
}

type DeleteServerCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCatalogOutput) GoString() string {
	return s.String()
}

type DisassociateConnectorInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connector.
	//
	// ConnectorId is a required field
	ConnectorId *string `locationName:"connectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConnectorInput"}
	if s.ConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorId sets the ConnectorId field's value.
func (s *DisassociateConnectorInput) SetConnectorId(v string) *DisassociateConnectorInput {
	s.ConnectorId = &v
	return s
}

type DisassociateConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConnectorOutput) GoString() string {
	return s.String()
}

// The user has the required permissions, so the request would have succeeded,
// but a dry run was performed.
type DryRunOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DryRunOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DryRunOperationException) GoString() string {
	return s.String()
}

func newErrorDryRunOperationException(v protocol.ResponseMetadata) error {
	return &DryRunOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DryRunOperationException) Code() string {
	return "DryRunOperationException"
}

// Message returns the exception's message.
func (s *DryRunOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DryRunOperationException) OrigErr() error {
	return nil
}

func (s *DryRunOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DryRunOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DryRunOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GenerateChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application associated with the change set.
	AppId *string `locationName:"appId" type:"string"`

	// The format for the change set.
	ChangesetFormat *string `locationName:"changesetFormat" type:"string" enum:"OutputFormat"`
}

// String returns the string representation
func (s GenerateChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateChangeSetInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GenerateChangeSetInput) SetAppId(v string) *GenerateChangeSetInput {
	s.AppId = &v
	return s
}

// SetChangesetFormat sets the ChangesetFormat field's value.
func (s *GenerateChangeSetInput) SetChangesetFormat(v string) *GenerateChangeSetInput {
	s.ChangesetFormat = &v
	return s
}

type GenerateChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The location of the Amazon S3 object.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s GenerateChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateChangeSetOutput) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *GenerateChangeSetOutput) SetS3Location(v *S3Location) *GenerateChangeSetOutput {
	s.S3Location = v
	return s
}

type GenerateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application associated with the AWS CloudFormation template.
	AppId *string `locationName:"appId" type:"string"`

	// The format for generating the AWS CloudFormation template.
	TemplateFormat *string `locationName:"templateFormat" type:"string" enum:"OutputFormat"`
}

// String returns the string representation
func (s GenerateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateTemplateInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GenerateTemplateInput) SetAppId(v string) *GenerateTemplateInput {
	s.AppId = &v
	return s
}

// SetTemplateFormat sets the TemplateFormat field's value.
func (s *GenerateTemplateInput) SetTemplateFormat(v string) *GenerateTemplateInput {
	s.TemplateFormat = &v
	return s
}

type GenerateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The location of the Amazon S3 object.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s GenerateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateTemplateOutput) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *GenerateTemplateOutput) SetS3Location(v *S3Location) *GenerateTemplateOutput {
	s.S3Location = v
	return s
}

type GetAppInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s GetAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetAppInput) SetAppId(v string) *GetAppInput {
	s.AppId = &v
	return s
}

type GetAppLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s GetAppLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppLaunchConfigurationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetAppLaunchConfigurationInput) SetAppId(v string) *GetAppLaunchConfigurationInput {
	s.AppId = &v
	return s
}

type GetAppLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`

	// Indicates whether the application is configured to launch automatically after
	// replication is complete.
	AutoLaunch *bool `locationName:"autoLaunch" type:"boolean"`

	// The name of the service role in the customer's account that AWS CloudFormation
	// uses to launch the application.
	RoleName *string `locationName:"roleName" type:"string"`

	// The launch configurations for server groups in this application.
	ServerGroupLaunchConfigurations []*ServerGroupLaunchConfiguration `locationName:"serverGroupLaunchConfigurations" type:"list"`
}

// String returns the string representation
func (s GetAppLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetAppLaunchConfigurationOutput) SetAppId(v string) *GetAppLaunchConfigurationOutput {
	s.AppId = &v
	return s
}

// SetAutoLaunch sets the AutoLaunch field's value.
func (s *GetAppLaunchConfigurationOutput) SetAutoLaunch(v bool) *GetAppLaunchConfigurationOutput {
	s.AutoLaunch = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *GetAppLaunchConfigurationOutput) SetRoleName(v string) *GetAppLaunchConfigurationOutput {
	s.RoleName = &v
	return s
}

// SetServerGroupLaunchConfigurations sets the ServerGroupLaunchConfigurations field's value.
func (s *GetAppLaunchConfigurationOutput) SetServerGroupLaunchConfigurations(v []*ServerGroupLaunchConfiguration) *GetAppLaunchConfigurationOutput {
	s.ServerGroupLaunchConfigurations = v
	return s
}

type GetAppOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	AppSummary *AppSummary `locationName:"appSummary" type:"structure"`

	// The server groups that belong to the application.
	ServerGroups []*ServerGroup `locationName:"serverGroups" type:"list"`

	// The tags associated with the application.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s GetAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppOutput) GoString() string {
	return s.String()
}

// SetAppSummary sets the AppSummary field's value.
func (s *GetAppOutput) SetAppSummary(v *AppSummary) *GetAppOutput {
	s.AppSummary = v
	return s
}

// SetServerGroups sets the ServerGroups field's value.
func (s *GetAppOutput) SetServerGroups(v []*ServerGroup) *GetAppOutput {
	s.ServerGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetAppOutput) SetTags(v []*Tag) *GetAppOutput {
	s.Tags = v
	return s
}

type GetAppReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s GetAppReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppReplicationConfigurationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetAppReplicationConfigurationInput) SetAppId(v string) *GetAppReplicationConfigurationInput {
	s.AppId = &v
	return s
}

type GetAppReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The replication configurations associated with server groups in this application.
	ServerGroupReplicationConfigurations []*ServerGroupReplicationConfiguration `locationName:"serverGroupReplicationConfigurations" type:"list"`
}

// String returns the string representation
func (s GetAppReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetServerGroupReplicationConfigurations sets the ServerGroupReplicationConfigurations field's value.
func (s *GetAppReplicationConfigurationOutput) SetServerGroupReplicationConfigurations(v []*ServerGroupReplicationConfiguration) *GetAppReplicationConfigurationOutput {
	s.ServerGroupReplicationConfigurations = v
	return s
}

type GetAppValidationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppValidationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppValidationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppValidationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppValidationConfigurationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetAppValidationConfigurationInput) SetAppId(v string) *GetAppValidationConfigurationInput {
	s.AppId = &v
	return s
}

type GetAppValidationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for application validation.
	AppValidationConfigurations []*AppValidationConfiguration `locationName:"appValidationConfigurations" type:"list"`

	// The configuration for instance validation.
	ServerGroupValidationConfigurations []*ServerGroupValidationConfiguration `locationName:"serverGroupValidationConfigurations" type:"list"`
}

// String returns the string representation
func (s GetAppValidationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppValidationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAppValidationConfigurations sets the AppValidationConfigurations field's value.
func (s *GetAppValidationConfigurationOutput) SetAppValidationConfigurations(v []*AppValidationConfiguration) *GetAppValidationConfigurationOutput {
	s.AppValidationConfigurations = v
	return s
}

// SetServerGroupValidationConfigurations sets the ServerGroupValidationConfigurations field's value.
func (s *GetAppValidationConfigurationOutput) SetServerGroupValidationConfigurations(v []*ServerGroupValidationConfiguration) *GetAppValidationConfigurationOutput {
	s.ServerGroupValidationConfigurations = v
	return s
}

type GetAppValidationOutputInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppValidationOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppValidationOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppValidationOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppValidationOutputInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetAppValidationOutputInput) SetAppId(v string) *GetAppValidationOutputInput {
	s.AppId = &v
	return s
}

type GetAppValidationOutputOutput struct {
	_ struct{} `type:"structure"`

	// The validation output.
	ValidationOutputList []*ValidationOutput `locationName:"validationOutputList" type:"list"`
}

// String returns the string representation
func (s GetAppValidationOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppValidationOutputOutput) GoString() string {
	return s.String()
}

// SetValidationOutputList sets the ValidationOutputList field's value.
func (s *GetAppValidationOutputOutput) SetValidationOutputList(v []*ValidationOutput) *GetAppValidationOutputOutput {
	s.ValidationOutputList = v
	return s
}

type GetConnectorsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. The default value
	// is 50. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetConnectorsInput) SetMaxResults(v int64) *GetConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectorsInput) SetNextToken(v string) *GetConnectorsInput {
	s.NextToken = &v
	return s
}

type GetConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the registered connectors.
	ConnectorList []*Connector `locationName:"connectorList" type:"list"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorsOutput) GoString() string {
	return s.String()
}

// SetConnectorList sets the ConnectorList field's value.
func (s *GetConnectorsOutput) SetConnectorList(v []*Connector) *GetConnectorsOutput {
	s.ConnectorList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectorsOutput) SetNextToken(v string) *GetConnectorsOutput {
	s.NextToken = &v
	return s
}

type GetReplicationJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. The default value
	// is 50. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the replication job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`
}

// String returns the string representation
func (s GetReplicationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationJobsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReplicationJobsInput) SetMaxResults(v int64) *GetReplicationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationJobsInput) SetNextToken(v string) *GetReplicationJobsInput {
	s.NextToken = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *GetReplicationJobsInput) SetReplicationJobId(v string) *GetReplicationJobsInput {
	s.ReplicationJobId = &v
	return s
}

type GetReplicationJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the replication jobs.
	ReplicationJobList []*ReplicationJob `locationName:"replicationJobList" type:"list"`
}

// String returns the string representation
func (s GetReplicationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationJobsOutput) SetNextToken(v string) *GetReplicationJobsOutput {
	s.NextToken = &v
	return s
}

// SetReplicationJobList sets the ReplicationJobList field's value.
func (s *GetReplicationJobsOutput) SetReplicationJobList(v []*ReplicationJob) *GetReplicationJobsOutput {
	s.ReplicationJobList = v
	return s
}

type GetReplicationRunsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. The default value
	// is 50. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the replication job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReplicationRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReplicationRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReplicationRunsInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReplicationRunsInput) SetMaxResults(v int64) *GetReplicationRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationRunsInput) SetNextToken(v string) *GetReplicationRunsInput {
	s.NextToken = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *GetReplicationRunsInput) SetReplicationJobId(v string) *GetReplicationRunsInput {
	s.ReplicationJobId = &v
	return s
}

type GetReplicationRunsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the replication job.
	ReplicationJob *ReplicationJob `locationName:"replicationJob" type:"structure"`

	// Information about the replication runs.
	ReplicationRunList []*ReplicationRun `locationName:"replicationRunList" type:"list"`
}

// String returns the string representation
func (s GetReplicationRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationRunsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationRunsOutput) SetNextToken(v string) *GetReplicationRunsOutput {
	s.NextToken = &v
	return s
}

// SetReplicationJob sets the ReplicationJob field's value.
func (s *GetReplicationRunsOutput) SetReplicationJob(v *ReplicationJob) *GetReplicationRunsOutput {
	s.ReplicationJob = v
	return s
}

// SetReplicationRunList sets the ReplicationRunList field's value.
func (s *GetReplicationRunsOutput) SetReplicationRunList(v []*ReplicationRun) *GetReplicationRunsOutput {
	s.ReplicationRunList = v
	return s
}

type GetServersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. The default value
	// is 50. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The server addresses.
	VmServerAddressList []*VmServerAddress `locationName:"vmServerAddressList" type:"list"`
}

// String returns the string representation
func (s GetServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetServersInput) SetMaxResults(v int64) *GetServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServersInput) SetNextToken(v string) *GetServersInput {
	s.NextToken = &v
	return s
}

// SetVmServerAddressList sets the VmServerAddressList field's value.
func (s *GetServersInput) SetVmServerAddressList(v []*VmServerAddress) *GetServersInput {
	s.VmServerAddressList = v
	return s
}

type GetServersOutput struct {
	_ struct{} `type:"structure"`

	// The time when the server was last modified.
	LastModifiedOn *time.Time `locationName:"lastModifiedOn" type:"timestamp"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The status of the server catalog.
	ServerCatalogStatus *string `locationName:"serverCatalogStatus" type:"string" enum:"ServerCatalogStatus"`

	// Information about the servers.
	ServerList []*Server `locationName:"serverList" type:"list"`
}

// String returns the string representation
func (s GetServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServersOutput) GoString() string {
	return s.String()
}

// SetLastModifiedOn sets the LastModifiedOn field's value.
func (s *GetServersOutput) SetLastModifiedOn(v time.Time) *GetServersOutput {
	s.LastModifiedOn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServersOutput) SetNextToken(v string) *GetServersOutput {
	s.NextToken = &v
	return s
}

// SetServerCatalogStatus sets the ServerCatalogStatus field's value.
func (s *GetServersOutput) SetServerCatalogStatus(v string) *GetServersOutput {
	s.ServerCatalogStatus = &v
	return s
}

// SetServerList sets the ServerList field's value.
func (s *GetServersOutput) SetServerList(v []*Server) *GetServersOutput {
	s.ServerList = v
	return s
}

type ImportAppCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the service role. If you omit this parameter, we create a service-linked
	// role for AWS Migration Hub in your account. Otherwise, the role that you
	// provide must have the policy and trust policy (https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed)
	// described in the AWS Migration Hub User Guide.
	RoleName *string `locationName:"roleName" type:"string"`
}

// String returns the string representation
func (s ImportAppCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportAppCatalogInput) GoString() string {
	return s.String()
}

// SetRoleName sets the RoleName field's value.
func (s *ImportAppCatalogInput) SetRoleName(v string) *ImportAppCatalogInput {
	s.RoleName = &v
	return s
}

type ImportAppCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportAppCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportAppCatalogOutput) GoString() string {
	return s.String()
}

type ImportServerCatalogInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportServerCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportServerCatalogInput) GoString() string {
	return s.String()
}

type ImportServerCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportServerCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportServerCatalogOutput) GoString() string {
	return s.String()
}

// An internal error occurred.
type InternalError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalError) GoString() string {
	return s.String()
}

func newErrorInternalError(v protocol.ResponseMetadata) error {
	return &InternalError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalError) Code() string {
	return "InternalError"
}

// Message returns the exception's message.
func (s *InternalError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalError) OrigErr() error {
	return nil
}

func (s *InternalError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalError) RequestID() string {
	return s.RespMetadata.RequestID
}

// A specified parameter is not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

type LaunchAppInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s LaunchAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchAppInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *LaunchAppInput) SetAppId(v string) *LaunchAppInput {
	s.AppId = &v
	return s
}

type LaunchAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LaunchAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchAppOutput) GoString() string {
	return s.String()
}

// Details about the latest launch of an application.
type LaunchDetails struct {
	_ struct{} `type:"structure"`

	// The latest time that this application was launched successfully.
	LatestLaunchTime *time.Time `locationName:"latestLaunchTime" type:"timestamp"`

	// The ID of the latest stack launched for this application.
	StackId *string `locationName:"stackId" type:"string"`

	// The name of the latest stack launched for this application.
	StackName *string `locationName:"stackName" type:"string"`
}

// String returns the string representation
func (s LaunchDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchDetails) GoString() string {
	return s.String()
}

// SetLatestLaunchTime sets the LatestLaunchTime field's value.
func (s *LaunchDetails) SetLatestLaunchTime(v time.Time) *LaunchDetails {
	s.LatestLaunchTime = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *LaunchDetails) SetStackId(v string) *LaunchDetails {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *LaunchDetails) SetStackName(v string) *LaunchDetails {
	s.StackName = &v
	return s
}

type ListAppsInput struct {
	_ struct{} `type:"structure"`

	// The unique application IDs.
	AppIds []*string `locationName:"appIds" type:"list"`

	// The maximum number of results to return in a single call. The default value
	// is 100. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAppsInput) GoString() string {
	return s.String()
}

// SetAppIds sets the AppIds field's value.
func (s *ListAppsInput) SetAppIds(v []*string) *ListAppsInput {
	s.AppIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppsInput) SetMaxResults(v int64) *ListAppsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsInput) SetNextToken(v string) *ListAppsInput {
	s.NextToken = &v
	return s
}

type ListAppsOutput struct {
	_ struct{} `type:"structure"`

	// The application summaries.
	Apps []*AppSummary `locationName:"apps" type:"list"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAppsOutput) GoString() string {
	return s.String()
}

// SetApps sets the Apps field's value.
func (s *ListAppsOutput) SetApps(v []*AppSummary) *ListAppsOutput {
	s.Apps = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsOutput) SetNextToken(v string) *ListAppsOutput {
	s.NextToken = &v
	return s
}

// A required parameter is missing.
type MissingRequiredParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MissingRequiredParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MissingRequiredParameterException) GoString() string {
	return s.String()
}

func newErrorMissingRequiredParameterException(v protocol.ResponseMetadata) error {
	return &MissingRequiredParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingRequiredParameterException) Code() string {
	return "MissingRequiredParameterException"
}

// Message returns the exception's message.
func (s *MissingRequiredParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingRequiredParameterException) OrigErr() error {
	return nil
}

func (s *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingRequiredParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingRequiredParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There are no connectors available.
type NoConnectorsAvailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoConnectorsAvailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoConnectorsAvailableException) GoString() string {
	return s.String()
}

func newErrorNoConnectorsAvailableException(v protocol.ResponseMetadata) error {
	return &NoConnectorsAvailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoConnectorsAvailableException) Code() string {
	return "NoConnectorsAvailableException"
}

// Message returns the exception's message.
func (s *NoConnectorsAvailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoConnectorsAvailableException) OrigErr() error {
	return nil
}

func (s *NoConnectorsAvailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoConnectorsAvailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoConnectorsAvailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the status of validating an application.
type NotificationContext struct {
	_ struct{} `type:"structure"`

	// The status of the validation.
	Status *string `locationName:"status" type:"string" enum:"ValidationStatus"`

	// The status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The ID of the validation.
	ValidationId *string `locationName:"validationId" type:"string"`
}

// String returns the string representation
func (s NotificationContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationContext) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *NotificationContext) SetStatus(v string) *NotificationContext {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *NotificationContext) SetStatusMessage(v string) *NotificationContext {
	s.StatusMessage = &v
	return s
}

// SetValidationId sets the ValidationId field's value.
func (s *NotificationContext) SetValidationId(v string) *NotificationContext {
	s.ValidationId = &v
	return s
}

type NotifyAppValidationOutputInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The notification information.
	NotificationContext *NotificationContext `locationName:"notificationContext" type:"structure"`
}

// String returns the string representation
func (s NotifyAppValidationOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyAppValidationOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyAppValidationOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyAppValidationOutputInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *NotifyAppValidationOutputInput) SetAppId(v string) *NotifyAppValidationOutputInput {
	s.AppId = &v
	return s
}

// SetNotificationContext sets the NotificationContext field's value.
func (s *NotifyAppValidationOutputInput) SetNotificationContext(v *NotificationContext) *NotifyAppValidationOutputInput {
	s.NotificationContext = v
	return s
}

type NotifyAppValidationOutputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s NotifyAppValidationOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyAppValidationOutputOutput) GoString() string {
	return s.String()
}

// This operation is not allowed.
type OperationNotPermittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OperationNotPermittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationNotPermittedException) GoString() string {
	return s.String()
}

func newErrorOperationNotPermittedException(v protocol.ResponseMetadata) error {
	return &OperationNotPermittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotPermittedException) Code() string {
	return "OperationNotPermittedException"
}

// Message returns the exception's message.
func (s *OperationNotPermittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotPermittedException) OrigErr() error {
	return nil
}

func (s *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotPermittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotPermittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutAppLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`

	// Indicates whether the application is configured to launch automatically after
	// replication is complete.
	AutoLaunch *bool `locationName:"autoLaunch" type:"boolean"`

	// The name of service role in the customer's account that AWS CloudFormation
	// uses to launch the application.
	RoleName *string `locationName:"roleName" type:"string"`

	// Information about the launch configurations for server groups in the application.
	ServerGroupLaunchConfigurations []*ServerGroupLaunchConfiguration `locationName:"serverGroupLaunchConfigurations" type:"list"`
}

// String returns the string representation
func (s PutAppLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAppLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAppLaunchConfigurationInput"}
	if s.ServerGroupLaunchConfigurations != nil {
		for i, v := range s.ServerGroupLaunchConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerGroupLaunchConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *PutAppLaunchConfigurationInput) SetAppId(v string) *PutAppLaunchConfigurationInput {
	s.AppId = &v
	return s
}

// SetAutoLaunch sets the AutoLaunch field's value.
func (s *PutAppLaunchConfigurationInput) SetAutoLaunch(v bool) *PutAppLaunchConfigurationInput {
	s.AutoLaunch = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *PutAppLaunchConfigurationInput) SetRoleName(v string) *PutAppLaunchConfigurationInput {
	s.RoleName = &v
	return s
}

// SetServerGroupLaunchConfigurations sets the ServerGroupLaunchConfigurations field's value.
func (s *PutAppLaunchConfigurationInput) SetServerGroupLaunchConfigurations(v []*ServerGroupLaunchConfiguration) *PutAppLaunchConfigurationInput {
	s.ServerGroupLaunchConfigurations = v
	return s
}

type PutAppLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAppLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAppLaunchConfigurationOutput) GoString() string {
	return s.String()
}

type PutAppReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`

	// Information about the replication configurations for server groups in the
	// application.
	ServerGroupReplicationConfigurations []*ServerGroupReplicationConfiguration `locationName:"serverGroupReplicationConfigurations" type:"list"`
}

// String returns the string representation
func (s PutAppReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAppReplicationConfigurationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *PutAppReplicationConfigurationInput) SetAppId(v string) *PutAppReplicationConfigurationInput {
	s.AppId = &v
	return s
}

// SetServerGroupReplicationConfigurations sets the ServerGroupReplicationConfigurations field's value.
func (s *PutAppReplicationConfigurationInput) SetServerGroupReplicationConfigurations(v []*ServerGroupReplicationConfiguration) *PutAppReplicationConfigurationInput {
	s.ServerGroupReplicationConfigurations = v
	return s
}

type PutAppReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAppReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAppReplicationConfigurationOutput) GoString() string {
	return s.String()
}

type PutAppValidationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The configuration for application validation.
	AppValidationConfigurations []*AppValidationConfiguration `locationName:"appValidationConfigurations" type:"list"`

	// The configuration for instance validation.
	ServerGroupValidationConfigurations []*ServerGroupValidationConfiguration `locationName:"serverGroupValidationConfigurations" type:"list"`
}

// String returns the string representation
func (s PutAppValidationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAppValidationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppValidationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAppValidationConfigurationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppValidationConfigurations != nil {
		for i, v := range s.AppValidationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AppValidationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ServerGroupValidationConfigurations != nil {
		for i, v := range s.ServerGroupValidationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerGroupValidationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *PutAppValidationConfigurationInput) SetAppId(v string) *PutAppValidationConfigurationInput {
	s.AppId = &v
	return s
}

// SetAppValidationConfigurations sets the AppValidationConfigurations field's value.
func (s *PutAppValidationConfigurationInput) SetAppValidationConfigurations(v []*AppValidationConfiguration) *PutAppValidationConfigurationInput {
	s.AppValidationConfigurations = v
	return s
}

// SetServerGroupValidationConfigurations sets the ServerGroupValidationConfigurations field's value.
func (s *PutAppValidationConfigurationInput) SetServerGroupValidationConfigurations(v []*ServerGroupValidationConfiguration) *PutAppValidationConfigurationInput {
	s.ServerGroupValidationConfigurations = v
	return s
}

type PutAppValidationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAppValidationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAppValidationConfigurationOutput) GoString() string {
	return s.String()
}

// Represents a replication job.
type ReplicationJob struct {
	_ struct{} `type:"structure"`

	// The description of the replication job.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the replication job should produce encrypted AMIs.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The time between consecutive replication runs, in hours.
	Frequency *int64 `locationName:"frequency" type:"integer"`

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	//    * KMS key ID
	//
	//    * KMS key alias
	//
	//    * ARN referring to the KMS key ID
	//
	//    * ARN referring to the KMS key alias
	//
	// If encrypted is enabled but a KMS key ID is not specified, the customer's
	// default KMS key for Amazon EBS is used.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The ID of the latest Amazon Machine Image (AMI).
	LatestAmiId *string `locationName:"latestAmiId" type:"string"`

	// The license type to be used for the AMI created by a successful replication
	// run.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// The start time of the next replication run.
	NextReplicationRunStartTime *time.Time `locationName:"nextReplicationRunStartTime" type:"timestamp"`

	// The number of recent AMIs to keep in the customer's account for a replication
	// job. By default, the value is set to zero, meaning that all AMIs are kept.
	NumberOfRecentAmisToKeep *int64 `locationName:"numberOfRecentAmisToKeep" type:"integer"`

	// The ID of the replication job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`

	// Information about the replication runs.
	ReplicationRunList []*ReplicationRun `locationName:"replicationRunList" type:"list"`

	// The name of the IAM role to be used by AWS SMS.
	RoleName *string `locationName:"roleName" type:"string"`

	// Indicates whether to run the replication job one time.
	RunOnce *bool `locationName:"runOnce" type:"boolean"`

	// The seed replication time.
	SeedReplicationTime *time.Time `locationName:"seedReplicationTime" type:"timestamp"`

	// The ID of the server.
	ServerId *string `locationName:"serverId" type:"string"`

	// The type of server.
	ServerType *string `locationName:"serverType" type:"string" enum:"ServerType"`

	// The state of the replication job.
	State *string `locationName:"state" type:"string" enum:"ReplicationJobState"`

	// The description of the current status of the replication job.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Information about the VM server.
	VmServer *VmServer `locationName:"vmServer" type:"structure"`
}

// String returns the string representation
func (s ReplicationJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationJob) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ReplicationJob) SetDescription(v string) *ReplicationJob {
	s.Description = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *ReplicationJob) SetEncrypted(v bool) *ReplicationJob {
	s.Encrypted = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *ReplicationJob) SetFrequency(v int64) *ReplicationJob {
	s.Frequency = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationJob) SetKmsKeyId(v string) *ReplicationJob {
	s.KmsKeyId = &v
	return s
}

// SetLatestAmiId sets the LatestAmiId field's value.
func (s *ReplicationJob) SetLatestAmiId(v string) *ReplicationJob {
	s.LatestAmiId = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *ReplicationJob) SetLicenseType(v string) *ReplicationJob {
	s.LicenseType = &v
	return s
}

// SetNextReplicationRunStartTime sets the NextReplicationRunStartTime field's value.
func (s *ReplicationJob) SetNextReplicationRunStartTime(v time.Time) *ReplicationJob {
	s.NextReplicationRunStartTime = &v
	return s
}

// SetNumberOfRecentAmisToKeep sets the NumberOfRecentAmisToKeep field's value.
func (s *ReplicationJob) SetNumberOfRecentAmisToKeep(v int64) *ReplicationJob {
	s.NumberOfRecentAmisToKeep = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *ReplicationJob) SetReplicationJobId(v string) *ReplicationJob {
	s.ReplicationJobId = &v
	return s
}

// SetReplicationRunList sets the ReplicationRunList field's value.
func (s *ReplicationJob) SetReplicationRunList(v []*ReplicationRun) *ReplicationJob {
	s.ReplicationRunList = v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *ReplicationJob) SetRoleName(v string) *ReplicationJob {
	s.RoleName = &v
	return s
}

// SetRunOnce sets the RunOnce field's value.
func (s *ReplicationJob) SetRunOnce(v bool) *ReplicationJob {
	s.RunOnce = &v
	return s
}

// SetSeedReplicationTime sets the SeedReplicationTime field's value.
func (s *ReplicationJob) SetSeedReplicationTime(v time.Time) *ReplicationJob {
	s.SeedReplicationTime = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ReplicationJob) SetServerId(v string) *ReplicationJob {
	s.ServerId = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *ReplicationJob) SetServerType(v string) *ReplicationJob {
	s.ServerType = &v
	return s
}

// SetState sets the State field's value.
func (s *ReplicationJob) SetState(v string) *ReplicationJob {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplicationJob) SetStatusMessage(v string) *ReplicationJob {
	s.StatusMessage = &v
	return s
}

// SetVmServer sets the VmServer field's value.
func (s *ReplicationJob) SetVmServer(v *VmServer) *ReplicationJob {
	s.VmServer = v
	return s
}

// The specified replication job already exists.
type ReplicationJobAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ReplicationJobAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationJobAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorReplicationJobAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ReplicationJobAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReplicationJobAlreadyExistsException) Code() string {
	return "ReplicationJobAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ReplicationJobAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReplicationJobAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ReplicationJobAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReplicationJobAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReplicationJobAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified replication job does not exist.
type ReplicationJobNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ReplicationJobNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationJobNotFoundException) GoString() string {
	return s.String()
}

func newErrorReplicationJobNotFoundException(v protocol.ResponseMetadata) error {
	return &ReplicationJobNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReplicationJobNotFoundException) Code() string {
	return "ReplicationJobNotFoundException"
}

// Message returns the exception's message.
func (s *ReplicationJobNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReplicationJobNotFoundException) OrigErr() error {
	return nil
}

func (s *ReplicationJobNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReplicationJobNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReplicationJobNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a replication run.
type ReplicationRun struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Machine Image (AMI) from the replication run.
	AmiId *string `locationName:"amiId" type:"string"`

	// The completion time of the last replication run.
	CompletedTime *time.Time `locationName:"completedTime" type:"timestamp"`

	// The description of the replication run.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the replication run should produce an encrypted AMI.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	//    * KMS key ID
	//
	//    * KMS key alias
	//
	//    * ARN referring to the KMS key ID
	//
	//    * ARN referring to the KMS key alias
	//
	// If encrypted is true but a KMS key ID is not specified, the customer's default
	// KMS key for Amazon EBS is used.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The ID of the replication run.
	ReplicationRunId *string `locationName:"replicationRunId" type:"string"`

	// The start time of the next replication run.
	ScheduledStartTime *time.Time `locationName:"scheduledStartTime" type:"timestamp"`

	// Details about the current stage of the replication run.
	StageDetails *ReplicationRunStageDetails `locationName:"stageDetails" type:"structure"`

	// The state of the replication run.
	State *string `locationName:"state" type:"string" enum:"ReplicationRunState"`

	// The description of the current status of the replication job.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The type of replication run.
	Type *string `locationName:"type" type:"string" enum:"ReplicationRunType"`
}

// String returns the string representation
func (s ReplicationRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRun) GoString() string {
	return s.String()
}

// SetAmiId sets the AmiId field's value.
func (s *ReplicationRun) SetAmiId(v string) *ReplicationRun {
	s.AmiId = &v
	return s
}

// SetCompletedTime sets the CompletedTime field's value.
func (s *ReplicationRun) SetCompletedTime(v time.Time) *ReplicationRun {
	s.CompletedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReplicationRun) SetDescription(v string) *ReplicationRun {
	s.Description = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *ReplicationRun) SetEncrypted(v bool) *ReplicationRun {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationRun) SetKmsKeyId(v string) *ReplicationRun {
	s.KmsKeyId = &v
	return s
}

// SetReplicationRunId sets the ReplicationRunId field's value.
func (s *ReplicationRun) SetReplicationRunId(v string) *ReplicationRun {
	s.ReplicationRunId = &v
	return s
}

// SetScheduledStartTime sets the ScheduledStartTime field's value.
func (s *ReplicationRun) SetScheduledStartTime(v time.Time) *ReplicationRun {
	s.ScheduledStartTime = &v
	return s
}

// SetStageDetails sets the StageDetails field's value.
func (s *ReplicationRun) SetStageDetails(v *ReplicationRunStageDetails) *ReplicationRun {
	s.StageDetails = v
	return s
}

// SetState sets the State field's value.
func (s *ReplicationRun) SetState(v string) *ReplicationRun {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplicationRun) SetStatusMessage(v string) *ReplicationRun {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *ReplicationRun) SetType(v string) *ReplicationRun {
	s.Type = &v
	return s
}

// You have exceeded the number of on-demand replication runs you can request
// in a 24-hour period.
type ReplicationRunLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ReplicationRunLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRunLimitExceededException) GoString() string {
	return s.String()
}

func newErrorReplicationRunLimitExceededException(v protocol.ResponseMetadata) error {
	return &ReplicationRunLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReplicationRunLimitExceededException) Code() string {
	return "ReplicationRunLimitExceededException"
}

// Message returns the exception's message.
func (s *ReplicationRunLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReplicationRunLimitExceededException) OrigErr() error {
	return nil
}

func (s *ReplicationRunLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReplicationRunLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReplicationRunLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details of the current stage of a replication run.
type ReplicationRunStageDetails struct {
	_ struct{} `type:"structure"`

	// The current stage of a replication run.
	Stage *string `locationName:"stage" type:"string"`

	// The progress of the current stage of a replication run.
	StageProgress *string `locationName:"stageProgress" type:"string"`
}

// String returns the string representation
func (s ReplicationRunStageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRunStageDetails) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *ReplicationRunStageDetails) SetStage(v string) *ReplicationRunStageDetails {
	s.Stage = &v
	return s
}

// SetStageProgress sets the StageProgress field's value.
func (s *ReplicationRunStageDetails) SetStageProgress(v string) *ReplicationRunStageDetails {
	s.StageProgress = &v
	return s
}

// Location of an Amazon S3 object.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// The Amazon S3 bucket key.
	Key *string `locationName:"key" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// Contains the location of validation output.
type SSMOutput struct {
	_ struct{} `type:"structure"`

	// Location of an Amazon S3 object.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s SSMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSMOutput) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *SSMOutput) SetS3Location(v *S3Location) *SSMOutput {
	s.S3Location = v
	return s
}

// Contains validation parameters.
type SSMValidationParameters struct {
	_ struct{} `type:"structure"`

	// The command to run the validation script
	Command *string `locationName:"command" min:"1" type:"string"`

	// The timeout interval, in seconds.
	ExecutionTimeoutSeconds *int64 `locationName:"executionTimeoutSeconds" min:"60" type:"integer"`

	// The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The name of the S3 bucket for output.
	OutputS3BucketName *string `locationName:"outputS3BucketName" type:"string"`

	// The type of validation script.
	ScriptType *string `locationName:"scriptType" type:"string" enum:"ScriptType"`

	// The location of the validation script.
	Source *Source `locationName:"source" type:"structure"`
}

// String returns the string representation
func (s SSMValidationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSMValidationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSMValidationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SSMValidationParameters"}
	if s.Command != nil && len(*s.Command) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Command", 1))
	}
	if s.ExecutionTimeoutSeconds != nil && *s.ExecutionTimeoutSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("ExecutionTimeoutSeconds", 60))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *SSMValidationParameters) SetCommand(v string) *SSMValidationParameters {
	s.Command = &v
	return s
}

// SetExecutionTimeoutSeconds sets the ExecutionTimeoutSeconds field's value.
func (s *SSMValidationParameters) SetExecutionTimeoutSeconds(v int64) *SSMValidationParameters {
	s.ExecutionTimeoutSeconds = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *SSMValidationParameters) SetInstanceId(v string) *SSMValidationParameters {
	s.InstanceId = &v
	return s
}

// SetOutputS3BucketName sets the OutputS3BucketName field's value.
func (s *SSMValidationParameters) SetOutputS3BucketName(v string) *SSMValidationParameters {
	s.OutputS3BucketName = &v
	return s
}

// SetScriptType sets the ScriptType field's value.
func (s *SSMValidationParameters) SetScriptType(v string) *SSMValidationParameters {
	s.ScriptType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SSMValidationParameters) SetSource(v *Source) *SSMValidationParameters {
	s.Source = v
	return s
}

// Represents a server.
type Server struct {
	_ struct{} `type:"structure"`

	// The ID of the replication job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`

	// Indicates whether the replication job is deleted or failed.
	ReplicationJobTerminated *bool `locationName:"replicationJobTerminated" type:"boolean"`

	// The ID of the server.
	ServerId *string `locationName:"serverId" type:"string"`

	// The type of server.
	ServerType *string `locationName:"serverType" type:"string" enum:"ServerType"`

	// Information about the VM server.
	VmServer *VmServer `locationName:"vmServer" type:"structure"`
}

// String returns the string representation
func (s Server) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Server) GoString() string {
	return s.String()
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *Server) SetReplicationJobId(v string) *Server {
	s.ReplicationJobId = &v
	return s
}

// SetReplicationJobTerminated sets the ReplicationJobTerminated field's value.
func (s *Server) SetReplicationJobTerminated(v bool) *Server {
	s.ReplicationJobTerminated = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *Server) SetServerId(v string) *Server {
	s.ServerId = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *Server) SetServerType(v string) *Server {
	s.ServerType = &v
	return s
}

// SetVmServer sets the VmServer field's value.
func (s *Server) SetVmServer(v *VmServer) *Server {
	s.VmServer = v
	return s
}

// The specified server cannot be replicated.
type ServerCannotBeReplicatedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServerCannotBeReplicatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerCannotBeReplicatedException) GoString() string {
	return s.String()
}

func newErrorServerCannotBeReplicatedException(v protocol.ResponseMetadata) error {
	return &ServerCannotBeReplicatedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerCannotBeReplicatedException) Code() string {
	return "ServerCannotBeReplicatedException"
}

// Message returns the exception's message.
func (s *ServerCannotBeReplicatedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerCannotBeReplicatedException) OrigErr() error {
	return nil
}

func (s *ServerCannotBeReplicatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerCannotBeReplicatedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerCannotBeReplicatedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Logical grouping of servers.
type ServerGroup struct {
	_ struct{} `type:"structure"`

	// The name of a server group.
	Name *string `locationName:"name" type:"string"`

	// The ID of a server group.
	ServerGroupId *string `locationName:"serverGroupId" type:"string"`

	// The servers that belong to a server group.
	ServerList []*Server `locationName:"serverList" type:"list"`
}

// String returns the string representation
func (s ServerGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerGroup) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ServerGroup) SetName(v string) *ServerGroup {
	s.Name = &v
	return s
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ServerGroup) SetServerGroupId(v string) *ServerGroup {
	s.ServerGroupId = &v
	return s
}

// SetServerList sets the ServerList field's value.
func (s *ServerGroup) SetServerList(v []*Server) *ServerGroup {
	s.ServerList = v
	return s
}

// Launch configuration for a server group.
type ServerGroupLaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// The launch order of servers in the server group.
	LaunchOrder *int64 `locationName:"launchOrder" type:"integer"`

	// The ID of the server group with which the launch configuration is associated.
	ServerGroupId *string `locationName:"serverGroupId" type:"string"`

	// The launch configuration for servers in the server group.
	ServerLaunchConfigurations []*ServerLaunchConfiguration `locationName:"serverLaunchConfigurations" type:"list"`
}

// String returns the string representation
func (s ServerGroupLaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerGroupLaunchConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerGroupLaunchConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerGroupLaunchConfiguration"}
	if s.ServerLaunchConfigurations != nil {
		for i, v := range s.ServerLaunchConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerLaunchConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchOrder sets the LaunchOrder field's value.
func (s *ServerGroupLaunchConfiguration) SetLaunchOrder(v int64) *ServerGroupLaunchConfiguration {
	s.LaunchOrder = &v
	return s
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ServerGroupLaunchConfiguration) SetServerGroupId(v string) *ServerGroupLaunchConfiguration {
	s.ServerGroupId = &v
	return s
}

// SetServerLaunchConfigurations sets the ServerLaunchConfigurations field's value.
func (s *ServerGroupLaunchConfiguration) SetServerLaunchConfigurations(v []*ServerLaunchConfiguration) *ServerGroupLaunchConfiguration {
	s.ServerLaunchConfigurations = v
	return s
}

// Replication configuration for a server group.
type ServerGroupReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the server group with which this replication configuration is associated.
	ServerGroupId *string `locationName:"serverGroupId" type:"string"`

	// The replication configuration for servers in the server group.
	ServerReplicationConfigurations []*ServerReplicationConfiguration `locationName:"serverReplicationConfigurations" type:"list"`
}

// String returns the string representation
func (s ServerGroupReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerGroupReplicationConfiguration) GoString() string {
	return s.String()
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ServerGroupReplicationConfiguration) SetServerGroupId(v string) *ServerGroupReplicationConfiguration {
	s.ServerGroupId = &v
	return s
}

// SetServerReplicationConfigurations sets the ServerReplicationConfigurations field's value.
func (s *ServerGroupReplicationConfiguration) SetServerReplicationConfigurations(v []*ServerReplicationConfiguration) *ServerGroupReplicationConfiguration {
	s.ServerReplicationConfigurations = v
	return s
}

// Configuration for validating an instance.
type ServerGroupValidationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the server group.
	ServerGroupId *string `locationName:"serverGroupId" type:"string"`

	// The validation configuration.
	ServerValidationConfigurations []*ServerValidationConfiguration `locationName:"serverValidationConfigurations" type:"list"`
}

// String returns the string representation
func (s ServerGroupValidationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerGroupValidationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerGroupValidationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerGroupValidationConfiguration"}
	if s.ServerValidationConfigurations != nil {
		for i, v := range s.ServerValidationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerValidationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ServerGroupValidationConfiguration) SetServerGroupId(v string) *ServerGroupValidationConfiguration {
	s.ServerGroupId = &v
	return s
}

// SetServerValidationConfigurations sets the ServerValidationConfigurations field's value.
func (s *ServerGroupValidationConfiguration) SetServerValidationConfigurations(v []*ServerValidationConfiguration) *ServerGroupValidationConfiguration {
	s.ServerValidationConfigurations = v
	return s
}

// Launch configuration for a server.
type ServerLaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether a publicly accessible IP address is created when launching
	// the server.
	AssociatePublicIpAddress *bool `locationName:"associatePublicIpAddress" type:"boolean"`

	// Location of an Amazon S3 object.
	ConfigureScript *S3Location `locationName:"configureScript" type:"structure"`

	// The type of configuration script.
	ConfigureScriptType *string `locationName:"configureScriptType" type:"string" enum:"ScriptType"`

	// The name of the Amazon EC2 SSH key to be used for connecting to the launched
	// server.
	Ec2KeyName *string `locationName:"ec2KeyName" type:"string"`

	// The name of the IAM instance profile.
	IamInstanceProfileName *string `locationName:"iamInstanceProfileName" type:"string"`

	// The instance type to use when launching the server.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The logical ID of the server in the AWS CloudFormation template.
	LogicalId *string `locationName:"logicalId" type:"string"`

	// The ID of the security group that applies to the launched server.
	SecurityGroup *string `locationName:"securityGroup" type:"string"`

	// The ID of the server with which the launch configuration is associated.
	Server *Server `locationName:"server" type:"structure"`

	// The ID of the subnet the server should be launched into.
	Subnet *string `locationName:"subnet" type:"string"`

	// Location of the user-data script to be executed when launching the server.
	UserData *UserData `locationName:"userData" type:"structure"`

	// The ID of the VPC into which the server should be launched.
	Vpc *string `locationName:"vpc" type:"string"`
}

// String returns the string representation
func (s ServerLaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerLaunchConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerLaunchConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerLaunchConfiguration"}
	if s.ConfigureScript != nil {
		if err := s.ConfigureScript.Validate(); err != nil {
			invalidParams.AddNested("ConfigureScript", err.(request.ErrInvalidParams))
		}
	}
	if s.UserData != nil {
		if err := s.UserData.Validate(); err != nil {
			invalidParams.AddNested("UserData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *ServerLaunchConfiguration) SetAssociatePublicIpAddress(v bool) *ServerLaunchConfiguration {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetConfigureScript sets the ConfigureScript field's value.
func (s *ServerLaunchConfiguration) SetConfigureScript(v *S3Location) *ServerLaunchConfiguration {
	s.ConfigureScript = v
	return s
}

// SetConfigureScriptType sets the ConfigureScriptType field's value.
func (s *ServerLaunchConfiguration) SetConfigureScriptType(v string) *ServerLaunchConfiguration {
	s.ConfigureScriptType = &v
	return s
}

// SetEc2KeyName sets the Ec2KeyName field's value.
func (s *ServerLaunchConfiguration) SetEc2KeyName(v string) *ServerLaunchConfiguration {
	s.Ec2KeyName = &v
	return s
}

// SetIamInstanceProfileName sets the IamInstanceProfileName field's value.
func (s *ServerLaunchConfiguration) SetIamInstanceProfileName(v string) *ServerLaunchConfiguration {
	s.IamInstanceProfileName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ServerLaunchConfiguration) SetInstanceType(v string) *ServerLaunchConfiguration {
	s.InstanceType = &v
	return s
}

// SetLogicalId sets the LogicalId field's value.
func (s *ServerLaunchConfiguration) SetLogicalId(v string) *ServerLaunchConfiguration {
	s.LogicalId = &v
	return s
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *ServerLaunchConfiguration) SetSecurityGroup(v string) *ServerLaunchConfiguration {
	s.SecurityGroup = &v
	return s
}

// SetServer sets the Server field's value.
func (s *ServerLaunchConfiguration) SetServer(v *Server) *ServerLaunchConfiguration {
	s.Server = v
	return s
}

// SetSubnet sets the Subnet field's value.
func (s *ServerLaunchConfiguration) SetSubnet(v string) *ServerLaunchConfiguration {
	s.Subnet = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *ServerLaunchConfiguration) SetUserData(v *UserData) *ServerLaunchConfiguration {
	s.UserData = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *ServerLaunchConfiguration) SetVpc(v string) *ServerLaunchConfiguration {
	s.Vpc = &v
	return s
}

// Replication configuration of a server.
type ServerReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the server with which this replication configuration is associated.
	Server *Server `locationName:"server" type:"structure"`

	// The parameters for replicating the server.
	ServerReplicationParameters *ServerReplicationParameters `locationName:"serverReplicationParameters" type:"structure"`
}

// String returns the string representation
func (s ServerReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerReplicationConfiguration) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *ServerReplicationConfiguration) SetServer(v *Server) *ServerReplicationConfiguration {
	s.Server = v
	return s
}

// SetServerReplicationParameters sets the ServerReplicationParameters field's value.
func (s *ServerReplicationConfiguration) SetServerReplicationParameters(v *ServerReplicationParameters) *ServerReplicationConfiguration {
	s.ServerReplicationParameters = v
	return s
}

// The replication parameters for replicating a server.
type ServerReplicationParameters struct {
	_ struct{} `type:"structure"`

	// Indicates whether the replication job produces encrypted AMIs.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The frequency of creating replication jobs for the server.
	Frequency *int64 `locationName:"frequency" type:"integer"`

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	//    * KMS key ID
	//
	//    * KMS key alias
	//
	//    * ARN referring to the KMS key ID
	//
	//    * ARN referring to the KMS key alias
	//
	// If encrypted is enabled but a KMS key ID is not specified, the customer's
	// default KMS key for Amazon EBS is used.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The license type for creating a replication job for the server.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// The number of recent AMIs to keep when creating a replication job for this
	// server.
	NumberOfRecentAmisToKeep *int64 `locationName:"numberOfRecentAmisToKeep" type:"integer"`

	// Indicates whether to run the replication job one time.
	RunOnce *bool `locationName:"runOnce" type:"boolean"`

	// The seed time for creating a replication job for the server.
	SeedTime *time.Time `locationName:"seedTime" type:"timestamp"`
}

// String returns the string representation
func (s ServerReplicationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerReplicationParameters) GoString() string {
	return s.String()
}

// SetEncrypted sets the Encrypted field's value.
func (s *ServerReplicationParameters) SetEncrypted(v bool) *ServerReplicationParameters {
	s.Encrypted = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *ServerReplicationParameters) SetFrequency(v int64) *ServerReplicationParameters {
	s.Frequency = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ServerReplicationParameters) SetKmsKeyId(v string) *ServerReplicationParameters {
	s.KmsKeyId = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *ServerReplicationParameters) SetLicenseType(v string) *ServerReplicationParameters {
	s.LicenseType = &v
	return s
}

// SetNumberOfRecentAmisToKeep sets the NumberOfRecentAmisToKeep field's value.
func (s *ServerReplicationParameters) SetNumberOfRecentAmisToKeep(v int64) *ServerReplicationParameters {
	s.NumberOfRecentAmisToKeep = &v
	return s
}

// SetRunOnce sets the RunOnce field's value.
func (s *ServerReplicationParameters) SetRunOnce(v bool) *ServerReplicationParameters {
	s.RunOnce = &v
	return s
}

// SetSeedTime sets the SeedTime field's value.
func (s *ServerReplicationParameters) SetSeedTime(v time.Time) *ServerReplicationParameters {
	s.SeedTime = &v
	return s
}

// Configuration for validating an instance.
type ServerValidationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the configuration.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents a server.
	Server *Server `locationName:"server" type:"structure"`

	// The validation strategy.
	ServerValidationStrategy *string `locationName:"serverValidationStrategy" type:"string" enum:"ServerValidationStrategy"`

	// The validation parameters.
	UserDataValidationParameters *UserDataValidationParameters `locationName:"userDataValidationParameters" type:"structure"`

	// The ID of the validation.
	ValidationId *string `locationName:"validationId" type:"string"`
}

// String returns the string representation
func (s ServerValidationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerValidationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerValidationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerValidationConfiguration"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UserDataValidationParameters != nil {
		if err := s.UserDataValidationParameters.Validate(); err != nil {
			invalidParams.AddNested("UserDataValidationParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ServerValidationConfiguration) SetName(v string) *ServerValidationConfiguration {
	s.Name = &v
	return s
}

// SetServer sets the Server field's value.
func (s *ServerValidationConfiguration) SetServer(v *Server) *ServerValidationConfiguration {
	s.Server = v
	return s
}

// SetServerValidationStrategy sets the ServerValidationStrategy field's value.
func (s *ServerValidationConfiguration) SetServerValidationStrategy(v string) *ServerValidationConfiguration {
	s.ServerValidationStrategy = &v
	return s
}

// SetUserDataValidationParameters sets the UserDataValidationParameters field's value.
func (s *ServerValidationConfiguration) SetUserDataValidationParameters(v *UserDataValidationParameters) *ServerValidationConfiguration {
	s.UserDataValidationParameters = v
	return s
}

// SetValidationId sets the ValidationId field's value.
func (s *ServerValidationConfiguration) SetValidationId(v string) *ServerValidationConfiguration {
	s.ValidationId = &v
	return s
}

// Contains output from validating an instance.
type ServerValidationOutput struct {
	_ struct{} `type:"structure"`

	// Represents a server.
	Server *Server `locationName:"server" type:"structure"`
}

// String returns the string representation
func (s ServerValidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerValidationOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *ServerValidationOutput) SetServer(v *Server) *ServerValidationOutput {
	s.Server = v
	return s
}

// Contains the location of a validation script.
type Source struct {
	_ struct{} `type:"structure"`

	// Location of an Amazon S3 object.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Source"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *Source) SetS3Location(v *S3Location) *Source {
	s.S3Location = v
	return s
}

type StartAppReplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s StartAppReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartAppReplicationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *StartAppReplicationInput) SetAppId(v string) *StartAppReplicationInput {
	s.AppId = &v
	return s
}

type StartAppReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartAppReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartAppReplicationOutput) GoString() string {
	return s.String()
}

type StartOnDemandAppReplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The description of the replication run.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s StartOnDemandAppReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOnDemandAppReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartOnDemandAppReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartOnDemandAppReplicationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *StartOnDemandAppReplicationInput) SetAppId(v string) *StartOnDemandAppReplicationInput {
	s.AppId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartOnDemandAppReplicationInput) SetDescription(v string) *StartOnDemandAppReplicationInput {
	s.Description = &v
	return s
}

type StartOnDemandAppReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartOnDemandAppReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOnDemandAppReplicationOutput) GoString() string {
	return s.String()
}

type StartOnDemandReplicationRunInput struct {
	_ struct{} `type:"structure"`

	// The description of the replication run.
	Description *string `locationName:"description" type:"string"`

	// The ID of the replication job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartOnDemandReplicationRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOnDemandReplicationRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartOnDemandReplicationRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartOnDemandReplicationRunInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StartOnDemandReplicationRunInput) SetDescription(v string) *StartOnDemandReplicationRunInput {
	s.Description = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *StartOnDemandReplicationRunInput) SetReplicationJobId(v string) *StartOnDemandReplicationRunInput {
	s.ReplicationJobId = &v
	return s
}

type StartOnDemandReplicationRunOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the replication run.
	ReplicationRunId *string `locationName:"replicationRunId" type:"string"`
}

// String returns the string representation
func (s StartOnDemandReplicationRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOnDemandReplicationRunOutput) GoString() string {
	return s.String()
}

// SetReplicationRunId sets the ReplicationRunId field's value.
func (s *StartOnDemandReplicationRunOutput) SetReplicationRunId(v string) *StartOnDemandReplicationRunOutput {
	s.ReplicationRunId = &v
	return s
}

type StopAppReplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s StopAppReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopAppReplicationInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *StopAppReplicationInput) SetAppId(v string) *StopAppReplicationInput {
	s.AppId = &v
	return s
}

type StopAppReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopAppReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopAppReplicationOutput) GoString() string {
	return s.String()
}

// Key/value pair that can be assigned to an application.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `locationName:"key" type:"string"`

	// The tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The service is temporarily unavailable.
type TemporarilyUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TemporarilyUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemporarilyUnavailableException) GoString() string {
	return s.String()
}

func newErrorTemporarilyUnavailableException(v protocol.ResponseMetadata) error {
	return &TemporarilyUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TemporarilyUnavailableException) Code() string {
	return "TemporarilyUnavailableException"
}

// Message returns the exception's message.
func (s *TemporarilyUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TemporarilyUnavailableException) OrigErr() error {
	return nil
}

func (s *TemporarilyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TemporarilyUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TemporarilyUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TerminateAppInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s TerminateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateAppInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *TerminateAppInput) SetAppId(v string) *TerminateAppInput {
	s.AppId = &v
	return s
}

type TerminateAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TerminateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateAppOutput) GoString() string {
	return s.String()
}

// You lack permissions needed to perform this operation. Check your IAM policies,
// and ensure that you are using the correct access keys.
type UnauthorizedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedOperationException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedOperationException(v protocol.ResponseMetadata) error {
	return &UnauthorizedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedOperationException) Code() string {
	return "UnauthorizedOperationException"
}

// Message returns the exception's message.
func (s *UnauthorizedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedOperationException) OrigErr() error {
	return nil
}

func (s *UnauthorizedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateAppInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	AppId *string `locationName:"appId" type:"string"`

	// The new description of the application.
	Description *string `locationName:"description" type:"string"`

	// The new name of the application.
	Name *string `locationName:"name" type:"string"`

	// The name of the service role in the customer's account used by AWS SMS.
	RoleName *string `locationName:"roleName" type:"string"`

	// The server groups in the application to update.
	ServerGroups []*ServerGroup `locationName:"serverGroups" type:"list"`

	// The tags to associate with the application.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s UpdateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateAppInput) SetAppId(v string) *UpdateAppInput {
	s.AppId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAppInput) SetDescription(v string) *UpdateAppInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInput) SetName(v string) *UpdateAppInput {
	s.Name = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *UpdateAppInput) SetRoleName(v string) *UpdateAppInput {
	s.RoleName = &v
	return s
}

// SetServerGroups sets the ServerGroups field's value.
func (s *UpdateAppInput) SetServerGroups(v []*ServerGroup) *UpdateAppInput {
	s.ServerGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateAppInput) SetTags(v []*Tag) *UpdateAppInput {
	s.Tags = v
	return s
}

type UpdateAppOutput struct {
	_ struct{} `type:"structure"`

	// A summary description of the application.
	AppSummary *AppSummary `locationName:"appSummary" type:"structure"`

	// The updated server groups in the application.
	ServerGroups []*ServerGroup `locationName:"serverGroups" type:"list"`

	// The tags associated with the application.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s UpdateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppOutput) GoString() string {
	return s.String()
}

// SetAppSummary sets the AppSummary field's value.
func (s *UpdateAppOutput) SetAppSummary(v *AppSummary) *UpdateAppOutput {
	s.AppSummary = v
	return s
}

// SetServerGroups sets the ServerGroups field's value.
func (s *UpdateAppOutput) SetServerGroups(v []*ServerGroup) *UpdateAppOutput {
	s.ServerGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateAppOutput) SetTags(v []*Tag) *UpdateAppOutput {
	s.Tags = v
	return s
}

type UpdateReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The description of the replication job.
	Description *string `locationName:"description" type:"string"`

	// When true, the replication job produces encrypted AMIs. For more information,
	// KmsKeyId.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The time between consecutive replication runs, in hours.
	Frequency *int64 `locationName:"frequency" type:"integer"`

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	//    * KMS key ID
	//
	//    * KMS key alias
	//
	//    * ARN referring to the KMS key ID
	//
	//    * ARN referring to the KMS key alias
	//
	// If encrypted is enabled but a KMS key ID is not specified, the customer's
	// default KMS key for Amazon EBS is used.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The license type to be used for the AMI created by a successful replication
	// run.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// The start time of the next replication run.
	NextReplicationRunStartTime *time.Time `locationName:"nextReplicationRunStartTime" type:"timestamp"`

	// The maximum number of SMS-created AMIs to retain. The oldest is deleted after
	// the maximum number is reached and a new AMI is created.
	NumberOfRecentAmisToKeep *int64 `locationName:"numberOfRecentAmisToKeep" type:"integer"`

	// The ID of the replication job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`

	// The name of the IAM role to be used by AWS SMS.
	RoleName *string `locationName:"roleName" type:"string"`
}

// String returns the string representation
func (s UpdateReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReplicationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationJobInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateReplicationJobInput) SetDescription(v string) *UpdateReplicationJobInput {
	s.Description = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *UpdateReplicationJobInput) SetEncrypted(v bool) *UpdateReplicationJobInput {
	s.Encrypted = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *UpdateReplicationJobInput) SetFrequency(v int64) *UpdateReplicationJobInput {
	s.Frequency = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateReplicationJobInput) SetKmsKeyId(v string) *UpdateReplicationJobInput {
	s.KmsKeyId = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *UpdateReplicationJobInput) SetLicenseType(v string) *UpdateReplicationJobInput {
	s.LicenseType = &v
	return s
}

// SetNextReplicationRunStartTime sets the NextReplicationRunStartTime field's value.
func (s *UpdateReplicationJobInput) SetNextReplicationRunStartTime(v time.Time) *UpdateReplicationJobInput {
	s.NextReplicationRunStartTime = &v
	return s
}

// SetNumberOfRecentAmisToKeep sets the NumberOfRecentAmisToKeep field's value.
func (s *UpdateReplicationJobInput) SetNumberOfRecentAmisToKeep(v int64) *UpdateReplicationJobInput {
	s.NumberOfRecentAmisToKeep = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *UpdateReplicationJobInput) SetReplicationJobId(v string) *UpdateReplicationJobInput {
	s.ReplicationJobId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *UpdateReplicationJobInput) SetRoleName(v string) *UpdateReplicationJobInput {
	s.RoleName = &v
	return s
}

type UpdateReplicationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReplicationJobOutput) GoString() string {
	return s.String()
}

// A script that runs on first launch of an Amazon EC2 instance. Used for configuring
// the server during launch.
type UserData struct {
	_ struct{} `type:"structure"`

	// Amazon S3 location of the user-data script.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s UserData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserData"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *UserData) SetS3Location(v *S3Location) *UserData {
	s.S3Location = v
	return s
}

// Contains validation parameters.
type UserDataValidationParameters struct {
	_ struct{} `type:"structure"`

	// The type of validation script.
	ScriptType *string `locationName:"scriptType" type:"string" enum:"ScriptType"`

	// The location of the validation script.
	Source *Source `locationName:"source" type:"structure"`
}

// String returns the string representation
func (s UserDataValidationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserDataValidationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserDataValidationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserDataValidationParameters"}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScriptType sets the ScriptType field's value.
func (s *UserDataValidationParameters) SetScriptType(v string) *UserDataValidationParameters {
	s.ScriptType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UserDataValidationParameters) SetSource(v *Source) *UserDataValidationParameters {
	s.Source = v
	return s
}

// Contains validation output.
type ValidationOutput struct {
	_ struct{} `type:"structure"`

	// The output from validating an application.
	AppValidationOutput *AppValidationOutput `locationName:"appValidationOutput" type:"structure"`

	// The latest time that the validation was performed.
	LatestValidationTime *time.Time `locationName:"latestValidationTime" type:"timestamp"`

	// The name of the validation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The output from validation an instance.
	ServerValidationOutput *ServerValidationOutput `locationName:"serverValidationOutput" type:"structure"`

	// The status of the validation.
	Status *string `locationName:"status" type:"string" enum:"ValidationStatus"`

	// The status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The ID of the validation.
	ValidationId *string `locationName:"validationId" type:"string"`
}

// String returns the string representation
func (s ValidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationOutput) GoString() string {
	return s.String()
}

// SetAppValidationOutput sets the AppValidationOutput field's value.
func (s *ValidationOutput) SetAppValidationOutput(v *AppValidationOutput) *ValidationOutput {
	s.AppValidationOutput = v
	return s
}

// SetLatestValidationTime sets the LatestValidationTime field's value.
func (s *ValidationOutput) SetLatestValidationTime(v time.Time) *ValidationOutput {
	s.LatestValidationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationOutput) SetName(v string) *ValidationOutput {
	s.Name = &v
	return s
}

// SetServerValidationOutput sets the ServerValidationOutput field's value.
func (s *ValidationOutput) SetServerValidationOutput(v *ServerValidationOutput) *ValidationOutput {
	s.ServerValidationOutput = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ValidationOutput) SetStatus(v string) *ValidationOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ValidationOutput) SetStatusMessage(v string) *ValidationOutput {
	s.StatusMessage = &v
	return s
}

// SetValidationId sets the ValidationId field's value.
func (s *ValidationOutput) SetValidationId(v string) *ValidationOutput {
	s.ValidationId = &v
	return s
}

// Represents a VM server.
type VmServer struct {
	_ struct{} `type:"structure"`

	// The name of the VM manager.
	VmManagerName *string `locationName:"vmManagerName" type:"string"`

	// The type of VM management product.
	VmManagerType *string `locationName:"vmManagerType" type:"string" enum:"VmManagerType"`

	// The name of the VM.
	VmName *string `locationName:"vmName" type:"string"`

	// The VM folder path in the vCenter Server virtual machine inventory tree.
	VmPath *string `locationName:"vmPath" type:"string"`

	// The VM server location.
	VmServerAddress *VmServerAddress `locationName:"vmServerAddress" type:"structure"`
}

// String returns the string representation
func (s VmServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VmServer) GoString() string {
	return s.String()
}

// SetVmManagerName sets the VmManagerName field's value.
func (s *VmServer) SetVmManagerName(v string) *VmServer {
	s.VmManagerName = &v
	return s
}

// SetVmManagerType sets the VmManagerType field's value.
func (s *VmServer) SetVmManagerType(v string) *VmServer {
	s.VmManagerType = &v
	return s
}

// SetVmName sets the VmName field's value.
func (s *VmServer) SetVmName(v string) *VmServer {
	s.VmName = &v
	return s
}

// SetVmPath sets the VmPath field's value.
func (s *VmServer) SetVmPath(v string) *VmServer {
	s.VmPath = &v
	return s
}

// SetVmServerAddress sets the VmServerAddress field's value.
func (s *VmServer) SetVmServerAddress(v *VmServerAddress) *VmServer {
	s.VmServerAddress = v
	return s
}

// Represents a VM server location.
type VmServerAddress struct {
	_ struct{} `type:"structure"`

	// The ID of the VM.
	VmId *string `locationName:"vmId" type:"string"`

	// The ID of the VM manager.
	VmManagerId *string `locationName:"vmManagerId" type:"string"`
}

// String returns the string representation
func (s VmServerAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VmServerAddress) GoString() string {
	return s.String()
}

// SetVmId sets the VmId field's value.
func (s *VmServerAddress) SetVmId(v string) *VmServerAddress {
	s.VmId = &v
	return s
}

// SetVmManagerId sets the VmManagerId field's value.
func (s *VmServerAddress) SetVmManagerId(v string) *VmServerAddress {
	s.VmManagerId = &v
	return s
}

const (
	// AppLaunchConfigurationStatusNotConfigured is a AppLaunchConfigurationStatus enum value
	AppLaunchConfigurationStatusNotConfigured = "NOT_CONFIGURED"

	// AppLaunchConfigurationStatusConfigured is a AppLaunchConfigurationStatus enum value
	AppLaunchConfigurationStatusConfigured = "CONFIGURED"
)

const (
	// AppLaunchStatusReadyForConfiguration is a AppLaunchStatus enum value
	AppLaunchStatusReadyForConfiguration = "READY_FOR_CONFIGURATION"

	// AppLaunchStatusConfigurationInProgress is a AppLaunchStatus enum value
	AppLaunchStatusConfigurationInProgress = "CONFIGURATION_IN_PROGRESS"

	// AppLaunchStatusConfigurationInvalid is a AppLaunchStatus enum value
	AppLaunchStatusConfigurationInvalid = "CONFIGURATION_INVALID"

	// AppLaunchStatusReadyForLaunch is a AppLaunchStatus enum value
	AppLaunchStatusReadyForLaunch = "READY_FOR_LAUNCH"

	// AppLaunchStatusValidationInProgress is a AppLaunchStatus enum value
	AppLaunchStatusValidationInProgress = "VALIDATION_IN_PROGRESS"

	// AppLaunchStatusLaunchPending is a AppLaunchStatus enum value
	AppLaunchStatusLaunchPending = "LAUNCH_PENDING"

	// AppLaunchStatusLaunchInProgress is a AppLaunchStatus enum value
	AppLaunchStatusLaunchInProgress = "LAUNCH_IN_PROGRESS"

	// AppLaunchStatusLaunched is a AppLaunchStatus enum value
	AppLaunchStatusLaunched = "LAUNCHED"

	// AppLaunchStatusPartiallyLaunched is a AppLaunchStatus enum value
	AppLaunchStatusPartiallyLaunched = "PARTIALLY_LAUNCHED"

	// AppLaunchStatusDeltaLaunchInProgress is a AppLaunchStatus enum value
	AppLaunchStatusDeltaLaunchInProgress = "DELTA_LAUNCH_IN_PROGRESS"

	// AppLaunchStatusDeltaLaunchFailed is a AppLaunchStatus enum value
	AppLaunchStatusDeltaLaunchFailed = "DELTA_LAUNCH_FAILED"

	// AppLaunchStatusLaunchFailed is a AppLaunchStatus enum value
	AppLaunchStatusLaunchFailed = "LAUNCH_FAILED"

	// AppLaunchStatusTerminateInProgress is a AppLaunchStatus enum value
	AppLaunchStatusTerminateInProgress = "TERMINATE_IN_PROGRESS"

	// AppLaunchStatusTerminateFailed is a AppLaunchStatus enum value
	AppLaunchStatusTerminateFailed = "TERMINATE_FAILED"

	// AppLaunchStatusTerminated is a AppLaunchStatus enum value
	AppLaunchStatusTerminated = "TERMINATED"
)

const (
	// AppReplicationConfigurationStatusNotConfigured is a AppReplicationConfigurationStatus enum value
	AppReplicationConfigurationStatusNotConfigured = "NOT_CONFIGURED"

	// AppReplicationConfigurationStatusConfigured is a AppReplicationConfigurationStatus enum value
	AppReplicationConfigurationStatusConfigured = "CONFIGURED"
)

const (
	// AppReplicationStatusReadyForConfiguration is a AppReplicationStatus enum value
	AppReplicationStatusReadyForConfiguration = "READY_FOR_CONFIGURATION"

	// AppReplicationStatusConfigurationInProgress is a AppReplicationStatus enum value
	AppReplicationStatusConfigurationInProgress = "CONFIGURATION_IN_PROGRESS"

	// AppReplicationStatusConfigurationInvalid is a AppReplicationStatus enum value
	AppReplicationStatusConfigurationInvalid = "CONFIGURATION_INVALID"

	// AppReplicationStatusReadyForReplication is a AppReplicationStatus enum value
	AppReplicationStatusReadyForReplication = "READY_FOR_REPLICATION"

	// AppReplicationStatusValidationInProgress is a AppReplicationStatus enum value
	AppReplicationStatusValidationInProgress = "VALIDATION_IN_PROGRESS"

	// AppReplicationStatusReplicationPending is a AppReplicationStatus enum value
	AppReplicationStatusReplicationPending = "REPLICATION_PENDING"

	// AppReplicationStatusReplicationInProgress is a AppReplicationStatus enum value
	AppReplicationStatusReplicationInProgress = "REPLICATION_IN_PROGRESS"

	// AppReplicationStatusReplicated is a AppReplicationStatus enum value
	AppReplicationStatusReplicated = "REPLICATED"

	// AppReplicationStatusPartiallyReplicated is a AppReplicationStatus enum value
	AppReplicationStatusPartiallyReplicated = "PARTIALLY_REPLICATED"

	// AppReplicationStatusDeltaReplicationInProgress is a AppReplicationStatus enum value
	AppReplicationStatusDeltaReplicationInProgress = "DELTA_REPLICATION_IN_PROGRESS"

	// AppReplicationStatusDeltaReplicated is a AppReplicationStatus enum value
	AppReplicationStatusDeltaReplicated = "DELTA_REPLICATED"

	// AppReplicationStatusDeltaReplicationFailed is a AppReplicationStatus enum value
	AppReplicationStatusDeltaReplicationFailed = "DELTA_REPLICATION_FAILED"

	// AppReplicationStatusReplicationFailed is a AppReplicationStatus enum value
	AppReplicationStatusReplicationFailed = "REPLICATION_FAILED"

	// AppReplicationStatusReplicationStopping is a AppReplicationStatus enum value
	AppReplicationStatusReplicationStopping = "REPLICATION_STOPPING"

	// AppReplicationStatusReplicationStopFailed is a AppReplicationStatus enum value
	AppReplicationStatusReplicationStopFailed = "REPLICATION_STOP_FAILED"

	// AppReplicationStatusReplicationStopped is a AppReplicationStatus enum value
	AppReplicationStatusReplicationStopped = "REPLICATION_STOPPED"
)

const (
	// AppStatusCreating is a AppStatus enum value
	AppStatusCreating = "CREATING"

	// AppStatusActive is a AppStatus enum value
	AppStatusActive = "ACTIVE"

	// AppStatusUpdating is a AppStatus enum value
	AppStatusUpdating = "UPDATING"

	// AppStatusDeleting is a AppStatus enum value
	AppStatusDeleting = "DELETING"

	// AppStatusDeleted is a AppStatus enum value
	AppStatusDeleted = "DELETED"

	// AppStatusDeleteFailed is a AppStatus enum value
	AppStatusDeleteFailed = "DELETE_FAILED"
)

const (
	// AppValidationStrategySsm is a AppValidationStrategy enum value
	AppValidationStrategySsm = "SSM"
)

const (
	// ConnectorCapabilityVsphere is a ConnectorCapability enum value
	ConnectorCapabilityVsphere = "VSPHERE"

	// ConnectorCapabilityScvmm is a ConnectorCapability enum value
	ConnectorCapabilityScvmm = "SCVMM"

	// ConnectorCapabilityHypervManager is a ConnectorCapability enum value
	ConnectorCapabilityHypervManager = "HYPERV-MANAGER"

	// ConnectorCapabilitySnapshotBatching is a ConnectorCapability enum value
	ConnectorCapabilitySnapshotBatching = "SNAPSHOT_BATCHING"

	// ConnectorCapabilitySmsOptimized is a ConnectorCapability enum value
	ConnectorCapabilitySmsOptimized = "SMS_OPTIMIZED"
)

const (
	// ConnectorStatusHealthy is a ConnectorStatus enum value
	ConnectorStatusHealthy = "HEALTHY"

	// ConnectorStatusUnhealthy is a ConnectorStatus enum value
	ConnectorStatusUnhealthy = "UNHEALTHY"
)

const (
	// LicenseTypeAws is a LicenseType enum value
	LicenseTypeAws = "AWS"

	// LicenseTypeByol is a LicenseType enum value
	LicenseTypeByol = "BYOL"
)

const (
	// OutputFormatJson is a OutputFormat enum value
	OutputFormatJson = "JSON"

	// OutputFormatYaml is a OutputFormat enum value
	OutputFormatYaml = "YAML"
)

const (
	// ReplicationJobStatePending is a ReplicationJobState enum value
	ReplicationJobStatePending = "PENDING"

	// ReplicationJobStateActive is a ReplicationJobState enum value
	ReplicationJobStateActive = "ACTIVE"

	// ReplicationJobStateFailed is a ReplicationJobState enum value
	ReplicationJobStateFailed = "FAILED"

	// ReplicationJobStateDeleting is a ReplicationJobState enum value
	ReplicationJobStateDeleting = "DELETING"

	// ReplicationJobStateDeleted is a ReplicationJobState enum value
	ReplicationJobStateDeleted = "DELETED"

	// ReplicationJobStateCompleted is a ReplicationJobState enum value
	ReplicationJobStateCompleted = "COMPLETED"

	// ReplicationJobStatePausedOnFailure is a ReplicationJobState enum value
	ReplicationJobStatePausedOnFailure = "PAUSED_ON_FAILURE"

	// ReplicationJobStateFailing is a ReplicationJobState enum value
	ReplicationJobStateFailing = "FAILING"
)

const (
	// ReplicationRunStatePending is a ReplicationRunState enum value
	ReplicationRunStatePending = "PENDING"

	// ReplicationRunStateMissed is a ReplicationRunState enum value
	ReplicationRunStateMissed = "MISSED"

	// ReplicationRunStateActive is a ReplicationRunState enum value
	ReplicationRunStateActive = "ACTIVE"

	// ReplicationRunStateFailed is a ReplicationRunState enum value
	ReplicationRunStateFailed = "FAILED"

	// ReplicationRunStateCompleted is a ReplicationRunState enum value
	ReplicationRunStateCompleted = "COMPLETED"

	// ReplicationRunStateDeleting is a ReplicationRunState enum value
	ReplicationRunStateDeleting = "DELETING"

	// ReplicationRunStateDeleted is a ReplicationRunState enum value
	ReplicationRunStateDeleted = "DELETED"
)

const (
	// ReplicationRunTypeOnDemand is a ReplicationRunType enum value
	ReplicationRunTypeOnDemand = "ON_DEMAND"

	// ReplicationRunTypeAutomatic is a ReplicationRunType enum value
	ReplicationRunTypeAutomatic = "AUTOMATIC"
)

const (
	// ScriptTypeShellScript is a ScriptType enum value
	ScriptTypeShellScript = "SHELL_SCRIPT"

	// ScriptTypePowershellScript is a ScriptType enum value
	ScriptTypePowershellScript = "POWERSHELL_SCRIPT"
)

const (
	// ServerCatalogStatusNotImported is a ServerCatalogStatus enum value
	ServerCatalogStatusNotImported = "NOT_IMPORTED"

	// ServerCatalogStatusImporting is a ServerCatalogStatus enum value
	ServerCatalogStatusImporting = "IMPORTING"

	// ServerCatalogStatusAvailable is a ServerCatalogStatus enum value
	ServerCatalogStatusAvailable = "AVAILABLE"

	// ServerCatalogStatusDeleted is a ServerCatalogStatus enum value
	ServerCatalogStatusDeleted = "DELETED"

	// ServerCatalogStatusExpired is a ServerCatalogStatus enum value
	ServerCatalogStatusExpired = "EXPIRED"
)

const (
	// ServerTypeVirtualMachine is a ServerType enum value
	ServerTypeVirtualMachine = "VIRTUAL_MACHINE"
)

const (
	// ServerValidationStrategyUserdata is a ServerValidationStrategy enum value
	ServerValidationStrategyUserdata = "USERDATA"
)

const (
	// ValidationStatusReadyForValidation is a ValidationStatus enum value
	ValidationStatusReadyForValidation = "READY_FOR_VALIDATION"

	// ValidationStatusPending is a ValidationStatus enum value
	ValidationStatusPending = "PENDING"

	// ValidationStatusInProgress is a ValidationStatus enum value
	ValidationStatusInProgress = "IN_PROGRESS"

	// ValidationStatusSucceeded is a ValidationStatus enum value
	ValidationStatusSucceeded = "SUCCEEDED"

	// ValidationStatusFailed is a ValidationStatus enum value
	ValidationStatusFailed = "FAILED"
)

const (
	// VmManagerTypeVsphere is a VmManagerType enum value
	VmManagerTypeVsphere = "VSPHERE"

	// VmManagerTypeScvmm is a VmManagerType enum value
	VmManagerTypeScvmm = "SCVMM"

	// VmManagerTypeHypervManager is a VmManagerType enum value
	VmManagerTypeHypervManager = "HYPERV-MANAGER"
)
