package apicurioregistry

import (
	monitoring "github.com/coreos/prometheus-operator/pkg/apis/monitoring/v1"
	core "k8s.io/api/core/v1"
	meta "k8s.io/apimachinery/pkg/apis/meta/v1"
)

type MonitoringFactory struct {
	ctx *Context
}

func NewMonitoringFactory(ctx *Context) *MonitoringFactory {
	return &MonitoringFactory{
		ctx: ctx,
	}
}

func (this *MonitoringFactory) GetLabels() map[string]string {
	return this.ctx.GetKubeFactory().GetLabels()
}

func (this *MonitoringFactory) GetSelectorLabels() map[string]string {
	return this.ctx.GetKubeFactory().GetSelectorLabels()
}

func (this *MonitoringFactory) NewServiceMonitor(service *core.Service) *monitoring.ServiceMonitor {
	name := this.ctx.configuration.GetAppName()
	namespace := this.ctx.configuration.GetAppNamespace()

	return &monitoring.ServiceMonitor{
		ObjectMeta: meta.ObjectMeta{
			Name:      name,
			Namespace: namespace,
			Labels:    this.GetLabels(),
		},
		Spec: monitoring.ServiceMonitorSpec{
			Endpoints: []monitoring.Endpoint{
				{
					Path:       "/metrics",
					TargetPort: &service.Spec.Ports[0].TargetPort,
				},
			},
			NamespaceSelector: monitoring.NamespaceSelector{
				MatchNames: []string{namespace},
			},
			Selector: meta.LabelSelector{
				MatchLabels: this.GetSelectorLabels(),
			},
		},
	}
}
