// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeregisterFromWorkMailInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the member (user or group) to be updated.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the Amazon WorkMail entity
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterFromWorkMailInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterFromWorkMailInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterFromWorkMailInput"}

	if s.EntityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("EntityId", 12))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterFromWorkMailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterFromWorkMailOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterFromWorkMail = "DeregisterFromWorkMail"

// DeregisterFromWorkMailRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Mark a user, group, or resource as no longer used in Amazon WorkMail. This
// action disassociates the mailbox and schedules it for clean-up. WorkMail
// keeps mailboxes for 30 days before they are permanently removed. The functionality
// in the console is Disable.
//
//    // Example sending a request using DeregisterFromWorkMailRequest.
//    req := client.DeregisterFromWorkMailRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail
func (c *Client) DeregisterFromWorkMailRequest(input *DeregisterFromWorkMailInput) DeregisterFromWorkMailRequest {
	op := &aws.Operation{
		Name:       opDeregisterFromWorkMail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterFromWorkMailInput{}
	}

	req := c.newRequest(op, input, &DeregisterFromWorkMailOutput{})
	return DeregisterFromWorkMailRequest{Request: req, Input: input, Copy: c.DeregisterFromWorkMailRequest}
}

// DeregisterFromWorkMailRequest is the request type for the
// DeregisterFromWorkMail API operation.
type DeregisterFromWorkMailRequest struct {
	*aws.Request
	Input *DeregisterFromWorkMailInput
	Copy  func(*DeregisterFromWorkMailInput) DeregisterFromWorkMailRequest
}

// Send marshals and sends the DeregisterFromWorkMail API request.
func (r DeregisterFromWorkMailRequest) Send(ctx context.Context) (*DeregisterFromWorkMailResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterFromWorkMailResponse{
		DeregisterFromWorkMailOutput: r.Request.Data.(*DeregisterFromWorkMailOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterFromWorkMailResponse is the response type for the
// DeregisterFromWorkMail API operation.
type DeregisterFromWorkMailResponse struct {
	*DeregisterFromWorkMailOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterFromWorkMail request.
func (r *DeregisterFromWorkMailResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
