// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateAccountInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAccountInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s CreateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Account != nil {
		v := s.Account

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Account", v, metadata)
	}
	return nil
}

const opCreateAccount = "CreateAccount"

// CreateAccountRequest returns a request value for making API operation for
// Amazon Chime.
//
// Creates an Amazon Chime account under the administrator's AWS account. Only
// Team account types are currently supported for this action. For more information
// about different account types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
//    // Example sending a request using CreateAccountRequest.
//    req := client.CreateAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Client) CreateAccountRequest(input *CreateAccountInput) CreateAccountRequest {
	op := &aws.Operation{
		Name:       opCreateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &CreateAccountInput{}
	}

	req := c.newRequest(op, input, &CreateAccountOutput{})
	return CreateAccountRequest{Request: req, Input: input, Copy: c.CreateAccountRequest}
}

// CreateAccountRequest is the request type for the
// CreateAccount API operation.
type CreateAccountRequest struct {
	*aws.Request
	Input *CreateAccountInput
	Copy  func(*CreateAccountInput) CreateAccountRequest
}

// Send marshals and sends the CreateAccount API request.
func (r CreateAccountRequest) Send(ctx context.Context) (*CreateAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAccountResponse{
		CreateAccountOutput: r.Request.Data.(*CreateAccountOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAccountResponse is the response type for the
// CreateAccount API operation.
type CreateAccountResponse struct {
	*CreateAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAccount request.
func (r *CreateAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
