// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetEventSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSelectorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEventSelectorsInput"}

	if s.TrailName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetEventSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// The event selectors that are configured for the trail.
	EventSelectors []EventSelector `type:"list"`

	// The specified trail ARN that has the event selectors.
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s GetEventSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEventSelectors = "GetEventSelectors"

// GetEventSelectorsRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Describes the settings for the event selectors that you configured for your
// trail. The information returned for your event selectors includes the following:
//
//    * If your event selector includes read-only events, write-only events,
//    or all events. This applies to both management events and data events.
//
//    * If your event selector includes management events.
//
//    * If your event selector includes data events, the Amazon S3 objects or
//    AWS Lambda functions that you are logging for data events.
//
// For more information, see Logging Data and Management Events for Trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html)
// in the AWS CloudTrail User Guide.
//
//    // Example sending a request using GetEventSelectorsRequest.
//    req := client.GetEventSelectorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors
func (c *Client) GetEventSelectorsRequest(input *GetEventSelectorsInput) GetEventSelectorsRequest {
	op := &aws.Operation{
		Name:       opGetEventSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventSelectorsInput{}
	}

	req := c.newRequest(op, input, &GetEventSelectorsOutput{})
	return GetEventSelectorsRequest{Request: req, Input: input, Copy: c.GetEventSelectorsRequest}
}

// GetEventSelectorsRequest is the request type for the
// GetEventSelectors API operation.
type GetEventSelectorsRequest struct {
	*aws.Request
	Input *GetEventSelectorsInput
	Copy  func(*GetEventSelectorsInput) GetEventSelectorsRequest
}

// Send marshals and sends the GetEventSelectors API request.
func (r GetEventSelectorsRequest) Send(ctx context.Context) (*GetEventSelectorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEventSelectorsResponse{
		GetEventSelectorsOutput: r.Request.Data.(*GetEventSelectorsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEventSelectorsResponse is the response type for the
// GetEventSelectors API operation.
type GetEventSelectorsResponse struct {
	*GetEventSelectorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEventSelectors request.
func (r *GetEventSelectorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
