// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`

	// A list of project descriptions. The list is sorted by the date and time the
	// projects are created.
	ProjectDescriptions []ProjectDescription `type:"list"`
}

// String returns the string representation
func (s DescribeProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProjects = "DescribeProjects"

// DescribeProjectsRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Lists and gets information about your Amazon Rekognition Custom Labels projects.
//
// This operation requires permissions to perform the rekognition:DescribeProjects
// action.
//
//    // Example sending a request using DescribeProjectsRequest.
//    req := client.DescribeProjectsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeProjectsRequest(input *DescribeProjectsInput) DescribeProjectsRequest {
	op := &aws.Operation{
		Name:       opDescribeProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProjectsInput{}
	}

	req := c.newRequest(op, input, &DescribeProjectsOutput{})
	return DescribeProjectsRequest{Request: req, Input: input, Copy: c.DescribeProjectsRequest}
}

// DescribeProjectsRequest is the request type for the
// DescribeProjects API operation.
type DescribeProjectsRequest struct {
	*aws.Request
	Input *DescribeProjectsInput
	Copy  func(*DescribeProjectsInput) DescribeProjectsRequest
}

// Send marshals and sends the DescribeProjects API request.
func (r DescribeProjectsRequest) Send(ctx context.Context) (*DescribeProjectsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProjectsResponse{
		DescribeProjectsOutput: r.Request.Data.(*DescribeProjectsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeProjectsRequestPaginator returns a paginator for DescribeProjects.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeProjectsRequest(input)
//   p := rekognition.NewDescribeProjectsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeProjectsPaginator(req DescribeProjectsRequest) DescribeProjectsPaginator {
	return DescribeProjectsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeProjectsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeProjectsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeProjectsPaginator struct {
	aws.Pager
}

func (p *DescribeProjectsPaginator) CurrentPage() *DescribeProjectsOutput {
	return p.Pager.CurrentPage().(*DescribeProjectsOutput)
}

// DescribeProjectsResponse is the response type for the
// DescribeProjects API operation.
type DescribeProjectsResponse struct {
	*DescribeProjectsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProjects request.
func (r *DescribeProjectsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
