// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateEventConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The new event configuration values.
	EventConfigurations map[string]Configuration `locationName:"eventConfigurations" type:"map"`
}

// String returns the string representation
func (s UpdateEventConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEventConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EventConfigurations != nil {
		v := s.EventConfigurations

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "eventConfigurations", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

type UpdateEventConfigurationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateEventConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEventConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateEventConfigurations = "UpdateEventConfigurations"

// UpdateEventConfigurationsRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates the event configurations.
//
//    // Example sending a request using UpdateEventConfigurationsRequest.
//    req := client.UpdateEventConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateEventConfigurationsRequest(input *UpdateEventConfigurationsInput) UpdateEventConfigurationsRequest {
	op := &aws.Operation{
		Name:       opUpdateEventConfigurations,
		HTTPMethod: "PATCH",
		HTTPPath:   "/event-configurations",
	}

	if input == nil {
		input = &UpdateEventConfigurationsInput{}
	}

	req := c.newRequest(op, input, &UpdateEventConfigurationsOutput{})
	return UpdateEventConfigurationsRequest{Request: req, Input: input, Copy: c.UpdateEventConfigurationsRequest}
}

// UpdateEventConfigurationsRequest is the request type for the
// UpdateEventConfigurations API operation.
type UpdateEventConfigurationsRequest struct {
	*aws.Request
	Input *UpdateEventConfigurationsInput
	Copy  func(*UpdateEventConfigurationsInput) UpdateEventConfigurationsRequest
}

// Send marshals and sends the UpdateEventConfigurations API request.
func (r UpdateEventConfigurationsRequest) Send(ctx context.Context) (*UpdateEventConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEventConfigurationsResponse{
		UpdateEventConfigurationsOutput: r.Request.Data.(*UpdateEventConfigurationsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEventConfigurationsResponse is the response type for the
// UpdateEventConfigurations API operation.
type UpdateEventConfigurationsResponse struct {
	*UpdateEventConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEventConfigurations request.
func (r *UpdateEventConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
