// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/profile_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// List profiles request.
type ListProfilesRequest struct {
	// Required.
	//
	// The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenants/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional.
	//
	// The token that specifies the current offset (that is, starting result).
	//
	// Please set the value to [ListProfilesResponse.next_page_token][google.cloud.talent.v4beta1.ListProfilesResponse.next_page_token] to
	// continue the list.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional.
	//
	// The maximum number of profiles to be returned, at most 100.
	//
	// Default is 100 unless a positive number smaller than 100 is specified.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional.
	//
	// A field mask to specify the profile fields to be listed in response.
	// All fields are listed if it is unset.
	//
	// Valid values are:
	//
	// * name
	ReadMask             *field_mask.FieldMask `protobuf:"bytes,4,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListProfilesRequest) Reset()         { *m = ListProfilesRequest{} }
func (m *ListProfilesRequest) String() string { return proto.CompactTextString(m) }
func (*ListProfilesRequest) ProtoMessage()    {}
func (*ListProfilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{0}
}

func (m *ListProfilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProfilesRequest.Unmarshal(m, b)
}
func (m *ListProfilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProfilesRequest.Marshal(b, m, deterministic)
}
func (m *ListProfilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProfilesRequest.Merge(m, src)
}
func (m *ListProfilesRequest) XXX_Size() int {
	return xxx_messageInfo_ListProfilesRequest.Size(m)
}
func (m *ListProfilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProfilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProfilesRequest proto.InternalMessageInfo

func (m *ListProfilesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListProfilesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListProfilesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProfilesRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

// The List profiles response object.
type ListProfilesResponse struct {
	// Profiles for the specific tenant.
	Profiles []*Profile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// A token to retrieve the next page of results. This is empty if there are no
	// more results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProfilesResponse) Reset()         { *m = ListProfilesResponse{} }
func (m *ListProfilesResponse) String() string { return proto.CompactTextString(m) }
func (*ListProfilesResponse) ProtoMessage()    {}
func (*ListProfilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{1}
}

func (m *ListProfilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProfilesResponse.Unmarshal(m, b)
}
func (m *ListProfilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProfilesResponse.Marshal(b, m, deterministic)
}
func (m *ListProfilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProfilesResponse.Merge(m, src)
}
func (m *ListProfilesResponse) XXX_Size() int {
	return xxx_messageInfo_ListProfilesResponse.Size(m)
}
func (m *ListProfilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProfilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProfilesResponse proto.InternalMessageInfo

func (m *ListProfilesResponse) GetProfiles() []*Profile {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *ListProfilesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Create profile request.
type CreateProfileRequest struct {
	// Required.
	//
	// The name of the tenant this profile belongs to.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenants/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The profile to be created.
	Profile              *Profile `protobuf:"bytes,2,opt,name=profile,proto3" json:"profile,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateProfileRequest) Reset()         { *m = CreateProfileRequest{} }
func (m *CreateProfileRequest) String() string { return proto.CompactTextString(m) }
func (*CreateProfileRequest) ProtoMessage()    {}
func (*CreateProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{2}
}

func (m *CreateProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateProfileRequest.Unmarshal(m, b)
}
func (m *CreateProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateProfileRequest.Marshal(b, m, deterministic)
}
func (m *CreateProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateProfileRequest.Merge(m, src)
}
func (m *CreateProfileRequest) XXX_Size() int {
	return xxx_messageInfo_CreateProfileRequest.Size(m)
}
func (m *CreateProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateProfileRequest proto.InternalMessageInfo

func (m *CreateProfileRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateProfileRequest) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

// Get profile request.
type GetProfileRequest struct {
	// Required.
	//
	// Resource name of the profile to get.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProfileRequest) Reset()         { *m = GetProfileRequest{} }
func (m *GetProfileRequest) String() string { return proto.CompactTextString(m) }
func (*GetProfileRequest) ProtoMessage()    {}
func (*GetProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{3}
}

func (m *GetProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProfileRequest.Unmarshal(m, b)
}
func (m *GetProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProfileRequest.Marshal(b, m, deterministic)
}
func (m *GetProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProfileRequest.Merge(m, src)
}
func (m *GetProfileRequest) XXX_Size() int {
	return xxx_messageInfo_GetProfileRequest.Size(m)
}
func (m *GetProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProfileRequest proto.InternalMessageInfo

func (m *GetProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Update profile request
type UpdateProfileRequest struct {
	// Required.
	//
	// Profile to be updated.
	Profile *Profile `protobuf:"bytes,1,opt,name=profile,proto3" json:"profile,omitempty"`
	// Optional.
	//
	// A field mask to specify the profile fields to update.
	//
	// A full update is performed if it is unset.
	//
	// Valid values are:
	//
	// * externalId
	// * source
	// * uri
	// * isHirable
	// * createTime
	// * updateTime
	// * resumeHrxml
	// * personNames
	// * addresses
	// * emailAddresses
	// * phoneNumbers
	// * personalUris
	// * additionalContactInfo
	// * employmentRecords
	// * educationRecords
	// * skills
	// * projects
	// * publications
	// * patents
	// * certifications
	// * recruitingNotes
	// * customAttributes
	// * groupId
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateProfileRequest) Reset()         { *m = UpdateProfileRequest{} }
func (m *UpdateProfileRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProfileRequest) ProtoMessage()    {}
func (*UpdateProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{4}
}

func (m *UpdateProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateProfileRequest.Unmarshal(m, b)
}
func (m *UpdateProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateProfileRequest.Marshal(b, m, deterministic)
}
func (m *UpdateProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProfileRequest.Merge(m, src)
}
func (m *UpdateProfileRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateProfileRequest.Size(m)
}
func (m *UpdateProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProfileRequest proto.InternalMessageInfo

func (m *UpdateProfileRequest) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

func (m *UpdateProfileRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Delete profile request.
type DeleteProfileRequest struct {
	// Required.
	//
	// Resource name of the profile to be deleted.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProfileRequest) Reset()         { *m = DeleteProfileRequest{} }
func (m *DeleteProfileRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProfileRequest) ProtoMessage()    {}
func (*DeleteProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{5}
}

func (m *DeleteProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteProfileRequest.Unmarshal(m, b)
}
func (m *DeleteProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteProfileRequest.Marshal(b, m, deterministic)
}
func (m *DeleteProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProfileRequest.Merge(m, src)
}
func (m *DeleteProfileRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteProfileRequest.Size(m)
}
func (m *DeleteProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProfileRequest proto.InternalMessageInfo

func (m *DeleteProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request body of the `SearchProfiles` call.
type SearchProfilesRequest struct {
	// Required.
	//
	// The resource name of the tenant to search within.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenants/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The meta information collected about the profile search user. This is used
	// to improve the search quality of the service. These values are provided by
	// users, and must be precise and consistent.
	RequestMetadata *RequestMetadata `protobuf:"bytes,2,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// Optional.
	//
	// Search query to execute. See [ProfileQuery][google.cloud.talent.v4beta1.ProfileQuery] for more details.
	ProfileQuery *ProfileQuery `protobuf:"bytes,3,opt,name=profile_query,json=profileQuery,proto3" json:"profile_query,omitempty"`
	// Optional.
	//
	// A limit on the number of profiles returned in the search results.
	// A value above the default value 10 can increase search response time.
	//
	// The maximum value allowed is 100. Otherwise an error is thrown.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional.
	//
	// The pageToken, similar to offset enables users of the API to paginate
	// through the search results. To retrieve the first page of results, set the
	// pageToken to empty. The search response includes a
	// [nextPageToken][google.cloud.talent.v4beta1.SearchProfilesResponse.next_page_token] field that can be
	// used to populate the pageToken field for the next page of results. Using
	// pageToken instead of offset increases the performance of the API,
	// especially compared to larger offset values.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional.
	//
	// An integer that specifies the current offset (that is, starting result) in
	// search results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token] is unset.
	//
	// The maximum allowed value is 5000. Otherwise an error is thrown.
	//
	// For example, 0 means to search from the first profile, and 10 means to
	// search from the 11th profile. This can be used for pagination, for example
	// pageSize = 10 and offset = 10 means to search from the second page.
	Offset int32 `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
	// Optional.
	//
	// This flag controls the spell-check feature. If `false`, the
	// service attempts to correct a misspelled query.
	//
	// For example, "enginee" is corrected to "engineer".
	DisableSpellCheck bool `protobuf:"varint,7,opt,name=disable_spell_check,json=disableSpellCheck,proto3" json:"disable_spell_check,omitempty"`
	// Optional.
	//
	// The criteria that determines how search results are sorted.
	// Defaults is "relevance desc" if no value is specified.
	//
	// Supported options are:
	//
	// * "relevance desc": By descending relevance, as determined by the API
	//    algorithms.
	// * "update_date desc": Sort by [Profile.update_date][] in descending order
	//   (recently updated profiles first).
	// * "create_date desc": Sort by [Profile.create_date][] in descending order
	//   (recently created profiles first).
	// * "first_name": Sort by [PersonStrcuturedName.given_name][] in ascending
	//   order.
	// * "first_name desc": Sort by [PersonStrcuturedName.given_name][] in
	//   descending order.
	// * "last_name": Sort by [PersonStrcuturedName.family_name][] in ascending
	//   order.
	// * "last_name desc": Sort by [PersonStrcuturedName.family_name][] in
	//   ascending order.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional.
	//
	// When sort by field is based on alphabetical order, sort values case
	// sensitively (based on ASCII) when the value is set to true. Default value
	// is case in-sensitive sort (false).
	CaseSensitiveSort bool `protobuf:"varint,9,opt,name=case_sensitive_sort,json=caseSensitiveSort,proto3" json:"case_sensitive_sort,omitempty"`
	// Optional.
	//
	// A list of expressions specifies histogram requests against matching
	// profiles for [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
	//
	// The expression syntax looks like a function definition with optional
	// parameters.
	//
	// Function syntax: function_name(histogram_facet[, list of buckets])
	//
	// Data types:
	//
	// * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
	// * String: string like "any string with backslash escape for quote(\")."
	// * Number: whole number and floating point number like 10, -1 and -0.01.
	// * List: list of elements with comma(,) separator surrounded by square
	// brackets. For example, [1, 2, 3] and ["one", "two", "three"].
	//
	// Built-in constants:
	//
	// * MIN (minimum number similar to java Double.MIN_VALUE)
	// * MAX (maximum number similar to java Double.MAX_VALUE)
	//
	// Built-in functions:
	//
	// * bucket(start, end[, label])
	// Bucket build-in function creates a bucket with range of [start, end). Note
	// that the end is exclusive.
	// For example, bucket(1, MAX, "positive number") or bucket(1, 10).
	//
	// Histogram Facets:
	//
	// * admin1: Admin1 is a global placeholder for referring to state, province,
	// or the particular term a country uses to define the geographic structure
	// below the country level. Examples include states codes such as "CA", "IL",
	// "NY", and provinces, such as "BC".
	// * locality: Locality is a global placeholder for referring to city, town,
	// or the particular term a country uses to define the geographic structure
	// below the admin1 level. Examples include city names such as
	// "Mountain View" and "New York".
	// * extended_locality: Extended locality is concatenated version of admin1
	// and locality with comma separator. For example, "Mountain View, CA" and
	// "New York, NY".
	// * postal_code: Postal code of profile which follows locale code.
	// * country: Country code (ISO-3166-1 alpha-2 code) of profile, such as US,
	//  JP, GB.
	// * job_title: Normalized job titles specified in EmploymentHistory.
	// * company_name: Normalized company name of profiles to match on.
	// * institution: The school name. For example, "MIT",
	// "University of California, Berkeley"
	// * degree: Highest education degree in ISCED code. Each value in degree
	// covers a specific level of education, without any expansion to upper nor
	// lower levels of education degree.
	// * experience_in_months: experience in months. 0 means 0 month to 1 month
	// (exclusive).
	// * application_date: The application date specifies application start dates.
	// See [ApplicationDateFilter][google.cloud.talent.v4beta1.ApplicationDateFilter] for more details.
	// * application_outcome_notes: The application outcome reason specifies the
	// reasons behind the outcome of the job application.
	// See [ApplicationOutcomeNotesFilter][google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter] for more details.
	// * application_job_title: The application job title specifies the job
	// applied for in the application.
	// See [ApplicationJobFilter][google.cloud.talent.v4beta1.ApplicationJobFilter] for more details.
	// * hirable_status: Hirable status specifies the profile's hirable status.
	// * string_custom_attribute: String custom attributes. Values can be accessed
	// via square bracket notation like string_custom_attribute["key1"].
	// * numeric_custom_attribute: Numeric custom attributes. Values can be
	// accessed via square bracket notation like numeric_custom_attribute["key1"].
	//
	// Example expressions:
	//
	// * count(admin1)
	// * count(experience_in_months, [bucket(0, 12, "1 year"),
	// bucket(12, 36, "1-3 years"), bucket(36, MAX, "3+ years")])
	// * count(string_custom_attribute["assigned_recruiter"])
	// * count(numeric_custom_attribute["favorite_number"],
	// [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])
	HistogramQueries     []*HistogramQuery `protobuf:"bytes,10,rep,name=histogram_queries,json=histogramQueries,proto3" json:"histogram_queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SearchProfilesRequest) Reset()         { *m = SearchProfilesRequest{} }
func (m *SearchProfilesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchProfilesRequest) ProtoMessage()    {}
func (*SearchProfilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{6}
}

func (m *SearchProfilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchProfilesRequest.Unmarshal(m, b)
}
func (m *SearchProfilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchProfilesRequest.Marshal(b, m, deterministic)
}
func (m *SearchProfilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchProfilesRequest.Merge(m, src)
}
func (m *SearchProfilesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchProfilesRequest.Size(m)
}
func (m *SearchProfilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchProfilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchProfilesRequest proto.InternalMessageInfo

func (m *SearchProfilesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchProfilesRequest) GetRequestMetadata() *RequestMetadata {
	if m != nil {
		return m.RequestMetadata
	}
	return nil
}

func (m *SearchProfilesRequest) GetProfileQuery() *ProfileQuery {
	if m != nil {
		return m.ProfileQuery
	}
	return nil
}

func (m *SearchProfilesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchProfilesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchProfilesRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SearchProfilesRequest) GetDisableSpellCheck() bool {
	if m != nil {
		return m.DisableSpellCheck
	}
	return false
}

func (m *SearchProfilesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *SearchProfilesRequest) GetCaseSensitiveSort() bool {
	if m != nil {
		return m.CaseSensitiveSort
	}
	return false
}

func (m *SearchProfilesRequest) GetHistogramQueries() []*HistogramQuery {
	if m != nil {
		return m.HistogramQueries
	}
	return nil
}

// Response of SearchProfiles method.
type SearchProfilesResponse struct {
	// An estimation of the number of profiles that match the specified query.
	//
	// This number isn't guaranteed to be accurate.
	EstimatedTotalSize int64 `protobuf:"varint,1,opt,name=estimated_total_size,json=estimatedTotalSize,proto3" json:"estimated_total_size,omitempty"`
	// The spell checking result, and correction.
	SpellCorrection *SpellingCorrection `protobuf:"bytes,2,opt,name=spell_correction,json=spellCorrection,proto3" json:"spell_correction,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A token to retrieve the next page of results. This is empty if there are no
	// more results.
	NextPageToken string `protobuf:"bytes,4,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The histogram results that match with specified
	// [SearchProfilesRequest.histogram_queries][google.cloud.talent.v4beta1.SearchProfilesRequest.histogram_queries].
	HistogramQueryResults []*HistogramQueryResult `protobuf:"bytes,5,rep,name=histogram_query_results,json=histogramQueryResults,proto3" json:"histogram_query_results,omitempty"`
	// The profile entities that match the specified [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
	SummarizedProfiles   []*SummarizedProfile `protobuf:"bytes,6,rep,name=summarized_profiles,json=summarizedProfiles,proto3" json:"summarized_profiles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchProfilesResponse) Reset()         { *m = SearchProfilesResponse{} }
func (m *SearchProfilesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchProfilesResponse) ProtoMessage()    {}
func (*SearchProfilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{7}
}

func (m *SearchProfilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchProfilesResponse.Unmarshal(m, b)
}
func (m *SearchProfilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchProfilesResponse.Marshal(b, m, deterministic)
}
func (m *SearchProfilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchProfilesResponse.Merge(m, src)
}
func (m *SearchProfilesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchProfilesResponse.Size(m)
}
func (m *SearchProfilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchProfilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchProfilesResponse proto.InternalMessageInfo

func (m *SearchProfilesResponse) GetEstimatedTotalSize() int64 {
	if m != nil {
		return m.EstimatedTotalSize
	}
	return 0
}

func (m *SearchProfilesResponse) GetSpellCorrection() *SpellingCorrection {
	if m != nil {
		return m.SpellCorrection
	}
	return nil
}

func (m *SearchProfilesResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SearchProfilesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchProfilesResponse) GetHistogramQueryResults() []*HistogramQueryResult {
	if m != nil {
		return m.HistogramQueryResults
	}
	return nil
}

func (m *SearchProfilesResponse) GetSummarizedProfiles() []*SummarizedProfile {
	if m != nil {
		return m.SummarizedProfiles
	}
	return nil
}

// Output only.
//
// Profile entry with metadata inside [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
type SummarizedProfile struct {
	// A list of profiles that are linked by [Profile.cluster_id][].
	Profiles []*Profile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// A profile summary shows the profile summary and how the profile matches the
	// search query.
	//
	// In profile summary, the profiles with the same [Profile.cluster_id][] are
	// merged together. Among profiles, same education/employment records may be
	// slightly different but they are merged into one with best efforts.
	//
	// For example, in one profile the school name is "UC Berkeley" and the field
	// study is "Computer Science" and in another one the school name is
	// "University of California at Berkeley" and the field study is "CS". The API
	// merges these two inputs into one and selects one value for each field. For
	// example, the school name in summary is set to "University of California at
	// Berkeley" and the field of study is set to "Computer Science".
	Summary              *Profile `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SummarizedProfile) Reset()         { *m = SummarizedProfile{} }
func (m *SummarizedProfile) String() string { return proto.CompactTextString(m) }
func (*SummarizedProfile) ProtoMessage()    {}
func (*SummarizedProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_d2b7b5f4d4d7ea55, []int{8}
}

func (m *SummarizedProfile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SummarizedProfile.Unmarshal(m, b)
}
func (m *SummarizedProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SummarizedProfile.Marshal(b, m, deterministic)
}
func (m *SummarizedProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummarizedProfile.Merge(m, src)
}
func (m *SummarizedProfile) XXX_Size() int {
	return xxx_messageInfo_SummarizedProfile.Size(m)
}
func (m *SummarizedProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_SummarizedProfile.DiscardUnknown(m)
}

var xxx_messageInfo_SummarizedProfile proto.InternalMessageInfo

func (m *SummarizedProfile) GetProfiles() []*Profile {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *SummarizedProfile) GetSummary() *Profile {
	if m != nil {
		return m.Summary
	}
	return nil
}

func init() {
	proto.RegisterType((*ListProfilesRequest)(nil), "google.cloud.talent.v4beta1.ListProfilesRequest")
	proto.RegisterType((*ListProfilesResponse)(nil), "google.cloud.talent.v4beta1.ListProfilesResponse")
	proto.RegisterType((*CreateProfileRequest)(nil), "google.cloud.talent.v4beta1.CreateProfileRequest")
	proto.RegisterType((*GetProfileRequest)(nil), "google.cloud.talent.v4beta1.GetProfileRequest")
	proto.RegisterType((*UpdateProfileRequest)(nil), "google.cloud.talent.v4beta1.UpdateProfileRequest")
	proto.RegisterType((*DeleteProfileRequest)(nil), "google.cloud.talent.v4beta1.DeleteProfileRequest")
	proto.RegisterType((*SearchProfilesRequest)(nil), "google.cloud.talent.v4beta1.SearchProfilesRequest")
	proto.RegisterType((*SearchProfilesResponse)(nil), "google.cloud.talent.v4beta1.SearchProfilesResponse")
	proto.RegisterType((*SummarizedProfile)(nil), "google.cloud.talent.v4beta1.SummarizedProfile")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/profile_service.proto", fileDescriptor_d2b7b5f4d4d7ea55)
}

var fileDescriptor_d2b7b5f4d4d7ea55 = []byte{
	// 1059 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdf, 0x6e, 0x1b, 0xc5,
	0x17, 0xd6, 0xe6, 0xaf, 0x73, 0xd2, 0x34, 0xc9, 0x24, 0xcd, 0x6f, 0x7f, 0x2e, 0x08, 0x6b, 0x85,
	0xc0, 0x75, 0xe9, 0x6e, 0xe3, 0x56, 0x0a, 0x4a, 0xa1, 0x82, 0x84, 0xbf, 0x12, 0x45, 0x61, 0x1d,
	0x04, 0xea, 0xcd, 0x6a, 0x62, 0x1f, 0x3b, 0x4b, 0x76, 0x77, 0xb6, 0x33, 0xe3, 0x08, 0x07, 0x55,
	0xa2, 0xbc, 0x42, 0xc4, 0x15, 0x77, 0x15, 0x97, 0xdc, 0xf1, 0x28, 0xbc, 0x02, 0x3c, 0x07, 0x68,
	0x66, 0xc7, 0xdb, 0xd8, 0x5e, 0x6d, 0x6c, 0xc4, 0xdd, 0xce, 0x9c, 0xf3, 0x9d, 0xf3, 0xcd, 0x37,
	0x67, 0xce, 0x59, 0xd8, 0xed, 0x31, 0xd6, 0x8b, 0xd0, 0x6b, 0x47, 0xac, 0xdf, 0xf1, 0x24, 0x8d,
	0x30, 0x91, 0xde, 0xf9, 0xc3, 0x13, 0x94, 0x74, 0xd7, 0x4b, 0x39, 0xeb, 0x86, 0x11, 0x06, 0x02,
	0xf9, 0x79, 0xd8, 0x46, 0x37, 0xe5, 0x4c, 0x32, 0x72, 0x3b, 0x83, 0xb8, 0x1a, 0xe2, 0x66, 0x10,
	0xd7, 0x40, 0xaa, 0xaf, 0x99, 0x78, 0x34, 0x0d, 0x3d, 0x9a, 0x24, 0x4c, 0x52, 0x19, 0xb2, 0x44,
	0x64, 0xd0, 0x6a, 0xbd, 0x2c, 0x5b, 0x9b, 0xc5, 0x31, 0x4b, 0x8c, 0xe7, 0x9d, 0x32, 0xcf, 0x6e,
	0x18, 0x49, 0xe4, 0xc3, 0xa0, 0x77, 0xcb, 0x5c, 0x4f, 0x43, 0x21, 0x59, 0x8f, 0xd3, 0x78, 0x9a,
	0xb8, 0xe6, 0xbc, 0xc6, 0xd5, 0x9c, 0xd3, 0xd3, 0xab, 0x93, 0x7e, 0xd7, 0xc3, 0x38, 0x95, 0x03,
	0x63, 0xac, 0x8d, 0x1b, 0xbb, 0x21, 0x46, 0x9d, 0x20, 0xa6, 0xe2, 0x2c, 0xf3, 0x70, 0x5e, 0x5a,
	0xb0, 0xf5, 0x45, 0x28, 0xe4, 0x51, 0x16, 0x54, 0xf8, 0xf8, 0xac, 0x8f, 0x42, 0x92, 0x1d, 0x58,
	0x4a, 0x29, 0xc7, 0x44, 0xda, 0x56, 0xcd, 0xaa, 0xaf, 0xf8, 0x66, 0x45, 0x5e, 0x07, 0x48, 0x69,
	0x0f, 0x03, 0xc9, 0xce, 0x30, 0xb1, 0xe7, 0xb4, 0x6d, 0x45, 0xed, 0x1c, 0xab, 0x0d, 0x72, 0x1b,
	0xf4, 0x22, 0x10, 0xe1, 0x05, 0xda, 0xf3, 0x35, 0xab, 0xbe, 0xe8, 0x57, 0xd4, 0x46, 0x2b, 0xbc,
	0x40, 0xb2, 0x07, 0x2b, 0x1c, 0x69, 0x96, 0xde, 0x5e, 0xa8, 0x59, 0xf5, 0xd5, 0x66, 0xd5, 0x35,
	0xd7, 0x34, 0x64, 0xe8, 0x7e, 0xa2, 0x18, 0x3e, 0xa1, 0xe2, 0xcc, 0xaf, 0x28, 0x67, 0xf5, 0xe5,
	0xfc, 0x68, 0xc1, 0xf6, 0x28, 0x49, 0x91, 0xb2, 0x44, 0x20, 0xf9, 0x00, 0x2a, 0x46, 0x0d, 0x61,
	0x5b, 0xb5, 0xf9, 0xfa, 0x6a, 0xf3, 0x4d, 0xb7, 0xe4, 0xde, 0x5d, 0x13, 0xc0, 0xcf, 0x51, 0xe4,
	0x2d, 0x58, 0x4f, 0xf0, 0x7b, 0x19, 0x4c, 0x1c, 0x6a, 0x4d, 0x6d, 0x1f, 0x0d, 0x0f, 0xe6, 0x24,
	0xb0, 0x7d, 0xc8, 0x91, 0x4a, 0x1c, 0x86, 0xb8, 0x46, 0xa7, 0xc7, 0xb0, 0x6c, 0x72, 0xe8, 0x78,
	0xd3, 0x12, 0x1b, 0x82, 0x9c, 0xb7, 0x61, 0xf3, 0x53, 0x94, 0x63, 0xc9, 0x08, 0x2c, 0x24, 0x34,
	0x46, 0x93, 0x4a, 0x7f, 0x3b, 0x97, 0x16, 0x6c, 0x7f, 0x9d, 0x76, 0x26, 0x99, 0x5d, 0x61, 0x60,
	0xfd, 0x0b, 0x06, 0xe4, 0x11, 0xac, 0xf6, 0x75, 0xdc, 0xec, 0xbe, 0xe6, 0xae, 0xbd, 0x2f, 0xc8,
	0xdc, 0xf5, 0x8d, 0x35, 0x60, 0xfb, 0x23, 0x8c, 0x70, 0x82, 0x54, 0xd1, 0x09, 0x5e, 0x2c, 0xc0,
	0xad, 0x16, 0x52, 0xde, 0x3e, 0x9d, 0xb6, 0x08, 0xbf, 0x81, 0x0d, 0x9e, 0xb9, 0x04, 0x31, 0x4a,
	0xda, 0xa1, 0x92, 0x1a, 0x7e, 0xef, 0x94, 0x9e, 0xd1, 0xc4, 0x7d, 0x62, 0x30, 0xfe, 0x3a, 0x1f,
	0xdd, 0x20, 0x5f, 0xc2, 0xda, 0xb0, 0x9b, 0x3c, 0xeb, 0x23, 0x1f, 0xe8, 0x12, 0x5e, 0x6d, 0xde,
	0x99, 0x46, 0xb9, 0xaf, 0x14, 0xc0, 0xbf, 0x91, 0x5e, 0x59, 0x8d, 0x3e, 0x87, 0x85, 0xb1, 0xe7,
	0x30, 0xfa, 0x94, 0x16, 0xc7, 0x9f, 0xd2, 0x0e, 0x2c, 0xb1, 0x6e, 0x57, 0xa0, 0xb4, 0x97, 0x34,
	0xd0, 0xac, 0x88, 0x0b, 0x5b, 0x9d, 0x50, 0xd0, 0x13, 0xd5, 0xf1, 0x52, 0x8c, 0xa2, 0xa0, 0x7d,
	0x8a, 0xed, 0x33, 0x7b, 0xb9, 0x66, 0xd5, 0x2b, 0xfe, 0xa6, 0x31, 0xb5, 0x94, 0xe5, 0x50, 0x19,
	0xc8, 0xff, 0xa1, 0xc2, 0x78, 0x07, 0x79, 0x70, 0x32, 0xb0, 0x2b, 0x3a, 0xc9, 0xb2, 0x5e, 0x1f,
	0x0c, 0x54, 0xa8, 0x36, 0x15, 0xaa, 0x73, 0x26, 0x22, 0x94, 0xe1, 0x39, 0x06, 0x82, 0x71, 0x69,
	0xaf, 0x64, 0xa1, 0x94, 0xa9, 0x35, 0xb4, 0xb4, 0x18, 0x97, 0xe4, 0x5b, 0xd8, 0xcc, 0x3b, 0x95,
	0x16, 0x28, 0x44, 0x61, 0x83, 0x7e, 0x77, 0x77, 0x4b, 0x25, 0xfa, 0x6c, 0x88, 0xca, 0x44, 0xda,
	0x38, 0xbd, 0xba, 0x0e, 0x51, 0x38, 0x7f, 0xcd, 0xc3, 0xce, 0x78, 0x0d, 0x98, 0x37, 0x7e, 0x1f,
	0xb6, 0x51, 0xc8, 0x30, 0xa6, 0x12, 0x3b, 0x81, 0x64, 0x92, 0x46, 0x99, 0x9c, 0xaa, 0x24, 0xe6,
	0x7d, 0x92, 0xdb, 0x8e, 0x95, 0x49, 0x0b, 0xfb, 0x14, 0x36, 0x8c, 0x32, 0x8c, 0x73, 0x6c, 0xab,
	0xd6, 0x6e, 0xca, 0xc3, 0x2b, 0x65, 0xa9, 0x45, 0x0b, 0x93, 0xde, 0x61, 0x0e, 0xf3, 0xd7, 0x75,
	0xa0, 0x57, 0x1b, 0xe4, 0x73, 0xa8, 0xe4, 0x25, 0x97, 0x15, 0xc7, 0xbd, 0x6b, 0x4a, 0x2e, 0x3b,
	0x46, 0x5e, 0x73, 0x39, 0xbc, 0xa8, 0xf5, 0x2c, 0x14, 0xb4, 0x1e, 0x12, 0xc2, 0xff, 0x46, 0x55,
	0x1f, 0x04, 0x1c, 0x45, 0x3f, 0x92, 0xc2, 0x5e, 0xd4, 0xda, 0xef, 0xce, 0xa2, 0xbd, 0x46, 0xfa,
	0xb7, 0x4e, 0x0b, 0x76, 0x05, 0x09, 0x60, 0x4b, 0xf4, 0xe3, 0x98, 0xf2, 0xf0, 0x02, 0x3b, 0x41,
	0xde, 0x5a, 0x97, 0x74, 0x1a, 0xb7, 0x5c, 0xbc, 0x1c, 0x37, 0x7c, 0xf2, 0x44, 0x8c, 0x6f, 0x09,
	0xe7, 0x67, 0x0b, 0x36, 0x27, 0x3c, 0xff, 0x83, 0x36, 0xfe, 0x18, 0x96, 0xb3, 0x6c, 0x83, 0xd9,
	0xda, 0xad, 0x01, 0x35, 0xff, 0x5e, 0x86, 0x9b, 0x66, 0xb3, 0x95, 0xfd, 0x46, 0x90, 0xdf, 0x2c,
	0xb8, 0x71, 0x75, 0xe8, 0x90, 0xfb, 0xa5, 0x21, 0x0b, 0x86, 0x68, 0x75, 0x77, 0x06, 0x44, 0x56,
	0x26, 0xce, 0xde, 0x4f, 0x7f, 0xfc, 0x79, 0x39, 0xb7, 0x4b, 0xbc, 0x7c, 0xdc, 0xff, 0x90, 0x35,
	0xbd, 0xf7, 0x53, 0xce, 0xbe, 0xc3, 0xb6, 0x14, 0x5e, 0xc3, 0x93, 0x98, 0xd0, 0x44, 0x7d, 0x3d,
	0xf7, 0x72, 0x05, 0x7e, 0xb5, 0x60, 0x6d, 0x64, 0x42, 0x91, 0xf2, 0xec, 0x45, 0xd3, 0xac, 0x3a,
	0x95, 0x6a, 0xce, 0xbe, 0xe6, 0xf8, 0xd0, 0x99, 0x95, 0xe3, 0xbe, 0xd5, 0x20, 0xbf, 0x58, 0x00,
	0xaf, 0x06, 0x1b, 0x29, 0xaf, 0xa9, 0x89, 0x09, 0x38, 0x25, 0xc1, 0x02, 0x11, 0xd5, 0xa4, 0x29,
	0xa4, 0x97, 0xb3, 0xf3, 0x1a, 0xcf, 0xd5, 0x9d, 0xaf, 0x8d, 0x0c, 0xd3, 0x6b, 0x44, 0x2c, 0x1a,
	0xbc, 0x53, 0x72, 0x3c, 0xd0, 0x1c, 0xdf, 0x6b, 0xee, 0x5d, 0x11, 0xd1, 0xfc, 0xd8, 0x4d, 0xc5,
	0x55, 0x89, 0x79, 0x69, 0xc1, 0xda, 0xc8, 0x98, 0xbd, 0x86, 0x6e, 0xd1, 0x48, 0xae, 0xee, 0x4c,
	0x8c, 0xf4, 0x8f, 0xd5, 0x1f, 0xe4, 0x50, 0xc4, 0xc6, 0xcc, 0x22, 0xfe, 0x6e, 0xc1, 0xcd, 0xd1,
	0x5e, 0x4e, 0x9a, 0xe5, 0xad, 0xa3, 0x68, 0xf8, 0x57, 0x1f, 0xcc, 0x84, 0x31, 0xcf, 0xe7, 0x5d,
	0x4d, 0xba, 0xe9, 0xdc, 0x9b, 0xae, 0x34, 0xf7, 0x85, 0x0e, 0xb3, 0x6f, 0x35, 0x0e, 0x5e, 0x58,
	0xf0, 0x46, 0x9b, 0xc5, 0x65, 0x49, 0x0f, 0xb6, 0x46, 0x5b, 0xc4, 0x91, 0x12, 0xec, 0xc8, 0x7a,
	0xfa, 0xa1, 0xc1, 0xf4, 0x58, 0x44, 0x93, 0x9e, 0xcb, 0x78, 0xcf, 0xeb, 0x61, 0xa2, 0xe5, 0xf4,
	0x32, 0x13, 0x4d, 0x43, 0x51, 0xf8, 0x33, 0xff, 0x28, 0x5b, 0xbe, 0x9c, 0x9b, 0x3f, 0x3c, 0x6e,
	0x9d, 0x2c, 0x69, 0xcc, 0x83, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x81, 0xa9, 0x37, 0xfb, 0xef,
	0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProfileServiceClient is the client API for ProfileService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProfileServiceClient interface {
	// Lists profiles by filter. The order is unspecified.
	ListProfiles(ctx context.Context, in *ListProfilesRequest, opts ...grpc.CallOption) (*ListProfilesResponse, error)
	// Creates and returns a new profile.
	CreateProfile(ctx context.Context, in *CreateProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// Gets the specified profile.
	GetProfile(ctx context.Context, in *GetProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// Updates the specified profile and returns the updated result.
	UpdateProfile(ctx context.Context, in *UpdateProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// Deletes the specified profile.
	// Prerequisite: The profile has no associated applications or assignments
	// associated.
	DeleteProfile(ctx context.Context, in *DeleteProfileRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches for profiles within a tenant.
	//
	// For example, search by raw queries "software engineer in Mountain View" or
	// search by structured filters (location filter, education filter, etc.).
	//
	// See [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest] for more information.
	SearchProfiles(ctx context.Context, in *SearchProfilesRequest, opts ...grpc.CallOption) (*SearchProfilesResponse, error)
}

type profileServiceClient struct {
	cc *grpc.ClientConn
}

func NewProfileServiceClient(cc *grpc.ClientConn) ProfileServiceClient {
	return &profileServiceClient{cc}
}

func (c *profileServiceClient) ListProfiles(ctx context.Context, in *ListProfilesRequest, opts ...grpc.CallOption) (*ListProfilesResponse, error) {
	out := new(ListProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/ListProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) CreateProfile(ctx context.Context, in *CreateProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/CreateProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) GetProfile(ctx context.Context, in *GetProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/GetProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) UpdateProfile(ctx context.Context, in *UpdateProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/UpdateProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) DeleteProfile(ctx context.Context, in *DeleteProfileRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/DeleteProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profileServiceClient) SearchProfiles(ctx context.Context, in *SearchProfilesRequest, opts ...grpc.CallOption) (*SearchProfilesResponse, error) {
	out := new(SearchProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ProfileService/SearchProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProfileServiceServer is the server API for ProfileService service.
type ProfileServiceServer interface {
	// Lists profiles by filter. The order is unspecified.
	ListProfiles(context.Context, *ListProfilesRequest) (*ListProfilesResponse, error)
	// Creates and returns a new profile.
	CreateProfile(context.Context, *CreateProfileRequest) (*Profile, error)
	// Gets the specified profile.
	GetProfile(context.Context, *GetProfileRequest) (*Profile, error)
	// Updates the specified profile and returns the updated result.
	UpdateProfile(context.Context, *UpdateProfileRequest) (*Profile, error)
	// Deletes the specified profile.
	// Prerequisite: The profile has no associated applications or assignments
	// associated.
	DeleteProfile(context.Context, *DeleteProfileRequest) (*empty.Empty, error)
	// Searches for profiles within a tenant.
	//
	// For example, search by raw queries "software engineer in Mountain View" or
	// search by structured filters (location filter, education filter, etc.).
	//
	// See [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest] for more information.
	SearchProfiles(context.Context, *SearchProfilesRequest) (*SearchProfilesResponse, error)
}

func RegisterProfileServiceServer(s *grpc.Server, srv ProfileServiceServer) {
	s.RegisterService(&_ProfileService_serviceDesc, srv)
}

func _ProfileService_ListProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).ListProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/ListProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).ListProfiles(ctx, req.(*ListProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_CreateProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).CreateProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/CreateProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).CreateProfile(ctx, req.(*CreateProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_GetProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).GetProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/GetProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).GetProfile(ctx, req.(*GetProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_UpdateProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).UpdateProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/UpdateProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).UpdateProfile(ctx, req.(*UpdateProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_DeleteProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).DeleteProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/DeleteProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).DeleteProfile(ctx, req.(*DeleteProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfileService_SearchProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfileServiceServer).SearchProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ProfileService/SearchProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfileServiceServer).SearchProfiles(ctx, req.(*SearchProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProfileService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.ProfileService",
	HandlerType: (*ProfileServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListProfiles",
			Handler:    _ProfileService_ListProfiles_Handler,
		},
		{
			MethodName: "CreateProfile",
			Handler:    _ProfileService_CreateProfile_Handler,
		},
		{
			MethodName: "GetProfile",
			Handler:    _ProfileService_GetProfile_Handler,
		},
		{
			MethodName: "UpdateProfile",
			Handler:    _ProfileService_UpdateProfile_Handler,
		},
		{
			MethodName: "DeleteProfile",
			Handler:    _ProfileService_DeleteProfile_Handler,
		},
		{
			MethodName: "SearchProfiles",
			Handler:    _ProfileService_SearchProfiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/profile_service.proto",
}
