// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/clouddms/logging/v1/clouddms_platform_logs.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The database engines.
type DatabaseEngine int32

const (
	// The source database engine of the migration job is unknown.
	DatabaseEngine_DATABASE_ENGINE_UNSPECIFIED DatabaseEngine = 0
	// The source engine is MySQL.
	DatabaseEngine_MYSQL DatabaseEngine = 1
	// The source engine is PostgreSQL.
	DatabaseEngine_POSTGRESQL DatabaseEngine = 2
	// The source engine is SQL Server.
	DatabaseEngine_SQLSERVER DatabaseEngine = 3
)

// Enum value maps for DatabaseEngine.
var (
	DatabaseEngine_name = map[int32]string{
		0: "DATABASE_ENGINE_UNSPECIFIED",
		1: "MYSQL",
		2: "POSTGRESQL",
		3: "SQLSERVER",
	}
	DatabaseEngine_value = map[string]int32{
		"DATABASE_ENGINE_UNSPECIFIED": 0,
		"MYSQL":                       1,
		"POSTGRESQL":                  2,
		"SQLSERVER":                   3,
	}
)

func (x DatabaseEngine) Enum() *DatabaseEngine {
	p := new(DatabaseEngine)
	*p = x
	return p
}

func (x DatabaseEngine) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEngine) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[0].Descriptor()
}

func (DatabaseEngine) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[0]
}

func (x DatabaseEngine) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEngine.Descriptor instead.
func (DatabaseEngine) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{0}
}

// The database providers.
type DatabaseProvider int32

const (
	// The database provider is unknown.
	DatabaseProvider_DATABASE_PROVIDER_UNSPECIFIED DatabaseProvider = 0
	// CloudSQL runs the database.
	DatabaseProvider_CLOUDSQL DatabaseProvider = 1
	// RDS runs the database.
	DatabaseProvider_RDS DatabaseProvider = 2
)

// Enum value maps for DatabaseProvider.
var (
	DatabaseProvider_name = map[int32]string{
		0: "DATABASE_PROVIDER_UNSPECIFIED",
		1: "CLOUDSQL",
		2: "RDS",
	}
	DatabaseProvider_value = map[string]int32{
		"DATABASE_PROVIDER_UNSPECIFIED": 0,
		"CLOUDSQL":                      1,
		"RDS":                           2,
	}
)

func (x DatabaseProvider) Enum() *DatabaseProvider {
	p := new(DatabaseProvider)
	*p = x
	return p
}

func (x DatabaseProvider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseProvider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[1].Descriptor()
}

func (DatabaseProvider) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[1]
}

func (x DatabaseProvider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseProvider.Descriptor instead.
func (DatabaseProvider) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{1}
}

// The migration job states enum.
type LoggedMigrationJob_State int32

const (
	// The state of the migration job is unknown.
	LoggedMigrationJob_STATE_UNSPECIFIED LoggedMigrationJob_State = 0
	// The migration job is down for maintenance.
	LoggedMigrationJob_MAINTENANCE LoggedMigrationJob_State = 1
	// The migration job is in draft mode and fully editable.
	LoggedMigrationJob_DRAFT LoggedMigrationJob_State = 2
	// The migration job is being created.
	LoggedMigrationJob_CREATING LoggedMigrationJob_State = 3
	// The migration job is created, not started and is fully editable.
	LoggedMigrationJob_NOT_STARTED LoggedMigrationJob_State = 4
	// The migration job is running
	LoggedMigrationJob_RUNNING LoggedMigrationJob_State = 5
	// The migration job failed.
	LoggedMigrationJob_FAILED LoggedMigrationJob_State = 6
	// The migration job has been completed.
	LoggedMigrationJob_COMPLETED LoggedMigrationJob_State = 7
	// The migration job is being deleted.
	LoggedMigrationJob_DELETING LoggedMigrationJob_State = 8
	// The migration job is being stopped.
	LoggedMigrationJob_STOPPING LoggedMigrationJob_State = 9
	// The migration job is currently stopped.
	LoggedMigrationJob_STOPPED LoggedMigrationJob_State = 10
	// The migration job has been deleted.
	LoggedMigrationJob_DELETED LoggedMigrationJob_State = 11
	// The migration job is being updated.
	LoggedMigrationJob_UPDATING LoggedMigrationJob_State = 12
	// The migration job is starting.
	LoggedMigrationJob_STARTING LoggedMigrationJob_State = 13
	// The migration job is restarting.
	LoggedMigrationJob_RESTARTING LoggedMigrationJob_State = 14
	// The migration job is resuming.
	LoggedMigrationJob_RESUMING LoggedMigrationJob_State = 15
)

// Enum value maps for LoggedMigrationJob_State.
var (
	LoggedMigrationJob_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "MAINTENANCE",
		2:  "DRAFT",
		3:  "CREATING",
		4:  "NOT_STARTED",
		5:  "RUNNING",
		6:  "FAILED",
		7:  "COMPLETED",
		8:  "DELETING",
		9:  "STOPPING",
		10: "STOPPED",
		11: "DELETED",
		12: "UPDATING",
		13: "STARTING",
		14: "RESTARTING",
		15: "RESUMING",
	}
	LoggedMigrationJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"MAINTENANCE":       1,
		"DRAFT":             2,
		"CREATING":          3,
		"NOT_STARTED":       4,
		"RUNNING":           5,
		"FAILED":            6,
		"COMPLETED":         7,
		"DELETING":          8,
		"STOPPING":          9,
		"STOPPED":           10,
		"DELETED":           11,
		"UPDATING":          12,
		"STARTING":          13,
		"RESTARTING":        14,
		"RESUMING":          15,
	}
)

func (x LoggedMigrationJob_State) Enum() *LoggedMigrationJob_State {
	p := new(LoggedMigrationJob_State)
	*p = x
	return p
}

func (x LoggedMigrationJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggedMigrationJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[2].Descriptor()
}

func (LoggedMigrationJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[2]
}

func (x LoggedMigrationJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggedMigrationJob_State.Descriptor instead.
func (LoggedMigrationJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{1, 0}
}

// The migration job phases enum.
type LoggedMigrationJob_Phase int32

const (
	// The phase of the migration job is unknown.
	LoggedMigrationJob_PHASE_UNSPECIFIED LoggedMigrationJob_Phase = 0
	// The migration job is in the full dump phase.
	LoggedMigrationJob_FULL_DUMP LoggedMigrationJob_Phase = 1
	// The migration job is CDC phase.
	LoggedMigrationJob_CDC LoggedMigrationJob_Phase = 2
	// The migration job is running the promote phase.
	LoggedMigrationJob_PROMOTE_IN_PROGRESS LoggedMigrationJob_Phase = 3
	// Only RDS flow - waiting for source writes to stop
	LoggedMigrationJob_WAITING_FOR_SOURCE_WRITES_TO_STOP LoggedMigrationJob_Phase = 4
	// Only RDS flow - the sources writes stopped, waiting for dump to begin
	LoggedMigrationJob_PREPARING_THE_DUMP LoggedMigrationJob_Phase = 5
)

// Enum value maps for LoggedMigrationJob_Phase.
var (
	LoggedMigrationJob_Phase_name = map[int32]string{
		0: "PHASE_UNSPECIFIED",
		1: "FULL_DUMP",
		2: "CDC",
		3: "PROMOTE_IN_PROGRESS",
		4: "WAITING_FOR_SOURCE_WRITES_TO_STOP",
		5: "PREPARING_THE_DUMP",
	}
	LoggedMigrationJob_Phase_value = map[string]int32{
		"PHASE_UNSPECIFIED":                 0,
		"FULL_DUMP":                         1,
		"CDC":                               2,
		"PROMOTE_IN_PROGRESS":               3,
		"WAITING_FOR_SOURCE_WRITES_TO_STOP": 4,
		"PREPARING_THE_DUMP":                5,
	}
)

func (x LoggedMigrationJob_Phase) Enum() *LoggedMigrationJob_Phase {
	p := new(LoggedMigrationJob_Phase)
	*p = x
	return p
}

func (x LoggedMigrationJob_Phase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggedMigrationJob_Phase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[3].Descriptor()
}

func (LoggedMigrationJob_Phase) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[3]
}

func (x LoggedMigrationJob_Phase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggedMigrationJob_Phase.Descriptor instead.
func (LoggedMigrationJob_Phase) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{1, 1}
}

// The migration job types.
type LoggedMigrationJob_Type int32

const (
	// The type of the migration job is unknown.
	LoggedMigrationJob_TYPE_UNSPECIFIED LoggedMigrationJob_Type = 0
	// The migration job is a one time migration.
	LoggedMigrationJob_ONE_TIME LoggedMigrationJob_Type = 1
	// The migration job is a continuous migration.
	LoggedMigrationJob_CONTINUOUS LoggedMigrationJob_Type = 2
)

// Enum value maps for LoggedMigrationJob_Type.
var (
	LoggedMigrationJob_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ONE_TIME",
		2: "CONTINUOUS",
	}
	LoggedMigrationJob_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ONE_TIME":         1,
		"CONTINUOUS":       2,
	}
)

func (x LoggedMigrationJob_Type) Enum() *LoggedMigrationJob_Type {
	p := new(LoggedMigrationJob_Type)
	*p = x
	return p
}

func (x LoggedMigrationJob_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggedMigrationJob_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[4].Descriptor()
}

func (LoggedMigrationJob_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[4]
}

func (x LoggedMigrationJob_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggedMigrationJob_Type.Descriptor instead.
func (LoggedMigrationJob_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{1, 2}
}

// Type of connectivity to source database.
type LoggedMigrationJob_ConnectivityType int32

const (
	// No data defined.
	LoggedMigrationJob_CONNECTIVITY_TYPE_UNSPECIFIED LoggedMigrationJob_ConnectivityType = 0
	// Connect using static IO
	LoggedMigrationJob_STATIC_IP LoggedMigrationJob_ConnectivityType = 1
	// Use reverse SSH connectivity.
	LoggedMigrationJob_REVERSE_SSH LoggedMigrationJob_ConnectivityType = 2
	// Use VPC Peering connectivity.
	LoggedMigrationJob_VPC_PEERING LoggedMigrationJob_ConnectivityType = 3
)

// Enum value maps for LoggedMigrationJob_ConnectivityType.
var (
	LoggedMigrationJob_ConnectivityType_name = map[int32]string{
		0: "CONNECTIVITY_TYPE_UNSPECIFIED",
		1: "STATIC_IP",
		2: "REVERSE_SSH",
		3: "VPC_PEERING",
	}
	LoggedMigrationJob_ConnectivityType_value = map[string]int32{
		"CONNECTIVITY_TYPE_UNSPECIFIED": 0,
		"STATIC_IP":                     1,
		"REVERSE_SSH":                   2,
		"VPC_PEERING":                   3,
	}
)

func (x LoggedMigrationJob_ConnectivityType) Enum() *LoggedMigrationJob_ConnectivityType {
	p := new(LoggedMigrationJob_ConnectivityType)
	*p = x
	return p
}

func (x LoggedMigrationJob_ConnectivityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggedMigrationJob_ConnectivityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[5].Descriptor()
}

func (LoggedMigrationJob_ConnectivityType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[5]
}

func (x LoggedMigrationJob_ConnectivityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggedMigrationJob_ConnectivityType.Descriptor instead.
func (LoggedMigrationJob_ConnectivityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{1, 3}
}

// The MySQL database version.
type MySqlConnectionProfile_Version int32

const (
	// Unspecified version.
	MySqlConnectionProfile_VERSION_UNSPECIFIED MySqlConnectionProfile_Version = 0
	// MySQL 5.5.
	MySqlConnectionProfile_V5_5 MySqlConnectionProfile_Version = 1
	// MySQL 5.6.
	MySqlConnectionProfile_V5_6 MySqlConnectionProfile_Version = 2
	// MySQL 5.7.
	MySqlConnectionProfile_V5_7 MySqlConnectionProfile_Version = 3
	// MySQL 8.0.
	MySqlConnectionProfile_V8_0 MySqlConnectionProfile_Version = 4
)

// Enum value maps for MySqlConnectionProfile_Version.
var (
	MySqlConnectionProfile_Version_name = map[int32]string{
		0: "VERSION_UNSPECIFIED",
		1: "V5_5",
		2: "V5_6",
		3: "V5_7",
		4: "V8_0",
	}
	MySqlConnectionProfile_Version_value = map[string]int32{
		"VERSION_UNSPECIFIED": 0,
		"V5_5":                1,
		"V5_6":                2,
		"V5_7":                3,
		"V8_0":                4,
	}
)

func (x MySqlConnectionProfile_Version) Enum() *MySqlConnectionProfile_Version {
	p := new(MySqlConnectionProfile_Version)
	*p = x
	return p
}

func (x MySqlConnectionProfile_Version) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MySqlConnectionProfile_Version) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[6].Descriptor()
}

func (MySqlConnectionProfile_Version) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[6]
}

func (x MySqlConnectionProfile_Version) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MySqlConnectionProfile_Version.Descriptor instead.
func (MySqlConnectionProfile_Version) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{2, 0}
}

// The PostgreSQL database version.
type PostgreSqlConnectionProfile_Version int32

const (
	// Unspecified version.
	PostgreSqlConnectionProfile_VERSION_UNSPECIFIED PostgreSqlConnectionProfile_Version = 0
	// PostgreSQL 9.6.
	PostgreSqlConnectionProfile_V9_6 PostgreSqlConnectionProfile_Version = 1
	// PostgreSQL 11.
	PostgreSqlConnectionProfile_V11 PostgreSqlConnectionProfile_Version = 2
	// PostgreSQL 10.
	PostgreSqlConnectionProfile_V10 PostgreSqlConnectionProfile_Version = 3
	// PostgreSQL 12.
	PostgreSqlConnectionProfile_V12 PostgreSqlConnectionProfile_Version = 4
	// PostgreSQL 13.
	PostgreSqlConnectionProfile_V13 PostgreSqlConnectionProfile_Version = 5
)

// Enum value maps for PostgreSqlConnectionProfile_Version.
var (
	PostgreSqlConnectionProfile_Version_name = map[int32]string{
		0: "VERSION_UNSPECIFIED",
		1: "V9_6",
		2: "V11",
		3: "V10",
		4: "V12",
		5: "V13",
	}
	PostgreSqlConnectionProfile_Version_value = map[string]int32{
		"VERSION_UNSPECIFIED": 0,
		"V9_6":                1,
		"V11":                 2,
		"V10":                 3,
		"V12":                 4,
		"V13":                 5,
	}
)

func (x PostgreSqlConnectionProfile_Version) Enum() *PostgreSqlConnectionProfile_Version {
	p := new(PostgreSqlConnectionProfile_Version)
	*p = x
	return p
}

func (x PostgreSqlConnectionProfile_Version) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PostgreSqlConnectionProfile_Version) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[7].Descriptor()
}

func (PostgreSqlConnectionProfile_Version) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[7]
}

func (x PostgreSqlConnectionProfile_Version) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PostgreSqlConnectionProfile_Version.Descriptor instead.
func (PostgreSqlConnectionProfile_Version) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{3, 0}
}

// The connection profile states enum.
type LoggedConnectionProfile_State int32

const (
	// The state of the connection profile is unknown.
	LoggedConnectionProfile_STATE_UNSPECIFIED LoggedConnectionProfile_State = 0
	// The connection profile is in draft mode and fully editable.
	LoggedConnectionProfile_DRAFT LoggedConnectionProfile_State = 1
	// The connection profile is being created.
	LoggedConnectionProfile_CREATING LoggedConnectionProfile_State = 2
	// The connection profile is ready.
	LoggedConnectionProfile_READY LoggedConnectionProfile_State = 3
	// The connection profile is being updated.
	LoggedConnectionProfile_UPDATING LoggedConnectionProfile_State = 4
	// The connection profile is being deleted.
	LoggedConnectionProfile_DELETING LoggedConnectionProfile_State = 5
	// The connection profile has been deleted.
	LoggedConnectionProfile_DELETED LoggedConnectionProfile_State = 6
	// The last action on the connection profile failed.
	LoggedConnectionProfile_FAILED LoggedConnectionProfile_State = 7
)

// Enum value maps for LoggedConnectionProfile_State.
var (
	LoggedConnectionProfile_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "CREATING",
		3: "READY",
		4: "UPDATING",
		5: "DELETING",
		6: "DELETED",
		7: "FAILED",
	}
	LoggedConnectionProfile_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"CREATING":          2,
		"READY":             3,
		"UPDATING":          4,
		"DELETING":          5,
		"DELETED":           6,
		"FAILED":            7,
	}
)

func (x LoggedConnectionProfile_State) Enum() *LoggedConnectionProfile_State {
	p := new(LoggedConnectionProfile_State)
	*p = x
	return p
}

func (x LoggedConnectionProfile_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggedConnectionProfile_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[8].Descriptor()
}

func (LoggedConnectionProfile_State) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes[8]
}

func (x LoggedConnectionProfile_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggedConnectionProfile_State.Descriptor instead.
func (LoggedConnectionProfile_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{5, 0}
}

// A message defining the database engine and provider.
type DatabaseType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database provider.
	Provider DatabaseProvider `protobuf:"varint,1,opt,name=provider,proto3,enum=google.cloud.clouddms.logging.v1.DatabaseProvider" json:"provider,omitempty"`
	// The database engine.
	Engine DatabaseEngine `protobuf:"varint,2,opt,name=engine,proto3,enum=google.cloud.clouddms.logging.v1.DatabaseEngine" json:"engine,omitempty"`
}

func (x *DatabaseType) Reset() {
	*x = DatabaseType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseType) ProtoMessage() {}

func (x *DatabaseType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseType.ProtoReflect.Descriptor instead.
func (*DatabaseType) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{0}
}

func (x *DatabaseType) GetProvider() DatabaseProvider {
	if x != nil {
		return x.Provider
	}
	return DatabaseProvider_DATABASE_PROVIDER_UNSPECIFIED
}

func (x *DatabaseType) GetEngine() DatabaseEngine {
	if x != nil {
		return x.Engine
	}
	return DatabaseEngine_DATABASE_ENGINE_UNSPECIFIED
}

// Migration job as stored in Cloud Logging logs.
// NEXT_TAG = 36.
type LoggedMigrationJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier for a migration job.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The display name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The current migration job state.
	State LoggedMigrationJob_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.clouddms.logging.v1.LoggedMigrationJob_State" json:"state,omitempty"`
	// Required. The current migration job phase.
	Phase LoggedMigrationJob_Phase `protobuf:"varint,5,opt,name=phase,proto3,enum=google.cloud.clouddms.logging.v1.LoggedMigrationJob_Phase" json:"phase,omitempty"`
	// Required. The migration job type.
	Type LoggedMigrationJob_Type `protobuf:"varint,6,opt,name=type,proto3,enum=google.cloud.clouddms.logging.v1.LoggedMigrationJob_Type" json:"type,omitempty"`
	// Optional. An optional dump path (gs://[BUCKET_NAME]/[OBJECT_NAME]).
	DumpPath string `protobuf:"bytes,7,opt,name=dump_path,json=dumpPath,proto3" json:"dump_path,omitempty"`
	// Required. The migration job source connection profile name.
	Source string `protobuf:"bytes,8,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The migration job destination connection profile name.
	Destination string `protobuf:"bytes,9,opt,name=destination,proto3" json:"destination,omitempty"`
	// Required. the migration job duration in seconds.
	Duration *durationpb.Duration `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	// Required. Type of connectivity to source database.
	ConnectivityType LoggedMigrationJob_ConnectivityType `protobuf:"varint,11,opt,name=connectivity_type,json=connectivityType,proto3,enum=google.cloud.clouddms.logging.v1.LoggedMigrationJob_ConnectivityType" json:"connectivity_type,omitempty"`
	// Required. The error details in case of state FAILED.
	Error *status.Status `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
	// Required. The time when this migration job was completed. Should only be set when the
	// phase of the migration job is COMPLETED.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Required. The indicative source database.
	SourceDatabase *DatabaseType `protobuf:"bytes,14,opt,name=source_database,json=sourceDatabase,proto3" json:"source_database,omitempty"`
	// Required. The indicative destination database.
	DestinationDatabase *DatabaseType `protobuf:"bytes,15,opt,name=destination_database,json=destinationDatabase,proto3" json:"destination_database,omitempty"`
}

func (x *LoggedMigrationJob) Reset() {
	*x = LoggedMigrationJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggedMigrationJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggedMigrationJob) ProtoMessage() {}

func (x *LoggedMigrationJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggedMigrationJob.ProtoReflect.Descriptor instead.
func (*LoggedMigrationJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{1}
}

func (x *LoggedMigrationJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoggedMigrationJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LoggedMigrationJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *LoggedMigrationJob) GetState() LoggedMigrationJob_State {
	if x != nil {
		return x.State
	}
	return LoggedMigrationJob_STATE_UNSPECIFIED
}

func (x *LoggedMigrationJob) GetPhase() LoggedMigrationJob_Phase {
	if x != nil {
		return x.Phase
	}
	return LoggedMigrationJob_PHASE_UNSPECIFIED
}

func (x *LoggedMigrationJob) GetType() LoggedMigrationJob_Type {
	if x != nil {
		return x.Type
	}
	return LoggedMigrationJob_TYPE_UNSPECIFIED
}

func (x *LoggedMigrationJob) GetDumpPath() string {
	if x != nil {
		return x.DumpPath
	}
	return ""
}

func (x *LoggedMigrationJob) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *LoggedMigrationJob) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *LoggedMigrationJob) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *LoggedMigrationJob) GetConnectivityType() LoggedMigrationJob_ConnectivityType {
	if x != nil {
		return x.ConnectivityType
	}
	return LoggedMigrationJob_CONNECTIVITY_TYPE_UNSPECIFIED
}

func (x *LoggedMigrationJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *LoggedMigrationJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *LoggedMigrationJob) GetSourceDatabase() *DatabaseType {
	if x != nil {
		return x.SourceDatabase
	}
	return nil
}

func (x *LoggedMigrationJob) GetDestinationDatabase() *DatabaseType {
	if x != nil {
		return x.DestinationDatabase
	}
	return nil
}

// An MySQL database connection profile.
type MySqlConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database version.
	Version MySqlConnectionProfile_Version `protobuf:"varint,1,opt,name=version,proto3,enum=google.cloud.clouddms.logging.v1.MySqlConnectionProfile_Version" json:"version,omitempty"`
	// The Cloud SQL id for a Cloud SQL instance.
	CloudSqlId string `protobuf:"bytes,2,opt,name=cloud_sql_id,json=cloudSqlId,proto3" json:"cloud_sql_id,omitempty"`
}

func (x *MySqlConnectionProfile) Reset() {
	*x = MySqlConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySqlConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySqlConnectionProfile) ProtoMessage() {}

func (x *MySqlConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySqlConnectionProfile.ProtoReflect.Descriptor instead.
func (*MySqlConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{2}
}

func (x *MySqlConnectionProfile) GetVersion() MySqlConnectionProfile_Version {
	if x != nil {
		return x.Version
	}
	return MySqlConnectionProfile_VERSION_UNSPECIFIED
}

func (x *MySqlConnectionProfile) GetCloudSqlId() string {
	if x != nil {
		return x.CloudSqlId
	}
	return ""
}

// An PostgreSQL connection profile.
type PostgreSqlConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database version.
	Version PostgreSqlConnectionProfile_Version `protobuf:"varint,1,opt,name=version,proto3,enum=google.cloud.clouddms.logging.v1.PostgreSqlConnectionProfile_Version" json:"version,omitempty"`
	// The Cloud SQL id for a Cloud SQL instance.
	CloudSqlId string `protobuf:"bytes,2,opt,name=cloud_sql_id,json=cloudSqlId,proto3" json:"cloud_sql_id,omitempty"`
}

func (x *PostgreSqlConnectionProfile) Reset() {
	*x = PostgreSqlConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgreSqlConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgreSqlConnectionProfile) ProtoMessage() {}

func (x *PostgreSqlConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgreSqlConnectionProfile.ProtoReflect.Descriptor instead.
func (*PostgreSqlConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{3}
}

func (x *PostgreSqlConnectionProfile) GetVersion() PostgreSqlConnectionProfile_Version {
	if x != nil {
		return x.Version
	}
	return PostgreSqlConnectionProfile_VERSION_UNSPECIFIED
}

func (x *PostgreSqlConnectionProfile) GetCloudSqlId() string {
	if x != nil {
		return x.CloudSqlId
	}
	return ""
}

// A CloudSQL connection profile.
type CloudSqlConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud SQL id.
	CloudSqlId string `protobuf:"bytes,1,opt,name=cloud_sql_id,json=cloudSqlId,proto3" json:"cloud_sql_id,omitempty"`
}

func (x *CloudSqlConnectionProfile) Reset() {
	*x = CloudSqlConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSqlConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlConnectionProfile) ProtoMessage() {}

func (x *CloudSqlConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlConnectionProfile.ProtoReflect.Descriptor instead.
func (*CloudSqlConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{4}
}

func (x *CloudSqlConnectionProfile) GetCloudSqlId() string {
	if x != nil {
		return x.CloudSqlId
	}
	return ""
}

// An producer connection profile definition.
// NEXT_TAG = 18.
type LoggedConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for a connection profile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The current connection profile state.
	State LoggedConnectionProfile_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.clouddms.logging.v1.LoggedConnectionProfile_State" json:"state,omitempty"`
	// The display name.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The connection profile definition
	//
	// Types that are assignable to ConnectionProfile:
	//	*LoggedConnectionProfile_Mysql
	//	*LoggedConnectionProfile_Postgresql
	//	*LoggedConnectionProfile_Cloudsql
	ConnectionProfile isLoggedConnectionProfile_ConnectionProfile `protobuf_oneof:"connection_profile"`
	// The error details in case of state FAILED.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// The database provider.
	Provider DatabaseProvider `protobuf:"varint,6,opt,name=provider,proto3,enum=google.cloud.clouddms.logging.v1.DatabaseProvider" json:"provider,omitempty"`
}

func (x *LoggedConnectionProfile) Reset() {
	*x = LoggedConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggedConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggedConnectionProfile) ProtoMessage() {}

func (x *LoggedConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggedConnectionProfile.ProtoReflect.Descriptor instead.
func (*LoggedConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{5}
}

func (x *LoggedConnectionProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoggedConnectionProfile) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LoggedConnectionProfile) GetState() LoggedConnectionProfile_State {
	if x != nil {
		return x.State
	}
	return LoggedConnectionProfile_STATE_UNSPECIFIED
}

func (x *LoggedConnectionProfile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *LoggedConnectionProfile) GetConnectionProfile() isLoggedConnectionProfile_ConnectionProfile {
	if m != nil {
		return m.ConnectionProfile
	}
	return nil
}

func (x *LoggedConnectionProfile) GetMysql() *MySqlConnectionProfile {
	if x, ok := x.GetConnectionProfile().(*LoggedConnectionProfile_Mysql); ok {
		return x.Mysql
	}
	return nil
}

func (x *LoggedConnectionProfile) GetPostgresql() *PostgreSqlConnectionProfile {
	if x, ok := x.GetConnectionProfile().(*LoggedConnectionProfile_Postgresql); ok {
		return x.Postgresql
	}
	return nil
}

func (x *LoggedConnectionProfile) GetCloudsql() *CloudSqlConnectionProfile {
	if x, ok := x.GetConnectionProfile().(*LoggedConnectionProfile_Cloudsql); ok {
		return x.Cloudsql
	}
	return nil
}

func (x *LoggedConnectionProfile) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *LoggedConnectionProfile) GetProvider() DatabaseProvider {
	if x != nil {
		return x.Provider
	}
	return DatabaseProvider_DATABASE_PROVIDER_UNSPECIFIED
}

type isLoggedConnectionProfile_ConnectionProfile interface {
	isLoggedConnectionProfile_ConnectionProfile()
}

type LoggedConnectionProfile_Mysql struct {
	// A MySQL database connection profile.
	Mysql *MySqlConnectionProfile `protobuf:"bytes,100,opt,name=mysql,proto3,oneof"`
}

type LoggedConnectionProfile_Postgresql struct {
	// A PostgreSQL database connection profile.
	Postgresql *PostgreSqlConnectionProfile `protobuf:"bytes,101,opt,name=postgresql,proto3,oneof"`
}

type LoggedConnectionProfile_Cloudsql struct {
	// A CloudSQL database connection profile.
	Cloudsql *CloudSqlConnectionProfile `protobuf:"bytes,102,opt,name=cloudsql,proto3,oneof"`
}

func (*LoggedConnectionProfile_Mysql) isLoggedConnectionProfile_ConnectionProfile() {}

func (*LoggedConnectionProfile_Postgresql) isLoggedConnectionProfile_ConnectionProfile() {}

func (*LoggedConnectionProfile_Cloudsql) isLoggedConnectionProfile_ConnectionProfile() {}

// Log definition for Migration Job event
type MigrationJobEventLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The migration job resource
	MigrationJob *LoggedMigrationJob `protobuf:"bytes,1,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// Timestamp of the event
	OccurrenceTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=occurrence_timestamp,json=occurrenceTimestamp,proto3" json:"occurrence_timestamp,omitempty"`
	// Event code
	Code int32 `protobuf:"varint,3,opt,name=code,proto3" json:"code,omitempty"`
	// Event message
	TextMessage string `protobuf:"bytes,4,opt,name=text_message,json=textMessage,proto3" json:"text_message,omitempty"`
	// Original event data
	//
	// Types that are assignable to OriginalCause:
	//	*MigrationJobEventLog_OriginalCode
	//	*MigrationJobEventLog_OriginalMessage
	OriginalCause isMigrationJobEventLog_OriginalCause `protobuf_oneof:"original_cause"`
}

func (x *MigrationJobEventLog) Reset() {
	*x = MigrationJobEventLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationJobEventLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationJobEventLog) ProtoMessage() {}

func (x *MigrationJobEventLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationJobEventLog.ProtoReflect.Descriptor instead.
func (*MigrationJobEventLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{6}
}

func (x *MigrationJobEventLog) GetMigrationJob() *LoggedMigrationJob {
	if x != nil {
		return x.MigrationJob
	}
	return nil
}

func (x *MigrationJobEventLog) GetOccurrenceTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.OccurrenceTimestamp
	}
	return nil
}

func (x *MigrationJobEventLog) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *MigrationJobEventLog) GetTextMessage() string {
	if x != nil {
		return x.TextMessage
	}
	return ""
}

func (m *MigrationJobEventLog) GetOriginalCause() isMigrationJobEventLog_OriginalCause {
	if m != nil {
		return m.OriginalCause
	}
	return nil
}

func (x *MigrationJobEventLog) GetOriginalCode() int32 {
	if x, ok := x.GetOriginalCause().(*MigrationJobEventLog_OriginalCode); ok {
		return x.OriginalCode
	}
	return 0
}

func (x *MigrationJobEventLog) GetOriginalMessage() string {
	if x, ok := x.GetOriginalCause().(*MigrationJobEventLog_OriginalMessage); ok {
		return x.OriginalMessage
	}
	return ""
}

type isMigrationJobEventLog_OriginalCause interface {
	isMigrationJobEventLog_OriginalCause()
}

type MigrationJobEventLog_OriginalCode struct {
	// Original event code
	OriginalCode int32 `protobuf:"varint,200,opt,name=original_code,json=originalCode,proto3,oneof"`
}

type MigrationJobEventLog_OriginalMessage struct {
	// Original event message
	OriginalMessage string `protobuf:"bytes,201,opt,name=original_message,json=originalMessage,proto3,oneof"`
}

func (*MigrationJobEventLog_OriginalCode) isMigrationJobEventLog_OriginalCause() {}

func (*MigrationJobEventLog_OriginalMessage) isMigrationJobEventLog_OriginalCause() {}

// Log definition for Connection Profile event
type ConnectionProfileEventLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The connection profilr resource
	ConnectionProfile *LoggedConnectionProfile `protobuf:"bytes,1,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// Timestamp of the event
	OccurrenceTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=occurrence_timestamp,json=occurrenceTimestamp,proto3" json:"occurrence_timestamp,omitempty"`
	// Event code
	Code int32 `protobuf:"varint,3,opt,name=code,proto3" json:"code,omitempty"`
	// Event message
	TextMessage string `protobuf:"bytes,4,opt,name=text_message,json=textMessage,proto3" json:"text_message,omitempty"`
	// Original event data
	//
	// Types that are assignable to OriginalCause:
	//	*ConnectionProfileEventLog_OriginalCode
	//	*ConnectionProfileEventLog_OriginalMessage
	OriginalCause isConnectionProfileEventLog_OriginalCause `protobuf_oneof:"original_cause"`
}

func (x *ConnectionProfileEventLog) Reset() {
	*x = ConnectionProfileEventLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionProfileEventLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionProfileEventLog) ProtoMessage() {}

func (x *ConnectionProfileEventLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionProfileEventLog.ProtoReflect.Descriptor instead.
func (*ConnectionProfileEventLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP(), []int{7}
}

func (x *ConnectionProfileEventLog) GetConnectionProfile() *LoggedConnectionProfile {
	if x != nil {
		return x.ConnectionProfile
	}
	return nil
}

func (x *ConnectionProfileEventLog) GetOccurrenceTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.OccurrenceTimestamp
	}
	return nil
}

func (x *ConnectionProfileEventLog) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *ConnectionProfileEventLog) GetTextMessage() string {
	if x != nil {
		return x.TextMessage
	}
	return ""
}

func (m *ConnectionProfileEventLog) GetOriginalCause() isConnectionProfileEventLog_OriginalCause {
	if m != nil {
		return m.OriginalCause
	}
	return nil
}

func (x *ConnectionProfileEventLog) GetOriginalCode() int32 {
	if x, ok := x.GetOriginalCause().(*ConnectionProfileEventLog_OriginalCode); ok {
		return x.OriginalCode
	}
	return 0
}

func (x *ConnectionProfileEventLog) GetOriginalMessage() string {
	if x, ok := x.GetOriginalCause().(*ConnectionProfileEventLog_OriginalMessage); ok {
		return x.OriginalMessage
	}
	return ""
}

type isConnectionProfileEventLog_OriginalCause interface {
	isConnectionProfileEventLog_OriginalCause()
}

type ConnectionProfileEventLog_OriginalCode struct {
	// Original event code
	OriginalCode int32 `protobuf:"varint,200,opt,name=original_code,json=originalCode,proto3,oneof"`
}

type ConnectionProfileEventLog_OriginalMessage struct {
	// Original event message
	OriginalMessage string `protobuf:"bytes,201,opt,name=original_message,json=originalMessage,proto3,oneof"`
}

func (*ConnectionProfileEventLog_OriginalCode) isConnectionProfileEventLog_OriginalCause() {}

func (*ConnectionProfileEventLog_OriginalMessage) isConnectionProfileEventLog_OriginalCause() {}

var File_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto protoreflect.FileDescriptor

var file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x5f, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x01, 0x0a,
	0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x48, 0x0a,
	0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52,
	0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0xe6, 0x0c, 0x0a, 0x12, 0x4c, 0x6f, 0x67, 0x67,
	0x65, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65,
	0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x55,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x55, 0x0a, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x50, 0x68, 0x61, 0x73, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x67, 0x65, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x09, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x75, 0x6d, 0x70, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x77, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf1, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e,
	0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41,
	0x46, 0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x05,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x45, 0x44, 0x10, 0x0a, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x0b, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0c, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0d, 0x12, 0x0e, 0x0a,
	0x0a, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0e, 0x12, 0x0c, 0x0a,
	0x08, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x0f, 0x22, 0x8e, 0x01, 0x0a, 0x05,
	0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x48, 0x41, 0x53, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x55, 0x4d, 0x50, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x43,
	0x44, 0x43, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x45, 0x5f,
	0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x25, 0x0a,
	0x21, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x53, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x54,
	0x4f, 0x50, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x45, 0x50, 0x41, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x54, 0x48, 0x45, 0x5f, 0x44, 0x55, 0x4d, 0x50, 0x10, 0x05, 0x22, 0x3a, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x4e,
	0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x54,
	0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53, 0x10, 0x02, 0x22, 0x66, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x49, 0x50, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x52, 0x45, 0x56, 0x45, 0x52, 0x53, 0x45, 0x5f, 0x53, 0x53, 0x48, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x56, 0x50, 0x43, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x22, 0xe2, 0x01, 0x0a, 0x16, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x5a, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x79, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x64, 0x22, 0x4a, 0x0a, 0x07, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x56, 0x35, 0x5f, 0x35, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x56, 0x35, 0x5f, 0x36, 0x10,
	0x02, 0x12, 0x08, 0x0a, 0x04, 0x56, 0x35, 0x5f, 0x37, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x56,
	0x38, 0x5f, 0x30, 0x10, 0x04, 0x22, 0xf2, 0x01, 0x0a, 0x1b, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x64, 0x22, 0x50, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x56, 0x39, 0x5f, 0x36, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x56, 0x31, 0x31, 0x10, 0x02, 0x12,
	0x07, 0x0a, 0x03, 0x56, 0x31, 0x30, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x56, 0x31, 0x32, 0x10,
	0x04, 0x12, 0x07, 0x0a, 0x03, 0x56, 0x31, 0x33, 0x10, 0x05, 0x22, 0x3d, 0x0a, 0x19, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x64, 0x22, 0xd8, 0x06, 0x0a, 0x17, 0x4c, 0x6f,
	0x67, 0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67,
	0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x50, 0x0a, 0x05, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x18, 0x64, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05, 0x6d,
	0x79, 0x73, 0x71, 0x6c, 0x12, 0x5f, 0x0a, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x12, 0x59, 0x0a, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x71,
	0x6c, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x71, 0x6c,
	0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4e, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x77, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x42, 0x14,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x22, 0xdf, 0x02, 0x0a, 0x14, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x59, 0x0a,
	0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x4d, 0x0a, 0x14, 0x6f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x13, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74,
	0x65, 0x78, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26,
	0x0a, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0xc8, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x10, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x22, 0xf3, 0x02, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x4c, 0x6f, 0x67, 0x12, 0x68, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x11, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4d,
	0x0a, 0x14, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x13, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x12, 0x0a,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0c,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x10,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x2a, 0x5b, 0x0a, 0x0e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x1f,
	0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f,
	0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x51, 0x4c, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x51,
	0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x03, 0x2a, 0x4c, 0x0a, 0x10, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a,
	0x1d, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x07,
	0x0a, 0x03, 0x52, 0x44, 0x53, 0x10, 0x02, 0x42, 0x8c, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x42, 0x19, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescOnce sync.Once
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescData = file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDesc
)

func file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescData)
	})
	return file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDescData
}

var file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_goTypes = []interface{}{
	(DatabaseEngine)(0),                      // 0: google.cloud.clouddms.logging.v1.DatabaseEngine
	(DatabaseProvider)(0),                    // 1: google.cloud.clouddms.logging.v1.DatabaseProvider
	(LoggedMigrationJob_State)(0),            // 2: google.cloud.clouddms.logging.v1.LoggedMigrationJob.State
	(LoggedMigrationJob_Phase)(0),            // 3: google.cloud.clouddms.logging.v1.LoggedMigrationJob.Phase
	(LoggedMigrationJob_Type)(0),             // 4: google.cloud.clouddms.logging.v1.LoggedMigrationJob.Type
	(LoggedMigrationJob_ConnectivityType)(0), // 5: google.cloud.clouddms.logging.v1.LoggedMigrationJob.ConnectivityType
	(MySqlConnectionProfile_Version)(0),      // 6: google.cloud.clouddms.logging.v1.MySqlConnectionProfile.Version
	(PostgreSqlConnectionProfile_Version)(0), // 7: google.cloud.clouddms.logging.v1.PostgreSqlConnectionProfile.Version
	(LoggedConnectionProfile_State)(0),       // 8: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.State
	(*DatabaseType)(nil),                     // 9: google.cloud.clouddms.logging.v1.DatabaseType
	(*LoggedMigrationJob)(nil),               // 10: google.cloud.clouddms.logging.v1.LoggedMigrationJob
	(*MySqlConnectionProfile)(nil),           // 11: google.cloud.clouddms.logging.v1.MySqlConnectionProfile
	(*PostgreSqlConnectionProfile)(nil),      // 12: google.cloud.clouddms.logging.v1.PostgreSqlConnectionProfile
	(*CloudSqlConnectionProfile)(nil),        // 13: google.cloud.clouddms.logging.v1.CloudSqlConnectionProfile
	(*LoggedConnectionProfile)(nil),          // 14: google.cloud.clouddms.logging.v1.LoggedConnectionProfile
	(*MigrationJobEventLog)(nil),             // 15: google.cloud.clouddms.logging.v1.MigrationJobEventLog
	(*ConnectionProfileEventLog)(nil),        // 16: google.cloud.clouddms.logging.v1.ConnectionProfileEventLog
	nil,                                      // 17: google.cloud.clouddms.logging.v1.LoggedMigrationJob.LabelsEntry
	nil,                                      // 18: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.LabelsEntry
	(*durationpb.Duration)(nil),              // 19: google.protobuf.Duration
	(*status.Status)(nil),                    // 20: google.rpc.Status
	(*timestamppb.Timestamp)(nil),            // 21: google.protobuf.Timestamp
}
var file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_depIdxs = []int32{
	1,  // 0: google.cloud.clouddms.logging.v1.DatabaseType.provider:type_name -> google.cloud.clouddms.logging.v1.DatabaseProvider
	0,  // 1: google.cloud.clouddms.logging.v1.DatabaseType.engine:type_name -> google.cloud.clouddms.logging.v1.DatabaseEngine
	17, // 2: google.cloud.clouddms.logging.v1.LoggedMigrationJob.labels:type_name -> google.cloud.clouddms.logging.v1.LoggedMigrationJob.LabelsEntry
	2,  // 3: google.cloud.clouddms.logging.v1.LoggedMigrationJob.state:type_name -> google.cloud.clouddms.logging.v1.LoggedMigrationJob.State
	3,  // 4: google.cloud.clouddms.logging.v1.LoggedMigrationJob.phase:type_name -> google.cloud.clouddms.logging.v1.LoggedMigrationJob.Phase
	4,  // 5: google.cloud.clouddms.logging.v1.LoggedMigrationJob.type:type_name -> google.cloud.clouddms.logging.v1.LoggedMigrationJob.Type
	19, // 6: google.cloud.clouddms.logging.v1.LoggedMigrationJob.duration:type_name -> google.protobuf.Duration
	5,  // 7: google.cloud.clouddms.logging.v1.LoggedMigrationJob.connectivity_type:type_name -> google.cloud.clouddms.logging.v1.LoggedMigrationJob.ConnectivityType
	20, // 8: google.cloud.clouddms.logging.v1.LoggedMigrationJob.error:type_name -> google.rpc.Status
	21, // 9: google.cloud.clouddms.logging.v1.LoggedMigrationJob.end_time:type_name -> google.protobuf.Timestamp
	9,  // 10: google.cloud.clouddms.logging.v1.LoggedMigrationJob.source_database:type_name -> google.cloud.clouddms.logging.v1.DatabaseType
	9,  // 11: google.cloud.clouddms.logging.v1.LoggedMigrationJob.destination_database:type_name -> google.cloud.clouddms.logging.v1.DatabaseType
	6,  // 12: google.cloud.clouddms.logging.v1.MySqlConnectionProfile.version:type_name -> google.cloud.clouddms.logging.v1.MySqlConnectionProfile.Version
	7,  // 13: google.cloud.clouddms.logging.v1.PostgreSqlConnectionProfile.version:type_name -> google.cloud.clouddms.logging.v1.PostgreSqlConnectionProfile.Version
	18, // 14: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.labels:type_name -> google.cloud.clouddms.logging.v1.LoggedConnectionProfile.LabelsEntry
	8,  // 15: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.state:type_name -> google.cloud.clouddms.logging.v1.LoggedConnectionProfile.State
	11, // 16: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.mysql:type_name -> google.cloud.clouddms.logging.v1.MySqlConnectionProfile
	12, // 17: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.postgresql:type_name -> google.cloud.clouddms.logging.v1.PostgreSqlConnectionProfile
	13, // 18: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.cloudsql:type_name -> google.cloud.clouddms.logging.v1.CloudSqlConnectionProfile
	20, // 19: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.error:type_name -> google.rpc.Status
	1,  // 20: google.cloud.clouddms.logging.v1.LoggedConnectionProfile.provider:type_name -> google.cloud.clouddms.logging.v1.DatabaseProvider
	10, // 21: google.cloud.clouddms.logging.v1.MigrationJobEventLog.migration_job:type_name -> google.cloud.clouddms.logging.v1.LoggedMigrationJob
	21, // 22: google.cloud.clouddms.logging.v1.MigrationJobEventLog.occurrence_timestamp:type_name -> google.protobuf.Timestamp
	14, // 23: google.cloud.clouddms.logging.v1.ConnectionProfileEventLog.connection_profile:type_name -> google.cloud.clouddms.logging.v1.LoggedConnectionProfile
	21, // 24: google.cloud.clouddms.logging.v1.ConnectionProfileEventLog.occurrence_timestamp:type_name -> google.protobuf.Timestamp
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_init() }
func file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_init() {
	if File_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggedMigrationJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySqlConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgreSqlConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSqlConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggedConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationJobEventLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionProfileEventLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*LoggedConnectionProfile_Mysql)(nil),
		(*LoggedConnectionProfile_Postgresql)(nil),
		(*LoggedConnectionProfile_Cloudsql)(nil),
	}
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*MigrationJobEventLog_OriginalCode)(nil),
		(*MigrationJobEventLog_OriginalMessage)(nil),
	}
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ConnectionProfileEventLog_OriginalCode)(nil),
		(*ConnectionProfileEventLog_OriginalMessage)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_depIdxs,
		EnumInfos:         file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_enumTypes,
		MessageInfos:      file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto = out.File
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_rawDesc = nil
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_goTypes = nil
	file_google_cloud_clouddms_logging_v1_clouddms_platform_logs_proto_depIdxs = nil
}
