// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/dialogflow/cx/v3/flow.proto

package cx

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// NLU model type.
type NluSettings_ModelType int32

const (
	// Not specified. `MODEL_TYPE_STANDARD` will be used.
	NluSettings_MODEL_TYPE_UNSPECIFIED NluSettings_ModelType = 0
	// Use standard NLU model.
	NluSettings_MODEL_TYPE_STANDARD NluSettings_ModelType = 1
	// Use advanced NLU model.
	NluSettings_MODEL_TYPE_ADVANCED NluSettings_ModelType = 3
)

// Enum value maps for NluSettings_ModelType.
var (
	NluSettings_ModelType_name = map[int32]string{
		0: "MODEL_TYPE_UNSPECIFIED",
		1: "MODEL_TYPE_STANDARD",
		3: "MODEL_TYPE_ADVANCED",
	}
	NluSettings_ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED": 0,
		"MODEL_TYPE_STANDARD":    1,
		"MODEL_TYPE_ADVANCED":    3,
	}
)

func (x NluSettings_ModelType) Enum() *NluSettings_ModelType {
	p := new(NluSettings_ModelType)
	*p = x
	return p
}

func (x NluSettings_ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NluSettings_ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_enumTypes[0].Descriptor()
}

func (NluSettings_ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_flow_proto_enumTypes[0]
}

func (x NluSettings_ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NluSettings_ModelType.Descriptor instead.
func (NluSettings_ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{0, 0}
}

// NLU model training mode.
type NluSettings_ModelTrainingMode int32

const (
	// Not specified. `MODEL_TRAINING_MODE_AUTOMATIC` will be used.
	NluSettings_MODEL_TRAINING_MODE_UNSPECIFIED NluSettings_ModelTrainingMode = 0
	// NLU model training is automatically triggered when a flow gets modified.
	// User can also manually trigger model training in this mode.
	NluSettings_MODEL_TRAINING_MODE_AUTOMATIC NluSettings_ModelTrainingMode = 1
	// User needs to manually trigger NLU model training. Best for large flows
	// whose models take long time to train.
	NluSettings_MODEL_TRAINING_MODE_MANUAL NluSettings_ModelTrainingMode = 2
)

// Enum value maps for NluSettings_ModelTrainingMode.
var (
	NluSettings_ModelTrainingMode_name = map[int32]string{
		0: "MODEL_TRAINING_MODE_UNSPECIFIED",
		1: "MODEL_TRAINING_MODE_AUTOMATIC",
		2: "MODEL_TRAINING_MODE_MANUAL",
	}
	NluSettings_ModelTrainingMode_value = map[string]int32{
		"MODEL_TRAINING_MODE_UNSPECIFIED": 0,
		"MODEL_TRAINING_MODE_AUTOMATIC":   1,
		"MODEL_TRAINING_MODE_MANUAL":      2,
	}
)

func (x NluSettings_ModelTrainingMode) Enum() *NluSettings_ModelTrainingMode {
	p := new(NluSettings_ModelTrainingMode)
	*p = x
	return p
}

func (x NluSettings_ModelTrainingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NluSettings_ModelTrainingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_enumTypes[1].Descriptor()
}

func (NluSettings_ModelTrainingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_flow_proto_enumTypes[1]
}

func (x NluSettings_ModelTrainingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NluSettings_ModelTrainingMode.Descriptor instead.
func (NluSettings_ModelTrainingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{0, 1}
}

// Settings related to NLU.
type NluSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the type of NLU model.
	ModelType NluSettings_ModelType `protobuf:"varint,1,opt,name=model_type,json=modelType,proto3,enum=google.cloud.dialogflow.cx.v3.NluSettings_ModelType" json:"model_type,omitempty"`
	// To filter out false positive results and still get variety in matched
	// natural language inputs for your agent, you can tune the machine learning
	// classification threshold. If the returned score value is less than the
	// threshold value, then a no-match event will be triggered. The score values
	// range from 0.0 (completely uncertain) to 1.0 (completely certain). If set
	// to 0.0, the default of 0.3 is used.
	ClassificationThreshold float32 `protobuf:"fixed32,3,opt,name=classification_threshold,json=classificationThreshold,proto3" json:"classification_threshold,omitempty"`
	// Indicates NLU model training mode.
	ModelTrainingMode NluSettings_ModelTrainingMode `protobuf:"varint,4,opt,name=model_training_mode,json=modelTrainingMode,proto3,enum=google.cloud.dialogflow.cx.v3.NluSettings_ModelTrainingMode" json:"model_training_mode,omitempty"`
}

func (x *NluSettings) Reset() {
	*x = NluSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NluSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NluSettings) ProtoMessage() {}

func (x *NluSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NluSettings.ProtoReflect.Descriptor instead.
func (*NluSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{0}
}

func (x *NluSettings) GetModelType() NluSettings_ModelType {
	if x != nil {
		return x.ModelType
	}
	return NluSettings_MODEL_TYPE_UNSPECIFIED
}

func (x *NluSettings) GetClassificationThreshold() float32 {
	if x != nil {
		return x.ClassificationThreshold
	}
	return 0
}

func (x *NluSettings) GetModelTrainingMode() NluSettings_ModelTrainingMode {
	if x != nil {
		return x.ModelTrainingMode
	}
	return NluSettings_MODEL_TRAINING_MODE_UNSPECIFIED
}

// Flows represents the conversation flows when you build your chatbot agent.
//
// A flow consists of many pages connected by the transition routes.
// Conversations always start with the built-in Start Flow (with an all-0 ID).
// Transition routes can direct the conversation session from the current flow
// (parent flow) to another flow (sub flow). When the sub flow is finished,
// Dialogflow will bring the session back to the parent flow, where the sub flow
// is started.
//
// Usually, when a transition route is followed by a matched intent, the intent
// will be "consumed". This means the intent won't activate more transition
// routes. However, when the followed transition route moves the conversation
// session into a different flow, the matched intent can be carried over and to
// be consumed in the target flow.
type Flow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the flow.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the flow.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the flow. The maximum length is 500 characters. If
	// exceeded, the request is rejected.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// A flow's transition routes serve two purposes:
	//
	// *   They are responsible for matching the user's first utterances in the
	// flow.
	// *   They are inherited by every page's [transition
	// routes][Page.transition_routes] and can support use cases such as the user
	// saying "help" or "can I talk to a human?", which can be handled in a common
	// way regardless of the current page. Transition routes defined in the page
	// have higher priority than those defined in the flow.
	//
	// TransitionRoutes are evalauted in the following order:
	//
	// *   TransitionRoutes with intent specified..
	// *   TransitionRoutes with only condition specified.
	//
	// TransitionRoutes with intent specified are inherited by pages in the flow.
	TransitionRoutes []*TransitionRoute `protobuf:"bytes,4,rep,name=transition_routes,json=transitionRoutes,proto3" json:"transition_routes,omitempty"`
	// A flow's event handlers serve two purposes:
	//
	// *   They are responsible for handling events (e.g. no match,
	// webhook errors) in the flow.
	// *   They are inherited by every page's [event
	// handlers][Page.event_handlers], which can be used to handle common events
	// regardless of the current page. Event handlers defined in the page
	// have higher priority than those defined in the flow.
	//
	// Unlike [transition_routes][google.cloud.dialogflow.cx.v3.Flow.transition_routes], these handlers are
	// evaluated on a first-match basis. The first one that matches the event
	// get executed, with the rest being ignored.
	EventHandlers []*EventHandler `protobuf:"bytes,10,rep,name=event_handlers,json=eventHandlers,proto3" json:"event_handlers,omitempty"`
	// NLU related settings of the flow.
	NluSettings *NluSettings `protobuf:"bytes,11,opt,name=nlu_settings,json=nluSettings,proto3" json:"nlu_settings,omitempty"`
}

func (x *Flow) Reset() {
	*x = Flow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Flow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Flow) ProtoMessage() {}

func (x *Flow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Flow.ProtoReflect.Descriptor instead.
func (*Flow) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{1}
}

func (x *Flow) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Flow) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Flow) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Flow) GetTransitionRoutes() []*TransitionRoute {
	if x != nil {
		return x.TransitionRoutes
	}
	return nil
}

func (x *Flow) GetEventHandlers() []*EventHandler {
	if x != nil {
		return x.EventHandlers
	}
	return nil
}

func (x *Flow) GetNluSettings() *NluSettings {
	if x != nil {
		return x.NluSettings
	}
	return nil
}

// The request message for [Flows.CreateFlow][google.cloud.dialogflow.cx.v3.Flows.CreateFlow].
type CreateFlowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a flow for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The flow to create.
	Flow *Flow `protobuf:"bytes,2,opt,name=flow,proto3" json:"flow,omitempty"`
	// The language of the following fields in `flow`:
	//
	// *  `Flow.event_handlers.trigger_fulfillment.messages`
	// *  `Flow.transition_routes.trigger_fulfillment.messages`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *CreateFlowRequest) Reset() {
	*x = CreateFlowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFlowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFlowRequest) ProtoMessage() {}

func (x *CreateFlowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFlowRequest.ProtoReflect.Descriptor instead.
func (*CreateFlowRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{2}
}

func (x *CreateFlowRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFlowRequest) GetFlow() *Flow {
	if x != nil {
		return x.Flow
	}
	return nil
}

func (x *CreateFlowRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for [Flows.DeleteFlow][google.cloud.dialogflow.cx.v3.Flows.DeleteFlow].
type DeleteFlowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the flow to delete.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for flows with no incoming transitions.
	// For flows with incoming transitions:
	//
	// *  If `force` is set to false, an error will be returned with message
	//    indicating the incoming transitions.
	// *  If `force` is set to true, Dialogflow will remove the flow, as well as
	//    any transitions to the flow (i.e. [Target
	//    flow][EventHandler.target_flow] in event handlers or [Target
	//    flow][TransitionRoute.target_flow] in transition routes that point to
	//    this flow will be cleared).
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteFlowRequest) Reset() {
	*x = DeleteFlowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFlowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFlowRequest) ProtoMessage() {}

func (x *DeleteFlowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFlowRequest.ProtoReflect.Descriptor instead.
func (*DeleteFlowRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteFlowRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteFlowRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request message for [Flows.ListFlows][google.cloud.dialogflow.cx.v3.Flows.ListFlows].
type ListFlowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent containing the flows.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The language to list flows for. The following fields are language
	// dependent:
	//
	// *  `Flow.event_handlers.trigger_fulfillment.messages`
	// *  `Flow.transition_routes.trigger_fulfillment.messages`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListFlowsRequest) Reset() {
	*x = ListFlowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFlowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFlowsRequest) ProtoMessage() {}

func (x *ListFlowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFlowsRequest.ProtoReflect.Descriptor instead.
func (*ListFlowsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{4}
}

func (x *ListFlowsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFlowsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFlowsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFlowsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The response message for [Flows.ListFlows][google.cloud.dialogflow.cx.v3.Flows.ListFlows].
type ListFlowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of flows. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Flows []*Flow `protobuf:"bytes,1,rep,name=flows,proto3" json:"flows,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFlowsResponse) Reset() {
	*x = ListFlowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFlowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFlowsResponse) ProtoMessage() {}

func (x *ListFlowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFlowsResponse.ProtoReflect.Descriptor instead.
func (*ListFlowsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{5}
}

func (x *ListFlowsResponse) GetFlows() []*Flow {
	if x != nil {
		return x.Flows
	}
	return nil
}

func (x *ListFlowsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The response message for [Flows.GetFlow][google.cloud.dialogflow.cx.v3.Flows.GetFlow].
type GetFlowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the flow to get.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The language to retrieve the flow for. The following fields are language
	// dependent:
	//
	// *  `Flow.event_handlers.trigger_fulfillment.messages`
	// *  `Flow.transition_routes.trigger_fulfillment.messages`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetFlowRequest) Reset() {
	*x = GetFlowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFlowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFlowRequest) ProtoMessage() {}

func (x *GetFlowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFlowRequest.ProtoReflect.Descriptor instead.
func (*GetFlowRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{6}
}

func (x *GetFlowRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetFlowRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for [Flows.UpdateFlow][google.cloud.dialogflow.cx.v3.Flows.UpdateFlow].
type UpdateFlowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The flow to update.
	Flow *Flow `protobuf:"bytes,1,opt,name=flow,proto3" json:"flow,omitempty"`
	// Required. The mask to control which fields get updated. If `update_mask` is not
	// specified, an error will be returned.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The language of the following fields in `flow`:
	//
	// *  `Flow.event_handlers.trigger_fulfillment.messages`
	// *  `Flow.transition_routes.trigger_fulfillment.messages`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *UpdateFlowRequest) Reset() {
	*x = UpdateFlowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFlowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFlowRequest) ProtoMessage() {}

func (x *UpdateFlowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFlowRequest.ProtoReflect.Descriptor instead.
func (*UpdateFlowRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateFlowRequest) GetFlow() *Flow {
	if x != nil {
		return x.Flow
	}
	return nil
}

func (x *UpdateFlowRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateFlowRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for [Flows.TrainFlow][google.cloud.dialogflow.cx.v3.Flows.TrainFlow].
type TrainFlowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The flow to train.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *TrainFlowRequest) Reset() {
	*x = TrainFlowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainFlowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainFlowRequest) ProtoMessage() {}

func (x *TrainFlowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainFlowRequest.ProtoReflect.Descriptor instead.
func (*TrainFlowRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{8}
}

func (x *TrainFlowRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for [Flows.ValidateFlow][google.cloud.dialogflow.cx.v3.Flows.ValidateFlow].
type ValidateFlowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The flow to validate.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If not specified, the agent's default language is used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ValidateFlowRequest) Reset() {
	*x = ValidateFlowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateFlowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateFlowRequest) ProtoMessage() {}

func (x *ValidateFlowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateFlowRequest.ProtoReflect.Descriptor instead.
func (*ValidateFlowRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{9}
}

func (x *ValidateFlowRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ValidateFlowRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for [Flows.GetFlowValidationResult][google.cloud.dialogflow.cx.v3.Flows.GetFlowValidationResult].
type GetFlowValidationResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The flow name.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/validationResult`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If not specified, the agent's default language is used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetFlowValidationResultRequest) Reset() {
	*x = GetFlowValidationResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFlowValidationResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFlowValidationResultRequest) ProtoMessage() {}

func (x *GetFlowValidationResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFlowValidationResultRequest.ProtoReflect.Descriptor instead.
func (*GetFlowValidationResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{10}
}

func (x *GetFlowValidationResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetFlowValidationResultRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The response message for [Flows.GetFlowValidationResult][google.cloud.dialogflow.cx.v3.Flows.GetFlowValidationResult].
type FlowValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the flow validation result.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/validationResult`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Contains all validation messages.
	ValidationMessages []*ValidationMessage `protobuf:"bytes,2,rep,name=validation_messages,json=validationMessages,proto3" json:"validation_messages,omitempty"`
	// Last time the flow was validated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *FlowValidationResult) Reset() {
	*x = FlowValidationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlowValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowValidationResult) ProtoMessage() {}

func (x *FlowValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowValidationResult.ProtoReflect.Descriptor instead.
func (*FlowValidationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP(), []int{11}
}

func (x *FlowValidationResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FlowValidationResult) GetValidationMessages() []*ValidationMessage {
	if x != nil {
		return x.ValidationMessages
	}
	return nil
}

func (x *FlowValidationResult) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3_flow_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_flow_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x03, 0x0a, 0x0b, 0x4e, 0x6c, 0x75, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x6c, 0x75, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x18, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x17, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x12, 0x6c, 0x0a, 0x13, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x4e, 0x6c, 0x75, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x11,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64,
	0x65, 0x22, 0x59, 0x0a, 0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52,
	0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x41, 0x44, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x03, 0x22, 0x7b, 0x0a, 0x11,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x49, 0x4e,
	0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f,
	0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x41, 0x55,
	0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x4d, 0x4f, 0x44,
	0x45, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x22, 0xce, 0x03, 0x0a, 0x04, 0x46, 0x6c,
	0x6f, 0x77, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x5b, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x10, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x52, 0x0a,
	0x0e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x52, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x6e, 0x6c, 0x75, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x6c, 0x75, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x0b, 0x6e, 0x6c, 0x75, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x66, 0x6c,
	0x6f, 0x77, 0x73, 0x2f, 0x7b, 0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x22, 0xb6, 0x01, 0x0a, 0x11, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x3c, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46,
	0x6c, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x23,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x22, 0x65, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6c, 0x6f,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x22, 0x76, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x05, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x05, 0x66, 0x6c, 0x6f, 0x77, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x46,
	0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x11,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x46, 0x6c, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x4e, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x46,
	0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x76, 0x0a, 0x13, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x6c, 0x6f, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x91,
	0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x22, 0xd7, 0x02, 0x0a, 0x14, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x61, 0x0a, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x12,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a,
	0x8a, 0x01, 0xea, 0x41, 0x86, 0x01, 0x0a, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x66,
	0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x7b, 0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x32, 0xee, 0x0c, 0x0a,
	0x05, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x22, 0x4e, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x22, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x3a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0xda, 0x41,
	0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x99, 0x01, 0x0a,
	0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb3, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6c, 0x6f, 0x77,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x6c, 0x6f, 0x77, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa0,
	0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6c,
	0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x22, 0x41,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xbd, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x32,
	0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0xda, 0x41,
	0x10, 0x66, 0x6c, 0x6f, 0x77, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0xd9, 0x01, 0x0a, 0x09, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x46, 0x6c, 0x6f, 0x77, 0x12,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x72, 0x61, 0x69, 0x6e, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2f, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0xbf, 0x01,
	0x0a, 0x0c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22,
	0x3b, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12,
	0xe1, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x46,
	0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x99, 0x01,
	0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x42, 0x09, 0x46, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x3b, 0x63,
	0x78, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_flow_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_flow_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_flow_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_dialogflow_cx_v3_flow_proto_goTypes = []interface{}{
	(NluSettings_ModelType)(0),             // 0: google.cloud.dialogflow.cx.v3.NluSettings.ModelType
	(NluSettings_ModelTrainingMode)(0),     // 1: google.cloud.dialogflow.cx.v3.NluSettings.ModelTrainingMode
	(*NluSettings)(nil),                    // 2: google.cloud.dialogflow.cx.v3.NluSettings
	(*Flow)(nil),                           // 3: google.cloud.dialogflow.cx.v3.Flow
	(*CreateFlowRequest)(nil),              // 4: google.cloud.dialogflow.cx.v3.CreateFlowRequest
	(*DeleteFlowRequest)(nil),              // 5: google.cloud.dialogflow.cx.v3.DeleteFlowRequest
	(*ListFlowsRequest)(nil),               // 6: google.cloud.dialogflow.cx.v3.ListFlowsRequest
	(*ListFlowsResponse)(nil),              // 7: google.cloud.dialogflow.cx.v3.ListFlowsResponse
	(*GetFlowRequest)(nil),                 // 8: google.cloud.dialogflow.cx.v3.GetFlowRequest
	(*UpdateFlowRequest)(nil),              // 9: google.cloud.dialogflow.cx.v3.UpdateFlowRequest
	(*TrainFlowRequest)(nil),               // 10: google.cloud.dialogflow.cx.v3.TrainFlowRequest
	(*ValidateFlowRequest)(nil),            // 11: google.cloud.dialogflow.cx.v3.ValidateFlowRequest
	(*GetFlowValidationResultRequest)(nil), // 12: google.cloud.dialogflow.cx.v3.GetFlowValidationResultRequest
	(*FlowValidationResult)(nil),           // 13: google.cloud.dialogflow.cx.v3.FlowValidationResult
	(*TransitionRoute)(nil),                // 14: google.cloud.dialogflow.cx.v3.TransitionRoute
	(*EventHandler)(nil),                   // 15: google.cloud.dialogflow.cx.v3.EventHandler
	(*fieldmaskpb.FieldMask)(nil),          // 16: google.protobuf.FieldMask
	(*ValidationMessage)(nil),              // 17: google.cloud.dialogflow.cx.v3.ValidationMessage
	(*timestamppb.Timestamp)(nil),          // 18: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                  // 19: google.protobuf.Empty
	(*longrunning.Operation)(nil),          // 20: google.longrunning.Operation
}
var file_google_cloud_dialogflow_cx_v3_flow_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.cx.v3.NluSettings.model_type:type_name -> google.cloud.dialogflow.cx.v3.NluSettings.ModelType
	1,  // 1: google.cloud.dialogflow.cx.v3.NluSettings.model_training_mode:type_name -> google.cloud.dialogflow.cx.v3.NluSettings.ModelTrainingMode
	14, // 2: google.cloud.dialogflow.cx.v3.Flow.transition_routes:type_name -> google.cloud.dialogflow.cx.v3.TransitionRoute
	15, // 3: google.cloud.dialogflow.cx.v3.Flow.event_handlers:type_name -> google.cloud.dialogflow.cx.v3.EventHandler
	2,  // 4: google.cloud.dialogflow.cx.v3.Flow.nlu_settings:type_name -> google.cloud.dialogflow.cx.v3.NluSettings
	3,  // 5: google.cloud.dialogflow.cx.v3.CreateFlowRequest.flow:type_name -> google.cloud.dialogflow.cx.v3.Flow
	3,  // 6: google.cloud.dialogflow.cx.v3.ListFlowsResponse.flows:type_name -> google.cloud.dialogflow.cx.v3.Flow
	3,  // 7: google.cloud.dialogflow.cx.v3.UpdateFlowRequest.flow:type_name -> google.cloud.dialogflow.cx.v3.Flow
	16, // 8: google.cloud.dialogflow.cx.v3.UpdateFlowRequest.update_mask:type_name -> google.protobuf.FieldMask
	17, // 9: google.cloud.dialogflow.cx.v3.FlowValidationResult.validation_messages:type_name -> google.cloud.dialogflow.cx.v3.ValidationMessage
	18, // 10: google.cloud.dialogflow.cx.v3.FlowValidationResult.update_time:type_name -> google.protobuf.Timestamp
	4,  // 11: google.cloud.dialogflow.cx.v3.Flows.CreateFlow:input_type -> google.cloud.dialogflow.cx.v3.CreateFlowRequest
	5,  // 12: google.cloud.dialogflow.cx.v3.Flows.DeleteFlow:input_type -> google.cloud.dialogflow.cx.v3.DeleteFlowRequest
	6,  // 13: google.cloud.dialogflow.cx.v3.Flows.ListFlows:input_type -> google.cloud.dialogflow.cx.v3.ListFlowsRequest
	8,  // 14: google.cloud.dialogflow.cx.v3.Flows.GetFlow:input_type -> google.cloud.dialogflow.cx.v3.GetFlowRequest
	9,  // 15: google.cloud.dialogflow.cx.v3.Flows.UpdateFlow:input_type -> google.cloud.dialogflow.cx.v3.UpdateFlowRequest
	10, // 16: google.cloud.dialogflow.cx.v3.Flows.TrainFlow:input_type -> google.cloud.dialogflow.cx.v3.TrainFlowRequest
	11, // 17: google.cloud.dialogflow.cx.v3.Flows.ValidateFlow:input_type -> google.cloud.dialogflow.cx.v3.ValidateFlowRequest
	12, // 18: google.cloud.dialogflow.cx.v3.Flows.GetFlowValidationResult:input_type -> google.cloud.dialogflow.cx.v3.GetFlowValidationResultRequest
	3,  // 19: google.cloud.dialogflow.cx.v3.Flows.CreateFlow:output_type -> google.cloud.dialogflow.cx.v3.Flow
	19, // 20: google.cloud.dialogflow.cx.v3.Flows.DeleteFlow:output_type -> google.protobuf.Empty
	7,  // 21: google.cloud.dialogflow.cx.v3.Flows.ListFlows:output_type -> google.cloud.dialogflow.cx.v3.ListFlowsResponse
	3,  // 22: google.cloud.dialogflow.cx.v3.Flows.GetFlow:output_type -> google.cloud.dialogflow.cx.v3.Flow
	3,  // 23: google.cloud.dialogflow.cx.v3.Flows.UpdateFlow:output_type -> google.cloud.dialogflow.cx.v3.Flow
	20, // 24: google.cloud.dialogflow.cx.v3.Flows.TrainFlow:output_type -> google.longrunning.Operation
	13, // 25: google.cloud.dialogflow.cx.v3.Flows.ValidateFlow:output_type -> google.cloud.dialogflow.cx.v3.FlowValidationResult
	13, // 26: google.cloud.dialogflow.cx.v3.Flows.GetFlowValidationResult:output_type -> google.cloud.dialogflow.cx.v3.FlowValidationResult
	19, // [19:27] is the sub-list for method output_type
	11, // [11:19] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_flow_proto_init() }
func file_google_cloud_dialogflow_cx_v3_flow_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_flow_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_page_proto_init()
	file_google_cloud_dialogflow_cx_v3_validation_message_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NluSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Flow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFlowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFlowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFlowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFlowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFlowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFlowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainFlowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateFlowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFlowValidationResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlowValidationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_flow_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_flow_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_flow_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_flow_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_flow_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_flow_proto = out.File
	file_google_cloud_dialogflow_cx_v3_flow_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_flow_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_flow_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FlowsClient is the client API for Flows service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FlowsClient interface {
	// Creates a flow in the specified agent.
	CreateFlow(ctx context.Context, in *CreateFlowRequest, opts ...grpc.CallOption) (*Flow, error)
	// Deletes a specified flow.
	DeleteFlow(ctx context.Context, in *DeleteFlowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the list of all flows in the specified agent.
	ListFlows(ctx context.Context, in *ListFlowsRequest, opts ...grpc.CallOption) (*ListFlowsResponse, error)
	// Retrieves the specified flow.
	GetFlow(ctx context.Context, in *GetFlowRequest, opts ...grpc.CallOption) (*Flow, error)
	// Updates the specified flow.
	UpdateFlow(ctx context.Context, in *UpdateFlowRequest, opts ...grpc.CallOption) (*Flow, error)
	// Trains the specified flow. Note that only the flow in 'draft' environment
	// is trained.
	TrainFlow(ctx context.Context, in *TrainFlowRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Validates the specified flow and creates or updates validation results.
	// Please call this API after the training is completed to get the complete
	// validation results.
	ValidateFlow(ctx context.Context, in *ValidateFlowRequest, opts ...grpc.CallOption) (*FlowValidationResult, error)
	// Gets the latest flow validation result. Flow validation is performed
	// when ValidateFlow is called.
	GetFlowValidationResult(ctx context.Context, in *GetFlowValidationResultRequest, opts ...grpc.CallOption) (*FlowValidationResult, error)
}

type flowsClient struct {
	cc grpc.ClientConnInterface
}

func NewFlowsClient(cc grpc.ClientConnInterface) FlowsClient {
	return &flowsClient{cc}
}

func (c *flowsClient) CreateFlow(ctx context.Context, in *CreateFlowRequest, opts ...grpc.CallOption) (*Flow, error) {
	out := new(Flow)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/CreateFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) DeleteFlow(ctx context.Context, in *DeleteFlowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/DeleteFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) ListFlows(ctx context.Context, in *ListFlowsRequest, opts ...grpc.CallOption) (*ListFlowsResponse, error) {
	out := new(ListFlowsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/ListFlows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) GetFlow(ctx context.Context, in *GetFlowRequest, opts ...grpc.CallOption) (*Flow, error) {
	out := new(Flow)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/GetFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) UpdateFlow(ctx context.Context, in *UpdateFlowRequest, opts ...grpc.CallOption) (*Flow, error) {
	out := new(Flow)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/UpdateFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) TrainFlow(ctx context.Context, in *TrainFlowRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/TrainFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) ValidateFlow(ctx context.Context, in *ValidateFlowRequest, opts ...grpc.CallOption) (*FlowValidationResult, error) {
	out := new(FlowValidationResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/ValidateFlow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) GetFlowValidationResult(ctx context.Context, in *GetFlowValidationResultRequest, opts ...grpc.CallOption) (*FlowValidationResult, error) {
	out := new(FlowValidationResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Flows/GetFlowValidationResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FlowsServer is the server API for Flows service.
type FlowsServer interface {
	// Creates a flow in the specified agent.
	CreateFlow(context.Context, *CreateFlowRequest) (*Flow, error)
	// Deletes a specified flow.
	DeleteFlow(context.Context, *DeleteFlowRequest) (*emptypb.Empty, error)
	// Returns the list of all flows in the specified agent.
	ListFlows(context.Context, *ListFlowsRequest) (*ListFlowsResponse, error)
	// Retrieves the specified flow.
	GetFlow(context.Context, *GetFlowRequest) (*Flow, error)
	// Updates the specified flow.
	UpdateFlow(context.Context, *UpdateFlowRequest) (*Flow, error)
	// Trains the specified flow. Note that only the flow in 'draft' environment
	// is trained.
	TrainFlow(context.Context, *TrainFlowRequest) (*longrunning.Operation, error)
	// Validates the specified flow and creates or updates validation results.
	// Please call this API after the training is completed to get the complete
	// validation results.
	ValidateFlow(context.Context, *ValidateFlowRequest) (*FlowValidationResult, error)
	// Gets the latest flow validation result. Flow validation is performed
	// when ValidateFlow is called.
	GetFlowValidationResult(context.Context, *GetFlowValidationResultRequest) (*FlowValidationResult, error)
}

// UnimplementedFlowsServer can be embedded to have forward compatible implementations.
type UnimplementedFlowsServer struct {
}

func (*UnimplementedFlowsServer) CreateFlow(context.Context, *CreateFlowRequest) (*Flow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFlow not implemented")
}
func (*UnimplementedFlowsServer) DeleteFlow(context.Context, *DeleteFlowRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFlow not implemented")
}
func (*UnimplementedFlowsServer) ListFlows(context.Context, *ListFlowsRequest) (*ListFlowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFlows not implemented")
}
func (*UnimplementedFlowsServer) GetFlow(context.Context, *GetFlowRequest) (*Flow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFlow not implemented")
}
func (*UnimplementedFlowsServer) UpdateFlow(context.Context, *UpdateFlowRequest) (*Flow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFlow not implemented")
}
func (*UnimplementedFlowsServer) TrainFlow(context.Context, *TrainFlowRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrainFlow not implemented")
}
func (*UnimplementedFlowsServer) ValidateFlow(context.Context, *ValidateFlowRequest) (*FlowValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateFlow not implemented")
}
func (*UnimplementedFlowsServer) GetFlowValidationResult(context.Context, *GetFlowValidationResultRequest) (*FlowValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFlowValidationResult not implemented")
}

func RegisterFlowsServer(s *grpc.Server, srv FlowsServer) {
	s.RegisterService(&_Flows_serviceDesc, srv)
}

func _Flows_CreateFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).CreateFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/CreateFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).CreateFlow(ctx, req.(*CreateFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_DeleteFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).DeleteFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/DeleteFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).DeleteFlow(ctx, req.(*DeleteFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_ListFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFlowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).ListFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/ListFlows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).ListFlows(ctx, req.(*ListFlowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_GetFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).GetFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/GetFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).GetFlow(ctx, req.(*GetFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_UpdateFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).UpdateFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/UpdateFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).UpdateFlow(ctx, req.(*UpdateFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_TrainFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).TrainFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/TrainFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).TrainFlow(ctx, req.(*TrainFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_ValidateFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).ValidateFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/ValidateFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).ValidateFlow(ctx, req.(*ValidateFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_GetFlowValidationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFlowValidationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).GetFlowValidationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Flows/GetFlowValidationResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).GetFlowValidationResult(ctx, req.(*GetFlowValidationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Flows_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Flows",
	HandlerType: (*FlowsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFlow",
			Handler:    _Flows_CreateFlow_Handler,
		},
		{
			MethodName: "DeleteFlow",
			Handler:    _Flows_DeleteFlow_Handler,
		},
		{
			MethodName: "ListFlows",
			Handler:    _Flows_ListFlows_Handler,
		},
		{
			MethodName: "GetFlow",
			Handler:    _Flows_GetFlow_Handler,
		},
		{
			MethodName: "UpdateFlow",
			Handler:    _Flows_UpdateFlow_Handler,
		},
		{
			MethodName: "TrainFlow",
			Handler:    _Flows_TrainFlow_Handler,
		},
		{
			MethodName: "ValidateFlow",
			Handler:    _Flows_ValidateFlow_Handler,
		},
		{
			MethodName: "GetFlowValidationResult",
			Handler:    _Flows_GetFlowValidationResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/flow.proto",
}
