// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/secretmanager/logging/v1/secret_event.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes the type of event that is being logged. All logs have exactly one
// EventType.
type SecretEvent_EventType int32

const (
	// An unrecognized event type. Should never be used.
	SecretEvent_EVENT_TYPE_UNSPECIFIED SecretEvent_EventType = 0
	// The secret is scheduled to expire in 30 days.
	SecretEvent_EXPIRES_IN_30_DAYS SecretEvent_EventType = 1
	// The secret is scheduled to expire in 7 days.
	SecretEvent_EXPIRES_IN_7_DAYS SecretEvent_EventType = 2
	// The secret is scheduled to expire in 1 day.
	SecretEvent_EXPIRES_IN_1_DAY SecretEvent_EventType = 3
	// The secret is scheduled to expire in 6 hours.
	SecretEvent_EXPIRES_IN_6_HOURS SecretEvent_EventType = 4
	// The secret is scheduled to expire in 1 hour.
	SecretEvent_EXPIRES_IN_1_HOUR SecretEvent_EventType = 5
	// The secret's expire-time has passed and it has expired.
	SecretEvent_EXPIRED SecretEvent_EventType = 6
	// A Pub/Sub topic configured on the secret could not be found.
	SecretEvent_TOPIC_NOT_FOUND SecretEvent_EventType = 7
	// A Pub/Sub topic configured on the secret does not have the needed
	// permissions. The Secret Manager P4SA must be granted
	// 'pubsub.topic.publish' permission (or 'roles/pubsub.publisher') on the
	// topic.
	SecretEvent_TOPIC_PERMISSION_DENIED SecretEvent_EventType = 8
)

// Enum value maps for SecretEvent_EventType.
var (
	SecretEvent_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "EXPIRES_IN_30_DAYS",
		2: "EXPIRES_IN_7_DAYS",
		3: "EXPIRES_IN_1_DAY",
		4: "EXPIRES_IN_6_HOURS",
		5: "EXPIRES_IN_1_HOUR",
		6: "EXPIRED",
		7: "TOPIC_NOT_FOUND",
		8: "TOPIC_PERMISSION_DENIED",
	}
	SecretEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":  0,
		"EXPIRES_IN_30_DAYS":      1,
		"EXPIRES_IN_7_DAYS":       2,
		"EXPIRES_IN_1_DAY":        3,
		"EXPIRES_IN_6_HOURS":      4,
		"EXPIRES_IN_1_HOUR":       5,
		"EXPIRED":                 6,
		"TOPIC_NOT_FOUND":         7,
		"TOPIC_PERMISSION_DENIED": 8,
	}
)

func (x SecretEvent_EventType) Enum() *SecretEvent_EventType {
	p := new(SecretEvent_EventType)
	*p = x
	return p
}

func (x SecretEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecretEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_secretmanager_logging_v1_secret_event_proto_enumTypes[0].Descriptor()
}

func (SecretEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_secretmanager_logging_v1_secret_event_proto_enumTypes[0]
}

func (x SecretEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecretEvent_EventType.Descriptor instead.
func (SecretEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescGZIP(), []int{0, 0}
}

// Logged event relating to a specific secret
type SecretEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the secret in the format `projects/*/secrets/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of event that is being logged for the secret
	Type SecretEvent_EventType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.secretmanager.logging.v1.SecretEvent_EventType" json:"type,omitempty"`
	// Human readable message describing the event
	LogMessage string `protobuf:"bytes,3,opt,name=log_message,json=logMessage,proto3" json:"log_message,omitempty"`
}

func (x *SecretEvent) Reset() {
	*x = SecretEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_logging_v1_secret_event_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretEvent) ProtoMessage() {}

func (x *SecretEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_logging_v1_secret_event_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretEvent.ProtoReflect.Descriptor instead.
func (*SecretEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescGZIP(), []int{0}
}

func (x *SecretEvent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecretEvent) GetType() SecretEvent_EventType {
	if x != nil {
		return x.Type
	}
	return SecretEvent_EVENT_TYPE_UNSPECIFIED
}

func (x *SecretEvent) GetLogMessage() string {
	if x != nil {
		return x.LogMessage
	}
	return ""
}

var File_google_cloud_secretmanager_logging_v1_secret_event_proto protoreflect.FileDescriptor

var file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x22, 0xf1, 0x02, 0x0a, 0x0b, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x67, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f,
	0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x09, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x49, 0x4e,
	0x5f, 0x33, 0x30, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x58,
	0x50, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x37, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10,
	0x02, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x5f,
	0x31, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x58, 0x50, 0x49, 0x52,
	0x45, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x36, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x04, 0x12,
	0x15, 0x0a, 0x11, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x31, 0x5f,
	0x48, 0x4f, 0x55, 0x52, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45,
	0x44, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x07, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x4f, 0x50, 0x49,
	0x43, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e,
	0x49, 0x45, 0x44, 0x10, 0x08, 0x42, 0x89, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x42, 0x10, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescOnce sync.Once
	file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescData = file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDesc
)

func file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescGZIP() []byte {
	file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescOnce.Do(func() {
		file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescData)
	})
	return file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDescData
}

var file_google_cloud_secretmanager_logging_v1_secret_event_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_secretmanager_logging_v1_secret_event_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_secretmanager_logging_v1_secret_event_proto_goTypes = []interface{}{
	(SecretEvent_EventType)(0), // 0: google.cloud.secretmanager.logging.v1.SecretEvent.EventType
	(*SecretEvent)(nil),        // 1: google.cloud.secretmanager.logging.v1.SecretEvent
}
var file_google_cloud_secretmanager_logging_v1_secret_event_proto_depIdxs = []int32{
	0, // 0: google.cloud.secretmanager.logging.v1.SecretEvent.type:type_name -> google.cloud.secretmanager.logging.v1.SecretEvent.EventType
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_secretmanager_logging_v1_secret_event_proto_init() }
func file_google_cloud_secretmanager_logging_v1_secret_event_proto_init() {
	if File_google_cloud_secretmanager_logging_v1_secret_event_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_secretmanager_logging_v1_secret_event_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_secretmanager_logging_v1_secret_event_proto_goTypes,
		DependencyIndexes: file_google_cloud_secretmanager_logging_v1_secret_event_proto_depIdxs,
		EnumInfos:         file_google_cloud_secretmanager_logging_v1_secret_event_proto_enumTypes,
		MessageInfos:      file_google_cloud_secretmanager_logging_v1_secret_event_proto_msgTypes,
	}.Build()
	File_google_cloud_secretmanager_logging_v1_secret_event_proto = out.File
	file_google_cloud_secretmanager_logging_v1_secret_event_proto_rawDesc = nil
	file_google_cloud_secretmanager_logging_v1_secret_event_proto_goTypes = nil
	file_google_cloud_secretmanager_logging_v1_secret_event_proto_depIdxs = nil
}
