---
title: Multiple Architectures
linkTitle: Multiple Architectures
weight: 80
---

### Supporting Multiple Architectures

Authors may decide to distribute their bundles for various architectures: x86_64, aarch64, ppc64le, s390x, etc, to accomodate the diversity of Kubernetes clusters and reach a larger number of potential users. Each architecture requires however compatible binaries.

#### Manifest lists

The most straightforward way of building operators and operands supporting multiple architectures is to leverage manifest lists, specified by [Image Manifest V2, Schema 2][manifest_list] or [OCI Image Index][image_index]. A manifest list points to specific image manifests for one or more platforms.

For convenience tools like [buildah][buildah] allow to cross-build and manifest multi-arch containers on one host. For instance with buildah:

```shell
for a in amd64 arm64 ppc64le s390x; do \
  buildah bud --manifest registry/username/repo:v1 --arch $a; \
done
```

This creates the manifest list, builds each image and adds them to the manifest list.

The result can then be pushed to the desired registry.

```shell
buildah push registry/username/repo:v1
```

Docker with [buildx][buildx] provides similar capabilities.

```shell
docker buildx build --push --platform linux/amd64,linux/arm64,linux/ppc64le,linux/s390x --tag registry/username/repo:v1 .
```

See [docker documentation][buildx_multiarch] for additional options.
 
**Caveats**: the Dockerfile generated by the SDK for the operator explicitely references GOARCH=amd64 for go build. This can be amended to GOARCH=$TARGETARCH. Docker will automatically set the environment variable to the value specified by --platform. With buildah --build-arg will need to be used for the purpose.

**Caveats**: When mirroring registries for disconnected installations (environments without internet connection) all the images referenced by a manifest list need to be copied, including images for architectures that may not be used in the environment.

#### Operator Lifecycle Manager

For operators distributed through the [Operator Lifecycle Manager (OLM)][olm]:

* [Bundle images][bundle] are not architecture-specific. They contain only plaintext kubernetes manifests and operator metadata.
* All image references in the ClusterServiceVersion should be manifest lists containing the pointers to the image manifests for the supported architectures.
* Labels for OS and architectures can be set in the CSV. Please refer to the [Operator Lifecycle Management Documentation][olm_multiarch] for details.

[manifest_list]: https://docs.docker.com/registry/spec/manifest-v2-2/#manifest-list
[image_index]: https://github.com/opencontainers/image-spec/blob/main/image-index.md
[buildah]: https://github.com/containers/buildah/blob/main/docs/buildah-bud.md#building-an-multi-architecture-image-using-a---manifest-option-requires-emulation-software
[buildx]: https://docs.docker.com/buildx/working-with-buildx/#build-multi-platform-images
[buildx_multiarch]: https://docs.docker.com/buildx/working-with-buildx/#build-multi-platform-images
[olm]: https://olm.operatorframework.io/docs/
[bundle]: https://olm.operatorframework.io/docs/glossary/#bundle
[olm_multiarch]: https://olm.operatorframework.io/docs/advanced-tasks/ship-operator-supporting-multiarch/#multiple-architectures
