package machinelearningservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/machinelearningservices/mgmt/2018-11-19/machinelearningservices"

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "Resizing"
	// Steady ...
	Steady AllocationState = "Steady"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady}
}

// ComputeType enumerates the values for compute type.
type ComputeType string

const (
	// ComputeTypeAKS ...
	ComputeTypeAKS ComputeType = "AKS"
	// ComputeTypeAmlCompute ...
	ComputeTypeAmlCompute ComputeType = "AmlCompute"
	// ComputeTypeDatabricks ...
	ComputeTypeDatabricks ComputeType = "Databricks"
	// ComputeTypeDataFactory ...
	ComputeTypeDataFactory ComputeType = "DataFactory"
	// ComputeTypeDataLakeAnalytics ...
	ComputeTypeDataLakeAnalytics ComputeType = "DataLakeAnalytics"
	// ComputeTypeHDInsight ...
	ComputeTypeHDInsight ComputeType = "HDInsight"
	// ComputeTypeVirtualMachine ...
	ComputeTypeVirtualMachine ComputeType = "VirtualMachine"
)

// PossibleComputeTypeValues returns an array of possible values for the ComputeType const type.
func PossibleComputeTypeValues() []ComputeType {
	return []ComputeType{ComputeTypeAKS, ComputeTypeAmlCompute, ComputeTypeDatabricks, ComputeTypeDataFactory, ComputeTypeDataLakeAnalytics, ComputeTypeHDInsight, ComputeTypeVirtualMachine}
}

// ComputeTypeBasicCompute enumerates the values for compute type basic compute.
type ComputeTypeBasicCompute string

const (
	// ComputeTypeAKS1 ...
	ComputeTypeAKS1 ComputeTypeBasicCompute = "AKS"
	// ComputeTypeAmlCompute1 ...
	ComputeTypeAmlCompute1 ComputeTypeBasicCompute = "AmlCompute"
	// ComputeTypeCompute ...
	ComputeTypeCompute ComputeTypeBasicCompute = "Compute"
	// ComputeTypeDatabricks1 ...
	ComputeTypeDatabricks1 ComputeTypeBasicCompute = "Databricks"
	// ComputeTypeDataFactory1 ...
	ComputeTypeDataFactory1 ComputeTypeBasicCompute = "DataFactory"
	// ComputeTypeDataLakeAnalytics1 ...
	ComputeTypeDataLakeAnalytics1 ComputeTypeBasicCompute = "DataLakeAnalytics"
	// ComputeTypeHDInsight1 ...
	ComputeTypeHDInsight1 ComputeTypeBasicCompute = "HDInsight"
	// ComputeTypeVirtualMachine1 ...
	ComputeTypeVirtualMachine1 ComputeTypeBasicCompute = "VirtualMachine"
)

// PossibleComputeTypeBasicComputeValues returns an array of possible values for the ComputeTypeBasicCompute const type.
func PossibleComputeTypeBasicComputeValues() []ComputeTypeBasicCompute {
	return []ComputeTypeBasicCompute{ComputeTypeAKS1, ComputeTypeAmlCompute1, ComputeTypeCompute, ComputeTypeDatabricks1, ComputeTypeDataFactory1, ComputeTypeDataLakeAnalytics1, ComputeTypeHDInsight1, ComputeTypeVirtualMachine1}
}

// ComputeTypeBasicComputeNodesInformation enumerates the values for compute type basic compute nodes
// information.
type ComputeTypeBasicComputeNodesInformation string

const (
	// ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute ...
	ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute ComputeTypeBasicComputeNodesInformation = "AmlCompute"
	// ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation ...
	ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation ComputeTypeBasicComputeNodesInformation = "ComputeNodesInformation"
)

// PossibleComputeTypeBasicComputeNodesInformationValues returns an array of possible values for the ComputeTypeBasicComputeNodesInformation const type.
func PossibleComputeTypeBasicComputeNodesInformationValues() []ComputeTypeBasicComputeNodesInformation {
	return []ComputeTypeBasicComputeNodesInformation{ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute, ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation}
}

// ComputeTypeBasicComputeSecrets enumerates the values for compute type basic compute secrets.
type ComputeTypeBasicComputeSecrets string

const (
	// ComputeTypeBasicComputeSecretsComputeTypeAKS ...
	ComputeTypeBasicComputeSecretsComputeTypeAKS ComputeTypeBasicComputeSecrets = "AKS"
	// ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets ...
	ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets ComputeTypeBasicComputeSecrets = "ComputeSecrets"
	// ComputeTypeBasicComputeSecretsComputeTypeDatabricks ...
	ComputeTypeBasicComputeSecretsComputeTypeDatabricks ComputeTypeBasicComputeSecrets = "Databricks"
	// ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine ...
	ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine ComputeTypeBasicComputeSecrets = "VirtualMachine"
)

// PossibleComputeTypeBasicComputeSecretsValues returns an array of possible values for the ComputeTypeBasicComputeSecrets const type.
func PossibleComputeTypeBasicComputeSecretsValues() []ComputeTypeBasicComputeSecrets {
	return []ComputeTypeBasicComputeSecrets{ComputeTypeBasicComputeSecretsComputeTypeAKS, ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets, ComputeTypeBasicComputeSecretsComputeTypeDatabricks, ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Unknown ...
	Unknown ProvisioningState = "Unknown"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Canceled, Creating, Deleting, Failed, Succeeded, Unknown, Updating}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{SystemAssigned}
}

// Status enumerates the values for status.
type Status string

const (
	// Disabled ...
	Disabled Status = "Disabled"
	// Enabled ...
	Enabled Status = "Enabled"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Disabled, Enabled}
}

// UnderlyingResourceAction enumerates the values for underlying resource action.
type UnderlyingResourceAction string

const (
	// Delete ...
	Delete UnderlyingResourceAction = "Delete"
	// Detach ...
	Detach UnderlyingResourceAction = "Detach"
)

// PossibleUnderlyingResourceActionValues returns an array of possible values for the UnderlyingResourceAction const type.
func PossibleUnderlyingResourceActionValues() []UnderlyingResourceAction {
	return []UnderlyingResourceAction{Delete, Detach}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Count ...
	Count UsageUnit = "Count"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{Count}
}

// VMPriority enumerates the values for vm priority.
type VMPriority string

const (
	// Dedicated ...
	Dedicated VMPriority = "Dedicated"
	// LowPriority ...
	LowPriority VMPriority = "LowPriority"
)

// PossibleVMPriorityValues returns an array of possible values for the VMPriority const type.
func PossibleVMPriorityValues() []VMPriority {
	return []VMPriority{Dedicated, LowPriority}
}

// AKS a Machine Learning compute based on AKS.
type AKS struct {
	// Properties - AKS properties
	Properties *AKSProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AKS.
func (a AKS) MarshalJSON() ([]byte, error) {
	a.ComputeType = ComputeTypeAKS1
	objectMap := make(map[string]interface{})
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	if a.ComputeLocation != nil {
		objectMap["computeLocation"] = a.ComputeLocation
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.ResourceID != nil {
		objectMap["resourceId"] = a.ResourceID
	}
	if a.ComputeType != "" {
		objectMap["computeType"] = a.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AKS.
func (a AKS) AsAKS() (*AKS, bool) {
	return &a, true
}

// AsAmlCompute is the BasicCompute implementation for AKS.
func (a AKS) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for AKS.
func (a AKS) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AKS.
func (a AKS) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AKS.
func (a AKS) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for AKS.
func (a AKS) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for AKS.
func (a AKS) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AKS.
func (a AKS) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AKS.
func (a AKS) AsBasicCompute() (BasicCompute, bool) {
	return &a, true
}

// AksComputeSecrets secrets related to a Machine Learning compute based on AKS.
type AksComputeSecrets struct {
	// UserKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
	// AdminKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`
	// ImagePullSecretName - Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AksComputeSecrets.
func (acs AksComputeSecrets) MarshalJSON() ([]byte, error) {
	acs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeAKS
	objectMap := make(map[string]interface{})
	if acs.UserKubeConfig != nil {
		objectMap["userKubeConfig"] = acs.UserKubeConfig
	}
	if acs.AdminKubeConfig != nil {
		objectMap["adminKubeConfig"] = acs.AdminKubeConfig
	}
	if acs.ImagePullSecretName != nil {
		objectMap["imagePullSecretName"] = acs.ImagePullSecretName
	}
	if acs.ComputeType != "" {
		objectMap["computeType"] = acs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return &acs, true
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &acs, true
}

// AksNetworkingConfiguration advance configuration for AKS networking
type AksNetworkingConfiguration struct {
	// SubnetID - Virtual network subnet resource ID the compute nodes belong to
	SubnetID *string `json:"subnetId,omitempty"`
	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`
	// DockerBridgeCidr - A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`
}

// AKSProperties AKS properties
type AKSProperties struct {
	// ClusterFqdn - Cluster full qualified domain name
	ClusterFqdn *string `json:"clusterFqdn,omitempty"`
	// SystemServices - READ-ONLY; System services
	SystemServices *[]SystemService `json:"systemServices,omitempty"`
	// AgentCount - Number of agents
	AgentCount *int32 `json:"agentCount,omitempty"`
	// AgentVMSize - Agent virtual machine size
	AgentVMSize *string `json:"agentVMSize,omitempty"`
	// SslConfiguration - SSL configuration
	SslConfiguration *SslConfiguration `json:"sslConfiguration,omitempty"`
	// AksNetworkingConfiguration - AKS networking configuration for vnet
	AksNetworkingConfiguration *AksNetworkingConfiguration `json:"aksNetworkingConfiguration,omitempty"`
}

// AmlCompute an Azure Machine Learning compute.
type AmlCompute struct {
	// Properties - AML Compute properties
	Properties *AmlComputeProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlCompute.
func (ac AmlCompute) MarshalJSON() ([]byte, error) {
	ac.ComputeType = ComputeTypeAmlCompute1
	objectMap := make(map[string]interface{})
	if ac.Properties != nil {
		objectMap["properties"] = ac.Properties
	}
	if ac.ComputeLocation != nil {
		objectMap["computeLocation"] = ac.ComputeLocation
	}
	if ac.Description != nil {
		objectMap["description"] = ac.Description
	}
	if ac.ResourceID != nil {
		objectMap["resourceId"] = ac.ResourceID
	}
	if ac.ComputeType != "" {
		objectMap["computeType"] = ac.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsAmlCompute() (*AmlCompute, bool) {
	return &ac, true
}

// AsVirtualMachine is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsBasicCompute() (BasicCompute, bool) {
	return &ac, true
}

// AmlComputeNodeInformation compute node information related to a AmlCompute.
type AmlComputeNodeInformation struct {
	// NodeID - READ-ONLY; ID of the compute node.
	NodeID *string `json:"nodeId,omitempty"`
	// IPAddress - READ-ONLY; Public IP address of the compute node.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - READ-ONLY; SSH port number of the node.
	Port *float64 `json:"port,omitempty"`
}

// AmlComputeNodesInformation compute node information related to a AmlCompute.
type AmlComputeNodesInformation struct {
	autorest.Response `json:"-"`
	// Nodes - READ-ONLY; The collection of returned AmlCompute nodes details.
	Nodes *[]AmlComputeNodeInformation `json:"nodes,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation', 'ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute'
	ComputeType ComputeTypeBasicComputeNodesInformation `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) MarshalJSON() ([]byte, error) {
	acni.ComputeType = ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute
	objectMap := make(map[string]interface{})
	if acni.ComputeType != "" {
		objectMap["computeType"] = acni.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAmlComputeNodesInformation is the BasicComputeNodesInformation implementation for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) AsAmlComputeNodesInformation() (*AmlComputeNodesInformation, bool) {
	return &acni, true
}

// AsComputeNodesInformation is the BasicComputeNodesInformation implementation for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) AsComputeNodesInformation() (*ComputeNodesInformation, bool) {
	return nil, false
}

// AsBasicComputeNodesInformation is the BasicComputeNodesInformation implementation for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) AsBasicComputeNodesInformation() (BasicComputeNodesInformation, bool) {
	return &acni, true
}

// AmlComputeNodesInformationIterator provides access to a complete listing of AmlComputeNodeInformation
// values.
type AmlComputeNodesInformationIterator struct {
	i    int
	page AmlComputeNodesInformationPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AmlComputeNodesInformationIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AmlComputeNodesInformationIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AmlComputeNodesInformationIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AmlComputeNodesInformationIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AmlComputeNodesInformationIterator) Response() AmlComputeNodesInformation {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AmlComputeNodesInformationIterator) Value() AmlComputeNodeInformation {
	if !iter.page.NotDone() {
		return AmlComputeNodeInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AmlComputeNodesInformationIterator type.
func NewAmlComputeNodesInformationIterator(page AmlComputeNodesInformationPage) AmlComputeNodesInformationIterator {
	return AmlComputeNodesInformationIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (acni AmlComputeNodesInformation) IsEmpty() bool {
	return acni.Nodes == nil || len(*acni.Nodes) == 0
}

// amlComputeNodesInformationPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (acni AmlComputeNodesInformation) amlComputeNodesInformationPreparer(ctx context.Context) (*http.Request, error) {
	if acni.NextLink == nil || len(to.String(acni.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(acni.NextLink)))
}

// AmlComputeNodesInformationPage contains a page of AmlComputeNodeInformation values.
type AmlComputeNodesInformationPage struct {
	fn   func(context.Context, AmlComputeNodesInformation) (AmlComputeNodesInformation, error)
	acni AmlComputeNodesInformation
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AmlComputeNodesInformationPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AmlComputeNodesInformationPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.acni)
	if err != nil {
		return err
	}
	page.acni = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AmlComputeNodesInformationPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AmlComputeNodesInformationPage) NotDone() bool {
	return !page.acni.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AmlComputeNodesInformationPage) Response() AmlComputeNodesInformation {
	return page.acni
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AmlComputeNodesInformationPage) Values() []AmlComputeNodeInformation {
	if page.acni.IsEmpty() {
		return nil
	}
	return *page.acni.Nodes
}

// Creates a new instance of the AmlComputeNodesInformationPage type.
func NewAmlComputeNodesInformationPage(getNextPage func(context.Context, AmlComputeNodesInformation) (AmlComputeNodesInformation, error)) AmlComputeNodesInformationPage {
	return AmlComputeNodesInformationPage{fn: getNextPage}
}

// AmlComputeProperties AML Compute properties
type AmlComputeProperties struct {
	// VMSize - Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - Virtual Machine priority. Possible values include: 'Dedicated', 'LowPriority'
	VMPriority VMPriority `json:"vmPriority,omitempty"`
	// ScaleSettings - Scale settings for AML Compute
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
	// UserAccountCredentials - Credentials for an administrator user account that will be created on each compute node.
	UserAccountCredentials *UserAccountCredentials `json:"userAccountCredentials,omitempty"`
	// Subnet - Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// AllocationState - READ-ONLY; Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute. Possible values include: 'Steady', 'Resizing'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - READ-ONLY; The time at which the compute entered its current allocation state.
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// Errors - READ-ONLY; Collection of errors encountered by various compute nodes during node setup.
	Errors *[]Error `json:"errors,omitempty"`
	// CurrentNodeCount - READ-ONLY; The number of compute nodes currently assigned to the compute.
	CurrentNodeCount *int32 `json:"currentNodeCount,omitempty"`
	// TargetNodeCount - READ-ONLY; The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
	TargetNodeCount *int32 `json:"targetNodeCount,omitempty"`
	// NodeStateCounts - READ-ONLY; Counts of various node states on the compute.
	NodeStateCounts *NodeStateCounts `json:"nodeStateCounts,omitempty"`
}

// ClusterUpdateParameters amlCompute update parameters.
type ClusterUpdateParameters struct {
	// ClusterUpdateProperties - The properties of the amlCompute.
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterUpdateProperties != nil {
		objectMap["properties"] = cup.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cup.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a amlCompute that need to be updated.
type ClusterUpdateProperties struct {
	// ScaleSettings - Desired scale settings for the amlCompute.
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// BasicCompute machine Learning compute object.
type BasicCompute interface {
	AsAKS() (*AKS, bool)
	AsAmlCompute() (*AmlCompute, bool)
	AsVirtualMachine() (*VirtualMachine, bool)
	AsHDInsight() (*HDInsight, bool)
	AsDataFactory() (*DataFactory, bool)
	AsDatabricks() (*Databricks, bool)
	AsDataLakeAnalytics() (*DataLakeAnalytics, bool)
	AsCompute() (*Compute, bool)
}

// Compute machine Learning compute object.
type Compute struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

func unmarshalBasicCompute(body []byte) (BasicCompute, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeAKS1):
		var a AKS
		err := json.Unmarshal(body, &a)
		return a, err
	case string(ComputeTypeAmlCompute1):
		var ac AmlCompute
		err := json.Unmarshal(body, &ac)
		return ac, err
	case string(ComputeTypeVirtualMachine1):
		var VM VirtualMachine
		err := json.Unmarshal(body, &VM)
		return VM, err
	case string(ComputeTypeHDInsight1):
		var hi HDInsight
		err := json.Unmarshal(body, &hi)
		return hi, err
	case string(ComputeTypeDataFactory1):
		var df DataFactory
		err := json.Unmarshal(body, &df)
		return df, err
	case string(ComputeTypeDatabricks1):
		var d Databricks
		err := json.Unmarshal(body, &d)
		return d, err
	case string(ComputeTypeDataLakeAnalytics1):
		var dla DataLakeAnalytics
		err := json.Unmarshal(body, &dla)
		return dla, err
	default:
		var c Compute
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicComputeArray(body []byte) ([]BasicCompute, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicCompute, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicCompute(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Compute.
func (c Compute) MarshalJSON() ([]byte, error) {
	c.ComputeType = ComputeTypeCompute
	objectMap := make(map[string]interface{})
	if c.ComputeLocation != nil {
		objectMap["computeLocation"] = c.ComputeLocation
	}
	if c.Description != nil {
		objectMap["description"] = c.Description
	}
	if c.ResourceID != nil {
		objectMap["resourceId"] = c.ResourceID
	}
	if c.ComputeType != "" {
		objectMap["computeType"] = c.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Compute.
func (c Compute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for Compute.
func (c Compute) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Compute.
func (c Compute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Compute.
func (c Compute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Compute.
func (c Compute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for Compute.
func (c Compute) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for Compute.
func (c Compute) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Compute.
func (c Compute) AsCompute() (*Compute, bool) {
	return &c, true
}

// AsBasicCompute is the BasicCompute implementation for Compute.
func (c Compute) AsBasicCompute() (BasicCompute, bool) {
	return &c, true
}

// BasicComputeNodesInformation compute nodes information related to a Machine Learning compute. Might differ for every
// type of compute.
type BasicComputeNodesInformation interface {
	AsAmlComputeNodesInformation() (*AmlComputeNodesInformation, bool)
	AsComputeNodesInformation() (*ComputeNodesInformation, bool)
}

// ComputeNodesInformation compute nodes information related to a Machine Learning compute. Might differ for
// every type of compute.
type ComputeNodesInformation struct {
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation', 'ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute'
	ComputeType ComputeTypeBasicComputeNodesInformation `json:"computeType,omitempty"`
}

func unmarshalBasicComputeNodesInformation(body []byte) (BasicComputeNodesInformation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute):
		var acni AmlComputeNodesInformation
		err := json.Unmarshal(body, &acni)
		return acni, err
	default:
		var cni ComputeNodesInformation
		err := json.Unmarshal(body, &cni)
		return cni, err
	}
}
func unmarshalBasicComputeNodesInformationArray(body []byte) ([]BasicComputeNodesInformation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cniArray := make([]BasicComputeNodesInformation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cni, err := unmarshalBasicComputeNodesInformation(*rawMessage)
		if err != nil {
			return nil, err
		}
		cniArray[index] = cni
	}
	return cniArray, nil
}

// MarshalJSON is the custom marshaler for ComputeNodesInformation.
func (cni ComputeNodesInformation) MarshalJSON() ([]byte, error) {
	cni.ComputeType = ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation
	objectMap := make(map[string]interface{})
	if cni.ComputeType != "" {
		objectMap["computeType"] = cni.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAmlComputeNodesInformation is the BasicComputeNodesInformation implementation for ComputeNodesInformation.
func (cni ComputeNodesInformation) AsAmlComputeNodesInformation() (*AmlComputeNodesInformation, bool) {
	return nil, false
}

// AsComputeNodesInformation is the BasicComputeNodesInformation implementation for ComputeNodesInformation.
func (cni ComputeNodesInformation) AsComputeNodesInformation() (*ComputeNodesInformation, bool) {
	return &cni, true
}

// AsBasicComputeNodesInformation is the BasicComputeNodesInformation implementation for ComputeNodesInformation.
func (cni ComputeNodesInformation) AsBasicComputeNodesInformation() (BasicComputeNodesInformation, bool) {
	return &cni, true
}

// ComputeResource machine Learning compute object wrapped into ARM resource envelope.
type ComputeResource struct {
	autorest.Response `json:"-"`
	// Properties - Compute properties
	Properties BasicCompute `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ComputeResource.
func (cr ComputeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = cr.Properties
	if cr.Identity != nil {
		objectMap["identity"] = cr.Identity
	}
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComputeResource struct.
func (cr *ComputeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicCompute(*v)
				if err != nil {
					return err
				}
				cr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cr.Tags = tags
			}
		}
	}

	return nil
}

// BasicComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type BasicComputeSecrets interface {
	AsAksComputeSecrets() (*AksComputeSecrets, bool)
	AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool)
	AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool)
	AsComputeSecrets() (*ComputeSecrets, bool)
}

// ComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type ComputeSecrets struct {
	autorest.Response `json:"-"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

func unmarshalBasicComputeSecrets(body []byte) (BasicComputeSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeSecretsComputeTypeAKS):
		var acs AksComputeSecrets
		err := json.Unmarshal(body, &acs)
		return acs, err
	case string(ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine):
		var vms VirtualMachineSecrets
		err := json.Unmarshal(body, &vms)
		return vms, err
	case string(ComputeTypeBasicComputeSecretsComputeTypeDatabricks):
		var dcs DatabricksComputeSecrets
		err := json.Unmarshal(body, &dcs)
		return dcs, err
	default:
		var cs ComputeSecrets
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicComputeSecretsArray(body []byte) ([]BasicComputeSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicComputeSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicComputeSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ComputeSecrets.
func (cs ComputeSecrets) MarshalJSON() ([]byte, error) {
	cs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets
	objectMap := make(map[string]interface{})
	if cs.ComputeType != "" {
		objectMap["computeType"] = cs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return &cs, true
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &cs, true
}

// ComputeSecretsModel ...
type ComputeSecretsModel struct {
	autorest.Response `json:"-"`
	Value             BasicComputeSecrets `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ComputeSecretsModel struct.
func (csm *ComputeSecretsModel) UnmarshalJSON(body []byte) error {
	cs, err := unmarshalBasicComputeSecrets(body)
	if err != nil {
		return err
	}
	csm.Value = cs

	return nil
}

// Databricks a DataFactory compute.
type Databricks struct {
	Properties *DatabricksProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for Databricks.
func (d Databricks) MarshalJSON() ([]byte, error) {
	d.ComputeType = ComputeTypeDatabricks1
	objectMap := make(map[string]interface{})
	if d.Properties != nil {
		objectMap["properties"] = d.Properties
	}
	if d.ComputeLocation != nil {
		objectMap["computeLocation"] = d.ComputeLocation
	}
	if d.Description != nil {
		objectMap["description"] = d.Description
	}
	if d.ResourceID != nil {
		objectMap["resourceId"] = d.ResourceID
	}
	if d.ComputeType != "" {
		objectMap["computeType"] = d.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Databricks.
func (d Databricks) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Databricks.
func (d Databricks) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Databricks.
func (d Databricks) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Databricks.
func (d Databricks) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for Databricks.
func (d Databricks) AsDatabricks() (*Databricks, bool) {
	return &d, true
}

// AsDataLakeAnalytics is the BasicCompute implementation for Databricks.
func (d Databricks) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsBasicCompute() (BasicCompute, bool) {
	return &d, true
}

// DatabricksComputeSecrets secrets related to a Machine Learning compute based on Databricks.
type DatabricksComputeSecrets struct {
	// DatabricksAccessToken - access token for databricks account.
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) MarshalJSON() ([]byte, error) {
	dcs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeDatabricks
	objectMap := make(map[string]interface{})
	if dcs.DatabricksAccessToken != nil {
		objectMap["databricksAccessToken"] = dcs.DatabricksAccessToken
	}
	if dcs.ComputeType != "" {
		objectMap["computeType"] = dcs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return &dcs, true
}

// AsComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &dcs, true
}

// DatabricksProperties ...
type DatabricksProperties struct {
	// DatabricksAccessToken - Databricks access token
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
}

// DataFactory a DataFactory compute.
type DataFactory struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataFactory.
func (df DataFactory) MarshalJSON() ([]byte, error) {
	df.ComputeType = ComputeTypeDataFactory1
	objectMap := make(map[string]interface{})
	if df.ComputeLocation != nil {
		objectMap["computeLocation"] = df.ComputeLocation
	}
	if df.Description != nil {
		objectMap["description"] = df.Description
	}
	if df.ResourceID != nil {
		objectMap["resourceId"] = df.ResourceID
	}
	if df.ComputeType != "" {
		objectMap["computeType"] = df.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataFactory() (*DataFactory, bool) {
	return &df, true
}

// AsDatabricks is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsBasicCompute() (BasicCompute, bool) {
	return &df, true
}

// DataLakeAnalytics a DataLakeAnalytics compute.
type DataLakeAnalytics struct {
	Properties *DataLakeAnalyticsProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataLakeAnalytics.
func (dla DataLakeAnalytics) MarshalJSON() ([]byte, error) {
	dla.ComputeType = ComputeTypeDataLakeAnalytics1
	objectMap := make(map[string]interface{})
	if dla.Properties != nil {
		objectMap["properties"] = dla.Properties
	}
	if dla.ComputeLocation != nil {
		objectMap["computeLocation"] = dla.ComputeLocation
	}
	if dla.Description != nil {
		objectMap["description"] = dla.Description
	}
	if dla.ResourceID != nil {
		objectMap["resourceId"] = dla.ResourceID
	}
	if dla.ComputeType != "" {
		objectMap["computeType"] = dla.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return &dla, true
}

// AsCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsBasicCompute() (BasicCompute, bool) {
	return &dla, true
}

// DataLakeAnalyticsProperties ...
type DataLakeAnalyticsProperties struct {
	// DataLakeStoreAccountName - DataLake Store Account Name
	DataLakeStoreAccountName *string `json:"dataLakeStoreAccountName,omitempty"`
}

// Error wrapper for error response to follow ARM guidelines.
type Error struct {
	// Error - READ-ONLY; The error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorDetail error detail information.
type ErrorDetail struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response information.
type ErrorResponse struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; An array of error detail objects.
	Details *[]ErrorDetail `json:"details,omitempty"`
}

// HDInsight a HDInsight compute.
type HDInsight struct {
	Properties *HDInsightProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for HDInsight.
func (hi HDInsight) MarshalJSON() ([]byte, error) {
	hi.ComputeType = ComputeTypeHDInsight1
	objectMap := make(map[string]interface{})
	if hi.Properties != nil {
		objectMap["properties"] = hi.Properties
	}
	if hi.ComputeLocation != nil {
		objectMap["computeLocation"] = hi.ComputeLocation
	}
	if hi.Description != nil {
		objectMap["description"] = hi.Description
	}
	if hi.ResourceID != nil {
		objectMap["resourceId"] = hi.ResourceID
	}
	if hi.ComputeType != "" {
		objectMap["computeType"] = hi.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsHDInsight() (*HDInsight, bool) {
	return &hi, true
}

// AsDataFactory is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsBasicCompute() (BasicCompute, bool) {
	return &hi, true
}

// HDInsightProperties ...
type HDInsightProperties struct {
	// SSHPort - Port open for ssh connections on the master node of the cluster.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the master node of the cluster.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for master node of the cluster
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// ListUsagesResult the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of AML resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next page of AML resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListUsagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListUsagesResultIterator type.
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return ListUsagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if lur.NextLink == nil || len(to.String(lur.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(context.Context, ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lur)
	if err != nil {
		return err
	}
	page.lur = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListUsagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// Creates a new instance of the ListUsagesResultPage type.
func NewListUsagesResultPage(getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return ListUsagesResultPage{fn: getNextPage}
}

// ListWorkspaceKeysResult ...
type ListWorkspaceKeysResult struct {
	autorest.Response `json:"-"`
	// UserStorageKey - READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty"`
	// UserStorageResourceID - READ-ONLY
	UserStorageResourceID *string `json:"userStorageResourceId,omitempty"`
	// AppInsightsInstrumentationKey - READ-ONLY
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty"`
	// ContainerRegistryCredentials - READ-ONLY
	ContainerRegistryCredentials *RegistryListCredentialsResult `json:"containerRegistryCredentials,omitempty"`
}

// MachineLearningComputeCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MachineLearningComputeCreateOrUpdateFuture) Result(client MachineLearningComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateOrUpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeCreateOrUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MachineLearningComputeDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MachineLearningComputeDeleteFuture) Result(client MachineLearningComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MachineLearningComputeUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MachineLearningComputeUpdateFuture) Result(client MachineLearningComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.UpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NodeStateCounts counts of various compute node states on the amlCompute.
type NodeStateCounts struct {
	// IdleNodeCount - READ-ONLY; Number of compute nodes in idle state.
	IdleNodeCount *int32 `json:"idleNodeCount,omitempty"`
	// RunningNodeCount - READ-ONLY; Number of compute nodes which are running jobs.
	RunningNodeCount *int32 `json:"runningNodeCount,omitempty"`
	// PreparingNodeCount - READ-ONLY; Number of compute nodes which are being prepared.
	PreparingNodeCount *int32 `json:"preparingNodeCount,omitempty"`
	// UnusableNodeCount - READ-ONLY; Number of compute nodes which are in unusable state.
	UnusableNodeCount *int32 `json:"unusableNodeCount,omitempty"`
	// LeavingNodeCount - READ-ONLY; Number of compute nodes which are leaving the amlCompute.
	LeavingNodeCount *int32 `json:"leavingNodeCount,omitempty"`
	// PreemptedNodeCount - READ-ONLY; Number of compute nodes which are in preempted state.
	PreemptedNodeCount *int32 `json:"preemptedNodeCount,omitempty"`
}

// Operation azure Machine Learning workspace REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display name of operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display name of operation
type OperationDisplay struct {
	// Provider - The resource provider name: Microsoft.MachineLearningExperimentation
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult an array of operations supported by the resource provider.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of AML workspace operations supported by the AML workspace resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// PaginatedComputeResourcesList paginated list of Machine Learning compute objects wrapped in ARM resource
// envelope.
type PaginatedComputeResourcesList struct {
	autorest.Response `json:"-"`
	// Value - An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value *[]ComputeResource `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaginatedComputeResourcesListIterator provides access to a complete listing of ComputeResource values.
type PaginatedComputeResourcesListIterator struct {
	i    int
	page PaginatedComputeResourcesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaginatedComputeResourcesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaginatedComputeResourcesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaginatedComputeResourcesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaginatedComputeResourcesListIterator) Response() PaginatedComputeResourcesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaginatedComputeResourcesListIterator) Value() ComputeResource {
	if !iter.page.NotDone() {
		return ComputeResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaginatedComputeResourcesListIterator type.
func NewPaginatedComputeResourcesListIterator(page PaginatedComputeResourcesListPage) PaginatedComputeResourcesListIterator {
	return PaginatedComputeResourcesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl PaginatedComputeResourcesList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// paginatedComputeResourcesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl PaginatedComputeResourcesList) paginatedComputeResourcesListPreparer(ctx context.Context) (*http.Request, error) {
	if pcrl.NextLink == nil || len(to.String(pcrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// PaginatedComputeResourcesListPage contains a page of ComputeResource values.
type PaginatedComputeResourcesListPage struct {
	fn   func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)
	pcrl PaginatedComputeResourcesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaginatedComputeResourcesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pcrl)
	if err != nil {
		return err
	}
	page.pcrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaginatedComputeResourcesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaginatedComputeResourcesListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaginatedComputeResourcesListPage) Response() PaginatedComputeResourcesList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaginatedComputeResourcesListPage) Values() []ComputeResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the PaginatedComputeResourcesListPage type.
func NewPaginatedComputeResourcesListPage(getNextPage func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)) PaginatedComputeResourcesListPage {
	return PaginatedComputeResourcesListPage{fn: getNextPage}
}

// Password ...
type Password struct {
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY
	Value *string `json:"value,omitempty"`
}

// RegistryListCredentialsResult ...
type RegistryListCredentialsResult struct {
	// Location - READ-ONLY
	Location *string `json:"location,omitempty"`
	// Username - READ-ONLY
	Username  *string     `json:"username,omitempty"`
	Passwords *[]Password `json:"passwords,omitempty"`
}

// Resource azure Resource Manager resource envelope.
type Resource struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Identity != nil {
		objectMap["identity"] = r.Identity
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceID represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
}

// ScaleSettings scale settings for AML Compute
type ScaleSettings struct {
	// MaxNodeCount - Max number of nodes to use
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
	// MinNodeCount - Min number of nodes to use
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	// NodeIdleTimeBeforeScaleDown - Node Idle Time before scaling down amlCompute
	NodeIdleTimeBeforeScaleDown *string `json:"nodeIdleTimeBeforeScaleDown,omitempty"`
}

// ServicePrincipalCredentials service principal credentials.
type ServicePrincipalCredentials struct {
	// ClientID - Client Id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// SslConfiguration the ssl configuration for scoring
type SslConfiguration struct {
	// Status - Enable or disable ssl for scoring. Possible values include: 'Disabled', 'Enabled'
	Status Status `json:"status,omitempty"`
	// Cert - Cert data
	Cert *string `json:"cert,omitempty"`
	// Key - Key data
	Key *string `json:"key,omitempty"`
	// Cname - CNAME of the cert
	Cname *string `json:"cname,omitempty"`
}

// SystemService a system service running on a compute.
type SystemService struct {
	// SystemServiceType - READ-ONLY; The type of this system service.
	SystemServiceType *string `json:"systemServiceType,omitempty"`
	// PublicIPAddress - READ-ONLY; Public IP address
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// Version - READ-ONLY; The version for this type.
	Version *string `json:"version,omitempty"`
}

// Usage describes AML Resource Usage.
type Usage struct {
	// Unit - READ-ONLY; An enum describing the unit of usage measurement. Possible values include: 'Count'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; The current usage of the resource.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Name - READ-ONLY; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UserAccountCredentials settings for user account that gets created on each on the nodes of a compute.
type UserAccountCredentials struct {
	// AdminUserName - Name of the administrator user account which can be used to SSH to nodes.
	AdminUserName *string `json:"adminUserName,omitempty"`
	// AdminUserSSHPublicKey - SSH public key of the administrator user account.
	AdminUserSSHPublicKey *string `json:"adminUserSshPublicKey,omitempty"`
	// AdminUserPassword - Password of the administrator user account.
	AdminUserPassword *string `json:"adminUserPassword,omitempty"`
}

// VirtualMachine a Machine Learning compute based on Azure Virtual Machines.
type VirtualMachine struct {
	Properties *VirtualMachineProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeAmlCompute1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1', 'ComputeTypeDatabricks1', 'ComputeTypeDataLakeAnalytics1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	VM.ComputeType = ComputeTypeVirtualMachine1
	objectMap := make(map[string]interface{})
	if VM.Properties != nil {
		objectMap["properties"] = VM.Properties
	}
	if VM.ComputeLocation != nil {
		objectMap["computeLocation"] = VM.ComputeLocation
	}
	if VM.Description != nil {
		objectMap["description"] = VM.Description
	}
	if VM.ResourceID != nil {
		objectMap["resourceId"] = VM.ResourceID
	}
	if VM.ComputeType != "" {
		objectMap["computeType"] = VM.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsVirtualMachine() (*VirtualMachine, bool) {
	return &VM, true
}

// AsHDInsight is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsBasicCompute() (BasicCompute, bool) {
	return &VM, true
}

// VirtualMachineProperties ...
type VirtualMachineProperties struct {
	// VirtualMachineSize - Virtual Machine size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`
	// SSHPort - Port open for ssh connections.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the virtual machine.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for virtual machine
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// VirtualMachineSecrets secrets related to a Machine Learning compute based on AKS.
type VirtualMachineSecrets struct {
	// AdministratorAccount - Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) MarshalJSON() ([]byte, error) {
	vms.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine
	objectMap := make(map[string]interface{})
	if vms.AdministratorAccount != nil {
		objectMap["administratorAccount"] = vms.AdministratorAccount
	}
	if vms.ComputeType != "" {
		objectMap["computeType"] = vms.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return &vms, true
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &vms, true
}

// VirtualMachineSize describes the properties of a VM size.
type VirtualMachineSize struct {
	// Name - READ-ONLY; The name of the virtual machine size.
	Name *string `json:"name,omitempty"`
	// Family - READ-ONLY; The family name of the virtual machine size.
	Family *string `json:"family,omitempty"`
	// VCPUs - READ-ONLY; The number of vCPUs supported by the virtual machine size.
	VCPUs *int32 `json:"vCPUs,omitempty"`
	// OsVhdSizeMB - READ-ONLY; The OS VHD disk size, in MB, allowed by the virtual machine size.
	OsVhdSizeMB *int32 `json:"osVhdSizeMB,omitempty"`
	// MaxResourceVolumeMB - READ-ONLY; The resource volume size, in MB, allowed by the virtual machine size.
	MaxResourceVolumeMB *int32 `json:"maxResourceVolumeMB,omitempty"`
	// MemoryGB - READ-ONLY; The amount of memory, in GB, supported by the virtual machine size.
	MemoryGB *float64 `json:"memoryGB,omitempty"`
	// LowPriorityCapable - READ-ONLY; Specifies if the virtual machine size supports low priority VMs.
	LowPriorityCapable *bool `json:"lowPriorityCapable,omitempty"`
	// PremiumIO - READ-ONLY; Specifies if the virtual machine size supports premium IO.
	PremiumIO *bool `json:"premiumIO,omitempty"`
}

// VirtualMachineSizeListResult the List Virtual Machine size operation response.
type VirtualMachineSizeListResult struct {
	autorest.Response `json:"-"`
	// AmlCompute - The list of virtual machine sizes supported by AmlCompute.
	AmlCompute *[]VirtualMachineSize `json:"amlCompute,omitempty"`
}

// VirtualMachineSSHCredentials admin credentials for virtual machine
type VirtualMachineSSHCredentials struct {
	// Username - Username of admin account
	Username *string `json:"username,omitempty"`
	// Password - Password of admin account
	Password *string `json:"password,omitempty"`
	// PublicKeyData - Public key data
	PublicKeyData *string `json:"publicKeyData,omitempty"`
	// PrivateKeyData - Private key data
	PrivateKeyData *string `json:"privateKeyData,omitempty"`
}

// Workspace an object that represents a machine learning workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - The properties of the machine learning workspace.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WorkspaceListResult the result of a request to list machine learning workspaces.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListResultIterator type.
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return WorkspaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if wlr.NextLink == nil || len(to.String(wlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wlr)
	if err != nil {
		return err
	}
	page.wlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkspaceListResultPage type.
func NewWorkspaceListResultPage(getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return WorkspaceListResultPage{fn: getNextPage}
}

// WorkspaceProperties the properties of a machine learning workspace.
type WorkspaceProperties struct {
	// WorkspaceID - READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace. This name in mutable
	FriendlyName *string `json:"friendlyName,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the machine learning workspace in ISO8601 format.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// KeyVault - ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
	KeyVault *string `json:"keyVault,omitempty"`
	// ApplicationInsights - ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created
	ApplicationInsights *string `json:"applicationInsights,omitempty"`
	// ContainerRegistry - ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created
	ContainerRegistry *string `json:"containerRegistry,omitempty"`
	// StorageAccount - ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
	StorageAccount *string `json:"storageAccount,omitempty"`
	// DiscoveryURL - Url for the discovery service to identify regional endpoints for machine learning experimentation services
	DiscoveryURL *string `json:"discoveryUrl,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// WorkspacePropertiesUpdateParameters the parameters for updating the properties of a machine learning
// workspace.
type WorkspacePropertiesUpdateParameters struct {
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesCreateOrUpdateFuture) Result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspaceUpdateParameters the parameters for updating a machine learning workspace.
type WorkspaceUpdateParameters struct {
	// Tags - The resource tags for the machine learning workspace.
	Tags map[string]*string `json:"tags"`
	// WorkspacePropertiesUpdateParameters - The properties that the machine learning workspace will be updated with.
	*WorkspacePropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceUpdateParameters.
func (wup WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WorkspacePropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WorkspacePropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceUpdateParameters struct.
func (wup *WorkspaceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var workspacePropertiesUpdateParameters WorkspacePropertiesUpdateParameters
				err = json.Unmarshal(*v, &workspacePropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WorkspacePropertiesUpdateParameters = &workspacePropertiesUpdateParameters
			}
		}
	}

	return nil
}
